## DO NOT EDIT!  Generated automatically from test/libieeep1788_tests_overlap.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/09c37dc3a884ee2e1989e0e2b2f34324087a5199
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788,
##                  original license: Apache License 2.0)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_overlap_test

%!test
%! assert (all (eq (overlap (infsup, infsup), "bothEmpty")));
%!test
%! assert (all (eq (overlap (infsup, infsup (1.0, 2.0)), "firstEmpty")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup), "secondEmpty")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 2.0), infsup (3.0, inf)), "before")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 2.0), infsup (3.0, 4.0)), "before")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (3.0, 4.0)), "before")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (3.0, 4.0)), "before")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (3.0, 3.0)), "before")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (3.0, 3.0)), "before")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (3.0, inf)), "before")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 2.0), infsup (2.0, 3.0)), "meets")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (2.0, 3.0)), "meets")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (2.0, inf)), "meets")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (1.5, 2.5)), "overlaps")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (1.0, inf)), "starts")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (1.0, 3.0)), "starts")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 1.0), infsup (1.0, 3.0)), "starts")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (-inf, inf)), "containedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (-inf, 3.0)), "containedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (0.0, 3.0)), "containedBy")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (0.0, 3.0)), "containedBy")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (0.0, inf)), "containedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (-inf, 2.0)), "finishes")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (0.0, 2.0)), "finishes")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 2.0), infsup (0.0, 2.0)), "finishes")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 2.0), infsup (1.0, 2.0)), "equals")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 1.0), infsup (1.0, 1.0)), "equals")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 1.0), infsup (-inf, 1.0)), "equals")));
%!test
%! assert (all (eq (overlap (infsup (-inf, inf), infsup (-inf, inf)), "equals")));
%!test
%! assert (all (eq (overlap (infsup (3.0, 4.0), infsup (2.0, 2.0)), "after")));
%!test
%! assert (all (eq (overlap (infsup (3.0, 4.0), infsup (1.0, 2.0)), "after")));
%!test
%! assert (all (eq (overlap (infsup (3.0, 3.0), infsup (1.0, 2.0)), "after")));
%!test
%! assert (all (eq (overlap (infsup (3.0, 3.0), infsup (2.0, 2.0)), "after")));
%!test
%! assert (all (eq (overlap (infsup (3.0, inf), infsup (2.0, 2.0)), "after")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 3.0), infsup (1.0, 2.0)), "metBy")));
%!test
%! assert (all (eq (overlap (infsup (2.0, 3.0), infsup (-inf, 2.0)), "metBy")));
%!test
%! assert (all (eq (overlap (infsup (1.5, 2.5), infsup (1.0, 2.0)), "overlappedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.5, 2.5), infsup (-inf, 2.0)), "overlappedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, inf), infsup (1.0, 2.0)), "startedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 3.0), infsup (1.0, 2.0)), "startedBy")));
%!test
%! assert (all (eq (overlap (infsup (1.0, 3.0), infsup (1.0, 1.0)), "startedBy")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 3.0), infsup (1.0, 2.0)), "contains")));
%!test
%! assert (all (eq (overlap (infsup (-inf, inf), infsup (1.0, 2.0)), "contains")));
%!test
%! assert (all (eq (overlap (infsup (0.0, 3.0), infsup (1.0, 2.0)), "contains")));
%!test
%! assert (all (eq (overlap (infsup (0.0, 3.0), infsup (2.0, 2.0)), "contains")));
%!test
%! assert (all (eq (overlap (infsup (-inf, 2.0), infsup (1.0, 2.0)), "finishedBy")));
%!test
%! assert (all (eq (overlap (infsup (0.0, 2.0), infsup (1.0, 2.0)), "finishedBy")));
%!test
%! assert (all (eq (overlap (infsup (0.0, 2.0), infsup (2.0, 2.0)), "finishedBy")));

## minimal_overlap_dec_test

%!test
%! assert (all (eq (overlap (infsupdec (empty, "trv"), infsupdec (empty, "trv")), "bothEmpty")));
%!test
%! assert (all (eq (overlap (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "com")), "firstEmpty")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "def"), infsupdec (empty, "trv")), "secondEmpty")));
%!test
%! assert (all (eq (overlap (infsupdec (2.0, 2.0, "def"), infsupdec (3.0, 4.0, "def")), "before")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "dac"), infsupdec (3.0, 4.0, "com")), "before")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "com"), infsupdec (3.0, 3.0, "trv")), "before")));
%!test
%! assert (all (eq (overlap (infsupdec (2.0, 2.0, "trv"), infsupdec (3.0, 3.0, "def")), "before")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "def"), infsupdec (2.0, 3.0, "def")), "meets")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "dac"), infsupdec (1.5, 2.5, "def")), "overlaps")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "def"), infsupdec (1.0, 3.0, "com")), "starts")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 1.0, "trv"), infsupdec (1.0, 3.0, "def")), "starts")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "def"), infsupdec (0.0, 3.0, "dac")), "containedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (2.0, 2.0, "trv"), infsupdec (0.0, 3.0, "def")), "containedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "trv"), infsupdec (0.0, 2.0, "com")), "finishes")));
%!test
%! assert (all (eq (overlap (infsupdec (2.0, 2.0, "def"), infsupdec (0.0, 2.0, "dac")), "finishes")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 2.0, "def"), infsupdec (1.0, 2.0, "def")), "equals")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 1.0, "dac"), infsupdec (1.0, 1.0, "dac")), "equals")));
%!test
%! assert (all (eq (overlap (infsupdec (3.0, 4.0, "trv"), infsupdec (2.0, 2.0, "trv")), "after")));
%!test
%! assert (all (eq (overlap (infsupdec (3.0, 4.0, "def"), infsupdec (1.0, 2.0, "def")), "after")));
%!test
%! assert (all (eq (overlap (infsupdec (3.0, 3.0, "com"), infsupdec (1.0, 2.0, "dac")), "after")));
%!test
%! assert (all (eq (overlap (infsupdec (3.0, 3.0, "def"), infsupdec (2.0, 2.0, "trv")), "after")));
%!test
%! assert (all (eq (overlap (infsupdec (2.0, 3.0, "def"), infsupdec (1.0, 2.0, "trv")), "metBy")));
%!test
%! assert (all (eq (overlap (infsupdec (1.5, 2.5, "com"), infsupdec (1.0, 2.0, "com")), "overlappedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 3.0, "dac"), infsupdec (1.0, 2.0, "def")), "startedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (1.0, 3.0, "com"), infsupdec (1.0, 1.0, "dac")), "startedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (0.0, 3.0, "com"), infsupdec (1.0, 2.0, "dac")), "contains")));
%!test
%! assert (all (eq (overlap (infsupdec (0.0, 3.0, "com"), infsupdec (2.0, 2.0, "def")), "contains")));
%!test
%! assert (all (eq (overlap (infsupdec (0.0, 2.0, "def"), infsupdec (1.0, 2.0, "trv")), "finishedBy")));
%!test
%! assert (all (eq (overlap (infsupdec (0.0, 2.0, "dac"), infsupdec (2.0, 2.0, "def")), "finishedBy")));
