## DO NOT EDIT!  Generated automatically from test/libieeep1788_tests_cancel.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/09c37dc3a884ee2e1989e0e2b2f34324087a5199
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich (oheim@posteo.de)
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_cancelPlus_test

%!test
%! assert (all (eq (cancelplus (infsup (-inf, -1.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, inf), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, inf), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, -1.0), infsup (-5.0, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, inf), infsup (-5.0, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, inf), infsup (-5.0, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, -1.0), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (-inf, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, 5.0), infsup (1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, 5.0), infsup (-inf, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.0, 5.0), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, inf), infsup (1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, inf), infsup (-inf, 1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-inf, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.0, -1.0), infsup (1.0, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.0, -1.0), infsup (0.9, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.0, -1.0), infsup (0.9, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.0), infsup (-5.0, 10.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.0), infsup (-5.1, 10.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.0), infsup (-5.1, 10.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.0), infsup (-5.0, -0.9)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.0), infsup (-5.1, -1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.0), infsup (-5.1, -0.9)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, -1.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup, infsup), infsup)));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (1.0, 10.0)), infsup)));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (-5.0, 10.0)), infsup)));
%!test
%! assert (all (eq (cancelplus (infsup, infsup (-5.0, -1.0)), infsup)));
%!test
%! assert (all (eq (cancelplus (infsup (-5.1, -0.0), infsup (0.0, 5.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.1, -1.0), infsup (1.0, 5.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.0, -0.9), infsup (1.0, 5.0)), infsup (0.0, 9.999999999999997780e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.1, -0.9), infsup (1.0, 5.0)), infsup (-9.999999999999964473e-02, 9.999999999999997780e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (-5.0, -1.0), infsup (1.0, 5.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.1, 5.0), infsup (-5.0, 10.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.1), infsup (-5.0, 10.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.1, 5.1), infsup (-5.0, 10.0)), infsup (-9.999999999999964473e-02, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (-10.0, 5.0), infsup (-5.0, 10.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (0.9, 5.0), infsup (-5.0, -1.0)), infsup (-9.999999999999997780e-02, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.1), infsup (-5.0, -1.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (0.0, 5.1), infsup (-5.0, -0.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (0.9, 5.1), infsup (-5.0, -1.0)), infsup (-9.999999999999997780e-02, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelplus (infsup (1.0, 5.0), infsup (-5.0, -1.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (0.0, 5.0), infsup (-5.0, -0.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (1.999999999999996447e+00, 1.999999999999996447e+00), infsup (-1.000000000000000056e-01, -1.000000000000000056e-01)), infsup (1.899999999999996358e+00, 1.899999999999996581e+00))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.000000000000000056e-01, 1.999999999999996447e+00), infsup (-1.000000000000000056e-01, 0.01)), infsup (-9.000000000000001055e-02, 1.899999999999996581e+00))));
%!test
%! assert (all (eq (cancelplus (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (1.797693134862315708e+308, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315509e+308, 1.797693134862315708e+308)), infsup (0.0, 1.995840309534719812e+292))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315509e+308)), infsup (-1.995840309534719812e+292, 0.0))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.797693134862315708e+308, 1.797693134862315509e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.797693134862315509e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.000000000000000000e+00, 2.220446049250312834e-16), infsup (-1.000000000000000000e+00, 2.220446049250312588e-16)), infsup (-9.999999999999998890e-01, -9.999999999999997780e-01))));
%!test
%! assert (all (eq (cancelplus (infsup (-1.000000000000000000e+00, 2.220446049250312588e-16), infsup (-1.000000000000000000e+00, 2.220446049250312834e-16)), infsup (-inf, inf))));

## minimal_cancelPlus_dec_test

%!test
%! assert (all (eq (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, inf, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, inf, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (entire, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (entire, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (-5.0, 1.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (-5.0, 1.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, inf, "trv"), infsupdec (-5.0, 1.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, inf, "trv"), infsupdec (-5.0, 1.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (entire, "def"), infsupdec (-5.0, 1.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (entire, "def"), infsupdec (-5.0, 1.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-inf, -1.0, "dac"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, inf, "def"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, inf, "def"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (1.0, inf, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (1.0, inf, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (-inf, 1.0, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (-inf, 1.0, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, 5.0, "dac"), infsupdec (1.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, 5.0, "dac"), infsupdec (1.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, 5.0, "def"), infsupdec (-inf, 1.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, 5.0, "def"), infsupdec (-inf, 1.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.0, 5.0, "com"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.0, 5.0, "com"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (entire, "def"), infsupdec (1.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (entire, "def"), infsupdec (1.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (entire, "def"), infsupdec (-inf, 1.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (entire, "def"), infsupdec (-inf, 1.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (entire, "def"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (entire, "def"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.0, -1.0, "com"), infsupdec (1.0, 5.1, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.0, -1.0, "com"), infsupdec (1.0, 5.1, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.0, -1.0, "dac"), infsupdec (0.9, 5.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.0, -1.0, "dac"), infsupdec (0.9, 5.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.0, -1.0, "def"), infsupdec (0.9, 5.1, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.0, -1.0, "def"), infsupdec (0.9, 5.1, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.0, "trv"), infsupdec (-5.0, 10.1, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.0, "trv"), infsupdec (-5.0, 10.1, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.0, "com"), infsupdec (-5.1, 10.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.0, "com"), infsupdec (-5.1, 10.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.0, "dac"), infsupdec (-5.1, 10.1, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.0, "dac"), infsupdec (-5.1, 10.1, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.0, "def"), infsupdec (-5.0, -0.9, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.0, "def"), infsupdec (-5.0, -0.9, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.0, "trv"), infsupdec (-5.1, -1.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.0, "trv"), infsupdec (-5.1, -1.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.0, "dac"), infsupdec (-5.1, -0.9, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.0, "dac"), infsupdec (-5.1, -0.9, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, -1.0, "trv"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, -1.0, "trv"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.0, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.0, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.0, "com"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.0, "com"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (1.0, 10.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (1.0, 10.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (-5.0, 10.0, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (-5.0, 10.0, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (empty, "trv"), infsupdec (-5.0, -1.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (empty, "trv"), infsupdec (-5.0, -1.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.1, -0.0, "com"), infsupdec (0.0, 5.0, "com")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.1, -0.0, "com"), infsupdec (0.0, 5.0, "com"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.1, -1.0, "com"), infsupdec (1.0, 5.0, "dac")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.1, -1.0, "com"), infsupdec (1.0, 5.0, "dac"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.0, -0.9, "com"), infsupdec (1.0, 5.0, "def")), infsupdec (0.0, 9.999999999999997780e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.0, -0.9, "com"), infsupdec (1.0, 5.0, "def"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999997780e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.1, -0.9, "dac"), infsupdec (1.0, 5.0, "trv")), infsupdec (-9.999999999999964473e-02, 9.999999999999997780e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.1, -0.9, "dac"), infsupdec (1.0, 5.0, "trv"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 9.999999999999997780e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-5.0, -1.0, "dac"), infsupdec (1.0, 5.0, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-5.0, -1.0, "dac"), infsupdec (1.0, 5.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.1, 5.0, "dac"), infsupdec (-5.0, 10.0, "dac")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.1, 5.0, "dac"), infsupdec (-5.0, 10.0, "dac"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.1, "def"), infsupdec (-5.0, 10.0, "def")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.1, "def"), infsupdec (-5.0, 10.0, "def"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.1, 5.1, "def"), infsupdec (-5.0, 10.0, "trv")), infsupdec (-9.999999999999964473e-02, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.1, 5.1, "def"), infsupdec (-5.0, 10.0, "trv"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-10.0, 5.0, "def"), infsupdec (-5.0, 10.0, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-10.0, 5.0, "def"), infsupdec (-5.0, 10.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (0.9, 5.0, "trv"), infsupdec (-5.0, -1.0, "dac")), infsupdec (-9.999999999999997780e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (0.9, 5.0, "trv"), infsupdec (-5.0, -1.0, "dac"))) {1}, decorationpart (infsupdec (-9.999999999999997780e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.1, "trv"), infsupdec (-5.0, -1.0, "def")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.1, "trv"), infsupdec (-5.0, -1.0, "def"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (0.0, 5.1, "trv"), infsupdec (-5.0, -0.0, "trv")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (0.0, 5.1, "trv"), infsupdec (-5.0, -0.0, "trv"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (0.9, 5.1, "com"), infsupdec (-5.0, -1.0, "com")), infsupdec (-9.999999999999997780e-02, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (0.9, 5.1, "com"), infsupdec (-5.0, -1.0, "com"))) {1}, decorationpart (infsupdec (-9.999999999999997780e-02, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.0, 5.0, "dac"), infsupdec (-5.0, -1.0, "dac")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.0, 5.0, "dac"), infsupdec (-5.0, -1.0, "dac"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (0.0, 5.0, "def"), infsupdec (-5.0, -0.0, "trv")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (0.0, 5.0, "def"), infsupdec (-5.0, -0.0, "trv"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.999999999999996447e+00, 1.999999999999996447e+00, "com"), infsupdec (-1.000000000000000056e-01, -1.000000000000000056e-01, "com")), infsupdec (1.899999999999996358e+00, 1.899999999999996581e+00, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.999999999999996447e+00, 1.999999999999996447e+00, "com"), infsupdec (-1.000000000000000056e-01, -1.000000000000000056e-01, "com"))) {1}, decorationpart (infsupdec (1.899999999999996358e+00, 1.899999999999996581e+00, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.000000000000000056e-01, 1.999999999999996447e+00, "dac"), infsupdec (-1.000000000000000056e-01, 0.01, "com")), infsupdec (-9.000000000000001055e-02, 1.899999999999996581e+00, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.000000000000000056e-01, 1.999999999999996447e+00, "dac"), infsupdec (-1.000000000000000056e-01, 0.01, "com"))) {1}, decorationpart (infsupdec (-9.000000000000001055e-02, 1.899999999999996581e+00, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (1.797693134862315708e+308, inf, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (1.797693134862315708e+308, inf, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "dac"), infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com")), infsupdec (0.0, 1.995840309534719812e+292, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "dac"), infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (0.0, 1.995840309534719812e+292, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "dac"), infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com")), infsupdec (-1.995840309534719812e+292, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "dac"), infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"))) {1}, decorationpart (infsupdec (-1.995840309534719812e+292, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "dac"), infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "com")), infsupdec (-9.999999999999998890e-01, -9.999999999999997780e-01, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "dac"), infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "com"))) {1}, decorationpart (infsupdec (-9.999999999999998890e-01, -9.999999999999997780e-01, "trv")) {1})));
%!test
%! assert (all (eq (cancelplus (infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "def"), infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelplus (infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "def"), infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));

## minimal_cancelMinus_test

%!test
%! assert (all (eq (cancelminus (infsup (-inf, -1.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, inf), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, inf), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, -1.0), infsup (-1.0, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, inf), infsup (-1.0, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, inf), infsup (-1.0, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, -1.0), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (-inf, -1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (-1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, 5.0), infsup (-inf, -1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, 5.0), infsup (-1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.0, 5.0), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, inf), infsup (-inf, -1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, inf), infsup (-1.0, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-inf, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, -1.0), infsup (-5.1, -1.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, -1.0), infsup (-5.0, -0.9)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, -1.0), infsup (-5.1, -0.9)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.0), infsup (-10.1, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.0), infsup (-10.0, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.0), infsup (-10.1, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.0), infsup (0.9, 5.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.0), infsup (1.0, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.0), infsup (0.9, 5.1)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, -1.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.0), infsup), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup, infsup), infsup)));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (-10.0, -1.0)), infsup)));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (-10.0, 5.0)), infsup)));
%!test
%! assert (all (eq (cancelminus (infsup, infsup (1.0, 5.0)), infsup)));
%!test
%! assert (all (eq (cancelminus (infsup (-5.1, -0.0), infsup (-5.0, 0.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.1, -1.0), infsup (-5.0, -1.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, -0.9), infsup (-5.0, -1.0)), infsup (0.0, 9.999999999999997780e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.1, -0.9), infsup (-5.0, -1.0)), infsup (-9.999999999999964473e-02, 9.999999999999997780e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, -1.0), infsup (-5.0, -1.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.1, 5.0), infsup (-10.0, 5.0)), infsup (-9.999999999999964473e-02, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.1), infsup (-10.0, 5.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.1, 5.1), infsup (-10.0, 5.0)), infsup (-9.999999999999964473e-02, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (-10.0, 5.0), infsup (-10.0, 5.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (0.9, 5.0), infsup (1.0, 5.0)), infsup (-9.999999999999997780e-02, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-0.0, 5.1), infsup (0.0, 5.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.1), infsup (1.0, 5.0)), infsup (0.0, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (0.9, 5.1), infsup (1.0, 5.0)), infsup (-9.999999999999997780e-02, 9.999999999999964473e-02))));
%!test
%! assert (all (eq (cancelminus (infsup (1.0, 5.0), infsup (1.0, 5.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, 1.0), infsup (-1.0, 5.0)), infsup (-4.0, -4.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-5.0, 0.0), infsup (-0.0, 5.0)), infsup (-5.0, -5.0))));
%!test
%! assert (all (eq (cancelminus (infsup (1.999999999999996447e+00, 1.999999999999996447e+00), infsup (1.000000000000000056e-01, 1.000000000000000056e-01)), infsup (1.899999999999996358e+00, 1.899999999999996581e+00))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.000000000000000056e-01, 1.999999999999996447e+00), infsup (-0.01, 1.000000000000000056e-01)), infsup (-9.000000000000001055e-02, 1.899999999999996581e+00))));
%!test
%! assert (all (eq (cancelminus (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, -1.797693134862315708e+308)), infsup (1.797693134862315708e+308, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315509e+308)), infsup (0.0, 1.995840309534719812e+292))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-1.797693134862315509e+308, 1.797693134862315708e+308)), infsup (-1.995840309534719812e+292, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.797693134862315708e+308, 1.797693134862315509e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.797693134862315509e+308, 1.797693134862315708e+308), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (4.940656458412465442e-324, 4.940656458412465442e-324), infsup (4.940656458412465442e-324, 4.940656458412465442e-324)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (cancelminus (infsup (4.940656458412465442e-324, 4.940656458412465442e-324), infsup (-4.940656458412465442e-324, -4.940656458412465442e-324)), infsup (9.881312916824930884e-324, 9.881312916824930884e-324))));
%!test
%! assert (all (eq (cancelminus (infsup (2.225073858507201383e-308, 2.225073858507202371e-308), infsup (2.225073858507201383e-308, 2.225073858507201877e-308)), infsup (0.0, 4.940656458412465442e-324))));
%!test
%! assert (all (eq (cancelminus (infsup (2.225073858507201383e-308, 2.225073858507201877e-308), infsup (2.225073858507201383e-308, 2.225073858507202371e-308)), infsup (-inf, inf))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.000000000000000000e+00, 2.220446049250312834e-16), infsup (-2.220446049250312588e-16, 1.000000000000000000e+00)), infsup (-9.999999999999998890e-01, -9.999999999999997780e-01))));
%!test
%! assert (all (eq (cancelminus (infsup (-1.000000000000000000e+00, 2.220446049250312588e-16), infsup (-2.220446049250312834e-16, 1.000000000000000000e+00)), infsup (-inf, inf))));

## minimal_cancelMinus_dec_test

%!test
%! assert (all (eq (cancelminus (infsupdec (-inf, -1.0, "dac"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-inf, -1.0, "dac"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, inf, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, inf, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (entire, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (entire, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-inf, -1.0, "trv"), infsupdec (-1.0, 5.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-inf, -1.0, "trv"), infsupdec (-1.0, 5.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, inf, "dac"), infsupdec (-1.0, 5.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, inf, "dac"), infsupdec (-1.0, 5.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (entire, "def"), infsupdec (-1.0, 5.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (entire, "def"), infsupdec (-1.0, 5.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-inf, -1.0, "def"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-inf, -1.0, "def"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, inf, "trv"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, inf, "trv"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (-inf, -1.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (-inf, -1.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (-1.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (-1.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, 5.0, "dac"), infsupdec (-inf, -1.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, 5.0, "dac"), infsupdec (-inf, -1.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, 5.0, "def"), infsupdec (-1.0, inf, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, 5.0, "def"), infsupdec (-1.0, inf, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.0, 5.0, "com"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.0, 5.0, "com"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (entire, "def"), infsupdec (-inf, -1.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (entire, "def"), infsupdec (-inf, -1.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (entire, "def"), infsupdec (-1.0, inf, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (entire, "def"), infsupdec (-1.0, inf, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (entire, "def"), infsupdec (entire, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (entire, "def"), infsupdec (entire, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, -1.0, "com"), infsupdec (-5.1, -1.0, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, -1.0, "com"), infsupdec (-5.1, -1.0, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, -1.0, "dac"), infsupdec (-5.0, -0.9, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, -1.0, "dac"), infsupdec (-5.0, -0.9, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, -1.0, "def"), infsupdec (-5.1, -0.9, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, -1.0, "def"), infsupdec (-5.1, -0.9, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.0, "trv"), infsupdec (-10.1, 5.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.0, "trv"), infsupdec (-10.1, 5.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.0, "com"), infsupdec (-10.0, 5.1, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.0, "com"), infsupdec (-10.0, 5.1, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.0, "dac"), infsupdec (-10.1, 5.1, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.0, "dac"), infsupdec (-10.1, 5.1, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.0, "def"), infsupdec (0.9, 5.0, "def")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.0, "def"), infsupdec (0.9, 5.0, "def"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.0, "trv"), infsupdec (1.0, 5.1, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.0, "trv"), infsupdec (1.0, 5.1, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.0, "com"), infsupdec (0.9, 5.1, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.0, "com"), infsupdec (0.9, 5.1, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, -1.0, "com"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, -1.0, "com"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.0, "dac"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.0, "dac"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.0, "def"), infsupdec (empty, "trv")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.0, "def"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (-10.0, -1.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (-10.0, -1.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (-10.0, 5.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (-10.0, 5.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (empty, "trv"), infsupdec (1.0, 5.0, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (empty, "trv"), infsupdec (1.0, 5.0, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.1, -0.0, "com"), infsupdec (-5.0, 0.0, "com")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.1, -0.0, "com"), infsupdec (-5.0, 0.0, "com"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.1, -1.0, "dac"), infsupdec (-5.0, -1.0, "com")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.1, -1.0, "dac"), infsupdec (-5.0, -1.0, "com"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, -0.9, "def"), infsupdec (-5.0, -1.0, "com")), infsupdec (0.0, 9.999999999999997780e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, -0.9, "def"), infsupdec (-5.0, -1.0, "com"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999997780e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.1, -0.9, "trv"), infsupdec (-5.0, -1.0, "com")), infsupdec (-9.999999999999964473e-02, 9.999999999999997780e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.1, -0.9, "trv"), infsupdec (-5.0, -1.0, "com"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 9.999999999999997780e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, -1.0, "com"), infsupdec (-5.0, -1.0, "dac")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, -1.0, "com"), infsupdec (-5.0, -1.0, "dac"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.1, 5.0, "dac"), infsupdec (-10.0, 5.0, "dac")), infsupdec (-9.999999999999964473e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.1, 5.0, "dac"), infsupdec (-10.0, 5.0, "dac"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.1, "def"), infsupdec (-10.0, 5.0, "dac")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.1, "def"), infsupdec (-10.0, 5.0, "dac"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.1, 5.1, "trv"), infsupdec (-10.0, 5.0, "def")), infsupdec (-9.999999999999964473e-02, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.1, 5.1, "trv"), infsupdec (-10.0, 5.0, "def"))) {1}, decorationpart (infsupdec (-9.999999999999964473e-02, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-10.0, 5.0, "com"), infsupdec (-10.0, 5.0, "def")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-10.0, 5.0, "com"), infsupdec (-10.0, 5.0, "def"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (0.9, 5.0, "dac"), infsupdec (1.0, 5.0, "def")), infsupdec (-9.999999999999997780e-02, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (0.9, 5.0, "dac"), infsupdec (1.0, 5.0, "def"))) {1}, decorationpart (infsupdec (-9.999999999999997780e-02, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-0.0, 5.1, "def"), infsupdec (0.0, 5.0, "def")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-0.0, 5.1, "def"), infsupdec (0.0, 5.0, "def"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.1, "trv"), infsupdec (1.0, 5.0, "trv")), infsupdec (0.0, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.1, "trv"), infsupdec (1.0, 5.0, "trv"))) {1}, decorationpart (infsupdec (0.0, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (0.9, 5.1, "com"), infsupdec (1.0, 5.0, "trv")), infsupdec (-9.999999999999997780e-02, 9.999999999999964473e-02, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (0.9, 5.1, "com"), infsupdec (1.0, 5.0, "trv"))) {1}, decorationpart (infsupdec (-9.999999999999997780e-02, 9.999999999999964473e-02, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.0, 5.0, "dac"), infsupdec (1.0, 5.0, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.0, 5.0, "dac"), infsupdec (1.0, 5.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, 1.0, "def"), infsupdec (-1.0, 5.0, "def")), infsupdec (-4.0, -4.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, 1.0, "def"), infsupdec (-1.0, 5.0, "def"))) {1}, decorationpart (infsupdec (-4.0, -4.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-5.0, 0.0, "trv"), infsupdec (-0.0, 5.0, "trv")), infsupdec (-5.0, -5.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-5.0, 0.0, "trv"), infsupdec (-0.0, 5.0, "trv"))) {1}, decorationpart (infsupdec (-5.0, -5.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.999999999999996447e+00, 1.999999999999996447e+00, "com"), infsupdec (1.000000000000000056e-01, 1.000000000000000056e-01, "com")), infsupdec (1.899999999999996358e+00, 1.899999999999996581e+00, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.999999999999996447e+00, 1.999999999999996447e+00, "com"), infsupdec (1.000000000000000056e-01, 1.000000000000000056e-01, "com"))) {1}, decorationpart (infsupdec (1.899999999999996358e+00, 1.899999999999996581e+00, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.000000000000000056e-01, 1.999999999999996447e+00, "def"), infsupdec (-0.01, 1.000000000000000056e-01, "dac")), infsupdec (-9.000000000000001055e-02, 1.899999999999996581e+00, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.000000000000000056e-01, 1.999999999999996447e+00, "def"), infsupdec (-0.01, 1.000000000000000056e-01, "dac"))) {1}, decorationpart (infsupdec (-9.000000000000001055e-02, 1.899999999999996581e+00, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, -1.797693134862315708e+308, "com")), infsupdec (1.797693134862315708e+308, inf, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, -1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (1.797693134862315708e+308, inf, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com")), infsupdec (0.0, 1.995840309534719812e+292, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"))) {1}, decorationpart (infsupdec (0.0, 1.995840309534719812e+292, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com")), infsupdec (-1.995840309534719812e+292, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (-1.995840309534719812e+292, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.797693134862315708e+308, 1.797693134862315509e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.797693134862315509e+308, 1.797693134862315708e+308, "com"), infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com"), infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com")), infsupdec (0.0, 0.0, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com"), infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com"), infsupdec (-4.940656458412465442e-324, -4.940656458412465442e-324, "dac")), infsupdec (9.881312916824930884e-324, 9.881312916824930884e-324, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (4.940656458412465442e-324, 4.940656458412465442e-324, "com"), infsupdec (-4.940656458412465442e-324, -4.940656458412465442e-324, "dac"))) {1}, decorationpart (infsupdec (9.881312916824930884e-324, 9.881312916824930884e-324, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (2.225073858507201383e-308, 2.225073858507202371e-308, "dac"), infsupdec (2.225073858507201383e-308, 2.225073858507201877e-308, "dac")), infsupdec (0.0, 4.940656458412465442e-324, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (2.225073858507201383e-308, 2.225073858507202371e-308, "dac"), infsupdec (2.225073858507201383e-308, 2.225073858507201877e-308, "dac"))) {1}, decorationpart (infsupdec (0.0, 4.940656458412465442e-324, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (2.225073858507201383e-308, 2.225073858507201877e-308, "def"), infsupdec (2.225073858507201383e-308, 2.225073858507202371e-308, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (2.225073858507201383e-308, 2.225073858507201877e-308, "def"), infsupdec (2.225073858507201383e-308, 2.225073858507202371e-308, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "com"), infsupdec (-2.220446049250312588e-16, 1.000000000000000000e+00, "dac")), infsupdec (-9.999999999999998890e-01, -9.999999999999997780e-01, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.000000000000000000e+00, 2.220446049250312834e-16, "com"), infsupdec (-2.220446049250312588e-16, 1.000000000000000000e+00, "dac"))) {1}, decorationpart (infsupdec (-9.999999999999998890e-01, -9.999999999999997780e-01, "trv")) {1})));
%!test
%! assert (all (eq (cancelminus (infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "def"), infsupdec (-2.220446049250312834e-16, 1.000000000000000000e+00, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (cancelminus (infsupdec (-1.000000000000000000e+00, 2.220446049250312588e-16, "def"), infsupdec (-2.220446049250312834e-16, 1.000000000000000000e+00, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
