## DO NOT EDIT!  Generated automatically from src/libieeep1788_tests_num.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/7e5753a2c84051d180748b5dc9896d1a358d742d
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich (oheim@posteo.de)
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_inf_test

%!test
%! assert (all (eq (...
%!    inf (infsup), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-inf, inf)), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsup (1.0, 2.0)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-3.0, -2.0)), ...
%!    -3.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-inf, 2.0)), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-inf, 0.0)), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-inf, -0.0)), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-2.0, inf)), ...
%!    -2.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (0.0, inf)), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-0.0, inf)), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-0.0, 0.0)), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (0.0, -0.0)), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (0.0, 0.0)), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsup (-0.0, -0.0)), ...
%!    -0.0)))

## minimal_inf_dec_test

%!test
%! assert (all (eq (...
%!    inf (infsupdec (empty, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-inf, inf, "def")), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (1.0, 2.0, "com")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-3.0, -2.0, "trv")), ...
%!    -3.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-inf, 2.0, "dac")), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-inf, 0.0, "def")), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-inf, -0.0, "trv")), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-2.0, inf, "trv")), ...
%!    -2.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (0.0, inf, "def")), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-0.0, inf, "trv")), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-0.0, 0.0, "dac")), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (0.0, -0.0, "trv")), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (0.0, 0.0, "trv")), ...
%!    -0.0)))
%!test
%! assert (all (eq (...
%!    inf (infsupdec (-0.0, -0.0, "trv")), ...
%!    -0.0)))

## minimal_sup_test

%!test
%! assert (all (eq (...
%!    sup (infsup), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-inf, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsup (1.0, 2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-3.0, -2.0)), ...
%!    -2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-inf, 2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-inf, 0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-inf, -0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-2.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsup (0.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-0.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-0.0, 0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (0.0, -0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (0.0, 0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsup (-0.0, -0.0)), ...
%!    0.0)))

## minimal_sup_dec_test

%!test
%! assert (all (eq (...
%!    sup (infsupdec (empty, "trv")), ...
%!    -inf)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-inf, inf, "def")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (1.0, 2.0, "com")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-3.0, -2.0, "trv")), ...
%!    -2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-inf, 2.0, "dac")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-inf, 0.0, "def")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-inf, -0.0, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-2.0, inf, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (0.0, inf, "def")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-0.0, inf, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-0.0, 0.0, "dac")), ...
%!    +0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (0.0, -0.0, "trv")), ...
%!    +0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (0.0, 0.0, "trv")), ...
%!    +0.0)))
%!test
%! assert (all (eq (...
%!    sup (infsupdec (-0.0, -0.0, "trv")), ...
%!    +0.0)))

## minimal_mid_test

%!test
%! assert (all (eq (...
%!    mid (infsup (-inf, inf)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (0.0, 2.0)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (2.0, 2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (-2.0, 2.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (-9.881312916824930884e-324, 4.940656458412465442e-324)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsup (-4.940656458412465442e-324, 9.881312916824930884e-324)), ...
%!    0.0)))

## minimal_mid_dec_test

%!test
%! assert (all (eq (...
%!    mid (infsupdec (-inf, inf, "def")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (0.0, 2.0, "com")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (2.0, 2.0, "dac")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (-2.0, 2.0, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (-9.881312916824930884e-324, 4.940656458412465442e-324, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mid (infsupdec (-4.940656458412465442e-324, 9.881312916824930884e-324, "trv")), ...
%!    0.0)))

## minimal_rad_test

%!test
%! assert (all (eq (...
%!    rad (infsup (0.0, 2.0)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    rad (infsup (2.0, 2.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    rad (infsup (-inf, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    rad (infsup (0.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    rad (infsup (-inf, 1.2)), ...
%!    inf)))

## minimal_rad_dec_test

%!test
%! assert (all (eq (...
%!    rad (infsupdec (0.0, 2.0, "trv")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    rad (infsupdec (2.0, 2.0, "com")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    rad (infsupdec (-inf, inf, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    rad (infsupdec (0.0, inf, "def")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    rad (infsupdec (-inf, 1.2, "trv")), ...
%!    inf)))

## minimal_wid_test

%!test
%! assert (all (eq (...
%!    wid (infsup (2.0, 2.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    wid (infsup (1.0, 2.0)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    wid (infsup (1.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    wid (infsup (-inf, 2.0)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    wid (infsup (-inf, inf)), ...
%!    inf)))

## minimal_wid_dec_test

%!test
%! assert (all (eq (...
%!    wid (infsupdec (2.0, 2.0, "com")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    wid (infsupdec (1.0, 2.0, "trv")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    wid (infsupdec (1.0, inf, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    wid (infsupdec (-inf, 2.0, "def")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    wid (infsupdec (-inf, inf, "trv")), ...
%!    inf)))

## minimal_mag_test

%!test
%! assert (all (eq (...
%!    mag (infsup (1.0, 2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mag (infsup (-4.0, 2.0)), ...
%!    4.0)))
%!test
%! assert (all (eq (...
%!    mag (infsup (-inf, 2.0)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsup (1.0, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsup (-inf, inf)), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsup (-0.0, 0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mag (infsup (-0.0, -0.0)), ...
%!    0.0)))

## minimal_mag_dec_test

%!test
%! assert (all (eq (...
%!    mag (infsupdec (1.0, 2.0, "com")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (-4.0, 2.0, "trv")), ...
%!    4.0)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (-inf, 2.0, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (1.0, inf, "def")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (-inf, inf, "trv")), ...
%!    inf)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (-0.0, 0.0, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mag (infsupdec (-0.0, -0.0, "trv")), ...
%!    0.0)))

## minimal_mig_test

%!test
%! assert (all (eq (...
%!    mig (infsup (1.0, 2.0)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-4.0, 2.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-4.0, -2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-inf, 2.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-inf, -2.0)), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-1.0, inf)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (1.0, inf)), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-inf, inf)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-0.0, 0.0)), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsup (-0.0, -0.0)), ...
%!    0.0)))

## minimal_mig_dec_test

%!test
%! assert (all (eq (...
%!    mig (infsupdec (1.0, 2.0, "com")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-4.0, 2.0, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-4.0, -2.0, "trv")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-inf, 2.0, "def")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-inf, -2.0, "trv")), ...
%!    2.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-1.0, inf, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (1.0, inf, "trv")), ...
%!    1.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-inf, inf, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-0.0, 0.0, "trv")), ...
%!    0.0)))
%!test
%! assert (all (eq (...
%!    mig (infsupdec (-0.0, -0.0, "trv")), ...
%!    0.0)))
