# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

service_mapping = {
    "access-governance-cp": [
        "access_governance_cp",
        "Access Governance",
        "Others"
    ],
    "adm": [
        "adm",
        "Application Dependency Management",
        "Developer Services"
    ],
    "ai": [
        "ai_language",
        "Language",
        "Analytics & AI"
    ],
    "ai-document": [
        "ai_document",
        "Document Understanding",
        "Analytics & AI"
    ],
    "ai-vision": [
        "ai_vision",
        "Vision",
        "Analytics & AI"
    ],
    "analytics": [
        "analytics",
        "Analytics",
        "Analytics & AI"
    ],
    "announce": [
        "announcements_service",
        "Announcements Service",
        "Governance & Administration"
    ],
    "anomaly-detection": [
        "ai_anomaly_detection",
        "Anomaly Detection",
        "Analytics & AI"
    ],
    "api-gateway": [
        "apigateway",
        "API Gateway",
        "Developer Services"
    ],
    "apm-config": [
        "apm_config",
        "Application Performance Monitoring Configuration",
        "Observability & Management"
    ],
    "apm-control-plane": [
        "apm_control_plane",
        "Application Performance Monitoring Control Plane",
        "Observability & Management"
    ],
    "apm-synthetics": [
        "apm_synthetics",
        "Application Performance Monitoring Synthetic Monitoring",
        "Observability & Management"
    ],
    "apm-traces": [
        "apm_traces",
        "Application Performance Monitoring Trace Explorer",
        "Observability & Management"
    ],
    "appmgmt-control": [
        "appmgmt_control",
        "Resource Discovery and Monitoring Control",
        "Others"
    ],
    "artifacts": [
        "artifacts",
        "Artifacts and Container Images",
        "Developer Services"
    ],
    "audit": [
        "audit",
        "Audit",
        "Identity & Security"
    ],
    "autoscaling": [
        "autoscaling",
        "Autoscaling",
        "Compute"
    ],
    "bastion": [
        "bastion",
        "Bastion",
        "Identity & Security"
    ],
    "bds": [
        "bds",
        "Big Data Service",
        "Analytics & AI"
    ],
    "blockchain": [
        "blockchain",
        "Blockchain Platform Control Plane",
        "Developer Services"
    ],
    "budgets": [
        "budget",
        "Budgets",
        "Billing & Cost Management"
    ],
    "bv": [
        "core",
        "Block Volume Service",
        "Storage"
    ],
    "capacity-management": [
        "capacity_management",
        "OciControlCenterCp",
        "Governance & Administration"
    ],
    "ccc": [
        "compute_cloud_at_customer",
        "Compute Cloud@Customer",
        "Others"
    ],
    "ce": [
        "container_engine",
        "Container Engine for Kubernetes",
        "Developer Services"
    ],
    "certificates": [
        "certificates",
        "Certificates Service Retrieval",
        "Identity & Security"
    ],
    "certs-mgmt": [
        "certificates_management",
        "Certificates Service Management",
        "Identity & Security"
    ],
    "cloud-bridge": [
        "cloud_bridge",
        "Oracle Cloud Bridge",
        "Others"
    ],
    "cloud-guard": [
        "cloud_guard",
        "Cloud Guard and Security Zones",
        "Identity & Security"
    ],
    "cloud-migrations": [
        "cloud_migrations",
        "Oracle Cloud Migrations",
        "Others"
    ],
    "compute": [
        "core",
        "Compute Service",
        "Compute"
    ],
    "compute-management": [
        "core",
        "Compute Management Service",
        "Compute"
    ],
    "container-instances": [
        "container_instances",
        "Container Instance",
        "Others"
    ],
    "cpg": [
        "cluster_placement_groups",
        "Cluster Placement Groups",
        "Others"
    ],
    "dashboard-service": [
        "dashboard_service",
        "Dashboards",
        "Observability & Management"
    ],
    "data-catalog": [
        "data_catalog",
        "Data Catalog",
        "Analytics & AI"
    ],
    "data-flow": [
        "data_flow",
        "Data Flow",
        "Analytics & AI"
    ],
    "data-integration": [
        "data_integration",
        "Data Integration",
        "Analytics & AI"
    ],
    "data-labeling-service": [
        "data_labeling_service",
        "Data Labeling Management",
        "Analytics & AI"
    ],
    "data-labeling-service-dataplane": [
        "data_labeling_service_dataplane",
        "Data Labeling",
        "Analytics & AI"
    ],
    "data-safe": [
        "data_safe",
        "Data Safe",
        "Oracle Database"
    ],
    "data-science": [
        "data_science",
        "Data Science",
        "Analytics & AI"
    ],
    "database-management": [
        "database_management",
        "Database Management",
        "Databases"
    ],
    "database-migration": [
        "database_migration",
        "Database Migration",
        "Migration"
    ],
    "db": [
        "database",
        "Database Service",
        "Databases"
    ],
    "dbtools": [
        "database_tools",
        "Database Tools",
        "Developer Services"
    ],
    "demand-signal": [
        "demand_signal",
        "OCI Control Center Demand Signal",
        "Others"
    ],
    "desktops": [
        "desktops",
        "Secure Desktops",
        "Others"
    ],
    "devops": [
        "devops",
        "DevOps",
        "Developer Services"
    ],
    "disaster-recovery": [
        "disaster_recovery",
        "Full Stack Disaster Recovery",
        "Others"
    ],
    "dns": [
        "dns",
        "DNS",
        "Networking"
    ],
    "dts": [
        "dts",
        "Data Transfer Service",
        "Migration"
    ],
    "em-warehouse": [
        "em_warehouse",
        "EM Warehouse",
        "Others"
    ],
    "email": [
        "email",
        "Email Delivery",
        "Developer Services"
    ],
    "email-data-plane": [
        "email_data_plane",
        "Email Delivery Submission",
        "Others"
    ],
    "events": [
        "events",
        "Events",
        "Observability & Management"
    ],
    "fleet-software-update": [
        "fleet_software_update",
        "Exadata Fleet Update service",
        "Others"
    ],
    "fn": [
        "functions",
        "Functions Service",
        "Developer Services"
    ],
    "fs": [
        "file_storage",
        "File Storage",
        "Storage"
    ],
    "fusion-apps": [
        "fusion_apps",
        "Fusion Applications Environment Management",
        "Others"
    ],
    "gdd": [
        "globally_distributed_database",
        "Globally Distributed Database",
        "Others"
    ],
    "generative-ai": [
        "generative_ai",
        "Generative AI Service Management",
        "Others"
    ],
    "generative-ai-inference": [
        "generative_ai_inference",
        "Generative AI Service Inference",
        "Others"
    ],
    "goldengate": [
        "golden_gate",
        "GoldenGate",
        "Oracle Database"
    ],
    "governance-rules-control-plane": [
        "governance_rules_control_plane",
        "GovernanceRulesControlPlane",
        "Governance & Administration"
    ],
    "health-checks": [
        "healthchecks",
        "Health Checks",
        "Observability & Management"
    ],
    "iam": [
        "identity",
        "Identity and Access Management Service",
        "Identity & Security"
    ],
    "identity-domains": [
        "identity_domains",
        "Identity Domains",
        "Others"
    ],
    "instance-agent": [
        "compute_instance_agent",
        "Compute Instance Agent Service",
        "Others"
    ],
    "integration": [
        "integration",
        "Oracle Integration",
        "Others"
    ],
    "jms": [
        "jms",
        "Java Management Service",
        "Observability & Management"
    ],
    "jms-java-downloads": [
        "jms_java_downloads",
        "Java Management Service Download",
        "Others"
    ],
    "kms": [
        "key_management",
        "Key Management",
        "Observability & Management"
    ],
    "lb": [
        "load_balancer",
        "Load Balancing",
        "Networking"
    ],
    "license-manager": [
        "license_manager",
        "License Manager",
        "Governance & Administration"
    ],
    "limits": [
        "limits",
        "Service Limits",
        "Governance & Administration"
    ],
    "log-analytics": [
        "log_analytics",
        "LogAnalytics",
        "Observability & Management"
    ],
    "logging": [
        "logging",
        "Logging Management",
        "Observability & Management"
    ],
    "logging-ingestion": [
        "loggingingestion",
        "Logging Ingestion",
        "Observability & Management"
    ],
    "logging-search": [
        "loggingsearch",
        "Logging Search",
        "Observability & Management"
    ],
    "management-agent": [
        "management_agent",
        "Management Agent",
        "Observability & Management"
    ],
    "management-dashboard": [
        "management_dashboard",
        "ManagementDashboard",
        "Others"
    ],
    "marketplace": [
        "marketplace",
        "Marketplace Service",
        "Observability & Management"
    ],
    "marketplace-private-offer": [
        "marketplace_private_offer",
        "MarketplacePrivateOffer",
        "Others"
    ],
    "marketplace-publisher": [
        "marketplace_publisher",
        "MarketplacePublisherService",
        "Others"
    ],
    "media-services": [
        "media_services",
        "Media Services",
        "Others"
    ],
    "monitoring": [
        "monitoring",
        "Monitoring",
        "Others"
    ],
    "mysql": [
        "mysql",
        "MySQL Database Service",
        "Databases"
    ],
    "network": [
        "core",
        "Networking Service",
        "Networking"
    ],
    "network-firewall": [
        "network_firewall",
        "Network Firewall",
        "Networking"
    ],
    "nlb": [
        "network_load_balancer",
        "NetworkLoadBalancer",
        "Networking"
    ],
    "nosql": [
        "nosql",
        "NoSQL Database",
        "Databases"
    ],
    "occ": [
        "oci_control_center",
        "OCI Control Center",
        "Others"
    ],
    "oce": [
        "oce",
        "Oracle Content and Experience",
        "Developer Services"
    ],
    "ocvs": [
        "ocvp",
        "Oracle Cloud VMware Solution",
        "Hybrid"
    ],
    "oda": [
        "oda",
        "Digital Assistant Service Instance",
        "Analytics & AI"
    ],
    "oma": [
        "lockbox",
        "Managed Access",
        "Identity & Security"
    ],
    "onesubscription": [
        "onesubscription",
        "OneSubscription",
        "Billing & Cost Management"
    ],
    "ons": [
        "ons",
        "Notifications",
        "Others"
    ],
    "opa": [
        "opa",
        "Process Automation",
        "Others"
    ],
    "opctl": [
        "operator_access_control",
        "OperatorAccessControl",
        "Oracle Database"
    ],
    "opensearch": [
        "opensearch",
        "OpenSearch Service",
        "Others"
    ],
    "opsi": [
        "opsi",
        "Operations Insights",
        "Observability & Management"
    ],
    "optimizer": [
        "optimizer",
        "Cloud Advisor",
        "Others"
    ],
    "organizations": [
        "tenant_manager_control_plane",
        "Organizations",
        "Governance & Administration"
    ],
    "os": [
        "object_storage",
        "Object Storage Service",
        "Storage"
    ],
    "os-management": [
        "os_management",
        "OS Management",
        "Compute"
    ],
    "os-management-hub": [
        "os_management_hub",
        "OS Management Hub",
        "Others"
    ],
    "osp-gateway": [
        "osp_gateway",
        "OSP Gateway",
        "Developer Services"
    ],
    "osub-billing-schedule": [
        "osub_billing_schedule",
        "OneSubscription  Billing Schedule",
        "Billing & Cost Management"
    ],
    "osub-organization-subscription": [
        "osub_organization_subscription",
        "OneSubscription Gateway  Organization's Subscription",
        "Billing & Cost Management"
    ],
    "osub-subscription": [
        "osub_subscription",
        "OneSubscription  Subscription, Commitment and and Rate Card Details",
        "Billing & Cost Management"
    ],
    "osub-usage": [
        "osub_usage",
        "OneSubscription  Usage Computation",
        "Billing & Cost Management"
    ],
    "psql": [
        "psql",
        "PGSQL Control Plane",
        "Others"
    ],
    "queue": [
        "queue",
        "Queue",
        "Others"
    ],
    "recovery": [
        "recovery",
        "Oracle Database Autonomous Recovery Service",
        "Others"
    ],
    "redis": [
        "redis",
        "Redis Service",
        "Others"
    ],
    "resource-manager": [
        "resource_manager",
        "Resource Manager",
        "Developer Services"
    ],
    "resource-scheduler": [
        "resource_scheduler",
        "Resource Scheduler",
        "Others"
    ],
    "rover": [
        "rover",
        "RoverCloudService",
        "Hybrid"
    ],
    "sch": [
        "sch",
        "Connector Hub",
        "Observability & Management"
    ],
    "search": [
        "resource_search",
        "Search Service",
        "Observability & Management"
    ],
    "secrets": [
        "secrets",
        "Vault Secret Retrieval",
        "Others"
    ],
    "service-catalog": [
        "service_catalog",
        "Service Catalog",
        "Observability & Management"
    ],
    "service-manager-proxy": [
        "service_manager_proxy",
        "Service Manager Proxy",
        "Others"
    ],
    "service-mesh": [
        "service_mesh",
        "Service Mesh",
        "Developer Services"
    ],
    "speech": [
        "ai_speech",
        "Speech",
        "Analytics & AI"
    ],
    "stack-monitoring": [
        "stack_monitoring",
        "Stack Monitoring",
        "Developer Services"
    ],
    "streaming": [
        "streaming",
        "Streaming",
        "Analytics & AI"
    ],
    "support": [
        "cims",
        "Support Management",
        "Governance & Administration"
    ],
    "threat-intelligence": [
        "threat_intelligence",
        "Threat Intelligence",
        "Identity & Security"
    ],
    "usage": [
        "usage",
        "Usage Proxy",
        "Governance & Administration"
    ],
    "usage-api": [
        "usage_api",
        "Usage",
        "Governance & Administration"
    ],
    "vault": [
        "vault",
        "Vault Secret Management",
        "Identity & Security"
    ],
    "vbstudio": [
        "vbs_inst",
        "VB Studio Controlplane Instance API",
        "Others"
    ],
    "visual-builder": [
        "visual_builder",
        "Visual Builder",
        "Developer Services"
    ],
    "vn-monitoring": [
        "vn_monitoring",
        "Network Monitoring",
        "Others"
    ],
    "vulnerability-scanning": [
        "vulnerability_scanning",
        "Scanning",
        "Identity & Security"
    ],
    "waa": [
        "waa",
        "Web Application Acceleration (WAA)",
        "Others"
    ],
    "waas": [
        "waas",
        "Web Application Acceleration and Security Services",
        "Others"
    ],
    "waf": [
        "waf",
        "Web Application Firewall (WAF)",
        "Identity & Security"
    ],
    "work-requests": [
        "work_requests",
        "Work Requests",
        "Governance & Administration"
    ]
}
