function GetOciTopLevelCommand_jms() {
    return 'jms'
}

function GetOciSubcommands_jms() {
    $ociSubcommands = @{
        'jms' = 'announcement-collection application-installation-usage-summary application-usage blocklist crypto-analysis-result deployed-application-installation-usage-summary deployed-application-usage drs-file drs-file-collection export-setting export-status fleet fleet-advanced-feature-configuration fleet-agent-configuration fleet-diagnosis-summary installation-site-summary installation-usage java-family java-migration-analysis-result java-release java-server-instance-usage java-server-usage jre-usage library-usage managed-instance-usage performance-tuning-analysis-result work-item-summary work-request work-request-error work-request-log-entry'
        'jms announcement-collection' = 'list-announcements'
        'jms application-installation-usage-summary' = 'summarize-application-installation-usage'
        'jms application-usage' = 'summarize'
        'jms blocklist' = 'create delete list'
        'jms crypto-analysis-result' = 'delete get list'
        'jms deployed-application-installation-usage-summary' = 'summarize-deployed-application-installation-usage'
        'jms deployed-application-usage' = 'summarize'
        'jms drs-file' = 'delete get'
        'jms drs-file-collection' = 'list-drs-files'
        'jms export-setting' = 'get update'
        'jms export-status' = 'get'
        'jms fleet' = 'change-compartment create create-drs-file delete disable-drs enable-drs generate-agent-deploy-script get list request-crypto-analyses request-java-migration-analyses request-jfr-recordings request-performance-tuning-analyses summarize-resource-inventory update update-drs-file'
        'jms fleet-advanced-feature-configuration' = 'get update'
        'jms fleet-agent-configuration' = 'get update'
        'jms fleet-diagnosis-summary' = 'list-fleet-diagnoses'
        'jms installation-site-summary' = 'add list-installation-sites remove'
        'jms installation-usage' = 'summarize'
        'jms java-family' = 'get list'
        'jms java-migration-analysis-result' = 'delete get list'
        'jms java-release' = 'get list'
        'jms java-server-instance-usage' = 'summarize'
        'jms java-server-usage' = 'scan summarize'
        'jms jre-usage' = 'list summarize'
        'jms library-usage' = 'scan summarize'
        'jms managed-instance-usage' = 'summarize'
        'jms performance-tuning-analysis-result' = 'delete get list'
        'jms work-item-summary' = 'list-work-items'
        'jms work-request' = 'cancel get list'
        'jms work-request-error' = 'list'
        'jms work-request-log-entry' = 'list-work-request-logs'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_jms() {
    $ociCommandsToLongParams = @{
        'jms announcement-collection list-announcements' = 'all from-json help limit page page-size sort-by sort-order summary-contains time-end time-start'
        'jms application-installation-usage-summary summarize-application-installation-usage' = 'app-installation-path-contains application-id application-installation-key application-type display-name display-name-contains fleet-id from-json help installation-path jre-distribution jre-vendor jre-version library-key limit managed-instance-id os-family page sort-by sort-order time-end time-start'
        'jms application-usage summarize' = 'application-id application-type display-name display-name-contains fields fleet-id from-json help installation-path jre-distribution jre-vendor jre-version library-key limit managed-instance-id os-family page sort-by sort-order time-end time-start'
        'jms blocklist create' = 'fleet-id from-json help operation reason target'
        'jms blocklist delete' = 'blocklist-key fleet-id force from-json help if-match'
        'jms blocklist list' = 'all fleet-id from-json help limit managed-instance-id operation page page-size sort-by sort-order'
        'jms crypto-analysis-result delete' = 'crypto-analysis-result-id fleet-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'jms crypto-analysis-result get' = 'crypto-analysis-result-id fleet-id from-json help'
        'jms crypto-analysis-result list' = 'aggregation-mode all fleet-id from-json help limit managed-instance-id page page-size sort-by sort-order time-end time-start'
        'jms deployed-application-installation-usage-summary summarize-deployed-application-installation-usage' = 'application-installation-key application-key application-name application-name-contains application-source-path-contains fleet-id from-json help library-key limit managed-instance-id page server-instance-key server-key sort-by sort-order time-end time-start'
        'jms deployed-application-usage summarize' = 'application-key application-name application-name-contains fleet-id from-json help library-key limit managed-instance-id page server-instance-key server-key sort-by sort-order time-end time-start'
        'jms drs-file delete' = 'drs-file-key fleet-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'jms drs-file get' = 'drs-file-key fleet-id from-json help page'
        'jms drs-file-collection list-drs-files' = 'all fleet-id from-json help limit page page-size sort-by sort-order'
        'jms export-setting get' = 'fleet-id from-json help'
        'jms export-setting update' = 'export-duration export-frequency export-resources fleet-id from-json help if-match is-cross-region-acknowledged is-enabled target-bucket-name target-bucket-namespace target-bucket-region'
        'jms export-status get' = 'fleet-id from-json help'
        'jms fleet change-compartment' = 'compartment-id fleet-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'jms fleet create' = 'compartment-id defined-tags description display-name freeform-tags from-json help inventory-log is-advanced-features-enabled max-wait-seconds operation-log wait-for-state wait-interval-seconds'
        'jms fleet create-drs-file' = 'bucket-name drs-file-name fleet-id from-json help if-match max-wait-seconds namespace wait-for-state wait-interval-seconds'
        'jms fleet delete' = 'fleet-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'jms fleet disable-drs' = 'fleet-id from-json help if-match manage-drs-details max-wait-seconds wait-for-state wait-interval-seconds'
        'jms fleet enable-drs' = 'fleet-id from-json help if-match manage-drs-details max-wait-seconds wait-for-state wait-interval-seconds'
        'jms fleet generate-agent-deploy-script' = 'file fleet-id from-json help install-key-id is-user-name-enabled os-family'
        'jms fleet get' = 'fleet-id from-json help'
        'jms fleet list' = 'all compartment-id display-name display-name-contains from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'jms fleet request-crypto-analyses' = 'fleet-id from-json help max-wait-seconds recording-duration-in-minutes targets wait-for-state wait-interval-seconds waiting-period-in-minutes'
        'jms fleet request-java-migration-analyses' = 'fleet-id from-json help max-wait-seconds targets wait-for-state wait-interval-seconds'
        'jms fleet request-jfr-recordings' = 'fleet-id from-json help jfc-profile-name jfc-v1 jfc-v2 max-wait-seconds recording-duration-in-minutes recording-size-in-mb targets wait-for-state wait-interval-seconds waiting-period-in-minutes'
        'jms fleet request-performance-tuning-analyses' = 'fleet-id from-json help max-wait-seconds recording-duration-in-minutes targets wait-for-state wait-interval-seconds waiting-period-in-minutes'
        'jms fleet summarize-resource-inventory' = 'compartment-id from-json help time-end time-start'
        'jms fleet update' = 'defined-tags description display-name fleet-id force freeform-tags from-json help if-match inventory-log is-advanced-features-enabled max-wait-seconds operation-log wait-for-state wait-interval-seconds'
        'jms fleet update-drs-file' = 'bucket-name drs-file-key drs-file-name fleet-id from-json help if-match max-wait-seconds namespace wait-for-state wait-interval-seconds'
        'jms fleet-advanced-feature-configuration get' = 'fleet-id from-json help if-match'
        'jms fleet-advanced-feature-configuration update' = 'advanced-usage-tracking analytic-bucket-name analytic-namespace crypto-event-analysis fleet-id force from-json help if-match java-migration-analysis jfr-recording lcm performance-tuning-analysis'
        'jms fleet-agent-configuration get' = 'fleet-id from-json help'
        'jms fleet-agent-configuration update' = 'agent-polling-interval-in-minutes fleet-id force from-json help if-match jre-scan-frequency jut-processing-frequency linux-configuration mac-os-configuration max-wait-seconds wait-for-state wait-interval-seconds windows-configuration work-request-validity-period-in-days'
        'jms fleet-diagnosis-summary list-fleet-diagnoses' = 'all fleet-id from-json help limit page page-size'
        'jms installation-site-summary add' = 'fleet-id from-json help if-match installation-sites max-wait-seconds post-installation-actions wait-for-state wait-interval-seconds'
        'jms installation-site-summary list-installation-sites' = 'all application-id fleet-id from-json help installation-path jre-distribution jre-security-status jre-vendor jre-version limit managed-instance-id os-family page page-size path-contains sort-by sort-order time-end time-start'
        'jms installation-site-summary remove' = 'fleet-id from-json help if-match installation-sites max-wait-seconds wait-for-state wait-interval-seconds'
        'jms installation-usage summarize' = 'application-id fields fleet-id from-json help installation-path jre-distribution jre-vendor jre-version limit managed-instance-id os-family page path-contains sort-by sort-order time-end time-start'
        'jms java-family get' = 'family-version from-json help'
        'jms java-family list' = 'all display-name family-version from-json help is-supported-version limit page page-size sort-by sort-order'
        'jms java-migration-analysis-result delete' = 'fleet-id force from-json help if-match java-migration-analysis-result-id max-wait-seconds wait-for-state wait-interval-seconds'
        'jms java-migration-analysis-result get' = 'fleet-id from-json help java-migration-analysis-result-id'
        'jms java-migration-analysis-result list' = 'all fleet-id from-json help limit managed-instance-id page page-size sort-by sort-order time-end time-start'
        'jms java-release get' = 'from-json help release-version'
        'jms java-release list' = 'all family-version from-json help jre-security-status license-type limit page page-size release-type release-version sort-by sort-order'
        'jms java-server-instance-usage summarize' = 'application-key fleet-id from-json help library-key limit managed-instance-id page server-instance-key server-instance-name server-instance-name-contains server-key sort-by sort-order time-end time-start'
        'jms java-server-usage scan' = 'fleet-id from-json help if-match managed-instance-ids max-wait-seconds wait-for-state wait-interval-seconds'
        'jms java-server-usage summarize' = 'fleet-id from-json help limit page server-key server-name server-name-contains server-version sort-by sort-order time-end time-start'
        'jms jre-usage list' = 'all application-id application-name compartment-id from-json help host-id limit page page-size sort-by sort-order time-end time-start'
        'jms jre-usage summarize' = 'application-id fields fleet-id from-json help jre-distribution jre-id jre-security-status jre-vendor jre-version limit managed-instance-id os-family page sort-by sort-order time-end time-start'
        'jms library-usage scan' = 'fleet-id from-json help if-match managed-instance-ids max-wait-seconds wait-for-state wait-interval-seconds'
        'jms library-usage summarize' = 'application-key fleet-id from-json help library-key library-name library-name-contains limit managed-instance-id page server-instance-key sort-by sort-order time-end time-start'
        'jms managed-instance-usage summarize' = 'application-id fields fleet-id from-json help hostname-contains installation-path jre-distribution jre-vendor jre-version library-key limit managed-instance-id managed-instance-type os-family page sort-by sort-order time-end time-start'
        'jms performance-tuning-analysis-result delete' = 'fleet-id force from-json help if-match max-wait-seconds performance-tuning-analysis-result-id wait-for-state wait-interval-seconds'
        'jms performance-tuning-analysis-result get' = 'fleet-id from-json help performance-tuning-analysis-result-id'
        'jms performance-tuning-analysis-result list' = 'all application-id fleet-id from-json help limit managed-instance-id page page-size sort-by sort-order time-end time-start'
        'jms work-item-summary list-work-items' = 'all from-json help limit page page-size work-request-id'
        'jms work-request cancel' = 'force from-json help if-match work-request-id'
        'jms work-request get' = 'from-json help work-request-id'
        'jms work-request list' = 'all compartment-id fleet-id from-json help id limit managed-instance-id page page-size'
        'jms work-request-error list' = 'all from-json help limit page page-size work-request-id'
        'jms work-request-log-entry list-work-request-logs' = 'all from-json help limit page page-size work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_jms() {
    $ociCommandsToShortParams = @{
        'jms announcement-collection list-announcements' = '? h'
        'jms application-installation-usage-summary summarize-application-installation-usage' = '? h'
        'jms application-usage summarize' = '? h'
        'jms blocklist create' = '? h'
        'jms blocklist delete' = '? h'
        'jms blocklist list' = '? h'
        'jms crypto-analysis-result delete' = '? h'
        'jms crypto-analysis-result get' = '? h'
        'jms crypto-analysis-result list' = '? h'
        'jms deployed-application-installation-usage-summary summarize-deployed-application-installation-usage' = '? h'
        'jms deployed-application-usage summarize' = '? h'
        'jms drs-file delete' = '? h'
        'jms drs-file get' = '? h'
        'jms drs-file-collection list-drs-files' = '? h'
        'jms export-setting get' = '? h'
        'jms export-setting update' = '? h'
        'jms export-status get' = '? h'
        'jms fleet change-compartment' = '? c h'
        'jms fleet create' = '? c h'
        'jms fleet create-drs-file' = '? h'
        'jms fleet delete' = '? h'
        'jms fleet disable-drs' = '? h'
        'jms fleet enable-drs' = '? h'
        'jms fleet generate-agent-deploy-script' = '? h'
        'jms fleet get' = '? h'
        'jms fleet list' = '? c h'
        'jms fleet request-crypto-analyses' = '? h'
        'jms fleet request-java-migration-analyses' = '? h'
        'jms fleet request-jfr-recordings' = '? h'
        'jms fleet request-performance-tuning-analyses' = '? h'
        'jms fleet summarize-resource-inventory' = '? c h'
        'jms fleet update' = '? h'
        'jms fleet update-drs-file' = '? h'
        'jms fleet-advanced-feature-configuration get' = '? h'
        'jms fleet-advanced-feature-configuration update' = '? h'
        'jms fleet-agent-configuration get' = '? h'
        'jms fleet-agent-configuration update' = '? h'
        'jms fleet-diagnosis-summary list-fleet-diagnoses' = '? h'
        'jms installation-site-summary add' = '? h'
        'jms installation-site-summary list-installation-sites' = '? h'
        'jms installation-site-summary remove' = '? h'
        'jms installation-usage summarize' = '? h'
        'jms java-family get' = '? h'
        'jms java-family list' = '? h'
        'jms java-migration-analysis-result delete' = '? h'
        'jms java-migration-analysis-result get' = '? h'
        'jms java-migration-analysis-result list' = '? h'
        'jms java-release get' = '? h'
        'jms java-release list' = '? h'
        'jms java-server-instance-usage summarize' = '? h'
        'jms java-server-usage scan' = '? h'
        'jms java-server-usage summarize' = '? h'
        'jms jre-usage list' = '? c h'
        'jms jre-usage summarize' = '? h'
        'jms library-usage scan' = '? h'
        'jms library-usage summarize' = '? h'
        'jms managed-instance-usage summarize' = '? h'
        'jms performance-tuning-analysis-result delete' = '? h'
        'jms performance-tuning-analysis-result get' = '? h'
        'jms performance-tuning-analysis-result list' = '? h'
        'jms work-item-summary list-work-items' = '? h'
        'jms work-request cancel' = '? h'
        'jms work-request get' = '? h'
        'jms work-request list' = '? c h'
        'jms work-request-error list' = '? h'
        'jms work-request-log-entry list-work-request-logs' = '? h'
    }
    return $ociCommandsToShortParams
}