function GetOciTopLevelCommand_db() {
    return 'db'
}

function GetOciSubcommands_db() {
    $ociSubcommands = @{
        'db' = 'autonomous-container-database autonomous-container-database-dataguard autonomous-database autonomous-database-backup autonomous-database-dataguard autonomous-database-wallet autonomous-db-preview-version autonomous-db-version autonomous-exadata-infrastructure autonomous-patch autonomous-vm-cluster backup backup-destination cloud-exa-infra cloud-vm-cluster console-connection data-guard-association database database-software-image db-home exadata-infrastructure external-backup-job external-cdb external-db-connector external-non-cdb external-pdb flex-component gi-version key-store maintenance-run node patch patch-history system system-shape upgrade-history version vm-cluster vm-cluster-network'
        'db autonomous-container-database' = 'change-compartment create get list restart rotate-key terminate update'
        'db autonomous-container-database-dataguard' = 'failover get list reinstate switchover'
        'db autonomous-database' = 'change-compartment configure-key create create-autonomous-database-create-virtual-autonomous-database-clone-details create-from-backup-id create-from-backup-timestamp create-from-clone create-refreshable-clone data-safe delete disable-operations-insights enable-operations-insights fail-over generate-wallet get list list-clones manual-refresh restart restore rotate-key start stop switchover update'
        'db autonomous-database data-safe' = 'deregister register'
        'db autonomous-database-backup' = 'create get list'
        'db autonomous-database-dataguard' = 'get list'
        'db autonomous-database-wallet' = 'get-metadata get-regional-wallet-metadata rotate rotate-regional-wallet'
        'db autonomous-db-preview-version' = 'list'
        'db autonomous-db-version' = 'list'
        'db autonomous-exadata-infrastructure' = 'change-compartment get launch list rotate-ords-certs rotate-ssl-certs shape terminate update'
        'db autonomous-exadata-infrastructure shape' = 'list'
        'db autonomous-patch' = 'get list-container-database-patches'
        'db autonomous-vm-cluster' = 'change-compartment create delete get list update'
        'db backup' = 'create delete get list'
        'db backup-destination' = 'change-compartment create-nfs-details create-recovery-appliance-details delete get update'
        'db cloud-exa-infra' = 'change-compartment create delete get list update'
        'db cloud-vm-cluster' = 'change-compartment create delete get get-exadata-iorm-config get-update get-update-history list list-update-histories list-updates update update-exadata-iorm-config'
        'db console-connection' = 'create delete get list'
        'db data-guard-association' = 'create failover get list reinstate switchover'
        'db data-guard-association create' = 'from-existing-db-system from-existing-vm-cluster with-new-db-system'
        'db database' = 'create create-database-from-backup create-from-backup create-from-database delete get list list-upgrade-history migrate-vault-key patch restore rotate-vault-key update upgrade upgrade-rollback upgrade-with-database-software-image upgrade-with-db-home upgrade-with-db-version'
        'db database-software-image' = 'change-compartment create delete get list update'
        'db db-home' = 'create delete get list update'
        'db exadata-infrastructure' = 'activate add-storage-capacity change-compartment create delete download-config-file generate-recommended-vm-cluster-network get get-compute-units list update'
        'db external-backup-job' = 'complete create get'
        'db external-cdb' = 'change-compartment create delete disable-db-management enable-db-management get list list-external-pdbs scan-pluggable-databases update'
        'db external-db-connector' = 'check-connection-status create-macs-connector delete get list update update-macs-connector'
        'db external-non-cdb' = 'change-compartment create delete disable-db-management disable-operations-insights enable-db-management enable-operations-insights get list update'
        'db external-pdb' = 'change-compartment create delete disable-db-management disable-operations-insights enable-db-management enable-operations-insights get update'
        'db flex-component' = 'list'
        'db gi-version' = 'list'
        'db key-store' = 'change-compartment create-oracle-key-vault-details delete get list update-oracle-key-vault-details'
        'db maintenance-run' = 'get list update'
        'db node' = 'get list reset soft-reset start stop'
        'db patch' = 'get get-db-home get-vm-cluster list list-db-home list-vm-cluster'
        'db patch get' = 'by-database by-db-system'
        'db patch list' = 'by-database by-db-system'
        'db patch-history' = 'get get-db-home get-vm-cluster list list-db-home list-vm-cluster'
        'db patch-history get' = 'by-database by-db-system'
        'db patch-history list' = 'by-database by-db-system'
        'db system' = 'change-compartment get get-exadata-iorm-config launch launch-from-backup launch-from-db-system list patch switch terminate update update-exadata-iorm-config'
        'db system-shape' = 'list'
        'db upgrade-history' = 'get'
        'db version' = 'list'
        'db vm-cluster' = 'change-compartment create delete get list update'
        'db vm-cluster-network' = 'create delete download-vm-cluster-network-config-file get list update validate'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_db() {
    $ociCommandsToLongParams = @{
        'db autonomous-container-database change-compartment' = 'autonomous-container-database-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database create' = 'autonomous-exadata-infrastructure-id autonomous-vm-cluster-id backup-config compartment-id db-unique-name defined-tags display-name freeform-tags from-json help key-store-id kms-key-id kms-key-version-id maintenance-window-details max-wait-seconds patch-model peer-autonomous-container-database-backup-config peer-autonomous-container-database-compartment-id peer-autonomous-container-database-display-name peer-autonomous-exadata-infrastructure-id peer-autonomous-vm-cluster-id peer-db-unique-name protection-mode service-level-agreement-type standby-maintenance-buffer-in-days vault-id wait-for-state wait-interval-seconds'
        'db autonomous-container-database get' = 'autonomous-container-database-id from-json help'
        'db autonomous-container-database list' = 'all autonomous-exadata-infrastructure-id autonomous-vm-cluster-id availability-domain compartment-id display-name from-json help infrastructure-type lifecycle-state limit page page-size service-level-agreement-type sort-by sort-order'
        'db autonomous-container-database restart' = 'autonomous-container-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database rotate-key' = 'autonomous-container-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database terminate' = 'autonomous-container-database-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database update' = 'autonomous-container-database-id backup-config defined-tags display-name force freeform-tags from-json help if-match maintenance-window-details max-wait-seconds patch-model standby-maintenance-buffer-in-days wait-for-state wait-interval-seconds'
        'db autonomous-container-database-dataguard failover' = 'autonomous-container-database-dataguard-association-id autonomous-container-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database-dataguard get' = 'autonomous-container-database-dataguard-association-id autonomous-container-database-id from-json help'
        'db autonomous-container-database-dataguard list' = 'all autonomous-container-database-id from-json help limit page page-size'
        'db autonomous-container-database-dataguard reinstate' = 'autonomous-container-database-dataguard-association-id autonomous-container-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-container-database-dataguard switchover' = 'autonomous-container-database-dataguard-association-id autonomous-container-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database change-compartment' = 'autonomous-database-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database configure-key' = 'autonomous-database-id from-json help if-match is-using-oracle-managed-keys kms-key-id max-wait-seconds vault-id wait-for-state wait-interval-seconds'
        'db autonomous-database create' = 'admin-password autonomous-container-database-id compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-acl-enabled is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label subnet-id vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database create-autonomous-database-create-virtual-autonomous-database-clone-details' = 'admin-password autonomous-container-database-id compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-access-control-enabled is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label source-id subnet-id vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database create-from-backup-id' = 'admin-password autonomous-container-database-id autonomous-database-backup-id clone-type compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label subnet-id vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database create-from-backup-timestamp' = 'admin-password autonomous-container-database-id autonomous-database-id clone-type compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label subnet-id timestamp vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database create-from-clone' = 'admin-password autonomous-container-database-id clone-type compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-acl-enabled is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label source-id subnet-id vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database create-refreshable-clone' = 'admin-password autonomous-container-database-id compartment-id cpu-core-count data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name freeform-tags from-json help is-auto-scaling-enabled is-data-guard-enabled is-dedicated is-free-tier is-preview-version-with-service-terms-accepted kms-key-id license-model max-wait-seconds nsg-ids private-endpoint-label refreshable-mode source-id subnet-id vault-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database data-safe deregister' = 'autonomous-database-id from-json help max-wait-seconds pdb-admin-password wait-for-state wait-interval-seconds'
        'db autonomous-database data-safe register' = 'autonomous-database-id from-json help max-wait-seconds pdb-admin-password wait-for-state wait-interval-seconds'
        'db autonomous-database delete' = 'autonomous-database-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database disable-operations-insights' = 'autonomous-database-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database enable-operations-insights' = 'autonomous-database-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database fail-over' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database generate-wallet' = 'autonomous-database-id file from-json generate-type help password'
        'db autonomous-database get' = 'autonomous-database-id from-json help'
        'db autonomous-database list' = 'all autonomous-container-database-id compartment-id db-version db-workload display-name from-json help infrastructure-type is-data-guard-enabled is-free-tier is-refreshable-clone lifecycle-state limit page page-size sort-by sort-order'
        'db autonomous-database list-clones' = 'all autonomous-database-id clone-type compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db autonomous-database manual-refresh' = 'autonomous-database-id from-json help if-match max-wait-seconds time-refresh-cutoff wait-for-state wait-interval-seconds'
        'db autonomous-database restart' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database restore' = 'autonomous-database-id database-scn from-json help if-match latest max-wait-seconds timestamp wait-for-state wait-interval-seconds'
        'db autonomous-database rotate-key' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database start' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database stop' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database switchover' = 'autonomous-database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database update' = 'admin-password are-primary-whitelisted-ips-used autonomous-database-id cpu-core-count customer-contacts data-storage-size-in-tbs db-name db-version db-workload defined-tags display-name force freeform-tags from-json help if-match is-acl-enabled is-auto-scaling-enabled is-data-guard-enabled is-free-tier is-refreshable-clone license-model max-wait-seconds nsg-ids open-mode permission-level private-endpoint-label refreshable-mode standby-whitelisted-ips subnet-id wait-for-state wait-interval-seconds whitelisted-ips'
        'db autonomous-database-backup create' = 'autonomous-database-id display-name from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-database-backup get' = 'autonomous-database-backup-id from-json help'
        'db autonomous-database-backup list' = 'all autonomous-database-id compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db autonomous-database-dataguard get' = 'autonomous-database-dataguard-association-id autonomous-database-id from-json help'
        'db autonomous-database-dataguard list' = 'all autonomous-database-id from-json help limit page page-size'
        'db autonomous-database-wallet get-metadata' = 'from-json help id'
        'db autonomous-database-wallet get-regional-wallet-metadata' = 'from-json help'
        'db autonomous-database-wallet rotate' = 'from-json help id max-wait-seconds should-rotate wait-for-state wait-interval-seconds'
        'db autonomous-database-wallet rotate-regional-wallet' = 'from-json help max-wait-seconds should-rotate wait-for-state wait-interval-seconds'
        'db autonomous-db-preview-version list' = 'all compartment-id from-json help limit page page-size sort-by sort-order'
        'db autonomous-db-version list' = 'all compartment-id db-workload from-json help limit page page-size sort-order'
        'db autonomous-exadata-infrastructure change-compartment' = 'autonomous-exadata-infrastructure-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-exadata-infrastructure get' = 'autonomous-exadata-infrastructure-id from-json help'
        'db autonomous-exadata-infrastructure launch' = 'availability-domain compartment-id defined-tags display-name domain freeform-tags from-json help license-model maintenance-window-details max-wait-seconds nsg-ids shape subnet-id wait-for-state wait-interval-seconds'
        'db autonomous-exadata-infrastructure list' = 'all availability-domain compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db autonomous-exadata-infrastructure rotate-ords-certs' = 'autonomous-exadata-infrastructure-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-exadata-infrastructure rotate-ssl-certs' = 'autonomous-exadata-infrastructure-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-exadata-infrastructure shape list' = 'all availability-domain compartment-id from-json help limit page page-size'
        'db autonomous-exadata-infrastructure terminate' = 'autonomous-exadata-infrastructure-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-exadata-infrastructure update' = 'autonomous-exadata-infrastructure-id defined-tags display-name force freeform-tags from-json help if-match maintenance-window-details max-wait-seconds nsg-ids wait-for-state wait-interval-seconds'
        'db autonomous-patch get' = 'autonomous-patch-id from-json help'
        'db autonomous-patch list-container-database-patches' = 'all autonomous-container-database-id compartment-id from-json help limit page page-size'
        'db autonomous-vm-cluster change-compartment' = 'autonomous-vm-cluster-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-vm-cluster create' = 'compartment-id defined-tags display-name exadata-infrastructure-id freeform-tags from-json help is-local-backup-enabled license-model max-wait-seconds time-zone vm-cluster-network-id wait-for-state wait-interval-seconds'
        'db autonomous-vm-cluster delete' = 'autonomous-vm-cluster-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db autonomous-vm-cluster get' = 'autonomous-vm-cluster-id from-json help'
        'db autonomous-vm-cluster list' = 'all compartment-id display-name exadata-infrastructure-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db autonomous-vm-cluster update' = 'autonomous-vm-cluster-id defined-tags force freeform-tags from-json help if-match license-model max-wait-seconds wait-for-state wait-interval-seconds'
        'db backup create' = 'database-id display-name from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db backup delete' = 'backup-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db backup get' = 'backup-id from-json help'
        'db backup list' = 'all compartment-id database-id from-json help limit page page-size'
        'db backup-destination change-compartment' = 'backup-destination-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db backup-destination create-nfs-details' = 'compartment-id defined-tags display-name freeform-tags from-json help local-mount-point-path max-wait-seconds mount-type-details wait-for-state wait-interval-seconds'
        'db backup-destination create-recovery-appliance-details' = 'compartment-id connection-string defined-tags display-name freeform-tags from-json help max-wait-seconds vpc-users wait-for-state wait-interval-seconds'
        'db backup-destination delete' = 'backup-destination-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db backup-destination get' = 'backup-destination-id from-json help'
        'db backup-destination update' = 'backup-destination-id connection-string defined-tags force freeform-tags from-json help if-match local-mount-point-path max-wait-seconds nfs-mount-type nfs-server nfs-server-export vpc-users wait-for-state wait-interval-seconds'
        'db cloud-exa-infra change-compartment' = 'cloud-exa-infra-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db cloud-exa-infra create' = 'availability-domain compartment-id compute-count defined-tags display-name freeform-tags from-json help maintenance-window max-wait-seconds shape storage-count wait-for-state wait-interval-seconds'
        'db cloud-exa-infra delete' = 'cloud-exa-infra-id force from-json help if-match is-delete-vm-clusters max-wait-seconds wait-for-state wait-interval-seconds'
        'db cloud-exa-infra get' = 'cloud-exa-infra-id from-json help'
        'db cloud-exa-infra list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db cloud-exa-infra update' = 'cloud-exa-infra-id compute-count defined-tags display-name force freeform-tags from-json help if-match maintenance-window max-wait-seconds storage-count wait-for-state wait-interval-seconds'
        'db cloud-vm-cluster change-compartment' = 'cloud-vm-cluster-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db cloud-vm-cluster create' = 'backup-network-nsg-ids backup-subnet-id cloud-exa-infra-id cluster-name compartment-id cpu-core-count data-storage-percentage defined-tags display-name domain freeform-tags from-json gi-version help hostname is-local-backup is-sparse-diskgroup license-model max-wait-seconds nsg-ids ssh-authorized-keys-file subnet-id time-zone wait-for-state wait-interval-seconds'
        'db cloud-vm-cluster delete' = 'cloud-vm-cluster-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db cloud-vm-cluster get' = 'cloud-vm-cluster-id from-json help'
        'db cloud-vm-cluster get-exadata-iorm-config' = 'cloud-vm-cluster-id from-json help'
        'db cloud-vm-cluster get-update' = 'cloud-vm-cluster-id from-json help update-id'
        'db cloud-vm-cluster get-update-history' = 'cloud-vm-cluster-id from-json help update-history-entry-id'
        'db cloud-vm-cluster list' = 'all cloud-exa-infra-id compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db cloud-vm-cluster list-update-histories' = 'all cloud-vm-cluster-id from-json help limit page page-size update-type'
        'db cloud-vm-cluster list-updates' = 'all cloud-vm-cluster-id from-json help limit page page-size update-type'
        'db cloud-vm-cluster update' = 'backup-network-nsg-ids cloud-vm-cluster-id compute-nodes cpu-core-count defined-tags display-name force freeform-tags from-json help if-match license-model max-wait-seconds nsg-ids ssh-authorized-keys-file storage-size-in-gbs update-action update-id wait-for-state wait-interval-seconds'
        'db cloud-vm-cluster update-exadata-iorm-config' = 'cloud-vm-cluster-id db-plans force from-json help if-match objective'
        'db console-connection create' = 'db-node-id from-json help max-wait-seconds public-key wait-for-state wait-interval-seconds'
        'db console-connection delete' = 'console-connection-id db-node-id force from-json help if-match'
        'db console-connection get' = 'console-connection-id db-node-id from-json help'
        'db console-connection list' = 'all db-node-id from-json help'
        'db data-guard-association create from-existing-db-system' = 'creation-type database-admin-password database-id database-software-image-id from-json help peer-db-home-id peer-db-system-id protection-mode transport-type'
        'db data-guard-association create from-existing-vm-cluster' = 'database-admin-password database-id database-software-image-id from-json help peer-db-home-id peer-vm-cluster-id protection-mode transport-type'
        'db data-guard-association create with-new-db-system' = 'availability-domain creation-type database-admin-password database-id database-software-image-id display-name from-json help hostname protection-mode shape subnet-id transport-type'
        'db data-guard-association failover' = 'data-guard-association-id database-admin-password database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db data-guard-association get' = 'data-guard-association-id database-id from-json help'
        'db data-guard-association list' = 'all database-id from-json help limit page page-size'
        'db data-guard-association reinstate' = 'data-guard-association-id database-admin-password database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db data-guard-association switchover' = 'data-guard-association-id database-admin-password database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database create' = 'admin-password auto-backup-enabled auto-backup-window backup-destination character-set database-software-image-id db-home-id db-name db-system-id db-unique-name db-version db-workload defined-tags freeform-tags from-json help kms-key-id kms-key-version-id max-wait-seconds ncharacter-set pdb-name recovery-window-in-days source tde-wallet-password vm-cluster-id wait-for-state wait-interval-seconds'
        'db database create-database-from-backup' = 'database db-home-id db-version from-json help kms-key-id kms-key-version-id max-wait-seconds wait-for-state wait-interval-seconds'
        'db database create-from-backup' = 'admin-password backup-id backup-tde-password database-software-image-id db-name db-system-id db-unique-name defined-tags freeform-tags from-json help kms-key-id kms-key-version-id max-wait-seconds vm-cluster-id wait-for-state wait-interval-seconds'
        'db database create-from-database' = 'admin-password backup-tde-password database-id database-software-image-id db-name db-system-id defined-tags freeform-tags from-json help kms-key-id kms-key-version-id max-wait-seconds point-in-time-recovery-timestamp wait-for-state wait-interval-seconds'
        'db database delete' = 'database-id force from-json help'
        'db database get' = 'database-id from-json help'
        'db database list' = 'backup-id compartment-id db-system-id display-name from-json help lifecycle-state limit sort-by sort-order vm-cluster-id'
        'db database list-upgrade-history' = 'all database-id from-json help lifecycle-state limit page page-size sort-by sort-order upgrade-action'
        'db database migrate-vault-key' = 'database-id from-json help if-match kms-key-id kms-key-version-id max-wait-seconds wait-for-state wait-interval-seconds'
        'db database patch' = 'database-id database-software-image-id from-json help one-off-patches patch-action patch-id'
        'db database restore' = 'database-id database-scn from-json help if-match latest max-wait-seconds timestamp wait-for-state wait-interval-seconds'
        'db database rotate-vault-key' = 'database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database update' = 'auto-backup-enabled auto-backup-window backup-destination database-id db-home-id defined-tags force freeform-tags from-json help if-match max-wait-seconds new-admin-password new-tde-wallet-password old-tde-wallet-password recovery-window-in-days wait-for-state wait-interval-seconds'
        'db database upgrade' = 'action database-id database-upgrade-source-details from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database upgrade-rollback' = 'database-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database upgrade-with-database-software-image' = 'action database-id database-software-image-id from-json help if-match max-wait-seconds options wait-for-state wait-interval-seconds'
        'db database upgrade-with-db-home' = 'action database-id db-home-id from-json help if-match max-wait-seconds options wait-for-state wait-interval-seconds'
        'db database upgrade-with-db-version' = 'action database-id db-version from-json help if-match max-wait-seconds options wait-for-state wait-interval-seconds'
        'db database-software-image change-compartment' = 'compartment-id database-software-image-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database-software-image create' = 'compartment-id database-software-image-one-off-patches database-version defined-tags display-name freeform-tags from-json help image-shape-family image-type ls-inventory max-wait-seconds patch-set wait-for-state wait-interval-seconds'
        'db database-software-image delete' = 'database-software-image-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db database-software-image get' = 'database-software-image-id from-json help'
        'db database-software-image list' = 'all compartment-id display-name from-json help image-shape-family image-type is-upgrade-supported lifecycle-state limit page page-size sort-by sort-order'
        'db database-software-image update' = 'database-software-image-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db db-home create' = 'database-software-image-id db-system-id db-version defined-tags display-name freeform-tags from-json help kms-key-id kms-key-version-id max-wait-seconds source vm-cluster-id wait-for-state wait-interval-seconds'
        'db db-home delete' = 'db-home-id force from-json help if-match max-wait-seconds perform-final-backup wait-for-state wait-interval-seconds'
        'db db-home get' = 'db-home-id from-json help'
        'db db-home list' = 'all backup-id compartment-id db-system-id db-version display-name from-json help lifecycle-state limit page page-size sort-by sort-order vm-cluster-id'
        'db db-home update' = 'db-home-id db-version defined-tags force freeform-tags from-json help if-match max-wait-seconds one-off-patches wait-for-state wait-interval-seconds'
        'db exadata-infrastructure activate' = 'activation-file exadata-infrastructure-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db exadata-infrastructure add-storage-capacity' = 'exadata-infrastructure-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db exadata-infrastructure change-compartment' = 'compartment-id exadata-infrastructure-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db exadata-infrastructure create' = 'admin-network-cidr cloud-control-plane-server1 cloud-control-plane-server2 compartment-id compute-count contacts corporate-proxy defined-tags display-name dns-server freeform-tags from-json gateway help infini-band-network-cidr maintenance-window max-wait-seconds netmask ntp-server shape storage-count time-zone wait-for-state wait-interval-seconds'
        'db exadata-infrastructure delete' = 'exadata-infrastructure-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db exadata-infrastructure download-config-file' = 'exadata-infrastructure-id file from-json help'
        'db exadata-infrastructure generate-recommended-vm-cluster-network' = 'compartment-id defined-tags display-name dns exadata-infrastructure-id freeform-tags from-json help networks ntp'
        'db exadata-infrastructure get' = 'exadata-infrastructure-id from-json help'
        'db exadata-infrastructure get-compute-units' = 'autonomous-exadata-infrastructure-id from-json help'
        'db exadata-infrastructure list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db exadata-infrastructure update' = 'additional-storage-count admin-network-cidr cloud-control-plane-server1 cloud-control-plane-server2 contacts corporate-proxy defined-tags dns-server exadata-infrastructure-id force freeform-tags from-json gateway help if-match infini-band-network-cidr maintenance-window max-wait-seconds netmask ntp-server time-zone wait-for-state wait-interval-seconds'
        'db external-backup-job complete' = 'backup-id cf-backup-handle data-size from-json help if-match redo-size spf-backup-handle sql-patches tde-wallet-path'
        'db external-backup-job create' = 'availability-domain character-set compartment-id database-edition database-mode db-name db-unique-name db-version display-name external-database-identifier from-json help ncharacter-set pdb-name'
        'db external-backup-job get' = 'backup-id from-json help'
        'db external-cdb change-compartment' = 'compartment-id external-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb delete' = 'external-cdb-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb disable-db-management' = 'external-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb enable-db-management' = 'external-cdb-id external-db-connector-id from-json help if-match license-model max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb get' = 'external-cdb-id from-json help'
        'db external-cdb list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db external-cdb list-external-pdbs' = 'all compartment-id display-name external-cdb-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db external-cdb scan-pluggable-databases' = 'external-cdb-id external-db-connector-id from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-cdb update' = 'defined-tags display-name external-cdb-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-db-connector check-connection-status' = 'external-db-connector-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-db-connector create-macs-connector' = 'connection-credentials connection-string connector-agent-id defined-tags display-name external-database-id freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-db-connector delete' = 'external-db-connector-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-db-connector get' = 'external-db-connector-id from-json help'
        'db external-db-connector list' = 'all compartment-id display-name external-database-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db external-db-connector update' = 'connector-type defined-tags display-name external-db-connector-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-db-connector update-macs-connector' = 'connection-credentials connection-string defined-tags display-name external-db-connector-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb change-compartment' = 'compartment-id external-non-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb delete' = 'external-non-cdb-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb disable-db-management' = 'external-non-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb disable-operations-insights' = 'external-non-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb enable-db-management' = 'external-db-connector-id external-non-cdb-id from-json help if-match license-model max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb enable-operations-insights' = 'external-db-connector-id external-non-cdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-non-cdb get' = 'external-non-cdb-id from-json help'
        'db external-non-cdb list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db external-non-cdb update' = 'defined-tags display-name external-non-cdb-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb change-compartment' = 'compartment-id external-pdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb create' = 'compartment-id defined-tags display-name external-cdb-id freeform-tags from-json help max-wait-seconds source-id wait-for-state wait-interval-seconds'
        'db external-pdb delete' = 'external-pdb-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb disable-db-management' = 'external-pdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb disable-operations-insights' = 'external-pdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb enable-db-management' = 'external-db-connector-id external-pdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb enable-operations-insights' = 'external-db-connector-id external-pdb-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db external-pdb get' = 'external-pdb-id from-json help'
        'db external-pdb update' = 'defined-tags display-name external-pdb-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db flex-component list' = 'all compartment-id from-json help limit name page page-size sort-by sort-order'
        'db gi-version list' = 'all compartment-id from-json help limit page page-size shape sort-order'
        'db key-store change-compartment' = 'compartment-id from-json help if-match key-store-id max-wait-seconds wait-for-state wait-interval-seconds'
        'db key-store create-oracle-key-vault-details' = 'admin-username compartment-id connection-ips defined-tags display-name freeform-tags from-json help max-wait-seconds secret-id vault-id wait-for-state wait-interval-seconds'
        'db key-store delete' = 'force from-json help if-match key-store-id max-wait-seconds wait-for-state wait-interval-seconds'
        'db key-store get' = 'from-json help key-store-id'
        'db key-store list' = 'all compartment-id from-json help limit page page-size'
        'db key-store update-oracle-key-vault-details' = 'admin-username connection-ips defined-tags force freeform-tags from-json help if-match key-store-id max-wait-seconds secret-id vault-id wait-for-state wait-interval-seconds'
        'db maintenance-run get' = 'from-json help maintenance-run-id'
        'db maintenance-run list' = 'all availability-domain compartment-id from-json help lifecycle-state limit maintenance-type page page-size sort-by sort-order target-resource-id target-resource-type'
        'db maintenance-run update' = 'from-json help if-match is-enabled is-patch-now-enabled maintenance-run-id max-wait-seconds patch-id patching-mode time-scheduled wait-for-state wait-interval-seconds'
        'db node get' = 'db-node-id from-json help'
        'db node list' = 'all compartment-id db-system-id from-json help lifecycle-state limit page page-size sort-by sort-order vm-cluster-id'
        'db node reset' = 'db-node-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db node soft-reset' = 'db-node-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db node start' = 'db-node-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db node stop' = 'db-node-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db patch get by-database' = 'database-id from-json help patch-id'
        'db patch get by-db-system' = 'db-system-id from-json help patch-id'
        'db patch get-db-home' = 'db-home-id from-json help patch-id'
        'db patch get-vm-cluster' = 'from-json help patch-id vm-cluster-id'
        'db patch list by-database' = 'all database-id from-json help limit page page-size'
        'db patch list by-db-system' = 'all db-system-id from-json help limit page page-size'
        'db patch list-db-home' = 'all db-home-id from-json help limit page page-size'
        'db patch list-vm-cluster' = 'all from-json help limit page page-size vm-cluster-id'
        'db patch-history get by-database' = 'database-id from-json help patch-history-entry-id'
        'db patch-history get by-db-system' = 'db-system-id from-json help patch-history-entry-id'
        'db patch-history get-db-home' = 'db-home-id from-json help patch-history-entry-id'
        'db patch-history get-vm-cluster' = 'from-json help patch-history-entry-id vm-cluster-id'
        'db patch-history list by-database' = 'all database-id from-json help limit page page-size'
        'db patch-history list by-db-system' = 'all db-system-id from-json help limit page page-size'
        'db patch-history list-db-home' = 'all db-home-id from-json help limit page page-size'
        'db patch-history list-vm-cluster' = 'all from-json help limit page page-size vm-cluster-id'
        'db system change-compartment' = 'compartment-id db-system-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db system get' = 'db-system-id from-json help'
        'db system get-exadata-iorm-config' = 'db-system-id from-json help'
        'db system launch' = 'admin-password auto-backup-enabled availability-domain backup-network-nsg-ids backup-subnet-id character-set cluster-name compartment-id cpu-core-count data-storage-percentage database-edition database-software-image-id db-name db-unique-name db-version db-workload defined-tags disk-redundancy display-name domain fault-domains freeform-tags from-json help hostname initial-data-storage-size-in-gb kms-key-id kms-key-version-id license-model maintenance-window-details max-wait-seconds ncharacter-set node-count nsg-ids pdb-name private-ip recovery-window-in-days shape sparse-diskgroup ssh-authorized-keys-file storage-management subnet-id tde-wallet-password time-zone wait-for-state wait-interval-seconds'
        'db system launch-from-backup' = 'admin-password availability-domain backup-id backup-network-nsg-ids backup-subnet-id backup-tde-password cluster-name compartment-id cpu-core-count data-storage-percentage database-edition db-name db-unique-name defined-tags disk-redundancy display-name domain fault-domains freeform-tags from-json help hostname initial-data-storage-size-in-gb kms-key-id kms-key-version-id license-model max-wait-seconds node-count nsg-ids private-ip shape sparse-diskgroup ssh-authorized-keys-file storage-management subnet-id time-zone wait-for-state wait-interval-seconds'
        'db system launch-from-db-system' = 'availability-domain backup-network-nsg-ids backup-subnet-id cluster-name compartment-id cpu-core-count data-storage-percentage db-home db-system-options defined-tags display-name domain fault-domains freeform-tags from-json help hostname initial-data-storage-size-in-gb kms-key-id kms-key-version-id license-model max-wait-seconds node-count nsg-ids private-ip shape source-db-system-id sparse-diskgroup ssh-public-keys subnet-id time-zone wait-for-state wait-interval-seconds'
        'db system list' = 'all availability-domain backup-id compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db system patch' = 'db-system-id from-json help patch-action patch-id'
        'db system switch' = 'db-system-id from-json help if-match'
        'db system terminate' = 'db-system-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'db system update' = 'backup-network-nsg-ids cpu-core-count data-storage-size-in-gbs db-system-id defined-tags force freeform-tags from-json help if-match license-model maintenance-window-details max-wait-seconds nsg-ids patch-action patch-id shape ssh-authorized-keys-file wait-for-state wait-interval-seconds'
        'db system update-exadata-iorm-config' = 'db-plans db-system-id force from-json help if-match max-wait-seconds objective wait-for-state wait-interval-seconds'
        'db system-shape list' = 'all availability-domain compartment-id from-json help limit page page-size'
        'db upgrade-history get' = 'database-id from-json help upgrade-history-id'
        'db version list' = 'all compartment-id db-system-id db-system-shape from-json help is-upgrade-supported limit page page-size storage-management'
        'db vm-cluster change-compartment' = 'compartment-id from-json help if-match max-wait-seconds vm-cluster-id wait-for-state wait-interval-seconds'
        'db vm-cluster create' = 'compartment-id cpu-core-count data-storage-size-in-tbs db-node-storage-size-in-gbs defined-tags display-name exadata-infrastructure-id freeform-tags from-json gi-version help is-local-backup-enabled is-sparse-diskgroup-enabled license-model max-wait-seconds memory-size-in-gbs ssh-public-keys time-zone vm-cluster-network-id wait-for-state wait-interval-seconds'
        'db vm-cluster delete' = 'force from-json help if-match max-wait-seconds vm-cluster-id wait-for-state wait-interval-seconds'
        'db vm-cluster get' = 'from-json help vm-cluster-id'
        'db vm-cluster list' = 'all compartment-id display-name exadata-infrastructure-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db vm-cluster update' = 'cpu-core-count data-storage-size-in-tbs db-node-storage-size-in-gbs defined-tags force freeform-tags from-json help if-match license-model max-wait-seconds memory-size-in-gbs patch-action patch-id ssh-public-keys vm-cluster-id wait-for-state wait-interval-seconds'
        'db vm-cluster-network create' = 'compartment-id defined-tags display-name dns exadata-infrastructure-id freeform-tags from-json help max-wait-seconds ntp scans vm-networks wait-for-state wait-interval-seconds'
        'db vm-cluster-network delete' = 'exadata-infrastructure-id force from-json help if-match max-wait-seconds vm-cluster-network-id wait-for-state wait-interval-seconds'
        'db vm-cluster-network download-vm-cluster-network-config-file' = 'exadata-infrastructure-id file from-json help vm-cluster-network-id'
        'db vm-cluster-network get' = 'exadata-infrastructure-id from-json help vm-cluster-network-id'
        'db vm-cluster-network list' = 'all compartment-id display-name exadata-infrastructure-id from-json help lifecycle-state limit page page-size sort-by sort-order'
        'db vm-cluster-network update' = 'defined-tags dns exadata-infrastructure-id force freeform-tags from-json help if-match max-wait-seconds ntp scans vm-cluster-network-id vm-networks wait-for-state wait-interval-seconds'
        'db vm-cluster-network validate' = 'exadata-infrastructure-id from-json help max-wait-seconds vm-cluster-network-id wait-for-state wait-interval-seconds'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_db() {
    $ociCommandsToShortParams = @{
        'db autonomous-container-database change-compartment' = '? c h'
        'db autonomous-container-database create' = '? c h'
        'db autonomous-container-database get' = '? h'
        'db autonomous-container-database list' = '? c h'
        'db autonomous-container-database restart' = '? h'
        'db autonomous-container-database rotate-key' = '? h'
        'db autonomous-container-database terminate' = '? h'
        'db autonomous-container-database update' = '? h'
        'db autonomous-container-database-dataguard failover' = '? h'
        'db autonomous-container-database-dataguard get' = '? h'
        'db autonomous-container-database-dataguard list' = '? h'
        'db autonomous-container-database-dataguard reinstate' = '? h'
        'db autonomous-container-database-dataguard switchover' = '? h'
        'db autonomous-database change-compartment' = '? c h'
        'db autonomous-database configure-key' = '? h'
        'db autonomous-database create' = '? c h'
        'db autonomous-database create-from-backup-id' = '? c h'
        'db autonomous-database create-from-backup-timestamp' = '? c h'
        'db autonomous-database create-from-clone' = '? c h'
        'db autonomous-database create-refreshable-clone' = '? c h'
        'db autonomous-database data-safe deregister' = '? h'
        'db autonomous-database data-safe register' = '? h'
        'db autonomous-database delete' = '? h'
        'db autonomous-database disable-operations-insights' = '? h'
        'db autonomous-database enable-operations-insights' = '? h'
        'db autonomous-database fail-over' = '? h'
        'db autonomous-database generate-wallet' = '? h'
        'db autonomous-database get' = '? h'
        'db autonomous-database list' = '? c h'
        'db autonomous-database list-clones' = '? c h'
        'db autonomous-database manual-refresh' = '? h'
        'db autonomous-database restart' = '? h'
        'db autonomous-database restore' = '? h'
        'db autonomous-database rotate-key' = '? h'
        'db autonomous-database start' = '? h'
        'db autonomous-database stop' = '? h'
        'db autonomous-database switchover' = '? h'
        'db autonomous-database update' = '? h'
        'db autonomous-database-backup create' = '? h'
        'db autonomous-database-backup get' = '? h'
        'db autonomous-database-backup list' = '? c h'
        'db autonomous-database-dataguard get' = '? h'
        'db autonomous-database-dataguard list' = '? h'
        'db autonomous-database-wallet get-metadata' = '? h'
        'db autonomous-database-wallet get-regional-wallet-metadata' = '? h'
        'db autonomous-database-wallet rotate' = '? h'
        'db autonomous-database-wallet rotate-regional-wallet' = '? h'
        'db autonomous-db-preview-version list' = '? c h'
        'db autonomous-db-version list' = '? c h'
        'db autonomous-exadata-infrastructure change-compartment' = '? c h'
        'db autonomous-exadata-infrastructure get' = '? h'
        'db autonomous-exadata-infrastructure launch' = '? c h'
        'db autonomous-exadata-infrastructure list' = '? c h'
        'db autonomous-exadata-infrastructure rotate-ords-certs' = '? h'
        'db autonomous-exadata-infrastructure rotate-ssl-certs' = '? h'
        'db autonomous-exadata-infrastructure shape list' = '? c h'
        'db autonomous-exadata-infrastructure terminate' = '? h'
        'db autonomous-exadata-infrastructure update' = '? h'
        'db autonomous-patch get' = '? h'
        'db autonomous-patch list-container-database-patches' = '? c h'
        'db autonomous-vm-cluster change-compartment' = '? c h'
        'db autonomous-vm-cluster create' = '? c h'
        'db autonomous-vm-cluster delete' = '? h'
        'db autonomous-vm-cluster get' = '? h'
        'db autonomous-vm-cluster list' = '? c h'
        'db autonomous-vm-cluster update' = '? h'
        'db backup create' = '? h'
        'db backup delete' = '? h'
        'db backup get' = '? h'
        'db backup list' = '? c h'
        'db backup-destination change-compartment' = '? c h'
        'db backup-destination create-nfs-details' = '? c h'
        'db backup-destination create-recovery-appliance-details' = '? c h'
        'db backup-destination delete' = '? h'
        'db backup-destination get' = '? h'
        'db backup-destination update' = '? h'
        'db cloud-exa-infra change-compartment' = '? c h'
        'db cloud-exa-infra create' = '? c h'
        'db cloud-exa-infra delete' = '? h'
        'db cloud-exa-infra get' = '? h'
        'db cloud-exa-infra list' = '? c h'
        'db cloud-exa-infra update' = '? h'
        'db cloud-vm-cluster change-compartment' = '? c h'
        'db cloud-vm-cluster create' = '? c h'
        'db cloud-vm-cluster delete' = '? h'
        'db cloud-vm-cluster get' = '? h'
        'db cloud-vm-cluster get-exadata-iorm-config' = '? h'
        'db cloud-vm-cluster get-update' = '? h'
        'db cloud-vm-cluster get-update-history' = '? h'
        'db cloud-vm-cluster list' = '? c h'
        'db cloud-vm-cluster list-update-histories' = '? h'
        'db cloud-vm-cluster list-updates' = '? h'
        'db cloud-vm-cluster update' = '? h'
        'db cloud-vm-cluster update-exadata-iorm-config' = '? h'
        'db console-connection create' = '? h'
        'db console-connection delete' = '? h'
        'db console-connection get' = '? h'
        'db console-connection list' = '? h'
        'db data-guard-association create from-existing-db-system' = '? h'
        'db data-guard-association create from-existing-vm-cluster' = '? h'
        'db data-guard-association create with-new-db-system' = '? h'
        'db data-guard-association failover' = '? h'
        'db data-guard-association get' = '? h'
        'db data-guard-association list' = '? h'
        'db data-guard-association reinstate' = '? h'
        'db data-guard-association switchover' = '? h'
        'db database create' = '? h'
        'db database create-database-from-backup' = '? h'
        'db database create-from-backup' = '? h'
        'db database create-from-database' = '? h'
        'db database delete' = '? h'
        'db database get' = '? h'
        'db database list' = '? c h'
        'db database list-upgrade-history' = '? h'
        'db database migrate-vault-key' = '? h'
        'db database patch' = '? h'
        'db database restore' = '? h'
        'db database rotate-vault-key' = '? h'
        'db database update' = '? h'
        'db database upgrade' = '? h'
        'db database upgrade-rollback' = '? h'
        'db database upgrade-with-database-software-image' = '? h'
        'db database upgrade-with-db-home' = '? h'
        'db database upgrade-with-db-version' = '? h'
        'db database-software-image change-compartment' = '? c h'
        'db database-software-image create' = '? c h'
        'db database-software-image delete' = '? h'
        'db database-software-image get' = '? h'
        'db database-software-image list' = '? c h'
        'db database-software-image update' = '? h'
        'db db-home create' = '? h'
        'db db-home delete' = '? h'
        'db db-home get' = '? h'
        'db db-home list' = '? c h'
        'db db-home update' = '? h'
        'db exadata-infrastructure activate' = '? h'
        'db exadata-infrastructure add-storage-capacity' = '? h'
        'db exadata-infrastructure change-compartment' = '? c h'
        'db exadata-infrastructure create' = '? c h'
        'db exadata-infrastructure delete' = '? h'
        'db exadata-infrastructure download-config-file' = '? h'
        'db exadata-infrastructure generate-recommended-vm-cluster-network' = '? c h'
        'db exadata-infrastructure get' = '? h'
        'db exadata-infrastructure get-compute-units' = '? h'
        'db exadata-infrastructure list' = '? c h'
        'db exadata-infrastructure update' = '? h'
        'db external-backup-job complete' = '? h'
        'db external-backup-job create' = '? c h'
        'db external-backup-job get' = '? h'
        'db external-cdb change-compartment' = '? c h'
        'db external-cdb create' = '? c h'
        'db external-cdb delete' = '? h'
        'db external-cdb disable-db-management' = '? h'
        'db external-cdb enable-db-management' = '? h'
        'db external-cdb get' = '? h'
        'db external-cdb list' = '? c h'
        'db external-cdb list-external-pdbs' = '? c h'
        'db external-cdb scan-pluggable-databases' = '? h'
        'db external-cdb update' = '? h'
        'db external-db-connector check-connection-status' = '? h'
        'db external-db-connector create-macs-connector' = '? h'
        'db external-db-connector delete' = '? h'
        'db external-db-connector get' = '? h'
        'db external-db-connector list' = '? c h'
        'db external-db-connector update' = '? h'
        'db external-db-connector update-macs-connector' = '? h'
        'db external-non-cdb change-compartment' = '? c h'
        'db external-non-cdb create' = '? c h'
        'db external-non-cdb delete' = '? h'
        'db external-non-cdb disable-db-management' = '? h'
        'db external-non-cdb disable-operations-insights' = '? h'
        'db external-non-cdb enable-db-management' = '? h'
        'db external-non-cdb enable-operations-insights' = '? h'
        'db external-non-cdb get' = '? h'
        'db external-non-cdb list' = '? c h'
        'db external-non-cdb update' = '? h'
        'db external-pdb change-compartment' = '? c h'
        'db external-pdb create' = '? c h'
        'db external-pdb delete' = '? h'
        'db external-pdb disable-db-management' = '? h'
        'db external-pdb disable-operations-insights' = '? h'
        'db external-pdb enable-db-management' = '? h'
        'db external-pdb enable-operations-insights' = '? h'
        'db external-pdb get' = '? h'
        'db external-pdb update' = '? h'
        'db flex-component list' = '? c h'
        'db gi-version list' = '? c h'
        'db key-store change-compartment' = '? c h'
        'db key-store create-oracle-key-vault-details' = '? c h'
        'db key-store delete' = '? h'
        'db key-store get' = '? h'
        'db key-store list' = '? c h'
        'db key-store update-oracle-key-vault-details' = '? h'
        'db maintenance-run get' = '? h'
        'db maintenance-run list' = '? c h'
        'db maintenance-run update' = '? h'
        'db node get' = '? h'
        'db node list' = '? c h'
        'db node reset' = '? h'
        'db node soft-reset' = '? h'
        'db node start' = '? h'
        'db node stop' = '? h'
        'db patch get by-database' = '? h'
        'db patch get by-db-system' = '? h'
        'db patch get-db-home' = '? h'
        'db patch get-vm-cluster' = '? h'
        'db patch list by-database' = '? h'
        'db patch list by-db-system' = '? h'
        'db patch list-db-home' = '? h'
        'db patch list-vm-cluster' = '? h'
        'db patch-history get by-database' = '? h'
        'db patch-history get by-db-system' = '? h'
        'db patch-history get-db-home' = '? h'
        'db patch-history get-vm-cluster' = '? h'
        'db patch-history list by-database' = '? h'
        'db patch-history list by-db-system' = '? h'
        'db patch-history list-db-home' = '? h'
        'db patch-history list-vm-cluster' = '? h'
        'db system change-compartment' = '? c h'
        'db system get' = '? h'
        'db system get-exadata-iorm-config' = '? h'
        'db system launch' = '? c h'
        'db system launch-from-backup' = '? c h'
        'db system launch-from-db-system' = '? c h'
        'db system list' = '? c h'
        'db system patch' = '? h'
        'db system switch' = '? h'
        'db system terminate' = '? h'
        'db system update' = '? h'
        'db system update-exadata-iorm-config' = '? h'
        'db system-shape list' = '? c h'
        'db upgrade-history get' = '? h'
        'db version list' = '? c h'
        'db vm-cluster change-compartment' = '? c h'
        'db vm-cluster create' = '? c h'
        'db vm-cluster delete' = '? h'
        'db vm-cluster get' = '? h'
        'db vm-cluster list' = '? c h'
        'db vm-cluster update' = '? h'
        'db vm-cluster-network create' = '? c h'
        'db vm-cluster-network delete' = '? h'
        'db vm-cluster-network download-vm-cluster-network-config-file' = '? h'
        'db vm-cluster-network get' = '? h'
        'db vm-cluster-network list' = '? c h'
        'db vm-cluster-network update' = '? h'
        'db vm-cluster-network validate' = '? h'
    }
    return $ociCommandsToShortParams
}