# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.database_management.src.oci_cli_database_management.generated import database_management_service_cli


@click.command(cli_util.override('managed_my_sql_databases.managed_my_sql_databases_root_group.command_name', 'managed-my-sql-databases'), cls=CommandGroupWithAlias, help=cli_util.override('managed_my_sql_databases.managed_my_sql_databases_root_group.help', """Use the Database Management API to monitor and manage resources such as
Oracle Databases, MySQL Databases, and External Database Systems.
For more information, see [Database Management]."""), short_help=cli_util.override('managed_my_sql_databases.managed_my_sql_databases_root_group.short_help', """Database Management API"""))
@cli_util.help_option_group
def managed_my_sql_databases_root_group():
    pass


@click.command(cli_util.override('managed_my_sql_databases.heat_wave_fleet_metrics_group.command_name', 'heat-wave-fleet-metrics'), cls=CommandGroupWithAlias, help="""The details of the HeatWave cluster fleet health metrics.""")
@cli_util.help_option_group
def heat_wave_fleet_metrics_group():
    pass


@click.command(cli_util.override('managed_my_sql_databases.my_sql_fleet_metrics_group.command_name', 'my-sql-fleet-metrics'), cls=CommandGroupWithAlias, help="""The details of the MySQL Database fleet health metrics.""")
@cli_util.help_option_group
def my_sql_fleet_metrics_group():
    pass


@click.command(cli_util.override('managed_my_sql_databases.managed_my_sql_database_group.command_name', 'managed-my-sql-database'), cls=CommandGroupWithAlias, help="""The details of the Managed MySQL Database.""")
@cli_util.help_option_group
def managed_my_sql_database_group():
    pass


@click.command(cli_util.override('managed_my_sql_databases.managed_my_sql_database_collection_group.command_name', 'managed-my-sql-database-collection'), cls=CommandGroupWithAlias, help="""A collection of Managed MySQL Database objects.""")
@cli_util.help_option_group
def managed_my_sql_database_collection_group():
    pass


database_management_service_cli.database_management_service_group.add_command(managed_my_sql_databases_root_group)
managed_my_sql_databases_root_group.add_command(heat_wave_fleet_metrics_group)
managed_my_sql_databases_root_group.add_command(my_sql_fleet_metrics_group)
managed_my_sql_databases_root_group.add_command(managed_my_sql_database_group)
managed_my_sql_databases_root_group.add_command(managed_my_sql_database_collection_group)


@heat_wave_fleet_metrics_group.command(name=cli_util.override('managed_my_sql_databases.get_heat_wave_fleet_metric.command_name', 'get'), help=u"""Gets the health metrics for a fleet of HeatWave clusters in a compartment. \n[Command Reference](getHeatWaveFleetMetric)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--start-time', required=True, help=u"""The start time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--end-time', required=True, help=u"""The end time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--filter-by-metric-names', help=u"""The filter used to retrieve a specific set of metrics by passing the desired metric names with a comma separator. Note that, by default, the service returns all supported metrics.""")
@cli_util.option('--filter-by-heat-wave-status', type=custom_types.CliCaseInsensitiveChoice(["UP", "DOWN", "UNKNOWN"]), help=u"""The parameter to filter by HeatWave cluster status.""")
@cli_util.option('--filter-by-heat-wave-shape', help=u"""The parameter to filter by HeatWave node shape.""")
@cli_util.option('--is-heat-wave-lakehouse-enabled', type=click.BOOL, help=u"""The parameter to filter based on whether HeatWave Lakehouse is enabled for the cluster.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'HeatWaveFleetMetrics'})
@cli_util.wrap_exceptions
def get_heat_wave_fleet_metric(ctx, from_json, compartment_id, start_time, end_time, filter_by_metric_names, filter_by_heat_wave_status, filter_by_heat_wave_shape, is_heat_wave_lakehouse_enabled):

    kwargs = {}
    if filter_by_metric_names is not None:
        kwargs['filter_by_metric_names'] = filter_by_metric_names
    if filter_by_heat_wave_status is not None:
        kwargs['filter_by_heat_wave_status'] = filter_by_heat_wave_status
    if filter_by_heat_wave_shape is not None:
        kwargs['filter_by_heat_wave_shape'] = filter_by_heat_wave_shape
    if is_heat_wave_lakehouse_enabled is not None:
        kwargs['is_heat_wave_lakehouse_enabled'] = is_heat_wave_lakehouse_enabled
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    result = client.get_heat_wave_fleet_metric(
        compartment_id=compartment_id,
        start_time=start_time,
        end_time=end_time,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@managed_my_sql_database_group.command(name=cli_util.override('managed_my_sql_databases.get_managed_my_sql_database.command_name', 'get'), help=u"""Retrieves the general information for a specific MySQL Database. \n[Command Reference](getManagedMySqlDatabase)""")
@cli_util.option('--managed-my-sql-database-id', required=True, help=u"""The OCID of the Managed MySQL Database.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'ManagedMySqlDatabase'})
@cli_util.wrap_exceptions
def get_managed_my_sql_database(ctx, from_json, managed_my_sql_database_id):

    if isinstance(managed_my_sql_database_id, six.string_types) and len(managed_my_sql_database_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-my-sql-database-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    result = client.get_managed_my_sql_database(
        managed_my_sql_database_id=managed_my_sql_database_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_sql_fleet_metrics_group.command(name=cli_util.override('managed_my_sql_databases.get_my_sql_fleet_metric.command_name', 'get'), help=u"""Gets the health metrics for a fleet of MySQL Databases in a compartment. \n[Command Reference](getMySqlFleetMetric)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--start-time', required=True, help=u"""The start time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--end-time', required=True, help=u"""The end time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--filter-by-metric-names', help=u"""The filter used to retrieve a specific set of metrics by passing the desired metric names with a comma separator. Note that, by default, the service returns all supported metrics.""")
@cli_util.option('--filter-by-my-sql-deployment-type-param', type=custom_types.CliCaseInsensitiveChoice(["ONPREMISE", "MDS"]), help=u"""The parameter to filter by MySQL deployment type.""")
@cli_util.option('--filter-by-mds-deployment-type', type=custom_types.CliCaseInsensitiveChoice(["HA", "HEATWAVE", "STANDALONE"]), help=u"""The parameter to filter by MySQL Database System type.""")
@cli_util.option('--filter-by-my-sql-status', type=custom_types.CliCaseInsensitiveChoice(["UP", "DOWN", "UNKNOWN"]), help=u"""The parameter to filter by MySQL Database status.""")
@cli_util.option('--filter-by-my-sql-database-version', help=u"""The parameter to filter by MySQL database version.""")
@cli_util.option('--is-heat-wave-enabled', type=click.BOOL, help=u"""The parameter to filter based on whether HeatWave is enabled for the database.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'MySqlFleetMetrics'})
@cli_util.wrap_exceptions
def get_my_sql_fleet_metric(ctx, from_json, compartment_id, start_time, end_time, filter_by_metric_names, filter_by_my_sql_deployment_type_param, filter_by_mds_deployment_type, filter_by_my_sql_status, filter_by_my_sql_database_version, is_heat_wave_enabled):

    kwargs = {}
    if filter_by_metric_names is not None:
        kwargs['filter_by_metric_names'] = filter_by_metric_names
    if filter_by_my_sql_deployment_type_param is not None:
        kwargs['filter_by_my_sql_deployment_type_param'] = filter_by_my_sql_deployment_type_param
    if filter_by_mds_deployment_type is not None:
        kwargs['filter_by_mds_deployment_type'] = filter_by_mds_deployment_type
    if filter_by_my_sql_status is not None:
        kwargs['filter_by_my_sql_status'] = filter_by_my_sql_status
    if filter_by_my_sql_database_version is not None:
        kwargs['filter_by_my_sql_database_version'] = filter_by_my_sql_database_version
    if is_heat_wave_enabled is not None:
        kwargs['is_heat_wave_enabled'] = is_heat_wave_enabled
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    result = client.get_my_sql_fleet_metric(
        compartment_id=compartment_id,
        start_time=start_time,
        end_time=end_time,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@managed_my_sql_database_group.command(name=cli_util.override('managed_my_sql_databases.list_managed_my_sql_database_configuration_data.command_name', 'list-managed-my-sql-database-configuration-data'), help=u"""Retrieves configuration data for a specific MySQL database. \n[Command Reference](listManagedMySqlDatabaseConfigurationData)""")
@cli_util.option('--managed-my-sql-database-id', required=True, help=u"""The OCID of the Managed MySQL Database.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of records returned in the paginated response.""")
@cli_util.option('--page', help=u"""The page token representing the page from where the next set of paginated results are retrieved. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The option to sort information in ascending (\u2018ASC\u2019) or descending (\u2018DESC\u2019) order. Descending order is the default order.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIMECREATED", "NAME"]), help=u"""The field to sort information by. Only one sortOrder can be used. The default sort order for \u2018TIMECREATED\u2019 is descending and the default sort order for \u2018NAME\u2019 is ascending. The \u2018NAME\u2019 sort order is case-sensitive.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'MySqlConfigurationDataCollection'})
@cli_util.wrap_exceptions
def list_managed_my_sql_database_configuration_data(ctx, from_json, all_pages, page_size, managed_my_sql_database_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(managed_my_sql_database_id, six.string_types) and len(managed_my_sql_database_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-my-sql-database-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_my_sql_database_configuration_data,
            managed_my_sql_database_id=managed_my_sql_database_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_my_sql_database_configuration_data,
            limit,
            page_size,
            managed_my_sql_database_id=managed_my_sql_database_id,
            **kwargs
        )
    else:
        result = client.list_managed_my_sql_database_configuration_data(
            managed_my_sql_database_id=managed_my_sql_database_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_my_sql_database_group.command(name=cli_util.override('managed_my_sql_databases.list_managed_my_sql_database_sql_data.command_name', 'list-managed-my-sql-database-sql-data'), help=u"""Retrieves the SQL performance data for a specific MySQL database. \n[Command Reference](listManagedMySqlDatabaseSqlData)""")
@cli_util.option('--managed-my-sql-database-id', required=True, help=u"""The OCID of the Managed MySQL Database.""")
@cli_util.option('--start-time', required=True, help=u"""The start time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--end-time', required=True, help=u"""The end time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--filter-column', help=u"""The parameter to filter results by key criteria which include : - AVG_TIMER_WAIT - SUM_TIMER_WAIT - COUNT_STAR - SUM_ERRORS - SUM_ROWS_AFFECTED - SUM_ROWS_SENT - SUM_ROWS_EXAMINED - SUM_CREATED_TMP_TABLES - SUM_NO_INDEX_USED - SUM_NO_GOOD_INDEX_USED - FIRST_SEEN - LAST_SEEN - HEATWAVE_OFFLOADED - HEATWAVE_OUT_OF_MEMORY""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of records returned in the paginated response.""")
@cli_util.option('--page', help=u"""The page token representing the page from where the next set of paginated results are retrieved. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIMECREATED", "NAME"]), help=u"""The field to sort information by. Only one sortOrder can be used. The default sort order for \u2018TIMECREATED\u2019 is descending and the default sort order for \u2018NAME\u2019 is ascending. The \u2018NAME\u2019 sort order is case-sensitive.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The option to sort information in ascending (\u2018ASC\u2019) or descending (\u2018DESC\u2019) order. Ascending order is the default order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'MySqlDataCollection'})
@cli_util.wrap_exceptions
def list_managed_my_sql_database_sql_data(ctx, from_json, all_pages, page_size, managed_my_sql_database_id, start_time, end_time, filter_column, limit, page, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(managed_my_sql_database_id, six.string_types) and len(managed_my_sql_database_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-my-sql-database-id cannot be whitespace or empty string')

    kwargs = {}
    if filter_column is not None:
        kwargs['filter_column'] = filter_column
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_my_sql_database_sql_data,
            managed_my_sql_database_id=managed_my_sql_database_id,
            start_time=start_time,
            end_time=end_time,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_my_sql_database_sql_data,
            limit,
            page_size,
            managed_my_sql_database_id=managed_my_sql_database_id,
            start_time=start_time,
            end_time=end_time,
            **kwargs
        )
    else:
        result = client.list_managed_my_sql_database_sql_data(
            managed_my_sql_database_id=managed_my_sql_database_id,
            start_time=start_time,
            end_time=end_time,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_my_sql_database_collection_group.command(name=cli_util.override('managed_my_sql_databases.list_managed_my_sql_databases.command_name', 'list-managed-my-sql-databases'), help=u"""Gets the list of Managed MySQL Databases in a specific compartment. \n[Command Reference](listManagedMySqlDatabases)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--page', help=u"""The page token representing the page from where the next set of paginated results are retrieved. This is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of records returned in the paginated response.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIMECREATED", "NAME"]), help=u"""The field to sort information by. Only one sortOrder can be used. The default sort order for \u2018TIMECREATED\u2019 is descending and the default sort order for \u2018NAME\u2019 is ascending. The \u2018NAME\u2019 sort order is case-sensitive.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The option to sort information in ascending (\u2018ASC\u2019) or descending (\u2018DESC\u2019) order. Ascending order is the default order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'ManagedMySqlDatabaseCollection'})
@cli_util.wrap_exceptions
def list_managed_my_sql_databases(ctx, from_json, all_pages, page_size, compartment_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_my_sql_databases,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_my_sql_databases,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_managed_my_sql_databases(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_my_sql_database_group.command(name=cli_util.override('managed_my_sql_databases.summarize_managed_my_sql_database_availability_metrics.command_name', 'summarize-managed-my-sql-database-availability-metrics'), help=u"""Gets the availability metrics for the MySQL Database specified by managedMySqlDatabaseId. \n[Command Reference](summarizeManagedMySqlDatabaseAvailabilityMetrics)""")
@cli_util.option('--managed-my-sql-database-id', required=True, help=u"""The OCID of the Managed MySQL Database.""")
@cli_util.option('--start-time', required=True, help=u"""The start time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--end-time', required=True, help=u"""The end time of the time range to retrieve the health metrics of a Managed Database in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".""")
@cli_util.option('--page', help=u"""The page token representing the page from where the next set of paginated results are retrieved. This is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of records returned in the paginated response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'database_management', 'class': 'MetricsAggregationRangeCollection'})
@cli_util.wrap_exceptions
def summarize_managed_my_sql_database_availability_metrics(ctx, from_json, managed_my_sql_database_id, start_time, end_time, page, limit):

    if isinstance(managed_my_sql_database_id, six.string_types) and len(managed_my_sql_database_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-my-sql-database-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('database_management', 'managed_my_sql_databases', ctx)
    result = client.summarize_managed_my_sql_database_availability_metrics(
        managed_my_sql_database_id=managed_my_sql_database_id,
        start_time=start_time,
        end_time=end_time,
        **kwargs
    )
    cli_util.render_response(result, ctx)
