// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _SelectBasics_SortAlgo_HeaderFile
#define _SelectBasics_SortAlgo_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Bnd_Box2d.hxx>
#include <Standard_Real.hxx>
#include <Bnd_BoundSortBox2d.hxx>
#include <TColStd_MapOfInteger.hxx>
#include <TColStd_MapIteratorOfMapOfInteger.hxx>
#include <Handle_Bnd_HArray1OfBox2d.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class Bnd_Box2d;
class Bnd_HArray1OfBox2d;


//! Quickly selection of a rectangle in a set of rectangles
//! Sort algorithm for 2D rectangles.
class SelectBasics_SortAlgo 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Empty rectangle selector.
  Standard_EXPORT SelectBasics_SortAlgo();
  
  //! Creates a initialized selector.
  Standard_EXPORT SelectBasics_SortAlgo(const Bnd_Box2d& ClippingRectangle, const Standard_Real sizeOfSensitiveArea, const Handle(Bnd_HArray1OfBox2d)& theRectangles);
  
  //! Clears and initializes the selector.
  Standard_EXPORT   void Initialize (const Bnd_Box2d& ClippingRectangle, const Standard_Real sizeOfSensitiveArea, const Handle(Bnd_HArray1OfBox2d)& theRectangles) ;
  
  //! Searchs the items on this position.
  Standard_EXPORT   void InitSelect (const Standard_Real x, const Standard_Real y) ;
  
  //! Searchs the items in this rectangle.
  Standard_EXPORT   void InitSelect (const Bnd_Box2d& rect) ;
  
  //! Returns true if there is something selected.
  Standard_EXPORT   Standard_Boolean More()  const;
  
  //! Sets value on the next selected item.
  Standard_EXPORT   void Next() ;
  
  //! Returns the index of the selected rectangle.
  Standard_EXPORT   Standard_Integer Value()  const;




protected:





private:



  Bnd_Box2d clipRect;
  Standard_Real sizeArea;
  Bnd_BoundSortBox2d sortedRect;
  TColStd_MapOfInteger myMap;
  TColStd_MapIteratorOfMapOfInteger curResult;


};







#endif // _SelectBasics_SortAlgo_HeaderFile
