// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_SurfaceOfRevolution_HeaderFile
#define _Geom_SurfaceOfRevolution_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_SurfaceOfRevolution_HeaderFile
#include <Handle_Geom_SurfaceOfRevolution.hxx>
#endif

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Geom_SweptSurface_HeaderFile
#include <Geom_SweptSurface.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class Geom_UndefinedDerivative;
class Geom_Curve;
class gp_Ax1;
class gp_Dir;
class gp_Pnt;
class gp_Ax2;
class gp_Trsf;
class gp_GTrsf2d;
class gp_Vec;
class Geom_Geometry;


//! Describes a surface of revolution (revolved surface). <br>
//! Such a surface is obtained by rotating a curve (called <br>
//! the "meridian") through a complete revolution about <br>
//! an axis (referred to as the "axis of revolution"). The <br>
//! curve and the axis must be in the same plane (the <br>
//! "reference plane" of the surface). <br>
//! Rotation around the axis of revolution in the <br>
//! trigonometric sense defines the u parametric <br>
//! direction. So the u parameter is an angle, and its <br>
//! origin is given by the position of the meridian on the surface. <br>
//! The parametric range for the u parameter is: [ 0, 2.*Pi ] <br>
//! The v parameter is that of the meridian. <br>
//! Note: A surface of revolution is built from a copy of the <br>
//! original meridian. As a result the original meridian is <br>
//! not modified when the surface is modified. <br>
//! The form of a surface of revolution is typically a <br>
//! general revolution surface <br>
//! (GeomAbs_RevolutionForm). It can be: <br>
//! - a conical surface, if the meridian is a line or a <br>
//!   trimmed line (GeomAbs_ConicalForm), <br>
//! - a cylindrical surface, if the meridian is a line or a <br>
//!   trimmed line parallel to the axis of revolution <br>
//!   (GeomAbs_CylindricalForm), <br>
//! - a planar surface if the meridian is a line or a <br>
//!   trimmed line perpendicular to the axis of revolution <br>
//!   of the surface (GeomAbs_PlanarForm), <br>
//! - a toroidal surface, if the meridian is a circle or a <br>
//!   trimmed circle (GeomAbs_ToroidalForm), or <br>
//! - a spherical surface, if the meridian is a circle, the <br>
//!   center of which is located on the axis of the <br>
//!   revolved surface (GeomAbs_SphericalForm). <br>
//!   Warning <br>
//! Be careful not to construct a surface of revolution <br>
//! where the curve and the axis or revolution are not <br>
//! defined in the same plane. If you do not have a <br>
//! correct configuration, you can correct your initial <br>
//! curve, using a cylindrical projection in the reference plane. <br>
class Geom_SurfaceOfRevolution : public Geom_SweptSurface {

public:

  
//!  C : is the meridian  or the referenced curve. <br>
//!  A1 is the axis of revolution. <br>
//!  The form of a SurfaceOfRevolution can be : <br>
//!  . a general revolution surface (RevolutionForm), <br>
//!  . a conical surface if the meridian is a line or a trimmed line <br>
//!    (ConicalForm), <br>
//!  . a cylindrical surface if the meridian is a line or a trimmed <br>
//!    line parallel to the revolution axis (CylindricalForm), <br>
//!  . a planar surface if the meridian is a line perpendicular to <br>
//!    the revolution axis of the surface (PlanarForm). <br>
//!  . a spherical surface, <br>
//!  . a toroidal surface, <br>
//!  . a quadric surface. <br>
//! Warnings : <br>
//!  It is not checked that the curve C is planar and that the <br>
//!  surface axis is in the plane of the curve. <br>
//!  It is not checked that the revolved curve C doesn't <br>
//!  self-intersects. <br>
  Standard_EXPORT   Geom_SurfaceOfRevolution(const Handle(Geom_Curve)& C,const gp_Ax1& A1);
  //! Changes the axis of revolution. <br>
//! Warnings : <br>
//!  It is not checked that the axis is in the plane of the <br>
//!  revolved curve. <br>
  Standard_EXPORT     void SetAxis(const gp_Ax1& A1) ;
  //! Changes the direction of the revolution axis. <br>
//! Warnings : <br>
//!  It is not checked that the axis is in the plane of the <br>
//!  revolved curve. <br>
  Standard_EXPORT     void SetDirection(const gp_Dir& V) ;
  //! Changes the revolved curve of the surface. <br>
//! Warnings : <br>
//!  It is not checked that the curve C is planar and that the <br>
//!  surface axis is in the plane of the curve. <br>
//!  It is not checked that the revolved curve C doesn't <br>
//!  self-intersects. <br>
  Standard_EXPORT     void SetBasisCurve(const Handle(Geom_Curve)& C) ;
  //! Changes the location point of the revolution axis. <br>
//! Warnings : <br>
//!  It is not checked that the axis is in the plane of the <br>
//!  revolved curve. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt& P) ;
  //! Returns the revolution axis of the surface. <br>
  Standard_EXPORT     gp_Ax1 Axis() const;
  
//!  Returns the location point of the axis of revolution. <br>
  Standard_EXPORT    const gp_Pnt& Location() const;
  
//!  Computes the position of the reference plane of the surface <br>
//!  defined by the basis curve and the symmetry axis. <br>
//!  The location point is the location point of the revolution's <br>
//!  axis, the XDirection of the plane is given by the revolution's <br>
//!  axis and the orientation of the normal to the plane is given <br>
//!  by the sense of revolution. <br>
//!  Raised if the revolved curve is not planar or if the revolved <br>
//!  curve and the symmetry axis are not in the same plane or if <br>
//!  the maximum of distance between the axis and the revolved <br>
//!  curve is lower or equal to Resolution from gp. <br>
  Standard_EXPORT     gp_Ax2 ReferencePlane() const;
  //! Changes the orientation of this surface of revolution <br>
//! in the u  parametric direction. The bounds of the <br>
//! surface are not changed but the given parametric <br>
//! direction is reversed. Hence the orientation of the <br>
//! surface is reversed. <br>
//! As a consequence: <br>
//! - UReverse reverses the direction of the axis of <br>
//!   revolution of this surface, <br>
  Standard_EXPORT     void UReverse() ;
  //! Computes the u  parameter on the modified <br>
//! surface, when reversing its u  parametric <br>
//! direction, for any point of u parameter U  on this surface of revolution. <br>
//! In the case of a revolved surface: <br>
//! - UReversedParameter returns 2.*Pi - U <br>
  Standard_EXPORT     Standard_Real UReversedParameter(const Standard_Real U) const;
  //! Changes the orientation of this surface of revolution <br>
//! in the v parametric direction. The bounds of the <br>
//! surface are not changed but the given parametric <br>
//! direction is reversed. Hence the orientation of the <br>
//! surface is reversed. <br>
//! As a consequence: <br>
//! - VReverse reverses the meridian of this surface of revolution. <br>
  Standard_EXPORT     void VReverse() ;
  //! Computes the  v parameter on the modified <br>
//! surface, when reversing its  v parametric <br>
//! direction, for any point of v parameter V on this surface of revolution. <br>
//! In the case of a revolved surface: <br>
//! - VReversedParameter returns the reversed <br>
//!   parameter given by the function <br>
//!   ReversedParameter called with V on the meridian. <br>
  Standard_EXPORT     Standard_Real VReversedParameter(const Standard_Real V) const;
  //! Computes the  parameters on the  transformed  surface for <br>
//!          the transform of the point of parameters U,V on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(U',V') <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U,V).Transformed(T) <br>
//! <br>
//!          Where U',V' are the new values of U,V after calling <br>
//! <br>
//!          me->TranformParameters(U,V,T) <br>
//! <br>
//!          This methods multiplies V by <br>
//!          BasisCurve()->ParametricTransformation(T) <br>
  Standard_EXPORT   virtual  void TransformParameters(Standard_Real& U,Standard_Real& V,const gp_Trsf& T) const;
  //! Returns a 2d transformation  used to find the  new <br>
//!          parameters of a point on the transformed surface. <br>
//! <br>
//!          me->Transformed(T)->Value(U',V') <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U,V).Transformed(T) <br>
//! <br>
//!          Where U',V' are  obtained by transforming U,V with <br>
//!          th 2d transformation returned by <br>
//! <br>
//!          me->ParametricTransformation(T) <br>
//! <br>
//!          This  methods  returns  a scale  centered  on  the <br>
//!          U axis with BasisCurve()->ParametricTransformation(T) <br>
  Standard_EXPORT   virtual  gp_GTrsf2d ParametricTransformation(const gp_Trsf& T) const;
  //! Returns the parametric bounds U1, U2 , V1 and V2 of this surface. <br>
//! A surface of revolution is always complete, so U1 = 0, U2 = 2*PI. <br>
  Standard_EXPORT     void Bounds(Standard_Real& U1,Standard_Real& U2,Standard_Real& V1,Standard_Real& V2) const;
  //! IsUClosed always returns true. <br>
  Standard_EXPORT     Standard_Boolean IsUClosed() const;
  //! IsVClosed returns true if the meridian of this <br>
//!   surface of revolution is closed. <br>
  Standard_EXPORT     Standard_Boolean IsVClosed() const;
  //! IsCNu always returns true. <br>
  Standard_EXPORT     Standard_Boolean IsCNu(const Standard_Integer N) const;
  //! IsCNv returns true if the degree of continuity of the <br>
//!   meridian of this surface of revolution is at least N. <br>//! Raised if N < 0. <br>
  Standard_EXPORT     Standard_Boolean IsCNv(const Standard_Integer N) const;
  //! Returns True. <br>
  Standard_EXPORT     Standard_Boolean IsUPeriodic() const;
  //!  IsVPeriodic returns true if the meridian of this <br>
//!   surface of revolution is periodic. <br>
  Standard_EXPORT     Standard_Boolean IsVPeriodic() const;
  //!  Computes the U isoparametric curve of this surface <br>
//! of revolution. It is the curve obtained by rotating the <br>
//! meridian through an angle U about the axis of revolution. <br>
  Standard_EXPORT     Handle_Geom_Curve UIso(const Standard_Real U) const;
  //!  Computes the U isoparametric curve of this surface <br>
//! of revolution. It is the curve obtained by rotating the <br>
//! meridian through an angle U about the axis of revolution. <br>
  Standard_EXPORT     Handle_Geom_Curve VIso(const Standard_Real V) const;
  //!  Computes the  point P (U, V) on the surface. <br>
//!  U is the angle of the rotation around the revolution axis. <br>
//!  The direction of this axis gives the sense of rotation. <br>
//!  V is the parameter of the revolved curve. <br>
  Standard_EXPORT     void D0(const Standard_Real U,const Standard_Real V,gp_Pnt& P) const;
  
//!  Computes the current point and the first derivatives <br>
//!  in the directions U and V. <br>//! Raised if the continuity of the surface is not C1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;
  
//!  Computes the current point, the first and the second derivatives <br>
//!  in the directions U and V. <br>//! Raised if the continuity of the surface is not C2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;
  
//!  Computes the current point, the first,the second and the third <br>
//!  derivatives in the directions U and V. <br>//! Raised if the continuity of the surface is not C3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;
  
//!  Computes the derivative of order Nu in the direction u and <br>
//!  Nv in the direction v. <br>
//!  Raised if the continuity of the surface is not CNu in the u <br>
//!  direction and CNv in the v direction. <br>//! Raised if Nu + Nv < 1 or Nu < 0 or Nv < 0. <br>//! The following  functions  evaluates the  local <br>
//! derivatives on surface. Useful to manage discontinuities <br>
//! on the surface. <br>
//!           if    Side  =  1  ->  P  =  S( U+,V ) <br>
//!           if    Side  = -1  ->  P  =  S( U-,V ) <br>
//!           else  P  is betveen discontinuities <br>
//!           can be evaluated using methods  of <br>
//!           global evaluations    P  =  S( U ,V ) <br>
  Standard_EXPORT     gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const;
  
  Standard_EXPORT     void LocalD0(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P) const;
  
  Standard_EXPORT     void LocalD1(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;
  
  Standard_EXPORT     void LocalD2(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;
  
  Standard_EXPORT     void LocalD3(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;
  
  Standard_EXPORT     gp_Vec LocalDN(const Standard_Real U,const Standard_Real V,const Standard_Integer USide,const Standard_Integer Nu,const Standard_Integer Nv) const;
  //! Applies the transformation T to this surface of revolution. <br>
  Standard_EXPORT     void Transform(const gp_Trsf& T) ;
  //! Creates a new object which is a copy of this surface of revolution. <br>
  Standard_EXPORT     Handle_Geom_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom_SurfaceOfRevolution)

protected:




private: 


gp_Pnt loc;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
