
//# unitInfo: Provides: CamlinternalFormatBasics
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function erase_rel(param){
     /*<<?>>*/ if(typeof param === "number")
      /*<<camlinternalFormatBasics.ml:562:20>>*/ return 0;
    switch(param[0]){
      case 0:
       var rest = param[1];
        /*<<camlinternalFormatBasics.ml:533:4>>*/ return [0, erase_rel(rest)];
      case 1:
       var rest$0 = param[1];
        /*<<camlinternalFormatBasics.ml:535:4>>*/ return [1,
               erase_rel(rest$0)];
      case 2:
       var rest$1 = param[1];
        /*<<camlinternalFormatBasics.ml:537:4>>*/ return [2,
               erase_rel(rest$1)];
      case 3:
       var rest$2 = param[1];
        /*<<camlinternalFormatBasics.ml:539:4>>*/ return [3,
               erase_rel(rest$2)];
      case 4:
       var rest$3 = param[1];
        /*<<camlinternalFormatBasics.ml:543:4>>*/ return [4,
               erase_rel(rest$3)];
      case 5:
       var rest$4 = param[1];
        /*<<camlinternalFormatBasics.ml:541:4>>*/ return [5,
               erase_rel(rest$4)];
      case 6:
       var rest$5 = param[1];
        /*<<camlinternalFormatBasics.ml:545:4>>*/ return [6,
               erase_rel(rest$5)];
      case 7:
       var rest$6 = param[1];
        /*<<camlinternalFormatBasics.ml:547:4>>*/ return [7,
               erase_rel(rest$6)];
      case 8:
       var rest$7 = param[2], ty = param[1];
        /*<<camlinternalFormatBasics.ml:549:4>>*/ return [8,
               ty,
               erase_rel(rest$7)];
      case 9:
       var rest$8 = param[3], ty1 = param[1];
        /*<<camlinternalFormatBasics.ml:551:4>>*/ return [9,
               ty1,
               ty1,
               erase_rel(rest$8)];
      case 10:
       var rest$9 = param[1];
        /*<<camlinternalFormatBasics.ml:553:4>>*/ return [10,
               erase_rel(rest$9)];
      case 11:
       var rest$10 = param[1];
        /*<<camlinternalFormatBasics.ml:555:4>>*/ return [11,
               erase_rel(rest$10)];
      case 12:
       var rest$11 = param[1];
        /*<<camlinternalFormatBasics.ml:557:4>>*/ return [12,
               erase_rel(rest$11)];
      case 13:
       var rest$12 = param[1];
        /*<<camlinternalFormatBasics.ml:559:4>>*/ return [13,
               erase_rel(rest$12)];
      default:
       var rest$13 = param[1];
        /*<<camlinternalFormatBasics.ml:561:4>>*/ return [14,
               erase_rel(rest$13)];
    }
   }
   function concat_fmtty(fmtty1, fmtty2){
     /*<<camlinternalFormatBasics.ml:590:21>>*/ if(typeof fmtty1 === "number")
      /*<<camlinternalFormatBasics.ml:621:20>>*/ return fmtty2;
    switch(fmtty1[0]){
      case 0:
       var rest = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:592:4>>*/ return [0,
               concat_fmtty(rest, fmtty2)];
      case 1:
       var rest$0 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:594:4>>*/ return [1,
               concat_fmtty(rest$0, fmtty2)];
      case 2:
       var rest$1 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:596:4>>*/ return [2,
               concat_fmtty(rest$1, fmtty2)];
      case 3:
       var rest$2 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:598:4>>*/ return [3,
               concat_fmtty(rest$2, fmtty2)];
      case 4:
       var rest$3 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:600:4>>*/ return [4,
               concat_fmtty(rest$3, fmtty2)];
      case 5:
       var rest$4 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:602:4>>*/ return [5,
               concat_fmtty(rest$4, fmtty2)];
      case 6:
       var rest$5 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:604:4>>*/ return [6,
               concat_fmtty(rest$5, fmtty2)];
      case 7:
       var rest$6 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:606:4>>*/ return [7,
               concat_fmtty(rest$6, fmtty2)];
      case 8:
       var rest$7 = fmtty1[2], ty = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:618:4>>*/ return [8,
               ty,
               concat_fmtty(rest$7, fmtty2)];
      case 9:
       var rest$8 = fmtty1[3], ty2 = fmtty1[2], ty1 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:620:4>>*/ return [9,
               ty1,
               ty2,
               concat_fmtty(rest$8, fmtty2)];
      case 10:
       var rest$9 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:608:4>>*/ return [10,
               concat_fmtty(rest$9, fmtty2)];
      case 11:
       var rest$10 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:610:4>>*/ return [11,
               concat_fmtty(rest$10, fmtty2)];
      case 12:
       var rest$11 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:612:4>>*/ return [12,
               concat_fmtty(rest$11, fmtty2)];
      case 13:
       var rest$12 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:614:4>>*/ return [13,
               concat_fmtty(rest$12, fmtty2)];
      default:
       var rest$13 = fmtty1[1];
        /*<<camlinternalFormatBasics.ml:616:4>>*/ return [14,
               concat_fmtty(rest$13, fmtty2)];
    }
    /*<<camlinternalFormatBasics.ml:621:26>>*/ }
   function concat_fmt(fmt1, fmt2){
     /*<<camlinternalFormatBasics.ml:631:17>>*/ if(typeof fmt1 === "number")
      /*<<camlinternalFormatBasics.ml:690:4>>*/ return fmt2;
    switch(fmt1[0]){
      case 0:
       var rest = fmt1[1];
        /*<<camlinternalFormatBasics.ml:649:4>>*/ return [0,
               concat_fmt(rest, fmt2)];
      case 1:
       var rest$0 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:651:4>>*/ return [1,
               concat_fmt(rest$0, fmt2)];
      case 2:
       var rest$1 = fmt1[2], pad = fmt1[1];
        /*<<camlinternalFormatBasics.ml:633:4>>*/ return [2,
               pad,
               concat_fmt(rest$1, fmt2)];
      case 3:
       var rest$2 = fmt1[2], pad$0 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:635:4>>*/ return [3,
               pad$0,
               concat_fmt(rest$2, fmt2)];
      case 4:
       var rest$3 = fmt1[4], prec = fmt1[3], pad$1 = fmt1[2], iconv = fmt1[1];
        /*<<camlinternalFormatBasics.ml:638:4>>*/ return [4,
               iconv,
               pad$1,
               prec,
               concat_fmt(rest$3, fmt2)];
      case 5:
       var
        rest$4 = fmt1[4],
        prec$0 = fmt1[3],
        pad$2 = fmt1[2],
        iconv$0 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:640:4>>*/ return [5,
               iconv$0,
               pad$2,
               prec$0,
               concat_fmt(rest$4, fmt2)];
      case 6:
       var
        rest$5 = fmt1[4],
        prec$1 = fmt1[3],
        pad$3 = fmt1[2],
        iconv$1 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:642:4>>*/ return [6,
               iconv$1,
               pad$3,
               prec$1,
               concat_fmt(rest$5, fmt2)];
      case 7:
       var
        rest$6 = fmt1[4],
        prec$2 = fmt1[3],
        pad$4 = fmt1[2],
        iconv$2 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:644:4>>*/ return [7,
               iconv$2,
               pad$4,
               prec$2,
               concat_fmt(rest$6, fmt2)];
      case 8:
       var
        rest$7 = fmt1[4],
        prec$3 = fmt1[3],
        pad$5 = fmt1[2],
        fconv = fmt1[1];
        /*<<camlinternalFormatBasics.ml:646:4>>*/ return [8,
               fconv,
               pad$5,
               prec$3,
               concat_fmt(rest$7, fmt2)];
      case 9:
       var rest$8 = fmt1[2], pad$6 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:653:4>>*/ return [9,
               pad$6,
               concat_fmt(rest$8, fmt2)];
      case 10:
       var rest$9 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:663:4>>*/ return [10,
               concat_fmt(rest$9, fmt2)];
      case 11:
       var rest$10 = fmt1[2], str = fmt1[1];
        /*<<camlinternalFormatBasics.ml:666:4>>*/ return [11,
               str,
               concat_fmt(rest$10, fmt2)];
      case 12:
       var rest$11 = fmt1[2], chr = fmt1[1];
        /*<<camlinternalFormatBasics.ml:668:4>>*/ return [12,
               chr,
               concat_fmt(rest$11, fmt2)];
      case 13:
       var rest$12 = fmt1[3], fmtty = fmt1[2], pad$7 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:671:4>>*/ return [13,
               pad$7,
               fmtty,
               concat_fmt(rest$12, fmt2)];
      case 14:
       var rest$13 = fmt1[3], fmtty$0 = fmt1[2], pad$8 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:673:4>>*/ return [14,
               pad$8,
               fmtty$0,
               concat_fmt(rest$13, fmt2)];
      case 15:
       var rest$14 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:655:4>>*/ return [15,
               concat_fmt(rest$14, fmt2)];
      case 16:
       var rest$15 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:657:4>>*/ return [16,
               concat_fmt(rest$15, fmt2)];
      case 17:
       var rest$16 = fmt1[2], fmting_lit = fmt1[1];
        /*<<camlinternalFormatBasics.ml:685:4>>*/ return [17,
               fmting_lit,
               concat_fmt(rest$16, fmt2)];
      case 18:
       var rest$17 = fmt1[2], fmting_gen = fmt1[1];
        /*<<camlinternalFormatBasics.ml:687:4>>*/ return [18,
               fmting_gen,
               concat_fmt(rest$17, fmt2)];
      case 19:
       var rest$18 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:661:4>>*/ return [19,
               concat_fmt(rest$18, fmt2)];
      case 20:
       var rest$19 = fmt1[3], char_set = fmt1[2], width_opt = fmt1[1];
        /*<<camlinternalFormatBasics.ml:676:4>>*/ return [20,
               width_opt,
               char_set,
               concat_fmt(rest$19, fmt2)];
      case 21:
       var rest$20 = fmt1[2], counter = fmt1[1];
        /*<<camlinternalFormatBasics.ml:678:4>>*/ return [21,
               counter,
               concat_fmt(rest$20, fmt2)];
      case 22:
       var rest$21 = fmt1[1];
        /*<<camlinternalFormatBasics.ml:680:4>>*/ return [22,
               concat_fmt(rest$21, fmt2)];
      case 23:
       var rest$22 = fmt1[2], ign = fmt1[1];
        /*<<camlinternalFormatBasics.ml:682:4>>*/ return [23,
               ign,
               concat_fmt(rest$22, fmt2)];
      default:
       var rest$23 = fmt1[3], f = fmt1[2], arity = fmt1[1];
        /*<<camlinternalFormatBasics.ml:659:4>>*/ return [24,
               arity,
               f,
               concat_fmt(rest$23, fmt2)];
    }
    /*<<camlinternalFormatBasics.ml:690:8>>*/ }
   var CamlinternalFormatBasics = [0, concat_fmtty, erase_rel, concat_fmt];
   runtime.caml_register_global
    (0, CamlinternalFormatBasics, "CamlinternalFormatBasics");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib
//# unitInfo: Requires: CamlinternalFormatBasics
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_false$0 = "false",
    cst_true$0 = "true",
    caml_atomic_cas = runtime.caml_atomic_cas,
    caml_atomic_load = runtime.caml_atomic_load,
    caml_blit_string = runtime.caml_blit_string,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_float_of_string = runtime.caml_float_of_string,
    caml_int64_float_of_bits = runtime.caml_int64_float_of_bits,
    caml_int_of_string = runtime.caml_int_of_string,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_ml_channel_size = runtime.caml_ml_channel_size,
    caml_ml_channel_size_64 = runtime.caml_ml_channel_size_64,
    caml_ml_close_channel = runtime.caml_ml_close_channel,
    caml_ml_flush = runtime.caml_ml_flush,
    caml_ml_input = runtime.caml_ml_input,
    caml_ml_input_char = runtime.caml_ml_input_char,
    caml_ml_open_descriptor_in = runtime.caml_ml_open_descriptor_in,
    caml_ml_open_descriptor_out = runtime.caml_ml_open_descriptor_out,
    caml_ml_output = runtime.caml_ml_output,
    caml_ml_output_bytes = runtime.caml_ml_output_bytes,
    caml_ml_output_char = runtime.caml_ml_output_char,
    caml_ml_set_binary_mode = runtime.caml_ml_set_binary_mode,
    caml_ml_set_channel_name = runtime.caml_ml_set_channel_name,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_string_of_bytes = runtime.caml_string_of_bytes,
    caml_sys_open = runtime.caml_sys_open,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst$0 = "%,",
    cst = ".",
    CamlinternalFormatBasics = global_data.CamlinternalFormatBasics,
    Invalid_argument = global_data.Invalid_argument,
    Failure = global_data.Failure,
    Match_failure = global_data.Match_failure,
    Assert_failure = global_data.Assert_failure,
    Not_found = global_data.Not_found,
    Out_of_memory = global_data.Out_of_memory,
    Stack_overflow = global_data.Stack_overflow,
    Sys_error = global_data.Sys_error,
    End_of_file = global_data.End_of_file,
    Division_by_zero = global_data.Division_by_zero,
    Sys_blocked_io = global_data.Sys_blocked_io,
    Undefined_recursive_module = global_data.Undefined_recursive_module;
   function failwith(s){
     /*<<stdlib.ml:29:17>>*/ throw  /*<<stdlib.ml:29:17>>*/ caml_maybe_attach_backtrace
           ([0, Failure, s], 1);
    /*<<stdlib.ml:29:33>>*/ }
   function invalid_arg(s){
     /*<<stdlib.ml:30:20>>*/ throw  /*<<stdlib.ml:30:20>>*/ caml_maybe_attach_backtrace
           ([0, Invalid_argument, s], 1);
    /*<<stdlib.ml:30:45>>*/ }
    /*<<stdlib.ml:32:0>>*/  /*<<stdlib.ml:32:0>>*/ var
    Exit = [248, "Stdlib.Exit", runtime.caml_fresh_oo_id(0)];
   function min(x, y){
     /*<<stdlib.ml:74:14>>*/ return  /*<<stdlib.ml:74:17>>*/ runtime.caml_lessequal
             (x, y)
            ? x
            : y;
    /*<<stdlib.ml:74:37>>*/ }
   function max(x, y){
     /*<<stdlib.ml:75:14>>*/ return  /*<<stdlib.ml:75:17>>*/ runtime.caml_greaterequal
             (x, y)
            ? x
            : y;
    /*<<stdlib.ml:75:37>>*/ }
   function abs(x){
     /*<<stdlib.ml:98:12>>*/ return 0 <= x ? x : - x | 0;
    /*<<stdlib.ml:98:36>>*/ }
   function lnot(x){
     /*<<stdlib.ml:104:13>>*/ return x ^ -1;
    /*<<stdlib.ml:104:24>>*/ }
    /*<<stdlib.ml:180:2>>*/ var
     /*<<stdlib.ml:180:2>>*/ infinity =
       /*<<stdlib.ml:180:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 32752)),
     /*<<stdlib.ml:182:2>>*/ neg_infinity =
       /*<<stdlib.ml:182:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 65520)),
     /*<<stdlib.ml:184:2>>*/ nan =
       /*<<stdlib.ml:184:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(1, 0, 32760)),
     /*<<stdlib.ml:186:2>>*/ max_float =
       /*<<stdlib.ml:186:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 32751)),
     /*<<stdlib.ml:188:2>>*/ min_float =
       /*<<stdlib.ml:188:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 16)),
     /*<<stdlib.ml:190:2>>*/ epsilon_float =
       /*<<stdlib.ml:190:2>>*/ caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 15536)),
    cst_char_of_int = "char_of_int",
    cst_true = cst_true$0,
    cst_false = cst_false$0,
    cst_bool_of_string = "bool_of_string",
    _a_ = [0, 1],
    _b_ = [0, 0];
   function symbol(s1, s2){
     /*<<stdlib.ml:213:2>>*/ var
     l1 = caml_ml_string_length(s1),
     l2 = caml_ml_string_length(s2),
      /*<<stdlib.ml:214:10>>*/ s =
        /*<<stdlib.ml:214:10>>*/ caml_create_bytes(l1 + l2 | 0);
     /*<<stdlib.ml:215:2>>*/  /*<<stdlib.ml:215:2>>*/ caml_blit_string
     (s1, 0, s, 0, l1);
     /*<<stdlib.ml:216:2>>*/  /*<<stdlib.ml:216:2>>*/ caml_blit_string
     (s2, 0, s, l1, l2);
    return caml_string_of_bytes(s);
    /*<<stdlib.ml:217:26>>*/ }
   function char_of_int(n){
     /*<<stdlib.ml:224:2>>*/ if(0 <= n && 255 >= n)
      /*<<stdlib.ml:224:58>>*/ return n;
     /*<<stdlib.ml:224:27>>*/ return invalid_arg(cst_char_of_int);
    /*<<stdlib.ml:224:78>>*/ }
   function string_of_bool(b){
     /*<<stdlib.ml:254:2>>*/ return b ? cst_true : cst_false;
    /*<<stdlib.ml:254:31>>*/ }
   function bool_of_string(param){
     /*<<stdlib.ml:255:21>>*/ return caml_string_notequal(param, cst_false$0)
            ? caml_string_notequal
               (param, cst_true$0)
              ? invalid_arg(cst_bool_of_string)
              : 1
            : 0;
    /*<<stdlib.ml:258:37>>*/ }
   function bool_of_string_opt(param){
     /*<<stdlib.ml:260:25>>*/ return caml_string_notequal(param, cst_false$0)
            ? caml_string_notequal(param, cst_true$0) ? 0 : _a_
            : _b_;
    /*<<stdlib.ml:263:13>>*/ }
   function string_of_int(n){
     /*<<stdlib.ml:266:2>>*/ return "" + n;
    /*<<stdlib.ml:266:19>>*/ }
   function int_of_string_opt(s){
     /*<<stdlib.ml:272:2>>*/ try{
      /*<<stdlib.ml:272:6>>*/  /*<<stdlib.ml:272:6>>*/ var
      _x_ = [0,  /*<<stdlib.ml:272:11>>*/ caml_int_of_string(s)];
      /*<<stdlib.ml:272:6>>*/ return _x_;
    }
    catch(_y_){
     var _w_ = caml_wrap_exception(_y_);
     if(_w_[1] === Failure)  /*<<stdlib.ml:273:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_w_, 0);
    }
    /*<<stdlib.ml:273:24>>*/ }
   function valid_float_lexem(s){
     /*<<stdlib.ml:278:2>>*/ var l = caml_ml_string_length(s), i = 0;
     /*<<stdlib.ml:280:4>>*/ for(;;){
     if(l <= i)  /*<<stdlib.ml:280:19>>*/ return symbol(s, cst);
      /*<<stdlib.ml:281:10>>*/  /*<<stdlib.ml:281:10>>*/ var
      match =  /*<<stdlib.ml:281:10>>*/ runtime.caml_string_get(s, i);
     a:
     {
      if(48 <= match){if(58 > match) break a;} else if(45 === match) break a;
       /*<<stdlib.ml:279:2>>*/ return s;
     }
      /*<<stdlib.ml:282:26>>*/ var
       /*<<stdlib.ml:282:26>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<stdlib.ml:285:8>>*/ }
   function string_of_float(f){
     /*<<stdlib.ml:287:24>>*/ return valid_float_lexem
            ( /*<<stdlib.ml:287:42>>*/ runtime.caml_format_float("%.12g", f));
    /*<<stdlib.ml:287:66>>*/ }
   function float_of_string_opt(s){
     /*<<stdlib.ml:293:2>>*/ try{
      /*<<stdlib.ml:293:6>>*/  /*<<stdlib.ml:293:6>>*/ var
      _u_ = [0,  /*<<stdlib.ml:293:11>>*/ caml_float_of_string(s)];
      /*<<stdlib.ml:293:6>>*/ return _u_;
    }
    catch(_v_){
     var _t_ = caml_wrap_exception(_v_);
     if(_t_[1] === Failure)  /*<<stdlib.ml:294:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_t_, 0);
    }
    /*<<stdlib.ml:294:24>>*/ }
   function symbol$0(l1, l2){
     /*<<stdlib.ml:299:2>>*/ if(! l1)  /*<<stdlib.ml:300:10>>*/ return l2;
    var _r_ = l1[2], h1 = l1[1];
    if(! _r_)  /*<<stdlib.ml:301:16>>*/ return [0, h1, l2];
    var match = _r_[2], h2 = _r_[1];
    if(! match)  /*<<stdlib.ml:302:22>>*/ return [0, h1, [0, h2, l2]];
     /*<<stdlib.ml:303:40>>*/ var
     tl = match[2],
     h3 = match[1],
      /*<<stdlib.ml:303:40>>*/ block = [0, h3, 24029],
     dst = block,
     offset = 1,
     l1$0 = tl;
     /*<<stdlib.ml:299:2>>*/ for(;;){
     if(l1$0){
      var _s_ = l1$0[2], h1$0 = l1$0[1];
      if(_s_){
       var match$0 = _s_[2], h2$0 = _s_[1];
       if(match$0){
         /*<<stdlib.ml:303:40>>*/ var
         tl$0 = match$0[2],
         h3$0 = match$0[1],
          /*<<stdlib.ml:303:40>>*/ dst$0 = [0, h3$0, 24029];
        dst[1 + offset] = [0, h1$0, [0, h2$0, dst$0]];
        var dst = dst$0, offset = 1, l1$0 = tl$0;
        continue;
       }
       dst[1 + offset] = [0, h1$0, [0, h2$0, l2]];
      }
      else
       dst[1 + offset] = [0, h1$0, l2];
     }
     else
      dst[1 + offset] = l2;
      /*<<stdlib.ml:303:28>>*/ return [0, h1, [0, h2, block]];
    }
    /*<<stdlib.ml:303:55>>*/ }
    /*<<stdlib.ml:314:12>>*/ var
     /*<<stdlib.ml:314:12>>*/ stdin =
       /*<<stdlib.ml:314:12>>*/ caml_ml_open_descriptor_in(0),
     /*<<stdlib.ml:315:13>>*/ stdout =
       /*<<stdlib.ml:315:13>>*/ caml_ml_open_descriptor_out(1),
     /*<<stdlib.ml:316:13>>*/ stderr =
       /*<<stdlib.ml:316:13>>*/ caml_ml_open_descriptor_out(2),
    _c_ = [0, 1, [0, 3, [0, 4, [0, 7, 0]]]],
    _d_ = [0, 1, [0, 3, [0, 4, [0, 6, 0]]]],
    cst_output = "output",
    cst_output_substring = "output_substring",
    _e_ = [0, 0, [0, 7, 0]],
    _f_ = [0, 0, [0, 6, 0]],
    cst_input = "input",
    cst_really_input = "really_input";
   function open_out_gen(mode, perm, name){
     /*<<stdlib.ml:331:2>>*/  /*<<stdlib.ml:331:10>>*/ var
     c =
        /*<<stdlib.ml:331:10>>*/ caml_ml_open_descriptor_out
        ( /*<<stdlib.ml:331:29>>*/ caml_sys_open(name, mode, perm));
     /*<<stdlib.ml:332:2>>*/  /*<<stdlib.ml:332:2>>*/ caml_ml_set_channel_name
     (c, name);
     /*<<stdlib.ml:332:2>>*/ return c;
    /*<<stdlib.ml:333:3>>*/ }
   function open_out(name){
     /*<<stdlib.ml:336:2>>*/ return open_out_gen(_c_, 438, name);
    /*<<stdlib.ml:336:74>>*/ }
   function open_out_bin(name){
     /*<<stdlib.ml:339:2>>*/ return open_out_gen(_d_, 438, name);
    /*<<stdlib.ml:339:76>>*/ }
   function flush_all(param){
     /*<<stdlib.ml:347:2>>*/ var
     param$0 =  /*<<stdlib.ml:356:10>>*/ runtime.caml_ml_out_channels_list(0);
     /*<<stdlib.ml:347:17>>*/ for(;;){
     if(! param$0)  /*<<stdlib.ml:348:12>>*/ return 0;
     var l = param$0[2], a = param$0[1];
      /*<<stdlib.ml:350:8>>*/ try{
       /*<<stdlib.ml:351:12>>*/  /*<<stdlib.ml:351:12>>*/ caml_ml_flush(a);
     }
     catch(_q_){
      var _p_ = caml_wrap_exception(_q_);
      if(_p_[1] !== Sys_error) throw caml_maybe_attach_backtrace(_p_, 0);
     }
     var param$0 = l;
    }
    /*<<stdlib.ml:356:32>>*/ }
   function output_bytes(oc, s){
     /*<<stdlib.ml:366:2>>*/ return  /*<<stdlib.ml:366:2>>*/ caml_ml_output_bytes
            (oc, s, 0, caml_ml_bytes_length(s));
    /*<<stdlib.ml:366:39>>*/ }
   function output_string(oc, s){
     /*<<stdlib.ml:369:2>>*/ return  /*<<stdlib.ml:369:2>>*/ caml_ml_output
            (oc, s, 0, caml_ml_string_length(s));
    /*<<stdlib.ml:369:47>>*/ }
   function output(oc, s, ofs, len){
     /*<<stdlib.ml:372:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
      /*<<stdlib.ml:374:7>>*/ return  /*<<stdlib.ml:374:7>>*/ caml_ml_output_bytes
             (oc, s, ofs, len);
     /*<<stdlib.ml:373:7>>*/ return invalid_arg(cst_output);
    /*<<stdlib.ml:374:33>>*/ }
   function output_substring(oc, s, ofs, len){
     /*<<stdlib.ml:377:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_string_length(s) - len | 0) >= ofs)
      /*<<stdlib.ml:379:7>>*/ return  /*<<stdlib.ml:379:7>>*/ caml_ml_output
             (oc, s, ofs, len);
     /*<<stdlib.ml:378:7>>*/ return invalid_arg(cst_output_substring);
    /*<<stdlib.ml:379:40>>*/ }
   function output_value(chan, v){
     /*<<stdlib.ml:386:26>>*/ return  /*<<stdlib.ml:386:26>>*/ runtime.caml_output_value
            (chan, v, 0);
    /*<<stdlib.ml:386:54>>*/ }
   function close_out(oc){
     /*<<stdlib.ml:392:19>>*/  /*<<stdlib.ml:392:19>>*/ caml_ml_flush(oc);
     /*<<stdlib.ml:392:29>>*/ return  /*<<stdlib.ml:392:29>>*/ caml_ml_close_channel
            (oc);
    /*<<stdlib.ml:392:49>>*/ }
   function close_out_noerr(oc){
     /*<<stdlib.ml:394:2>>*/ try{
      /*<<stdlib.ml:394:7>>*/  /*<<stdlib.ml:394:7>>*/ caml_ml_flush(oc);
    }
    catch(_o_){}
     /*<<stdlib.ml:395:2>>*/ try{
      /*<<stdlib.ml:395:7>>*/  /*<<stdlib.ml:395:7>>*/ var
      _m_ =  /*<<stdlib.ml:395:7>>*/ caml_ml_close_channel(oc);
      /*<<stdlib.ml:395:7>>*/ return _m_;
    }
    catch(_n_){ /*<<stdlib.ml:395:38>>*/ return 0;}
    /*<<stdlib.ml:395:41>>*/ }
   function open_in_gen(mode, perm, name){
     /*<<stdlib.ml:405:2>>*/  /*<<stdlib.ml:405:10>>*/ var
     c =
        /*<<stdlib.ml:405:10>>*/ caml_ml_open_descriptor_in
        ( /*<<stdlib.ml:405:28>>*/ caml_sys_open(name, mode, perm));
     /*<<stdlib.ml:406:2>>*/  /*<<stdlib.ml:406:2>>*/ caml_ml_set_channel_name
     (c, name);
     /*<<stdlib.ml:406:2>>*/ return c;
    /*<<stdlib.ml:407:3>>*/ }
   function open_in(name){
     /*<<stdlib.ml:410:2>>*/ return open_in_gen(_e_, 0, name);
    /*<<stdlib.ml:410:45>>*/ }
   function open_in_bin(name){
     /*<<stdlib.ml:413:2>>*/ return open_in_gen(_f_, 0, name);
    /*<<stdlib.ml:413:47>>*/ }
   function input(ic, s, ofs, len){
     /*<<stdlib.ml:421:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
      /*<<stdlib.ml:423:7>>*/ return  /*<<stdlib.ml:423:7>>*/ caml_ml_input
             (ic, s, ofs, len);
     /*<<stdlib.ml:422:7>>*/ return invalid_arg(cst_input);
    /*<<stdlib.ml:423:32>>*/ }
   function unsafe_really_input(ic, s, ofs, len){
     /*<<stdlib.ml:426:2>>*/ var ofs$0 = ofs, len$0 = len;
     /*<<stdlib.ml:426:2>>*/ for(;;){
     if(0 >= len$0)  /*<<stdlib.ml:426:19>>*/ return 0;
      /*<<stdlib.ml:427:12>>*/  /*<<stdlib.ml:427:12>>*/ var
      r =  /*<<stdlib.ml:427:12>>*/ caml_ml_input(ic, s, ofs$0, len$0);
      /*<<stdlib.ml:428:4>>*/ if(0 === r)
       /*<<stdlib.ml:429:9>>*/ throw  /*<<stdlib.ml:429:9>>*/ caml_maybe_attach_backtrace
             (End_of_file, 1);
     var
      len$1 = len$0 - r | 0,
      ofs$1 = ofs$0 + r | 0,
      ofs$0 = ofs$1,
      len$0 = len$1;
    }
    /*<<stdlib.ml:431:5>>*/ }
   function really_input(ic, s, ofs, len){
     /*<<stdlib.ml:434:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
      /*<<stdlib.ml:436:7>>*/ return unsafe_really_input(ic, s, ofs, len);
     /*<<stdlib.ml:435:7>>*/ return invalid_arg(cst_really_input);
    /*<<stdlib.ml:436:39>>*/ }
   function really_input_string(ic, len){
     /*<<stdlib.ml:439:2>>*/  /*<<stdlib.ml:439:10>>*/ var
     s =  /*<<stdlib.ml:439:10>>*/ caml_create_bytes(len);
     /*<<stdlib.ml:440:2>>*/ really_input(ic, s, 0, len);
    return caml_string_of_bytes(s);
    /*<<stdlib.ml:441:26>>*/ }
   function input_line(chan){
     /*<<stdlib.ml:446:2>>*/ function build_result(buf, pos, param){
     var pos$0 = pos, param$0 = param;
     for(;;){
      if(! param$0)  /*<<stdlib.ml:447:10>>*/ return buf;
       /*<<stdlib.ml:449:6>>*/ var
       tl = param$0[2],
       hd = param$0[1],
        /*<<stdlib.ml:449:6>>*/ len =
          /*<<stdlib.ml:449:6>>*/ caml_ml_bytes_length(hd);
       /*<<stdlib.ml:450:6>>*/  /*<<stdlib.ml:450:6>>*/ runtime.caml_blit_bytes
       (hd, 0, buf, pos$0 - len | 0, len);
      var pos$1 = pos$0 - len | 0, pos$0 = pos$1, param$0 = tl;
     }
    }
    var accu = 0, len = 0;
     /*<<stdlib.ml:453:4>>*/ for(;;){
      /*<<stdlib.ml:453:12>>*/  /*<<stdlib.ml:453:12>>*/ var
      n =  /*<<stdlib.ml:453:12>>*/ runtime.caml_ml_input_scan_line(chan);
      /*<<stdlib.ml:454:4>>*/ if(0 === n){
      if(! accu)
        /*<<stdlib.ml:456:14>>*/ throw  /*<<stdlib.ml:456:14>>*/ caml_maybe_attach_backtrace
              (End_of_file, 1);
      var
       _l_ =
         build_result
          ( /*<<stdlib.ml:457:27>>*/ caml_create_bytes(len), len, accu);
     }
     else{
      if(0 >= n){
        /*<<stdlib.ml:467:16>>*/  /*<<stdlib.ml:467:16>>*/ var
        beg =  /*<<stdlib.ml:467:16>>*/ caml_create_bytes(- n | 0);
        /*<<stdlib.ml:468:12>>*/  /*<<stdlib.ml:468:12>>*/ caml_ml_input
        (chan, beg, 0, - n | 0);
        /*<<stdlib.ml:469:11>>*/ var
        len$1 = len - n | 0,
         /*<<stdlib.ml:469:11>>*/ accu$0 = [0, beg, accu],
        accu = accu$0,
        len = len$1;
       continue;
      }
       /*<<stdlib.ml:459:16>>*/  /*<<stdlib.ml:459:16>>*/ var
       res =  /*<<stdlib.ml:459:16>>*/ caml_create_bytes(n - 1 | 0);
       /*<<stdlib.ml:460:13>>*/  /*<<stdlib.ml:460:13>>*/ caml_ml_input
       (chan, res, 0, n - 1 | 0);
       /*<<stdlib.ml:461:13>>*/  /*<<stdlib.ml:461:13>>*/ caml_ml_input_char
       (chan);
      if(accu)
       var
        len$0 = (len + n | 0) - 1 | 0,
        _l_ =
          build_result
           ( /*<<stdlib.ml:465:27>>*/ caml_create_bytes(len$0),
            len$0,
            [0, res, accu]);
      else
       var _l_ = res;
     }
      /*<<stdlib.ml:471:28>>*/ return  /*<<stdlib.ml:471:28>>*/ caml_string_of_bytes
             (_l_);
    }
    /*<<stdlib.ml:471:39>>*/ }
   function close_in_noerr(ic){
     /*<<stdlib.ml:480:24>>*/ try{
      /*<<stdlib.ml:480:29>>*/  /*<<stdlib.ml:480:29>>*/ var
      _j_ =  /*<<stdlib.ml:480:29>>*/ caml_ml_close_channel(ic);
      /*<<stdlib.ml:480:29>>*/ return _j_;
    }
    catch(_k_){ /*<<stdlib.ml:480:51>>*/ return 0;}
    /*<<stdlib.ml:480:54>>*/ }
   function print_char(c){
     /*<<stdlib.ml:486:19>>*/ return  /*<<stdlib.ml:486:19>>*/ caml_ml_output_char
            (stdout, c);
    /*<<stdlib.ml:486:39>>*/ }
   function print_string(s){
     /*<<stdlib.ml:487:21>>*/ return output_string(stdout, s);
    /*<<stdlib.ml:487:43>>*/ }
   function print_bytes(s){
     /*<<stdlib.ml:488:20>>*/ return output_bytes(stdout, s);
    /*<<stdlib.ml:488:41>>*/ }
   function print_int(i){
     /*<<stdlib.ml:489:18>>*/ return output_string(stdout, "" + i);
    /*<<stdlib.ml:489:56>>*/ }
   function print_float(f){
     /*<<stdlib.ml:490:20>>*/ return output_string(stdout, string_of_float(f));
    /*<<stdlib.ml:490:60>>*/ }
   function print_endline(s){
     /*<<stdlib.ml:492:2>>*/ output_string(stdout, s);
     /*<<stdlib.ml:492:26>>*/  /*<<stdlib.ml:492:26>>*/ caml_ml_output_char
     (stdout, 10);
     /*<<stdlib.ml:492:51>>*/ return  /*<<stdlib.ml:492:51>>*/ caml_ml_flush
            (stdout);
    /*<<stdlib.ml:492:63>>*/ }
   function print_newline(param){
     /*<<stdlib.ml:493:23>>*/  /*<<stdlib.ml:493:23>>*/ caml_ml_output_char
     (stdout, 10);
     /*<<stdlib.ml:493:48>>*/ return  /*<<stdlib.ml:493:48>>*/ caml_ml_flush
            (stdout);
    /*<<stdlib.ml:493:60>>*/ }
   function prerr_char(c){
     /*<<stdlib.ml:497:19>>*/ return  /*<<stdlib.ml:497:19>>*/ caml_ml_output_char
            (stderr, c);
    /*<<stdlib.ml:497:39>>*/ }
   function prerr_string(s){
     /*<<stdlib.ml:498:21>>*/ return output_string(stderr, s);
    /*<<stdlib.ml:498:43>>*/ }
   function prerr_bytes(s){
     /*<<stdlib.ml:499:20>>*/ return output_bytes(stderr, s);
    /*<<stdlib.ml:499:41>>*/ }
   function prerr_int(i){
     /*<<stdlib.ml:500:18>>*/ return output_string(stderr, "" + i);
    /*<<stdlib.ml:500:56>>*/ }
   function prerr_float(f){
     /*<<stdlib.ml:501:20>>*/ return output_string(stderr, string_of_float(f));
    /*<<stdlib.ml:501:60>>*/ }
   function prerr_endline(s){
     /*<<stdlib.ml:503:2>>*/ output_string(stderr, s);
     /*<<stdlib.ml:503:26>>*/  /*<<stdlib.ml:503:26>>*/ caml_ml_output_char
     (stderr, 10);
     /*<<stdlib.ml:503:51>>*/ return  /*<<stdlib.ml:503:51>>*/ caml_ml_flush
            (stderr);
    /*<<stdlib.ml:503:63>>*/ }
   function prerr_newline(param){
     /*<<stdlib.ml:504:23>>*/  /*<<stdlib.ml:504:23>>*/ caml_ml_output_char
     (stderr, 10);
     /*<<stdlib.ml:504:48>>*/ return  /*<<stdlib.ml:504:48>>*/ caml_ml_flush
            (stderr);
    /*<<stdlib.ml:504:60>>*/ }
   function read_line(param){
     /*<<stdlib.ml:508:19>>*/  /*<<stdlib.ml:508:19>>*/ caml_ml_flush(stdout);
     /*<<stdlib.ml:314:12>>*/ return input_line(stdin);
    /*<<stdlib.ml:508:49>>*/ }
   function read_int(param){
     /*<<stdlib.ml:509:18>>*/ return  /*<<stdlib.ml:509:18>>*/ caml_int_of_string
            (read_line(0));
    /*<<stdlib.ml:509:44>>*/ }
   function read_int_opt(param){
     /*<<stdlib.ml:510:22>>*/ return int_of_string_opt(read_line(0));
    /*<<stdlib.ml:510:52>>*/ }
   function read_float(param){
     /*<<stdlib.ml:511:20>>*/ return  /*<<stdlib.ml:511:20>>*/ caml_float_of_string
            (read_line(0));
    /*<<stdlib.ml:511:48>>*/ }
   function read_float_opt(param){
     /*<<stdlib.ml:512:24>>*/ return float_of_string_opt(read_line(0));
    /*<<stdlib.ml:512:56>>*/ }
   function string_of_format(param){
    var str = param[2];
     /*<<stdlib.ml:538:44>>*/ return str;
   }
   function symbol$1(param, _h_){
     /*<<stdlib.ml:546:10>>*/ var
     str2 = _h_[2],
     fmt2 = _h_[1],
     str1 = param[2],
     fmt1 = param[1],
      /*<<stdlib.ml:546:10>>*/ _i_ = symbol(str1, symbol(cst$0, str2));
     /*<<stdlib.ml:545:2>>*/ return [0,
             /*<<stdlib.ml:545:10>>*/ caml_call2
             (CamlinternalFormatBasics[3], fmt1, fmt2),
            _i_];
   }
    /*<<stdlib.ml:559:20>>*/  /*<<stdlib.ml:559:20>>*/ var
    exit_function = [0, flush_all];
   function at_exit(f){
     /*<<stdlib.ml:563:2>>*/ for(;;){
      /*<<stdlib.ml:563:21>>*/ var
       /*<<stdlib.ml:563:21>>*/ f_yet_to_run = [0, 1],
       /*<<stdlib.ml:564:2>>*/ old_exit =
         /*<<stdlib.ml:564:2>>*/ caml_atomic_load(exit_function);
     let f_yet_to_run$0 = f_yet_to_run, old_exit$0 = old_exit;
      /*<<stdlib.ml:570:2>>*/ var
      new_exit =
        function(param){
          /*<<stdlib.ml:566:4>>*/ if(caml_atomic_cas(f_yet_to_run$0, 1, 0))
           /*<<stdlib.ml:566:59>>*/  /*<<stdlib.ml:566:59>>*/ caml_call1(f, 0);
          /*<<stdlib.ml:566:59>>*/ return  /*<<stdlib.ml:566:59>>*/ caml_call1
                 (old_exit$0, 0);
         /*<<stdlib.ml:567:15>>*/ },
      success = caml_atomic_cas(exit_function, old_exit, new_exit),
       /*<<stdlib.ml:570:2>>*/ _g_ = 1 - success;
     if(! _g_)  /*<<stdlib.ml:570:2>>*/ return _g_;
    }
    /*<<stdlib.ml:570:31>>*/ }
    /*<<stdlib.ml:572:30>>*/  /*<<stdlib.ml:572:30>>*/ var
    do_domain_local_at_exit =
      [0,
       function(param){
         /*<<stdlib.ml:572:45>>*/ return 0;
        /*<<stdlib.ml:572:47>>*/ }];
   function do_at_exit(param){
     /*<<stdlib.ml:575:2>>*/  /*<<stdlib.ml:575:2>>*/ caml_call1
     (do_domain_local_at_exit[1], 0);
     /*<<stdlib.ml:575:2>>*/ return  /*<<stdlib.ml:575:2>>*/ caml_call1
            (caml_atomic_load(exit_function), 0);
    /*<<stdlib.ml:576:31>>*/ }
   function exit(retcode){
     /*<<stdlib.ml:579:2>>*/ do_at_exit(0);
     /*<<stdlib.ml:580:2>>*/ return  /*<<stdlib.ml:580:2>>*/ runtime.caml_sys_exit
            (retcode);
    /*<<stdlib.ml:580:18>>*/ }
    /*<<stdlib.ml:582:8>>*/  /*<<stdlib.ml:582:8>>*/ runtime.caml_register_named_value
    ("Pervasives.do_at_exit", do_at_exit);
   var
    Stdlib =
      [0,
       invalid_arg,
       failwith,
       Exit,
       Match_failure,
       Assert_failure,
       Invalid_argument,
       Failure,
       Not_found,
       Out_of_memory,
       Stack_overflow,
       Sys_error,
       End_of_file,
       Division_by_zero,
       Sys_blocked_io,
       Undefined_recursive_module,
       min,
       max,
       abs,
       2147483647,
       -2147483648,
       lnot,
       infinity,
       neg_infinity,
       nan,
       max_float,
       min_float,
       epsilon_float,
       symbol,
       char_of_int,
       string_of_bool,
       bool_of_string_opt,
       bool_of_string,
       string_of_int,
       int_of_string_opt,
       string_of_float,
       float_of_string_opt,
       symbol$0,
       stdin,
       stdout,
       stderr,
       print_char,
       print_string,
       print_bytes,
       print_int,
       print_float,
       print_endline,
       print_newline,
       prerr_char,
       prerr_string,
       prerr_bytes,
       prerr_int,
       prerr_float,
       prerr_endline,
       prerr_newline,
       read_line,
       read_int_opt,
       read_int,
       read_float_opt,
       read_float,
       open_out,
       open_out_bin,
       open_out_gen,
       caml_ml_flush,
       flush_all,
       caml_ml_output_char,
       output_string,
       output_bytes,
       output,
       output_substring,
       caml_ml_output_char,
       runtime.caml_ml_output_int,
       output_value,
       runtime.caml_ml_seek_out,
       runtime.caml_ml_pos_out,
       caml_ml_channel_size,
       close_out,
       close_out_noerr,
       caml_ml_set_binary_mode,
       open_in,
       open_in_bin,
       open_in_gen,
       caml_ml_input_char,
       input_line,
       input,
       really_input,
       really_input_string,
       caml_ml_input_char,
       runtime.caml_ml_input_int,
       runtime.caml_input_value,
       runtime.caml_ml_seek_in,
       runtime.caml_ml_pos_in,
       caml_ml_channel_size,
       caml_ml_close_channel,
       close_in_noerr,
       caml_ml_set_binary_mode,
       [0,
        runtime.caml_ml_seek_out_64,
        runtime.caml_ml_pos_out_64,
        caml_ml_channel_size_64,
        runtime.caml_ml_seek_in_64,
        runtime.caml_ml_pos_in_64,
        caml_ml_channel_size_64],
       string_of_format,
       symbol$1,
       exit,
       at_exit,
       valid_float_lexem,
       unsafe_really_input,
       do_at_exit,
       do_domain_local_at_exit];
   runtime.caml_register_global(45, Stdlib, "Stdlib");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Either
(function(globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function left(v){
     /*<<either.ml:18:13>>*/ return [0, v];
    /*<<either.ml:18:19>>*/ }
   function right(v){
     /*<<either.ml:19:14>>*/ return [1, v];
    /*<<either.ml:19:21>>*/ }
   function is_left(param){
     /*<<either.ml:21:14>>*/ return 0 === param[0] ? 1 : 0;
    /*<<either.ml:23:18>>*/ }
   function is_right(param){
     /*<<either.ml:25:15>>*/ return 0 === param[0] ? 0 : 1;
    /*<<either.ml:27:17>>*/ }
   function find_left(param){
     /*<<either.ml:29:16>>*/ if(0 !== param[0])
      /*<<either.ml:31:13>>*/ return 0;
    var v = param[1];
     /*<<either.ml:30:12>>*/ return [0, v];
    /*<<either.ml:31:17>>*/ }
   function find_right(param){
     /*<<either.ml:33:17>>*/ if(0 === param[0])
      /*<<either.ml:34:12>>*/ return 0;
    var v = param[1];
     /*<<either.ml:35:13>>*/ return [0, v];
    /*<<either.ml:35:19>>*/ }
   function map_left(f, e){
     /*<<?>>*/ if(0 !== e[0])  /*<<either.ml:39:18>>*/ return e;
    var v = e[1];
     /*<<either.ml:38:12>>*/ return [0,
             /*<<either.ml:38:17>>*/ caml_call1(f, v)];
   }
   function map_right(f, e){
     /*<<?>>*/ if(0 === e[0])  /*<<either.ml:42:17>>*/ return e;
    var v = e[1];
     /*<<either.ml:43:13>>*/ return [1,
             /*<<either.ml:43:19>>*/ caml_call1(f, v)];
   }
   function map(left, right, param){
     /*<<?>>*/ if(0 === param[0]){
     var v = param[1];
      /*<<either.ml:46:12>>*/ return [0,
              /*<<either.ml:46:17>>*/ caml_call1(left, v)];
    }
    var v$0 = param[1];
     /*<<either.ml:47:13>>*/ return [1,
             /*<<either.ml:47:19>>*/ caml_call1(right, v$0)];
   }
   function fold(left, right, param){
     /*<<?>>*/ if(0 === param[0]){
     var v = param[1];
      /*<<either.ml:50:12>>*/ return  /*<<either.ml:50:12>>*/ caml_call1
             (left, v);
    }
    var v$0 = param[1];
     /*<<either.ml:51:13>>*/ return  /*<<either.ml:51:13>>*/ caml_call1
            (right, v$0);
   }
   function equal(left, right, e1, e2){
     /*<<either.ml:57:31>>*/ if(0 === e1[0]){
     var v1 = e1[1];
     if(0 === e2[0]){
      var v2 = e2[1];
       /*<<either.ml:58:22>>*/ return  /*<<either.ml:58:22>>*/ caml_call2
              (left, v1, v2);
     }
    }
    else{
     var v1$0 = e1[1];
     if(0 !== e2[0]){
      var v2$0 = e2[1];
       /*<<either.ml:59:24>>*/ return  /*<<either.ml:59:24>>*/ caml_call2
              (right, v1$0, v2$0);
     }
    }
     /*<<either.ml:60:39>>*/ return 0;
    /*<<either.ml:60:44>>*/ }
   function compare(left, right, e1, e2){
     /*<<either.ml:62:33>>*/ if(0 === e1[0]){
     var v1 = e1[1];
     if(0 !== e2[0])  /*<<either.ml:65:21>>*/ return -1;
     var v2 = e2[1];
      /*<<either.ml:63:22>>*/ return  /*<<either.ml:63:22>>*/ caml_call2
             (left, v1, v2);
    }
    var v1$0 = e1[1];
    if(0 === e2[0])  /*<<either.ml:66:21>>*/ return 1;
    var v2$0 = e2[1];
     /*<<either.ml:64:24>>*/ return  /*<<either.ml:64:24>>*/ caml_call2
            (right, v1$0, v2$0);
    /*<<either.ml:66:22>>*/ }
   var
    Stdlib_Either =
      [0,
       left,
       right,
       is_left,
       is_right,
       find_left,
       find_right,
       map_left,
       map_right,
       map,
       fold,
       fold,
       fold,
       equal,
       compare];
   runtime.caml_register_global(0, Stdlib_Either, "Stdlib__Either");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Sys
//# unitInfo: Requires: Stdlib
(function
  (globalThis){
   "use strict";
    /*<<sys.ml.in:36:22>>*/ var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    ocaml_version = "5.1.1",
    ocaml_release = [0, 5, 1, 1, 0],
    Stdlib = global_data.Stdlib,
     /*<<sys.ml.in:36:22>>*/ executable_name =
       /*<<sys.ml.in:36:22>>*/ runtime.caml_sys_executable_name(0),
    os_type =  /*<<sys.ml.in:37:22>>*/ runtime.caml_sys_get_config(0)[1],
    backend_type = [0, "js_of_ocaml"],
    unix = runtime.caml_sys_const_ostype_unix(0),
    win32 = runtime.caml_sys_const_ostype_win32(0),
    cygwin = runtime.caml_sys_const_ostype_cygwin(0),
    max_array_length = runtime.caml_sys_const_max_wosize(0),
    max_floatarray_length = max_array_length / 2 | 0,
    max_string_length = (4 * max_array_length | 0) - 1 | 0;
   function getenv_opt(s){
     /*<<sys.ml.in:60:2>>*/ try{
      /*<<sys.ml.in:60:6>>*/  /*<<sys.ml.in:60:6>>*/ var
      _d_ = [0,  /*<<sys.ml.in:60:11>>*/ runtime.caml_sys_getenv(s)];
      /*<<sys.ml.in:60:6>>*/ return _d_;
    }
    catch(_e_){
     var _c_ = caml_wrap_exception(_e_);
     if(_c_ === Stdlib[8])  /*<<sys.ml.in:61:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_c_, 0);
    }
    /*<<sys.ml.in:61:24>>*/ }
    /*<<sys.ml.in:72:18>>*/  /*<<sys.ml.in:72:18>>*/ var interactive = [0, 0];
   function set_signal(sig_num, sig_beh){ /*<<sys.ml.in:82:33>>*/ return 0;
    /*<<sys.ml.in:82:63>>*/ }
    /*<<sys.ml.in:113:0>>*/  /*<<sys.ml.in:113:0>>*/ var
    Break = [248, "Stdlib.Sys.Break", runtime.caml_fresh_oo_id(0)];
   function catch_break(on){
     /*<<sys.ml.in:116:2>>*/ return on ? 0 : 0;
    /*<<sys.ml.in:119:36>>*/ }
   function Make(_b_, _a_){ /*<<sys.ml.in:163:70>>*/ return [0, 1];}
    /*<<sys.ml.in:155:21>>*/ var
     /*<<sys.ml.in:155:21>>*/ Immediate64 = [0, Make],
    Stdlib_Sys =
      [0,
       executable_name,
       getenv_opt,
       interactive,
       os_type,
       backend_type,
       unix,
       win32,
       cygwin,
       32,
       32,
       0,
       max_string_length,
       max_array_length,
       max_floatarray_length,
       set_signal,
       -1,
       -2,
       -3,
       -4,
       -5,
       -6,
       -7,
       -8,
       -9,
       -10,
       -11,
       -12,
       -13,
       -14,
       -15,
       -16,
       -17,
       -18,
       -19,
       -20,
       -21,
       -22,
       -23,
       -24,
       -25,
       -26,
       -27,
       -28,
       Break,
       catch_break,
       ocaml_version,
       0,
       ocaml_release,
       runtime.caml_ml_enable_runtime_warnings,
       runtime.caml_ml_runtime_warnings_enabled,
       Immediate64];
   runtime.caml_register_global(4, Stdlib_Sys, "Stdlib__Sys");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Obj
//# unitInfo: Requires: Stdlib, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Obj_extension_constructor$1 = "Obj.extension_constructor",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_obj_tag = runtime.caml_obj_tag;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Sys = global_data.Stdlib__Sys;
   function is_block(a){
     /*<<obj.ml:26:34>>*/ return 1 - (typeof a === "number" ? 1 : 0);
    /*<<obj.ml:26:48>>*/ }
   var
    double_field = runtime.caml_array_get,
    set_double_field = runtime.caml_array_set,
    _a_ = [0, "obj.ml", 94, 4],
    cst_Obj_extension_constructor = cst_Obj_extension_constructor$1,
    cst_Obj_extension_constructor$0 = cst_Obj_extension_constructor$1;
   function info(obj){
     /*<<obj.ml:94:4>>*/ if( /*<<obj.ml:94:12>>*/ caml_obj_tag(obj) !== 247)
      /*<<obj.ml:94:4>>*/ throw  /*<<obj.ml:94:4>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _a_], 1);
     /*<<obj.ml:95:16>>*/ var
      /*<<obj.ml:95:16>>*/ info =
        /*<<obj.ml:95:16>>*/ runtime.caml_obj_raw_field(obj, 1),
     arity = 64 === Stdlib_Sys[9] ? info >> 56 : info >> 24,
      /*<<obj.ml:89:13>>*/ start_env = info << 8 >>> 9 | 0;
     /*<<obj.ml:90:4>>*/ return [0, arity, start_env];
    /*<<obj.ml:95:33>>*/ }
   function of_val(x){
     /*<<obj.ml:102:4>>*/ a:
    {
     if
      (is_block(x)
       &&  /*<<obj.ml:104:25>>*/ caml_obj_tag(x) !== 248 && 1 <= x.length - 1){var slot = x[1]; break a;}
     var slot = x;
    }
    a:
    {
     if(is_block(slot) &&  /*<<obj.ml:108:28>>*/ caml_obj_tag(slot) === 248){var name = slot[1]; break a;}
     var
      name =
         /*<<obj.ml:109:11>>*/ caml_call1
         (Stdlib[1], cst_Obj_extension_constructor$0);
    }
    return  /*<<obj.ml:111:9>>*/ caml_obj_tag(name) === 252
            ? slot
            :  /*<<obj.ml:112:11>>*/ caml_call1
              (Stdlib[1], cst_Obj_extension_constructor);
    /*<<obj.ml:112:50>>*/ }
   function name(slot){
     /*<<obj.ml:115:5>>*/ return slot[1];
    /*<<obj.ml:115:30>>*/ }
   function id(slot){
     /*<<obj.ml:118:5>>*/ return slot[2];
    /*<<obj.ml:118:30>>*/ }
    /*<<obj.ml:99:0>>*/ var
     /*<<obj.ml:99:0>>*/ Extension_constructor = [0, of_val, name, id],
    max_ephe_length = Stdlib_Sys[13] - 2 | 0,
    cst_Obj_Ephemeron_create = "Obj.Ephemeron.create",
    cst_Obj_Ephemeron_get_key = "Obj.Ephemeron.get_key",
    cst_Obj_Ephemeron_get_key_copy = "Obj.Ephemeron.get_key_copy",
    cst_Obj_Ephemeron_set_key = "Obj.Ephemeron.set_key",
    cst_Obj_Ephemeron_unset_key = "Obj.Ephemeron.unset_key",
    cst_Obj_Ephemeron_check_key = "Obj.Ephemeron.check_key",
    cst_Obj_Ephemeron_blit_key = "Obj.Ephemeron.blit_key";
   function create(l){
     /*<<obj.ml:132:4>>*/ var
     _g_ = 0 <= l ? 1 : 0,
     _h_ = _g_ ? l <= max_ephe_length ? 1 : 0 : _g_;
    if(1 - _h_)
      /*<<obj.ml:133:6>>*/  /*<<obj.ml:133:6>>*/ caml_call1
      (Stdlib[1], cst_Obj_Ephemeron_create);
     /*<<obj.ml:134:4>>*/ return  /*<<obj.ml:134:4>>*/ runtime.caml_ephe_create
            (l);
    /*<<obj.ml:134:12>>*/ }
   function length(x){
     /*<<obj.ml:136:17>>*/ return x.length - 1 - 2 | 0;
    /*<<obj.ml:136:49>>*/ }
   function raise_if_invalid_offset(e, o, msg){
     /*<<obj.ml:139:4>>*/ var
     _d_ = 0 <= o ? 1 : 0,
     _e_ = _d_ ? o < length(e) ? 1 : 0 : _d_,
     _f_ = 1 - _e_;
    return _f_ ?  /*<<obj.ml:140:6>>*/ caml_call1(Stdlib[1], msg) : _f_;
    /*<<obj.ml:140:21>>*/ }
   function get_key(e, o){
     /*<<obj.ml:144:4>>*/ raise_if_invalid_offset
     (e, o, cst_Obj_Ephemeron_get_key);
     /*<<obj.ml:145:4>>*/ return  /*<<obj.ml:145:4>>*/ runtime.caml_ephe_get_key
            (e, o);
    /*<<obj.ml:145:15>>*/ }
   function get_key_copy(e, o){
     /*<<obj.ml:149:4>>*/ raise_if_invalid_offset
     (e, o, cst_Obj_Ephemeron_get_key_copy);
     /*<<obj.ml:150:4>>*/ return  /*<<obj.ml:150:4>>*/ runtime.caml_ephe_get_key_copy
            (e, o);
    /*<<obj.ml:150:20>>*/ }
   function set_key(e, o, x){
     /*<<obj.ml:154:4>>*/ raise_if_invalid_offset
     (e, o, cst_Obj_Ephemeron_set_key);
     /*<<obj.ml:155:4>>*/ return  /*<<obj.ml:155:4>>*/ runtime.caml_ephe_set_key
            (e, o, x);
    /*<<obj.ml:155:17>>*/ }
   function unset_key(e, o){
     /*<<obj.ml:159:4>>*/ raise_if_invalid_offset
     (e, o, cst_Obj_Ephemeron_unset_key);
     /*<<obj.ml:160:4>>*/ return  /*<<obj.ml:160:4>>*/ runtime.caml_ephe_unset_key
            (e, o);
    /*<<obj.ml:160:17>>*/ }
   function check_key(e, o){
     /*<<obj.ml:164:4>>*/ raise_if_invalid_offset
     (e, o, cst_Obj_Ephemeron_check_key);
     /*<<obj.ml:165:4>>*/ return  /*<<obj.ml:165:4>>*/ runtime.caml_ephe_check_key
            (e, o);
    /*<<obj.ml:165:17>>*/ }
   function blit_key(e1, o1, e2, o2, l){
     /*<<obj.ml:171:4>>*/ if
     (0 <= l
      &&
       0 <= o1
       && (length(e1) - l | 0) >= o1 && 0 <= o2 && (length(e2) - l | 0) >= o2){
     var
      _b_ = 0 !== l ? 1 : 0,
      _c_ =
        _b_
         ?  /*<<obj.ml:174:24>>*/ runtime.caml_ephe_blit_key
           (e1, o1, e2, o2, l)
         : _b_;
      /*<<obj.ml:174:24>>*/ return _c_;
    }
     /*<<obj.ml:173:9>>*/ return  /*<<obj.ml:173:9>>*/ caml_call1
            (Stdlib[1], cst_Obj_Ephemeron_blit_key);
    /*<<obj.ml:174:46>>*/ }
   var
    Stdlib_Obj =
      [0,
       is_block,
       double_field,
       set_double_field,
       0,
       243,
       244,
       245,
       246,
       247,
       248,
       249,
       250,
       251,
       251,
       252,
       253,
       254,
       255,
       1000,
       1001,
       1002,
       [0, info],
       Extension_constructor,
       [0,
        create,
        length,
        get_key,
        get_key_copy,
        set_key,
        unset_key,
        check_key,
        blit_key,
        runtime.caml_ephe_get_data,
        runtime.caml_ephe_get_data_copy,
        runtime.caml_ephe_set_data,
        runtime.caml_ephe_unset_data,
        runtime.caml_ephe_check_data,
        runtime.caml_ephe_blit_data,
        max_ephe_length]];
   runtime.caml_register_global(13, Stdlib_Obj, "Stdlib__Obj");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Type
//# unitInfo: Requires: Stdlib__Obj
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Obj = global_data.Stdlib__Obj,
    cst_Id = "Id",
    _a_ = [0, 0];
   function make(param){
     /*<<type.ml:32:4>>*/  /*<<type.ml:32:43>>*/ var
     Id = [248, cst_Id, runtime.caml_fresh_oo_id(0)];
     /*<<type.ml:32:12>>*/ return [0, Id];
    /*<<type.ml:32:57>>*/ }
   function uid(A){
     /*<<type.ml:35:4>>*/  /*<<type.ml:35:33>>*/ var
     _b_ =  /*<<type.ml:35:33>>*/ caml_call1(Stdlib_Obj[23][1], A[1]);
     /*<<type.ml:35:33>>*/ return  /*<<type.ml:35:33>>*/ caml_call1
            (Stdlib_Obj[23][3], _b_);
    /*<<type.ml:35:72>>*/ }
   function provably_equal(A, B){
     /*<<type.ml:40:4>>*/ return A[1] === B[1] ? _a_ : 0;
    /*<<type.ml:40:50>>*/ }
    /*<<type.ml:22:12>>*/ var
     /*<<type.ml:22:12>>*/ Id = [0, make, uid, provably_equal],
    Stdlib_Type = [0, Id];
   runtime.caml_register_global(3, Stdlib_Type, "Stdlib__Type");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Atomic
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_atomic_exchange = runtime.caml_atomic_exchange,
    caml_atomic_fetch_add = runtime.caml_atomic_fetch_add;
   function set(r, x){
     /*<<atomic.ml:24:14>>*/ caml_atomic_exchange(r, x);
    return 0;
    /*<<atomic.ml:24:35>>*/ }
   function incr(r){
     /*<<atomic.ml:25:13>>*/ caml_atomic_fetch_add(r, 1);
    return 0;
    /*<<atomic.ml:25:39>>*/ }
   function decr(r){
     /*<<atomic.ml:26:13>>*/ caml_atomic_fetch_add(r, -1);
    return 0;
    /*<<atomic.ml:26:42>>*/ }
   var
    Stdlib_Atomic =
      [0,
       function(_a_){ /*<<atomic.ml:17:0>>*/ return [0, _a_];},
       runtime.caml_atomic_load,
       set,
       caml_atomic_exchange,
       runtime.caml_atomic_cas,
       caml_atomic_fetch_add,
       incr,
       decr];
   runtime.caml_register_global(0, Stdlib_Atomic, "Stdlib__Atomic");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: CamlinternalLazy
//# unitInfo: Requires: Stdlib, Stdlib__Obj
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_lazy_update_to_forward = runtime.caml_lazy_update_to_forward,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<camlinternalLazy.ml:20:0>>*/ var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Obj = global_data.Stdlib__Obj,
     /*<<camlinternalLazy.ml:20:0>>*/ Undefined =
      [248, "CamlinternalLazy.Undefined", runtime.caml_fresh_oo_id(0)];
   function force_gen_lazy_block(only_val, blk){
     /*<<camlinternalLazy.ml:72:2>>*/ if
     (0
      !==
        /*<<camlinternalLazy.ml:72:8>>*/ runtime.caml_lazy_update_to_forcing
        (blk))
      /*<<camlinternalLazy.ml:75:9>>*/ throw  /*<<camlinternalLazy.ml:75:9>>*/ caml_maybe_attach_backtrace
            (Undefined, 1);
    if(only_val){
      /*<<camlinternalLazy.ml:61:25>>*/  /*<<camlinternalLazy.ml:61:25>>*/ var
      closure$0 = blk[1];
      /*<<camlinternalLazy.ml:62:2>>*/ blk[1] = 0;
      /*<<camlinternalLazy.ml:63:15>>*/  /*<<camlinternalLazy.ml:63:15>>*/ var
      result$0 =  /*<<camlinternalLazy.ml:63:15>>*/ caml_call1(closure$0, 0);
      /*<<camlinternalLazy.ml:64:2>>*/ blk[1] = result$0;
      /*<<camlinternalLazy.ml:65:2>>*/  /*<<camlinternalLazy.ml:65:2>>*/ caml_lazy_update_to_forward
      (blk);
      /*<<camlinternalLazy.ml:65:2>>*/ return result$0;
    }
     /*<<camlinternalLazy.ml:46:25>>*/  /*<<camlinternalLazy.ml:46:25>>*/ var
     closure = blk[1];
     /*<<camlinternalLazy.ml:47:2>>*/ blk[1] = 0;
     /*<<camlinternalLazy.ml:47:2>>*/ try{
      /*<<camlinternalLazy.ml:49:17>>*/  /*<<camlinternalLazy.ml:49:17>>*/ var
      result =  /*<<camlinternalLazy.ml:49:17>>*/ caml_call1(closure, 0);
      /*<<camlinternalLazy.ml:50:4>>*/ blk[1] = result;
      /*<<camlinternalLazy.ml:51:4>>*/  /*<<camlinternalLazy.ml:51:4>>*/ caml_lazy_update_to_forward
      (blk);
      /*<<camlinternalLazy.ml:51:4>>*/ return result;
    }
    catch(e$0){
     var e = caml_wrap_exception(e$0);
      /*<<camlinternalLazy.ml:54:4>>*/ blk[1] =
      function(param){
        /*<<camlinternalLazy.ml:54:43>>*/ throw  /*<<camlinternalLazy.ml:54:43>>*/ caml_maybe_attach_backtrace
              (e, 0);
       /*<<camlinternalLazy.ml:54:50>>*/ };
      /*<<camlinternalLazy.ml:55:4>>*/  /*<<camlinternalLazy.ml:55:4>>*/ runtime.caml_lazy_reset_to_lazy
      (blk);
      /*<<camlinternalLazy.ml:56:4>>*/ throw  /*<<camlinternalLazy.ml:56:4>>*/ caml_maybe_attach_backtrace
            (e, 0);
    }
    /*<<camlinternalLazy.ml:75:24>>*/ }
   function force_lazy_block(blk){
     /*<<camlinternalLazy.ml:78:27>>*/ return force_gen_lazy_block(0, blk);
    /*<<camlinternalLazy.ml:78:67>>*/ }
   function force_gen(only_val, lzv){
     /*<<camlinternalLazy.ml:93:2>>*/  /*<<camlinternalLazy.ml:99:10>>*/ var
     t =  /*<<camlinternalLazy.ml:99:10>>*/ runtime.caml_obj_tag(lzv);
    if(t === Stdlib_Obj[12])
      /*<<camlinternalLazy.ml:101:13>>*/ return lzv[1];
    if(t === Stdlib_Obj[6])
      /*<<camlinternalLazy.ml:103:35>>*/ throw  /*<<camlinternalLazy.ml:103:35>>*/ caml_maybe_attach_backtrace
            (Undefined, 1);
    return t !== Stdlib_Obj[8] ? lzv : force_gen_lazy_block(only_val, lzv);
    /*<<camlinternalLazy.ml:105:41>>*/ }
   var CamlinternalLazy = [0, Undefined, force_lazy_block, force_gen];
   runtime.caml_register_global(2, CamlinternalLazy, "CamlinternalLazy");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Lazy
//# unitInfo: Requires: CamlinternalLazy, Stdlib, Stdlib__Obj
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, caml_obj_tag = runtime.caml_obj_tag;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    CamlinternalLazy = global_data.CamlinternalLazy,
    Stdlib_Obj = global_data.Stdlib__Obj,
    Undefined = CamlinternalLazy[1];
   function force_val(l){
     /*<<lazy.ml:56:18>>*/ return  /*<<lazy.ml:56:18>>*/ caml_call2
            (CamlinternalLazy[3], 1, l);
    /*<<lazy.ml:56:61>>*/ }
   function from_fun(f){
     /*<<lazy.ml:59:2>>*/  /*<<lazy.ml:59:10>>*/ var
     x =  /*<<lazy.ml:59:10>>*/ runtime.caml_obj_block(Stdlib_Obj[8], 1);
     /*<<lazy.ml:60:2>>*/ x[1] = f;
     /*<<lazy.ml:60:2>>*/ return x;
    /*<<lazy.ml:61:22>>*/ }
   function from_val(v){
     /*<<lazy.ml:64:2>>*/  /*<<lazy.ml:64:10>>*/ var
     t =  /*<<lazy.ml:64:10>>*/ caml_obj_tag(v);
    if
     (t !== Stdlib_Obj[12]
      && t !== Stdlib_Obj[8] && t !== Stdlib_Obj[6] && t !== Stdlib_Obj[16])
      /*<<lazy.ml:69:5>>*/ return v;
     /*<<lazy.ml:66:52>>*/ return  /*<<lazy.ml:66:52>>*/ runtime.caml_lazy_make_forward
            (v);
    /*<<lazy.ml:70:5>>*/ }
   function is_val(l){
     /*<<lazy.ml:72:26>>*/  /*<<lazy.ml:72:26>>*/ var _i_ = Stdlib_Obj[8];
     /*<<lazy.ml:72:26>>*/ return  /*<<lazy.ml:72:26>>*/ caml_obj_tag(l)
            !== _i_
            ? 1
            : 0;
    /*<<lazy.ml:72:62>>*/ }
   function map(f, x){
     /*<<lazy.ml:75:2>>*/ return [246,
            function(_f_){
             var _g_ = caml_obj_tag(x);
             a:
             if(250 === _g_)
              var _h_ = x[1];
             else{
              if(246 !== _g_ && 244 !== _g_){var _h_ = x; break a;}
              var _h_ = caml_call1(CamlinternalLazy[2], x);
             }
              /*<<lazy.ml:75:10>>*/ return  /*<<lazy.ml:75:10>>*/ caml_call1
                     (f, _h_);
            }];
    /*<<lazy.ml:75:20>>*/ }
   function map_val(f, x){
     /*<<lazy.ml:78:2>>*/ if(! is_val(x))
      /*<<lazy.ml:80:12>>*/ return [246,
             function(_c_){
              var _d_ = caml_obj_tag(x);
              a:
              if(250 === _d_)
               var _e_ = x[1];
              else{
               if(246 !== _d_ && 244 !== _d_){var _e_ = x; break a;}
               var _e_ = caml_call1(CamlinternalLazy[2], x);
              }
               /*<<lazy.ml:80:15>>*/ return  /*<<lazy.ml:80:15>>*/ caml_call1
                      (f, _e_);
             }];
    var _a_ = caml_obj_tag(x);
    a:
    if(250 === _a_)
     var _b_ = x[1];
    else{
     if(246 !== _a_ && 244 !== _a_){var _b_ = x; break a;}
     var _b_ = caml_call1(CamlinternalLazy[2], x);
    }
     /*<<lazy.ml:79:16>>*/ return from_val
            ( /*<<lazy.ml:79:16>>*/ caml_call1(f, _b_));
    /*<<lazy.ml:80:25>>*/ }
   var
    Stdlib_Lazy =
      [0, Undefined, map, is_val, from_val, map_val, from_fun, force_val];
   runtime.caml_register_global(2, Stdlib_Lazy, "Stdlib__Lazy");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Seq
//# unitInfo: Requires: CamlinternalLazy, Stdlib, Stdlib__Atomic, Stdlib__Lazy
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Assert_failure = global_data.Assert_failure,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    CamlinternalLazy = global_data.CamlinternalLazy,
    Stdlib = global_data.Stdlib,
    Stdlib_Lazy = global_data.Stdlib__Lazy,
    cst_Seq_init = "Seq.init",
    cst_Seq_take = "Seq.take",
    cst_Seq_drop = "Seq.drop";
   function empty(param){
     /*<<seq.ml:24:15>>*/ return 0;
    /*<<seq.ml:24:18>>*/ }
   function return$0(x, param){
     /*<<seq.ml:26:18>>*/ return [0, x, empty];
    /*<<seq.ml:26:33>>*/ }
   function cons(x, next, param){
     /*<<seq.ml:28:21>>*/ return [0, x, next];
    /*<<seq.ml:28:35>>*/ }
   function append(seq1, seq2, param){
     /*<<seq.ml:31:2>>*/  /*<<seq.ml:31:8>>*/ var
     match =  /*<<seq.ml:31:8>>*/ caml_call1(seq1, 0);
    if(! match)
      /*<<seq.ml:32:11>>*/ return  /*<<seq.ml:32:11>>*/ caml_call1(seq2, 0);
    var next = match[2], x = match[1];
     /*<<seq.ml:33:22>>*/ return [0,
            x,
            function(_ay_){ /*<<?>>*/ return append(next, seq2, _ay_);}];
    /*<<seq.ml:33:48>>*/ }
   function map(f, seq, param){
     /*<<seq.ml:35:23>>*/  /*<<seq.ml:35:29>>*/ var
     match =  /*<<seq.ml:35:29>>*/ caml_call1(seq, 0);
    if(! match)  /*<<seq.ml:36:11>>*/ return 0;
    var next = match[2], x = match[1];
     /*<<seq.ml:37:22>>*/ return [0,
             /*<<seq.ml:37:28>>*/ caml_call1(f, x),
            function(_ax_){ /*<<?>>*/ return map(f, next, _ax_);}];
    /*<<seq.ml:37:44>>*/ }
   function filter_map(f, seq, param){
     /*<<seq.ml:39:30>>*/ var seq$0 = seq;
     /*<<seq.ml:39:30>>*/ for(;;){
      /*<<seq.ml:39:36>>*/  /*<<seq.ml:39:36>>*/ var
      match =  /*<<seq.ml:39:36>>*/ caml_call1(seq$0, 0);
     if(! match)  /*<<seq.ml:40:11>>*/ return 0;
      /*<<seq.ml:42:12>>*/ var
      next = match[2],
      x = match[1],
       /*<<seq.ml:42:12>>*/ match$0 =  /*<<seq.ml:42:12>>*/ caml_call1(f, x);
     if(match$0){
      var y = match$0[1];
       /*<<seq.ml:44:20>>*/ return [0,
              y,
              function(_aw_){ /*<<?>>*/ return filter_map(f, next, _aw_);}];
     }
     var seq$0 = next;
    }
    /*<<seq.ml:44:47>>*/ }
   function filter(f, seq, param){
     /*<<seq.ml:46:26>>*/ var seq$0 = seq;
     /*<<seq.ml:46:26>>*/ for(;;){
      /*<<seq.ml:46:32>>*/  /*<<seq.ml:46:32>>*/ var
      match =  /*<<seq.ml:46:32>>*/ caml_call1(seq$0, 0);
     if(! match)  /*<<seq.ml:47:11>>*/ return 0;
     var next = match[2], x = match[1];
      /*<<seq.ml:49:9>>*/ if( /*<<seq.ml:49:9>>*/ caml_call1(f, x))
       /*<<seq.ml:50:11>>*/ return [0,
              x,
              function(_av_){ /*<<?>>*/ return filter(f, next, _av_);}];
     var seq$0 = next;
    }
    /*<<seq.ml:51:27>>*/ }
   function concat(seq, param){
     /*<<seq.ml:53:24>>*/  /*<<seq.ml:53:30>>*/ var
     match =  /*<<seq.ml:53:30>>*/ caml_call1(seq, 0);
    if(! match)  /*<<seq.ml:54:11>>*/ return 0;
    var next = match[2], x = match[1];
     /*<<seq.ml:56:5>>*/ return append
            (x, function(_au_){ /*<<?>>*/ return concat(next, _au_);}, 0);
    /*<<seq.ml:56:30>>*/ }
   function flat_map(f, seq, param){
     /*<<seq.ml:58:28>>*/  /*<<seq.ml:58:34>>*/ var
     match =  /*<<seq.ml:58:34>>*/ caml_call1(seq, 0);
    if(! match)  /*<<seq.ml:59:11>>*/ return 0;
    var next = match[2], x = match[1];
     /*<<seq.ml:61:4>>*/ return append
            ( /*<<seq.ml:61:11>>*/ caml_call1(f, x),
             function(_at_){ /*<<?>>*/ return flat_map(f, next, _at_);},
             0);
    /*<<seq.ml:61:37>>*/ }
   function fold_left(f, acc, seq){
     /*<<seq.ml:66:2>>*/ var acc$0 = acc, seq$0 = seq;
     /*<<seq.ml:66:2>>*/ for(;;){
      /*<<seq.ml:66:8>>*/  /*<<seq.ml:66:8>>*/ var
      match =  /*<<seq.ml:66:8>>*/ caml_call1(seq$0, 0);
     if(! match)  /*<<seq.ml:67:13>>*/ return acc$0;
      /*<<seq.ml:69:18>>*/ var
      next = match[2],
      x = match[1],
       /*<<seq.ml:69:18>>*/ acc$1 =
         /*<<seq.ml:69:18>>*/ caml_call2(f, acc$0, x),
      acc$0 = acc$1,
      seq$0 = next;
    }
    /*<<seq.ml:70:28>>*/ }
   function iter(f, seq){
     /*<<seq.ml:73:2>>*/ var seq$0 = seq;
     /*<<seq.ml:73:2>>*/ for(;;){
      /*<<seq.ml:73:8>>*/  /*<<seq.ml:73:8>>*/ var
      match =  /*<<seq.ml:73:8>>*/ caml_call1(seq$0, 0);
     if(! match)  /*<<seq.ml:74:13>>*/ return 0;
     var next = match[2], x = match[1];
      /*<<seq.ml:76:8>>*/  /*<<seq.ml:76:8>>*/ caml_call1(f, x);
     var seq$0 = next;
    }
    /*<<seq.ml:77:19>>*/ }
   function unfold(f, u, param){
     /*<<seq.ml:80:2>>*/  /*<<seq.ml:80:8>>*/ var
     match =  /*<<seq.ml:80:8>>*/ caml_call1(f, u);
    if(! match)  /*<<seq.ml:81:12>>*/ return 0;
    var match$0 = match[1], u$0 = match$0[2], x = match$0[1];
     /*<<seq.ml:82:20>>*/ return [0,
            x,
            function(_as_){ /*<<?>>*/ return unfold(f, u$0, _as_);}];
    /*<<seq.ml:82:41>>*/ }
   function is_empty(xs){
     /*<<seq.ml:85:2>>*/ return  /*<<seq.ml:85:8>>*/ caml_call1(xs, 0) ? 0 : 1;
    /*<<seq.ml:89:11>>*/ }
   function uncons(xs){
     /*<<seq.ml:92:2>>*/  /*<<seq.ml:92:8>>*/ var
     match =  /*<<seq.ml:92:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:96:6>>*/ return 0;
    var xs$0 = match[2], x = match[1];
     /*<<seq.ml:94:6>>*/ return [0, [0, x, xs$0]];
    /*<<seq.ml:96:10>>*/ }
   function length(xs$1){
     /*<<seq.ml:108:2>>*/ var accu = 0, xs = xs$1;
     /*<<seq.ml:101:2>>*/ for(;;){
      /*<<seq.ml:101:8>>*/  /*<<seq.ml:101:8>>*/ var
      match =  /*<<seq.ml:101:8>>*/ caml_call1(xs, 0);
     if(! match)  /*<<seq.ml:103:6>>*/ return accu;
      /*<<seq.ml:105:6>>*/ var
      xs$0 = match[2],
       /*<<seq.ml:105:6>>*/ accu$0 = accu + 1 | 0,
      accu = accu$0,
      xs = xs$0;
    }
    /*<<seq.ml:108:17>>*/ }
   function iteri(f, xs$1){
     /*<<seq.ml:119:2>>*/ var i = 0, xs = xs$1;
     /*<<seq.ml:111:2>>*/ for(;;){
      /*<<seq.ml:111:8>>*/  /*<<seq.ml:111:8>>*/ var
      match =  /*<<seq.ml:111:8>>*/ caml_call1(xs, 0);
     if(! match)  /*<<seq.ml:113:6>>*/ return 0;
     var xs$0 = match[2], x = match[1];
      /*<<seq.ml:115:6>>*/  /*<<seq.ml:115:6>>*/ caml_call2(f, i, x);
     var i$0 = i + 1 | 0, i = i$0, xs = xs$0;
    }
    /*<<seq.ml:119:18>>*/ }
   function fold_lefti(f, accu$1, xs$1){
     /*<<seq.ml:130:2>>*/ var accu = accu$1, i = 0, xs = xs$1;
     /*<<seq.ml:122:2>>*/ for(;;){
      /*<<seq.ml:122:8>>*/  /*<<seq.ml:122:8>>*/ var
      match =  /*<<seq.ml:122:8>>*/ caml_call1(xs, 0);
     if(! match)  /*<<seq.ml:124:6>>*/ return accu;
      /*<<seq.ml:126:17>>*/ var
      xs$0 = match[2],
      x = match[1],
       /*<<seq.ml:126:17>>*/ accu$0 =
         /*<<seq.ml:126:17>>*/ caml_call3(f, accu, i, x),
       /*<<seq.ml:127:6>>*/ i$0 = i + 1 | 0,
      accu = accu$0,
      i = i$0,
      xs = xs$0;
    }
    /*<<seq.ml:130:28>>*/ }
   function for_all(p, xs){
     /*<<seq.ml:133:2>>*/ var xs$0 = xs;
     /*<<seq.ml:133:2>>*/ for(;;){
      /*<<seq.ml:133:8>>*/  /*<<seq.ml:133:8>>*/ var
      match =  /*<<seq.ml:133:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:135:6>>*/ return 1;
      /*<<seq.ml:137:6>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:137:6>>*/ _ar_ =  /*<<seq.ml:137:6>>*/ caml_call1(p, x);
      /*<<seq.ml:137:6>>*/ if(! _ar_)  /*<<seq.ml:137:6>>*/ return _ar_;
     var xs$0 = xs$1;
    }
    /*<<seq.ml:137:25>>*/ }
   function exists(p, xs){
     /*<<seq.ml:140:2>>*/ var xs$0 = xs;
     /*<<seq.ml:140:2>>*/ for(;;){
      /*<<seq.ml:140:8>>*/  /*<<seq.ml:140:8>>*/ var
      match =  /*<<seq.ml:140:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:142:6>>*/ return 0;
      /*<<seq.ml:144:6>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:144:6>>*/ _aq_ =  /*<<seq.ml:144:6>>*/ caml_call1(p, x);
      /*<<seq.ml:144:6>>*/ if(_aq_)  /*<<seq.ml:144:6>>*/ return _aq_;
     var xs$0 = xs$1;
    }
    /*<<seq.ml:144:24>>*/ }
   function find(p, xs){
     /*<<seq.ml:147:2>>*/ var xs$0 = xs;
     /*<<seq.ml:147:2>>*/ for(;;){
      /*<<seq.ml:147:8>>*/  /*<<seq.ml:147:8>>*/ var
      match =  /*<<seq.ml:147:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:149:6>>*/ return 0;
     var xs$1 = match[2], x = match[1];
      /*<<seq.ml:151:9>>*/ if( /*<<seq.ml:151:9>>*/ caml_call1(p, x))
       /*<<seq.ml:151:18>>*/ return [0, x];
     var xs$0 = xs$1;
    }
    /*<<seq.ml:151:39>>*/ }
   function find_index(p, xs){
     /*<<seq.ml:154:2>>*/ var i = 0, xs$0 = xs;
     /*<<seq.ml:154:21>>*/ for(;;){
      /*<<seq.ml:154:27>>*/  /*<<seq.ml:154:27>>*/ var
      match =  /*<<seq.ml:154:27>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:156:8>>*/ return 0;
     var xs$1 = match[2], x = match[1];
      /*<<seq.ml:158:11>>*/ if( /*<<seq.ml:158:11>>*/ caml_call1(p, x))
       /*<<seq.ml:158:20>>*/ return [0, i];
     var i$0 = i + 1 | 0, i = i$0, xs$0 = xs$1;
    }
    /*<<seq.ml:159:10>>*/ }
   function find_map(f, xs){
     /*<<seq.ml:162:2>>*/ var xs$0 = xs;
     /*<<seq.ml:162:2>>*/ for(;;){
      /*<<seq.ml:162:8>>*/  /*<<seq.ml:162:8>>*/ var
      match =  /*<<seq.ml:162:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:164:6>>*/ return 0;
      /*<<seq.ml:166:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:166:12>>*/ result =  /*<<seq.ml:166:12>>*/ caml_call1(f, x);
     if(result)  /*<<seq.ml:170:10>>*/ return result;
     var xs$0 = xs$1;
    }
    /*<<seq.ml:170:16>>*/ }
   function find_mapi(f, xs){
     /*<<seq.ml:173:2>>*/ var i = 0, xs$0 = xs;
     /*<<seq.ml:173:21>>*/ for(;;){
      /*<<seq.ml:173:27>>*/  /*<<seq.ml:173:27>>*/ var
      match =  /*<<seq.ml:173:27>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:175:8>>*/ return 0;
      /*<<seq.ml:177:14>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:177:14>>*/ result =
         /*<<seq.ml:177:14>>*/ caml_call2(f, i, x);
     if(result)  /*<<seq.ml:181:12>>*/ return result;
     var i$0 = i + 1 | 0, i = i$0, xs$0 = xs$1;
    }
    /*<<seq.ml:182:10>>*/ }
   function iter2(f, xs, ys){
     /*<<seq.ml:192:2>>*/ var xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:192:2>>*/ for(;;){
      /*<<seq.ml:192:8>>*/  /*<<seq.ml:192:8>>*/ var
      match =  /*<<seq.ml:192:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:194:6>>*/ return 0;
      /*<<seq.ml:196:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:196:12>>*/ match$0 =
         /*<<seq.ml:196:12>>*/ caml_call1(ys$0, 0);
     if(! match$0)  /*<<seq.ml:198:10>>*/ return 0;
     var ys$1 = match$0[2], y = match$0[1];
      /*<<seq.ml:200:10>>*/  /*<<seq.ml:200:10>>*/ caml_call2(f, x, y);
     var xs$0 = xs$1, ys$0 = ys$1;
    }
    /*<<seq.ml:201:23>>*/ }
   function fold_left2(f, accu, xs, ys){
     /*<<seq.ml:204:2>>*/ var accu$0 = accu, xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:204:2>>*/ for(;;){
      /*<<seq.ml:204:8>>*/  /*<<seq.ml:204:8>>*/ var
      match =  /*<<seq.ml:204:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:206:6>>*/ return accu$0;
      /*<<seq.ml:208:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:208:12>>*/ match$0 =
         /*<<seq.ml:208:12>>*/ caml_call1(ys$0, 0);
     if(! match$0)  /*<<seq.ml:210:10>>*/ return accu$0;
      /*<<seq.ml:212:21>>*/ var
      ys$1 = match$0[2],
      y = match$0[1],
       /*<<seq.ml:212:21>>*/ accu$1 =
         /*<<seq.ml:212:21>>*/ caml_call3(f, accu$0, x, y),
      accu$0 = accu$1,
      xs$0 = xs$1,
      ys$0 = ys$1;
    }
    /*<<seq.ml:213:33>>*/ }
   function for_all2(f, xs, ys){
     /*<<seq.ml:216:2>>*/ var xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:216:2>>*/ for(;;){
      /*<<seq.ml:216:8>>*/  /*<<seq.ml:216:8>>*/ var
      match =  /*<<seq.ml:216:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:218:6>>*/ return 1;
      /*<<seq.ml:220:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:220:12>>*/ match$0 =
         /*<<seq.ml:220:12>>*/ caml_call1(ys$0, 0);
     if(! match$0)  /*<<seq.ml:222:10>>*/ return 1;
      /*<<seq.ml:224:10>>*/ var
      ys$1 = match$0[2],
      y = match$0[1],
       /*<<seq.ml:224:10>>*/ _ap_ =  /*<<seq.ml:224:10>>*/ caml_call2(f, x, y);
      /*<<seq.ml:224:10>>*/ if(! _ap_)  /*<<seq.ml:224:10>>*/ return _ap_;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
    /*<<seq.ml:224:35>>*/ }
   function exists2(f, xs, ys){
     /*<<seq.ml:227:2>>*/ var xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:227:2>>*/ for(;;){
      /*<<seq.ml:227:8>>*/  /*<<seq.ml:227:8>>*/ var
      match =  /*<<seq.ml:227:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:229:6>>*/ return 0;
      /*<<seq.ml:231:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:231:12>>*/ match$0 =
         /*<<seq.ml:231:12>>*/ caml_call1(ys$0, 0);
     if(! match$0)  /*<<seq.ml:233:10>>*/ return 0;
      /*<<seq.ml:235:10>>*/ var
      ys$1 = match$0[2],
      y = match$0[1],
       /*<<seq.ml:235:10>>*/ _ao_ =  /*<<seq.ml:235:10>>*/ caml_call2(f, x, y);
      /*<<seq.ml:235:10>>*/ if(_ao_)  /*<<seq.ml:235:10>>*/ return _ao_;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
    /*<<seq.ml:235:34>>*/ }
   function equal(eq, xs, ys){
     /*<<seq.ml:238:2>>*/ var xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:238:2>>*/ for(;;){
      /*<<seq.ml:238:8>>*/ var
       /*<<seq.ml:238:8>>*/ match =  /*<<seq.ml:238:8>>*/ caml_call1(xs$0, 0),
       /*<<seq.ml:238:14>>*/ match$0 =
         /*<<seq.ml:238:14>>*/ caml_call1(ys$0, 0);
     if(match){
      if(match$0){
        /*<<seq.ml:242:6>>*/ var
        ys$1 = match$0[2],
        y = match$0[1],
        xs$1 = match[2],
        x = match[1],
         /*<<seq.ml:242:6>>*/ _an_ =
           /*<<seq.ml:242:6>>*/ caml_call2(eq, x, y);
        /*<<seq.ml:242:6>>*/ if(! _an_)  /*<<seq.ml:242:6>>*/ return _an_;
       var xs$0 = xs$1, ys$0 = ys$1;
       continue;
      }
     }
     else if(! match$0)  /*<<seq.ml:240:6>>*/ return 1;
      /*<<seq.ml:245:6>>*/ return 0;
    }
    /*<<seq.ml:245:11>>*/ }
   function compare(cmp, xs, ys){
     /*<<seq.ml:248:2>>*/ var xs$0 = xs, ys$0 = ys;
     /*<<seq.ml:248:2>>*/ for(;;){
      /*<<seq.ml:248:8>>*/ var
       /*<<seq.ml:248:8>>*/ match =  /*<<seq.ml:248:8>>*/ caml_call1(xs$0, 0),
       /*<<seq.ml:248:14>>*/ match$0 =
         /*<<seq.ml:248:14>>*/ caml_call1(ys$0, 0);
     if(! match) return match$0 ? -1 : 0;
     var xs$1 = match[2], x = match[1];
     if(! match$0)  /*<<seq.ml:257:6>>*/ return 1;
      /*<<seq.ml:252:14>>*/ var
      ys$1 = match$0[2],
      y = match$0[1],
       /*<<seq.ml:252:14>>*/ c =  /*<<seq.ml:252:14>>*/ caml_call2(cmp, x, y);
      /*<<seq.ml:253:6>>*/ if(0 !== c)  /*<<seq.ml:253:21>>*/ return c;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
    /*<<seq.ml:257:8>>*/ }
   function init_aux(f, i, j, param){
     /*<<seq.ml:264:2>>*/ if(i >= j)  /*<<seq.ml:268:4>>*/ return 0;
    var _al_ = i + 1 | 0;
     /*<<seq.ml:264:16>>*/ return [0,
             /*<<seq.ml:265:10>>*/ caml_call1(f, i),
            function(_am_){ /*<<?>>*/ return init_aux(f, _al_, j, _am_);}];
    /*<<seq.ml:268:7>>*/ }
   function init(n, f){
     /*<<seq.ml:271:2>>*/ if(0 > n)
      /*<<seq.ml:272:4>>*/ return  /*<<seq.ml:272:4>>*/ caml_call1
             (Stdlib[1], cst_Seq_init);
    var _aj_ = 0;
     /*<<seq.ml:274:4>>*/ return function(_ak_){
      /*<<?>>*/ return init_aux(f, _aj_, n, _ak_);};
    /*<<seq.ml:274:18>>*/ }
   function repeat(x, param){
     /*<<seq.ml:277:2>>*/ return [0,
            x,
            function(_ai_){ /*<<?>>*/ return repeat(x, _ai_);}];
    /*<<seq.ml:277:20>>*/ }
   function forever(f, param){
     /*<<seq.ml:280:2>>*/ return [0,
             /*<<seq.ml:280:8>>*/ caml_call1(f, 0),
            function(_ah_){ /*<<?>>*/ return forever(f, _ah_);}];
    /*<<seq.ml:280:23>>*/ }
   function cycle_nonempty(xs, param){
     /*<<seq.ml:287:2>>*/ return append
            (xs,
             function(_ag_){ /*<<?>>*/ return cycle_nonempty(xs, _ag_);},
             0);
    /*<<seq.ml:287:34>>*/ }
   function cycle(xs, param){
     /*<<seq.ml:295:2>>*/  /*<<seq.ml:295:8>>*/ var
     match =  /*<<seq.ml:295:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:297:6>>*/ return 0;
    var xs$0 = match[2], x = match[1];
     /*<<seq.ml:299:26>>*/ function _ad_(_af_){
      /*<<?>>*/ return cycle_nonempty(xs, _af_);
    }
     /*<<seq.ml:299:6>>*/ return [0,
            x,
            function(_ae_){ /*<<?>>*/ return append(xs$0, _ad_, _ae_);}];
    /*<<seq.ml:299:46>>*/ }
   function iterate1(f, x, param){
     /*<<seq.ml:306:2>>*/  /*<<seq.ml:306:10>>*/ var
     y =  /*<<seq.ml:306:10>>*/ caml_call1(f, x);
     /*<<seq.ml:307:2>>*/ return [0,
            y,
            function(_ac_){ /*<<?>>*/ return iterate1(f, y, _ac_);}];
    /*<<seq.ml:307:24>>*/ }
   function iterate(f, x){
     /*<<seq.ml:319:9>>*/ function _$_(_ab_){
      /*<<?>>*/ return iterate1(f, x, _ab_);
    }
     /*<<seq.ml:319:9>>*/ return function(_aa_){
      /*<<?>>*/ return [0, x, _$_];};
    /*<<seq.ml:319:23>>*/ }
   function mapi_aux(f, i, xs, param){
     /*<<seq.ml:324:2>>*/  /*<<seq.ml:324:8>>*/ var
     match =  /*<<seq.ml:324:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:326:6>>*/ return 0;
    var xs$0 = match[2], x = match[1],  /*<<seq.ml:328:6>>*/ _Z_ = i + 1 | 0;
     /*<<seq.ml:328:6>>*/ return [0,
             /*<<seq.ml:328:12>>*/ caml_call2(f, i, x),
            function(___){ /*<<?>>*/ return mapi_aux(f, _Z_, xs$0, ___);}];
    /*<<seq.ml:328:39>>*/ }
   function mapi(f, xs){
     /*<<seq.ml:331:2>>*/ var _X_ = 0;
     /*<<seq.ml:331:2>>*/ return function(_Y_){
      /*<<?>>*/ return mapi_aux(f, _X_, xs, _Y_);};
    /*<<seq.ml:331:17>>*/ }
   function tail_scan(f, s, xs, param){
     /*<<seq.ml:340:2>>*/  /*<<seq.ml:340:8>>*/ var
     match =  /*<<seq.ml:340:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:342:6>>*/ return 0;
     /*<<seq.ml:344:14>>*/ var
     xs$0 = match[2],
     x = match[1],
      /*<<seq.ml:344:14>>*/ s$0 =  /*<<seq.ml:344:14>>*/ caml_call2(f, s, x);
     /*<<seq.ml:345:6>>*/ return [0,
            s$0,
            function(_W_){ /*<<?>>*/ return tail_scan(f, s$0, xs$0, _W_);}];
    /*<<seq.ml:345:32>>*/ }
   function scan(f, s, xs){
     /*<<seq.ml:348:9>>*/ function _T_(_V_){
      /*<<?>>*/ return tail_scan(f, s, xs, _V_);
    }
     /*<<seq.ml:348:9>>*/ return function(_U_){
      /*<<?>>*/ return [0, s, _T_];};
    /*<<seq.ml:348:27>>*/ }
   function take_aux(n, xs){
     /*<<seq.ml:354:2>>*/ return 0 === n
            ? empty
            : function
             (param){
               /*<<seq.ml:358:6>>*/  /*<<seq.ml:358:12>>*/ var
               match =  /*<<seq.ml:358:12>>*/ caml_call1(xs, 0);
              if(! match)  /*<<seq.ml:360:10>>*/ return 0;
              var xs$0 = match[2], x = match[1];
               /*<<seq.ml:362:10>>*/ return [0, x, take_aux(n - 1 | 0, xs$0)];
              /*<<seq.ml:362:37>>*/ };
    /*<<seq.ml:362:37>>*/ }
   function take(n, xs){
     /*<<seq.ml:365:2>>*/ if(n < 0)
      /*<<seq.ml:365:16>>*/  /*<<seq.ml:365:16>>*/ caml_call1
      (Stdlib[1], cst_Seq_take);
     /*<<seq.ml:365:16>>*/ return take_aux(n, xs);
    /*<<seq.ml:366:15>>*/ }
   function drop(n, xs){
     /*<<seq.ml:387:2>>*/ return 0 <= n
            ? 0
              === n
              ? xs
              : function
               (param){
                 /*<<seq.ml:392:6>>*/ var n$0 = n, xs$0 = xs;
                 /*<<seq.ml:373:2>>*/ for(;;){
                  /*<<seq.ml:373:8>>*/  /*<<seq.ml:373:8>>*/ var
                  match =  /*<<seq.ml:373:8>>*/ caml_call1(xs$0, 0);
                 if(! match)  /*<<seq.ml:375:6>>*/ return 0;
                  /*<<seq.ml:377:6>>*/ var
                  xs$1 = match[2],
                   /*<<seq.ml:377:6>>*/ n$1 = n$0 - 1 | 0;
                  /*<<seq.ml:378:6>>*/ if(0 === n$1)
                   /*<<seq.ml:379:8>>*/ return  /*<<seq.ml:379:8>>*/ caml_call1
                          (xs$1, 0);
                 var n$0 = n$1, xs$0 = xs$1;
                }
                /*<<seq.ml:392:21>>*/ }
            :  /*<<seq.ml:387:16>>*/ caml_call1(Stdlib[1], cst_Seq_drop);
    /*<<seq.ml:392:21>>*/ }
   function take_while(p, xs, param){
     /*<<seq.ml:395:2>>*/  /*<<seq.ml:395:8>>*/ var
     match =  /*<<seq.ml:395:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:397:6>>*/ return 0;
    var xs$0 = match[2], x = match[1];
     /*<<seq.ml:399:9>>*/ return  /*<<seq.ml:399:9>>*/ caml_call1(p, x)
            ? [0,
              x,
              function(_S_){ /*<<?>>*/ return take_while(p, xs$0, _S_);}]
            : 0;
    /*<<seq.ml:399:52>>*/ }
   function drop_while(p, xs, param){
     /*<<seq.ml:402:2>>*/ var xs$0 = xs;
     /*<<seq.ml:402:2>>*/ for(;;){
      /*<<seq.ml:402:8>>*/  /*<<seq.ml:402:8>>*/ var
      node =  /*<<seq.ml:402:8>>*/ caml_call1(xs$0, 0);
     if(! node)  /*<<seq.ml:404:6>>*/ return 0;
     var xs$1 = node[2], x = node[1];
      /*<<seq.ml:406:9>>*/ if(!  /*<<seq.ml:406:9>>*/ caml_call1(p, x))
       /*<<seq.ml:406:42>>*/ return node;
     var xs$0 = xs$1;
    }
    /*<<seq.ml:406:46>>*/ }
   function group(eq, xs, param){
     /*<<seq.ml:409:2>>*/  /*<<seq.ml:409:8>>*/ var
     match =  /*<<seq.ml:409:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:411:6>>*/ return 0;
    var
     xs$0 = match[2],
     x = match[1],
      /*<<seq.ml:413:64>>*/ _K_ =  /*<<seq.ml:413:64>>*/ caml_call1(eq, x);
     /*<<seq.ml:413:52>>*/ function _L_(_R_){
      /*<<?>>*/ return drop_while(_K_, xs$0, _R_);
    }
     /*<<seq.ml:413:31>>*/ var _M_ =  /*<<seq.ml:413:31>>*/ caml_call1(eq, x);
     /*<<seq.ml:413:19>>*/ function _N_(_Q_){
      /*<<?>>*/ return take_while(_M_, xs$0, _Q_);
    }
     /*<<seq.ml:413:6>>*/ return [0,
            function(_P_){ /*<<?>>*/ return [0, x, _N_];},
            function(_O_){ /*<<?>>*/ return group(eq, _L_, _O_);}];
    /*<<seq.ml:413:75>>*/ }
    /*<<seq.ml:415:0>>*/ var
     /*<<seq.ml:415:0>>*/ Forced_twice =
      [248, "Stdlib.Seq.Forced_twice", runtime.caml_fresh_oo_id(0)],
     /*<<seq.ml:415:0>>*/ to_lazy = Stdlib_Lazy[6],
    _a_ = [0, "seq.ml", 616, 4];
   function failure(param){
     /*<<seq.ml:441:6>>*/ throw  /*<<seq.ml:441:6>>*/ caml_maybe_attach_backtrace
           (Forced_twice, 1);
    /*<<seq.ml:441:24>>*/ }
   function memoize(xs){
    function s$0(param){
      /*<<seq.ml:460:4>>*/  /*<<seq.ml:460:10>>*/ var
      match =  /*<<seq.ml:460:10>>*/ caml_call1(xs, 0);
     if(! match)  /*<<seq.ml:462:8>>*/ return 0;
     var xs$0 = match[2], x = match[1];
      /*<<seq.ml:464:8>>*/ return [0, x, memoize(xs$0)];
     /*<<seq.ml:464:28>>*/ }
     /*<<seq.ml:434:14>>*/  /*<<seq.ml:434:14>>*/ var
     s =  /*<<seq.ml:434:14>>*/ caml_call1(to_lazy, s$0);
     /*<<seq.ml:434:14>>*/ return function(_J_){
     var _I_ = runtime.caml_obj_tag(s);
     if(250 === _I_) return s[1];
     if(246 !== _I_ && 244 !== _I_)  /*<<seq.ml:429:14>>*/ return s;
      /*<<seq.ml:429:14>>*/ return  /*<<seq.ml:429:14>>*/ caml_call1
             (CamlinternalLazy[2], s);};
    /*<<seq.ml:465:3>>*/ }
   function once(xs){
    function f(param){
      /*<<seq.ml:469:4>>*/  /*<<seq.ml:469:10>>*/ var
      match =  /*<<seq.ml:469:10>>*/ caml_call1(xs, 0);
     if(! match)  /*<<seq.ml:471:8>>*/ return 0;
     var xs$0 = match[2], x = match[1];
      /*<<seq.ml:473:8>>*/ return [0, x, once(xs$0)];
     /*<<seq.ml:473:25>>*/ }
     /*<<seq.ml:448:17>>*/  /*<<seq.ml:448:17>>*/ var
     action =  /*<<seq.ml:448:17>>*/ caml_call1(Stdlib_Atomic[1], f);
     /*<<seq.ml:449:4>>*/ return function(param){
      /*<<seq.ml:453:6>>*/  /*<<seq.ml:453:14>>*/ var
      f =  /*<<seq.ml:453:14>>*/ caml_call2(Stdlib_Atomic[4], action, failure);
      /*<<seq.ml:454:6>>*/ return  /*<<seq.ml:454:6>>*/ caml_call1(f, 0); /*<<seq.ml:454:9>>*/ };
    /*<<seq.ml:474:3>>*/ }
   function zip(xs, ys, param){
     /*<<seq.ml:478:2>>*/  /*<<seq.ml:478:8>>*/ var
     match =  /*<<seq.ml:478:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:480:6>>*/ return 0;
     /*<<seq.ml:482:12>>*/ var
     xs$0 = match[2],
     x = match[1],
      /*<<seq.ml:482:12>>*/ match$0 =  /*<<seq.ml:482:12>>*/ caml_call1(ys, 0);
    if(! match$0)  /*<<seq.ml:484:10>>*/ return 0;
    var ys$0 = match$0[2], y = match$0[1];
     /*<<seq.ml:486:10>>*/ return [0,
            [0, x, y],
            function(_H_){ /*<<?>>*/ return zip(xs$0, ys$0, _H_);}];
    /*<<seq.ml:486:34>>*/ }
   function map2(f, xs, ys, param){
     /*<<seq.ml:489:2>>*/  /*<<seq.ml:489:8>>*/ var
     match =  /*<<seq.ml:489:8>>*/ caml_call1(xs, 0);
    if(! match)  /*<<seq.ml:491:6>>*/ return 0;
     /*<<seq.ml:493:12>>*/ var
     xs$0 = match[2],
     x = match[1],
      /*<<seq.ml:493:12>>*/ match$0 =  /*<<seq.ml:493:12>>*/ caml_call1(ys, 0);
    if(! match$0)  /*<<seq.ml:495:10>>*/ return 0;
    var ys$0 = match$0[2], y = match$0[1];
     /*<<seq.ml:497:10>>*/ return [0,
             /*<<seq.ml:497:16>>*/ caml_call2(f, x, y),
            function(_G_){ /*<<?>>*/ return map2(f, xs$0, ys$0, _G_);}];
    /*<<seq.ml:497:36>>*/ }
   function interleave(xs, ys, param){
     /*<<seq.ml:500:2>>*/  /*<<seq.ml:500:8>>*/ var
     match =  /*<<seq.ml:500:8>>*/ caml_call1(xs, 0);
    if(! match)
      /*<<seq.ml:502:6>>*/ return  /*<<seq.ml:502:6>>*/ caml_call1(ys, 0);
    var xs$0 = match[2], x = match[1];
     /*<<seq.ml:504:6>>*/ return [0,
            x,
            function(_F_){ /*<<?>>*/ return interleave(ys, xs$0, _F_);}];
    /*<<seq.ml:504:32>>*/ }
   function sorted_merge1(cmp, x, xs, y, ys){
     /*<<seq.ml:533:2>>*/ return 0
            <  /*<<seq.ml:533:5>>*/ caml_call2(cmp, x, y)
            ? [0,
              y,
              function(_D_){
                /*<<seq.ml:519:8>>*/  /*<<seq.ml:519:8>>*/ var
                match =  /*<<seq.ml:519:8>>*/ caml_call1(ys, 0);
               if(! match)  /*<<seq.ml:521:6>>*/ return [0, x, xs];
               var ys$0 = match[2], y = match[1];
                /*<<seq.ml:523:6>>*/ return sorted_merge1(cmp, x, xs, y, ys$0);
              }]
            : [0,
              x,
              function(_E_){
                /*<<seq.ml:526:8>>*/  /*<<seq.ml:526:8>>*/ var
                match =  /*<<seq.ml:526:8>>*/ caml_call1(xs, 0);
               if(! match)  /*<<seq.ml:528:6>>*/ return [0, y, ys];
               var xs$0 = match[2], x = match[1];
                /*<<seq.ml:530:6>>*/ return sorted_merge1(cmp, x, xs$0, y, ys);
              }];
    /*<<seq.ml:536:40>>*/ }
   function sorted_merge(cmp, xs, ys, param){
     /*<<seq.ml:539:2>>*/ var
      /*<<seq.ml:539:8>>*/ match =  /*<<seq.ml:539:8>>*/ caml_call1(xs, 0),
      /*<<seq.ml:539:14>>*/ match$0 =  /*<<seq.ml:539:14>>*/ caml_call1(ys, 0);
    if(match){
     if(match$0){
      var ys$0 = match$0[2], y = match$0[1], xs$0 = match[2], x = match[1];
       /*<<seq.ml:546:8>>*/ return sorted_merge1(cmp, x, xs$0, y, ys$0);
     }
     var c = match;
    }
    else{if(! match$0)  /*<<seq.ml:541:8>>*/ return 0; var c = match$0;}
     /*<<seq.ml:544:8>>*/ return c;
    /*<<seq.ml:546:35>>*/ }
   function map_fst(xys, param){
     /*<<seq.ml:550:2>>*/  /*<<seq.ml:550:8>>*/ var
     match =  /*<<seq.ml:550:8>>*/ caml_call1(xys, 0);
    if(! match)  /*<<seq.ml:552:6>>*/ return 0;
    var xys$0 = match[2], x = match[1][1];
     /*<<seq.ml:554:6>>*/ return [0,
            x,
            function(_C_){ /*<<?>>*/ return map_fst(xys$0, _C_);}];
    /*<<seq.ml:554:27>>*/ }
   function map_snd(xys, param){
     /*<<seq.ml:557:2>>*/  /*<<seq.ml:557:8>>*/ var
     match =  /*<<seq.ml:557:8>>*/ caml_call1(xys, 0);
    if(! match)  /*<<seq.ml:559:6>>*/ return 0;
    var xys$0 = match[2], y = match[1][2];
     /*<<seq.ml:561:6>>*/ return [0,
            y,
            function(_B_){ /*<<?>>*/ return map_snd(xys$0, _B_);}];
    /*<<seq.ml:561:27>>*/ }
   function unzip(xys){
     /*<<seq.ml:564:2>>*/ return [0,
            function(_A_){ /*<<?>>*/ return map_fst(xys, _A_);},
            function(_z_){ /*<<?>>*/ return map_snd(xys, _z_);}];
    /*<<seq.ml:564:26>>*/ }
   function filter_map_find_left_map(f, xs, param){
     /*<<seq.ml:573:2>>*/ var xs$0 = xs;
     /*<<seq.ml:573:2>>*/ for(;;){
      /*<<seq.ml:573:8>>*/  /*<<seq.ml:573:8>>*/ var
      match =  /*<<seq.ml:573:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:575:6>>*/ return 0;
      /*<<seq.ml:577:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:577:12>>*/ match$0 =  /*<<seq.ml:577:12>>*/ caml_call1(f, x);
     if(0 === match$0[0]){
      var y = match$0[1];
       /*<<seq.ml:579:10>>*/ return [0,
              y,
              function(_y_){
                /*<<?>>*/ return filter_map_find_left_map(f, xs$1, _y_);
              }];
     }
     var xs$0 = xs$1;
    }
    /*<<seq.ml:581:42>>*/ }
   function filter_map_find_right_map(f, xs, param){
     /*<<seq.ml:584:2>>*/ var xs$0 = xs;
     /*<<seq.ml:584:2>>*/ for(;;){
      /*<<seq.ml:584:8>>*/  /*<<seq.ml:584:8>>*/ var
      match =  /*<<seq.ml:584:8>>*/ caml_call1(xs$0, 0);
     if(! match)  /*<<seq.ml:586:6>>*/ return 0;
      /*<<seq.ml:588:12>>*/ var
      xs$1 = match[2],
      x = match[1],
       /*<<seq.ml:588:12>>*/ match$0 =  /*<<seq.ml:588:12>>*/ caml_call1(f, x);
     if(0 !== match$0[0]){
      var z = match$0[1];
       /*<<seq.ml:592:10>>*/ return [0,
              z,
              function(_x_){
                /*<<?>>*/ return filter_map_find_right_map(f, xs$1, _x_);
              }];
     }
     var xs$0 = xs$1;
    }
    /*<<seq.ml:592:50>>*/ }
   function partition_map(f, xs){
     /*<<seq.ml:595:2>>*/ return [0,
            function(_w_){
              /*<<?>>*/ return filter_map_find_left_map(f, xs, _w_);
            },
            function(_v_){
              /*<<?>>*/ return filter_map_find_right_map(f, xs, _v_);
            }];
    /*<<seq.ml:596:32>>*/ }
   function partition(p, xs){
    function _s_(x){
      /*<<seq.ml:599:32>>*/ return 1 -  /*<<seq.ml:599:36>>*/ caml_call1(p, x);
     /*<<seq.ml:599:41>>*/ }
     /*<<seq.ml:599:2>>*/ return [0,
            function(_u_){ /*<<?>>*/ return filter(p, xs, _u_);},
            function(_t_){ /*<<?>>*/ return filter(_s_, xs, _t_);}];
    /*<<seq.ml:599:45>>*/ }
   function peel(xss){
     /*<<seq.ml:611:2>>*/ return unzip
            (function(_r_){ /*<<?>>*/ return filter_map(uncons, xss, _r_);});
    /*<<seq.ml:611:31>>*/ }
   function transpose(xss, param){
     /*<<seq.ml:614:2>>*/ var
      /*<<seq.ml:614:21>>*/ match = peel(xss),
     tails = match[2],
     heads = match[1];
     /*<<seq.ml:615:5>>*/ if(! is_empty(heads))
      /*<<seq.ml:620:4>>*/ return [0,
             heads,
             function(_q_){ /*<<?>>*/ return transpose(tails, _q_);}];
     /*<<seq.ml:616:11>>*/ if(is_empty(tails))  /*<<seq.ml:617:4>>*/ return 0;
     /*<<seq.ml:616:4>>*/ throw  /*<<seq.ml:616:4>>*/ caml_maybe_attach_backtrace
           ([0, Assert_failure, _a_], 1);
    /*<<seq.ml:620:33>>*/ }
   function _b_(remainders, xss, param){
     /*<<seq.ml:627:2>>*/  /*<<seq.ml:627:8>>*/ var
     match =  /*<<seq.ml:627:8>>*/ caml_call1(xss, 0);
    if(! match)  /*<<seq.ml:649:6>>*/ return transpose(remainders, 0);
     /*<<seq.ml:629:18>>*/ var
     xss$0 = match[2],
     xs = match[1],
      /*<<seq.ml:629:18>>*/ match$0 =  /*<<seq.ml:629:18>>*/ caml_call1(xs, 0);
    if(match$0){
      /*<<seq.ml:637:29>>*/ var
      xs$0 = match$0[2],
      x = match$0[1],
       /*<<seq.ml:637:29>>*/ match$1 = peel(remainders),
      tails = match$1[2],
      heads = match$1[1],
       /*<<seq.ml:638:40>>*/ _l_ =
        function(_p_){ /*<<?>>*/ return [0, xs$0, tails];};
      /*<<seq.ml:638:10>>*/ return [0,
             function(_o_){ /*<<?>>*/ return [0, x, heads];},
             function(_n_){ /*<<?>>*/ return _b_(_l_, xss$0, _n_);}];
    }
     /*<<seq.ml:643:29>>*/ var
      /*<<seq.ml:643:29>>*/ match$2 = peel(remainders),
     tails$0 = match$2[2],
     heads$0 = match$2[1];
     /*<<seq.ml:644:10>>*/ return [0,
            heads$0,
            function(_m_){ /*<<?>>*/ return _b_(tails$0, xss$0, _m_);}];
    /*<<seq.ml:649:29>>*/ }
   function map_product(f, xs, ys){
    function _f_(x){
     function _j_(y){
       /*<<seq.ml:671:8>>*/ return  /*<<seq.ml:671:8>>*/ caml_call2(f, x, y);
      /*<<seq.ml:671:13>>*/ }
      /*<<seq.ml:670:10>>*/ return function(_k_){
       /*<<?>>*/ return map(_j_, ys, _k_);};
     /*<<seq.ml:672:10>>*/ }
     /*<<seq.ml:668:20>>*/ function xss(_i_){
      /*<<?>>*/ return map(_f_, xs, _i_);
    }
     /*<<seq.ml:665:2>>*/ function _e_(_h_){
      /*<<?>>*/ return _b_(empty, xss, _h_);
    }
     /*<<seq.ml:668:9>>*/ return function(_g_){
      /*<<?>>*/ return concat(_e_, _g_);};
    /*<<seq.ml:674:4>>*/ }
   function product(xs, ys){
     /*<<seq.ml:677:2>>*/ return map_product
            (function(x, y){
               /*<<seq.ml:677:26>>*/ return [0, x, y];
              /*<<seq.ml:677:32>>*/ },
             xs,
             ys);
    /*<<seq.ml:677:39>>*/ }
   function of_dispenser(it){
    function c(param){
      /*<<seq.ml:681:4>>*/  /*<<seq.ml:681:10>>*/ var
      match =  /*<<seq.ml:681:10>>*/ caml_call1(it, 0);
     if(! match)  /*<<seq.ml:683:8>>*/ return 0;
     var x = match[1];
      /*<<seq.ml:685:8>>*/ return [0, x, c];
     /*<<seq.ml:685:19>>*/ }
     /*<<seq.ml:687:2>>*/ return c;
    /*<<seq.ml:687:3>>*/ }
   function to_dispenser(xs){
     /*<<seq.ml:690:2>>*/  /*<<seq.ml:690:10>>*/ var s = [0, xs];
     /*<<seq.ml:691:2>>*/ return function(param){
      /*<<seq.ml:692:4>>*/  /*<<seq.ml:692:10>>*/ var
      match =  /*<<seq.ml:692:10>>*/ caml_call1(s[1], 0);
     if(! match)  /*<<seq.ml:694:8>>*/ return 0;
     var xs = match[2], x = match[1];
     s[1] = xs;
      /*<<seq.ml:697:8>>*/ return [0, x]; /*<<seq.ml:697:14>>*/ };
    /*<<seq.ml:697:14>>*/ }
   function ints(i, param){
     /*<<seq.ml:702:2>>*/  /*<<seq.ml:702:2>>*/ var _c_ = i + 1 | 0;
     /*<<seq.ml:702:2>>*/ return [0,
            i,
            function(_d_){ /*<<?>>*/ return ints(_c_, _d_);}];
    /*<<seq.ml:702:24>>*/ }
   var
    Stdlib_Seq =
      [0,
       is_empty,
       uncons,
       length,
       iter,
       fold_left,
       iteri,
       fold_lefti,
       for_all,
       exists,
       find,
       find_index,
       find_map,
       find_mapi,
       iter2,
       fold_left2,
       for_all2,
       exists2,
       equal,
       compare,
       empty,
       return$0,
       cons,
       init,
       unfold,
       repeat,
       forever,
       cycle,
       iterate,
       map,
       mapi,
       filter,
       filter_map,
       scan,
       take,
       drop,
       take_while,
       drop_while,
       group,
       memoize,
       Forced_twice,
       once,
       transpose,
       append,
       concat,
       flat_map,
       flat_map,
       zip,
       map2,
       interleave,
       sorted_merge,
       product,
       map_product,
       unzip,
       unzip,
       partition_map,
       partition,
       of_dispenser,
       to_dispenser,
       ints];
   runtime.caml_register_global(10, Stdlib_Seq, "Stdlib__Seq");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Option
//# unitInfo: Requires: Stdlib, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    cst_option_is_None = "option is None";
   function some(v){
     /*<<option.ml:19:13>>*/ return [0, v];
    /*<<option.ml:19:19>>*/ }
   function value(o, default$0){
     /*<<option.ml:20:23>>*/ if(! o)
      /*<<option.ml:20:58>>*/ return default$0;
    var v = o[1];
     /*<<option.ml:20:46>>*/ return v;
    /*<<option.ml:20:65>>*/ }
   function get(param){
     /*<<option.ml:21:10>>*/ if(! param)
      /*<<option.ml:21:41>>*/ return  /*<<option.ml:21:41>>*/ caml_call1
             (Stdlib[1], cst_option_is_None);
    var v = param[1];
     /*<<option.ml:21:29>>*/ return v;
    /*<<option.ml:21:69>>*/ }
   function bind(o, f){
     /*<<option.ml:22:15>>*/ if(! o)  /*<<option.ml:22:36>>*/ return 0;
    var v = o[1];
     /*<<option.ml:22:53>>*/ return  /*<<option.ml:22:53>>*/ caml_call1(f, v);
    /*<<option.ml:22:56>>*/ }
   function join(param){
     /*<<option.ml:23:11>>*/ if(! param)  /*<<option.ml:23:42>>*/ return 0;
    var o = param[1];
     /*<<option.ml:23:30>>*/ return o;
    /*<<option.ml:23:46>>*/ }
   function map(f, o){
     /*<<option.ml:24:14>>*/ if(! o)  /*<<option.ml:24:35>>*/ return 0;
    var v = o[1];
     /*<<option.ml:24:52>>*/ return [0,
             /*<<option.ml:24:57>>*/ caml_call1(f, v)];
    /*<<option.ml:24:62>>*/ }
   function fold(none, some, param){
     /*<<?>>*/ if(! param)  /*<<option.ml:25:59>>*/ return none;
    var v = param[1];
     /*<<option.ml:25:42>>*/ return  /*<<option.ml:25:42>>*/ caml_call1
            (some, v);
   }
   function iter(f, param){
     /*<<?>>*/ if(! param)  /*<<option.ml:26:46>>*/ return 0;
    var v = param[1];
     /*<<option.ml:26:32>>*/ return  /*<<option.ml:26:32>>*/ caml_call1(f, v);
   }
   function is_none(param){
     /*<<option.ml:27:14>>*/ return param ? 0 : 1;
    /*<<option.ml:27:53>>*/ }
   function is_some(param){
     /*<<option.ml:28:14>>*/ return param ? 1 : 0;
    /*<<option.ml:28:53>>*/ }
   function equal(eq, o0, o1){
     /*<<option.ml:30:21>>*/ if(o0){
     if(o1){
      var v1 = o1[1], v0 = o0[1];
       /*<<option.ml:31:22>>*/ return  /*<<option.ml:31:22>>*/ caml_call2
              (eq, v0, v1);
     }
    }
    else if(! o1)  /*<<option.ml:32:16>>*/ return 1;
     /*<<option.ml:33:7>>*/ return 0;
    /*<<option.ml:33:12>>*/ }
   function compare(cmp, o0, o1){
     /*<<option.ml:35:24>>*/ if(! o0) return o1 ? -1 : 0;
    var v0 = o0[1];
    if(! o1)  /*<<option.ml:39:18>>*/ return 1;
    var v1 = o1[1];
     /*<<option.ml:36:22>>*/ return  /*<<option.ml:36:22>>*/ caml_call2
            (cmp, v0, v1);
    /*<<option.ml:39:19>>*/ }
   function to_result(none, param){
     /*<<?>>*/ if(! param)  /*<<option.ml:41:39>>*/ return [1, none];
    var v = param[1];
     /*<<option.ml:41:62>>*/ return [0, v];
   }
   function to_list(param){
     /*<<option.ml:42:14>>*/ if(! param)  /*<<option.ml:42:31>>*/ return 0;
    var v = param[1];
     /*<<option.ml:42:46>>*/ return [0, v, 0];
    /*<<option.ml:42:49>>*/ }
   function to_seq(param){
     /*<<option.ml:43:13>>*/ if(! param)
      /*<<option.ml:43:30>>*/ return Stdlib_Seq[20];
    var v = param[1];
     /*<<option.ml:43:52>>*/ return  /*<<option.ml:43:52>>*/ caml_call1
            (Stdlib_Seq[21], v);
    /*<<option.ml:43:64>>*/ }
   var
    Stdlib_Option =
      [0,
       0,
       some,
       value,
       get,
       bind,
       join,
       map,
       fold,
       iter,
       is_none,
       is_some,
       equal,
       compare,
       to_result,
       to_list,
       to_seq];
   runtime.caml_register_global(3, Stdlib_Option, "Stdlib__Option");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Result
//# unitInfo: Requires: Stdlib, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    cst_result_is_Error = "result is Error _",
    cst_result_is_Ok = "result is Ok _";
   function ok(v){
     /*<<result.ml:18:11>>*/ return [0, v];
    /*<<result.ml:18:15>>*/ }
   function error(e){
     /*<<result.ml:19:14>>*/ return [1, e];
    /*<<result.ml:19:21>>*/ }
   function value(r, default$0){
     /*<<result.ml:20:23>>*/ if(0 !== r[0])
      /*<<result.ml:20:59>>*/ return default$0;
    var v = r[1];
     /*<<result.ml:20:44>>*/ return v;
    /*<<result.ml:20:66>>*/ }
   function get_ok(param){
     /*<<result.ml:21:13>>*/ if(0 !== param[0])
      /*<<result.ml:21:45>>*/ return  /*<<result.ml:21:45>>*/ caml_call1
             (Stdlib[1], cst_result_is_Error);
    var v = param[1];
     /*<<result.ml:21:30>>*/ return v;
    /*<<result.ml:21:76>>*/ }
   function get_error(param){
     /*<<result.ml:22:16>>*/ if(0 === param[0])
      /*<<result.ml:22:48>>*/ return  /*<<result.ml:22:48>>*/ caml_call1
             (Stdlib[1], cst_result_is_Ok);
    var e = param[1];
     /*<<result.ml:22:36>>*/ return e;
    /*<<result.ml:22:76>>*/ }
   function bind(r, f){
     /*<<result.ml:23:15>>*/ if(0 !== r[0])  /*<<result.ml:23:58>>*/ return r;
    var v = r[1];
     /*<<result.ml:23:36>>*/ return  /*<<result.ml:23:36>>*/ caml_call1(f, v);
    /*<<result.ml:23:59>>*/ }
   function join(e){
     /*<<result.ml:24:11>>*/ if(0 !== e[0])  /*<<result.ml:24:48>>*/ return e;
    var r = e[1];
     /*<<result.ml:24:28>>*/ return r;
    /*<<result.ml:24:49>>*/ }
   function map(f, e){
     /*<<?>>*/ if(0 !== e[0])  /*<<result.ml:25:56>>*/ return e;
    var v = e[1];
     /*<<result.ml:25:29>>*/ return [0,
             /*<<result.ml:25:32>>*/ caml_call1(f, v)];
   }
   function map_error(f, v){
     /*<<?>>*/ if(0 === v[0])  /*<<result.ml:26:65>>*/ return v;
    var e = v[1];
     /*<<result.ml:26:38>>*/ return [1,
             /*<<result.ml:26:44>>*/ caml_call1(f, e)];
   }
   function fold(ok, error, param){
     /*<<?>>*/ if(0 === param[0]){
     var v = param[1];
      /*<<result.ml:27:39>>*/ return  /*<<result.ml:27:39>>*/ caml_call1
             (ok, v);
    }
    var e = param[1];
     /*<<result.ml:27:57>>*/ return  /*<<result.ml:27:57>>*/ caml_call1
            (error, e);
   }
   function iter(f, param){
     /*<<?>>*/ if(0 !== param[0])  /*<<result.ml:28:47>>*/ return 0;
    var v = param[1];
     /*<<result.ml:28:30>>*/ return  /*<<result.ml:28:30>>*/ caml_call1(f, v);
   }
   function iter_error(f, param){
     /*<<?>>*/ if(0 === param[0])  /*<<result.ml:29:53>>*/ return 0;
    var e = param[1];
     /*<<result.ml:29:39>>*/ return  /*<<result.ml:29:39>>*/ caml_call1(f, e);
   }
   function is_ok(param){
     /*<<result.ml:30:12>>*/ return 0 === param[0] ? 1 : 0;
    /*<<result.ml:30:52>>*/ }
   function is_error(param){
     /*<<result.ml:31:15>>*/ return 0 === param[0] ? 0 : 1;
    /*<<result.ml:31:55>>*/ }
   function equal(ok, error, r0, r1){
     /*<<result.ml:33:29>>*/ if(0 === r0[0]){
     var v0 = r0[1];
     if(0 === r1[0]){
      var v1 = r1[1];
       /*<<result.ml:34:18>>*/ return  /*<<result.ml:34:18>>*/ caml_call2
              (ok, v0, v1);
     }
    }
    else{
     var e0 = r0[1];
     if(0 !== r1[0]){
      var e1 = r1[1];
       /*<<result.ml:35:24>>*/ return  /*<<result.ml:35:24>>*/ caml_call2
              (error, e0, e1);
     }
    }
     /*<<result.ml:36:10>>*/ return 0;
    /*<<result.ml:36:15>>*/ }
   function compare(ok, error, r0, r1){
     /*<<result.ml:38:31>>*/ if(0 === r0[0]){
     var v0 = r0[1];
     if(0 !== r1[0])  /*<<result.ml:41:19>>*/ return -1;
     var v1 = r1[1];
      /*<<result.ml:39:18>>*/ return  /*<<result.ml:39:18>>*/ caml_call2
             (ok, v0, v1);
    }
    var e0 = r0[1];
    if(0 === r1[0])  /*<<result.ml:42:19>>*/ return 1;
    var e1 = r1[1];
     /*<<result.ml:40:24>>*/ return  /*<<result.ml:40:24>>*/ caml_call2
            (error, e0, e1);
    /*<<result.ml:42:20>>*/ }
   function to_option(param){
     /*<<result.ml:44:16>>*/ if(0 !== param[0])
      /*<<result.ml:44:53>>*/ return 0;
    var v = param[1];
     /*<<result.ml:44:33>>*/ return [0, v];
    /*<<result.ml:44:57>>*/ }
   function to_list(param){
     /*<<result.ml:45:14>>*/ if(0 !== param[0])
      /*<<result.ml:45:48>>*/ return 0;
    var v = param[1];
     /*<<result.ml:45:31>>*/ return [0, v, 0];
    /*<<result.ml:45:50>>*/ }
   function to_seq(param){
     /*<<result.ml:46:13>>*/ if(0 !== param[0])
      /*<<result.ml:46:56>>*/ return Stdlib_Seq[20];
    var v = param[1];
     /*<<result.ml:46:30>>*/ return  /*<<result.ml:46:30>>*/ caml_call1
            (Stdlib_Seq[21], v);
    /*<<result.ml:46:65>>*/ }
   var
    Stdlib_Result =
      [0,
       ok,
       error,
       value,
       get_ok,
       get_error,
       bind,
       join,
       map,
       map_error,
       fold,
       iter,
       iter_error,
       is_ok,
       is_error,
       equal,
       compare,
       to_option,
       to_list,
       to_seq];
   runtime.caml_register_global(4, Stdlib_Result, "Stdlib__Result");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Bool
(function(globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, caml_hash = runtime.caml_hash;
   function equal(_d_, _c_){ /*<<?>>*/ return _d_ === _c_ ? 1 : 0;}
   var
    compare = runtime.caml_int_compare,
    cst_true = "true",
    cst_false = "false";
   function to_float(param){
     /*<<bool.ml:24:15>>*/ return param ? 1. : 0.;
    /*<<bool.ml:24:48>>*/ }
   function to_string(param){
     /*<<bool.ml:33:16>>*/ return param ? cst_true : cst_false;
    /*<<bool.ml:33:58>>*/ }
   function seeded_hash(seed, x){
     /*<<bool.ml:37:25>>*/ return  /*<<bool.ml:37:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<bool.ml:37:56>>*/ }
   function hash(x){
     /*<<bool.ml:38:13>>*/ return  /*<<bool.ml:38:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<bool.ml:38:41>>*/ }
   var
    Stdlib_Bool =
      [0,
       function(_b_){ /*<<?>>*/ return 1 - _b_;},
       equal,
       compare,
       function(_a_){ /*<<?>>*/ return _a_;},
       to_float,
       to_string,
       seeded_hash,
       hash];
   runtime.caml_register_global(4, Stdlib_Bool, "Stdlib__Bool");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Char
//# unitInfo: Requires: Stdlib
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_hash = runtime.caml_hash,
    caml_string_of_bytes = runtime.caml_string_of_bytes;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst = "\\\\",
    cst$0 = "\\'",
    Stdlib = global_data.Stdlib,
    cst_Char_chr = "Char.chr",
    cst_b = "\\b",
    cst_t = "\\t",
    cst_n = "\\n",
    cst_r = "\\r";
   function chr(n){
     /*<<char.ml:22:2>>*/ if(0 <= n && 255 >= n)
      /*<<char.ml:22:55>>*/ return n;
     /*<<char.ml:22:27>>*/ return  /*<<char.ml:22:27>>*/ caml_call1
            (Stdlib[1], cst_Char_chr);
    /*<<char.ml:22:67>>*/ }
   function escaped(c){
     /*<<char.ml:29:14>>*/ a:
    {
     if(40 <= c){
      if(92 === c)  /*<<char.ml:31:12>>*/ return cst;
      if(127 > c) break a;
     }
     else{
      if(32 <= c){if(39 <= c)  /*<<char.ml:30:12>>*/ return cst$0; break a;}
      if(14 > c)
       switch(c){
         case 8:
           /*<<char.ml:35:12>>*/ return cst_b;
         case 9:
           /*<<char.ml:33:12>>*/ return cst_t;
         case 10:
           /*<<char.ml:32:12>>*/ return cst_n;
         case 13:
           /*<<char.ml:34:12>>*/ return cst_r;
       }
     }
      /*<<char.ml:42:14>>*/  /*<<char.ml:42:14>>*/ var
      s =  /*<<char.ml:42:14>>*/ caml_create_bytes(4);
     caml_bytes_unsafe_set(s, 0, 92);
     caml_bytes_unsafe_set(s, 1, 48 + (c / 100 | 0) | 0);
     caml_bytes_unsafe_set(s, 2, 48 + ((c / 10 | 0) % 10 | 0) | 0);
     caml_bytes_unsafe_set(s, 3, 48 + (c % 10 | 0) | 0);
     return caml_string_of_bytes(s);
    }
     /*<<char.ml:37:14>>*/  /*<<char.ml:37:14>>*/ var
     s$0 =  /*<<char.ml:37:14>>*/ caml_create_bytes(1);
    caml_bytes_unsafe_set(s$0, 0, c);
    return caml_string_of_bytes(s$0);
    /*<<char.ml:47:24>>*/ }
   function lowercase_ascii(c){
     /*<<char.ml:49:22>>*/ return 25 < c - 65 >>> 0 ? c : c + 32 | 0;
    /*<<char.ml:51:10>>*/ }
   function uppercase_ascii(c){
     /*<<char.ml:53:22>>*/ return 25 < c - 97 >>> 0 ? c : c - 32 | 0;
    /*<<char.ml:55:10>>*/ }
   function compare(c1, c2){
     /*<<char.ml:59:20>>*/ return c1 - c2 | 0;
    /*<<char.ml:59:37>>*/ }
   function equal(c1, c2){
     /*<<char.ml:60:28>>*/ return 0 === (c1 - c2 | 0) ? 1 : 0;
    /*<<char.ml:60:45>>*/ }
   function seeded_hash(seed, x){
     /*<<char.ml:64:25>>*/ return  /*<<char.ml:64:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<char.ml:64:56>>*/ }
   function hash(x){
     /*<<char.ml:65:13>>*/ return  /*<<char.ml:65:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<char.ml:65:41>>*/ }
   var
    Stdlib_Char =
      [0,
       chr,
       escaped,
       lowercase_ascii,
       uppercase_ascii,
       compare,
       equal,
       seeded_hash,
       hash];
   runtime.caml_register_global(8, Stdlib_Char, "Stdlib__Char");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Uchar
//# unitInfo: Requires: Stdlib
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_uchar_ml = "uchar.ml",
    caml_format_int = runtime.caml_format_int,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    err_no_pred = "U+0000 has no predecessor",
    err_no_succ = "U+10FFFF has no successor",
    Assert_failure = global_data.Assert_failure,
    Stdlib = global_data.Stdlib,
    cst_is_not_an_Unicode_scalar_v = " is not an Unicode scalar value",
    cst_is_not_a_latin1_character = " is not a latin1 character",
    cst_U = "U+",
    lo_bound = 55295,
    hi_bound = 57344;
   function succ(u){
     /*<<uchar.ml:34:2>>*/ return u === 55295
            ? hi_bound
            : u === 1114111 ? caml_call1(Stdlib[1], err_no_succ) : u + 1 | 0;
    /*<<uchar.ml:36:7>>*/ }
   function pred(u){
     /*<<uchar.ml:39:2>>*/ return u === 57344
            ? lo_bound
            : u === 0 ? caml_call1(Stdlib[1], err_no_pred) : u - 1 | 0;
    /*<<uchar.ml:41:7>>*/ }
   function is_valid(i){
     /*<<uchar.ml:43:17>>*/ var
     _n_ = 0 <= i ? 1 : 0,
     _o_ = _n_ ? i <= 55295 ? 1 : 0 : _n_;
    if(_o_)
     var _p_ = _o_;
    else
     var _q_ = 57344 <= i ? 1 : 0, _p_ = _q_ ? i <= 1114111 ? 1 : 0 : _q_;
    return _p_;
    /*<<uchar.ml:43:75>>*/ }
   function of_int(i){
     /*<<uchar.ml:44:15>>*/ if(is_valid(i))  /*<<uchar.ml:44:34>>*/ return i;
     /*<<uchar.ml:20:19>>*/  /*<<uchar.ml:20:19>>*/ var
     _m_ =
        /*<<uchar.ml:20:19>>*/ caml_call2
        (Stdlib[28],
          /*<<uchar.ml:20:19>>*/ caml_format_int("%X", i),
         cst_is_not_an_Unicode_scalar_v);
     /*<<uchar.ml:44:53>>*/ return  /*<<uchar.ml:44:53>>*/ caml_call1
            (Stdlib[1], _m_);
    /*<<uchar.ml:44:67>>*/ }
   function is_char(u){
     /*<<uchar.ml:48:16>>*/ return u < 256 ? 1 : 0;
    /*<<uchar.ml:48:23>>*/ }
   function of_char(c){
     /*<<uchar.ml:49:16>>*/ return c;
    /*<<uchar.ml:49:27>>*/ }
   function to_char(u){
     /*<<uchar.ml:51:2>>*/ if(255 >= u)  /*<<uchar.ml:52:2>>*/ return u;
     /*<<uchar.ml:21:30>>*/ var
      /*<<uchar.ml:21:30>>*/ _k_ =
        /*<<uchar.ml:21:30>>*/ caml_call2
        (Stdlib[28],
          /*<<uchar.ml:21:30>>*/ caml_format_int("%04X", u),
         cst_is_not_a_latin1_character),
      /*<<uchar.ml:21:30>>*/ _l_ =
        /*<<uchar.ml:21:30>>*/ caml_call2(Stdlib[28], cst_U, _k_);
     /*<<uchar.ml:51:30>>*/ return  /*<<uchar.ml:51:30>>*/ caml_call1
            (Stdlib[1], _l_);
    /*<<uchar.ml:52:19>>*/ }
   function unsafe_to_char(_j_){ /*<<?>>*/ return _j_;}
   function equal(_i_, _h_){ /*<<?>>*/ return _i_ === _h_ ? 1 : 0;}
   var
    compare = runtime.caml_int_compare,
    _a_ = [0, cst_uchar_ml, 85, 7],
    _b_ = [0, cst_uchar_ml, 80, 18],
    _c_ = [0, cst_uchar_ml, 91, 7],
    _d_ = [0, cst_uchar_ml, 88, 18];
   function hash(_g_){ /*<<?>>*/ return _g_;}
   function utf_decode_is_valid(d){
     /*<<uchar.ml:73:37>>*/ return 1 === (d >>> 27 | 0) ? 1 : 0;
    /*<<uchar.ml:73:58>>*/ }
   function utf_decode_length(d){
     /*<<uchar.ml:74:35>>*/ return (d >>> 24 | 0) & 7;
    /*<<uchar.ml:74:65>>*/ }
   function utf_decode_uchar(d){
     /*<<uchar.ml:75:34>>*/ return d & 16777215;
    /*<<uchar.ml:75:65>>*/ }
   function utf_decode(n, u){
     /*<<uchar.ml:76:30>>*/ return (8 | n) << 24 | u;
    /*<<uchar.ml:76:72>>*/ }
   function utf_decode_invalid(n){
     /*<<uchar.ml:77:36>>*/ return n << 24 | 65533;
    /*<<uchar.ml:77:63>>*/ }
   function utf_8_byte_length(u){
     /*<<uchar.ml:79:26>>*/ if(0 > u)
      /*<<uchar.ml:80:18>>*/ throw  /*<<uchar.ml:80:18>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _b_], 1);
     /*<<uchar.ml:81:9>>*/ if(127 >= u)  /*<<uchar.ml:81:24>>*/ return 1;
     /*<<uchar.ml:82:9>>*/ if(2047 >= u)  /*<<uchar.ml:82:24>>*/ return 2;
     /*<<uchar.ml:83:9>>*/ if(65535 >= u)  /*<<uchar.ml:83:24>>*/ return 3;
     /*<<uchar.ml:84:9>>*/ if(1114111 < u)
      /*<<uchar.ml:85:7>>*/ throw  /*<<uchar.ml:85:7>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _a_], 1);
     /*<<uchar.ml:84:26>>*/ return 4;
    /*<<uchar.ml:85:19>>*/ }
   function utf_16_byte_length(u){
     /*<<uchar.ml:87:27>>*/ if(0 > u)
      /*<<uchar.ml:88:18>>*/ throw  /*<<uchar.ml:88:18>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _d_], 1);
     /*<<uchar.ml:89:9>>*/ if(65535 >= u)  /*<<uchar.ml:89:24>>*/ return 2;
     /*<<uchar.ml:90:9>>*/ if(1114111 < u)
      /*<<uchar.ml:91:7>>*/ throw  /*<<uchar.ml:91:7>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _c_], 1);
     /*<<uchar.ml:90:26>>*/ return 4;
    /*<<uchar.ml:91:19>>*/ }
   var
    Stdlib_Uchar =
      [0,
       0,
       1114111,
       65279,
       65533,
       succ,
       pred,
       is_valid,
       of_int,
       function(_f_){ /*<<?>>*/ return _f_;},
       function(_e_){ /*<<?>>*/ return _e_;},
       is_char,
       of_char,
       to_char,
       unsafe_to_char,
       equal,
       compare,
       hash,
       utf_decode_is_valid,
       utf_decode_uchar,
       utf_decode_length,
       utf_decode,
       utf_decode_invalid,
       utf_8_byte_length,
       utf_16_byte_length];
   runtime.caml_register_global(13, Stdlib_Uchar, "Stdlib__Uchar");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__List
//# unitInfo: Requires: Stdlib
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_List_map2$1 = "List.map2",
    cst_List_nth$1 = "List.nth",
    caml_compare = runtime.caml_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    cst_hd = "hd",
    cst_tl = "tl",
    cst_nth = "nth",
    cst_List_nth = cst_List_nth$1,
    cst_List_nth$0 = cst_List_nth$1;
   function length(l$0){
     /*<<list.ml:25:15>>*/ var len = 0, param = l$0;
    for(;;){
     if(! param)  /*<<list.ml:22:10>>*/ return len;
      /*<<list.ml:23:12>>*/ var
      l = param[2],
       /*<<list.ml:23:12>>*/ len$0 = len + 1 | 0,
      len = len$0,
      param = l;
    }
    /*<<list.ml:25:29>>*/ }
   function cons(a, l){
     /*<<list.ml:27:15>>*/ return [0, a, l];
    /*<<list.ml:27:19>>*/ }
   function hd(param){
     /*<<list.ml:29:9>>*/ if(! param)
      /*<<list.ml:30:10>>*/ return  /*<<list.ml:30:10>>*/ caml_call1
             (Stdlib[2], cst_hd);
    var a = param[1];
     /*<<list.ml:31:12>>*/ return a;
    /*<<list.ml:31:13>>*/ }
   function tl(param){
     /*<<list.ml:33:9>>*/ if(! param)
      /*<<list.ml:34:10>>*/ return  /*<<list.ml:34:10>>*/ caml_call1
             (Stdlib[2], cst_tl);
    var l = param[2];
     /*<<list.ml:35:12>>*/ return l;
    /*<<list.ml:35:13>>*/ }
   function nth(l, n){
     /*<<list.ml:38:2>>*/ if(0 > n)
      /*<<list.ml:38:16>>*/ return  /*<<list.ml:38:16>>*/ caml_call1
             (Stdlib[1], cst_List_nth);
    var l$0 = l, n$0 = n;
     /*<<list.ml:40:4>>*/ for(;;){
     if(! l$0)
       /*<<list.ml:41:12>>*/ return  /*<<list.ml:41:12>>*/ caml_call1
              (Stdlib[2], cst_nth);
     var l$1 = l$0[2], a = l$0[1];
      /*<<list.ml:42:14>>*/ if(0 === n$0)  /*<<list.ml:42:28>>*/ return a;
      /*<<list.ml:42:35>>*/ var
       /*<<list.ml:42:35>>*/ n$1 = n$0 - 1 | 0,
      l$0 = l$1,
      n$0 = n$1;
    }
    /*<<list.ml:43:16>>*/ }
   function nth_opt(l, n){
     /*<<list.ml:46:2>>*/ if(0 > n)
      /*<<list.ml:46:16>>*/ return  /*<<list.ml:46:16>>*/ caml_call1
             (Stdlib[1], cst_List_nth$0);
    var l$0 = l, n$0 = n;
     /*<<list.ml:48:4>>*/ for(;;){
     if(! l$0)  /*<<list.ml:49:12>>*/ return 0;
     var l$1 = l$0[2], a = l$0[1];
      /*<<list.ml:50:14>>*/ if(0 === n$0)
       /*<<list.ml:50:28>>*/ return [0, a];
      /*<<list.ml:50:40>>*/ var
       /*<<list.ml:50:40>>*/ n$1 = n$0 - 1 | 0,
      l$0 = l$1,
      n$0 = n$1;
    }
    /*<<list.ml:51:16>>*/ }
   var
    append = Stdlib[37],
    cst_List_init = "List.init",
    cst_List_map2 = cst_List_map2$1,
    cst_List_map2$0 = cst_List_map2$1,
    cst_List_rev_map2 = "List.rev_map2",
    cst_List_iter2 = "List.iter2",
    cst_List_fold_left2 = "List.fold_left2",
    cst_List_fold_right2 = "List.fold_right2",
    cst_List_for_all2 = "List.for_all2",
    cst_List_exists2 = "List.exists2",
    _a_ = [0, 0, 0],
    cst_List_combine = "List.combine";
   function rev_append(l1, l2){
     /*<<list.ml:56:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:56:2>>*/ for(;;){
     if(! l1$0)  /*<<list.ml:57:10>>*/ return l2$0;
      /*<<list.ml:58:27>>*/ var
      l1$1 = l1$0[2],
      a = l1$0[1],
       /*<<list.ml:58:27>>*/ l2$1 = [0, a, l2$0],
      l1$0 = l1$1,
      l2$0 = l2$1;
    }
    /*<<list.ml:58:36>>*/ }
   function rev(l){
     /*<<list.ml:60:12>>*/ return rev_append(l, 0);
    /*<<list.ml:60:27>>*/ }
   function init(len, f){
     /*<<list.ml:71:2>>*/ if(0 > len)
      /*<<list.ml:71:18>>*/ return  /*<<list.ml:71:18>>*/ caml_call1
             (Stdlib[1], cst_List_init);
    var last = len - 1 | 0, i$1 = 0;
    if(last < 0)  /*<<list.ml:63:19>>*/ return 0;
    if(0 === last)
      /*<<list.ml:64:24>>*/ return [0,
              /*<<list.ml:64:25>>*/ caml_call1(f, i$1),
             0];
     /*<<list.ml:66:13>>*/ var
      /*<<list.ml:66:13>>*/ r1 =  /*<<list.ml:66:13>>*/ caml_call1(f, i$1),
      /*<<list.ml:67:13>>*/ r2 =  /*<<list.ml:67:13>>*/ caml_call1(f, 1),
      /*<<list.ml:68:10>>*/ block = [0, r2, 24029],
     dst = block,
     offset = 1,
     i = 2;
     /*<<list.ml:63:2>>*/ for(;;){
     if(last < i)
      dst[1 + offset] = 0;
     else{
      if(i !== last){
        /*<<list.ml:66:13>>*/ var
         /*<<list.ml:66:13>>*/ r1$0 =  /*<<list.ml:66:13>>*/ caml_call1(f, i),
         /*<<list.ml:67:13>>*/ r2$0 =
           /*<<list.ml:67:13>>*/ caml_call1(f, i + 1 | 0),
         /*<<list.ml:68:10>>*/ dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$0, dst$0];
       var i$0 = i + 2 | 0, dst = dst$0, offset = 1, i = i$0;
       continue;
      }
      dst[1 + offset] = [0,  /*<<list.ml:64:25>>*/ caml_call1(f, i), 0];
     }
      /*<<list.ml:68:4>>*/ return [0, r1, block];
    }
    /*<<list.ml:72:20>>*/ }
   function flatten(param){
     /*<<list.ml:74:18>>*/ if(! param)  /*<<list.ml:75:10>>*/ return 0;
     /*<<list.ml:76:16>>*/ var
     r = param[2],
     l = param[1],
      /*<<list.ml:76:16>>*/ _I_ = flatten(r);
     /*<<list.ml:76:16>>*/ return  /*<<list.ml:76:16>>*/ caml_call2
            (Stdlib[37], l, _I_);
    /*<<list.ml:76:25>>*/ }
   function map(f, param){
     /*<<?>>*/ if(! param)  /*<<list.ml:81:10>>*/ return 0;
    var match = param[2], a1 = param[1];
    if(! match){
      /*<<list.ml:83:15>>*/  /*<<list.ml:83:15>>*/ var
      r1$0 =  /*<<list.ml:83:15>>*/ caml_call1(f, a1);
      /*<<list.ml:84:6>>*/ return [0, r1$0, 0];
    }
     /*<<list.ml:86:15>>*/ var
     l = match[2],
     a2 = match[1],
      /*<<list.ml:86:15>>*/ r1 =  /*<<list.ml:86:15>>*/ caml_call1(f, a1),
      /*<<list.ml:87:15>>*/ r2 =  /*<<list.ml:87:15>>*/ caml_call1(f, a2),
      /*<<list.ml:88:10>>*/ block = [0, r2, 24029],
     dst = block,
     offset = 1,
     param$0 = l;
    for(;;){
     if(param$0){
      var match$0 = param$0[2], a1$0 = param$0[1];
      if(match$0){
        /*<<list.ml:86:15>>*/ var
        l$0 = match$0[2],
        a2$0 = match$0[1],
         /*<<list.ml:86:15>>*/ r1$1 =
           /*<<list.ml:86:15>>*/ caml_call1(f, a1$0),
         /*<<list.ml:87:15>>*/ r2$0 =
           /*<<list.ml:87:15>>*/ caml_call1(f, a2$0),
         /*<<list.ml:88:10>>*/ dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$1, dst$0];
       var dst = dst$0, offset = 1, param$0 = l$0;
       continue;
      }
       /*<<list.ml:83:15>>*/  /*<<list.ml:83:15>>*/ var
       r1$2 =  /*<<list.ml:83:15>>*/ caml_call1(f, a1$0);
      dst[1 + offset] = [0, r1$2, 0];
     }
     else
      dst[1 + offset] = 0;
      /*<<list.ml:88:6>>*/ return [0, r1, block];
    }
   }
   function mapi(f, l$1){
     /*<<list.ml:100:15>>*/ var i$1 = 0;
    if(! l$1)  /*<<list.ml:91:10>>*/ return 0;
    var match = l$1[2], a1 = l$1[1];
    if(! match){
      /*<<list.ml:93:15>>*/  /*<<list.ml:93:15>>*/ var
      r1$0 =  /*<<list.ml:93:15>>*/ caml_call2(f, i$1, a1);
      /*<<list.ml:94:6>>*/ return [0, r1$0, 0];
    }
     /*<<list.ml:96:15>>*/ var
     l = match[2],
     a2 = match[1],
      /*<<list.ml:96:15>>*/ r1 =  /*<<list.ml:96:15>>*/ caml_call2(f, i$1, a1),
      /*<<list.ml:97:15>>*/ r2 =  /*<<list.ml:97:15>>*/ caml_call2(f, 1, a2),
      /*<<list.ml:98:10>>*/ block = [0, r2, 24029],
     dst = block,
     offset = 1,
     i = 2,
     param = l;
    for(;;){
     if(param){
      var match$0 = param[2], a1$0 = param[1];
      if(match$0){
        /*<<list.ml:96:15>>*/ var
        l$0 = match$0[2],
        a2$0 = match$0[1],
         /*<<list.ml:96:15>>*/ r1$1 =
           /*<<list.ml:96:15>>*/ caml_call2(f, i, a1$0),
         /*<<list.ml:97:15>>*/ r2$0 =
           /*<<list.ml:97:15>>*/ caml_call2(f, i + 1 | 0, a2$0),
         /*<<list.ml:98:10>>*/ dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$1, dst$0];
       var i$0 = i + 2 | 0, dst = dst$0, offset = 1, i = i$0, param = l$0;
       continue;
      }
       /*<<list.ml:93:15>>*/  /*<<list.ml:93:15>>*/ var
       r1$2 =  /*<<list.ml:93:15>>*/ caml_call2(f, i, a1$0);
      dst[1 + offset] = [0, r1$2, 0];
     }
     else
      dst[1 + offset] = 0;
      /*<<list.ml:98:6>>*/ return [0, r1, block];
    }
    /*<<list.ml:100:25>>*/ }
   function rev_map(f, l){
     /*<<list.ml:103:2>>*/ var accu = 0, param = l;
    for(;;){
     if(! param)  /*<<list.ml:104:12>>*/ return accu;
      /*<<list.ml:105:21>>*/ var
      l$0 = param[2],
      a = param[1],
       /*<<list.ml:105:21>>*/ accu$0 =
        [0,  /*<<list.ml:105:22>>*/ caml_call1(f, a), accu],
      accu = accu$0,
      param = l$0;
    }
    /*<<list.ml:107:13>>*/ }
   function iter(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:111:10>>*/ return 0;
     var l = param$0[2], a = param$0[1];
      /*<<list.ml:112:12>>*/  /*<<list.ml:112:12>>*/ caml_call1(f, a);
     var param$0 = l;
    }
   }
   function iteri(f, l$0){
     /*<<list.ml:118:16>>*/ var i = 0, param = l$0;
    for(;;){
     if(! param)  /*<<list.ml:115:10>>*/ return 0;
     var l = param[2], a = param[1];
      /*<<list.ml:116:12>>*/  /*<<list.ml:116:12>>*/ caml_call2(f, i, a);
     var i$0 = i + 1 | 0, i = i$0, param = l;
    }
    /*<<list.ml:118:27>>*/ }
   function fold_left(f, accu, l){
     /*<<list.ml:121:2>>*/ var accu$0 = accu, l$0 = l;
     /*<<list.ml:121:2>>*/ for(;;){
     if(! l$0)  /*<<list.ml:122:10>>*/ return accu$0;
      /*<<list.ml:123:24>>*/ var
      l$1 = l$0[2],
      a = l$0[1],
       /*<<list.ml:123:24>>*/ accu$1 =
         /*<<list.ml:123:24>>*/ caml_call2(f, accu$0, a),
      accu$0 = accu$1,
      l$0 = l$1;
    }
    /*<<list.ml:123:36>>*/ }
   function fold_right(f, l, accu){
     /*<<list.ml:126:2>>*/ if(! l)  /*<<list.ml:127:10>>*/ return accu;
    var l$0 = l[2], a = l[1];
     /*<<list.ml:128:16>>*/ return  /*<<list.ml:128:16>>*/ caml_call2
            (f, a, fold_right(f, l$0, accu));
    /*<<list.ml:128:37>>*/ }
   function map2(f, l1, l2){
     /*<<list.ml:131:2>>*/ if(l1){
     var _G_ = l1[2], a1 = l1[1];
     if(_G_){
      if(l2){
       var match = l2[2];
       if(match){
         /*<<list.ml:137:15>>*/ var
         l2$0 = match[2],
         b2 = match[1],
         b1 = l2[1],
         l1$0 = _G_[2],
         a2 = _G_[1],
          /*<<list.ml:137:15>>*/ r1 =
            /*<<list.ml:137:15>>*/ caml_call2(f, a1, b1),
          /*<<list.ml:138:15>>*/ r2 =
            /*<<list.ml:138:15>>*/ caml_call2(f, a2, b2),
          /*<<list.ml:139:10>>*/ block = [0, r2, 24029],
         dst = block,
         offset = 1,
         l1$1 = l1$0,
         l2$1 = l2$0;
         /*<<list.ml:131:2>>*/ for(;;){
         a:
         {
          if(l1$1){
           var _H_ = l1$1[2], a1$0 = l1$1[1];
           if(_H_){
            if(l2$1){
             var match$0 = l2$1[2];
             if(match$0){
               /*<<list.ml:137:15>>*/ var
               l2$2 = match$0[2],
               b2$0 = match$0[1],
               b1$1 = l2$1[1],
               l1$2 = _H_[2],
               a2$0 = _H_[1],
                /*<<list.ml:137:15>>*/ r1$1 =
                  /*<<list.ml:137:15>>*/ caml_call2(f, a1$0, b1$1),
                /*<<list.ml:138:15>>*/ r2$0 =
                  /*<<list.ml:138:15>>*/ caml_call2(f, a2$0, b2$0),
                /*<<list.ml:139:10>>*/ dst$0 = [0, r2$0, 24029];
              dst[1 + offset] = [0, r1$1, dst$0];
              var dst = dst$0, offset = 1, l1$1 = l1$2, l2$1 = l2$2;
              continue;
             }
            }
           }
           else if(l2$1 && ! l2$1[2]){
             /*<<list.ml:134:15>>*/ var
             b1$2 = l2$1[1],
              /*<<list.ml:134:15>>*/ r1$2 =
                /*<<list.ml:134:15>>*/ caml_call2(f, a1$0, b1$2);
            dst[1 + offset] = [0, r1$2, 0];
            break a;
           }
          }
          else if(! l2$1){dst[1 + offset] = 0; break a;}
          dst[1 + offset] = caml_call1(Stdlib[1], cst_List_map2$0);
         }
          /*<<list.ml:139:6>>*/ return [0, r1, block];
        }
       }
      }
     }
     else if(l2 && ! l2[2]){
       /*<<list.ml:134:15>>*/ var
       b1$0 = l2[1],
        /*<<list.ml:134:15>>*/ r1$0 =
          /*<<list.ml:134:15>>*/ caml_call2(f, a1, b1$0);
       /*<<list.ml:135:6>>*/ return [0, r1$0, 0];
     }
    }
    else if(! l2)  /*<<list.ml:132:16>>*/ return 0;
     /*<<list.ml:140:14>>*/ return  /*<<list.ml:140:14>>*/ caml_call1
            (Stdlib[1], cst_List_map2);
    /*<<list.ml:140:37>>*/ }
   function rev_map2(f, l1, l2){
     /*<<list.ml:143:2>>*/ var accu = 0, l1$0 = l1, l2$0 = l2;
     /*<<list.ml:144:4>>*/ for(;;){
     if(l1$0){
      if(l2$0){
        /*<<list.ml:146:34>>*/ var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
         /*<<list.ml:146:34>>*/ accu$0 =
          [0,  /*<<list.ml:146:35>>*/ caml_call2(f, a1, a2), accu],
        accu = accu$0,
        l1$0 = l1$1,
        l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:145:18>>*/ return accu;
      /*<<list.ml:147:16>>*/ return  /*<<list.ml:147:16>>*/ caml_call1
             (Stdlib[1], cst_List_rev_map2);
    }
    /*<<list.ml:149:18>>*/ }
   function iter2(f, l1, l2){
     /*<<list.ml:153:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:153:2>>*/ for(;;){
     if(l1$0){
      if(l2$0){
       var l2$1 = l2$0[2], a2 = l2$0[1], l1$1 = l1$0[2], a1 = l1$0[1];
        /*<<list.ml:155:24>>*/  /*<<list.ml:155:24>>*/ caml_call2(f, a1, a2);
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:154:16>>*/ return 0;
      /*<<list.ml:156:14>>*/ return  /*<<list.ml:156:14>>*/ caml_call1
             (Stdlib[1], cst_List_iter2);
    }
    /*<<list.ml:156:38>>*/ }
   function fold_left2(f, accu, l1, l2){
     /*<<list.ml:159:2>>*/ var accu$0 = accu, l1$0 = l1, l2$0 = l2;
     /*<<list.ml:159:2>>*/ for(;;){
     if(l1$0){
      if(l2$0){
        /*<<list.ml:161:37>>*/ var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
         /*<<list.ml:161:37>>*/ accu$1 =
           /*<<list.ml:161:37>>*/ caml_call3(f, accu$0, a1, a2),
        accu$0 = accu$1,
        l1$0 = l1$1,
        l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:160:16>>*/ return accu$0;
      /*<<list.ml:162:14>>*/ return  /*<<list.ml:162:14>>*/ caml_call1
             (Stdlib[1], cst_List_fold_left2);
    }
    /*<<list.ml:162:43>>*/ }
   function fold_right2(f, l1, l2, accu){
     /*<<list.ml:165:2>>*/ if(l1){
     if(l2){
      var l2$0 = l2[2], a2 = l2[1], l1$0 = l1[2], a1 = l1[1];
       /*<<list.ml:167:32>>*/ return  /*<<list.ml:167:32>>*/ caml_call3
              (f, a1, a2, fold_right2(f, l1$0, l2$0, accu));
     }
    }
    else if(! l2)  /*<<list.ml:166:16>>*/ return accu;
     /*<<list.ml:168:14>>*/ return  /*<<list.ml:168:14>>*/ caml_call1
            (Stdlib[1], cst_List_fold_right2);
    /*<<list.ml:168:44>>*/ }
   function for_all(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:171:10>>*/ return 1;
      /*<<list.ml:172:12>>*/ var
      l = param$0[2],
      a = param$0[1],
       /*<<list.ml:172:12>>*/ _F_ =  /*<<list.ml:172:12>>*/ caml_call1(p, a);
      /*<<list.ml:172:12>>*/ if(! _F_)  /*<<list.ml:172:12>>*/ return _F_;
     var param$0 = l;
    }
   }
   function exists(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:175:10>>*/ return 0;
      /*<<list.ml:176:12>>*/ var
      l = param$0[2],
      a = param$0[1],
       /*<<list.ml:176:12>>*/ _E_ =  /*<<list.ml:176:12>>*/ caml_call1(p, a);
      /*<<list.ml:176:12>>*/ if(_E_)  /*<<list.ml:176:12>>*/ return _E_;
     var param$0 = l;
    }
   }
   function for_all2(p, l1, l2){
     /*<<list.ml:179:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:179:2>>*/ for(;;){
     if(l1$0){
      if(l2$0){
        /*<<list.ml:181:24>>*/ var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
         /*<<list.ml:181:24>>*/ _D_ =
           /*<<list.ml:181:24>>*/ caml_call2(p, a1, a2);
        /*<<list.ml:181:24>>*/ if(! _D_)  /*<<list.ml:181:24>>*/ return _D_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:180:16>>*/ return 1;
      /*<<list.ml:182:14>>*/ return  /*<<list.ml:182:14>>*/ caml_call1
             (Stdlib[1], cst_List_for_all2);
    }
    /*<<list.ml:182:41>>*/ }
   function exists2(p, l1, l2){
     /*<<list.ml:185:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:185:2>>*/ for(;;){
     if(l1$0){
      if(l2$0){
        /*<<list.ml:187:24>>*/ var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
         /*<<list.ml:187:24>>*/ _C_ =
           /*<<list.ml:187:24>>*/ caml_call2(p, a1, a2);
        /*<<list.ml:187:24>>*/ if(_C_)  /*<<list.ml:187:24>>*/ return _C_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:186:16>>*/ return 0;
      /*<<list.ml:188:14>>*/ return  /*<<list.ml:188:14>>*/ caml_call1
             (Stdlib[1], cst_List_exists2);
    }
    /*<<list.ml:188:40>>*/ }
   function mem(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:191:10>>*/ return 0;
     var
      l = param$0[2],
      a = param$0[1],
      _B_ = 0 ===  /*<<list.ml:192:12>>*/ caml_compare(a, x) ? 1 : 0;
     if(_B_) return _B_;
     var param$0 = l;
    }
   }
   function memq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:195:10>>*/ return 0;
     var l = param$0[2], a = param$0[1], _A_ = a === x ? 1 : 0;
     if(_A_) return _A_;
     var param$0 = l;
    }
   }
   function assoc(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)
       /*<<list.ml:199:10>>*/ throw  /*<<list.ml:199:10>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
      /*<<list.ml:200:19>>*/ if
      (0 ===  /*<<list.ml:200:19>>*/ caml_compare(a, x))
       /*<<list.ml:200:40>>*/ return b;
     var param$0 = l;
    }
   }
   function assoc_opt(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:203:10>>*/ return 0;
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
      /*<<list.ml:204:19>>*/ if
      (0 ===  /*<<list.ml:204:19>>*/ caml_compare(a, x))
       /*<<list.ml:204:40>>*/ return [0, b];
     var param$0 = l;
    }
   }
   function assq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)
       /*<<list.ml:207:10>>*/ throw  /*<<list.ml:207:10>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(a === x)  /*<<list.ml:208:31>>*/ return b;
     var param$0 = l;
    }
   }
   function assq_opt(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:211:10>>*/ return 0;
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(a === x)  /*<<list.ml:212:31>>*/ return [0, b];
     var param$0 = l;
    }
   }
   function mem_assoc(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:215:10>>*/ return 0;
     var
      l = param$0[2],
      a = param$0[1][1],
      _z_ = 0 ===  /*<<list.ml:216:19>>*/ caml_compare(a, x) ? 1 : 0;
     if(_z_) return _z_;
     var param$0 = l;
    }
   }
   function mem_assq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:219:10>>*/ return 0;
     var l = param$0[2], a = param$0[1][1], _y_ = a === x ? 1 : 0;
     if(_y_) return _y_;
     var param$0 = l;
    }
   }
   function remove_assoc(x, param){
     /*<<?>>*/ if(! param)  /*<<list.ml:223:10>>*/ return 0;
    var l = param[2], pair = param[1], a = pair[1];
     /*<<list.ml:225:9>>*/ return 0
            ===  /*<<list.ml:225:9>>*/ caml_compare(a, x)
            ? l
            : [0, pair, remove_assoc(x, l)];
   }
   function remove_assq(x, param){
     /*<<?>>*/ if(! param)  /*<<list.ml:228:10>>*/ return 0;
    var l = param[2], pair = param[1], a = pair[1];
    return a === x ? l : [0, pair, remove_assq(x, l)];
   }
   function find(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0)
       /*<<list.ml:232:10>>*/ throw  /*<<list.ml:232:10>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var l = param$0[2], x = param$0[1];
      /*<<list.ml:233:17>>*/ if( /*<<list.ml:233:17>>*/ caml_call1(p, x))
       /*<<list.ml:233:26>>*/ return x;
     var param$0 = l;
    }
   }
   function find_opt(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:236:10>>*/ return 0;
     var l = param$0[2], x = param$0[1];
      /*<<list.ml:237:17>>*/ if( /*<<list.ml:237:17>>*/ caml_call1(p, x))
       /*<<list.ml:237:26>>*/ return [0, x];
     var param$0 = l;
    }
   }
   function find_index(p){
     /*<<list.ml:240:2>>*/  /*<<list.ml:243:2>>*/ var i = 0;
     /*<<list.ml:243:2>>*/ return function(param$0){
     var i$0 = i, param = param$0;
     for(;;){
      if(! param)  /*<<list.ml:241:10>>*/ return 0;
      var l = param[2], a = param[1];
       /*<<list.ml:242:17>>*/ if( /*<<list.ml:242:17>>*/ caml_call1(p, a))
        /*<<list.ml:242:26>>*/ return [0, i$0];
      var i$1 = i$0 + 1 | 0, i$0 = i$1, param = l;
     }};
    /*<<list.ml:243:7>>*/ }
   function find_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:246:10>>*/ return 0;
      /*<<list.ml:248:17>>*/ var
      l = param$0[2],
      x = param$0[1],
       /*<<list.ml:248:17>>*/ result =
         /*<<list.ml:248:17>>*/ caml_call1(f, x);
     if(result)  /*<<list.ml:249:29>>*/ return result;
     var param$0 = l;
    }
   }
   function find_mapi(f){
     /*<<list.ml:254:2>>*/  /*<<list.ml:261:2>>*/ var i = 0;
     /*<<list.ml:261:2>>*/ return function(param$0){
     var i$0 = i, param = param$0;
     for(;;){
      if(! param)  /*<<list.ml:255:10>>*/ return 0;
       /*<<list.ml:257:17>>*/ var
       l = param[2],
       x = param[1],
        /*<<list.ml:257:17>>*/ result =
          /*<<list.ml:257:17>>*/ caml_call2(f, i$0, x);
      if(result)  /*<<list.ml:258:29>>*/ return result;
      var i$1 = i$0 + 1 | 0, i$0 = i$1, param = l;
     }};
    /*<<list.ml:261:7>>*/ }
   function find_all(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:264:10>>*/ return 0;
     var l = param$0[2], x = param$0[1];
      /*<<list.ml:265:17>>*/ if( /*<<list.ml:265:17>>*/ caml_call1(p, x)){
       /*<<list.ml:265:26>>*/ var
        /*<<list.ml:265:26>>*/ block = [0, x, 24029],
       dst = block,
       offset = 1,
       param$1 = l;
      for(;;){
       if(! param$1){
        dst[1 + offset] = 0;
         /*<<list.ml:265:31>>*/ return block;
       }
       var l$0 = param$1[2], x$0 = param$1[1];
        /*<<list.ml:265:17>>*/ if( /*<<list.ml:265:17>>*/ caml_call1(p, x$0)){
         /*<<list.ml:265:26>>*/  /*<<list.ml:265:26>>*/ var
         dst$0 = [0, x$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, param$1 = l$0;
       }
       else
        var param$1 = l$0;
      }
     }
     else
      var param$0 = l;
    }
   }
   function filteri(p, l$1){
     /*<<list.ml:275:18>>*/ var i = 0, param = l$1;
    for(;;){
     if(! param)  /*<<list.ml:270:10>>*/ return 0;
      /*<<list.ml:272:6>>*/ var
      l = param[2],
      x = param[1],
       /*<<list.ml:272:6>>*/ i$0 = i + 1 | 0;
      /*<<list.ml:273:9>>*/ if( /*<<list.ml:273:9>>*/ caml_call2(p, i, x))
      break;
     var i = i$0, param = l;
    }
     /*<<list.ml:273:20>>*/ var
      /*<<list.ml:273:20>>*/ block = [0, x, 24029],
     dst = block,
     offset = 1,
     i$1 = i$0,
     param$0 = l;
    for(;;){
     if(! param$0){dst[1 + offset] = 0;  /*<<list.ml:273:25>>*/ return block;}
      /*<<list.ml:272:6>>*/ var
      l$0 = param$0[2],
      x$0 = param$0[1],
       /*<<list.ml:272:6>>*/ i$2 = i$1 + 1 | 0;
      /*<<list.ml:273:9>>*/ if( /*<<list.ml:273:9>>*/ caml_call2(p, i$1, x$0)){
       /*<<list.ml:273:20>>*/  /*<<list.ml:273:20>>*/ var
       dst$0 = [0, x$0, 24029];
      dst[1 + offset] = dst$0;
      var dst = dst$0, offset = 1, i$1 = i$2, param$0 = l$0;
     }
     else
      var i$1 = i$2, param$0 = l$0;
    }
    /*<<list.ml:275:31>>*/ }
   function filter_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:278:10>>*/ return 0;
      /*<<list.ml:280:12>>*/ var
      l = param$0[2],
      x = param$0[1],
       /*<<list.ml:280:12>>*/ match =  /*<<list.ml:280:12>>*/ caml_call1(f, x);
     if(match){
       /*<<list.ml:282:18>>*/ var
       v = match[1],
        /*<<list.ml:282:18>>*/ block = [0, v, 24029],
       dst = block,
       offset = 1,
       param$1 = l;
      for(;;){
       if(! param$1){
        dst[1 + offset] = 0;
         /*<<list.ml:282:23>>*/ return block;
       }
        /*<<list.ml:280:12>>*/ var
        l$0 = param$1[2],
        x$0 = param$1[1],
         /*<<list.ml:280:12>>*/ match$0 =
           /*<<list.ml:280:12>>*/ caml_call1(f, x$0);
       if(match$0){
         /*<<list.ml:282:18>>*/ var
         v$0 = match$0[1],
          /*<<list.ml:282:18>>*/ dst$0 = [0, v$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, param$1 = l$0;
       }
       else
        var param$1 = l$0;
      }
     }
     else
      var param$0 = l;
    }
   }
   function concat_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0)  /*<<list.ml:285:10>>*/ return 0;
      /*<<list.ml:286:32>>*/ var
      xs = param$0[2],
      x = param$0[1],
       /*<<list.ml:286:32>>*/ ys =  /*<<list.ml:286:32>>*/ caml_call1(f, x);
     if(ys){
       /*<<list.ml:290:15>>*/ var
       ys$1 = ys[2],
       y = ys[1],
        /*<<list.ml:290:15>>*/ block = [0, y, 24029],
       dst = block,
       offset = 1,
       ys$2 = ys$1,
       xs$1 = xs;
       /*<<list.ml:288:2>>*/ for(;;)
       if(ys$2){
         /*<<list.ml:290:15>>*/ var
         ys$3 = ys$2[2],
         y$0 = ys$2[1],
          /*<<list.ml:290:15>>*/ dst$0 = [0, y$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, ys$2 = ys$3;
       }
       else{
        if(! xs$1){dst[1 + offset] = 0;  /*<<list.ml:290:20>>*/ return block;}
         /*<<list.ml:286:32>>*/ var
         xs$0 = xs$1[2],
         x$0 = xs$1[1],
          /*<<list.ml:286:32>>*/ ys$0 =
            /*<<list.ml:286:32>>*/ caml_call1(f, x$0),
         ys$2 = ys$0,
         xs$1 = xs$0;
       }
     }
     else
      var param$0 = xs;
    }
   }
   function fold_left_map(f, accu, l){
     /*<<list.ml:293:2>>*/ var accu$0 = accu, l_accu = 0, param = l;
    for(;;){
     if(! param)  /*<<list.ml:294:12>>*/ return [0, accu$0, rev(l_accu)];
      /*<<list.ml:296:22>>*/ var
      l$0 = param[2],
      x = param[1],
       /*<<list.ml:296:22>>*/ match =
         /*<<list.ml:296:22>>*/ caml_call2(f, accu$0, x),
      x$0 = match[2],
      accu$1 = match[1],
       /*<<list.ml:297:17>>*/ l_accu$0 = [0, x$0, l_accu],
      accu$0 = accu$1,
      l_accu = l_accu$0,
      param = l$0;
    }
    /*<<list.ml:298:15>>*/ }
   function partition(p, l){
     /*<<list.ml:301:2>>*/ var yes = 0, no = 0, param = l;
    for(;;){
     if(! param){
       /*<<list.ml:302:20>>*/  /*<<list.ml:302:20>>*/ var _x_ = rev(no);
       /*<<list.ml:302:10>>*/ return [0, rev(yes), _x_];
     }
     var l$0 = param[2], x = param[1];
      /*<<list.ml:303:17>>*/ if( /*<<list.ml:303:17>>*/ caml_call1(p, x))
       /*<<list.ml:303:31>>*/ var
        /*<<list.ml:303:31>>*/ yes$0 = [0, x, yes],
       yes = yes$0,
       param = l$0;
     else
       /*<<list.ml:303:61>>*/ var
        /*<<list.ml:303:61>>*/ no$0 = [0, x, no],
       no = no$0,
       param = l$0;
    }
    /*<<list.ml:304:14>>*/ }
   function partition_map(p, l){
     /*<<list.ml:307:2>>*/ var left = 0, right = 0, param = l;
    for(;;){
     if(! param){
       /*<<list.ml:308:21>>*/  /*<<list.ml:308:21>>*/ var _w_ = rev(right);
       /*<<list.ml:308:10>>*/ return [0, rev(left), _w_];
     }
      /*<<list.ml:310:17>>*/ var
      l$0 = param[2],
      x = param[1],
       /*<<list.ml:310:17>>*/ match =  /*<<list.ml:310:17>>*/ caml_call1(p, x);
     if(0 === match[0])
       /*<<list.ml:311:31>>*/ var
       v = match[1],
        /*<<list.ml:311:31>>*/ left$0 = [0, v, left],
       left = left$0,
       param = l$0;
     else
       /*<<list.ml:312:37>>*/ var
       v$0 = match[1],
        /*<<list.ml:312:37>>*/ right$0 = [0, v$0, right],
       right = right$0,
       param = l$0;
    }
    /*<<list.ml:315:14>>*/ }
   function split(param){
     /*<<list.ml:317:16>>*/ if(! param)  /*<<list.ml:318:10>>*/ return _a_;
     /*<<list.ml:320:21>>*/ var
     l = param[2],
     match = param[1],
     y = match[2],
     x = match[1],
      /*<<list.ml:320:21>>*/ match$0 = split(l),
     ry = match$0[2],
     rx = match$0[1];
     /*<<list.ml:320:32>>*/ return [0, [0, x, rx], [0, y, ry]];
    /*<<list.ml:320:46>>*/ }
   function combine(l1, l2){
     /*<<list.ml:323:2>>*/ if(l1){
     if(l2){
      var l2$0 = l2[2], a2 = l2[1], l1$0 = l1[2], a1 = l1[1];
       /*<<list.ml:325:24>>*/ return [0, [0, a1, a2], combine(l1$0, l2$0)];
     }
    }
    else if(! l2)  /*<<list.ml:324:16>>*/ return 0;
     /*<<list.ml:326:14>>*/ return  /*<<list.ml:326:14>>*/ caml_call1
            (Stdlib[1], cst_List_combine);
    /*<<list.ml:326:40>>*/ }
   function merge(cmp, l1, l2){
     /*<<list.ml:331:2>>*/ if(! l1)  /*<<list.ml:332:14>>*/ return l2;
    if(! l2)  /*<<list.ml:333:14>>*/ return l1;
    var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
     /*<<list.ml:335:9>>*/ return 0
            <  /*<<list.ml:335:9>>*/ caml_call2(cmp, h1, h2)
            ? [0, h2, merge(cmp, l1, t2)]
            : [0, h1, merge(cmp, t1, l2)];
    /*<<list.ml:337:32>>*/ }
   function stable_sort(cmp, l){
    function sort(n, l){
      /*<<list.ml:360:4>>*/ if(2 === n){
      if(l){
       var match = l[2];
       if(match){
         /*<<list.ml:362:19>>*/ var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
          /*<<list.ml:362:19>>*/ s =
           0 <  /*<<list.ml:362:19>>*/ caml_call2(cmp, x1, x2)
            ? [0, x2, [0, x1, 0]]
            : [0, x1, [0, x2, 0]];
         /*<<list.ml:363:8>>*/ return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _v_ = l[2];
      if(_v_){
       var match$2 = _v_[2];
       if(match$2){
         /*<<list.ml:366:13>>*/ var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _v_[1],
         x1$0 = l[1],
          /*<<list.ml:366:13>>*/ s$0 =
           0 <  /*<<list.ml:366:13>>*/ caml_call2(cmp, x1$0, x2$0)
            ? 0
              <  /*<<list.ml:370:18>>*/ caml_call2(cmp, x1$0, x3)
              ? 0
                <  /*<<list.ml:371:18>>*/ caml_call2(cmp, x2$0, x3)
                ? [0, x3, [0, x2$0, [0, x1$0, 0]]]
                : [0, x2$0, [0, x3, [0, x1$0, 0]]]
              : [0, x2$0, [0, x1$0, [0, x3, 0]]]
            : 0
              <  /*<<list.ml:367:15>>*/ caml_call2(cmp, x2$0, x3)
              ? 0
                <  /*<<list.ml:368:20>>*/ caml_call2(cmp, x1$0, x3)
                ? [0, x3, [0, x1$0, [0, x2$0, 0]]]
                : [0, x1$0, [0, x3, [0, x2$0, 0]]]
              : [0, x1$0, [0, x2$0, [0, x3, 0]]];
         /*<<list.ml:374:8>>*/ return [0, s$0, tl$1];
       }
      }
     }
      /*<<list.ml:378:21>>*/ var
      n1 = n >> 1,
      n2 = n - n1 | 0,
       /*<<list.ml:378:21>>*/ match$0 = rev_sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
       /*<<list.ml:379:21>>*/ match$1 = rev_sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
      /*<<list.ml:351:4>>*/ for(;;){
      if(l1){
       if(l2){
        var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
         /*<<list.ml:355:11>>*/ if
         (0 <  /*<<list.ml:355:11>>*/ caml_call2(cmp, h1, h2)){
          /*<<list.ml:356:33>>*/ var
           /*<<list.ml:356:33>>*/ accu$0 = [0, h1, accu],
          l1 = t1,
          accu = accu$0;
         continue;
        }
         /*<<list.ml:357:33>>*/ var
          /*<<list.ml:357:33>>*/ accu$1 = [0, h2, accu],
         l2 = t2,
         accu = accu$1;
        continue;
       }
       var _u_ = rev_append(l1, accu);
      }
      else
       var _u_ = rev_append(l2, accu);
       /*<<list.ml:380:8>>*/ return [0, _u_, tl$0];
     }
     /*<<list.ml:380:36>>*/ }
    function rev_sort(n, l){
      /*<<list.ml:382:4>>*/ if(2 === n){
      if(l){
       var match = l[2];
       if(match){
         /*<<list.ml:384:19>>*/ var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
          /*<<list.ml:384:19>>*/ s =
           0 <  /*<<list.ml:384:19>>*/ caml_call2(cmp, x1, x2)
            ? [0, x1, [0, x2, 0]]
            : [0, x2, [0, x1, 0]];
         /*<<list.ml:385:8>>*/ return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _t_ = l[2];
      if(_t_){
       var match$2 = _t_[2];
       if(match$2){
         /*<<list.ml:388:13>>*/ var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _t_[1],
         x1$0 = l[1],
          /*<<list.ml:388:13>>*/ s$0 =
           0 <  /*<<list.ml:388:13>>*/ caml_call2(cmp, x1$0, x2$0)
            ? 0
              <  /*<<list.ml:389:15>>*/ caml_call2(cmp, x2$0, x3)
              ? [0, x1$0, [0, x2$0, [0, x3, 0]]]
              : 0
                <  /*<<list.ml:390:20>>*/ caml_call2(cmp, x1$0, x3)
                ? [0, x1$0, [0, x3, [0, x2$0, 0]]]
                : [0, x3, [0, x1$0, [0, x2$0, 0]]]
            : 0
              <  /*<<list.ml:392:18>>*/ caml_call2(cmp, x1$0, x3)
              ? [0, x2$0, [0, x1$0, [0, x3, 0]]]
              : 0
                <  /*<<list.ml:393:18>>*/ caml_call2(cmp, x2$0, x3)
                ? [0, x2$0, [0, x3, [0, x1$0, 0]]]
                : [0, x3, [0, x2$0, [0, x1$0, 0]]];
         /*<<list.ml:396:8>>*/ return [0, s$0, tl$1];
       }
      }
     }
      /*<<list.ml:400:21>>*/ var
      n1 = n >> 1,
      n2 = n - n1 | 0,
       /*<<list.ml:400:21>>*/ match$0 = sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
       /*<<list.ml:401:21>>*/ match$1 = sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
      /*<<list.ml:342:4>>*/ for(;;){
      if(l1){
       if(l2){
        var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
         /*<<list.ml:346:11>>*/ if
         (0 <  /*<<list.ml:346:11>>*/ caml_call2(cmp, h1, h2)){
          /*<<list.ml:348:29>>*/ var
           /*<<list.ml:348:29>>*/ accu$0 = [0, h2, accu],
          l2 = t2,
          accu = accu$0;
         continue;
        }
         /*<<list.ml:347:29>>*/ var
          /*<<list.ml:347:29>>*/ accu$1 = [0, h1, accu],
         l1 = t1,
         accu = accu$1;
        continue;
       }
       var _s_ = rev_append(l1, accu);
      }
      else
       var _s_ = rev_append(l2, accu);
       /*<<list.ml:402:8>>*/ return [0, _s_, tl$0];
     }
     /*<<list.ml:402:32>>*/ }
     /*<<list.ml:404:12>>*/  /*<<list.ml:404:12>>*/ var len = length(l);
     /*<<list.ml:405:2>>*/ return 2 <= len ? sort(len, l)[1] : l;
    /*<<list.ml:405:41>>*/ }
   function sort_uniq(cmp, l){
    function sort(n, l){
      /*<<list.ml:443:4>>*/ if(2 === n){
      if(l){
       var match = l[2];
       if(match){
         /*<<list.ml:446:18>>*/ var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
          /*<<list.ml:446:18>>*/ c$0 =
            /*<<list.ml:446:18>>*/ caml_call2(cmp, x1, x2),
          /*<<list.ml:447:10>>*/ s =
           0 === c$0
            ? [0, x1, 0]
            : 0 <= c$0 ? [0, x2, [0, x1, 0]] : [0, x1, [0, x2, 0]];
         /*<<list.ml:449:8>>*/ return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _m_ = l[2];
      if(_m_){
       var match$2 = _m_[2];
       if(match$2){
         /*<<list.ml:452:18>>*/ var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _m_[1],
         x1$0 = l[1],
          /*<<list.ml:452:18>>*/ c$1 =
            /*<<list.ml:452:18>>*/ caml_call2(cmp, x1$0, x2$0);
         /*<<list.ml:453:10>>*/ if(0 === c$1)
          /*<<list.ml:454:20>>*/ var
           /*<<list.ml:454:20>>*/ c$2 =
             /*<<list.ml:454:20>>*/ caml_call2(cmp, x2$0, x3),
           /*<<list.ml:455:12>>*/ _n_ =
            0 === c$2
             ? [0, x2$0, 0]
             : 0 <= c$2 ? [0, x3, [0, x2$0, 0]] : [0, x2$0, [0, x3, 0]],
          s$0 = _n_;
        else if(0 <= c$1){
          /*<<list.ml:466:20>>*/  /*<<list.ml:466:20>>*/ var
          c$3 =  /*<<list.ml:466:20>>*/ caml_call2(cmp, x1$0, x3);
          /*<<list.ml:467:12>>*/ if(0 === c$3)
          var _o_ = [0, x2$0, [0, x1$0, 0]];
         else if(0 <= c$3)
           /*<<list.ml:470:22>>*/ var
            /*<<list.ml:470:22>>*/ c$4 =
              /*<<list.ml:470:22>>*/ caml_call2(cmp, x2$0, x3),
            /*<<list.ml:471:14>>*/ _p_ =
             0 === c$4
              ? [0, x2$0, [0, x1$0, 0]]
              : 0
                <= c$4
                ? [0, x3, [0, x2$0, [0, x1$0, 0]]]
                : [0, x2$0, [0, x3, [0, x1$0, 0]]],
           _o_ = _p_;
         else
          var _o_ = [0, x2$0, [0, x1$0, [0, x3, 0]]];
         var s$0 = _o_;
        }
        else{
          /*<<list.ml:457:20>>*/  /*<<list.ml:457:20>>*/ var
          c$5 =  /*<<list.ml:457:20>>*/ caml_call2(cmp, x2$0, x3);
          /*<<list.ml:458:12>>*/ if(0 === c$5)
          var _q_ = [0, x1$0, [0, x2$0, 0]];
         else if(0 <= c$5)
           /*<<list.ml:461:22>>*/ var
            /*<<list.ml:461:22>>*/ c$6 =
              /*<<list.ml:461:22>>*/ caml_call2(cmp, x1$0, x3),
            /*<<list.ml:462:14>>*/ _r_ =
             0 === c$6
              ? [0, x1$0, [0, x2$0, 0]]
              : 0
                <= c$6
                ? [0, x3, [0, x1$0, [0, x2$0, 0]]]
                : [0, x1$0, [0, x3, [0, x2$0, 0]]],
           _q_ = _r_;
         else
          var _q_ = [0, x1$0, [0, x2$0, [0, x3, 0]]];
         var s$0 = _q_;
        }
         /*<<list.ml:475:8>>*/ return [0, s$0, tl$1];
       }
      }
     }
      /*<<list.ml:479:21>>*/ var
      n1 = n >> 1,
      n2 = n - n1 | 0,
       /*<<list.ml:479:21>>*/ match$0 = rev_sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
       /*<<list.ml:480:21>>*/ match$1 = rev_sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
      /*<<list.ml:432:4>>*/ for(;;){
      if(l1){
       if(l2){
         /*<<list.ml:436:16>>*/ var
         t2 = l2[2],
         h2 = l2[1],
         t1 = l1[2],
         h1 = l1[1],
          /*<<list.ml:436:16>>*/ c =
            /*<<list.ml:436:16>>*/ caml_call2(cmp, h1, h2);
         /*<<list.ml:437:8>>*/ if(0 === c){
          /*<<list.ml:437:42>>*/ var
           /*<<list.ml:437:42>>*/ accu$0 = [0, h1, accu],
          l1 = t1,
          l2 = t2,
          accu = accu$0;
         continue;
        }
        if(0 < c){
          /*<<list.ml:439:33>>*/ var
           /*<<list.ml:439:33>>*/ accu$1 = [0, h1, accu],
          l1 = t1,
          accu = accu$1;
         continue;
        }
         /*<<list.ml:440:33>>*/ var
          /*<<list.ml:440:33>>*/ accu$2 = [0, h2, accu],
         l2 = t2,
         accu = accu$2;
        continue;
       }
       var _l_ = rev_append(l1, accu);
      }
      else
       var _l_ = rev_append(l2, accu);
       /*<<list.ml:481:8>>*/ return [0, _l_, tl$0];
     }
     /*<<list.ml:481:36>>*/ }
    function rev_sort(n, l){
      /*<<list.ml:483:4>>*/ if(2 === n){
      if(l){
       var match = l[2];
       if(match){
         /*<<list.ml:486:18>>*/ var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
          /*<<list.ml:486:18>>*/ c$0 =
            /*<<list.ml:486:18>>*/ caml_call2(cmp, x1, x2),
          /*<<list.ml:487:10>>*/ s =
           0 === c$0
            ? [0, x1, 0]
            : 0 < c$0 ? [0, x1, [0, x2, 0]] : [0, x2, [0, x1, 0]];
         /*<<list.ml:489:8>>*/ return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _f_ = l[2];
      if(_f_){
       var match$2 = _f_[2];
       if(match$2){
         /*<<list.ml:492:18>>*/ var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _f_[1],
         x1$0 = l[1],
          /*<<list.ml:492:18>>*/ c$1 =
            /*<<list.ml:492:18>>*/ caml_call2(cmp, x1$0, x2$0);
         /*<<list.ml:493:10>>*/ if(0 === c$1)
          /*<<list.ml:494:20>>*/ var
           /*<<list.ml:494:20>>*/ c$2 =
             /*<<list.ml:494:20>>*/ caml_call2(cmp, x2$0, x3),
           /*<<list.ml:495:12>>*/ _g_ =
            0 === c$2
             ? [0, x2$0, 0]
             : 0 < c$2 ? [0, x2$0, [0, x3, 0]] : [0, x3, [0, x2$0, 0]],
          s$0 = _g_;
        else if(0 < c$1){
          /*<<list.ml:497:20>>*/  /*<<list.ml:497:20>>*/ var
          c$3 =  /*<<list.ml:497:20>>*/ caml_call2(cmp, x2$0, x3);
          /*<<list.ml:498:12>>*/ if(0 === c$3)
          var _h_ = [0, x1$0, [0, x2$0, 0]];
         else if(0 < c$3)
          var _h_ = [0, x1$0, [0, x2$0, [0, x3, 0]]];
         else
           /*<<list.ml:501:22>>*/ var
            /*<<list.ml:501:22>>*/ c$4 =
              /*<<list.ml:501:22>>*/ caml_call2(cmp, x1$0, x3),
            /*<<list.ml:502:14>>*/ _i_ =
             0 === c$4
              ? [0, x1$0, [0, x2$0, 0]]
              : 0
                < c$4
                ? [0, x1$0, [0, x3, [0, x2$0, 0]]]
                : [0, x3, [0, x1$0, [0, x2$0, 0]]],
           _h_ = _i_;
         var s$0 = _h_;
        }
        else{
          /*<<list.ml:506:20>>*/  /*<<list.ml:506:20>>*/ var
          c$5 =  /*<<list.ml:506:20>>*/ caml_call2(cmp, x1$0, x3);
          /*<<list.ml:507:12>>*/ if(0 === c$5)
          var _j_ = [0, x2$0, [0, x1$0, 0]];
         else if(0 < c$5)
          var _j_ = [0, x2$0, [0, x1$0, [0, x3, 0]]];
         else
           /*<<list.ml:510:22>>*/ var
            /*<<list.ml:510:22>>*/ c$6 =
              /*<<list.ml:510:22>>*/ caml_call2(cmp, x2$0, x3),
            /*<<list.ml:511:14>>*/ _k_ =
             0 === c$6
              ? [0, x2$0, [0, x1$0, 0]]
              : 0
                < c$6
                ? [0, x2$0, [0, x3, [0, x1$0, 0]]]
                : [0, x3, [0, x2$0, [0, x1$0, 0]]],
           _j_ = _k_;
         var s$0 = _j_;
        }
         /*<<list.ml:515:8>>*/ return [0, s$0, tl$1];
       }
      }
     }
      /*<<list.ml:519:21>>*/ var
      n1 = n >> 1,
      n2 = n - n1 | 0,
       /*<<list.ml:519:21>>*/ match$0 = sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
       /*<<list.ml:520:21>>*/ match$1 = sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
      /*<<list.ml:421:4>>*/ for(;;){
      if(l1){
       if(l2){
         /*<<list.ml:425:16>>*/ var
         t2 = l2[2],
         h2 = l2[1],
         t1 = l1[2],
         h1 = l1[1],
          /*<<list.ml:425:16>>*/ c =
            /*<<list.ml:425:16>>*/ caml_call2(cmp, h1, h2);
         /*<<list.ml:426:8>>*/ if(0 === c){
          /*<<list.ml:426:38>>*/ var
           /*<<list.ml:426:38>>*/ accu$0 = [0, h1, accu],
          l1 = t1,
          l2 = t2,
          accu = accu$0;
         continue;
        }
        if(0 <= c){
          /*<<list.ml:429:29>>*/ var
           /*<<list.ml:429:29>>*/ accu$1 = [0, h2, accu],
          l2 = t2,
          accu = accu$1;
         continue;
        }
         /*<<list.ml:428:29>>*/ var
          /*<<list.ml:428:29>>*/ accu$2 = [0, h1, accu],
         l1 = t1,
         accu = accu$2;
        continue;
       }
       var _e_ = rev_append(l1, accu);
      }
      else
       var _e_ = rev_append(l2, accu);
       /*<<list.ml:521:8>>*/ return [0, _e_, tl$0];
     }
     /*<<list.ml:521:32>>*/ }
     /*<<list.ml:523:12>>*/  /*<<list.ml:523:12>>*/ var len = length(l);
     /*<<list.ml:524:2>>*/ return 2 <= len ? sort(len, l)[1] : l;
    /*<<list.ml:524:41>>*/ }
   function compare_lengths(l1, l2){
     /*<<list.ml:528:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:528:2>>*/ for(;;){
     if(! l1$0) return l2$0 ? -1 : 0;
     if(! l2$0)  /*<<list.ml:531:13>>*/ return 1;
     var l2$1 = l2$0[2], l1$1 = l1$0[2], l1$0 = l1$1, l2$0 = l2$1;
    }
    /*<<list.ml:532:45>>*/ }
   function compare_length_with(l, n){
     /*<<list.ml:535:2>>*/ var l$0 = l, n$0 = n;
     /*<<list.ml:535:2>>*/ for(;;){
     if(! l$0) return 0 === n$0 ? 0 : 0 < n$0 ? -1 : 1;
     var l$1 = l$0[2];
      /*<<list.ml:540:4>>*/ if(0 >= n$0)  /*<<list.ml:540:19>>*/ return 1;
      /*<<list.ml:541:6>>*/ var
       /*<<list.ml:541:6>>*/ n$1 = n$0 - 1 | 0,
      l$0 = l$1,
      n$0 = n$1;
    }
    /*<<list.ml:541:33>>*/ }
   function is_empty(param){
     /*<<list.ml:543:15>>*/ return param ? 0 : 1;
    /*<<list.ml:545:19>>*/ }
   function equal(eq, l1, l2){
     /*<<list.ml:555:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:555:2>>*/ for(;;){
     if(l1$0){
      if(l2$0){
        /*<<list.ml:558:22>>*/ var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
         /*<<list.ml:558:22>>*/ _d_ =
           /*<<list.ml:558:22>>*/ caml_call2(eq, a1, a2);
        /*<<list.ml:558:22>>*/ if(! _d_)  /*<<list.ml:558:22>>*/ return _d_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0)  /*<<list.ml:556:14>>*/ return 1;
      /*<<list.ml:557:27>>*/ return 0;
    }
    /*<<list.ml:558:48>>*/ }
   function compare(cmp, l1, l2){
     /*<<list.ml:561:2>>*/ var l1$0 = l1, l2$0 = l2;
     /*<<list.ml:561:2>>*/ for(;;){
     if(! l1$0) return l2$0 ? -1 : 0;
     var l1$1 = l1$0[2], a1 = l1$0[1];
     if(! l2$0)  /*<<list.ml:564:16>>*/ return 1;
      /*<<list.ml:566:12>>*/ var
      l2$1 = l2$0[2],
      a2 = l2$0[1],
       /*<<list.ml:566:12>>*/ c =
         /*<<list.ml:566:12>>*/ caml_call2(cmp, a1, a2);
      /*<<list.ml:567:4>>*/ if(0 !== c)  /*<<list.ml:567:19>>*/ return c;
     var l1$0 = l1$1, l2$0 = l2$1;
    }
    /*<<list.ml:568:26>>*/ }
   function to_seq(l){
     /*<<list.ml:573:2>>*/ function aux(l, param){
      /*<<list.ml:573:21>>*/ if(! l)  /*<<list.ml:574:12>>*/ return 0;
     var tail = l[2], x = l[1];
      /*<<list.ml:575:19>>*/ return [0,
             x,
             function(_c_){ /*<<?>>*/ return aux(tail, _c_);}];
     /*<<list.ml:575:41>>*/ }
     /*<<list.ml:577:2>>*/ return function(_b_){
      /*<<?>>*/ return aux(l, _b_);};
    /*<<list.ml:577:7>>*/ }
   function of_seq(seq){
     /*<<list.ml:580:2>>*/  /*<<list.ml:580:8>>*/ var
     match =  /*<<list.ml:580:8>>*/ caml_call1(seq, 0);
    if(! match)  /*<<list.ml:581:15>>*/ return 0;
     /*<<list.ml:583:18>>*/ var
     seq$0 = match[2],
     x1 = match[1],
      /*<<list.ml:583:18>>*/ match$0 =
        /*<<list.ml:583:18>>*/ caml_call1(seq$0, 0);
    if(! match$0)  /*<<list.ml:584:19>>*/ return [0, x1, 0];
     /*<<list.ml:585:36>>*/ var
     seq$1 = match$0[2],
     x2 = match$0[1],
      /*<<list.ml:585:36>>*/ block = [0, x2, 24029],
     dst = block,
     offset = 1,
     seq$2 = seq$1;
     /*<<list.ml:580:2>>*/ for(;;){
      /*<<list.ml:580:8>>*/  /*<<list.ml:580:8>>*/ var
      match$1 =  /*<<list.ml:580:8>>*/ caml_call1(seq$2, 0);
     if(match$1){
       /*<<list.ml:583:18>>*/ var
       seq$3 = match$1[2],
       x1$0 = match$1[1],
        /*<<list.ml:583:18>>*/ match$2 =
          /*<<list.ml:583:18>>*/ caml_call1(seq$3, 0);
      if(match$2){
        /*<<list.ml:585:36>>*/ var
        seq$4 = match$2[2],
        x2$0 = match$2[1],
         /*<<list.ml:585:36>>*/ dst$0 = [0, x2$0, 24029];
       dst[1 + offset] = [0, x1$0, dst$0];
       var dst = dst$0, offset = 1, seq$2 = seq$4;
       continue;
      }
      dst[1 + offset] = [0, x1$0, 0];
     }
     else
      dst[1 + offset] = 0;
      /*<<list.ml:585:30>>*/ return [0, x1, block];
    }
    /*<<list.ml:586:9>>*/ }
   var
    Stdlib_List =
      [0,
       length,
       compare_lengths,
       compare_length_with,
       is_empty,
       cons,
       hd,
       tl,
       nth,
       nth_opt,
       rev,
       init,
       append,
       rev_append,
       flatten,
       flatten,
       equal,
       compare,
       iter,
       iteri,
       map,
       mapi,
       rev_map,
       filter_map,
       concat_map,
       fold_left_map,
       fold_left,
       fold_right,
       iter2,
       map2,
       rev_map2,
       fold_left2,
       fold_right2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find,
       find_opt,
       find_index,
       find_map,
       find_mapi,
       find_all,
       find_all,
       filteri,
       partition,
       partition_map,
       assoc,
       assoc_opt,
       assq,
       assq_opt,
       mem_assoc,
       mem_assq,
       remove_assoc,
       remove_assq,
       split,
       combine,
       stable_sort,
       stable_sort,
       stable_sort,
       sort_uniq,
       merge,
       to_seq,
       of_seq];
   runtime.caml_register_global(17, Stdlib_List, "Stdlib__List");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Int
(function(globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, caml_hash = runtime.caml_hash;
   function abs(x){
     /*<<int.ml:29:12>>*/ return 0 <= x ? x : - x | 0;
    /*<<int.ml:29:36>>*/ }
   function lognot(x){
     /*<<int.ml:35:15>>*/ return x ^ -1;
    /*<<int.ml:35:28>>*/ }
   function equal(_b_, _a_){ /*<<?>>*/ return _b_ === _a_ ? 1 : 0;}
   var compare = runtime.caml_int_compare;
   function min(x, y){
     /*<<int.ml:41:18>>*/ return x <= y ? x : y;
    /*<<int.ml:41:41>>*/ }
   function max(x, y){
     /*<<int.ml:42:18>>*/ return y <= x ? x : y;
    /*<<int.ml:42:41>>*/ }
   function to_string(x){
     /*<<int.ml:52:18>>*/ return "" + x;
    /*<<int.ml:52:35>>*/ }
   function seeded_hash(seed, x){
     /*<<int.ml:56:25>>*/ return  /*<<int.ml:56:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<int.ml:56:56>>*/ }
   function hash(x){
     /*<<int.ml:57:13>>*/ return  /*<<int.ml:57:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<int.ml:57:41>>*/ }
   var
    Stdlib_Int =
      [0,
       0,
       1,
       -1,
       abs,
       2147483647,
       -2147483648,
       lognot,
       equal,
       compare,
       min,
       max,
       to_string,
       seeded_hash,
       hash];
   runtime.caml_register_global(1, Stdlib_Int, "Stdlib__Int");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Bytes
//# unitInfo: Requires: Stdlib, Stdlib__Char, Stdlib__Int, Stdlib__Seq, Stdlib__Sys, Stdlib__Uchar
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_bytes_ml = "bytes.ml",
    cst_index_out_of_bounds$3 = "index out of bounds",
    caml_blit_bytes = runtime.caml_blit_bytes,
    caml_bswap16 = runtime.caml_bswap16,
    caml_bytes_get = runtime.caml_bytes_get,
    caml_bytes_get16 = runtime.caml_bytes_get16,
    caml_bytes_get32 = runtime.caml_bytes_get32,
    caml_bytes_get64 = runtime.caml_bytes_get64,
    caml_bytes_of_string = runtime.caml_bytes_of_string,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_bytes_set16 = runtime.caml_bytes_set16,
    caml_bytes_set32 = runtime.caml_bytes_set32,
    caml_bytes_set64 = runtime.caml_bytes_set64,
    caml_bytes_unsafe_get = runtime.caml_bytes_unsafe_get,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_fill_bytes = runtime.caml_fill_bytes,
    caml_int32_bswap = runtime.caml_int32_bswap,
    caml_int64_bswap = runtime.caml_int64_bswap,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_string_of_bytes = runtime.caml_string_of_bytes,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Uchar = global_data.Stdlib__Uchar,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_Char = global_data.Stdlib__Char;
   function make(n, c){
     /*<<bytes.ml:42:2>>*/  /*<<bytes.ml:42:10>>*/ var
     s =  /*<<bytes.ml:42:10>>*/ caml_create_bytes(n);
     /*<<bytes.ml:43:2>>*/  /*<<bytes.ml:43:2>>*/ caml_fill_bytes(s, 0, n, c);
     /*<<bytes.ml:43:2>>*/ return s;
    /*<<bytes.ml:44:3>>*/ }
   function init(n, f){
     /*<<bytes.ml:47:2>>*/ var
      /*<<bytes.ml:47:10>>*/ s =  /*<<bytes.ml:47:10>>*/ caml_create_bytes(n),
      /*<<bytes.ml:48:2>>*/ _ap_ = n - 1 | 0,
      /*<<bytes.ml:47:10>>*/ _ao_ = 0;
    if(_ap_ >= 0){
     var i = _ao_;
     for(;;){
      caml_bytes_unsafe_set(s, i,  /*<<bytes.ml:49:19>>*/ caml_call1(f, i));
       /*<<bytes.ml:48:2>>*/  /*<<bytes.ml:48:2>>*/ var _aq_ = i + 1 | 0;
      if(_ap_ === i) break;
      var i = _aq_;
     }
    }
     /*<<bytes.ml:51:2>>*/ return s;
    /*<<bytes.ml:51:3>>*/ }
    /*<<bytes.ml:53:12>>*/ var
     /*<<bytes.ml:53:12>>*/ empty =
       /*<<bytes.ml:53:12>>*/ caml_create_bytes(0),
    cst_String_sub_Bytes_sub = "String.sub / Bytes.sub",
    cst_Bytes_extend = "Bytes.extend",
    cst_String_fill_Bytes_fill = "String.fill / Bytes.fill",
    cst_Bytes_blit = "Bytes.blit",
    cst_String_blit_Bytes_blit_str = "String.blit / Bytes.blit_string",
    cst_Bytes_concat = "Bytes.concat",
    cst_String_index_from_Bytes_in = "String.index_from / Bytes.index_from",
    cst_String_index_from_opt_Byte =
      "String.index_from_opt / Bytes.index_from_opt",
    cst_String_rindex_from_Bytes_r = "String.rindex_from / Bytes.rindex_from",
    cst_String_rindex_from_opt_Byt =
      "String.rindex_from_opt / Bytes.rindex_from_opt",
    cst_String_contains_from_Bytes =
      "String.contains_from / Bytes.contains_from",
    cst_String_rcontains_from_Byte =
      "String.rcontains_from / Bytes.rcontains_from";
   function copy(s){
     /*<<bytes.ml:56:2>>*/ var
     len = caml_ml_bytes_length(s),
      /*<<bytes.ml:57:10>>*/ r =
        /*<<bytes.ml:57:10>>*/ caml_create_bytes(len);
     /*<<bytes.ml:58:2>>*/  /*<<bytes.ml:58:2>>*/ caml_blit_bytes
     (s, 0, r, 0, len);
     /*<<bytes.ml:58:2>>*/ return r;
    /*<<bytes.ml:59:3>>*/ }
   function to_string(b){
     /*<<bytes.ml:61:18>>*/ return  /*<<bytes.ml:61:35>>*/ caml_string_of_bytes
            (copy(b));
    /*<<bytes.ml:61:43>>*/ }
   function of_string(s){
     /*<<bytes.ml:62:18>>*/ return copy(caml_bytes_of_string(s));
    /*<<bytes.ml:62:43>>*/ }
   function sub(s, ofs, len){
     /*<<bytes.ml:65:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs){
      /*<<bytes.ml:68:12>>*/  /*<<bytes.ml:68:12>>*/ var
      r =  /*<<bytes.ml:68:12>>*/ caml_create_bytes(len);
      /*<<bytes.ml:69:4>>*/  /*<<bytes.ml:69:4>>*/ caml_blit_bytes
      (s, ofs, r, 0, len);
      /*<<bytes.ml:69:4>>*/ return r;
    }
     /*<<bytes.ml:66:7>>*/ return  /*<<bytes.ml:66:7>>*/ caml_call1
            (Stdlib[1], cst_String_sub_Bytes_sub);
    /*<<bytes.ml:71:5>>*/ }
   function sub_string(b, ofs, len){
     /*<<bytes.ml:73:27>>*/ return  /*<<bytes.ml:73:44>>*/ caml_string_of_bytes
            (sub(b, ofs, len));
    /*<<bytes.ml:73:59>>*/ }
   function symbol(a, b){
     /*<<bytes.ml:77:2>>*/ var
     c = a + b | 0,
     _an_ = b < 0 ? 1 : 0,
     match = c < 0 ? 1 : 0;
    a:
    {
     if(a < 0){if(_an_ && ! match) break a;} else if(! _an_ && match) break a;
      /*<<bytes.ml:81:9>>*/ return c;
    }
     /*<<bytes.ml:80:27>>*/ return  /*<<bytes.ml:80:27>>*/ caml_call1
            (Stdlib[1], cst_Bytes_extend);
    /*<<bytes.ml:81:10>>*/ }
   function extend(s, left, right){
     /*<<bytes.ml:84:2>>*/ var
      /*<<bytes.ml:84:12>>*/ len =
       symbol(symbol(caml_ml_bytes_length(s), left), right),
      /*<<bytes.ml:85:10>>*/ r =
        /*<<bytes.ml:85:10>>*/ caml_create_bytes(len);
    if(0 <= left)
     var dstoff = left, srcoff = 0;
    else
     var dstoff = 0, srcoff = - left | 0;
     /*<<bytes.ml:87:15>>*/  /*<<bytes.ml:87:15>>*/ var
     cpylen =
        /*<<bytes.ml:87:15>>*/ caml_call2
        (Stdlib_Int[10],
         caml_ml_bytes_length(s) - srcoff | 0,
         len - dstoff | 0);
    if(0 < cpylen)
      /*<<bytes.ml:88:21>>*/  /*<<bytes.ml:88:21>>*/ caml_blit_bytes
      (s, srcoff, r, dstoff, cpylen);
     /*<<bytes.ml:88:21>>*/ return r;
    /*<<bytes.ml:89:3>>*/ }
   function fill(s, ofs, len, c){
     /*<<bytes.ml:92:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
      /*<<bytes.ml:94:7>>*/ return  /*<<bytes.ml:94:7>>*/ caml_fill_bytes
             (s, ofs, len, c);
     /*<<bytes.ml:93:7>>*/ return  /*<<bytes.ml:93:7>>*/ caml_call1
            (Stdlib[1], cst_String_fill_Bytes_fill);
    /*<<bytes.ml:94:30>>*/ }
   function blit(s1, ofs1, s2, ofs2, len){
     /*<<bytes.ml:97:2>>*/ if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (caml_ml_bytes_length(s1) - len | 0) >= ofs1
        && 0 <= ofs2 && (caml_ml_bytes_length(s2) - len | 0) >= ofs2)
      /*<<bytes.ml:100:7>>*/ return  /*<<bytes.ml:100:7>>*/ caml_blit_bytes
             (s1, ofs1, s2, ofs2, len);
     /*<<bytes.ml:99:7>>*/ return  /*<<bytes.ml:99:7>>*/ caml_call1
            (Stdlib[1], cst_Bytes_blit);
    /*<<bytes.ml:100:38>>*/ }
   function blit_string(s1, ofs1, s2, ofs2, len){
     /*<<bytes.ml:103:2>>*/ if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (runtime.caml_ml_string_length(s1) - len | 0) >= ofs1
        && 0 <= ofs2 && (caml_ml_bytes_length(s2) - len | 0) >= ofs2)
      /*<<bytes.ml:106:7>>*/ return  /*<<bytes.ml:106:7>>*/ runtime.caml_blit_string
             (s1, ofs1, s2, ofs2, len);
     /*<<bytes.ml:105:7>>*/ return  /*<<bytes.ml:105:7>>*/ caml_call1
            (Stdlib[1], cst_String_blit_Bytes_blit_str);
    /*<<bytes.ml:106:45>>*/ }
   function iter(f, a){
     /*<<bytes.ml:110:2>>*/ var
     _al_ = caml_ml_bytes_length(a) - 1 | 0,
      /*<<bytes.ml:110:2>>*/ _ak_ = 0;
    if(_al_ >= 0){
     var i = _ak_;
     for(;;){
       /*<<bytes.ml:110:31>>*/  /*<<bytes.ml:110:31>>*/ caml_call1
       (f, caml_bytes_unsafe_get(a, i));
       /*<<bytes.ml:110:31>>*/  /*<<bytes.ml:110:31>>*/ var _am_ = i + 1 | 0;
      if(_al_ === i) break;
      var i = _am_;
     }
    }
    return 0;
    /*<<bytes.ml:110:53>>*/ }
   function iteri(f, a){
     /*<<bytes.ml:114:2>>*/ var
     _ai_ = caml_ml_bytes_length(a) - 1 | 0,
      /*<<bytes.ml:114:2>>*/ _ah_ = 0;
    if(_ai_ >= 0){
     var i = _ah_;
     for(;;){
       /*<<bytes.ml:114:31>>*/  /*<<bytes.ml:114:31>>*/ caml_call2
       (f, i, caml_bytes_unsafe_get(a, i));
       /*<<bytes.ml:114:31>>*/  /*<<bytes.ml:114:31>>*/ var _aj_ = i + 1 | 0;
      if(_ai_ === i) break;
      var i = _aj_;
     }
    }
    return 0;
    /*<<bytes.ml:114:56>>*/ }
   function concat(sep, l){
     /*<<?>>*/ if(! l)  /*<<bytes.ml:53:12>>*/ return empty;
    var seplen = caml_ml_bytes_length(sep);
    a:
    {
     b:
     {
      var acc = 0, param = l, pos$1 = 0;
      for(;;){
       if(! param) break;
       var hd = param[1];
       if(! param[2]) break b;
       var
        tl = param[2],
        x = (caml_ml_bytes_length(hd) + seplen | 0) + acc | 0,
        acc$0 =
          acc <= x
           ? x
           :  /*<<bytes.ml:116:48>>*/ caml_call1(Stdlib[1], cst_Bytes_concat),
        acc = acc$0,
        param = tl;
      }
      var _ag_ = acc;
      break a;
     }
     var _ag_ = caml_ml_bytes_length(hd) + acc | 0;
    }
     /*<<bytes.ml:136:12>>*/ var
      /*<<bytes.ml:136:12>>*/ dst =
        /*<<bytes.ml:136:12>>*/ caml_create_bytes(_ag_),
     pos = pos$1,
     param$0 = l;
    for(;;){
     if(! param$0)  /*<<bytes.ml:124:10>>*/ return dst;
     var hd$0 = param$0[1];
     if(! param$0[2]){
       /*<<bytes.ml:126:4>>*/  /*<<bytes.ml:126:4>>*/ caml_blit_bytes
       (hd$0, 0, dst, pos, caml_ml_bytes_length(hd$0));
       /*<<bytes.ml:126:4>>*/ return dst;
     }
     var tl$0 = param$0[2];
      /*<<bytes.ml:128:4>>*/  /*<<bytes.ml:128:4>>*/ caml_blit_bytes
      (hd$0, 0, dst, pos,  /*<<bytes.ml:128:4>>*/ caml_ml_bytes_length(hd$0));
      /*<<bytes.ml:129:4>>*/  /*<<bytes.ml:129:4>>*/ caml_blit_bytes
      (sep, 0, dst, pos + caml_ml_bytes_length(hd$0) | 0, seplen);
     var
      pos$0 = (pos + caml_ml_bytes_length(hd$0) | 0) + seplen | 0,
      pos = pos$0,
      param$0 = tl$0;
    }
   }
   function cat(s1, s2){
     /*<<bytes.ml:140:2>>*/ var
     l1 = caml_ml_bytes_length(s1),
      /*<<bytes.ml:141:2>>*/ l2 =
        /*<<bytes.ml:141:2>>*/ caml_ml_bytes_length(s2),
      /*<<bytes.ml:142:10>>*/ r =
        /*<<bytes.ml:142:10>>*/ caml_create_bytes(l1 + l2 | 0);
     /*<<bytes.ml:143:2>>*/  /*<<bytes.ml:143:2>>*/ caml_blit_bytes
     (s1, 0, r, 0, l1);
     /*<<bytes.ml:144:2>>*/  /*<<bytes.ml:144:2>>*/ caml_blit_bytes
     (s2, 0, r, l1, l2);
     /*<<bytes.ml:144:2>>*/ return r;
    /*<<bytes.ml:145:3>>*/ }
   function is_space(param){
     /*<<bytes.ml:151:15>>*/  /*<<bytes.ml:151:15>>*/ var
     _af_ = param - 9 | 0;
    a:
    {
     if(4 < _af_ >>> 0){if(23 !== _af_) break a;} else if(2 === _af_) break a;
      /*<<bytes.ml:152:41>>*/ return 1;
    }
     /*<<bytes.ml:153:9>>*/ return 0;
    /*<<bytes.ml:153:14>>*/ }
   function trim(s){
     /*<<bytes.ml:156:2>>*/ var
     len = caml_ml_bytes_length(s),
      /*<<bytes.ml:157:10>>*/ i = [0, 0];
    for(;;){
     if(i[1] >= len) break;
      /*<<bytes.ml:158:20>>*/ if(! is_space(caml_bytes_unsafe_get(s, i[1])))
      break;
     i[1]++;
    }
     /*<<bytes.ml:161:10>>*/  /*<<bytes.ml:161:10>>*/ var
     j = [0, len - 1 | 0];
    for(;;){
      /*<<bytes.ml:162:20>>*/ if
      (i[1] <= j[1] && is_space(caml_bytes_unsafe_get(s, j[1]))){j[1] += -1; continue;}
     return i[1] <= j[1] ? sub(s, i[1], (j[1] - i[1] | 0) + 1 | 0) : empty;
    }
    /*<<bytes.ml:168:9>>*/ }
   function unsafe_escape(s){
     /*<<bytes.ml:184:2>>*/ var
      /*<<bytes.ml:184:10>>*/ n = [0, 0],
     ___ = caml_ml_bytes_length(s) - 1 | 0,
      /*<<bytes.ml:184:10>>*/ _Z_ = 0;
    if(___ >= 0){
     var i$0 = _Z_;
     for(;;){
      var match = caml_bytes_unsafe_get(s, i$0);
      a:
      {
       b:
       {
        c:
        {
         if(32 <= match){
          var _ac_ = match - 34 | 0;
          if(58 < _ac_ >>> 0){
           if(93 <= _ac_) break c;
          }
          else if(56 < _ac_ - 1 >>> 0) break b;
          var _ad_ = 1;
          break a;
         }
         if(11 <= match){
          if(13 === match) break b;
         }
         else if(8 <= match) break b;
        }
        var _ad_ = 4;
        break a;
       }
       var _ad_ = 2;
      }
      n[1] = n[1] + _ad_ | 0;
       /*<<bytes.ml:185:2>>*/  /*<<bytes.ml:185:2>>*/ var _ae_ = i$0 + 1 | 0;
      if(___ === i$0) break;
      var i$0 = _ae_;
     }
    }
    if(n[1] === caml_ml_bytes_length(s))  /*<<bytes.ml:192:24>>*/ return s;
     /*<<bytes.ml:194:13>>*/  /*<<bytes.ml:194:13>>*/ var
     s$0 =  /*<<bytes.ml:194:13>>*/ caml_create_bytes(n[1]);
    n[1] = 0;
     /*<<bytes.ml:196:4>>*/ var
     _aa_ = caml_ml_bytes_length(s) - 1 | 0,
      /*<<bytes.ml:196:4>>*/ _$_ = 0;
    if(_aa_ >= 0){
     var i = _$_;
     for(;;){
      var c = caml_bytes_unsafe_get(s, i);
      a:
      {
       b:
       {
        c:
        {
         if(35 <= c){
          if(92 !== c){if(127 <= c) break c; break b;}
         }
         else{
          if(32 > c){
           if(14 <= c) break c;
           switch(c){
             case 8:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 98);
              break a;
             case 9:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 116);
              break a;
             case 10:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 110);
              break a;
             case 13:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 114);
              break a;
             default: break c;
           }
          }
          if(34 > c) break b;
         }
         caml_bytes_unsafe_set(s$0, n[1], 92);
         n[1]++;
         caml_bytes_unsafe_set(s$0, n[1], c);
         break a;
        }
        caml_bytes_unsafe_set(s$0, n[1], 92);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + (c / 100 | 0) | 0);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + ((c / 10 | 0) % 10 | 0) | 0);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + (c % 10 | 0) | 0);
        break a;
       }
       caml_bytes_unsafe_set(s$0, n[1], c);
      }
      n[1]++;
       /*<<bytes.ml:196:4>>*/  /*<<bytes.ml:196:4>>*/ var _ab_ = i + 1 | 0;
      if(_aa_ === i) break;
      var i = _ab_;
     }
    }
     /*<<bytes.ml:221:4>>*/ return s$0;
    /*<<bytes.ml:222:5>>*/ }
   function escaped(b){
     /*<<bytes.ml:225:2>>*/  /*<<bytes.ml:225:10>>*/ var b$0 = copy(b);
     /*<<bytes.ml:228:2>>*/ return unsafe_escape(b$0);
    /*<<bytes.ml:228:17>>*/ }
   function map(f, s){
     /*<<bytes.ml:231:2>>*/ var l = caml_ml_bytes_length(s);
     /*<<bytes.ml:232:2>>*/ if(0 === l)  /*<<bytes.ml:232:16>>*/ return s;
     /*<<bytes.ml:233:12>>*/ var
      /*<<bytes.ml:233:12>>*/ r =
        /*<<bytes.ml:233:12>>*/ caml_create_bytes(l),
      /*<<bytes.ml:234:4>>*/ _X_ = l - 1 | 0,
      /*<<bytes.ml:233:12>>*/ _W_ = 0;
    if(_X_ >= 0){
     var i = _W_;
     for(;;){
      caml_bytes_unsafe_set
       (r,
        i,
         /*<<bytes.ml:234:41>>*/ caml_call1(f, caml_bytes_unsafe_get(s, i)));
       /*<<bytes.ml:234:4>>*/  /*<<bytes.ml:234:4>>*/ var _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
     /*<<bytes.ml:235:4>>*/ return r;
    /*<<bytes.ml:236:5>>*/ }
   function mapi(f, s){
     /*<<bytes.ml:239:2>>*/ var l = caml_ml_bytes_length(s);
     /*<<bytes.ml:240:2>>*/ if(0 === l)  /*<<bytes.ml:240:16>>*/ return s;
     /*<<bytes.ml:241:12>>*/ var
      /*<<bytes.ml:241:12>>*/ r =
        /*<<bytes.ml:241:12>>*/ caml_create_bytes(l),
      /*<<bytes.ml:242:4>>*/ _U_ = l - 1 | 0,
      /*<<bytes.ml:241:12>>*/ _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      caml_bytes_unsafe_set
       (r,
        i,
         /*<<bytes.ml:242:41>>*/ caml_call2(f, i, caml_bytes_unsafe_get(s, i)));
       /*<<bytes.ml:242:4>>*/  /*<<bytes.ml:242:4>>*/ var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
     /*<<bytes.ml:243:4>>*/ return r;
    /*<<bytes.ml:244:5>>*/ }
   function fold_left(f, x, a){
     /*<<bytes.ml:247:2>>*/ var
      /*<<bytes.ml:247:10>>*/ r = [0, x],
     _R_ = caml_ml_bytes_length(a) - 1 | 0,
      /*<<bytes.ml:247:10>>*/ _Q_ = 0;
    if(_R_ >= 0){
     var i = _Q_;
     for(;;){
      r[1] =
        /*<<bytes.ml:249:9>>*/ caml_call2
        (f, r[1], caml_bytes_unsafe_get(a, i));
       /*<<bytes.ml:248:2>>*/  /*<<bytes.ml:248:2>>*/ var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
    return r[1];
    /*<<bytes.ml:251:4>>*/ }
   function fold_right(f, a, x){
     /*<<bytes.ml:254:2>>*/ var
      /*<<bytes.ml:254:10>>*/ r = [0, x],
      /*<<bytes.ml:255:2>>*/ _O_ =
        /*<<bytes.ml:255:2>>*/ caml_ml_bytes_length(a) - 1 | 0;
    if(_O_ >= 0){
     var i = _O_;
     for(;;){
      r[1] =
        /*<<bytes.ml:256:9>>*/ caml_call2
        (f, caml_bytes_unsafe_get(a, i), r[1]);
       /*<<bytes.ml:255:2>>*/  /*<<bytes.ml:255:2>>*/ var _P_ = i - 1 | 0;
      if(0 === i) break;
      var i = _P_;
     }
    }
    return r[1];
    /*<<bytes.ml:258:4>>*/ }
   function exists(p, s){
     /*<<bytes.ml:261:2>>*/ var n = caml_ml_bytes_length(s), i = 0;
     /*<<bytes.ml:263:4>>*/ for(;;){
     if(i === n)  /*<<bytes.ml:263:18>>*/ return 0;
      /*<<bytes.ml:264:12>>*/ if
      ( /*<<bytes.ml:264:12>>*/ caml_call1(p, caml_bytes_unsafe_get(s, i)))
       /*<<bytes.ml:264:36>>*/ return 1;
      /*<<bytes.ml:265:9>>*/ var
       /*<<bytes.ml:265:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<bytes.ml:266:8>>*/ }
   function for_all(p, s){
     /*<<bytes.ml:269:2>>*/ var n = caml_ml_bytes_length(s), i = 0;
     /*<<bytes.ml:271:4>>*/ for(;;){
     if(i === n)  /*<<bytes.ml:271:18>>*/ return 1;
      /*<<bytes.ml:272:12>>*/ if
      (!  /*<<bytes.ml:272:12>>*/ caml_call1(p, caml_bytes_unsafe_get(s, i)))
       /*<<bytes.ml:273:9>>*/ return 0;
      /*<<bytes.ml:272:36>>*/ var
       /*<<bytes.ml:272:36>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<bytes.ml:274:8>>*/ }
   function uppercase_ascii(s){
     /*<<bytes.ml:276:24>>*/ return map(Stdlib_Char[4], s);
    /*<<bytes.ml:276:50>>*/ }
   function lowercase_ascii(s){
     /*<<bytes.ml:277:24>>*/ return map(Stdlib_Char[3], s);
    /*<<bytes.ml:277:50>>*/ }
   function apply1(f, s){
     /*<<bytes.ml:280:2>>*/ if(0 === caml_ml_bytes_length(s))
      /*<<bytes.ml:280:23>>*/ return s;
     /*<<bytes.ml:281:12>>*/  /*<<bytes.ml:281:12>>*/ var r = copy(s);
    caml_bytes_unsafe_set
     (r,
      0,
       /*<<bytes.ml:282:19>>*/ caml_call1(f, caml_bytes_unsafe_get(s, 0)));
     /*<<bytes.ml:283:4>>*/ return r;
    /*<<bytes.ml:284:5>>*/ }
   function capitalize_ascii(s){
     /*<<bytes.ml:286:25>>*/ return apply1(Stdlib_Char[4], s);
    /*<<bytes.ml:286:54>>*/ }
   function uncapitalize_ascii(s){
     /*<<bytes.ml:287:27>>*/ return apply1(Stdlib_Char[3], s);
    /*<<bytes.ml:287:56>>*/ }
   function starts_with(prefix, s){
     /*<<bytes.ml:291:2>>*/ var
     len_s = caml_ml_bytes_length(s),
     len_pre = caml_ml_bytes_length(prefix),
     _N_ = len_pre <= len_s ? 1 : 0;
    if(! _N_) return _N_;
    var i = 0;
     /*<<bytes.ml:294:4>>*/ for(;;){
     if(i === len_pre)  /*<<bytes.ml:294:24>>*/ return 1;
     if(caml_bytes_unsafe_get(s, i) !== caml_bytes_unsafe_get(prefix, i))
       /*<<bytes.ml:295:55>>*/ return 0;
      /*<<bytes.ml:296:9>>*/ var
       /*<<bytes.ml:296:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<bytes.ml:297:30>>*/ }
   function ends_with(suffix, s){
     /*<<bytes.ml:301:2>>*/ var
     len_s = caml_ml_bytes_length(s),
     len_suf = caml_ml_bytes_length(suffix),
     diff = len_s - len_suf | 0,
     _M_ = 0 <= diff ? 1 : 0;
    if(! _M_) return _M_;
    var i = 0;
     /*<<bytes.ml:305:4>>*/ for(;;){
     if(i === len_suf)  /*<<bytes.ml:305:24>>*/ return 1;
     if
      (caml_bytes_unsafe_get(s, diff + i | 0)
       !== caml_bytes_unsafe_get(suffix, i))
       /*<<bytes.ml:306:64>>*/ return 0;
      /*<<bytes.ml:307:9>>*/ var
       /*<<bytes.ml:307:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<bytes.ml:308:23>>*/ }
   function index_rec(s, lim, i, c){
     /*<<bytes.ml:312:2>>*/ var i$0 = i;
     /*<<bytes.ml:312:2>>*/ for(;;){
     if(lim <= i$0)
       /*<<bytes.ml:312:19>>*/ throw  /*<<bytes.ml:312:19>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     if(caml_bytes_unsafe_get(s, i$0) === c)
       /*<<bytes.ml:313:29>>*/ return i$0;
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
    /*<<bytes.ml:313:61>>*/ }
   function index(s, c){
     /*<<bytes.ml:316:16>>*/ return index_rec
            (s, caml_ml_bytes_length(s), 0, c);
    /*<<bytes.ml:316:42>>*/ }
   function index_rec_opt(s, lim, i, c){
     /*<<bytes.ml:320:2>>*/ var i$0 = i;
     /*<<bytes.ml:320:2>>*/ for(;;){
     if(lim <= i$0)  /*<<bytes.ml:320:19>>*/ return 0;
     if(caml_bytes_unsafe_get(s, i$0) === c)
       /*<<bytes.ml:321:29>>*/ return [0, i$0];
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
    /*<<bytes.ml:321:70>>*/ }
   function index_opt(s, c){
     /*<<bytes.ml:324:20>>*/ return index_rec_opt
            (s, caml_ml_bytes_length(s), 0, c);
    /*<<bytes.ml:324:50>>*/ }
   function index_from(s, i, c){
     /*<<bytes.ml:328:2>>*/ var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i)  /*<<bytes.ml:330:2>>*/ return index_rec(s, l, i, c);
     /*<<bytes.ml:329:25>>*/ return  /*<<bytes.ml:329:25>>*/ caml_call1
            (Stdlib[1], cst_String_index_from_Bytes_in);
    /*<<bytes.ml:330:19>>*/ }
   function index_from_opt(s, i, c){
     /*<<bytes.ml:334:2>>*/ var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i)
      /*<<bytes.ml:338:4>>*/ return index_rec_opt(s, l, i, c);
     /*<<bytes.ml:336:4>>*/ return  /*<<bytes.ml:336:4>>*/ caml_call1
            (Stdlib[1], cst_String_index_from_opt_Byte);
    /*<<bytes.ml:338:25>>*/ }
   function rindex_rec(s, i, c){
     /*<<bytes.ml:342:2>>*/ var i$0 = i;
     /*<<bytes.ml:342:2>>*/ for(;;){
     if(0 > i$0)
       /*<<bytes.ml:342:16>>*/ throw  /*<<bytes.ml:342:16>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     if(caml_bytes_unsafe_get(s, i$0) === c)
       /*<<bytes.ml:343:29>>*/ return i$0;
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
    /*<<bytes.ml:343:58>>*/ }
   function rindex(s, c){
     /*<<bytes.ml:346:17>>*/ return rindex_rec
            (s, caml_ml_bytes_length(s) - 1 | 0, c);
    /*<<bytes.ml:346:46>>*/ }
   function rindex_from(s, i, c){
     /*<<bytes.ml:350:2>>*/ if(-1 <= i && caml_ml_bytes_length(s) > i)
      /*<<bytes.ml:353:4>>*/ return rindex_rec(s, i, c);
     /*<<bytes.ml:351:4>>*/ return  /*<<bytes.ml:351:4>>*/ caml_call1
            (Stdlib[1], cst_String_rindex_from_Bytes_r);
    /*<<bytes.ml:353:20>>*/ }
   function rindex_rec_opt(s, i, c){
     /*<<bytes.ml:357:2>>*/ var i$0 = i;
     /*<<bytes.ml:357:2>>*/ for(;;){
     if(0 > i$0)  /*<<bytes.ml:357:16>>*/ return 0;
     if(caml_bytes_unsafe_get(s, i$0) === c)
       /*<<bytes.ml:358:29>>*/ return [0, i$0];
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
    /*<<bytes.ml:358:67>>*/ }
   function rindex_opt(s, c){
     /*<<bytes.ml:361:21>>*/ return rindex_rec_opt
            (s, caml_ml_bytes_length(s) - 1 | 0, c);
    /*<<bytes.ml:361:54>>*/ }
   function rindex_from_opt(s, i, c){
     /*<<bytes.ml:365:2>>*/ if(-1 <= i && caml_ml_bytes_length(s) > i)
      /*<<bytes.ml:368:4>>*/ return rindex_rec_opt(s, i, c);
     /*<<bytes.ml:366:4>>*/ return  /*<<bytes.ml:366:4>>*/ caml_call1
            (Stdlib[1], cst_String_rindex_from_opt_Byt);
    /*<<bytes.ml:368:24>>*/ }
   function contains_from(s, i, c){
     /*<<bytes.ml:373:2>>*/ var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i)
      /*<<bytes.ml:377:4>>*/ try{
       /*<<bytes.ml:377:15>>*/ index_rec(s, l, i, c);
       /*<<bytes.ml:377:36>>*/  /*<<bytes.ml:377:36>>*/ var _K_ = 1;
       /*<<bytes.ml:377:36>>*/ return _K_;
     }
     catch(_L_){
      var _J_ = caml_wrap_exception(_L_);
      if(_J_ === Stdlib[8])  /*<<bytes.ml:377:59>>*/ return 0;
      throw caml_maybe_attach_backtrace(_J_, 0);
     }
     /*<<bytes.ml:375:4>>*/ return  /*<<bytes.ml:375:4>>*/ caml_call1
            (Stdlib[1], cst_String_contains_from_Bytes);
    /*<<bytes.ml:377:64>>*/ }
   function contains(s, c){
     /*<<bytes.ml:381:19>>*/ return contains_from(s, 0, c);
    /*<<bytes.ml:381:38>>*/ }
   function rcontains_from(s, i, c){
     /*<<bytes.ml:385:2>>*/ if(0 <= i && caml_ml_bytes_length(s) > i)
      /*<<bytes.ml:388:4>>*/ try{
       /*<<bytes.ml:388:15>>*/ rindex_rec(s, i, c);
       /*<<bytes.ml:388:35>>*/  /*<<bytes.ml:388:35>>*/ var _H_ = 1;
       /*<<bytes.ml:388:35>>*/ return _H_;
     }
     catch(_I_){
      var _G_ = caml_wrap_exception(_I_);
      if(_G_ === Stdlib[8])  /*<<bytes.ml:388:58>>*/ return 0;
      throw caml_maybe_attach_backtrace(_G_, 0);
     }
     /*<<bytes.ml:386:4>>*/ return  /*<<bytes.ml:386:4>>*/ caml_call1
            (Stdlib[1], cst_String_rcontains_from_Byte);
    /*<<bytes.ml:388:63>>*/ }
   var
    compare = runtime.caml_bytes_compare,
    cst_Bytes_of_seq_cannot_grow_b = "Bytes.of_seq: cannot grow bytes";
   function split_on_char(sep, s){
     /*<<bytes.ml:398:2>>*/ var
      /*<<bytes.ml:398:10>>*/ r = [0, 0],
      /*<<bytes.ml:399:10>>*/ j =
       [0,  /*<<bytes.ml:399:2>>*/ caml_ml_bytes_length(s)],
      /*<<bytes.ml:400:2>>*/ _C_ =
        /*<<bytes.ml:400:2>>*/ caml_ml_bytes_length(s) - 1 | 0;
    if(_C_ >= 0){
     var i = _C_;
     for(;;){
      if(caml_bytes_unsafe_get(s, i) === sep){
       var _E_ = r[1];
       r[1] = [0, sub(s, i + 1 | 0, (j[1] - i | 0) - 1 | 0), _E_];
       j[1] = i;
      }
       /*<<bytes.ml:400:2>>*/  /*<<bytes.ml:400:2>>*/ var _F_ = i - 1 | 0;
      if(0 === i) break;
      var i = _F_;
     }
    }
    var _D_ = r[1];
     /*<<bytes.ml:406:2>>*/ return [0, sub(s, 0, j[1]), _D_];
    /*<<bytes.ml:406:18>>*/ }
   function to_seq(s){
    function aux(i, param){
      /*<<bytes.ml:412:4>>*/ if(i === caml_ml_bytes_length(s))
       /*<<bytes.ml:412:25>>*/ return 0;
      /*<<bytes.ml:414:14>>*/ var
       /*<<bytes.ml:414:14>>*/ x =
         /*<<bytes.ml:414:14>>*/ caml_bytes_get(s, i),
       /*<<bytes.ml:414:14>>*/ _A_ = i + 1 | 0;
      /*<<bytes.ml:415:6>>*/ return [0,
             x,
             function(_B_){ /*<<?>>*/ return aux(_A_, _B_);}];
     /*<<bytes.ml:415:29>>*/ }
     /*<<bytes.ml:417:2>>*/ var _y_ = 0;
     /*<<bytes.ml:417:2>>*/ return function(_z_){
      /*<<?>>*/ return aux(_y_, _z_);};
    /*<<bytes.ml:417:7>>*/ }
   function to_seqi(s){
    function aux(i, param){
      /*<<bytes.ml:421:4>>*/ if(i === caml_ml_bytes_length(s))
       /*<<bytes.ml:421:25>>*/ return 0;
      /*<<bytes.ml:423:14>>*/ var
       /*<<bytes.ml:423:14>>*/ x =
         /*<<bytes.ml:423:14>>*/ caml_bytes_get(s, i),
       /*<<bytes.ml:423:14>>*/ _w_ = i + 1 | 0;
      /*<<bytes.ml:424:6>>*/ return [0,
             [0, i, x],
             function(_x_){ /*<<?>>*/ return aux(_w_, _x_);}];
     /*<<bytes.ml:424:33>>*/ }
     /*<<bytes.ml:426:2>>*/ var _u_ = 0;
     /*<<bytes.ml:426:2>>*/ return function(_v_){
      /*<<?>>*/ return aux(_u_, _v_);};
    /*<<bytes.ml:426:7>>*/ }
   function of_seq(i){
     /*<<bytes.ml:429:2>>*/ var
      /*<<bytes.ml:429:10>>*/ n = [0, 0],
      /*<<bytes.ml:430:12>>*/ buf = [0, make(256, 0)];
     /*<<bytes.ml:439:2>>*/  /*<<bytes.ml:439:2>>*/ caml_call2
     (Stdlib_Seq[4],
      function(c){
        /*<<bytes.ml:441:7>>*/ if(n[1] === caml_ml_bytes_length(buf[1])){
         /*<<bytes.ml:433:18>>*/  /*<<bytes.ml:433:18>>*/ var
         new_len =
            /*<<bytes.ml:433:18>>*/ caml_call2
            (Stdlib_Int[10],
             2 * caml_ml_bytes_length(buf[1]) | 0,
             Stdlib_Sys[12]);
        if(caml_ml_bytes_length(buf[1]) === new_len)
          /*<<bytes.ml:434:34>>*/  /*<<bytes.ml:434:34>>*/ caml_call1
          (Stdlib[2], cst_Bytes_of_seq_cannot_grow_b);
         /*<<bytes.ml:435:18>>*/  /*<<bytes.ml:435:18>>*/ var
         new_buf = make(new_len, 0);
         /*<<bytes.ml:436:4>>*/ blit(buf[1], 0, new_buf, 0, n[1]);
        buf[1] = new_buf;
       }
        /*<<bytes.ml:442:7>>*/  /*<<bytes.ml:442:7>>*/ caml_bytes_set
        (buf[1], n[1], c);
       n[1]++;
       return 0;
       /*<<bytes.ml:443:13>>*/ },
      i);
    return sub(buf[1], 0, n[1]);
    /*<<bytes.ml:445:15>>*/ }
   function unsafe_get_uint16_le(b, i){
     /*<<bytes.ml:470:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:471:14>>*/ caml_bswap16
              ( /*<<bytes.ml:471:14>>*/ caml_bytes_get16(b, i))
            :  /*<<bytes.ml:472:7>>*/ caml_bytes_get16(b, i);
    /*<<bytes.ml:472:31>>*/ }
   function unsafe_get_uint16_be(b, i){
     /*<<bytes.ml:475:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:476:7>>*/ caml_bytes_get16(b, i)
            :  /*<<bytes.ml:477:14>>*/ caml_bswap16
              ( /*<<bytes.ml:477:14>>*/ caml_bytes_get16(b, i));
    /*<<bytes.ml:477:40>>*/ }
   function get_int8(b, i){
     /*<<bytes.ml:480:2>>*/ var
      /*<<bytes.ml:480:2>>*/ _s_ = Stdlib_Sys[10] - 8 | 0,
     _t_ = Stdlib_Sys[10] - 8 | 0;
    return  /*<<bytes.ml:480:3>>*/ caml_bytes_get(b, i) << _t_ >> _s_;
    /*<<bytes.ml:480:65>>*/ }
   function get_uint16_le(b, i){
     /*<<bytes.ml:483:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:483:32>>*/ caml_bswap16
              ( /*<<bytes.ml:483:32>>*/ caml_bytes_get16(b, i))
            :  /*<<bytes.ml:484:7>>*/ caml_bytes_get16(b, i);
    /*<<bytes.ml:484:24>>*/ }
   function get_uint16_be(b, i){
     /*<<bytes.ml:487:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:488:7>>*/ caml_bytes_get16(b, i)
            :  /*<<bytes.ml:487:36>>*/ caml_bswap16
              ( /*<<bytes.ml:487:36>>*/ caml_bytes_get16(b, i));
    /*<<bytes.ml:488:24>>*/ }
   function get_int16_ne(b, i){
     /*<<bytes.ml:491:2>>*/ var
      /*<<bytes.ml:491:2>>*/ _q_ = Stdlib_Sys[10] - 16 | 0,
     _r_ = Stdlib_Sys[10] - 16 | 0;
    return  /*<<bytes.ml:491:3>>*/ caml_bytes_get16(b, i) << _r_ >> _q_;
    /*<<bytes.ml:491:71>>*/ }
   function get_int16_le(b, i){
     /*<<bytes.ml:494:2>>*/ var
      /*<<bytes.ml:494:2>>*/ _o_ = Stdlib_Sys[10] - 16 | 0,
     _p_ = Stdlib_Sys[10] - 16 | 0;
    return get_uint16_le(b, i) << _p_ >> _o_;
    /*<<bytes.ml:494:71>>*/ }
   function get_int16_be(b, i){
     /*<<bytes.ml:497:2>>*/ var
      /*<<bytes.ml:497:2>>*/ _m_ = Stdlib_Sys[10] - 16 | 0,
     _n_ = Stdlib_Sys[10] - 16 | 0;
    return get_uint16_be(b, i) << _n_ >> _m_;
    /*<<bytes.ml:497:71>>*/ }
   function get_int32_le(b, i){
     /*<<bytes.ml:500:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:500:25>>*/ caml_int32_bswap
              ( /*<<bytes.ml:500:32>>*/ caml_bytes_get32(b, i))
            :  /*<<bytes.ml:501:7>>*/ caml_bytes_get32(b, i);
    /*<<bytes.ml:501:23>>*/ }
   function get_int32_be(b, i){
     /*<<bytes.ml:504:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:505:7>>*/ caml_bytes_get32(b, i)
            :  /*<<bytes.ml:504:29>>*/ caml_int32_bswap
              ( /*<<bytes.ml:504:36>>*/ caml_bytes_get32(b, i));
    /*<<bytes.ml:505:23>>*/ }
   function get_int64_le(b, i){
     /*<<bytes.ml:508:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:508:25>>*/ caml_int64_bswap
              ( /*<<bytes.ml:508:32>>*/ caml_bytes_get64(b, i))
            :  /*<<bytes.ml:509:7>>*/ caml_bytes_get64(b, i);
    /*<<bytes.ml:509:23>>*/ }
   function get_int64_be(b, i){
     /*<<bytes.ml:512:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:513:7>>*/ caml_bytes_get64(b, i)
            :  /*<<bytes.ml:512:29>>*/ caml_int64_bswap
              ( /*<<bytes.ml:512:36>>*/ caml_bytes_get64(b, i));
    /*<<bytes.ml:513:23>>*/ }
   function unsafe_set_uint16_le(b, i, x){
     /*<<bytes.ml:516:2>>*/ if(Stdlib_Sys[11]){
      /*<<bytes.ml:517:7>>*/  /*<<bytes.ml:517:7>>*/ caml_bytes_set16
      (b, i, caml_bswap16(x));
      /*<<bytes.ml:517:7>>*/ return;
    }
     /*<<bytes.ml:518:7>>*/  /*<<bytes.ml:518:7>>*/ caml_bytes_set16(b, i, x);
     /*<<bytes.ml:518:7>>*/ return;
    /*<<bytes.ml:518:33>>*/ }
   function unsafe_set_uint16_be(b, i, x){
     /*<<bytes.ml:521:2>>*/ if(Stdlib_Sys[11]){
      /*<<bytes.ml:522:7>>*/  /*<<bytes.ml:522:7>>*/ caml_bytes_set16(b, i, x);
      /*<<bytes.ml:522:7>>*/ return;
    }
     /*<<bytes.ml:523:2>>*/  /*<<bytes.ml:523:2>>*/ caml_bytes_set16
     (b, i, caml_bswap16(x));
     /*<<bytes.ml:523:2>>*/ return;
    /*<<bytes.ml:523:37>>*/ }
   function set_int16_le(b, i, x){
     /*<<bytes.ml:526:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:526:25>>*/ caml_bytes_set16(b, i, caml_bswap16(x))
            :  /*<<bytes.ml:527:7>>*/ caml_bytes_set16(b, i, x);
    /*<<bytes.ml:527:25>>*/ }
   function set_int16_be(b, i, x){
     /*<<bytes.ml:530:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:531:7>>*/ caml_bytes_set16(b, i, x)
            :  /*<<bytes.ml:530:29>>*/ caml_bytes_set16(b, i, caml_bswap16(x));
    /*<<bytes.ml:531:25>>*/ }
   function set_int32_le(b, i, x){
     /*<<bytes.ml:534:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:534:25>>*/ caml_bytes_set32
              (b, i,  /*<<bytes.ml:534:42>>*/ caml_int32_bswap(x))
            :  /*<<bytes.ml:535:7>>*/ caml_bytes_set32(b, i, x);
    /*<<bytes.ml:535:25>>*/ }
   function set_int32_be(b, i, x){
     /*<<bytes.ml:538:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:539:7>>*/ caml_bytes_set32(b, i, x)
            :  /*<<bytes.ml:538:29>>*/ caml_bytes_set32
              (b, i,  /*<<bytes.ml:538:46>>*/ caml_int32_bswap(x));
    /*<<bytes.ml:539:25>>*/ }
   function set_int64_le(b, i, x){
     /*<<bytes.ml:542:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:542:25>>*/ caml_bytes_set64
              (b, i,  /*<<bytes.ml:542:42>>*/ caml_int64_bswap(x))
            :  /*<<bytes.ml:543:7>>*/ caml_bytes_set64(b, i, x);
    /*<<bytes.ml:543:25>>*/ }
   function set_int64_be(b, i, x){
     /*<<bytes.ml:546:2>>*/ return Stdlib_Sys[11]
            ?  /*<<bytes.ml:547:7>>*/ caml_bytes_set64(b, i, x)
            :  /*<<bytes.ml:546:29>>*/ caml_bytes_set64
              (b, i,  /*<<bytes.ml:546:46>>*/ caml_int64_bswap(x));
    /*<<bytes.ml:547:25>>*/ }
   var
    set_uint8 = caml_bytes_set,
    set_uint16_ne = caml_bytes_set16,
    dec_invalid = Stdlib_Uchar[22],
    _a_ = [0, cst_bytes_ml, 679, 9],
    _b_ = [0, cst_bytes_ml, 654, 20],
    cst_index_out_of_bounds = cst_index_out_of_bounds$3,
    cst_index_out_of_bounds$0 = cst_index_out_of_bounds$3,
    _c_ = [0, cst_bytes_ml, 777, 9],
    _d_ = [0, cst_bytes_ml, 766, 20],
    cst_index_out_of_bounds$1 = cst_index_out_of_bounds$3,
    cst_index_out_of_bounds$2 = cst_index_out_of_bounds$3,
    _e_ = [0, cst_bytes_ml, 831, 9],
    _f_ = [0, cst_bytes_ml, 820, 20];
   function dec_ret(n, u){
     /*<<bytes.ml:557:27>>*/  /*<<bytes.ml:557:46>>*/ var
     _l_ =  /*<<bytes.ml:557:46>>*/ caml_call1(Stdlib_Uchar[9], u);
     /*<<bytes.ml:557:46>>*/ return  /*<<bytes.ml:557:46>>*/ caml_call2
            (Stdlib_Uchar[21], n, _l_);
    /*<<bytes.ml:557:69>>*/ }
   function not_in_x80_to_xBF(b){
     /*<<bytes.ml:575:35>>*/ return 2 !== (b >>> 6 | 0) ? 1 : 0;
    /*<<bytes.ml:575:50>>*/ }
   function not_in_xA0_to_xBF(b){
     /*<<bytes.ml:576:35>>*/ return 5 !== (b >>> 5 | 0) ? 1 : 0;
    /*<<bytes.ml:576:51>>*/ }
   function not_in_x80_to_x9F(b){
     /*<<bytes.ml:577:35>>*/ return 4 !== (b >>> 5 | 0) ? 1 : 0;
    /*<<bytes.ml:577:51>>*/ }
   function not_in_x90_to_xBF(b){
     /*<<bytes.ml:578:35>>*/ var
     _j_ = b < 144 ? 1 : 0,
     _k_ = _j_ || (191 < b ? 1 : 0);
    return _k_;
    /*<<bytes.ml:578:55>>*/ }
   function not_in_x80_to_x8F(b){
     /*<<bytes.ml:579:35>>*/ return 8 !== (b >>> 4 | 0) ? 1 : 0;
    /*<<bytes.ml:579:49>>*/ }
   function utf_8_uchar_3(b0, b1, b2){
     /*<<bytes.ml:586:2>>*/ return (b0 & 15) << 12 | (b1 & 63) << 6 | b2 & 63;
    /*<<bytes.ml:588:18>>*/ }
   function utf_8_uchar_4(b0, b1, b2, b3){
     /*<<bytes.ml:591:2>>*/ return (b0 & 7) << 18 | (b1 & 63) << 12
           | (b2 & 63) << 6
           | b3 & 63;
    /*<<bytes.ml:594:18>>*/ }
   function get_utf_8_uchar(b, i){
     /*<<bytes.ml:597:2>>*/ var
      /*<<bytes.ml:597:11>>*/ b0 =
        /*<<bytes.ml:597:11>>*/ caml_bytes_get(b, i),
      /*<<bytes.ml:599:2>>*/ max =
        /*<<bytes.ml:599:2>>*/ caml_ml_bytes_length(b) - 1 | 0;
    a:
    {
      /*<<bytes.ml:600:2>>*/ if(224 <= b0){
      if(237 <= b0){
       if(245 <= b0) break a;
       switch(b0 - 237 | 0){
         case 0:
           /*<<bytes.ml:619:6>>*/  /*<<bytes.ml:619:6>>*/ var i$0 = i + 1 | 0;
          if(max < i$0)
            /*<<bytes.ml:619:39>>*/ return  /*<<bytes.ml:619:39>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:620:15>>*/  /*<<bytes.ml:620:15>>*/ var
           b1 =  /*<<bytes.ml:620:15>>*/ caml_bytes_unsafe_get(b, i$0);
           /*<<bytes.ml:620:29>>*/ if(not_in_x80_to_x9F(b1))
            /*<<bytes.ml:620:55>>*/ return  /*<<bytes.ml:620:55>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:621:6>>*/  /*<<bytes.ml:621:6>>*/ var
           i$1 = i$0 + 1 | 0;
          if(max < i$1)
            /*<<bytes.ml:621:39>>*/ return  /*<<bytes.ml:621:39>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:622:15>>*/  /*<<bytes.ml:622:15>>*/ var
           b2 =  /*<<bytes.ml:622:15>>*/ caml_bytes_unsafe_get(b, i$1);
           /*<<bytes.ml:622:29>>*/ return not_in_x80_to_xBF(b2)
                  ?  /*<<bytes.ml:622:55>>*/ caml_call1(dec_invalid, 2)
                  : dec_ret(3, utf_8_uchar_3(b0, b1, b2));
         case 3:
           /*<<bytes.ml:625:6>>*/  /*<<bytes.ml:625:6>>*/ var i$4 = i + 1 | 0;
          if(max < i$4)
            /*<<bytes.ml:625:39>>*/ return  /*<<bytes.ml:625:39>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:626:15>>*/  /*<<bytes.ml:626:15>>*/ var
           b1$1 =  /*<<bytes.ml:626:15>>*/ caml_bytes_unsafe_get(b, i$4);
           /*<<bytes.ml:626:29>>*/ if(not_in_x90_to_xBF(b1$1))
            /*<<bytes.ml:626:55>>*/ return  /*<<bytes.ml:626:55>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:627:6>>*/  /*<<bytes.ml:627:6>>*/ var
           i$5 = i$4 + 1 | 0;
          if(max < i$5)
            /*<<bytes.ml:627:39>>*/ return  /*<<bytes.ml:627:39>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:628:15>>*/  /*<<bytes.ml:628:15>>*/ var
           b2$1 =  /*<<bytes.ml:628:15>>*/ caml_bytes_unsafe_get(b, i$5);
           /*<<bytes.ml:628:29>>*/ if(not_in_x80_to_xBF(b2$1))
            /*<<bytes.ml:628:55>>*/ return  /*<<bytes.ml:628:55>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:629:6>>*/  /*<<bytes.ml:629:6>>*/ var
           i$6 = i$5 + 1 | 0;
          if(max < i$6)
            /*<<bytes.ml:629:39>>*/ return  /*<<bytes.ml:629:39>>*/ caml_call1
                   (dec_invalid, 3);
           /*<<bytes.ml:630:15>>*/  /*<<bytes.ml:630:15>>*/ var
           b3 =  /*<<bytes.ml:630:15>>*/ caml_bytes_unsafe_get(b, i$6);
           /*<<bytes.ml:630:29>>*/ return not_in_x80_to_xBF(b3)
                  ?  /*<<bytes.ml:630:55>>*/ caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$1, b2$1, b3));
         case 7:
           /*<<bytes.ml:641:6>>*/  /*<<bytes.ml:641:6>>*/ var
           i$10 = i + 1 | 0;
          if(max < i$10)
            /*<<bytes.ml:641:39>>*/ return  /*<<bytes.ml:641:39>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:642:15>>*/  /*<<bytes.ml:642:15>>*/ var
           b1$3 =  /*<<bytes.ml:642:15>>*/ caml_bytes_unsafe_get(b, i$10);
           /*<<bytes.ml:642:29>>*/ if(not_in_x80_to_x8F(b1$3))
            /*<<bytes.ml:642:55>>*/ return  /*<<bytes.ml:642:55>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:643:6>>*/  /*<<bytes.ml:643:6>>*/ var
           i$11 = i$10 + 1 | 0;
          if(max < i$11)
            /*<<bytes.ml:643:39>>*/ return  /*<<bytes.ml:643:39>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:644:15>>*/  /*<<bytes.ml:644:15>>*/ var
           b2$3 =  /*<<bytes.ml:644:15>>*/ caml_bytes_unsafe_get(b, i$11);
           /*<<bytes.ml:644:29>>*/ if(not_in_x80_to_xBF(b2$3))
            /*<<bytes.ml:644:55>>*/ return  /*<<bytes.ml:644:55>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:645:6>>*/  /*<<bytes.ml:645:6>>*/ var
           i$12 = i$11 + 1 | 0;
          if(max < i$12)
            /*<<bytes.ml:645:39>>*/ return  /*<<bytes.ml:645:39>>*/ caml_call1
                   (dec_invalid, 3);
           /*<<bytes.ml:646:15>>*/  /*<<bytes.ml:646:15>>*/ var
           b3$1 =  /*<<bytes.ml:646:15>>*/ caml_bytes_unsafe_get(b, i$12);
           /*<<bytes.ml:646:29>>*/ return not_in_x80_to_xBF(b3$1)
                  ?  /*<<bytes.ml:646:55>>*/ caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$3, b2$3, b3$1));
         case 1:
         case 2: break;
         default:
           /*<<bytes.ml:633:6>>*/  /*<<bytes.ml:633:6>>*/ var i$7 = i + 1 | 0;
          if(max < i$7)
            /*<<bytes.ml:633:39>>*/ return  /*<<bytes.ml:633:39>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:634:15>>*/  /*<<bytes.ml:634:15>>*/ var
           b1$2 =  /*<<bytes.ml:634:15>>*/ caml_bytes_unsafe_get(b, i$7);
           /*<<bytes.ml:634:29>>*/ if(not_in_x80_to_xBF(b1$2))
            /*<<bytes.ml:634:55>>*/ return  /*<<bytes.ml:634:55>>*/ caml_call1
                   (dec_invalid, 1);
           /*<<bytes.ml:635:6>>*/  /*<<bytes.ml:635:6>>*/ var
           i$8 = i$7 + 1 | 0;
          if(max < i$8)
            /*<<bytes.ml:635:39>>*/ return  /*<<bytes.ml:635:39>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:636:15>>*/  /*<<bytes.ml:636:15>>*/ var
           b2$2 =  /*<<bytes.ml:636:15>>*/ caml_bytes_unsafe_get(b, i$8);
           /*<<bytes.ml:636:29>>*/ if(not_in_x80_to_xBF(b2$2))
            /*<<bytes.ml:636:55>>*/ return  /*<<bytes.ml:636:55>>*/ caml_call1
                   (dec_invalid, 2);
           /*<<bytes.ml:637:6>>*/  /*<<bytes.ml:637:6>>*/ var
           i$9 = i$8 + 1 | 0;
          if(max < i$9)
            /*<<bytes.ml:637:39>>*/ return  /*<<bytes.ml:637:39>>*/ caml_call1
                   (dec_invalid, 3);
           /*<<bytes.ml:638:15>>*/  /*<<bytes.ml:638:15>>*/ var
           b3$0 =  /*<<bytes.ml:638:15>>*/ caml_bytes_unsafe_get(b, i$9);
           /*<<bytes.ml:638:29>>*/ return not_in_x80_to_xBF(b3$0)
                  ?  /*<<bytes.ml:638:55>>*/ caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$2, b2$2, b3$0));
       }
      }
      else if(225 > b0){
        /*<<bytes.ml:607:6>>*/  /*<<bytes.ml:607:6>>*/ var i$13 = i + 1 | 0;
       if(max < i$13)
         /*<<bytes.ml:607:39>>*/ return  /*<<bytes.ml:607:39>>*/ caml_call1
                (dec_invalid, 1);
        /*<<bytes.ml:608:15>>*/  /*<<bytes.ml:608:15>>*/ var
        b1$4 =  /*<<bytes.ml:608:15>>*/ caml_bytes_unsafe_get(b, i$13);
        /*<<bytes.ml:608:29>>*/ if(not_in_xA0_to_xBF(b1$4))
         /*<<bytes.ml:608:55>>*/ return  /*<<bytes.ml:608:55>>*/ caml_call1
                (dec_invalid, 1);
        /*<<bytes.ml:609:6>>*/  /*<<bytes.ml:609:6>>*/ var
        i$14 = i$13 + 1 | 0;
       if(max < i$14)
         /*<<bytes.ml:609:39>>*/ return  /*<<bytes.ml:609:39>>*/ caml_call1
                (dec_invalid, 2);
        /*<<bytes.ml:610:15>>*/  /*<<bytes.ml:610:15>>*/ var
        b2$4 =  /*<<bytes.ml:610:15>>*/ caml_bytes_unsafe_get(b, i$14);
        /*<<bytes.ml:610:29>>*/ return not_in_x80_to_xBF(b2$4)
               ?  /*<<bytes.ml:610:55>>*/ caml_call1(dec_invalid, 2)
               : dec_ret(3, utf_8_uchar_3(b0, b1$4, b2$4));
      }
       /*<<bytes.ml:613:6>>*/  /*<<bytes.ml:613:6>>*/ var i$2 = i + 1 | 0;
      if(max < i$2)
        /*<<bytes.ml:613:39>>*/ return  /*<<bytes.ml:613:39>>*/ caml_call1
               (dec_invalid, 1);
       /*<<bytes.ml:614:15>>*/  /*<<bytes.ml:614:15>>*/ var
       b1$0 =  /*<<bytes.ml:614:15>>*/ caml_bytes_unsafe_get(b, i$2);
       /*<<bytes.ml:614:29>>*/ if(not_in_x80_to_xBF(b1$0))
        /*<<bytes.ml:614:55>>*/ return  /*<<bytes.ml:614:55>>*/ caml_call1
               (dec_invalid, 1);
       /*<<bytes.ml:615:6>>*/  /*<<bytes.ml:615:6>>*/ var i$3 = i$2 + 1 | 0;
      if(max < i$3)
        /*<<bytes.ml:615:39>>*/ return  /*<<bytes.ml:615:39>>*/ caml_call1
               (dec_invalid, 2);
       /*<<bytes.ml:616:15>>*/  /*<<bytes.ml:616:15>>*/ var
       b2$0 =  /*<<bytes.ml:616:15>>*/ caml_bytes_unsafe_get(b, i$3);
       /*<<bytes.ml:616:29>>*/ return not_in_x80_to_xBF(b2$0)
              ?  /*<<bytes.ml:616:55>>*/ caml_call1(dec_invalid, 2)
              : dec_ret(3, utf_8_uchar_3(b0, b1$0, b2$0));
     }
     if(128 > b0)  /*<<bytes.ml:601:24>>*/ return dec_ret(1, b0);
     if(194 <= b0){
       /*<<bytes.ml:603:6>>*/  /*<<bytes.ml:603:6>>*/ var i$15 = i + 1 | 0;
      if(max < i$15)
        /*<<bytes.ml:603:39>>*/ return  /*<<bytes.ml:603:39>>*/ caml_call1
               (dec_invalid, 1);
       /*<<bytes.ml:604:15>>*/  /*<<bytes.ml:604:15>>*/ var
       b1$5 =  /*<<bytes.ml:604:15>>*/ caml_bytes_unsafe_get(b, i$15);
       /*<<bytes.ml:604:29>>*/ return not_in_x80_to_xBF(b1$5)
              ?  /*<<bytes.ml:604:55>>*/ caml_call1(dec_invalid, 1)
              : dec_ret(2, (b0 & 31) << 6 | b1$5 & 63);
     }
    }
     /*<<bytes.ml:648:9>>*/ return  /*<<bytes.ml:648:9>>*/ caml_call1
            (dec_invalid, 1);
    /*<<bytes.ml:648:22>>*/ }
   function set_utf_8_uchar(b, i, u){
     /*<<bytes.ml:651:2>>*/ function set(_i_, _h_, _g_){
      /*<<?>>*/ caml_bytes_unsafe_set(_i_, _h_, _g_);
     return;
    }
     /*<<bytes.ml:652:2>>*/ var
      /*<<bytes.ml:652:2>>*/ max =
        /*<<bytes.ml:652:2>>*/ caml_ml_bytes_length(b) - 1 | 0,
      /*<<bytes.ml:653:8>>*/ u$0 =
        /*<<bytes.ml:653:8>>*/ caml_call1(Stdlib_Uchar[10], u);
     /*<<bytes.ml:654:11>>*/ if(0 > u$0)
      /*<<bytes.ml:654:20>>*/ throw  /*<<bytes.ml:654:20>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _b_], 1);
     /*<<bytes.ml:655:11>>*/ if(127 >= u$0){
      /*<<bytes.ml:656:6>>*/  /*<<bytes.ml:656:6>>*/ caml_bytes_set(b, i, u$0);
      /*<<bytes.ml:656:6>>*/ return 1;
    }
     /*<<bytes.ml:658:11>>*/ if(2047 >= u$0){
      /*<<bytes.ml:659:6>>*/  /*<<bytes.ml:659:6>>*/ var last$1 = i + 1 | 0;
     return max < last$1
             ? 0
             : ( /*<<bytes.ml:661:7>>*/ caml_bytes_set
                (b, i, 192 | u$0 >>> 6 | 0),
               set(b, last$1, 128 | u$0 & 63),
               2);
    }
     /*<<bytes.ml:664:11>>*/ if(65535 >= u$0){
      /*<<bytes.ml:665:6>>*/  /*<<bytes.ml:665:6>>*/ var last$0 = i + 2 | 0;
     return max < last$0
             ? 0
             : ( /*<<bytes.ml:667:7>>*/ caml_bytes_set
                (b, i, 224 | u$0 >>> 12 | 0),
               set(b, i + 1 | 0, 128 | (u$0 >>> 6 | 0) & 63),
               set(b, last$0, 128 | u$0 & 63),
               3);
    }
     /*<<bytes.ml:671:11>>*/ if(1114111 < u$0)
      /*<<bytes.ml:679:9>>*/ throw  /*<<bytes.ml:679:9>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _a_], 1);
     /*<<bytes.ml:672:6>>*/  /*<<bytes.ml:672:6>>*/ var last = i + 3 | 0;
    return max < last
            ? 0
            : ( /*<<bytes.ml:674:7>>*/ caml_bytes_set
               (b, i, 240 | u$0 >>> 18 | 0),
              set(b, i + 1 | 0, 128 | (u$0 >>> 12 | 0) & 63),
              set(b, i + 2 | 0, 128 | (u$0 >>> 6 | 0) & 63),
              set(b, last, 128 | u$0 & 63),
              4);
    /*<<bytes.ml:679:21>>*/ }
   function is_valid_utf_8(b){
     /*<<bytes.ml:682:2>>*/ var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
     /*<<bytes.ml:683:4>>*/ for(;;){
     if(max < i)  /*<<bytes.ml:683:20>>*/ return 1;
      /*<<bytes.ml:685:26>>*/  /*<<bytes.ml:685:26>>*/ var
      match =  /*<<bytes.ml:685:26>>*/ caml_bytes_unsafe_get(b, i);
     a:
     {
      if(224 <= match){
       if(237 <= match){
        if(245 <= match) break a;
        switch(match - 237 | 0){
          case 0:
            /*<<bytes.ml:708:8>>*/  /*<<bytes.ml:708:8>>*/ var
            last = i + 2 | 0;
            /*<<bytes.ml:711:11>>*/ if
            (max >= last
             &&
              !
              not_in_x80_to_x9F
               ( /*<<bytes.ml:710:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF
                ( /*<<bytes.ml:711:29>>*/ caml_bytes_unsafe_get(b, last))){
             /*<<bytes.ml:713:13>>*/ var
              /*<<bytes.ml:713:13>>*/ i$0 = last + 1 | 0,
             i = i$0;
            continue;
           }
            /*<<bytes.ml:712:13>>*/ return 0;
          case 3:
            /*<<bytes.ml:715:8>>*/  /*<<bytes.ml:715:8>>*/ var
            last$1 = i + 3 | 0;
            /*<<bytes.ml:719:11>>*/ if
            (max >= last$1
             &&
              !
              not_in_x90_to_xBF
               ( /*<<bytes.ml:717:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF
                ( /*<<bytes.ml:718:29>>*/ caml_bytes_unsafe_get(b, i + 2 | 0))
               &&
                !
                not_in_x80_to_xBF
                 ( /*<<bytes.ml:719:29>>*/ caml_bytes_unsafe_get(b, last$1))){
             /*<<bytes.ml:721:13>>*/ var
              /*<<bytes.ml:721:13>>*/ i$2 = last$1 + 1 | 0,
             i = i$2;
            continue;
           }
            /*<<bytes.ml:720:13>>*/ return 0;
          case 7:
            /*<<bytes.ml:731:8>>*/  /*<<bytes.ml:731:8>>*/ var
            last$3 = i + 3 | 0;
            /*<<bytes.ml:735:11>>*/ if
            (max >= last$3
             &&
              !
              not_in_x80_to_x8F
               ( /*<<bytes.ml:733:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF
                ( /*<<bytes.ml:734:29>>*/ caml_bytes_unsafe_get(b, i + 2 | 0))
               &&
                !
                not_in_x80_to_xBF
                 ( /*<<bytes.ml:735:29>>*/ caml_bytes_unsafe_get(b, last$3))){
             /*<<bytes.ml:737:13>>*/ var
              /*<<bytes.ml:737:13>>*/ i$4 = last$3 + 1 | 0,
             i = i$4;
            continue;
           }
            /*<<bytes.ml:736:13>>*/ return 0;
          case 1:
          case 2: break;
          default:
            /*<<bytes.ml:723:8>>*/  /*<<bytes.ml:723:8>>*/ var
            last$2 = i + 3 | 0;
            /*<<bytes.ml:727:11>>*/ if
            (max >= last$2
             &&
              !
              not_in_x80_to_xBF
               ( /*<<bytes.ml:725:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF
                ( /*<<bytes.ml:726:29>>*/ caml_bytes_unsafe_get(b, i + 2 | 0))
               &&
                !
                not_in_x80_to_xBF
                 ( /*<<bytes.ml:727:29>>*/ caml_bytes_unsafe_get(b, last$2))){
             /*<<bytes.ml:729:13>>*/ var
              /*<<bytes.ml:729:13>>*/ i$3 = last$2 + 1 | 0,
             i = i$3;
            continue;
           }
            /*<<bytes.ml:728:13>>*/ return 0;
        }
       }
       else if(225 > match){
         /*<<bytes.ml:694:8>>*/  /*<<bytes.ml:694:8>>*/ var
         last$4 = i + 2 | 0;
         /*<<bytes.ml:697:11>>*/ if
         (max >= last$4
          &&
           !
           not_in_xA0_to_xBF
            ( /*<<bytes.ml:696:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
           &&
            !
            not_in_x80_to_xBF
             ( /*<<bytes.ml:697:29>>*/ caml_bytes_unsafe_get(b, last$4))){
          /*<<bytes.ml:699:13>>*/ var
           /*<<bytes.ml:699:13>>*/ i$5 = last$4 + 1 | 0,
          i = i$5;
         continue;
        }
         /*<<bytes.ml:698:13>>*/ return 0;
       }
        /*<<bytes.ml:701:8>>*/  /*<<bytes.ml:701:8>>*/ var last$0 = i + 2 | 0;
        /*<<bytes.ml:704:11>>*/ if
        (max >= last$0
         &&
          !
          not_in_x80_to_xBF
           ( /*<<bytes.ml:703:29>>*/ caml_bytes_unsafe_get(b, i + 1 | 0))
          &&
           !
           not_in_x80_to_xBF
            ( /*<<bytes.ml:704:29>>*/ caml_bytes_unsafe_get(b, last$0))){
         /*<<bytes.ml:706:13>>*/ var
          /*<<bytes.ml:706:13>>*/ i$1 = last$0 + 1 | 0,
         i = i$1;
        continue;
       }
        /*<<bytes.ml:705:13>>*/ return 0;
      }
      if(128 > match){
        /*<<bytes.ml:686:26>>*/ var
         /*<<bytes.ml:686:26>>*/ i$7 = i + 1 | 0,
        i = i$7;
       continue;
      }
      if(194 <= match){
        /*<<bytes.ml:688:8>>*/  /*<<bytes.ml:688:8>>*/ var last$5 = i + 1 | 0;
        /*<<bytes.ml:690:11>>*/ if
        (max >= last$5
         &&
          !
          not_in_x80_to_xBF
           ( /*<<bytes.ml:690:29>>*/ caml_bytes_unsafe_get(b, last$5))){
         /*<<bytes.ml:692:13>>*/ var
          /*<<bytes.ml:692:13>>*/ i$6 = last$5 + 1 | 0,
         i = i$6;
        continue;
       }
        /*<<bytes.ml:691:13>>*/ return 0;
      }
     }
      /*<<bytes.ml:738:11>>*/ return 0;
    }
    /*<<bytes.ml:740:25>>*/ }
   function get_utf_16be_uchar(b, i){
     /*<<bytes.ml:745:2>>*/  /*<<bytes.ml:746:2>>*/ var
     max =  /*<<bytes.ml:746:2>>*/ caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     if(i === max)
       /*<<bytes.ml:748:18>>*/ return  /*<<bytes.ml:748:18>>*/ caml_call1
              (dec_invalid, 1);
      /*<<bytes.ml:749:8>>*/  /*<<bytes.ml:749:8>>*/ var
      hi = unsafe_get_uint16_be(b, i);
     if(55296 <= hi && 57343 >= hi){
       /*<<bytes.ml:751:11>>*/ if(56319 < hi)
        /*<<bytes.ml:751:25>>*/ return  /*<<bytes.ml:751:25>>*/ caml_call1
               (dec_invalid, 2);
       /*<<bytes.ml:753:6>>*/  /*<<bytes.ml:753:6>>*/ var last = i + 3 | 0;
      if(max < last) return caml_call1(dec_invalid, (max - i | 0) + 1 | 0);
       /*<<bytes.ml:755:12>>*/  /*<<bytes.ml:755:12>>*/ var
       lo = unsafe_get_uint16_be(b, i + 2 | 0);
      if(56320 <= lo && 57343 >= lo){
       var u = ((hi & 1023) << 10 | lo & 1023) + 65536 | 0;
        /*<<bytes.ml:759:10>>*/ return dec_ret(4, u);
      }
       /*<<bytes.ml:756:43>>*/ return  /*<<bytes.ml:756:43>>*/ caml_call1
              (dec_invalid, 2);
     }
      /*<<bytes.ml:750:39>>*/ return dec_ret(2, hi);
    }
     /*<<bytes.ml:747:27>>*/ return  /*<<bytes.ml:747:27>>*/ caml_call1
            (Stdlib[1], cst_index_out_of_bounds);
    /*<<bytes.ml:759:21>>*/ }
   function set_utf_16be_uchar(b, i, u){
     /*<<bytes.ml:762:2>>*/  /*<<bytes.ml:763:2>>*/ var
     max =  /*<<bytes.ml:763:2>>*/ caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
      /*<<bytes.ml:765:8>>*/  /*<<bytes.ml:765:8>>*/ var
      u$0 =  /*<<bytes.ml:765:8>>*/ caml_call1(Stdlib_Uchar[10], u);
      /*<<bytes.ml:766:11>>*/ if(0 > u$0)
       /*<<bytes.ml:766:20>>*/ throw  /*<<bytes.ml:766:20>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _d_], 1);
      /*<<bytes.ml:767:11>>*/ if(65535 >= u$0){
       /*<<bytes.ml:768:6>>*/  /*<<bytes.ml:768:6>>*/ var last$0 = i + 1 | 0;
      return max < last$0 ? 0 : (unsafe_set_uint16_be(b, i, u$0), 2);
     }
      /*<<bytes.ml:770:11>>*/ if(1114111 < u$0)
       /*<<bytes.ml:777:9>>*/ throw  /*<<bytes.ml:777:9>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _c_], 1);
      /*<<bytes.ml:771:6>>*/  /*<<bytes.ml:771:6>>*/ var last = i + 3 | 0;
     if(max < last)  /*<<bytes.ml:772:25>>*/ return 0;
      /*<<bytes.ml:773:6>>*/ var
       /*<<bytes.ml:773:6>>*/ u$1 = u$0 - 65536 | 0,
      hi = 55296 | u$1 >>> 10 | 0,
      lo = 56320 | u$1 & 1023;
      /*<<bytes.ml:776:6>>*/ unsafe_set_uint16_be(b, i, hi);
      /*<<bytes.ml:776:18>>*/ unsafe_set_uint16_be(b, i + 2 | 0, lo);
      /*<<bytes.ml:776:18>>*/ return 4;
    }
     /*<<bytes.ml:764:27>>*/ return  /*<<bytes.ml:764:27>>*/ caml_call1
            (Stdlib[1], cst_index_out_of_bounds$0);
    /*<<bytes.ml:777:21>>*/ }
   function is_valid_utf_16be(b){
     /*<<bytes.ml:780:2>>*/ var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
     /*<<bytes.ml:781:4>>*/ for(;;){
     if(max < i)  /*<<bytes.ml:782:20>>*/ return 1;
     if(i === max)  /*<<bytes.ml:783:20>>*/ return 0;
      /*<<bytes.ml:784:10>>*/  /*<<bytes.ml:784:10>>*/ var
      u = unsafe_get_uint16_be(b, i);
     if(55296 <= u && 57343 >= u){
       /*<<bytes.ml:786:13>>*/ if(56319 < u)
        /*<<bytes.ml:786:27>>*/ return 0;
       /*<<bytes.ml:788:8>>*/  /*<<bytes.ml:788:8>>*/ var last = i + 3 | 0;
      if(max < last)  /*<<bytes.ml:789:27>>*/ return 0;
       /*<<bytes.ml:790:14>>*/  /*<<bytes.ml:790:14>>*/ var
       u$0 = unsafe_get_uint16_be(b, i + 2 | 0);
      if(56320 <= u$0 && 57343 >= u$0){
        /*<<bytes.ml:792:17>>*/ var
         /*<<bytes.ml:792:17>>*/ i$1 = i + 4 | 0,
        i = i$1;
       continue;
      }
       /*<<bytes.ml:791:45>>*/ return 0;
     }
      /*<<bytes.ml:785:41>>*/ var
       /*<<bytes.ml:785:41>>*/ i$0 = i + 2 | 0,
      i = i$0;
    }
    /*<<bytes.ml:794:25>>*/ }
   function get_utf_16le_uchar(b, i){
     /*<<bytes.ml:799:2>>*/  /*<<bytes.ml:800:2>>*/ var
     max =  /*<<bytes.ml:800:2>>*/ caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     if(i === max)
       /*<<bytes.ml:802:18>>*/ return  /*<<bytes.ml:802:18>>*/ caml_call1
              (dec_invalid, 1);
      /*<<bytes.ml:803:8>>*/  /*<<bytes.ml:803:8>>*/ var
      hi = unsafe_get_uint16_le(b, i);
     if(55296 <= hi && 57343 >= hi){
       /*<<bytes.ml:805:11>>*/ if(56319 < hi)
        /*<<bytes.ml:805:25>>*/ return  /*<<bytes.ml:805:25>>*/ caml_call1
               (dec_invalid, 2);
       /*<<bytes.ml:807:6>>*/  /*<<bytes.ml:807:6>>*/ var last = i + 3 | 0;
      if(max < last) return caml_call1(dec_invalid, (max - i | 0) + 1 | 0);
       /*<<bytes.ml:809:12>>*/  /*<<bytes.ml:809:12>>*/ var
       lo = unsafe_get_uint16_le(b, i + 2 | 0);
      if(56320 <= lo && 57343 >= lo){
       var u = ((hi & 1023) << 10 | lo & 1023) + 65536 | 0;
        /*<<bytes.ml:813:10>>*/ return dec_ret(4, u);
      }
       /*<<bytes.ml:810:43>>*/ return  /*<<bytes.ml:810:43>>*/ caml_call1
              (dec_invalid, 2);
     }
      /*<<bytes.ml:804:39>>*/ return dec_ret(2, hi);
    }
     /*<<bytes.ml:801:27>>*/ return  /*<<bytes.ml:801:27>>*/ caml_call1
            (Stdlib[1], cst_index_out_of_bounds$1);
    /*<<bytes.ml:813:21>>*/ }
   function set_utf_16le_uchar(b, i, u){
     /*<<bytes.ml:816:2>>*/  /*<<bytes.ml:817:2>>*/ var
     max =  /*<<bytes.ml:817:2>>*/ caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
      /*<<bytes.ml:819:8>>*/  /*<<bytes.ml:819:8>>*/ var
      u$0 =  /*<<bytes.ml:819:8>>*/ caml_call1(Stdlib_Uchar[10], u);
      /*<<bytes.ml:820:11>>*/ if(0 > u$0)
       /*<<bytes.ml:820:20>>*/ throw  /*<<bytes.ml:820:20>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _f_], 1);
      /*<<bytes.ml:821:11>>*/ if(65535 >= u$0){
       /*<<bytes.ml:822:6>>*/  /*<<bytes.ml:822:6>>*/ var last$0 = i + 1 | 0;
      return max < last$0 ? 0 : (unsafe_set_uint16_le(b, i, u$0), 2);
     }
      /*<<bytes.ml:824:11>>*/ if(1114111 < u$0)
       /*<<bytes.ml:831:9>>*/ throw  /*<<bytes.ml:831:9>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _e_], 1);
      /*<<bytes.ml:825:6>>*/  /*<<bytes.ml:825:6>>*/ var last = i + 3 | 0;
     if(max < last)  /*<<bytes.ml:826:25>>*/ return 0;
      /*<<bytes.ml:827:6>>*/ var
       /*<<bytes.ml:827:6>>*/ u$1 = u$0 - 65536 | 0,
      hi = 55296 | u$1 >>> 10 | 0,
      lo = 56320 | u$1 & 1023;
      /*<<bytes.ml:830:6>>*/ unsafe_set_uint16_le(b, i, hi);
      /*<<bytes.ml:830:18>>*/ unsafe_set_uint16_le(b, i + 2 | 0, lo);
      /*<<bytes.ml:830:18>>*/ return 4;
    }
     /*<<bytes.ml:818:27>>*/ return  /*<<bytes.ml:818:27>>*/ caml_call1
            (Stdlib[1], cst_index_out_of_bounds$2);
    /*<<bytes.ml:831:21>>*/ }
   function is_valid_utf_16le(b){
     /*<<bytes.ml:834:2>>*/ var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
     /*<<bytes.ml:835:4>>*/ for(;;){
     if(max < i)  /*<<bytes.ml:836:20>>*/ return 1;
     if(i === max)  /*<<bytes.ml:837:20>>*/ return 0;
      /*<<bytes.ml:838:10>>*/  /*<<bytes.ml:838:10>>*/ var
      u = unsafe_get_uint16_le(b, i);
     if(55296 <= u && 57343 >= u){
       /*<<bytes.ml:840:13>>*/ if(56319 < u)
        /*<<bytes.ml:840:27>>*/ return 0;
       /*<<bytes.ml:842:8>>*/  /*<<bytes.ml:842:8>>*/ var last = i + 3 | 0;
      if(max < last)  /*<<bytes.ml:843:27>>*/ return 0;
       /*<<bytes.ml:844:14>>*/  /*<<bytes.ml:844:14>>*/ var
       u$0 = unsafe_get_uint16_le(b, i + 2 | 0);
      if(56320 <= u$0 && 57343 >= u$0){
        /*<<bytes.ml:846:17>>*/ var
         /*<<bytes.ml:846:17>>*/ i$1 = i + 4 | 0,
        i = i$1;
       continue;
      }
       /*<<bytes.ml:845:45>>*/ return 0;
     }
      /*<<bytes.ml:839:41>>*/ var
       /*<<bytes.ml:839:41>>*/ i$0 = i + 2 | 0,
      i = i$0;
    }
    /*<<bytes.ml:848:25>>*/ }
   var
    Stdlib_Bytes =
      [0,
       make,
       init,
       empty,
       copy,
       of_string,
       to_string,
       sub,
       sub_string,
       extend,
       fill,
       blit,
       blit_string,
       concat,
       cat,
       iter,
       iteri,
       map,
       mapi,
       fold_left,
       fold_right,
       for_all,
       exists,
       trim,
       escaped,
       index,
       index_opt,
       rindex,
       rindex_opt,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       contains,
       contains_from,
       rcontains_from,
       uppercase_ascii,
       lowercase_ascii,
       capitalize_ascii,
       uncapitalize_ascii,
       compare,
       runtime.caml_bytes_equal,
       starts_with,
       ends_with,
       caml_string_of_bytes,
       caml_bytes_of_string,
       split_on_char,
       to_seq,
       to_seqi,
       of_seq,
       get_utf_8_uchar,
       set_utf_8_uchar,
       is_valid_utf_8,
       get_utf_16be_uchar,
       set_utf_16be_uchar,
       is_valid_utf_16be,
       get_utf_16le_uchar,
       set_utf_16le_uchar,
       is_valid_utf_16le,
       caml_bytes_get,
       get_int8,
       caml_bytes_get16,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       caml_bytes_get32,
       get_int32_be,
       get_int32_le,
       caml_bytes_get64,
       get_int64_be,
       get_int64_le,
       set_uint8,
       caml_bytes_set,
       set_uint16_ne,
       set_int16_be,
       set_int16_le,
       caml_bytes_set16,
       set_int16_be,
       set_int16_le,
       caml_bytes_set32,
       set_int32_be,
       set_int32_le,
       caml_bytes_set64,
       set_int64_be,
       set_int64_le,
       unsafe_escape];
   runtime.caml_register_global(30, Stdlib_Bytes, "Stdlib__Bytes");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__String
//# unitInfo: Requires: Stdlib, Stdlib__Bytes
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$0 = "",
    caml_blit_string = runtime.caml_blit_string,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_equal = runtime.caml_string_equal,
    caml_string_hash = runtime.caml_string_hash,
    caml_string_unsafe_get = runtime.caml_string_unsafe_get,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst = cst$0,
    empty = cst$0,
    Stdlib = global_data.Stdlib,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    bts = Stdlib_Bytes[44],
    bos = Stdlib_Bytes[45];
   function make(n, c){
     /*<<string.ml:36:2>>*/ return  /*<<string.ml:36:2>>*/ caml_call1
            (bts,  /*<<string.ml:36:2>>*/ caml_call2(Stdlib_Bytes[1], n, c));
    /*<<string.ml:36:19>>*/ }
   function init(n, f){
     /*<<string.ml:38:2>>*/ return  /*<<string.ml:38:2>>*/ caml_call1
            (bts,  /*<<string.ml:38:2>>*/ caml_call2(Stdlib_Bytes[2], n, f));
    /*<<string.ml:38:19>>*/ }
   var of_bytes = Stdlib_Bytes[6], to_bytes = Stdlib_Bytes[5];
   function sub(s, ofs, len){
     /*<<string.ml:43:2>>*/  /*<<string.ml:43:8>>*/ var
     _X_ =  /*<<string.ml:43:8>>*/ caml_call1(bos, s);
     /*<<string.ml:43:2>>*/ return  /*<<string.ml:43:2>>*/ caml_call1
            (bts,
              /*<<string.ml:43:2>>*/ caml_call3
              (Stdlib_Bytes[7], _X_, ofs, len));
    /*<<string.ml:43:30>>*/ }
   var blit = Stdlib_Bytes[12], cst_String_concat = "String.concat";
   function concat(sep, l){
     /*<<?>>*/ if(! l)  /*<<string.ml:64:10>>*/ return cst;
    var seplen = caml_ml_string_length(sep);
    a:
    {
     b:
     {
      var acc = 0, param = l, pos$1 = 0;
      for(;;){
       if(! param) break;
       var hd = param[1];
       if(! param[2]) break b;
       var
        tl = param[2],
        x = (caml_ml_string_length(hd) + seplen | 0) + acc | 0,
        acc$0 =
          acc <= x
           ? x
           :  /*<<string.ml:47:48>>*/ caml_call1(Stdlib[1], cst_String_concat),
        acc = acc$0,
        param = tl;
      }
      var _W_ = acc;
      break a;
     }
     var _W_ = caml_ml_string_length(hd) + acc | 0;
    }
     /*<<string.ml:67:12>>*/ var
      /*<<string.ml:67:12>>*/ dst =
        /*<<string.ml:67:12>>*/ runtime.caml_create_bytes(_W_),
     pos = pos$1,
     param$0 = l;
    for(;;){
     if(param$0){
      var hd$0 = param$0[1];
      if(param$0[2]){
       var tl$0 = param$0[2];
        /*<<string.ml:59:4>>*/  /*<<string.ml:59:4>>*/ caml_blit_string
        (hd$0,
         0,
         dst,
         pos,
          /*<<string.ml:59:4>>*/ caml_ml_string_length(hd$0));
        /*<<string.ml:60:4>>*/  /*<<string.ml:60:4>>*/ caml_blit_string
        (sep, 0, dst, pos + caml_ml_string_length(hd$0) | 0, seplen);
       var
        pos$0 = (pos + caml_ml_string_length(hd$0) | 0) + seplen | 0,
        pos = pos$0,
        param$0 = tl$0;
       continue;
      }
       /*<<string.ml:57:4>>*/  /*<<string.ml:57:4>>*/ caml_blit_string
       (hd$0, 0, dst, pos, caml_ml_string_length(hd$0));
     }
      /*<<string.ml:66:10>>*/ return  /*<<string.ml:66:10>>*/ caml_call1
             (bts, dst);
    }
   }
   var
    cat = Stdlib[28],
    cst_String_index_from_Bytes_in = "String.index_from / Bytes.index_from",
    cst_String_index_from_opt_Byte =
      "String.index_from_opt / Bytes.index_from_opt",
    cst_String_rindex_from_Bytes_r = "String.rindex_from / Bytes.rindex_from",
    cst_String_rindex_from_opt_Byt =
      "String.rindex_from_opt / Bytes.rindex_from_opt",
    cst_String_contains_from_Bytes =
      "String.contains_from / Bytes.contains_from",
    cst_String_rcontains_from_Byte =
      "String.rcontains_from / Bytes.rcontains_from";
   function iter(f, s){
     /*<<string.ml:74:2>>*/ var
     _U_ = caml_ml_string_length(s) - 1 | 0,
      /*<<string.ml:74:2>>*/ _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
       /*<<string.ml:74:31>>*/  /*<<string.ml:74:31>>*/ caml_call1
       (f, caml_string_unsafe_get(s, i));
       /*<<string.ml:74:31>>*/  /*<<string.ml:74:31>>*/ var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return 0;
    /*<<string.ml:74:54>>*/ }
   function iteri(f, s){
     /*<<string.ml:78:2>>*/ var
     _R_ = caml_ml_string_length(s) - 1 | 0,
      /*<<string.ml:78:2>>*/ _Q_ = 0;
    if(_R_ >= 0){
     var i = _Q_;
     for(;;){
       /*<<string.ml:78:31>>*/  /*<<string.ml:78:31>>*/ caml_call2
       (f, i, caml_string_unsafe_get(s, i));
       /*<<string.ml:78:31>>*/  /*<<string.ml:78:31>>*/ var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
    return 0;
    /*<<string.ml:78:56>>*/ }
   function map(f, s){
     /*<<string.ml:81:2>>*/  /*<<string.ml:81:10>>*/ var
     _P_ =  /*<<string.ml:81:10>>*/ caml_call1(bos, s);
     /*<<string.ml:81:2>>*/ return  /*<<string.ml:81:2>>*/ caml_call1
            (bts,
              /*<<string.ml:81:2>>*/ caml_call2(Stdlib_Bytes[17], f, _P_));
    /*<<string.ml:81:24>>*/ }
   function mapi(f, s){
     /*<<string.ml:83:2>>*/  /*<<string.ml:83:11>>*/ var
     _O_ =  /*<<string.ml:83:11>>*/ caml_call1(bos, s);
     /*<<string.ml:83:2>>*/ return  /*<<string.ml:83:2>>*/ caml_call1
            (bts,
              /*<<string.ml:83:2>>*/ caml_call2(Stdlib_Bytes[18], f, _O_));
    /*<<string.ml:83:25>>*/ }
   function fold_right(f, x, a){
     /*<<string.ml:85:2>>*/  /*<<string.ml:85:17>>*/ var
     _N_ =  /*<<string.ml:85:17>>*/ caml_call1(bos, x);
     /*<<string.ml:85:2>>*/ return  /*<<string.ml:85:2>>*/ caml_call3
            (Stdlib_Bytes[20], f, _N_, a);
    /*<<string.ml:85:26>>*/ }
   function fold_left(f, a, x){
     /*<<string.ml:87:2>>*/  /*<<string.ml:87:18>>*/ var
     _M_ =  /*<<string.ml:87:18>>*/ caml_call1(bos, x);
     /*<<string.ml:87:18>>*/ return  /*<<string.ml:87:18>>*/ caml_call3
            (Stdlib_Bytes[19], f, a, _M_);
    /*<<string.ml:87:25>>*/ }
   function exists(f, s){
     /*<<string.ml:89:2>>*/  /*<<string.ml:89:13>>*/ var
     _L_ =  /*<<string.ml:89:13>>*/ caml_call1(bos, s);
     /*<<string.ml:89:13>>*/ return  /*<<string.ml:89:13>>*/ caml_call2
            (Stdlib_Bytes[22], f, _L_);
    /*<<string.ml:89:20>>*/ }
   function for_all(f, s){
     /*<<string.ml:91:2>>*/  /*<<string.ml:91:14>>*/ var
     _K_ =  /*<<string.ml:91:14>>*/ caml_call1(bos, s);
     /*<<string.ml:91:14>>*/ return  /*<<string.ml:91:14>>*/ caml_call2
            (Stdlib_Bytes[21], f, _K_);
    /*<<string.ml:91:21>>*/ }
   function is_space(param){
     /*<<string.ml:97:15>>*/  /*<<string.ml:97:15>>*/ var _J_ = param - 9 | 0;
    a:
    {
     if(4 < _J_ >>> 0){if(23 !== _J_) break a;} else if(2 === _J_) break a;
      /*<<string.ml:98:41>>*/ return 1;
    }
     /*<<string.ml:99:9>>*/ return 0;
    /*<<string.ml:99:14>>*/ }
   function trim(s){
     /*<<string.ml:102:2>>*/ if
     ( /*<<string.ml:102:5>>*/ caml_string_equal(s, cst$0))
      /*<<string.ml:102:17>>*/ return s;
     /*<<string.ml:103:39>>*/ if
     (!
      is_space(caml_string_unsafe_get(s, 0))
      &&
       !
       is_space(caml_string_unsafe_get(s, caml_ml_string_length(s) - 1 | 0)))
      /*<<string.ml:105:7>>*/ return s;
     /*<<string.ml:104:21>>*/  /*<<string.ml:104:21>>*/ var
     _I_ =  /*<<string.ml:104:21>>*/ caml_call1(bos, s);
     /*<<string.ml:104:13>>*/ return  /*<<string.ml:104:13>>*/ caml_call1
            (bts,  /*<<string.ml:104:13>>*/ caml_call1(Stdlib_Bytes[23], _I_));
    /*<<string.ml:105:8>>*/ }
   function escaped(s){
     /*<<string.ml:108:2>>*/  /*<<string.ml:108:10>>*/ var
     b =  /*<<string.ml:108:10>>*/ caml_call1(bos, s);
     /*<<string.ml:111:6>>*/ return  /*<<string.ml:111:6>>*/ caml_call1
            (bts,  /*<<string.ml:111:6>>*/ caml_call1(Stdlib_Bytes[87], b));
    /*<<string.ml:111:25>>*/ }
   function index_rec(s, lim, i, c){
     /*<<string.ml:115:2>>*/ var i$0 = i;
     /*<<string.ml:115:2>>*/ for(;;){
     if(lim <= i$0)
       /*<<string.ml:115:19>>*/ throw  /*<<string.ml:115:19>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     if(caml_string_unsafe_get(s, i$0) === c)
       /*<<string.ml:116:29>>*/ return i$0;
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
    /*<<string.ml:116:61>>*/ }
   function index(s, c){
     /*<<string.ml:119:16>>*/ return index_rec
            (s, caml_ml_string_length(s), 0, c);
    /*<<string.ml:119:42>>*/ }
   function index_rec_opt(s, lim, i, c){
     /*<<string.ml:123:2>>*/ var i$0 = i;
     /*<<string.ml:123:2>>*/ for(;;){
     if(lim <= i$0)  /*<<string.ml:123:19>>*/ return 0;
     if(caml_string_unsafe_get(s, i$0) === c)
       /*<<string.ml:124:29>>*/ return [0, i$0];
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
    /*<<string.ml:124:70>>*/ }
   function index_opt(s, c){
     /*<<string.ml:127:20>>*/ return index_rec_opt
            (s, caml_ml_string_length(s), 0, c);
    /*<<string.ml:127:50>>*/ }
   function index_from(s, i, c){
     /*<<string.ml:131:2>>*/ var l = caml_ml_string_length(s);
    if(0 <= i && l >= i)
      /*<<string.ml:133:4>>*/ return index_rec(s, l, i, c);
     /*<<string.ml:132:25>>*/ return  /*<<string.ml:132:25>>*/ caml_call1
            (Stdlib[1], cst_String_index_from_Bytes_in);
    /*<<string.ml:133:21>>*/ }
   function index_from_opt(s, i, c){
     /*<<string.ml:137:2>>*/ var l = caml_ml_string_length(s);
    if(0 <= i && l >= i)
      /*<<string.ml:141:4>>*/ return index_rec_opt(s, l, i, c);
     /*<<string.ml:139:4>>*/ return  /*<<string.ml:139:4>>*/ caml_call1
            (Stdlib[1], cst_String_index_from_opt_Byte);
    /*<<string.ml:141:25>>*/ }
   function rindex_rec(s, i, c){
     /*<<string.ml:145:2>>*/ var i$0 = i;
     /*<<string.ml:145:2>>*/ for(;;){
     if(0 > i$0)
       /*<<string.ml:145:16>>*/ throw  /*<<string.ml:145:16>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     if(caml_string_unsafe_get(s, i$0) === c)
       /*<<string.ml:146:29>>*/ return i$0;
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
    /*<<string.ml:146:58>>*/ }
   function rindex(s, c){
     /*<<string.ml:149:17>>*/ return rindex_rec
            (s, caml_ml_string_length(s) - 1 | 0, c);
    /*<<string.ml:149:46>>*/ }
   function rindex_from(s, i, c){
     /*<<string.ml:153:2>>*/ if(-1 <= i && caml_ml_string_length(s) > i)
      /*<<string.ml:156:4>>*/ return rindex_rec(s, i, c);
     /*<<string.ml:154:4>>*/ return  /*<<string.ml:154:4>>*/ caml_call1
            (Stdlib[1], cst_String_rindex_from_Bytes_r);
    /*<<string.ml:156:20>>*/ }
   function rindex_rec_opt(s, i, c){
     /*<<string.ml:160:2>>*/ var i$0 = i;
     /*<<string.ml:160:2>>*/ for(;;){
     if(0 > i$0)  /*<<string.ml:160:16>>*/ return 0;
     if(caml_string_unsafe_get(s, i$0) === c)
       /*<<string.ml:161:29>>*/ return [0, i$0];
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
    /*<<string.ml:161:67>>*/ }
   function rindex_opt(s, c){
     /*<<string.ml:164:21>>*/ return rindex_rec_opt
            (s, caml_ml_string_length(s) - 1 | 0, c);
    /*<<string.ml:164:54>>*/ }
   function rindex_from_opt(s, i, c){
     /*<<string.ml:168:2>>*/ if(-1 <= i && caml_ml_string_length(s) > i)
      /*<<string.ml:171:4>>*/ return rindex_rec_opt(s, i, c);
     /*<<string.ml:169:4>>*/ return  /*<<string.ml:169:4>>*/ caml_call1
            (Stdlib[1], cst_String_rindex_from_opt_Byt);
    /*<<string.ml:171:24>>*/ }
   function contains_from(s, i, c){
     /*<<string.ml:175:2>>*/ var l = caml_ml_string_length(s);
    if(0 <= i && l >= i)
      /*<<string.ml:179:4>>*/ try{
       /*<<string.ml:179:15>>*/ index_rec(s, l, i, c);
       /*<<string.ml:179:36>>*/  /*<<string.ml:179:36>>*/ var _G_ = 1;
       /*<<string.ml:179:36>>*/ return _G_;
     }
     catch(_H_){
      var _F_ = caml_wrap_exception(_H_);
      if(_F_ === Stdlib[8])  /*<<string.ml:179:59>>*/ return 0;
      throw caml_maybe_attach_backtrace(_F_, 0);
     }
     /*<<string.ml:177:4>>*/ return  /*<<string.ml:177:4>>*/ caml_call1
            (Stdlib[1], cst_String_contains_from_Bytes);
    /*<<string.ml:179:64>>*/ }
   function contains(s, c){
     /*<<string.ml:182:19>>*/ return contains_from(s, 0, c);
    /*<<string.ml:182:38>>*/ }
   function rcontains_from(s, i, c){
     /*<<string.ml:186:2>>*/ if(0 <= i && caml_ml_string_length(s) > i)
      /*<<string.ml:189:4>>*/ try{
       /*<<string.ml:189:15>>*/ rindex_rec(s, i, c);
       /*<<string.ml:189:35>>*/  /*<<string.ml:189:35>>*/ var _D_ = 1;
       /*<<string.ml:189:35>>*/ return _D_;
     }
     catch(_E_){
      var _C_ = caml_wrap_exception(_E_);
      if(_C_ === Stdlib[8])  /*<<string.ml:189:58>>*/ return 0;
      throw caml_maybe_attach_backtrace(_C_, 0);
     }
     /*<<string.ml:187:4>>*/ return  /*<<string.ml:187:4>>*/ caml_call1
            (Stdlib[1], cst_String_rcontains_from_Byte);
    /*<<string.ml:189:63>>*/ }
   function uppercase_ascii(s){
     /*<<string.ml:192:2>>*/  /*<<string.ml:192:20>>*/ var
     _B_ =  /*<<string.ml:192:20>>*/ caml_call1(bos, s);
     /*<<string.ml:192:2>>*/ return  /*<<string.ml:192:2>>*/ caml_call1
            (bts,  /*<<string.ml:192:2>>*/ caml_call1(Stdlib_Bytes[36], _B_));
    /*<<string.ml:192:34>>*/ }
   function lowercase_ascii(s){
     /*<<string.ml:194:2>>*/  /*<<string.ml:194:20>>*/ var
     _A_ =  /*<<string.ml:194:20>>*/ caml_call1(bos, s);
     /*<<string.ml:194:2>>*/ return  /*<<string.ml:194:2>>*/ caml_call1
            (bts,  /*<<string.ml:194:2>>*/ caml_call1(Stdlib_Bytes[37], _A_));
    /*<<string.ml:194:34>>*/ }
   function capitalize_ascii(s){
     /*<<string.ml:196:2>>*/  /*<<string.ml:196:21>>*/ var
     _z_ =  /*<<string.ml:196:21>>*/ caml_call1(bos, s);
     /*<<string.ml:196:2>>*/ return  /*<<string.ml:196:2>>*/ caml_call1
            (bts,  /*<<string.ml:196:2>>*/ caml_call1(Stdlib_Bytes[38], _z_));
    /*<<string.ml:196:35>>*/ }
   function uncapitalize_ascii(s){
     /*<<string.ml:198:2>>*/  /*<<string.ml:198:23>>*/ var
     _y_ =  /*<<string.ml:198:23>>*/ caml_call1(bos, s);
     /*<<string.ml:198:2>>*/ return  /*<<string.ml:198:2>>*/ caml_call1
            (bts,  /*<<string.ml:198:2>>*/ caml_call1(Stdlib_Bytes[39], _y_));
    /*<<string.ml:198:37>>*/ }
   function starts_with(prefix, s){
     /*<<string.ml:202:2>>*/ var
     len_s = caml_ml_string_length(s),
     len_pre = caml_ml_string_length(prefix),
     _x_ = len_pre <= len_s ? 1 : 0;
    if(! _x_) return _x_;
    var i = 0;
     /*<<string.ml:205:4>>*/ for(;;){
     if(i === len_pre)  /*<<string.ml:205:24>>*/ return 1;
     if(caml_string_unsafe_get(s, i) !== caml_string_unsafe_get(prefix, i))
       /*<<string.ml:206:55>>*/ return 0;
      /*<<string.ml:207:9>>*/ var
       /*<<string.ml:207:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<string.ml:208:30>>*/ }
   function ends_with(suffix, s){
     /*<<string.ml:212:2>>*/ var
     len_s = caml_ml_string_length(s),
     len_suf = caml_ml_string_length(suffix),
     diff = len_s - len_suf | 0,
     _w_ = 0 <= diff ? 1 : 0;
    if(! _w_) return _w_;
    var i = 0;
     /*<<string.ml:216:4>>*/ for(;;){
     if(i === len_suf)  /*<<string.ml:216:24>>*/ return 1;
     if
      (caml_string_unsafe_get(s, diff + i | 0)
       !== caml_string_unsafe_get(suffix, i))
       /*<<string.ml:217:64>>*/ return 0;
      /*<<string.ml:218:9>>*/ var
       /*<<string.ml:218:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<string.ml:219:23>>*/ }
   function hash(x){
     /*<<string.ml:222:13>>*/ return  /*<<string.ml:222:13>>*/ caml_string_hash
            (0, x);
    /*<<string.ml:222:28>>*/ }
   function split_on_char(sep, s){
     /*<<string.ml:226:2>>*/ var
      /*<<string.ml:226:10>>*/ r = [0, 0],
      /*<<string.ml:227:10>>*/ j =
       [0,  /*<<string.ml:227:2>>*/ caml_ml_string_length(s)],
      /*<<string.ml:228:2>>*/ _s_ =
        /*<<string.ml:228:2>>*/ caml_ml_string_length(s) - 1 | 0;
    if(_s_ >= 0){
     var i = _s_;
     for(;;){
      if(caml_string_unsafe_get(s, i) === sep){
       var _u_ = r[1];
       r[1] = [0, sub(s, i + 1 | 0, (j[1] - i | 0) - 1 | 0), _u_];
       j[1] = i;
      }
       /*<<string.ml:228:2>>*/  /*<<string.ml:228:2>>*/ var _v_ = i - 1 | 0;
      if(0 === i) break;
      var i = _v_;
     }
    }
    var _t_ = r[1];
     /*<<string.ml:234:2>>*/ return [0, sub(s, 0, j[1]), _t_];
    /*<<string.ml:234:18>>*/ }
   var compare = runtime.caml_string_compare;
   function to_seq(s){
     /*<<string.ml:243:15>>*/  /*<<string.ml:243:15>>*/ var
     _r_ =  /*<<string.ml:243:15>>*/ caml_call1(bos, s);
     /*<<string.ml:243:15>>*/ return  /*<<string.ml:243:15>>*/ caml_call1
            (Stdlib_Bytes[47], _r_);
    /*<<string.ml:243:32>>*/ }
   function to_seqi(s){
     /*<<string.ml:245:16>>*/  /*<<string.ml:245:16>>*/ var
     _q_ =  /*<<string.ml:245:16>>*/ caml_call1(bos, s);
     /*<<string.ml:245:16>>*/ return  /*<<string.ml:245:16>>*/ caml_call1
            (Stdlib_Bytes[48], _q_);
    /*<<string.ml:245:34>>*/ }
   function of_seq(g){
     /*<<string.ml:247:15>>*/ return  /*<<string.ml:247:15>>*/ caml_call1
            (bts,  /*<<string.ml:247:15>>*/ caml_call1(Stdlib_Bytes[49], g));
    /*<<string.ml:247:32>>*/ }
   function get_utf_8_uchar(s, i){
     /*<<string.ml:251:26>>*/  /*<<string.ml:251:44>>*/ var
     _p_ =  /*<<string.ml:251:44>>*/ caml_call1(bos, s);
     /*<<string.ml:251:26>>*/ return  /*<<string.ml:251:26>>*/ caml_call2
            (Stdlib_Bytes[50], _p_, i);
    /*<<string.ml:251:53>>*/ }
   function is_valid_utf_8(s){
     /*<<string.ml:252:23>>*/  /*<<string.ml:252:40>>*/ var
     _o_ =  /*<<string.ml:252:40>>*/ caml_call1(bos, s);
     /*<<string.ml:252:40>>*/ return  /*<<string.ml:252:40>>*/ caml_call1
            (Stdlib_Bytes[52], _o_);
    /*<<string.ml:252:47>>*/ }
   function get_utf_16be_uchar(s, i){
     /*<<string.ml:254:29>>*/  /*<<string.ml:254:50>>*/ var
     _n_ =  /*<<string.ml:254:50>>*/ caml_call1(bos, s);
     /*<<string.ml:254:29>>*/ return  /*<<string.ml:254:29>>*/ caml_call2
            (Stdlib_Bytes[53], _n_, i);
    /*<<string.ml:254:59>>*/ }
   function is_valid_utf_16be(s){
     /*<<string.ml:255:26>>*/  /*<<string.ml:255:46>>*/ var
     _m_ =  /*<<string.ml:255:46>>*/ caml_call1(bos, s);
     /*<<string.ml:255:46>>*/ return  /*<<string.ml:255:46>>*/ caml_call1
            (Stdlib_Bytes[55], _m_);
    /*<<string.ml:255:53>>*/ }
   function get_utf_16le_uchar(s, i){
     /*<<string.ml:257:29>>*/  /*<<string.ml:257:50>>*/ var
     _l_ =  /*<<string.ml:257:50>>*/ caml_call1(bos, s);
     /*<<string.ml:257:29>>*/ return  /*<<string.ml:257:29>>*/ caml_call2
            (Stdlib_Bytes[56], _l_, i);
    /*<<string.ml:257:59>>*/ }
   function is_valid_utf_16le(s){
     /*<<string.ml:258:26>>*/  /*<<string.ml:258:46>>*/ var
     _k_ =  /*<<string.ml:258:46>>*/ caml_call1(bos, s);
     /*<<string.ml:258:46>>*/ return  /*<<string.ml:258:46>>*/ caml_call1
            (Stdlib_Bytes[58], _k_);
    /*<<string.ml:258:53>>*/ }
   function get_int8(s, i){
     /*<<string.ml:267:19>>*/  /*<<string.ml:267:30>>*/ var
     _j_ =  /*<<string.ml:267:30>>*/ caml_call1(bos, s);
     /*<<string.ml:267:19>>*/ return  /*<<string.ml:267:19>>*/ caml_call2
            (Stdlib_Bytes[60], _j_, i);
    /*<<string.ml:267:39>>*/ }
   function get_uint16_le(s, i){
     /*<<string.ml:268:24>>*/  /*<<string.ml:268:40>>*/ var
     _i_ =  /*<<string.ml:268:40>>*/ caml_call1(bos, s);
     /*<<string.ml:268:24>>*/ return  /*<<string.ml:268:24>>*/ caml_call2
            (Stdlib_Bytes[63], _i_, i);
    /*<<string.ml:268:49>>*/ }
   function get_uint16_be(s, i){
     /*<<string.ml:269:24>>*/  /*<<string.ml:269:40>>*/ var
     _h_ =  /*<<string.ml:269:40>>*/ caml_call1(bos, s);
     /*<<string.ml:269:24>>*/ return  /*<<string.ml:269:24>>*/ caml_call2
            (Stdlib_Bytes[62], _h_, i);
    /*<<string.ml:269:49>>*/ }
   function get_int16_ne(s, i){
     /*<<string.ml:270:23>>*/  /*<<string.ml:270:38>>*/ var
     _g_ =  /*<<string.ml:270:38>>*/ caml_call1(bos, s);
     /*<<string.ml:270:23>>*/ return  /*<<string.ml:270:23>>*/ caml_call2
            (Stdlib_Bytes[64], _g_, i);
    /*<<string.ml:270:47>>*/ }
   function get_int16_le(s, i){
     /*<<string.ml:271:23>>*/  /*<<string.ml:271:38>>*/ var
     _f_ =  /*<<string.ml:271:38>>*/ caml_call1(bos, s);
     /*<<string.ml:271:23>>*/ return  /*<<string.ml:271:23>>*/ caml_call2
            (Stdlib_Bytes[66], _f_, i);
    /*<<string.ml:271:47>>*/ }
   function get_int16_be(s, i){
     /*<<string.ml:272:23>>*/  /*<<string.ml:272:38>>*/ var
     _e_ =  /*<<string.ml:272:38>>*/ caml_call1(bos, s);
     /*<<string.ml:272:23>>*/ return  /*<<string.ml:272:23>>*/ caml_call2
            (Stdlib_Bytes[65], _e_, i);
    /*<<string.ml:272:47>>*/ }
   function get_int32_le(s, i){
     /*<<string.ml:273:23>>*/  /*<<string.ml:273:38>>*/ var
     _d_ =  /*<<string.ml:273:38>>*/ caml_call1(bos, s);
     /*<<string.ml:273:23>>*/ return  /*<<string.ml:273:23>>*/ caml_call2
            (Stdlib_Bytes[69], _d_, i);
    /*<<string.ml:273:47>>*/ }
   function get_int32_be(s, i){
     /*<<string.ml:274:23>>*/  /*<<string.ml:274:38>>*/ var
     _c_ =  /*<<string.ml:274:38>>*/ caml_call1(bos, s);
     /*<<string.ml:274:23>>*/ return  /*<<string.ml:274:23>>*/ caml_call2
            (Stdlib_Bytes[68], _c_, i);
    /*<<string.ml:274:47>>*/ }
   function get_int64_le(s, i){
     /*<<string.ml:275:23>>*/  /*<<string.ml:275:38>>*/ var
     _b_ =  /*<<string.ml:275:38>>*/ caml_call1(bos, s);
     /*<<string.ml:275:23>>*/ return  /*<<string.ml:275:23>>*/ caml_call2
            (Stdlib_Bytes[72], _b_, i);
    /*<<string.ml:275:47>>*/ }
   function get_int64_be(s, i){
     /*<<string.ml:276:23>>*/  /*<<string.ml:276:38>>*/ var
     _a_ =  /*<<string.ml:276:38>>*/ caml_call1(bos, s);
     /*<<string.ml:276:23>>*/ return  /*<<string.ml:276:23>>*/ caml_call2
            (Stdlib_Bytes[71], _a_, i);
    /*<<string.ml:276:47>>*/ }
   var
    Stdlib_String =
      [0,
       make,
       init,
       empty,
       of_bytes,
       to_bytes,
       blit,
       concat,
       cat,
       caml_string_equal,
       compare,
       starts_with,
       ends_with,
       contains_from,
       rcontains_from,
       contains,
       sub,
       split_on_char,
       map,
       mapi,
       fold_left,
       fold_right,
       for_all,
       exists,
       trim,
       escaped,
       uppercase_ascii,
       lowercase_ascii,
       capitalize_ascii,
       uncapitalize_ascii,
       iter,
       iteri,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       index,
       index_opt,
       rindex,
       rindex_opt,
       to_seq,
       to_seqi,
       of_seq,
       get_utf_8_uchar,
       is_valid_utf_8,
       get_utf_16be_uchar,
       is_valid_utf_16be,
       get_utf_16le_uchar,
       is_valid_utf_16le,
       runtime.caml_string_get,
       get_int8,
       runtime.caml_string_get16,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       runtime.caml_string_get32,
       hash,
       caml_string_hash,
       get_int32_be,
       get_int32_le,
       runtime.caml_string_get64,
       get_int64_be,
       get_int64_le];
   runtime.caml_register_global(12, Stdlib_String, "Stdlib__String");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Unit
(function(globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, cst = "()";
   function equal(param, _b_){
     /*<<unit.ml:18:18>>*/ return 1;
    /*<<unit.ml:18:22>>*/ }
   function compare(param, _a_){
     /*<<unit.ml:19:20>>*/ return 0;
    /*<<unit.ml:19:21>>*/ }
   function to_string(param){
     /*<<unit.ml:20:19>>*/ return cst;
    /*<<unit.ml:20:23>>*/ }
   var Stdlib_Unit = [0, equal, compare, to_string];
   runtime.caml_register_global(1, Stdlib_Unit, "Stdlib__Unit");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Marshal
//# unitInfo: Requires: Stdlib, Stdlib__Bytes
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Marshal_from_bytes$1 = "Marshal.from_bytes",
    caml_marshal_data_size = runtime.caml_marshal_data_size,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib = global_data.Stdlib,
    cst_Marshal_to_buffer_substrin =
      "Marshal.to_buffer: substring out of bounds";
   function to_buffer(buff, ofs, len, v, flags){
     /*<<marshal.ml:34:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_bytes_length(buff) - len | 0) >= ofs)
      /*<<marshal.ml:36:7>>*/ return  /*<<marshal.ml:36:7>>*/ runtime.caml_output_value_to_buffer
             (buff, ofs, len, v, flags);
     /*<<marshal.ml:35:7>>*/ return  /*<<marshal.ml:35:7>>*/ caml_call1
            (Stdlib[1], cst_Marshal_to_buffer_substrin);
    /*<<marshal.ml:36:44>>*/ }
   var
    cst_Marshal_data_size = "Marshal.data_size",
    cst_Marshal_from_bytes = cst_Marshal_from_bytes$1,
    cst_Marshal_from_bytes$0 = cst_Marshal_from_bytes$1;
   function data_size(buff, ofs){
     /*<<marshal.ml:50:2>>*/ if
     (0 <= ofs && (caml_ml_bytes_length(buff) - 16 | 0) >= ofs)
      /*<<marshal.ml:52:7>>*/ return  /*<<marshal.ml:52:7>>*/ caml_marshal_data_size
             (buff, ofs);
     /*<<marshal.ml:51:7>>*/ return  /*<<marshal.ml:51:7>>*/ caml_call1
            (Stdlib[1], cst_Marshal_data_size);
    /*<<marshal.ml:52:32>>*/ }
   function total_size(buff, ofs){
     /*<<marshal.ml:53:26>>*/ return 16 + data_size(buff, ofs) | 0;
    /*<<marshal.ml:53:58>>*/ }
   function from_bytes(buff, ofs){
     /*<<marshal.ml:56:2>>*/ if
     (0 <= ofs && (caml_ml_bytes_length(buff) - 16 | 0) >= ofs){
      /*<<marshal.ml:59:14>>*/  /*<<marshal.ml:59:14>>*/ var
      len =  /*<<marshal.ml:59:14>>*/ caml_marshal_data_size(buff, ofs);
     return (caml_ml_bytes_length(buff) - (16 + len | 0) | 0) < ofs
             ?  /*<<marshal.ml:61:9>>*/ caml_call1
               (Stdlib[1], cst_Marshal_from_bytes$0)
             :  /*<<marshal.ml:62:9>>*/ runtime.caml_input_value_from_bytes
               (buff, ofs);
    }
     /*<<marshal.ml:57:7>>*/ return  /*<<marshal.ml:57:7>>*/ caml_call1
            (Stdlib[1], cst_Marshal_from_bytes);
    /*<<marshal.ml:63:5>>*/ }
   function from_string(buff, ofs){
     /*<<marshal.ml:68:2>>*/ return from_bytes
            ( /*<<marshal.ml:68:13>>*/ caml_call1(Stdlib_Bytes[45], buff),
             ofs);
    /*<<marshal.ml:68:46>>*/ }
   var
    Stdlib_Marshal =
      [0,
       runtime.caml_output_value,
       to_buffer,
       runtime.caml_input_value,
       from_bytes,
       from_string,
       16,
       data_size,
       total_size];
   runtime.caml_register_global(6, Stdlib_Marshal, "Stdlib__Marshal");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Array
//# unitInfo: Requires: Stdlib, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_array_sub = runtime.caml_array_sub,
    caml_check_bound = runtime.caml_check_bound,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<array.ml:37:20>>*/ var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Assert_failure = global_data.Assert_failure,
    Stdlib = global_data.Stdlib,
     /*<<array.ml:37:20>>*/ Floatarray = [0],
    cst_Array_init = "Array.init",
    cst_Array_sub = "Array.sub",
    cst_Array_fill = "Array.fill",
    cst_Array_blit = "Array.blit",
    cst_Array_iter2_arrays_must_ha =
      "Array.iter2: arrays must have the same length",
    cst_Array_map2_arrays_must_hav =
      "Array.map2: arrays must have the same length",
    cst_Array_for_all2 = "Array.for_all2",
    cst_Array_exists2 = "Array.exists2",
    cst_Array_combine = "Array.combine";
   function init(l, f){
     /*<<array.ml:48:2>>*/ if(0 === l)  /*<<array.ml:48:16>>*/ return [0];
    if(0 > l)
      /*<<array.ml:49:16>>*/ return  /*<<array.ml:49:16>>*/ caml_call1
             (Stdlib[1], cst_Array_init);
     /*<<array.ml:53:13>>*/ var
      /*<<array.ml:53:13>>*/ res =
        /*<<array.ml:53:13>>*/ caml_make_vect
        (l,  /*<<array.ml:53:22>>*/ caml_call1(f, 0)),
      /*<<array.ml:54:3>>*/ _aw_ = l - 1 | 0,
      /*<<array.ml:53:13>>*/ _av_ = 1;
    if(_aw_ >= 1){
     var i = _av_;
     for(;;){
       /*<<array.ml:55:5>>*/ res[1 + i] =
        /*<<array.ml:55:22>>*/ caml_call1(f, i);
       /*<<array.ml:55:5>>*/  /*<<array.ml:55:5>>*/ var _ax_ = i + 1 | 0;
      if(_aw_ === i) break;
      var i = _ax_;
     }
    }
     /*<<array.ml:57:3>>*/ return res;
    /*<<array.ml:57:6>>*/ }
   function make_matrix(sx, sy, init){
     /*<<array.ml:60:2>>*/ var
      /*<<array.ml:60:12>>*/ res =
        /*<<array.ml:60:12>>*/ caml_make_vect(sx, [0]),
      /*<<array.ml:61:2>>*/ _at_ = sx - 1 | 0,
      /*<<array.ml:60:12>>*/ _as_ = 0;
    if(_at_ >= 0){
     var x = _as_;
     for(;;){
      res[1 + x] =  /*<<array.ml:62:21>>*/ caml_make_vect(sy, init);
       /*<<array.ml:61:2>>*/  /*<<array.ml:61:2>>*/ var _au_ = x + 1 | 0;
      if(_at_ === x) break;
      var x = _au_;
     }
    }
     /*<<array.ml:64:2>>*/ return res;
    /*<<array.ml:64:5>>*/ }
   function copy(a){
     /*<<array.ml:67:2>>*/ var l = a.length - 1;
     /*<<array.ml:67:22>>*/ return 0 === l
            ? [0]
            :  /*<<array.ml:67:46>>*/ caml_array_sub(a, 0, l);
    /*<<array.ml:67:62>>*/ }
   function append(a1, a2){
     /*<<array.ml:70:2>>*/ var l1 = a1.length - 1;
     /*<<array.ml:71:2>>*/ return 0 === l1
            ? copy(a2)
            : 0
              === a2.length - 1
              ?  /*<<array.ml:72:29>>*/ caml_array_sub(a1, 0, l1)
              :  /*<<array.ml:73:7>>*/ runtime.caml_array_append(a1, a2);
    /*<<array.ml:73:24>>*/ }
   function sub(a, ofs, len){
     /*<<array.ml:76:2>>*/ if
     (0 <= ofs && 0 <= len && (a.length - 1 - len | 0) >= ofs)
      /*<<array.ml:78:7>>*/ return  /*<<array.ml:78:7>>*/ caml_array_sub
             (a, ofs, len);
     /*<<array.ml:77:7>>*/ return  /*<<array.ml:77:7>>*/ caml_call1
            (Stdlib[1], cst_Array_sub);
    /*<<array.ml:78:27>>*/ }
   function fill(a, ofs, len, v){
     /*<<array.ml:81:2>>*/ if
     (0 <= ofs && 0 <= len && (a.length - 1 - len | 0) >= ofs)
      /*<<array.ml:83:7>>*/ return  /*<<array.ml:83:7>>*/ runtime.caml_array_fill
             (a, ofs, len, v);
     /*<<array.ml:82:7>>*/ return  /*<<array.ml:82:7>>*/ caml_call1
            (Stdlib[1], cst_Array_fill);
    /*<<array.ml:83:30>>*/ }
   function blit(a1, ofs1, a2, ofs2, len){
     /*<<array.ml:86:2>>*/ if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (a1.length - 1 - len | 0) >= ofs1
        && 0 <= ofs2 && (a2.length - 1 - len | 0) >= ofs2)
      /*<<array.ml:89:7>>*/ return  /*<<array.ml:89:7>>*/ runtime.caml_array_blit
             (a1, ofs1, a2, ofs2, len);
     /*<<array.ml:88:7>>*/ return  /*<<array.ml:88:7>>*/ caml_call1
            (Stdlib[1], cst_Array_blit);
    /*<<array.ml:89:38>>*/ }
   function iter(f, a){
     /*<<array.ml:92:2>>*/ var
     _aq_ = a.length - 1 - 1 | 0,
      /*<<array.ml:92:2>>*/ _ap_ = 0;
    if(_aq_ >= 0){
     var i = _ap_;
     for(;;){
       /*<<array.ml:92:31>>*/  /*<<array.ml:92:31>>*/ caml_call1(f, a[1 + i]);
       /*<<array.ml:92:31>>*/  /*<<array.ml:92:31>>*/ var _ar_ = i + 1 | 0;
      if(_aq_ === i) break;
      var i = _ar_;
     }
    }
    return 0;
    /*<<array.ml:92:53>>*/ }
   function iter2(f, a, b){
     /*<<array.ml:95:2>>*/ if(a.length - 1 !== b.length - 1)
      /*<<array.ml:96:4>>*/ return  /*<<array.ml:96:4>>*/ caml_call1
             (Stdlib[1], cst_Array_iter2_arrays_must_ha);
     /*<<array.ml:98:4>>*/ var
     _an_ = a.length - 1 - 1 | 0,
      /*<<array.ml:98:4>>*/ _am_ = 0;
    if(_an_ >= 0){
     var i = _am_;
     for(;;){
       /*<<array.ml:98:33>>*/  /*<<array.ml:98:33>>*/ caml_call2
       (f, a[1 + i], b[1 + i]);
       /*<<array.ml:98:33>>*/  /*<<array.ml:98:33>>*/ var _ao_ = i + 1 | 0;
      if(_an_ === i) break;
      var i = _ao_;
     }
    }
    return 0;
    /*<<array.ml:98:73>>*/ }
   function map(f, a){
     /*<<array.ml:101:2>>*/ var l = a.length - 1;
     /*<<array.ml:102:2>>*/ if(0 === l)  /*<<array.ml:102:16>>*/ return [0];
     /*<<array.ml:103:12>>*/ var
      /*<<array.ml:103:12>>*/ r =
        /*<<array.ml:103:12>>*/ caml_make_vect
        (l,  /*<<array.ml:103:21>>*/ caml_call1(f, a[1])),
      /*<<array.ml:104:4>>*/ _ak_ = l - 1 | 0,
      /*<<array.ml:103:12>>*/ _aj_ = 1;
    if(_ak_ >= 1){
     var i = _aj_;
     for(;;){
       /*<<array.ml:105:6>>*/ r[1 + i] =
        /*<<array.ml:105:21>>*/ caml_call1(f, a[1 + i]);
       /*<<array.ml:105:6>>*/  /*<<array.ml:105:6>>*/ var _al_ = i + 1 | 0;
      if(_ak_ === i) break;
      var i = _al_;
     }
    }
     /*<<array.ml:107:4>>*/ return r;
    /*<<array.ml:108:5>>*/ }
   function map_inplace(f, a){
     /*<<array.ml:111:2>>*/ var
     _ah_ = a.length - 1 - 1 | 0,
      /*<<array.ml:111:2>>*/ _ag_ = 0;
    if(_ah_ >= 0){
     var i = _ag_;
     for(;;){
       /*<<array.ml:112:4>>*/ a[1 + i] =
        /*<<array.ml:112:19>>*/ caml_call1(f, a[1 + i]);
       /*<<array.ml:112:4>>*/  /*<<array.ml:112:4>>*/ var _ai_ = i + 1 | 0;
      if(_ah_ === i) break;
      var i = _ai_;
     }
    }
    return 0;
    /*<<array.ml:113:6>>*/ }
   function mapi_inplace(f, a){
     /*<<array.ml:116:2>>*/ var
     _ae_ = a.length - 1 - 1 | 0,
      /*<<array.ml:116:2>>*/ _ad_ = 0;
    if(_ae_ >= 0){
     var i = _ad_;
     for(;;){
       /*<<array.ml:117:4>>*/ a[1 + i] =
        /*<<array.ml:117:19>>*/ caml_call2(f, i, a[1 + i]);
       /*<<array.ml:117:4>>*/  /*<<array.ml:117:4>>*/ var _af_ = i + 1 | 0;
      if(_ae_ === i) break;
      var i = _af_;
     }
    }
    return 0;
    /*<<array.ml:118:6>>*/ }
   function map2(f, a, b){
     /*<<array.ml:121:2>>*/ var
     la = a.length - 1,
      /*<<array.ml:122:2>>*/ lb = b.length - 1;
    if(la !== lb)
      /*<<array.ml:124:4>>*/ return  /*<<array.ml:124:4>>*/ caml_call1
             (Stdlib[1], cst_Array_map2_arrays_must_hav);
    if(0 === la)  /*<<array.ml:126:19>>*/ return [0];
     /*<<array.ml:127:14>>*/ var
      /*<<array.ml:127:14>>*/ r =
        /*<<array.ml:127:14>>*/ caml_make_vect
        (la,  /*<<array.ml:127:24>>*/ caml_call2(f, a[1], b[1])),
      /*<<array.ml:128:6>>*/ _ab_ = la - 1 | 0,
      /*<<array.ml:127:14>>*/ _aa_ = 1;
    if(_ab_ >= 1){
     var i = _aa_;
     for(;;){
       /*<<array.ml:129:8>>*/ r[1 + i] =
        /*<<array.ml:129:23>>*/ caml_call2(f, a[1 + i], b[1 + i]);
       /*<<array.ml:129:8>>*/  /*<<array.ml:129:8>>*/ var _ac_ = i + 1 | 0;
      if(_ab_ === i) break;
      var i = _ac_;
     }
    }
     /*<<array.ml:131:6>>*/ return r;
    /*<<array.ml:133:5>>*/ }
   function iteri(f, a){
     /*<<array.ml:136:2>>*/ var
     ___ = a.length - 1 - 1 | 0,
      /*<<array.ml:136:2>>*/ _Z_ = 0;
    if(___ >= 0){
     var i = _Z_;
     for(;;){
       /*<<array.ml:136:31>>*/  /*<<array.ml:136:31>>*/ caml_call2
       (f, i, a[1 + i]);
       /*<<array.ml:136:31>>*/  /*<<array.ml:136:31>>*/ var _$_ = i + 1 | 0;
      if(___ === i) break;
      var i = _$_;
     }
    }
    return 0;
    /*<<array.ml:136:56>>*/ }
   function mapi(f, a){
     /*<<array.ml:139:2>>*/ var l = a.length - 1;
     /*<<array.ml:140:2>>*/ if(0 === l)  /*<<array.ml:140:16>>*/ return [0];
     /*<<array.ml:141:12>>*/ var
      /*<<array.ml:141:12>>*/ r =
        /*<<array.ml:141:12>>*/ caml_make_vect
        (l,  /*<<array.ml:141:21>>*/ caml_call2(f, 0, a[1])),
      /*<<array.ml:142:4>>*/ _X_ = l - 1 | 0,
      /*<<array.ml:141:12>>*/ _W_ = 1;
    if(_X_ >= 1){
     var i = _W_;
     for(;;){
       /*<<array.ml:143:6>>*/ r[1 + i] =
        /*<<array.ml:143:21>>*/ caml_call2(f, i, a[1 + i]);
       /*<<array.ml:143:6>>*/  /*<<array.ml:143:6>>*/ var _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
     /*<<array.ml:145:4>>*/ return r;
    /*<<array.ml:146:5>>*/ }
   function to_list(a){
     /*<<array.ml:149:2>>*/ var i$1 = a.length - 1 - 1 | 0, i = i$1, res = 0;
     /*<<array.ml:150:4>>*/ for(;;){
     if(0 > i)  /*<<array.ml:150:18>>*/ return res;
      /*<<array.ml:150:42>>*/ var
       /*<<array.ml:150:42>>*/ res$0 = [0, a[1 + i], res],
       /*<<array.ml:150:42>>*/ i$0 = i - 1 | 0,
      i = i$0,
      res = res$0;
    }
    /*<<array.ml:151:26>>*/ }
   function list_length(accu, param){
    var accu$0 = accu, param$0 = param;
    for(;;){
     if(! param$0)  /*<<array.ml:155:10>>*/ return accu$0;
      /*<<array.ml:156:12>>*/ var
      t = param$0[2],
       /*<<array.ml:156:12>>*/ accu$1 = accu$0 + 1 | 0,
      accu$0 = accu$1,
      param$0 = t;
    }
   }
   function of_list(l){
     /*<<array.ml:158:14>>*/ if(! l)  /*<<array.ml:159:10>>*/ return [0];
     /*<<array.ml:161:14>>*/ var
     tl = l[2],
     hd = l[1],
      /*<<array.ml:161:14>>*/ a =
        /*<<array.ml:161:14>>*/ caml_make_vect(list_length(0, l), hd),
     i = 1,
     param = tl;
    for(;;){
     if(! param)  /*<<array.ml:162:6>>*/ return a;
     var tl$0 = param[2], hd$0 = param[1];
      /*<<array.ml:164:20>>*/ a[1 + i] = hd$0;
      /*<<array.ml:162:6>>*/ var
       /*<<array.ml:162:6>>*/ i$0 = i + 1 | 0,
      i = i$0,
      param = tl$0;
    }
    /*<<array.ml:165:15>>*/ }
   function fold_left(f, x, a){
     /*<<array.ml:168:2>>*/ var
      /*<<array.ml:168:10>>*/ r = [0, x],
     _U_ = a.length - 1 - 1 | 0,
      /*<<array.ml:168:10>>*/ _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      r[1] =  /*<<array.ml:170:9>>*/ caml_call2(f, r[1], a[1 + i]);
       /*<<array.ml:169:2>>*/  /*<<array.ml:169:2>>*/ var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return r[1];
    /*<<array.ml:172:4>>*/ }
   function fold_left_map(f, acc, input_array){
     /*<<array.ml:175:2>>*/ var len = input_array.length - 1;
     /*<<array.ml:176:2>>*/ if(0 === len)
      /*<<array.ml:176:18>>*/ return [0, acc, [0]];
     /*<<array.ml:177:19>>*/ var
      /*<<array.ml:177:19>>*/ match =
        /*<<array.ml:177:19>>*/ caml_call2(f, acc, input_array[1]),
     elt = match[2],
     acc$0 = match[1],
      /*<<array.ml:178:23>>*/ output_array =
        /*<<array.ml:178:23>>*/ caml_make_vect(len, elt),
      /*<<array.ml:179:14>>*/ acc$1 = [0, acc$0],
      /*<<array.ml:180:4>>*/ _R_ = len - 1 | 0,
      /*<<array.ml:179:14>>*/ _Q_ = 1;
    if(_R_ >= 1){
     var i = _Q_;
     for(;;){
       /*<<array.ml:181:22>>*/ var
        /*<<array.ml:181:22>>*/ match$0 =
          /*<<array.ml:181:22>>*/ caml_call2(f, acc$1[1], input_array[1 + i]),
       elt$0 = match$0[2],
       acc$2 = match$0[1];
      acc$1[1] = acc$2;
       /*<<array.ml:183:6>>*/ output_array[1 + i] = elt$0;
       /*<<array.ml:180:4>>*/  /*<<array.ml:180:4>>*/ var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
     /*<<array.ml:185:4>>*/ return [0, acc$1[1], output_array];
    /*<<array.ml:186:5>>*/ }
   function fold_right(f, a, x){
     /*<<array.ml:189:2>>*/ var
      /*<<array.ml:189:10>>*/ r = [0, x],
      /*<<array.ml:190:2>>*/ _O_ = a.length - 1 - 1 | 0;
    if(_O_ >= 0){
     var i = _O_;
     for(;;){
      r[1] =  /*<<array.ml:191:9>>*/ caml_call2(f, a[1 + i], r[1]);
       /*<<array.ml:190:2>>*/  /*<<array.ml:190:2>>*/ var _P_ = i - 1 | 0;
      if(0 === i) break;
      var i = _P_;
     }
    }
    return r[1];
    /*<<array.ml:193:4>>*/ }
   function exists(p, a){
     /*<<array.ml:196:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:198:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:198:18>>*/ return 0;
      /*<<array.ml:199:12>>*/ if
      ( /*<<array.ml:199:12>>*/ caml_call1(p, a[1 + i]))
       /*<<array.ml:199:36>>*/ return 1;
      /*<<array.ml:200:9>>*/ var
       /*<<array.ml:200:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:201:8>>*/ }
   function for_all(p, a){
     /*<<array.ml:204:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:206:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:206:18>>*/ return 1;
      /*<<array.ml:207:12>>*/ if
      (!  /*<<array.ml:207:12>>*/ caml_call1(p, a[1 + i]))
       /*<<array.ml:208:9>>*/ return 0;
      /*<<array.ml:207:36>>*/ var
       /*<<array.ml:207:36>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:209:8>>*/ }
   function for_all2(p, l1, l2){
     /*<<array.ml:212:2>>*/ var n1 = l1.length - 1, n2 = l2.length - 1;
    if(n1 !== n2)
      /*<<array.ml:214:19>>*/ return  /*<<array.ml:214:19>>*/ caml_call1
             (Stdlib[1], cst_Array_for_all2);
    var i = 0;
     /*<<array.ml:216:4>>*/ for(;;){
     if(i === n1)  /*<<array.ml:216:19>>*/ return 1;
      /*<<array.ml:217:12>>*/ if
      (!  /*<<array.ml:217:12>>*/ caml_call2(p, l1[1 + i], l2[1 + i]))
       /*<<array.ml:218:9>>*/ return 0;
      /*<<array.ml:217:55>>*/ var
       /*<<array.ml:217:55>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:219:8>>*/ }
   function exists2(p, l1, l2){
     /*<<array.ml:222:2>>*/ var n1 = l1.length - 1, n2 = l2.length - 1;
    if(n1 !== n2)
      /*<<array.ml:224:19>>*/ return  /*<<array.ml:224:19>>*/ caml_call1
             (Stdlib[1], cst_Array_exists2);
    var i = 0;
     /*<<array.ml:226:4>>*/ for(;;){
     if(i === n1)  /*<<array.ml:226:19>>*/ return 0;
      /*<<array.ml:227:12>>*/ if
      ( /*<<array.ml:227:12>>*/ caml_call2(p, l1[1 + i], l2[1 + i]))
       /*<<array.ml:227:55>>*/ return 1;
      /*<<array.ml:228:9>>*/ var
       /*<<array.ml:228:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:229:8>>*/ }
   function mem(x, a){
     /*<<array.ml:232:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:234:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:234:18>>*/ return 0;
      /*<<array.ml:235:12>>*/ if
      (0 ===  /*<<array.ml:235:12>>*/ runtime.caml_compare(a[1 + i], x))
       /*<<array.ml:235:48>>*/ return 1;
      /*<<array.ml:236:9>>*/ var
       /*<<array.ml:236:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:237:8>>*/ }
   function memq(x, a){
     /*<<array.ml:240:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:242:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:242:18>>*/ return 0;
     if(x === a[1 + i])  /*<<array.ml:243:39>>*/ return 1;
      /*<<array.ml:244:9>>*/ var
       /*<<array.ml:244:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:245:8>>*/ }
   function find_opt(p, a){
     /*<<array.ml:248:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:250:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:250:18>>*/ return 0;
      /*<<array.ml:252:14>>*/  /*<<array.ml:252:14>>*/ var x = a[1 + i];
      /*<<array.ml:253:9>>*/ if( /*<<array.ml:253:9>>*/ caml_call1(p, x))
       /*<<array.ml:253:18>>*/ return [0, x];
      /*<<array.ml:254:11>>*/ var
       /*<<array.ml:254:11>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:256:8>>*/ }
   function find_index(p, a){
     /*<<array.ml:259:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:261:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:261:18>>*/ return 0;
      /*<<array.ml:262:12>>*/ if
      ( /*<<array.ml:262:12>>*/ caml_call1(p, a[1 + i]))
       /*<<array.ml:262:36>>*/ return [0, i];
      /*<<array.ml:263:9>>*/ var
       /*<<array.ml:263:9>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:264:8>>*/ }
   function find_map(f, a){
     /*<<array.ml:267:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:269:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:269:18>>*/ return 0;
      /*<<array.ml:271:12>>*/  /*<<array.ml:271:12>>*/ var
      r =  /*<<array.ml:271:12>>*/ caml_call1(f, a[1 + i]);
     if(r)  /*<<array.ml:273:23>>*/ return r;
      /*<<array.ml:272:16>>*/ var
       /*<<array.ml:272:16>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:275:8>>*/ }
   function find_mapi(f, a){
     /*<<array.ml:278:2>>*/ var n = a.length - 1, i = 0;
     /*<<array.ml:280:4>>*/ for(;;){
     if(i === n)  /*<<array.ml:280:18>>*/ return 0;
      /*<<array.ml:282:12>>*/  /*<<array.ml:282:12>>*/ var
      r =  /*<<array.ml:282:12>>*/ caml_call2(f, i, a[1 + i]);
     if(r)  /*<<array.ml:284:23>>*/ return r;
      /*<<array.ml:283:16>>*/ var
       /*<<array.ml:283:16>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<array.ml:286:8>>*/ }
   function split(x){
     /*<<array.ml:289:2>>*/ if
     ( /*<<array.ml:289:5>>*/ runtime.caml_equal(x, [0]))
      /*<<array.ml:289:19>>*/ return [0, [0], [0]];
     /*<<array.ml:292:4>>*/ var
     match = x[1],
     b0 = match[2],
     a0 = match[1],
      /*<<array.ml:292:4>>*/ n = x.length - 1,
      /*<<array.ml:293:12>>*/ a =
        /*<<array.ml:293:12>>*/ caml_make_vect(n, a0),
      /*<<array.ml:294:12>>*/ b =
        /*<<array.ml:294:12>>*/ caml_make_vect(n, b0),
      /*<<array.ml:295:4>>*/ _M_ = n - 1 | 0,
      /*<<array.ml:294:12>>*/ _L_ = 1;
    if(_M_ >= 1){
     var i = _L_;
     for(;;){
      var match$0 = x[1 + i], bi = match$0[2], ai = match$0[1];
       /*<<array.ml:297:6>>*/ a[1 + i] = ai;
       /*<<array.ml:298:6>>*/ b[1 + i] = bi;
       /*<<array.ml:295:4>>*/  /*<<array.ml:295:4>>*/ var _N_ = i + 1 | 0;
      if(_M_ === i) break;
      var i = _N_;
     }
    }
     /*<<array.ml:300:4>>*/ return [0, a, b];
    /*<<array.ml:301:5>>*/ }
   function combine(a, b){
     /*<<array.ml:304:2>>*/ var
     na = a.length - 1,
      /*<<array.ml:305:2>>*/ nb = b.length - 1;
    if(na !== nb)
      /*<<array.ml:306:19>>*/  /*<<array.ml:306:19>>*/ caml_call1
      (Stdlib[1], cst_Array_combine);
    if(0 === na)  /*<<array.ml:307:17>>*/ return [0];
     /*<<array.ml:309:12>>*/ var
      /*<<array.ml:309:12>>*/ x =
        /*<<array.ml:309:12>>*/ caml_make_vect(na, [0, a[1], b[1]]),
      /*<<array.ml:310:4>>*/ _J_ = na - 1 | 0,
      /*<<array.ml:309:12>>*/ _I_ = 1;
    if(_J_ >= 1){
     var i = _I_;
     for(;;){
      x[1 + i] = [0, a[1 + i], b[1 + i]];
       /*<<array.ml:310:4>>*/  /*<<array.ml:310:4>>*/ var _K_ = i + 1 | 0;
      if(_J_ === i) break;
      var i = _K_;
     }
    }
     /*<<array.ml:313:4>>*/ return x;
    /*<<array.ml:314:5>>*/ }
    /*<<array.ml:316:0>>*/ var
     /*<<array.ml:316:0>>*/ Bottom =
      [248, "Stdlib.Array.Bottom", runtime.caml_fresh_oo_id(0)],
    _a_ = [0, "array.ml", 348, 4];
   function sort(cmp, a){
    function maxson(l, i){
      /*<<array.ml:319:4>>*/ var
      i31 = ((i + i | 0) + i | 0) + 1 | 0,
       /*<<array.ml:320:12>>*/ x = [0, i31];
     if((i31 + 2 | 0) < l){
       /*<<array.ml:321:22>>*/ var
        /*<<array.ml:321:22>>*/ _B_ = i31 + 1 | 0,
        /*<<array.ml:322:25>>*/ _C_ = caml_check_bound(a, _B_)[1 + _B_];
      if
       ( /*<<array.ml:322:9>>*/ caml_call2
         (cmp, caml_check_bound(a, i31)[1 + i31], _C_)
        < 0)
       x[1] = i31 + 1 | 0;
       /*<<array.ml:323:6>>*/ var
        /*<<array.ml:323:6>>*/ _D_ = i31 + 2 | 0,
        /*<<array.ml:323:24>>*/ _E_ = caml_check_bound(a, _D_)[1 + _D_],
       _F_ = x[1];
      if
       ( /*<<array.ml:323:9>>*/ caml_call2
         (cmp, caml_check_bound(a, _F_)[1 + _F_], _E_)
        < 0)
       x[1] = i31 + 2 | 0;
      return x[1];
     }
     if((i31 + 1 | 0) < l){
       /*<<array.ml:326:38>>*/ var
       _G_ = i31 + 1 | 0,
        /*<<array.ml:326:38>>*/ _H_ = caml_check_bound(a, _G_)[1 + _G_];
       /*<<array.ml:326:22>>*/ if
       (0
        >
          /*<<array.ml:326:22>>*/ caml_call2
          (cmp, caml_check_bound(a, i31)[1 + i31], _H_))
        /*<<array.ml:327:11>>*/ return i31 + 1 | 0;
     }
     if(i31 < l)  /*<<array.ml:328:27>>*/ return i31;
      /*<<array.ml:328:36>>*/ throw  /*<<array.ml:328:36>>*/ caml_maybe_attach_backtrace
            ([0, Bottom, i], 1);
     /*<<array.ml:328:52>>*/ }
    var l = a.length - 1, _v_ = ((l + 1 | 0) / 3 | 0) - 1 | 0;
    if(_v_ >= 0){
     var i$6 = _v_;
     for(;;){
       /*<<array.ml:357:50>>*/  /*<<array.ml:357:50>>*/ var
       e$1 = caml_check_bound(a, i$6)[1 + i$6];
       /*<<array.ml:339:22>>*/ try{
       var i = i$6;
        /*<<array.ml:331:4>>*/ for(;;){
         /*<<array.ml:331:12>>*/  /*<<array.ml:331:12>>*/ var
         j = maxson(l, i);
         /*<<array.ml:332:7>>*/ if
         (0
          >=
            /*<<array.ml:332:7>>*/ caml_call2
            (cmp, caml_check_bound(a, j)[1 + j], e$1))
         break;
         /*<<array.ml:333:14>>*/  /*<<array.ml:333:14>>*/ var
         _s_ = caml_check_bound(a, j)[1 + j];
         /*<<array.ml:333:6>>*/ caml_check_bound(a, i)[1 + i] = _s_;
        var i = j;
       }
        /*<<array.ml:335:13>>*/ caml_check_bound(a, i)[1 + i] = e$1;
      }
      catch(exn$0){
       var exn = caml_wrap_exception(exn$0);
       if(exn[1] !== Bottom) throw caml_maybe_attach_backtrace(exn, 0);
       var i$0 = exn[2];
        /*<<array.ml:339:61>>*/ caml_check_bound(a, i$0)[1 + i$0] = e$1;
      }
       /*<<array.ml:357:38>>*/  /*<<array.ml:357:38>>*/ var _A_ = i$6 - 1 | 0;
      if(0 === i$6) break;
      var i$6 = _A_;
     }
    }
     /*<<array.ml:358:2>>*/  /*<<array.ml:358:2>>*/ var _w_ = l - 1 | 0;
    if(_w_ >= 2){
     var i$4 = _w_;
     for(;;){
       /*<<array.ml:359:12>>*/  /*<<array.ml:359:12>>*/ var
       e$0 = caml_check_bound(a, i$4)[1 + i$4];
       /*<<array.ml:360:4>>*/ a[1 + i$4] = caml_check_bound(a, 0)[1];
      var i$5 = 0;
       /*<<array.ml:345:19>>*/ try{
       var i$1 = i$5;
        /*<<array.ml:341:4>>*/ for(;;){
         /*<<array.ml:341:12>>*/ var
          /*<<array.ml:341:12>>*/ j$0 = maxson(i$4, i$1),
          /*<<array.ml:342:12>>*/ _t_ = caml_check_bound(a, j$0)[1 + j$0];
         /*<<array.ml:342:4>>*/ caml_check_bound(a, i$1)[1 + i$1] = _t_;
        var i$1 = j$0;
       }
      }
      catch(exn){
       var exn$0 = caml_wrap_exception(exn);
       if(exn$0[1] !== Bottom) throw caml_maybe_attach_backtrace(exn$0, 0);
       var i$2 = exn$0[2];
       a:
       {
        b:
        {
         var i$3 = i$2;
          /*<<array.ml:347:4>>*/ for(;;){
          var father = (i$3 - 1 | 0) / 3 | 0;
          if(i$3 === father)
            /*<<array.ml:348:4>>*/ throw  /*<<array.ml:348:4>>*/ caml_maybe_attach_backtrace
                  ([0, Assert_failure, _a_], 1);
           /*<<array.ml:349:7>>*/ if
           (0
            <=
              /*<<array.ml:349:7>>*/ caml_call2
              (cmp, caml_check_bound(a, father)[1 + father], e$0))
           break;
           /*<<array.ml:350:14>>*/  /*<<array.ml:350:14>>*/ var
           _u_ = caml_check_bound(a, father)[1 + father];
           /*<<array.ml:350:6>>*/ caml_check_bound(a, i$3)[1 + i$3] = _u_;
          if(0 >= father) break b;
          var i$3 = father;
         }
          /*<<array.ml:352:13>>*/ caml_check_bound(a, i$3)[1 + i$3] = e$0;
         break a;
        }
         /*<<array.ml:351:49>>*/ caml_check_bound(a, 0)[1] = e$0;
       }
        /*<<array.ml:358:2>>*/  /*<<array.ml:358:2>>*/ var _z_ = i$4 - 1 | 0;
       if(2 === i$4) break;
       var i$4 = _z_;
      }
     }
    }
    var _x_ = 1 < l ? 1 : 0;
    if(_x_){
      /*<<array.ml:363:25>>*/  /*<<array.ml:363:25>>*/ var
      e = caml_check_bound(a, 1)[2];
      /*<<array.ml:363:38>>*/ a[2] = caml_check_bound(a, 0)[1];
      /*<<array.ml:363:57>>*/ a[1] = e;
     var _y_ = 0;
    }
    else
     var _y_ = _x_;
     /*<<array.ml:363:57>>*/ return _y_;
    /*<<array.ml:363:67>>*/ }
   function stable_sort(cmp, a){
    function merge(src1ofs, src1len, src2, src2ofs, src2len, dst, dstofs){
      /*<<array.ml:369:4>>*/ var
      src1r = src1ofs + src1len | 0,
      src2r = src2ofs + src2len | 0,
       /*<<array.ml:386:44>>*/ s2$1 =
        caml_check_bound(src2, src2ofs)[1 + src2ofs],
       /*<<array.ml:386:20>>*/ s1$1 =
        caml_check_bound(a, src1ofs)[1 + src1ofs],
      i1 = src1ofs,
      s1 = s1$1,
      i2 = src2ofs,
      s2 = s2$1,
      d = dstofs;
      /*<<array.ml:371:6>>*/ for(;;)
       /*<<array.ml:371:9>>*/ if
       (0 <  /*<<array.ml:371:9>>*/ caml_call2(cmp, s1, s2)){
        /*<<array.ml:379:8>>*/ caml_check_bound(dst, d)[1 + d] = s2;
        /*<<array.ml:379:8>>*/  /*<<array.ml:379:8>>*/ var i2$0 = i2 + 1 | 0;
       if(i2$0 >= src2r) return blit(a, i1, dst, d + 1 | 0, src1r - i1 | 0);
        /*<<array.ml:382:10>>*/ var
         /*<<array.ml:382:10>>*/ d$0 = d + 1 | 0,
         /*<<array.ml:382:24>>*/ s2$0 = caml_check_bound(src2, i2$0)[1 + i2$0],
        i2 = i2$0,
        s2 = s2$0,
        d = d$0;
      }
      else{
        /*<<array.ml:372:8>>*/ caml_check_bound(dst, d)[1 + d] = s1;
        /*<<array.ml:372:8>>*/  /*<<array.ml:372:8>>*/ var i1$0 = i1 + 1 | 0;
       if(i1$0 >= src1r)
        return blit(src2, i2, dst, d + 1 | 0, src2r - i2 | 0);
        /*<<array.ml:375:10>>*/ var
         /*<<array.ml:375:10>>*/ d$1 = d + 1 | 0,
         /*<<array.ml:375:18>>*/ s1$0 = caml_check_bound(a, i1$0)[1 + i1$0],
        i1 = i1$0,
        s1 = s1$0,
        d = d$1;
      }
     /*<<array.ml:386:70>>*/ }
    function isortto(srcofs, dst, dstofs, len){
      /*<<array.ml:389:4>>*/ var
      _k_ = len - 1 | 0,
       /*<<array.ml:389:4>>*/ _j_ = 0;
     if(_k_ >= 0){
      var i = _j_;
      for(;;){
        /*<<array.ml:390:14>>*/ var
        _l_ = srcofs + i | 0,
         /*<<array.ml:390:14>>*/ e = caml_check_bound(a, _l_)[1 + _l_],
         /*<<array.ml:391:14>>*/ j = [0, (dstofs + i | 0) - 1 | 0];
       for(;;){
        if(dstofs > j[1]) break;
        var _m_ = j[1];
         /*<<array.ml:392:29>>*/ if
         (0
          >=
            /*<<array.ml:392:29>>*/ caml_call2
            (cmp, caml_check_bound(dst, _m_)[1 + _m_], e))
         break;
         /*<<array.ml:393:25>>*/ var
         _n_ = j[1],
          /*<<array.ml:393:25>>*/ _o_ = caml_check_bound(dst, _n_)[1 + _n_],
         _p_ = j[1] + 1 | 0;
         /*<<array.ml:393:8>>*/ caml_check_bound(dst, _p_)[1 + _p_] = _o_;
        j[1] += -1;
       }
       var _q_ = j[1] + 1 | 0;
        /*<<array.ml:396:6>>*/ caml_check_bound(dst, _q_)[1 + _q_] = e;
        /*<<array.ml:389:4>>*/  /*<<array.ml:389:4>>*/ var _r_ = i + 1 | 0;
       if(_k_ === i) break;
       var i = _r_;
      }
     }
     return 0;
     /*<<array.ml:397:8>>*/ }
    function sortto(srcofs, dst, dstofs, len){
      /*<<array.ml:400:4>>*/ if(len <= 5)
       /*<<array.ml:400:26>>*/ return isortto(srcofs, dst, dstofs, len);
     var l1 = len / 2 | 0, l2 = len - l1 | 0;
      /*<<array.ml:403:6>>*/ sortto(srcofs + l1 | 0, dst, dstofs + l1 | 0, l2);
      /*<<array.ml:404:6>>*/ sortto(srcofs, a, srcofs + l2 | 0, l1);
      /*<<array.ml:404:6>>*/ return merge
             (srcofs + l2 | 0, l1, dst, dstofs + l1 | 0, l2, dst, dstofs);
     /*<<array.ml:406:7>>*/ }
    var l = a.length - 1;
    if(l <= 5)  /*<<array.ml:409:22>>*/ return isortto(0, a, 0, l);
     /*<<array.ml:412:12>>*/ var
     l1 = l / 2 | 0,
     l2 = l - l1 | 0,
      /*<<array.ml:412:12>>*/ t =
        /*<<array.ml:412:12>>*/ caml_make_vect(l2, caml_check_bound(a, 0)[1]);
     /*<<array.ml:413:4>>*/ sortto(l1, t, 0, l2);
     /*<<array.ml:414:4>>*/ sortto(0, a, l2, l1);
     /*<<array.ml:414:4>>*/ return merge(l2, l1, t, 0, l2, a, 0);
    /*<<array.ml:416:5>>*/ }
   function to_seq(a){
    function aux(i, param){
      /*<<array.ml:425:4>>*/ if(i >= a.length - 1)
       /*<<array.ml:429:9>>*/ return 0;
      /*<<array.ml:427:14>>*/ var
       /*<<array.ml:427:14>>*/ x = a[1 + i],
       /*<<array.ml:427:14>>*/ _h_ = i + 1 | 0;
      /*<<array.ml:428:6>>*/ return [0,
             x,
             function(_i_){ /*<<?>>*/ return aux(_h_, _i_);}];
     /*<<array.ml:429:16>>*/ }
     /*<<array.ml:431:2>>*/ var _f_ = 0;
     /*<<array.ml:431:2>>*/ return function(_g_){
      /*<<?>>*/ return aux(_f_, _g_);};
    /*<<array.ml:431:7>>*/ }
   function to_seqi(a){
    function aux(i, param){
      /*<<array.ml:435:4>>*/ if(i >= a.length - 1)
       /*<<array.ml:439:9>>*/ return 0;
      /*<<array.ml:437:14>>*/ var
       /*<<array.ml:437:14>>*/ x = a[1 + i],
       /*<<array.ml:437:14>>*/ _d_ = i + 1 | 0;
      /*<<array.ml:438:6>>*/ return [0,
             [0, i, x],
             function(_e_){ /*<<?>>*/ return aux(_d_, _e_);}];
     /*<<array.ml:439:16>>*/ }
     /*<<array.ml:441:2>>*/ var _b_ = 0;
     /*<<array.ml:441:2>>*/ return function(_c_){
      /*<<?>>*/ return aux(_b_, _c_);};
    /*<<array.ml:441:7>>*/ }
   function of_seq(i$2){
     /*<<array.ml:455:2>>*/  /*<<array.ml:455:10>>*/ var
     l =
        /*<<array.ml:455:10>>*/ caml_call3
        (Stdlib_Seq[5],
         function(acc, x){
           /*<<array.ml:455:38>>*/ return [0, x, acc];
          /*<<array.ml:455:44>>*/ },
         0,
         i$2);
    if(! l)  /*<<array.ml:444:10>>*/ return [0];
     /*<<array.ml:446:16>>*/ var
     tl = l[2],
     hd = l[1],
      /*<<array.ml:446:16>>*/ len = list_length(0, l),
      /*<<array.ml:447:14>>*/ a =
        /*<<array.ml:447:14>>*/ caml_make_vect(len, hd),
      /*<<array.ml:446:16>>*/ i$1 = len - 2 | 0,
     i = i$1,
     param = tl;
    for(;;){
     if(! param)  /*<<array.ml:448:6>>*/ return a;
     var tl$0 = param[2], hd$0 = param[1];
      /*<<array.ml:450:20>>*/ a[1 + i] = hd$0;
      /*<<array.ml:448:6>>*/ var
       /*<<array.ml:448:6>>*/ i$0 = i - 1 | 0,
      i = i$0,
      param = tl$0;
    }
    /*<<array.ml:456:15>>*/ }
   var
    Stdlib_Array =
      [0,
       init,
       make_matrix,
       append,
       runtime.caml_array_concat,
       sub,
       copy,
       fill,
       blit,
       to_list,
       of_list,
       iter,
       iteri,
       map,
       map_inplace,
       mapi,
       mapi_inplace,
       fold_left,
       fold_left_map,
       fold_right,
       iter2,
       map2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find_opt,
       find_index,
       find_map,
       find_mapi,
       split,
       combine,
       sort,
       stable_sort,
       stable_sort,
       to_seq,
       to_seqi,
       of_seq,
       Floatarray];
   runtime.caml_register_global(14, Stdlib_Array, "Stdlib__Array");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Float
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__List, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Float_array_blit$1 = "Float.array.blit",
    cst_float_ml = "float.ml",
    caml_array_get = runtime.caml_array_get,
    caml_array_set = runtime.caml_array_set,
    caml_float_compare = runtime.caml_float_compare,
    caml_floatarray_blit = runtime.caml_floatarray_blit,
    caml_floatarray_create = runtime.caml_floatarray_create,
    caml_hash = runtime.caml_hash,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_nextafter_float = runtime.caml_nextafter_float,
    caml_signbit_float = runtime.caml_signbit_float,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<float.ml:38:20>>*/ var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    Assert_failure = global_data.Assert_failure,
    Stdlib = global_data.Stdlib,
    infinity = Stdlib[22],
    neg_infinity = Stdlib[23],
    nan = Stdlib[24],
     /*<<float.ml:38:20>>*/ signaling_nan =
       /*<<float.ml:38:20>>*/ runtime.caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(1, 0, 32752));
   function is_finite(x){
     /*<<float.ml:39:27>>*/ return x - x == 0. ? 1 : 0;
    /*<<float.ml:39:38>>*/ }
   function is_infinite(x){
     /*<<float.ml:40:29>>*/ return 1. / x == 0. ? 1 : 0;
    /*<<float.ml:40:41>>*/ }
   function is_nan(x){
     /*<<float.ml:41:24>>*/ return x != x ? 1 : 0;
    /*<<float.ml:41:30>>*/ }
   var
    max_float = Stdlib[25],
    min_float = Stdlib[26],
    epsilon = Stdlib[27],
    of_string_opt = Stdlib[36],
    to_string = Stdlib[35],
    cst_Float_Array_init = "Float.Array.init",
    cst_Float_Array_concat = "Float.Array.concat",
    _a_ = [0, cst_float_ml, 228, 14],
    cst_Float_Array_sub = "Float.Array.sub",
    cst_Float_Array_fill = "Float.Array.fill",
    cst_Float_array_blit = cst_Float_array_blit$1,
    cst_Float_array_blit$0 = cst_Float_array_blit$1,
    cst_Float_Array_iter2_arrays_m =
      "Float.Array.iter2: arrays must have the same length",
    cst_Float_Array_map2_arrays_mu =
      "Float.Array.map2: arrays must have the same length";
   function is_integer(x){
     /*<<float.ml:116:19>>*/ var
     _am_ = x ==  /*<<float.ml:116:23>>*/ runtime.caml_trunc_float(x) ? 1 : 0;
    return _am_ ? is_finite(x) : _am_;
    /*<<float.ml:116:45>>*/ }
   function succ(x){
     /*<<float.ml:121:13>>*/ return  /*<<float.ml:121:13>>*/ caml_nextafter_float
            (x, infinity);
    /*<<float.ml:121:34>>*/ }
   function pred(x){
     /*<<float.ml:122:13>>*/ return  /*<<float.ml:122:13>>*/ caml_nextafter_float
            (x, neg_infinity);
    /*<<float.ml:122:38>>*/ }
   function equal(x, y){
     /*<<float.ml:136:16>>*/ return 0 === caml_float_compare(x, y) ? 1 : 0;
    /*<<float.ml:136:31>>*/ }
   function min(x, y){
     /*<<float.ml:139:2>>*/ a:
    if(! (x < y)){
      /*<<float.ml:139:34>>*/ if
      (!
        /*<<float.ml:139:18>>*/ caml_signbit_float(y)
       &&  /*<<float.ml:139:34>>*/ caml_signbit_float(x))
      break a;
      /*<<float.ml:141:10>>*/ return x != x ? x : y;
    }
     /*<<float.ml:140:7>>*/ return y != y ? y : x;
    /*<<float.ml:141:32>>*/ }
   function max(x, y){
     /*<<float.ml:144:2>>*/ a:
    if(! (x < y)){
      /*<<float.ml:144:34>>*/ if
      (!
        /*<<float.ml:144:18>>*/ caml_signbit_float(y)
       &&  /*<<float.ml:144:34>>*/ caml_signbit_float(x))
      break a;
      /*<<float.ml:146:10>>*/ return y != y ? y : x;
    }
     /*<<float.ml:145:7>>*/ return x != x ? x : y;
    /*<<float.ml:146:32>>*/ }
   function min_max(x, y){
     /*<<float.ml:149:2>>*/ if(x == x && y == y){
     a:
     if(! (x < y)){
       /*<<float.ml:150:39>>*/ if
       (!
         /*<<float.ml:150:23>>*/ caml_signbit_float(y)
        &&  /*<<float.ml:150:39>>*/ caml_signbit_float(x))
       break a;
       /*<<float.ml:150:68>>*/ return [0, y, x];
     }
      /*<<float.ml:150:56>>*/ return [0, x, y];
    }
     /*<<float.ml:149:31>>*/ return [0, nan, nan];
    /*<<float.ml:150:74>>*/ }
   function min_num(x, y){
     /*<<float.ml:153:2>>*/ a:
    if(! (x < y)){
      /*<<float.ml:153:34>>*/ if
      (!
        /*<<float.ml:153:18>>*/ caml_signbit_float(y)
       &&  /*<<float.ml:153:34>>*/ caml_signbit_float(x))
      break a;
      /*<<float.ml:155:10>>*/ return y != y ? x : y;
    }
     /*<<float.ml:154:7>>*/ return x != x ? y : x;
    /*<<float.ml:155:32>>*/ }
   function max_num(x, y){
     /*<<float.ml:158:2>>*/ a:
    if(! (x < y)){
      /*<<float.ml:158:34>>*/ if
      (!
        /*<<float.ml:158:18>>*/ caml_signbit_float(y)
       &&  /*<<float.ml:158:34>>*/ caml_signbit_float(x))
      break a;
      /*<<float.ml:160:10>>*/ return x != x ? y : x;
    }
     /*<<float.ml:159:7>>*/ return y != y ? x : y;
    /*<<float.ml:160:32>>*/ }
   function min_max_num(x, y){
     /*<<float.ml:163:2>>*/ if(x != x)
      /*<<float.ml:163:19>>*/ return [0, y, y];
     /*<<float.ml:164:10>>*/ if(y != y)
      /*<<float.ml:164:24>>*/ return [0, x, x];
    a:
    if(! (x < y)){
      /*<<float.ml:165:39>>*/ if
      (!
        /*<<float.ml:165:23>>*/ caml_signbit_float(y)
       &&  /*<<float.ml:165:39>>*/ caml_signbit_float(x))
      break a;
      /*<<float.ml:165:67>>*/ return [0, y, x];
    }
     /*<<float.ml:165:56>>*/ return [0, x, y];
    /*<<float.ml:165:72>>*/ }
   function seeded_hash(seed, x){
     /*<<float.ml:169:25>>*/ return  /*<<float.ml:169:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<float.ml:169:56>>*/ }
   function hash(x){
     /*<<float.ml:170:13>>*/ return  /*<<float.ml:170:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<float.ml:170:41>>*/ }
   function unsafe_fill(a, ofs, len, v){
     /*<<float.ml:184:4>>*/ var _ak_ = (ofs + len | 0) - 1 | 0;
    if(_ak_ >= ofs){
     var i = ofs;
     for(;;){
       /*<<float.ml:184:36>>*/ a[1 + i] = v;
       /*<<float.ml:184:36>>*/  /*<<float.ml:184:36>>*/ var _al_ = i + 1 | 0;
      if(_ak_ === i) break;
      var i = _al_;
     }
    }
    return 0;
    /*<<float.ml:184:57>>*/ }
   function check(a, ofs, len, msg){
     /*<<float.ml:190:4>>*/ var _ag_ = ofs < 0 ? 1 : 0;
    if(_ag_)
     var _ah_ = _ag_;
    else{
     var _ai_ = len < 0 ? 1 : 0;
     if(_ai_)
      var _ah_ = _ai_;
     else
      var
       _aj_ = (ofs + len | 0) < 0 ? 1 : 0,
       _ah_ = _aj_ || (a.length - 1 < (ofs + len | 0) ? 1 : 0);
    }
    return _ah_ ?  /*<<float.ml:191:6>>*/ caml_call1(Stdlib[1], msg) : _ah_;
    /*<<float.ml:191:21>>*/ }
   function make(n, v){
     /*<<float.ml:194:4>>*/  /*<<float.ml:194:17>>*/ var
     result =  /*<<float.ml:194:17>>*/ caml_floatarray_create(n);
     /*<<float.ml:195:4>>*/ unsafe_fill(result, 0, n, v);
     /*<<float.ml:195:4>>*/ return result;
    /*<<float.ml:196:10>>*/ }
   function init(l, f){
     /*<<float.ml:199:4>>*/ if(0 > l)
      /*<<float.ml:199:18>>*/ return  /*<<float.ml:199:18>>*/ caml_call1
             (Stdlib[1], cst_Float_Array_init);
     /*<<float.ml:201:16>>*/ var
      /*<<float.ml:201:16>>*/ res =
        /*<<float.ml:201:16>>*/ caml_floatarray_create(l),
      /*<<float.ml:202:6>>*/ _ae_ = l - 1 | 0,
      /*<<float.ml:201:16>>*/ _ad_ = 0;
    if(_ae_ >= 0){
     var i = _ad_;
     for(;;){
       /*<<float.ml:203:8>>*/ res[1 + i] =
        /*<<float.ml:203:25>>*/ caml_call1(f, i);
       /*<<float.ml:203:8>>*/  /*<<float.ml:203:8>>*/ var _af_ = i + 1 | 0;
      if(_ae_ === i) break;
      var i = _af_;
     }
    }
     /*<<float.ml:205:6>>*/ return res;
    /*<<float.ml:205:9>>*/ }
   function append(a1, a2){
     /*<<float.ml:208:4>>*/ var
     l1 = a1.length - 1,
      /*<<float.ml:209:4>>*/ l2 = a2.length - 1,
      /*<<float.ml:210:17>>*/ result =
        /*<<float.ml:210:17>>*/ caml_floatarray_create(l1 + l2 | 0);
     /*<<float.ml:211:4>>*/  /*<<float.ml:211:4>>*/ caml_floatarray_blit
     (a1, 0, result, 0, l1);
     /*<<float.ml:212:4>>*/  /*<<float.ml:212:4>>*/ caml_floatarray_blit
     (a2, 0, result, l1, l2);
     /*<<float.ml:212:4>>*/ return result;
    /*<<float.ml:213:10>>*/ }
   function concat(l){
     /*<<float.ml:224:4>>*/ var acc = 0, param = l;
    for(;;){
     if(! param) break;
     var
      tl = param[2],
      hd = param[1],
      x = hd.length - 1 + acc | 0,
      acc$0 =
        acc <= x
         ? x
         :  /*<<float.ml:217:26>>*/ caml_call1
           (Stdlib[1], cst_Float_Array_concat),
      acc = acc$0,
      param = tl;
    }
     /*<<float.ml:225:17>>*/ var
      /*<<float.ml:225:17>>*/ result =
        /*<<float.ml:225:17>>*/ caml_floatarray_create(acc),
     l$0 = l,
     i = 0;
     /*<<float.ml:227:6>>*/ for(;;){
     if(! l$0){
      if(i === acc)  /*<<float.ml:234:4>>*/ return result;
       /*<<float.ml:228:14>>*/ throw  /*<<float.ml:228:14>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _a_], 1);
     }
      /*<<float.ml:230:8>>*/ var
      tl$0 = l$0[2],
      hd$0 = l$0[1],
       /*<<float.ml:230:8>>*/ hlen = hd$0.length - 1;
      /*<<float.ml:231:8>>*/  /*<<float.ml:231:8>>*/ caml_floatarray_blit
      (hd$0, 0, result, i, hlen);
     var i$0 = i + hlen | 0, l$0 = tl$0, i = i$0;
    }
    /*<<float.ml:235:10>>*/ }
   function sub(a, ofs, len){
     /*<<float.ml:238:4>>*/ check(a, ofs, len, cst_Float_Array_sub);
     /*<<float.ml:239:17>>*/  /*<<float.ml:239:17>>*/ var
     result =  /*<<float.ml:239:17>>*/ caml_floatarray_create(len);
     /*<<float.ml:240:4>>*/  /*<<float.ml:240:4>>*/ caml_floatarray_blit
     (a, ofs, result, 0, len);
     /*<<float.ml:240:4>>*/ return result;
    /*<<float.ml:241:10>>*/ }
   function copy(a){
     /*<<float.ml:244:4>>*/ var
     l = a.length - 1,
      /*<<float.ml:245:17>>*/ result =
        /*<<float.ml:245:17>>*/ caml_floatarray_create(l);
     /*<<float.ml:246:4>>*/  /*<<float.ml:246:4>>*/ caml_floatarray_blit
     (a, 0, result, 0, l);
     /*<<float.ml:246:4>>*/ return result;
    /*<<float.ml:247:10>>*/ }
   function fill(a, ofs, len, v){
     /*<<float.ml:250:4>>*/ check(a, ofs, len, cst_Float_Array_fill);
     /*<<float.ml:250:4>>*/ return unsafe_fill(a, ofs, len, v);
    /*<<float.ml:251:27>>*/ }
   function blit(src, sofs, dst, dofs, len){
     /*<<float.ml:254:4>>*/ check(src, sofs, len, cst_Float_array_blit);
     /*<<float.ml:255:4>>*/ check(dst, dofs, len, cst_Float_array_blit$0);
     /*<<float.ml:256:4>>*/ return  /*<<float.ml:256:4>>*/ caml_floatarray_blit
            (src, sofs, dst, dofs, len);
    /*<<float.ml:256:37>>*/ }
   function to_list(a){
     /*<<float.ml:259:4>>*/ return  /*<<float.ml:259:25>>*/ caml_call2
            (Stdlib_List[11],
             a.length - 1,
             function(_ac_){ /*<<?>>*/ return a[1 + _ac_];});
    /*<<float.ml:259:39>>*/ }
   function of_list(l){
     /*<<float.ml:262:4>>*/ var
      /*<<float.ml:262:17>>*/ result =
        /*<<float.ml:262:17>>*/ caml_floatarray_create
        ( /*<<float.ml:262:24>>*/ caml_call1(Stdlib_List[1], l)),
     i = 0,
     l$0 = l;
     /*<<float.ml:264:6>>*/ for(;;){
     if(! l$0)  /*<<float.ml:263:4>>*/ return result;
     var t = l$0[2], h = l$0[1];
      /*<<float.ml:266:18>>*/ result[1 + i] = h;
      /*<<float.ml:263:4>>*/ var
       /*<<float.ml:263:4>>*/ i$0 = i + 1 | 0,
      i = i$0,
      l$0 = t;
    }
    /*<<float.ml:268:12>>*/ }
   function iter(f, a){
     /*<<float.ml:272:4>>*/ var
     _aa_ = a.length - 1 - 1 | 0,
      /*<<float.ml:272:4>>*/ _$_ = 0;
    if(_aa_ >= 0){
     var i = _$_;
     for(;;){
       /*<<float.ml:272:33>>*/  /*<<float.ml:272:33>>*/ caml_call1
       (f, a[1 + i]);
       /*<<float.ml:272:33>>*/  /*<<float.ml:272:33>>*/ var _ab_ = i + 1 | 0;
      if(_aa_ === i) break;
      var i = _ab_;
     }
    }
    return 0;
    /*<<float.ml:272:56>>*/ }
   function iter2(f, a, b){
     /*<<float.ml:276:4>>*/ if(a.length - 1 !== b.length - 1)
      /*<<float.ml:277:6>>*/ return  /*<<float.ml:277:6>>*/ caml_call1
             (Stdlib[1], cst_Float_Array_iter2_arrays_m);
     /*<<float.ml:279:6>>*/ var
     _Z_ = a.length - 1 - 1 | 0,
      /*<<float.ml:279:6>>*/ _Y_ = 0;
    if(_Z_ >= 0){
     var i = _Y_;
     for(;;){
       /*<<float.ml:279:35>>*/  /*<<float.ml:279:35>>*/ caml_call2
       (f, a[1 + i], b[1 + i]);
       /*<<float.ml:279:35>>*/  /*<<float.ml:279:35>>*/ var ___ = i + 1 | 0;
      if(_Z_ === i) break;
      var i = ___;
     }
    }
    return 0;
    /*<<float.ml:279:75>>*/ }
   function map(f, a){
     /*<<float.ml:282:4>>*/ var
     l = a.length - 1,
      /*<<float.ml:283:12>>*/ r =
        /*<<float.ml:283:12>>*/ caml_floatarray_create(l),
      /*<<float.ml:284:4>>*/ _W_ = l - 1 | 0,
      /*<<float.ml:283:12>>*/ _V_ = 0;
    if(_W_ >= 0){
     var i = _V_;
     for(;;){
       /*<<float.ml:285:6>>*/ r[1 + i] =
        /*<<float.ml:285:21>>*/ caml_call1(f, a[1 + i]);
       /*<<float.ml:285:6>>*/  /*<<float.ml:285:6>>*/ var _X_ = i + 1 | 0;
      if(_W_ === i) break;
      var i = _X_;
     }
    }
     /*<<float.ml:287:4>>*/ return r;
    /*<<float.ml:287:5>>*/ }
   function map_inplace(f, a){
     /*<<float.ml:291:4>>*/ var
     _T_ = a.length - 1 - 1 | 0,
      /*<<float.ml:291:4>>*/ _S_ = 0;
    if(_T_ >= 0){
     var i = _S_;
     for(;;){
       /*<<float.ml:292:6>>*/ a[1 + i] =
        /*<<float.ml:292:21>>*/ caml_call1(f, a[1 + i]);
       /*<<float.ml:292:6>>*/  /*<<float.ml:292:6>>*/ var _U_ = i + 1 | 0;
      if(_T_ === i) break;
      var i = _U_;
     }
    }
    return 0;
    /*<<float.ml:293:8>>*/ }
   function map2(f, a, b){
     /*<<float.ml:296:4>>*/ var
     la = a.length - 1,
      /*<<float.ml:297:4>>*/ lb = b.length - 1;
    if(la !== lb)
      /*<<float.ml:299:6>>*/ return  /*<<float.ml:299:6>>*/ caml_call1
             (Stdlib[1], cst_Float_Array_map2_arrays_mu);
     /*<<float.ml:301:14>>*/ var
      /*<<float.ml:301:14>>*/ r =
        /*<<float.ml:301:14>>*/ caml_floatarray_create(la),
      /*<<float.ml:302:6>>*/ _Q_ = la - 1 | 0,
      /*<<float.ml:301:14>>*/ _P_ = 0;
    if(_Q_ >= 0){
     var i = _P_;
     for(;;){
       /*<<float.ml:303:8>>*/ r[1 + i] =
        /*<<float.ml:303:23>>*/ caml_call2(f, a[1 + i], b[1 + i]);
       /*<<float.ml:303:8>>*/  /*<<float.ml:303:8>>*/ var _R_ = i + 1 | 0;
      if(_Q_ === i) break;
      var i = _R_;
     }
    }
     /*<<float.ml:305:6>>*/ return r;
    /*<<float.ml:306:7>>*/ }
   function iteri(f, a){
     /*<<float.ml:310:4>>*/ var
     _N_ = a.length - 1 - 1 | 0,
      /*<<float.ml:310:4>>*/ _M_ = 0;
    if(_N_ >= 0){
     var i = _M_;
     for(;;){
       /*<<float.ml:310:33>>*/  /*<<float.ml:310:33>>*/ caml_call2
       (f, i, a[1 + i]);
       /*<<float.ml:310:33>>*/  /*<<float.ml:310:33>>*/ var _O_ = i + 1 | 0;
      if(_N_ === i) break;
      var i = _O_;
     }
    }
    return 0;
    /*<<float.ml:310:58>>*/ }
   function mapi(f, a){
     /*<<float.ml:313:4>>*/ var
     l = a.length - 1,
      /*<<float.ml:314:12>>*/ r =
        /*<<float.ml:314:12>>*/ caml_floatarray_create(l),
      /*<<float.ml:315:4>>*/ _K_ = l - 1 | 0,
      /*<<float.ml:314:12>>*/ _J_ = 0;
    if(_K_ >= 0){
     var i = _J_;
     for(;;){
       /*<<float.ml:316:6>>*/ r[1 + i] =
        /*<<float.ml:316:21>>*/ caml_call2(f, i, a[1 + i]);
       /*<<float.ml:316:6>>*/  /*<<float.ml:316:6>>*/ var _L_ = i + 1 | 0;
      if(_K_ === i) break;
      var i = _L_;
     }
    }
     /*<<float.ml:318:4>>*/ return r;
    /*<<float.ml:318:5>>*/ }
   function mapi_inplace(f, a){
     /*<<float.ml:322:4>>*/ var
     _H_ = a.length - 1 - 1 | 0,
      /*<<float.ml:322:4>>*/ _G_ = 0;
    if(_H_ >= 0){
     var i = _G_;
     for(;;){
       /*<<float.ml:323:6>>*/ a[1 + i] =
        /*<<float.ml:323:21>>*/ caml_call2(f, i, a[1 + i]);
       /*<<float.ml:323:6>>*/  /*<<float.ml:323:6>>*/ var _I_ = i + 1 | 0;
      if(_H_ === i) break;
      var i = _I_;
     }
    }
    return 0;
    /*<<float.ml:324:8>>*/ }
   function fold_left(f, x, a){
     /*<<float.ml:328:4>>*/ var
      /*<<float.ml:328:12>>*/ r = [0, x],
     _E_ = a.length - 1 - 1 | 0,
      /*<<float.ml:328:12>>*/ _D_ = 0;
    if(_E_ >= 0){
     var i = _D_;
     for(;;){
      r[1] =  /*<<float.ml:330:11>>*/ caml_call2(f, r[1], a[1 + i]);
       /*<<float.ml:329:4>>*/  /*<<float.ml:329:4>>*/ var _F_ = i + 1 | 0;
      if(_E_ === i) break;
      var i = _F_;
     }
    }
    return r[1];
    /*<<float.ml:332:6>>*/ }
   function fold_right(f, a, x){
     /*<<float.ml:336:4>>*/ var
      /*<<float.ml:336:12>>*/ r = [0, x],
      /*<<float.ml:337:4>>*/ _B_ = a.length - 1 - 1 | 0;
    if(_B_ >= 0){
     var i = _B_;
     for(;;){
      r[1] =  /*<<float.ml:338:11>>*/ caml_call2(f, a[1 + i], r[1]);
       /*<<float.ml:337:4>>*/  /*<<float.ml:337:4>>*/ var _C_ = i - 1 | 0;
      if(0 === i) break;
      var i = _C_;
     }
    }
    return r[1];
    /*<<float.ml:340:6>>*/ }
   function exists(p, a){
     /*<<float.ml:344:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:346:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:346:20>>*/ return 0;
      /*<<float.ml:347:14>>*/ if
      ( /*<<float.ml:347:14>>*/ caml_call1(p, a[1 + i]))
       /*<<float.ml:347:38>>*/ return 1;
      /*<<float.ml:348:11>>*/ var
       /*<<float.ml:348:11>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:349:10>>*/ }
   function for_all(p, a){
     /*<<float.ml:353:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:355:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:355:20>>*/ return 1;
      /*<<float.ml:356:14>>*/ if
      (!  /*<<float.ml:356:14>>*/ caml_call1(p, a[1 + i]))
       /*<<float.ml:357:11>>*/ return 0;
      /*<<float.ml:356:38>>*/ var
       /*<<float.ml:356:38>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:358:10>>*/ }
   function mem(x, a){
     /*<<float.ml:362:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:364:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:364:20>>*/ return 0;
     if(0 ===  /*<<float.ml:365:22>>*/ caml_float_compare(a[1 + i], x))
       /*<<float.ml:365:50>>*/ return 1;
      /*<<float.ml:366:11>>*/ var
       /*<<float.ml:366:11>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:368:10>>*/ }
   function mem_ieee(x, a){
     /*<<float.ml:372:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:374:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:374:20>>*/ return 0;
     if(x == a[1 + i])  /*<<float.ml:375:40>>*/ return 1;
      /*<<float.ml:376:11>>*/ var
       /*<<float.ml:376:11>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:378:10>>*/ }
   function find_opt(p, a){
     /*<<float.ml:382:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:384:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:384:20>>*/ return 0;
      /*<<float.ml:386:16>>*/  /*<<float.ml:386:16>>*/ var x = a[1 + i];
      /*<<float.ml:387:11>>*/ if( /*<<float.ml:387:11>>*/ caml_call1(p, x))
       /*<<float.ml:387:20>>*/ return [0, x];
      /*<<float.ml:388:13>>*/ var
       /*<<float.ml:388:13>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:390:10>>*/ }
   function find_index(p, a){
     /*<<float.ml:394:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:396:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:396:20>>*/ return 0;
      /*<<float.ml:397:14>>*/ if
      ( /*<<float.ml:397:14>>*/ caml_call1(p, a[1 + i]))
       /*<<float.ml:397:38>>*/ return [0, i];
      /*<<float.ml:398:11>>*/ var
       /*<<float.ml:398:11>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:399:10>>*/ }
   function find_map(f, a){
     /*<<float.ml:403:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:405:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:405:20>>*/ return 0;
      /*<<float.ml:407:14>>*/  /*<<float.ml:407:14>>*/ var
      r =  /*<<float.ml:407:14>>*/ caml_call1(f, a[1 + i]);
     if(r)  /*<<float.ml:409:25>>*/ return r;
      /*<<float.ml:408:18>>*/ var
       /*<<float.ml:408:18>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:411:10>>*/ }
   function find_mapi(f, a){
     /*<<float.ml:415:4>>*/ var n = a.length - 1, i = 0;
     /*<<float.ml:417:6>>*/ for(;;){
     if(i === n)  /*<<float.ml:417:20>>*/ return 0;
      /*<<float.ml:419:14>>*/  /*<<float.ml:419:14>>*/ var
      r =  /*<<float.ml:419:14>>*/ caml_call2(f, i, a[1 + i]);
     if(r)  /*<<float.ml:421:25>>*/ return r;
      /*<<float.ml:420:18>>*/ var
       /*<<float.ml:420:18>>*/ i$0 = i + 1 | 0,
      i = i$0;
    }
    /*<<float.ml:423:10>>*/ }
    /*<<float.ml:426:2>>*/ var
     /*<<float.ml:426:2>>*/ Bottom =
      [248, "Stdlib.Float.Array.Bottom", runtime.caml_fresh_oo_id(0)],
    _b_ = [0, cst_float_ml, 458, 6];
   function sort(cmp, a){
    function maxson(l, i){
      /*<<float.ml:429:6>>*/ var
      i31 = ((i + i | 0) + i | 0) + 1 | 0,
       /*<<float.ml:430:14>>*/ x = [0, i31];
     if((i31 + 2 | 0) < l){
      if
       ( /*<<float.ml:432:11>>*/ caml_call2
         (cmp,
           /*<<float.ml:432:15>>*/ caml_array_get(a, i31),
           /*<<float.ml:432:27>>*/ caml_array_get(a, i31 + 1 | 0))
        < 0)
       x[1] = i31 + 1 | 0;
      if
       ( /*<<float.ml:433:11>>*/ caml_call2
         (cmp,
           /*<<float.ml:433:15>>*/ caml_array_get(a, x[1]),
           /*<<float.ml:433:26>>*/ caml_array_get(a, i31 + 2 | 0))
        < 0)
       x[1] = i31 + 2 | 0;
      return x[1];
     }
      /*<<float.ml:436:24>>*/ if
      ((i31 + 1 | 0) < l
       &&
        0
        >
          /*<<float.ml:436:24>>*/ caml_call2
          (cmp,
            /*<<float.ml:436:28>>*/ caml_array_get(a, i31),
            /*<<float.ml:436:40>>*/ caml_array_get(a, i31 + 1 | 0)))
       /*<<float.ml:437:13>>*/ return i31 + 1 | 0;
     if(i31 < l)  /*<<float.ml:438:29>>*/ return i31;
      /*<<float.ml:438:38>>*/ throw  /*<<float.ml:438:38>>*/ caml_maybe_attach_backtrace
            ([0, Bottom, i], 1);
     /*<<float.ml:438:54>>*/ }
    var l = a.length - 1, _v_ = ((l + 1 | 0) / 3 | 0) - 1 | 0;
    if(_v_ >= 0){
     var i$6 = _v_;
     for(;;){
       /*<<float.ml:467:52>>*/  /*<<float.ml:467:52>>*/ var
       e$1 =  /*<<float.ml:467:52>>*/ caml_array_get(a, i$6);
       /*<<float.ml:449:24>>*/ try{
       var i = i$6;
        /*<<float.ml:441:6>>*/ for(;;){
         /*<<float.ml:441:14>>*/  /*<<float.ml:441:14>>*/ var
         j = maxson(l, i);
         /*<<float.ml:442:9>>*/ if
         (0
          >=
            /*<<float.ml:442:9>>*/ caml_call2
            (cmp,  /*<<float.ml:442:13>>*/ caml_array_get(a, j), e$1))
         break;
         /*<<float.ml:443:8>>*/  /*<<float.ml:443:8>>*/ caml_array_set
         (a, i,  /*<<float.ml:443:16>>*/ caml_array_get(a, j));
        var i = j;
       }
        /*<<float.ml:445:15>>*/  /*<<float.ml:445:15>>*/ caml_array_set
        (a, i, e$1);
      }
      catch(exn$0){
       var exn = caml_wrap_exception(exn$0);
       if(exn[1] !== Bottom) throw caml_maybe_attach_backtrace(exn, 0);
       var i$0 = exn[2];
        /*<<float.ml:449:63>>*/  /*<<float.ml:449:63>>*/ caml_array_set
        (a, i$0, e$1);
      }
       /*<<float.ml:467:40>>*/  /*<<float.ml:467:40>>*/ var _A_ = i$6 - 1 | 0;
      if(0 === i$6) break;
      var i$6 = _A_;
     }
    }
     /*<<float.ml:468:4>>*/  /*<<float.ml:468:4>>*/ var _w_ = l - 1 | 0;
    if(_w_ >= 2){
     var i$4 = _w_;
     for(;;){
       /*<<float.ml:469:14>>*/  /*<<float.ml:469:14>>*/ var
       e$0 =  /*<<float.ml:469:14>>*/ caml_array_get(a, i$4);
       /*<<float.ml:470:6>>*/  /*<<float.ml:470:6>>*/ caml_array_set
       (a, i$4,  /*<<float.ml:470:14>>*/ caml_array_get(a, 0));
      var i$5 = 0;
       /*<<float.ml:455:21>>*/ try{
       var i$1 = i$5;
        /*<<float.ml:451:6>>*/ for(;;){
         /*<<float.ml:451:14>>*/  /*<<float.ml:451:14>>*/ var
         j$0 = maxson(i$4, i$1);
         /*<<float.ml:452:6>>*/  /*<<float.ml:452:6>>*/ caml_array_set
         (a, i$1,  /*<<float.ml:452:14>>*/ caml_array_get(a, j$0));
        var i$1 = j$0;
       }
      }
      catch(exn){
       var exn$0 = caml_wrap_exception(exn);
       if(exn$0[1] !== Bottom) throw caml_maybe_attach_backtrace(exn$0, 0);
       var i$2 = exn$0[2];
       a:
       {
        b:
        {
         var i$3 = i$2;
          /*<<float.ml:457:6>>*/ for(;;){
          var father = (i$3 - 1 | 0) / 3 | 0;
          if(i$3 === father)
            /*<<float.ml:458:6>>*/ throw  /*<<float.ml:458:6>>*/ caml_maybe_attach_backtrace
                  ([0, Assert_failure, _b_], 1);
           /*<<float.ml:459:9>>*/ if
           (0
            <=
              /*<<float.ml:459:9>>*/ caml_call2
              (cmp,  /*<<float.ml:459:13>>*/ caml_array_get(a, father), e$0))
           break;
           /*<<float.ml:460:8>>*/  /*<<float.ml:460:8>>*/ caml_array_set
           (a, i$3,  /*<<float.ml:460:16>>*/ caml_array_get(a, father));
          if(0 >= father) break b;
          var i$3 = father;
         }
          /*<<float.ml:462:15>>*/  /*<<float.ml:462:15>>*/ caml_array_set
          (a, i$3, e$0);
         break a;
        }
         /*<<float.ml:461:51>>*/  /*<<float.ml:461:51>>*/ caml_array_set
         (a, 0, e$0);
       }
        /*<<float.ml:468:4>>*/  /*<<float.ml:468:4>>*/ var _z_ = i$4 - 1 | 0;
       if(2 === i$4) break;
       var i$4 = _z_;
      }
     }
    }
    var _x_ = 1 < l ? 1 : 0;
    if(_x_){
      /*<<float.ml:473:27>>*/  /*<<float.ml:473:27>>*/ var
      e =  /*<<float.ml:473:27>>*/ caml_array_get(a, 1);
      /*<<float.ml:473:40>>*/  /*<<float.ml:473:40>>*/ caml_array_set
      (a, 1,  /*<<float.ml:473:48>>*/ caml_array_get(a, 0));
     var _y_ =  /*<<float.ml:473:59>>*/ caml_array_set(a, 0, e);
    }
    else
     var _y_ = _x_;
     /*<<float.ml:473:59>>*/ return _y_;
    /*<<float.ml:473:69>>*/ }
   function stable_sort(cmp, a){
    function merge(src1ofs, src1len, src2, src2ofs, src2len, dst, dstofs){
      /*<<float.ml:479:6>>*/ var
      src1r = src1ofs + src1len | 0,
      src2r = src2ofs + src2len | 0,
       /*<<float.ml:496:46>>*/ s2$1 =
         /*<<float.ml:496:46>>*/ caml_array_get(src2, src2ofs),
       /*<<float.ml:496:22>>*/ s1$1 =
         /*<<float.ml:496:22>>*/ caml_array_get(a, src1ofs),
      i1 = src1ofs,
      s1 = s1$1,
      i2 = src2ofs,
      s2 = s2$1,
      d = dstofs;
      /*<<float.ml:481:8>>*/ for(;;)
       /*<<float.ml:481:11>>*/ if
       (0 <  /*<<float.ml:481:11>>*/ caml_call2(cmp, s1, s2)){
        /*<<float.ml:489:10>>*/  /*<<float.ml:489:10>>*/ caml_array_set
        (dst, d, s2);
        /*<<float.ml:489:10>>*/  /*<<float.ml:489:10>>*/ var
        i2$0 = i2 + 1 | 0;
       if(i2$0 >= src2r) return blit(a, i1, dst, d + 1 | 0, src1r - i1 | 0);
        /*<<float.ml:492:12>>*/ var
         /*<<float.ml:492:12>>*/ d$0 = d + 1 | 0,
         /*<<float.ml:492:26>>*/ s2$0 =
           /*<<float.ml:492:26>>*/ caml_array_get(src2, i2$0),
        i2 = i2$0,
        s2 = s2$0,
        d = d$0;
      }
      else{
        /*<<float.ml:482:10>>*/  /*<<float.ml:482:10>>*/ caml_array_set
        (dst, d, s1);
        /*<<float.ml:482:10>>*/  /*<<float.ml:482:10>>*/ var
        i1$0 = i1 + 1 | 0;
       if(i1$0 >= src1r)
        return blit(src2, i2, dst, d + 1 | 0, src2r - i2 | 0);
        /*<<float.ml:485:12>>*/ var
         /*<<float.ml:485:12>>*/ d$1 = d + 1 | 0,
         /*<<float.ml:485:20>>*/ s1$0 =
           /*<<float.ml:485:20>>*/ caml_array_get(a, i1$0),
        i1 = i1$0,
        s1 = s1$0,
        d = d$1;
      }
     /*<<float.ml:496:72>>*/ }
    function isortto(srcofs, dst, dstofs, len){
      /*<<float.ml:499:6>>*/ var
      _t_ = len - 1 | 0,
       /*<<float.ml:499:6>>*/ _s_ = 0;
     if(_t_ >= 0){
      var i = _s_;
      for(;;){
        /*<<float.ml:500:16>>*/ var
         /*<<float.ml:500:16>>*/ e =
           /*<<float.ml:500:16>>*/ caml_array_get(a, srcofs + i | 0),
         /*<<float.ml:501:16>>*/ j = [0, (dstofs + i | 0) - 1 | 0];
       for(;;){
        if(dstofs > j[1]) break;
         /*<<float.ml:502:31>>*/ if
         (0
          >=
            /*<<float.ml:502:31>>*/ caml_call2
            (cmp,  /*<<float.ml:502:35>>*/ caml_array_get(dst, j[1]), e))
         break;
         /*<<float.ml:503:10>>*/  /*<<float.ml:503:10>>*/ caml_array_set
         (dst,
          j[1] + 1 | 0,
           /*<<float.ml:503:27>>*/ caml_array_get(dst, j[1]));
        j[1] += -1;
       }
        /*<<float.ml:506:8>>*/  /*<<float.ml:506:8>>*/ caml_array_set
        (dst, j[1] + 1 | 0, e);
        /*<<float.ml:499:6>>*/  /*<<float.ml:499:6>>*/ var _u_ = i + 1 | 0;
       if(_t_ === i) break;
       var i = _u_;
      }
     }
     return 0;
     /*<<float.ml:507:10>>*/ }
    function sortto(srcofs, dst, dstofs, len){
      /*<<float.ml:510:6>>*/ if(len <= 5)
       /*<<float.ml:510:28>>*/ return isortto(srcofs, dst, dstofs, len);
     var l1 = len / 2 | 0, l2 = len - l1 | 0;
      /*<<float.ml:513:8>>*/ sortto(srcofs + l1 | 0, dst, dstofs + l1 | 0, l2);
      /*<<float.ml:514:8>>*/ sortto(srcofs, a, srcofs + l2 | 0, l1);
      /*<<float.ml:514:8>>*/ return merge
             (srcofs + l2 | 0, l1, dst, dstofs + l1 | 0, l2, dst, dstofs);
     /*<<float.ml:516:9>>*/ }
    var l = a.length - 1;
    if(l <= 5)  /*<<float.ml:519:24>>*/ return isortto(0, a, 0, l);
     /*<<float.ml:522:14>>*/ var
     l1 = l / 2 | 0,
     l2 = l - l1 | 0,
      /*<<float.ml:522:14>>*/ t =
        /*<<float.ml:522:14>>*/ caml_floatarray_create(l2);
     /*<<float.ml:523:6>>*/ sortto(l1, t, 0, l2);
     /*<<float.ml:524:6>>*/ sortto(0, a, l2, l1);
     /*<<float.ml:524:6>>*/ return merge(l2, l1, t, 0, l2, a, 0);
    /*<<float.ml:526:7>>*/ }
   function to_seq(a){
    function aux(i, param){
      /*<<float.ml:533:6>>*/ if(i >= a.length - 1)
       /*<<float.ml:537:11>>*/ return 0;
      /*<<float.ml:535:16>>*/ var
       /*<<float.ml:535:16>>*/ x = a[1 + i],
       /*<<float.ml:535:16>>*/ _q_ = i + 1 | 0;
      /*<<float.ml:536:8>>*/ return [0,
             x,
             function(_r_){ /*<<?>>*/ return aux(_q_, _r_);}];
     /*<<float.ml:537:18>>*/ }
     /*<<float.ml:539:4>>*/ var _o_ = 0;
     /*<<float.ml:539:4>>*/ return function(_p_){
      /*<<?>>*/ return aux(_o_, _p_);};
    /*<<float.ml:539:9>>*/ }
   function to_seqi(a){
    function aux(i, param){
      /*<<float.ml:544:6>>*/ if(i >= a.length - 1)
       /*<<float.ml:548:11>>*/ return 0;
      /*<<float.ml:546:16>>*/ var
       /*<<float.ml:546:16>>*/ x = a[1 + i],
       /*<<float.ml:546:16>>*/ _m_ = i + 1 | 0;
      /*<<float.ml:547:8>>*/ return [0,
             [0, i, x],
             function(_n_){ /*<<?>>*/ return aux(_m_, _n_);}];
     /*<<float.ml:548:18>>*/ }
     /*<<float.ml:550:4>>*/ var _k_ = 0;
     /*<<float.ml:550:4>>*/ return function(_l_){
      /*<<?>>*/ return aux(_k_, _l_);};
    /*<<float.ml:550:9>>*/ }
   function of_seq(i$2){
     /*<<float.ml:564:4>>*/ var
      /*<<float.ml:564:12>>*/ l =
        /*<<float.ml:564:12>>*/ caml_call3
        (Stdlib_Seq[5],
         function(acc, x){
           /*<<float.ml:564:40>>*/ return [0, x, acc];
          /*<<float.ml:564:46>>*/ },
         0,
         i$2),
      /*<<float.ml:554:14>>*/ len =
        /*<<float.ml:554:14>>*/ caml_call1(Stdlib_List[1], l),
      /*<<float.ml:555:12>>*/ a =
        /*<<float.ml:555:12>>*/ caml_floatarray_create(len),
      /*<<float.ml:554:14>>*/ i$1 = len - 1 | 0,
     i = i$1,
     param = l;
    for(;;){
     if(! param)  /*<<float.ml:556:4>>*/ return a;
     var tl = param[2], hd = param[1];
      /*<<float.ml:558:18>>*/ a[1 + i] = hd;
      /*<<float.ml:556:4>>*/ var
       /*<<float.ml:556:4>>*/ i$0 = i - 1 | 0,
      i = i$0,
      param = tl;
    }
    /*<<float.ml:565:17>>*/ }
   function map_to_array(f, a){
     /*<<float.ml:569:4>>*/ var l = a.length - 1;
     /*<<float.ml:570:4>>*/ if(0 === l)  /*<<float.ml:570:18>>*/ return [0];
     /*<<float.ml:571:14>>*/ var
      /*<<float.ml:571:14>>*/ r =
        /*<<float.ml:571:14>>*/ runtime.caml_make_vect
        (l,  /*<<float.ml:571:27>>*/ caml_call1(f, a[1])),
      /*<<float.ml:572:6>>*/ _i_ = l - 1 | 0,
      /*<<float.ml:571:14>>*/ _h_ = 1;
    if(_i_ >= 1){
     var i = _h_;
     for(;;){
       /*<<float.ml:573:8>>*/ r[1 + i] =
        /*<<float.ml:573:29>>*/ caml_call1(f, a[1 + i]);
       /*<<float.ml:573:8>>*/  /*<<float.ml:573:8>>*/ var _j_ = i + 1 | 0;
      if(_i_ === i) break;
      var i = _j_;
     }
    }
     /*<<float.ml:575:6>>*/ return r;
    /*<<float.ml:576:7>>*/ }
   function map_from_array(f, a){
     /*<<float.ml:579:4>>*/ var
     l = a.length - 1,
      /*<<float.ml:580:12>>*/ r =
        /*<<float.ml:580:12>>*/ caml_floatarray_create(l),
      /*<<float.ml:581:4>>*/ _f_ = l - 1 | 0,
      /*<<float.ml:580:12>>*/ _e_ = 0;
    if(_f_ >= 0){
     var i = _e_;
     for(;;){
       /*<<float.ml:582:6>>*/ r[1 + i] =
        /*<<float.ml:582:21>>*/ caml_call1(f, a[1 + i]);
       /*<<float.ml:582:6>>*/  /*<<float.ml:582:6>>*/ var _g_ = i + 1 | 0;
      if(_f_ === i) break;
      var i = _g_;
     }
    }
     /*<<float.ml:584:4>>*/ return r;
    /*<<float.ml:584:5>>*/ }
   var
    Stdlib_Float =
      [0,
       0.,
       1.,
       -1.,
       succ,
       pred,
       infinity,
       neg_infinity,
       nan,
       signaling_nan,
       nan,
       3.141592653589793,
       max_float,
       min_float,
       epsilon,
       is_finite,
       is_infinite,
       is_nan,
       is_integer,
       of_string_opt,
       to_string,
       caml_float_compare,
       equal,
       min,
       max,
       min_max,
       min_num,
       max_num,
       min_max_num,
       seeded_hash,
       hash,
       [0,
        function(_d_){ /*<<?>>*/ return _d_.length - 1;},
        caml_array_get,
        caml_array_set,
        make,
        caml_floatarray_create,
        init,
        append,
        concat,
        sub,
        copy,
        fill,
        blit,
        to_list,
        of_list,
        iter,
        iteri,
        map,
        map_inplace,
        mapi,
        mapi_inplace,
        fold_left,
        fold_right,
        iter2,
        map2,
        for_all,
        exists,
        mem,
        mem_ieee,
        find_opt,
        find_index,
        find_map,
        find_mapi,
        sort,
        stable_sort,
        stable_sort,
        to_seq,
        to_seqi,
        of_seq,
        map_to_array,
        map_from_array],
       [0,
        function(_c_){ /*<<?>>*/ return _c_.length - 1;},
        caml_array_get,
        caml_array_set,
        make,
        caml_floatarray_create,
        init,
        append,
        concat,
        sub,
        copy,
        fill,
        blit,
        to_list,
        of_list,
        iter,
        iteri,
        map,
        map_inplace,
        mapi,
        mapi_inplace,
        fold_left,
        fold_right,
        iter2,
        map2,
        for_all,
        exists,
        mem,
        mem_ieee,
        find_opt,
        find_index,
        find_map,
        find_mapi,
        sort,
        stable_sort,
        stable_sort,
        to_seq,
        to_seqi,
        of_seq,
        map_to_array,
        map_from_array]];
   runtime.caml_register_global(23, Stdlib_Float, "Stdlib__Float");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Int32
//# unitInfo: Requires: Stdlib, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int_compare = runtime.caml_int_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_mul = runtime.caml_mul,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Assert_failure = global_data.Assert_failure,
    zero = 0,
    one = 1;
   function succ(n){
     /*<<int32.ml:48:13>>*/ return n + 1 | 0;
    /*<<int32.ml:48:21>>*/ }
   function pred(n){
     /*<<int32.ml:49:13>>*/ return n - 1 | 0;
    /*<<int32.ml:49:21>>*/ }
   function abs(n){
     /*<<int32.ml:50:12>>*/ return  /*<<int32.ml:50:15>>*/ caml_greaterequal
             (n, 0)
            ? n
            : - n | 0;
    /*<<int32.ml:50:40>>*/ }
   function lognot(n){
     /*<<int32.ml:53:15>>*/ return n ^ -1;
    /*<<int32.ml:53:29>>*/ }
   var
    _a_ = Stdlib_Sys[9],
    _b_ = [0, "int32.ml", 69, 6],
    minus_one = -1,
    min_int = -2147483648,
    max_int = 2147483647;
   if(32 === _a_)
     /*<<int32.ml:58:6>>*/ var
      /*<<int32.ml:58:6>>*/ max_int$0 = Stdlib[19],
     unsigned_to_int =
       function(n){
         /*<<int32.ml:60:8>>*/ if
         (0 >=  /*<<int32.ml:60:11>>*/ caml_int_compare(0, n)
          && 0 >=  /*<<int32.ml:60:34>>*/ caml_int_compare(n, max_int$0))
          /*<<int32.ml:61:10>>*/ return [0, n];
         /*<<int32.ml:63:10>>*/ return 0;
        /*<<int32.ml:63:14>>*/ };
   else{
    if(64 !== _a_)
      /*<<int32.ml:69:6>>*/ throw  /*<<int32.ml:69:6>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _b_], 1);
    var
     unsigned_to_int =
       function(n){
         /*<<int32.ml:67:15>>*/ return [0, n & -1];
        /*<<int32.ml:67:40>>*/ };
   }
   function to_string(n){
     /*<<int32.ml:72:18>>*/ return  /*<<int32.ml:72:18>>*/ runtime.caml_format_int
            ("%d", n);
    /*<<int32.ml:72:31>>*/ }
   function of_string_opt(s){
     /*<<int32.ml:78:2>>*/ try{
      /*<<int32.ml:78:6>>*/  /*<<int32.ml:78:6>>*/ var
      _d_ = [0,  /*<<int32.ml:78:11>>*/ runtime.caml_int_of_string(s)];
      /*<<int32.ml:78:6>>*/ return _d_;
    }
    catch(_e_){
     var _c_ = caml_wrap_exception(_e_);
     if(_c_[1] === Stdlib[7])  /*<<int32.ml:79:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_c_, 0);
    }
    /*<<int32.ml:79:24>>*/ }
   var compare = caml_int_compare;
   function equal(x, y){
     /*<<int32.ml:84:26>>*/ return 0
            ===  /*<<int32.ml:84:26>>*/ caml_int_compare(x, y)
            ? 1
            : 0;
    /*<<int32.ml:84:41>>*/ }
   function unsigned_compare(n, m){
     /*<<int32.ml:87:2>>*/ return  /*<<int32.ml:87:26>>*/ caml_int_compare
            (n + 2147483648 | 0, m + 2147483648 | 0);
    /*<<int32.ml:87:41>>*/ }
   function min(x, y){
     /*<<int32.ml:89:18>>*/ return  /*<<int32.ml:89:21>>*/ runtime.caml_lessequal
             (x, y)
            ? x
            : y;
    /*<<int32.ml:89:41>>*/ }
   function max(x, y){
     /*<<int32.ml:90:18>>*/ return  /*<<int32.ml:90:21>>*/ caml_greaterequal
             (x, y)
            ? x
            : y;
    /*<<int32.ml:90:41>>*/ }
   function unsigned_div(n, d){
     /*<<int32.ml:96:2>>*/ if
     ( /*<<int32.ml:96:5>>*/ runtime.caml_lessthan(d, 0))
      /*<<int32.ml:97:7>>*/ return 0 <= unsigned_compare(n, d) ? one : zero;
     /*<<int32.ml:99:12>>*/ var
      /*<<int32.ml:99:12>>*/ q =
        /*<<int32.ml:99:23>>*/ runtime.caml_div(n >>> 1 | 0, d) << 1,
      /*<<int32.ml:100:12>>*/ r =
       n -  /*<<int32.ml:100:18>>*/ caml_mul(q, d) | 0;
     /*<<int32.ml:101:7>>*/ return 0 <= unsigned_compare(r, d) ? q + 1 | 0 : q;
    /*<<int32.ml:101:51>>*/ }
   function unsigned_rem(n, d){
     /*<<int32.ml:104:2>>*/ return n
           -  /*<<int32.ml:104:8>>*/ caml_mul(unsigned_div(n, d), d)
           | 0;
    /*<<int32.ml:104:34>>*/ }
   function seeded_hash(seed, x){
     /*<<int32.ml:108:25>>*/ return  /*<<int32.ml:108:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<int32.ml:108:56>>*/ }
   function hash(x){
     /*<<int32.ml:109:13>>*/ return  /*<<int32.ml:109:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<int32.ml:109:41>>*/ }
   var
    Stdlib_Int32 =
      [0,
       zero,
       one,
       minus_one,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(14, Stdlib_Int32, "Stdlib__Int32");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Int64
//# unitInfo: Requires: Stdlib
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int64_compare = runtime.caml_int64_compare,
    caml_int64_mul = runtime.caml_int64_mul,
    caml_int64_sub = runtime.caml_int64_sub,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    zero = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    one = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    minus_one = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 65535),
    min_int = runtime.caml_int64_create_lo_mi_hi(0, 0, 32768),
    max_int = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 32767),
    Stdlib = global_data.Stdlib,
    _a_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _b_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _c_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    _d_ = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 65535);
   function succ(n){
     /*<<int64.ml:46:13>>*/ return  /*<<int64.ml:46:13>>*/ runtime.caml_int64_add
            (n, _a_);
    /*<<int64.ml:46:21>>*/ }
   function pred(n){
     /*<<int64.ml:47:13>>*/ return  /*<<int64.ml:47:13>>*/ caml_int64_sub
            (n, _b_);
    /*<<int64.ml:47:21>>*/ }
   function abs(n){
     /*<<int64.ml:48:12>>*/ return  /*<<int64.ml:48:15>>*/ caml_greaterequal
             (n, _c_)
            ? n
            :  /*<<int64.ml:48:35>>*/ runtime.caml_int64_neg(n);
    /*<<int64.ml:48:40>>*/ }
   function lognot(n){
     /*<<int64.ml:51:15>>*/ return  /*<<int64.ml:51:15>>*/ runtime.caml_int64_xor
            (n, _d_);
    /*<<int64.ml:51:29>>*/ }
    /*<<int64.ml:54:16>>*/  /*<<int64.ml:54:16>>*/ var
    max_int$0 =
       /*<<int64.ml:54:16>>*/ runtime.caml_int64_of_int32(Stdlib[19]);
   function unsigned_to_int(n){
     /*<<int64.ml:56:4>>*/ if
     (0 >=  /*<<int64.ml:56:7>>*/ caml_int64_compare(zero, n)
      && 0 >=  /*<<int64.ml:56:30>>*/ caml_int64_compare(n, max_int$0))
      /*<<int64.ml:57:6>>*/ return [0, runtime.caml_int64_to_int32(n)];
     /*<<int64.ml:59:6>>*/ return 0;
    /*<<int64.ml:59:10>>*/ }
   function to_string(n){
     /*<<int64.ml:62:18>>*/ return  /*<<int64.ml:62:18>>*/ runtime.caml_int64_format
            ("%d", n);
    /*<<int64.ml:62:31>>*/ }
   function of_string_opt(s){
     /*<<int64.ml:68:2>>*/ try{
      /*<<int64.ml:68:6>>*/  /*<<int64.ml:68:6>>*/ var
      _f_ = [0,  /*<<int64.ml:68:11>>*/ runtime.caml_int64_of_string(s)];
      /*<<int64.ml:68:6>>*/ return _f_;
    }
    catch(_g_){
     var _e_ = caml_wrap_exception(_g_);
     if(_e_[1] === Stdlib[7])  /*<<int64.ml:69:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_e_, 0);
    }
    /*<<int64.ml:69:24>>*/ }
   function compare(x, y){
     /*<<int64.ml:82:28>>*/ return  /*<<int64.ml:82:28>>*/ caml_int64_compare
            (x, y);
    /*<<int64.ml:82:46>>*/ }
   function equal(x, y){
     /*<<int64.ml:83:26>>*/ return 0
            ===  /*<<int64.ml:83:26>>*/ caml_int64_compare(x, y)
            ? 1
            : 0;
    /*<<int64.ml:83:41>>*/ }
   function unsigned_compare(n, m){
     /*<<int64.ml:86:2>>*/ return  /*<<int64.ml:86:26>>*/ caml_int64_compare
            ( /*<<int64.ml:86:10>>*/ caml_int64_sub(n, min_int),
              /*<<int64.ml:86:26>>*/ caml_int64_sub(m, min_int));
    /*<<int64.ml:86:41>>*/ }
   function min(x, y){
     /*<<int64.ml:88:18>>*/ return  /*<<int64.ml:88:21>>*/ runtime.caml_lessequal
             (x, y)
            ? x
            : y;
    /*<<int64.ml:88:41>>*/ }
   function max(x, y){
     /*<<int64.ml:89:18>>*/ return  /*<<int64.ml:89:21>>*/ caml_greaterequal
             (x, y)
            ? x
            : y;
    /*<<int64.ml:89:41>>*/ }
   function unsigned_div(n, d){
     /*<<int64.ml:95:2>>*/ if
     ( /*<<int64.ml:95:5>>*/ runtime.caml_lessthan(d, zero))
      /*<<int64.ml:96:7>>*/ return 0 <= unsigned_compare(n, d) ? one : zero;
     /*<<int64.ml:98:12>>*/ var
      /*<<int64.ml:98:12>>*/ q =
        /*<<int64.ml:98:12>>*/ runtime.caml_int64_shift_left
        ( /*<<int64.ml:98:23>>*/ runtime.caml_int64_div
          ( /*<<int64.ml:98:28>>*/ runtime.caml_int64_shift_right_unsigned
            (n, 1),
           d),
         1),
      /*<<int64.ml:99:12>>*/ r =
        /*<<int64.ml:99:12>>*/ caml_int64_sub
        (n,  /*<<int64.ml:99:18>>*/ caml_int64_mul(q, d));
     /*<<int64.ml:100:7>>*/ return 0 <= unsigned_compare(r, d) ? succ(q) : q;
    /*<<int64.ml:100:51>>*/ }
   function unsigned_rem(n, d){
     /*<<int64.ml:103:2>>*/ return  /*<<int64.ml:103:2>>*/ caml_int64_sub
            (n,  /*<<int64.ml:103:8>>*/ caml_int64_mul(unsigned_div(n, d), d));
    /*<<int64.ml:103:34>>*/ }
   function seeded_hash(seed, x){
     /*<<int64.ml:107:25>>*/ return  /*<<int64.ml:107:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<int64.ml:107:56>>*/ }
   function hash(x){
     /*<<int64.ml:108:13>>*/ return  /*<<int64.ml:108:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<int64.ml:108:41>>*/ }
   var
    Stdlib_Int64 =
      [0,
       zero,
       one,
       minus_one,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(11, Stdlib_Int64, "Stdlib__Int64");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Nativeint
//# unitInfo: Requires: Stdlib, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int_compare = runtime.caml_int_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_mul = runtime.caml_mul,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    zero = 0,
    one = 1;
   function succ(n){
     /*<<nativeint.ml:44:13>>*/ return n + 1 | 0;
    /*<<nativeint.ml:44:21>>*/ }
   function pred(n){
     /*<<nativeint.ml:45:13>>*/ return n - 1 | 0;
    /*<<nativeint.ml:45:21>>*/ }
   function abs(n){
     /*<<nativeint.ml:46:12>>*/ return  /*<<nativeint.ml:46:15>>*/ caml_greaterequal
             (n, 0)
            ? n
            : - n | 0;
    /*<<nativeint.ml:46:40>>*/ }
    /*<<nativeint.ml:48:14>>*/ var
    size = Stdlib_Sys[9],
     /*<<nativeint.ml:48:14>>*/ min_int = 1 << (size - 1 | 0),
     /*<<nativeint.ml:49:14>>*/ max_int = min_int - 1 | 0;
   function lognot(n){
     /*<<nativeint.ml:50:15>>*/ return n ^ -1;
    /*<<nativeint.ml:50:29>>*/ }
   var max_int$0 = Stdlib[19];
   function unsigned_to_int(n){
     /*<<nativeint.ml:55:4>>*/ if
     (0 >=  /*<<nativeint.ml:55:7>>*/ caml_int_compare(0, n)
      && 0 >=  /*<<nativeint.ml:55:30>>*/ caml_int_compare(n, max_int$0))
      /*<<nativeint.ml:56:6>>*/ return [0, n];
     /*<<nativeint.ml:58:6>>*/ return 0;
    /*<<nativeint.ml:58:10>>*/ }
   function to_string(n){
     /*<<nativeint.ml:61:18>>*/ return  /*<<nativeint.ml:61:18>>*/ runtime.caml_format_int
            ("%d", n);
    /*<<nativeint.ml:61:31>>*/ }
   function of_string_opt(s){
     /*<<nativeint.ml:67:2>>*/ try{
      /*<<nativeint.ml:67:6>>*/  /*<<nativeint.ml:67:6>>*/ var
      _b_ = [0,  /*<<nativeint.ml:67:11>>*/ runtime.caml_int_of_string(s)];
      /*<<nativeint.ml:67:6>>*/ return _b_;
    }
    catch(_c_){
     var _a_ = caml_wrap_exception(_c_);
     if(_a_[1] === Stdlib[7])  /*<<nativeint.ml:68:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_a_, 0);
    }
    /*<<nativeint.ml:68:24>>*/ }
   var compare = caml_int_compare;
   function equal(x, y){
     /*<<nativeint.ml:73:26>>*/ return 0
            ===  /*<<nativeint.ml:73:26>>*/ caml_int_compare(x, y)
            ? 1
            : 0;
    /*<<nativeint.ml:73:41>>*/ }
   function unsigned_compare(n, m){
     /*<<nativeint.ml:76:2>>*/ return  /*<<nativeint.ml:76:26>>*/ caml_int_compare
            (n - min_int | 0, m - min_int | 0);
    /*<<nativeint.ml:76:41>>*/ }
   function min(x, y){
     /*<<nativeint.ml:78:18>>*/ return  /*<<nativeint.ml:78:21>>*/ runtime.caml_lessequal
             (x, y)
            ? x
            : y;
    /*<<nativeint.ml:78:41>>*/ }
   function max(x, y){
     /*<<nativeint.ml:79:18>>*/ return  /*<<nativeint.ml:79:21>>*/ caml_greaterequal
             (x, y)
            ? x
            : y;
    /*<<nativeint.ml:79:41>>*/ }
   function unsigned_div(n, d){
     /*<<nativeint.ml:85:2>>*/ if
     ( /*<<nativeint.ml:85:5>>*/ runtime.caml_lessthan(d, 0))
      /*<<nativeint.ml:86:7>>*/ return 0 <= unsigned_compare(n, d)
             ? one
             : zero;
     /*<<nativeint.ml:88:12>>*/ var
      /*<<nativeint.ml:88:12>>*/ q =
        /*<<nativeint.ml:88:23>>*/ runtime.caml_div(n >>> 1 | 0, d) << 1,
      /*<<nativeint.ml:89:12>>*/ r =
       n -  /*<<nativeint.ml:89:18>>*/ caml_mul(q, d) | 0;
     /*<<nativeint.ml:90:7>>*/ return 0 <= unsigned_compare(r, d)
            ? q + 1 | 0
            : q;
    /*<<nativeint.ml:90:51>>*/ }
   function unsigned_rem(n, d){
     /*<<nativeint.ml:93:2>>*/ return n
           -  /*<<nativeint.ml:93:8>>*/ caml_mul(unsigned_div(n, d), d)
           | 0;
    /*<<nativeint.ml:93:34>>*/ }
   function seeded_hash(seed, x){
     /*<<nativeint.ml:97:25>>*/ return  /*<<nativeint.ml:97:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<nativeint.ml:97:56>>*/ }
   function hash(x){
     /*<<nativeint.ml:98:13>>*/ return  /*<<nativeint.ml:98:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<nativeint.ml:98:41>>*/ }
   var
    Stdlib_Nativeint =
      [0,
       zero,
       one,
       -1,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       size,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(12, Stdlib_Nativeint, "Stdlib__Nativeint");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Lexing
//# unitInfo: Requires: Stdlib, Stdlib__Bytes, Stdlib__Int, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst = "",
    caml_bytes_get = runtime.caml_bytes_get,
    caml_check_bound = runtime.caml_check_bound,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    dummy_pos = [0, cst, 0, 0, -1],
    zero_pos = [0, cst, 1, 0, 0],
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Int = global_data.Stdlib__Int,
    cst_Lexing_lex_refill_cannot_g = "Lexing.lex_refill: cannot grow buffer";
   function engine(tbl, state, buf){
     /*<<lexing.ml:65:2>>*/ var
      /*<<lexing.ml:65:15>>*/ result =
        /*<<lexing.ml:65:15>>*/ runtime.caml_lex_engine(tbl, state, buf),
     _n_ = 0 <= result ? 1 : 0,
     _o_ = _n_ ? buf[12] !== dummy_pos ? 1 : 0 : _n_;
    if(_o_){
     buf[11] = buf[12];
     var _p_ = buf[12];
     buf[12] = [0, _p_[1], _p_[2], _p_[3], buf[4] + buf[6] | 0];
    }
     /*<<lexing.ml:71:2>>*/ return result;
    /*<<lexing.ml:71:8>>*/ }
   function new_engine(tbl, state, buf){
     /*<<lexing.ml:75:2>>*/ var
      /*<<lexing.ml:75:15>>*/ result =
        /*<<lexing.ml:75:15>>*/ runtime.caml_new_lex_engine(tbl, state, buf),
     _k_ = 0 <= result ? 1 : 0,
     _l_ = _k_ ? buf[12] !== dummy_pos ? 1 : 0 : _k_;
    if(_l_){
     buf[11] = buf[12];
     var _m_ = buf[12];
     buf[12] = [0, _m_[1], _m_[2], _m_[3], buf[4] + buf[6] | 0];
    }
     /*<<lexing.ml:81:2>>*/ return result;
    /*<<lexing.ml:81:8>>*/ }
   function from_function(opt, read_fun){
     /*<<lexing.ml:148:2>>*/ if(opt)
     var sth = opt[1], with_positions = sth;
    else
     var with_positions = 1;
     /*<<lexing.ml:148:2>>*/ var
      /*<<lexing.ml:148:2>>*/ _f_ = with_positions ? zero_pos : dummy_pos,
     _g_ = with_positions ? zero_pos : dummy_pos,
      /*<<lexing.ml:148:31>>*/ aux_buffer =
        /*<<lexing.ml:148:31>>*/ caml_create_bytes(512);
     /*<<lexing.ml:148:2>>*/ return [0,
            function(lexbuf){
              /*<<lexing.ml:85:4>>*/ var
               /*<<lexing.ml:85:4>>*/ read =
                 /*<<lexing.ml:85:4>>*/ caml_call2
                 (read_fun, aux_buffer, caml_ml_bytes_length(aux_buffer)),
               /*<<lexing.ml:86:2>>*/ n = 0 < read ? read : (lexbuf[9] = 1, 0);
             if(caml_ml_bytes_length(lexbuf[2]) < (lexbuf[3] + n | 0)){
              if
               (((lexbuf[3] - lexbuf[5] | 0) + n | 0)
                <= caml_ml_bytes_length(lexbuf[2]))
                /*<<lexing.ml:100:9>>*/  /*<<lexing.ml:100:9>>*/ caml_call5
                (Stdlib_Bytes[11],
                 lexbuf[2],
                 lexbuf[5],
                 lexbuf[2],
                 0,
                 lexbuf[3] - lexbuf[5] | 0);
              else{
                /*<<lexing.ml:111:8>>*/  /*<<lexing.ml:111:8>>*/ var
                newlen =
                   /*<<lexing.ml:111:8>>*/ caml_call2
                   (Stdlib_Int[10],
                    2 * caml_ml_bytes_length(lexbuf[2]) | 0,
                    Stdlib_Sys[12]);
               if(newlen < ((lexbuf[3] - lexbuf[5] | 0) + n | 0))
                 /*<<lexing.ml:113:11>>*/  /*<<lexing.ml:113:11>>*/ caml_call1
                 (Stdlib[2], cst_Lexing_lex_refill_cannot_g);
                /*<<lexing.ml:114:19>>*/  /*<<lexing.ml:114:19>>*/ var
                newbuf =  /*<<lexing.ml:114:19>>*/ caml_create_bytes(newlen);
                /*<<lexing.ml:116:6>>*/  /*<<lexing.ml:116:6>>*/ caml_call5
                (Stdlib_Bytes[11],
                 lexbuf[2],
                 lexbuf[5],
                 newbuf,
                 0,
                 lexbuf[3] - lexbuf[5] | 0);
               lexbuf[2] = newbuf;
              }
              var s = lexbuf[5];
              lexbuf[4] = lexbuf[4] + s | 0;
              lexbuf[6] = lexbuf[6] - s | 0;
              lexbuf[5] = 0;
              lexbuf[7] = lexbuf[7] - s | 0;
              lexbuf[3] = lexbuf[3] - s | 0;
              var t = lexbuf[10], _i_ = t.length - 1 - 1 | 0, _h_ = 0;
              if(_i_ >= 0){
               var i = _h_;
               for(;;){
                 /*<<lexing.ml:131:14>>*/  /*<<lexing.ml:131:14>>*/ var
                 v = caml_check_bound(t, i)[1 + i];
                if(0 <= v)
                  /*<<lexing.ml:133:8>>*/ caml_check_bound(t, i)[1 + i] = v - s | 0;
                 /*<<lexing.ml:130:4>>*/  /*<<lexing.ml:130:4>>*/ var
                 _j_ = i + 1 | 0;
                if(_i_ === i) break;
                var i = _j_;
               }
              }
             }
              /*<<lexing.ml:137:2>>*/  /*<<lexing.ml:137:2>>*/ caml_call5
              (Stdlib_Bytes[11], aux_buffer, 0, lexbuf[2], lexbuf[3], n);
             lexbuf[3] = lexbuf[3] + n | 0;
             return 0;
            },
             /*<<lexing.ml:149:17>>*/ caml_create_bytes(1024),
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            [0],
            _g_,
            _f_];
    /*<<lexing.ml:160:3>>*/ }
   function from_channel(with_positions, ic){
     /*<<lexing.ml:163:2>>*/ return from_function
            (with_positions,
             function(buf, n){
               /*<<lexing.ml:163:46>>*/ return  /*<<lexing.ml:163:46>>*/ caml_call4
                      (Stdlib[84], ic, buf, 0, n);
              /*<<lexing.ml:163:62>>*/ });
    /*<<lexing.ml:163:63>>*/ }
   function from_string(opt, s){
     /*<<lexing.ml:166:2>>*/ if(opt)
     var sth = opt[1], with_positions = sth;
    else
     var with_positions = 1;
     /*<<lexing.ml:166:2>>*/ var
      /*<<lexing.ml:166:2>>*/ _d_ = with_positions ? zero_pos : dummy_pos,
     _e_ = with_positions ? zero_pos : dummy_pos;
     /*<<lexing.ml:166:2>>*/ return [0,
            function(lexbuf){
              /*<<lexing.ml:166:33>>*/ lexbuf[9] = 1;
             return 0;
             /*<<lexing.ml:166:63>>*/ },
             /*<<lexing.ml:167:17>>*/ caml_call1(Stdlib_Bytes[5], s),
            runtime.caml_ml_string_length(s),
            0,
            0,
            0,
            0,
            0,
            1,
            [0],
            _e_,
            _d_];
    /*<<lexing.ml:179:3>>*/ }
   function set_position(lexbuf, position){
     /*<<lexing.ml:182:2>>*/ lexbuf[12] =
     [0, lexbuf[12][1], position[2], position[3], position[4]];
    lexbuf[4] = position[4];
    return 0;
    /*<<lexing.ml:183:41>>*/ }
   function set_filename(lexbuf, fname){
     /*<<lexing.ml:186:2>>*/ var _c_ = lexbuf[12];
    lexbuf[12] = [0, fname, _c_[2], _c_[3], _c_[4]];
    return 0;
    /*<<lexing.ml:186:65>>*/ }
   function with_positions(lexbuf){
     /*<<lexing.ml:188:28>>*/ return lexbuf[12] !== dummy_pos ? 1 : 0;
    /*<<lexing.ml:188:58>>*/ }
   function lexeme(lexbuf){
     /*<<lexing.ml:191:2>>*/ var len = lexbuf[6] - lexbuf[5] | 0;
     /*<<lexing.ml:192:2>>*/ return  /*<<lexing.ml:192:2>>*/ caml_call3
            (Stdlib_Bytes[8], lexbuf[2], lexbuf[5], len);
    /*<<lexing.ml:192:61>>*/ }
   function sub_lexeme(lexbuf, i1, i2){
     /*<<lexing.ml:195:2>>*/ var len = i2 - i1 | 0;
     /*<<lexing.ml:196:2>>*/ return  /*<<lexing.ml:196:2>>*/ caml_call3
            (Stdlib_Bytes[8], lexbuf[2], i1, len);
    /*<<lexing.ml:196:43>>*/ }
   function sub_lexeme_opt(lexbuf, i1, i2){
     /*<<lexing.ml:199:2>>*/ if(0 > i1)  /*<<lexing.ml:202:11>>*/ return 0;
    var len = i2 - i1 | 0;
     /*<<lexing.ml:201:4>>*/ return [0,
             /*<<lexing.ml:201:9>>*/ caml_call3
             (Stdlib_Bytes[8], lexbuf[2], i1, len)];
    /*<<lexing.ml:204:5>>*/ }
   function sub_lexeme_char(lexbuf, i){
     /*<<lexing.ml:206:31>>*/ return  /*<<lexing.ml:206:31>>*/ caml_bytes_get
            (lexbuf[2], i);
    /*<<lexing.ml:206:60>>*/ }
   function sub_lexeme_char_opt(lexbuf, i){
     /*<<lexing.ml:209:2>>*/ return 0 <= i
            ? [0,  /*<<lexing.ml:210:9>>*/ caml_bytes_get(lexbuf[2], i)]
            : 0;
    /*<<lexing.ml:212:8>>*/ }
   function lexeme_char(lexbuf, i){
     /*<<lexing.ml:216:2>>*/ return  /*<<lexing.ml:216:2>>*/ caml_bytes_get
            (lexbuf[2], lexbuf[5] + i | 0);
    /*<<lexing.ml:216:56>>*/ }
   function lexeme_start(lexbuf){
     /*<<lexing.ml:218:26>>*/ return lexbuf[11][4];
    /*<<lexing.ml:218:53>>*/ }
   function lexeme_end(lexbuf){
     /*<<lexing.ml:219:24>>*/ return lexbuf[12][4];
    /*<<lexing.ml:219:50>>*/ }
   function lexeme_start_p(lexbuf){
     /*<<lexing.ml:221:28>>*/ return lexbuf[11];
    /*<<lexing.ml:221:46>>*/ }
   function lexeme_end_p(lexbuf){
     /*<<lexing.ml:222:26>>*/ return lexbuf[12];
    /*<<lexing.ml:222:43>>*/ }
   function new_line(lexbuf){
     /*<<lexing.ml:225:2>>*/ var
     lcp = lexbuf[12],
     _a_ = lcp !== dummy_pos ? 1 : 0,
     _b_ =
       _a_
        ? (lexbuf[12] = [0, lcp[1], lcp[2] + 1 | 0, lcp[4], lcp[4]], 0)
        : _a_;
    return _b_;
    /*<<lexing.ml:231:7>>*/ }
   function flush_input(lb){
     /*<<lexing.ml:238:2>>*/ lb[6] = 0;
    lb[4] = 0;
    var lcp = lb[12];
    if(lcp !== dummy_pos)
     lb[12] = [0, lcp[1], zero_pos[2], zero_pos[3], zero_pos[4]];
    lb[3] = 0;
    return 0;
    /*<<lexing.ml:243:25>>*/ }
   var
    Stdlib_Lexing =
      [0,
       dummy_pos,
       from_channel,
       from_string,
       from_function,
       set_position,
       set_filename,
       with_positions,
       lexeme,
       lexeme_char,
       lexeme_start,
       lexeme_end,
       lexeme_start_p,
       lexeme_end_p,
       new_line,
       flush_input,
       sub_lexeme,
       sub_lexeme_opt,
       sub_lexeme_char,
       sub_lexeme_char_opt,
       engine,
       new_engine];
   runtime.caml_register_global(7, Stdlib_Lexing, "Stdlib__Lexing");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Parsing
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Lexing, Stdlib__Obj
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_check_bound = runtime.caml_check_bound,
    caml_fresh_oo_id = runtime.caml_fresh_oo_id,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
    /*<<parsing.ml:59:0>>*/ var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Obj = global_data.Stdlib__Obj,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Lexing = global_data.Stdlib__Lexing,
     /*<<parsing.ml:59:0>>*/ YYexit =
      [248, "Stdlib.Parsing.YYexit", caml_fresh_oo_id(0)],
     /*<<parsing.ml:60:0>>*/ Parse_error =
      [248, "Stdlib.Parsing.Parse_error", caml_fresh_oo_id(0)],
     /*<<parsing.ml:90:2>>*/ env =
      [0,
        /*<<parsing.ml:90:14>>*/ caml_make_vect(100, 0),
        /*<<parsing.ml:91:14>>*/ caml_make_vect(100, 0),
        /*<<parsing.ml:92:23>>*/ caml_make_vect(100, Stdlib_Lexing[1]),
        /*<<parsing.ml:93:21>>*/ caml_make_vect(100, Stdlib_Lexing[1]),
       100,
       0,
       0,
       0,
       Stdlib_Lexing[1],
       Stdlib_Lexing[1],
       0,
       0,
       0,
       0,
       0,
       0];
   function grow_stacks(param){
     /*<<parsing.ml:108:2>>*/ var
     oldsize = env[5],
     newsize = oldsize * 2 | 0,
      /*<<parsing.ml:110:14>>*/ new_s =
        /*<<parsing.ml:110:14>>*/ caml_make_vect(newsize, 0),
      /*<<parsing.ml:111:14>>*/ new_v =
        /*<<parsing.ml:111:14>>*/ caml_make_vect(newsize, 0),
      /*<<parsing.ml:112:18>>*/ new_start =
        /*<<parsing.ml:112:18>>*/ caml_make_vect(newsize, Stdlib_Lexing[1]),
      /*<<parsing.ml:113:16>>*/ new_end =
        /*<<parsing.ml:113:16>>*/ caml_make_vect(newsize, Stdlib_Lexing[1]);
     /*<<parsing.ml:114:4>>*/  /*<<parsing.ml:114:4>>*/ caml_call5
     (Stdlib_Array[8], env[1], 0, new_s, 0, oldsize);
    env[1] = new_s;
     /*<<parsing.ml:116:4>>*/  /*<<parsing.ml:116:4>>*/ caml_call5
     (Stdlib_Array[8], env[2], 0, new_v, 0, oldsize);
    env[2] = new_v;
     /*<<parsing.ml:118:4>>*/  /*<<parsing.ml:118:4>>*/ caml_call5
     (Stdlib_Array[8], env[3], 0, new_start, 0, oldsize);
    env[3] = new_start;
     /*<<parsing.ml:120:4>>*/  /*<<parsing.ml:120:4>>*/ caml_call5
     (Stdlib_Array[8], env[4], 0, new_end, 0, oldsize);
    env[4] = new_end;
    env[5] = newsize;
    return;
    /*<<parsing.ml:122:28>>*/ }
   function clear_parser(param){
     /*<<parsing.ml:125:2>>*/  /*<<parsing.ml:125:2>>*/ caml_call4
     (Stdlib_Array[7], env[2], 0, env[5], 0);
    env[8] = 0;
    return 0;
    /*<<parsing.ml:126:25>>*/ }
    /*<<parsing.ml:128:28>>*/ var
     /*<<parsing.ml:128:28>>*/ current_lookahead_fun =
      [0,
       function(param){
         /*<<parsing.ml:128:52>>*/ return 0;
        /*<<parsing.ml:128:57>>*/ }],
    cst_syntax_error = "syntax error";
   function yyparse(tables, start, lexer, lexbuf){
     /*<<parsing.ml:131:2>>*/ var
     init_asp = env[11],
     init_sp = env[14],
     init_stackbase = env[6],
     init_state = env[15],
     init_curr_char = env[7],
     init_lval = env[8],
     init_errflag = env[16];
    env[6] = env[14] + 1 | 0;
    env[7] = start;
    env[10] = lexbuf[12];
     /*<<parsing.ml:164:2>>*/ try{
     var cmd = 0, arg = 0;
      /*<<parsing.ml:132:4>>*/ for(;;)
      switch
       ( /*<<parsing.ml:132:10>>*/ runtime.caml_parse_engine
         (tables, env, cmd, arg)){
        case 0:
          /*<<parsing.ml:134:24>>*/  /*<<parsing.ml:134:24>>*/ var
          arg$0 =  /*<<parsing.ml:134:24>>*/ caml_call1(lexer, lexbuf);
         env[9] = lexbuf[11];
         env[10] = lexbuf[12];
         var cmd = 1, arg = arg$0;
         break;
        case 1:
          /*<<parsing.ml:139:8>>*/ throw  /*<<parsing.ml:139:8>>*/ caml_maybe_attach_backtrace
                (Parse_error, 1);
        case 2:
          /*<<parsing.ml:148:8>>*/ grow_stacks(0);
         var cmd = 2, arg = 0;
         break;
        case 3:
          /*<<parsing.ml:150:8>>*/ grow_stacks(0);
         var cmd = 3, arg = 0;
         break;
        case 4:
         try{
           /*<<parsing.ml:143:39>>*/ var
           _i_ = env[13],
            /*<<parsing.ml:143:39>>*/ _j_ =
              /*<<parsing.ml:143:39>>*/ caml_call1
              (caml_check_bound(tables[1], _i_)[1 + _i_], env),
            /*<<parsing.ml:143:39>>*/ _k_ = 4,
           value = _j_,
           action = _k_;
         }
         catch(_m_){
          var _h_ = caml_wrap_exception(_m_);
          if(_h_ !== Parse_error) throw caml_maybe_attach_backtrace(_h_, 0);
          var value = 0, action = 5;
         }
         var cmd = action, arg = value;
         break;
        default:
          /*<<parsing.ml:152:8>>*/  /*<<parsing.ml:152:8>>*/ caml_call1
          (tables[14], cst_syntax_error);
         var cmd = 5, arg = 0;
      }
    }
    catch(exn$0){
      /*<<parsing.ml:167:4>>*/ var
      exn = caml_wrap_exception(exn$0),
       /*<<parsing.ml:167:4>>*/ curr_char = env[7];
     env[11] = init_asp;
     env[14] = init_sp;
     env[6] = init_stackbase;
     env[15] = init_state;
     env[7] = init_curr_char;
     env[8] = init_lval;
     env[16] = init_errflag;
     if(exn[1] === YYexit){
      var v = exn[2];
       /*<<parsing.ml:177:8>>*/ return v;
     }
     current_lookahead_fun[1] =
      function(tok){
        /*<<parsing.ml:181:12>>*/ if
        (!  /*<<parsing.ml:181:15>>*/ caml_call1(Stdlib_Obj[1], tok))
         /*<<parsing.ml:183:17>>*/ return caml_check_bound(tables[2], tok)
                 [1 + tok]
                === curr_char
                ? 1
                : 0;
        /*<<parsing.ml:182:38>>*/  /*<<parsing.ml:182:38>>*/ var
        _l_ =  /*<<parsing.ml:182:38>>*/ runtime.caml_obj_tag(tok);
        /*<<parsing.ml:182:17>>*/ return caml_check_bound(tables[3], _l_)
                [1 + _l_]
               === curr_char
               ? 1
               : 0;
       /*<<parsing.ml:183:64>>*/ };
      /*<<parsing.ml:184:8>>*/ throw  /*<<parsing.ml:184:8>>*/ caml_maybe_attach_backtrace
            (exn, 0);
    }
    /*<<parsing.ml:184:17>>*/ }
   function peek_val(env, n){
     /*<<parsing.ml:187:2>>*/ var _g_ = env[11] - n | 0;
     /*<<parsing.ml:187:12>>*/ return caml_check_bound(env[2], _g_)[1 + _g_];
    /*<<parsing.ml:187:37>>*/ }
   function symbol_start_pos(param){
     /*<<parsing.ml:190:2>>*/ var i$1 = env[12], i = i$1;
     /*<<parsing.ml:191:4>>*/ for(;;){
     if(0 >= i){
      var _f_ = env[11];
       /*<<parsing.ml:191:19>>*/ return caml_check_bound(env[4], _f_)[1 + _f_];
     }
      /*<<parsing.ml:193:15>>*/ var
      _d_ = (env[11] - i | 0) + 1 | 0,
       /*<<parsing.ml:193:15>>*/ st = caml_check_bound(env[3], _d_)[1 + _d_],
      _e_ = (env[11] - i | 0) + 1 | 0,
       /*<<parsing.ml:194:15>>*/ en = caml_check_bound(env[4], _e_)[1 + _e_];
      /*<<parsing.ml:195:9>>*/ if
      ( /*<<parsing.ml:195:9>>*/ runtime.caml_notequal(st, en))
       /*<<parsing.ml:195:23>>*/ return st;
      /*<<parsing.ml:195:31>>*/ var
       /*<<parsing.ml:195:31>>*/ i$0 = i - 1 | 0,
      i = i$0;
    }
    /*<<parsing.ml:198:19>>*/ }
   function symbol_end_pos(param){
     /*<<parsing.ml:200:24>>*/ var _c_ = env[11];
     /*<<parsing.ml:200:24>>*/ return caml_check_bound(env[4], _c_)[1 + _c_];
    /*<<parsing.ml:200:52>>*/ }
   function rhs_start_pos(n){
     /*<<parsing.ml:201:22>>*/ var _b_ = env[11] - (env[12] - n | 0) | 0;
     /*<<parsing.ml:201:22>>*/ return caml_check_bound(env[3], _b_)[1 + _b_];
    /*<<parsing.ml:201:73>>*/ }
   function rhs_end_pos(n){
     /*<<parsing.ml:202:20>>*/ var _a_ = env[11] - (env[12] - n | 0) | 0;
     /*<<parsing.ml:202:20>>*/ return caml_check_bound(env[4], _a_)[1 + _a_];
    /*<<parsing.ml:202:69>>*/ }
   function symbol_start(param){
     /*<<parsing.ml:204:22>>*/ return symbol_start_pos(0)[4];
    /*<<parsing.ml:204:52>>*/ }
   function symbol_end(param){
     /*<<parsing.ml:205:20>>*/ return symbol_end_pos(0)[4];
    /*<<parsing.ml:205:48>>*/ }
   function rhs_start(n){
     /*<<parsing.ml:206:18>>*/ return rhs_start_pos(n)[4];
    /*<<parsing.ml:206:44>>*/ }
   function rhs_end(n){
     /*<<parsing.ml:207:16>>*/ return rhs_end_pos(n)[4];
    /*<<parsing.ml:207:40>>*/ }
   function is_current_lookahead(tok){
     /*<<parsing.ml:210:2>>*/ return  /*<<parsing.ml:210:2>>*/ caml_call1
            (current_lookahead_fun[1], tok);
    /*<<parsing.ml:210:40>>*/ }
   function parse_error(param){
     /*<<parsing.ml:212:31>>*/ return 0;
    /*<<parsing.ml:212:33>>*/ }
   var
    Stdlib_Parsing =
      [0,
       symbol_start,
       symbol_end,
       rhs_start,
       rhs_end,
       symbol_start_pos,
       symbol_end_pos,
       rhs_start_pos,
       rhs_end_pos,
       clear_parser,
       Parse_error,
       runtime.caml_set_parser_trace,
       YYexit,
       yyparse,
       peek_val,
       is_current_lookahead,
       parse_error];
   runtime.caml_register_global(7, Stdlib_Parsing, "Stdlib__Parsing");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Set
//# unitInfo: Requires: Stdlib, Stdlib__List, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Set_bal$3 = "Set.bal",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    Assert_failure = global_data.Assert_failure,
    cst_Set_bal = cst_Set_bal$3,
    cst_Set_bal$0 = cst_Set_bal$3,
    cst_Set_bal$1 = cst_Set_bal$3,
    cst_Set_bal$2 = cst_Set_bal$3,
    cst_Set_remove_min_elt = "Set.remove_min_elt",
    _a_ = [0, 0, 0, 0],
    _b_ = [0, 0, 0],
    _c_ = [0, "set.ml", 571, 18],
    Stdlib_Set =
      [0,
       function(Ord){
        function height(param){
          /*<<set.ml:81:17>>*/ if(! param)  /*<<set.ml:82:17>>*/ return 0;
         var h = param[4];
          /*<<set.ml:83:20>>*/ return h;
         /*<<set.ml:83:21>>*/ }
        function create(l, v, r){
          /*<<set.ml:91:6>>*/ if(l) var h = l[4], hl = h; else var hl = 0;
          /*<<set.ml:92:6>>*/ if(r) var h$0 = r[4], hr = h$0; else var hr = 0;
         var _Y_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
          /*<<set.ml:93:10>>*/ return [0, l, v, r, _Y_];
         /*<<set.ml:93:60>>*/ }
        function bal(l, v, r){
          /*<<set.ml:101:6>>*/ if(l) var h = l[4], hl = h; else var hl = 0;
          /*<<set.ml:102:6>>*/ if(r)
          var h$0 = r[4], hr = h$0;
         else
          var hr = 0;
         if((hr + 2 | 0) < hl){
          if(! l)
            /*<<set.ml:105:19>>*/ return  /*<<set.ml:105:19>>*/ caml_call1
                   (Stdlib[1], cst_Set_bal$0);
           /*<<set.ml:107:28>>*/ var
           lr = l[3],
           lv = l[2],
           ll = l[1],
            /*<<set.ml:107:28>>*/ _T_ = height(lr);
          if(_T_ <= height(ll))
            /*<<set.ml:108:27>>*/ return create(ll, lv, create(lr, v, r));
          if(! lr)
            /*<<set.ml:111:25>>*/ return  /*<<set.ml:111:25>>*/ caml_call1
                   (Stdlib[1], cst_Set_bal);
           /*<<set.ml:113:48>>*/ var
           lrr = lr[3],
           lrv = lr[2],
           lrl = lr[1],
            /*<<set.ml:113:48>>*/ _U_ = create(lrr, v, r);
           /*<<set.ml:113:48>>*/ return create(create(ll, lv, lrl), lrv, _U_);
         }
         if((hl + 2 | 0) >= hr){
          var _X_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
           /*<<set.ml:128:12>>*/ return [0, l, v, r, _X_];
         }
         if(! r)
           /*<<set.ml:117:19>>*/ return  /*<<set.ml:117:19>>*/ caml_call1
                  (Stdlib[1], cst_Set_bal$2);
          /*<<set.ml:119:28>>*/ var
          rr = r[3],
          rv = r[2],
          rl = r[1],
           /*<<set.ml:119:28>>*/ _V_ = height(rl);
         if(_V_ <= height(rr))
           /*<<set.ml:120:14>>*/ return create(create(l, v, rl), rv, rr);
         if(! rl)
           /*<<set.ml:123:25>>*/ return  /*<<set.ml:123:25>>*/ caml_call1
                  (Stdlib[1], cst_Set_bal$1);
          /*<<set.ml:125:46>>*/ var
          rlr = rl[3],
          rlv = rl[2],
          rll = rl[1],
           /*<<set.ml:125:46>>*/ _W_ = create(rlr, rv, rr);
          /*<<set.ml:125:46>>*/ return create(create(l, v, rll), rlv, _W_);
         /*<<set.ml:128:62>>*/ }
        function add(x, t){
          /*<<?>>*/ if(! t)  /*<<set.ml:133:21>>*/ return [0, 0, x, 0, 1];
          /*<<set.ml:135:18>>*/ var
          r = t[3],
          v = t[2],
          l = t[1],
           /*<<set.ml:135:18>>*/ c =
             /*<<set.ml:135:18>>*/ caml_call2(Ord[1], x, v);
          /*<<set.ml:136:10>>*/ if(0 === c)  /*<<set.ml:136:24>>*/ return t;
         if(0 <= c){
           /*<<set.ml:141:21>>*/  /*<<set.ml:141:21>>*/ var rr = add(x, r);
          return r === rr ? t : bal(l, v, rr);
         }
          /*<<set.ml:138:21>>*/  /*<<set.ml:138:21>>*/ var ll = add(x, l);
         return l === ll ? t : bal(ll, v, r);
        }
        function singleton(x){
          /*<<set.ml:144:22>>*/ return [0, 0, x, 0, 1];
         /*<<set.ml:144:54>>*/ }
        function add_min_element(x, param){
          /*<<?>>*/ if(! param)  /*<<set.ml:154:17>>*/ return singleton(x);
         var r = param[3], v = param[2], l = param[1];
          /*<<set.ml:156:8>>*/ return bal(add_min_element(x, l), v, r);
        }
        function add_max_element(x, param){
          /*<<?>>*/ if(! param)  /*<<set.ml:159:17>>*/ return singleton(x);
         var r = param[3], v = param[2], l = param[1];
          /*<<set.ml:161:16>>*/ return bal(l, v, add_max_element(x, r));
        }
        function join(l, v, r){
          /*<<set.ml:167:6>>*/ if(! l)
           /*<<set.ml:168:22>>*/ return add_min_element(v, r);
         if(! r)  /*<<set.ml:169:22>>*/ return add_max_element(v, l);
         var
          rh = r[4],
          rr = r[3],
          rv = r[2],
          rl = r[1],
          lh = l[4],
          lr = l[3],
          lv = l[2],
          ll = l[1];
         return (rh + 2 | 0) < lh
                 ? bal(ll, lv, join(lr, v, r))
                 : (lh
                   + 2
                   | 0)
                   < rh
                   ? bal(join(l, v, rl), rv, rr)
                   : create(l, v, r);
         /*<<set.ml:173:22>>*/ }
        function min_elt(param){
          /*<<set.ml:177:22>>*/ var param$0 = param;
          /*<<set.ml:177:22>>*/ for(;;){
          if(! param$0)
            /*<<set.ml:178:17>>*/ throw  /*<<set.ml:178:17>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var l = param$0[1];
          if(! l){var v = param$0[2];  /*<<set.ml:179:28>>*/ return v;}
          var param$0 = l;
         }
         /*<<set.ml:180:28>>*/ }
        function min_elt_opt(param){
          /*<<set.ml:182:26>>*/ var param$0 = param;
          /*<<set.ml:182:26>>*/ for(;;){
          if(! param$0)  /*<<set.ml:183:17>>*/ return 0;
          var l = param$0[1];
          if(! l){var v = param$0[2];  /*<<set.ml:184:28>>*/ return [0, v];}
          var param$0 = l;
         }
         /*<<set.ml:185:32>>*/ }
        function max_elt(param){
          /*<<set.ml:187:22>>*/ var param$0 = param;
          /*<<set.ml:187:22>>*/ for(;;){
          if(! param$0)
            /*<<set.ml:188:17>>*/ throw  /*<<set.ml:188:17>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          if(! param$0[3]){
           var v = param$0[2];
            /*<<set.ml:189:28>>*/ return v;
          }
          var r = param$0[3], param$0 = r;
         }
         /*<<set.ml:190:28>>*/ }
        function max_elt_opt(param){
          /*<<set.ml:192:26>>*/ var param$0 = param;
          /*<<set.ml:192:26>>*/ for(;;){
          if(! param$0)  /*<<set.ml:193:17>>*/ return 0;
          if(! param$0[3]){
           var v = param$0[2];
            /*<<set.ml:194:28>>*/ return [0, v];
          }
          var r = param$0[3], param$0 = r;
         }
         /*<<set.ml:195:32>>*/ }
        function remove_min_elt(param){
          /*<<set.ml:199:29>>*/ if(! param)
           /*<<set.ml:200:17>>*/ return  /*<<set.ml:200:17>>*/ caml_call1
                  (Stdlib[1], cst_Set_remove_min_elt);
         var l = param[1];
         if(l){
          var r = param[3], v = param[2];
           /*<<set.ml:202:25>>*/ return bal(remove_min_elt(l), v, r);
         }
         var r$0 = param[3];
          /*<<set.ml:201:28>>*/ return r$0;
         /*<<set.ml:202:51>>*/ }
        function concat(t1, t2){
          /*<<set.ml:219:6>>*/ if(! t1)  /*<<set.ml:220:22>>*/ return t2;
         if(! t2)  /*<<set.ml:221:22>>*/ return t1;
          /*<<set.ml:222:39>>*/  /*<<set.ml:222:39>>*/ var
          _S_ = remove_min_elt(t2);
          /*<<set.ml:222:39>>*/ return join(t1, min_elt(t2), _S_);
         /*<<set.ml:222:58>>*/ }
        function split(x, param){
          /*<<?>>*/ if(! param)  /*<<set.ml:232:10>>*/ return _a_;
          /*<<set.ml:234:18>>*/ var
          r = param[3],
          v = param[2],
          l = param[1],
           /*<<set.ml:234:18>>*/ c =
             /*<<set.ml:234:18>>*/ caml_call2(Ord[1], x, v);
          /*<<set.ml:235:10>>*/ if(0 === c)
           /*<<set.ml:235:24>>*/ return [0, l, 1, r];
         if(0 <= c){
           /*<<set.ml:239:33>>*/ var
            /*<<set.ml:239:33>>*/ match = split(x, r),
           rr = match[3],
           pres = match[2],
           lr = match[1];
           /*<<set.ml:239:46>>*/ return [0, join(l, v, lr), pres, rr];
         }
          /*<<set.ml:237:33>>*/ var
           /*<<set.ml:237:33>>*/ match$0 = split(x, l),
          rl = match$0[3],
          pres$0 = match$0[2],
          ll = match$0[1];
          /*<<set.ml:237:46>>*/ return [0, ll, pres$0, join(rl, v, r)];
        }
        var empty = 0;
        function is_empty(param){
          /*<<set.ml:245:19>>*/ return param ? 0 : 1;
         /*<<set.ml:245:54>>*/ }
        function mem(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:248:17>>*/ return 0;
           /*<<set.ml:250:18>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:250:18>>*/ c =
              /*<<set.ml:250:18>>*/ caml_call2(Ord[1], x, v),
           _R_ = 0 === c ? 1 : 0;
          if(_R_) return _R_;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function remove(x, t){
          /*<<?>>*/ if(! t)  /*<<set.ml:254:17>>*/ return 0;
          /*<<set.ml:256:18>>*/ var
          t2 = t[3],
          v = t[2],
          t1 = t[1],
           /*<<set.ml:256:18>>*/ c =
             /*<<set.ml:256:18>>*/ caml_call2(Ord[1], x, v);
          /*<<set.ml:257:10>>*/ if(0 === c){
          if(! t1)  /*<<set.ml:210:22>>*/ return t2;
          if(! t2)  /*<<set.ml:211:22>>*/ return t1;
           /*<<set.ml:212:38>>*/  /*<<set.ml:212:38>>*/ var
           _Q_ = remove_min_elt(t2);
           /*<<set.ml:212:38>>*/ return bal(t1, min_elt(t2), _Q_);
         }
         if(0 <= c){
           /*<<set.ml:264:23>>*/  /*<<set.ml:264:23>>*/ var
           rr = remove(x, t2);
          return t2 === rr ? t : bal(t1, v, rr);
         }
          /*<<set.ml:260:23>>*/  /*<<set.ml:260:23>>*/ var ll = remove(x, t1);
         return t1 === ll ? t : bal(ll, v, t2);
        }
        function union(s1, s2){
          /*<<set.ml:269:6>>*/ if(! s1)  /*<<set.ml:270:23>>*/ return s2;
         if(! s2)  /*<<set.ml:271:23>>*/ return s1;
         var
          h2 = s2[4],
          r2 = s2[3],
          v2 = s2[2],
          l2 = s2[1],
          h1 = s1[4],
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1];
         if(h2 <= h1){
          if(1 === h2)  /*<<set.ml:274:27>>*/ return add(v2, s1);
           /*<<set.ml:275:32>>*/ var
            /*<<set.ml:275:32>>*/ match = split(v1, s2),
           r2$0 = match[3],
           l2$0 = match[1],
            /*<<set.ml:276:36>>*/ _O_ = union(r1, r2$0);
           /*<<set.ml:276:36>>*/ return join(union(l1, l2$0), v1, _O_);
         }
         if(1 === h1)  /*<<set.ml:279:27>>*/ return add(v1, s2);
          /*<<set.ml:280:32>>*/ var
           /*<<set.ml:280:32>>*/ match$0 = split(v2, s1),
          r1$0 = match$0[3],
          l1$0 = match$0[1],
           /*<<set.ml:281:36>>*/ _P_ = union(r1$0, r2);
          /*<<set.ml:281:36>>*/ return join(union(l1$0, l2), v2, _P_);
         /*<<set.ml:282:15>>*/ }
        function inter(s1, s2){
          /*<<set.ml:285:6>>*/ if(! s1)  /*<<set.ml:286:22>>*/ return 0;
         if(! s2)  /*<<set.ml:287:22>>*/ return 0;
          /*<<set.ml:289:16>>*/ var
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1],
           /*<<set.ml:289:16>>*/ _L_ = split(v1, s2),
          l2 = _L_[1];
         if(_L_[2]){
           /*<<set.ml:293:36>>*/ var
           r2 = _L_[3],
            /*<<set.ml:293:36>>*/ _M_ = inter(r1, r2);
           /*<<set.ml:293:36>>*/ return join(inter(l1, l2), v1, _M_);
         }
          /*<<set.ml:291:35>>*/ var
          r2$0 = _L_[3],
           /*<<set.ml:291:35>>*/ _N_ = inter(r1, r2$0);
          /*<<set.ml:291:35>>*/ return concat(inter(l1, l2), _N_);
         /*<<set.ml:293:49>>*/ }
        function split_bis(x, param){
          /*<<?>>*/ if(! param)
           /*<<set.ml:305:10>>*/ return [0,
                  0,
                  function(param){
                    /*<<set.ml:305:38>>*/ return 0;
                   /*<<set.ml:305:43>>*/ }];
          /*<<set.ml:307:18>>*/ var
          r = param[3],
          v = param[2],
          l = param[1],
           /*<<set.ml:307:18>>*/ c =
             /*<<set.ml:307:18>>*/ caml_call2(Ord[1], x, v);
          /*<<set.ml:308:10>>*/ if(0 === c)  /*<<set.ml:308:24>>*/ return 0;
         if(0 <= c){
           /*<<set.ml:314:18>>*/  /*<<set.ml:314:18>>*/ var
           match = split_bis(x, r);
          if(! match)  /*<<set.ml:315:23>>*/ return 0;
          var rr = match[2], lr = match[1];
           /*<<set.ml:316:35>>*/ return [0, join(l, v, lr), rr];
         }
          /*<<set.ml:310:18>>*/  /*<<set.ml:310:18>>*/ var
          match$0 = split_bis(x, l);
         if(! match$0)  /*<<set.ml:311:23>>*/ return 0;
         var rl = match$0[2], ll = match$0[1];
          /*<<set.ml:312:35>>*/ return [0,
                 ll,
                 function(param){
                   /*<<set.ml:312:60>>*/ return join(rl(0), v, r);
                  /*<<set.ml:312:76>>*/ }];
        }
        function disjoint(s1, s2){
          /*<<set.ml:319:6>>*/ var s1$0 = s1, s2$0 = s2;
          /*<<set.ml:319:6>>*/ for(;;){
          if(s1$0 && s2$0){
           var r1 = s1$0[3], v1 = s1$0[2], l1 = s1$0[1];
           if(s1$0 === s2$0)  /*<<set.ml:322:27>>*/ return 0;
            /*<<set.ml:323:21>>*/  /*<<set.ml:323:21>>*/ var
            match = split_bis(v1, s2$0);
           if(! match)  /*<<set.ml:325:23>>*/ return 0;
            /*<<set.ml:324:34>>*/ var
            r2 = match[2],
            l2 = match[1],
             /*<<set.ml:324:34>>*/ _K_ = disjoint(l1, l2);
            /*<<set.ml:324:34>>*/ if(! _K_)  /*<<set.ml:324:34>>*/ return _K_;
            /*<<set.ml:324:64>>*/ var
             /*<<set.ml:324:64>>*/ s2$1 = r2(0),
            s1$0 = r1,
            s2$0 = s2$1;
           continue;
          }
           /*<<set.ml:320:35>>*/ return 1;
         }
         /*<<set.ml:325:28>>*/ }
        function diff(s1, s2){
          /*<<set.ml:328:6>>*/ if(! s1)  /*<<set.ml:329:22>>*/ return 0;
         if(! s2)  /*<<set.ml:330:23>>*/ return s1;
          /*<<set.ml:332:16>>*/ var
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1],
           /*<<set.ml:332:16>>*/ _H_ = split(v1, s2),
          l2 = _H_[1];
         if(_H_[2]){
           /*<<set.ml:336:34>>*/ var
           r2 = _H_[3],
            /*<<set.ml:336:34>>*/ _I_ = diff(r1, r2);
           /*<<set.ml:336:34>>*/ return concat(diff(l1, l2), _I_);
         }
          /*<<set.ml:334:35>>*/ var
          r2$0 = _H_[3],
           /*<<set.ml:334:35>>*/ _J_ = diff(r1, r2$0);
          /*<<set.ml:334:35>>*/ return join(diff(l1, l2), v1, _J_);
         /*<<set.ml:336:46>>*/ }
        function cons_enum(s, e){
          /*<<set.ml:341:6>>*/ var s$0 = s, e$0 = e;
          /*<<set.ml:341:6>>*/ for(;;){
          if(! s$0)  /*<<set.ml:342:17>>*/ return e$0;
           /*<<set.ml:343:37>>*/ var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
            /*<<set.ml:343:37>>*/ e$1 = [0, v, r, e$0],
           s$0 = l,
           e$0 = e$1;
         }
         /*<<set.ml:343:52>>*/ }
        function compare(s1, s2){
          /*<<set.ml:357:6>>*/ var
           /*<<set.ml:357:37>>*/ e2$2 = cons_enum(s2, 0),
           /*<<set.ml:357:18>>*/ e1$2 = cons_enum(s1, 0),
          e1 = e1$2,
          e2 = e2$2;
          /*<<set.ml:346:8>>*/ for(;;){
          if(! e1) return e2 ? -1 : 0;
          if(! e2)  /*<<set.ml:349:20>>*/ return 1;
           /*<<set.ml:351:18>>*/ var
           e2$0 = e2[3],
           r2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[3],
           r1 = e1[2],
           v1 = e1[1],
            /*<<set.ml:351:18>>*/ c =
              /*<<set.ml:351:18>>*/ caml_call2(Ord[1], v1, v2);
           /*<<set.ml:352:10>>*/ if(0 !== c)  /*<<set.ml:353:15>>*/ return c;
           /*<<set.ml:354:45>>*/ var
            /*<<set.ml:354:45>>*/ e2$1 = cons_enum(r2, e2$0),
            /*<<set.ml:354:27>>*/ e1$1 = cons_enum(r1, e1$0),
           e1 = e1$1,
           e2 = e2$1;
         }
         /*<<set.ml:357:55>>*/ }
        function equal(s1, s2){
          /*<<set.ml:360:6>>*/ return 0 === compare(s1, s2) ? 1 : 0;
         /*<<set.ml:360:23>>*/ }
        function subset(s1, s2){
          /*<<set.ml:363:6>>*/ var s1$0 = s1, s2$0 = s2;
          /*<<set.ml:363:6>>*/ for(;;){
          if(! s1$0)  /*<<set.ml:365:10>>*/ return 1;
          if(! s2$0)  /*<<set.ml:367:10>>*/ return 0;
           /*<<set.ml:369:18>>*/ var
           r2 = s2$0[3],
           v2 = s2$0[2],
           l2 = s2$0[1],
           r1 = s1$0[3],
           v1 = s1$0[2],
           l1 = s1$0[1],
            /*<<set.ml:369:18>>*/ c =
              /*<<set.ml:369:18>>*/ caml_call2(Ord[1], v1, v2);
           /*<<set.ml:370:10>>*/ if(0 === c){
            /*<<set.ml:371:12>>*/  /*<<set.ml:371:12>>*/ var
            _E_ = subset(l1, l2);
            /*<<set.ml:371:12>>*/ if(! _E_)  /*<<set.ml:371:12>>*/ return _E_;
           var s1$0 = r1, s2$0 = r2;
          }
          else if(0 <= c){
            /*<<set.ml:375:12>>*/  /*<<set.ml:375:12>>*/ var
            _F_ = subset([0, 0, v1, r1, 0], r2);
            /*<<set.ml:375:12>>*/ if(! _F_)  /*<<set.ml:375:12>>*/ return _F_;
           var s1$0 = l1;
          }
          else{
            /*<<set.ml:373:12>>*/  /*<<set.ml:373:12>>*/ var
            _G_ = subset([0, l1, v1, 0, 0], l2);
            /*<<set.ml:373:12>>*/ if(! _G_)  /*<<set.ml:373:12>>*/ return _G_;
           var s1$0 = r1;
          }
         }
         /*<<set.ml:375:71>>*/ }
        function iter(f, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:378:17>>*/ return 0;
          var r = param$0[3], v = param$0[2], l = param$0[1];
           /*<<set.ml:379:25>>*/ iter(f, l);
           /*<<set.ml:379:35>>*/  /*<<set.ml:379:35>>*/ caml_call1(f, v);
          var param$0 = r;
         }
        }
        function fold(f, s, accu){
          /*<<set.ml:382:6>>*/ var s$0 = s, accu$0 = accu;
          /*<<set.ml:382:6>>*/ for(;;){
          if(! s$0)  /*<<set.ml:383:17>>*/ return accu$0;
           /*<<set.ml:384:34>>*/ var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
            /*<<set.ml:384:34>>*/ accu$1 =
              /*<<set.ml:384:34>>*/ caml_call2(f, v, fold(f, l, accu$0)),
           s$0 = r,
           accu$0 = accu$1;
         }
         /*<<set.ml:384:55>>*/ }
        function for_all(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:387:17>>*/ return 1;
           /*<<set.ml:388:25>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:388:25>>*/ _B_ =
              /*<<set.ml:388:25>>*/ caml_call1(p, v);
           /*<<set.ml:388:25>>*/ if(_B_){
            /*<<set.ml:388:32>>*/  /*<<set.ml:388:32>>*/ var
            _C_ = for_all(p, l);
            /*<<set.ml:388:32>>*/ if(_C_){var param$0 = r; continue;}
           var _D_ = _C_;
          }
          else
           var _D_ = _B_;
           /*<<set.ml:388:32>>*/ return _D_;
         }
        }
        function exists(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:391:17>>*/ return 0;
           /*<<set.ml:392:25>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:392:25>>*/ _y_ =
              /*<<set.ml:392:25>>*/ caml_call1(p, v);
           /*<<set.ml:392:25>>*/ if(_y_)
           var _z_ = _y_;
          else{
            /*<<set.ml:392:32>>*/  /*<<set.ml:392:32>>*/ var
            _A_ = exists(p, l);
            /*<<set.ml:392:32>>*/ if(! _A_){var param$0 = r; continue;}
           var _z_ = _A_;
          }
           /*<<set.ml:392:25>>*/ return _z_;
         }
        }
        function filter(p, t){
          /*<<?>>*/ if(! t)  /*<<set.ml:395:17>>*/ return 0;
          /*<<set.ml:398:19>>*/ var
          r = t[3],
          v = t[2],
          l = t[1],
           /*<<set.ml:398:19>>*/ l$0 = filter(p, l),
           /*<<set.ml:399:19>>*/ pv =  /*<<set.ml:399:19>>*/ caml_call1(p, v),
           /*<<set.ml:400:19>>*/ r$0 = filter(p, r);
          /*<<set.ml:401:10>>*/ if(! pv)
           /*<<set.ml:403:15>>*/ return concat(l$0, r$0);
         if(l === l$0 && r === r$0)  /*<<set.ml:402:35>>*/ return t;
          /*<<set.ml:402:42>>*/ return join(l$0, v, r$0);
        }
        function partition(p, param){
          /*<<?>>*/ if(! param)  /*<<set.ml:406:17>>*/ return _b_;
          /*<<set.ml:409:25>>*/ var
          r = param[3],
          v = param[2],
          l = param[1],
           /*<<set.ml:409:25>>*/ match = partition(p, l),
          lf = match[2],
          lt = match[1],
           /*<<set.ml:410:19>>*/ pv =  /*<<set.ml:410:19>>*/ caml_call1(p, v),
           /*<<set.ml:411:25>>*/ match$0 = partition(p, r),
          rf = match$0[2],
          rt = match$0[1];
          /*<<set.ml:412:10>>*/ if(pv){
           /*<<set.ml:413:30>>*/  /*<<set.ml:413:30>>*/ var
           _w_ = concat(lf, rf);
           /*<<set.ml:413:15>>*/ return [0, join(lt, v, rt), _w_];
         }
          /*<<set.ml:414:30>>*/  /*<<set.ml:414:30>>*/ var
          _x_ = join(lf, v, rf);
          /*<<set.ml:414:15>>*/ return [0, concat(lt, rt), _x_];
        }
        function cardinal(param){
          /*<<set.ml:416:23>>*/ if(! param)  /*<<set.ml:417:17>>*/ return 0;
          /*<<set.ml:418:39>>*/ var
          r = param[3],
          l = param[1],
           /*<<set.ml:418:39>>*/ _v_ = cardinal(r);
         return (cardinal(l) + 1 | 0) + _v_ | 0;
         /*<<set.ml:418:49>>*/ }
        function elements_aux(accu, param){
         var accu$0 = accu, param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:421:17>>*/ return accu$0;
           /*<<set.ml:422:38>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:422:38>>*/ accu$1 = [0, v, elements_aux(accu$0, r)],
           accu$0 = accu$1,
           param$0 = l;
         }
        }
        function elements(s){
          /*<<set.ml:425:6>>*/ return elements_aux(0, s);
         /*<<set.ml:425:23>>*/ }
        function find(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)
            /*<<set.ml:432:17>>*/ throw  /*<<set.ml:432:17>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
           /*<<set.ml:434:18>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:434:18>>*/ c =
              /*<<set.ml:434:18>>*/ caml_call2(Ord[1], x, v);
           /*<<set.ml:435:10>>*/ if(0 === c)  /*<<set.ml:435:24>>*/ return v;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function find_first(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)
            /*<<set.ml:449:10>>*/ throw  /*<<set.ml:449:10>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
           /*<<set.ml:451:13>>*/ if
           ( /*<<set.ml:451:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, param = l$0;
           for(;;){
            if(! param)  /*<<set.ml:440:10>>*/ return v0;
            var r = param[3], v0$0 = param[2], l = param[1];
             /*<<set.ml:442:13>>*/ if
             ( /*<<set.ml:442:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_first_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)  /*<<set.ml:467:10>>*/ return 0;
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
           /*<<set.ml:469:13>>*/ if
           ( /*<<set.ml:469:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, param = l$0;
           for(;;){
            if(! param)  /*<<set.ml:458:10>>*/ return [0, v0];
            var r = param[3], v0$0 = param[2], l = param[1];
             /*<<set.ml:460:13>>*/ if
             ( /*<<set.ml:460:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_last(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)
            /*<<set.ml:485:10>>*/ throw  /*<<set.ml:485:10>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
           /*<<set.ml:487:13>>*/ if
           ( /*<<set.ml:487:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, param = r$0;
           for(;;){
            if(! param)  /*<<set.ml:476:10>>*/ return v0;
            var r = param[3], v0$0 = param[2], l = param[1];
             /*<<set.ml:478:13>>*/ if
             ( /*<<set.ml:478:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_last_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)  /*<<set.ml:503:10>>*/ return 0;
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
           /*<<set.ml:505:13>>*/ if
           ( /*<<set.ml:505:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, param = r$0;
           for(;;){
            if(! param)  /*<<set.ml:494:10>>*/ return [0, v0];
            var r = param[3], v0$0 = param[2], l = param[1];
             /*<<set.ml:496:13>>*/ if
             ( /*<<set.ml:496:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_opt(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<set.ml:511:17>>*/ return 0;
           /*<<set.ml:513:18>>*/ var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<set.ml:513:18>>*/ c =
              /*<<set.ml:513:18>>*/ caml_call2(Ord[1], x, v);
           /*<<set.ml:514:10>>*/ if(0 === c)
            /*<<set.ml:514:24>>*/ return [0, v];
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function try_join(l, v, r){
          /*<<set.ml:521:6>>*/ a:
         {
          if(0 !== l){
            /*<<set.ml:521:35>>*/  /*<<set.ml:521:35>>*/ var _u_ = max_elt(l);
            /*<<set.ml:521:23>>*/ if
            (0 <=  /*<<set.ml:521:23>>*/ caml_call2(Ord[1], _u_, v))
            break a;
          }
          if(0 !== r){
            /*<<set.ml:522:37>>*/  /*<<set.ml:522:37>>*/ var _t_ = min_elt(r);
            /*<<set.ml:522:23>>*/ if
            (0 <=  /*<<set.ml:522:23>>*/ caml_call2(Ord[1], v, _t_))
            break a;
          }
           /*<<set.ml:523:11>>*/ return join(l, v, r);
         }
          /*<<set.ml:524:19>>*/ return union(l, add(v, r));
         /*<<set.ml:524:28>>*/ }
        function map(f, t){
          /*<<?>>*/ if(! t)  /*<<set.ml:527:17>>*/ return 0;
          /*<<set.ml:530:18>>*/ var
          r = t[3],
          v = t[2],
          l = t[1],
           /*<<set.ml:530:18>>*/ l$0 = map(f, l),
           /*<<set.ml:531:18>>*/ v$0 =  /*<<set.ml:531:18>>*/ caml_call1(f, v),
           /*<<set.ml:532:18>>*/ r$0 = map(f, r);
         if(l === l$0 && v === v$0 && r === r$0)
           /*<<set.ml:533:47>>*/ return t;
          /*<<set.ml:534:14>>*/ return try_join(l$0, v$0, r$0);
        }
        function filter_map(f, t){
          /*<<?>>*/ if(! t)  /*<<set.ml:543:17>>*/ return 0;
          /*<<set.ml:546:18>>*/ var
          r = t[3],
          v = t[2],
          l = t[1],
           /*<<set.ml:546:18>>*/ t1 = filter_map(f, l),
           /*<<set.ml:547:18>>*/ v$0 =  /*<<set.ml:547:18>>*/ caml_call1(f, v),
           /*<<set.ml:548:18>>*/ t2 = filter_map(f, r);
          /*<<set.ml:549:9>>*/ if(v$0){
          var v$1 = v$0[1];
          if(l === t1 && v === v$1 && r === t2)
            /*<<set.ml:551:52>>*/ return t;
           /*<<set.ml:552:19>>*/ return try_join(t1, v$1, t2);
         }
         if(! t1)  /*<<set.ml:538:22>>*/ return t2;
         if(! t2)  /*<<set.ml:539:22>>*/ return t1;
          /*<<set.ml:540:43>>*/  /*<<set.ml:540:43>>*/ var
          _s_ = remove_min_elt(t2);
          /*<<set.ml:540:43>>*/ return try_join(t1, min_elt(t2), _s_);
        }
        function of_list(l){
          /*<<set.ml:581:6>>*/ if(! l) return empty;
         var _n_ = l[2], x0 = l[1];
         if(! _n_)  /*<<set.ml:583:16>>*/ return singleton(x0);
         var _o_ = _n_[2], x1 = _n_[1];
         if(! _o_)  /*<<set.ml:584:27>>*/ return add(x1, singleton(x0));
         var _p_ = _o_[2], x2 = _o_[1];
         if(! _p_)
           /*<<set.ml:585:31>>*/ return add(x2, add(x1, singleton(x0)));
         var _q_ = _p_[2], x3 = _p_[1];
         if(! _q_)
           /*<<set.ml:586:35>>*/ return add
                  (x3, add(x2, add(x1, singleton(x0))));
         if(_q_[2]){
           /*<<set.ml:588:28>>*/ var
            /*<<set.ml:588:28>>*/ l$0 =
              /*<<set.ml:588:28>>*/ caml_call2(Stdlib_List[62], Ord[1], l),
           sub =
             function(n, l){
               /*<<set.ml:559:8>>*/ if(3 >= n >>> 0)
               switch(n){
                 case 0:
                   /*<<set.ml:560:18>>*/ return [0, 0, l];
                 case 1:
                  if(l){
                   var l$3 = l[2], x0 = l[1];
                    /*<<set.ml:561:24>>*/ return [0, [0, 0, x0, 0, 1], l$3];
                  }
                  break;
                 case 2:
                  if(l){
                   var match$1 = l[2];
                   if(match$1){
                    var l$4 = match$1[2], x1 = match$1[1], x0$0 = l[1];
                     /*<<set.ml:563:12>>*/ return [0,
                            [0, [0, 0, x0$0, 0, 1], x1, 0, 2],
                            l$4];
                   }
                  }
                  break;
                 default:
                  if(l){
                   var _r_ = l[2];
                   if(_r_){
                    var match$2 = _r_[2];
                    if(match$2){
                     var
                      l$5 = match$2[2],
                      x2 = match$2[1],
                      x1$0 = _r_[1],
                      x0$1 = l[1];
                      /*<<set.ml:565:12>>*/ return [0,
                             [0, [0, 0, x0$1, 0, 1], x1$0, [0, 0, x2, 0, 1], 2],
                             l$5];
                    }
                   }
                  }
               }
               /*<<set.ml:569:24>>*/ var
               nl = n / 2 | 0,
                /*<<set.ml:569:24>>*/ match = sub(nl, l),
               l$0 = match[2],
               left = match[1];
               /*<<set.ml:570:10>>*/ if(! l$0)
                /*<<set.ml:571:18>>*/ throw  /*<<set.ml:571:18>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _c_], 1);
               /*<<set.ml:573:27>>*/ var
               l$1 = l$0[2],
               mid = l$0[1],
                /*<<set.ml:573:27>>*/ match$0 = sub((n - nl | 0) - 1 | 0, l$1),
               l$2 = match$0[2],
               right = match$0[1];
               /*<<set.ml:574:12>>*/ return [0, create(left, mid, right), l$2];
              /*<<set.ml:574:36>>*/ };
           /*<<set.ml:576:10>>*/ return sub
                   ( /*<<set.ml:576:15>>*/ caml_call1(Stdlib_List[1], l$0),
                    l$0)
                  [1];
         }
         var x4 = _q_[1];
          /*<<set.ml:587:39>>*/ return add
                 (x4, add(x3, add(x2, add(x1, singleton(x0)))));
         /*<<set.ml:588:58>>*/ }
        function add_seq(i, m){
          /*<<set.ml:591:6>>*/ return  /*<<set.ml:591:6>>*/ caml_call3
                 (Stdlib_Seq[5],
                  function(s, x){
                    /*<<set.ml:591:32>>*/ return add(x, s);
                   /*<<set.ml:591:39>>*/ },
                  m,
                  i);
         /*<<set.ml:591:44>>*/ }
        function of_seq(i){
          /*<<set.ml:593:19>>*/ return add_seq(i, empty);
         /*<<set.ml:593:34>>*/ }
        function seq_of_enum(c, param){
          /*<<set.ml:595:32>>*/ if(! c)  /*<<set.ml:596:15>>*/ return 0;
         var
          rest = c[3],
          t = c[2],
          x = c[1],
           /*<<set.ml:597:55>>*/ _l_ = cons_enum(t, rest);
          /*<<set.ml:597:29>>*/ return [0,
                 x,
                 function(_m_){ /*<<?>>*/ return seq_of_enum(_l_, _m_);}];
         /*<<set.ml:597:74>>*/ }
        function to_seq(c){
          /*<<set.ml:599:19>>*/  /*<<set.ml:599:32>>*/ var
          _j_ = cons_enum(c, 0);
          /*<<set.ml:599:32>>*/ return function(_k_){
           /*<<?>>*/ return seq_of_enum(_j_, _k_);};
         /*<<set.ml:599:49>>*/ }
        function snoc_enum(s, e){
          /*<<set.ml:602:6>>*/ var s$0 = s, e$0 = e;
          /*<<set.ml:602:6>>*/ for(;;){
          if(! s$0)  /*<<set.ml:603:17>>*/ return e$0;
           /*<<set.ml:604:37>>*/ var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
            /*<<set.ml:604:37>>*/ e$1 = [0, v, l, e$0],
           s$0 = r,
           e$0 = e$1;
         }
         /*<<set.ml:604:52>>*/ }
        function rev_seq_of_enum(c, param){
          /*<<set.ml:606:36>>*/ if(! c)  /*<<set.ml:607:15>>*/ return 0;
         var
          rest = c[3],
          t = c[2],
          x = c[1],
           /*<<set.ml:608:59>>*/ _h_ = snoc_enum(t, rest);
          /*<<set.ml:608:29>>*/ return [0,
                 x,
                 function(_i_){ /*<<?>>*/ return rev_seq_of_enum(_h_, _i_);}];
         /*<<set.ml:608:78>>*/ }
        function to_rev_seq(c){
          /*<<set.ml:610:23>>*/  /*<<set.ml:610:40>>*/ var
          _f_ = snoc_enum(c, 0);
          /*<<set.ml:610:40>>*/ return function(_g_){
           /*<<?>>*/ return rev_seq_of_enum(_f_, _g_);};
         /*<<set.ml:610:57>>*/ }
        function to_seq_from(low, s){
          /*<<set.ml:613:6>>*/ a:
         {
          b:
          {
           var s$0 = s, c = 0;
            /*<<set.ml:613:28>>*/ for(;;){
            if(! s$0) break;
             /*<<set.ml:616:24>>*/ var
             r = s$0[3],
             v = s$0[2],
             l = s$0[1],
              /*<<set.ml:616:24>>*/ n =
                /*<<set.ml:616:24>>*/ caml_call2(Ord[1], v, low);
            if(0 === n) break b;
            if(0 <= n)
              /*<<set.ml:619:31>>*/ var
               /*<<set.ml:619:31>>*/ c$0 = [0, v, r, c],
              s$0 = l,
              c = c$0;
            else
             var s$0 = r;
           }
           var _d_ = c;
           break a;
          }
          var _d_ = [0, v, r, c];
         }
          /*<<set.ml:622:19>>*/ return function(_e_){
           /*<<?>>*/ return seq_of_enum(_d_, _e_);};
         /*<<set.ml:622:34>>*/ }
        return [0,
                empty,
                add,
                singleton,
                remove,
                union,
                inter,
                disjoint,
                diff,
                cardinal,
                elements,
                min_elt,
                min_elt_opt,
                max_elt,
                max_elt_opt,
                min_elt,
                min_elt_opt,
                find,
                find_opt,
                find_first,
                find_first_opt,
                find_last,
                find_last_opt,
                iter,
                fold,
                map,
                filter,
                filter_map,
                partition,
                split,
                is_empty,
                mem,
                equal,
                compare,
                subset,
                for_all,
                exists,
                elements,
                of_list,
                to_seq_from,
                to_seq,
                to_rev_seq,
                add_seq,
                of_seq];
       }];
   runtime.caml_register_global(12, Stdlib_Set, "Stdlib__Set");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Map
//# unitInfo: Requires: Stdlib, Stdlib__List, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Map_bal$3 = "Map.bal",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    cst_Map_bal = cst_Map_bal$3,
    cst_Map_bal$0 = cst_Map_bal$3,
    cst_Map_bal$1 = cst_Map_bal$3,
    cst_Map_bal$2 = cst_Map_bal$3,
    cst_Map_remove_min_elt = "Map.remove_min_elt",
    _a_ = [0, 0, 0, 0],
    _b_ = [0, "map.ml", 408, 10],
    _c_ = [0, 0, 0],
    Stdlib_Map =
      [0,
       function(Ord){
        function height(param){
          /*<<map.ml:81:17>>*/ if(! param)  /*<<map.ml:82:17>>*/ return 0;
         var h = param[5];
          /*<<map.ml:83:20>>*/ return h;
         /*<<map.ml:83:21>>*/ }
        function create(l, x, d, r){
          /*<<map.ml:86:6>>*/ var
           /*<<map.ml:86:15>>*/ hl = height(l),
           /*<<map.ml:86:33>>*/ hr = height(r),
          _K_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
          /*<<map.ml:87:10>>*/ return [0, l, x, d, r, _K_];
         /*<<map.ml:87:65>>*/ }
        function singleton(x, d){
          /*<<map.ml:89:24>>*/ return [0, 0, x, d, 0, 1];
         /*<<map.ml:89:59>>*/ }
        function bal(l, x, d, r){
          /*<<map.ml:92:6>>*/ if(l) var h = l[5], hl = h; else var hl = 0;
          /*<<map.ml:93:6>>*/ if(r) var h$0 = r[5], hr = h$0; else var hr = 0;
         if((hr + 2 | 0) < hl){
          if(! l)
            /*<<map.ml:96:19>>*/ return  /*<<map.ml:96:19>>*/ caml_call1
                   (Stdlib[1], cst_Map_bal$0);
           /*<<map.ml:98:28>>*/ var
           lr = l[4],
           ld = l[3],
           lv = l[2],
           ll = l[1],
            /*<<map.ml:98:28>>*/ _F_ = height(lr);
          if(_F_ <= height(ll))
            /*<<map.ml:99:30>>*/ return create
                   (ll, lv, ld, create(lr, x, d, r));
          if(! lr)
            /*<<map.ml:102:25>>*/ return  /*<<map.ml:102:25>>*/ caml_call1
                   (Stdlib[1], cst_Map_bal);
           /*<<map.ml:104:55>>*/ var
           lrr = lr[4],
           lrd = lr[3],
           lrv = lr[2],
           lrl = lr[1],
            /*<<map.ml:104:55>>*/ _G_ = create(lrr, x, d, r);
           /*<<map.ml:104:55>>*/ return create
                  (create(ll, lv, ld, lrl), lrv, lrd, _G_);
         }
         if((hl + 2 | 0) >= hr){
          var _J_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
           /*<<map.ml:119:12>>*/ return [0, l, x, d, r, _J_];
         }
         if(! r)
           /*<<map.ml:108:19>>*/ return  /*<<map.ml:108:19>>*/ caml_call1
                  (Stdlib[1], cst_Map_bal$2);
          /*<<map.ml:110:28>>*/ var
          rr = r[4],
          rd = r[3],
          rv = r[2],
          rl = r[1],
           /*<<map.ml:110:28>>*/ _H_ = height(rl);
         if(_H_ <= height(rr))
           /*<<map.ml:111:14>>*/ return create
                  (create(l, x, d, rl), rv, rd, rr);
         if(! rl)
           /*<<map.ml:114:25>>*/ return  /*<<map.ml:114:25>>*/ caml_call1
                  (Stdlib[1], cst_Map_bal$1);
          /*<<map.ml:116:52>>*/ var
          rlr = rl[4],
          rld = rl[3],
          rlv = rl[2],
          rll = rl[1],
           /*<<map.ml:116:52>>*/ _I_ = create(rlr, rv, rd, rr);
          /*<<map.ml:116:52>>*/ return create
                 (create(l, x, d, rll), rlv, rld, _I_);
         /*<<map.ml:119:67>>*/ }
        var empty = 0;
        function is_empty(param){
          /*<<map.ml:123:19>>*/ return param ? 0 : 1;
         /*<<map.ml:123:54>>*/ }
        function add(x, data, m){
          /*<<?>>*/ if(! m)
           /*<<map.ml:127:14>>*/ return [0, 0, x, data, 0, 1];
          /*<<map.ml:129:18>>*/ var
          h = m[5],
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
           /*<<map.ml:129:18>>*/ c =
             /*<<map.ml:129:18>>*/ caml_call2(Ord[1], x, v);
          /*<<map.ml:130:10>>*/ if(0 === c)
          return d === data ? m : [0, l, x, data, r, h];
         if(0 <= c){
           /*<<map.ml:136:21>>*/  /*<<map.ml:136:21>>*/ var
           rr = add(x, data, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
          /*<<map.ml:133:21>>*/  /*<<map.ml:133:21>>*/ var
          ll = add(x, data, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function find(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)
            /*<<map.ml:141:10>>*/ throw  /*<<map.ml:141:10>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
           /*<<map.ml:143:18>>*/ var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:143:18>>*/ c =
              /*<<map.ml:143:18>>*/ caml_call2(Ord[1], x, v);
           /*<<map.ml:144:10>>*/ if(0 === c)  /*<<map.ml:144:24>>*/ return d;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function find_first(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)
            /*<<map.ml:158:10>>*/ throw  /*<<map.ml:158:10>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
           /*<<map.ml:160:13>>*/ if
           ( /*<<map.ml:160:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = l$0;
           for(;;){
            if(! param)  /*<<map.ml:149:10>>*/ return [0, v0, d0];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
             /*<<map.ml:151:13>>*/ if
             ( /*<<map.ml:151:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_first_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)  /*<<map.ml:176:10>>*/ return 0;
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
           /*<<map.ml:178:13>>*/ if
           ( /*<<map.ml:178:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = l$0;
           for(;;){
            if(! param)  /*<<map.ml:167:10>>*/ return [0, [0, v0, d0]];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
             /*<<map.ml:169:13>>*/ if
             ( /*<<map.ml:169:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_last(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)
            /*<<map.ml:194:10>>*/ throw  /*<<map.ml:194:10>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
           /*<<map.ml:196:13>>*/ if
           ( /*<<map.ml:196:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = r$0;
           for(;;){
            if(! param)  /*<<map.ml:185:10>>*/ return [0, v0, d0];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
             /*<<map.ml:187:13>>*/ if
             ( /*<<map.ml:187:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_last_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1)  /*<<map.ml:212:10>>*/ return 0;
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
           /*<<map.ml:214:13>>*/ if
           ( /*<<map.ml:214:13>>*/ caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = r$0;
           for(;;){
            if(! param)  /*<<map.ml:203:10>>*/ return [0, [0, v0, d0]];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
             /*<<map.ml:205:13>>*/ if
             ( /*<<map.ml:205:13>>*/ caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_opt(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:221:10>>*/ return 0;
           /*<<map.ml:223:18>>*/ var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:223:18>>*/ c =
              /*<<map.ml:223:18>>*/ caml_call2(Ord[1], x, v);
           /*<<map.ml:224:10>>*/ if(0 === c)
            /*<<map.ml:224:24>>*/ return [0, d];
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function mem(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:229:10>>*/ return 0;
           /*<<map.ml:231:18>>*/ var
           r = param$0[4],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:231:18>>*/ c =
              /*<<map.ml:231:18>>*/ caml_call2(Ord[1], x, v),
           _E_ = 0 === c ? 1 : 0;
          if(_E_) return _E_;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function min_binding(param){
          /*<<map.ml:234:26>>*/ var param$0 = param;
          /*<<map.ml:234:26>>*/ for(;;){
          if(! param$0)
            /*<<map.ml:235:17>>*/ throw  /*<<map.ml:235:17>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          var l = param$0[1];
          if(! l){
           var d = param$0[3], v = param$0[2];
            /*<<map.ml:236:32>>*/ return [0, v, d];
          }
          var param$0 = l;
         }
         /*<<map.ml:237:33>>*/ }
        function min_binding_opt(param){
          /*<<map.ml:239:30>>*/ var param$0 = param;
          /*<<map.ml:239:30>>*/ for(;;){
          if(! param$0)  /*<<map.ml:240:17>>*/ return 0;
          var l = param$0[1];
          if(! l){
           var d = param$0[3], v = param$0[2];
            /*<<map.ml:241:32>>*/ return [0, [0, v, d]];
          }
          var param$0 = l;
         }
         /*<<map.ml:242:36>>*/ }
        function max_binding(param){
          /*<<map.ml:244:26>>*/ var param$0 = param;
          /*<<map.ml:244:26>>*/ for(;;){
          if(! param$0)
            /*<<map.ml:245:17>>*/ throw  /*<<map.ml:245:17>>*/ caml_maybe_attach_backtrace
                  (Stdlib[8], 1);
          if(! param$0[4]){
           var d = param$0[3], v = param$0[2];
            /*<<map.ml:246:32>>*/ return [0, v, d];
          }
          var r = param$0[4], param$0 = r;
         }
         /*<<map.ml:247:33>>*/ }
        function max_binding_opt(param){
          /*<<map.ml:249:30>>*/ var param$0 = param;
          /*<<map.ml:249:30>>*/ for(;;){
          if(! param$0)  /*<<map.ml:250:17>>*/ return 0;
          if(! param$0[4]){
           var d = param$0[3], v = param$0[2];
            /*<<map.ml:251:32>>*/ return [0, [0, v, d]];
          }
          var r = param$0[4], param$0 = r;
         }
         /*<<map.ml:252:37>>*/ }
        function remove_min_binding(param){
          /*<<map.ml:254:33>>*/ if(! param)
           /*<<map.ml:255:17>>*/ return  /*<<map.ml:255:17>>*/ caml_call1
                  (Stdlib[1], cst_Map_remove_min_elt);
         var l = param[1];
         if(l){
          var r = param[4], d = param[3], v = param[2];
           /*<<map.ml:257:29>>*/ return bal(remove_min_binding(l), v, d, r);
         }
         var r$0 = param[4];
          /*<<map.ml:256:29>>*/ return r$0;
         /*<<map.ml:257:61>>*/ }
        function _d_(t1, t2){
          /*<<map.ml:260:6>>*/ if(! t1)  /*<<map.ml:261:22>>*/ return t2;
         if(! t2)  /*<<map.ml:262:22>>*/ return t1;
          /*<<map.ml:264:23>>*/ var
           /*<<map.ml:264:23>>*/ match = min_binding(t2),
          d = match[2],
          x = match[1];
          /*<<map.ml:265:21>>*/ return bal(t1, x, d, remove_min_binding(t2));
         /*<<map.ml:265:44>>*/ }
        function remove(x, m){
          /*<<?>>*/ if(! m)  /*<<map.ml:269:10>>*/ return 0;
          /*<<map.ml:271:18>>*/ var
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
           /*<<map.ml:271:18>>*/ c =
             /*<<map.ml:271:18>>*/ caml_call2(Ord[1], x, v);
          /*<<map.ml:272:10>>*/ if(0 === c)
           /*<<map.ml:272:24>>*/ return _d_(l, r);
         if(0 <= c){
           /*<<map.ml:276:21>>*/  /*<<map.ml:276:21>>*/ var rr = remove(x, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
          /*<<map.ml:274:21>>*/  /*<<map.ml:274:21>>*/ var ll = remove(x, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function update(x, f, m){
          /*<<?>>*/ if(! m){
           /*<<map.ml:280:22>>*/  /*<<map.ml:280:22>>*/ var
           match$0 =  /*<<map.ml:280:22>>*/ caml_call1(f, 0);
          if(! match$0)  /*<<map.ml:281:20>>*/ return 0;
          var data$0 = match$0[1];
           /*<<map.ml:282:29>>*/ return [0, 0, x, data$0, 0, 1];
         }
          /*<<map.ml:285:18>>*/ var
          h = m[5],
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
           /*<<map.ml:285:18>>*/ c =
             /*<<map.ml:285:18>>*/ caml_call2(Ord[1], x, v);
          /*<<map.ml:286:10>>*/ if(0 === c){
           /*<<map.ml:287:18>>*/  /*<<map.ml:287:18>>*/ var
           match =  /*<<map.ml:287:18>>*/ caml_call1(f, [0, d]);
          if(! match)  /*<<map.ml:288:22>>*/ return _d_(l, r);
          var data = match[1];
          return d === data ? m : [0, l, x, data, r, h];
         }
         if(0 <= c){
           /*<<map.ml:295:21>>*/  /*<<map.ml:295:21>>*/ var
           rr = update(x, f, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
          /*<<map.ml:292:21>>*/  /*<<map.ml:292:21>>*/ var
          ll = update(x, f, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function add_to_list(x, data, m){
         function add(param){
           /*<<map.ml:299:16>>*/ if(! param)
            /*<<map.ml:299:33>>*/ return [0, [0, data, 0]];
          var l = param[1];
           /*<<map.ml:299:57>>*/ return [0, [0, data, l]];
          /*<<map.ml:299:73>>*/ }
          /*<<map.ml:300:6>>*/ return update(x, add, m);
         /*<<map.ml:300:20>>*/ }
        function iter(f, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:303:17>>*/ return 0;
          var r = param$0[4], d = param$0[3], v = param$0[2], l = param$0[1];
           /*<<map.ml:305:10>>*/ iter(f, l);
           /*<<map.ml:305:20>>*/  /*<<map.ml:305:20>>*/ caml_call2(f, v, d);
          var param$0 = r;
         }
        }
        function map(f, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:309:10>>*/ return 0;
          /*<<map.ml:311:19>>*/ var
          h = param[5],
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
           /*<<map.ml:311:19>>*/ l$0 = map(f, l),
           /*<<map.ml:312:19>>*/ d$0 =  /*<<map.ml:312:19>>*/ caml_call1(f, d),
           /*<<map.ml:313:19>>*/ r$0 = map(f, r);
          /*<<map.ml:314:14>>*/ return [0, l$0, v, d$0, r$0, h];
        }
        function mapi(f, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:318:10>>*/ return 0;
          /*<<map.ml:320:19>>*/ var
          h = param[5],
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
           /*<<map.ml:320:19>>*/ l$0 = mapi(f, l),
           /*<<map.ml:321:19>>*/ d$0 =
             /*<<map.ml:321:19>>*/ caml_call2(f, v, d),
           /*<<map.ml:322:19>>*/ r$0 = mapi(f, r);
          /*<<map.ml:323:14>>*/ return [0, l$0, v, d$0, r$0, h];
        }
        function fold(f, m, accu){
          /*<<map.ml:326:6>>*/ var m$0 = m, accu$0 = accu;
          /*<<map.ml:326:6>>*/ for(;;){
          if(! m$0)  /*<<map.ml:327:17>>*/ return accu$0;
           /*<<map.ml:329:19>>*/ var
           r = m$0[4],
           d = m$0[3],
           v = m$0[2],
           l = m$0[1],
            /*<<map.ml:329:19>>*/ accu$1 =
              /*<<map.ml:329:19>>*/ caml_call3(f, v, d, fold(f, l, accu$0)),
           m$0 = r,
           accu$0 = accu$1;
         }
         /*<<map.ml:329:42>>*/ }
        function for_all(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:332:17>>*/ return 1;
           /*<<map.ml:333:29>>*/ var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:333:29>>*/ _B_ =
              /*<<map.ml:333:29>>*/ caml_call2(p, v, d);
           /*<<map.ml:333:29>>*/ if(_B_){
            /*<<map.ml:333:38>>*/  /*<<map.ml:333:38>>*/ var
            _C_ = for_all(p, l);
            /*<<map.ml:333:38>>*/ if(_C_){var param$0 = r; continue;}
           var _D_ = _C_;
          }
          else
           var _D_ = _B_;
           /*<<map.ml:333:38>>*/ return _D_;
         }
        }
        function exists(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:336:17>>*/ return 0;
           /*<<map.ml:337:29>>*/ var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:337:29>>*/ _y_ =
              /*<<map.ml:337:29>>*/ caml_call2(p, v, d);
           /*<<map.ml:337:29>>*/ if(_y_)
           var _z_ = _y_;
          else{
            /*<<map.ml:337:38>>*/  /*<<map.ml:337:38>>*/ var
            _A_ = exists(p, l);
            /*<<map.ml:337:38>>*/ if(! _A_){var param$0 = r; continue;}
           var _z_ = _A_;
          }
           /*<<map.ml:337:29>>*/ return _z_;
         }
        }
        function add_min_binding(k, x, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:348:17>>*/ return singleton(k, x);
         var r = param[4], d = param[3], v = param[2], l = param[1];
          /*<<map.ml:350:8>>*/ return bal(add_min_binding(k, x, l), v, d, r);
        }
        function add_max_binding(k, x, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:353:17>>*/ return singleton(k, x);
         var r = param[4], d = param[3], v = param[2], l = param[1];
          /*<<map.ml:355:18>>*/ return bal(l, v, d, add_max_binding(k, x, r));
        }
        function join(l, v, d, r){
          /*<<map.ml:361:6>>*/ if(! l)
           /*<<map.ml:362:22>>*/ return add_min_binding(v, d, r);
         if(! r)  /*<<map.ml:363:22>>*/ return add_max_binding(v, d, l);
         var
          rh = r[5],
          rr = r[4],
          rd = r[3],
          rv = r[2],
          rl = r[1],
          lh = l[5],
          lr = l[4],
          ld = l[3],
          lv = l[2],
          ll = l[1];
         return (rh + 2 | 0) < lh
                 ? bal(ll, lv, ld, join(lr, v, d, r))
                 : (lh
                   + 2
                   | 0)
                   < rh
                   ? bal(join(l, v, d, rl), rv, rd, rr)
                   : create(l, v, d, r);
         /*<<map.ml:368:24>>*/ }
        function concat(t1, t2){
          /*<<map.ml:375:6>>*/ if(! t1)  /*<<map.ml:376:22>>*/ return t2;
         if(! t2)  /*<<map.ml:377:22>>*/ return t1;
          /*<<map.ml:379:23>>*/ var
           /*<<map.ml:379:23>>*/ match = min_binding(t2),
          d = match[2],
          x = match[1];
          /*<<map.ml:380:22>>*/ return join(t1, x, d, remove_min_binding(t2));
         /*<<map.ml:380:45>>*/ }
        function concat_or_join(t1, v, d, t2){
          /*<<map.ml:383:6>>*/ if(! d)
           /*<<map.ml:385:16>>*/ return concat(t1, t2);
         var d$0 = d[1];
          /*<<map.ml:384:18>>*/ return join(t1, v, d$0, t2);
         /*<<map.ml:385:28>>*/ }
        function split(x, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:389:10>>*/ return _a_;
          /*<<map.ml:391:18>>*/ var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
           /*<<map.ml:391:18>>*/ c =
             /*<<map.ml:391:18>>*/ caml_call2(Ord[1], x, v);
          /*<<map.ml:392:10>>*/ if(0 === c)
           /*<<map.ml:392:24>>*/ return [0, l, [0, d], r];
         if(0 <= c){
           /*<<map.ml:396:33>>*/ var
            /*<<map.ml:396:33>>*/ match = split(x, r),
           rr = match[3],
           pres = match[2],
           lr = match[1];
           /*<<map.ml:396:46>>*/ return [0, join(l, v, d, lr), pres, rr];
         }
          /*<<map.ml:394:33>>*/ var
           /*<<map.ml:394:33>>*/ match$0 = split(x, l),
          rl = match$0[3],
          pres$0 = match$0[2],
          ll = match$0[1];
          /*<<map.ml:394:46>>*/ return [0, ll, pres$0, join(rl, v, d, r)];
        }
        function merge(f, s1, s2){
          /*<<map.ml:399:6>>*/ if(s1){
          var h1 = s1[5], r1 = s1[4], d1 = s1[3], v1 = s1[2], l1 = s1[1];
          if(height(s2) <= h1){
            /*<<map.ml:402:29>>*/ var
             /*<<map.ml:402:29>>*/ match = split(v1, s2),
            r2 = match[3],
            d2 = match[2],
            l2 = match[1],
             /*<<map.ml:403:64>>*/ _u_ = merge(f, r1, r2),
             /*<<map.ml:403:44>>*/ _v_ =
               /*<<map.ml:403:44>>*/ caml_call3(f, v1, [0, d1], d2);
            /*<<map.ml:403:64>>*/ return concat_or_join
                   (merge(f, l1, l2), v1, _v_, _u_);
          }
         }
         else if(! s2)  /*<<map.ml:400:26>>*/ return 0;
         if(! s2)
           /*<<map.ml:408:10>>*/ throw  /*<<map.ml:408:10>>*/ caml_maybe_attach_backtrace
                 ([0, Assert_failure, _b_], 1);
          /*<<map.ml:405:29>>*/ var
          r2$0 = s2[4],
          d2$0 = s2[3],
          v2 = s2[2],
          l2$0 = s2[1],
           /*<<map.ml:405:29>>*/ match$0 = split(v2, s1),
          r1$0 = match$0[3],
          d1$0 = match$0[2],
          l1$0 = match$0[1],
           /*<<map.ml:406:64>>*/ _w_ = merge(f, r1$0, r2$0),
           /*<<map.ml:406:44>>*/ _x_ =
             /*<<map.ml:406:44>>*/ caml_call3(f, v2, d1$0, [0, d2$0]);
          /*<<map.ml:406:64>>*/ return concat_or_join
                 (merge(f, l1$0, l2$0), v2, _x_, _w_);
         /*<<map.ml:408:22>>*/ }
        function union(f, s1, s2){
          /*<<map.ml:411:6>>*/ if(s1){
          if(s2){
           var
            h2 = s2[5],
            r2 = s2[4],
            d2 = s2[3],
            v2 = s2[2],
            l2 = s2[1],
            h1 = s1[5],
            r1 = s1[4],
            d1 = s1[3],
            v1 = s1[2],
            l1 = s1[1];
           if(h2 <= h1){
             /*<<map.ml:416:31>>*/ var
              /*<<map.ml:416:31>>*/ match = split(v1, s2),
             r2$0 = match[3],
             d2$0 = match[2],
             l2$0 = match[1],
              /*<<map.ml:417:20>>*/ l = union(f, l1, l2$0),
              /*<<map.ml:417:42>>*/ r = union(f, r1, r2$0);
             /*<<map.ml:418:12>>*/ if(! d2$0)
              /*<<map.ml:419:22>>*/ return join(l, v1, d1, r);
            var d2$1 = d2$0[1];
             /*<<map.ml:420:25>>*/ return concat_or_join
                    (l,
                     v1,
                      /*<<map.ml:420:45>>*/ caml_call3(f, v1, d1, d2$1),
                     r);
           }
            /*<<map.ml:422:31>>*/ var
             /*<<map.ml:422:31>>*/ match$0 = split(v2, s1),
            r1$0 = match$0[3],
            d1$0 = match$0[2],
            l1$0 = match$0[1],
             /*<<map.ml:423:20>>*/ l$0 = union(f, l1$0, l2),
             /*<<map.ml:423:42>>*/ r$0 = union(f, r1$0, r2);
            /*<<map.ml:424:12>>*/ if(! d1$0)
             /*<<map.ml:425:22>>*/ return join(l$0, v2, d2, r$0);
           var d1$1 = d1$0[1];
            /*<<map.ml:426:25>>*/ return concat_or_join
                   (l$0,
                    v2,
                     /*<<map.ml:426:45>>*/ caml_call3(f, v2, d1$1, d2),
                    r$0);
          }
          var s = s1;
         }
         else
          var s = s2;
          /*<<map.ml:412:35>>*/ return s;
         /*<<map.ml:426:59>>*/ }
        function filter(p, m){
          /*<<?>>*/ if(! m)  /*<<map.ml:429:17>>*/ return 0;
          /*<<map.ml:432:19>>*/ var
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
           /*<<map.ml:432:19>>*/ l$0 = filter(p, l),
           /*<<map.ml:433:20>>*/ pvd =
             /*<<map.ml:433:20>>*/ caml_call2(p, v, d),
           /*<<map.ml:434:19>>*/ r$0 = filter(p, r);
          /*<<map.ml:435:10>>*/ if(! pvd)
           /*<<map.ml:436:15>>*/ return concat(l$0, r$0);
         if(l === l$0 && r === r$0)  /*<<map.ml:435:45>>*/ return m;
          /*<<map.ml:435:52>>*/ return join(l$0, v, d, r$0);
        }
        function filter_map(f, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:439:17>>*/ return 0;
          /*<<map.ml:442:19>>*/ var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
           /*<<map.ml:442:19>>*/ l$0 = filter_map(f, l),
           /*<<map.ml:443:20>>*/ fvd =
             /*<<map.ml:443:20>>*/ caml_call2(f, v, d),
           /*<<map.ml:444:19>>*/ r$0 = filter_map(f, r);
          /*<<map.ml:445:10>>*/ if(! fvd)
           /*<<map.ml:447:22>>*/ return concat(l$0, r$0);
         var d$0 = fvd[1];
          /*<<map.ml:446:25>>*/ return join(l$0, v, d$0, r$0);
        }
        function partition(p, param){
          /*<<?>>*/ if(! param)  /*<<map.ml:451:17>>*/ return _c_;
          /*<<map.ml:454:25>>*/ var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
           /*<<map.ml:454:25>>*/ match = partition(p, l),
          lf = match[2],
          lt = match[1],
           /*<<map.ml:455:20>>*/ pvd =
             /*<<map.ml:455:20>>*/ caml_call2(p, v, d),
           /*<<map.ml:456:25>>*/ match$0 = partition(p, r),
          rf = match$0[2],
          rt = match$0[1];
          /*<<map.ml:457:10>>*/ if(pvd){
           /*<<map.ml:458:32>>*/  /*<<map.ml:458:32>>*/ var
           _s_ = concat(lf, rf);
           /*<<map.ml:458:15>>*/ return [0, join(lt, v, d, rt), _s_];
         }
          /*<<map.ml:459:30>>*/  /*<<map.ml:459:30>>*/ var
          _t_ = join(lf, v, d, rf);
          /*<<map.ml:459:15>>*/ return [0, concat(lt, rt), _t_];
        }
        function cons_enum(m, e){
          /*<<map.ml:464:6>>*/ var m$0 = m, e$0 = e;
          /*<<map.ml:464:6>>*/ for(;;){
          if(! m$0)  /*<<map.ml:465:17>>*/ return e$0;
           /*<<map.ml:466:41>>*/ var
           r = m$0[4],
           d = m$0[3],
           v = m$0[2],
           l = m$0[1],
            /*<<map.ml:466:41>>*/ e$1 = [0, v, d, r, e$0],
           m$0 = l,
           e$0 = e$1;
         }
         /*<<map.ml:466:59>>*/ }
        function compare(cmp, m1, m2){
          /*<<map.ml:469:6>>*/ var
           /*<<map.ml:480:40>>*/ e2$2 = cons_enum(m2, 0),
           /*<<map.ml:480:21>>*/ e1$2 = cons_enum(m1, 0),
          e1 = e1$2,
          e2 = e2$2;
          /*<<map.ml:470:10>>*/ for(;;){
          if(! e1) return e2 ? -1 : 0;
          if(! e2)  /*<<map.ml:473:22>>*/ return 1;
           /*<<map.ml:475:20>>*/ var
           e2$0 = e2[4],
           r2 = e2[3],
           d2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[4],
           r1 = e1[3],
           d1 = e1[2],
           v1 = e1[1],
            /*<<map.ml:475:20>>*/ c =
              /*<<map.ml:475:20>>*/ caml_call2(Ord[1], v1, v2);
           /*<<map.ml:476:12>>*/ if(0 !== c)  /*<<map.ml:476:27>>*/ return c;
           /*<<map.ml:477:20>>*/  /*<<map.ml:477:20>>*/ var
           c$0 =  /*<<map.ml:477:20>>*/ caml_call2(cmp, d1, d2);
           /*<<map.ml:478:12>>*/ if(0 !== c$0)
            /*<<map.ml:478:27>>*/ return c$0;
           /*<<map.ml:479:42>>*/ var
            /*<<map.ml:479:42>>*/ e2$1 = cons_enum(r2, e2$0),
            /*<<map.ml:479:24>>*/ e1$1 = cons_enum(r1, e1$0),
           e1 = e1$1,
           e2 = e2$1;
         }
         /*<<map.ml:480:58>>*/ }
        function equal(cmp, m1, m2){
          /*<<map.ml:483:6>>*/ var
           /*<<map.ml:491:38>>*/ e2$2 = cons_enum(m2, 0),
           /*<<map.ml:491:19>>*/ e1$2 = cons_enum(m1, 0),
          e1 = e1$2,
          e2 = e2$2;
          /*<<map.ml:484:10>>*/ for(;;){
          if(! e1) return e2 ? 0 : 1;
          if(! e2)  /*<<map.ml:487:22>>*/ return 0;
          var
           e2$0 = e2[4],
           r2 = e2[3],
           d2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[4],
           r1 = e1[3],
           d1 = e1[2],
           v1 = e1[1],
           _p_ =
             0 ===  /*<<map.ml:489:12>>*/ caml_call2(Ord[1], v1, v2) ? 1 : 0;
          if(_p_){
            /*<<map.ml:489:37>>*/  /*<<map.ml:489:37>>*/ var
            _q_ =  /*<<map.ml:489:37>>*/ caml_call2(cmp, d1, d2);
            /*<<map.ml:489:37>>*/ if(_q_){
             /*<<map.ml:490:40>>*/ var
              /*<<map.ml:490:40>>*/ e2$1 = cons_enum(r2, e2$0),
              /*<<map.ml:490:22>>*/ e1$1 = cons_enum(r1, e1$0),
             e1 = e1$1,
             e2 = e2$1;
            continue;
           }
           var _r_ = _q_;
          }
          else
           var _r_ = _p_;
           /*<<map.ml:489:37>>*/ return _r_;
         }
         /*<<map.ml:491:56>>*/ }
        function cardinal(param){
          /*<<map.ml:493:23>>*/ if(! param)  /*<<map.ml:494:17>>*/ return 0;
          /*<<map.ml:495:40>>*/ var
          r = param[4],
          l = param[1],
           /*<<map.ml:495:40>>*/ _o_ = cardinal(r);
         return (cardinal(l) + 1 | 0) + _o_ | 0;
         /*<<map.ml:495:50>>*/ }
        function bindings_aux(accu, param){
         var accu$0 = accu, param$0 = param;
         for(;;){
          if(! param$0)  /*<<map.ml:498:17>>*/ return accu$0;
           /*<<map.ml:499:42>>*/ var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
            /*<<map.ml:499:42>>*/ accu$1 =
             [0, [0, v, d], bindings_aux(accu$0, r)],
           accu$0 = accu$1,
           param$0 = l;
         }
        }
        function bindings(s){
          /*<<map.ml:502:6>>*/ return bindings_aux(0, s);
         /*<<map.ml:502:23>>*/ }
        function of_list(bs){
          /*<<map.ml:509:21>>*/ return  /*<<map.ml:509:21>>*/ caml_call3
                 (Stdlib_List[26],
                  function(m, param){
                    /*<<map.ml:509:36>>*/ var v = param[2], k = param[1];
                    /*<<map.ml:509:53>>*/ return add(k, v, m);
                   /*<<map.ml:509:63>>*/ },
                  empty,
                  bs);
         /*<<map.ml:509:72>>*/ }
        function add_seq(i, m){
          /*<<map.ml:512:6>>*/ return  /*<<map.ml:512:6>>*/ caml_call3
                 (Stdlib_Seq[5],
                  function(m, param){
                    /*<<map.ml:512:20>>*/ var v = param[2], k = param[1];
                    /*<<map.ml:512:36>>*/ return add(k, v, m);
                   /*<<map.ml:512:46>>*/ },
                  m,
                  i);
         /*<<map.ml:512:50>>*/ }
        function of_seq(i){
          /*<<map.ml:514:19>>*/ return add_seq(i, empty);
         /*<<map.ml:514:34>>*/ }
        function seq_of_enum(c, param){
          /*<<map.ml:516:32>>*/ if(! c)  /*<<map.ml:517:15>>*/ return 0;
         var
          rest = c[4],
          t = c[3],
          v = c[2],
          k = c[1],
           /*<<map.ml:518:59>>*/ _m_ = cons_enum(t, rest);
          /*<<map.ml:518:29>>*/ return [0,
                 [0, k, v],
                 function(_n_){ /*<<?>>*/ return seq_of_enum(_m_, _n_);}];
         /*<<map.ml:518:78>>*/ }
        function to_seq(m){
          /*<<map.ml:521:6>>*/  /*<<map.ml:521:19>>*/ var
          _k_ = cons_enum(m, 0);
          /*<<map.ml:521:19>>*/ return function(_l_){
           /*<<?>>*/ return seq_of_enum(_k_, _l_);};
         /*<<map.ml:521:36>>*/ }
        function snoc_enum(s, e){
          /*<<map.ml:524:6>>*/ var s$0 = s, e$0 = e;
          /*<<map.ml:524:6>>*/ for(;;){
          if(! s$0)  /*<<map.ml:525:17>>*/ return e$0;
           /*<<map.ml:526:40>>*/ var
           r = s$0[4],
           d = s$0[3],
           v = s$0[2],
           l = s$0[1],
            /*<<map.ml:526:40>>*/ e$1 = [0, v, d, l, e$0],
           s$0 = r,
           e$0 = e$1;
         }
         /*<<map.ml:526:58>>*/ }
        function rev_seq_of_enum(c, param){
          /*<<map.ml:528:36>>*/ if(! c)  /*<<map.ml:529:15>>*/ return 0;
         var
          rest = c[4],
          t = c[3],
          v = c[2],
          k = c[1],
           /*<<map.ml:531:44>>*/ _i_ = snoc_enum(t, rest);
          /*<<map.ml:531:10>>*/ return [0,
                 [0, k, v],
                 function(_j_){ /*<<?>>*/ return rev_seq_of_enum(_i_, _j_);}];
         /*<<map.ml:531:63>>*/ }
        function to_rev_seq(c){
          /*<<map.ml:534:6>>*/  /*<<map.ml:534:23>>*/ var
          _g_ = snoc_enum(c, 0);
          /*<<map.ml:534:23>>*/ return function(_h_){
           /*<<?>>*/ return rev_seq_of_enum(_g_, _h_);};
         /*<<map.ml:534:40>>*/ }
        function to_seq_from(low, m){
          /*<<map.ml:537:6>>*/ a:
         {
          b:
          {
           var m$0 = m, c = 0;
            /*<<map.ml:537:28>>*/ for(;;){
            if(! m$0) break;
             /*<<map.ml:540:24>>*/ var
             r = m$0[4],
             d = m$0[3],
             v = m$0[2],
             l = m$0[1],
              /*<<map.ml:540:24>>*/ n =
                /*<<map.ml:540:24>>*/ caml_call2(Ord[1], v, low);
            if(0 === n) break b;
            if(0 <= n)
              /*<<map.ml:543:31>>*/ var
               /*<<map.ml:543:31>>*/ c$0 = [0, v, d, r, c],
              m$0 = l,
              c = c$0;
            else
             var m$0 = r;
           }
           var _e_ = c;
           break a;
          }
          var _e_ = [0, v, d, r, c];
         }
          /*<<map.ml:546:19>>*/ return function(_f_){
           /*<<?>>*/ return seq_of_enum(_e_, _f_);};
         /*<<map.ml:546:34>>*/ }
        return [0,
                empty,
                add,
                add_to_list,
                update,
                singleton,
                remove,
                merge,
                union,
                cardinal,
                bindings,
                min_binding,
                min_binding_opt,
                max_binding,
                max_binding_opt,
                min_binding,
                min_binding_opt,
                find,
                find_opt,
                find_first,
                find_first_opt,
                find_last,
                find_last_opt,
                iter,
                fold,
                map,
                mapi,
                filter,
                filter_map,
                partition,
                split,
                is_empty,
                mem,
                equal,
                compare,
                for_all,
                exists,
                bindings,
                of_list,
                to_seq,
                to_rev_seq,
                to_seq_from,
                add_seq,
                of_seq];
       }];
   runtime.caml_register_global(12, Stdlib_Map, "Stdlib__Map");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Stack
//# unitInfo: Requires: Stdlib__List, Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<stack.ml:18:0>>*/ var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
     /*<<stack.ml:18:0>>*/ Empty =
      [248, "Stdlib.Stack.Empty", runtime.caml_fresh_oo_id(0)];
   function create(param){
     /*<<stack.ml:20:16>>*/ return [0, 0, 0];
    /*<<stack.ml:20:36>>*/ }
   function clear(s){
     /*<<stack.ml:22:14>>*/ s[1] = 0;
    s[2] = 0;
    return 0;
    /*<<stack.ml:22:35>>*/ }
   function copy(s){
     /*<<stack.ml:24:13>>*/ return [0, s[1], s[2]];
    /*<<stack.ml:24:38>>*/ }
   function push(x, s){
     /*<<stack.ml:26:15>>*/ s[1] = [0, x, s[1]];
    s[2] = s[2] + 1 | 0;
    return 0;
    /*<<stack.ml:26:50>>*/ }
   function pop(s){
     /*<<stack.ml:29:2>>*/ var match = s[1];
    if(! match)
      /*<<stack.ml:31:14>>*/ throw  /*<<stack.ml:31:14>>*/ caml_maybe_attach_backtrace
            (Empty, 1);
    var tl = match[2], hd = match[1];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
     /*<<stack.ml:30:45>>*/ return hd;
    /*<<stack.ml:31:25>>*/ }
   function pop_opt(s){
     /*<<stack.ml:34:2>>*/ var match = s[1];
    if(! match)  /*<<stack.ml:36:14>>*/ return 0;
    var tl = match[2], hd = match[1];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
     /*<<stack.ml:35:45>>*/ return [0, hd];
    /*<<stack.ml:36:18>>*/ }
   function drop(s){
     /*<<stack.ml:39:2>>*/ var match = s[1];
    if(! match)
      /*<<stack.ml:41:10>>*/ throw  /*<<stack.ml:41:10>>*/ caml_maybe_attach_backtrace
            (Empty, 1);
    var tl = match[2];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
    return 0;
    /*<<stack.ml:41:21>>*/ }
   function top(s){
     /*<<stack.ml:44:2>>*/ var match = s[1];
    if(! match)
      /*<<stack.ml:46:13>>*/ throw  /*<<stack.ml:46:13>>*/ caml_maybe_attach_backtrace
            (Empty, 1);
    var hd = match[1];
     /*<<stack.ml:45:13>>*/ return hd;
    /*<<stack.ml:46:24>>*/ }
   function top_opt(s){
     /*<<stack.ml:49:2>>*/ var match = s[1];
    if(! match)  /*<<stack.ml:51:13>>*/ return 0;
    var hd = match[1];
     /*<<stack.ml:50:13>>*/ return [0, hd];
    /*<<stack.ml:51:17>>*/ }
   function is_empty(s){
     /*<<stack.ml:53:17>>*/ return 0 === s[1] ? 1 : 0;
    /*<<stack.ml:53:27>>*/ }
   function length(s){
     /*<<stack.ml:55:15>>*/ return s[2];
    /*<<stack.ml:55:20>>*/ }
   function iter(f, s){
     /*<<stack.ml:57:15>>*/ return caml_call2(Stdlib_List[18], f, s[1]);
    /*<<stack.ml:57:30>>*/ }
   function fold(f, acc, s){
     /*<<stack.ml:59:19>>*/ return caml_call3(Stdlib_List[26], f, acc, s[1]);
    /*<<stack.ml:59:43>>*/ }
   function to_seq(s){
     /*<<stack.ml:63:15>>*/ return caml_call1(Stdlib_List[64], s[1]);
    /*<<stack.ml:63:30>>*/ }
   function add_seq(q, i){
     /*<<stack.ml:65:18>>*/ return  /*<<stack.ml:65:18>>*/ caml_call2
            (Stdlib_Seq[4],
             function(x){
               /*<<stack.ml:65:37>>*/ return push(x, q);
              /*<<stack.ml:65:45>>*/ },
             i);
    /*<<stack.ml:65:48>>*/ }
   function of_seq(g){
     /*<<stack.ml:68:2>>*/  /*<<stack.ml:68:10>>*/ var s = create(0);
     /*<<stack.ml:69:2>>*/ add_seq(s, g);
     /*<<stack.ml:69:2>>*/ return s;
    /*<<stack.ml:70:3>>*/ }
   var
    Stdlib_Stack =
      [0,
       Empty,
       create,
       push,
       pop,
       pop_opt,
       drop,
       top,
       top_opt,
       clear,
       copy,
       is_empty,
       length,
       iter,
       fold,
       to_seq,
       add_seq,
       of_seq];
   runtime.caml_register_global(3, Stdlib_Stack, "Stdlib__Stack");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Queue
//# unitInfo: Requires: Stdlib__Seq
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<queue.ml:17:0>>*/ var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
     /*<<queue.ml:17:0>>*/ Empty =
      [248, "Stdlib.Queue.Empty", runtime.caml_fresh_oo_id(0)];
   function create(param){
     /*<<queue.ml:29:16>>*/ return [0, 0, 0, 0];
    /*<<queue.ml:33:1>>*/ }
   function clear(q){
     /*<<queue.ml:36:2>>*/ q[1] = 0;
    q[2] = 0;
    q[3] = 0;
    return 0;
    /*<<queue.ml:38:15>>*/ }
   function add(x, q){
     /*<<queue.ml:41:2>>*/ var
      /*<<queue.ml:41:18>>*/ cell = [0, x, 0],
      /*<<queue.ml:45:2>>*/ match = q[3];
    return match
            ? (q[1] = q[1] + 1 | 0, match[2] = cell, q[3] = cell, 0)
            : (q[1] = 1, q[2] = cell, q[3] = cell, 0);
    /*<<queue.ml:53:18>>*/ }
   function peek(q){
     /*<<queue.ml:59:2>>*/ var match = q[2];
    if(! match)
      /*<<queue.ml:60:11>>*/ throw  /*<<queue.ml:60:11>>*/ caml_maybe_attach_backtrace
            (Empty, 1);
    var content = match[1];
     /*<<queue.ml:61:24>>*/ return content;
    /*<<queue.ml:61:31>>*/ }
   function peek_opt(q){
     /*<<queue.ml:64:2>>*/ var match = q[2];
    if(! match)  /*<<queue.ml:65:11>>*/ return 0;
    var content = match[1];
     /*<<queue.ml:66:24>>*/ return [0, content];
    /*<<queue.ml:66:36>>*/ }
   function take(q){
     /*<<queue.ml:72:2>>*/ var _f_ = q[2];
    if(! _f_)
      /*<<queue.ml:73:11>>*/ throw  /*<<queue.ml:73:11>>*/ caml_maybe_attach_backtrace
            (Empty, 1);
    var content = _f_[1];
    if(_f_[2]){
     var next = _f_[2];
     q[1] = q[1] - 1 | 0;
     q[2] = next;
      /*<<queue.ml:80:4>>*/ return content;
    }
     /*<<queue.ml:75:4>>*/ clear(q);
     /*<<queue.ml:75:4>>*/ return content;
    /*<<queue.ml:80:11>>*/ }
   function take_opt(q){
     /*<<queue.ml:83:2>>*/ var _e_ = q[2];
    if(! _e_)  /*<<queue.ml:84:11>>*/ return 0;
    var content = _e_[1];
    if(_e_[2]){
     var next = _e_[2];
     q[1] = q[1] - 1 | 0;
     q[2] = next;
      /*<<queue.ml:91:4>>*/ return [0, content];
    }
     /*<<queue.ml:86:4>>*/ clear(q);
     /*<<queue.ml:87:4>>*/ return [0, content];
    /*<<queue.ml:91:16>>*/ }
   function copy(q){
     /*<<queue.ml:108:11>>*/ var
     cell$0 = q[2],
      /*<<queue.ml:108:16>>*/ q_res = [0, q[1], 0, 0],
     prev = 0,
     cell = cell$0;
     /*<<queue.ml:98:4>>*/ for(;;){
     if(! cell){q_res[3] = prev;  /*<<queue.ml:99:33>>*/ return q_res;}
      /*<<queue.ml:101:21>>*/ var
      content = cell[1],
      next = cell[2],
       /*<<queue.ml:101:21>>*/ prev$0 = [0, content, 0];
      /*<<queue.ml:102:6>>*/ if(prev)
      prev[2] = prev$0;
     else
      q_res[2] = prev$0;
     var prev = prev$0, cell = next;
    }
    /*<<queue.ml:108:74>>*/ }
   function is_empty(q){
     /*<<queue.ml:111:2>>*/ return 0 === q[1] ? 1 : 0;
    /*<<queue.ml:111:14>>*/ }
   function length(q){
     /*<<queue.ml:114:2>>*/ return q[1];
    /*<<queue.ml:114:10>>*/ }
   function iter(f, q){
     /*<<queue.ml:124:13>>*/ var cell$0 = q[2], cell = cell$0;
     /*<<queue.ml:118:4>>*/ for(;;){
     if(! cell)  /*<<queue.ml:119:13>>*/ return 0;
     var content = cell[1], next = cell[2];
      /*<<queue.ml:121:6>>*/  /*<<queue.ml:121:6>>*/ caml_call1(f, content);
     var cell = next;
    }
    /*<<queue.ml:124:27>>*/ }
   function fold(f, accu$1, q){
     /*<<queue.ml:134:18>>*/ var cell$0 = q[2], accu = accu$1, cell = cell$0;
     /*<<queue.ml:128:4>>*/ for(;;){
     if(! cell)  /*<<queue.ml:129:13>>*/ return accu;
      /*<<queue.ml:131:17>>*/ var
      content = cell[1],
      next = cell[2],
       /*<<queue.ml:131:17>>*/ accu$0 =
         /*<<queue.ml:131:17>>*/ caml_call2(f, accu, content),
      accu = accu$0,
      cell = next;
    }
    /*<<queue.ml:134:37>>*/ }
   function transfer(q1, q2){
     /*<<queue.ml:137:2>>*/ var _d_ = 0 < q1[1] ? 1 : 0;
    if(! _d_) return _d_;
    var match = q2[3];
    return match
            ? (q2
               [1]
              = q2[1] + q1[1] | 0,
              match[2] = q1[2],
              q2[3] = q1[3],
              clear(q1))
            : (q2[1] = q1[1], q2[2] = q1[2], q2[3] = q1[3], clear(q1));
    /*<<queue.ml:148:14>>*/ }
   function to_seq(q){
     /*<<queue.ml:153:2>>*/ function aux(c, param){
      /*<<queue.ml:153:21>>*/ if(! c)  /*<<queue.ml:154:13>>*/ return 0;
     var x = c[1], next = c[2];
      /*<<queue.ml:155:35>>*/ return [0,
             x,
             function(_c_){ /*<<?>>*/ return aux(next, _c_);}];
     /*<<queue.ml:155:57>>*/ }
    var _a_ = q[2];
     /*<<queue.ml:153:2>>*/ return function(_b_){
      /*<<?>>*/ return aux(_a_, _b_);};
    /*<<queue.ml:157:13>>*/ }
   function add_seq(q, i){
     /*<<queue.ml:159:18>>*/ return  /*<<queue.ml:159:18>>*/ caml_call2
            (Stdlib_Seq[4],
             function(x){
               /*<<queue.ml:159:37>>*/ return add(x, q);
              /*<<queue.ml:159:45>>*/ },
             i);
    /*<<queue.ml:159:48>>*/ }
   function of_seq(g){
     /*<<queue.ml:162:2>>*/  /*<<queue.ml:162:10>>*/ var q = create(0);
     /*<<queue.ml:163:2>>*/ add_seq(q, g);
     /*<<queue.ml:163:2>>*/ return q;
    /*<<queue.ml:164:3>>*/ }
   var
    Stdlib_Queue =
      [0,
       Empty,
       create,
       add,
       add,
       take,
       take_opt,
       take,
       peek,
       peek_opt,
       peek,
       clear,
       copy,
       is_empty,
       length,
       iter,
       fold,
       transfer,
       to_seq,
       add_seq,
       of_seq];
   runtime.caml_register_global(2, Stdlib_Queue, "Stdlib__Queue");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Buffer
//# unitInfo: Requires: Stdlib, Stdlib__Bytes, Stdlib__Seq, Stdlib__String, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_blit_string = runtime.caml_blit_string,
    caml_bswap16 = runtime.caml_bswap16,
    caml_bytes_get = runtime.caml_bytes_get,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_bytes_set16 = runtime.caml_bytes_set16,
    caml_bytes_set32 = runtime.caml_bytes_set32,
    caml_bytes_set64 = runtime.caml_bytes_set64,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_int32_bswap = runtime.caml_int32_bswap,
    caml_int64_bswap = runtime.caml_int64_bswap,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_get = runtime.caml_string_get;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    Stdlib_String = global_data.Stdlib__String,
    Assert_failure = global_data.Assert_failure,
    cst_Buffer_sub = "Buffer.sub",
    cst_Buffer_blit = "Buffer.blit",
    cst_Buffer_nth = "Buffer.nth",
    cst_Buffer_add_cannot_grow_buf = "Buffer.add: cannot grow buffer";
   function create(n){
     /*<<buffer.ml:41:1>>*/ var
     n$0 = 1 <= n ? n : 1,
     n$1 = Stdlib_Sys[12] < n$0 ? Stdlib_Sys[12] : n$0,
      /*<<buffer.ml:43:9>>*/ s =
        /*<<buffer.ml:43:9>>*/ caml_create_bytes(n$1);
     /*<<buffer.ml:44:1>>*/ return [0, [0, s, n$1], 0, s];
    /*<<buffer.ml:44:71>>*/ }
   function contents(b){
     /*<<buffer.ml:46:17>>*/ return caml_call3
            (Stdlib_Bytes[8], b[1][1], 0, b[2]);
    /*<<buffer.ml:46:61>>*/ }
   function to_bytes(b){
     /*<<buffer.ml:47:17>>*/ return caml_call3
            (Stdlib_Bytes[7], b[1][1], 0, b[2]);
    /*<<buffer.ml:47:54>>*/ }
   function sub(b, ofs, len){
     /*<<buffer.ml:50:2>>*/ if
     (0 <= ofs && 0 <= len && (b[2] - len | 0) >= ofs)
      /*<<buffer.ml:52:7>>*/ return  /*<<buffer.ml:52:7>>*/ caml_call3
             (Stdlib_Bytes[8], b[1][1], ofs, len);
     /*<<buffer.ml:51:7>>*/ return  /*<<buffer.ml:51:7>>*/ caml_call1
            (Stdlib[1], cst_Buffer_sub);
    /*<<buffer.ml:52:46>>*/ }
   function blit(src, srcoff, dst, dstoff, len){
     /*<<buffer.ml:56:2>>*/ if
     (0 <= len
      &&
       0 <= srcoff
       &&
        (src[2] - len | 0) >= srcoff
        && 0 <= dstoff && (caml_ml_bytes_length(dst) - len | 0) >= dstoff)
      /*<<buffer.ml:60:4>>*/ return  /*<<buffer.ml:60:4>>*/ caml_call5
             (Stdlib_Bytes[11], src[1][1], srcoff, dst, dstoff, len);
     /*<<buffer.ml:58:7>>*/ return  /*<<buffer.ml:58:7>>*/ caml_call1
            (Stdlib[1], cst_Buffer_blit);
    /*<<buffer.ml:60:53>>*/ }
   function nth(b, ofs){
     /*<<buffer.ml:64:2>>*/ var
     position = b[2],
      /*<<buffer.ml:65:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1];
    if(0 <= ofs && position > ofs && length >= position)
     return runtime.caml_bytes_unsafe_get(buffer, ofs);
     /*<<buffer.ml:67:3>>*/ return  /*<<buffer.ml:67:3>>*/ caml_call1
            (Stdlib[1], cst_Buffer_nth);
    /*<<buffer.ml:68:34>>*/ }
   function length(b){
     /*<<buffer.ml:71:15>>*/ return b[2];
    /*<<buffer.ml:71:25>>*/ }
   function clear(b){
     /*<<buffer.ml:73:14>>*/ b[2] = 0;
    return 0;
    /*<<buffer.ml:73:29>>*/ }
   function reset(b){
     /*<<buffer.ml:76:2>>*/ b[2] = 0;
     /*<<buffer.ml:78:4>>*/  /*<<buffer.ml:78:4>>*/ var
     inner = [0, b[3], caml_ml_bytes_length(b[3])];
    b[1] = inner;
    return 0;
    /*<<buffer.ml:80:18>>*/ }
   function resize(b, more){
     /*<<buffer.ml:87:2>>*/ var
     old_pos = b[2],
     old_len = b[1][2],
      /*<<buffer.ml:89:16>>*/ new_len = [0, old_len];
    for(;;){
     if(new_len[1] >= (old_pos + more | 0)) break;
     new_len[1] = 2 * new_len[1] | 0;
    }
    if(Stdlib_Sys[12] < new_len[1])
     if((old_pos + more | 0) <= Stdlib_Sys[12])
      new_len[1] = Stdlib_Sys[12];
     else
       /*<<buffer.ml:94:9>>*/  /*<<buffer.ml:94:9>>*/ caml_call1
       (Stdlib[2], cst_Buffer_add_cannot_grow_buf);
     /*<<buffer.ml:96:19>>*/  /*<<buffer.ml:96:19>>*/ var
     new_buffer =  /*<<buffer.ml:96:19>>*/ caml_create_bytes(new_len[1]);
     /*<<buffer.ml:99:2>>*/  /*<<buffer.ml:99:2>>*/ caml_call5
     (Stdlib_Bytes[11], b[1][1], 0, new_buffer, 0, b[2]);
    b[1] = [0, new_buffer, new_len[1]];
    return;
    /*<<buffer.ml:100:55>>*/ }
   function add_char(b, c){
     /*<<buffer.ml:113:2>>*/ var
     pos = b[2],
      /*<<buffer.ml:114:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1];
    if(length <= pos){
      /*<<buffer.ml:116:4>>*/ resize(b, 1);
      /*<<buffer.ml:117:4>>*/  /*<<buffer.ml:117:4>>*/ caml_bytes_set
      (b[1][1], b[2], c);
    }
    else
     caml_bytes_unsafe_set(buffer, pos, c);
    b[2] = pos + 1 | 0;
    return 0;
    /*<<buffer.ml:120:23>>*/ }
   var
    uchar_utf_8_byte_length_max = 4,
    uchar_utf_16_byte_length_max = 4,
    cst_Buffer_add_substring_add_s = "Buffer.add_substring/add_subbytes",
    cst_Buffer_add_channel = "Buffer.add_channel",
    _a_ = [0, "buffer.ml", 220, 9],
    cst_Buffer_truncate = "Buffer.truncate";
   function add_utf_8_uchar(b, u){
     /*<<buffer.ml:126:2>>*/ for(;;){
     var pos = b[2];
     if(b[1][2] <= pos)
       /*<<buffer.ml:127:32>>*/ resize(b, uchar_utf_8_byte_length_max);
      /*<<buffer.ml:128:10>>*/  /*<<buffer.ml:128:10>>*/ var
      n =
         /*<<buffer.ml:128:10>>*/ caml_call3
         (Stdlib_Bytes[51], b[1][1], pos, u);
      /*<<buffer.ml:129:2>>*/ if(0 !== n){b[2] = pos + n | 0; return 0;}
      /*<<buffer.ml:130:8>>*/ resize(b, uchar_utf_8_byte_length_max);
    }
    /*<<buffer.ml:131:30>>*/ }
   function add_utf_16be_uchar(b, u){
     /*<<buffer.ml:134:2>>*/ for(;;){
     var pos = b[2];
     if(b[1][2] <= pos)
       /*<<buffer.ml:135:32>>*/ resize(b, uchar_utf_16_byte_length_max);
      /*<<buffer.ml:136:10>>*/  /*<<buffer.ml:136:10>>*/ var
      n =
         /*<<buffer.ml:136:10>>*/ caml_call3
         (Stdlib_Bytes[54], b[1][1], pos, u);
      /*<<buffer.ml:137:2>>*/ if(0 !== n){b[2] = pos + n | 0; return 0;}
      /*<<buffer.ml:138:8>>*/ resize(b, uchar_utf_16_byte_length_max);
    }
    /*<<buffer.ml:139:30>>*/ }
   function add_utf_16le_uchar(b, u){
     /*<<buffer.ml:142:2>>*/ for(;;){
     var pos = b[2];
     if(b[1][2] <= pos)
       /*<<buffer.ml:143:32>>*/ resize(b, uchar_utf_16_byte_length_max);
      /*<<buffer.ml:144:10>>*/  /*<<buffer.ml:144:10>>*/ var
      n =
         /*<<buffer.ml:144:10>>*/ caml_call3
         (Stdlib_Bytes[57], b[1][1], pos, u);
      /*<<buffer.ml:145:2>>*/ if(0 !== n){b[2] = pos + n | 0; return 0;}
      /*<<buffer.ml:146:8>>*/ resize(b, uchar_utf_16_byte_length_max);
    }
    /*<<buffer.ml:147:30>>*/ }
   function add_substring(b, s, offset, len){
     /*<<buffer.ml:150:2>>*/ var _q_ = offset < 0 ? 1 : 0;
    if(_q_)
     var _r_ = _q_;
    else
     var
      _s_ = len < 0 ? 1 : 0,
      _r_ = _s_ || ((caml_ml_string_length(s) - len | 0) < offset ? 1 : 0);
    if(_r_)
      /*<<buffer.ml:151:7>>*/  /*<<buffer.ml:151:7>>*/ caml_call1
      (Stdlib[1], cst_Buffer_add_substring_add_s);
     /*<<buffer.ml:153:2>>*/ var
     position = b[2],
      /*<<buffer.ml:153:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + len | 0;
    if(length < new_position){
      /*<<buffer.ml:156:4>>*/ resize(b, len);
      /*<<buffer.ml:157:4>>*/  /*<<buffer.ml:157:4>>*/ caml_call5
      (Stdlib_Bytes[12], s, offset, b[1][1], b[2], len);
    }
    else
      /*<<buffer.ml:159:4>>*/  /*<<buffer.ml:159:4>>*/ caml_blit_string
      (s, offset, buffer, position, len);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:160:28>>*/ }
   function add_subbytes(b, s, offset, len){
     /*<<buffer.ml:163:2>>*/ return add_substring
            (b,
              /*<<buffer.ml:163:18>>*/ caml_call1(Stdlib_Bytes[44], s),
             offset,
             len);
    /*<<buffer.ml:163:55>>*/ }
   function add_string(b, s){
     /*<<buffer.ml:166:2>>*/ var
     len = caml_ml_string_length(s),
      /*<<buffer.ml:167:2>>*/ position = b[2],
      /*<<buffer.ml:168:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + len | 0;
    if(length < new_position){
      /*<<buffer.ml:171:4>>*/ resize(b, len);
      /*<<buffer.ml:172:4>>*/  /*<<buffer.ml:172:4>>*/ caml_call5
      (Stdlib_Bytes[12], s, 0, b[1][1], b[2], len);
    }
    else
      /*<<buffer.ml:174:4>>*/  /*<<buffer.ml:174:4>>*/ caml_blit_string
      (s, 0, buffer, position, len);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:175:28>>*/ }
   function add_bytes(b, s){
     /*<<buffer.ml:177:20>>*/ return add_string
            (b,  /*<<buffer.ml:177:33>>*/ caml_call1(Stdlib_Bytes[44], s));
    /*<<buffer.ml:177:59>>*/ }
   function add_buffer(b, bs){
     /*<<buffer.ml:180:2>>*/ return add_subbytes(b, bs[1][1], 0, bs[2]);
    /*<<buffer.ml:180:46>>*/ }
   function add_channel(b, ic, to_read$1){
     /*<<buffer.ml:206:2>>*/ var
     _o_ = to_read$1 < 0 ? 1 : 0,
     _p_ = _o_ || (Stdlib_Sys[12] < to_read$1 ? 1 : 0);
    if(_p_)
      /*<<buffer.ml:207:4>>*/  /*<<buffer.ml:207:4>>*/ caml_call1
      (Stdlib[1], cst_Buffer_add_channel);
    if(b[1][2] < (b[2] + to_read$1 | 0))
      /*<<buffer.ml:200:44>>*/ resize(b, to_read$1);
    var
     ofs$1 = b[2],
     buf = b[1][1],
     already_read = 0,
     ofs = ofs$1,
     to_read = to_read$1;
     /*<<buffer.ml:185:4>>*/ for(;;){
     if(0 !== to_read){
       /*<<buffer.ml:187:14>>*/  /*<<buffer.ml:187:14>>*/ var
       r =
          /*<<buffer.ml:187:14>>*/ caml_call4
          (Stdlib[84], ic, buf, ofs, to_read);
       /*<<buffer.ml:188:6>>*/ if(0 !== r){
       var
        already_read$0 = already_read + r | 0,
        ofs$0 = ofs + r | 0,
        to_read$0 = to_read - r | 0,
        already_read = already_read$0,
        ofs = ofs$0,
        to_read = to_read$0;
       continue;
      }
     }
     b[2] = b[2] + already_read | 0;
     if(already_read < to_read$1)
       /*<<buffer.ml:211:18>>*/ throw  /*<<buffer.ml:211:18>>*/ caml_maybe_attach_backtrace
             (Stdlib[12], 1);
      /*<<buffer.ml:212:2>>*/ return 0;
    }
    /*<<buffer.ml:212:4>>*/ }
   function output_buffer(oc, b){
     /*<<buffer.ml:215:2>>*/ return caml_call4
            (Stdlib[68], oc, b[1][1], 0, b[2]);
    /*<<buffer.ml:215:39>>*/ }
   function add_substitute(b, f, s){
     /*<<buffer.ml:260:2>>*/ var
     lim$1 = caml_ml_string_length(s),
     previous = 32,
     i$4 = 0;
     /*<<buffer.ml:262:4>>*/ for(;;){
     if(i$4 >= lim$1){
      var _n_ = 92 === previous ? 1 : 0;
      return _n_ ? add_char(b, previous) : _n_;
     }
      /*<<buffer.ml:263:12>>*/  /*<<buffer.ml:263:12>>*/ var
      previous$0 =  /*<<buffer.ml:263:12>>*/ caml_string_get(s, i$4);
     if(36 === previous$0)
      if(92 === previous){
        /*<<buffer.ml:265:9>>*/ add_char(b, previous$0);
        /*<<buffer.ml:265:9>>*/ var
         /*<<buffer.ml:265:9>>*/ i$5 = i$4 + 1 | 0,
        previous = 32,
        i$4 = i$5;
      }
      else{
        /*<<buffer.ml:268:9>>*/  /*<<buffer.ml:268:9>>*/ var
        start$0 = i$4 + 1 | 0;
       if(lim$1 <= start$0)
         /*<<buffer.ml:245:23>>*/ throw  /*<<buffer.ml:245:23>>*/ caml_maybe_attach_backtrace
               (Stdlib[8], 1);
        /*<<buffer.ml:246:8>>*/  /*<<buffer.ml:246:8>>*/ var
        opening =  /*<<buffer.ml:246:8>>*/ caml_string_get(s, start$0);
       a:
       {
        if(40 !== opening && 123 !== opening){
          /*<<buffer.ml:254:5>>*/ var
           /*<<buffer.ml:254:5>>*/ start = start$0 + 1 | 0,
          lim$0 = caml_ml_string_length(s);
         b:
         {
          c:
          {
           d:
           {
            var i$2 = start;
             /*<<buffer.ml:237:4>>*/ for(;;){
             if(lim$0 <= i$2) break c;
              /*<<buffer.ml:238:10>>*/  /*<<buffer.ml:238:10>>*/ var
              match =  /*<<buffer.ml:238:10>>*/ caml_string_get(s, i$2);
             if(91 <= match){
              if(97 <= match){
               if(123 <= match) break d;
              }
              else if(95 !== match) break d;
             }
             else
              if(58 <= match){
               if(65 > match) break;
              }
              else if(48 > match) break d;
             var i$3 = i$2 + 1 | 0, i$2 = i$3;
            }
           }
           var stop$0 = i$2;
           break b;
          }
          var stop$0 = lim$0;
         }
         var
          match$0 =
            [0,
              /*<<buffer.ml:255:5>>*/ caml_call3
              (Stdlib_String[16], s, start$0, stop$0 - start$0 | 0),
             stop$0];
         break a;
        }
         /*<<buffer.ml:249:5>>*/ var
          /*<<buffer.ml:249:5>>*/ new_start = start$0 + 1 | 0,
         k$2 = 0;
        if(40 === opening)
         var closing = 41;
        else{
         if(123 !== opening)
           /*<<buffer.ml:220:9>>*/ throw  /*<<buffer.ml:220:9>>*/ caml_maybe_attach_backtrace
                 ([0, Assert_failure, _a_], 1);
         var closing = 125;
        }
        var lim = caml_ml_string_length(s), k = k$2, stop = new_start;
         /*<<buffer.ml:228:4>>*/ for(;;){
         if(lim <= stop)
           /*<<buffer.ml:228:21>>*/ throw  /*<<buffer.ml:228:21>>*/ caml_maybe_attach_backtrace
                 (Stdlib[8], 1);
         if( /*<<buffer.ml:229:7>>*/ caml_string_get(s, stop) === opening)
          var i = stop + 1 | 0, k$0 = k + 1 | 0, k = k$0, stop = i;
         else if
          ( /*<<buffer.ml:230:7>>*/ caml_string_get(s, stop) === closing){
          if(0 === k) break;
          var i$0 = stop + 1 | 0, k$1 = k - 1 | 0, k = k$1, stop = i$0;
         }
         else
          var i$1 = stop + 1 | 0, stop = i$1;
        }
        var
         match$0 =
           [0,
             /*<<buffer.ml:251:5>>*/ caml_call3
             (Stdlib_String[16], s, new_start, (stop - start$0 | 0) - 1 | 0),
            stop + 1 | 0];
       }
       var next_i = match$0[2], ident = match$0[1];
        /*<<buffer.ml:270:9>>*/ add_string
        (b,  /*<<buffer.ml:270:22>>*/ caml_call1(f, ident));
       var previous = 32, i$4 = next_i;
      }
     else if(92 === previous){
       /*<<buffer.ml:273:9>>*/ add_char(b, 92);
       /*<<buffer.ml:274:9>>*/ add_char(b, previous$0);
       /*<<buffer.ml:274:9>>*/ var
        /*<<buffer.ml:274:9>>*/ i$6 = i$4 + 1 | 0,
       previous = 32,
       i$4 = i$6;
     }
     else if(92 === previous$0)
       /*<<buffer.ml:277:9>>*/ var
        /*<<buffer.ml:277:9>>*/ i$7 = i$4 + 1 | 0,
       previous = previous$0,
       i$4 = i$7;
     else{
       /*<<buffer.ml:279:9>>*/ add_char(b, previous$0);
       /*<<buffer.ml:279:9>>*/ var
        /*<<buffer.ml:279:9>>*/ i$8 = i$4 + 1 | 0,
       previous = previous$0,
       i$4 = i$8;
     }
    }
    /*<<buffer.ml:283:13>>*/ }
   function truncate(b, len){
     /*<<buffer.ml:286:4>>*/ if(0 <= len && b[2] >= len){b[2] = len; return 0;}
     /*<<buffer.ml:287:6>>*/ return  /*<<buffer.ml:287:6>>*/ caml_call1
            (Stdlib[1], cst_Buffer_truncate);
    /*<<buffer.ml:289:23>>*/ }
   function to_seq(b){
    function aux(i, param){
      /*<<buffer.ml:296:4>>*/ if(b[2] <= i)
       /*<<buffer.ml:296:28>>*/ return 0;
      /*<<buffer.ml:298:14>>*/ var
       /*<<buffer.ml:298:14>>*/ x =
         /*<<buffer.ml:298:14>>*/ caml_bytes_get(b[1][1], i),
       /*<<buffer.ml:298:14>>*/ _l_ = i + 1 | 0;
      /*<<buffer.ml:299:6>>*/ return [0,
             x,
             function(_m_){ /*<<?>>*/ return aux(_l_, _m_);}];
     /*<<buffer.ml:299:29>>*/ }
     /*<<buffer.ml:301:2>>*/ var _j_ = 0;
     /*<<buffer.ml:301:2>>*/ return function(_k_){
      /*<<?>>*/ return aux(_j_, _k_);};
    /*<<buffer.ml:301:7>>*/ }
   function to_seqi(b){
    function aux(i, param){
      /*<<buffer.ml:306:4>>*/ if(b[2] <= i)
       /*<<buffer.ml:306:28>>*/ return 0;
      /*<<buffer.ml:308:14>>*/ var
       /*<<buffer.ml:308:14>>*/ x =
         /*<<buffer.ml:308:14>>*/ caml_bytes_get(b[1][1], i),
       /*<<buffer.ml:308:14>>*/ _h_ = i + 1 | 0;
      /*<<buffer.ml:309:6>>*/ return [0,
             [0, i, x],
             function(_i_){ /*<<?>>*/ return aux(_h_, _i_);}];
     /*<<buffer.ml:309:33>>*/ }
     /*<<buffer.ml:311:2>>*/ var _f_ = 0;
     /*<<buffer.ml:311:2>>*/ return function(_g_){
      /*<<?>>*/ return aux(_f_, _g_);};
    /*<<buffer.ml:311:7>>*/ }
   function add_seq(b, seq){
     /*<<buffer.ml:313:20>>*/ return  /*<<buffer.ml:313:20>>*/ caml_call2
            (Stdlib_Seq[4],
             function(_e_){ /*<<?>>*/ return add_char(b, _e_);},
             seq);
    /*<<buffer.ml:313:45>>*/ }
   function of_seq(i){
     /*<<buffer.ml:316:2>>*/  /*<<buffer.ml:316:10>>*/ var b = create(32);
     /*<<buffer.ml:317:2>>*/ add_seq(b, i);
     /*<<buffer.ml:317:2>>*/ return b;
    /*<<buffer.ml:318:3>>*/ }
   function add_int8(b, x){
     /*<<buffer.ml:337:2>>*/ var
     position = b[2],
      /*<<buffer.ml:338:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
      /*<<buffer.ml:339:2>>*/ new_position = position + 1 | 0;
    if(length < new_position){
      /*<<buffer.ml:341:4>>*/ resize(b, 1);
      /*<<buffer.ml:342:4>>*/  /*<<buffer.ml:342:4>>*/ caml_bytes_set
      (b[1][1], b[2], x);
    }
    else
     caml_bytes_unsafe_set(buffer, position, x);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:345:28>>*/ }
   function add_int16_ne(b, x){
     /*<<buffer.ml:348:2>>*/ var
     position = b[2],
      /*<<buffer.ml:349:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
      /*<<buffer.ml:350:2>>*/ new_position = position + 2 | 0;
    if(length < new_position){
      /*<<buffer.ml:352:4>>*/ resize(b, 2);
      /*<<buffer.ml:353:4>>*/  /*<<buffer.ml:353:4>>*/ caml_bytes_set16
      (b[1][1], b[2], x);
    }
    else
      /*<<buffer.ml:355:4>>*/  /*<<buffer.ml:355:4>>*/ caml_bytes_set16
      (buffer, position, x);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:356:28>>*/ }
   function add_int32_ne(b, x){
     /*<<buffer.ml:359:2>>*/ var
     position = b[2],
      /*<<buffer.ml:360:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
      /*<<buffer.ml:361:2>>*/ new_position = position + 4 | 0;
    if(length < new_position){
      /*<<buffer.ml:363:4>>*/ resize(b, 4);
      /*<<buffer.ml:364:4>>*/  /*<<buffer.ml:364:4>>*/ caml_bytes_set32
      (b[1][1], b[2], x);
    }
    else
      /*<<buffer.ml:366:4>>*/  /*<<buffer.ml:366:4>>*/ caml_bytes_set32
      (buffer, position, x);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:367:28>>*/ }
   function add_int64_ne(b, x){
     /*<<buffer.ml:370:2>>*/ var
     position = b[2],
      /*<<buffer.ml:371:2>>*/ match = b[1],
     length = match[2],
     buffer = match[1],
      /*<<buffer.ml:372:2>>*/ new_position = position + 8 | 0;
    if(length < new_position){
      /*<<buffer.ml:374:4>>*/ resize(b, 8);
      /*<<buffer.ml:375:4>>*/  /*<<buffer.ml:375:4>>*/ caml_bytes_set64
      (b[1][1], b[2], x);
    }
    else
      /*<<buffer.ml:377:4>>*/  /*<<buffer.ml:377:4>>*/ caml_bytes_set64
      (buffer, position, x);
    b[2] = new_position;
    return 0;
    /*<<buffer.ml:378:28>>*/ }
   function add_int16_le(b, x){
     /*<<buffer.ml:381:2>>*/ var _d_ = Stdlib_Sys[11] ? caml_bswap16(x) : x;
    return add_int16_ne(b, _d_);
    /*<<buffer.ml:381:57>>*/ }
   function add_int16_be(b, x){
     /*<<buffer.ml:384:2>>*/ var x$0 = Stdlib_Sys[11] ? x : caml_bswap16(x);
     /*<<buffer.ml:384:41>>*/ return add_int16_ne(b, x$0);
    /*<<buffer.ml:384:57>>*/ }
   function add_int32_le(b, x){
     /*<<buffer.ml:387:2>>*/ var
     _c_ = Stdlib_Sys[11] ?  /*<<buffer.ml:387:41>>*/ caml_int32_bswap(x) : x;
     /*<<buffer.ml:387:41>>*/ return add_int32_ne(b, _c_);
    /*<<buffer.ml:387:57>>*/ }
   function add_int32_be(b, x){
     /*<<buffer.ml:390:2>>*/ var
     x$0 = Stdlib_Sys[11] ? x :  /*<<buffer.ml:390:48>>*/ caml_int32_bswap(x);
     /*<<buffer.ml:390:48>>*/ return add_int32_ne(b, x$0);
    /*<<buffer.ml:390:57>>*/ }
   function add_int64_le(b, x){
     /*<<buffer.ml:393:2>>*/ var
     _b_ = Stdlib_Sys[11] ?  /*<<buffer.ml:393:41>>*/ caml_int64_bswap(x) : x;
     /*<<buffer.ml:393:41>>*/ return add_int64_ne(b, _b_);
    /*<<buffer.ml:393:57>>*/ }
   function add_int64_be(b, x){
     /*<<buffer.ml:396:2>>*/ var
     x$0 = Stdlib_Sys[11] ? x :  /*<<buffer.ml:396:48>>*/ caml_int64_bswap(x);
     /*<<buffer.ml:396:48>>*/ return add_int64_ne(b, x$0);
    /*<<buffer.ml:396:57>>*/ }
   var
    Stdlib_Buffer =
      [0,
       create,
       contents,
       to_bytes,
       sub,
       blit,
       nth,
       length,
       clear,
       reset,
       output_buffer,
       truncate,
       add_char,
       add_utf_8_uchar,
       add_utf_16le_uchar,
       add_utf_16be_uchar,
       add_string,
       add_bytes,
       add_substring,
       add_subbytes,
       add_substitute,
       add_buffer,
       add_channel,
       to_seq,
       to_seqi,
       add_seq,
       of_seq,
       add_int8,
       add_int8,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int32_ne,
       add_int32_be,
       add_int32_le,
       add_int64_ne,
       add_int64_be,
       add_int64_le];
   runtime.caml_register_global(14, Stdlib_Buffer, "Stdlib__Buffer");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Mutex
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_mutex_lock = runtime.caml_ml_mutex_lock,
    caml_ml_mutex_unlock = runtime.caml_ml_mutex_unlock,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function protect(m, f){
     /*<<mutex.ml:27:2>>*/  /*<<mutex.ml:27:2>>*/ caml_ml_mutex_lock(m);
     /*<<mutex.ml:27:2>>*/ try{
      /*<<mutex.ml:28:8>>*/  /*<<mutex.ml:28:8>>*/ var
      x =  /*<<mutex.ml:28:8>>*/ caml_call1(f, 0);
    }
    catch(e$0){
     var e = caml_wrap_exception(e$0);
      /*<<mutex.ml:33:4>>*/  /*<<mutex.ml:33:4>>*/ caml_ml_mutex_unlock(m);
      /*<<mutex.ml:34:4>>*/ throw  /*<<mutex.ml:34:4>>*/ caml_maybe_attach_backtrace
            (e, 0);
    }
     /*<<mutex.ml:30:4>>*/  /*<<mutex.ml:30:4>>*/ caml_ml_mutex_unlock(m);
     /*<<mutex.ml:30:4>>*/ return x;
    /*<<mutex.ml:34:13>>*/ }
   var
    Stdlib_Mutex =
      [0,
       runtime.caml_ml_mutex_new,
       caml_ml_mutex_lock,
       runtime.caml_ml_mutex_try_lock,
       caml_ml_mutex_unlock,
       protect];
   runtime.caml_register_global(0, Stdlib_Mutex, "Stdlib__Mutex");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Condition
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    Stdlib_Condition =
      [0,
       runtime.caml_ml_condition_new,
       runtime.caml_ml_condition_wait,
       runtime.caml_ml_condition_signal,
       runtime.caml_ml_condition_broadcast];
   runtime.caml_register_global(0, Stdlib_Condition, "Stdlib__Condition");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Semaphore
//# unitInfo: Requires: Stdlib, Stdlib__Condition, Stdlib__Mutex
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Mutex = global_data.Stdlib__Mutex,
    Stdlib_Condition = global_data.Stdlib__Condition,
    Stdlib = global_data.Stdlib,
    cst_Semaphore_Counting_init_wr =
      "Semaphore.Counting.init: wrong initial value",
    cst_Semaphore_Counting_release = "Semaphore.Counting.release: overflow";
   function make(v){
     /*<<semaphore.ml:29:2>>*/ if(v < 0)
      /*<<semaphore.ml:29:16>>*/  /*<<semaphore.ml:29:16>>*/ caml_call1
      (Stdlib[1], cst_Semaphore_Counting_init_wr);
     /*<<semaphore.ml:30:39>>*/  /*<<semaphore.ml:30:39>>*/ var
     _c_ =  /*<<semaphore.ml:30:39>>*/ caml_call1(Stdlib_Condition[1], 0);
     /*<<semaphore.ml:30:2>>*/ return [0,
             /*<<semaphore.ml:30:10>>*/ caml_call1(Stdlib_Mutex[1], 0),
            v,
            _c_];
    /*<<semaphore.ml:30:59>>*/ }
   function release(s){
     /*<<semaphore.ml:33:2>>*/  /*<<semaphore.ml:33:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
    if(s[2] < Stdlib[19]){
     s[2] = s[2] + 1 | 0;
      /*<<semaphore.ml:36:4>>*/  /*<<semaphore.ml:36:4>>*/ caml_call1
      (Stdlib_Condition[3], s[3]);
     return caml_call1(Stdlib_Mutex[4], s[1]);
    }
     /*<<semaphore.ml:39:4>>*/  /*<<semaphore.ml:39:4>>*/ caml_call1
     (Stdlib_Mutex[4], s[1]);
     /*<<semaphore.ml:40:4>>*/ throw  /*<<semaphore.ml:40:4>>*/ caml_maybe_attach_backtrace
           ([0, Stdlib[11], cst_Semaphore_Counting_release], 1);
    /*<<semaphore.ml:41:5>>*/ }
   function acquire(s){
     /*<<semaphore.ml:44:2>>*/  /*<<semaphore.ml:44:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
     /*<<semaphore.ml:45:19>>*/ for(;;){
     if(0 !== s[2]){
      s[2] = s[2] - 1 | 0;
      return caml_call1(Stdlib_Mutex[4], s[1]);
     }
      /*<<semaphore.ml:45:19>>*/  /*<<semaphore.ml:45:19>>*/ caml_call2
      (Stdlib_Condition[2], s[3], s[1]);
    }
    /*<<semaphore.ml:47:20>>*/ }
   function try_acquire(s){
     /*<<semaphore.ml:50:2>>*/  /*<<semaphore.ml:50:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
    var ret = 0 === s[2] ? 0 : (s[2] = s[2] - 1 | 0, 1);
     /*<<semaphore.ml:52:2>>*/  /*<<semaphore.ml:52:2>>*/ caml_call1
     (Stdlib_Mutex[4], s[1]);
     /*<<semaphore.ml:52:2>>*/ return ret;
    /*<<semaphore.ml:53:5>>*/ }
   function get_value(s){
     /*<<semaphore.ml:55:18>>*/ return s[2];
    /*<<semaphore.ml:55:21>>*/ }
    /*<<semaphore.ml:24:18>>*/  /*<<semaphore.ml:24:18>>*/ var
    Counting = [0, make, release, acquire, try_acquire, get_value];
   function make$0(b){
     /*<<semaphore.ml:64:2>>*/ var
      /*<<semaphore.ml:66:14>>*/ _a_ =
        /*<<semaphore.ml:66:14>>*/ caml_call1(Stdlib_Condition[1], 0),
     _b_ = b ? 1 : 0;
     /*<<semaphore.ml:64:2>>*/ return [0,
             /*<<semaphore.ml:64:10>>*/ caml_call1(Stdlib_Mutex[1], 0),
            _b_,
            _a_];
    /*<<semaphore.ml:66:34>>*/ }
   function release$0(s){
     /*<<semaphore.ml:69:2>>*/  /*<<semaphore.ml:69:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
    s[2] = 1;
     /*<<semaphore.ml:71:2>>*/  /*<<semaphore.ml:71:2>>*/ caml_call1
     (Stdlib_Condition[3], s[3]);
    return caml_call1(Stdlib_Mutex[4], s[1]);
    /*<<semaphore.ml:72:20>>*/ }
   function acquire$0(s){
     /*<<semaphore.ml:75:2>>*/  /*<<semaphore.ml:75:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
     /*<<semaphore.ml:76:19>>*/ for(;;){
     if(0 !== s[2]){s[2] = 0; return caml_call1(Stdlib_Mutex[4], s[1]);}
      /*<<semaphore.ml:76:19>>*/  /*<<semaphore.ml:76:19>>*/ caml_call2
      (Stdlib_Condition[2], s[3], s[1]);
    }
    /*<<semaphore.ml:78:20>>*/ }
   function try_acquire$0(s){
     /*<<semaphore.ml:81:2>>*/  /*<<semaphore.ml:81:2>>*/ caml_call1
     (Stdlib_Mutex[2], s[1]);
    var ret = 0 === s[2] ? 0 : (s[2] = 0, 1);
     /*<<semaphore.ml:83:2>>*/  /*<<semaphore.ml:83:2>>*/ caml_call1
     (Stdlib_Mutex[4], s[1]);
     /*<<semaphore.ml:83:2>>*/ return ret;
    /*<<semaphore.ml:84:5>>*/ }
    /*<<semaphore.ml:59:16>>*/ var
     /*<<semaphore.ml:59:16>>*/ Binary =
      [0, make$0, release$0, acquire$0, try_acquire$0],
    Stdlib_Semaphore = [0, Counting, Binary];
   runtime.caml_register_global(5, Stdlib_Semaphore, "Stdlib__Semaphore");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Domain
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Atomic, Stdlib__Condition, Stdlib__List, Stdlib__Mutex
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_check_bound = runtime.caml_check_bound,
    caml_domain_dls_set = runtime.caml_domain_dls_set,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_domain_id = runtime.caml_ml_domain_id,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Mutex = global_data.Stdlib__Mutex,
    Stdlib_Condition = global_data.Stdlib__Condition,
    Stdlib = global_data.Stdlib,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_Array = global_data.Stdlib__Array;
   function cpu_relax(param){
     /*<<domain.ml:32:19>>*/ return  /*<<domain.ml:32:19>>*/ runtime.caml_ml_domain_cpu_relax
            (0);
    /*<<domain.ml:32:35>>*/ }
    /*<<domain.ml:51:30>>*/  /*<<domain.ml:51:30>>*/ var
    unique_value = [0, 0];
   function create_dls(param){
     /*<<domain.ml:59:4>>*/  /*<<domain.ml:59:13>>*/ var
     st =  /*<<domain.ml:59:13>>*/ caml_make_vect(8, unique_value);
     /*<<domain.ml:60:4>>*/  /*<<domain.ml:60:4>>*/ caml_domain_dls_set(st);
     /*<<domain.ml:60:4>>*/ return;
    /*<<domain.ml:60:20>>*/ }
    /*<<domain.ml:62:10>>*/ create_dls(0);
    /*<<domain.ml:66:20>>*/ var
     /*<<domain.ml:66:20>>*/ key_counter =
       /*<<domain.ml:66:20>>*/ caml_call1(Stdlib_Atomic[1], 0),
     /*<<domain.ml:71:20>>*/ parent_keys =
       /*<<domain.ml:71:20>>*/ caml_call1(Stdlib_Atomic[1], 0);
   function new_key(split_from_parent, init_orphan){
     /*<<domain.ml:79:4>>*/ var
      /*<<domain.ml:79:14>>*/ idx =
        /*<<domain.ml:79:14>>*/ caml_call2(Stdlib_Atomic[6], key_counter, 1),
      /*<<domain.ml:80:12>>*/ k = [0, idx, init_orphan];
     /*<<domain.ml:81:4>>*/ if(split_from_parent){
      /*<<domain.ml:83:35>>*/ var
      split = split_from_parent[1],
       /*<<domain.ml:83:35>>*/ ki = [0, k, split];
      /*<<domain.ml:74:4>>*/ for(;;){
       /*<<domain.ml:74:12>>*/  /*<<domain.ml:74:12>>*/ var
       l =  /*<<domain.ml:74:12>>*/ caml_call1(Stdlib_Atomic[2], parent_keys);
      if
       (!
        (1
        -
          /*<<domain.ml:75:11>>*/ caml_call3
          (Stdlib_Atomic[5], parent_keys, l, [0, ki, l])))
       break;
     }
    }
     /*<<domain.ml:85:4>>*/ return k;
    /*<<domain.ml:85:5>>*/ }
   function maybe_grow(idx){
     /*<<domain.ml:90:4>>*/ var
     st = runtime.caml_domain_dls_get(0),
      /*<<domain.ml:91:4>>*/ sz = st.length - 1;
    if(idx < sz)  /*<<domain.ml:92:21>>*/ return st;
    var new_sz = sz;
     /*<<domain.ml:95:8>>*/ for(;;){
     if(idx < new_sz){
       /*<<domain.ml:98:19>>*/  /*<<domain.ml:98:19>>*/ var
       new_st =  /*<<domain.ml:98:19>>*/ caml_make_vect(new_sz, unique_value);
       /*<<domain.ml:99:6>>*/  /*<<domain.ml:99:6>>*/ caml_call5
       (Stdlib_Array[8], st, 0, new_st, 0, sz);
       /*<<domain.ml:100:6>>*/  /*<<domain.ml:100:6>>*/ caml_domain_dls_set
       (new_st);
       /*<<domain.ml:100:6>>*/ return new_st;
     }
     var s = 2 * new_sz | 0, new_sz = s;
    }
    /*<<domain.ml:102:7>>*/ }
   function set(param, x){
     /*<<domain.ml:105:13>>*/ var
     idx = param[1],
      /*<<domain.ml:105:13>>*/ st = maybe_grow(idx);
     /*<<domain.ml:109:4>>*/ caml_check_bound(st, idx)[1 + idx] = x;
     /*<<domain.ml:109:4>>*/ return 0;
   }
   function get(param){
     /*<<domain.ml:112:13>>*/ var
     init = param[2],
     idx = param[1],
      /*<<domain.ml:112:13>>*/ st = maybe_grow(idx),
      /*<<domain.ml:113:12>>*/ v = caml_check_bound(st, idx)[1 + idx];
    if(v !== unique_value)  /*<<domain.ml:118:9>>*/ return v;
     /*<<domain.ml:115:24>>*/  /*<<domain.ml:115:24>>*/ var
     v$0 =  /*<<domain.ml:115:24>>*/ caml_call1(init, 0);
     /*<<domain.ml:116:6>>*/ caml_check_bound(st, idx)[1 + idx] = v$0;
     /*<<domain.ml:116:6>>*/ return v$0;
   }
   function get_id(param){
    var domain = param[1];
     /*<<domain.ml:136:27>>*/ return domain;
   }
   function self(param){
     /*<<domain.ml:138:14>>*/ return  /*<<domain.ml:138:14>>*/ caml_ml_domain_id
            (0);
    /*<<domain.ml:138:25>>*/ }
   function is_main_domain(param){
     /*<<domain.ml:140:24>>*/ return 0
            ===  /*<<domain.ml:140:25>>*/ caml_ml_domain_id(0)
            ? 1
            : 0;
    /*<<domain.ml:140:44>>*/ }
    /*<<domain.ml:145:27>>*/ var
     /*<<domain.ml:145:27>>*/ first_domain_spawned =
       /*<<domain.ml:145:27>>*/ caml_call1(Stdlib_Atomic[1], 0),
     /*<<domain.ml:147:27>>*/ first_spawn_function =
      [0,
       function(param){
         /*<<domain.ml:147:42>>*/ return;
        /*<<domain.ml:147:44>>*/ }],
    cst_first_domain_already_spawn = "first domain already spawned";
   function before_first_spawn(f){
     /*<<domain.ml:150:2>>*/ if
     ( /*<<domain.ml:150:5>>*/ caml_call1
       (Stdlib_Atomic[2], first_domain_spawned))
      /*<<domain.ml:151:4>>*/ throw  /*<<domain.ml:151:4>>*/ caml_maybe_attach_backtrace
            ([0, Stdlib[6], cst_first_domain_already_spawn], 1);
    var old_f = first_spawn_function[1];
    function new_f(param){
      /*<<domain.ml:154:19>>*/  /*<<domain.ml:154:19>>*/ caml_call1(old_f, 0);
      /*<<domain.ml:154:19>>*/ return  /*<<domain.ml:154:19>>*/ caml_call1
             (f, 0);
     /*<<domain.ml:154:33>>*/ }
    first_spawn_function[1] = new_f;
    return 0;
    /*<<domain.ml:156:5>>*/ }
    /*<<domain.ml:166:18>>*/  /*<<domain.ml:166:18>>*/ var
    at_exit_key =
      new_key
       (0,
        function(param, _c_){
          /*<<domain.ml:166:52>>*/ return 0;
         /*<<domain.ml:166:54>>*/ });
   function at_exit(f){
     /*<<domain.ml:169:2>>*/  /*<<domain.ml:169:32>>*/ var
     old_exit = get(at_exit_key);
    function new_exit(param){
      /*<<domain.ml:175:4>>*/  /*<<domain.ml:175:4>>*/ caml_call1(f, 0);
      /*<<domain.ml:175:4>>*/ return  /*<<domain.ml:175:4>>*/ caml_call1
             (old_exit, 0);
     /*<<domain.ml:175:21>>*/ }
     /*<<domain.ml:177:2>>*/ return set(at_exit_key, new_exit);
    /*<<domain.ml:177:30>>*/ }
   function do_at_exit(param){
     /*<<domain.ml:180:2>>*/  /*<<domain.ml:180:25>>*/ var
     f = get(at_exit_key);
     /*<<domain.ml:181:2>>*/ return  /*<<domain.ml:181:2>>*/ caml_call1(f, 0);
    /*<<domain.ml:181:6>>*/ }
   Stdlib[104][1] = do_at_exit;
   var
    cst_internal_error_Am_I_alread = "internal error: Am I already finished?";
   function spawn(f){
     /*<<domain.ml:188:2>>*/ if
     (1
      -
        /*<<domain.ml:159:9>>*/ caml_call1
        (Stdlib_Atomic[2], first_domain_spawned)){
      /*<<domain.ml:160:4>>*/  /*<<domain.ml:160:4>>*/ caml_call2
      (Stdlib_Atomic[3], first_domain_spawned, 1);
      /*<<domain.ml:161:4>>*/  /*<<domain.ml:161:4>>*/ caml_call1
      (first_spawn_function[1], 0);
     first_spawn_function[1] =
      function(param){
        /*<<domain.ml:163:39>>*/ return 0;
       /*<<domain.ml:163:41>>*/ };
    }
     /*<<domain.ml:124:6>>*/ var
      /*<<domain.ml:124:6>>*/ _a_ =
        /*<<domain.ml:124:6>>*/ caml_call1(Stdlib_Atomic[2], parent_keys),
      /*<<domain.ml:124:6>>*/ pk =
        /*<<domain.ml:124:6>>*/ caml_call2
        (Stdlib_List[20],
         function(param){
           /*<<domain.ml:122:6>>*/ var
           split = param[2],
           k = param[1],
           idx = k[1];
           /*<<domain.ml:123:11>>*/ return [0,
                  idx,
                   /*<<domain.ml:123:26>>*/ caml_call1(split, get(k))];
          /*<<domain.ml:123:43>>*/ },
         _a_),
      /*<<domain.ml:193:19>>*/ term_mutex =
        /*<<domain.ml:193:19>>*/ caml_call1(Stdlib_Mutex[1], 0),
      /*<<domain.ml:194:23>>*/ term_condition =
        /*<<domain.ml:194:23>>*/ caml_call1(Stdlib_Condition[1], 0),
      /*<<domain.ml:195:19>>*/ term_state = [0, 0];
    function body(param){
      /*<<domain.ml:198:4>>*/ a:
     {
       /*<<domain.ml:198:4>>*/ try{
        /*<<domain.ml:200:8>>*/ create_dls(0);
        /*<<domain.ml:127:4>>*/  /*<<domain.ml:127:4>>*/ caml_call2
        (Stdlib_List[18],
         function(param){
           /*<<domain.ml:128:6>>*/ var
           v = param[2],
           idx = param[1],
            /*<<domain.ml:129:17>>*/ st = maybe_grow(idx);
           /*<<domain.ml:129:35>>*/ caml_check_bound(st, idx)[1 + idx] = v;
           /*<<domain.ml:129:35>>*/ return 0;
          /*<<domain.ml:129:49>>*/ },
         pk);
        /*<<domain.ml:202:18>>*/  /*<<domain.ml:202:18>>*/ var
        res =  /*<<domain.ml:202:18>>*/ caml_call1(f, 0);
      }
      catch(ex$0){
       var ex = caml_wrap_exception(ex$0), result = [1, ex];
       break a;
      }
      var result = [0, res];
     }
      /*<<domain.ml:209:4>>*/ try{
       /*<<domain.ml:212:12>>*/ do_at_exit(0);
      var result$0 = result;
     }
     catch(ex){
       /*<<domain.ml:215:10>>*/ var
       ex$0 = caml_wrap_exception(ex),
        /*<<domain.ml:215:10>>*/ _b_ = 0 === result[0] ? [1, ex$0] : result,
       result$0 = _b_;
     }
      /*<<domain.ml:230:4>>*/  /*<<domain.ml:230:4>>*/ caml_call1
      (Stdlib_Mutex[2], term_mutex);
     return term_state[1]
             ?  /*<<domain.ml:236:8>>*/ caml_call1
               (Stdlib[2], cst_internal_error_Am_I_alread)
             : (term_state
                [1]
               = [0, result$0],
                /*<<domain.ml:197:2>>*/ caml_call1
                (Stdlib_Condition[4], term_condition));
     /*<<domain.ml:236:57>>*/ }
     /*<<domain.ml:240:2>>*/ return [0,
             /*<<domain.ml:240:13>>*/ runtime.caml_domain_spawn
             (body, term_mutex),
            term_mutex,
            term_condition,
            term_state];
    /*<<domain.ml:243:16>>*/ }
   function join(param){
    var
     term_state = param[4],
     term_condition = param[3],
     term_mutex = param[2];
     /*<<domain.ml:246:2>>*/  /*<<domain.ml:246:2>>*/ caml_call1
     (Stdlib_Mutex[2], term_mutex);
     /*<<domain.ml:248:4>>*/ for(;;){
     var match = term_state[1];
     if(match){
      var res = match[1];
       /*<<domain.ml:253:8>>*/  /*<<domain.ml:253:8>>*/ caml_call1
       (Stdlib_Mutex[4], term_mutex);
      if(0 === res[0]){var x = res[1];  /*<<domain.ml:257:12>>*/ return x;}
      var ex = res[1];
       /*<<domain.ml:258:16>>*/ throw  /*<<domain.ml:258:16>>*/ caml_maybe_attach_backtrace
             (ex, 1);
     }
      /*<<domain.ml:250:8>>*/  /*<<domain.ml:250:8>>*/ caml_call2
      (Stdlib_Condition[2], term_condition, term_mutex);
    }
   }
   var
    recommended_domain_count = runtime.caml_recommended_domain_count,
    Stdlib_Domain =
      [0,
       spawn,
       join,
       get_id,
       self,
       before_first_spawn,
       at_exit,
       cpu_relax,
       is_main_domain,
       recommended_domain_count,
       [0, new_key, get, set]];
   runtime.caml_register_global(8, Stdlib_Domain, "Stdlib__Domain");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: CamlinternalFormat
//# unitInfo: Requires: CamlinternalFormatBasics, Stdlib, Stdlib__Buffer, Stdlib__Bytes, Stdlib__Char, Stdlib__Int, Stdlib__String, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$43 = "",
    cst_and = " and ",
    cst_Li$3 = "%Li",
    cst_i$3 = "%i",
    cst_li$3 = "%li",
    cst_ni$3 = "%ni",
    cst_u$0 = "%u",
    cst$42 = "' '",
    cst$41 = "'#'",
    cst$39 = "'*'",
    cst$40 = "'+'",
    cst$44 = ", ",
    cst_0$3 = "0",
    cst_at_character_number = ": at character number ",
    cst$38 = "@[",
    cst$37 = "@{",
    cst_bad_input_format_type_mism =
      "bad input: format type mismatch between ",
    cst_bad_input_format_type_mism$0 =
      "bad input: format type mismatch between %S and %S",
    cst_camlinternalFormat_ml = "camlinternalFormat.ml",
    cst_invalid_format = "invalid format ",
    cst_precision$3 = "precision",
    caml_blit_string = runtime.caml_blit_string,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_format_float = runtime.caml_format_float,
    caml_format_int = runtime.caml_format_int,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_notequal = runtime.caml_notequal,
    caml_string_get = runtime.caml_string_get,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_string_unsafe_get = runtime.caml_string_unsafe_get,
    caml_trampoline = runtime.caml_trampoline,
    caml_trampoline_return = runtime.caml_trampoline_return,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$9 = "%{",
    cst$10 = "%}",
    cst$11 = "%(",
    cst$12 = "%)",
    cst$13 = "%?",
    cst$18 = cst$37,
    cst$19 = cst$38,
    cst$20 = cst$37,
    cst$21 = cst$38,
    cst$22 = cst$37,
    cst$23 = cst$38,
    cst$26 = cst$39,
    cst$24 = "'-'",
    cst$25 = cst$39,
    cst$27 = cst$40,
    cst$28 = cst$41,
    cst$29 = cst$42,
    cst$30 = cst$40,
    cst$31 = "'_'",
    sub_format = [0, 0, cst$43],
    formatting_lit = [0, "@;", 1, 0],
    cst$35 = cst$41,
    cst$32 = cst$40,
    cst$33 = cst$40,
    cst$34 = cst$42,
    cst$36 = cst$40,
    cst$17 = ".",
    cst$14 = "%!",
    cst$15 = cst$37,
    cst$16 = cst$38,
    cst$8 = "%%",
    cst$0 = "@]",
    cst$1 = "@}",
    cst$2 = "@?",
    cst$3 = "@\n",
    cst$4 = "@.",
    cst$5 = "@@",
    cst$6 = "@%",
    cst$7 = "@",
    cst = ".*",
    Assert_failure = global_data.Assert_failure,
    CamlinternalFormatBasics = global_data.CamlinternalFormatBasics,
    Stdlib = global_data.Stdlib,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Char = global_data.Stdlib__Char,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_Int = global_data.Stdlib__Int,
    _a_ = [0, 0, 0],
    cst_c = "%c",
    cst_s = "%s",
    cst_i = cst_i$3,
    cst_li = cst_li$3,
    cst_ni = cst_ni$3,
    cst_Li = cst_Li$3,
    cst_f = "%f",
    cst_B = "%B",
    cst_a = "%a",
    cst_t = "%t",
    cst_r = "%r",
    cst_r$0 = "%_r",
    cst_0c = "0c",
    _b_ = [0, cst_camlinternalFormat_ml, 850, 23],
    _c_ = [0, cst_camlinternalFormat_ml, 837, 26],
    _d_ = [0, cst_camlinternalFormat_ml, 847, 28],
    _e_ = [0, cst_camlinternalFormat_ml, 815, 21],
    _f_ = [0, cst_camlinternalFormat_ml, 819, 21],
    _g_ = [0, cst_camlinternalFormat_ml, 823, 19],
    _h_ = [0, cst_camlinternalFormat_ml, 827, 22],
    _i_ = [0, cst_camlinternalFormat_ml, 832, 30],
    _j_ = [0, cst_camlinternalFormat_ml, 851, 23],
    _k_ = [0, cst_camlinternalFormat_ml, 836, 26],
    _l_ = [0, cst_camlinternalFormat_ml, 846, 28],
    _m_ = [0, cst_camlinternalFormat_ml, 814, 21],
    _n_ = [0, cst_camlinternalFormat_ml, 818, 21],
    _o_ = [0, cst_camlinternalFormat_ml, 822, 19],
    _p_ = [0, cst_camlinternalFormat_ml, 826, 22],
    _q_ = [0, cst_camlinternalFormat_ml, 831, 30];
   function create_char_set(param){
     /*<<camlinternalFormat.ml:24:25>>*/ return  /*<<camlinternalFormat.ml:24:25>>*/ caml_call2
            (Stdlib_Bytes[1], 32, 0);
    /*<<camlinternalFormat.ml:24:45>>*/ }
   function add_in_char_set(char_set, c){
     /*<<camlinternalFormat.ml:28:2>>*/ var
     str_ind = c >>> 3 | 0,
     mask = 1 << (c & 7),
      /*<<camlinternalFormat.ml:31:30>>*/ _dt_ =
        /*<<camlinternalFormat.ml:31:30>>*/ runtime.caml_bytes_get
        (char_set, str_ind)
       | mask;
     /*<<camlinternalFormat.ml:30:2>>*/ return  /*<<camlinternalFormat.ml:30:2>>*/ caml_bytes_set
            (char_set,
             str_ind,
              /*<<camlinternalFormat.ml:31:4>>*/ caml_call1(Stdlib[29], _dt_));
    /*<<camlinternalFormat.ml:31:69>>*/ }
   function freeze_char_set(char_set){
     /*<<camlinternalFormat.ml:34:2>>*/ return  /*<<camlinternalFormat.ml:34:2>>*/ caml_call1
            (Stdlib_Bytes[6], char_set);
    /*<<camlinternalFormat.ml:34:26>>*/ }
   function rev_char_set(char_set){
     /*<<camlinternalFormat.ml:38:2>>*/ var
      /*<<camlinternalFormat.ml:38:18>>*/ char_set$0 = create_char_set(0),
     i = 0;
    for(;;){
      /*<<camlinternalFormat.ml:41:32>>*/  /*<<camlinternalFormat.ml:41:32>>*/ var
      _dr_ =
         /*<<camlinternalFormat.ml:41:32>>*/ caml_string_get(char_set, i)
        ^ 255;
      /*<<camlinternalFormat.ml:40:4>>*/  /*<<camlinternalFormat.ml:40:4>>*/ caml_bytes_set
      (char_set$0,
       i,
        /*<<camlinternalFormat.ml:41:6>>*/ caml_call1(Stdlib[29], _dr_));
      /*<<camlinternalFormat.ml:40:4>>*/  /*<<camlinternalFormat.ml:40:4>>*/ var
      _ds_ = i + 1 | 0;
     if(31 === i)
       /*<<camlinternalFormat.ml:43:2>>*/ return  /*<<camlinternalFormat.ml:43:2>>*/ caml_call1
              (Stdlib_Bytes[44], char_set$0);
     var i = _ds_;
    }
    /*<<camlinternalFormat.ml:43:34>>*/ }
   function is_in_char_set(char_set, c){
     /*<<camlinternalFormat.ml:47:2>>*/ var
     str_ind = c >>> 3 | 0,
     mask = 1 << (c & 7);
    return 0
            !==
             ( /*<<camlinternalFormat.ml:49:15>>*/ caml_string_get
              (char_set, str_ind)
             & mask)
            ? 1
            : 0;
    /*<<camlinternalFormat.ml:49:60>>*/ }
   function pad_of_pad_opt(pad_opt){
     /*<<camlinternalFormat.ml:62:29>>*/ if(! pad_opt)
      /*<<camlinternalFormat.ml:63:12>>*/ return 0;
    var width = pad_opt[1];
     /*<<camlinternalFormat.ml:64:18>>*/ return [0, 1, width];
    /*<<camlinternalFormat.ml:64:44>>*/ }
   function param_format_of_ignored_format(ign, fmt){
     /*<<camlinternalFormat.ml:76:15>>*/ if(typeof ign === "number")
     switch(ign){
       case 0:
         /*<<camlinternalFormat.ml:78:4>>*/ return [0, [0, fmt]];
       case 1:
         /*<<camlinternalFormat.ml:80:4>>*/ return [0, [1, fmt]];
       case 2:
         /*<<camlinternalFormat.ml:108:4>>*/ return [0, [19, fmt]];
       default:  /*<<camlinternalFormat.ml:114:4>>*/ return [0, [22, fmt]];
     }
    switch(ign[0]){
      case 0:
       var pad_opt = ign[1];
        /*<<camlinternalFormat.ml:82:4>>*/ return [0,
               [2, pad_of_pad_opt(pad_opt), fmt]];
      case 1:
       var pad_opt$0 = ign[1];
        /*<<camlinternalFormat.ml:84:4>>*/ return [0,
               [3, pad_of_pad_opt(pad_opt$0), fmt]];
      case 2:
       var pad_opt$1 = ign[2], iconv = ign[1];
        /*<<camlinternalFormat.ml:86:4>>*/ return [0,
               [4, iconv, pad_of_pad_opt(pad_opt$1), 0, fmt]];
      case 3:
       var pad_opt$2 = ign[2], iconv$0 = ign[1];
        /*<<camlinternalFormat.ml:88:4>>*/ return [0,
               [5, iconv$0, pad_of_pad_opt(pad_opt$2), 0, fmt]];
      case 4:
       var pad_opt$3 = ign[2], iconv$1 = ign[1];
        /*<<camlinternalFormat.ml:91:4>>*/ return [0,
               [6, iconv$1, pad_of_pad_opt(pad_opt$3), 0, fmt]];
      case 5:
       var pad_opt$4 = ign[2], iconv$2 = ign[1];
        /*<<camlinternalFormat.ml:94:4>>*/ return [0,
               [7, iconv$2, pad_of_pad_opt(pad_opt$4), 0, fmt]];
      case 6:
       var prec_opt = ign[2], pad_opt$5 = ign[1];
       if(prec_opt)
        var ndec = prec_opt[1], _dq_ = [0, ndec];
       else
        var _dq_ = 0;
        /*<<camlinternalFormat.ml:97:4>>*/ return [0,
               [8, _a_, pad_of_pad_opt(pad_opt$5), _dq_, fmt]];
      case 7:
       var pad_opt$6 = ign[1];
        /*<<camlinternalFormat.ml:101:4>>*/ return [0,
               [9, pad_of_pad_opt(pad_opt$6), fmt]];
      case 8:
       var fmtty = ign[2], pad_opt$7 = ign[1];
        /*<<camlinternalFormat.ml:103:4>>*/ return [0,
               [13, pad_opt$7, fmtty, fmt]];
      case 9:
       var fmtty$0 = ign[2], pad_opt$8 = ign[1];
        /*<<camlinternalFormat.ml:105:4>>*/ return [0,
               [14, pad_opt$8, fmtty$0, fmt]];
      case 10:
       var char_set = ign[2], width_opt = ign[1];
        /*<<camlinternalFormat.ml:110:4>>*/ return [0,
               [20, width_opt, char_set, fmt]];
      default:
       var counter = ign[1];
        /*<<camlinternalFormat.ml:112:4>>*/ return [0, [21, counter, fmt]];
    }
    /*<<camlinternalFormat.ml:114:41>>*/ }
   function default_float_precision(fconv){
     /*<<camlinternalFormat.ml:221:2>>*/ return 5 === fconv[2] ? 12 : -6;
    /*<<camlinternalFormat.ml:227:17>>*/ }
   function buffer_create(init_size){
     /*<<camlinternalFormat.ml:256:30>>*/ return [0,
            0,
             /*<<camlinternalFormat.ml:256:49>>*/ caml_create_bytes(init_size)];
    /*<<camlinternalFormat.ml:256:73>>*/ }
   function buffer_check_size(buf, overhead){
     /*<<camlinternalFormat.ml:260:2>>*/ var
     len = runtime.caml_ml_bytes_length(buf[2]),
     min_len = buf[1] + overhead | 0;
    if(len < min_len){
      /*<<camlinternalFormat.ml:263:18>>*/ var
       /*<<camlinternalFormat.ml:263:18>>*/ new_len =
         /*<<camlinternalFormat.ml:263:18>>*/ caml_call2
         (Stdlib_Int[11], len * 2 | 0, min_len),
       /*<<camlinternalFormat.ml:264:18>>*/ new_str =
         /*<<camlinternalFormat.ml:264:18>>*/ caml_create_bytes(new_len);
      /*<<camlinternalFormat.ml:265:4>>*/  /*<<camlinternalFormat.ml:265:4>>*/ caml_call5
      (Stdlib_Bytes[11], buf[2], 0, new_str, 0, len);
     buf[2] = new_str;
    }
    return;
    /*<<camlinternalFormat.ml:267:3>>*/ }
   function buffer_add_char(buf, c){
     /*<<camlinternalFormat.ml:271:2>>*/ buffer_check_size(buf, 1);
     /*<<camlinternalFormat.ml:272:2>>*/  /*<<camlinternalFormat.ml:272:2>>*/ caml_bytes_set
     (buf[2], buf[1], c);
    buf[1] = buf[1] + 1 | 0;
    return;
    /*<<camlinternalFormat.ml:273:24>>*/ }
   function buffer_add_string(buf, s){
     /*<<camlinternalFormat.ml:277:2>>*/ var
     str_len = caml_ml_string_length(s);
     /*<<camlinternalFormat.ml:278:2>>*/ buffer_check_size(buf, str_len);
     /*<<camlinternalFormat.ml:279:2>>*/  /*<<camlinternalFormat.ml:279:2>>*/ caml_call5
     (Stdlib_String[6], s, 0, buf[2], buf[1], str_len);
    buf[1] = buf[1] + str_len | 0;
    return;
    /*<<camlinternalFormat.ml:280:30>>*/ }
   function buffer_contents(buf){
     /*<<camlinternalFormat.ml:284:2>>*/ return caml_call3
            (Stdlib_Bytes[8], buf[2], 0, buf[1]);
    /*<<camlinternalFormat.ml:284:38>>*/ }
   function char_of_iconv(iconv){
     /*<<camlinternalFormat.ml:289:26>>*/ switch(iconv){
      case 6:
      case 7:
        /*<<camlinternalFormat.ml:291:38>>*/ return 120;
      case 8:
      case 9:
        /*<<camlinternalFormat.ml:291:62>>*/ return 88;
      case 10:
      case 11:
        /*<<camlinternalFormat.ml:292:14>>*/ return 111;
      case 12:
      case 15:
        /*<<camlinternalFormat.ml:292:38>>*/ return 117;
      case 0:
      case 1:
      case 2:
      case 13:
        /*<<camlinternalFormat.ml:290:40>>*/ return 100;
      default:  /*<<camlinternalFormat.ml:291:14>>*/ return 105;
    }
    /*<<camlinternalFormat.ml:292:41>>*/ }
   function char_of_fconv(opt, fconv){
     /*<<camlinternalFormat.ml:296:36>>*/ if(opt)
     var sth = opt[1], cF = sth;
    else
     var cF = 70;
    switch(fconv[2]){
      case 0:
        /*<<camlinternalFormat.ml:297:15>>*/ return 102;
      case 1:
        /*<<camlinternalFormat.ml:297:32>>*/ return 101;
      case 2:
        /*<<camlinternalFormat.ml:298:15>>*/ return 69;
      case 3:
        /*<<camlinternalFormat.ml:298:32>>*/ return 103;
      case 4:
        /*<<camlinternalFormat.ml:299:15>>*/ return 71;
      case 5:
        /*<<camlinternalFormat.ml:299:32>>*/ return cF;
      case 6:
        /*<<camlinternalFormat.ml:300:15>>*/ return 104;
      case 7:
        /*<<camlinternalFormat.ml:300:32>>*/ return 72;
      default:  /*<<camlinternalFormat.ml:301:16>>*/ return 70;
    }
    /*<<camlinternalFormat.ml:301:19>>*/ }
   function bprint_padty(buf, padty){
     /*<<camlinternalFormat.ml:374:29>>*/ switch(padty){
      case 0:
        /*<<camlinternalFormat.ml:375:13>>*/ return buffer_add_char(buf, 45);
      case 1:
        /*<<camlinternalFormat.ml:376:13>>*/ return;
      default:
        /*<<camlinternalFormat.ml:377:13>>*/ return buffer_add_char(buf, 48);
    }
    /*<<camlinternalFormat.ml:377:36>>*/ }
   function bprint_ignored_flag(buf, ign_flag){
     /*<<camlinternalFormat.ml:381:2>>*/ return ign_flag
            ? buffer_add_char(buf, 95)
            : ign_flag;
    /*<<camlinternalFormat.ml:381:42>>*/ }
   function bprint_pad_opt(buf, pad_opt){
     /*<<camlinternalFormat.ml:385:33>>*/ if(! pad_opt)
      /*<<camlinternalFormat.ml:386:12>>*/ return;
    var width = pad_opt[1];
     /*<<camlinternalFormat.ml:387:40>>*/ return buffer_add_string
            (buf,
              /*<<camlinternalFormat.ml:387:40>>*/ caml_call1
              (Stdlib_Int[12], width));
    /*<<camlinternalFormat.ml:387:61>>*/ }
   function bprint_padding(buf, pad){
     /*<<camlinternalFormat.ml:393:15>>*/ if(typeof pad === "number")
      /*<<camlinternalFormat.ml:394:18>>*/ return;
    if(0 === pad[0]){
     var n = pad[2], padty = pad[1];
      /*<<camlinternalFormat.ml:396:4>>*/ bprint_padty(buf, padty);
      /*<<camlinternalFormat.ml:397:26>>*/ return buffer_add_string
             (buf,
               /*<<camlinternalFormat.ml:397:26>>*/ caml_call1
               (Stdlib_Int[12], n));
    }
    var padty$0 = pad[1];
     /*<<camlinternalFormat.ml:399:4>>*/ bprint_padty(buf, padty$0);
     /*<<camlinternalFormat.ml:399:4>>*/ return buffer_add_char(buf, 42);
    /*<<camlinternalFormat.ml:400:27>>*/ }
   function bprint_precision(buf, prec){
     /*<<camlinternalFormat.ml:404:18>>*/ if(typeof prec !== "number"){
     var n = prec[1];
      /*<<camlinternalFormat.ml:407:4>>*/ buffer_add_char(buf, 46);
      /*<<camlinternalFormat.ml:408:26>>*/ return buffer_add_string
             (buf,
               /*<<camlinternalFormat.ml:408:26>>*/ caml_call1
               (Stdlib_Int[12], n));
    }
    if(prec)
      /*<<camlinternalFormat.ml:410:4>>*/ return buffer_add_string(buf, cst);
     /*<<camlinternalFormat.ml:405:20>>*/ return;
    /*<<camlinternalFormat.ml:410:30>>*/ }
   function bprint_iconv_flag(buf, iconv){
     /*<<camlinternalFormat.ml:415:34>>*/ switch(iconv){
      case 1:
      case 4:
        /*<<camlinternalFormat.ml:416:23>>*/ return buffer_add_char(buf, 43);
      case 2:
      case 5:
        /*<<camlinternalFormat.ml:417:23>>*/ return buffer_add_char(buf, 32);
      case 7:
      case 9:
      case 11:
      case 13:
      case 14:
      case 15:
        /*<<camlinternalFormat.ml:419:6>>*/ return buffer_add_char(buf, 35);
      default:  /*<<camlinternalFormat.ml:420:53>>*/ return;
    }
    /*<<camlinternalFormat.ml:420:55>>*/ }
   function bprint_altint_fmt(buf, ign_flag, iconv, pad, prec, c){
     /*<<camlinternalFormat.ml:433:2>>*/ buffer_add_char(buf, 37);
     /*<<camlinternalFormat.ml:434:2>>*/ bprint_ignored_flag(buf, ign_flag);
     /*<<camlinternalFormat.ml:435:2>>*/ bprint_iconv_flag(buf, iconv);
     /*<<camlinternalFormat.ml:436:2>>*/ bprint_padding(buf, pad);
     /*<<camlinternalFormat.ml:437:2>>*/ bprint_precision(buf, prec);
     /*<<camlinternalFormat.ml:438:2>>*/ buffer_add_char(buf, c);
     /*<<camlinternalFormat.ml:439:22>>*/ return buffer_add_char
            (buf, char_of_iconv(iconv));
    /*<<camlinternalFormat.ml:439:43>>*/ }
   function bprint_fconv_flag(buf, fconv){
     /*<<camlinternalFormat.ml:445:2>>*/ switch(fconv[1]){
      case 0: break;
      case 1:
        /*<<camlinternalFormat.ml:446:20>>*/ buffer_add_char(buf, 43); break;
      default:  /*<<camlinternalFormat.ml:447:20>>*/ buffer_add_char(buf, 32);
    }
    if(8 <= fconv[2])
      /*<<camlinternalFormat.ml:450:16>>*/ return buffer_add_char(buf, 35);
     /*<<camlinternalFormat.ml:452:35>>*/ return;
    /*<<camlinternalFormat.ml:452:37>>*/ }
   function string_of_formatting_lit(formatting_lit){
     /*<<camlinternalFormat.ml:465:46>>*/ if
     (typeof formatting_lit === "number")
     switch(formatting_lit){
       case 0:
         /*<<camlinternalFormat.ml:466:28>>*/ return cst$0;
       case 1:
         /*<<camlinternalFormat.ml:467:28>>*/ return cst$1;
       case 2:
         /*<<camlinternalFormat.ml:469:28>>*/ return cst$2;
       case 3:
         /*<<camlinternalFormat.ml:470:28>>*/ return cst$3;
       case 4:
         /*<<camlinternalFormat.ml:471:28>>*/ return cst$4;
       case 5:
         /*<<camlinternalFormat.ml:473:28>>*/ return cst$5;
       default:  /*<<camlinternalFormat.ml:474:28>>*/ return cst$6;
     }
    switch(formatting_lit[0]){
      case 0:
       var str = formatting_lit[1];
        /*<<camlinternalFormat.ml:468:28>>*/ return str;
      case 1:
       var str$0 = formatting_lit[1];
        /*<<camlinternalFormat.ml:472:28>>*/ return str$0;
      default:
        /*<<camlinternalFormat.ml:475:26>>*/ var
        c = formatting_lit[1],
         /*<<camlinternalFormat.ml:475:26>>*/ _dp_ =
           /*<<camlinternalFormat.ml:475:26>>*/ caml_call2
           (Stdlib_String[1], 1, c);
        /*<<camlinternalFormat.ml:475:26>>*/ return  /*<<camlinternalFormat.ml:475:26>>*/ caml_call2
               (Stdlib[28], cst$7, _dp_);
    }
    /*<<camlinternalFormat.ml:475:43>>*/ }
   function bprint_char_literal(buf, chr){
     /*<<camlinternalFormat.ml:480:34>>*/ return 37 === chr
            ? buffer_add_string(buf, cst$8)
            : buffer_add_char(buf, chr);
    /*<<camlinternalFormat.ml:482:32>>*/ }
   function bprint_string_literal(buf, str){
     /*<<camlinternalFormat.ml:486:2>>*/ var
     _dn_ = caml_ml_string_length(str) - 1 | 0,
      /*<<camlinternalFormat.ml:486:2>>*/ _dm_ = 0;
    if(_dn_ >= 0){
     var i = _dm_;
     for(;;){
       /*<<camlinternalFormat.ml:487:4>>*/ bprint_char_literal
       (buf,  /*<<camlinternalFormat.ml:487:28>>*/ caml_string_get(str, i));
       /*<<camlinternalFormat.ml:487:4>>*/  /*<<camlinternalFormat.ml:487:4>>*/ var
       _do_ = i + 1 | 0;
      if(_dn_ === i) break;
      var i = _do_;
     }
    }
    return;
    /*<<camlinternalFormat.ml:488:6>>*/ }
   function bprint_fmtty(buf, fmtty){
     /*<<camlinternalFormat.ml:496:17>>*/ var fmtty$0 = fmtty;
     /*<<camlinternalFormat.ml:496:17>>*/ for(;;){
     if(typeof fmtty$0 === "number")
       /*<<camlinternalFormat.ml:521:20>>*/ return;
     switch(fmtty$0[0]){
       case 0:
        var fmtty$1 = fmtty$0[1];
         /*<<camlinternalFormat.ml:497:25>>*/ buffer_add_string(buf, cst_c);
        var fmtty$0 = fmtty$1;
        break;
       case 1:
        var fmtty$2 = fmtty$0[1];
         /*<<camlinternalFormat.ml:498:25>>*/ buffer_add_string(buf, cst_s);
        var fmtty$0 = fmtty$2;
        break;
       case 2:
        var fmtty$3 = fmtty$0[1];
         /*<<camlinternalFormat.ml:499:25>>*/ buffer_add_string(buf, cst_i);
        var fmtty$0 = fmtty$3;
        break;
       case 3:
        var fmtty$4 = fmtty$0[1];
         /*<<camlinternalFormat.ml:500:25>>*/ buffer_add_string(buf, cst_li);
        var fmtty$0 = fmtty$4;
        break;
       case 4:
        var fmtty$5 = fmtty$0[1];
         /*<<camlinternalFormat.ml:501:25>>*/ buffer_add_string(buf, cst_ni);
        var fmtty$0 = fmtty$5;
        break;
       case 5:
        var fmtty$6 = fmtty$0[1];
         /*<<camlinternalFormat.ml:502:25>>*/ buffer_add_string(buf, cst_Li);
        var fmtty$0 = fmtty$6;
        break;
       case 6:
        var fmtty$7 = fmtty$0[1];
         /*<<camlinternalFormat.ml:503:25>>*/ buffer_add_string(buf, cst_f);
        var fmtty$0 = fmtty$7;
        break;
       case 7:
        var fmtty$8 = fmtty$0[1];
         /*<<camlinternalFormat.ml:504:25>>*/ buffer_add_string(buf, cst_B);
        var fmtty$0 = fmtty$8;
        break;
       case 8:
        var fmtty$9 = fmtty$0[2], sub_fmtty = fmtty$0[1];
         /*<<camlinternalFormat.ml:515:4>>*/ buffer_add_string(buf, cst$9);
         /*<<camlinternalFormat.ml:515:32>>*/ bprint_fmtty(buf, sub_fmtty);
         /*<<camlinternalFormat.ml:516:4>>*/ buffer_add_string(buf, cst$10);
        var fmtty$0 = fmtty$9;
        break;
       case 9:
        var fmtty$10 = fmtty$0[3], sub_fmtty$0 = fmtty$0[1];
         /*<<camlinternalFormat.ml:518:4>>*/ buffer_add_string(buf, cst$11);
         /*<<camlinternalFormat.ml:518:32>>*/ bprint_fmtty(buf, sub_fmtty$0);
         /*<<camlinternalFormat.ml:519:4>>*/ buffer_add_string(buf, cst$12);
        var fmtty$0 = fmtty$10;
        break;
       case 10:
        var fmtty$11 = fmtty$0[1];
         /*<<camlinternalFormat.ml:505:25>>*/ buffer_add_string(buf, cst_a);
        var fmtty$0 = fmtty$11;
        break;
       case 11:
        var fmtty$12 = fmtty$0[1];
         /*<<camlinternalFormat.ml:506:25>>*/ buffer_add_string(buf, cst_t);
        var fmtty$0 = fmtty$12;
        break;
       case 12:
        var fmtty$13 = fmtty$0[1];
         /*<<camlinternalFormat.ml:507:25>>*/ buffer_add_string(buf, cst$13);
        var fmtty$0 = fmtty$13;
        break;
       case 13:
        var fmtty$14 = fmtty$0[1];
         /*<<camlinternalFormat.ml:508:25>>*/ buffer_add_string(buf, cst_r);
        var fmtty$0 = fmtty$14;
        break;
       default:
        var fmtty$15 = fmtty$0[1];
         /*<<camlinternalFormat.ml:511:4>>*/ buffer_add_string(buf, cst_r$0);
        var fmtty$0 = fmtty$15;
     }
    }
    /*<<camlinternalFormat.ml:521:22>>*/ }
   function int_of_custom_arity(param){
     /*<<?>>*/ if(! param)  /*<<camlinternalFormat.ml:528:19>>*/ return 0;
    var x = param[1];
    return 1 + int_of_custom_arity(x) | 0;
   }
   function string_of_fmt(fmt){
     /*<<camlinternalFormat.ml:644:2>>*/  /*<<camlinternalFormat.ml:644:12>>*/ var
     buf = buffer_create(16);
    function fmtiter(fmt, ign_flag){
      /*<<camlinternalFormat.ml:535:22>>*/ var
      fmt$0 = fmt,
      ign_flag$0 = ign_flag;
      /*<<camlinternalFormat.ml:535:22>>*/ for(;;){
      if(typeof fmt$0 === "number")
        /*<<camlinternalFormat.ml:636:23>>*/ return;
      switch(fmt$0[0]){
        case 0:
         var rest = fmt$0[1];
          /*<<camlinternalFormat.ml:562:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:562:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:563:6>>*/ buffer_add_char(buf, 99);
         var fmt$0 = rest, ign_flag$0 = 0;
         break;
        case 1:
         var rest$0 = fmt$0[1];
          /*<<camlinternalFormat.ml:565:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:565:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:566:6>>*/ buffer_add_char(buf, 67);
         var fmt$0 = rest$0, ign_flag$0 = 0;
         break;
        case 2:
         var rest$1 = fmt$0[2], pad = fmt$0[1];
          /*<<camlinternalFormat.ml:537:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:537:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:538:6>>*/ bprint_padding(buf, pad);
          /*<<camlinternalFormat.ml:538:30>>*/ buffer_add_char(buf, 115);
         var fmt$0 = rest$1, ign_flag$0 = 0;
         break;
        case 3:
         var rest$2 = fmt$0[2], pad$0 = fmt$0[1];
          /*<<camlinternalFormat.ml:541:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:541:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:542:6>>*/ bprint_padding(buf, pad$0);
          /*<<camlinternalFormat.ml:542:30>>*/ buffer_add_char(buf, 83);
         var fmt$0 = rest$2, ign_flag$0 = 0;
         break;
        case 4:
         var
          rest$3 = fmt$0[4],
          prec = fmt$0[3],
          pad$1 = fmt$0[2],
          iconv = fmt$0[1];
          /*<<camlinternalFormat.ml:424:2>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:425:2>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:426:2>>*/ bprint_iconv_flag(buf, iconv);
          /*<<camlinternalFormat.ml:427:2>>*/ bprint_padding(buf, pad$1);
          /*<<camlinternalFormat.ml:428:2>>*/ bprint_precision(buf, prec);
          /*<<camlinternalFormat.ml:429:22>>*/ buffer_add_char
          (buf, char_of_iconv(iconv));
         var fmt$0 = rest$3, ign_flag$0 = 0;
         break;
        case 5:
         var
          rest$4 = fmt$0[4],
          prec$0 = fmt$0[3],
          pad$2 = fmt$0[2],
          iconv$0 = fmt$0[1];
          /*<<camlinternalFormat.ml:549:6>>*/ bprint_altint_fmt
          (buf, ign_flag$0, iconv$0, pad$2, prec$0, 108);
         var fmt$0 = rest$4, ign_flag$0 = 0;
         break;
        case 6:
         var
          rest$5 = fmt$0[4],
          prec$1 = fmt$0[3],
          pad$3 = fmt$0[2],
          iconv$1 = fmt$0[1];
          /*<<camlinternalFormat.ml:552:6>>*/ bprint_altint_fmt
          (buf, ign_flag$0, iconv$1, pad$3, prec$1, 110);
         var fmt$0 = rest$5, ign_flag$0 = 0;
         break;
        case 7:
         var
          rest$6 = fmt$0[4],
          prec$2 = fmt$0[3],
          pad$4 = fmt$0[2],
          iconv$2 = fmt$0[1];
          /*<<camlinternalFormat.ml:555:6>>*/ bprint_altint_fmt
          (buf, ign_flag$0, iconv$2, pad$4, prec$2, 76);
         var fmt$0 = rest$6, ign_flag$0 = 0;
         break;
        case 8:
         var
          rest$7 = fmt$0[4],
          prec$3 = fmt$0[3],
          pad$5 = fmt$0[2],
          fconv = fmt$0[1];
          /*<<camlinternalFormat.ml:456:2>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:457:2>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:458:2>>*/ bprint_fconv_flag(buf, fconv);
          /*<<camlinternalFormat.ml:459:2>>*/ bprint_padding(buf, pad$5);
          /*<<camlinternalFormat.ml:460:2>>*/ bprint_precision(buf, prec$3);
          /*<<camlinternalFormat.ml:461:22>>*/ buffer_add_char
          (buf, char_of_fconv(0, fconv));
         var fmt$0 = rest$7, ign_flag$0 = 0;
         break;
        case 9:
         var rest$8 = fmt$0[2], pad$6 = fmt$0[1];
          /*<<camlinternalFormat.ml:568:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:568:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:569:6>>*/ bprint_padding(buf, pad$6);
          /*<<camlinternalFormat.ml:569:30>>*/ buffer_add_char(buf, 66);
         var fmt$0 = rest$8, ign_flag$0 = 0;
         break;
        case 10:
         var rest$9 = fmt$0[1];
          /*<<camlinternalFormat.ml:587:6>>*/ buffer_add_string(buf, cst$14);
         var fmt$0 = rest$9;
         break;
        case 11:
         var rest$10 = fmt$0[2], str = fmt$0[1];
          /*<<camlinternalFormat.ml:591:6>>*/ bprint_string_literal(buf, str);
         var fmt$0 = rest$10;
         break;
        case 12:
         var rest$11 = fmt$0[2], chr = fmt$0[1];
          /*<<camlinternalFormat.ml:594:6>>*/ bprint_char_literal(buf, chr);
         var fmt$0 = rest$11;
         break;
        case 13:
         var rest$12 = fmt$0[3], fmtty = fmt$0[2], pad_opt = fmt$0[1];
          /*<<camlinternalFormat.ml:598:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:598:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:599:6>>*/ bprint_pad_opt(buf, pad_opt);
          /*<<camlinternalFormat.ml:599:34>>*/ buffer_add_char(buf, 123);
          /*<<camlinternalFormat.ml:600:6>>*/ bprint_fmtty(buf, fmtty);
          /*<<camlinternalFormat.ml:600:30>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:600:55>>*/ buffer_add_char(buf, 125);
         var fmt$0 = rest$12, ign_flag$0 = 0;
         break;
        case 14:
         var rest$13 = fmt$0[3], fmtty$0 = fmt$0[2], pad_opt$0 = fmt$0[1];
          /*<<camlinternalFormat.ml:603:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:603:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:604:6>>*/ bprint_pad_opt(buf, pad_opt$0);
          /*<<camlinternalFormat.ml:604:34>>*/ buffer_add_char(buf, 40);
          /*<<camlinternalFormat.ml:605:6>>*/ bprint_fmtty(buf, fmtty$0);
          /*<<camlinternalFormat.ml:605:30>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:605:55>>*/ buffer_add_char(buf, 41);
         var fmt$0 = rest$13, ign_flag$0 = 0;
         break;
        case 15:
         var rest$14 = fmt$0[1];
          /*<<camlinternalFormat.ml:572:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:572:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:573:6>>*/ buffer_add_char(buf, 97);
         var fmt$0 = rest$14, ign_flag$0 = 0;
         break;
        case 16:
         var rest$15 = fmt$0[1];
          /*<<camlinternalFormat.ml:575:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:575:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:576:6>>*/ buffer_add_char(buf, 116);
         var fmt$0 = rest$15, ign_flag$0 = 0;
         break;
        case 17:
         var rest$16 = fmt$0[2], fmting_lit = fmt$0[1];
          /*<<camlinternalFormat.ml:625:6>>*/ bprint_string_literal
          (buf, string_of_formatting_lit(fmting_lit));
         var fmt$0 = rest$16;
         break;
        case 18:
         var rest$17 = fmt$0[2], fmting_gen = fmt$0[1];
          /*<<camlinternalFormat.ml:628:6>>*/ if(0 === fmting_gen[0]){
          var str$0 = fmting_gen[1][2];
           /*<<camlinternalFormat.ml:630:8>>*/ buffer_add_string(buf, cst$15);
           /*<<camlinternalFormat.ml:630:36>>*/ buffer_add_string(buf, str$0);
         }
         else{
          var str$1 = fmting_gen[1][2];
           /*<<camlinternalFormat.ml:632:8>>*/ buffer_add_string(buf, cst$16);
           /*<<camlinternalFormat.ml:632:36>>*/ buffer_add_string(buf, str$1);
         }
         var fmt$0 = rest$17;
         break;
        case 19:
         var rest$18 = fmt$0[1];
          /*<<camlinternalFormat.ml:584:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:584:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:585:6>>*/ buffer_add_char(buf, 114);
         var fmt$0 = rest$18, ign_flag$0 = 0;
         break;
        case 20:
         var rest$19 = fmt$0[3], char_set = fmt$0[2], width_opt = fmt$0[1];
          /*<<camlinternalFormat.ml:609:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:609:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:610:6>>*/ bprint_pad_opt(buf, width_opt);
         var
          print_char =
            function(buf, i){
              /*<<camlinternalFormat.ml:358:25>>*/  /*<<camlinternalFormat.ml:358:31>>*/ var
              c =
                 /*<<camlinternalFormat.ml:358:31>>*/ caml_call1
                 (Stdlib[29], i);
             return 37 === c
                     ? (buffer_add_char(buf, 37), buffer_add_char(buf, 37))
                     : 64
                       === c
                       ? (buffer_add_char(buf, 37), buffer_add_char(buf, 64))
                       : buffer_add_char(buf, c);
             /*<<camlinternalFormat.ml:361:35>>*/ };
          /*<<camlinternalFormat.ml:363:2>>*/ buffer_add_char(buf, 91);
          /*<<camlinternalFormat.ml:365:7>>*/  /*<<camlinternalFormat.ml:365:7>>*/ var
          set =
            is_in_char_set(char_set, 0)
             ? (buffer_add_char(buf, 94), rev_char_set(char_set))
             : char_set;
         let set$0 = set;
         var
          is_alone =
            function(c){
              /*<<camlinternalFormat.ml:316:6>>*/ var
               /*<<camlinternalFormat.ml:316:50>>*/ after =
                 /*<<camlinternalFormat.ml:316:50>>*/ caml_call1
                 (Stdlib_Char[1], c + 1 | 0),
               /*<<camlinternalFormat.ml:316:32>>*/ before =
                 /*<<camlinternalFormat.ml:316:32>>*/ caml_call1
                 (Stdlib_Char[1], c - 1 | 0),
               /*<<camlinternalFormat.ml:317:6>>*/ _di_ =
                is_in_char_set(set$0, c);
              /*<<camlinternalFormat.ml:317:6>>*/ if(_di_)
               /*<<camlinternalFormat.ml:318:14>>*/ var
                /*<<camlinternalFormat.ml:318:14>>*/ _dj_ =
                 is_in_char_set(set$0, before),
                /*<<camlinternalFormat.ml:318:14>>*/ _dk_ =
                 _dj_ ? is_in_char_set(set$0, after) : _dj_,
               _dl_ = 1 - _dk_;
             else
              var _dl_ = _di_;
              /*<<camlinternalFormat.ml:318:43>>*/ return _dl_;
             /*<<camlinternalFormat.ml:318:68>>*/ };
          /*<<camlinternalFormat.ml:319:7>>*/ if(is_alone(93))
           /*<<camlinternalFormat.ml:319:25>>*/ buffer_add_char(buf, 93);
         a:
         b:
         {
          c:
          {
           d:
           {
            var i = 1;
             /*<<camlinternalFormat.ml:323:4>>*/ for(;;){
             if(i >= 256) break;
              /*<<camlinternalFormat.ml:324:9>>*/ if
              (is_in_char_set
                (set,
                  /*<<camlinternalFormat.ml:324:28>>*/ caml_call1
                  (Stdlib[29], i))){
               /*<<camlinternalFormat.ml:327:10>>*/  /*<<camlinternalFormat.ml:327:10>>*/ var
               switcher =
                  /*<<camlinternalFormat.ml:327:10>>*/ caml_call1
                  (Stdlib[29], i)
                 - 45
                 | 0;
              if(48 < switcher >>> 0){
               if(210 <= switcher) break d;
              }
              else if(46 < switcher - 1 >>> 0){
                /*<<camlinternalFormat.ml:329:19>>*/ var
                 /*<<camlinternalFormat.ml:329:19>>*/ i$2 = i + 1 | 0,
                i = i$2;
               continue;
              }
               /*<<camlinternalFormat.ml:330:11>>*/  /*<<camlinternalFormat.ml:330:11>>*/ var
               i$1 = i + 1 | 0;
               /*<<camlinternalFormat.ml:332:7>>*/ if
               (is_in_char_set
                 (set,
                   /*<<camlinternalFormat.ml:332:26>>*/ caml_call1
                   (Stdlib[29], i$1))){
                /*<<camlinternalFormat.ml:333:12>>*/  /*<<camlinternalFormat.ml:333:12>>*/ var
                switcher$0 =
                   /*<<camlinternalFormat.ml:333:12>>*/ caml_call1
                   (Stdlib[29], i$1)
                  - 45
                  | 0;
               if(48 < switcher$0 >>> 0){
                if(210 <= switcher$0) break c;
               }
               else if
                (46 < switcher$0 - 1 >>> 0
                 &&
                  !
                  is_in_char_set
                   (set,
                     /*<<camlinternalFormat.ml:337:47>>*/ caml_call1
                     (Stdlib[29], i$1 + 1 | 0))){
                 /*<<camlinternalFormat.ml:338:8>>*/ print_char
                 (buf, i$1 - 1 | 0);
                 /*<<camlinternalFormat.ml:338:8>>*/ var
                  /*<<camlinternalFormat.ml:338:8>>*/ i$5 = i$1 + 1 | 0,
                 i = i$5;
                continue;
               }
                /*<<camlinternalFormat.ml:340:19>>*/ if
                (is_in_char_set
                  (set,
                    /*<<camlinternalFormat.ml:340:39>>*/ caml_call1
                    (Stdlib[29], i$1 + 1 | 0))){
                 /*<<camlinternalFormat.ml:345:8>>*/ var
                  /*<<camlinternalFormat.ml:345:8>>*/ j = i$1 + 2 | 0,
                 i$3 = i$1 - 1 | 0,
                 j$0 = j;
                 /*<<camlinternalFormat.ml:351:4>>*/ for(;;){
                 if(256 === j$0) break;
                  /*<<camlinternalFormat.ml:351:22>>*/ if
                  (!
                   is_in_char_set
                    (set,
                      /*<<camlinternalFormat.ml:351:42>>*/ caml_call1
                      (Stdlib[29], j$0)))
                  break;
                  /*<<camlinternalFormat.ml:357:6>>*/ var
                   /*<<camlinternalFormat.ml:357:6>>*/ j$1 = j$0 + 1 | 0,
                  j$0 = j$1;
                }
                 /*<<camlinternalFormat.ml:352:6>>*/ print_char(buf, i$3);
                 /*<<camlinternalFormat.ml:353:6>>*/ print_char(buf, 45);
                 /*<<camlinternalFormat.ml:354:6>>*/ print_char
                 (buf, j$0 - 1 | 0);
                if(j$0 >= 256) break b;
                 /*<<camlinternalFormat.ml:355:22>>*/ var
                  /*<<camlinternalFormat.ml:355:22>>*/ i$7 = j$0 + 1 | 0,
                 i = i$7;
               }
               else{
                 /*<<camlinternalFormat.ml:341:8>>*/ print_char
                 (buf, i$1 - 1 | 0);
                 /*<<camlinternalFormat.ml:342:8>>*/ print_char(buf, i$1);
                 /*<<camlinternalFormat.ml:342:8>>*/ var
                  /*<<camlinternalFormat.ml:342:8>>*/ i$4 = i$1 + 2 | 0,
                 i = i$4;
               }
              }
              else{
                /*<<camlinternalFormat.ml:347:6>>*/ print_char
                (buf, i$1 - 1 | 0);
                /*<<camlinternalFormat.ml:347:6>>*/ var
                 /*<<camlinternalFormat.ml:347:6>>*/ i$6 = i$1 + 1 | 0,
                i = i$6;
              }
             }
             else
               /*<<camlinternalFormat.ml:325:11>>*/ var
                /*<<camlinternalFormat.ml:325:11>>*/ i$0 = i + 1 | 0,
               i = i$0;
            }
            break a;
           }
            /*<<camlinternalFormat.ml:328:16>>*/ print_char(buf, 255);
           break a;
          }
           /*<<camlinternalFormat.ml:335:8>>*/ print_char(buf, 254);
           /*<<camlinternalFormat.ml:335:8>>*/ print_char(buf, 255);
          break a;
         }
          /*<<camlinternalFormat.ml:321:7>>*/ if(is_alone(45))
           /*<<camlinternalFormat.ml:321:25>>*/ buffer_add_char(buf, 45);
          /*<<camlinternalFormat.ml:364:2>>*/ buffer_add_char(buf, 93);
         var fmt$0 = rest$19, ign_flag$0 = 0;
         break;
        case 21:
         var rest$20 = fmt$0[2], counter = fmt$0[1];
          /*<<camlinternalFormat.ml:613:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:613:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
         switch(counter){
           case 0:
            var _de_ = 108; break;
           case 1:
            var _de_ = 110; break;
           default: var _de_ = 78;
         }
          /*<<camlinternalFormat.ml:614:6>>*/ buffer_add_char(buf, _de_);
         var fmt$0 = rest$20, ign_flag$0 = 0;
         break;
        case 22:
         var rest$21 = fmt$0[1];
          /*<<camlinternalFormat.ml:617:6>>*/ buffer_add_char(buf, 37);
          /*<<camlinternalFormat.ml:617:31>>*/ bprint_ignored_flag
          (buf, ign_flag$0);
          /*<<camlinternalFormat.ml:618:6>>*/ bprint_string_literal
          (buf, cst_0c);
         var fmt$0 = rest$21, ign_flag$0 = 0;
         break;
        case 23:
         var
          rest$22 = fmt$0[2],
          ign = fmt$0[1],
          fmt$1 = param_format_of_ignored_format(ign, rest$22)[1],
          fmt$0 = fmt$1,
          ign_flag$0 = 1;
         break;
        default:
          /*<<camlinternalFormat.ml:578:20>>*/ var
          rest$23 = fmt$0[3],
          arity = fmt$0[1],
           /*<<camlinternalFormat.ml:578:20>>*/ _dg_ =
            int_of_custom_arity(arity),
          _df_ = 1;
         if(_dg_ >= 1){
          var i$8 = _df_;
          for(;;){
            /*<<camlinternalFormat.ml:579:8>>*/ buffer_add_char(buf, 37);
            /*<<camlinternalFormat.ml:579:33>>*/ bprint_ignored_flag
            (buf, ign_flag$0);
            /*<<camlinternalFormat.ml:580:8>>*/ buffer_add_char(buf, 63);
            /*<<camlinternalFormat.ml:580:8>>*/  /*<<camlinternalFormat.ml:580:8>>*/ var
            _dh_ = i$8 + 1 | 0;
           if(_dg_ === i$8) break;
           var i$8 = _dh_;
          }
         }
         var fmt$0 = rest$23, ign_flag$0 = 0;
      }
     }
     /*<<camlinternalFormat.ml:636:25>>*/ }
     /*<<camlinternalFormat.ml:638:5>>*/ fmtiter(fmt, 0);
     /*<<camlinternalFormat.ml:645:2>>*/ return buffer_contents(buf);
    /*<<camlinternalFormat.ml:646:21>>*/ }
   function symm(param){
     /*<<?>>*/ if(typeof param === "number")
      /*<<camlinternalFormat.ml:680:20>>*/ return 0;
    switch(param[0]){
      case 0:
       var rest = param[1];
        /*<<camlinternalFormat.ml:663:20>>*/ return [0, symm(rest)];
      case 1:
       var rest$0 = param[1];
        /*<<camlinternalFormat.ml:670:22>>*/ return [1, symm(rest$0)];
      case 2:
       var rest$1 = param[1];
        /*<<camlinternalFormat.ml:664:19>>*/ return [2, symm(rest$1)];
      case 3:
       var rest$2 = param[1];
        /*<<camlinternalFormat.ml:665:21>>*/ return [3, symm(rest$2)];
      case 4:
       var rest$3 = param[1];
        /*<<camlinternalFormat.ml:667:25>>*/ return [4, symm(rest$3)];
      case 5:
       var rest$4 = param[1];
        /*<<camlinternalFormat.ml:666:21>>*/ return [5, symm(rest$4)];
      case 6:
       var rest$5 = param[1];
        /*<<camlinternalFormat.ml:668:21>>*/ return [6, symm(rest$5)];
      case 7:
       var rest$6 = param[1];
        /*<<camlinternalFormat.ml:669:20>>*/ return [7, symm(rest$6)];
      case 8:
       var rest$7 = param[2], ty = param[1];
        /*<<camlinternalFormat.ml:677:4>>*/ return [8, ty, symm(rest$7)];
      case 9:
       var rest$8 = param[3], ty2 = param[2], ty1 = param[1];
        /*<<camlinternalFormat.ml:679:4>>*/ return [9, ty2, ty1, symm(rest$8)];
      case 10:
       var rest$9 = param[1];
        /*<<camlinternalFormat.ml:672:21>>*/ return [10, symm(rest$9)];
      case 11:
       var rest$10 = param[1];
        /*<<camlinternalFormat.ml:671:21>>*/ return [11, symm(rest$10)];
      case 12:
       var rest$11 = param[1];
        /*<<camlinternalFormat.ml:673:19>>*/ return [12, symm(rest$11)];
      case 13:
       var rest$12 = param[1];
        /*<<camlinternalFormat.ml:674:22>>*/ return [13, symm(rest$12)];
      default:
       var rest$13 = param[1];
        /*<<camlinternalFormat.ml:675:30>>*/ return [14, symm(rest$13)];
    }
   }
   function fmtty_rel_det(param){
     /*<<?>>*/ if(typeof param === "number")
      /*<<camlinternalFormat.ml:691:4>>*/ return [0,
             function(param){
               /*<<camlinternalFormat.ml:691:17>>*/ return;
              /*<<camlinternalFormat.ml:691:21>>*/ },
             function(param){
               /*<<camlinternalFormat.ml:692:17>>*/ return;
              /*<<camlinternalFormat.ml:692:21>>*/ },
             function(param){
               /*<<camlinternalFormat.ml:693:17>>*/ return;
              /*<<camlinternalFormat.ml:693:21>>*/ },
             function(param){
               /*<<camlinternalFormat.ml:694:17>>*/ return;
              /*<<camlinternalFormat.ml:694:21>>*/ }];
    switch(param[0]){
      case 0:
        /*<<camlinternalFormat.ml:696:25>>*/ var
        rest = param[1],
         /*<<camlinternalFormat.ml:696:25>>*/ match = fmtty_rel_det(rest),
        de = match[4],
        ed = match[3],
        af = match[2],
        fa = match[1];
        /*<<camlinternalFormat.ml:697:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:697:17>>*/ fa(0);
                 /*<<camlinternalFormat.ml:697:39>>*/ return;
                /*<<camlinternalFormat.ml:697:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:698:17>>*/ af(0);
                 /*<<camlinternalFormat.ml:698:39>>*/ return;
                /*<<camlinternalFormat.ml:698:43>>*/ },
               ed,
               de];
      case 1:
        /*<<camlinternalFormat.ml:701:25>>*/ var
        rest$0 = param[1],
         /*<<camlinternalFormat.ml:701:25>>*/ match$0 = fmtty_rel_det(rest$0),
        de$0 = match$0[4],
        ed$0 = match$0[3],
        af$0 = match$0[2],
        fa$0 = match$0[1];
        /*<<camlinternalFormat.ml:702:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:702:17>>*/ fa$0(0);
                 /*<<camlinternalFormat.ml:702:39>>*/ return;
                /*<<camlinternalFormat.ml:702:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:703:17>>*/ af$0(0);
                 /*<<camlinternalFormat.ml:703:39>>*/ return;
                /*<<camlinternalFormat.ml:703:43>>*/ },
               ed$0,
               de$0];
      case 2:
        /*<<camlinternalFormat.ml:706:25>>*/ var
        rest$1 = param[1],
         /*<<camlinternalFormat.ml:706:25>>*/ match$1 = fmtty_rel_det(rest$1),
        de$1 = match$1[4],
        ed$1 = match$1[3],
        af$1 = match$1[2],
        fa$1 = match$1[1];
        /*<<camlinternalFormat.ml:707:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:707:17>>*/ fa$1(0);
                 /*<<camlinternalFormat.ml:707:39>>*/ return;
                /*<<camlinternalFormat.ml:707:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:708:17>>*/ af$1(0);
                 /*<<camlinternalFormat.ml:708:39>>*/ return;
                /*<<camlinternalFormat.ml:708:43>>*/ },
               ed$1,
               de$1];
      case 3:
        /*<<camlinternalFormat.ml:711:25>>*/ var
        rest$2 = param[1],
         /*<<camlinternalFormat.ml:711:25>>*/ match$2 = fmtty_rel_det(rest$2),
        de$2 = match$2[4],
        ed$2 = match$2[3],
        af$2 = match$2[2],
        fa$2 = match$2[1];
        /*<<camlinternalFormat.ml:712:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:712:17>>*/ fa$2(0);
                 /*<<camlinternalFormat.ml:712:39>>*/ return;
                /*<<camlinternalFormat.ml:712:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:713:17>>*/ af$2(0);
                 /*<<camlinternalFormat.ml:713:39>>*/ return;
                /*<<camlinternalFormat.ml:713:43>>*/ },
               ed$2,
               de$2];
      case 4:
        /*<<camlinternalFormat.ml:721:25>>*/ var
        rest$3 = param[1],
         /*<<camlinternalFormat.ml:721:25>>*/ match$3 = fmtty_rel_det(rest$3),
        de$3 = match$3[4],
        ed$3 = match$3[3],
        af$3 = match$3[2],
        fa$3 = match$3[1];
        /*<<camlinternalFormat.ml:722:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:722:17>>*/ fa$3(0);
                 /*<<camlinternalFormat.ml:722:39>>*/ return;
                /*<<camlinternalFormat.ml:722:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:723:17>>*/ af$3(0);
                 /*<<camlinternalFormat.ml:723:39>>*/ return;
                /*<<camlinternalFormat.ml:723:43>>*/ },
               ed$3,
               de$3];
      case 5:
        /*<<camlinternalFormat.ml:716:25>>*/ var
        rest$4 = param[1],
         /*<<camlinternalFormat.ml:716:25>>*/ match$4 = fmtty_rel_det(rest$4),
        de$4 = match$4[4],
        ed$4 = match$4[3],
        af$4 = match$4[2],
        fa$4 = match$4[1];
        /*<<camlinternalFormat.ml:717:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:717:17>>*/ fa$4(0);
                 /*<<camlinternalFormat.ml:717:39>>*/ return;
                /*<<camlinternalFormat.ml:717:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:718:17>>*/ af$4(0);
                 /*<<camlinternalFormat.ml:718:39>>*/ return;
                /*<<camlinternalFormat.ml:718:43>>*/ },
               ed$4,
               de$4];
      case 6:
        /*<<camlinternalFormat.ml:726:25>>*/ var
        rest$5 = param[1],
         /*<<camlinternalFormat.ml:726:25>>*/ match$5 = fmtty_rel_det(rest$5),
        de$5 = match$5[4],
        ed$5 = match$5[3],
        af$5 = match$5[2],
        fa$5 = match$5[1];
        /*<<camlinternalFormat.ml:727:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:727:17>>*/ fa$5(0);
                 /*<<camlinternalFormat.ml:727:39>>*/ return;
                /*<<camlinternalFormat.ml:727:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:728:17>>*/ af$5(0);
                 /*<<camlinternalFormat.ml:728:39>>*/ return;
                /*<<camlinternalFormat.ml:728:43>>*/ },
               ed$5,
               de$5];
      case 7:
        /*<<camlinternalFormat.ml:731:25>>*/ var
        rest$6 = param[1],
         /*<<camlinternalFormat.ml:731:25>>*/ match$6 = fmtty_rel_det(rest$6),
        de$6 = match$6[4],
        ed$6 = match$6[3],
        af$6 = match$6[2],
        fa$6 = match$6[1];
        /*<<camlinternalFormat.ml:732:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:732:17>>*/ fa$6(0);
                 /*<<camlinternalFormat.ml:732:39>>*/ return;
                /*<<camlinternalFormat.ml:732:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:733:17>>*/ af$6(0);
                 /*<<camlinternalFormat.ml:733:39>>*/ return;
                /*<<camlinternalFormat.ml:733:43>>*/ },
               ed$6,
               de$6];
      case 8:
        /*<<camlinternalFormat.ml:764:25>>*/ var
        rest$7 = param[2],
         /*<<camlinternalFormat.ml:764:25>>*/ match$7 = fmtty_rel_det(rest$7),
        de$7 = match$7[4],
        ed$7 = match$7[3],
        af$7 = match$7[2],
        fa$7 = match$7[1];
        /*<<camlinternalFormat.ml:765:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:765:17>>*/ fa$7(0);
                 /*<<camlinternalFormat.ml:765:39>>*/ return;
                /*<<camlinternalFormat.ml:765:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:766:17>>*/ af$7(0);
                 /*<<camlinternalFormat.ml:766:39>>*/ return;
                /*<<camlinternalFormat.ml:766:43>>*/ },
               ed$7,
               de$7];
      case 9:
        /*<<camlinternalFormat.ml:769:25>>*/ var
        rest$8 = param[3],
        ty2 = param[2],
        ty1 = param[1],
         /*<<camlinternalFormat.ml:769:25>>*/ match$8 = fmtty_rel_det(rest$8),
        de$8 = match$8[4],
        ed$8 = match$8[3],
        af$8 = match$8[2],
        fa$8 = match$8[1],
         /*<<camlinternalFormat.ml:770:13>>*/ ty = trans(symm(ty1), ty2),
         /*<<camlinternalFormat.ml:771:25>>*/ match$9 = fmtty_rel_det(ty),
        jd = match$9[4],
        dj = match$9[3],
        ga = match$9[2],
        ag = match$9[1];
        /*<<camlinternalFormat.ml:772:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:772:17>>*/ fa$8(0);
                 /*<<camlinternalFormat.ml:772:50>>*/ ag(0);
                 /*<<camlinternalFormat.ml:772:61>>*/ return;
                /*<<camlinternalFormat.ml:772:65>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:773:17>>*/ ga(0);
                 /*<<camlinternalFormat.ml:773:50>>*/ af$8(0);
                 /*<<camlinternalFormat.ml:773:61>>*/ return;
                /*<<camlinternalFormat.ml:773:65>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:774:17>>*/ ed$8(0);
                 /*<<camlinternalFormat.ml:774:50>>*/ dj(0);
                 /*<<camlinternalFormat.ml:774:61>>*/ return;
                /*<<camlinternalFormat.ml:774:65>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:775:17>>*/ jd(0);
                 /*<<camlinternalFormat.ml:775:50>>*/ de$8(0);
                 /*<<camlinternalFormat.ml:775:61>>*/ return;
                /*<<camlinternalFormat.ml:775:65>>*/ }];
      case 10:
        /*<<camlinternalFormat.ml:742:25>>*/ var
        rest$9 = param[1],
         /*<<camlinternalFormat.ml:742:25>>*/ match$10 = fmtty_rel_det(rest$9),
        de$9 = match$10[4],
        ed$9 = match$10[3],
        af$9 = match$10[2],
        fa$9 = match$10[1];
        /*<<camlinternalFormat.ml:743:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:743:17>>*/ fa$9(0);
                 /*<<camlinternalFormat.ml:743:39>>*/ return;
                /*<<camlinternalFormat.ml:743:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:744:17>>*/ af$9(0);
                 /*<<camlinternalFormat.ml:744:39>>*/ return;
                /*<<camlinternalFormat.ml:744:43>>*/ },
               ed$9,
               de$9];
      case 11:
        /*<<camlinternalFormat.ml:737:25>>*/ var
        rest$10 = param[1],
         /*<<camlinternalFormat.ml:737:25>>*/ match$11 =
          fmtty_rel_det(rest$10),
        de$10 = match$11[4],
        ed$10 = match$11[3],
        af$10 = match$11[2],
        fa$10 = match$11[1];
        /*<<camlinternalFormat.ml:738:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:738:17>>*/ fa$10(0);
                 /*<<camlinternalFormat.ml:738:39>>*/ return;
                /*<<camlinternalFormat.ml:738:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:739:17>>*/ af$10(0);
                 /*<<camlinternalFormat.ml:739:39>>*/ return;
                /*<<camlinternalFormat.ml:739:43>>*/ },
               ed$10,
               de$10];
      case 12:
        /*<<camlinternalFormat.ml:747:25>>*/ var
        rest$11 = param[1],
         /*<<camlinternalFormat.ml:747:25>>*/ match$12 =
          fmtty_rel_det(rest$11),
        de$11 = match$12[4],
        ed$11 = match$12[3],
        af$11 = match$12[2],
        fa$11 = match$12[1];
        /*<<camlinternalFormat.ml:748:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:748:17>>*/ fa$11(0);
                 /*<<camlinternalFormat.ml:748:39>>*/ return;
                /*<<camlinternalFormat.ml:748:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:749:17>>*/ af$11(0);
                 /*<<camlinternalFormat.ml:749:39>>*/ return;
                /*<<camlinternalFormat.ml:749:43>>*/ },
               ed$11,
               de$11];
      case 13:
        /*<<camlinternalFormat.ml:752:25>>*/ var
        rest$12 = param[1],
         /*<<camlinternalFormat.ml:752:25>>*/ match$13 =
          fmtty_rel_det(rest$12),
        de$12 = match$13[4],
        ed$12 = match$13[3],
        af$12 = match$13[2],
        fa$12 = match$13[1];
        /*<<camlinternalFormat.ml:753:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:753:17>>*/ fa$12(0);
                 /*<<camlinternalFormat.ml:753:39>>*/ return;
                /*<<camlinternalFormat.ml:753:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:754:17>>*/ af$12(0);
                 /*<<camlinternalFormat.ml:754:39>>*/ return;
                /*<<camlinternalFormat.ml:754:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:755:17>>*/ ed$12(0);
                 /*<<camlinternalFormat.ml:755:39>>*/ return;
                /*<<camlinternalFormat.ml:755:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:756:17>>*/ de$12(0);
                 /*<<camlinternalFormat.ml:756:39>>*/ return;
                /*<<camlinternalFormat.ml:756:43>>*/ }];
      default:
        /*<<camlinternalFormat.ml:758:25>>*/ var
        rest$13 = param[1],
         /*<<camlinternalFormat.ml:758:25>>*/ match$14 =
          fmtty_rel_det(rest$13),
        de$13 = match$14[4],
        ed$13 = match$14[3],
        af$13 = match$14[2],
        fa$13 = match$14[1];
        /*<<camlinternalFormat.ml:759:4>>*/ return [0,
               function(param){
                 /*<<camlinternalFormat.ml:759:17>>*/ fa$13(0);
                 /*<<camlinternalFormat.ml:759:39>>*/ return;
                /*<<camlinternalFormat.ml:759:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:760:17>>*/ af$13(0);
                 /*<<camlinternalFormat.ml:760:39>>*/ return;
                /*<<camlinternalFormat.ml:760:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:761:17>>*/ ed$13(0);
                 /*<<camlinternalFormat.ml:761:39>>*/ return;
                /*<<camlinternalFormat.ml:761:43>>*/ },
               function(param){
                 /*<<camlinternalFormat.ml:762:17>>*/ de$13(0);
                 /*<<camlinternalFormat.ml:762:39>>*/ return;
                /*<<camlinternalFormat.ml:762:43>>*/ }];
    }
   }
   function trans(ty1, ty2){
     /*<<camlinternalFormat.ml:803:17>>*/ a:
    {
     b:
     {
      c:
      {
       d:
       {
        e:
        {
         f:
         {
          g:
          {
           if(typeof ty1 !== "number"){
            switch(ty1[0]){
              case 0:
               var rest1 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 0:
                   var rest2 = ty2[1];
                    /*<<camlinternalFormat.ml:804:36>>*/ return [0,
                           trans(rest1, rest2)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 1:
               var rest1$0 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 1:
                   var rest2$0 = ty2[1];
                    /*<<camlinternalFormat.ml:805:40>>*/ return [1,
                           trans(rest1$0, rest2$0)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 2:
               var rest1$1 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 2:
                   var rest2$1 = ty2[1];
                    /*<<camlinternalFormat.ml:807:34>>*/ return [2,
                           trans(rest1$1, rest2$1)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 3:
               var rest1$2 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 3:
                   var rest2$2 = ty2[1];
                    /*<<camlinternalFormat.ml:808:38>>*/ return [3,
                           trans(rest1$2, rest2$2)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 4:
               var rest1$3 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 4:
                   var rest2$3 = ty2[1];
                    /*<<camlinternalFormat.ml:810:46>>*/ return [4,
                           trans(rest1$3, rest2$3)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 5:
               var rest1$4 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 5:
                   var rest2$4 = ty2[1];
                    /*<<camlinternalFormat.ml:809:38>>*/ return [5,
                           trans(rest1$4, rest2$4)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 6:
               var rest1$5 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 6:
                   var rest2$5 = ty2[1];
                    /*<<camlinternalFormat.ml:811:38>>*/ return [6,
                           trans(rest1$5, rest2$5)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 7:
               var rest1$6 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 7:
                   var rest2$6 = ty2[1];
                    /*<<camlinternalFormat.ml:806:36>>*/ return [7,
                           trans(rest1$6, rest2$6)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 8:
               var rest1$7 = ty1[2], ty1$0 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 8:
                    /*<<camlinternalFormat.ml:835:34>>*/ var
                    rest2$7 = ty2[2],
                    ty2$0 = ty2[1],
                     /*<<camlinternalFormat.ml:835:34>>*/ _dd_ =
                      trans(rest1$7, rest2$7);
                    /*<<camlinternalFormat.ml:835:4>>*/ return [8,
                           trans(ty1$0, ty2$0),
                           _dd_];
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
                /*<<camlinternalFormat.ml:836:26>>*/ throw  /*<<camlinternalFormat.ml:836:26>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _k_], 1);
              case 9:
               var rest1$8 = ty1[3], ty12 = ty1[2], ty11 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 8:
                   break f;
                  case 9:
                    /*<<camlinternalFormat.ml:841:13>>*/ var
                    rest2$8 = ty2[3],
                    ty22 = ty2[2],
                    ty21 = ty2[1],
                     /*<<camlinternalFormat.ml:841:13>>*/ ty =
                      trans(symm(ty12), ty21),
                     /*<<camlinternalFormat.ml:842:23>>*/ match =
                      fmtty_rel_det(ty),
                    f4 = match[4],
                    f2 = match[2];
                    /*<<camlinternalFormat.ml:843:15>>*/ f2(0);
                    /*<<camlinternalFormat.ml:844:15>>*/ f4(0);
                    /*<<camlinternalFormat.ml:845:4>>*/ return [9,
                           ty11,
                           ty22,
                           trans(rest1$8, rest2$8)];
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
                /*<<camlinternalFormat.ml:846:28>>*/ throw  /*<<camlinternalFormat.ml:846:28>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _l_], 1);
              case 10:
               var rest1$9 = ty1[1];
               if(typeof ty2 !== "number" && 10 === ty2[0]){
                var rest2$9 = ty2[1];
                 /*<<camlinternalFormat.ml:813:38>>*/ return [10,
                        trans(rest1$9, rest2$9)];
               }
                /*<<camlinternalFormat.ml:814:21>>*/ throw  /*<<camlinternalFormat.ml:814:21>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _m_], 1);
              case 11:
               var rest1$10 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   var rest2$10 = ty2[1];
                    /*<<camlinternalFormat.ml:817:38>>*/ return [11,
                           trans(rest1$10, rest2$10)];
                }
                /*<<camlinternalFormat.ml:818:21>>*/ throw  /*<<camlinternalFormat.ml:818:21>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _n_], 1);
              case 12:
               var rest1$11 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   var rest2$11 = ty2[1];
                    /*<<camlinternalFormat.ml:821:34>>*/ return [12,
                           trans(rest1$11, rest2$11)];
                }
                /*<<camlinternalFormat.ml:822:19>>*/ throw  /*<<camlinternalFormat.ml:822:19>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _o_], 1);
              case 13:
               var rest1$12 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   var rest2$12 = ty2[1];
                    /*<<camlinternalFormat.ml:825:40>>*/ return [13,
                           trans(rest1$12, rest2$12)];
                }
                /*<<camlinternalFormat.ml:826:22>>*/ throw  /*<<camlinternalFormat.ml:826:22>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _p_], 1);
              default:
               var rest1$13 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   var rest2$13 = ty2[1];
                    /*<<camlinternalFormat.ml:830:4>>*/ return [14,
                           trans(rest1$13, rest2$13)];
                }
                /*<<camlinternalFormat.ml:831:30>>*/ throw  /*<<camlinternalFormat.ml:831:30>>*/ caml_maybe_attach_backtrace
                      ([0, Assert_failure, _q_], 1);
            }
             /*<<camlinternalFormat.ml:851:23>>*/ throw  /*<<camlinternalFormat.ml:851:23>>*/ caml_maybe_attach_backtrace
                   ([0, Assert_failure, _j_], 1);
           }
           if(typeof ty2 === "number")
             /*<<camlinternalFormat.ml:849:34>>*/ return 0;
           switch(ty2[0]){
             case 10:
              break a;
             case 11:
              break b;
             case 12:
              break c;
             case 13:
              break d;
             case 14:
              break e;
             case 8:
              break f;
             case 9: break;
             default:
               /*<<camlinternalFormat.ml:850:23>>*/ throw  /*<<camlinternalFormat.ml:850:23>>*/ caml_maybe_attach_backtrace
                     ([0, Assert_failure, _b_], 1);
           }
          }
           /*<<camlinternalFormat.ml:847:28>>*/ throw  /*<<camlinternalFormat.ml:847:28>>*/ caml_maybe_attach_backtrace
                 ([0, Assert_failure, _d_], 1);
         }
          /*<<camlinternalFormat.ml:837:26>>*/ throw  /*<<camlinternalFormat.ml:837:26>>*/ caml_maybe_attach_backtrace
                ([0, Assert_failure, _c_], 1);
        }
         /*<<camlinternalFormat.ml:832:30>>*/ throw  /*<<camlinternalFormat.ml:832:30>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _i_], 1);
       }
        /*<<camlinternalFormat.ml:827:22>>*/ throw  /*<<camlinternalFormat.ml:827:22>>*/ caml_maybe_attach_backtrace
              ([0, Assert_failure, _h_], 1);
      }
       /*<<camlinternalFormat.ml:823:19>>*/ throw  /*<<camlinternalFormat.ml:823:19>>*/ caml_maybe_attach_backtrace
             ([0, Assert_failure, _g_], 1);
     }
      /*<<camlinternalFormat.ml:819:21>>*/ throw  /*<<camlinternalFormat.ml:819:21>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _f_], 1);
    }
     /*<<camlinternalFormat.ml:815:21>>*/ throw  /*<<camlinternalFormat.ml:815:21>>*/ caml_maybe_attach_backtrace
           ([0, Assert_failure, _e_], 1);
    /*<<camlinternalFormat.ml:851:35>>*/ }
   function fmtty_of_fmt(fmtty){
     /*<<camlinternalFormat.ml:863:13>>*/ var fmtty$0 = fmtty;
     /*<<camlinternalFormat.ml:863:13>>*/ for(;;){
     if(typeof fmtty$0 === "number")
       /*<<camlinternalFormat.ml:916:34>>*/ return 0;
     switch(fmtty$0[0]){
       case 0:
        var rest = fmtty$0[1];
         /*<<camlinternalFormat.ml:890:34>>*/ return [0, fmtty_of_fmt(rest)];
       case 1:
        var rest$0 = fmtty$0[1];
         /*<<camlinternalFormat.ml:891:34>>*/ return [0, fmtty_of_fmt(rest$0)];
       case 2:
        var rest$1 = fmtty$0[2], pad = fmtty$0[1];
         /*<<camlinternalFormat.ml:865:31>>*/ return fmtty_of_padding_fmtty
                (pad, [1, fmtty_of_fmt(rest$1)]);
       case 3:
        var rest$2 = fmtty$0[2], pad$0 = fmtty$0[1];
         /*<<camlinternalFormat.ml:867:31>>*/ return fmtty_of_padding_fmtty
                (pad$0, [1, fmtty_of_fmt(rest$2)]);
       case 4:
         /*<<camlinternalFormat.ml:870:18>>*/ var
         rest$3 = fmtty$0[4],
         prec = fmtty$0[3],
         pad$1 = fmtty$0[2],
          /*<<camlinternalFormat.ml:870:18>>*/ ty_rest = fmtty_of_fmt(rest$3),
          /*<<camlinternalFormat.ml:871:18>>*/ prec_ty =
           fmtty_of_precision_fmtty(prec, [2, ty_rest]);
         /*<<camlinternalFormat.ml:872:4>>*/ return fmtty_of_padding_fmtty
                (pad$1, prec_ty);
       case 5:
         /*<<camlinternalFormat.ml:874:18>>*/ var
         rest$4 = fmtty$0[4],
         prec$0 = fmtty$0[3],
         pad$2 = fmtty$0[2],
          /*<<camlinternalFormat.ml:874:18>>*/ ty_rest$0 =
           fmtty_of_fmt(rest$4),
          /*<<camlinternalFormat.ml:875:18>>*/ prec_ty$0 =
           fmtty_of_precision_fmtty(prec$0, [3, ty_rest$0]);
         /*<<camlinternalFormat.ml:876:4>>*/ return fmtty_of_padding_fmtty
                (pad$2, prec_ty$0);
       case 6:
         /*<<camlinternalFormat.ml:878:18>>*/ var
         rest$5 = fmtty$0[4],
         prec$1 = fmtty$0[3],
         pad$3 = fmtty$0[2],
          /*<<camlinternalFormat.ml:878:18>>*/ ty_rest$1 =
           fmtty_of_fmt(rest$5),
          /*<<camlinternalFormat.ml:879:18>>*/ prec_ty$1 =
           fmtty_of_precision_fmtty(prec$1, [4, ty_rest$1]);
         /*<<camlinternalFormat.ml:880:4>>*/ return fmtty_of_padding_fmtty
                (pad$3, prec_ty$1);
       case 7:
         /*<<camlinternalFormat.ml:882:18>>*/ var
         rest$6 = fmtty$0[4],
         prec$2 = fmtty$0[3],
         pad$4 = fmtty$0[2],
          /*<<camlinternalFormat.ml:882:18>>*/ ty_rest$2 =
           fmtty_of_fmt(rest$6),
          /*<<camlinternalFormat.ml:883:18>>*/ prec_ty$2 =
           fmtty_of_precision_fmtty(prec$2, [5, ty_rest$2]);
         /*<<camlinternalFormat.ml:884:4>>*/ return fmtty_of_padding_fmtty
                (pad$4, prec_ty$2);
       case 8:
         /*<<camlinternalFormat.ml:886:18>>*/ var
         rest$7 = fmtty$0[4],
         prec$3 = fmtty$0[3],
         pad$5 = fmtty$0[2],
          /*<<camlinternalFormat.ml:886:18>>*/ ty_rest$3 =
           fmtty_of_fmt(rest$7),
          /*<<camlinternalFormat.ml:887:18>>*/ prec_ty$3 =
           fmtty_of_precision_fmtty(prec$3, [6, ty_rest$3]);
         /*<<camlinternalFormat.ml:888:4>>*/ return fmtty_of_padding_fmtty
                (pad$5, prec_ty$3);
       case 9:
        var rest$8 = fmtty$0[2], pad$6 = fmtty$0[1];
         /*<<camlinternalFormat.ml:893:33>>*/ return fmtty_of_padding_fmtty
                (pad$6, [7, fmtty_of_fmt(rest$8)]);
       case 10:
        var fmtty$1 = fmtty$0[1], fmtty$0 = fmtty$1; break;
       case 11:
        var fmtty$2 = fmtty$0[2], fmtty$0 = fmtty$2; break;
       case 12:
        var fmtty$3 = fmtty$0[2], fmtty$0 = fmtty$3; break;
       case 13:
        var rest$9 = fmtty$0[3], ty = fmtty$0[2];
         /*<<camlinternalFormat.ml:900:4>>*/ return [8,
                ty,
                fmtty_of_fmt(rest$9)];
       case 14:
        var rest$10 = fmtty$0[3], ty$0 = fmtty$0[2];
         /*<<camlinternalFormat.ml:902:4>>*/ return [9,
                ty$0,
                ty$0,
                fmtty_of_fmt(rest$10)];
       case 15:
        var rest$11 = fmtty$0[1];
         /*<<camlinternalFormat.ml:894:34>>*/ return [10,
                fmtty_of_fmt(rest$11)];
       case 16:
        var rest$12 = fmtty$0[1];
         /*<<camlinternalFormat.ml:895:34>>*/ return [11,
                fmtty_of_fmt(rest$12)];
       case 17:
        var fmtty$4 = fmtty$0[2], fmtty$0 = fmtty$4; break;
       case 18:
         /*<<camlinternalFormat.ml:914:54>>*/ var
         rest$13 = fmtty$0[2],
         formatting_gen = fmtty$0[1],
          /*<<camlinternalFormat.ml:914:54>>*/ _da_ = fmtty_of_fmt(rest$13);
        if(0 === formatting_gen[0])
         var fmt = formatting_gen[1][1], _db_ = fmtty_of_fmt(fmt);
        else
         var fmt$0 = formatting_gen[1][1], _db_ = fmtty_of_fmt(fmt$0);
         /*<<camlinternalFormat.ml:914:54>>*/ return  /*<<camlinternalFormat.ml:914:54>>*/ caml_call2
                (CamlinternalFormatBasics[1], _db_, _da_);
       case 19:
        var rest$14 = fmtty$0[1];
         /*<<camlinternalFormat.ml:897:34>>*/ return [13,
                fmtty_of_fmt(rest$14)];
       case 20:
        var rest$15 = fmtty$0[3];
         /*<<camlinternalFormat.ml:908:34>>*/ return [1,
                fmtty_of_fmt(rest$15)];
       case 21:
        var rest$16 = fmtty$0[2];
         /*<<camlinternalFormat.ml:909:34>>*/ return [2,
                fmtty_of_fmt(rest$16)];
       case 22:
        var rest$17 = fmtty$0[1];
         /*<<camlinternalFormat.ml:910:34>>*/ return [0,
                fmtty_of_fmt(rest$17)];
       case 23:
        var fmtty$5 = fmtty$0[2], ign = fmtty$0[1];
        if(typeof ign === "number")
         switch(ign){
           case 0:
            var fmtty$0 = fmtty$5; break;
           case 1:
            var fmtty$0 = fmtty$5; break;
           case 2:
             /*<<camlinternalFormat.ml:944:39>>*/ return [14,
                    fmtty_of_fmt(fmtty$5)];
           default: var fmtty$0 = fmtty$5;
         }
        else
         switch(ign[0]){
           case 0:
            var fmtty$0 = fmtty$5; break;
           case 1:
            var fmtty$0 = fmtty$5; break;
           case 2:
            var fmtty$0 = fmtty$5; break;
           case 3:
            var fmtty$0 = fmtty$5; break;
           case 4:
            var fmtty$0 = fmtty$5; break;
           case 5:
            var fmtty$0 = fmtty$5; break;
           case 6:
            var fmtty$0 = fmtty$5; break;
           case 7:
            var fmtty$0 = fmtty$5; break;
           case 8:
            var fmtty$0 = fmtty$5; break;
           case 9:
             /*<<camlinternalFormat.ml:943:58>>*/ var
             fmtty$6 = ign[2],
              /*<<camlinternalFormat.ml:943:58>>*/ _dc_ =
               fmtty_of_fmt(fmtty$5);
             /*<<camlinternalFormat.ml:943:58>>*/ return  /*<<camlinternalFormat.ml:943:58>>*/ caml_call2
                    (CamlinternalFormatBasics[1], fmtty$6, _dc_);
           case 10:
            var fmtty$0 = fmtty$5; break;
           default: var fmtty$0 = fmtty$5;
         }
        break;
       default:
        var rest$18 = fmtty$0[3], arity = fmtty$0[1];
         /*<<camlinternalFormat.ml:896:56>>*/ return fmtty_of_custom
                (arity, fmtty_of_fmt(rest$18));
     }
    }
    /*<<camlinternalFormat.ml:916:46>>*/ }
   function fmtty_of_custom(arity, fmtty){
     /*<<camlinternalFormat.ml:921:19>>*/ if(! arity)
      /*<<camlinternalFormat.ml:922:19>>*/ return fmtty;
    var arity$0 = arity[1];
     /*<<camlinternalFormat.ml:923:25>>*/ return [12,
            fmtty_of_custom(arity$0, fmtty)];
    /*<<camlinternalFormat.ml:923:61>>*/ }
   function fmtty_of_padding_fmtty(pad, fmtty){
     /*<<camlinternalFormat.ml:952:19>>*/ return typeof pad === "number"
            ? fmtty
            : 0 === pad[0] ? fmtty : [2, fmtty];
    /*<<camlinternalFormat.ml:955:35>>*/ }
   function fmtty_of_precision_fmtty(prec, fmtty){
     /*<<camlinternalFormat.ml:960:20>>*/ return typeof prec === "number"
            ? prec ? [2, fmtty] : fmtty
            : fmtty;
    /*<<camlinternalFormat.ml:963:37>>*/ }
    /*<<camlinternalFormat.ml:969:0>>*/ var
     /*<<camlinternalFormat.ml:969:0>>*/ Type_mismatch =
      [248, "CamlinternalFormat.Type_mismatch", runtime.caml_fresh_oo_id(0)],
    cst_d = "%d",
    cst_d$0 = "%+d",
    cst_d$1 = "% d",
    cst_i$0 = cst_i$3,
    cst_i$1 = "%+i",
    cst_i$2 = "% i",
    cst_x = "%x",
    cst_x$0 = "%#x",
    cst_X = "%X",
    cst_X$0 = "%#X",
    cst_o = "%o",
    cst_o$0 = "%#o",
    cst_u = cst_u$0,
    cst_Ld = "%Ld",
    cst_Ld$0 = "%+Ld",
    cst_Ld$1 = "% Ld",
    cst_Li$0 = cst_Li$3,
    cst_Li$1 = "%+Li",
    cst_Li$2 = "% Li",
    cst_Lx = "%Lx",
    cst_Lx$0 = "%#Lx",
    cst_LX = "%LX",
    cst_LX$0 = "%#LX",
    cst_Lo = "%Lo",
    cst_Lo$0 = "%#Lo",
    cst_Lu = "%Lu",
    cst_ld = "%ld",
    cst_ld$0 = "%+ld",
    cst_ld$1 = "% ld",
    cst_li$0 = cst_li$3,
    cst_li$1 = "%+li",
    cst_li$2 = "% li",
    cst_lx = "%lx",
    cst_lx$0 = "%#lx",
    cst_lX = "%lX",
    cst_lX$0 = "%#lX",
    cst_lo = "%lo",
    cst_lo$0 = "%#lo",
    cst_lu = "%lu",
    cst_nd = "%nd",
    cst_nd$0 = "%+nd",
    cst_nd$1 = "% nd",
    cst_ni$0 = cst_ni$3,
    cst_ni$1 = "%+ni",
    cst_ni$2 = "% ni",
    cst_nx = "%nx",
    cst_nx$0 = "%#nx",
    cst_nX = "%nX",
    cst_nX$0 = "%#nX",
    cst_no = "%no",
    cst_no$0 = "%#no",
    cst_nu = "%nu",
    _r_ = [0, 103],
    cst_neg_infinity = "neg_infinity",
    cst_infinity = "infinity",
    cst_nan = "nan",
    _s_ = [0, cst_camlinternalFormat_ml, 1558, 4],
    cst_Printf_bad_conversion = "Printf: bad conversion %[",
    _t_ = [0, cst_camlinternalFormat_ml, 1626, 39],
    _u_ = [0, cst_camlinternalFormat_ml, 1649, 31],
    _v_ = [0, cst_camlinternalFormat_ml, 1650, 31],
    cst_Printf_bad_conversion$0 = "Printf: bad conversion %_",
    _w_ = [0, cst_camlinternalFormat_ml, 1830, 8],
    _x_ = [0, 0, 4],
    _y_ =
      [0,
       [11, "invalid box description ", [3, 0, 0]],
       "invalid box description %S"],
    _z_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11, cst_at_character_number, [4, 0, 0, 0, [11, cst$44, [2, 0, 0]]]]]],
       "invalid format %S: at character number %d, %s"],
    cst_unexpected_end_of_format = "unexpected end of format",
    cst_non_zero_widths_are_unsupp =
      "non-zero widths are unsupported for %c conversions",
    _A_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, ", '", [0, [11, "' without ", [2, 0, 0]]]]]]]],
       "invalid format %S: at character number %d, '%c' without %s"],
    _B_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, cst$44, [2, 0, [11, " expected, read ", [1, 0]]]]]]]],
       "invalid format %S: at character number %d, %s expected, read %C"],
    _C_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, ", duplicate flag ", [1, 0]]]]]],
       "invalid format %S: at character number %d, duplicate flag %C"],
    cst_padding = "padding",
    _D_ = [0, 1, 0],
    cst_0 = cst_0$3,
    _E_ = [0, 0],
    cst_precision = cst_precision$3,
    _F_ = [1, 0],
    _G_ = [1, 1],
    cst_precision$0 = cst_precision$3,
    _H_ = [1, 1],
    cst_precision$1 = cst_precision$3,
    cst_0$0 = cst_0$3,
    _I_ = [1, 1],
    cst_0$1 = cst_0$3,
    cst_0$2 = "'0'",
    _J_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11, ', invalid conversion "', [12, 37, [0, [12, 34, 0]]]]]]]],
       'invalid format %S: at character number %d, invalid conversion "%%%c"'],
    _K_ = [0, 0],
    cst_padding$0 = "`padding'",
    _L_ = [0, 0],
    cst_precision$2 = "`precision'",
    _M_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11,
            ", flag ",
            [1,
             [11,
              " is only allowed after the '",
              [12, 37, [11, "', before padding and precision", 0]]]]]]]]],
       "invalid format %S: at character number %d, flag %C is only allowed after the '%%', before padding and precision"],
    _N_ = [0, [12, 64, 0]],
    _O_ = [0, "@ ", 1, 0],
    _P_ = [0, "@,", 0, 0],
    _Q_ = [2, 60],
    _R_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ": '",
          [12,
           37,
           [11,
            "' alone is not accepted in character sets, use ",
            [12,
             37,
             [12,
              37,
              [11, " instead at position ", [4, 0, 0, 0, [12, 46, 0]]]]]]]]]],
       "invalid format %S: '%%' alone is not accepted in character sets, use %%%% instead at position %d."],
    _S_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ": integer ",
          [4, 0, 0, 0, [11, " is greater than the limit ", [4, 0, 0, 0, 0]]]]]],
       "invalid format %S: integer %d is greater than the limit %d"],
    _T_ = [0, cst_camlinternalFormat_ml, 2837, 11],
    cst_digit = "digit",
    _U_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ': unclosed sub-format, expected "',
          [12, 37, [0, [11, '" at character number ', [4, 0, 0, 0, 0]]]]]]],
       'invalid format %S: unclosed sub-format, expected "%%%c" at character number %d'],
    cst_character = "character ')'",
    cst_character$0 = "character '}'",
    _V_ = [0, cst_camlinternalFormat_ml, 2899, 34],
    _W_ = [0, cst_camlinternalFormat_ml, 2935, 28],
    _X_ = [0, cst_camlinternalFormat_ml, 2957, 11],
    _Y_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11,
            cst$44,
            [2,
             0,
             [11,
              " is incompatible with '",
              [0, [11, "' in sub-format ", [3, 0, 0]]]]]]]]]],
       "invalid format %S: at character number %d, %s is incompatible with '%c' in sub-format %S"],
    _Z_ =
      [0,
       [11, cst_bad_input_format_type_mism, [3, 0, [11, cst_and, [3, 0, 0]]]],
       cst_bad_input_format_type_mism$0],
    ___ =
      [0,
       [11, cst_bad_input_format_type_mism, [3, 0, [11, cst_and, [3, 0, 0]]]],
       cst_bad_input_format_type_mism$0];
   function type_padding(pad, fmtty){
     /*<<camlinternalFormat.ml:977:17>>*/ if(typeof pad === "number")
      /*<<camlinternalFormat.ml:978:21>>*/ return [0, 0, fmtty];
    if(0 === pad[0]){
     var w = pad[2], padty = pad[1];
      /*<<camlinternalFormat.ml:979:33>>*/ return [0, [0, padty, w], fmtty];
    }
    if(typeof fmtty !== "number" && 2 === fmtty[0]){
     var rest = fmtty[1], padty$0 = pad[1];
      /*<<camlinternalFormat.ml:980:38>>*/ return [0, [1, padty$0], rest];
    }
     /*<<camlinternalFormat.ml:981:9>>*/ throw  /*<<camlinternalFormat.ml:981:9>>*/ caml_maybe_attach_backtrace
           (Type_mismatch, 1);
    /*<<camlinternalFormat.ml:981:28>>*/ }
   function type_padprec(pad, prec, fmtty){
     /*<<camlinternalFormat.ml:989:22>>*/  /*<<camlinternalFormat.ml:989:34>>*/ var
     match = type_padding(pad, fmtty);
    if(typeof prec !== "number"){
     var rest$1 = match[2], pad$2 = match[1], p = prec[1];
      /*<<camlinternalFormat.ml:993:4>>*/ return [0, pad$2, [0, p], rest$1];
    }
    if(! prec){
     var rest$0 = match[2], pad$1 = match[1];
      /*<<camlinternalFormat.ml:991:4>>*/ return [0, pad$1, 0, rest$0];
    }
    var match$0 = match[2];
    if(typeof match$0 !== "number" && 2 === match$0[0]){
     var rest = match$0[1], pad$0 = match[1];
      /*<<camlinternalFormat.ml:995:4>>*/ return [0, pad$0, 1, rest];
    }
     /*<<camlinternalFormat.ml:996:35>>*/ throw  /*<<camlinternalFormat.ml:996:35>>*/ caml_maybe_attach_backtrace
           (Type_mismatch, 1);
    /*<<camlinternalFormat.ml:996:54>>*/ }
   function type_format(fmt, fmtty){
     /*<<camlinternalFormat.ml:1008:19>>*/  /*<<camlinternalFormat.ml:1008:25>>*/ var
     _c$_ = type_format_gen(fmt, fmtty);
    if(typeof _c$_[2] !== "number")
      /*<<camlinternalFormat.ml:1010:9>>*/ throw  /*<<camlinternalFormat.ml:1010:9>>*/ caml_maybe_attach_backtrace
            (Type_mismatch, 1);
    var fmt$0 = _c$_[1];
     /*<<camlinternalFormat.ml:1009:42>>*/ return fmt$0;
    /*<<camlinternalFormat.ml:1010:28>>*/ }
   function type_format_gen(fmt, fmtty0){
     /*<<camlinternalFormat.ml:1018:19>>*/ if(typeof fmt === "number")
      /*<<camlinternalFormat.ml:1133:33>>*/ return [0, 0, fmtty0];
    switch(fmt[0]){
      case 0:
       if(typeof fmtty0 !== "number" && 0 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1020:39>>*/ var
         fmtty_rest = fmtty0[1],
         fmt_rest = fmt[1],
          /*<<camlinternalFormat.ml:1020:39>>*/ match =
           type_format_gen(fmt_rest, fmtty_rest),
         fmtty = match[2],
         fmt$0 = match[1];
         /*<<camlinternalFormat.ml:1021:4>>*/ return [0, [0, fmt$0], fmtty];
       }
       break;
      case 1:
       if(typeof fmtty0 !== "number" && 0 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1023:39>>*/ var
         fmtty_rest$0 = fmtty0[1],
         fmt_rest$0 = fmt[1],
          /*<<camlinternalFormat.ml:1023:39>>*/ match$0 =
           type_format_gen(fmt_rest$0, fmtty_rest$0),
         fmtty$0 = match$0[2],
         fmt$1 = match$0[1];
         /*<<camlinternalFormat.ml:1024:4>>*/ return [0, [1, fmt$1], fmtty$0];
       }
       break;
      case 2:
        /*<<camlinternalFormat.ml:1026:10>>*/ var
        fmt_rest$1 = fmt[2],
        pad = fmt[1],
         /*<<camlinternalFormat.ml:1026:10>>*/ match$1 =
          type_padding(pad, fmtty0),
        pad$0 = match$1[1],
        match$2 = match$1[2];
       if(typeof match$2 !== "number" && 1 === match$2[0]){
         /*<<camlinternalFormat.ml:1028:41>>*/ var
         fmtty_rest$1 = match$2[1],
          /*<<camlinternalFormat.ml:1028:41>>*/ match$3 =
           type_format_gen(fmt_rest$1, fmtty_rest$1),
         fmtty$1 = match$3[2],
         fmt$2 = match$3[1];
         /*<<camlinternalFormat.ml:1029:6>>*/ return [0,
                [2, pad$0, fmt$2],
                fmtty$1];
       }
        /*<<camlinternalFormat.ml:1030:34>>*/ throw  /*<<camlinternalFormat.ml:1030:34>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 3:
        /*<<camlinternalFormat.ml:1033:10>>*/ var
        fmt_rest$2 = fmt[2],
        pad$1 = fmt[1],
         /*<<camlinternalFormat.ml:1033:10>>*/ match$4 =
          type_padding(pad$1, fmtty0),
        pad$2 = match$4[1],
        match$5 = match$4[2];
       if(typeof match$5 !== "number" && 1 === match$5[0]){
         /*<<camlinternalFormat.ml:1035:41>>*/ var
         fmtty_rest$2 = match$5[1],
          /*<<camlinternalFormat.ml:1035:41>>*/ match$6 =
           type_format_gen(fmt_rest$2, fmtty_rest$2),
         fmtty$2 = match$6[2],
         fmt$3 = match$6[1];
         /*<<camlinternalFormat.ml:1036:6>>*/ return [0,
                [3, pad$2, fmt$3],
                fmtty$2];
       }
        /*<<camlinternalFormat.ml:1037:34>>*/ throw  /*<<camlinternalFormat.ml:1037:34>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 4:
        /*<<camlinternalFormat.ml:1040:10>>*/ var
        fmt_rest$3 = fmt[4],
        prec = fmt[3],
        pad$3 = fmt[2],
        iconv = fmt[1],
         /*<<camlinternalFormat.ml:1040:10>>*/ match$7 =
          type_padprec(pad$3, prec, fmtty0),
        pad$4 = match$7[1],
        match$8 = match$7[3];
       if(typeof match$8 !== "number" && 2 === match$8[0]){
         /*<<camlinternalFormat.ml:1042:41>>*/ var
         fmtty_rest$3 = match$8[1],
         prec$0 = match$7[2],
          /*<<camlinternalFormat.ml:1042:41>>*/ match$9 =
           type_format_gen(fmt_rest$3, fmtty_rest$3),
         fmtty$3 = match$9[2],
         fmt$4 = match$9[1];
         /*<<camlinternalFormat.ml:1043:6>>*/ return [0,
                [4, iconv, pad$4, prec$0, fmt$4],
                fmtty$3];
       }
        /*<<camlinternalFormat.ml:1044:37>>*/ throw  /*<<camlinternalFormat.ml:1044:37>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 5:
        /*<<camlinternalFormat.ml:1047:10>>*/ var
        fmt_rest$4 = fmt[4],
        prec$1 = fmt[3],
        pad$5 = fmt[2],
        iconv$0 = fmt[1],
         /*<<camlinternalFormat.ml:1047:10>>*/ match$10 =
          type_padprec(pad$5, prec$1, fmtty0),
        pad$6 = match$10[1],
        match$11 = match$10[3];
       if(typeof match$11 !== "number" && 3 === match$11[0]){
         /*<<camlinternalFormat.ml:1049:41>>*/ var
         fmtty_rest$4 = match$11[1],
         prec$2 = match$10[2],
          /*<<camlinternalFormat.ml:1049:41>>*/ match$12 =
           type_format_gen(fmt_rest$4, fmtty_rest$4),
         fmtty$4 = match$12[2],
         fmt$5 = match$12[1];
         /*<<camlinternalFormat.ml:1050:6>>*/ return [0,
                [5, iconv$0, pad$6, prec$2, fmt$5],
                fmtty$4];
       }
        /*<<camlinternalFormat.ml:1051:37>>*/ throw  /*<<camlinternalFormat.ml:1051:37>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 6:
        /*<<camlinternalFormat.ml:1054:10>>*/ var
        fmt_rest$5 = fmt[4],
        prec$3 = fmt[3],
        pad$7 = fmt[2],
        iconv$1 = fmt[1],
         /*<<camlinternalFormat.ml:1054:10>>*/ match$13 =
          type_padprec(pad$7, prec$3, fmtty0),
        pad$8 = match$13[1],
        match$14 = match$13[3];
       if(typeof match$14 !== "number" && 4 === match$14[0]){
         /*<<camlinternalFormat.ml:1056:41>>*/ var
         fmtty_rest$5 = match$14[1],
         prec$4 = match$13[2],
          /*<<camlinternalFormat.ml:1056:41>>*/ match$15 =
           type_format_gen(fmt_rest$5, fmtty_rest$5),
         fmtty$5 = match$15[2],
         fmt$6 = match$15[1];
         /*<<camlinternalFormat.ml:1057:6>>*/ return [0,
                [6, iconv$1, pad$8, prec$4, fmt$6],
                fmtty$5];
       }
        /*<<camlinternalFormat.ml:1058:37>>*/ throw  /*<<camlinternalFormat.ml:1058:37>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 7:
        /*<<camlinternalFormat.ml:1061:10>>*/ var
        fmt_rest$6 = fmt[4],
        prec$5 = fmt[3],
        pad$9 = fmt[2],
        iconv$2 = fmt[1],
         /*<<camlinternalFormat.ml:1061:10>>*/ match$16 =
          type_padprec(pad$9, prec$5, fmtty0),
        pad$10 = match$16[1],
        match$17 = match$16[3];
       if(typeof match$17 !== "number" && 5 === match$17[0]){
         /*<<camlinternalFormat.ml:1063:41>>*/ var
         fmtty_rest$6 = match$17[1],
         prec$6 = match$16[2],
          /*<<camlinternalFormat.ml:1063:41>>*/ match$18 =
           type_format_gen(fmt_rest$6, fmtty_rest$6),
         fmtty$6 = match$18[2],
         fmt$7 = match$18[1];
         /*<<camlinternalFormat.ml:1064:6>>*/ return [0,
                [7, iconv$2, pad$10, prec$6, fmt$7],
                fmtty$6];
       }
        /*<<camlinternalFormat.ml:1065:37>>*/ throw  /*<<camlinternalFormat.ml:1065:37>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 8:
        /*<<camlinternalFormat.ml:1068:10>>*/ var
        fmt_rest$7 = fmt[4],
        prec$7 = fmt[3],
        pad$11 = fmt[2],
        fconv = fmt[1],
         /*<<camlinternalFormat.ml:1068:10>>*/ match$19 =
          type_padprec(pad$11, prec$7, fmtty0),
        pad$12 = match$19[1],
        match$20 = match$19[3];
       if(typeof match$20 !== "number" && 6 === match$20[0]){
         /*<<camlinternalFormat.ml:1070:41>>*/ var
         fmtty_rest$7 = match$20[1],
         prec$8 = match$19[2],
          /*<<camlinternalFormat.ml:1070:41>>*/ match$21 =
           type_format_gen(fmt_rest$7, fmtty_rest$7),
         fmtty$7 = match$21[2],
         fmt$8 = match$21[1];
         /*<<camlinternalFormat.ml:1071:6>>*/ return [0,
                [8, fconv, pad$12, prec$8, fmt$8],
                fmtty$7];
       }
        /*<<camlinternalFormat.ml:1072:37>>*/ throw  /*<<camlinternalFormat.ml:1072:37>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 9:
        /*<<camlinternalFormat.ml:1075:10>>*/ var
        fmt_rest$8 = fmt[2],
        pad$13 = fmt[1],
         /*<<camlinternalFormat.ml:1075:10>>*/ match$22 =
          type_padding(pad$13, fmtty0),
        pad$14 = match$22[1],
        match$23 = match$22[2];
       if(typeof match$23 !== "number" && 7 === match$23[0]){
         /*<<camlinternalFormat.ml:1077:41>>*/ var
         fmtty_rest$8 = match$23[1],
          /*<<camlinternalFormat.ml:1077:41>>*/ match$24 =
           type_format_gen(fmt_rest$8, fmtty_rest$8),
         fmtty$8 = match$24[2],
         fmt$9 = match$24[1];
         /*<<camlinternalFormat.ml:1078:6>>*/ return [0,
                [9, pad$14, fmt$9],
                fmtty$8];
       }
        /*<<camlinternalFormat.ml:1079:34>>*/ throw  /*<<camlinternalFormat.ml:1079:34>>*/ caml_maybe_attach_backtrace
              (Type_mismatch, 1);
      case 10:
        /*<<camlinternalFormat.ml:1082:39>>*/ var
        fmt_rest$9 = fmt[1],
         /*<<camlinternalFormat.ml:1082:39>>*/ match$25 =
          type_format_gen(fmt_rest$9, fmtty0),
        fmtty$9 = match$25[2],
        fmt$10 = match$25[1];
        /*<<camlinternalFormat.ml:1083:4>>*/ return [0, [10, fmt$10], fmtty$9];
      case 11:
        /*<<camlinternalFormat.ml:1086:39>>*/ var
        fmt_rest$10 = fmt[2],
        str = fmt[1],
         /*<<camlinternalFormat.ml:1086:39>>*/ match$26 =
          type_format_gen(fmt_rest$10, fmtty0),
        fmtty$10 = match$26[2],
        fmt$11 = match$26[1];
        /*<<camlinternalFormat.ml:1087:4>>*/ return [0,
               [11, str, fmt$11],
               fmtty$10];
      case 12:
        /*<<camlinternalFormat.ml:1089:39>>*/ var
        fmt_rest$11 = fmt[2],
        chr = fmt[1],
         /*<<camlinternalFormat.ml:1089:39>>*/ match$27 =
          type_format_gen(fmt_rest$11, fmtty0),
        fmtty$11 = match$27[2],
        fmt$12 = match$27[1];
        /*<<camlinternalFormat.ml:1090:4>>*/ return [0,
               [12, chr, fmt$12],
               fmtty$11];
      case 13:
       if(typeof fmtty0 !== "number" && 8 === fmtty0[0]){
        var
         fmtty_rest$9 = fmtty0[2],
         sub_fmtty = fmtty0[1],
         fmt_rest$12 = fmt[3],
         sub_fmtty$0 = fmt[2],
         pad_opt = fmt[1];
         /*<<camlinternalFormat.ml:1094:7>>*/ if
         ( /*<<camlinternalFormat.ml:1094:7>>*/ caml_notequal
           ([0, sub_fmtty$0], [0, sub_fmtty]))
          /*<<camlinternalFormat.ml:1094:56>>*/ throw  /*<<camlinternalFormat.ml:1094:56>>*/ caml_maybe_attach_backtrace
                (Type_mismatch, 1);
         /*<<camlinternalFormat.ml:1095:39>>*/ var
          /*<<camlinternalFormat.ml:1095:39>>*/ match$28 =
           type_format_gen(fmt_rest$12, fmtty_rest$9),
         fmtty$12 = match$28[2],
         fmt$13 = match$28[1];
         /*<<camlinternalFormat.ml:1096:4>>*/ return [0,
                [13, pad_opt, sub_fmtty, fmt$13],
                fmtty$12];
       }
       break;
      case 14:
       if(typeof fmtty0 !== "number" && 9 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1099:42>>*/ var
         fmtty_rest$10 = fmtty0[3],
         sub_fmtty1 = fmtty0[1],
         fmt_rest$13 = fmt[3],
         sub_fmtty$1 = fmt[2],
         pad_opt$0 = fmt[1],
          /*<<camlinternalFormat.ml:1099:42>>*/ _c9_ =
           [0,
             /*<<camlinternalFormat.ml:1099:52>>*/ caml_call1
             (CamlinternalFormatBasics[2], sub_fmtty1)];
         /*<<camlinternalFormat.ml:1099:7>>*/ if
         ( /*<<camlinternalFormat.ml:1099:7>>*/ caml_notequal
           ([0,
              /*<<camlinternalFormat.ml:1099:17>>*/ caml_call1
              (CamlinternalFormatBasics[2], sub_fmtty$1)],
            _c9_))
          /*<<camlinternalFormat.ml:1100:6>>*/ throw  /*<<camlinternalFormat.ml:1100:6>>*/ caml_maybe_attach_backtrace
                (Type_mismatch, 1);
         /*<<camlinternalFormat.ml:1102:6>>*/ var
          /*<<camlinternalFormat.ml:1102:6>>*/ match$29 =
           type_format_gen
            (fmt_rest$13,
              /*<<camlinternalFormat.ml:1102:31>>*/ caml_call1
              (CamlinternalFormatBasics[2], fmtty_rest$10)),
         fmtty$13 = match$29[2],
         fmt$14 = match$29[1];
         /*<<camlinternalFormat.ml:1104:4>>*/ return [0,
                [14, pad_opt$0, sub_fmtty1, fmt$14],
                fmtty$13];
       }
       break;
      case 15:
       if(typeof fmtty0 !== "number" && 10 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1107:39>>*/ var
         fmtty_rest$11 = fmtty0[1],
         fmt_rest$14 = fmt[1],
          /*<<camlinternalFormat.ml:1107:39>>*/ match$30 =
           type_format_gen(fmt_rest$14, fmtty_rest$11),
         fmtty$14 = match$30[2],
         fmt$15 = match$30[1];
         /*<<camlinternalFormat.ml:1108:4>>*/ return [0,
                [15, fmt$15],
                fmtty$14];
       }
       break;
      case 16:
       if(typeof fmtty0 !== "number" && 11 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1110:39>>*/ var
         fmtty_rest$12 = fmtty0[1],
         fmt_rest$15 = fmt[1],
          /*<<camlinternalFormat.ml:1110:39>>*/ match$31 =
           type_format_gen(fmt_rest$15, fmtty_rest$12),
         fmtty$15 = match$31[2],
         fmt$16 = match$31[1];
         /*<<camlinternalFormat.ml:1111:4>>*/ return [0,
                [16, fmt$16],
                fmtty$15];
       }
       break;
      case 17:
        /*<<camlinternalFormat.ml:1115:39>>*/ var
        fmt_rest$16 = fmt[2],
        formatting_lit = fmt[1],
         /*<<camlinternalFormat.ml:1115:39>>*/ match$32 =
          type_format_gen(fmt_rest$16, fmtty0),
        fmtty$16 = match$32[2],
        fmt$17 = match$32[1];
        /*<<camlinternalFormat.ml:1116:4>>*/ return [0,
               [17, formatting_lit, fmt$17],
               fmtty$16];
      case 18:
       var fmt_rest$17 = fmt[2], formatting_gen = fmt[1];
       if(0 === formatting_gen[0]){
         /*<<camlinternalFormat.ml:1144:39>>*/ var
         match$36 = formatting_gen[1],
         str$0 = match$36[2],
         fmt1 = match$36[1],
          /*<<camlinternalFormat.ml:1144:39>>*/ match$37 =
           type_format_gen(fmt1, fmtty0),
         fmtty2 = match$37[2],
         fmt2 = match$37[1],
          /*<<camlinternalFormat.ml:1145:39>>*/ match$38 =
           type_format_gen(fmt_rest$17, fmtty2),
         fmtty3 = match$38[2],
         fmt3 = match$38[1];
         /*<<camlinternalFormat.ml:1146:4>>*/ return [0,
                [18, [0, [0, fmt2, str$0]], fmt3],
                fmtty3];
       }
        /*<<camlinternalFormat.ml:1148:39>>*/ var
        match$39 = formatting_gen[1],
        str$1 = match$39[2],
        fmt1$0 = match$39[1],
         /*<<camlinternalFormat.ml:1148:39>>*/ match$40 =
          type_format_gen(fmt1$0, fmtty0),
        fmtty2$0 = match$40[2],
        fmt2$0 = match$40[1],
         /*<<camlinternalFormat.ml:1149:39>>*/ match$41 =
          type_format_gen(fmt_rest$17, fmtty2$0),
        fmtty3$0 = match$41[2],
        fmt3$0 = match$41[1];
        /*<<camlinternalFormat.ml:1150:4>>*/ return [0,
               [18, [1, [0, fmt2$0, str$1]], fmt3$0],
               fmtty3$0];
      case 19:
       if(typeof fmtty0 !== "number" && 13 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1122:39>>*/ var
         fmtty_rest$13 = fmtty0[1],
         fmt_rest$18 = fmt[1],
          /*<<camlinternalFormat.ml:1122:39>>*/ match$33 =
           type_format_gen(fmt_rest$18, fmtty_rest$13),
         fmtty$17 = match$33[2],
         fmt$18 = match$33[1];
         /*<<camlinternalFormat.ml:1123:4>>*/ return [0,
                [19, fmt$18],
                fmtty$17];
       }
       break;
      case 20:
       if(typeof fmtty0 !== "number" && 1 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1125:39>>*/ var
         fmtty_rest$14 = fmtty0[1],
         fmt_rest$19 = fmt[3],
         char_set = fmt[2],
         width_opt = fmt[1],
          /*<<camlinternalFormat.ml:1125:39>>*/ match$34 =
           type_format_gen(fmt_rest$19, fmtty_rest$14),
         fmtty$18 = match$34[2],
         fmt$19 = match$34[1];
         /*<<camlinternalFormat.ml:1126:4>>*/ return [0,
                [20, width_opt, char_set, fmt$19],
                fmtty$18];
       }
       break;
      case 21:
       if(typeof fmtty0 !== "number" && 2 === fmtty0[0]){
         /*<<camlinternalFormat.ml:1128:39>>*/ var
         fmtty_rest$15 = fmtty0[1],
         fmt_rest$20 = fmt[2],
         counter = fmt[1],
          /*<<camlinternalFormat.ml:1128:39>>*/ match$35 =
           type_format_gen(fmt_rest$20, fmtty_rest$15),
         fmtty$19 = match$35[2],
         fmt$20 = match$35[1];
         /*<<camlinternalFormat.ml:1129:4>>*/ return [0,
                [21, counter, fmt$20],
                fmtty$19];
       }
       break;
      case 23:
       var rest = fmt[2], ign = fmt[1];
       if(typeof ign !== "number")
        switch(ign[0]){
          case 0:
            /*<<camlinternalFormat.ml:1161:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 1:
            /*<<camlinternalFormat.ml:1162:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 2:
            /*<<camlinternalFormat.ml:1163:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 3:
            /*<<camlinternalFormat.ml:1164:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 4:
            /*<<camlinternalFormat.ml:1165:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 5:
            /*<<camlinternalFormat.ml:1166:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 6:
            /*<<camlinternalFormat.ml:1167:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 7:
            /*<<camlinternalFormat.ml:1168:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          case 8:
           var sub_fmtty$2 = ign[2], pad_opt$1 = ign[1];
            /*<<camlinternalFormat.ml:1173:4>>*/ return type_ignored_param_one
                   ([8, pad_opt$1, sub_fmtty$2], rest, fmtty0);
          case 9:
            /*<<camlinternalFormat.ml:1176:6>>*/ var
            sub_fmtty$3 = ign[2],
            pad_opt$2 = ign[1],
             /*<<camlinternalFormat.ml:1176:6>>*/ _c__ =
              type_ignored_format_substituti(sub_fmtty$3, rest, fmtty0),
            match$43 = _c__[2],
            fmtty$21 = match$43[2],
            fmt$22 = match$43[1],
            sub_fmtty$4 = _c__[1];
            /*<<camlinternalFormat.ml:1177:4>>*/ return [0,
                   [23, [9, pad_opt$2, sub_fmtty$4], fmt$22],
                   fmtty$21];
          case 10:
            /*<<camlinternalFormat.ml:1169:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
          default:
            /*<<camlinternalFormat.ml:1170:42>>*/ return type_ignored_param_one
                   (ign, rest, fmtty0);
        }
       switch(ign){
         case 0:
           /*<<camlinternalFormat.ml:1159:42>>*/ return type_ignored_param_one
                  (ign, rest, fmtty0);
         case 1:
           /*<<camlinternalFormat.ml:1160:42>>*/ return type_ignored_param_one
                  (ign, rest, fmtty0);
         case 2:
          if(typeof fmtty0 !== "number" && 14 === fmtty0[0]){
            /*<<camlinternalFormat.ml:1183:41>>*/ var
            fmtty_rest$16 = fmtty0[1],
             /*<<camlinternalFormat.ml:1183:41>>*/ match$42 =
              type_format_gen(rest, fmtty_rest$16),
            fmtty$20 = match$42[2],
            fmt$21 = match$42[1];
            /*<<camlinternalFormat.ml:1184:6>>*/ return [0,
                   [23, 2, fmt$21],
                   fmtty$20];
          }
           /*<<camlinternalFormat.ml:1185:11>>*/ throw  /*<<camlinternalFormat.ml:1185:11>>*/ caml_maybe_attach_backtrace
                 (Type_mismatch, 1);
         default:
           /*<<camlinternalFormat.ml:1171:42>>*/ return type_ignored_param_one
                  (ign, rest, fmtty0);
       }
    }
     /*<<camlinternalFormat.ml:1135:9>>*/ throw  /*<<camlinternalFormat.ml:1135:9>>*/ caml_maybe_attach_backtrace
           (Type_mismatch, 1);
    /*<<camlinternalFormat.ml:1135:28>>*/ }
   function type_ignored_param_one(ign, fmt, fmtty){
     /*<<camlinternalFormat.ml:1194:2>>*/ var
      /*<<camlinternalFormat.ml:1194:37>>*/ match =
       type_format_gen(fmt, fmtty),
     fmtty$0 = match[2],
     fmt$0 = match[1];
     /*<<camlinternalFormat.ml:1195:2>>*/ return [0,
            [23, ign, fmt$0],
            fmtty$0];
    /*<<camlinternalFormat.ml:1195:51>>*/ }
   function type_ignored_format_substituti(sub_fmtty, fmt, fmtty){
     /*<<camlinternalFormat.ml:1202:27>>*/ if(typeof sub_fmtty === "number")
      /*<<camlinternalFormat.ml:1276:4>>*/ return [0,
             0,
             type_format_gen(fmt, fmtty)];
    switch(sub_fmtty[0]){
      case 0:
       if(typeof fmtty !== "number" && 0 === fmtty[0]){
         /*<<camlinternalFormat.ml:1205:6>>*/ var
         fmtty_rest = fmtty[1],
         sub_fmtty_rest = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1205:6>>*/ match =
           type_ignored_format_substituti(sub_fmtty_rest, fmt, fmtty_rest),
         fmt$0 = match[2],
         sub_fmtty_rest$0 = match[1];
         /*<<camlinternalFormat.ml:1206:4>>*/ return [0,
                [0, sub_fmtty_rest$0],
                fmt$0];
       }
       break;
      case 1:
       if(typeof fmtty !== "number" && 1 === fmtty[0]){
         /*<<camlinternalFormat.ml:1209:6>>*/ var
         fmtty_rest$0 = fmtty[1],
         sub_fmtty_rest$1 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1209:6>>*/ match$0 =
           type_ignored_format_substituti(sub_fmtty_rest$1, fmt, fmtty_rest$0),
         fmt$1 = match$0[2],
         sub_fmtty_rest$2 = match$0[1];
         /*<<camlinternalFormat.ml:1210:4>>*/ return [0,
                [1, sub_fmtty_rest$2],
                fmt$1];
       }
       break;
      case 2:
       if(typeof fmtty !== "number" && 2 === fmtty[0]){
         /*<<camlinternalFormat.ml:1213:6>>*/ var
         fmtty_rest$1 = fmtty[1],
         sub_fmtty_rest$3 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1213:6>>*/ match$1 =
           type_ignored_format_substituti(sub_fmtty_rest$3, fmt, fmtty_rest$1),
         fmt$2 = match$1[2],
         sub_fmtty_rest$4 = match$1[1];
         /*<<camlinternalFormat.ml:1214:4>>*/ return [0,
                [2, sub_fmtty_rest$4],
                fmt$2];
       }
       break;
      case 3:
       if(typeof fmtty !== "number" && 3 === fmtty[0]){
         /*<<camlinternalFormat.ml:1217:6>>*/ var
         fmtty_rest$2 = fmtty[1],
         sub_fmtty_rest$5 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1217:6>>*/ match$2 =
           type_ignored_format_substituti(sub_fmtty_rest$5, fmt, fmtty_rest$2),
         fmt$3 = match$2[2],
         sub_fmtty_rest$6 = match$2[1];
         /*<<camlinternalFormat.ml:1218:4>>*/ return [0,
                [3, sub_fmtty_rest$6],
                fmt$3];
       }
       break;
      case 4:
       if(typeof fmtty !== "number" && 4 === fmtty[0]){
         /*<<camlinternalFormat.ml:1221:6>>*/ var
         fmtty_rest$3 = fmtty[1],
         sub_fmtty_rest$7 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1221:6>>*/ match$3 =
           type_ignored_format_substituti(sub_fmtty_rest$7, fmt, fmtty_rest$3),
         fmt$4 = match$3[2],
         sub_fmtty_rest$8 = match$3[1];
         /*<<camlinternalFormat.ml:1222:4>>*/ return [0,
                [4, sub_fmtty_rest$8],
                fmt$4];
       }
       break;
      case 5:
       if(typeof fmtty !== "number" && 5 === fmtty[0]){
         /*<<camlinternalFormat.ml:1225:6>>*/ var
         fmtty_rest$4 = fmtty[1],
         sub_fmtty_rest$9 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1225:6>>*/ match$4 =
           type_ignored_format_substituti(sub_fmtty_rest$9, fmt, fmtty_rest$4),
         fmt$5 = match$4[2],
         sub_fmtty_rest$10 = match$4[1];
         /*<<camlinternalFormat.ml:1226:4>>*/ return [0,
                [5, sub_fmtty_rest$10],
                fmt$5];
       }
       break;
      case 6:
       if(typeof fmtty !== "number" && 6 === fmtty[0]){
         /*<<camlinternalFormat.ml:1229:6>>*/ var
         fmtty_rest$5 = fmtty[1],
         sub_fmtty_rest$11 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1229:6>>*/ match$5 =
           type_ignored_format_substituti
            (sub_fmtty_rest$11, fmt, fmtty_rest$5),
         fmt$6 = match$5[2],
         sub_fmtty_rest$12 = match$5[1];
         /*<<camlinternalFormat.ml:1230:4>>*/ return [0,
                [6, sub_fmtty_rest$12],
                fmt$6];
       }
       break;
      case 7:
       if(typeof fmtty !== "number" && 7 === fmtty[0]){
         /*<<camlinternalFormat.ml:1233:6>>*/ var
         fmtty_rest$6 = fmtty[1],
         sub_fmtty_rest$13 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1233:6>>*/ match$6 =
           type_ignored_format_substituti
            (sub_fmtty_rest$13, fmt, fmtty_rest$6),
         fmt$7 = match$6[2],
         sub_fmtty_rest$14 = match$6[1];
         /*<<camlinternalFormat.ml:1234:4>>*/ return [0,
                [7, sub_fmtty_rest$14],
                fmt$7];
       }
       break;
      case 8:
       if(typeof fmtty !== "number" && 8 === fmtty[0]){
        var
         fmtty_rest$7 = fmtty[2],
         sub2_fmtty = fmtty[1],
         sub_fmtty_rest$15 = sub_fmtty[2],
         sub2_fmtty$0 = sub_fmtty[1];
         /*<<camlinternalFormat.ml:1254:7>>*/ if
         ( /*<<camlinternalFormat.ml:1254:7>>*/ caml_notequal
           ([0, sub2_fmtty$0], [0, sub2_fmtty]))
          /*<<camlinternalFormat.ml:1254:58>>*/ throw  /*<<camlinternalFormat.ml:1254:58>>*/ caml_maybe_attach_backtrace
                (Type_mismatch, 1);
         /*<<camlinternalFormat.ml:1256:6>>*/ var
          /*<<camlinternalFormat.ml:1256:6>>*/ match$7 =
           type_ignored_format_substituti
            (sub_fmtty_rest$15, fmt, fmtty_rest$7),
         fmt$8 = match$7[2],
         sub_fmtty_rest$16 = match$7[1];
         /*<<camlinternalFormat.ml:1257:4>>*/ return [0,
                [8, sub2_fmtty, sub_fmtty_rest$16],
                fmt$8];
       }
       break;
      case 9:
       if(typeof fmtty !== "number" && 9 === fmtty[0]){
         /*<<camlinternalFormat.ml:1261:43>>*/ var
         fmtty_rest$8 = fmtty[3],
         sub2_fmtty$1 = fmtty[2],
         sub1_fmtty = fmtty[1],
         sub_fmtty_rest$17 = sub_fmtty[3],
         sub2_fmtty$2 = sub_fmtty[2],
         sub1_fmtty$0 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1261:43>>*/ _c7_ =
           [0,
             /*<<camlinternalFormat.ml:1261:53>>*/ caml_call1
             (CamlinternalFormatBasics[2], sub1_fmtty)];
         /*<<camlinternalFormat.ml:1261:7>>*/ if
         ( /*<<camlinternalFormat.ml:1261:7>>*/ caml_notequal
           ([0,
              /*<<camlinternalFormat.ml:1261:17>>*/ caml_call1
              (CamlinternalFormatBasics[2], sub1_fmtty$0)],
            _c7_))
          /*<<camlinternalFormat.ml:1262:9>>*/ throw  /*<<camlinternalFormat.ml:1262:9>>*/ caml_maybe_attach_backtrace
                (Type_mismatch, 1);
         /*<<camlinternalFormat.ml:1263:43>>*/  /*<<camlinternalFormat.ml:1263:43>>*/ var
         _c8_ =
           [0,
             /*<<camlinternalFormat.ml:1263:53>>*/ caml_call1
             (CamlinternalFormatBasics[2], sub2_fmtty$1)];
         /*<<camlinternalFormat.ml:1263:7>>*/ if
         ( /*<<camlinternalFormat.ml:1263:7>>*/ caml_notequal
           ([0,
              /*<<camlinternalFormat.ml:1263:17>>*/ caml_call1
              (CamlinternalFormatBasics[2], sub2_fmtty$2)],
            _c8_))
          /*<<camlinternalFormat.ml:1264:9>>*/ throw  /*<<camlinternalFormat.ml:1264:9>>*/ caml_maybe_attach_backtrace
                (Type_mismatch, 1);
         /*<<camlinternalFormat.ml:1265:21>>*/ var
          /*<<camlinternalFormat.ml:1265:21>>*/ sub_fmtty$0 =
           trans(symm(sub1_fmtty), sub2_fmtty$1),
          /*<<camlinternalFormat.ml:1266:23>>*/ match$8 =
           fmtty_rel_det(sub_fmtty$0),
         f4 = match$8[4],
         f2 = match$8[2];
         /*<<camlinternalFormat.ml:1267:15>>*/ f2(0);
         /*<<camlinternalFormat.ml:1268:15>>*/ f4(0);
         /*<<camlinternalFormat.ml:1270:6>>*/ var
          /*<<camlinternalFormat.ml:1270:6>>*/ match$9 =
           type_ignored_format_substituti
            ( /*<<camlinternalFormat.ml:1270:39>>*/ caml_call1
              (CamlinternalFormatBasics[2], sub_fmtty_rest$17),
             fmt,
             fmtty_rest$8),
         fmt$9 = match$9[2],
         sub_fmtty_rest$18 = match$9[1];
         /*<<camlinternalFormat.ml:1272:4>>*/ return [0,
                [9, sub1_fmtty, sub2_fmtty$1, symm(sub_fmtty_rest$18)],
                fmt$9];
       }
       break;
      case 10:
       if(typeof fmtty !== "number" && 10 === fmtty[0]){
         /*<<camlinternalFormat.ml:1237:6>>*/ var
         fmtty_rest$9 = fmtty[1],
         sub_fmtty_rest$19 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1237:6>>*/ match$10 =
           type_ignored_format_substituti
            (sub_fmtty_rest$19, fmt, fmtty_rest$9),
         fmt$10 = match$10[2],
         sub_fmtty_rest$20 = match$10[1];
         /*<<camlinternalFormat.ml:1238:4>>*/ return [0,
                [10, sub_fmtty_rest$20],
                fmt$10];
       }
       break;
      case 11:
       if(typeof fmtty !== "number" && 11 === fmtty[0]){
         /*<<camlinternalFormat.ml:1241:6>>*/ var
         fmtty_rest$10 = fmtty[1],
         sub_fmtty_rest$21 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1241:6>>*/ match$11 =
           type_ignored_format_substituti
            (sub_fmtty_rest$21, fmt, fmtty_rest$10),
         fmt$11 = match$11[2],
         sub_fmtty_rest$22 = match$11[1];
         /*<<camlinternalFormat.ml:1242:4>>*/ return [0,
                [11, sub_fmtty_rest$22],
                fmt$11];
       }
       break;
      case 13:
       if(typeof fmtty !== "number" && 13 === fmtty[0]){
         /*<<camlinternalFormat.ml:1245:6>>*/ var
         fmtty_rest$11 = fmtty[1],
         sub_fmtty_rest$23 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1245:6>>*/ match$12 =
           type_ignored_format_substituti
            (sub_fmtty_rest$23, fmt, fmtty_rest$11),
         fmt$12 = match$12[2],
         sub_fmtty_rest$24 = match$12[1];
         /*<<camlinternalFormat.ml:1246:4>>*/ return [0,
                [13, sub_fmtty_rest$24],
                fmt$12];
       }
       break;
      case 14:
       if(typeof fmtty !== "number" && 14 === fmtty[0]){
         /*<<camlinternalFormat.ml:1249:6>>*/ var
         fmtty_rest$12 = fmtty[1],
         sub_fmtty_rest$25 = sub_fmtty[1],
          /*<<camlinternalFormat.ml:1249:6>>*/ match$13 =
           type_ignored_format_substituti
            (sub_fmtty_rest$25, fmt, fmtty_rest$12),
         fmt$13 = match$13[2],
         sub_fmtty_rest$26 = match$13[1];
         /*<<camlinternalFormat.ml:1250:4>>*/ return [0,
                [14, sub_fmtty_rest$26],
                fmt$13];
       }
       break;
    }
     /*<<camlinternalFormat.ml:1277:9>>*/ throw  /*<<camlinternalFormat.ml:1277:9>>*/ caml_maybe_attach_backtrace
           (Type_mismatch, 1);
    /*<<camlinternalFormat.ml:1277:28>>*/ }
   function recast(fmt, fmtty){
     /*<<camlinternalFormat.ml:1312:2>>*/  /*<<camlinternalFormat.ml:1312:29>>*/ var
     _c6_ = symm(fmtty);
     /*<<camlinternalFormat.ml:1312:18>>*/ return type_format
            (fmt,
              /*<<camlinternalFormat.ml:1312:18>>*/ caml_call1
              (CamlinternalFormatBasics[2], _c6_));
    /*<<camlinternalFormat.ml:1312:42>>*/ }
   function fix_padding(padty, width, str){
     /*<<camlinternalFormat.ml:1319:2>>*/ var
     len = caml_ml_string_length(str),
      /*<<camlinternalFormat.ml:1320:2>>*/ padty$0 = 0 <= width ? padty : 0,
      /*<<camlinternalFormat.ml:1321:4>>*/ width$0 =
        /*<<camlinternalFormat.ml:1321:4>>*/ caml_call1(Stdlib[18], width);
    if(width$0 <= len)  /*<<camlinternalFormat.ml:1332:23>>*/ return str;
     /*<<camlinternalFormat.ml:1333:14>>*/ var
     _c5_ = 2 === padty$0 ? 48 : 32,
      /*<<camlinternalFormat.ml:1333:14>>*/ res =
        /*<<camlinternalFormat.ml:1333:14>>*/ caml_call2
        (Stdlib_Bytes[1], width$0, _c5_);
     /*<<camlinternalFormat.ml:1334:4>>*/ switch(padty$0){
      case 0:
        /*<<camlinternalFormat.ml:1335:15>>*/  /*<<camlinternalFormat.ml:1335:15>>*/ caml_call5
        (Stdlib_String[6], str, 0, res, 0, len);
       break;
      case 1:
        /*<<camlinternalFormat.ml:1336:15>>*/  /*<<camlinternalFormat.ml:1336:15>>*/ caml_call5
        (Stdlib_String[6], str, 0, res, width$0 - len | 0, len);
       break;
      default:
       a:
       if(0 < len){
         /*<<camlinternalFormat.ml:1337:63>>*/ if
         (43
          !==  /*<<camlinternalFormat.ml:1337:29>>*/ caml_string_get(str, 0)
          &&
           45
           !==  /*<<camlinternalFormat.ml:1337:46>>*/ caml_string_get(str, 0)
           &&
            32
            !==  /*<<camlinternalFormat.ml:1337:63>>*/ caml_string_get(str, 0))
         break a;
         /*<<camlinternalFormat.ml:1338:6>>*/  /*<<camlinternalFormat.ml:1338:6>>*/ caml_bytes_set
         (res,
          0,
           /*<<camlinternalFormat.ml:1338:22>>*/ caml_string_get(str, 0));
         /*<<camlinternalFormat.ml:1339:6>>*/  /*<<camlinternalFormat.ml:1339:6>>*/ caml_call5
         (Stdlib_String[6],
          str,
          1,
          res,
          (width$0 - len | 0) + 1 | 0,
          len - 1 | 0);
        break;
       }
       a:
       if
        (1 < len
         &&
          48
          ===  /*<<camlinternalFormat.ml:1340:28>>*/ caml_string_get(str, 0)){
         /*<<camlinternalFormat.ml:1340:63>>*/ if
         (120
          !==  /*<<camlinternalFormat.ml:1340:46>>*/ caml_string_get(str, 1)
          &&
           88
           !==  /*<<camlinternalFormat.ml:1340:63>>*/ caml_string_get(str, 1))
         break a;
         /*<<camlinternalFormat.ml:1341:6>>*/  /*<<camlinternalFormat.ml:1341:6>>*/ caml_bytes_set
         (res,
          1,
           /*<<camlinternalFormat.ml:1341:22>>*/ caml_string_get(str, 1));
         /*<<camlinternalFormat.ml:1342:6>>*/  /*<<camlinternalFormat.ml:1342:6>>*/ caml_call5
         (Stdlib_String[6],
          str,
          2,
          res,
          (width$0 - len | 0) + 2 | 0,
          len - 2 | 0);
        break;
       }
        /*<<camlinternalFormat.ml:1344:6>>*/  /*<<camlinternalFormat.ml:1344:6>>*/ caml_call5
        (Stdlib_String[6], str, 0, res, width$0 - len | 0, len);
    }
     /*<<camlinternalFormat.ml:1346:4>>*/ return  /*<<camlinternalFormat.ml:1346:4>>*/ caml_call1
            (Stdlib_Bytes[44], res);
    /*<<camlinternalFormat.ml:1346:30>>*/ }
   function fix_int_precision(prec, str){
     /*<<camlinternalFormat.ml:1350:2>>*/ var
      /*<<camlinternalFormat.ml:1350:13>>*/ prec$0 =
        /*<<camlinternalFormat.ml:1350:13>>*/ caml_call1(Stdlib[18], prec),
      /*<<camlinternalFormat.ml:1351:2>>*/ len =
        /*<<camlinternalFormat.ml:1351:2>>*/ caml_ml_string_length(str),
      /*<<camlinternalFormat.ml:1352:8>>*/ c =
        /*<<camlinternalFormat.ml:1352:8>>*/ caml_string_get(str, 0);
    a:
    {
     b:
     {
      if(58 > c){
       if(32 !== c){
        if(43 > c) break a;
        switch(c - 43 | 0){
          case 5:
           c:
           if(len < (prec$0 + 2 | 0) && 1 < len){
             /*<<camlinternalFormat.ml:1358:60>>*/ if
             (120
              !==
                /*<<camlinternalFormat.ml:1358:43>>*/ caml_string_get(str, 1)
              &&
               88
               !==
                 /*<<camlinternalFormat.ml:1358:60>>*/ caml_string_get(str, 1))
             break c;
             /*<<camlinternalFormat.ml:1359:14>>*/  /*<<camlinternalFormat.ml:1359:14>>*/ var
             res$1 =
                /*<<camlinternalFormat.ml:1359:14>>*/ caml_call2
                (Stdlib_Bytes[1], prec$0 + 2 | 0, 48);
             /*<<camlinternalFormat.ml:1360:4>>*/  /*<<camlinternalFormat.ml:1360:4>>*/ caml_bytes_set
             (res$1,
              1,
               /*<<camlinternalFormat.ml:1360:20>>*/ caml_string_get(str, 1));
             /*<<camlinternalFormat.ml:1361:4>>*/  /*<<camlinternalFormat.ml:1361:4>>*/ caml_call5
             (Stdlib_String[6],
              str,
              2,
              res$1,
              (prec$0 - len | 0) + 4 | 0,
              len - 2 | 0);
             /*<<camlinternalFormat.ml:1361:4>>*/ return  /*<<camlinternalFormat.ml:1361:4>>*/ caml_call1
                    (Stdlib_Bytes[44], res$1);
           }
           break b;
          case 0:
          case 2: break;
          case 1:
          case 3:
          case 4:
           break a;
          default: break b;
        }
       }
       if(len >= (prec$0 + 1 | 0)) break a;
        /*<<camlinternalFormat.ml:1354:14>>*/  /*<<camlinternalFormat.ml:1354:14>>*/ var
        res$0 =
           /*<<camlinternalFormat.ml:1354:14>>*/ caml_call2
           (Stdlib_Bytes[1], prec$0 + 1 | 0, 48);
        /*<<camlinternalFormat.ml:1355:4>>*/  /*<<camlinternalFormat.ml:1355:4>>*/ caml_bytes_set
        (res$0, 0, c);
        /*<<camlinternalFormat.ml:1356:4>>*/  /*<<camlinternalFormat.ml:1356:4>>*/ caml_call5
        (Stdlib_String[6],
         str,
         1,
         res$0,
         (prec$0 - len | 0) + 2 | 0,
         len - 1 | 0);
        /*<<camlinternalFormat.ml:1356:4>>*/ return  /*<<camlinternalFormat.ml:1356:4>>*/ caml_call1
               (Stdlib_Bytes[44], res$0);
      }
      if(71 <= c){if(5 < c - 97 >>> 0) break a;} else if(65 > c) break a;
     }
     if(len < prec$0){
       /*<<camlinternalFormat.ml:1364:14>>*/  /*<<camlinternalFormat.ml:1364:14>>*/ var
       res =
          /*<<camlinternalFormat.ml:1364:14>>*/ caml_call2
          (Stdlib_Bytes[1], prec$0, 48);
       /*<<camlinternalFormat.ml:1365:4>>*/  /*<<camlinternalFormat.ml:1365:4>>*/ caml_call5
       (Stdlib_String[6], str, 0, res, prec$0 - len | 0, len);
       /*<<camlinternalFormat.ml:1365:4>>*/ return  /*<<camlinternalFormat.ml:1365:4>>*/ caml_call1
              (Stdlib_Bytes[44], res);
     }
    }
     /*<<camlinternalFormat.ml:1368:4>>*/ return str;
    /*<<camlinternalFormat.ml:1368:7>>*/ }
   function string_to_caml_string(str){
     /*<<camlinternalFormat.ml:1372:2>>*/ var
      /*<<camlinternalFormat.ml:1372:12>>*/ str$0 =
        /*<<camlinternalFormat.ml:1372:12>>*/ caml_call1
        (Stdlib_String[25], str),
      /*<<camlinternalFormat.ml:1373:2>>*/ l =
        /*<<camlinternalFormat.ml:1373:2>>*/ caml_ml_string_length(str$0),
      /*<<camlinternalFormat.ml:1374:12>>*/ res =
        /*<<camlinternalFormat.ml:1374:12>>*/ caml_call2
        (Stdlib_Bytes[1], l + 2 | 0, 34);
     /*<<camlinternalFormat.ml:1375:2>>*/  /*<<camlinternalFormat.ml:1375:2>>*/ caml_blit_string
     (str$0, 0, res, 1, l);
     /*<<camlinternalFormat.ml:1375:2>>*/ return  /*<<camlinternalFormat.ml:1375:2>>*/ caml_call1
            (Stdlib_Bytes[44], res);
    /*<<camlinternalFormat.ml:1376:28>>*/ }
   function format_of_fconv(fconv, prec){
     /*<<camlinternalFormat.ml:1414:4>>*/ var
      /*<<camlinternalFormat.ml:1414:15>>*/ prec$0 =
        /*<<camlinternalFormat.ml:1414:15>>*/ caml_call1(Stdlib[18], prec),
      /*<<camlinternalFormat.ml:1415:15>>*/ symb = char_of_fconv(_r_, fconv),
      /*<<camlinternalFormat.ml:1416:14>>*/ buf = buffer_create(16);
     /*<<camlinternalFormat.ml:1417:4>>*/ buffer_add_char(buf, 37);
     /*<<camlinternalFormat.ml:1418:4>>*/ bprint_fconv_flag(buf, fconv);
     /*<<camlinternalFormat.ml:1419:4>>*/ buffer_add_char(buf, 46);
     /*<<camlinternalFormat.ml:1420:4>>*/ buffer_add_string
     (buf,
       /*<<camlinternalFormat.ml:1420:26>>*/ caml_call1
       (Stdlib_Int[12], prec$0));
     /*<<camlinternalFormat.ml:1421:4>>*/ buffer_add_char(buf, symb);
     /*<<camlinternalFormat.ml:1421:4>>*/ return buffer_contents(buf);
    /*<<camlinternalFormat.ml:1422:23>>*/ }
   function transform_int_alt(iconv, s){
     /*<<camlinternalFormat.ml:1425:2>>*/ if(13 > iconv)
      /*<<camlinternalFormat.ml:1447:9>>*/ return s;
     /*<<camlinternalFormat.ml:1428:14>>*/ var
      /*<<camlinternalFormat.ml:1428:14>>*/ n = [0, 0],
     _c0_ = caml_ml_string_length(s) - 1 | 0,
      /*<<camlinternalFormat.ml:1428:14>>*/ _cZ_ = 0;
    if(_c0_ >= 0){
     var i$0 = _cZ_;
     for(;;){
      if(9 >= caml_string_unsafe_get(s, i$0) - 48 >>> 0) n[1]++;
       /*<<camlinternalFormat.ml:1429:6>>*/  /*<<camlinternalFormat.ml:1429:6>>*/ var
       _c4_ = i$0 + 1 | 0;
      if(_c0_ === i$0) break;
      var i$0 = _c4_;
     }
    }
     /*<<camlinternalFormat.ml:1436:14>>*/ var
     digits = n[1],
      /*<<camlinternalFormat.ml:1436:14>>*/ buf =
        /*<<camlinternalFormat.ml:1436:14>>*/ caml_create_bytes
        (caml_ml_string_length(s) + ((digits - 1 | 0) / 3 | 0) | 0),
      /*<<camlinternalFormat.ml:1437:14>>*/ pos = [0, 0];
    function put(c){
      /*<<camlinternalFormat.ml:1438:16>>*/  /*<<camlinternalFormat.ml:1438:16>>*/ caml_bytes_set
      (buf, pos[1], c);
     pos[1]++;
     return;
     /*<<camlinternalFormat.ml:1438:46>>*/ }
     /*<<camlinternalFormat.ml:1439:15>>*/ var
      /*<<camlinternalFormat.ml:1439:15>>*/ left =
       [0, ((digits - 1 | 0) % 3 | 0) + 1 | 0],
     _c2_ = caml_ml_string_length(s) - 1 | 0,
      /*<<camlinternalFormat.ml:1439:15>>*/ _c1_ = 0;
    if(_c2_ >= 0){
     var i = _c1_;
     for(;;){
      var c = caml_string_unsafe_get(s, i);
      if(9 < c - 48 >>> 0)
        /*<<camlinternalFormat.ml:1444:13>>*/ put(c);
      else{
       if(0 === left[1]){
         /*<<camlinternalFormat.ml:1443:29>>*/ put(95);
        left[1] = 3;
       }
       left[1] += -1;
        /*<<camlinternalFormat.ml:1443:61>>*/ put(c);
      }
       /*<<camlinternalFormat.ml:1440:4>>*/  /*<<camlinternalFormat.ml:1440:4>>*/ var
       _c3_ = i + 1 | 0;
      if(_c2_ === i) break;
      var i = _c3_;
     }
    }
     /*<<camlinternalFormat.ml:1446:4>>*/ return  /*<<camlinternalFormat.ml:1446:4>>*/ caml_call1
            (Stdlib_Bytes[44], buf);
    /*<<camlinternalFormat.ml:1447:10>>*/ }
   function convert_int(iconv, n){
     /*<<camlinternalFormat.ml:1451:2>>*/ switch(iconv){
      case 1:
       var _cY_ = cst_d$0; break;
      case 2:
       var _cY_ = cst_d$1; break;
      case 4:
       var _cY_ = cst_i$1; break;
      case 5:
       var _cY_ = cst_i$2; break;
      case 6:
       var _cY_ = cst_x; break;
      case 7:
       var _cY_ = cst_x$0; break;
      case 8:
       var _cY_ = cst_X; break;
      case 9:
       var _cY_ = cst_X$0; break;
      case 10:
       var _cY_ = cst_o; break;
      case 11:
       var _cY_ = cst_o$0; break;
      case 0:
      case 13:
       var _cY_ = cst_d; break;
      case 3:
      case 14:
       var _cY_ = cst_i$0; break;
      default: var _cY_ = cst_u;
    }
     /*<<camlinternalFormat.ml:1451:26>>*/ return transform_int_alt
            (iconv,
              /*<<camlinternalFormat.ml:1451:26>>*/ caml_format_int(_cY_, n));
    /*<<camlinternalFormat.ml:1451:64>>*/ }
   function convert_int32(iconv, n){
     /*<<camlinternalFormat.ml:1453:2>>*/ switch(iconv){
      case 1:
       var _cX_ = cst_ld$0; break;
      case 2:
       var _cX_ = cst_ld$1; break;
      case 4:
       var _cX_ = cst_li$1; break;
      case 5:
       var _cX_ = cst_li$2; break;
      case 6:
       var _cX_ = cst_lx; break;
      case 7:
       var _cX_ = cst_lx$0; break;
      case 8:
       var _cX_ = cst_lX; break;
      case 9:
       var _cX_ = cst_lX$0; break;
      case 10:
       var _cX_ = cst_lo; break;
      case 11:
       var _cX_ = cst_lo$0; break;
      case 0:
      case 13:
       var _cX_ = cst_ld; break;
      case 3:
      case 14:
       var _cX_ = cst_li$0; break;
      default: var _cX_ = cst_lu;
    }
     /*<<camlinternalFormat.ml:1453:26>>*/ return transform_int_alt
            (iconv,
              /*<<camlinternalFormat.ml:1453:26>>*/ caml_format_int(_cX_, n));
    /*<<camlinternalFormat.ml:1453:67>>*/ }
   function convert_nativeint(iconv, n){
     /*<<camlinternalFormat.ml:1455:2>>*/ switch(iconv){
      case 1:
       var _cW_ = cst_nd$0; break;
      case 2:
       var _cW_ = cst_nd$1; break;
      case 4:
       var _cW_ = cst_ni$1; break;
      case 5:
       var _cW_ = cst_ni$2; break;
      case 6:
       var _cW_ = cst_nx; break;
      case 7:
       var _cW_ = cst_nx$0; break;
      case 8:
       var _cW_ = cst_nX; break;
      case 9:
       var _cW_ = cst_nX$0; break;
      case 10:
       var _cW_ = cst_no; break;
      case 11:
       var _cW_ = cst_no$0; break;
      case 0:
      case 13:
       var _cW_ = cst_nd; break;
      case 3:
      case 14:
       var _cW_ = cst_ni$0; break;
      default: var _cW_ = cst_nu;
    }
     /*<<camlinternalFormat.ml:1455:26>>*/ return transform_int_alt
            (iconv,
              /*<<camlinternalFormat.ml:1455:26>>*/ caml_format_int(_cW_, n));
    /*<<camlinternalFormat.ml:1455:71>>*/ }
   function convert_int64(iconv, n){
     /*<<camlinternalFormat.ml:1457:2>>*/ switch(iconv){
      case 1:
       var _cV_ = cst_Ld$0; break;
      case 2:
       var _cV_ = cst_Ld$1; break;
      case 4:
       var _cV_ = cst_Li$1; break;
      case 5:
       var _cV_ = cst_Li$2; break;
      case 6:
       var _cV_ = cst_Lx; break;
      case 7:
       var _cV_ = cst_Lx$0; break;
      case 8:
       var _cV_ = cst_LX; break;
      case 9:
       var _cV_ = cst_LX$0; break;
      case 10:
       var _cV_ = cst_Lo; break;
      case 11:
       var _cV_ = cst_Lo$0; break;
      case 0:
      case 13:
       var _cV_ = cst_Ld; break;
      case 3:
      case 14:
       var _cV_ = cst_Li$0; break;
      default: var _cV_ = cst_Lu;
    }
     /*<<camlinternalFormat.ml:1457:26>>*/ return transform_int_alt
            (iconv,
              /*<<camlinternalFormat.ml:1457:26>>*/ runtime.caml_int64_format
              (_cV_, n));
    /*<<camlinternalFormat.ml:1457:67>>*/ }
   function convert_float(fconv, prec, x){
    function hex(param){
      /*<<camlinternalFormat.ml:1463:4>>*/ switch(fconv[1]){
       case 0:
        var sign = 45; break;
       case 1:
        var sign = 43; break;
       default: var sign = 32;
     }
      /*<<camlinternalFormat.ml:1468:4>>*/ return  /*<<camlinternalFormat.ml:1468:4>>*/ runtime.caml_hexstring_of_float
             (x, prec, sign);
     /*<<camlinternalFormat.ml:1468:34>>*/ }
     /*<<camlinternalFormat.ml:1477:2>>*/ function caml_special_val(str){
      /*<<camlinternalFormat.ml:1477:29>>*/  /*<<camlinternalFormat.ml:1477:35>>*/ var
      match =
         /*<<camlinternalFormat.ml:1477:35>>*/ runtime.caml_classify_float(x);
     return 3 === match
             ? x < 0. ? cst_neg_infinity : cst_infinity
             : 4 <= match ? cst_nan : str;
     /*<<camlinternalFormat.ml:1480:21>>*/ }
    switch(fconv[2]){
      case 5:
        /*<<camlinternalFormat.ml:1486:14>>*/ var
         /*<<camlinternalFormat.ml:1486:14>>*/ str =
           /*<<camlinternalFormat.ml:1486:14>>*/ caml_format_float
           (format_of_fconv(fconv, prec), x),
        len = caml_ml_string_length(str),
        i = 0;
        /*<<camlinternalFormat.ml:1472:6>>*/ for(;;){
        if(i === len)
         var _cS_ = 0;
        else{
          /*<<camlinternalFormat.ml:1473:14>>*/  /*<<camlinternalFormat.ml:1473:14>>*/ var
          _cR_ =
             /*<<camlinternalFormat.ml:1473:14>>*/ caml_string_get(str, i)
            - 46
            | 0;
         a:
         {
          if(23 < _cR_ >>> 0){
           if(55 === _cR_) break a;
          }
          else if(21 < _cR_ - 1 >>> 0) break a;
           /*<<camlinternalFormat.ml:1475:15>>*/ var
            /*<<camlinternalFormat.ml:1475:15>>*/ i$0 = i + 1 | 0,
           i = i$0;
          continue;
         }
         var _cS_ = 1;
        }
         /*<<camlinternalFormat.ml:1476:7>>*/  /*<<camlinternalFormat.ml:1476:7>>*/ var
         _cT_ =
           _cS_
            ? str
            :  /*<<camlinternalFormat.ml:1476:32>>*/ caml_call2
              (Stdlib[28], str, cst$17);
         /*<<camlinternalFormat.ml:1487:21>>*/ return caml_special_val(_cT_);
       }
      case 6:
        /*<<camlinternalFormat.ml:1482:15>>*/ return hex(0);
      case 7:
        /*<<camlinternalFormat.ml:1483:38>>*/  /*<<camlinternalFormat.ml:1483:38>>*/ var
        _cU_ = hex(0);
        /*<<camlinternalFormat.ml:1483:38>>*/ return  /*<<camlinternalFormat.ml:1483:38>>*/ caml_call1
               (Stdlib_String[26], _cU_);
      case 8:
        /*<<camlinternalFormat.ml:1484:33>>*/ return caml_special_val(hex(0));
      default:
        /*<<camlinternalFormat.ml:1489:4>>*/ return  /*<<camlinternalFormat.ml:1489:4>>*/ caml_format_float
               (format_of_fconv(fconv, prec), x);
    }
    /*<<camlinternalFormat.ml:1489:47>>*/ }
   function string_of_fmtty(fmtty){
     /*<<camlinternalFormat.ml:1501:2>>*/  /*<<camlinternalFormat.ml:1501:12>>*/ var
     buf = buffer_create(16);
     /*<<camlinternalFormat.ml:1502:2>>*/ bprint_fmtty(buf, fmtty);
     /*<<camlinternalFormat.ml:1502:2>>*/ return buffer_contents(buf);
    /*<<camlinternalFormat.ml:1503:21>>*/ }
   function make_printf$0(counter, k, acc, fmt){
     /*<<camlinternalFormat.ml:1518:17>>*/ var
     k$0 = k,
     acc$0 = acc,
     fmt$0 = fmt;
     /*<<camlinternalFormat.ml:1518:17>>*/ for(;;){
     if(typeof fmt$0 === "number")
       /*<<camlinternalFormat.ml:1605:4>>*/ return  /*<<camlinternalFormat.ml:1605:4>>*/ caml_call1
              (k$0, acc$0);
     switch(fmt$0[0]){
       case 0:
        var rest = fmt$0[1];
         /*<<camlinternalFormat.ml:1520:4>>*/ return function(c){
          /*<<camlinternalFormat.ml:1521:6>>*/  /*<<camlinternalFormat.ml:1521:20>>*/ var
          new_acc = [5, acc$0, c];
          /*<<camlinternalFormat.ml:1522:6>>*/ return make_printf
                 (k$0, new_acc, rest); /*<<camlinternalFormat.ml:1522:32>>*/ };
       case 1:
        var rest$0 = fmt$0[1];
         /*<<camlinternalFormat.ml:1524:4>>*/ return function(c){
          /*<<camlinternalFormat.ml:1525:6>>*/ var
           /*<<camlinternalFormat.ml:1493:12>>*/ str =
             /*<<camlinternalFormat.ml:1493:12>>*/ caml_call1
             (Stdlib_Char[2], c),
           /*<<camlinternalFormat.ml:1494:2>>*/ l =
             /*<<camlinternalFormat.ml:1494:2>>*/ caml_ml_string_length(str),
           /*<<camlinternalFormat.ml:1495:12>>*/ res =
             /*<<camlinternalFormat.ml:1495:12>>*/ caml_call2
             (Stdlib_Bytes[1], l + 2 | 0, 39);
          /*<<camlinternalFormat.ml:1496:2>>*/  /*<<camlinternalFormat.ml:1496:2>>*/ caml_blit_string
          (str, 0, res, 1, l);
          /*<<camlinternalFormat.ml:1525:20>>*/  /*<<camlinternalFormat.ml:1525:20>>*/ var
          new_acc =
            [4,
             acc$0,
              /*<<camlinternalFormat.ml:1496:2>>*/ caml_call1
              (Stdlib_Bytes[44], res)];
          /*<<camlinternalFormat.ml:1526:6>>*/ return make_printf
                 (k$0, new_acc, rest$0); /*<<camlinternalFormat.ml:1526:32>>*/ };
       case 2:
        var rest$1 = fmt$0[2], pad = fmt$0[1];
         /*<<camlinternalFormat.ml:1528:32>>*/ return make_padding
                (k$0,
                 acc$0,
                 rest$1,
                 pad,
                 function(str){
                   /*<<camlinternalFormat.ml:1528:44>>*/ return str;
                  /*<<camlinternalFormat.ml:1528:47>>*/ });
       case 3:
        var rest$2 = fmt$0[2], pad$0 = fmt$0[1];
         /*<<camlinternalFormat.ml:1530:4>>*/ return make_padding
                (k$0, acc$0, rest$2, pad$0, string_to_caml_string);
       case 4:
        var
         rest$3 = fmt$0[4],
         prec = fmt$0[3],
         pad$1 = fmt$0[2],
         iconv = fmt$0[1];
         /*<<camlinternalFormat.ml:1532:4>>*/ return make_int_padding_precision
                (k$0, acc$0, rest$3, pad$1, prec, convert_int, iconv);
       case 5:
        var
         rest$4 = fmt$0[4],
         prec$0 = fmt$0[3],
         pad$2 = fmt$0[2],
         iconv$0 = fmt$0[1];
         /*<<camlinternalFormat.ml:1534:4>>*/ return make_int_padding_precision
                (k$0, acc$0, rest$4, pad$2, prec$0, convert_int32, iconv$0);
       case 6:
        var
         rest$5 = fmt$0[4],
         prec$1 = fmt$0[3],
         pad$3 = fmt$0[2],
         iconv$1 = fmt$0[1];
         /*<<camlinternalFormat.ml:1536:4>>*/ return make_int_padding_precision
                (k$0,
                 acc$0,
                 rest$5,
                 pad$3,
                 prec$1,
                 convert_nativeint,
                 iconv$1);
       case 7:
        var
         rest$6 = fmt$0[4],
         prec$2 = fmt$0[3],
         pad$4 = fmt$0[2],
         iconv$2 = fmt$0[1];
         /*<<camlinternalFormat.ml:1538:4>>*/ return make_int_padding_precision
                (k$0, acc$0, rest$6, pad$4, prec$2, convert_int64, iconv$2);
       case 8:
        var
         rest$7 = fmt$0[4],
         prec$3 = fmt$0[3],
         pad$5 = fmt$0[2],
         fconv = fmt$0[1];
        if(typeof pad$5 === "number"){
         if(typeof prec$3 === "number")
          return prec$3
                  ? function
                   (p, x){
                     /*<<camlinternalFormat.ml:1746:6>>*/  /*<<camlinternalFormat.ml:1746:16>>*/ var
                     str = convert_float(fconv, p, x);
                     /*<<camlinternalFormat.ml:1747:6>>*/ return make_printf
                            (k$0, [4, acc$0, str], rest$7);
                    /*<<camlinternalFormat.ml:1747:52>>*/ }
                  : function
                   (x){
                     /*<<camlinternalFormat.ml:1738:6>>*/  /*<<camlinternalFormat.ml:1738:16>>*/ var
                     str =
                       convert_float(fconv, default_float_precision(fconv), x);
                     /*<<camlinternalFormat.ml:1739:6>>*/ return make_printf
                            (k$0, [4, acc$0, str], rest$7);
                    /*<<camlinternalFormat.ml:1739:52>>*/ };
         var p = prec$3[1];
          /*<<camlinternalFormat.ml:1741:4>>*/ return function(x){
           /*<<camlinternalFormat.ml:1742:6>>*/  /*<<camlinternalFormat.ml:1742:16>>*/ var
           str = convert_float(fconv, p, x);
           /*<<camlinternalFormat.ml:1743:6>>*/ return make_printf
                  (k$0, [4, acc$0, str], rest$7); /*<<camlinternalFormat.ml:1743:52>>*/ };
        }
        if(0 === pad$5[0]){
         var w = pad$5[2], padty = pad$5[1];
         if(typeof prec$3 === "number")
          return prec$3
                  ? function
                   (p, x){
                     /*<<camlinternalFormat.ml:1759:6>>*/  /*<<camlinternalFormat.ml:1759:16>>*/ var
                     str = fix_padding(padty, w, convert_float(fconv, p, x));
                     /*<<camlinternalFormat.ml:1760:6>>*/ return make_printf
                            (k$0, [4, acc$0, str], rest$7);
                    /*<<camlinternalFormat.ml:1760:52>>*/ }
                  : function
                   (x){
                     /*<<camlinternalFormat.ml:1750:6>>*/ var
                      /*<<camlinternalFormat.ml:1750:16>>*/ str =
                       convert_float(fconv, default_float_precision(fconv), x),
                      /*<<camlinternalFormat.ml:1751:17>>*/ str$0 =
                       fix_padding(padty, w, str);
                     /*<<camlinternalFormat.ml:1752:6>>*/ return make_printf
                            (k$0, [4, acc$0, str$0], rest$7);
                    /*<<camlinternalFormat.ml:1752:53>>*/ };
         var p$0 = prec$3[1];
          /*<<camlinternalFormat.ml:1754:4>>*/ return function(x){
           /*<<camlinternalFormat.ml:1755:6>>*/  /*<<camlinternalFormat.ml:1755:16>>*/ var
           str = fix_padding(padty, w, convert_float(fconv, p$0, x));
           /*<<camlinternalFormat.ml:1756:6>>*/ return make_printf
                  (k$0, [4, acc$0, str], rest$7); /*<<camlinternalFormat.ml:1756:52>>*/ };
        }
        var padty$0 = pad$5[1];
        if(typeof prec$3 === "number")
         return prec$3
                 ? function
                  (w, p, x){
                    /*<<camlinternalFormat.ml:1772:6>>*/  /*<<camlinternalFormat.ml:1772:16>>*/ var
                    str = fix_padding(padty$0, w, convert_float(fconv, p, x));
                    /*<<camlinternalFormat.ml:1773:6>>*/ return make_printf
                           (k$0, [4, acc$0, str], rest$7);
                   /*<<camlinternalFormat.ml:1773:52>>*/ }
                 : function
                  (w, x){
                    /*<<camlinternalFormat.ml:1763:6>>*/ var
                     /*<<camlinternalFormat.ml:1763:16>>*/ str =
                      convert_float(fconv, default_float_precision(fconv), x),
                     /*<<camlinternalFormat.ml:1764:17>>*/ str$0 =
                      fix_padding(padty$0, w, str);
                    /*<<camlinternalFormat.ml:1765:6>>*/ return make_printf
                           (k$0, [4, acc$0, str$0], rest$7);
                   /*<<camlinternalFormat.ml:1765:53>>*/ };
        var p$1 = prec$3[1];
         /*<<camlinternalFormat.ml:1767:4>>*/ return function(w, x){
          /*<<camlinternalFormat.ml:1768:6>>*/  /*<<camlinternalFormat.ml:1768:16>>*/ var
          str = fix_padding(padty$0, w, convert_float(fconv, p$1, x));
          /*<<camlinternalFormat.ml:1769:6>>*/ return make_printf
                 (k$0, [4, acc$0, str], rest$7); /*<<camlinternalFormat.ml:1769:52>>*/ };
       case 9:
        var rest$8 = fmt$0[2], pad$6 = fmt$0[1];
         /*<<camlinternalFormat.ml:1542:4>>*/ return make_padding
                (k$0, acc$0, rest$8, pad$6, Stdlib[30]);
       case 10:
         /*<<camlinternalFormat.ml:1560:18>>*/ var
         rest$9 = fmt$0[1],
          /*<<camlinternalFormat.ml:1560:18>>*/ acc$1 = [7, acc$0],
         acc$0 = acc$1,
         fmt$0 = rest$9;
        break;
       case 11:
         /*<<camlinternalFormat.ml:1563:18>>*/ var
         rest$10 = fmt$0[2],
         str = fmt$0[1],
          /*<<camlinternalFormat.ml:1563:18>>*/ acc$2 = [2, acc$0, str],
         acc$0 = acc$2,
         fmt$0 = rest$10;
        break;
       case 12:
         /*<<camlinternalFormat.ml:1565:18>>*/ var
         rest$11 = fmt$0[2],
         chr = fmt$0[1],
          /*<<camlinternalFormat.ml:1565:18>>*/ acc$3 = [3, acc$0, chr],
         acc$0 = acc$3,
         fmt$0 = rest$11;
        break;
       case 13:
         /*<<camlinternalFormat.ml:1568:13>>*/ var
         rest$12 = fmt$0[3],
         sub_fmtty = fmt$0[2],
          /*<<camlinternalFormat.ml:1568:13>>*/ ty =
           string_of_fmtty(sub_fmtty);
         /*<<camlinternalFormat.ml:1569:4>>*/ return function(str){
          /*<<camlinternalFormat.ml:1570:6>>*/ return make_printf
                 (k$0, [4, acc$0, ty], rest$12); /*<<camlinternalFormat.ml:1571:52>>*/ };
       case 14:
        var rest$13 = fmt$0[3], fmtty = fmt$0[2];
         /*<<camlinternalFormat.ml:1573:4>>*/ return function(param){
          /*<<camlinternalFormat.ml:1573:4>>*/ var
          fmt = param[1],
           /*<<camlinternalFormat.ml:1574:18>>*/ _cQ_ = recast(fmt, fmtty);
          /*<<camlinternalFormat.ml:1574:6>>*/ return make_printf
                 (k$0,
                  acc$0,
                   /*<<camlinternalFormat.ml:1574:6>>*/ caml_call2
                   (CamlinternalFormatBasics[3], _cQ_, rest$13)); /*<<camlinternalFormat.ml:1574:42>>*/ };
       case 15:
        var rest$14 = fmt$0[1];
         /*<<camlinternalFormat.ml:1544:4>>*/ return function(f, x){
          /*<<camlinternalFormat.ml:1544:15>>*/ return make_printf
                 (k$0,
                  [6,
                   acc$0,
                   function(o){
                     /*<<camlinternalFormat.ml:1544:55>>*/ return caml_call2
                            (f, o, x);
                    /*<<camlinternalFormat.ml:1544:60>>*/ }],
                  rest$14); /*<<camlinternalFormat.ml:1544:67>>*/ };
       case 16:
        var rest$15 = fmt$0[1];
         /*<<camlinternalFormat.ml:1546:4>>*/ return function(f){
          /*<<camlinternalFormat.ml:1546:13>>*/ return make_printf
                 (k$0, [6, acc$0, f], rest$15); /*<<camlinternalFormat.ml:1546:52>>*/ };
       case 17:
         /*<<camlinternalFormat.ml:1594:18>>*/ var
         rest$16 = fmt$0[2],
         fmting_lit = fmt$0[1],
          /*<<camlinternalFormat.ml:1594:18>>*/ acc$4 = [0, acc$0, fmting_lit],
         acc$0 = acc$4,
         fmt$0 = rest$16;
        break;
       case 18:
        var _cO_ = fmt$0[1];
        if(0 === _cO_[0]){
         var rest$17 = fmt$0[2], fmt$1 = _cO_[1][1];
         let acc = acc$0, k = k$0, rest = rest$17;
         var
          k$1 =
            function(kacc){
              /*<<camlinternalFormat.ml:1597:6>>*/ return make_printf
                     (k, [1, acc, [0, kacc]], rest);
             /*<<camlinternalFormat.ml:1597:70>>*/ },
          k$0 = k$1,
          acc$0 = 0,
          fmt$0 = fmt$1;
        }
        else{
         var rest$18 = fmt$0[2], fmt$2 = _cO_[1][1];
         let acc = acc$0, k = k$0, rest = rest$18;
         var
          k$2 =
            function(kacc){
              /*<<camlinternalFormat.ml:1601:6>>*/ return make_printf
                     (k, [1, acc, [1, kacc]], rest);
             /*<<camlinternalFormat.ml:1601:70>>*/ },
          k$0 = k$2,
          acc$0 = 0,
          fmt$0 = fmt$2;
        }
        break;
       case 19:
         /*<<camlinternalFormat.ml:1558:4>>*/ throw  /*<<camlinternalFormat.ml:1558:4>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _s_], 1);
       case 20:
         /*<<camlinternalFormat.ml:1577:18>>*/ var
         rest$19 = fmt$0[3],
          /*<<camlinternalFormat.ml:1577:18>>*/ new_acc =
           [8, acc$0, cst_Printf_bad_conversion];
         /*<<camlinternalFormat.ml:1578:4>>*/ return function(param){
          /*<<camlinternalFormat.ml:1578:13>>*/ return make_printf
                 (k$0, new_acc, rest$19); /*<<camlinternalFormat.ml:1578:39>>*/ };
       case 21:
        var rest$20 = fmt$0[2];
         /*<<camlinternalFormat.ml:1583:4>>*/ return function(n){
          /*<<camlinternalFormat.ml:1584:6>>*/  /*<<camlinternalFormat.ml:1584:20>>*/ var
          new_acc =
            [4,
             acc$0,
              /*<<camlinternalFormat.ml:1584:42>>*/ caml_format_int
              (cst_u$0, n)];
          /*<<camlinternalFormat.ml:1585:6>>*/ return make_printf
                 (k$0, new_acc, rest$20); /*<<camlinternalFormat.ml:1585:32>>*/ };
       case 22:
        var rest$21 = fmt$0[1];
         /*<<camlinternalFormat.ml:1587:4>>*/ return function(c){
          /*<<camlinternalFormat.ml:1588:6>>*/  /*<<camlinternalFormat.ml:1588:20>>*/ var
          new_acc = [5, acc$0, c];
          /*<<camlinternalFormat.ml:1589:6>>*/ return make_printf
                 (k$0, new_acc, rest$21); /*<<camlinternalFormat.ml:1589:32>>*/ };
       case 23:
        var rest$22 = fmt$0[2], ign = fmt$0[1];
         /*<<camlinternalFormat.ml:1591:4>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1591:4>>*/ return  /*<<camlinternalFormat.ml:1591:4>>*/ caml_trampoline_return
                 (make_ignored_param$0, [0, k$0, acc$0, ign, rest$22]);
        var counter$1 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1591:4>>*/ return make_ignored_param$0
                (counter$1, k$0, acc$0, ign, rest$22);
       default:
         /*<<camlinternalFormat.ml:1548:33>>*/ var
         rest$23 = fmt$0[3],
         f = fmt$0[2],
         arity = fmt$0[1],
          /*<<camlinternalFormat.ml:1548:33>>*/ _cP_ =
            /*<<camlinternalFormat.ml:1548:33>>*/ caml_call1(f, 0);
         /*<<camlinternalFormat.ml:1548:33>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1548:33>>*/ return  /*<<camlinternalFormat.ml:1548:33>>*/ caml_trampoline_return
                 (make_custom$0, [0, k$0, acc$0, rest$23, arity, _cP_]);
        var counter$0 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1548:33>>*/ return make_custom$0
                (counter$0, k$0, acc$0, rest$23, arity, _cP_);
     }
    }
    /*<<camlinternalFormat.ml:1605:9>>*/ }
   function make_printf(k, acc, fmt){
     /*<<?>>*/ return caml_trampoline(make_printf$0(0, k, acc, fmt));
   }
   function make_ignored_param$0(counter, k, acc, ign, fmt){
     /*<<camlinternalFormat.ml:1613:21>>*/ if(typeof ign === "number")
     switch(ign){
       case 0:
         /*<<camlinternalFormat.ml:1614:39>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1614:39>>*/ return  /*<<camlinternalFormat.ml:1614:39>>*/ caml_trampoline_return
                 (make_invalid_arg, [0, k, acc, fmt]);
        var counter$0 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1614:39>>*/ return make_invalid_arg
                (counter$0, k, acc, fmt);
       case 1:
         /*<<camlinternalFormat.ml:1615:39>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1615:39>>*/ return  /*<<camlinternalFormat.ml:1615:39>>*/ caml_trampoline_return
                 (make_invalid_arg, [0, k, acc, fmt]);
        var counter$1 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1615:39>>*/ return make_invalid_arg
                (counter$1, k, acc, fmt);
       case 2:
         /*<<camlinternalFormat.ml:1626:39>>*/ throw  /*<<camlinternalFormat.ml:1626:39>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _t_], 1);
       default:
         /*<<camlinternalFormat.ml:1629:39>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1629:39>>*/ return  /*<<camlinternalFormat.ml:1629:39>>*/ caml_trampoline_return
                 (make_invalid_arg, [0, k, acc, fmt]);
        var counter$2 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1629:39>>*/ return make_invalid_arg
                (counter$2, k, acc, fmt);
     }
    switch(ign[0]){
      case 0:
        /*<<camlinternalFormat.ml:1616:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1616:39>>*/ return  /*<<camlinternalFormat.ml:1616:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$3 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1616:39>>*/ return make_invalid_arg
               (counter$3, k, acc, fmt);
      case 1:
        /*<<camlinternalFormat.ml:1617:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1617:39>>*/ return  /*<<camlinternalFormat.ml:1617:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$4 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1617:39>>*/ return make_invalid_arg
               (counter$4, k, acc, fmt);
      case 2:
        /*<<camlinternalFormat.ml:1618:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1618:39>>*/ return  /*<<camlinternalFormat.ml:1618:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$5 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1618:39>>*/ return make_invalid_arg
               (counter$5, k, acc, fmt);
      case 3:
        /*<<camlinternalFormat.ml:1619:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1619:39>>*/ return  /*<<camlinternalFormat.ml:1619:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$6 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1619:39>>*/ return make_invalid_arg
               (counter$6, k, acc, fmt);
      case 4:
        /*<<camlinternalFormat.ml:1620:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1620:39>>*/ return  /*<<camlinternalFormat.ml:1620:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$7 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1620:39>>*/ return make_invalid_arg
               (counter$7, k, acc, fmt);
      case 5:
        /*<<camlinternalFormat.ml:1621:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1621:39>>*/ return  /*<<camlinternalFormat.ml:1621:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$8 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1621:39>>*/ return make_invalid_arg
               (counter$8, k, acc, fmt);
      case 6:
        /*<<camlinternalFormat.ml:1622:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1622:39>>*/ return  /*<<camlinternalFormat.ml:1622:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$9 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1622:39>>*/ return make_invalid_arg
               (counter$9, k, acc, fmt);
      case 7:
        /*<<camlinternalFormat.ml:1623:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1623:39>>*/ return  /*<<camlinternalFormat.ml:1623:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$10 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1623:39>>*/ return make_invalid_arg
               (counter$10, k, acc, fmt);
      case 8:
        /*<<camlinternalFormat.ml:1624:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1624:39>>*/ return  /*<<camlinternalFormat.ml:1624:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$11 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1624:39>>*/ return make_invalid_arg
               (counter$11, k, acc, fmt);
      case 9:
       var fmtty = ign[2];
        /*<<camlinternalFormat.ml:1625:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1625:39>>*/ return  /*<<camlinternalFormat.ml:1625:39>>*/ caml_trampoline_return
                (make_from_fmtty$0, [0, k, acc, fmtty, fmt]);
       var counter$14 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1625:39>>*/ return make_from_fmtty$0
               (counter$14, k, acc, fmtty, fmt);
      case 10:
        /*<<camlinternalFormat.ml:1627:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1627:39>>*/ return  /*<<camlinternalFormat.ml:1627:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$12 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1627:39>>*/ return make_invalid_arg
               (counter$12, k, acc, fmt);
      default:
        /*<<camlinternalFormat.ml:1628:39>>*/ if(counter >= 50)
         /*<<camlinternalFormat.ml:1628:39>>*/ return  /*<<camlinternalFormat.ml:1628:39>>*/ caml_trampoline_return
                (make_invalid_arg, [0, k, acc, fmt]);
       var counter$13 = counter + 1 | 0;
        /*<<camlinternalFormat.ml:1628:39>>*/ return make_invalid_arg
               (counter$13, k, acc, fmt);
    }
    /*<<camlinternalFormat.ml:1629:65>>*/ }
   function make_ignored_param(k, acc, ign, fmt){
     /*<<?>>*/ return caml_trampoline
            (make_ignored_param$0(0, k, acc, ign, fmt));
   }
   function make_from_fmtty$0(counter, k, acc, fmtty, fmt){
     /*<<camlinternalFormat.ml:1637:23>>*/ if(typeof fmtty !== "number")
     switch(fmtty[0]){
       case 0:
        var rest = fmtty[1];
         /*<<camlinternalFormat.ml:1638:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1638:40>>*/ return make_from_fmtty
                 (k, acc, rest, fmt); /*<<camlinternalFormat.ml:1638:70>>*/ };
       case 1:
        var rest$0 = fmtty[1];
         /*<<camlinternalFormat.ml:1639:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1639:40>>*/ return make_from_fmtty
                 (k, acc, rest$0, fmt); /*<<camlinternalFormat.ml:1639:70>>*/ };
       case 2:
        var rest$1 = fmtty[1];
         /*<<camlinternalFormat.ml:1640:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1640:40>>*/ return make_from_fmtty
                 (k, acc, rest$1, fmt); /*<<camlinternalFormat.ml:1640:70>>*/ };
       case 3:
        var rest$2 = fmtty[1];
         /*<<camlinternalFormat.ml:1641:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1641:40>>*/ return make_from_fmtty
                 (k, acc, rest$2, fmt); /*<<camlinternalFormat.ml:1641:70>>*/ };
       case 4:
        var rest$3 = fmtty[1];
         /*<<camlinternalFormat.ml:1642:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1642:40>>*/ return make_from_fmtty
                 (k, acc, rest$3, fmt); /*<<camlinternalFormat.ml:1642:70>>*/ };
       case 5:
        var rest$4 = fmtty[1];
         /*<<camlinternalFormat.ml:1643:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1643:40>>*/ return make_from_fmtty
                 (k, acc, rest$4, fmt); /*<<camlinternalFormat.ml:1643:70>>*/ };
       case 6:
        var rest$5 = fmtty[1];
         /*<<camlinternalFormat.ml:1644:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1644:40>>*/ return make_from_fmtty
                 (k, acc, rest$5, fmt); /*<<camlinternalFormat.ml:1644:70>>*/ };
       case 7:
        var rest$6 = fmtty[1];
         /*<<camlinternalFormat.ml:1645:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1645:40>>*/ return make_from_fmtty
                 (k, acc, rest$6, fmt); /*<<camlinternalFormat.ml:1645:70>>*/ };
       case 8:
        var rest$7 = fmtty[2];
         /*<<camlinternalFormat.ml:1651:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1651:40>>*/ return make_from_fmtty
                 (k, acc, rest$7, fmt); /*<<camlinternalFormat.ml:1651:70>>*/ };
       case 9:
         /*<<camlinternalFormat.ml:1654:13>>*/ var
         rest$8 = fmtty[3],
         ty2 = fmtty[2],
         ty1 = fmtty[1],
          /*<<camlinternalFormat.ml:1654:13>>*/ ty = trans(symm(ty1), ty2);
         /*<<camlinternalFormat.ml:1655:4>>*/ return function(param){
          /*<<camlinternalFormat.ml:1655:13>>*/ return make_from_fmtty
                 (k,
                  acc,
                   /*<<camlinternalFormat.ml:1655:35>>*/ caml_call2
                   (CamlinternalFormatBasics[1], ty, rest$8),
                  fmt); /*<<camlinternalFormat.ml:1655:61>>*/ };
       case 10:
        var rest$9 = fmtty[1];
         /*<<camlinternalFormat.ml:1646:31>>*/ return function(param, _cN_){
          /*<<camlinternalFormat.ml:1646:42>>*/ return make_from_fmtty
                 (k, acc, rest$9, fmt); /*<<camlinternalFormat.ml:1646:72>>*/ };
       case 11:
        var rest$10 = fmtty[1];
         /*<<camlinternalFormat.ml:1647:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1647:40>>*/ return make_from_fmtty
                 (k, acc, rest$10, fmt); /*<<camlinternalFormat.ml:1647:70>>*/ };
       case 12:
        var rest$11 = fmtty[1];
         /*<<camlinternalFormat.ml:1648:31>>*/ return function(param){
          /*<<camlinternalFormat.ml:1648:40>>*/ return make_from_fmtty
                 (k, acc, rest$11, fmt); /*<<camlinternalFormat.ml:1648:70>>*/ };
       case 13:
         /*<<camlinternalFormat.ml:1649:31>>*/ throw  /*<<camlinternalFormat.ml:1649:31>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _u_], 1);
       default:
         /*<<camlinternalFormat.ml:1650:31>>*/ throw  /*<<camlinternalFormat.ml:1650:31>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _v_], 1);
     }
     /*<<camlinternalFormat.ml:1652:31>>*/ if(counter >= 50)
      /*<<camlinternalFormat.ml:1652:31>>*/ return  /*<<camlinternalFormat.ml:1652:31>>*/ caml_trampoline_return
             (make_invalid_arg, [0, k, acc, fmt]);
    var counter$0 = counter + 1 | 0;
     /*<<camlinternalFormat.ml:1652:31>>*/ return make_invalid_arg
            (counter$0, k, acc, fmt);
    /*<<camlinternalFormat.ml:1655:61>>*/ }
   function make_from_fmtty(k, acc, fmtty, fmt){
     /*<<?>>*/ return caml_trampoline
            (make_from_fmtty$0(0, k, acc, fmtty, fmt));
   }
   function make_invalid_arg(counter, k, acc, fmt){
     /*<<camlinternalFormat.ml:1663:2>>*/  /*<<camlinternalFormat.ml:1663:16>>*/ var
     _cM_ = [8, acc, cst_Printf_bad_conversion$0];
     /*<<camlinternalFormat.ml:1663:2>>*/ if(counter >= 50)
      /*<<camlinternalFormat.ml:1663:2>>*/ return  /*<<camlinternalFormat.ml:1663:2>>*/ caml_trampoline_return
             (make_printf$0, [0, k, _cM_, fmt]);
    var counter$0 = counter + 1 | 0;
     /*<<camlinternalFormat.ml:1663:2>>*/ return make_printf$0
            (counter$0, k, _cM_, fmt);
    /*<<camlinternalFormat.ml:1663:72>>*/ }
   function make_padding(k, acc, fmt, pad, trans){
     /*<<camlinternalFormat.ml:1670:29>>*/ if(typeof pad === "number")
      /*<<camlinternalFormat.ml:1672:4>>*/ return function(x){
       /*<<camlinternalFormat.ml:1673:6>>*/  /*<<camlinternalFormat.ml:1673:20>>*/ var
       new_acc =
         [4, acc,  /*<<camlinternalFormat.ml:1673:42>>*/ caml_call1(trans, x)];
       /*<<camlinternalFormat.ml:1674:6>>*/ return make_printf
              (k, new_acc, fmt); /*<<camlinternalFormat.ml:1674:31>>*/ };
    if(0 === pad[0]){
     var width = pad[2], padty = pad[1];
      /*<<camlinternalFormat.ml:1676:4>>*/ return function(x){
       /*<<camlinternalFormat.ml:1677:6>>*/  /*<<camlinternalFormat.ml:1677:20>>*/ var
       new_acc =
         [4,
          acc,
          fix_padding
           (padty,
            width,
             /*<<camlinternalFormat.ml:1677:66>>*/ caml_call1(trans, x))];
       /*<<camlinternalFormat.ml:1678:6>>*/ return make_printf
              (k, new_acc, fmt); /*<<camlinternalFormat.ml:1678:31>>*/ };
    }
    var padty$0 = pad[1];
     /*<<camlinternalFormat.ml:1680:4>>*/ return function(w, x){
      /*<<camlinternalFormat.ml:1681:6>>*/  /*<<camlinternalFormat.ml:1681:20>>*/ var
      new_acc =
        [4,
         acc,
         fix_padding
          (padty$0,
           w,
            /*<<camlinternalFormat.ml:1681:62>>*/ caml_call1(trans, x))];
      /*<<camlinternalFormat.ml:1682:6>>*/ return make_printf(k, new_acc, fmt); /*<<camlinternalFormat.ml:1682:31>>*/ };
    /*<<camlinternalFormat.ml:1682:31>>*/ }
   function make_int_padding_precision(k, acc, fmt, pad, prec, trans, iconv){
     /*<<camlinternalFormat.ml:1691:40>>*/ if(typeof pad === "number"){
     if(typeof prec === "number")
      return prec
              ? function
               (p, x){
                 /*<<camlinternalFormat.ml:1702:6>>*/  /*<<camlinternalFormat.ml:1702:16>>*/ var
                 str =
                   fix_int_precision
                    (p,
                      /*<<camlinternalFormat.ml:1702:36>>*/ caml_call2
                      (trans, iconv, x));
                 /*<<camlinternalFormat.ml:1703:6>>*/ return make_printf
                        (k, [4, acc, str], fmt);
                /*<<camlinternalFormat.ml:1703:52>>*/ }
              : function
               (x){
                 /*<<camlinternalFormat.ml:1694:6>>*/  /*<<camlinternalFormat.ml:1694:16>>*/ var
                 str =
                    /*<<camlinternalFormat.ml:1694:16>>*/ caml_call2
                    (trans, iconv, x);
                 /*<<camlinternalFormat.ml:1695:6>>*/ return make_printf
                        (k, [4, acc, str], fmt);
                /*<<camlinternalFormat.ml:1695:52>>*/ };
     var p = prec[1];
      /*<<camlinternalFormat.ml:1697:4>>*/ return function(x){
       /*<<camlinternalFormat.ml:1698:6>>*/  /*<<camlinternalFormat.ml:1698:16>>*/ var
       str =
         fix_int_precision
          (p,
            /*<<camlinternalFormat.ml:1698:36>>*/ caml_call2(trans, iconv, x));
       /*<<camlinternalFormat.ml:1699:6>>*/ return make_printf
              (k, [4, acc, str], fmt); /*<<camlinternalFormat.ml:1699:52>>*/ };
    }
    if(0 === pad[0]){
     var w = pad[2], padty = pad[1];
     if(typeof prec === "number")
      return prec
              ? function
               (p, x){
                 /*<<camlinternalFormat.ml:1714:6>>*/  /*<<camlinternalFormat.ml:1714:16>>*/ var
                 str =
                   fix_padding
                    (padty,
                     w,
                     fix_int_precision
                      (p,
                        /*<<camlinternalFormat.ml:1714:57>>*/ caml_call2
                        (trans, iconv, x)));
                 /*<<camlinternalFormat.ml:1715:6>>*/ return make_printf
                        (k, [4, acc, str], fmt);
                /*<<camlinternalFormat.ml:1715:52>>*/ }
              : function
               (x){
                 /*<<camlinternalFormat.ml:1706:6>>*/  /*<<camlinternalFormat.ml:1706:16>>*/ var
                 str =
                   fix_padding
                    (padty,
                     w,
                      /*<<camlinternalFormat.ml:1706:36>>*/ caml_call2
                      (trans, iconv, x));
                 /*<<camlinternalFormat.ml:1707:6>>*/ return make_printf
                        (k, [4, acc, str], fmt);
                /*<<camlinternalFormat.ml:1707:52>>*/ };
     var p$0 = prec[1];
      /*<<camlinternalFormat.ml:1709:4>>*/ return function(x){
       /*<<camlinternalFormat.ml:1710:6>>*/  /*<<camlinternalFormat.ml:1710:16>>*/ var
       str =
         fix_padding
          (padty,
           w,
           fix_int_precision
            (p$0,
              /*<<camlinternalFormat.ml:1710:57>>*/ caml_call2
              (trans, iconv, x)));
       /*<<camlinternalFormat.ml:1711:6>>*/ return make_printf
              (k, [4, acc, str], fmt); /*<<camlinternalFormat.ml:1711:52>>*/ };
    }
    var padty$0 = pad[1];
    if(typeof prec === "number")
     return prec
             ? function
              (w, p, x){
                /*<<camlinternalFormat.ml:1726:6>>*/  /*<<camlinternalFormat.ml:1726:16>>*/ var
                str =
                  fix_padding
                   (padty$0,
                    w,
                    fix_int_precision
                     (p,
                       /*<<camlinternalFormat.ml:1726:57>>*/ caml_call2
                       (trans, iconv, x)));
                /*<<camlinternalFormat.ml:1727:6>>*/ return make_printf
                       (k, [4, acc, str], fmt);
               /*<<camlinternalFormat.ml:1727:52>>*/ }
             : function
              (w, x){
                /*<<camlinternalFormat.ml:1718:6>>*/  /*<<camlinternalFormat.ml:1718:16>>*/ var
                str =
                  fix_padding
                   (padty$0,
                    w,
                     /*<<camlinternalFormat.ml:1718:36>>*/ caml_call2
                     (trans, iconv, x));
                /*<<camlinternalFormat.ml:1719:6>>*/ return make_printf
                       (k, [4, acc, str], fmt);
               /*<<camlinternalFormat.ml:1719:52>>*/ };
    var p$1 = prec[1];
     /*<<camlinternalFormat.ml:1721:4>>*/ return function(w, x){
      /*<<camlinternalFormat.ml:1722:6>>*/  /*<<camlinternalFormat.ml:1722:16>>*/ var
      str =
        fix_padding
         (padty$0,
          w,
          fix_int_precision
           (p$1,
             /*<<camlinternalFormat.ml:1722:57>>*/ caml_call2(trans, iconv, x)));
      /*<<camlinternalFormat.ml:1723:6>>*/ return make_printf
             (k, [4, acc, str], fmt); /*<<camlinternalFormat.ml:1723:52>>*/ };
    /*<<camlinternalFormat.ml:1727:52>>*/ }
   function make_custom$0(counter, k, acc, rest, arity, f){
     /*<<camlinternalFormat.ml:1778:28>>*/ if(arity){
     var arity$0 = arity[1];
      /*<<camlinternalFormat.ml:1781:4>>*/ return function(x){
       /*<<camlinternalFormat.ml:1782:6>>*/ return make_custom
              (k,
               acc,
               rest,
               arity$0,
                /*<<camlinternalFormat.ml:1782:35>>*/ caml_call1(f, x)); /*<<camlinternalFormat.ml:1782:40>>*/ };
    }
     /*<<camlinternalFormat.ml:1779:33>>*/  /*<<camlinternalFormat.ml:1779:33>>*/ var
     _cL_ = [4, acc, f];
     /*<<camlinternalFormat.ml:1779:19>>*/ if(counter >= 50)
      /*<<camlinternalFormat.ml:1779:19>>*/ return  /*<<camlinternalFormat.ml:1779:19>>*/ caml_trampoline_return
             (make_printf$0, [0, k, _cL_, rest]);
    var counter$0 = counter + 1 | 0;
     /*<<camlinternalFormat.ml:1779:19>>*/ return make_printf$0
            (counter$0, k, _cL_, rest);
    /*<<camlinternalFormat.ml:1782:40>>*/ }
   function make_custom(k, acc, rest, arity, f){
     /*<<?>>*/ return caml_trampoline
            (make_custom$0(0, k, acc, rest, arity, f));
   }
   function make_iprintf$0(counter, k, o, fmt){
     /*<<camlinternalFormat.ml:1788:17>>*/ var k$0 = k, fmt$0 = fmt;
     /*<<camlinternalFormat.ml:1788:17>>*/ for(;;){
     if(typeof fmt$0 === "number")
       /*<<camlinternalFormat.ml:1858:8>>*/ return  /*<<camlinternalFormat.ml:1858:8>>*/ caml_call1
              (k$0, o);
     switch(fmt$0[0]){
       case 0:
        var
         rest = fmt$0[1],
          /*<<camlinternalFormat.ml:1790:14>>*/ _b2_ =
           make_iprintf(k$0, o, rest);
         /*<<camlinternalFormat.ml:1790:14>>*/ return function(_cK_){
          /*<<?>>*/ return _b2_;};
       case 1:
        var
         rest$0 = fmt$0[1],
          /*<<camlinternalFormat.ml:1792:14>>*/ _b3_ =
           make_iprintf(k$0, o, rest$0);
         /*<<camlinternalFormat.ml:1792:14>>*/ return function(_cJ_){
          /*<<?>>*/ return _b3_;};
       case 2:
        var _b4_ = fmt$0[1];
        if(typeof _b4_ === "number"){
         var
          rest$1 = fmt$0[2],
           /*<<camlinternalFormat.ml:1794:14>>*/ _b5_ =
            make_iprintf(k$0, o, rest$1);
          /*<<camlinternalFormat.ml:1794:14>>*/ return function(_cI_){
           /*<<?>>*/ return _b5_;};
        }
        if(0 === _b4_[0]){
         var
          rest$2 = fmt$0[2],
           /*<<camlinternalFormat.ml:1796:14>>*/ _b6_ =
            make_iprintf(k$0, o, rest$2);
          /*<<camlinternalFormat.ml:1796:14>>*/ return function(_cH_){
           /*<<?>>*/ return _b6_;};
        }
         /*<<camlinternalFormat.ml:1798:14>>*/ var
         rest$3 = fmt$0[2],
          /*<<camlinternalFormat.ml:1798:21>>*/ _b7_ =
           make_iprintf(k$0, o, rest$3),
          /*<<camlinternalFormat.ml:1798:14>>*/ _b8_ =
           function(_cG_){ /*<<?>>*/ return _b7_;};
         /*<<camlinternalFormat.ml:1798:14>>*/ return function(_cF_){
          /*<<?>>*/ return _b8_;};
       case 3:
        var _b9_ = fmt$0[1];
        if(typeof _b9_ === "number"){
         var
          rest$4 = fmt$0[2],
           /*<<camlinternalFormat.ml:1800:14>>*/ _b__ =
            make_iprintf(k$0, o, rest$4);
          /*<<camlinternalFormat.ml:1800:14>>*/ return function(_cE_){
           /*<<?>>*/ return _b__;};
        }
        if(0 === _b9_[0]){
         var
          rest$5 = fmt$0[2],
           /*<<camlinternalFormat.ml:1802:14>>*/ _b$_ =
            make_iprintf(k$0, o, rest$5);
          /*<<camlinternalFormat.ml:1802:14>>*/ return function(_cD_){
           /*<<?>>*/ return _b$_;};
        }
         /*<<camlinternalFormat.ml:1804:14>>*/ var
         rest$6 = fmt$0[2],
          /*<<camlinternalFormat.ml:1804:21>>*/ _ca_ =
           make_iprintf(k$0, o, rest$6),
          /*<<camlinternalFormat.ml:1804:14>>*/ _cb_ =
           function(_cC_){ /*<<?>>*/ return _ca_;};
         /*<<camlinternalFormat.ml:1804:14>>*/ return function(_cB_){
          /*<<?>>*/ return _cb_;};
       case 4:
        var rest$7 = fmt$0[4], prec = fmt$0[3], pad = fmt$0[2];
         /*<<camlinternalFormat.ml:1806:8>>*/ return fn_of_padding_precision
                (k$0, o, rest$7, pad, prec);
       case 5:
        var rest$8 = fmt$0[4], prec$0 = fmt$0[3], pad$0 = fmt$0[2];
         /*<<camlinternalFormat.ml:1808:8>>*/ return fn_of_padding_precision
                (k$0, o, rest$8, pad$0, prec$0);
       case 6:
        var rest$9 = fmt$0[4], prec$1 = fmt$0[3], pad$1 = fmt$0[2];
         /*<<camlinternalFormat.ml:1810:8>>*/ return fn_of_padding_precision
                (k$0, o, rest$9, pad$1, prec$1);
       case 7:
        var rest$10 = fmt$0[4], prec$2 = fmt$0[3], pad$2 = fmt$0[2];
         /*<<camlinternalFormat.ml:1812:8>>*/ return fn_of_padding_precision
                (k$0, o, rest$10, pad$2, prec$2);
       case 8:
        var rest$11 = fmt$0[4], prec$3 = fmt$0[3], pad$3 = fmt$0[2];
         /*<<camlinternalFormat.ml:1814:8>>*/ return fn_of_padding_precision
                (k$0, o, rest$11, pad$3, prec$3);
       case 9:
        var _cc_ = fmt$0[1];
        if(typeof _cc_ === "number"){
         var
          rest$12 = fmt$0[2],
           /*<<camlinternalFormat.ml:1816:14>>*/ _cd_ =
            make_iprintf(k$0, o, rest$12);
          /*<<camlinternalFormat.ml:1816:14>>*/ return function(_cA_){
           /*<<?>>*/ return _cd_;};
        }
        if(0 === _cc_[0]){
         var
          rest$13 = fmt$0[2],
           /*<<camlinternalFormat.ml:1818:14>>*/ _ce_ =
            make_iprintf(k$0, o, rest$13);
          /*<<camlinternalFormat.ml:1818:14>>*/ return function(_cz_){
           /*<<?>>*/ return _ce_;};
        }
         /*<<camlinternalFormat.ml:1820:14>>*/ var
         rest$14 = fmt$0[2],
          /*<<camlinternalFormat.ml:1820:21>>*/ _cf_ =
           make_iprintf(k$0, o, rest$14),
          /*<<camlinternalFormat.ml:1820:14>>*/ _cg_ =
           function(_cy_){ /*<<?>>*/ return _cf_;};
         /*<<camlinternalFormat.ml:1820:14>>*/ return function(_cx_){
          /*<<?>>*/ return _cg_;};
       case 10:
        var rest$15 = fmt$0[1], fmt$0 = rest$15; break;
       case 11:
        var rest$16 = fmt$0[2], fmt$0 = rest$16; break;
       case 12:
        var rest$17 = fmt$0[2], fmt$0 = rest$17; break;
       case 13:
        var
         rest$18 = fmt$0[3],
          /*<<camlinternalFormat.ml:1838:14>>*/ _ch_ =
           make_iprintf(k$0, o, rest$18);
         /*<<camlinternalFormat.ml:1838:14>>*/ return function(_cw_){
          /*<<?>>*/ return _ch_;};
       case 14:
        var rest$19 = fmt$0[3], fmtty = fmt$0[2];
         /*<<camlinternalFormat.ml:1840:8>>*/ return function(param){
          /*<<camlinternalFormat.ml:1840:8>>*/ var
          fmt = param[1],
           /*<<camlinternalFormat.ml:1842:24>>*/ _cv_ = recast(fmt, fmtty);
          /*<<camlinternalFormat.ml:1842:12>>*/ return make_iprintf
                 (k$0,
                  o,
                   /*<<camlinternalFormat.ml:1842:12>>*/ caml_call2
                   (CamlinternalFormatBasics[3], _cv_, rest$19)); /*<<camlinternalFormat.ml:1842:48>>*/ };
       case 15:
         /*<<camlinternalFormat.ml:1822:14>>*/ var
         rest$20 = fmt$0[1],
          /*<<camlinternalFormat.ml:1822:21>>*/ _ci_ =
           make_iprintf(k$0, o, rest$20),
          /*<<camlinternalFormat.ml:1822:14>>*/ _cj_ =
           function(_cu_){ /*<<?>>*/ return _ci_;};
         /*<<camlinternalFormat.ml:1822:14>>*/ return function(_ct_){
          /*<<?>>*/ return _cj_;};
       case 16:
        var
         rest$21 = fmt$0[1],
          /*<<camlinternalFormat.ml:1824:14>>*/ _ck_ =
           make_iprintf(k$0, o, rest$21);
         /*<<camlinternalFormat.ml:1824:14>>*/ return function(_cs_){
          /*<<?>>*/ return _ck_;};
       case 17:
        var rest$22 = fmt$0[2], fmt$0 = rest$22; break;
       case 18:
        var _cl_ = fmt$0[1];
        if(0 === _cl_[0]){
         var rest$23 = fmt$0[2], fmt$1 = _cl_[1][1];
         let k = k$0, rest = rest$23;
         var
          k$1 =
            function(koc){
              /*<<camlinternalFormat.ml:1854:33>>*/ return make_iprintf
                     (k, koc, rest);
             /*<<camlinternalFormat.ml:1854:56>>*/ },
          k$0 = k$1,
          fmt$0 = fmt$1;
        }
        else{
         var rest$24 = fmt$0[2], fmt$2 = _cl_[1][1];
         let k = k$0, rest = rest$24;
         var
          k$2 =
            function(koc){
              /*<<camlinternalFormat.ml:1856:33>>*/ return make_iprintf
                     (k, koc, rest);
             /*<<camlinternalFormat.ml:1856:56>>*/ },
          k$0 = k$2,
          fmt$0 = fmt$2;
        }
        break;
       case 19:
         /*<<camlinternalFormat.ml:1830:8>>*/ throw  /*<<camlinternalFormat.ml:1830:8>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _w_], 1);
       case 20:
        var
         rest$25 = fmt$0[3],
          /*<<camlinternalFormat.ml:1844:14>>*/ _cm_ =
           make_iprintf(k$0, o, rest$25);
         /*<<camlinternalFormat.ml:1844:14>>*/ return function(_cr_){
          /*<<?>>*/ return _cm_;};
       case 21:
        var
         rest$26 = fmt$0[2],
          /*<<camlinternalFormat.ml:1846:14>>*/ _cn_ =
           make_iprintf(k$0, o, rest$26);
         /*<<camlinternalFormat.ml:1846:14>>*/ return function(_cq_){
          /*<<?>>*/ return _cn_;};
       case 22:
        var
         rest$27 = fmt$0[1],
          /*<<camlinternalFormat.ml:1848:14>>*/ _co_ =
           make_iprintf(k$0, o, rest$27);
         /*<<camlinternalFormat.ml:1848:14>>*/ return function(_cp_){
          /*<<?>>*/ return _co_;};
       case 23:
        var rest$28 = fmt$0[2], ign = fmt$0[1];
         /*<<camlinternalFormat.ml:1850:8>>*/ return make_ignored_param
                (function(param){
                   /*<<camlinternalFormat.ml:1850:37>>*/ return caml_call1
                          (k$0, o);
                  /*<<camlinternalFormat.ml:1850:40>>*/ },
                 0,
                 ign,
                 rest$28);
       default:
        var rest$29 = fmt$0[3], arity = fmt$0[1];
         /*<<camlinternalFormat.ml:1826:8>>*/ if(counter >= 50)
          /*<<camlinternalFormat.ml:1826:8>>*/ return  /*<<camlinternalFormat.ml:1826:8>>*/ caml_trampoline_return
                 (fn_of_custom_arity$0, [0, k$0, o, rest$29, arity]);
        var counter$0 = counter + 1 | 0;
         /*<<camlinternalFormat.ml:1826:8>>*/ return fn_of_custom_arity$0
                (counter$0, k$0, o, rest$29, arity);
     }
    }
    /*<<camlinternalFormat.ml:1858:11>>*/ }
   function make_iprintf(k, o, fmt){
     /*<<?>>*/ return caml_trampoline(make_iprintf$0(0, k, o, fmt));
   }
   function fn_of_padding_precision(k, o, fmt, pad, prec){
     /*<<camlinternalFormat.ml:1863:26>>*/ if(typeof pad === "number"){
     if(typeof prec !== "number"){
       /*<<camlinternalFormat.ml:1867:14>>*/ var
       _bB_ = make_iprintf(k, o, fmt);
       /*<<camlinternalFormat.ml:1867:14>>*/ return function(_b1_){
        /*<<?>>*/ return _bB_;};
     }
     if(prec){
       /*<<camlinternalFormat.ml:1869:14>>*/ var
        /*<<camlinternalFormat.ml:1869:21>>*/ _by_ = make_iprintf(k, o, fmt),
        /*<<camlinternalFormat.ml:1869:14>>*/ _bz_ =
         function(_b0_){ /*<<?>>*/ return _by_;};
       /*<<camlinternalFormat.ml:1869:14>>*/ return function(_bZ_){
        /*<<?>>*/ return _bz_;};
     }
      /*<<camlinternalFormat.ml:1865:14>>*/ var
      _bA_ = make_iprintf(k, o, fmt);
      /*<<camlinternalFormat.ml:1865:14>>*/ return function(_bY_){
       /*<<?>>*/ return _bA_;};
    }
    if(0 === pad[0]){
     if(typeof prec !== "number"){
       /*<<camlinternalFormat.ml:1873:14>>*/ var
       _bF_ = make_iprintf(k, o, fmt);
       /*<<camlinternalFormat.ml:1873:14>>*/ return function(_bX_){
        /*<<?>>*/ return _bF_;};
     }
     if(prec){
       /*<<camlinternalFormat.ml:1875:14>>*/ var
        /*<<camlinternalFormat.ml:1875:21>>*/ _bC_ = make_iprintf(k, o, fmt),
        /*<<camlinternalFormat.ml:1875:14>>*/ _bD_ =
         function(_bW_){ /*<<?>>*/ return _bC_;};
       /*<<camlinternalFormat.ml:1875:14>>*/ return function(_bV_){
        /*<<?>>*/ return _bD_;};
     }
      /*<<camlinternalFormat.ml:1871:14>>*/ var
      _bE_ = make_iprintf(k, o, fmt);
      /*<<camlinternalFormat.ml:1871:14>>*/ return function(_bU_){
       /*<<?>>*/ return _bE_;};
    }
    if(typeof prec !== "number"){
      /*<<camlinternalFormat.ml:1879:14>>*/ var
       /*<<camlinternalFormat.ml:1879:21>>*/ _bL_ = make_iprintf(k, o, fmt),
       /*<<camlinternalFormat.ml:1879:14>>*/ _bM_ =
        function(_bT_){ /*<<?>>*/ return _bL_;};
      /*<<camlinternalFormat.ml:1879:14>>*/ return function(_bS_){
       /*<<?>>*/ return _bM_;};
    }
    if(prec){
      /*<<camlinternalFormat.ml:1881:21>>*/ var
       /*<<camlinternalFormat.ml:1881:28>>*/ _bG_ = make_iprintf(k, o, fmt),
       /*<<camlinternalFormat.ml:1881:21>>*/ _bH_ =
        function(_bR_){ /*<<?>>*/ return _bG_;},
       /*<<camlinternalFormat.ml:1881:14>>*/ _bI_ =
        function(_bQ_){ /*<<?>>*/ return _bH_;};
      /*<<camlinternalFormat.ml:1881:14>>*/ return function(_bP_){
       /*<<?>>*/ return _bI_;};
    }
     /*<<camlinternalFormat.ml:1877:21>>*/ var _bJ_ = make_iprintf(k, o, fmt);
     /*<<camlinternalFormat.ml:1877:14>>*/ function _bK_(_bO_){
      /*<<?>>*/ return _bJ_;
    }
     /*<<camlinternalFormat.ml:1877:14>>*/ return function(_bN_){
      /*<<?>>*/ return _bK_;};
    /*<<camlinternalFormat.ml:1881:52>>*/ }
   function fn_of_custom_arity$0(counter, k, o, fmt, param){
     /*<<?>>*/ if(param){
     var
      arity = param[1],
       /*<<camlinternalFormat.ml:1889:14>>*/ _bw_ =
        fn_of_custom_arity(k, o, fmt, arity);
      /*<<camlinternalFormat.ml:1889:14>>*/ return function(_bx_){
       /*<<?>>*/ return _bw_;};
    }
     /*<<camlinternalFormat.ml:1887:8>>*/ if(counter >= 50)
      /*<<camlinternalFormat.ml:1887:8>>*/ return  /*<<camlinternalFormat.ml:1887:8>>*/ caml_trampoline_return
             (make_iprintf$0, [0, k, o, fmt]);
    var counter$0 = counter + 1 | 0;
     /*<<camlinternalFormat.ml:1887:8>>*/ return make_iprintf$0
            (counter$0, k, o, fmt);
   }
   function fn_of_custom_arity(k, o, fmt, param){
     /*<<?>>*/ return caml_trampoline
            (fn_of_custom_arity$0(0, k, o, fmt, param));
   }
   function output_acc(o, acc){
     /*<<camlinternalFormat.ml:1897:27>>*/ var acc$0 = acc;
     /*<<camlinternalFormat.ml:1897:27>>*/ for(;;){
     if(typeof acc$0 === "number")
       /*<<camlinternalFormat.ml:1912:32>>*/ return 0;
     switch(acc$0[0]){
       case 0:
         /*<<camlinternalFormat.ml:1899:12>>*/ var
         fmting_lit = acc$0[2],
         p = acc$0[1],
          /*<<camlinternalFormat.ml:1899:12>>*/ s =
           string_of_formatting_lit(fmting_lit);
         /*<<camlinternalFormat.ml:1900:4>>*/ output_acc(o, p);
         /*<<camlinternalFormat.ml:1900:4>>*/ return  /*<<camlinternalFormat.ml:1900:4>>*/ caml_call2
                (Stdlib[66], o, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
          /*<<camlinternalFormat.ml:1902:4>>*/ output_acc(o, p$0);
          /*<<camlinternalFormat.ml:1902:20>>*/  /*<<camlinternalFormat.ml:1902:20>>*/ caml_call2
          (Stdlib[66], o, cst$18);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
          /*<<camlinternalFormat.ml:1904:4>>*/ output_acc(o, p$0);
          /*<<camlinternalFormat.ml:1904:20>>*/  /*<<camlinternalFormat.ml:1904:20>>*/ caml_call2
          (Stdlib[66], o, cst$19);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
         /*<<camlinternalFormat.ml:1909:32>>*/ output_acc(o, p$3);
         /*<<camlinternalFormat.ml:1909:32>>*/ return  /*<<camlinternalFormat.ml:1909:32>>*/ caml_call1
                (f, o);
       case 7:
        var p$4 = acc$0[1];
         /*<<camlinternalFormat.ml:1910:32>>*/ output_acc(o, p$4);
         /*<<camlinternalFormat.ml:1910:32>>*/ return  /*<<camlinternalFormat.ml:1910:32>>*/ caml_call1
                (Stdlib[63], o);
       case 8:
        var msg = acc$0[2], p$5 = acc$0[1];
         /*<<camlinternalFormat.ml:1911:32>>*/ output_acc(o, p$5);
         /*<<camlinternalFormat.ml:1911:32>>*/ return  /*<<camlinternalFormat.ml:1911:32>>*/ caml_call1
                (Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
         /*<<camlinternalFormat.ml:1906:32>>*/ output_acc(o, p$1);
         /*<<camlinternalFormat.ml:1906:32>>*/ return  /*<<camlinternalFormat.ml:1906:32>>*/ caml_call2
                (Stdlib[66], o, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
         /*<<camlinternalFormat.ml:1908:32>>*/ output_acc(o, p$2);
         /*<<camlinternalFormat.ml:1908:32>>*/ return  /*<<camlinternalFormat.ml:1908:32>>*/ caml_call2
                (Stdlib[65], o, c);
     }
    }
    /*<<camlinternalFormat.ml:1912:34>>*/ }
   function bufput_acc(b, acc){
     /*<<camlinternalFormat.ml:1917:27>>*/ var acc$0 = acc;
     /*<<camlinternalFormat.ml:1917:27>>*/ for(;;){
     if(typeof acc$0 === "number")
       /*<<camlinternalFormat.ml:1932:32>>*/ return 0;
     switch(acc$0[0]){
       case 0:
         /*<<camlinternalFormat.ml:1919:12>>*/ var
         fmting_lit = acc$0[2],
         p = acc$0[1],
          /*<<camlinternalFormat.ml:1919:12>>*/ s =
           string_of_formatting_lit(fmting_lit);
         /*<<camlinternalFormat.ml:1920:4>>*/ bufput_acc(b, p);
         /*<<camlinternalFormat.ml:1920:4>>*/ return  /*<<camlinternalFormat.ml:1920:4>>*/ caml_call2
                (Stdlib_Buffer[16], b, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
          /*<<camlinternalFormat.ml:1922:4>>*/ bufput_acc(b, p$0);
          /*<<camlinternalFormat.ml:1922:20>>*/  /*<<camlinternalFormat.ml:1922:20>>*/ caml_call2
          (Stdlib_Buffer[16], b, cst$20);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
          /*<<camlinternalFormat.ml:1924:4>>*/ bufput_acc(b, p$0);
          /*<<camlinternalFormat.ml:1924:20>>*/  /*<<camlinternalFormat.ml:1924:20>>*/ caml_call2
          (Stdlib_Buffer[16], b, cst$21);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
         /*<<camlinternalFormat.ml:1929:32>>*/ bufput_acc(b, p$3);
         /*<<camlinternalFormat.ml:1929:32>>*/ return  /*<<camlinternalFormat.ml:1929:32>>*/ caml_call1
                (f, b);
       case 7:
        var acc$3 = acc$0[1], acc$0 = acc$3; break;
       case 8:
        var msg = acc$0[2], p$4 = acc$0[1];
         /*<<camlinternalFormat.ml:1931:32>>*/ bufput_acc(b, p$4);
         /*<<camlinternalFormat.ml:1931:32>>*/ return  /*<<camlinternalFormat.ml:1931:32>>*/ caml_call1
                (Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
         /*<<camlinternalFormat.ml:1926:32>>*/ bufput_acc(b, p$1);
         /*<<camlinternalFormat.ml:1926:32>>*/ return  /*<<camlinternalFormat.ml:1926:32>>*/ caml_call2
                (Stdlib_Buffer[16], b, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
         /*<<camlinternalFormat.ml:1928:32>>*/ bufput_acc(b, p$2);
         /*<<camlinternalFormat.ml:1928:32>>*/ return  /*<<camlinternalFormat.ml:1928:32>>*/ caml_call2
                (Stdlib_Buffer[12], b, c);
     }
    }
    /*<<camlinternalFormat.ml:1932:34>>*/ }
   function strput_acc(b, acc){
     /*<<camlinternalFormat.ml:1938:27>>*/ var acc$0 = acc;
     /*<<camlinternalFormat.ml:1938:27>>*/ for(;;){
     if(typeof acc$0 === "number")
       /*<<camlinternalFormat.ml:1953:32>>*/ return 0;
     switch(acc$0[0]){
       case 0:
         /*<<camlinternalFormat.ml:1940:12>>*/ var
         fmting_lit = acc$0[2],
         p = acc$0[1],
          /*<<camlinternalFormat.ml:1940:12>>*/ s =
           string_of_formatting_lit(fmting_lit);
         /*<<camlinternalFormat.ml:1941:4>>*/ strput_acc(b, p);
         /*<<camlinternalFormat.ml:1941:4>>*/ return  /*<<camlinternalFormat.ml:1941:4>>*/ caml_call2
                (Stdlib_Buffer[16], b, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
          /*<<camlinternalFormat.ml:1943:4>>*/ strput_acc(b, p$0);
          /*<<camlinternalFormat.ml:1943:20>>*/  /*<<camlinternalFormat.ml:1943:20>>*/ caml_call2
          (Stdlib_Buffer[16], b, cst$22);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
          /*<<camlinternalFormat.ml:1945:4>>*/ strput_acc(b, p$0);
          /*<<camlinternalFormat.ml:1945:20>>*/  /*<<camlinternalFormat.ml:1945:20>>*/ caml_call2
          (Stdlib_Buffer[16], b, cst$23);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
         /*<<camlinternalFormat.ml:1950:32>>*/ strput_acc(b, p$3);
         /*<<camlinternalFormat.ml:1950:68>>*/  /*<<camlinternalFormat.ml:1950:68>>*/ var
         _bv_ =  /*<<camlinternalFormat.ml:1950:68>>*/ caml_call1(f, 0);
         /*<<camlinternalFormat.ml:1950:68>>*/ return  /*<<camlinternalFormat.ml:1950:68>>*/ caml_call2
                (Stdlib_Buffer[16], b, _bv_);
       case 7:
        var acc$3 = acc$0[1], acc$0 = acc$3; break;
       case 8:
        var msg = acc$0[2], p$4 = acc$0[1];
         /*<<camlinternalFormat.ml:1952:32>>*/ strput_acc(b, p$4);
         /*<<camlinternalFormat.ml:1952:32>>*/ return  /*<<camlinternalFormat.ml:1952:32>>*/ caml_call1
                (Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
         /*<<camlinternalFormat.ml:1947:32>>*/ strput_acc(b, p$1);
         /*<<camlinternalFormat.ml:1947:32>>*/ return  /*<<camlinternalFormat.ml:1947:32>>*/ caml_call2
                (Stdlib_Buffer[16], b, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
         /*<<camlinternalFormat.ml:1949:32>>*/ strput_acc(b, p$2);
         /*<<camlinternalFormat.ml:1949:32>>*/ return  /*<<camlinternalFormat.ml:1949:32>>*/ caml_call2
                (Stdlib_Buffer[12], b, c);
     }
    }
    /*<<camlinternalFormat.ml:1953:34>>*/ }
   function failwith_message(param){
     /*<<camlinternalFormat.ml:1960:12>>*/ var
     fmt = param[1],
      /*<<camlinternalFormat.ml:1960:12>>*/ buf =
        /*<<camlinternalFormat.ml:1960:12>>*/ caml_call1
        (Stdlib_Buffer[1], 256);
    function k(acc){
      /*<<camlinternalFormat.ml:1961:14>>*/ strput_acc(buf, acc);
      /*<<camlinternalFormat.ml:1961:43>>*/  /*<<camlinternalFormat.ml:1961:43>>*/ var
      _bu_ =
         /*<<camlinternalFormat.ml:1961:43>>*/ caml_call1
         (Stdlib_Buffer[2], buf);
      /*<<camlinternalFormat.ml:1961:43>>*/ return  /*<<camlinternalFormat.ml:1961:43>>*/ caml_call1
             (Stdlib[2], _bu_);
     /*<<camlinternalFormat.ml:1961:64>>*/ }
     /*<<camlinternalFormat.ml:1962:2>>*/ return make_printf(k, 0, fmt);
   }
   function open_box_of_string(str){
     /*<<camlinternalFormat.ml:1969:2>>*/ if
     ( /*<<camlinternalFormat.ml:1969:5>>*/ runtime.caml_string_equal
       (str, cst$43))
      /*<<camlinternalFormat.ml:1969:19>>*/ return _x_;
    var len = caml_ml_string_length(str);
    function invalid_box(param){
      /*<<camlinternalFormat.ml:1971:25>>*/ return  /*<<camlinternalFormat.ml:1971:4>>*/ caml_call1
             (failwith_message(_y_), str);
     /*<<camlinternalFormat.ml:1971:74>>*/ }
    function parse_spaces(i){
      /*<<camlinternalFormat.ml:1973:6>>*/ var i$0 = i;
      /*<<camlinternalFormat.ml:1973:6>>*/ for(;;){
      if(i$0 === len)  /*<<camlinternalFormat.ml:1973:22>>*/ return i$0;
       /*<<camlinternalFormat.ml:1974:14>>*/  /*<<camlinternalFormat.ml:1974:14>>*/ var
       match =
          /*<<camlinternalFormat.ml:1974:14>>*/ caml_string_get(str, i$0);
      if(9 !== match && 32 !== match)
        /*<<camlinternalFormat.ml:1976:15>>*/ return i$0;
       /*<<camlinternalFormat.ml:1975:24>>*/ var
        /*<<camlinternalFormat.ml:1975:24>>*/ i$1 = i$0 + 1 | 0,
       i$0 = i$1;
     }
     /*<<camlinternalFormat.ml:1976:16>>*/ }
     /*<<camlinternalFormat.ml:1987:17>>*/  /*<<camlinternalFormat.ml:1987:17>>*/ var
     wstart = parse_spaces(0);
    a:
    b:
    {
     var wend = wstart;
      /*<<camlinternalFormat.ml:1978:6>>*/ for(;;){
      if(wend === len) break b;
      if
       (25
        <
          /*<<camlinternalFormat.ml:1979:14>>*/ caml_string_get(str, wend)
         - 97
         >>> 0)
       break;
       /*<<camlinternalFormat.ml:1980:24>>*/ var
        /*<<camlinternalFormat.ml:1980:24>>*/ j = wend + 1 | 0,
       wend = j;
     }
     break a;
    }
     /*<<camlinternalFormat.ml:1989:19>>*/ var
      /*<<camlinternalFormat.ml:1989:19>>*/ box_name =
        /*<<camlinternalFormat.ml:1989:19>>*/ caml_call3
        (Stdlib_String[16], str, wstart, wend - wstart | 0),
      /*<<camlinternalFormat.ml:1990:17>>*/ nstart = parse_spaces(wend);
    a:
    b:
    {
     var nend = nstart;
      /*<<camlinternalFormat.ml:1983:6>>*/ for(;;){
      if(nend === len) break b;
       /*<<camlinternalFormat.ml:1984:14>>*/  /*<<camlinternalFormat.ml:1984:14>>*/ var
       match =
          /*<<camlinternalFormat.ml:1984:14>>*/ caml_string_get(str, nend);
      if(48 <= match){if(58 <= match) break;} else if(45 !== match) break;
       /*<<camlinternalFormat.ml:1985:30>>*/ var
        /*<<camlinternalFormat.ml:1985:30>>*/ j$0 = nend + 1 | 0,
       nend = j$0;
     }
     break a;
    }
    if(nstart === nend)
     var indent = 0;
    else
      /*<<camlinternalFormat.ml:1994:8>>*/ try{
       /*<<camlinternalFormat.ml:1994:12>>*/ var
        /*<<camlinternalFormat.ml:1994:12>>*/ _bs_ =
          /*<<camlinternalFormat.ml:1994:12>>*/ runtime.caml_int_of_string
          ( /*<<camlinternalFormat.ml:1994:26>>*/ caml_call3
            (Stdlib_String[16], str, nstart, nend - nstart | 0)),
       indent = _bs_;
     }
     catch(_bt_){
      var _br_ = caml_wrap_exception(_bt_);
      if(_br_[1] !== Stdlib[7]) throw caml_maybe_attach_backtrace(_br_, 0);
      var indent = invalid_box(0);
     }
     /*<<camlinternalFormat.ml:1996:18>>*/  /*<<camlinternalFormat.ml:1996:18>>*/ var
     exp_end = parse_spaces(nend);
    if(exp_end !== len)  /*<<camlinternalFormat.ml:1997:27>>*/ invalid_box(0);
    a:
    {
     if
      (caml_string_notequal(box_name, cst$43)
       && caml_string_notequal(box_name, "b")){
      if(! caml_string_notequal(box_name, "h")){var box_type = 0; break a;}
      if(! caml_string_notequal(box_name, "hov")){var box_type = 3; break a;}
      if(! caml_string_notequal(box_name, "hv")){var box_type = 2; break a;}
      if(caml_string_notequal(box_name, "v")){
       var box_type = invalid_box(0);
       break a;
      }
      var box_type = 1;
      break a;
     }
     var box_type = 4;
    }
     /*<<camlinternalFormat.ml:2005:4>>*/ return [0, indent, box_type];
    /*<<camlinternalFormat.ml:2005:22>>*/ }
   function make_padding_fmt_ebb(pad, fmt){
     /*<<camlinternalFormat.ml:2015:15>>*/ if(typeof pad === "number")
      /*<<camlinternalFormat.ml:2016:26>>*/ return [0, 0, fmt];
    if(0 === pad[0]){
     var w = pad[2], s = pad[1];
      /*<<camlinternalFormat.ml:2017:26>>*/ return [0, [0, s, w], fmt];
    }
    var s$0 = pad[1];
     /*<<camlinternalFormat.ml:2018:26>>*/ return [0, [1, s$0], fmt];
    /*<<camlinternalFormat.ml:2018:62>>*/ }
   function make_padprec_fmt_ebb(pad, prec, fmt){
     /*<<camlinternalFormat.ml:2038:2>>*/ if(typeof prec === "number")
     var match = prec ? [0, 1] : [0, 0];
    else
     var p = prec[1], match = [0, [0, p]];
    var prec$0 = match[1];
     /*<<camlinternalFormat.ml:2039:2>>*/ if(typeof pad === "number")
      /*<<camlinternalFormat.ml:2040:26>>*/ return [0, 0, prec$0, fmt];
     /*<<camlinternalFormat.ml:2039:2>>*/ if(0 === pad[0]){
     var w = pad[2], s = pad[1];
      /*<<camlinternalFormat.ml:2041:26>>*/ return [0, [0, s, w], prec$0, fmt];
    }
    var s$0 = pad[1];
     /*<<camlinternalFormat.ml:2042:26>>*/ return [0, [1, s$0], prec$0, fmt];
    /*<<camlinternalFormat.ml:2042:69>>*/ }
   function fmt_ebb_of_string(legacy_behavior, str){
     /*<<?>>*/ if(legacy_behavior)
     var flag = legacy_behavior[1], legacy_behavior$0 = flag;
    else
     var legacy_behavior$0 = 1;
    function invalid_format_message(str_ind, msg){
      /*<<camlinternalFormat.ml:2084:4>>*/ return  /*<<camlinternalFormat.ml:2084:4>>*/ caml_call3
             (failwith_message(_z_), str, str_ind, msg);
     /*<<camlinternalFormat.ml:2086:21>>*/ }
     /*<<camlinternalFormat.ml:2091:2>>*/ function unexpected_end_of_format
    (end_ind){
      /*<<camlinternalFormat.ml:2092:4>>*/ return invalid_format_message
             (end_ind, cst_unexpected_end_of_format);
     /*<<camlinternalFormat.ml:2093:32>>*/ }
    function invalid_format_without(str_ind, c, s){
      /*<<camlinternalFormat.ml:2104:4>>*/ return  /*<<camlinternalFormat.ml:2104:4>>*/ caml_call4
             (failwith_message(_A_), str, str_ind, c, s);
     /*<<camlinternalFormat.ml:2106:21>>*/ }
    function expected_character(str_ind, expected, read){
      /*<<camlinternalFormat.ml:2112:4>>*/ return  /*<<camlinternalFormat.ml:2112:4>>*/ caml_call4
             (failwith_message(_B_), str, str_ind, expected, read);
     /*<<camlinternalFormat.ml:2114:31>>*/ }
    function parse(lit_start, end_ind){
      /*<<camlinternalFormat.ml:2119:25>>*/ a:
     {
      var str_ind = lit_start;
       /*<<camlinternalFormat.ml:2124:4>>*/ for(;;){
       if(str_ind === end_ind)
         /*<<camlinternalFormat.ml:2124:30>>*/ return add_literal
                (lit_start, str_ind, 0);
        /*<<camlinternalFormat.ml:2125:12>>*/  /*<<camlinternalFormat.ml:2125:12>>*/ var
        match =
           /*<<camlinternalFormat.ml:2125:12>>*/ caml_string_get(str, str_ind);
       if(37 === match) break;
       if(64 === match) break a;
       var str_ind$1 = str_ind + 1 | 0, str_ind = str_ind$1;
      }
      var str_ind$2 = str_ind + 1 | 0;
      if(str_ind$2 === end_ind)
        /*<<camlinternalFormat.ml:2141:30>>*/ unexpected_end_of_format
        (end_ind);
      var
       match$1 =
         95
          ===
            /*<<camlinternalFormat.ml:2142:10>>*/ caml_string_get
            (str, str_ind$2)
          ? parse_flags(str_ind, str_ind$2 + 1 | 0, end_ind, 1)
          : parse_flags(str_ind, str_ind$2, end_ind, 0),
       fmt_rest = match$1[1];
       /*<<camlinternalFormat.ml:2128:8>>*/ return add_literal
              (lit_start, str_ind, fmt_rest);
     }
     var str_ind$0 = str_ind + 1 | 0;
     a:
     if(str_ind$0 === end_ind)
      var match$0 = _N_;
     else{
       /*<<camlinternalFormat.ml:2593:12>>*/  /*<<camlinternalFormat.ml:2593:12>>*/ var
       c =
          /*<<camlinternalFormat.ml:2593:12>>*/ caml_string_get
          (str, str_ind$0);
      if(65 <= c){
       if(94 <= c){
         /*<<camlinternalFormat.ml:2593:12>>*/  /*<<camlinternalFormat.ml:2593:12>>*/ var
         switcher = c - 123 | 0;
        if(2 >= switcher >>> 0)
         switch(switcher){
           case 0:
            var match$0 = parse_tag(1, str_ind$0 + 1 | 0, end_ind); break a;
           case 1: break;
           default:
            var
             fmt_rest$2 = parse(str_ind$0 + 1 | 0, end_ind)[1],
             match$0 = [0, [17, 1, fmt_rest$2]];
            break a;
         }
       }
       else if(91 <= c)
        switch(c - 91 | 0){
          case 0:
           var match$0 = parse_tag(0, str_ind$0 + 1 | 0, end_ind); break a;
          case 1: break;
          default:
           var
            fmt_rest$3 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 0, fmt_rest$3]];
           break a;
        }
      }
      else{
       if(10 === c){
        var
         fmt_rest$4 = parse(str_ind$0 + 1 | 0, end_ind)[1],
         match$0 = [0, [17, 3, fmt_rest$4]];
        break a;
       }
       if(32 <= c)
        switch(c - 32 | 0){
          case 0:
           var
            fmt_rest$5 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, _O_, fmt_rest$5]];
           break a;
          case 5:
            /*<<camlinternalFormat.ml:2626:42>>*/ if
            ((str_ind$0 + 1 | 0) < end_ind
             &&
              37
              ===
                /*<<camlinternalFormat.ml:2626:42>>*/ caml_string_get
                (str, str_ind$0 + 1 | 0)){
            var
             fmt_rest$6 = parse(str_ind$0 + 2 | 0, end_ind)[1],
             match$0 = [0, [17, 6, fmt_rest$6]];
            break a;
           }
           var
            fmt_rest$7 = parse(str_ind$0, end_ind)[1],
            match$0 = [0, [12, 64, fmt_rest$7]];
           break a;
          case 12:
           var
            fmt_rest$8 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, _P_, fmt_rest$8]];
           break a;
          case 14:
           var
            fmt_rest$9 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 4, fmt_rest$9]];
           break a;
          case 27:
           var str_ind$3 = str_ind$0 + 1 | 0;
           b:
           try{
            var
             _bg_ = str_ind$3 === end_ind ? 1 : 0,
             _bh_ =
               _bg_
               ||
                (60
                  !==
                    /*<<camlinternalFormat.ml:2666:32>>*/ caml_string_get
                    (str, str_ind$3)
                  ? 1
                  : 0);
            if(_bh_)
              /*<<camlinternalFormat.ml:2666:58>>*/ throw  /*<<camlinternalFormat.ml:2666:58>>*/ caml_maybe_attach_backtrace
                    (Stdlib[8], 1);
             /*<<camlinternalFormat.ml:2667:24>>*/ var
              /*<<camlinternalFormat.ml:2667:24>>*/ str_ind_1 =
               parse_spaces(str_ind$3 + 1 | 0, end_ind),
              /*<<camlinternalFormat.ml:2668:14>>*/ match$2 =
                /*<<camlinternalFormat.ml:2668:14>>*/ caml_string_get
                (str, str_ind_1);
            c:
            {
             if(48 <= match$2){
              if(58 > match$2) break c;
             }
             else if(45 === match$2) break c;
              /*<<camlinternalFormat.ml:2684:15>>*/ throw  /*<<camlinternalFormat.ml:2684:15>>*/ caml_maybe_attach_backtrace
                    (Stdlib[8], 1);
            }
             /*<<camlinternalFormat.ml:2670:33>>*/ var
              /*<<camlinternalFormat.ml:2670:33>>*/ match$3 =
               parse_integer(str_ind_1, end_ind),
             width = match$3[2],
             str_ind_2 = match$3[1],
              /*<<camlinternalFormat.ml:2671:28>>*/ str_ind_3 =
               parse_spaces(str_ind_2, end_ind),
              /*<<camlinternalFormat.ml:2672:18>>*/ switcher$0 =
                /*<<camlinternalFormat.ml:2672:18>>*/ caml_string_get
                (str, str_ind_3)
               - 45
               | 0;
            if(12 < switcher$0 >>> 0){
             if(17 === switcher$0){
               /*<<camlinternalFormat.ml:2674:24>>*/ var
                /*<<camlinternalFormat.ml:2674:24>>*/ s =
                  /*<<camlinternalFormat.ml:2674:24>>*/ caml_call3
                  (Stdlib_String[16],
                   str,
                   str_ind$3 - 2 | 0,
                   (str_ind_3 - str_ind$3 | 0) + 3 | 0),
                /*<<camlinternalFormat.ml:2675:31>>*/ _bi_ = [0, s, width, 0],
                /*<<camlinternalFormat.ml:2675:31>>*/ _bj_ = str_ind_3 + 1 | 0,
               formatting_lit$0 = _bi_,
               next_ind = _bj_;
              break b;
             }
            }
            else if(1 < switcher$0 - 1 >>> 0){
              /*<<camlinternalFormat.ml:2677:40>>*/ var
               /*<<camlinternalFormat.ml:2677:40>>*/ match$4 =
                parse_integer(str_ind_3, end_ind),
              offset = match$4[2],
              str_ind_4 = match$4[1],
               /*<<camlinternalFormat.ml:2678:32>>*/ str_ind_5 =
                parse_spaces(str_ind_4, end_ind);
             if
              (62
               !==
                 /*<<camlinternalFormat.ml:2679:19>>*/ caml_string_get
                 (str, str_ind_5))
               /*<<camlinternalFormat.ml:2679:47>>*/ throw  /*<<camlinternalFormat.ml:2679:47>>*/ caml_maybe_attach_backtrace
                     (Stdlib[8], 1);
              /*<<camlinternalFormat.ml:2680:24>>*/ var
               /*<<camlinternalFormat.ml:2680:24>>*/ s$0 =
                 /*<<camlinternalFormat.ml:2680:24>>*/ caml_call3
                 (Stdlib_String[16],
                  str,
                  str_ind$3 - 2 | 0,
                  (str_ind_5 - str_ind$3 | 0) + 3 | 0),
               /*<<camlinternalFormat.ml:2681:31>>*/ _bk_ =
                [0, s$0, width, offset],
               /*<<camlinternalFormat.ml:2681:31>>*/ _bl_ = str_ind_5 + 1 | 0,
              formatting_lit$0 = _bk_,
              next_ind = _bl_;
             break b;
            }
             /*<<camlinternalFormat.ml:2682:21>>*/ throw  /*<<camlinternalFormat.ml:2682:21>>*/ caml_maybe_attach_backtrace
                   (Stdlib[8], 1);
           }
           catch(_bq_){
            var _bf_ = caml_wrap_exception(_bq_);
            if(_bf_ !== Stdlib[8] && _bf_[1] !== Stdlib[7])
             throw caml_maybe_attach_backtrace(_bf_, 0);
            var formatting_lit$0 = formatting_lit, next_ind = str_ind$3;
           }
           var
            fmt_rest$12 = parse(next_ind, end_ind)[1],
            match$0 = [0, [17, formatting_lit$0, fmt_rest$12]];
           break a;
          case 28:
           var str_ind$4 = str_ind$0 + 1 | 0;
            /*<<camlinternalFormat.ml:2694:4>>*/ try{
             /*<<camlinternalFormat.ml:2696:24>>*/ var
              /*<<camlinternalFormat.ml:2696:24>>*/ str_ind_1$0 =
               parse_spaces(str_ind$4, end_ind),
              /*<<camlinternalFormat.ml:2697:14>>*/ match$6 =
                /*<<camlinternalFormat.ml:2697:14>>*/ caml_string_get
                (str, str_ind_1$0);
            b:
            {
             c:
             {
              if(48 <= match$6){
               if(58 > match$6) break c;
              }
              else if(45 === match$6) break c;
              var _bo_ = 0;
              break b;
             }
              /*<<camlinternalFormat.ml:2699:32>>*/ var
               /*<<camlinternalFormat.ml:2699:32>>*/ match$7 =
                parse_integer(str_ind_1$0, end_ind),
              size = match$7[2],
              str_ind_2$0 = match$7[1],
               /*<<camlinternalFormat.ml:2700:26>>*/ str_ind_3$0 =
                parse_spaces(str_ind_2$0, end_ind);
             if
              (62
               !==
                 /*<<camlinternalFormat.ml:2701:13>>*/ caml_string_get
                 (str, str_ind_3$0))
               /*<<camlinternalFormat.ml:2701:41>>*/ throw  /*<<camlinternalFormat.ml:2701:41>>*/ caml_maybe_attach_backtrace
                     (Stdlib[8], 1);
              /*<<camlinternalFormat.ml:2702:18>>*/ var
               /*<<camlinternalFormat.ml:2702:18>>*/ s$1 =
                 /*<<camlinternalFormat.ml:2702:18>>*/ caml_call3
                 (Stdlib_String[16],
                  str,
                  str_ind$4 - 2 | 0,
                  (str_ind_3$0 - str_ind$4 | 0) + 3 | 0),
              _bo_ = [0, [0, str_ind_3$0 + 1 | 0, [1, s$1, size]]];
            }
            var _bn_ = _bo_;
           }
           catch(_bp_){
            var _bm_ = caml_wrap_exception(_bp_);
            if(_bm_ !== Stdlib[8] && _bm_[1] !== Stdlib[7])
             throw caml_maybe_attach_backtrace(_bm_, 0);
            var _bn_ = 0;
           }
           if(_bn_)
            var
             match$5 = _bn_[1],
             formatting_lit$1 = match$5[2],
             next_ind$0 = match$5[1],
             fmt_rest$13 = parse(next_ind$0, end_ind)[1],
             _be_ = [0, [17, formatting_lit$1, fmt_rest$13]];
           else
            var
             fmt_rest$14 = parse(str_ind$4, end_ind)[1],
             _be_ = [0, [17, _Q_, fmt_rest$14]];
           var match$0 = _be_;
           break a;
          case 31:
           var
            fmt_rest$10 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 2, fmt_rest$10]];
           break a;
          case 32:
           var
            fmt_rest$11 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 5, fmt_rest$11]];
           break a;
        }
      }
      var
       fmt_rest$1 = parse(str_ind$0 + 1 | 0, end_ind)[1],
       match$0 = [0, [17, [2, c], fmt_rest$1]];
     }
     var fmt_rest$0 = match$0[1];
      /*<<camlinternalFormat.ml:2131:8>>*/ return add_literal
             (lit_start, str_ind, fmt_rest$0);
     /*<<camlinternalFormat.ml:2119:62>>*/ }
    function parse_flags(pct_ind, str_ind, end_ind, ign){
      /*<<camlinternalFormat.ml:2149:4>>*/ var
       /*<<camlinternalFormat.ml:2149:15>>*/ zero = [0, 0],
       /*<<camlinternalFormat.ml:2149:37>>*/ minus = [0, 0],
       /*<<camlinternalFormat.ml:2150:15>>*/ plus = [0, 0],
       /*<<camlinternalFormat.ml:2150:37>>*/ space = [0, 0],
       /*<<camlinternalFormat.ml:2151:15>>*/ hash = [0, 0];
     function set_flag(str_ind, flag){
       /*<<camlinternalFormat.ml:2154:6>>*/ var
       _bb_ = flag[1],
       _bc_ = _bb_ ? 1 - legacy_behavior$0 : _bb_;
      if(_bc_){
        /*<<camlinternalFormat.ml:2157:22>>*/  /*<<camlinternalFormat.ml:2157:22>>*/ var
        _bd_ =
           /*<<camlinternalFormat.ml:2157:22>>*/ caml_string_get(str, str_ind);
        /*<<camlinternalFormat.ml:2155:8>>*/  /*<<camlinternalFormat.ml:2155:8>>*/ caml_call3
        (failwith_message(_C_), str, str_ind, _bd_);
      }
      flag[1] = 1;
      return;
      /*<<camlinternalFormat.ml:2158:19>>*/ }
     a:
     b:
     {
      var str_ind$0 = str_ind;
      c:
       /*<<camlinternalFormat.ml:2161:6>>*/ for(;;){
       if(str_ind$0 === end_ind)
         /*<<camlinternalFormat.ml:2161:32>>*/ unexpected_end_of_format
         (end_ind);
        /*<<camlinternalFormat.ml:2162:18>>*/  /*<<camlinternalFormat.ml:2162:18>>*/ var
        switcher =
           /*<<camlinternalFormat.ml:2162:18>>*/ caml_string_get
           (str, str_ind$0)
          - 32
          | 0;
       if(16 < switcher >>> 0) break b;
       switch(switcher){
         case 0:
           /*<<camlinternalFormat.ml:2167:15>>*/ set_flag(str_ind$0, space);
           /*<<camlinternalFormat.ml:2167:15>>*/ var
            /*<<camlinternalFormat.ml:2167:15>>*/ str_ind$1 =
             str_ind$0 + 1 | 0,
           str_ind$0 = str_ind$1;
          break;
         case 3:
           /*<<camlinternalFormat.ml:2166:15>>*/ set_flag(str_ind$0, hash);
           /*<<camlinternalFormat.ml:2166:15>>*/ var
            /*<<camlinternalFormat.ml:2166:15>>*/ str_ind$2 =
             str_ind$0 + 1 | 0,
           str_ind$0 = str_ind$2;
          break;
         case 11:
           /*<<camlinternalFormat.ml:2165:15>>*/ set_flag(str_ind$0, plus);
           /*<<camlinternalFormat.ml:2165:15>>*/ var
            /*<<camlinternalFormat.ml:2165:15>>*/ str_ind$3 =
             str_ind$0 + 1 | 0,
           str_ind$0 = str_ind$3;
          break;
         case 13:
           /*<<camlinternalFormat.ml:2164:15>>*/ set_flag(str_ind$0, minus);
           /*<<camlinternalFormat.ml:2164:15>>*/ var
            /*<<camlinternalFormat.ml:2164:15>>*/ str_ind$4 =
             str_ind$0 + 1 | 0,
           str_ind$0 = str_ind$4;
          break;
         case 16:
           /*<<camlinternalFormat.ml:2163:15>>*/ set_flag(str_ind$0, zero);
           /*<<camlinternalFormat.ml:2163:15>>*/ var
            /*<<camlinternalFormat.ml:2163:15>>*/ str_ind$5 =
             str_ind$0 + 1 | 0,
           str_ind$0 = str_ind$5;
          break;
         default: break c;
       }
      }
      break a;
     }
     var
      space$0 = space[1],
      hash$0 = hash[1],
      plus$0 = plus[1],
      minus$0 = minus[1],
      zero$0 = zero[1];
     if(str_ind$0 === end_ind)
       /*<<camlinternalFormat.ml:2180:30>>*/ unexpected_end_of_format(end_ind);
      /*<<camlinternalFormat.ml:2188:10>>*/ var
      padty =
        zero$0
         ? minus$0
           ? legacy_behavior$0
             ? 0
             : incompatible_flag(pct_ind, str_ind$0, 45, cst_0)
           : 2
         : minus$0 ? 0 : 1,
       /*<<camlinternalFormat.ml:2188:10>>*/ match =
         /*<<camlinternalFormat.ml:2188:10>>*/ caml_string_get(str, str_ind$0);
     if(48 <= match){
      if(58 > match){
        /*<<camlinternalFormat.ml:2190:27>>*/ var
         /*<<camlinternalFormat.ml:2190:27>>*/ match$0 =
          parse_positive(str_ind$0, end_ind, 0),
        width = match$0[2],
        new_ind = match$0[1];
        /*<<camlinternalFormat.ml:2192:8>>*/ return parse_after_padding
               (pct_ind,
                new_ind,
                end_ind,
                minus$0,
                plus$0,
                hash$0,
                space$0,
                ign,
                [0, padty, width]);
      }
     }
     else if(42 === match)
       /*<<camlinternalFormat.ml:2195:12>>*/ return parse_after_padding
              (pct_ind,
               str_ind$0 + 1 | 0,
               end_ind,
               minus$0,
               plus$0,
               hash$0,
               space$0,
               ign,
               [1, padty]);
     switch(padty){
       case 0:
        if(1 - legacy_behavior$0)
          /*<<camlinternalFormat.ml:2200:10>>*/ invalid_format_without
          (str_ind$0 - 1 | 0, 45, cst_padding);
         /*<<camlinternalFormat.ml:2200:10>>*/ return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 0);
       case 1:
         /*<<camlinternalFormat.ml:2210:8>>*/ return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 0);
       default:
         /*<<camlinternalFormat.ml:2207:8>>*/ return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 _D_);
     }
     /*<<camlinternalFormat.ml:2173:22>>*/ }
    function parse_after_padding
    (pct_ind, str_ind, end_ind, minus, plus, hash, space, ign, pad){
      /*<<camlinternalFormat.ml:2219:4>>*/ if(str_ind === end_ind)
       /*<<camlinternalFormat.ml:2219:30>>*/ unexpected_end_of_format(end_ind);
      /*<<camlinternalFormat.ml:2220:10>>*/  /*<<camlinternalFormat.ml:2220:10>>*/ var
      symb =
         /*<<camlinternalFormat.ml:2220:10>>*/ caml_string_get(str, str_ind);
     if(46 !== symb)
       /*<<camlinternalFormat.ml:2225:6>>*/ return parse_conversion
              (pct_ind,
               str_ind + 1 | 0,
               end_ind,
               plus,
               hash,
               space,
               ign,
               pad,
               0,
               pad,
               symb);
     var str_ind$0 = str_ind + 1 | 0;
     if(str_ind$0 === end_ind)
       /*<<camlinternalFormat.ml:2233:30>>*/ unexpected_end_of_format(end_ind);
     function parse_literal(minus, str_ind){
       /*<<camlinternalFormat.ml:2235:6>>*/ var
        /*<<camlinternalFormat.ml:2235:26>>*/ match =
         parse_positive(str_ind, end_ind, 0),
       prec = match[2],
       new_ind = match[1];
       /*<<camlinternalFormat.ml:2237:12>>*/ return parse_after_precision
              (pct_ind,
               new_ind,
               end_ind,
               minus,
               plus,
               hash,
               space,
               ign,
               pad,
               [0, prec]);
      /*<<camlinternalFormat.ml:2237:32>>*/ }
      /*<<camlinternalFormat.ml:2238:10>>*/  /*<<camlinternalFormat.ml:2238:10>>*/ var
      symb$0 =
         /*<<camlinternalFormat.ml:2238:10>>*/ caml_string_get(str, str_ind$0);
     if(48 <= symb$0){
      if(58 > symb$0)
        /*<<camlinternalFormat.ml:2239:20>>*/ return parse_literal
               (minus, str_ind$0);
     }
     else if(42 <= symb$0)
      switch(symb$0 - 42 | 0){
        case 0:
          /*<<camlinternalFormat.ml:2251:6>>*/ return parse_after_precision
                 (pct_ind,
                  str_ind$0 + 1 | 0,
                  end_ind,
                  minus,
                  plus,
                  hash,
                  space,
                  ign,
                  pad,
                  1);
        case 1:
        case 3:
         if(legacy_behavior$0){
           /*<<camlinternalFormat.ml:2249:6>>*/ var
            /*<<camlinternalFormat.ml:2249:6>>*/ _ba_ = str_ind$0 + 1 | 0,
           minus$0 = minus || (45 === symb$0 ? 1 : 0);
           /*<<camlinternalFormat.ml:2249:6>>*/ return parse_literal
                  (minus$0, _ba_);
         }
         break;
      }
     return legacy_behavior$0
             ? parse_after_precision
               (pct_ind,
                str_ind$0,
                end_ind,
                minus,
                plus,
                hash,
                space,
                ign,
                pad,
                _E_)
             : invalid_format_without(str_ind$0 - 1 | 0, 46, cst_precision);
     /*<<camlinternalFormat.ml:2226:29>>*/ }
    function parse_after_precision
    (pct_ind, str_ind, end_ind, minus, plus, hash, space, ign, pad, prec){
      /*<<camlinternalFormat.ml:2268:4>>*/ if(str_ind === end_ind)
       /*<<camlinternalFormat.ml:2268:30>>*/ unexpected_end_of_format(end_ind);
     function parse_conv(padprec){
       /*<<camlinternalFormat.ml:2270:6>>*/ return parse_conversion
              (pct_ind,
               str_ind + 1 | 0,
               end_ind,
               plus,
               hash,
               space,
               ign,
               pad,
               prec,
               padprec,
                /*<<camlinternalFormat.ml:2271:21>>*/ caml_string_get
                (str, str_ind));
      /*<<camlinternalFormat.ml:2271:34>>*/ }
     if(typeof pad !== "number")
       /*<<camlinternalFormat.ml:2287:13>>*/ return parse_conv(pad);
     if(typeof prec === "number" && ! prec)
       /*<<camlinternalFormat.ml:2281:29>>*/ return parse_conv(0);
     if(minus){
      if(typeof prec === "number")
        /*<<camlinternalFormat.ml:2285:33>>*/ return parse_conv(_F_);
      var n = prec[1];
       /*<<camlinternalFormat.ml:2283:46>>*/ return parse_conv([0, 0, n]);
     }
     if(typeof prec === "number")
       /*<<camlinternalFormat.ml:2284:34>>*/ return parse_conv(_G_);
     var n$0 = prec[1];
      /*<<camlinternalFormat.ml:2282:47>>*/ return parse_conv([0, 1, n$0]);
     /*<<camlinternalFormat.ml:2287:27>>*/ }
    function parse_conversion
    (pct_ind,
     str_ind,
     end_ind,
     plus,
     hash,
     space,
     ign,
     pad,
     prec,
     padprec,
     symb){
      /*<<camlinternalFormat.ml:2295:21>>*/ var
       /*<<camlinternalFormat.ml:2295:21>>*/ plus_used = [0, 0],
       /*<<camlinternalFormat.ml:2295:47>>*/ hash_used = [0, 0],
       /*<<camlinternalFormat.ml:2296:21>>*/ space_used = [0, 0],
       /*<<camlinternalFormat.ml:2296:48>>*/ ign_used = [0, 0],
       /*<<camlinternalFormat.ml:2297:21>>*/ pad_used = [0, 0],
       /*<<camlinternalFormat.ml:2297:48>>*/ prec_used = [0, 0];
     function get_plus(param){
       /*<<camlinternalFormat.ml:2300:25>>*/ plus_used[1] = 1;
       /*<<camlinternalFormat.ml:2300:4>>*/ return plus;
      /*<<camlinternalFormat.ml:2300:49>>*/ }
     function get_hash(param){
       /*<<camlinternalFormat.ml:2301:24>>*/ hash_used[1] = 1;
      return hash;
      /*<<camlinternalFormat.ml:2301:47>>*/ }
     function get_space(param){
       /*<<camlinternalFormat.ml:2302:25>>*/ space_used[1] = 1;
      return space;
      /*<<camlinternalFormat.ml:2302:50>>*/ }
     function get_ign(param){
       /*<<camlinternalFormat.ml:2303:25>>*/ ign_used[1] = 1;
      return ign;
      /*<<camlinternalFormat.ml:2303:48>>*/ }
     function get_pad(param){
       /*<<camlinternalFormat.ml:2304:25>>*/ pad_used[1] = 1;
      return pad;
      /*<<camlinternalFormat.ml:2304:48>>*/ }
     function get_prec(param){
       /*<<camlinternalFormat.ml:2305:25>>*/ prec_used[1] = 1;
      return prec;
      /*<<camlinternalFormat.ml:2305:49>>*/ }
     function get_padprec(param){
       /*<<camlinternalFormat.ml:2306:25>>*/ pad_used[1] = 1;
      return padprec;
      /*<<camlinternalFormat.ml:2306:52>>*/ }
     function get_int_pad(param){
       /*<<camlinternalFormat.ml:2320:7>>*/ var
        /*<<camlinternalFormat.ml:2320:13>>*/ pad = get_pad(0),
        /*<<camlinternalFormat.ml:2320:25>>*/ match = get_prec(0);
       /*<<camlinternalFormat.ml:2320:25>>*/ if
       (typeof match === "number" && ! match)
        /*<<camlinternalFormat.ml:2321:32>>*/ return pad;
      if(typeof pad === "number")
        /*<<camlinternalFormat.ml:2322:32>>*/ return 0;
      if(0 !== pad[0])
       return 2 <= pad[1]
               ? legacy_behavior$0
                 ? _H_
                 : incompatible_flag(pct_ind, str_ind, 48, cst_precision$1)
               : pad;
      if(2 > pad[1])  /*<<camlinternalFormat.ml:2329:38>>*/ return pad;
      var n = pad[2];
       /*<<camlinternalFormat.ml:2324:11>>*/ return legacy_behavior$0
              ? [0, 1, n]
              : incompatible_flag(pct_ind, str_ind, 48, cst_precision$0);
      /*<<camlinternalFormat.ml:2330:41>>*/ }
     function check_no_0(symb, pad){
       /*<<camlinternalFormat.ml:2334:6>>*/ if(typeof pad === "number")
        /*<<camlinternalFormat.ml:2335:22>>*/ return pad;
      if(0 !== pad[0])
       return 2 <= pad[1]
               ? legacy_behavior$0
                 ? _I_
                 : incompatible_flag(pct_ind, str_ind, symb, cst_0$1)
               : pad;
      if(2 > pad[1])  /*<<camlinternalFormat.ml:2336:43>>*/ return pad;
      var width = pad[2];
       /*<<camlinternalFormat.ml:2339:8>>*/ return legacy_behavior$0
              ? [0, 1, width]
              : incompatible_flag(pct_ind, str_ind, symb, cst_0$0);
      /*<<camlinternalFormat.ml:2343:55>>*/ }
     function opt_of_pad(c, pad){
       /*<<camlinternalFormat.ml:2349:64>>*/ if(typeof pad === "number")
        /*<<camlinternalFormat.ml:2350:22>>*/ return 0;
      if(0 === pad[0])
       switch(pad[1]){
         case 0:
          var width = pad[2];
           /*<<camlinternalFormat.ml:2356:8>>*/ return legacy_behavior$0
                  ? [0, width]
                  : incompatible_flag(pct_ind, str_ind, c, cst$24);
         case 1:
          var width$0 = pad[2];
           /*<<camlinternalFormat.ml:2351:38>>*/ return [0, width$0];
         default:
          var width$1 = pad[2];
           /*<<camlinternalFormat.ml:2353:8>>*/ return legacy_behavior$0
                  ? [0, width$1]
                  : incompatible_flag(pct_ind, str_ind, c, cst_0$2);
       }
       /*<<camlinternalFormat.ml:2358:25>>*/ return incompatible_flag
              (pct_ind, str_ind, c, cst$25);
      /*<<camlinternalFormat.ml:2358:66>>*/ }
     function get_pad_opt(c){
       /*<<camlinternalFormat.ml:2360:24>>*/ return opt_of_pad(c, get_pad(0));
      /*<<camlinternalFormat.ml:2360:49>>*/ }
     function get_padprec_opt(c){
       /*<<camlinternalFormat.ml:2361:28>>*/ return opt_of_pad
              (c, get_padprec(0));
      /*<<camlinternalFormat.ml:2361:57>>*/ }
     a:
     {
       /*<<camlinternalFormat.ml:2372:4>>*/ if(124 > symb)
       switch(symb){
         case 33:
          var
           fmt_rest$5 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [10, fmt_rest$5]];
          break a;
         case 40:
           /*<<camlinternalFormat.ml:2531:20>>*/ var
            /*<<camlinternalFormat.ml:2531:20>>*/ sub_end =
             search_subformat_end(str_ind, end_ind, 41),
           fmt_rest$7 = parse(sub_end + 2 | 0, end_ind)[1],
           sub_fmt = parse(str_ind, sub_end)[1],
            /*<<camlinternalFormat.ml:2534:22>>*/ sub_fmtty =
             fmtty_of_fmt(sub_fmt);
           /*<<camlinternalFormat.ml:2535:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2536:22>>*/ var
             /*<<camlinternalFormat.ml:2536:22>>*/ ignored$2 =
              [9, get_pad_opt(95), sub_fmtty],
            _aJ_ = [0, [23, ignored$2, fmt_rest$7]];
          else
           var _aJ_ = [0, [14, get_pad_opt(40), sub_fmtty, fmt_rest$7]];
          var fmt_result = _aJ_;
          break a;
         case 44:
          var fmt_result = parse(str_ind, end_ind); break a;
         case 67:
           /*<<camlinternalFormat.ml:2397:9>>*/ var
           fmt_rest$10 = parse(str_ind, end_ind)[1],
            /*<<camlinternalFormat.ml:2397:9>>*/ _aL_ =
             get_ign(0) ? [0, [23, 1, fmt_rest$10]] : [0, [1, fmt_rest$10]],
           fmt_result = _aL_;
          break a;
         case 78:
          var fmt_rest$14 = parse(str_ind, end_ind)[1], counter$0 = 2;
           /*<<camlinternalFormat.ml:2433:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2434:22>>*/ var
             /*<<camlinternalFormat.ml:2434:22>>*/ ignored$6 = [11, counter$0],
            _aR_ = [0, [23, ignored$6, fmt_rest$14]];
          else
           var _aR_ = [0, [21, counter$0, fmt_rest$14]];
          var fmt_result = _aR_;
          break a;
         case 83:
           /*<<camlinternalFormat.ml:2410:16>>*/ var
            /*<<camlinternalFormat.ml:2410:16>>*/ pad$6 =
             check_no_0(symb, get_padprec(0)),
           fmt_rest$15 = parse(str_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2412:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2413:22>>*/ var
             /*<<camlinternalFormat.ml:2413:22>>*/ ignored$7 =
              [1, get_padprec_opt(95)],
            _aS_ = [0, [23, ignored$7, fmt_rest$15]];
          else
            /*<<camlinternalFormat.ml:2417:10>>*/ var
             /*<<camlinternalFormat.ml:2417:10>>*/ match$5 =
              make_padding_fmt_ebb(pad$6, fmt_rest$15),
            fmt_rest$16 = match$5[2],
            pad$7 = match$5[1],
            _aS_ = [0, [3, pad$7, fmt_rest$16]];
          var fmt_result = _aS_;
          break a;
         case 91:
          if(str_ind === end_ind)
            /*<<camlinternalFormat.ml:2717:30>>*/ unexpected_end_of_format
            (end_ind);
           /*<<camlinternalFormat.ml:2719:19>>*/ var
            /*<<camlinternalFormat.ml:2719:19>>*/ char_set =
             create_char_set(0),
           add_char =
             function(c){
               /*<<camlinternalFormat.ml:2721:6>>*/ return add_in_char_set
                      (char_set, c);
              /*<<camlinternalFormat.ml:2721:32>>*/ },
           add_range =
             function(c$0, c){
               /*<<camlinternalFormat.ml:2724:6>>*/ if(c >= c$0){
               var i = c$0;
               for(;;){
                 /*<<camlinternalFormat.ml:2725:8>>*/ add_in_char_set
                 (char_set,
                   /*<<camlinternalFormat.ml:2725:33>>*/ caml_call1
                   (Stdlib[29], i));
                 /*<<camlinternalFormat.ml:2725:8>>*/  /*<<camlinternalFormat.ml:2725:8>>*/ var
                 _a$_ = i + 1 | 0;
                if(c === i) break;
                var i = _a$_;
               }
              }
              return;
              /*<<camlinternalFormat.ml:2726:10>>*/ },
           fail_single_percent =
             function(str_ind){
               /*<<camlinternalFormat.ml:2730:6>>*/ return  /*<<camlinternalFormat.ml:2730:6>>*/ caml_call2
                      (failwith_message(_R_), str, str_ind);
              /*<<camlinternalFormat.ml:2732:54>>*/ },
           parse_char_set_content =
             function(counter, str_ind, end_ind){
               /*<<camlinternalFormat.ml:2743:6>>*/ var str_ind$0 = str_ind;
               /*<<camlinternalFormat.ml:2743:6>>*/ for(;;){
               if(str_ind$0 === end_ind)
                 /*<<camlinternalFormat.ml:2743:32>>*/ unexpected_end_of_format
                 (end_ind);
                /*<<camlinternalFormat.ml:2744:12>>*/  /*<<camlinternalFormat.ml:2744:12>>*/ var
                c =
                   /*<<camlinternalFormat.ml:2744:12>>*/ caml_string_get
                   (str, str_ind$0);
               if(45 !== c){
                if(93 === c)
                  /*<<camlinternalFormat.ml:2746:8>>*/ return str_ind$0 + 1
                        | 0;
                var _a__ = str_ind$0 + 1 | 0;
                 /*<<camlinternalFormat.ml:2751:8>>*/ if(counter >= 50)
                  /*<<camlinternalFormat.ml:2751:8>>*/ return  /*<<camlinternalFormat.ml:2751:8>>*/ caml_trampoline_return
                         (parse_char_set_after_char$0, [0, _a__, end_ind, c]);
                var counter$0 = counter + 1 | 0;
                 /*<<camlinternalFormat.ml:2751:8>>*/ return parse_char_set_after_char$0
                        (counter$0, _a__, end_ind, c);
               }
                /*<<camlinternalFormat.ml:2748:8>>*/ add_char(45);
               var str_ind$1 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$1;
              }
              /*<<camlinternalFormat.ml:2751:57>>*/ },
           parse_char_set_after_char$0 =
             function(counter, str_ind, end_ind, c){
               /*<<camlinternalFormat.ml:2755:6>>*/ var
               str_ind$0 = str_ind,
               c$0 = c;
               /*<<camlinternalFormat.ml:2755:6>>*/ for(;;){
               if(str_ind$0 === end_ind)
                 /*<<camlinternalFormat.ml:2755:32>>*/ unexpected_end_of_format
                 (end_ind);
                /*<<camlinternalFormat.ml:2756:12>>*/  /*<<camlinternalFormat.ml:2756:12>>*/ var
                c$1 =
                   /*<<camlinternalFormat.ml:2756:12>>*/ caml_string_get
                   (str, str_ind$0);
               a:
               {
                if(46 <= c$1){
                 if(64 !== c$1){
                  if(93 !== c$1) break a;
                   /*<<camlinternalFormat.ml:2758:8>>*/ add_char(c$0);
                   /*<<camlinternalFormat.ml:2758:8>>*/ return str_ind$0 + 1
                         | 0;
                 }
                }
                else if(37 !== c$1){
                 if(45 > c$1) break a;
                 var str_ind$2 = str_ind$0 + 1 | 0;
                 if(str_ind$2 === end_ind)
                   /*<<camlinternalFormat.ml:2775:32>>*/ unexpected_end_of_format
                   (end_ind);
                  /*<<camlinternalFormat.ml:2776:12>>*/  /*<<camlinternalFormat.ml:2776:12>>*/ var
                  c$2 =
                     /*<<camlinternalFormat.ml:2776:12>>*/ caml_string_get
                     (str, str_ind$2);
                 if(37 === c$2){
                  if((str_ind$2 + 1 | 0) === end_ind)
                    /*<<camlinternalFormat.ml:2782:38>>*/ unexpected_end_of_format
                    (end_ind);
                   /*<<camlinternalFormat.ml:2783:20>>*/  /*<<camlinternalFormat.ml:2783:20>>*/ var
                   c$3 =
                      /*<<camlinternalFormat.ml:2783:20>>*/ caml_string_get
                      (str, str_ind$2 + 1 | 0);
                  if(37 !== c$3 && 64 !== c$3)
                    /*<<camlinternalFormat.ml:2787:17>>*/ return fail_single_percent
                           (str_ind$2);
                   /*<<camlinternalFormat.ml:2785:12>>*/ add_range(c$0, c$3);
                  var _a8_ = str_ind$2 + 2 | 0;
                   /*<<camlinternalFormat.ml:2785:12>>*/ if(counter >= 50)
                    /*<<camlinternalFormat.ml:2785:12>>*/ return  /*<<camlinternalFormat.ml:2785:12>>*/ caml_trampoline_return
                           (parse_char_set_content, [0, _a8_, end_ind]);
                  var counter$2 = counter + 1 | 0;
                   /*<<camlinternalFormat.ml:2785:12>>*/ return parse_char_set_content
                          (counter$2, _a8_, end_ind);
                 }
                 if(93 === c$2){
                   /*<<camlinternalFormat.ml:2778:8>>*/ add_char(c$0);
                   /*<<camlinternalFormat.ml:2779:8>>*/ add_char(45);
                   /*<<camlinternalFormat.ml:2779:8>>*/ return str_ind$2 + 1
                         | 0;
                 }
                  /*<<camlinternalFormat.ml:2790:8>>*/ add_range(c$0, c$2);
                 var _a9_ = str_ind$2 + 1 | 0;
                  /*<<camlinternalFormat.ml:2790:8>>*/ if(counter >= 50)
                   /*<<camlinternalFormat.ml:2790:8>>*/ return  /*<<camlinternalFormat.ml:2790:8>>*/ caml_trampoline_return
                          (parse_char_set_content, [0, _a9_, end_ind]);
                 var counter$1 = counter + 1 | 0;
                  /*<<camlinternalFormat.ml:2790:8>>*/ return parse_char_set_content
                         (counter$1, _a9_, end_ind);
                }
                if(37 === c$0){
                  /*<<camlinternalFormat.ml:2763:8>>*/ add_char(c$1);
                 var _a7_ = str_ind$0 + 1 | 0;
                  /*<<camlinternalFormat.ml:2763:8>>*/ if(counter >= 50)
                   /*<<camlinternalFormat.ml:2763:8>>*/ return  /*<<camlinternalFormat.ml:2763:8>>*/ caml_trampoline_return
                          (parse_char_set_content, [0, _a7_, end_ind]);
                 var counter$0 = counter + 1 | 0;
                  /*<<camlinternalFormat.ml:2763:8>>*/ return parse_char_set_content
                         (counter$0, _a7_, end_ind);
                }
               }
               if(37 === c$0)
                 /*<<camlinternalFormat.ml:2766:24>>*/ fail_single_percent
                 (str_ind$0);
                /*<<camlinternalFormat.ml:2770:8>>*/ add_char(c$0);
               var
                str_ind$1 = str_ind$0 + 1 | 0,
                str_ind$0 = str_ind$1,
                c$0 = c$1;
              }
              /*<<camlinternalFormat.ml:2771:58>>*/ },
           parse_char_set_after_char =
             function(str_ind, end_ind, c){
               /*<<?>>*/ return caml_trampoline
                      (parse_char_set_after_char$0(0, str_ind, end_ind, c));
             };
          if(str_ind === end_ind)
            /*<<camlinternalFormat.ml:2794:32>>*/ unexpected_end_of_format
            (end_ind);
          if
           (94
            ===
              /*<<camlinternalFormat.ml:2795:12>>*/ caml_string_get
              (str, str_ind))
           var
            str_ind$0 = str_ind + 1 | 0,
            reverse = 1,
            str_ind$1 = str_ind$0;
          else
           var reverse = 0, str_ind$1 = str_ind;
          if(str_ind$1 === end_ind)
            /*<<camlinternalFormat.ml:2737:32>>*/ unexpected_end_of_format
            (end_ind);
           /*<<camlinternalFormat.ml:2738:14>>*/ var
            /*<<camlinternalFormat.ml:2738:14>>*/ c =
              /*<<camlinternalFormat.ml:2738:14>>*/ caml_string_get
              (str, str_ind$1),
            /*<<camlinternalFormat.ml:2739:6>>*/ next_ind =
             parse_char_set_after_char(str_ind$1 + 1 | 0, end_ind, c),
            /*<<camlinternalFormat.ml:2799:19>>*/ char_set$0 =
             freeze_char_set(char_set),
            /*<<camlinternalFormat.ml:2800:4>>*/ char_set$1 =
             reverse ? rev_char_set(char_set$0) : char_set$0,
           fmt_rest$19 = parse(next_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2543:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2544:22>>*/ var
             /*<<camlinternalFormat.ml:2544:22>>*/ ignored$9 =
              [10, get_pad_opt(95), char_set$1],
            _aX_ = [0, [23, ignored$9, fmt_rest$19]];
          else
           var _aX_ = [0, [20, get_pad_opt(91), char_set$1, fmt_rest$19]];
          var fmt_result = _aX_;
          break a;
         case 97:
          var
           fmt_rest$20 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [15, fmt_rest$20]];
          break a;
         case 99:
           /*<<camlinternalFormat.ml:2387:18>>*/ var
           char_format =
             function(fmt_rest){
               /*<<camlinternalFormat.ml:2377:8>>*/ return get_ign(0)
                      ? [0, [23, 0, fmt_rest]]
                      : [0, [0, fmt_rest]];
              /*<<camlinternalFormat.ml:2379:36>>*/ },
           fmt_rest$21 = parse(str_ind, end_ind)[1],
            /*<<camlinternalFormat.ml:2387:18>>*/ match$7 = get_pad_opt(99);
          if(match$7){
           if(0 === match$7[1])
             /*<<camlinternalFormat.ml:2382:11>>*/ var
              /*<<camlinternalFormat.ml:2382:11>>*/ _aY_ =
               get_ign(0) ? [0, [23, 3, fmt_rest$21]] : [0, [22, fmt_rest$21]],
             _aZ_ = _aY_;
           else
            var
             _aZ_ =
               legacy_behavior$0
                ? char_format(fmt_rest$21)
                : invalid_format_message
                  (str_ind, cst_non_zero_widths_are_unsupp);
           var _a0_ = _aZ_;
          }
          else
           var _a0_ = char_format(fmt_rest$21);
          var fmt_result = _a0_;
          break a;
         case 114:
           /*<<camlinternalFormat.ml:2512:9>>*/ var
           fmt_rest$22 = parse(str_ind, end_ind)[1],
            /*<<camlinternalFormat.ml:2512:9>>*/ _a1_ =
             get_ign(0) ? [0, [23, 2, fmt_rest$22]] : [0, [19, fmt_rest$22]],
           fmt_result = _a1_;
          break a;
         case 115:
           /*<<camlinternalFormat.ml:2400:16>>*/ var
            /*<<camlinternalFormat.ml:2400:16>>*/ pad$9 =
             check_no_0(symb, get_padprec(0)),
           fmt_rest$23 = parse(str_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2402:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2403:22>>*/ var
             /*<<camlinternalFormat.ml:2403:22>>*/ ignored$10 =
              [0, get_padprec_opt(95)],
            _a2_ = [0, [23, ignored$10, fmt_rest$23]];
          else
            /*<<camlinternalFormat.ml:2407:10>>*/ var
             /*<<camlinternalFormat.ml:2407:10>>*/ match$8 =
              make_padding_fmt_ebb(pad$9, fmt_rest$23),
            fmt_rest$24 = match$8[2],
            pad$10 = match$8[1],
            _a2_ = [0, [2, pad$10, fmt_rest$24]];
          var fmt_result = _a2_;
          break a;
         case 116:
          var
           fmt_rest$25 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [16, fmt_rest$25]];
          break a;
         case 123:
           /*<<camlinternalFormat.ml:2521:20>>*/ var
            /*<<camlinternalFormat.ml:2521:20>>*/ sub_end$0 =
             search_subformat_end(str_ind, end_ind, 125),
           sub_fmt$0 = parse(str_ind, sub_end$0)[1],
           fmt_rest$26 = parse(sub_end$0 + 2 | 0, end_ind)[1],
            /*<<camlinternalFormat.ml:2524:22>>*/ sub_fmtty$0 =
             fmtty_of_fmt(sub_fmt$0);
           /*<<camlinternalFormat.ml:2525:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2526:22>>*/ var
             /*<<camlinternalFormat.ml:2526:22>>*/ ignored$11 =
              [8, get_pad_opt(95), sub_fmtty$0],
            _a3_ = [0, [23, ignored$11, fmt_rest$26]];
          else
           var _a3_ = [0, [13, get_pad_opt(123), sub_fmtty$0, fmt_rest$26]];
          var fmt_result = _a3_;
          break a;
         case 66:
         case 98:
           /*<<camlinternalFormat.ml:2495:16>>*/ var
            /*<<camlinternalFormat.ml:2495:16>>*/ pad$3 =
             check_no_0(symb, get_padprec(0)),
           fmt_rest$8 = parse(str_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2497:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2498:22>>*/ var
             /*<<camlinternalFormat.ml:2498:22>>*/ ignored$3 =
              [7, get_padprec_opt(95)],
            _aK_ = [0, [23, ignored$3, fmt_rest$8]];
          else
            /*<<camlinternalFormat.ml:2502:10>>*/ var
             /*<<camlinternalFormat.ml:2502:10>>*/ match$3 =
              make_padding_fmt_ebb(pad$3, fmt_rest$8),
            fmt_rest$9 = match$3[2],
            pad$4 = match$3[1],
            _aK_ = [0, [9, pad$4, fmt_rest$9]];
          var fmt_result = _aK_;
          break a;
         case 37:
         case 64:
          var
           fmt_rest$6 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [12, symb, fmt_rest$6]];
          break a;
         case 76:
         case 108:
         case 110:
          if(str_ind !== end_ind){
            /*<<camlinternalFormat.ml:2438:63>>*/ var
             /*<<camlinternalFormat.ml:2438:63>>*/ symb$0 =
               /*<<camlinternalFormat.ml:2438:63>>*/ caml_string_get
               (str, str_ind),
             /*<<camlinternalFormat.ml:2892:25>>*/ _a4_ = symb$0 - 88 | 0;
           b:
           {
            if(32 >= _a4_ >>> 0)
             switch(_a4_){
               case 0:
               case 12:
               case 17:
               case 23:
               case 29:
               case 32:
                var _aQ_ = 1; break b;
             }
            var _aQ_ = 0;
           }
            /*<<camlinternalFormat.ml:2438:50>>*/ if(_aQ_) break;
          }
          var fmt_rest$13 = parse(str_ind, end_ind)[1];
          b:
          {
           if(108 <= symb){
            if(111 > symb)
             switch(symb - 108 | 0){
               case 0:
                var counter = 0; break b;
               case 1: break;
               default: var counter = 1; break b;
             }
           }
           else if(76 === symb){var counter = 2; break b;}
            /*<<camlinternalFormat.ml:2899:34>>*/ throw  /*<<camlinternalFormat.ml:2899:34>>*/ caml_maybe_attach_backtrace
                  ([0, Assert_failure, _V_], 1);
          }
           /*<<camlinternalFormat.ml:2441:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2442:22>>*/ var
             /*<<camlinternalFormat.ml:2442:22>>*/ ignored$5 = [11, counter],
            _aP_ = [0, [23, ignored$5, fmt_rest$13]];
          else
           var _aP_ = [0, [21, counter, fmt_rest$13]];
          var fmt_result = _aP_;
          break a;
         case 32:
         case 35:
         case 43:
         case 45:
         case 95:
          var
           fmt_result =
              /*<<camlinternalFormat.ml:2549:6>>*/ caml_call3
              (failwith_message(_M_), str, pct_ind, symb);
          break a;
         case 88:
         case 100:
         case 105:
         case 111:
         case 117:
         case 120:
           /*<<camlinternalFormat.ml:2421:8>>*/ var
            /*<<camlinternalFormat.ml:2421:8>>*/ _aT_ = get_space(0),
            /*<<camlinternalFormat.ml:2420:65>>*/ _aU_ = get_hash(0),
            /*<<camlinternalFormat.ml:2420:18>>*/ iconv$2 =
             compute_int_conv(pct_ind, str_ind, get_plus(0), _aU_, _aT_, symb),
           fmt_rest$17 = parse(str_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2423:9>>*/ if(get_ign(0))
            /*<<camlinternalFormat.ml:2424:22>>*/ var
             /*<<camlinternalFormat.ml:2424:22>>*/ ignored$8 =
              [2, iconv$2, get_pad_opt(95)],
            _aV_ = [0, [23, ignored$8, fmt_rest$17]];
          else
            /*<<camlinternalFormat.ml:2428:48>>*/ var
             /*<<camlinternalFormat.ml:2428:48>>*/ _aW_ = get_prec(0),
             /*<<camlinternalFormat.ml:2428:10>>*/ match$6 =
              make_padprec_fmt_ebb(get_int_pad(0), _aW_, fmt_rest$17),
            fmt_rest$18 = match$6[3],
            prec$4 = match$6[2],
            pad$8 = match$6[1],
            _aV_ = [0, [4, iconv$2, pad$8, prec$4, fmt_rest$18]];
          var fmt_result = _aV_;
          break a;
         case 69:
         case 70:
         case 71:
         case 72:
         case 101:
         case 102:
         case 103:
         case 104:
           /*<<camlinternalFormat.ml:2485:38>>*/ var
            /*<<camlinternalFormat.ml:2485:38>>*/ space$1 = get_space(0),
            /*<<camlinternalFormat.ml:2485:24>>*/ hash$1 = get_hash(0),
            /*<<camlinternalFormat.ml:2485:10>>*/ plus$2 = get_plus(0),
           flag =
             plus$2
              ? space$1
                ? legacy_behavior$0
                  ? 1
                  : incompatible_flag(pct_ind, str_ind, 32, cst$36)
                : 1
              : space$1 ? 2 : 0;
          b:
          {
           c:
           if(73 <= symb){
            var switcher = symb - 101 | 0;
            if(3 >= switcher >>> 0){
             switch(switcher){
               case 0:
                var _a5_ = 1; break;
               case 1:
                var _a5_ = 0; break;
               case 2:
                var _a5_ = 3; break;
               default: var _a5_ = 6;
             }
             var kind = _a5_;
             break b;
            }
           }
           else if(69 <= symb){
            switch(symb - 69 | 0){
              case 0:
               var _a6_ = 2; break;
              case 1:
               break c;
              case 2:
               var _a6_ = 4; break;
              default: var _a6_ = 7;
            }
            var kind = _a6_;
            break b;
           }
           if(hash$1){
            if(70 === symb){var kind = 8; break b;}
           }
           else if(70 === symb){var kind = 5; break b;}
            /*<<camlinternalFormat.ml:2957:11>>*/ throw  /*<<camlinternalFormat.ml:2957:11>>*/ caml_maybe_attach_backtrace
                  ([0, Assert_failure, _X_], 1);
          }
           /*<<camlinternalFormat.ml:2958:4>>*/ var
            /*<<camlinternalFormat.ml:2958:4>>*/ fconv = [0, flag, kind],
           fmt_rest$11 = parse(str_ind, end_ind)[1];
           /*<<camlinternalFormat.ml:2487:9>>*/ if(get_ign(0)){
            /*<<camlinternalFormat.ml:2366:32>>*/  /*<<camlinternalFormat.ml:2366:32>>*/ var
            match = get_prec(0);
           if(typeof match === "number")
            var
             _aM_ =
               match ? incompatible_flag(pct_ind, str_ind, 95, cst$26) : 0;
           else
            var ndec = match[1], _aM_ = [0, ndec];
            /*<<camlinternalFormat.ml:2488:22>>*/ var
             /*<<camlinternalFormat.ml:2488:22>>*/ ignored$4 =
              [6, get_pad_opt(95), _aM_],
            _aN_ = [0, [23, ignored$4, fmt_rest$11]];
          }
          else
            /*<<camlinternalFormat.ml:2492:44>>*/ var
             /*<<camlinternalFormat.ml:2492:44>>*/ _aO_ = get_prec(0),
             /*<<camlinternalFormat.ml:2492:10>>*/ match$4 =
              make_padprec_fmt_ebb(get_pad(0), _aO_, fmt_rest$11),
            fmt_rest$12 = match$4[3],
            prec$3 = match$4[2],
            pad$5 = match$4[1],
            _aN_ = [0, [8, fconv, pad$5, prec$3, fmt_rest$12]];
          var fmt_result = _aN_;
          break a;
       }
      b:
      if(108 <= symb){
       if(111 > symb){
        switch(symb - 108 | 0){
          case 0:
            /*<<camlinternalFormat.ml:2449:25>>*/ var
             /*<<camlinternalFormat.ml:2449:25>>*/ _at_ =
               /*<<camlinternalFormat.ml:2449:25>>*/ caml_string_get
               (str, str_ind),
             /*<<camlinternalFormat.ml:2449:10>>*/ _au_ = get_space(0),
             /*<<camlinternalFormat.ml:2448:61>>*/ _av_ = get_hash(0),
             /*<<camlinternalFormat.ml:2448:8>>*/ iconv =
              compute_int_conv
               (pct_ind, str_ind + 1 | 0, get_plus(0), _av_, _au_, _at_),
            fmt_rest = parse(str_ind + 1 | 0, end_ind)[1];
            /*<<camlinternalFormat.ml:2451:9>>*/ if(get_ign(0))
             /*<<camlinternalFormat.ml:2452:22>>*/ var
              /*<<camlinternalFormat.ml:2452:22>>*/ ignored =
               [3, iconv, get_pad_opt(95)],
             _aw_ = [0, [23, ignored, fmt_rest]];
           else
             /*<<camlinternalFormat.ml:2456:48>>*/ var
              /*<<camlinternalFormat.ml:2456:48>>*/ _ay_ = get_prec(0),
              /*<<camlinternalFormat.ml:2456:10>>*/ match$0 =
               make_padprec_fmt_ebb(get_int_pad(0), _ay_, fmt_rest),
             fmt_rest$0 = match$0[3],
             prec$0 = match$0[2],
             pad$0 = match$0[1],
             _aw_ = [0, [5, iconv, pad$0, prec$0, fmt_rest$0]];
           var _ax_ = _aw_;
           break;
          case 1:
           break b;
          default:
            /*<<camlinternalFormat.ml:2461:39>>*/ var
             /*<<camlinternalFormat.ml:2461:39>>*/ _az_ =
               /*<<camlinternalFormat.ml:2461:39>>*/ caml_string_get
               (str, str_ind),
             /*<<camlinternalFormat.ml:2461:24>>*/ _aA_ = get_space(0),
             /*<<camlinternalFormat.ml:2461:10>>*/ _aB_ = get_hash(0),
             /*<<camlinternalFormat.ml:2460:8>>*/ iconv$0 =
              compute_int_conv
               (pct_ind, str_ind + 1 | 0, get_plus(0), _aB_, _aA_, _az_),
            fmt_rest$1 = parse(str_ind + 1 | 0, end_ind)[1];
            /*<<camlinternalFormat.ml:2463:9>>*/ if(get_ign(0))
             /*<<camlinternalFormat.ml:2464:22>>*/ var
              /*<<camlinternalFormat.ml:2464:22>>*/ ignored$0 =
               [4, iconv$0, get_pad_opt(95)],
             _aC_ = [0, [23, ignored$0, fmt_rest$1]];
           else
             /*<<camlinternalFormat.ml:2468:48>>*/ var
              /*<<camlinternalFormat.ml:2468:48>>*/ _aD_ = get_prec(0),
              /*<<camlinternalFormat.ml:2468:10>>*/ match$1 =
               make_padprec_fmt_ebb(get_int_pad(0), _aD_, fmt_rest$1),
             fmt_rest$2 = match$1[3],
             prec$1 = match$1[2],
             pad$1 = match$1[1],
             _aC_ = [0, [6, iconv$0, pad$1, prec$1, fmt_rest$2]];
           var _ax_ = _aC_;
        }
        var fmt_result = _ax_;
        break a;
       }
      }
      else if(76 === symb){
        /*<<camlinternalFormat.ml:2473:25>>*/ var
         /*<<camlinternalFormat.ml:2473:25>>*/ _aE_ =
           /*<<camlinternalFormat.ml:2473:25>>*/ caml_string_get(str, str_ind),
         /*<<camlinternalFormat.ml:2473:10>>*/ _aF_ = get_space(0),
         /*<<camlinternalFormat.ml:2472:61>>*/ _aG_ = get_hash(0),
         /*<<camlinternalFormat.ml:2472:8>>*/ iconv$1 =
          compute_int_conv
           (pct_ind, str_ind + 1 | 0, get_plus(0), _aG_, _aF_, _aE_),
        fmt_rest$3 = parse(str_ind + 1 | 0, end_ind)[1];
        /*<<camlinternalFormat.ml:2475:9>>*/ if(get_ign(0))
         /*<<camlinternalFormat.ml:2476:22>>*/ var
          /*<<camlinternalFormat.ml:2476:22>>*/ ignored$1 =
           [5, iconv$1, get_pad_opt(95)],
         _aH_ = [0, [23, ignored$1, fmt_rest$3]];
       else
         /*<<camlinternalFormat.ml:2480:48>>*/ var
          /*<<camlinternalFormat.ml:2480:48>>*/ _aI_ = get_prec(0),
          /*<<camlinternalFormat.ml:2480:10>>*/ match$2 =
           make_padprec_fmt_ebb(get_int_pad(0), _aI_, fmt_rest$3),
         fmt_rest$4 = match$2[3],
         prec$2 = match$2[2],
         pad$2 = match$2[1],
         _aH_ = [0, [7, iconv$1, pad$2, prec$2, fmt_rest$4]];
       var fmt_result = _aH_;
       break a;
      }
      var
       fmt_result =
          /*<<camlinternalFormat.ml:2554:6>>*/ caml_call3
          (failwith_message(_J_), str, str_ind - 1 | 0, symb);
     }
     if(1 - legacy_behavior$0){
      var _ak_ = 1 - plus_used[1], plus$0 = _ak_ ? plus : _ak_;
      if(plus$0)
        /*<<camlinternalFormat.ml:2564:6>>*/ incompatible_flag
        (pct_ind, str_ind, symb, cst$27);
      var _al_ = 1 - hash_used[1], hash$0 = _al_ ? hash : _al_;
      if(hash$0)
        /*<<camlinternalFormat.ml:2566:6>>*/ incompatible_flag
        (pct_ind, str_ind, symb, cst$28);
      var _am_ = 1 - space_used[1], space$0 = _am_ ? space : _am_;
      if(space$0)
        /*<<camlinternalFormat.ml:2568:6>>*/ incompatible_flag
        (pct_ind, str_ind, symb, cst$29);
      var
       _an_ = 1 - pad_used[1],
       _ao_ =
         _an_
          ?  /*<<camlinternalFormat.ml:2569:25>>*/ caml_notequal
            ([0, pad], _K_)
          : _an_;
       /*<<camlinternalFormat.ml:2569:25>>*/ if(_ao_)
        /*<<camlinternalFormat.ml:2570:6>>*/ incompatible_flag
        (pct_ind, str_ind, symb, cst_padding$0);
      var
       _ap_ = 1 - prec_used[1],
       _aq_ =
         _ap_
          ?  /*<<camlinternalFormat.ml:2571:25>>*/ caml_notequal
            ([0, prec], _L_)
          : _ap_;
       /*<<camlinternalFormat.ml:2571:25>>*/ if(_aq_){
       var _ar_ = ign ? 95 : symb;
        /*<<camlinternalFormat.ml:2572:6>>*/ incompatible_flag
        (pct_ind, str_ind, _ar_, cst_precision$2);
      }
      var plus$1 = ign ? plus : ign;
      if(plus$1)
        /*<<camlinternalFormat.ml:2574:24>>*/ incompatible_flag
        (pct_ind, str_ind, 95, cst$30);
     }
     var _as_ = 1 - ign_used[1], ign$0 = _as_ ? ign : _as_;
     a:
     if(ign$0){
      b:
      {
       if(38 <= symb){
        if(44 !== symb && 64 !== symb) break b;
       }
       else if(33 !== symb && 37 > symb) break b;
       if(legacy_behavior$0) break a;
      }
       /*<<camlinternalFormat.ml:2584:10>>*/ incompatible_flag
       (pct_ind, str_ind, symb, cst$31);
     }
      /*<<camlinternalFormat.ml:2584:10>>*/ return fmt_result;
    }
    function parse_tag(is_open_tag, str_ind, end_ind){
      /*<<camlinternalFormat.ml:2639:4>>*/ try{
      if(str_ind === end_ind)
        /*<<camlinternalFormat.ml:2640:32>>*/ throw  /*<<camlinternalFormat.ml:2640:32>>*/ caml_maybe_attach_backtrace
              (Stdlib[8], 1);
      if
       (60
        !==
          /*<<camlinternalFormat.ml:2641:12>>*/ caml_string_get(str, str_ind))
        /*<<camlinternalFormat.ml:2653:8>>*/ throw  /*<<camlinternalFormat.ml:2653:8>>*/ caml_maybe_attach_backtrace
              (Stdlib[8], 1);
       /*<<camlinternalFormat.ml:2643:18>>*/  /*<<camlinternalFormat.ml:2643:18>>*/ var
       ind =
          /*<<camlinternalFormat.ml:2643:18>>*/ caml_call3
          (Stdlib_String[32], str, str_ind + 1 | 0, 62);
      if(end_ind <= ind)
        /*<<camlinternalFormat.ml:2644:31>>*/ throw  /*<<camlinternalFormat.ml:2644:31>>*/ caml_maybe_attach_backtrace
              (Stdlib[8], 1);
       /*<<camlinternalFormat.ml:2645:22>>*/ var
        /*<<camlinternalFormat.ml:2645:22>>*/ sub_str =
          /*<<camlinternalFormat.ml:2645:22>>*/ caml_call3
          (Stdlib_String[16], str, str_ind, (ind - str_ind | 0) + 1 | 0),
       fmt_rest$0 = parse(ind + 1 | 0, end_ind)[1],
       sub_fmt = parse(str_ind, ind + 1 | 0)[1],
        /*<<camlinternalFormat.ml:2648:25>>*/ sub_format$0 =
         [0, sub_fmt, sub_str],
        /*<<camlinternalFormat.ml:2649:8>>*/ formatting$0 =
         is_open_tag ? [0, sub_format$0] : [1, sub_format$0],
        /*<<camlinternalFormat.ml:2651:8>>*/ _ai_ =
         [0, [18, formatting$0, fmt_rest$0]];
       /*<<camlinternalFormat.ml:2651:8>>*/ return _ai_;
     }
     catch(_aj_){
      var _ah_ = caml_wrap_exception(_aj_);
      if(_ah_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_ah_, 0);
       /*<<camlinternalFormat.ml:2657:6>>*/ var
       fmt_rest = parse(str_ind, end_ind)[1],
        /*<<camlinternalFormat.ml:2657:6>>*/ formatting =
         is_open_tag ? [0, sub_format] : [1, sub_format];
       /*<<camlinternalFormat.ml:2659:6>>*/ return [0,
              [18, formatting, fmt_rest]];
     }
     /*<<camlinternalFormat.ml:2659:53>>*/ }
    function parse_spaces(str_ind, end_ind){
      /*<<camlinternalFormat.ml:2804:4>>*/ var str_ind$0 = str_ind;
      /*<<camlinternalFormat.ml:2804:4>>*/ for(;;){
      if(str_ind$0 === end_ind)
        /*<<camlinternalFormat.ml:2804:30>>*/ unexpected_end_of_format
        (end_ind);
       /*<<camlinternalFormat.ml:2805:7>>*/ if
       (32
        !==
          /*<<camlinternalFormat.ml:2805:7>>*/ caml_string_get(str, str_ind$0))
        /*<<camlinternalFormat.ml:2805:72>>*/ return str_ind$0;
      var str_ind$1 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$1;
     }
     /*<<camlinternalFormat.ml:2805:79>>*/ }
    function parse_positive(str_ind, end_ind, acc){
      /*<<camlinternalFormat.ml:2810:4>>*/ var
      str_ind$0 = str_ind,
      acc$0 = acc;
      /*<<camlinternalFormat.ml:2810:4>>*/ for(;;){
      if(str_ind$0 === end_ind)
        /*<<camlinternalFormat.ml:2810:30>>*/ unexpected_end_of_format
        (end_ind);
       /*<<camlinternalFormat.ml:2811:10>>*/  /*<<camlinternalFormat.ml:2811:10>>*/ var
       c =
          /*<<camlinternalFormat.ml:2811:10>>*/ caml_string_get
          (str, str_ind$0);
      if(9 < c - 48 >>> 0)
        /*<<camlinternalFormat.ml:2820:11>>*/ return [0, str_ind$0, acc$0];
      var new_acc = (acc$0 * 10 | 0) + (c - 48 | 0) | 0;
      if(Stdlib_Sys[12] < new_acc){
        /*<<camlinternalFormat.ml:2815:8>>*/  /*<<camlinternalFormat.ml:2815:8>>*/ var
        _ag_ = Stdlib_Sys[12];
        /*<<camlinternalFormat.ml:2815:8>>*/ return  /*<<camlinternalFormat.ml:2815:8>>*/ caml_call3
               (failwith_message(_S_), str, new_acc, _ag_);
      }
      var
       str_ind$1 = str_ind$0 + 1 | 0,
       str_ind$0 = str_ind$1,
       acc$0 = new_acc;
     }
     /*<<camlinternalFormat.ml:2820:23>>*/ }
    function parse_integer(str_ind, end_ind){
      /*<<camlinternalFormat.ml:2825:4>>*/ if(str_ind === end_ind)
       /*<<camlinternalFormat.ml:2825:30>>*/ unexpected_end_of_format(end_ind);
      /*<<camlinternalFormat.ml:2826:10>>*/  /*<<camlinternalFormat.ml:2826:10>>*/ var
      match =
         /*<<camlinternalFormat.ml:2826:10>>*/ caml_string_get(str, str_ind);
     if(48 <= match){
      if(58 > match)
        /*<<camlinternalFormat.ml:2827:20>>*/ return parse_positive
               (str_ind, end_ind, 0);
     }
     else if(45 === match){
      if((str_ind + 1 | 0) === end_ind)
        /*<<camlinternalFormat.ml:2829:36>>*/ unexpected_end_of_format
        (end_ind);
       /*<<camlinternalFormat.ml:2830:12>>*/  /*<<camlinternalFormat.ml:2830:12>>*/ var
       c =
          /*<<camlinternalFormat.ml:2830:12>>*/ caml_string_get
          (str, str_ind + 1 | 0);
      if(9 < c - 48 >>> 0)
        /*<<camlinternalFormat.ml:2835:8>>*/ return expected_character
               (str_ind + 1 | 0, cst_digit, c);
       /*<<camlinternalFormat.ml:2832:26>>*/ var
        /*<<camlinternalFormat.ml:2832:26>>*/ match$0 =
         parse_positive(str_ind + 1 | 0, end_ind, 0),
       n = match$0[2],
       next_ind = match$0[1];
       /*<<camlinternalFormat.ml:2833:8>>*/ return [0, next_ind, - n | 0];
     }
      /*<<camlinternalFormat.ml:2837:11>>*/ throw  /*<<camlinternalFormat.ml:2837:11>>*/ caml_maybe_attach_backtrace
            ([0, Assert_failure, _T_], 1);
     /*<<camlinternalFormat.ml:2837:23>>*/ }
    function add_literal(lit_start, str_ind, fmt){
      /*<<camlinternalFormat.ml:2843:31>>*/ var
      size = str_ind - lit_start | 0;
     return 0 === size
             ? [0, fmt]
             : 1
               === size
               ? [0,
                 [12,
                   /*<<camlinternalFormat.ml:2845:37>>*/ caml_string_get
                   (str, lit_start),
                  fmt]]
               : [0,
                 [11,
                   /*<<camlinternalFormat.ml:2846:39>>*/ caml_call3
                   (Stdlib_String[16], str, lit_start, size),
                  fmt]];
     /*<<camlinternalFormat.ml:2846:75>>*/ }
    function search_subformat_end(str_ind, end_ind, c){
      /*<<camlinternalFormat.ml:2851:4>>*/ var str_ind$0 = str_ind;
      /*<<camlinternalFormat.ml:2851:4>>*/ for(;;){
      if(str_ind$0 === end_ind)
        /*<<camlinternalFormat.ml:2852:6>>*/  /*<<camlinternalFormat.ml:2852:6>>*/ caml_call3
        (failwith_message(_U_), str, c, end_ind);
      if
       (37
        ===
          /*<<camlinternalFormat.ml:2855:10>>*/ caml_string_get
          (str, str_ind$0)){
       if((str_ind$0 + 1 | 0) === end_ind)
         /*<<camlinternalFormat.ml:2857:36>>*/ unexpected_end_of_format
         (end_ind);
       if
        ( /*<<camlinternalFormat.ml:2858:9>>*/ caml_string_get
          (str, str_ind$0 + 1 | 0)
         === c)
         /*<<camlinternalFormat.ml:2858:62>>*/ return str_ind$0;
        /*<<camlinternalFormat.ml:2859:20>>*/  /*<<camlinternalFormat.ml:2859:20>>*/ var
        match =
           /*<<camlinternalFormat.ml:2859:20>>*/ caml_string_get
           (str, str_ind$0 + 1 | 0);
       if(95 <= match){
        if(123 <= match){
         if(126 > match)
          switch(match - 123 | 0){
            case 0:
              /*<<camlinternalFormat.ml:2874:24>>*/ var
               /*<<camlinternalFormat.ml:2874:24>>*/ sub_end =
                search_subformat_end(str_ind$0 + 2 | 0, end_ind, 125),
               /*<<camlinternalFormat.ml:2874:24>>*/ str_ind$2 =
                sub_end + 2 | 0,
              str_ind$0 = str_ind$2;
             continue;
            case 1: break;
            default:
              /*<<camlinternalFormat.ml:2882:10>>*/ return expected_character
                     (str_ind$0 + 1 | 0, cst_character, 125);
          }
        }
        else if(96 > match){
         if((str_ind$0 + 2 | 0) === end_ind)
           /*<<camlinternalFormat.ml:2862:40>>*/ unexpected_end_of_format
           (end_ind);
          /*<<camlinternalFormat.ml:2863:22>>*/  /*<<camlinternalFormat.ml:2863:22>>*/ var
          match$0 =
             /*<<camlinternalFormat.ml:2863:22>>*/ caml_string_get
             (str, str_ind$0 + 2 | 0);
         if(40 === match$0){
           /*<<camlinternalFormat.ml:2868:26>>*/ var
            /*<<camlinternalFormat.ml:2868:26>>*/ sub_end$0 =
             search_subformat_end(str_ind$0 + 3 | 0, end_ind, 41),
            /*<<camlinternalFormat.ml:2868:26>>*/ str_ind$3 =
             sub_end$0 + 2 | 0,
           str_ind$0 = str_ind$3;
          continue;
         }
         if(123 === match$0){
           /*<<camlinternalFormat.ml:2865:26>>*/ var
            /*<<camlinternalFormat.ml:2865:26>>*/ sub_end$1 =
             search_subformat_end(str_ind$0 + 3 | 0, end_ind, 125),
            /*<<camlinternalFormat.ml:2865:26>>*/ str_ind$4 =
             sub_end$1 + 2 | 0,
           str_ind$0 = str_ind$4;
          continue;
         }
         var str_ind$5 = str_ind$0 + 3 | 0, str_ind$0 = str_ind$5;
         continue;
        }
       }
       else{
        if(40 === match){
          /*<<camlinternalFormat.ml:2878:24>>*/ var
           /*<<camlinternalFormat.ml:2878:24>>*/ sub_end$2 =
            search_subformat_end(str_ind$0 + 2 | 0, end_ind, 41),
           /*<<camlinternalFormat.ml:2878:24>>*/ str_ind$6 = sub_end$2 + 2 | 0,
          str_ind$0 = str_ind$6;
         continue;
        }
        if(41 === match)
          /*<<camlinternalFormat.ml:2885:10>>*/ return expected_character
                 (str_ind$0 + 1 | 0, cst_character$0, 41);
       }
       var str_ind$1 = str_ind$0 + 2 | 0, str_ind$0 = str_ind$1;
      }
      else
       var str_ind$7 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$7;
     }
     /*<<camlinternalFormat.ml:2889:55>>*/ }
    function compute_int_conv(pct_ind, str_ind, plus, hash, space, symb){
      /*<<camlinternalFormat.ml:2903:4>>*/ var
      plus$0 = plus,
      hash$0 = hash,
      space$0 = space;
      /*<<camlinternalFormat.ml:2903:4>>*/ for(;;){
      a:
      {
       if(plus$0){
        if(! hash$0){
         if(space$0) break a;
         if(100 === symb)  /*<<camlinternalFormat.ml:2906:34>>*/ return 1;
         if(105 === symb)  /*<<camlinternalFormat.ml:2906:71>>*/ return 4;
         break a;
        }
       }
       else{
        if(! hash$0){
         if(space$0){
          if(100 === symb)  /*<<camlinternalFormat.ml:2905:34>>*/ return 2;
          if(105 === symb)  /*<<camlinternalFormat.ml:2905:71>>*/ return 5;
          break a;
         }
         var switcher$1 = symb - 88 | 0;
         if(32 < switcher$1 >>> 0) break a;
         switch(switcher$1){
           case 0:
             /*<<camlinternalFormat.ml:2907:71>>*/ return 8;
           case 12:
             /*<<camlinternalFormat.ml:2904:34>>*/ return 0;
           case 17:
             /*<<camlinternalFormat.ml:2904:71>>*/ return 3;
           case 23:
             /*<<camlinternalFormat.ml:2909:34>>*/ return 10;
           case 29:
             /*<<camlinternalFormat.ml:2911:34>>*/ return 12;
           case 32:
             /*<<camlinternalFormat.ml:2907:34>>*/ return 6;
           default: break a;
         }
        }
        if(! space$0){
         var switcher$0 = symb - 88 | 0;
         if(32 >= switcher$0 >>> 0)
          switch(switcher$0){
            case 0:
              /*<<camlinternalFormat.ml:2908:71>>*/ return 9;
            case 12:
              /*<<camlinternalFormat.ml:2912:34>>*/ return 13;
            case 17:
              /*<<camlinternalFormat.ml:2913:34>>*/ return 14;
            case 23:
              /*<<camlinternalFormat.ml:2910:34>>*/ return 11;
            case 29:
              /*<<camlinternalFormat.ml:2914:34>>*/ return 15;
            case 32:
              /*<<camlinternalFormat.ml:2908:34>>*/ return 7;
          }
        }
       }
       var switcher = symb - 88 | 0;
       if(32 >= switcher >>> 0)
        switch(switcher){
          case 0:
           if(legacy_behavior$0)
             /*<<camlinternalFormat.ml:2916:46>>*/ return 9;
           break;
          case 23:
           if(legacy_behavior$0)
             /*<<camlinternalFormat.ml:2917:46>>*/ return 11;
           break;
          case 32:
           if(legacy_behavior$0)
             /*<<camlinternalFormat.ml:2915:46>>*/ return 7;
           break;
          case 12:
          case 17:
          case 29:
           if(! legacy_behavior$0)
             /*<<camlinternalFormat.ml:2921:11>>*/ return incompatible_flag
                    (pct_ind, str_ind, symb, cst$35);
           var hash$0 = 0;
           continue;
        }
      }
      if(plus$0)
       if(space$0){
        if(! legacy_behavior$0)
          /*<<camlinternalFormat.ml:2926:11>>*/ return incompatible_flag
                 (pct_ind, str_ind, 32, cst$32);
        var space$0 = 0;
       }
       else{
        if(! legacy_behavior$0)
          /*<<camlinternalFormat.ml:2934:11>>*/ return incompatible_flag
                 (pct_ind, str_ind, symb, cst$33);
        var plus$0 = 0;
       }
      else{
       if(! space$0)
         /*<<camlinternalFormat.ml:2935:28>>*/ throw  /*<<camlinternalFormat.ml:2935:28>>*/ caml_maybe_attach_backtrace
               ([0, Assert_failure, _W_], 1);
       if(! legacy_behavior$0)
         /*<<camlinternalFormat.ml:2930:11>>*/ return incompatible_flag
                (pct_ind, str_ind, symb, cst$34);
       var space$0 = 0;
      }
     }
     /*<<camlinternalFormat.ml:2935:40>>*/ }
    function incompatible_flag(pct_ind, str_ind, symb, option){
      /*<<camlinternalFormat.ml:2963:6>>*/  /*<<camlinternalFormat.ml:2963:19>>*/ var
      subfmt =
         /*<<camlinternalFormat.ml:2963:19>>*/ caml_call3
         (Stdlib_String[16], str, pct_ind, str_ind - pct_ind | 0);
      /*<<camlinternalFormat.ml:2964:6>>*/ return  /*<<camlinternalFormat.ml:2964:6>>*/ caml_call5
             (failwith_message(_Y_), str, pct_ind, option, symb, subfmt);
     /*<<camlinternalFormat.ml:2967:38>>*/ }
    return parse(0, caml_ml_string_length(str));
   }
   function format_of_string_fmtty(str, fmtty){
     /*<<camlinternalFormat.ml:2977:2>>*/ var
     fmt = fmt_ebb_of_string(0, str)[1];
     /*<<camlinternalFormat.ml:2978:2>>*/ try{
      /*<<camlinternalFormat.ml:2978:6>>*/  /*<<camlinternalFormat.ml:2978:6>>*/ var
      _ae_ = [0, type_format(fmt, fmtty), str];
      /*<<camlinternalFormat.ml:2978:6>>*/ return _ae_;
    }
    catch(_af_){
     var _ac_ = caml_wrap_exception(_af_);
     if(_ac_ !== Type_mismatch) throw caml_maybe_attach_backtrace(_ac_, 0);
      /*<<camlinternalFormat.ml:2982:10>>*/  /*<<camlinternalFormat.ml:2982:10>>*/ var
      _ad_ = string_of_fmtty(fmtty);
      /*<<camlinternalFormat.ml:2982:10>>*/ return  /*<<camlinternalFormat.ml:2982:10>>*/ caml_call2
             (failwith_message(_Z_), str, _ad_);
    }
    /*<<camlinternalFormat.ml:2982:33>>*/ }
   function format_of_string_format(str, param){
    var
     str$0 = param[2],
     fmt = param[1],
     fmt$0 = fmt_ebb_of_string(0, str)[1];
     /*<<camlinternalFormat.ml:2988:2>>*/ try{
      /*<<camlinternalFormat.ml:2988:6>>*/  /*<<camlinternalFormat.ml:2988:6>>*/ var
      _aa_ = [0, type_format(fmt$0, fmtty_of_fmt(fmt)), str];
      /*<<camlinternalFormat.ml:2988:6>>*/ return _aa_;
    }
    catch(_ab_){
     var _$_ = caml_wrap_exception(_ab_);
     if(_$_ === Type_mismatch)
       /*<<camlinternalFormat.ml:2990:4>>*/ return  /*<<camlinternalFormat.ml:2990:4>>*/ caml_call2
              (failwith_message(___), str, str$0);
     throw caml_maybe_attach_backtrace(_$_, 0);
    }
   }
   var
    CamlinternalFormat =
      [0,
       is_in_char_set,
       rev_char_set,
       create_char_set,
       add_in_char_set,
       freeze_char_set,
       param_format_of_ignored_format,
       make_printf,
       make_iprintf,
       output_acc,
       bufput_acc,
       strput_acc,
       type_format,
       fmt_ebb_of_string,
       format_of_string_fmtty,
       format_of_string_format,
       char_of_iconv,
       string_of_formatting_lit,
       string_of_fmtty,
       string_of_fmt,
       open_box_of_string,
       symm,
       trans,
       recast];
   runtime.caml_register_global(197, CamlinternalFormat, "CamlinternalFormat");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Printf
//# unitInfo: Requires: CamlinternalFormat, Stdlib, Stdlib__Buffer
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    CamlinternalFormat = global_data.CamlinternalFormat,
    Stdlib = global_data.Stdlib;
   function kfprintf(k, o, param){
    var fmt = param[1];
     /*<<printf.ml:20:2>>*/ return  /*<<printf.ml:20:2>>*/ caml_call3
            (CamlinternalFormat[7],
             function(acc){
               /*<<printf.ml:20:26>>*/  /*<<printf.ml:20:26>>*/ caml_call2
               (CamlinternalFormat[9], o, acc);
              return caml_call1(k, o);
              /*<<printf.ml:20:47>>*/ },
             0,
             fmt);
   }
   function kbprintf(k, b, param){
    var fmt = param[1];
     /*<<printf.ml:22:2>>*/ return  /*<<printf.ml:22:2>>*/ caml_call3
            (CamlinternalFormat[7],
             function(acc){
               /*<<printf.ml:22:26>>*/  /*<<printf.ml:22:26>>*/ caml_call2
               (CamlinternalFormat[10], b, acc);
              return caml_call1(k, b);
              /*<<printf.ml:22:47>>*/ },
             0,
             fmt);
   }
   function ikfprintf(k, oc, param){
    var fmt = param[1];
     /*<<printf.ml:24:2>>*/ return  /*<<printf.ml:24:2>>*/ caml_call3
            (CamlinternalFormat[8], k, oc, fmt);
   }
   function fprintf(oc, fmt){
     /*<<printf.ml:27:21>>*/ return kfprintf
            (function(_d_){ /*<<?>>*/ return 0;}, oc, fmt);
    /*<<printf.ml:27:43>>*/ }
   function bprintf(b, fmt){
     /*<<printf.ml:28:20>>*/ return kbprintf
            (function(_c_){ /*<<?>>*/ return 0;}, b, fmt);
    /*<<printf.ml:28:41>>*/ }
   function ifprintf(oc, fmt){
     /*<<printf.ml:29:22>>*/ return ikfprintf
            (function(_b_){ /*<<?>>*/ return 0;}, oc, fmt);
    /*<<printf.ml:29:45>>*/ }
   function ibprintf(b, fmt){
     /*<<printf.ml:30:21>>*/ return ikfprintf
            (function(_a_){ /*<<?>>*/ return 0;}, b, fmt);
    /*<<printf.ml:30:43>>*/ }
   function printf(fmt){
     /*<<printf.ml:31:17>>*/ return fprintf(Stdlib[39], fmt);
    /*<<printf.ml:31:35>>*/ }
   function eprintf(fmt){
     /*<<printf.ml:32:18>>*/ return fprintf(Stdlib[40], fmt);
    /*<<printf.ml:32:36>>*/ }
   function ksprintf(k, param){
    var fmt = param[1];
     /*<<printf.ml:35:2>>*/ function k$0(acc){
      /*<<printf.ml:36:4>>*/  /*<<printf.ml:36:14>>*/ var
      buf =  /*<<printf.ml:36:14>>*/ caml_call1(Stdlib_Buffer[1], 64);
      /*<<printf.ml:37:4>>*/  /*<<printf.ml:37:4>>*/ caml_call2
      (CamlinternalFormat[11], buf, acc);
      /*<<printf.ml:38:6>>*/ return  /*<<printf.ml:38:6>>*/ caml_call1
             (k,  /*<<printf.ml:38:6>>*/ caml_call1(Stdlib_Buffer[2], buf));
     /*<<printf.ml:38:27>>*/ }
     /*<<printf.ml:39:2>>*/ return  /*<<printf.ml:39:2>>*/ caml_call3
            (CamlinternalFormat[7], k$0, 0, fmt);
   }
   function sprintf(fmt){
     /*<<printf.ml:41:18>>*/ return ksprintf
            (function(s){
               /*<<printf.ml:41:37>>*/ return s;
              /*<<printf.ml:41:38>>*/ },
             fmt);
    /*<<printf.ml:41:43>>*/ }
   var
    Stdlib_Printf =
      [0,
       fprintf,
       printf,
       eprintf,
       sprintf,
       bprintf,
       ifprintf,
       ibprintf,
       kfprintf,
       ikfprintf,
       ksprintf,
       kbprintf,
       ikfprintf,
       ksprintf];
   runtime.caml_register_global(3, Stdlib_Printf, "Stdlib__Printf");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Arg
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Buffer, Stdlib__Int, Stdlib__List, Stdlib__Printf, Stdlib__String, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$8 = "",
    cst$10 = "  ",
    cst_Display_this_list_of_optio$1 = " Display this list of options",
    cst_s = "%s",
    cst_help$4 = "--help",
    cst_help$3 = "-help",
    cst$9 = ".\n",
    cst_a_float$1 = "a float",
    cst_an_integer$1 = "an integer",
    caml_check_bound = runtime.caml_check_bound,
    caml_equal = runtime.caml_equal,
    caml_fresh_oo_id = runtime.caml_fresh_oo_id,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_get = runtime.caml_string_get,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_sys_argv = runtime.caml_sys_argv,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
    /*<<?>>*/ function caml_call6(f, a0, a1, a2, a3, a4, a5){
    return (f.l >= 0 ? f.l : f.l = f.length) == 6
            ? f(a0, a1, a2, a3, a4, a5)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4, a5]);
   }
    /*<<arg.ml:50:0>>*/ var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$7 = "\n",
    cst$4 = cst$8,
    cst$5 = " ",
    cst$6 = cst$8,
    cst$2 = "(?)",
    cst$3 = "-",
    cst = "}",
    cst$0 = "|",
    cst$1 = "{",
    Stdlib = global_data.Stdlib,
    Stdlib_Printf = global_data.Stdlib__Printf,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Int = global_data.Stdlib__Int,
     /*<<arg.ml:50:0>>*/ Bad = [248, "Stdlib.Arg.Bad", caml_fresh_oo_id(0)],
     /*<<arg.ml:51:0>>*/ Help = [248, "Stdlib.Arg.Help", caml_fresh_oo_id(0)],
     /*<<arg.ml:59:0>>*/ Stop = [248, "Stdlib.Arg.Stop", caml_fresh_oo_id(0)],
    cst_none = "<none>",
    _a_ =
      [0, [11, cst$10, [2, 0, [12, 32, [2, 0, [12, 10, 0]]]]], "  %s %s\n"],
    _b_ =
      [0,
       [11, cst$10, [2, 0, [12, 32, [2, 0, [2, 0, [12, 10, 0]]]]]],
       "  %s %s%s\n"],
    _c_ = [0, cst_help$3],
    cst_Display_this_list_of_optio = cst_Display_this_list_of_optio$1,
    cst_help = cst_help$3,
    cst_Display_this_list_of_optio$0 = cst_Display_this_list_of_optio$1,
    cst_help$0 = cst_help$4,
    cst_help$1 = cst_help$4,
    cst_help$2 = cst_help$3,
    _d_ = [0, [2, 0, [12, 10, 0]], "%s\n"],
    _e_ = [0, [2, 0, 0], cst_s];
   function assoc3(x, l){
     /*<<arg.ml:64:2>>*/ var l$0 = l;
     /*<<arg.ml:64:2>>*/ for(;;){
     if(! l$0)
       /*<<arg.ml:65:10>>*/ throw  /*<<arg.ml:65:10>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var match = l$0[1], y2 = match[2], y1 = match[1];
      /*<<arg.ml:66:26>>*/ if( /*<<arg.ml:66:26>>*/ caml_equal(y1, x))
       /*<<arg.ml:66:36>>*/ return y2;
     var t = l$0[2], l$0 = t;
    }
    /*<<arg.ml:67:24>>*/ }
   function make_symlist(prefix, sep, suffix, l){
     /*<<arg.ml:77:2>>*/ if(! l)  /*<<arg.ml:78:10>>*/ return cst_none;
     /*<<arg.ml:79:53>>*/ var
     t = l[2],
     h = l[1],
      /*<<arg.ml:79:53>>*/ _az_ =
        /*<<arg.ml:79:53>>*/ caml_call2(Stdlib[28], prefix, h),
      /*<<arg.ml:79:12>>*/ _aA_ =
        /*<<arg.ml:79:12>>*/ caml_call3
        (Stdlib_List[26],
         function(x, y){
           /*<<arg.ml:79:40>>*/  /*<<arg.ml:79:44>>*/ var
           _aB_ =  /*<<arg.ml:79:44>>*/ caml_call2(Stdlib[28], sep, y);
           /*<<arg.ml:79:44>>*/ return  /*<<arg.ml:79:44>>*/ caml_call2
                  (Stdlib[28], x, _aB_);
          /*<<arg.ml:79:51>>*/ },
         _az_,
         t);
     /*<<arg.ml:79:12>>*/ return  /*<<arg.ml:79:12>>*/ caml_call2
            (Stdlib[28], _aA_, suffix);
    /*<<arg.ml:79:77>>*/ }
   function help_action(param){
     /*<<arg.ml:91:21>>*/ throw  /*<<arg.ml:91:21>>*/ caml_maybe_attach_backtrace
           ([0, Stop, _c_], 1);
    /*<<arg.ml:91:51>>*/ }
   function add_help(speclist){
     /*<<arg.ml:94:2>>*/ try{
      /*<<arg.ml:95:15>>*/ assoc3(cst_help$2, speclist);
      /*<<arg.ml:95:42>>*/ var  /*<<arg.ml:95:42>>*/ _aw_ = 0, add1 = _aw_;
    }
    catch(_ay_){
     var _as_ = caml_wrap_exception(_ay_);
     if(_as_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_as_, 0);
     var
      add1 =
        [0,
         [0, cst_help, [0, help_action], cst_Display_this_list_of_optio],
         0];
    }
    try{
      /*<<arg.ml:99:15>>*/ assoc3(cst_help$1, speclist);
      /*<<arg.ml:99:43>>*/ var  /*<<arg.ml:99:43>>*/ _av_ = 0, add2 = _av_;
    }
    catch(_ax_){
     var _at_ = caml_wrap_exception(_ax_);
     if(_at_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_at_, 0);
     var
      add2 =
        [0,
         [0, cst_help$0, [0, help_action], cst_Display_this_list_of_optio$0],
         0];
    }
     /*<<arg.ml:103:13>>*/  /*<<arg.ml:103:13>>*/ var
     _au_ =  /*<<arg.ml:103:13>>*/ caml_call2(Stdlib[37], add1, add2);
     /*<<arg.ml:103:13>>*/ return  /*<<arg.ml:103:13>>*/ caml_call2
            (Stdlib[37], speclist, _au_);
    /*<<arg.ml:103:26>>*/ }
   function usage_b(buf, speclist, errmsg){
     /*<<arg.ml:107:2>>*/  /*<<arg.ml:107:2>>*/ caml_call3
     (Stdlib_Printf[5], buf, _d_, errmsg);
     /*<<arg.ml:108:29>>*/  /*<<arg.ml:108:29>>*/ var
     _ap_ = add_help(speclist);
     /*<<arg.ml:108:29>>*/ return  /*<<arg.ml:108:29>>*/ caml_call2
            (Stdlib_List[18],
             function(param){
              var
               doc = param[3],
               spec = param[2],
               key = param[1],
               _aq_ =
                 0 <  /*<<arg.ml:83:2>>*/ caml_ml_string_length(doc) ? 1 : 0;
              if(! _aq_) return _aq_;
              if(11 !== spec[0])
                /*<<arg.ml:88:8>>*/ return  /*<<arg.ml:88:8>>*/ caml_call4
                       (Stdlib_Printf[5], buf, _a_, key, doc);
               /*<<arg.ml:86:38>>*/ var
               l = spec[1],
                /*<<arg.ml:86:38>>*/ _ar_ = make_symlist(cst$1, cst$0, cst, l);
               /*<<arg.ml:86:8>>*/ return  /*<<arg.ml:86:8>>*/ caml_call5
                      (Stdlib_Printf[5], buf, _b_, key, _ar_, doc);
             },
             _ap_);
    /*<<arg.ml:108:48>>*/ }
   function usage_string(speclist, errmsg){
     /*<<arg.ml:112:2>>*/  /*<<arg.ml:112:10>>*/ var
     b =  /*<<arg.ml:112:10>>*/ caml_call1(Stdlib_Buffer[1], 200);
     /*<<arg.ml:113:2>>*/ usage_b(b, speclist, errmsg);
     /*<<arg.ml:113:2>>*/ return  /*<<arg.ml:113:2>>*/ caml_call1
            (Stdlib_Buffer[2], b);
    /*<<arg.ml:114:19>>*/ }
   function usage(speclist, errmsg){
     /*<<arg.ml:118:2>>*/  /*<<arg.ml:118:15>>*/ var
     _ao_ = usage_string(speclist, errmsg);
     /*<<arg.ml:118:15>>*/ return  /*<<arg.ml:118:15>>*/ caml_call2
            (Stdlib_Printf[3], _e_, _ao_);
    /*<<arg.ml:118:45>>*/ }
    /*<<arg.ml:121:14>>*/ var
     /*<<arg.ml:121:14>>*/ current = [0, 0],
    _f_ =
      [0,
       [2, 0, [11, ": unknown option '", [2, 0, [11, "'.\n", 0]]]],
       "%s: unknown option '%s'.\n"],
    _g_ = [0, cst_help$3],
    _h_ = [0, cst_help$4],
    _i_ =
      [0,
       [2,
        0,
        [11,
         ": wrong argument '",
         [2,
          0,
          [11,
           "'; option '",
           [2, 0, [11, "' expects ", [2, 0, [11, cst$9, 0]]]]]]]],
       "%s: wrong argument '%s'; option '%s' expects %s.\n"],
    _j_ =
      [0,
       [2, 0, [11, ": option '", [2, 0, [11, "' needs an argument.\n", 0]]]],
       "%s: option '%s' needs an argument.\n"],
    _k_ = [0, [2, 0, [11, ": ", [2, 0, [11, cst$9, 0]]]], "%s: %s.\n"],
    cst_no_argument = "no argument",
    cst_a_boolean = "a boolean",
    cst_an_integer = cst_an_integer$1,
    cst_an_integer$0 = cst_an_integer$1,
    cst_a_float = cst_a_float$1,
    cst_a_float$0 = cst_a_float$1,
    cst_one_of = "one of: ",
    cst_Arg_Expand_is_is_only_allo =
      "Arg.Expand is is only allowed with Arg.parse_and_expand_argv_dynamic",
    _l_ = [0, [2, 0, 0], cst_s],
    _m_ = [0, [2, 0, 0], cst_s],
    _n_ = [0, [2, 0, 0], cst_s],
    _o_ = [0, [2, 0, 0], cst_s],
    _p_ = [0, [2, 0, 0], cst_s],
    _q_ = [0, [2, 0, 0], cst_s];
   function int_of_string_opt(x){
     /*<<arg.ml:128:2>>*/ try{
      /*<<arg.ml:128:6>>*/  /*<<arg.ml:128:6>>*/ var
      _am_ = [0,  /*<<arg.ml:128:11>>*/ runtime.caml_int_of_string(x)];
      /*<<arg.ml:128:6>>*/ return _am_;
    }
    catch(_an_){
     var _al_ = caml_wrap_exception(_an_);
     if(_al_[1] === Stdlib[7])  /*<<arg.ml:129:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_al_, 0);
    }
    /*<<arg.ml:129:24>>*/ }
   function float_of_string_opt(x){
     /*<<arg.ml:132:2>>*/ try{
      /*<<arg.ml:132:6>>*/  /*<<arg.ml:132:6>>*/ var
      _aj_ = [0,  /*<<arg.ml:132:11>>*/ runtime.caml_float_of_string(x)];
      /*<<arg.ml:132:6>>*/ return _aj_;
    }
    catch(_ak_){
     var _ai_ = caml_wrap_exception(_ak_);
     if(_ai_[1] === Stdlib[7])  /*<<arg.ml:133:20>>*/ return 0;
     throw caml_maybe_attach_backtrace(_ai_, 0);
    }
    /*<<arg.ml:133:24>>*/ }
   function parse_and_expand_argv_dynamic_
   (allow_expand, current, argv, speclist, anonfun, errmsg){
    var initpos = current[1];
    function convert_error(error){
      /*<<arg.ml:143:4>>*/ var
       /*<<arg.ml:143:12>>*/ b =
         /*<<arg.ml:143:12>>*/ caml_call1(Stdlib_Buffer[1], 200),
      progname =
        initpos < argv[1].length - 1
         ? caml_check_bound(argv[1], initpos)[1 + initpos]
         : cst$2;
      /*<<arg.ml:146:4>>*/ switch(error[0]){
       case 0:
        var s = error[1];
        if
         (caml_string_notequal(s, cst_help$4)
          && caml_string_notequal(s, cst_help$3))
          /*<<arg.ml:150:10>>*/  /*<<arg.ml:150:10>>*/ caml_call4
          (Stdlib_Printf[5], b, _f_, progname, s);
        break;
       case 1:
        var expected = error[3], arg = error[2], opt = error[1];
         /*<<arg.ml:154:10>>*/  /*<<arg.ml:154:10>>*/ caml_call6
         (Stdlib_Printf[5], b, _i_, progname, arg, opt, expected);
        break;
       case 2:
        var s$0 = error[1];
         /*<<arg.ml:152:10>>*/  /*<<arg.ml:152:10>>*/ caml_call4
         (Stdlib_Printf[5], b, _j_, progname, s$0);
        break;
       default:
        var s$1 = error[1];
         /*<<arg.ml:157:10>>*/  /*<<arg.ml:157:10>>*/ caml_call4
         (Stdlib_Printf[5], b, _k_, progname, s$1);
     }
      /*<<arg.ml:159:4>>*/ usage_b(b, speclist[1], errmsg);
      /*<<arg.ml:160:34>>*/ if
      (!
        /*<<arg.ml:160:7>>*/ caml_equal(error, _g_)
       && !  /*<<arg.ml:160:34>>*/ caml_equal(error, _h_))
       /*<<arg.ml:162:9>>*/ return [0,
              Bad,
               /*<<arg.ml:162:13>>*/ caml_call1(Stdlib_Buffer[2], b)];
      /*<<arg.ml:161:9>>*/ return [0,
             Help,
              /*<<arg.ml:161:14>>*/ caml_call1(Stdlib_Buffer[2], b)];
     /*<<arg.ml:162:32>>*/ }
     /*<<arg.ml:164:2>>*/ current[1]++;
    for(;;){
     if(current[1] >= argv[1].length - 1) return 0;
      /*<<arg.ml:166:4>>*/ try{
       /*<<arg.ml:167:14>>*/ var
       _V_ = current[1],
        /*<<arg.ml:167:14>>*/ s = caml_check_bound(argv[1], _V_)[1 + _V_];
       /*<<arg.ml:168:9>>*/ if
       ( /*<<arg.ml:168:9>>*/ caml_call2(Stdlib_String[11], cst$3, s)){
       try{
         /*<<arg.ml:170:14>>*/ var
         follow$1 = 0,
          /*<<arg.ml:170:14>>*/ _Z_ = assoc3(s, speclist[1]),
         follow$0 = follow$1,
         action = _Z_;
       }
       catch(_ag_){
        var _W_ = caml_wrap_exception(_ag_);
        if(_W_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_W_, 0);
         /*<<arg.ml:172:10>>*/ try{
          /*<<arg.ml:71:10>>*/ var
           /*<<arg.ml:71:10>>*/ i =
             /*<<arg.ml:71:10>>*/ caml_call2(Stdlib_String[36], s, 61),
           /*<<arg.ml:72:2>>*/ len =
             /*<<arg.ml:72:2>>*/ caml_ml_string_length(s),
           /*<<arg.ml:73:20>>*/ arg =
             /*<<arg.ml:73:20>>*/ caml_call3
             (Stdlib_String[16], s, i + 1 | 0, len - (i + 1 | 0) | 0),
           /*<<arg.ml:73:2>>*/ keyword =
             /*<<arg.ml:73:2>>*/ caml_call3(Stdlib_String[16], s, 0, i),
           /*<<arg.ml:174:38>>*/ follow = [0, arg],
           /*<<arg.ml:174:12>>*/ _Y_ = assoc3(keyword, speclist[1]),
          follow$0 = follow,
          action = _Y_;
        }
        catch(_ah_){
         var _X_ = caml_wrap_exception(_ah_);
         if(_X_ === Stdlib[8])
           /*<<arg.ml:175:28>>*/ throw  /*<<arg.ml:175:28>>*/ caml_maybe_attach_backtrace
                 ([0, Stop, [0, s]], 1);
         throw caml_maybe_attach_backtrace(_X_, 0);
        }
       }
       let s$0 = s, follow$2 = follow$0;
       var
        no_arg =
          function(param){
            /*<<arg.ml:178:10>>*/ if(! follow$2)
             /*<<arg.ml:179:20>>*/ return;
           var arg = follow$2[1];
            /*<<arg.ml:180:24>>*/ throw  /*<<arg.ml:180:24>>*/ caml_maybe_attach_backtrace
                  ([0, Stop, [1, s$0, arg, cst_no_argument]], 1);
           /*<<arg.ml:180:68>>*/ },
        get_arg =
          function(param){
            /*<<arg.ml:182:10>>*/ if(follow$2){
            var arg = follow$2[1];
             /*<<arg.ml:186:24>>*/ return arg;
           }
           if((current[1] + 1 | 0) >= argv[1].length - 1)
             /*<<arg.ml:185:19>>*/ throw  /*<<arg.ml:185:19>>*/ caml_maybe_attach_backtrace
                   ([0, Stop, [2, s$0]], 1);
           var _af_ = current[1] + 1 | 0;
            /*<<arg.ml:184:58>>*/ return caml_check_bound(argv[1], _af_)
                   [1 + _af_];
           /*<<arg.ml:186:27>>*/ },
        consume_arg =
          function(param){
            /*<<arg.ml:189:10>>*/ return follow$2 ? 0 : (current[1]++, 0);
           /*<<arg.ml:191:24>>*/ },
        treat_action =
          function(param){
            /*<<arg.ml:193:31>>*/ switch(param[0]){
             case 0:
              var f = param[1];
               /*<<arg.ml:194:20>>*/ no_arg$0(0);
               /*<<arg.ml:194:20>>*/ return  /*<<arg.ml:194:20>>*/ caml_call1
                      (f, 0);
             case 1:
               /*<<arg.ml:196:22>>*/ var
               f$0 = param[1],
                /*<<arg.ml:196:22>>*/ arg = get_arg$0(0);
               /*<<arg.ml:124:2>>*/ try{
                /*<<arg.ml:124:6>>*/ var
                 /*<<arg.ml:124:6>>*/ _$_ =
                  [0,  /*<<arg.ml:124:11>>*/ caml_call1(Stdlib[32], arg)],
                match = _$_;
              }
              catch(_ae_){
               var ___ = caml_wrap_exception(_ae_);
               if(___[1] !== Stdlib[6])
                throw caml_maybe_attach_backtrace(___, 0);
               var match = 0;
              }
              if(! match)
                /*<<arg.ml:198:22>>*/ throw  /*<<arg.ml:198:22>>*/ caml_maybe_attach_backtrace
                      ([0, Stop, [1, s$0, arg, cst_a_boolean]], 1);
              var s = match[1];
               /*<<arg.ml:199:24>>*/  /*<<arg.ml:199:24>>*/ caml_call1(f$0, s);
               /*<<arg.ml:201:12>>*/ return consume_arg$0(0);
             case 2:
              var r = param[1];
               /*<<arg.ml:202:19>>*/ no_arg$0(0);
              r[1] = 1;
              return 0;
             case 3:
              var r$0 = param[1];
               /*<<arg.ml:203:21>>*/ no_arg$0(0);
              r$0[1] = 0;
              return 0;
             case 4:
               /*<<arg.ml:205:22>>*/ var
               f$1 = param[1],
                /*<<arg.ml:205:22>>*/ arg$0 = get_arg$0(0);
               /*<<arg.ml:206:12>>*/  /*<<arg.ml:206:12>>*/ caml_call1
               (f$1, arg$0);
               /*<<arg.ml:206:12>>*/ return consume_arg$0(0);
             case 5:
              var r$1 = param[1];
              r$1[1] = get_arg$0(0);
               /*<<arg.ml:219:12>>*/ return consume_arg$0(0);
             case 6:
               /*<<arg.ml:221:22>>*/ var
               f$2 = param[1],
                /*<<arg.ml:221:22>>*/ arg$1 = get_arg$0(0),
                /*<<arg.ml:222:24>>*/ match$0 = int_of_string_opt(arg$1);
              if(! match$0)
                /*<<arg.ml:223:22>>*/ throw  /*<<arg.ml:223:22>>*/ caml_maybe_attach_backtrace
                      ([0, Stop, [1, s$0, arg$1, cst_an_integer]], 1);
              var x = match$0[1];
               /*<<arg.ml:224:24>>*/  /*<<arg.ml:224:24>>*/ caml_call1(f$2, x);
               /*<<arg.ml:226:12>>*/ return consume_arg$0(0);
             case 7:
               /*<<arg.ml:228:22>>*/ var
               r$2 = param[1],
                /*<<arg.ml:228:22>>*/ arg$2 = get_arg$0(0),
                /*<<arg.ml:229:24>>*/ match$1 = int_of_string_opt(arg$2);
              if(! match$1)
                /*<<arg.ml:230:22>>*/ throw  /*<<arg.ml:230:22>>*/ caml_maybe_attach_backtrace
                      ([0, Stop, [1, s$0, arg$2, cst_an_integer$0]], 1);
              var x$0 = match$1[1];
              r$2[1] = x$0;
               /*<<arg.ml:233:12>>*/ return consume_arg$0(0);
             case 8:
               /*<<arg.ml:235:22>>*/ var
               f$3 = param[1],
                /*<<arg.ml:235:22>>*/ arg$3 = get_arg$0(0),
                /*<<arg.ml:236:24>>*/ match$2 = float_of_string_opt(arg$3);
              if(! match$2)
                /*<<arg.ml:237:22>>*/ throw  /*<<arg.ml:237:22>>*/ caml_maybe_attach_backtrace
                      ([0, Stop, [1, s$0, arg$3, cst_a_float]], 1);
              var x$1 = match$2[1];
               /*<<arg.ml:238:24>>*/  /*<<arg.ml:238:24>>*/ caml_call1
               (f$3, x$1);
               /*<<arg.ml:240:12>>*/ return consume_arg$0(0);
             case 9:
               /*<<arg.ml:242:22>>*/ var
               r$3 = param[1],
                /*<<arg.ml:242:22>>*/ arg$4 = get_arg$0(0),
                /*<<arg.ml:243:24>>*/ match$3 = float_of_string_opt(arg$4);
              if(! match$3)
                /*<<arg.ml:244:22>>*/ throw  /*<<arg.ml:244:22>>*/ caml_maybe_attach_backtrace
                      ([0, Stop, [1, s$0, arg$4, cst_a_float$0]], 1);
              var x$2 = match$3[1];
              r$3[1] = x$2;
               /*<<arg.ml:247:12>>*/ return consume_arg$0(0);
             case 10:
              var specs = param[1];
               /*<<arg.ml:249:12>>*/ no_arg$0(0);
               /*<<arg.ml:249:12>>*/ return  /*<<arg.ml:249:12>>*/ caml_call2
                      (Stdlib_List[18], treat_action$0, specs);
             case 11:
               /*<<arg.ml:209:22>>*/ var
               f$4 = param[2],
               symb = param[1],
                /*<<arg.ml:209:22>>*/ arg$5 = get_arg$0(0);
               /*<<arg.ml:210:15>>*/ if
               ( /*<<arg.ml:210:15>>*/ caml_call2
                 (Stdlib_List[37], arg$5, symb)){
                /*<<arg.ml:211:14>>*/  /*<<arg.ml:211:14>>*/ caml_call1
                (f$4, arg$5);
                /*<<arg.ml:211:14>>*/ return consume_arg$0(0);
              }
               /*<<arg.ml:215:44>>*/  /*<<arg.ml:215:44>>*/ var
               _aa_ = make_symlist(cst$6, cst$5, cst$4, symb);
               /*<<arg.ml:213:21>>*/ throw  /*<<arg.ml:213:21>>*/ caml_maybe_attach_backtrace
                     ([0,
                       Stop,
                       [1,
                        s$0,
                        arg$5,
                         /*<<arg.ml:214:42>>*/ caml_call2
                         (Stdlib[28], cst_one_of, _aa_)]],
                      1);
             case 12:
              var f$5 = param[1];
               /*<<arg.ml:252:12>>*/ no_arg$0(0);
               /*<<arg.ml:255:14>>*/ for(;;){
               if(current[1] >= (argv[1].length - 1 - 1 | 0)) return 0;
               var _ab_ = current[1] + 1 | 0;
                /*<<arg.ml:254:14>>*/  /*<<arg.ml:254:14>>*/ caml_call1
                (f$5, caml_check_bound(argv[1], _ab_)[1 + _ab_]);
                /*<<arg.ml:255:14>>*/ consume_arg$0(0);
              }
              break;
             case 13:
              var f$6 = param[1];
               /*<<arg.ml:258:12>>*/ no_arg$0(0);
               /*<<arg.ml:259:22>>*/  /*<<arg.ml:259:22>>*/ var acc = [0, 0];
               /*<<arg.ml:262:14>>*/ for(;;){
               if(current[1] >= (argv[1].length - 1 - 1 | 0))
                 /*<<arg.ml:264:14>>*/ return  /*<<arg.ml:264:14>>*/ caml_call1
                        (f$6,
                          /*<<arg.ml:264:14>>*/ caml_call1(Stdlib_List[10], acc[1]));
               var _ad_ = current[1] + 1 | 0, _ac_ = acc[1];
               acc[1] = [0, caml_check_bound(argv[1], _ad_)[1 + _ad_], _ac_];
                /*<<arg.ml:262:14>>*/ consume_arg$0(0);
              }
              break;
             default:
              var f$7 = param[1];
              if(1 - allow_expand)
                /*<<arg.ml:267:14>>*/ throw  /*<<arg.ml:267:14>>*/ caml_maybe_attach_backtrace
                      ([0, Stdlib[6], cst_Arg_Expand_is_is_only_allo], 1);
               /*<<arg.ml:269:22>>*/ var
                /*<<arg.ml:269:22>>*/ arg$6 = get_arg$0(0),
                /*<<arg.ml:270:25>>*/ newarg =
                  /*<<arg.ml:270:25>>*/ caml_call1(f$7, arg$6);
               /*<<arg.ml:271:12>>*/ consume_arg$0(0);
               /*<<arg.ml:272:25>>*/ var
                /*<<arg.ml:272:25>>*/ before =
                  /*<<arg.ml:272:25>>*/ caml_call3
                  (Stdlib_Array[5], argv[1], 0, current[1] + 1 | 0),
                /*<<arg.ml:274:14>>*/ after =
                  /*<<arg.ml:274:14>>*/ caml_call3
                  (Stdlib_Array[5],
                   argv[1],
                   current[1] + 1 | 0,
                   (argv[1].length - 1 - current[1] | 0) - 1 | 0);
              argv[1] =
                /*<<arg.ml:276:19>>*/ caml_call1
                (Stdlib_Array[4], [0, before, [0, newarg, [0, after, 0]]]);
              return 0;
           }
           /*<<arg.ml:276:54>>*/ };
       let
        no_arg$0 = no_arg,
        get_arg$0 = get_arg,
        consume_arg$0 = consume_arg,
        treat_action$0 = treat_action;
        /*<<arg.ml:278:8>>*/ treat_action(action);
      }
      else
        /*<<arg.ml:279:11>>*/  /*<<arg.ml:279:11>>*/ caml_call1(anonfun, s);
     }
     catch(exn$0){
      var exn = caml_wrap_exception(exn$0);
      if(exn[1] === Bad){
       var m = exn[2];
        /*<<arg.ml:280:26>>*/ throw  /*<<arg.ml:280:26>>*/ caml_maybe_attach_backtrace
              (convert_error([3, m]), 1);
      }
      if(exn[1] !== Stop) throw caml_maybe_attach_backtrace(exn, 0);
      var e = exn[2];
       /*<<arg.ml:281:27>>*/ throw  /*<<arg.ml:281:27>>*/ caml_maybe_attach_backtrace
             (convert_error(e), 1);
     }
     current[1]++;
    }
   }
   function parse_and_expand_argv_dynamic
   (current, argv, speclist, anonfun, errmsg){
     /*<<arg.ml:287:2>>*/ return parse_and_expand_argv_dynamic_
            (1, current, argv, speclist, anonfun, errmsg);
    /*<<arg.ml:287:77>>*/ }
   function parse_argv_dynamic(opt, argv, speclist, anonfun, errmsg){
     /*<<arg.ml:290:2>>*/ if(opt)
     var sth = opt[1], current$0 = sth;
    else
     var current$0 = current;
     /*<<arg.ml:290:2>>*/ return parse_and_expand_argv_dynamic_
            (0, current$0, [0, argv], speclist, anonfun, errmsg);
    /*<<arg.ml:291:10>>*/ }
   function parse_argv(opt, argv, speclist, anonfun, errmsg){
     /*<<arg.ml:295:2>>*/ if(opt)
     var sth = opt[1], current$0 = sth;
    else
     var current$0 = current;
     /*<<arg.ml:295:2>>*/ return parse_argv_dynamic
            ([0, current$0], argv, [0, speclist], anonfun, errmsg);
    /*<<arg.ml:295:72>>*/ }
   function parse(l, f, msg){
     /*<<arg.ml:299:2>>*/ try{
      /*<<arg.ml:300:4>>*/  /*<<arg.ml:300:4>>*/ var
      _U_ = parse_argv(0, caml_sys_argv(0), l, f, msg);
      /*<<arg.ml:300:4>>*/ return _U_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] === Bad){
      var msg$0 = exn[2];
       /*<<arg.ml:302:15>>*/  /*<<arg.ml:302:15>>*/ caml_call2
       (Stdlib_Printf[3], _l_, msg$0);
       /*<<arg.ml:302:15>>*/ return  /*<<arg.ml:302:15>>*/ caml_call1
              (Stdlib[99], 2);
     }
     if(exn[1] !== Help) throw caml_maybe_attach_backtrace(exn, 0);
     var msg$1 = exn[2];
      /*<<arg.ml:303:16>>*/  /*<<arg.ml:303:16>>*/ caml_call2
      (Stdlib_Printf[2], _m_, msg$1);
      /*<<arg.ml:303:16>>*/ return  /*<<arg.ml:303:16>>*/ caml_call1
             (Stdlib[99], 0);
    }
    /*<<arg.ml:303:39>>*/ }
   function parse_dynamic(l, f, msg){
     /*<<arg.ml:307:2>>*/ try{
      /*<<arg.ml:308:4>>*/  /*<<arg.ml:308:4>>*/ var
      _T_ = parse_argv_dynamic(0, caml_sys_argv(0), l, f, msg);
      /*<<arg.ml:308:4>>*/ return _T_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] === Bad){
      var msg$0 = exn[2];
       /*<<arg.ml:310:15>>*/  /*<<arg.ml:310:15>>*/ caml_call2
       (Stdlib_Printf[3], _n_, msg$0);
       /*<<arg.ml:310:15>>*/ return  /*<<arg.ml:310:15>>*/ caml_call1
              (Stdlib[99], 2);
     }
     if(exn[1] !== Help) throw caml_maybe_attach_backtrace(exn, 0);
     var msg$1 = exn[2];
      /*<<arg.ml:311:16>>*/  /*<<arg.ml:311:16>>*/ caml_call2
      (Stdlib_Printf[2], _o_, msg$1);
      /*<<arg.ml:311:16>>*/ return  /*<<arg.ml:311:16>>*/ caml_call1
             (Stdlib[99], 0);
    }
    /*<<arg.ml:311:39>>*/ }
   function parse_expand(l, f, msg){
     /*<<arg.ml:314:2>>*/ try{
      /*<<arg.ml:315:15>>*/ var
       /*<<arg.ml:315:15>>*/ argv = [0, caml_sys_argv(0)],
       /*<<arg.ml:316:15>>*/ spec = [0, l],
       /*<<arg.ml:317:18>>*/ current$0 = [0, current[1]],
       /*<<arg.ml:318:4>>*/ _S_ =
        parse_and_expand_argv_dynamic(current$0, argv, spec, f, msg);
      /*<<arg.ml:318:4>>*/ return _S_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] === Bad){
      var msg$0 = exn[2];
       /*<<arg.ml:320:15>>*/  /*<<arg.ml:320:15>>*/ caml_call2
       (Stdlib_Printf[3], _p_, msg$0);
       /*<<arg.ml:320:15>>*/ return  /*<<arg.ml:320:15>>*/ caml_call1
              (Stdlib[99], 2);
     }
     if(exn[1] !== Help) throw caml_maybe_attach_backtrace(exn, 0);
     var msg$1 = exn[2];
      /*<<arg.ml:321:16>>*/  /*<<arg.ml:321:16>>*/ caml_call2
      (Stdlib_Printf[2], _q_, msg$1);
      /*<<arg.ml:321:16>>*/ return  /*<<arg.ml:321:16>>*/ caml_call1
             (Stdlib[99], 0);
    }
    /*<<arg.ml:321:39>>*/ }
   function second_word(s){
     /*<<arg.ml:325:2>>*/ var len = caml_ml_string_length(s);
    function loop(n){
      /*<<arg.ml:327:4>>*/ var n$0 = n;
      /*<<arg.ml:327:4>>*/ for(;;){
      if(len <= n$0)  /*<<arg.ml:326:2>>*/ return len;
       /*<<arg.ml:328:12>>*/ if
       (32 !==  /*<<arg.ml:328:12>>*/ caml_string_get(s, n$0))
        /*<<arg.ml:329:9>>*/ return n$0;
       /*<<arg.ml:328:29>>*/ var
        /*<<arg.ml:328:29>>*/ n$1 = n$0 + 1 | 0,
       n$0 = n$1;
     }
     /*<<arg.ml:329:10>>*/ }
     /*<<arg.ml:331:2>>*/ try{
      /*<<arg.ml:331:8>>*/  /*<<arg.ml:331:8>>*/ var
      n$0 =  /*<<arg.ml:331:8>>*/ caml_call2(Stdlib_String[36], s, 9);
    }
    catch(_Q_){
     var _O_ = caml_wrap_exception(_Q_);
     if(_O_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_O_, 0);
      /*<<arg.ml:334:6>>*/ try{
       /*<<arg.ml:334:18>>*/  /*<<arg.ml:334:18>>*/ var
       n =  /*<<arg.ml:334:18>>*/ caml_call2(Stdlib_String[36], s, 32);
     }
     catch(_R_){
      var _P_ = caml_wrap_exception(_R_);
      if(_P_ === Stdlib[8])  /*<<arg.ml:336:31>>*/ return len;
      throw caml_maybe_attach_backtrace(_P_, 0);
     }
      /*<<arg.ml:334:18>>*/ return loop(n + 1 | 0);
    }
     /*<<arg.ml:331:8>>*/ return loop(n$0 + 1 | 0);
    /*<<arg.ml:337:9>>*/ }
   function max_arg_len(cur, param){
    var doc = param[3], spec = param[2], kwd = param[1];
     /*<<arg.ml:341:2>>*/ if(11 === spec[0])
     return caml_call2(Stdlib_Int[11], cur, caml_ml_string_length(kwd));
    var _N_ = caml_ml_string_length(kwd) + second_word(doc) | 0;
    return caml_call2(Stdlib_Int[11], cur, _N_);
   }
   function replace_leading_tab(s){
     /*<<arg.ml:347:2>>*/  /*<<arg.ml:347:13>>*/ var seen = [0, 0];
     /*<<arg.ml:348:2>>*/ return  /*<<arg.ml:348:2>>*/ caml_call2
            (Stdlib_String[18],
             function(c){
               /*<<arg.ml:348:13>>*/ if(9 === c && ! seen[1]){
               seen[1] = 1;
                /*<<arg.ml:348:60>>*/ return 32;
              }
               /*<<arg.ml:348:71>>*/ return c;
              /*<<arg.ml:348:73>>*/ },
             s);
    /*<<arg.ml:348:75>>*/ }
   function align(opt, speclist){
     /*<<arg.ml:374:2>>*/ if(opt)
     var sth = opt[1], limit = sth;
    else
     var limit = Stdlib[19];
     /*<<arg.ml:374:18>>*/ var
      /*<<arg.ml:374:18>>*/ completed = add_help(speclist),
      /*<<arg.ml:375:12>>*/ len =
        /*<<arg.ml:375:12>>*/ caml_call3
        (Stdlib_List[26], max_arg_len, 0, completed),
      /*<<arg.ml:376:12>>*/ len$0 =
        /*<<arg.ml:376:12>>*/ caml_call2(Stdlib_Int[10], len, limit);
     /*<<arg.ml:377:2>>*/ return  /*<<arg.ml:377:2>>*/ caml_call2
            (Stdlib_List[20],
             function(ksd){
              var kwd = ksd[1], spec = ksd[2];
              if(! caml_string_notequal(ksd[3], cst$8))
                /*<<arg.ml:355:6>>*/ return ksd;
              if(11 === spec[0]){
                /*<<arg.ml:357:19>>*/ var
                msg$0 = ksd[3],
                 /*<<arg.ml:357:19>>*/ cutcol$0 = second_word(msg$0),
                 /*<<arg.ml:358:32>>*/ _K_ =
                   /*<<arg.ml:358:32>>*/ caml_call2
                   (Stdlib_Int[11], 0, len$0 - cutcol$0 | 0)
                  + 3
                  | 0,
                 /*<<arg.ml:358:19>>*/ spaces$0 =
                   /*<<arg.ml:358:19>>*/ caml_call2(Stdlib_String[1], _K_, 32),
                 /*<<arg.ml:359:34>>*/ _L_ = replace_leading_tab(msg$0),
                 /*<<arg.ml:359:25>>*/ _M_ =
                   /*<<arg.ml:359:25>>*/ caml_call2(Stdlib[28], spaces$0, _L_);
                /*<<arg.ml:359:6>>*/ return [0,
                       kwd,
                       spec,
                        /*<<arg.ml:359:18>>*/ caml_call2(Stdlib[28], cst$7, _M_)];
              }
               /*<<arg.ml:361:19>>*/ var
               msg = ksd[3],
               spec$0 = ksd[2],
                /*<<arg.ml:361:19>>*/ cutcol = second_word(msg),
                /*<<arg.ml:362:6>>*/ kwd_len =
                  /*<<arg.ml:362:6>>*/ caml_ml_string_length(kwd),
               diff = (len$0 - kwd_len | 0) - cutcol | 0;
               /*<<arg.ml:364:6>>*/ if(0 >= diff)
                /*<<arg.ml:365:8>>*/ return [0,
                       kwd,
                       spec$0,
                       replace_leading_tab(msg)];
               /*<<arg.ml:367:21>>*/ var
                /*<<arg.ml:367:21>>*/ spaces =
                  /*<<arg.ml:367:21>>*/ caml_call2(Stdlib_String[1], diff, 32),
                /*<<arg.ml:368:32>>*/ _I_ = replace_leading_tab(msg),
                /*<<arg.ml:368:21>>*/ prefix =
                  /*<<arg.ml:368:21>>*/ caml_call3
                  (Stdlib_String[16], _I_, 0, cutcol),
                /*<<arg.ml:369:21>>*/ suffix =
                  /*<<arg.ml:369:21>>*/ caml_call3
                  (Stdlib_String[16],
                   msg,
                   cutcol,
                   caml_ml_string_length(msg) - cutcol | 0),
                /*<<arg.ml:370:29>>*/ _J_ =
                  /*<<arg.ml:370:29>>*/ caml_call2(Stdlib[28], spaces, suffix);
               /*<<arg.ml:370:8>>*/ return [0,
                      kwd,
                      spec$0,
                       /*<<arg.ml:370:20>>*/ caml_call2(Stdlib[28], prefix, _J_)];
             },
             completed);
    /*<<arg.ml:377:38>>*/ }
   function read_aux(trim, sep, file){
     /*<<arg.ml:387:2>>*/ var
      /*<<arg.ml:387:11>>*/ ic =
        /*<<arg.ml:387:11>>*/ caml_call1(Stdlib[80], file),
      /*<<arg.ml:388:12>>*/ buf =
        /*<<arg.ml:388:12>>*/ caml_call1(Stdlib_Buffer[1], 200),
      /*<<arg.ml:389:14>>*/ words = [0, 0];
    function stash(param){
      /*<<arg.ml:391:4>>*/  /*<<arg.ml:391:15>>*/ var
      word =  /*<<arg.ml:391:15>>*/ caml_call1(Stdlib_Buffer[2], buf);
      /*<<arg.ml:392:4>>*/ if(trim){
      var len = caml_ml_string_length(word);
      a:
      {
        /*<<arg.ml:381:16>>*/ if
        (0 < len
         && 13 ===  /*<<arg.ml:381:16>>*/ caml_string_get(word, len - 1 | 0)){
        var
         _H_ =
            /*<<arg.ml:382:4>>*/ caml_call3
            (Stdlib_String[16], word, 0, len - 1 | 0);
        break a;
       }
       var _H_ = word;
      }
      var word$0 = _H_;
     }
     else
      var word$0 = word;
     words[1] = [0, word$0, words[1]];
      /*<<arg.ml:390:2>>*/ return  /*<<arg.ml:390:2>>*/ caml_call1
             (Stdlib_Buffer[8], buf);
     /*<<arg.ml:394:20>>*/ }
     /*<<arg.ml:396:2>>*/ try{
     for(;;){
       /*<<arg.ml:398:16>>*/  /*<<arg.ml:398:16>>*/ var
       c =  /*<<arg.ml:398:16>>*/ caml_call1(Stdlib[82], ic);
      if(c === sep)
        /*<<arg.ml:399:24>>*/ stash(0);
      else
        /*<<arg.ml:399:38>>*/  /*<<arg.ml:399:38>>*/ caml_call2
        (Stdlib_Buffer[12], buf, c);
     }
    }
    catch(_G_){
     var _E_ = caml_wrap_exception(_G_);
     if(_E_ !== Stdlib[12]) throw caml_maybe_attach_backtrace(_E_, 0);
     if(0 <  /*<<arg.ml:403:5>>*/ caml_call1(Stdlib_Buffer[7], buf))
       /*<<arg.ml:403:32>>*/ stash(0);
      /*<<arg.ml:404:2>>*/  /*<<arg.ml:404:2>>*/ caml_call1(Stdlib[93], ic);
      /*<<arg.ml:405:16>>*/  /*<<arg.ml:405:16>>*/ var
      _F_ =  /*<<arg.ml:405:16>>*/ caml_call1(Stdlib_List[10], words[1]);
      /*<<arg.ml:405:16>>*/ return  /*<<arg.ml:405:16>>*/ caml_call1
             (Stdlib_Array[10], _F_);
    }
    /*<<arg.ml:405:33>>*/ }
   var _r_ = 10, _s_ = 1;
    /*<<arg.ml:407:15>>*/ function read_arg(_D_){
     /*<<?>>*/ return read_aux(_s_, _r_, _D_);
   }
   var
     /*<<arg.ml:407:15>>*/ _t_ = 0,
    _u_ = 0,
    _v_ = [0, [2, 0, [0, 0]], "%s%c"];
    /*<<arg.ml:409:16>>*/ function read_arg0(_C_){
     /*<<?>>*/ return read_aux(_u_, _t_, _C_);
   }
   function write_aux(sep, file, args){
     /*<<arg.ml:412:2>>*/  /*<<arg.ml:412:11>>*/ var
     oc =  /*<<arg.ml:412:11>>*/ caml_call1(Stdlib[61], file);
     /*<<arg.ml:413:2>>*/  /*<<arg.ml:413:2>>*/ caml_call2
     (Stdlib_Array[11],
      function(s){
        /*<<arg.ml:413:23>>*/ return caml_call4
               (Stdlib_Printf[1], oc, _v_, s, sep);
       /*<<arg.ml:413:46>>*/ },
      args);
     /*<<arg.ml:413:2>>*/ return  /*<<arg.ml:413:2>>*/ caml_call1
            (Stdlib[76], oc);
    /*<<arg.ml:414:14>>*/ }
   var _w_ = 10;
    /*<<arg.ml:416:16>>*/ function write_arg(_A_, _B_){
     /*<<?>>*/ return write_aux(_w_, _A_, _B_);
   }
    /*<<arg.ml:416:16>>*/ var _x_ = 0;
    /*<<arg.ml:418:17>>*/ function write_arg0(_y_, _z_){
     /*<<?>>*/ return write_aux(_x_, _y_, _z_);
   }
   var
    Stdlib_Arg =
      [0,
       parse,
       parse_dynamic,
       parse_argv,
       parse_argv_dynamic,
       parse_and_expand_argv_dynamic,
       parse_expand,
       Help,
       Bad,
       usage,
       usage_string,
       align,
       current,
       read_arg,
       read_arg0,
       write_arg,
       write_arg0];
   runtime.caml_register_global(55, Stdlib_Arg, "Stdlib__Arg");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Printexc
//# unitInfo: Requires: Stdlib, Stdlib__Atomic, Stdlib__Buffer, Stdlib__Obj, Stdlib__Printf
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$4 = "",
    cst_s = "%s\n",
    cst_Program_not_linked_with_g_$0 =
      "(Program not linked with -g, cannot print stack backtrace)\n",
    cst_characters = ", characters ",
    cst_Fatal_error_exception = "Fatal error: exception ",
    cst_Fatal_error_exception_s = "Fatal error: exception %s\n",
    cst_Uncaught_exception = "Uncaught exception: ",
    cst_Uncaught_exception_s = "Uncaught exception: %s\n",
    caml_check_bound = runtime.caml_check_bound,
    caml_get_exception_raw_backtra = runtime.caml_get_exception_raw_backtrace,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_obj_tag = runtime.caml_obj_tag,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call6(f, a0, a1, a2, a3, a4, a5){
    return (f.l >= 0 ? f.l : f.l = f.length) == 6
            ? f(a0, a1, a2, a3, a4, a5)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4, a5]);
   }
    /*<<?>>*/ function caml_call8(f, a0, a1, a2, a3, a4, a5, a6, a7){
    return (f.l >= 0 ? f.l : f.l = f.length) == 8
            ? f(a0, a1, a2, a3, a4, a5, a6, a7)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4, a5, a6, a7]);
   }
    /*<<printexc.ml:20:15>>*/ var
    global_data = runtime.caml_get_global_data(),
    cst$0 = cst$4,
    cst$3 = cst$4,
    partial = [4, 0, 0, 0, [12, 45, [4, 0, 0, 0, 0]]],
    cst$1 = cst$4,
    cst$2 = cst$4,
    cst = "_",
    locfmt =
      [0,
       [11,
        'File "',
        [2,
         0,
         [11,
          '", line ',
          [4,
           0,
           0,
           0,
           [11,
            cst_characters,
            [4, 0, 0, 0, [12, 45, [4, 0, 0, 0, [11, ": ", [2, 0, 0]]]]]]]]]],
       'File "%s", line %d, characters %d-%d: %s'],
    Stdlib_Printf = global_data.Stdlib__Printf,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    Stdlib = global_data.Stdlib,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_Obj = global_data.Stdlib__Obj,
     /*<<printexc.ml:20:15>>*/ printers =
       /*<<printexc.ml:20:15>>*/ caml_call1(Stdlib_Atomic[1], 0),
    _a_ = [0, [3, 0, 0], "%S"],
    _b_ = [0, [4, 0, 0, 0, 0], "%d"],
    _c_ = [0, [11, ", ", [2, 0, [2, 0, 0]]], ", %s%s"],
    _d_ = [0, [12, 40, [2, 0, [2, 0, [12, 41, 0]]]], "(%s%s)"],
    _e_ = [0, [12, 40, [2, 0, [12, 41, 0]]], "(%s)"],
    cst_Out_of_memory = "Out of memory",
    cst_Stack_overflow = "Stack overflow",
    cst_Pattern_matching_failed = "Pattern matching failed",
    cst_Assertion_failed = "Assertion failed",
    cst_Undefined_recursive_module = "Undefined recursive module",
    _f_ =
      [0,
       [11, cst_Uncaught_exception, [2, 0, [12, 10, 0]]],
       cst_Uncaught_exception_s],
    _g_ =
      [0,
       [11, cst_Uncaught_exception, [2, 0, [12, 10, 0]]],
       cst_Uncaught_exception_s],
    cst_Raised_at = "Raised at",
    cst_Re_raised_at = "Re-raised at",
    cst_Raised_by_primitive_operat = "Raised by primitive operation at",
    cst_Called_from = "Called from",
    cst_inlined = " (inlined)",
    _h_ =
      [0,
       [2,
        0,
        [12,
         32,
         [2,
          0,
          [11,
           ' in file "',
           [2,
            0,
            [12,
             34,
             [2,
              0,
              [11, ", line ", [4, 0, 0, 0, [11, cst_characters, partial]]]]]]]]]],
       '%s %s in file "%s"%s, line %d, characters %d-%d'],
    _i_ = [0, [2, 0, [11, " unknown location", 0]], "%s unknown location"],
    _j_ = [0, [2, 0, [12, 10, 0]], cst_s],
    _k_ =
      [0,
       [11, cst_Program_not_linked_with_g_$0, 0],
       cst_Program_not_linked_with_g_$0],
    _l_ = [0, [2, 0, [12, 10, 0]], cst_s],
    cst_Program_not_linked_with_g_ = cst_Program_not_linked_with_g_$0;
   function field(x, i){
     /*<<printexc.ml:25:2>>*/  /*<<printexc.ml:25:10>>*/ var f = x[1 + i];
     /*<<printexc.ml:26:9>>*/ if
     (!  /*<<printexc.ml:26:9>>*/ caml_call1(Stdlib_Obj[1], f))
      /*<<printexc.ml:27:4>>*/ return  /*<<printexc.ml:27:4>>*/ caml_call2
             (Stdlib_Printf[4], _b_, f);
     /*<<printexc.ml:28:7>>*/  /*<<printexc.ml:28:7>>*/ var
     _ag_ = Stdlib_Obj[15];
    if( /*<<printexc.ml:28:10>>*/ caml_obj_tag(f) === _ag_)
      /*<<printexc.ml:29:4>>*/ return  /*<<printexc.ml:29:4>>*/ caml_call2
             (Stdlib_Printf[4], _a_, f);
     /*<<printexc.ml:30:7>>*/  /*<<printexc.ml:30:7>>*/ var
     _ah_ = Stdlib_Obj[16];
    return  /*<<printexc.ml:30:10>>*/ caml_obj_tag(f) === _ah_
            ?  /*<<printexc.ml:31:4>>*/ caml_call1(Stdlib[35], f)
            : cst;
    /*<<printexc.ml:33:7>>*/ }
   function other_fields(x, i){
     /*<<printexc.ml:36:2>>*/ if(x.length - 1 <= i)
      /*<<printexc.ml:36:26>>*/ return cst$0;
     /*<<printexc.ml:37:36>>*/ var
      /*<<printexc.ml:37:36>>*/ _ae_ = other_fields(x, i + 1 | 0),
      /*<<printexc.ml:37:24>>*/ _af_ = field(x, i);
     /*<<printexc.ml:37:36>>*/ return  /*<<printexc.ml:37:36>>*/ caml_call3
            (Stdlib_Printf[4], _c_, _af_, _ae_);
    /*<<printexc.ml:37:58>>*/ }
   function use_printers(x){
     /*<<printexc.ml:47:2>>*/ var
     param =  /*<<printexc.ml:53:7>>*/ caml_call1(Stdlib_Atomic[2], printers);
     /*<<printexc.ml:47:17>>*/ for(;;){
     if(! param)  /*<<printexc.ml:52:12>>*/ return 0;
     var tl = param[2], hd = param[1];
     a:
     {
       /*<<printexc.ml:49:8>>*/ try{
        /*<<printexc.ml:49:15>>*/  /*<<printexc.ml:49:15>>*/ var
        val =  /*<<printexc.ml:49:15>>*/ caml_call1(hd, x);
      }
      catch(_ad_){break a;}
      if(val){var s = val[1];  /*<<printexc.ml:51:21>>*/ return [0, s];}
     }
     var param = tl;
    }
    /*<<printexc.ml:53:28>>*/ }
   function string_of_extension_constructo(t){
     /*<<printexc.ml:64:2>>*/ if
     (0 ===  /*<<printexc.ml:56:5>>*/ caml_obj_tag(t)){
      /*<<printexc.ml:60:17>>*/ var
       /*<<printexc.ml:60:17>>*/ constructor = t[1][1],
      match = t.length - 1;
     if(2 < match >>> 0)
       /*<<printexc.ml:44:38>>*/ var
        /*<<printexc.ml:44:38>>*/ _$_ = other_fields(t, 2),
        /*<<printexc.ml:44:26>>*/ _aa_ = field(t, 1),
       _ac_ =
          /*<<printexc.ml:44:38>>*/ caml_call3
          (Stdlib_Printf[4], _d_, _aa_, _$_);
     else
      switch(match){
        case 0:
         var _ac_ = cst$1; break;
        case 1:
         var _ac_ = cst$2; break;
        default:
          /*<<printexc.ml:43:24>>*/ var
           /*<<printexc.ml:43:24>>*/ _ab_ = field(t, 1),
          _ac_ =
             /*<<printexc.ml:43:24>>*/ caml_call2(Stdlib_Printf[4], _e_, _ab_);
      }
     var match$0 = [0, constructor, [0, _ac_]];
    }
    else
     var match$0 = [0, t[1], 0];
    var fields_opt = match$0[2], constructor$0 = match$0[1];
     /*<<printexc.ml:65:2>>*/ if(! fields_opt)
      /*<<printexc.ml:66:12>>*/ return constructor$0;
    var f = fields_opt[1];
     /*<<printexc.ml:67:14>>*/ return  /*<<printexc.ml:67:14>>*/ caml_call2
            (Stdlib[28], constructor$0, f);
    /*<<printexc.ml:67:29>>*/ }
   function to_string_default(x){
     /*<<printexc.ml:69:24>>*/ if(x === Stdlib[9])
      /*<<printexc.ml:70:21>>*/ return cst_Out_of_memory;
    if(x === Stdlib[10])  /*<<printexc.ml:71:22>>*/ return cst_Stack_overflow;
    if(x[1] === Stdlib[4]){
     var match = x[2], char$0 = match[3], line = match[2], file = match[1];
      /*<<printexc.ml:73:6>>*/ return  /*<<printexc.ml:73:6>>*/ caml_call6
             (Stdlib_Printf[4],
              locfmt,
              file,
              line,
              char$0,
              char$0 + 5 | 0,
              cst_Pattern_matching_failed);
    }
    if(x[1] === Stdlib[5]){
     var
      match$0 = x[2],
      char$1 = match$0[3],
      line$0 = match$0[2],
      file$0 = match$0[1];
      /*<<printexc.ml:75:6>>*/ return  /*<<printexc.ml:75:6>>*/ caml_call6
             (Stdlib_Printf[4],
              locfmt,
              file$0,
              line$0,
              char$1,
              char$1 + 6 | 0,
              cst_Assertion_failed);
    }
    if(x[1] !== Stdlib[15])
      /*<<printexc.ml:79:6>>*/ return string_of_extension_constructo(x);
    var
     match$1 = x[2],
     char$2 = match$1[3],
     line$1 = match$1[2],
     file$1 = match$1[1];
     /*<<printexc.ml:77:6>>*/ return  /*<<printexc.ml:77:6>>*/ caml_call6
            (Stdlib_Printf[4],
             locfmt,
             file$1,
             line$1,
             char$2,
             char$2 + 6 | 0,
             cst_Undefined_recursive_module);
    /*<<printexc.ml:79:50>>*/ }
   function to_string(e){
     /*<<printexc.ml:82:2>>*/  /*<<printexc.ml:82:8>>*/ var
     match = use_printers(e);
    if(! match)  /*<<printexc.ml:84:12>>*/ return to_string_default(e);
    var s = match[1];
     /*<<printexc.ml:83:14>>*/ return s;
    /*<<printexc.ml:84:31>>*/ }
   function print(fct, arg){
     /*<<printexc.ml:87:2>>*/ try{
      /*<<printexc.ml:88:4>>*/  /*<<printexc.ml:88:4>>*/ var
      ___ =  /*<<printexc.ml:88:4>>*/ caml_call1(fct, arg);
      /*<<printexc.ml:88:4>>*/ return ___;
    }
    catch(x$0){
      /*<<printexc.ml:90:39>>*/ var
      x = caml_wrap_exception(x$0),
       /*<<printexc.ml:90:39>>*/ _Z_ = to_string(x);
      /*<<printexc.ml:90:4>>*/  /*<<printexc.ml:90:4>>*/ caml_call2
      (Stdlib_Printf[3], _f_, _Z_);
      /*<<printexc.ml:91:4>>*/  /*<<printexc.ml:91:4>>*/ caml_call1
      (Stdlib[63], Stdlib[40]);
      /*<<printexc.ml:92:4>>*/ throw  /*<<printexc.ml:92:4>>*/ caml_maybe_attach_backtrace
            (x, 0);
    }
    /*<<printexc.ml:92:11>>*/ }
   function catch$0(fct, arg){
     /*<<printexc.ml:95:2>>*/ try{
      /*<<printexc.ml:96:4>>*/  /*<<printexc.ml:96:4>>*/ var
      _Y_ =  /*<<printexc.ml:96:4>>*/ caml_call1(fct, arg);
      /*<<printexc.ml:96:4>>*/ return _Y_;
    }
    catch(x$0){
     var x = caml_wrap_exception(x$0);
      /*<<printexc.ml:98:4>>*/  /*<<printexc.ml:98:4>>*/ caml_call1
      (Stdlib[63], Stdlib[39]);
      /*<<printexc.ml:99:39>>*/  /*<<printexc.ml:99:39>>*/ var
      _X_ = to_string(x);
      /*<<printexc.ml:99:4>>*/  /*<<printexc.ml:99:4>>*/ caml_call2
      (Stdlib_Printf[3], _g_, _X_);
      /*<<printexc.ml:99:4>>*/ return  /*<<printexc.ml:99:4>>*/ caml_call1
             (Stdlib[99], 2);
    }
    /*<<printexc.ml:100:10>>*/ }
   function raw_backtrace_entries(bt){
     /*<<printexc.ml:106:31>>*/ return bt;
    /*<<printexc.ml:106:33>>*/ }
   function convert_raw_backtrace(bt){
     /*<<printexc.ml:141:2>>*/ return [0,
             /*<<printexc.ml:141:11>>*/ runtime.caml_convert_raw_backtrace(bt)];
    /*<<printexc.ml:142:24>>*/ }
   function format_backtrace_slot(pos, slot){
    function info(is_raise){
      /*<<printexc.ml:146:4>>*/ return is_raise
             ? 0 === pos ? cst_Raised_at : cst_Re_raised_at
             : 0 === pos ? cst_Raised_by_primitive_operat : cst_Called_from;
     /*<<printexc.ml:149:75>>*/ }
     /*<<printexc.ml:151:2>>*/ if(0 === slot[0]){
      /*<<printexc.ml:159:14>>*/ var
      _P_ = slot[5],
      _Q_ = slot[4],
      _R_ = slot[3],
      _S_ = slot[6] ? cst_inlined : cst$3,
      _T_ = slot[2],
      _U_ = slot[7],
       /*<<printexc.ml:159:14>>*/ _V_ = info(slot[1]);
      /*<<printexc.ml:158:6>>*/ return [0,
              /*<<printexc.ml:158:11>>*/ caml_call8
              (Stdlib_Printf[4], _h_, _V_, _U_, _T_, _S_, _R_, _Q_, _P_)];
    }
    if(slot[1])  /*<<printexc.ml:154:50>>*/ return 0;
     /*<<printexc.ml:156:44>>*/  /*<<printexc.ml:156:44>>*/ var _W_ = info(0);
     /*<<printexc.ml:156:8>>*/ return [0,
             /*<<printexc.ml:156:13>>*/ caml_call2(Stdlib_Printf[4], _i_, _W_)];
    /*<<printexc.ml:161:52>>*/ }
   function print_raw_backtrace(outchan, raw_backtrace){
     /*<<printexc.ml:176:2>>*/  /*<<printexc.ml:176:36>>*/ var
     backtrace = convert_raw_backtrace(raw_backtrace);
    if(! backtrace)
      /*<<printexc.ml:166:6>>*/ return  /*<<printexc.ml:166:6>>*/ caml_call2
             (Stdlib_Printf[1], outchan, _k_);
    var a = backtrace[1], _N_ = a.length - 1 - 1 | 0, _M_ = 0;
    if(_N_ >= 0){
     var i = _M_;
     for(;;){
       /*<<printexc.ml:170:14>>*/  /*<<printexc.ml:170:14>>*/ var
       match = format_backtrace_slot(i, caml_check_bound(a, i)[1 + i]);
      if(match){
       var str = match[1];
        /*<<printexc.ml:172:24>>*/  /*<<printexc.ml:172:24>>*/ caml_call3
        (Stdlib_Printf[1], outchan, _j_, str);
      }
       /*<<printexc.ml:169:6>>*/  /*<<printexc.ml:169:6>>*/ var
       _O_ = i + 1 | 0;
      if(_N_ === i) break;
      var i = _O_;
     }
    }
    return 0;
    /*<<printexc.ml:176:73>>*/ }
   function print_backtrace(outchan){
     /*<<printexc.ml:180:2>>*/ return print_raw_backtrace
            (outchan,
              /*<<printexc.ml:180:30>>*/ caml_get_exception_raw_backtra(0));
    /*<<printexc.ml:180:52>>*/ }
   function raw_backtrace_to_string(raw_backtrace){
     /*<<printexc.ml:196:2>>*/  /*<<printexc.ml:196:22>>*/ var
     backtrace = convert_raw_backtrace(raw_backtrace);
    if(! backtrace)
      /*<<printexc.ml:185:5>>*/ return cst_Program_not_linked_with_g_;
     /*<<printexc.ml:187:14>>*/ var
     a = backtrace[1],
      /*<<printexc.ml:187:14>>*/ b =
        /*<<printexc.ml:187:14>>*/ caml_call1(Stdlib_Buffer[1], 1024),
     _K_ = a.length - 1 - 1 | 0,
      /*<<printexc.ml:187:14>>*/ _J_ = 0;
    if(_K_ >= 0){
     var i = _J_;
     for(;;){
       /*<<printexc.ml:189:14>>*/  /*<<printexc.ml:189:14>>*/ var
       match = format_backtrace_slot(i, caml_check_bound(a, i)[1 + i]);
      if(match){
       var str = match[1];
        /*<<printexc.ml:191:24>>*/  /*<<printexc.ml:191:24>>*/ caml_call3
        (Stdlib_Printf[5], b, _l_, str);
      }
       /*<<printexc.ml:188:6>>*/  /*<<printexc.ml:188:6>>*/ var
       _L_ = i + 1 | 0;
      if(_K_ === i) break;
      var i = _L_;
     }
    }
     /*<<printexc.ml:193:6>>*/ return  /*<<printexc.ml:193:6>>*/ caml_call1
            (Stdlib_Buffer[2], b);
    /*<<printexc.ml:196:59>>*/ }
   function backtrace_slot_is_raise(param){
     /*<<printexc.ml:198:30>>*/ return 0 === param[0] ? param[1] : param[1];
    /*<<printexc.ml:200:36>>*/ }
   function backtrace_slot_is_inline(param){
     /*<<printexc.ml:202:31>>*/ return 0 === param[0] ? param[6] : 0;
    /*<<printexc.ml:204:31>>*/ }
   function backtrace_slot_location(param){
     /*<<printexc.ml:213:30>>*/ return 0 === param[0]
            ? [0, [0, param[2], param[3], param[4], param[5]]]
            : 0;
    /*<<printexc.ml:221:5>>*/ }
   function backtrace_slot_defname(param){
     /*<<printexc.ml:223:29>>*/ if
     (0 === param[0] && runtime.caml_string_notequal(param[7], cst$4))
      /*<<printexc.ml:226:24>>*/ return [0, param[7]];
     /*<<printexc.ml:225:39>>*/ return 0;
    /*<<printexc.ml:226:38>>*/ }
   function backtrace_slots(raw_backtrace){
     /*<<printexc.ml:235:2>>*/  /*<<printexc.ml:235:8>>*/ var
     match = convert_raw_backtrace(raw_backtrace);
    if(! match)  /*<<printexc.ml:236:14>>*/ return 0;
    var backtrace = match[1], i$1 = backtrace.length - 1 - 1 | 0, i = i$1;
     /*<<printexc.ml:241:30>>*/ for(;;){
     if(-1 === i)
      var _I_ = 0;
     else{
      var _H_ = 0 === caml_check_bound(backtrace, i)[1 + i][0] ? 1 : 0;
       /*<<printexc.ml:243:15>>*/ if(! _H_){
       var i$0 = i - 1 | 0, i = i$0;
       continue;
      }
      var _I_ = _H_;
     }
      /*<<printexc.ml:244:9>>*/ return _I_ ? [0, backtrace] : 0;
    }
    /*<<printexc.ml:246:15>>*/ }
   function backtrace_slots_of_raw_entry(entry){
     /*<<printexc.ml:249:2>>*/ return backtrace_slots([0, entry]);
    /*<<printexc.ml:249:29>>*/ }
   function raw_backtrace_length(bt){
     /*<<printexc.ml:260:30>>*/ return bt.length - 1;
    /*<<printexc.ml:260:45>>*/ }
   function get_backtrace(param){
     /*<<printexc.ml:271:23>>*/ return raw_backtrace_to_string
            ( /*<<printexc.ml:271:47>>*/ caml_get_exception_raw_backtra(0));
    /*<<printexc.ml:271:69>>*/ }
   function register_printer(fn){
     /*<<printexc.ml:277:2>>*/ for(;;){
      /*<<printexc.ml:277:21>>*/ var
       /*<<printexc.ml:277:21>>*/ old_printers =
         /*<<printexc.ml:277:21>>*/ caml_call1(Stdlib_Atomic[2], printers),
       /*<<printexc.ml:278:21>>*/ new_printers = [0, fn, old_printers],
       /*<<printexc.ml:279:16>>*/ success =
         /*<<printexc.ml:279:16>>*/ caml_call3
         (Stdlib_Atomic[5], printers, old_printers, new_printers),
       /*<<printexc.ml:280:2>>*/ _G_ = 1 - success;
     if(! _G_)  /*<<printexc.ml:280:2>>*/ return _G_;
    }
    /*<<printexc.ml:280:41>>*/ }
   function exn_slot(x){
     /*<<printexc.ml:285:2>>*/ return 0
            ===  /*<<printexc.ml:286:5>>*/ caml_obj_tag(x)
            ? x[1]
            : x;
    /*<<printexc.ml:286:44>>*/ }
   function exn_slot_id(x){
     /*<<printexc.ml:289:2>>*/  /*<<printexc.ml:289:13>>*/ var
     slot = exn_slot(x);
     /*<<printexc.ml:290:11>>*/ return slot[2];
    /*<<printexc.ml:290:36>>*/ }
   function exn_slot_name(x){
     /*<<printexc.ml:293:2>>*/  /*<<printexc.ml:293:13>>*/ var
     slot = exn_slot(x);
     /*<<printexc.ml:294:11>>*/ return slot[1];
    /*<<printexc.ml:294:39>>*/ }
   var
    errors =
      [0,
        cst$4,
        "(Cannot print locations:\n bytecode executable program file not found)",
        "(Cannot print locations:\n bytecode executable program file appears to be corrupt)",
        "(Cannot print locations:\n bytecode executable program file has wrong magic number)",
        "(Cannot print locations:\n bytecode executable program file cannot be opened;\n -- too many open files. Try running with OCAMLRUNPARAM=b=2)"].slice
       (),
    _m_ =
      [0,
       [11, cst_Fatal_error_exception, [2, 0, [12, 10, 0]]],
       cst_Fatal_error_exception_s];
   function default_uncaught_exception_han(exn, raw_backtrace){
     /*<<printexc.ml:316:2>>*/  /*<<printexc.ml:316:40>>*/ var
     _D_ = to_string(exn);
     /*<<printexc.ml:316:2>>*/  /*<<printexc.ml:316:2>>*/ caml_call2
     (Stdlib_Printf[3], _m_, _D_);
     /*<<printexc.ml:317:2>>*/ print_raw_backtrace(Stdlib[40], raw_backtrace);
     /*<<printexc.ml:318:15>>*/  /*<<printexc.ml:318:15>>*/ var
     status =  /*<<printexc.ml:318:15>>*/ runtime.caml_ml_debug_info_status(0);
    if(status < 0){
      /*<<printexc.ml:320:26>>*/ var
       /*<<printexc.ml:320:26>>*/ _E_ =
         /*<<printexc.ml:320:26>>*/ caml_call1(Stdlib[18], status),
       /*<<printexc.ml:320:18>>*/ _F_ = caml_check_bound(errors, _E_)[1 + _E_];
      /*<<printexc.ml:320:4>>*/  /*<<printexc.ml:320:4>>*/ caml_call1
      (Stdlib[53], _F_);
    }
     /*<<printexc.ml:320:4>>*/ return  /*<<printexc.ml:320:4>>*/ caml_call1
            (Stdlib[63], Stdlib[40]);
    /*<<printexc.ml:321:14>>*/ }
    /*<<printexc.ml:323:33>>*/  /*<<printexc.ml:323:33>>*/ var
    uncaught_exception_handler = [0, default_uncaught_exception_han];
   function set_uncaught_exception_handler(fn){
     /*<<printexc.ml:325:40>>*/ uncaught_exception_handler[1] = fn;
    return 0;
    /*<<printexc.ml:325:72>>*/ }
   var
    empty_backtrace = [0],
    cst_Fatal_error_out_of_memory_ =
      "Fatal error: out of memory in uncaught exception handler",
    _n_ =
      [0,
       [11, cst_Fatal_error_exception, [2, 0, [12, 10, 0]]],
       cst_Fatal_error_exception_s],
    _o_ =
      [0,
       [11,
        "Fatal error in uncaught exception handler: exception ",
        [2, 0, [12, 10, 0]]],
       "Fatal error in uncaught exception handler: exception %s\n"];
   function handle_uncaught_exception(exn$0, debugger_in_use){
     /*<<printexc.ml:364:2>>*/ try{
      /*<<printexc.ml:336:2>>*/ try{
      var
       raw_backtrace =
         debugger_in_use
          ? empty_backtrace
          :  /*<<printexc.ml:343:8>>*/ caml_get_exception_raw_backtra(0);
       /*<<printexc.ml:345:4>>*/ try{
        /*<<printexc.ml:345:9>>*/  /*<<printexc.ml:345:9>>*/ caml_call1
        (Stdlib[103], 0);
      }
      catch(_C_){}
       /*<<printexc.ml:346:4>>*/ try{
        /*<<printexc.ml:347:6>>*/ var
         /*<<printexc.ml:347:6>>*/ _y_ =
           /*<<printexc.ml:347:6>>*/ caml_call2
           (uncaught_exception_handler[1], exn$0, raw_backtrace),
        _x_ = _y_;
      }
      catch(exn$1){
        /*<<printexc.ml:349:27>>*/ var
        exn = caml_wrap_exception(exn$1),
         /*<<printexc.ml:349:27>>*/ raw_backtrace$0 =
           /*<<printexc.ml:349:27>>*/ caml_get_exception_raw_backtra(0),
         /*<<printexc.ml:350:44>>*/ _v_ = to_string(exn$0);
        /*<<printexc.ml:350:6>>*/  /*<<printexc.ml:350:6>>*/ caml_call2
        (Stdlib_Printf[3], _n_, _v_);
        /*<<printexc.ml:351:6>>*/ print_raw_backtrace
        (Stdlib[40], raw_backtrace);
        /*<<printexc.ml:353:8>>*/  /*<<printexc.ml:353:8>>*/ var
        _w_ = to_string(exn);
        /*<<printexc.ml:352:6>>*/  /*<<printexc.ml:352:6>>*/ caml_call2
        (Stdlib_Printf[3], _o_, _w_);
        /*<<printexc.ml:354:6>>*/ print_raw_backtrace
        (Stdlib[40], raw_backtrace$0);
       var
        _x_ =  /*<<printexc.ml:355:6>>*/ caml_call1(Stdlib[63], Stdlib[40]);
      }
      var _z_ = _x_;
     }
     catch(_B_){
      var _u_ = caml_wrap_exception(_B_);
      if(_u_ !== Stdlib[9]) throw caml_maybe_attach_backtrace(_u_, 0);
      var
       _z_ =
          /*<<printexc.ml:358:8>>*/ caml_call1
          (Stdlib[53], cst_Fatal_error_out_of_memory_);
     }
      /*<<printexc.ml:365:4>>*/ return _z_;
    }
    catch(_A_){ /*<<printexc.ml:368:4>>*/ return 0;}
    /*<<printexc.ml:368:6>>*/ }
    /*<<printexc.ml:374:2>>*/  /*<<printexc.ml:374:2>>*/ runtime.caml_register_named_value
    ("Printexc.handle_uncaught_exception", handle_uncaught_exception);
   var
    Stdlib_Printexc =
      [0,
       to_string,
       to_string_default,
       print,
       catch$0,
       print_backtrace,
       get_backtrace,
       runtime.caml_record_backtrace,
       runtime.caml_backtrace_status,
       register_printer,
       use_printers,
       raw_backtrace_entries,
       function(_t_){ /*<<?>>*/ return caml_get_exception_raw_backtra(_t_);},
       print_raw_backtrace,
       raw_backtrace_to_string,
       default_uncaught_exception_han,
       set_uncaught_exception_handler,
       backtrace_slots,
       backtrace_slots_of_raw_entry,
       [0,
        backtrace_slot_is_raise,
        backtrace_slot_is_inline,
        backtrace_slot_location,
        backtrace_slot_defname,
        format_backtrace_slot],
       raw_backtrace_length,
       function(_s_, _r_){
         /*<<?>>*/ return runtime.caml_raw_backtrace_slot(_s_, _r_);
       },
       function(_q_){
         /*<<?>>*/ return runtime.caml_convert_raw_backtrace_slot(_q_);
       },
       function(_p_){
         /*<<?>>*/ return runtime.caml_raw_backtrace_next_slot(_p_);
       },
       exn_slot_id,
       exn_slot_name,
       string_of_extension_constructo];
   runtime.caml_register_global(42, Stdlib_Printexc, "Stdlib__Printexc");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Fun
//# unitInfo: Requires: Stdlib, Stdlib__Printexc
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_restore_raw_backtrace = runtime.caml_restore_raw_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Printexc = global_data.Stdlib__Printexc,
    Stdlib = global_data.Stdlib;
   function const$0(c, param){
     /*<<fun.ml:17:16>>*/ return c;
    /*<<fun.ml:17:17>>*/ }
   function flip(f, x, y){
     /*<<fun.ml:18:17>>*/ return  /*<<fun.ml:18:17>>*/ caml_call2(f, y, x);
    /*<<fun.ml:18:22>>*/ }
   function negate(p, v){
     /*<<fun.ml:19:17>>*/ return 1 -  /*<<fun.ml:19:21>>*/ caml_call1(p, v);
    /*<<fun.ml:19:26>>*/ }
    /*<<fun.ml:21:0>>*/ var
     /*<<fun.ml:21:0>>*/ Finally_raised =
      [248, "Stdlib.Fun.Finally_raised", runtime.caml_fresh_oo_id(0)],
    cst_Fun_Finally_raised = "Fun.Finally_raised: ";
    /*<<fun.ml:23:9>>*/  /*<<fun.ml:23:9>>*/ caml_call1
    (Stdlib_Printexc[9],
     function(param){
       /*<<fun.ml:23:38>>*/ if(param[1] !== Finally_raised)
        /*<<fun.ml:25:7>>*/ return 0;
       /*<<fun.ml:24:55>>*/ var
       exn = param[2],
        /*<<fun.ml:24:55>>*/ _a_ =
          /*<<fun.ml:24:55>>*/ caml_call1(Stdlib_Printexc[1], exn);
       /*<<fun.ml:24:24>>*/ return [0,
               /*<<fun.ml:24:29>>*/ caml_call2
               (Stdlib[28], cst_Fun_Finally_raised, _a_)];
      /*<<fun.ml:25:11>>*/ });
   function protect(finally$0, work){
    function finally_no_exn(param){
      /*<<fun.ml:29:4>>*/ try{
       /*<<fun.ml:29:8>>*/  /*<<fun.ml:29:8>>*/ caml_call1(finally$0, 0);
       /*<<fun.ml:29:8>>*/ return;
     }
     catch(e$0){
       /*<<fun.ml:30:15>>*/ var
       e = caml_wrap_exception(e$0),
        /*<<fun.ml:30:15>>*/ bt =
          /*<<fun.ml:30:15>>*/ caml_call1(Stdlib_Printexc[12], 0),
        /*<<fun.ml:31:36>>*/ exn = [0, Finally_raised, e];
      caml_restore_raw_backtrace(exn, bt);
       /*<<fun.ml:31:6>>*/ throw  /*<<fun.ml:31:6>>*/ caml_maybe_attach_backtrace
             (exn, 0);
     }
     /*<<fun.ml:31:57>>*/ }
     /*<<fun.ml:33:2>>*/ try{
      /*<<fun.ml:33:8>>*/  /*<<fun.ml:33:8>>*/ var
      result =  /*<<fun.ml:33:8>>*/ caml_call1(work, 0);
    }
    catch(work_exn$0){
      /*<<fun.ml:36:20>>*/ var
      work_exn = caml_wrap_exception(work_exn$0),
       /*<<fun.ml:36:20>>*/ work_bt =
         /*<<fun.ml:36:20>>*/ caml_call1(Stdlib_Printexc[12], 0);
      /*<<fun.ml:37:6>>*/ finally_no_exn(0);
     caml_restore_raw_backtrace(work_exn, work_bt);
      /*<<fun.ml:38:6>>*/ throw  /*<<fun.ml:38:6>>*/ caml_maybe_attach_backtrace
            (work_exn, 0);
    }
     /*<<fun.ml:34:14>>*/ finally_no_exn(0);
     /*<<fun.ml:34:14>>*/ return result;
    /*<<fun.ml:38:52>>*/ }
   var Stdlib_Fun = [0, const$0, flip, negate, protect, Finally_raised];
   runtime.caml_register_global(4, Stdlib_Fun, "Stdlib__Fun");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Gc
//# unitInfo: Requires: Stdlib, Stdlib__Atomic, Stdlib__Fun, Stdlib__Printf, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst = "\n",
    caml_ml_string_length = runtime.caml_ml_string_length;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Atomic = global_data.Stdlib__Atomic;
   global_data.Stdlib__Fun;
   var
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Printf = global_data.Stdlib__Printf,
    _a_ =
      [0,
       [11, "minor_collections:      ", [4, 0, 0, 0, [12, 10, 0]]],
       "minor_collections:      %d\n"],
    _b_ =
      [0,
       [11, "major_collections:      ", [4, 0, 0, 0, [12, 10, 0]]],
       "major_collections:      %d\n"],
    _c_ =
      [0,
       [11, "compactions:            ", [4, 0, 0, 0, [12, 10, 0]]],
       "compactions:            %d\n"],
    _d_ =
      [0,
       [11, "forced_major_collections: ", [4, 0, 0, 0, [12, 10, 0]]],
       "forced_major_collections: %d\n"],
    _e_ = [0, [12, 10, 0], cst],
    _f_ = [0, [8, [0, 0, 0], 0, [0, 0], 0], "%.0f"],
    _g_ =
      [0,
       [11, "minor_words:    ", [8, [0, 0, 0], [1, 1], [0, 0], [12, 10, 0]]],
       "minor_words:    %*.0f\n"],
    _h_ =
      [0,
       [11, "promoted_words: ", [8, [0, 0, 0], [1, 1], [0, 0], [12, 10, 0]]],
       "promoted_words: %*.0f\n"],
    _i_ =
      [0,
       [11, "major_words:    ", [8, [0, 0, 0], [1, 1], [0, 0], [12, 10, 0]]],
       "major_words:    %*.0f\n"],
    _j_ = [0, [12, 10, 0], cst],
    _k_ = [0, [4, 0, 0, 0, 0], "%d"],
    _l_ =
      [0,
       [11, "top_heap_words: ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "top_heap_words: %*d\n"],
    _m_ =
      [0,
       [11, "heap_words:     ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "heap_words:     %*d\n"],
    _n_ =
      [0,
       [11, "live_words:     ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "live_words:     %*d\n"],
    _o_ =
      [0,
       [11, "free_words:     ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "free_words:     %*d\n"],
    _p_ =
      [0,
       [11, "largest_free:   ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "largest_free:   %*d\n"],
    _q_ =
      [0,
       [11, "fragments:      ", [4, 0, [1, 1], 0, [12, 10, 0]]],
       "fragments:      %*d\n"],
    _r_ = [0, [12, 10, 0], cst],
    _s_ =
      [0,
       [11, "live_blocks: ", [4, 0, 0, 0, [12, 10, 0]]],
       "live_blocks: %d\n"],
    _t_ =
      [0,
       [11, "free_blocks: ", [4, 0, 0, 0, [12, 10, 0]]],
       "free_blocks: %d\n"],
    _u_ =
      [0,
       [11, "heap_chunks: ", [4, 0, 0, 0, [12, 10, 0]]],
       "heap_chunks: %d\n"];
   function eventlog_pause(param){
     /*<<gc.ml:65:24>>*/ return 0;
    /*<<gc.ml:65:26>>*/ }
   function eventlog_resume(param){ /*<<gc.ml:66:25>>*/ return 0;
    /*<<gc.ml:66:27>>*/ }
   function print_stat(c){
     /*<<gc.ml:71:2>>*/  /*<<gc.ml:71:11>>*/ var
     st =  /*<<gc.ml:71:11>>*/ runtime.caml_gc_stat(0);
     /*<<gc.ml:72:2>>*/  /*<<gc.ml:72:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _a_, st[4]);
     /*<<gc.ml:73:2>>*/  /*<<gc.ml:73:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _b_, st[5]);
     /*<<gc.ml:74:2>>*/  /*<<gc.ml:74:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _c_, st[14]);
     /*<<gc.ml:75:2>>*/  /*<<gc.ml:75:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _d_, st[17]);
     /*<<gc.ml:76:2>>*/  /*<<gc.ml:76:2>>*/ caml_call2
     (Stdlib_Printf[1], c, _e_);
     /*<<gc.ml:77:25>>*/  /*<<gc.ml:77:25>>*/ var
     l1 =
        /*<<gc.ml:77:25>>*/ caml_ml_string_length
        ( /*<<gc.ml:77:25>>*/ caml_call2(Stdlib_Printf[4], _f_, st[1]));
     /*<<gc.ml:78:2>>*/  /*<<gc.ml:78:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _g_, l1, st[1]);
     /*<<gc.ml:79:2>>*/  /*<<gc.ml:79:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _h_, l1, st[2]);
     /*<<gc.ml:80:2>>*/  /*<<gc.ml:80:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _i_, l1, st[3]);
     /*<<gc.ml:81:2>>*/  /*<<gc.ml:81:2>>*/ caml_call2
     (Stdlib_Printf[1], c, _j_);
     /*<<gc.ml:82:25>>*/  /*<<gc.ml:82:25>>*/ var
     l2 =
        /*<<gc.ml:82:25>>*/ caml_ml_string_length
        ( /*<<gc.ml:82:25>>*/ caml_call2(Stdlib_Printf[4], _k_, st[15]));
     /*<<gc.ml:83:2>>*/  /*<<gc.ml:83:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _l_, l2, st[15]);
     /*<<gc.ml:84:2>>*/  /*<<gc.ml:84:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _m_, l2, st[6]);
     /*<<gc.ml:85:2>>*/  /*<<gc.ml:85:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _n_, l2, st[8]);
     /*<<gc.ml:86:2>>*/  /*<<gc.ml:86:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _o_, l2, st[10]);
     /*<<gc.ml:87:2>>*/  /*<<gc.ml:87:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _p_, l2, st[12]);
     /*<<gc.ml:88:2>>*/  /*<<gc.ml:88:2>>*/ caml_call4
     (Stdlib_Printf[1], c, _q_, l2, st[13]);
     /*<<gc.ml:89:2>>*/  /*<<gc.ml:89:2>>*/ caml_call2
     (Stdlib_Printf[1], c, _r_);
     /*<<gc.ml:90:2>>*/  /*<<gc.ml:90:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _s_, st[9]);
     /*<<gc.ml:91:2>>*/  /*<<gc.ml:91:2>>*/ caml_call3
     (Stdlib_Printf[1], c, _t_, st[11]);
    return caml_call3(Stdlib_Printf[1], c, _u_, st[7]);
    /*<<gc.ml:92:46>>*/ }
   function allocated_bytes(param){
     /*<<gc.ml:96:2>>*/ var
      /*<<gc.ml:96:22>>*/ match =
        /*<<gc.ml:96:22>>*/ runtime.caml_gc_counters(0),
     ma = match[3],
     pro = match[2],
     mi = match[1];
     /*<<gc.ml:97:2>>*/ return (mi + ma - pro) * (Stdlib_Sys[9] / 8 | 0);
    /*<<gc.ml:97:55>>*/ }
   function create_alarm(f){
     /*<<gc.ml:117:2>>*/ return  /*<<gc.ml:117:24>>*/ caml_call1
            (Stdlib_Atomic[1], 1);
    /*<<gc.ml:119:13>>*/ }
   function delete_alarm(a){
     /*<<gc.ml:122:21>>*/ return  /*<<gc.ml:122:21>>*/ caml_call2
            (Stdlib_Atomic[3], a, 0);
    /*<<gc.ml:122:39>>*/ }
    /*<<gc.ml:141:23>>*/  /*<<gc.ml:141:23>>*/ var
    null_tracker =
      [0,
       function(param){ /*<<gc.ml:142:30>>*/ return 0; /*<<gc.ml:142:34>>*/ },
       function(param){ /*<<gc.ml:143:30>>*/ return 0; /*<<gc.ml:143:34>>*/ },
       function(param){ /*<<gc.ml:144:26>>*/ return 0; /*<<gc.ml:144:30>>*/ },
       function(param){ /*<<gc.ml:145:32>>*/ return 0; /*<<gc.ml:145:34>>*/ },
       function(param){ /*<<gc.ml:146:32>>*/ return 0; /*<<gc.ml:146:34>>*/ }];
   function start(sampling_rate, opt, tracker){
     /*<<gc.ml:157:6>>*/ if(opt)
     var sth = opt[1], callstack_size = sth;
    else
     var callstack_size = Stdlib[19];
     /*<<gc.ml:157:6>>*/ return  /*<<gc.ml:157:6>>*/ runtime.caml_memprof_start
            (sampling_rate, callstack_size, tracker);
    /*<<gc.ml:157:50>>*/ }
   var
    Stdlib_Gc =
      [0,
       print_stat,
       allocated_bytes,
       function(_x_, _w_){
         /*<<?>>*/ return runtime.caml_final_register(_x_, _w_);
       },
       runtime.caml_final_register_called_without_value,
       function(_v_){ /*<<?>>*/ return runtime.caml_final_release(_v_);},
       create_alarm,
       delete_alarm,
       eventlog_pause,
       eventlog_resume,
       [0, null_tracker, start, runtime.caml_memprof_stop]];
   runtime.caml_register_global(26, Stdlib_Gc, "Stdlib__Gc");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Digest
//# unitInfo: Requires: Stdlib, Stdlib__Bytes, Stdlib__Char, Stdlib__String
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Digest_from_hex$1 = "Digest.from_hex",
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_md5_string = runtime.caml_md5_string,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_get = runtime.caml_string_get,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Char = global_data.Stdlib__Char,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_String = global_data.Stdlib__String,
    compare = Stdlib_String[10],
    equal = Stdlib_String[9],
    cst_Digest_substring = "Digest.substring",
    cst_Digest_to_hex = "Digest.to_hex",
    cst_Digest_from_hex = cst_Digest_from_hex$1,
    cst_Digest_from_hex$0 = cst_Digest_from_hex$1;
   function string(str){
     /*<<digest.ml:27:2>>*/ return  /*<<digest.ml:27:2>>*/ caml_md5_string
            (str, 0, caml_ml_string_length(str));
    /*<<digest.ml:27:41>>*/ }
   function bytes(b){
     /*<<digest.ml:29:14>>*/ return string
            ( /*<<digest.ml:29:21>>*/ caml_call1(Stdlib_Bytes[44], b));
    /*<<digest.ml:29:47>>*/ }
   function substring(str, ofs, len){
     /*<<digest.ml:32:2>>*/ if
     (0 <= ofs && 0 <= len && (caml_ml_string_length(str) - len | 0) >= ofs)
      /*<<digest.ml:34:7>>*/ return  /*<<digest.ml:34:7>>*/ caml_md5_string
             (str, ofs, len);
     /*<<digest.ml:33:7>>*/ return  /*<<digest.ml:33:7>>*/ caml_call1
            (Stdlib[1], cst_Digest_substring);
    /*<<digest.ml:34:32>>*/ }
   function subbytes(b, ofs, len){
     /*<<digest.ml:36:25>>*/ return substring
            ( /*<<digest.ml:36:35>>*/ caml_call1(Stdlib_Bytes[44], b),
             ofs,
             len);
    /*<<digest.ml:36:69>>*/ }
   function file(filename){
     /*<<digest.ml:39:2>>*/  /*<<digest.ml:39:11>>*/ var
     ic =  /*<<digest.ml:39:11>>*/ caml_call1(Stdlib[80], filename);
     /*<<digest.ml:40:2>>*/ try{
      /*<<digest.ml:40:8>>*/  /*<<digest.ml:40:8>>*/ var
      d =  /*<<digest.ml:40:8>>*/ runtime.caml_md5_chan(ic, -1);
    }
    catch(e$0){
     var e = caml_wrap_exception(e$0);
      /*<<digest.ml:42:21>>*/  /*<<digest.ml:42:21>>*/ caml_call1
      (Stdlib[93], ic);
      /*<<digest.ml:42:34>>*/ throw  /*<<digest.ml:42:34>>*/ caml_maybe_attach_backtrace
            (e, 0);
    }
     /*<<digest.ml:41:11>>*/  /*<<digest.ml:41:11>>*/ caml_call1
     (Stdlib[93], ic);
     /*<<digest.ml:41:11>>*/ return d;
    /*<<digest.ml:42:41>>*/ }
   function output(chan, digest){
     /*<<digest.ml:45:2>>*/ return  /*<<digest.ml:45:2>>*/ caml_call2
            (Stdlib[66], chan, digest);
    /*<<digest.ml:45:27>>*/ }
   function input(chan){
     /*<<digest.ml:47:17>>*/ return  /*<<digest.ml:47:17>>*/ caml_call2
            (Stdlib[86], chan, 16);
    /*<<digest.ml:47:44>>*/ }
   function char_hex(n){
     /*<<digest.ml:50:2>>*/ var _e_ = 10 <= n ? 87 : 48;
    return n + _e_ | 0;
    /*<<digest.ml:50:78>>*/ }
   function to_hex(d){
     /*<<digest.ml:53:2>>*/ if(16 !== caml_ml_string_length(d))
      /*<<digest.ml:53:32>>*/  /*<<digest.ml:53:32>>*/ caml_call1
      (Stdlib[1], cst_Digest_to_hex);
     /*<<digest.ml:54:15>>*/ var
      /*<<digest.ml:54:15>>*/ result =
        /*<<digest.ml:54:15>>*/ caml_create_bytes(32),
     i = 0;
    for(;;){
      /*<<digest.ml:56:22>>*/  /*<<digest.ml:56:22>>*/ var
      x =  /*<<digest.ml:56:22>>*/ caml_string_get(d, i);
     caml_bytes_unsafe_set(result, i * 2 | 0, char_hex(x >>> 4 | 0));
     caml_bytes_unsafe_set(result, (i * 2 | 0) + 1 | 0, char_hex(x & 15));
      /*<<digest.ml:55:2>>*/  /*<<digest.ml:55:2>>*/ var _d_ = i + 1 | 0;
     if(15 === i)
       /*<<digest.ml:60:2>>*/ return  /*<<digest.ml:60:2>>*/ caml_call1
              (Stdlib_Bytes[44], result);
     var i = _d_;
    }
    /*<<digest.ml:60:31>>*/ }
   function from_hex(s){
     /*<<digest.ml:63:2>>*/ if(32 !== caml_ml_string_length(s))
      /*<<digest.ml:63:32>>*/  /*<<digest.ml:63:32>>*/ caml_call1
      (Stdlib[1], cst_Digest_from_hex);
     /*<<digest.ml:63:32>>*/ function digit(c){
      /*<<digest.ml:65:4>>*/ if(65 <= c){
      if(97 <= c){
       if(103 > c) return (c - 97 | 0) + 10 | 0;
      }
      else if(71 > c) return (c - 65 | 0) + 10 | 0;
     }
     else if(9 >= c - 48 >>> 0) return c - 48 | 0;
      /*<<digest.ml:69:11>>*/ throw  /*<<digest.ml:69:11>>*/ caml_maybe_attach_backtrace
            ([0, Stdlib[6], cst_Digest_from_hex$0], 1);
     /*<<digest.ml:69:53>>*/ }
     /*<<digest.ml:72:15>>*/ var
      /*<<digest.ml:72:15>>*/ result =
        /*<<digest.ml:72:15>>*/ caml_create_bytes(16),
     i = 0;
    for(;;){
      /*<<digest.ml:71:35>>*/ var
      i$0 = 2 * i | 0,
       /*<<digest.ml:71:35>>*/ _a_ =
        digit( /*<<digest.ml:71:41>>*/ caml_string_get(s, i$0 + 1 | 0)),
      _b_ =
        (digit( /*<<digest.ml:71:21>>*/ caml_string_get(s, i$0)) << 4) + _a_
        | 0;
      /*<<digest.ml:74:4>>*/  /*<<digest.ml:74:4>>*/ runtime.caml_bytes_set
      (result, i,  /*<<digest.ml:74:23>>*/ caml_call1(Stdlib_Char[1], _b_));
      /*<<digest.ml:74:4>>*/  /*<<digest.ml:74:4>>*/ var _c_ = i + 1 | 0;
     if(15 === i)
       /*<<digest.ml:76:2>>*/ return  /*<<digest.ml:76:2>>*/ caml_call1
              (Stdlib_Bytes[44], result);
     var i = _c_;
    }
    /*<<digest.ml:76:31>>*/ }
   var
    Stdlib_Digest =
      [0,
       compare,
       equal,
       string,
       bytes,
       substring,
       subbytes,
       file,
       output,
       input,
       to_hex,
       from_hex];
   runtime.caml_register_global(8, Stdlib_Digest, "Stdlib__Digest");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Bigarray
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Bigarray_Array3_of_array_n$1 =
      "Bigarray.Array3.of_array: non-cubic data",
    caml_ba_change_layout = runtime.caml_ba_change_layout,
    caml_ba_create = runtime.caml_ba_create,
    caml_ba_dim_1 = runtime.caml_ba_dim_1,
    caml_ba_dim_2 = runtime.caml_ba_dim_2,
    caml_ba_kind = runtime.caml_ba_kind,
    caml_ba_num_dims = runtime.caml_ba_num_dims,
    caml_ba_reshape = runtime.caml_ba_reshape,
    caml_ba_set_1 = runtime.caml_ba_set_1,
    caml_ba_set_2 = runtime.caml_ba_set_2,
    caml_ba_set_3 = runtime.caml_ba_set_3,
    caml_ba_set_generic = runtime.caml_ba_set_generic,
    caml_ba_slice = runtime.caml_ba_slice,
    caml_check_bound = runtime.caml_check_bound,
    caml_make_vect = runtime.caml_make_vect,
    caml_mul = runtime.caml_mul;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Sys = global_data.Stdlib__Sys;
   function kind_size_in_bytes(param){
     /*<<?>>*/ switch(param){
      case 0:
        /*<<bigarray.ml:74:15>>*/ return 4;
      case 1:
        /*<<bigarray.ml:75:15>>*/ return 8;
      case 2:
        /*<<bigarray.ml:76:19>>*/ return 1;
      case 3:
        /*<<bigarray.ml:77:21>>*/ return 1;
      case 4:
        /*<<bigarray.ml:78:20>>*/ return 2;
      case 5:
        /*<<bigarray.ml:79:22>>*/ return 2;
      case 6:
        /*<<bigarray.ml:80:13>>*/ return 4;
      case 7:
        /*<<bigarray.ml:81:13>>*/ return 8;
      case 8:
       return Stdlib_Sys[9] / 8 | 0;
      case 9:
       return Stdlib_Sys[9] / 8 | 0;
      case 10:
        /*<<bigarray.ml:84:17>>*/ return 8;
      case 11:
        /*<<bigarray.ml:85:17>>*/ return 16;
      default:  /*<<bigarray.ml:86:12>>*/ return 1;
    }
   }
   var
    cst_Bigarray_Array2_of_array_n =
      "Bigarray.Array2.of_array: non-rectangular data",
    cst_Bigarray_Array3_of_array_n = cst_Bigarray_Array3_of_array_n$1,
    cst_Bigarray_Array3_of_array_n$0 = cst_Bigarray_Array3_of_array_n$1,
    cst_Bigarray_array0_of_genarra = "Bigarray.array0_of_genarray",
    cst_Bigarray_array1_of_genarra = "Bigarray.array1_of_genarray",
    cst_Bigarray_array2_of_genarra = "Bigarray.array2_of_genarray",
    cst_Bigarray_array3_of_genarra = "Bigarray.array3_of_genarray";
   function cloop(arr, idx, f, col, max){
     /*<<bigarray.ml:104:4>>*/ if(col === idx.length - 1){
      /*<<bigarray.ml:104:35>>*/  /*<<bigarray.ml:104:35>>*/ caml_ba_set_generic
      (arr, idx,  /*<<bigarray.ml:104:47>>*/ caml_call1(f, idx));
      /*<<bigarray.ml:104:35>>*/ return;
    }
     /*<<bigarray.ml:105:27>>*/ var
      /*<<bigarray.ml:105:27>>*/ _am_ =
       caml_check_bound(max, col)[1 + col] - 1 | 0,
      /*<<bigarray.ml:105:9>>*/ _al_ = 0;
    if(_am_ >= 0){
     var j = _al_;
     for(;;){
       /*<<bigarray.ml:106:11>>*/ caml_check_bound(idx, col)[1 + col] = j;
       /*<<bigarray.ml:107:11>>*/ cloop(arr, idx, f, col + 1 | 0, max);
       /*<<bigarray.ml:107:11>>*/  /*<<bigarray.ml:107:11>>*/ var
       _an_ = j + 1 | 0;
      if(_am_ === j) break;
      var j = _an_;
     }
    }
    return;
    /*<<bigarray.ml:108:13>>*/ }
   function floop(arr, idx, f, col, max){
     /*<<bigarray.ml:110:4>>*/ if(0 > col){
      /*<<bigarray.ml:110:20>>*/  /*<<bigarray.ml:110:20>>*/ caml_ba_set_generic
      (arr, idx,  /*<<bigarray.ml:110:32>>*/ caml_call1(f, idx));
      /*<<bigarray.ml:110:20>>*/ return;
    }
     /*<<bigarray.ml:111:22>>*/ var
      /*<<bigarray.ml:111:22>>*/ _aj_ = caml_check_bound(max, col)[1 + col],
      /*<<bigarray.ml:111:9>>*/ _ai_ = 1;
    if(_aj_ >= 1){
     var j = _ai_;
     for(;;){
       /*<<bigarray.ml:112:11>>*/ caml_check_bound(idx, col)[1 + col] = j;
       /*<<bigarray.ml:113:11>>*/ floop(arr, idx, f, col - 1 | 0, max);
       /*<<bigarray.ml:113:11>>*/  /*<<bigarray.ml:113:11>>*/ var
       _ak_ = j + 1 | 0;
      if(_aj_ === j) break;
      var j = _ak_;
     }
    }
    return;
    /*<<bigarray.ml:114:13>>*/ }
   function init(kind, layout, dims, f){
     /*<<bigarray.ml:116:4>>*/ var
      /*<<bigarray.ml:116:14>>*/ arr =
        /*<<bigarray.ml:116:14>>*/ caml_ba_create(kind, layout, dims),
      /*<<bigarray.ml:117:4>>*/ dlen = dims.length - 1;
     /*<<bigarray.ml:118:4>>*/ return layout
            ? (floop
               (arr,
                 /*<<bigarray.ml:120:34>>*/ caml_make_vect(dlen, 1),
                f,
                dlen - 1 | 0,
                dims),
              arr)
            : (cloop
               (arr,
                 /*<<bigarray.ml:119:28>>*/ caml_make_vect(dlen, 0),
                f,
                0,
                dims),
              arr);
    /*<<bigarray.ml:120:77>>*/ }
   function dims(a){
     /*<<bigarray.ml:125:4>>*/ var
      /*<<bigarray.ml:125:12>>*/ n =
        /*<<bigarray.ml:125:12>>*/ caml_ba_num_dims(a),
      /*<<bigarray.ml:126:12>>*/ d =
        /*<<bigarray.ml:126:12>>*/ caml_make_vect(n, 0),
      /*<<bigarray.ml:127:4>>*/ _af_ = n - 1 | 0,
      /*<<bigarray.ml:126:12>>*/ _ae_ = 0;
    if(_af_ >= 0){
     var i = _ae_;
     for(;;){
       /*<<bigarray.ml:127:33>>*/  /*<<bigarray.ml:127:33>>*/ var
       _ag_ =  /*<<bigarray.ml:127:33>>*/ runtime.caml_ba_dim(a, i);
       /*<<bigarray.ml:127:24>>*/ caml_check_bound(d, i)[1 + i] = _ag_;
       /*<<bigarray.ml:127:24>>*/  /*<<bigarray.ml:127:24>>*/ var
       _ah_ = i + 1 | 0;
      if(_af_ === i) break;
      var i = _ah_;
     }
    }
     /*<<bigarray.ml:128:4>>*/ return d;
    /*<<bigarray.ml:128:5>>*/ }
   function size_in_bytes(arr){
     /*<<bigarray.ml:136:4>>*/ var
      /*<<bigarray.ml:136:63>>*/ _ac_ = dims(arr),
      /*<<bigarray.ml:136:38>>*/ _ad_ =
        /*<<bigarray.ml:136:38>>*/ caml_call3
        (Stdlib_Array[17], caml_mul, 1, _ac_);
     /*<<bigarray.ml:136:4>>*/ return  /*<<bigarray.ml:136:4>>*/ caml_mul
            (kind_size_in_bytes( /*<<bigarray.ml:136:24>>*/ caml_ba_kind(arr)),
             _ad_);
    /*<<bigarray.ml:136:74>>*/ }
   function create(kind, layout){
     /*<<bigarray.ml:157:4>>*/ return  /*<<bigarray.ml:157:4>>*/ caml_ba_create
            (kind, layout, [0]);
    /*<<bigarray.ml:157:36>>*/ }
   function get(arr){
     /*<<bigarray.ml:158:16>>*/ return  /*<<bigarray.ml:158:16>>*/ runtime.caml_ba_get_generic
            (arr, [0]);
    /*<<bigarray.ml:158:37>>*/ }
   function set(arr){
     /*<<bigarray.ml:159:16>>*/  /*<<bigarray.ml:159:16>>*/ var _aa_ = [0];
     /*<<bigarray.ml:159:33>>*/ return function(_ab_){
      /*<<?>>*/ return caml_ba_set_generic(arr, _aa_, _ab_);};
    /*<<bigarray.ml:159:37>>*/ }
   function size_in_bytes$0(arr){
     /*<<bigarray.ml:166:26>>*/ return kind_size_in_bytes
            ( /*<<bigarray.ml:166:45>>*/ caml_ba_kind(arr));
    /*<<bigarray.ml:166:55>>*/ }
   function of_value(kind, layout, v){
     /*<<bigarray.ml:172:4>>*/  /*<<bigarray.ml:172:12>>*/ var
     a = create(kind, layout);
     /*<<bigarray.ml:173:4>>*/ set(a)(v);
     /*<<bigarray.ml:173:4>>*/ return a;
    /*<<bigarray.ml:174:5>>*/ }
   function create$0(kind, layout, dim){
     /*<<bigarray.ml:181:4>>*/ return  /*<<bigarray.ml:181:4>>*/ caml_ba_create
            (kind, layout, [0, dim]);
    /*<<bigarray.ml:181:39>>*/ }
   function size_in_bytes$1(arr){
     /*<<bigarray.ml:195:4>>*/  /*<<bigarray.ml:195:38>>*/ var
     _$_ =  /*<<bigarray.ml:195:38>>*/ caml_ba_dim_1(arr);
     /*<<bigarray.ml:195:4>>*/ return  /*<<bigarray.ml:195:4>>*/ caml_mul
            (kind_size_in_bytes( /*<<bigarray.ml:195:24>>*/ caml_ba_kind(arr)),
             _$_);
    /*<<bigarray.ml:195:47>>*/ }
   function slice(a, n){
     /*<<bigarray.ml:199:4>>*/ return  /*<<bigarray.ml:199:10>>*/ runtime.caml_ba_layout
             (a)
            ?  /*<<bigarray.ml:201:25>>*/ caml_ba_slice(a, [0, n])
            :  /*<<bigarray.ml:200:19>>*/ caml_ba_slice(a, [0, n]);
    /*<<bigarray.ml:201:76>>*/ }
   function init$0(kind, layout, dim, f){
     /*<<bigarray.ml:209:4>>*/  /*<<bigarray.ml:209:14>>*/ var
     arr = create$0(kind, layout, dim);
     /*<<bigarray.ml:210:4>>*/ if(layout){
      /*<<bigarray.ml:207:4>>*/  /*<<bigarray.ml:207:4>>*/ var _Z_ = 1;
     if(dim >= 1){
      var i$0 = _Z_;
      for(;;){
        /*<<bigarray.ml:207:24>>*/  /*<<bigarray.ml:207:24>>*/ caml_ba_set_1
        (arr, i$0,  /*<<bigarray.ml:207:41>>*/ caml_call1(f, i$0));
        /*<<bigarray.ml:207:24>>*/  /*<<bigarray.ml:207:24>>*/ var
        ___ = i$0 + 1 | 0;
       if(dim === i$0) break;
       var i$0 = ___;
      }
     }
      /*<<bigarray.ml:212:24>>*/ return arr;
    }
     /*<<bigarray.ml:205:4>>*/ var
     _X_ = dim - 1 | 0,
      /*<<bigarray.ml:205:4>>*/ _W_ = 0;
    if(_X_ >= 0){
     var i = _W_;
     for(;;){
       /*<<bigarray.ml:205:29>>*/  /*<<bigarray.ml:205:29>>*/ caml_ba_set_1
       (arr, i,  /*<<bigarray.ml:205:46>>*/ caml_call1(f, i));
       /*<<bigarray.ml:205:29>>*/  /*<<bigarray.ml:205:29>>*/ var
       _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
     /*<<bigarray.ml:211:18>>*/ return arr;
    /*<<bigarray.ml:212:51>>*/ }
   function of_array(kind, layout, data){
     /*<<bigarray.ml:214:4>>*/ var
      /*<<bigarray.ml:214:13>>*/ ba = create$0(kind, layout, data.length - 1),
      /*<<bigarray.ml:215:4>>*/ ofs = layout ? 1 : 0,
     _U_ = data.length - 1 - 1 | 0,
     _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
       /*<<bigarray.ml:220:42>>*/  /*<<bigarray.ml:220:42>>*/ caml_ba_set_1
       (ba, i + ofs | 0, caml_check_bound(data, i)[1 + i]);
       /*<<bigarray.ml:220:42>>*/  /*<<bigarray.ml:220:42>>*/ var
       _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
     /*<<bigarray.ml:221:4>>*/ return ba;
    /*<<bigarray.ml:221:6>>*/ }
   function create$1(kind, layout, dim1, dim2){
     /*<<bigarray.ml:227:4>>*/ return  /*<<bigarray.ml:227:4>>*/ caml_ba_create
            (kind, layout, [0, dim1, dim2]);
    /*<<bigarray.ml:227:46>>*/ }
   function size_in_bytes$2(arr){
     /*<<bigarray.ml:243:4>>*/ var
      /*<<bigarray.ml:243:51>>*/ _R_ =
        /*<<bigarray.ml:243:51>>*/ caml_ba_dim_2(arr),
      /*<<bigarray.ml:243:38>>*/ _S_ =
        /*<<bigarray.ml:243:38>>*/ caml_ba_dim_1(arr);
    return caml_mul
            ( /*<<bigarray.ml:243:4>>*/ caml_mul
              (kind_size_in_bytes
                ( /*<<bigarray.ml:243:24>>*/ caml_ba_kind(arr)),
               _S_),
             _R_);
    /*<<bigarray.ml:243:61>>*/ }
   function slice_left(a, n){
     /*<<bigarray.ml:250:23>>*/ return  /*<<bigarray.ml:250:23>>*/ caml_ba_slice
            (a, [0, n]);
    /*<<bigarray.ml:250:50>>*/ }
   function slice_right(a, n){
     /*<<bigarray.ml:251:24>>*/ return  /*<<bigarray.ml:251:24>>*/ caml_ba_slice
            (a, [0, n]);
    /*<<bigarray.ml:251:52>>*/ }
   function init$1(kind, layout, dim1, dim2, f){
     /*<<bigarray.ml:267:4>>*/  /*<<bigarray.ml:267:14>>*/ var
     arr = create$1(kind, layout, dim1, dim2);
     /*<<bigarray.ml:268:4>>*/ if(layout){
      /*<<bigarray.ml:261:4>>*/  /*<<bigarray.ml:261:4>>*/ var _N_ = 1;
     if(dim2 >= 1){
      var j$0 = _N_;
      for(;;){
        /*<<bigarray.ml:262:6>>*/  /*<<bigarray.ml:262:6>>*/ var _O_ = 1;
       if(dim1 >= 1){
        var i$0 = _O_;
        for(;;){
          /*<<bigarray.ml:263:8>>*/  /*<<bigarray.ml:263:8>>*/ caml_ba_set_2
          (arr, i$0, j$0,  /*<<bigarray.ml:263:27>>*/ caml_call2(f, i$0, j$0));
          /*<<bigarray.ml:263:8>>*/  /*<<bigarray.ml:263:8>>*/ var
          _Q_ = i$0 + 1 | 0;
         if(dim1 === i$0) break;
         var i$0 = _Q_;
        }
       }
        /*<<bigarray.ml:261:4>>*/  /*<<bigarray.ml:261:4>>*/ var
        _P_ = j$0 + 1 | 0;
       if(dim2 === j$0) break;
       var j$0 = _P_;
      }
     }
      /*<<bigarray.ml:270:24>>*/ return arr;
    }
     /*<<bigarray.ml:255:4>>*/ var
     _I_ = dim1 - 1 | 0,
      /*<<bigarray.ml:255:4>>*/ _H_ = 0;
    if(_I_ >= 0){
     var i = _H_;
     for(;;){
       /*<<bigarray.ml:256:6>>*/ var
       _K_ = dim2 - 1 | 0,
        /*<<bigarray.ml:256:6>>*/ _J_ = 0;
      if(_K_ >= 0){
       var j = _J_;
       for(;;){
         /*<<bigarray.ml:257:8>>*/  /*<<bigarray.ml:257:8>>*/ caml_ba_set_2
         (arr, i, j,  /*<<bigarray.ml:257:27>>*/ caml_call2(f, i, j));
         /*<<bigarray.ml:257:8>>*/  /*<<bigarray.ml:257:8>>*/ var
         _M_ = j + 1 | 0;
        if(_K_ === j) break;
        var j = _M_;
       }
      }
       /*<<bigarray.ml:255:4>>*/  /*<<bigarray.ml:255:4>>*/ var
       _L_ = i + 1 | 0;
      if(_I_ === i) break;
      var i = _L_;
     }
    }
     /*<<bigarray.ml:269:18>>*/ return arr;
    /*<<bigarray.ml:270:57>>*/ }
   function of_array$0(kind, layout, data){
     /*<<bigarray.ml:272:4>>*/ var
     dim1 = data.length - 1,
      /*<<bigarray.ml:273:4>>*/ dim2 =
       0 === dim1 ? 0 : caml_check_bound(data, 0)[1].length - 1,
      /*<<bigarray.ml:274:13>>*/ ba = create$1(kind, layout, dim1, dim2),
      /*<<bigarray.ml:275:4>>*/ ofs = layout ? 1 : 0,
      /*<<bigarray.ml:280:4>>*/ _C_ = dim1 - 1 | 0,
     _B_ = 0;
    if(_C_ >= 0){
     var i = _B_;
     for(;;){
       /*<<bigarray.ml:281:16>>*/  /*<<bigarray.ml:281:16>>*/ var
       row = caml_check_bound(data, i)[1 + i];
      if(row.length - 1 !== dim2)
        /*<<bigarray.ml:283:8>>*/  /*<<bigarray.ml:283:8>>*/ caml_call1
        (Stdlib[1], cst_Bigarray_Array2_of_array_n);
       /*<<bigarray.ml:273:32>>*/ var
        /*<<bigarray.ml:273:32>>*/ _E_ = dim2 - 1 | 0,
        /*<<bigarray.ml:283:8>>*/ _D_ = 0;
      if(_E_ >= 0){
       var j = _D_;
       for(;;){
         /*<<bigarray.ml:285:8>>*/  /*<<bigarray.ml:285:8>>*/ caml_ba_set_2
         (ba, i + ofs | 0, j + ofs | 0, caml_check_bound(row, j)[1 + j]);
         /*<<bigarray.ml:285:8>>*/  /*<<bigarray.ml:285:8>>*/ var
         _G_ = j + 1 | 0;
        if(_E_ === j) break;
        var j = _G_;
       }
      }
       /*<<bigarray.ml:280:4>>*/  /*<<bigarray.ml:280:4>>*/ var
       _F_ = i + 1 | 0;
      if(_C_ === i) break;
      var i = _F_;
     }
    }
     /*<<bigarray.ml:288:4>>*/ return ba;
    /*<<bigarray.ml:288:6>>*/ }
   function create$2(kind, layout, dim1, dim2, dim3){
     /*<<bigarray.ml:294:4>>*/ return  /*<<bigarray.ml:294:4>>*/ caml_ba_create
            (kind, layout, [0, dim1, dim2, dim3]);
    /*<<bigarray.ml:294:52>>*/ }
   function size_in_bytes$3(arr){
     /*<<bigarray.ml:312:4>>*/ var
      /*<<bigarray.ml:312:64>>*/ _y_ =
        /*<<bigarray.ml:312:64>>*/ runtime.caml_ba_dim_3(arr),
      /*<<bigarray.ml:312:51>>*/ _z_ =
        /*<<bigarray.ml:312:51>>*/ caml_ba_dim_2(arr),
      /*<<bigarray.ml:312:38>>*/ _A_ =
        /*<<bigarray.ml:312:38>>*/ caml_ba_dim_1(arr);
    return caml_mul
            (caml_mul
              ( /*<<bigarray.ml:312:4>>*/ caml_mul
                (kind_size_in_bytes
                  ( /*<<bigarray.ml:312:24>>*/ caml_ba_kind(arr)),
                 _A_),
               _z_),
             _y_);
    /*<<bigarray.ml:312:74>>*/ }
   function slice_left_1(a, n, m){
     /*<<bigarray.ml:319:27>>*/ return  /*<<bigarray.ml:319:27>>*/ caml_ba_slice
            (a, [0, n, m]);
    /*<<bigarray.ml:319:57>>*/ }
   function slice_right_1(a, n, m){
     /*<<bigarray.ml:320:28>>*/ return  /*<<bigarray.ml:320:28>>*/ caml_ba_slice
            (a, [0, n, m]);
    /*<<bigarray.ml:320:59>>*/ }
   function slice_left_2(a, n){
     /*<<bigarray.ml:321:25>>*/ return  /*<<bigarray.ml:321:25>>*/ caml_ba_slice
            (a, [0, n]);
    /*<<bigarray.ml:321:52>>*/ }
   function slice_right_2(a, n){
     /*<<bigarray.ml:322:26>>*/ return  /*<<bigarray.ml:322:26>>*/ caml_ba_slice
            (a, [0, n]);
    /*<<bigarray.ml:322:54>>*/ }
   function init$2(kind, layout, dim1, dim2, dim3, f){
     /*<<bigarray.ml:342:4>>*/  /*<<bigarray.ml:342:14>>*/ var
     arr = create$2(kind, layout, dim1, dim2, dim3);
     /*<<bigarray.ml:343:4>>*/ if(layout){
      /*<<bigarray.ml:334:4>>*/  /*<<bigarray.ml:334:4>>*/ var _s_ = 1;
     if(dim3 >= 1){
      var k$0 = _s_;
      for(;;){
        /*<<bigarray.ml:335:6>>*/  /*<<bigarray.ml:335:6>>*/ var _t_ = 1;
       if(dim2 >= 1){
        var j$0 = _t_;
        for(;;){
          /*<<bigarray.ml:336:8>>*/  /*<<bigarray.ml:336:8>>*/ var _v_ = 1;
         if(dim1 >= 1){
          var i$0 = _v_;
          for(;;){
            /*<<bigarray.ml:337:10>>*/  /*<<bigarray.ml:337:10>>*/ caml_ba_set_3
            (arr,
             i$0,
             j$0,
             k$0,
              /*<<bigarray.ml:337:31>>*/ caml_call3(f, i$0, j$0, k$0));
            /*<<bigarray.ml:337:10>>*/  /*<<bigarray.ml:337:10>>*/ var
            _x_ = i$0 + 1 | 0;
           if(dim1 === i$0) break;
           var i$0 = _x_;
          }
         }
          /*<<bigarray.ml:335:6>>*/  /*<<bigarray.ml:335:6>>*/ var
          _w_ = j$0 + 1 | 0;
         if(dim2 === j$0) break;
         var j$0 = _w_;
        }
       }
        /*<<bigarray.ml:334:4>>*/  /*<<bigarray.ml:334:4>>*/ var
        _u_ = k$0 + 1 | 0;
       if(dim3 === k$0) break;
       var k$0 = _u_;
      }
     }
      /*<<bigarray.ml:345:24>>*/ return arr;
    }
     /*<<bigarray.ml:326:4>>*/ var
     _k_ = dim1 - 1 | 0,
      /*<<bigarray.ml:326:4>>*/ _j_ = 0;
    if(_k_ >= 0){
     var i = _j_;
     for(;;){
       /*<<bigarray.ml:327:6>>*/ var
       _m_ = dim2 - 1 | 0,
        /*<<bigarray.ml:327:6>>*/ _l_ = 0;
      if(_m_ >= 0){
       var j = _l_;
       for(;;){
         /*<<bigarray.ml:328:8>>*/ var
         _p_ = dim3 - 1 | 0,
          /*<<bigarray.ml:328:8>>*/ _o_ = 0;
        if(_p_ >= 0){
         var k = _o_;
         for(;;){
           /*<<bigarray.ml:329:10>>*/  /*<<bigarray.ml:329:10>>*/ caml_ba_set_3
           (arr, i, j, k,  /*<<bigarray.ml:329:31>>*/ caml_call3(f, i, j, k));
           /*<<bigarray.ml:329:10>>*/  /*<<bigarray.ml:329:10>>*/ var
           _r_ = k + 1 | 0;
          if(_p_ === k) break;
          var k = _r_;
         }
        }
         /*<<bigarray.ml:327:6>>*/  /*<<bigarray.ml:327:6>>*/ var
         _q_ = j + 1 | 0;
        if(_m_ === j) break;
        var j = _q_;
       }
      }
       /*<<bigarray.ml:326:4>>*/  /*<<bigarray.ml:326:4>>*/ var
       _n_ = i + 1 | 0;
      if(_k_ === i) break;
      var i = _n_;
     }
    }
     /*<<bigarray.ml:344:18>>*/ return arr;
    /*<<bigarray.ml:345:62>>*/ }
   function of_array$1(kind, layout, data){
     /*<<bigarray.ml:347:4>>*/ var
     dim1 = data.length - 1,
      /*<<bigarray.ml:348:4>>*/ dim2 =
       0 === dim1 ? 0 : caml_check_bound(data, 0)[1].length - 1,
      /*<<bigarray.ml:349:4>>*/ dim3 =
       0 === dim2
        ? 0
        : caml_check_bound(caml_check_bound(data, 0)[1], 0)[1].length - 1,
      /*<<bigarray.ml:350:13>>*/ ba = create$2(kind, layout, dim1, dim2, dim3),
      /*<<bigarray.ml:351:4>>*/ ofs = layout ? 1 : 0,
      /*<<bigarray.ml:356:4>>*/ _b_ = dim1 - 1 | 0,
     _a_ = 0;
    if(_b_ >= 0){
     var i = _a_;
     for(;;){
       /*<<bigarray.ml:357:16>>*/  /*<<bigarray.ml:357:16>>*/ var
       row = caml_check_bound(data, i)[1 + i];
      if(row.length - 1 !== dim2)
        /*<<bigarray.ml:359:8>>*/  /*<<bigarray.ml:359:8>>*/ caml_call1
        (Stdlib[1], cst_Bigarray_Array3_of_array_n);
       /*<<bigarray.ml:348:32>>*/ var
        /*<<bigarray.ml:348:32>>*/ _d_ = dim2 - 1 | 0,
        /*<<bigarray.ml:359:8>>*/ _c_ = 0;
      if(_d_ >= 0){
       var j = _c_;
       for(;;){
         /*<<bigarray.ml:361:18>>*/  /*<<bigarray.ml:361:18>>*/ var
         col = caml_check_bound(row, j)[1 + j];
        if(col.length - 1 !== dim3)
          /*<<bigarray.ml:363:10>>*/  /*<<bigarray.ml:363:10>>*/ caml_call1
          (Stdlib[1], cst_Bigarray_Array3_of_array_n$0);
         /*<<bigarray.ml:349:32>>*/ var
          /*<<bigarray.ml:349:32>>*/ _g_ = dim3 - 1 | 0,
          /*<<bigarray.ml:363:10>>*/ _f_ = 0;
        if(_g_ >= 0){
         var k = _f_;
         for(;;){
           /*<<bigarray.ml:365:10>>*/  /*<<bigarray.ml:365:10>>*/ caml_ba_set_3
           (ba,
            i + ofs | 0,
            j + ofs | 0,
            k + ofs | 0,
            caml_check_bound(col, k)[1 + k]);
           /*<<bigarray.ml:365:10>>*/  /*<<bigarray.ml:365:10>>*/ var
           _i_ = k + 1 | 0;
          if(_g_ === k) break;
          var k = _i_;
         }
        }
         /*<<bigarray.ml:359:8>>*/  /*<<bigarray.ml:359:8>>*/ var
         _h_ = j + 1 | 0;
        if(_d_ === j) break;
        var j = _h_;
       }
      }
       /*<<bigarray.ml:356:4>>*/  /*<<bigarray.ml:356:4>>*/ var
       _e_ = i + 1 | 0;
      if(_b_ === i) break;
      var i = _e_;
     }
    }
     /*<<bigarray.ml:369:4>>*/ return ba;
    /*<<bigarray.ml:369:6>>*/ }
   function array0_of_genarray(a){
     /*<<bigarray.ml:381:2>>*/ return 0
            ===  /*<<bigarray.ml:381:5>>*/ caml_ba_num_dims(a)
            ? a
            :  /*<<bigarray.ml:382:7>>*/ caml_call1
              (Stdlib[1], cst_Bigarray_array0_of_genarra);
    /*<<bigarray.ml:382:48>>*/ }
   function array1_of_genarray(a){
     /*<<bigarray.ml:384:2>>*/ return 1
            ===  /*<<bigarray.ml:384:5>>*/ caml_ba_num_dims(a)
            ? a
            :  /*<<bigarray.ml:385:7>>*/ caml_call1
              (Stdlib[1], cst_Bigarray_array1_of_genarra);
    /*<<bigarray.ml:385:48>>*/ }
   function array2_of_genarray(a){
     /*<<bigarray.ml:387:2>>*/ return 2
            ===  /*<<bigarray.ml:387:5>>*/ caml_ba_num_dims(a)
            ? a
            :  /*<<bigarray.ml:388:7>>*/ caml_call1
              (Stdlib[1], cst_Bigarray_array2_of_genarra);
    /*<<bigarray.ml:388:48>>*/ }
   function array3_of_genarray(a){
     /*<<bigarray.ml:390:2>>*/ return 3
            ===  /*<<bigarray.ml:390:5>>*/ caml_ba_num_dims(a)
            ? a
            :  /*<<bigarray.ml:391:7>>*/ caml_call1
              (Stdlib[1], cst_Bigarray_array3_of_genarra);
    /*<<bigarray.ml:391:48>>*/ }
   function reshape_0(a){
     /*<<bigarray.ml:396:18>>*/ return  /*<<bigarray.ml:396:18>>*/ caml_ba_reshape
            (a, [0]);
    /*<<bigarray.ml:396:32>>*/ }
   function reshape_1(a, dim1){
     /*<<bigarray.ml:397:23>>*/ return  /*<<bigarray.ml:397:23>>*/ caml_ba_reshape
            (a, [0, dim1]);
    /*<<bigarray.ml:397:41>>*/ }
   function reshape_2(a, dim1, dim2){
     /*<<bigarray.ml:398:28>>*/ return  /*<<bigarray.ml:398:28>>*/ caml_ba_reshape
            (a, [0, dim1, dim2]);
    /*<<bigarray.ml:398:51>>*/ }
   function reshape_3(a, dim1, dim2, dim3){
     /*<<bigarray.ml:399:33>>*/ return  /*<<bigarray.ml:399:33>>*/ caml_ba_reshape
            (a, [0, dim1, dim2, dim3]);
    /*<<bigarray.ml:399:61>>*/ }
   var
    Stdlib_Bigarray =
      [0,
       0,
       1,
       10,
       11,
       2,
       3,
       4,
       5,
       8,
       6,
       7,
       9,
       12,
       kind_size_in_bytes,
       0,
       1,
       [0, init, dims, size_in_bytes],
       [0,
        create,
        of_value,
        caml_ba_change_layout,
        size_in_bytes$0,
        get,
        set,
        of_value],
       [0,
        create$0,
        init$0,
        caml_ba_change_layout,
        size_in_bytes$1,
        slice,
        of_array],
       [0,
        create$1,
        init$1,
        caml_ba_change_layout,
        size_in_bytes$2,
        slice_left,
        slice_right,
        of_array$0],
       [0,
        create$2,
        init$2,
        caml_ba_change_layout,
        size_in_bytes$3,
        slice_left_1,
        slice_right_1,
        slice_left_2,
        slice_right_2,
        of_array$1],
       array0_of_genarray,
       array1_of_genarray,
       array2_of_genarray,
       array3_of_genarray,
       caml_ba_reshape,
       reshape_0,
       reshape_1,
       reshape_2,
       reshape_3];
   runtime.caml_register_global(10, Stdlib_Bigarray, "Stdlib__Bigarray");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Random
//# unitInfo: Requires: Stdlib, Stdlib__Bigarray, Stdlib__Bytes, Stdlib__Digest, Stdlib__Domain, Stdlib__Int32, Stdlib__Int64, Stdlib__Nativeint, Stdlib__String, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_ba_blit = runtime.caml_ba_blit,
    caml_ba_set_1 = runtime.caml_ba_set_1,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_greaterthan = runtime.caml_greaterthan,
    caml_int64_of_int32 = runtime.caml_int64_of_int32,
    caml_int64_shift_right_unsigne = runtime.caml_int64_shift_right_unsigned,
    caml_int64_sub = runtime.caml_int64_sub,
    caml_int64_to_int32 = runtime.caml_int64_to_int32,
    caml_lessequal = runtime.caml_lessequal,
    caml_lxm_next = runtime.caml_lxm_next,
    caml_mod = runtime.caml_mod,
    caml_notequal = runtime.caml_notequal,
    caml_sys_random_seed = runtime.caml_sys_random_seed;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    serialization_prefix = "lxm1:",
    Stdlib_Domain = global_data.Stdlib__Domain,
    Stdlib = global_data.Stdlib,
    Stdlib_Int32 = global_data.Stdlib__Int32,
    Stdlib_Int64 = global_data.Stdlib__Int64,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_Digest = global_data.Stdlib__Digest,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Bigarray = global_data.Stdlib__Bigarray,
    Stdlib_Nativeint = global_data.Stdlib__Nativeint,
    _a_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _b_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    _c_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    _d_ = runtime.caml_int64_create_lo_mi_hi(2, 0, 0),
    _e_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0);
   function create(param){
     /*<<random.ml:31:4>>*/ return  /*<<random.ml:31:4>>*/ caml_call3
            (Stdlib_Bigarray[19][1], 7, 0, 4);
    /*<<random.ml:31:34>>*/ }
   function set(s, i1, i2, i3, i4){
     /*<<random.ml:34:4>>*/  /*<<random.ml:34:4>>*/ caml_ba_set_1
     (s, 0,  /*<<random.ml:34:26>>*/ runtime.caml_int64_or(i1, _a_));
     /*<<random.ml:35:4>>*/  /*<<random.ml:35:4>>*/ caml_ba_set_1(s, 1, i2);
     /*<<random.ml:36:30>>*/  /*<<random.ml:36:30>>*/ var
     i3$0 =  /*<<random.ml:36:30>>*/ caml_notequal(i3, _b_) ? i3 : _e_;
     /*<<random.ml:36:4>>*/  /*<<random.ml:36:4>>*/ caml_ba_set_1(s, 2, i3$0);
     /*<<random.ml:37:30>>*/  /*<<random.ml:37:30>>*/ var
     i4$0 =  /*<<random.ml:37:30>>*/ caml_notequal(i4, _c_) ? i4 : _d_;
     /*<<random.ml:37:4>>*/ return  /*<<random.ml:37:4>>*/ caml_ba_set_1
            (s, 3, i4$0);
    /*<<random.ml:37:55>>*/ }
   function mk(i1, i2, i3, i4){
     /*<<random.ml:40:4>>*/  /*<<random.ml:40:12>>*/ var s = create(0);
     /*<<random.ml:41:4>>*/ set(s, i1, i2, i3, i4);
     /*<<random.ml:41:4>>*/ return s;
    /*<<random.ml:41:24>>*/ }
   var
    serialization_prefix_len = 5,
    cst_Random_State_of_binary_str =
      "Random.State.of_binary_string: expected a format compatible with OCaml ",
    cst_Random_int = "Random.int",
    cst_Random_full_int = "Random.full_int",
    cst_Random_int32 = "Random.int32";
   function to_binary_string(s){
     /*<<random.ml:61:4>>*/  /*<<random.ml:63:14>>*/ var
     buf =  /*<<random.ml:63:14>>*/ caml_create_bytes(37);
     /*<<random.ml:64:4>>*/  /*<<random.ml:64:4>>*/ caml_call5
     (Stdlib_Bytes[12],
      serialization_prefix,
      0,
      buf,
      0,
      serialization_prefix_len);
    var i = 0;
    for(;;){
      /*<<random.ml:66:47>>*/  /*<<random.ml:66:47>>*/ var
      _y_ =  /*<<random.ml:66:47>>*/ runtime.caml_ba_get_1(s, i);
      /*<<random.ml:66:6>>*/  /*<<random.ml:66:6>>*/ caml_call3
      (Stdlib_Bytes[86], buf, 5 + (i * 8 | 0) | 0, _y_);
      /*<<random.ml:66:6>>*/  /*<<random.ml:66:6>>*/ var _z_ = i + 1 | 0;
     if(3 === i)
       /*<<random.ml:68:4>>*/ return  /*<<random.ml:68:4>>*/ caml_call1
              (Stdlib_Bytes[44], buf);
     var i = _z_;
    }
    /*<<random.ml:68:30>>*/ }
   function of_binary_string(buf){
     /*<<random.ml:71:4>>*/ var
     _v_ = runtime.caml_ml_string_length(buf) !== 37 ? 1 : 0,
     _w_ =
       _v_
       ||
        1
        -
          /*<<random.ml:74:14>>*/ caml_call2
          (Stdlib_String[11], serialization_prefix, buf);
    if(_w_){
      /*<<random.ml:77:8>>*/  /*<<random.ml:77:8>>*/ var
      _x_ =
         /*<<random.ml:77:8>>*/ caml_call2
         (Stdlib[28], cst_Random_State_of_binary_str, Stdlib_Sys[46]);
      /*<<random.ml:76:6>>*/  /*<<random.ml:76:6>>*/ caml_call1
      (Stdlib[2], _x_);
    }
     /*<<random.ml:79:13>>*/ var
      /*<<random.ml:79:13>>*/ i1 =
        /*<<random.ml:79:13>>*/ caml_call2(Stdlib_String[64], buf, 5),
      /*<<random.ml:80:13>>*/ i2 =
        /*<<random.ml:80:13>>*/ caml_call2(Stdlib_String[64], buf, 13),
      /*<<random.ml:81:13>>*/ i3 =
        /*<<random.ml:81:13>>*/ caml_call2(Stdlib_String[64], buf, 21),
      /*<<random.ml:82:13>>*/ i4 =
        /*<<random.ml:82:13>>*/ caml_call2(Stdlib_String[64], buf, 29);
     /*<<random.ml:83:4>>*/ return mk(i1, i2, i3, i4);
    /*<<random.ml:83:18>>*/ }
   function copy(s){
     /*<<random.ml:89:4>>*/  /*<<random.ml:89:13>>*/ var s$0 = create(0);
     /*<<random.ml:89:25>>*/  /*<<random.ml:89:25>>*/ caml_ba_blit(s, s$0);
     /*<<random.ml:89:25>>*/ return s$0;
    /*<<random.ml:89:40>>*/ }
   function reinit(s, seed){
     /*<<random.ml:97:4>>*/ var
     n = seed.length - 1,
      /*<<random.ml:98:12>>*/ b =
        /*<<random.ml:98:12>>*/ caml_create_bytes((n * 8 | 0) + 1 | 0),
      /*<<random.ml:99:4>>*/ _p_ = n - 1 | 0,
      /*<<random.ml:98:12>>*/ _o_ = 0;
    if(_p_ >= 0){
     var i = _o_;
     for(;;){
       /*<<random.ml:100:35>>*/  /*<<random.ml:100:35>>*/ var
       _t_ =
          /*<<random.ml:100:35>>*/ caml_int64_of_int32
          (runtime.caml_check_bound(seed, i)[1 + i]);
       /*<<random.ml:100:6>>*/  /*<<random.ml:100:6>>*/ caml_call3
       (Stdlib_Bytes[86], b, i * 8 | 0, _t_);
       /*<<random.ml:100:6>>*/  /*<<random.ml:100:6>>*/ var _u_ = i + 1 | 0;
      if(_p_ === i) break;
      var i = _u_;
     }
    }
     /*<<random.ml:102:4>>*/  /*<<random.ml:102:4>>*/ caml_bytes_set
     (b, n * 8 | 0, 1);
     /*<<random.ml:103:13>>*/  /*<<random.ml:103:13>>*/ var
     d1 =  /*<<random.ml:103:13>>*/ caml_call1(Stdlib_Digest[4], b);
     /*<<random.ml:104:4>>*/  /*<<random.ml:104:4>>*/ caml_bytes_set
     (b, n * 8 | 0, 2);
     /*<<random.ml:105:13>>*/ var
      /*<<random.ml:105:13>>*/ d2 =
        /*<<random.ml:105:13>>*/ caml_call1(Stdlib_Digest[4], b),
      /*<<random.ml:109:10>>*/ _q_ =
        /*<<random.ml:109:10>>*/ caml_call2(Stdlib_String[64], d2, 8),
      /*<<random.ml:108:10>>*/ _r_ =
        /*<<random.ml:108:10>>*/ caml_call2(Stdlib_String[64], d2, 0),
      /*<<random.ml:107:10>>*/ _s_ =
        /*<<random.ml:107:10>>*/ caml_call2(Stdlib_String[64], d1, 8);
     /*<<random.ml:109:10>>*/ return set
            (s,
              /*<<random.ml:106:10>>*/ caml_call2(Stdlib_String[64], d1, 0),
             _s_,
             _r_,
             _q_);
    /*<<random.ml:109:36>>*/ }
   function make(seed){
     /*<<random.ml:112:4>>*/  /*<<random.ml:112:12>>*/ var s = create(0);
     /*<<random.ml:112:24>>*/ reinit(s, seed);
     /*<<random.ml:112:24>>*/ return s;
    /*<<random.ml:112:40>>*/ }
   function make_self_init(param){
     /*<<random.ml:115:4>>*/ return make
            ( /*<<random.ml:115:9>>*/ caml_sys_random_seed(0));
    /*<<random.ml:115:25>>*/ }
   function bits(s){
     /*<<random.ml:119:4>>*/ return  /*<<random.ml:119:17>>*/ caml_int64_to_int32
            ( /*<<random.ml:119:17>>*/ caml_lxm_next(s))
           & 1073741823;
    /*<<random.ml:119:42>>*/ }
   function intaux(s, n){
     /*<<random.ml:123:4>>*/ for(;;){
      /*<<random.ml:123:12>>*/ var
       /*<<random.ml:123:12>>*/ r = bits(s),
      v = caml_mod(r, n);
     if(((1073741823 - n | 0) + 1 | 0) >= (r - v | 0))
       /*<<random.ml:125:55>>*/ return v;
    }
    /*<<random.ml:125:56>>*/ }
   function int$0(s, bound){
     /*<<random.ml:128:4>>*/ if(1073741823 >= bound && 0 < bound)
      /*<<random.ml:130:9>>*/ return intaux(s, bound);
     /*<<random.ml:129:9>>*/ return  /*<<random.ml:129:9>>*/ caml_call1
            (Stdlib[1], cst_Random_int);
    /*<<random.ml:130:23>>*/ }
   function full_int(s, bound){
     /*<<random.ml:140:4>>*/ if(0 >= bound)
      /*<<random.ml:141:6>>*/ return  /*<<random.ml:141:6>>*/ caml_call1
             (Stdlib[1], cst_Random_full_int);
    if(1073741823 >= bound)  /*<<random.ml:145:6>>*/ return intaux(s, bound);
     /*<<random.ml:135:4>>*/ for(;;){
      /*<<random.ml:135:4>>*/ var
       /*<<random.ml:135:4>>*/ _n_ = Stdlib[19],
      r =
         /*<<random.ml:135:25>>*/ caml_int64_to_int32
         ( /*<<random.ml:135:25>>*/ caml_lxm_next(s))
        & _n_,
      v = caml_mod(r, bound);
     if(((Stdlib[19] - bound | 0) + 1 | 0) >= (r - v | 0))
       /*<<random.ml:137:54>>*/ return v;
    }
    /*<<random.ml:145:20>>*/ }
   function bits32(s){
     /*<<random.ml:149:4>>*/ return  /*<<random.ml:149:4>>*/ caml_int64_to_int32
            ( /*<<random.ml:149:19>>*/ caml_lxm_next(s));
    /*<<random.ml:149:27>>*/ }
   function int32(s, bound){
     /*<<random.ml:160:4>>*/ if
     ( /*<<random.ml:160:7>>*/ caml_lessequal(bound, 0))
      /*<<random.ml:161:9>>*/ return  /*<<random.ml:161:9>>*/ caml_call1
             (Stdlib[1], cst_Random_int32);
     /*<<random.ml:153:4>>*/ for(;;){
      /*<<random.ml:153:12>>*/ var
       /*<<random.ml:153:12>>*/ r = bits32(s) >>> 1 | 0,
       /*<<random.ml:154:12>>*/ v =
         /*<<random.ml:154:12>>*/ caml_mod(r, bound);
      /*<<random.ml:155:14>>*/ if
      (!
        /*<<random.ml:155:14>>*/ caml_greaterthan
        (r - v | 0, (Stdlib_Int32[9] - bound | 0) + 1 | 0))
       /*<<random.ml:157:9>>*/ return v;
    }
    /*<<random.ml:162:25>>*/ }
   var
    bits64 = caml_lxm_next,
    _f_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _g_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    cst_Random_int64 = "Random.int64";
   function int64(s, bound){
     /*<<random.ml:177:4>>*/ if
     ( /*<<random.ml:177:7>>*/ caml_lessequal(bound, _g_))
      /*<<random.ml:178:9>>*/ return  /*<<random.ml:178:9>>*/ caml_call1
             (Stdlib[1], cst_Random_int64);
     /*<<random.ml:170:4>>*/ for(;;){
      /*<<random.ml:170:12>>*/ var
       /*<<random.ml:170:12>>*/ r =
         /*<<random.ml:170:12>>*/ caml_int64_shift_right_unsigne
         ( /*<<random.ml:170:38>>*/ caml_lxm_next(s), 1),
       /*<<random.ml:171:12>>*/ v =
         /*<<random.ml:171:12>>*/ runtime.caml_int64_mod(r, bound);
      /*<<random.ml:172:14>>*/ if
      (!
        /*<<random.ml:172:14>>*/ caml_greaterthan
        ( /*<<random.ml:172:14>>*/ caml_int64_sub(r, v),
          /*<<random.ml:172:24>>*/ runtime.caml_int64_add
          ( /*<<random.ml:172:28>>*/ caml_int64_sub(Stdlib_Int64[9], bound),
           _f_)))
       /*<<random.ml:174:9>>*/ return v;
    }
    /*<<random.ml:179:25>>*/ }
   var
    _j_ = runtime.caml_int64_create_lo_mi_hi(14371852, 15349651, 22696),
    _k_ = runtime.caml_int64_create_lo_mi_hi(12230193, 11438743, 35013),
    _l_ = runtime.caml_int64_create_lo_mi_hi(1424933, 15549263, 2083),
    _m_ = runtime.caml_int64_create_lo_mi_hi(9492471, 4696708, 43520),
    _h_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    _i_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    nativebits =
      32 === Stdlib_Nativeint[9]
       ? function
        (s){
          /*<<random.ml:184:18>>*/ return bits32(s);
         /*<<random.ml:184:47>>*/ }
       : function
        (s){
          /*<<random.ml:185:18>>*/ return  /*<<random.ml:185:18>>*/ caml_int64_to_int32
                 ( /*<<random.ml:185:37>>*/ caml_lxm_next(s));
         /*<<random.ml:185:47>>*/ },
    nativeint =
      32 === Stdlib_Nativeint[9]
       ? function
        (s, bound){
          /*<<random.ml:190:24>>*/ return int32(s, bound);
         /*<<random.ml:190:79>>*/ }
       : function
        (s, bound){
          /*<<random.ml:191:24>>*/ return  /*<<random.ml:191:24>>*/ caml_int64_to_int32
                 (int64
                   (s,  /*<<random.ml:191:52>>*/ caml_int64_of_int32(bound)));
         /*<<random.ml:191:79>>*/ };
   function float$0(s, bound){
     /*<<random.ml:201:22>>*/ for(;;){
      /*<<random.ml:196:12>>*/ var
       /*<<random.ml:196:12>>*/ b =  /*<<random.ml:196:12>>*/ caml_lxm_next(s),
       /*<<random.ml:197:12>>*/ n =
         /*<<random.ml:197:12>>*/ caml_int64_shift_right_unsigne(b, 11);
      /*<<random.ml:198:7>>*/ if
      ( /*<<random.ml:198:7>>*/ caml_notequal(n, _h_))
       /*<<random.ml:201:22>>*/ return  /*<<random.ml:198:20>>*/ runtime.caml_int64_to_float
              (n)
             * 1.1102230246251565e-16
             * bound;
    }
    /*<<random.ml:201:41>>*/ }
   function bool(s){
     /*<<random.ml:204:15>>*/ return  /*<<random.ml:204:15>>*/ runtime.caml_lessthan
            ( /*<<random.ml:204:15>>*/ caml_lxm_next(s), _i_);
    /*<<random.ml:204:26>>*/ }
   function split(s){
     /*<<random.ml:208:4>>*/ var
      /*<<random.ml:208:13>>*/ i1 =  /*<<random.ml:208:13>>*/ caml_lxm_next(s),
      /*<<random.ml:208:34>>*/ i2 =  /*<<random.ml:208:34>>*/ caml_lxm_next(s),
      /*<<random.ml:209:13>>*/ i3 =  /*<<random.ml:209:13>>*/ caml_lxm_next(s),
      /*<<random.ml:209:34>>*/ i4 =  /*<<random.ml:209:34>>*/ caml_lxm_next(s);
     /*<<random.ml:210:4>>*/ return mk(i1, i2, i3, i4);
    /*<<random.ml:210:18>>*/ }
   function mk_default(param){
     /*<<random.ml:215:2>>*/ return mk(_m_, _l_, _k_, _j_);
    /*<<random.ml:218:31>>*/ }
    /*<<random.ml:221:2>>*/  /*<<random.ml:221:2>>*/ var
    random_key =
       /*<<random.ml:221:2>>*/ caml_call2
       (Stdlib_Domain[10][1], [0, split], mk_default);
   function bits$0(param){
     /*<<random.ml:223:14>>*/ return bits
            ( /*<<random.ml:223:25>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:223:52>>*/ }
   function int$1(bound){
     /*<<random.ml:224:16>>*/ return int$0
            ( /*<<random.ml:224:26>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             bound);
    /*<<random.ml:224:59>>*/ }
   function full_int$0(bound){
     /*<<random.ml:225:21>>*/ return full_int
            ( /*<<random.ml:225:36>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             bound);
    /*<<random.ml:225:69>>*/ }
   function int32$0(bound){
     /*<<random.ml:226:18>>*/ return int32
            ( /*<<random.ml:226:30>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             bound);
    /*<<random.ml:226:63>>*/ }
   function nativeint$0(bound){
     /*<<random.ml:227:22>>*/ return nativeint
            ( /*<<random.ml:227:38>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             bound);
    /*<<random.ml:227:71>>*/ }
   function int64$0(bound){
     /*<<random.ml:228:18>>*/ return int64
            ( /*<<random.ml:228:30>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             bound);
    /*<<random.ml:228:63>>*/ }
   function float$1(scale){
     /*<<random.ml:229:18>>*/ return float$0
            ( /*<<random.ml:229:30>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             scale);
    /*<<random.ml:229:63>>*/ }
   function bool$0(param){
     /*<<random.ml:230:14>>*/ return bool
            ( /*<<random.ml:230:25>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:230:52>>*/ }
   function bits32$0(param){
     /*<<random.ml:231:16>>*/ return bits32
            ( /*<<random.ml:231:29>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:231:56>>*/ }
   function bits64$0(param){
     /*<<random.ml:232:16>>*/ return  /*<<random.ml:232:29>>*/ caml_lxm_next
            ( /*<<random.ml:232:29>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:232:56>>*/ }
   function nativebits$0(param){
     /*<<random.ml:233:20>>*/ return nativebits
            ( /*<<random.ml:233:37>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:233:64>>*/ }
   function full_init(seed){
     /*<<random.ml:235:21>>*/ return reinit
            ( /*<<random.ml:235:34>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key),
             seed);
    /*<<random.ml:235:66>>*/ }
   function init(seed){
     /*<<random.ml:236:16>>*/ return full_init([0, seed]);
    /*<<random.ml:236:36>>*/ }
   function self_init(param){
     /*<<random.ml:237:19>>*/ return full_init
            ( /*<<random.ml:237:29>>*/ caml_sys_random_seed(0));
    /*<<random.ml:237:44>>*/ }
   function split$0(param){
     /*<<random.ml:241:15>>*/ return split
            ( /*<<random.ml:241:27>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:241:54>>*/ }
   function get_state(param){
     /*<<random.ml:245:19>>*/ return copy
            ( /*<<random.ml:245:30>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:245:57>>*/ }
   function set_state(s){
     /*<<random.ml:246:18>>*/ return  /*<<random.ml:246:18>>*/ caml_ba_blit
            (s,
              /*<<random.ml:246:31>>*/ caml_call1
              (Stdlib_Domain[10][2], random_key));
    /*<<random.ml:246:60>>*/ }
   var
    Stdlib_Random =
      [0,
       init,
       full_init,
       self_init,
       bits$0,
       int$1,
       full_int$0,
       int32$0,
       nativeint$0,
       int64$0,
       float$1,
       bool$0,
       bits32$0,
       bits64$0,
       nativebits$0,
       [0,
        make,
        make_self_init,
        copy,
        bits,
        int$0,
        full_int,
        int32,
        nativeint,
        int64,
        float$0,
        bool,
        bits32,
        bits64,
        nativebits,
        split,
        to_binary_string,
        of_binary_string],
       get_state,
       set_state,
       split$0];
   runtime.caml_register_global(32, Stdlib_Random, "Stdlib__Random");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Hashtbl
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Atomic, Stdlib__Domain, Stdlib__Int, Stdlib__Random, Stdlib__Seq, Stdlib__String, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_check_bound = runtime.caml_check_bound,
    caml_compare = runtime.caml_compare,
    caml_hash = runtime.caml_hash,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_sys_getenv = runtime.caml_sys_getenv,
    caml_wrap_exception = runtime.caml_wrap_exception;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst = "",
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib = global_data.Stdlib,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    Stdlib_Domain = global_data.Stdlib__Domain,
    Stdlib_Random = global_data.Stdlib__Random,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Array = global_data.Stdlib__Array;
   global_data.Assert_failure;
   var Stdlib_String = global_data.Stdlib__String;
   function ongoing_traversal(h){
     /*<<hashtbl.ml:41:2>>*/ var
     _an_ = h.length - 1 < 4 ? 1 : 0,
     _ao_ = _an_ || (h[4] < 0 ? 1 : 0);
    return _ao_;
    /*<<hashtbl.ml:42:23>>*/ }
   function flip_ongoing_traversal(h){
     /*<<hashtbl.ml:45:2>>*/ h[4] = - h[4] | 0;
    return 0;
    /*<<hashtbl.ml:45:36>>*/ }
   var
    cst_Hashtbl_unsupported_hash_t = "Hashtbl: unsupported hash table format",
    _d_ = [0, 0];
   try{
     /*<<hashtbl.ml:51:8>>*/ var
      /*<<hashtbl.ml:51:8>>*/ _f_ =
        /*<<hashtbl.ml:51:8>>*/ caml_sys_getenv("OCAMLRUNPARAM"),
     params = _f_;
   }
   catch(_al_){
    var _a_ = caml_wrap_exception(_al_);
    if(_a_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_a_, 0);
     /*<<hashtbl.ml:52:4>>*/ try{
      /*<<hashtbl.ml:52:8>>*/ var
       /*<<hashtbl.ml:52:8>>*/ _e_ =
         /*<<hashtbl.ml:52:8>>*/ caml_sys_getenv("CAMLRUNPARAM"),
      _c_ = _e_;
    }
    catch(_am_){
     var _b_ = caml_wrap_exception(_am_);
     if(_b_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_b_, 0);
     var _c_ = cst;
    }
    var params = _c_;
   }
    /*<<hashtbl.ml:53:2>>*/ var
     /*<<hashtbl.ml:53:2>>*/ randomized_default =
       /*<<hashtbl.ml:53:2>>*/ caml_call2(Stdlib_String[15], params, 82),
     /*<<hashtbl.ml:55:17>>*/ randomized =
       /*<<hashtbl.ml:55:17>>*/ caml_call1
       (Stdlib_Atomic[1], randomized_default);
   function randomize(param){
     /*<<hashtbl.ml:57:19>>*/ return  /*<<hashtbl.ml:57:19>>*/ caml_call2
            (Stdlib_Atomic[3], randomized, 1);
    /*<<hashtbl.ml:57:45>>*/ }
   function is_randomized(param){
     /*<<hashtbl.ml:58:23>>*/ return caml_call1(Stdlib_Atomic[2], randomized);
    /*<<hashtbl.ml:58:44>>*/ }
    /*<<hashtbl.ml:60:15>>*/  /*<<hashtbl.ml:60:15>>*/ var
    prng_key =
       /*<<hashtbl.ml:60:15>>*/ caml_call2
       (Stdlib_Domain[10][1], 0, Stdlib_Random[15][2]);
   function power_2_above(x, n){
     /*<<hashtbl.ml:69:2>>*/ var x$0 = x;
     /*<<hashtbl.ml:69:2>>*/ for(;;){
     if(n <= x$0)  /*<<hashtbl.ml:69:17>>*/ return x$0;
     if(Stdlib_Sys[13] < (x$0 * 2 | 0))  /*<<hashtbl.ml:70:44>>*/ return x$0;
     var x$1 = x$0 * 2 | 0, x$0 = x$1;
    }
    /*<<hashtbl.ml:71:30>>*/ }
   function create(opt, initial_size){
     /*<<hashtbl.ml:74:2>>*/ if(opt)
     var sth = opt[1], random = sth;
    else
     var
      random =
         /*<<hashtbl.ml:73:22>>*/ caml_call1(Stdlib_Atomic[2], randomized);
     /*<<hashtbl.ml:74:10>>*/  /*<<hashtbl.ml:74:10>>*/ var
     s = power_2_above(16, initial_size);
     /*<<hashtbl.ml:75:2>>*/ if(random)
      /*<<hashtbl.ml:76:37>>*/ var
       /*<<hashtbl.ml:76:37>>*/ _ak_ =
         /*<<hashtbl.ml:76:37>>*/ caml_call1(Stdlib_Domain[10][2], prng_key),
      seed =  /*<<hashtbl.ml:76:19>>*/ caml_call1(Stdlib_Random[15][4], _ak_);
    else
     var seed = 0;
     /*<<hashtbl.ml:78:2>>*/ return [0,
            0,
             /*<<hashtbl.ml:78:52>>*/ caml_make_vect(s, 0),
            seed,
            s];
    /*<<hashtbl.ml:78:72>>*/ }
   function clear(h){
     /*<<hashtbl.ml:81:2>>*/ var _aj_ = 0 < h[1] ? 1 : 0;
    return _aj_
            ? (h
               [1]
              = 0,
               /*<<hashtbl.ml:83:4>>*/ caml_call4
               (Stdlib_Array[7], h[2], 0, h[2].length - 1, 0))
            : _aj_;
    /*<<hashtbl.ml:84:5>>*/ }
   function reset(h){
     /*<<hashtbl.ml:87:2>>*/ var len = h[2].length - 1;
    if
     (4 <= h.length - 1
      && len !==  /*<<hashtbl.ml:89:13>>*/ caml_call1(Stdlib[18], h[4])){
     h[1] = 0;
     h[2] =
       /*<<hashtbl.ml:93:14>>*/ caml_make_vect
       ( /*<<hashtbl.ml:93:25>>*/ caml_call1(Stdlib[18], h[4]), 0);
     return 0;
    }
     /*<<hashtbl.ml:90:4>>*/ return clear(h);
    /*<<hashtbl.ml:94:5>>*/ }
   function copy_bucketlist(param){
     /*<<hashtbl.ml:96:22>>*/ if(! param)  /*<<hashtbl.ml:97:13>>*/ return 0;
     /*<<hashtbl.ml:109:19>>*/ var
     key = param[1],
     data = param[2],
     next = param[3],
      /*<<hashtbl.ml:109:19>>*/ prec$1 = [0, key, data, next],
     prec = prec$1,
     param$0 = next;
    for(;;){
     if(! param$0)  /*<<hashtbl.ml:110:6>>*/ return prec$1;
      /*<<hashtbl.ml:102:25>>*/ var
      key$0 = param$0[1],
      data$0 = param$0[2],
      next$0 = param$0[3],
       /*<<hashtbl.ml:102:25>>*/ prec$0 = [0, key$0, data$0, next$0];
     prec[3] = prec$0;
     var prec = prec$0, param$0 = next$0;
    }
    /*<<hashtbl.ml:111:7>>*/ }
   function copy(h){
     /*<<hashtbl.ml:113:13>>*/ var
     _ag_ = h[4],
     _ah_ = h[3],
      /*<<hashtbl.ml:113:29>>*/ _ai_ =
        /*<<hashtbl.ml:113:29>>*/ caml_call2
        (Stdlib_Array[13], copy_bucketlist, h[2]);
     /*<<hashtbl.ml:113:13>>*/ return [0, h[1], _ai_, _ah_, _ag_];
    /*<<hashtbl.ml:113:63>>*/ }
   function length(h){
     /*<<hashtbl.ml:115:15>>*/ return h[1];
    /*<<hashtbl.ml:115:21>>*/ }
   function insert_all_buckets(indexfun, inplace, odata, ndata){
     /*<<hashtbl.ml:118:2>>*/ var
     nsize = ndata.length - 1,
      /*<<hashtbl.ml:119:19>>*/ ndata_tail =
        /*<<hashtbl.ml:119:19>>*/ caml_make_vect(nsize, 0),
     _aa_ = odata.length - 1 - 1 | 0,
      /*<<hashtbl.ml:135:2>>*/ _$_ = 0;
    if(_aa_ >= 0){
     var i$0 = _$_;
     for(;;){
       /*<<hashtbl.ml:136:18>>*/ var
        /*<<hashtbl.ml:136:18>>*/ cell$1 =
         caml_check_bound(odata, i$0)[1 + i$0],
       cell = cell$1;
       /*<<hashtbl.ml:120:26>>*/ for(;;){
       if(! cell) break;
        /*<<hashtbl.ml:123:8>>*/ var
        key = cell[1],
        data = cell[2],
        next = cell[3],
         /*<<hashtbl.ml:123:8>>*/ cell$0 = inplace ? cell : [0, key, data, 0],
         /*<<hashtbl.ml:127:19>>*/ nidx =
           /*<<hashtbl.ml:127:19>>*/ caml_call1(indexfun, key),
         /*<<hashtbl.ml:128:20>>*/ match =
          caml_check_bound(ndata_tail, nidx)[1 + nidx];
       if(match)
        match[3] = cell$0;
       else
         /*<<hashtbl.ml:129:19>>*/ caml_check_bound(ndata, nidx)[1 + nidx] = cell$0;
        /*<<hashtbl.ml:132:8>>*/ caml_check_bound(ndata_tail, nidx)[1 + nidx]
       = cell$0;
       var cell = next;
      }
       /*<<hashtbl.ml:136:4>>*/  /*<<hashtbl.ml:136:4>>*/ var
       _af_ = i$0 + 1 | 0;
      if(_aa_ === i$0) break;
      var i$0 = _af_;
     }
    }
    if(inplace){
      /*<<hashtbl.ml:139:4>>*/ var
      _ac_ = nsize - 1 | 0,
       /*<<hashtbl.ml:139:4>>*/ _ab_ = 0;
     if(_ac_ >= 0){
      var i = _ab_;
      for(;;){
        /*<<hashtbl.ml:140:12>>*/  /*<<hashtbl.ml:140:12>>*/ var
        match$0 = caml_check_bound(ndata_tail, i)[1 + i];
       if(match$0) match$0[3] = 0;
        /*<<hashtbl.ml:139:4>>*/  /*<<hashtbl.ml:139:4>>*/ var
        _ae_ = i + 1 | 0;
       if(_ac_ === i) break;
       var i = _ae_;
      }
     }
     var _ad_ = 0;
    }
    else
     var _ad_ = inplace;
    return _ad_;
    /*<<hashtbl.ml:143:8>>*/ }
   function resize(indexfun, h){
     /*<<hashtbl.ml:146:2>>*/ var
     odata = h[2],
      /*<<hashtbl.ml:147:2>>*/ osize = odata.length - 1,
     nsize = osize * 2 | 0,
     ___ = nsize < Stdlib_Sys[13] ? 1 : 0;
    if(! ___) return ___;
     /*<<hashtbl.ml:150:16>>*/ var
      /*<<hashtbl.ml:150:16>>*/ ndata =
        /*<<hashtbl.ml:150:16>>*/ caml_make_vect(nsize, 0),
      /*<<hashtbl.ml:151:22>>*/ inplace = 1 - ongoing_traversal(h);
    h[2] = ndata;
     /*<<hashtbl.ml:153:4>>*/ return insert_all_buckets
            ( /*<<hashtbl.ml:153:23>>*/ caml_call1(indexfun, h),
             inplace,
             odata,
             ndata);
    /*<<hashtbl.ml:154:5>>*/ }
   function iter(f, h){
     /*<<hashtbl.ml:157:2>>*/  /*<<hashtbl.ml:162:17>>*/ var
     old_trav = ongoing_traversal(h);
    if(1 - old_trav)  /*<<hashtbl.ml:163:23>>*/ flip_ongoing_traversal(h);
     /*<<hashtbl.ml:163:23>>*/ try{
     var d = h[2], _W_ = d.length - 1 - 1 | 0, _V_ = 0;
     if(_W_ >= 0){
      var i = _V_;
      for(;;){
       var param = caml_check_bound(d, i)[1 + i];
        /*<<hashtbl.ml:157:22>>*/ for(;;){
        if(! param) break;
        var key = param[1], data = param[2], next = param[3];
         /*<<hashtbl.ml:161:8>>*/  /*<<hashtbl.ml:161:8>>*/ caml_call2
         (f, key, data);
        var param = next;
       }
        /*<<hashtbl.ml:167:6>>*/  /*<<hashtbl.ml:167:6>>*/ var
        _Z_ = i + 1 | 0;
       if(_W_ === i) break;
       var i = _Z_;
      }
     }
     var _X_ = 1 - old_trav, _Y_ = _X_ ? flip_ongoing_traversal(h) : _X_;
      /*<<hashtbl.ml:169:25>>*/ return _Y_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
      /*<<hashtbl.ml:170:16>>*/ if(old_trav)
      throw caml_maybe_attach_backtrace(exn, 0);
      /*<<hashtbl.ml:171:4>>*/ flip_ongoing_traversal(h);
      /*<<hashtbl.ml:172:4>>*/ throw  /*<<hashtbl.ml:172:4>>*/ caml_maybe_attach_backtrace
            (exn, 0);
    }
    /*<<hashtbl.ml:172:13>>*/ }
   function filter_map_inplace(f, h){
     /*<<hashtbl.ml:195:2>>*/ var
     d = h[2],
      /*<<hashtbl.ml:196:17>>*/ old_trav = ongoing_traversal(h);
    if(1 - old_trav)  /*<<hashtbl.ml:197:23>>*/ flip_ongoing_traversal(h);
     /*<<hashtbl.ml:197:23>>*/ try{
     var _R_ = d.length - 1 - 1 | 0, _Q_ = 0;
     if(_R_ >= 0){
      var i = _Q_;
      for(;;){
        /*<<hashtbl.ml:200:44>>*/ var
         /*<<hashtbl.ml:200:44>>*/ slot$0 = caml_check_bound(h[2], i)[1 + i],
        prec = 0,
        slot = slot$0;
       for(;;){
        if(! slot) break;
         /*<<hashtbl.ml:181:18>>*/ var
         key = slot[1],
         data = slot[2],
         next = slot[3],
          /*<<hashtbl.ml:181:18>>*/ match =
            /*<<hashtbl.ml:181:18>>*/ caml_call2(f, key, data);
        if(match){
         var data$0 = match[1];
          /*<<hashtbl.ml:186:10>>*/ if(prec)
          prec[3] = slot;
         else
           /*<<hashtbl.ml:187:21>>*/ caml_check_bound(h[2], i)[1 + i] = slot;
         slot[2] = data$0;
         var prec = slot, slot = next;
        }
        else{h[1] = h[1] - 1 | 0; var slot = next;}
       }
       if(prec)
        prec[3] = 0;
       else
         /*<<hashtbl.ml:177:17>>*/ caml_check_bound(h[2], i)[1 + i] = 0;
        /*<<hashtbl.ml:200:6>>*/  /*<<hashtbl.ml:200:6>>*/ var
        _U_ = i + 1 | 0;
       if(_R_ === i) break;
       var i = _U_;
      }
     }
     var _S_ = 1 - old_trav, _T_ = _S_ ? flip_ongoing_traversal(h) : _S_;
      /*<<hashtbl.ml:202:25>>*/ return _T_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
      /*<<hashtbl.ml:203:16>>*/ if(old_trav)
      throw caml_maybe_attach_backtrace(exn, 0);
      /*<<hashtbl.ml:204:4>>*/ flip_ongoing_traversal(h);
      /*<<hashtbl.ml:205:4>>*/ throw  /*<<hashtbl.ml:205:4>>*/ caml_maybe_attach_backtrace
            (exn, 0);
    }
    /*<<hashtbl.ml:205:13>>*/ }
   function fold(f, h, init){
     /*<<hashtbl.ml:208:2>>*/  /*<<hashtbl.ml:214:17>>*/ var
     old_trav = ongoing_traversal(h);
    if(1 - old_trav)  /*<<hashtbl.ml:215:23>>*/ flip_ongoing_traversal(h);
     /*<<hashtbl.ml:215:23>>*/ try{
      /*<<hashtbl.ml:218:15>>*/ var
      d = h[2],
       /*<<hashtbl.ml:218:15>>*/ accu$1 = [0, init],
      _N_ = d.length - 1 - 1 | 0,
       /*<<hashtbl.ml:218:15>>*/ _M_ = 0;
     if(_N_ >= 0){
      var i = _M_;
      for(;;){
        /*<<hashtbl.ml:220:24>>*/ var
        accu$2 = accu$1[1],
         /*<<hashtbl.ml:220:24>>*/ b$0 = caml_check_bound(d, i)[1 + i],
        b = b$0,
        accu = accu$2;
        /*<<hashtbl.ml:209:4>>*/ for(;;){
        if(! b) break;
         /*<<hashtbl.ml:213:23>>*/ var
         key = b[1],
         data = b[2],
         next = b[3],
          /*<<hashtbl.ml:213:23>>*/ accu$0 =
            /*<<hashtbl.ml:213:23>>*/ caml_call3(f, key, data, accu),
         b = next,
         accu = accu$0;
       }
       accu$1[1] = accu;
        /*<<hashtbl.ml:219:4>>*/  /*<<hashtbl.ml:219:4>>*/ var
        _P_ = i + 1 | 0;
       if(_N_ === i) break;
       var i = _P_;
      }
     }
     if(1 - old_trav)  /*<<hashtbl.ml:222:25>>*/ flip_ongoing_traversal(h);
     var _O_ = accu$1[1];
     return _O_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
      /*<<hashtbl.ml:224:16>>*/ if(old_trav)
      throw caml_maybe_attach_backtrace(exn, 0);
      /*<<hashtbl.ml:225:4>>*/ flip_ongoing_traversal(h);
      /*<<hashtbl.ml:226:4>>*/ throw  /*<<hashtbl.ml:226:4>>*/ caml_maybe_attach_backtrace
            (exn, 0);
    }
    /*<<hashtbl.ml:226:13>>*/ }
   function bucket_length(accu, param){
    var accu$0 = accu, param$0 = param;
    for(;;){
     if(! param$0)  /*<<hashtbl.ml:236:13>>*/ return accu$0;
      /*<<hashtbl.ml:237:18>>*/ var
      next = param$0[3],
       /*<<hashtbl.ml:237:18>>*/ accu$1 = accu$0 + 1 | 0,
      accu$0 = accu$1,
      param$0 = next;
    }
   }
   function stats(h){
     /*<<hashtbl.ml:240:2>>*/ var
      /*<<hashtbl.ml:241:4>>*/ mbl =
        /*<<hashtbl.ml:241:4>>*/ caml_call3
        (Stdlib_Array[17],
         function(m, b){
           /*<<hashtbl.ml:241:32>>*/  /*<<hashtbl.ml:241:42>>*/ var
           _L_ = bucket_length(0, b);
           /*<<hashtbl.ml:241:42>>*/ return  /*<<hashtbl.ml:241:42>>*/ caml_call2
                  (Stdlib_Int[11], m, _L_);
          /*<<hashtbl.ml:241:61>>*/ },
         0,
         h[2]),
      /*<<hashtbl.ml:242:14>>*/ histo =
        /*<<hashtbl.ml:242:14>>*/ caml_make_vect(mbl + 1 | 0, 0);
     /*<<hashtbl.ml:243:2>>*/  /*<<hashtbl.ml:243:2>>*/ caml_call2
     (Stdlib_Array[11],
      function(b){
        /*<<hashtbl.ml:245:6>>*/  /*<<hashtbl.ml:245:14>>*/ var
        l = bucket_length(0, b);
        /*<<hashtbl.ml:246:6>>*/ histo[1 + l] =
        caml_check_bound(histo, l)[1 + l] + 1 | 0;
        /*<<hashtbl.ml:246:6>>*/ return 0;
       /*<<hashtbl.ml:246:32>>*/ },
      h[2]);
     /*<<hashtbl.ml:248:2>>*/ return [0, h[1], h[2].length - 1, mbl, histo];
    /*<<hashtbl.ml:251:30>>*/ }
   function to_seq(tbl){
     /*<<hashtbl.ml:258:2>>*/ var tbl_data = tbl[2];
     /*<<hashtbl.ml:260:2>>*/ function aux(i, buck, param){
      /*<<hashtbl.ml:260:26>>*/ var i$0 = i, buck$0 = buck;
      /*<<hashtbl.ml:260:26>>*/ for(;;){
      if(buck$0){
       var key = buck$0[1], data = buck$0[2], next = buck$0[3];
        /*<<hashtbl.ml:266:8>>*/ return [0,
               [0, key, data],
               function(_K_){ /*<<?>>*/ return aux(i$0, next, _K_);}];
      }
      if(i$0 === tbl_data.length - 1)  /*<<hashtbl.ml:263:13>>*/ return 0;
       /*<<hashtbl.ml:264:22>>*/ var
        /*<<hashtbl.ml:264:22>>*/ buck$1 =
         caml_check_bound(tbl_data, i$0)[1 + i$0],
        /*<<hashtbl.ml:264:22>>*/ i$1 = i$0 + 1 | 0,
       i$0 = i$1,
       buck$0 = buck$1;
     }
     /*<<hashtbl.ml:266:42>>*/ }
    var  /*<<hashtbl.ml:268:2>>*/ _H_ = 0, _I_ = 0;
     /*<<hashtbl.ml:268:2>>*/ return function(_J_){
      /*<<?>>*/ return aux(_I_, _H_, _J_);};
    /*<<hashtbl.ml:268:13>>*/ }
   function to_seq_keys(m){
     /*<<hashtbl.ml:270:20>>*/  /*<<hashtbl.ml:270:32>>*/ var _F_ = to_seq(m);
     /*<<hashtbl.ml:270:32>>*/ return  /*<<hashtbl.ml:270:32>>*/ caml_call2
            (Stdlib_Seq[29], function(_G_){ /*<<?>>*/ return _G_[1];}, _F_);
    /*<<hashtbl.ml:270:42>>*/ }
   function to_seq_values(m){
     /*<<hashtbl.ml:272:22>>*/  /*<<hashtbl.ml:272:34>>*/ var _D_ = to_seq(m);
     /*<<hashtbl.ml:272:34>>*/ return  /*<<hashtbl.ml:272:34>>*/ caml_call2
            (Stdlib_Seq[29], function(_E_){ /*<<?>>*/ return _E_[2];}, _D_);
    /*<<hashtbl.ml:272:44>>*/ }
   function MakeSeeded(H){
    function key_index(h, key){
      /*<<hashtbl.ml:357:6>>*/ var _C_ = h[2].length - 1 - 1 | 0;
      /*<<hashtbl.ml:357:6>>*/ return  /*<<hashtbl.ml:357:6>>*/ caml_call2
             (H[2], h[3], key)
            & _C_;
     /*<<hashtbl.ml:357:63>>*/ }
    function add(h, key, data){
      /*<<hashtbl.ml:360:6>>*/ var
       /*<<hashtbl.ml:360:14>>*/ i = key_index(h, key),
       /*<<hashtbl.ml:361:23>>*/ bucket =
        [0, key, data, caml_check_bound(h[2], i)[1 + i]];
      /*<<hashtbl.ml:362:6>>*/ caml_check_bound(h[2], i)[1 + i] = bucket;
     h[1] = h[1] + 1 | 0;
     var _B_ = h[2].length - 1 << 1 < h[1] ? 1 : 0;
     return _B_ ? resize(key_index, h) : _B_;
     /*<<hashtbl.ml:364:67>>*/ }
    function remove(h, key){
      /*<<hashtbl.ml:380:6>>*/ var
       /*<<hashtbl.ml:380:14>>*/ i = key_index(h, key),
       /*<<hashtbl.ml:381:34>>*/ c = caml_check_bound(h[2], i)[1 + i],
      prec$0 = 0,
      prec = c;
     for(;;){
      if(! prec)  /*<<hashtbl.ml:368:10>>*/ return 0;
      var k = prec[1], next = prec[3];
       /*<<hashtbl.ml:370:13>>*/ if
       ( /*<<hashtbl.ml:370:13>>*/ caml_call2(H[1], k, key)){
       h[1] = h[1] - 1 | 0;
       return prec$0
               ? (prec$0[3] = next, 0)
               : (caml_check_bound(h[2], i)[1 + i] = next, 0);
      }
      var prec$0 = prec, prec = next;
     }
     /*<<hashtbl.ml:381:44>>*/ }
    function find(h, key){
      /*<<hashtbl.ml:390:6>>*/ var
       /*<<hashtbl.ml:390:20>>*/ _A_ = key_index(h, key),
       /*<<hashtbl.ml:390:12>>*/ match = caml_check_bound(h[2], _A_)[1 + _A_];
     if(! match)
       /*<<hashtbl.ml:391:17>>*/ throw  /*<<hashtbl.ml:391:17>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var k1 = match[1], d1 = match[2], next1 = match[3];
      /*<<hashtbl.ml:393:13>>*/ if
      ( /*<<hashtbl.ml:393:13>>*/ caml_call2(H[1], key, k1))
       /*<<hashtbl.ml:393:33>>*/ return d1;
     if(! next1)
       /*<<hashtbl.ml:395:21>>*/ throw  /*<<hashtbl.ml:395:21>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var k2 = next1[1], d2 = next1[2], next2 = next1[3];
      /*<<hashtbl.ml:397:17>>*/ if
      ( /*<<hashtbl.ml:397:17>>*/ caml_call2(H[1], key, k2))
       /*<<hashtbl.ml:397:37>>*/ return d2;
     if(! next2)
       /*<<hashtbl.ml:399:25>>*/ throw  /*<<hashtbl.ml:399:25>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var k3 = next2[1], d3 = next2[2], next3 = next2[3];
      /*<<hashtbl.ml:401:21>>*/ if
      ( /*<<hashtbl.ml:401:21>>*/ caml_call2(H[1], key, k3))
       /*<<hashtbl.ml:401:41>>*/ return d3;
     var param = next3;
     for(;;){
      if(! param)
        /*<<hashtbl.ml:385:10>>*/ throw  /*<<hashtbl.ml:385:10>>*/ caml_maybe_attach_backtrace
              (Stdlib[8], 1);
      var k = param[1], data = param[2], next = param[3];
       /*<<hashtbl.ml:387:13>>*/ if
       ( /*<<hashtbl.ml:387:13>>*/ caml_call2(H[1], key, k))
        /*<<hashtbl.ml:387:32>>*/ return data;
      var param = next;
     }
     /*<<hashtbl.ml:401:67>>*/ }
    function find_opt(h, key){
      /*<<hashtbl.ml:410:6>>*/ var
       /*<<hashtbl.ml:410:20>>*/ _z_ = key_index(h, key),
       /*<<hashtbl.ml:410:12>>*/ match = caml_check_bound(h[2], _z_)[1 + _z_];
     if(! match)  /*<<hashtbl.ml:411:17>>*/ return 0;
     var k1 = match[1], d1 = match[2], next1 = match[3];
      /*<<hashtbl.ml:413:13>>*/ if
      ( /*<<hashtbl.ml:413:13>>*/ caml_call2(H[1], key, k1))
       /*<<hashtbl.ml:413:33>>*/ return [0, d1];
     if(! next1)  /*<<hashtbl.ml:415:21>>*/ return 0;
     var k2 = next1[1], d2 = next1[2], next2 = next1[3];
      /*<<hashtbl.ml:417:17>>*/ if
      ( /*<<hashtbl.ml:417:17>>*/ caml_call2(H[1], key, k2))
       /*<<hashtbl.ml:417:37>>*/ return [0, d2];
     if(! next2)  /*<<hashtbl.ml:419:25>>*/ return 0;
     var k3 = next2[1], d3 = next2[2], next3 = next2[3];
      /*<<hashtbl.ml:421:21>>*/ if
      ( /*<<hashtbl.ml:421:21>>*/ caml_call2(H[1], key, k3))
       /*<<hashtbl.ml:421:41>>*/ return [0, d3];
     var param = next3;
     for(;;){
      if(! param)  /*<<hashtbl.ml:405:10>>*/ return 0;
      var k = param[1], data = param[2], next = param[3];
       /*<<hashtbl.ml:407:13>>*/ if
       ( /*<<hashtbl.ml:407:13>>*/ caml_call2(H[1], key, k))
        /*<<hashtbl.ml:407:32>>*/ return [0, data];
      var param = next;
     }
     /*<<hashtbl.ml:421:76>>*/ }
    function find_all(h, key){
      /*<<hashtbl.ml:424:6>>*/ var
       /*<<hashtbl.ml:431:29>>*/ _y_ = key_index(h, key),
      param = caml_check_bound(h[2], _y_)[1 + _y_];
      /*<<hashtbl.ml:424:47>>*/ for(;;){
      if(! param)  /*<<hashtbl.ml:426:10>>*/ return 0;
      var k = param[1], d = param[2], next = param[3];
       /*<<hashtbl.ml:428:13>>*/ if
       ( /*<<hashtbl.ml:428:13>>*/ caml_call2(H[1], k, key))
       break;
      var param = next;
     }
      /*<<hashtbl.ml:429:15>>*/ var
       /*<<hashtbl.ml:429:15>>*/ block = [0, d, 24029],
      dst = block,
      offset = 1,
      param$0 = next;
      /*<<hashtbl.ml:424:47>>*/ for(;;){
      if(! param$0){
       dst[1 + offset] = 0;
        /*<<hashtbl.ml:429:20>>*/ return block;
      }
      var k$0 = param$0[1], d$0 = param$0[2], next$0 = param$0[3];
       /*<<hashtbl.ml:428:13>>*/ if
       ( /*<<hashtbl.ml:428:13>>*/ caml_call2(H[1], k$0, key)){
        /*<<hashtbl.ml:429:15>>*/  /*<<hashtbl.ml:429:15>>*/ var
        dst$0 = [0, d$0, 24029];
       dst[1 + offset] = dst$0;
       var dst = dst$0, offset = 1, param$0 = next$0;
      }
      else
       var param$0 = next$0;
     }
     /*<<hashtbl.ml:431:45>>*/ }
    function replace(h, key, data){
      /*<<hashtbl.ml:442:6>>*/ var
       /*<<hashtbl.ml:442:14>>*/ i = key_index(h, key),
       /*<<hashtbl.ml:443:14>>*/ l = caml_check_bound(h[2], i)[1 + i],
      slot = l;
     for(;;){
      if(slot){
       var k = slot[1], next = slot[3];
        /*<<hashtbl.ml:437:13>>*/ if
        (!  /*<<hashtbl.ml:437:13>>*/ caml_call2(H[1], k, key)){var slot = next; continue;}
       slot[1] = key;
       slot[2] = data;
       var _v_ = 0;
      }
      else
       var _v_ = 1;
       /*<<hashtbl.ml:444:9>>*/ if(_v_){
        /*<<hashtbl.ml:445:8>>*/ caml_check_bound(h[2], i)[1 + i] = [0, key, data, l];
       h[1] = h[1] + 1 | 0;
       var _w_ = h[2].length - 1 << 1 < h[1] ? 1 : 0;
       if(_w_)  /*<<hashtbl.ml:447:51>>*/ return resize(key_index, h);
       var _x_ = _w_;
      }
      else
       var _x_ = _v_;
      return _x_;
     }
     /*<<hashtbl.ml:448:9>>*/ }
    function mem(h, key){
      /*<<hashtbl.ml:457:6>>*/ var
       /*<<hashtbl.ml:457:32>>*/ _u_ = key_index(h, key),
      param = caml_check_bound(h[2], _u_)[1 + _u_];
     for(;;){
      if(! param)  /*<<hashtbl.ml:452:10>>*/ return 0;
       /*<<hashtbl.ml:454:10>>*/ var
       k = param[1],
       next = param[3],
        /*<<hashtbl.ml:454:10>>*/ _t_ =
          /*<<hashtbl.ml:454:10>>*/ caml_call2(H[1], k, key);
       /*<<hashtbl.ml:454:10>>*/ if(_t_)
        /*<<hashtbl.ml:454:10>>*/ return _t_;
      var param = next;
     }
     /*<<hashtbl.ml:457:48>>*/ }
    function add_seq(tbl, i){
      /*<<hashtbl.ml:460:6>>*/ return  /*<<hashtbl.ml:460:6>>*/ caml_call2
             (Stdlib_Seq[4],
              function(param){
                /*<<hashtbl.ml:460:15>>*/ var v = param[2], k = param[1];
                /*<<hashtbl.ml:460:29>>*/ return add(tbl, k, v);
               /*<<hashtbl.ml:460:41>>*/ },
              i);
     /*<<hashtbl.ml:460:43>>*/ }
    function replace_seq(tbl, i){
      /*<<hashtbl.ml:463:6>>*/ return  /*<<hashtbl.ml:463:6>>*/ caml_call2
             (Stdlib_Seq[4],
              function(param){
                /*<<hashtbl.ml:463:15>>*/ var v = param[2], k = param[1];
                /*<<hashtbl.ml:463:29>>*/ return replace(tbl, k, v);
               /*<<hashtbl.ml:463:45>>*/ },
              i);
     /*<<hashtbl.ml:463:47>>*/ }
    function of_seq(i){
      /*<<hashtbl.ml:466:6>>*/  /*<<hashtbl.ml:466:16>>*/ var
      tbl = create(0, 16);
      /*<<hashtbl.ml:467:6>>*/ replace_seq(tbl, i);
      /*<<hashtbl.ml:467:6>>*/ return tbl;
     /*<<hashtbl.ml:468:9>>*/ }
     /*<<hashtbl.ml:347:2>>*/ return [0,
            create,
            clear,
            reset,
            copy,
            add,
            remove,
            find,
            find_opt,
            find_all,
            replace,
            mem,
            iter,
            filter_map_inplace,
            fold,
            length,
            stats,
            to_seq,
            to_seq_keys,
            to_seq_values,
            add_seq,
            replace_seq,
            of_seq];
   }
   function Make(H){
    var equal = H[1];
    function seeded_hash(seed, x){
      /*<<hashtbl.ml:485:41>>*/ return  /*<<hashtbl.ml:485:41>>*/ caml_call1
             (H[2], x);
     /*<<hashtbl.ml:485:49>>*/ }
    var
     include = MakeSeeded([0, equal, seeded_hash]),
     clear = include[2],
     reset = include[3],
     copy = include[4],
     add = include[5],
     remove = include[6],
     find = include[7],
     find_opt = include[8],
     find_all = include[9],
     replace = include[10],
     mem = include[11],
     iter = include[12],
     filter_map_inplace = include[13],
     fold = include[14],
     length = include[15],
     stats = include[16],
     to_seq = include[17],
     to_seq_keys = include[18],
     to_seq_values = include[19],
     add_seq = include[20],
     replace_seq = include[21],
     _s_ = include[1];
    function create(sz){
      /*<<hashtbl.ml:487:20>>*/ return  /*<<hashtbl.ml:487:20>>*/ caml_call2
             (_s_, _d_, sz);
     /*<<hashtbl.ml:487:43>>*/ }
    function of_seq(i){
      /*<<hashtbl.ml:489:6>>*/  /*<<hashtbl.ml:489:16>>*/ var
      tbl = create(16);
      /*<<hashtbl.ml:490:6>>*/  /*<<hashtbl.ml:490:6>>*/ caml_call2
      (replace_seq, tbl, i);
      /*<<hashtbl.ml:490:6>>*/ return tbl;
     /*<<hashtbl.ml:491:9>>*/ }
     /*<<hashtbl.ml:481:2>>*/ return [0,
            create,
            clear,
            reset,
            copy,
            add,
            remove,
            find,
            find_opt,
            find_all,
            replace,
            mem,
            iter,
            filter_map_inplace,
            fold,
            length,
            stats,
            to_seq,
            to_seq_keys,
            to_seq_values,
            add_seq,
            replace_seq,
            of_seq];
   }
   function hash(x){
     /*<<hashtbl.ml:501:13>>*/ return  /*<<hashtbl.ml:501:13>>*/ caml_hash
            (10, 100, 0, x);
    /*<<hashtbl.ml:501:41>>*/ }
   function hash_param(n1, n2, x){
     /*<<hashtbl.ml:502:25>>*/ return  /*<<hashtbl.ml:502:25>>*/ caml_hash
            (n1, n2, 0, x);
    /*<<hashtbl.ml:502:52>>*/ }
   function seeded_hash(seed, x){
     /*<<hashtbl.ml:503:25>>*/ return  /*<<hashtbl.ml:503:25>>*/ caml_hash
            (10, 100, seed, x);
    /*<<hashtbl.ml:503:56>>*/ }
   function key_index(h, key){
     /*<<hashtbl.ml:506:2>>*/ return 4 <= h.length - 1
            ?  /*<<hashtbl.ml:507:7>>*/ caml_hash
              (10, 100, h[3], key)
             & (h[2].length - 1 - 1 | 0)
            :  /*<<hashtbl.ml:508:7>>*/ caml_call1
              (Stdlib[1], cst_Hashtbl_unsupported_hash_t);
    /*<<hashtbl.ml:508:59>>*/ }
   function add(h, key, data){
     /*<<hashtbl.ml:511:2>>*/ var
      /*<<hashtbl.ml:511:10>>*/ i = key_index(h, key),
      /*<<hashtbl.ml:512:19>>*/ bucket =
       [0, key, data, caml_check_bound(h[2], i)[1 + i]];
     /*<<hashtbl.ml:513:2>>*/ caml_check_bound(h[2], i)[1 + i] = bucket;
    h[1] = h[1] + 1 | 0;
    var _r_ = h[2].length - 1 << 1 < h[1] ? 1 : 0;
    return _r_ ? resize(key_index, h) : _r_;
    /*<<hashtbl.ml:515:63>>*/ }
   function remove(h, key){
     /*<<hashtbl.ml:531:2>>*/ var
      /*<<hashtbl.ml:531:10>>*/ i = key_index(h, key),
      /*<<hashtbl.ml:532:30>>*/ c = caml_check_bound(h[2], i)[1 + i],
     prec$0 = 0,
     prec = c;
    for(;;){
     if(! prec)  /*<<hashtbl.ml:519:6>>*/ return 0;
     var k = prec[1], next = prec[3];
      /*<<hashtbl.ml:521:9>>*/ if
      (0 ===  /*<<hashtbl.ml:521:9>>*/ caml_compare(k, key)){
      h[1] = h[1] - 1 | 0;
      return prec$0
              ? (prec$0[3] = next, 0)
              : (caml_check_bound(h[2], i)[1 + i] = next, 0);
     }
     var prec$0 = prec, prec = next;
    }
    /*<<hashtbl.ml:532:40>>*/ }
   function find(h, key){
     /*<<hashtbl.ml:541:2>>*/ var
      /*<<hashtbl.ml:541:16>>*/ _q_ = key_index(h, key),
      /*<<hashtbl.ml:541:8>>*/ match = caml_check_bound(h[2], _q_)[1 + _q_];
    if(! match)
      /*<<hashtbl.ml:542:13>>*/ throw  /*<<hashtbl.ml:542:13>>*/ caml_maybe_attach_backtrace
            (Stdlib[8], 1);
    var k1 = match[1], d1 = match[2], next1 = match[3];
     /*<<hashtbl.ml:544:9>>*/ if
     (0 ===  /*<<hashtbl.ml:544:9>>*/ caml_compare(key, k1))
      /*<<hashtbl.ml:544:33>>*/ return d1;
    if(! next1)
      /*<<hashtbl.ml:546:17>>*/ throw  /*<<hashtbl.ml:546:17>>*/ caml_maybe_attach_backtrace
            (Stdlib[8], 1);
    var k2 = next1[1], d2 = next1[2], next2 = next1[3];
     /*<<hashtbl.ml:548:13>>*/ if
     (0 ===  /*<<hashtbl.ml:548:13>>*/ caml_compare(key, k2))
      /*<<hashtbl.ml:548:37>>*/ return d2;
    if(! next2)
      /*<<hashtbl.ml:550:21>>*/ throw  /*<<hashtbl.ml:550:21>>*/ caml_maybe_attach_backtrace
            (Stdlib[8], 1);
    var k3 = next2[1], d3 = next2[2], next3 = next2[3];
     /*<<hashtbl.ml:552:17>>*/ if
     (0 ===  /*<<hashtbl.ml:552:17>>*/ caml_compare(key, k3))
      /*<<hashtbl.ml:552:41>>*/ return d3;
    var param = next3;
    for(;;){
     if(! param)
       /*<<hashtbl.ml:536:6>>*/ throw  /*<<hashtbl.ml:536:6>>*/ caml_maybe_attach_backtrace
             (Stdlib[8], 1);
     var k = param[1], data = param[2], next = param[3];
      /*<<hashtbl.ml:538:9>>*/ if
      (0 ===  /*<<hashtbl.ml:538:9>>*/ caml_compare(key, k))
       /*<<hashtbl.ml:538:32>>*/ return data;
     var param = next;
    }
    /*<<hashtbl.ml:552:67>>*/ }
   function find_opt(h, key){
     /*<<hashtbl.ml:561:2>>*/ var
      /*<<hashtbl.ml:561:16>>*/ _p_ = key_index(h, key),
      /*<<hashtbl.ml:561:8>>*/ match = caml_check_bound(h[2], _p_)[1 + _p_];
    if(! match)  /*<<hashtbl.ml:562:13>>*/ return 0;
    var k1 = match[1], d1 = match[2], next1 = match[3];
     /*<<hashtbl.ml:564:9>>*/ if
     (0 ===  /*<<hashtbl.ml:564:9>>*/ caml_compare(key, k1))
      /*<<hashtbl.ml:564:33>>*/ return [0, d1];
    if(! next1)  /*<<hashtbl.ml:566:17>>*/ return 0;
    var k2 = next1[1], d2 = next1[2], next2 = next1[3];
     /*<<hashtbl.ml:568:13>>*/ if
     (0 ===  /*<<hashtbl.ml:568:13>>*/ caml_compare(key, k2))
      /*<<hashtbl.ml:568:37>>*/ return [0, d2];
    if(! next2)  /*<<hashtbl.ml:570:21>>*/ return 0;
    var k3 = next2[1], d3 = next2[2], next3 = next2[3];
     /*<<hashtbl.ml:572:17>>*/ if
     (0 ===  /*<<hashtbl.ml:572:17>>*/ caml_compare(key, k3))
      /*<<hashtbl.ml:572:41>>*/ return [0, d3];
    var param = next3;
    for(;;){
     if(! param)  /*<<hashtbl.ml:556:6>>*/ return 0;
     var k = param[1], data = param[2], next = param[3];
      /*<<hashtbl.ml:558:9>>*/ if
      (0 ===  /*<<hashtbl.ml:558:9>>*/ caml_compare(key, k))
       /*<<hashtbl.ml:558:32>>*/ return [0, data];
     var param = next;
    }
    /*<<hashtbl.ml:572:76>>*/ }
   function find_all(h, key){
     /*<<hashtbl.ml:575:2>>*/ var
      /*<<hashtbl.ml:582:25>>*/ _o_ = key_index(h, key),
     param = caml_check_bound(h[2], _o_)[1 + _o_];
     /*<<hashtbl.ml:575:43>>*/ for(;;){
     if(! param)  /*<<hashtbl.ml:577:6>>*/ return 0;
     var k = param[1], data = param[2], next = param[3];
      /*<<hashtbl.ml:579:9>>*/ if
      (0 ===  /*<<hashtbl.ml:579:9>>*/ caml_compare(k, key))
      break;
     var param = next;
    }
     /*<<hashtbl.ml:580:11>>*/ var
      /*<<hashtbl.ml:580:11>>*/ block = [0, data, 24029],
     dst = block,
     offset = 1,
     param$0 = next;
     /*<<hashtbl.ml:575:43>>*/ for(;;){
     if(! param$0){
      dst[1 + offset] = 0;
       /*<<hashtbl.ml:580:19>>*/ return block;
     }
     var k$0 = param$0[1], data$0 = param$0[2], next$0 = param$0[3];
      /*<<hashtbl.ml:579:9>>*/ if
      (0 ===  /*<<hashtbl.ml:579:9>>*/ caml_compare(k$0, key)){
       /*<<hashtbl.ml:580:11>>*/  /*<<hashtbl.ml:580:11>>*/ var
       dst$0 = [0, data$0, 24029];
      dst[1 + offset] = dst$0;
      var dst = dst$0, offset = 1, param$0 = next$0;
     }
     else
      var param$0 = next$0;
    }
    /*<<hashtbl.ml:582:41>>*/ }
   function replace(h, key, data){
     /*<<hashtbl.ml:593:2>>*/ var
      /*<<hashtbl.ml:593:10>>*/ i = key_index(h, key),
      /*<<hashtbl.ml:594:10>>*/ l = caml_check_bound(h[2], i)[1 + i],
     slot = l;
    for(;;){
     if(slot){
      var k = slot[1], next = slot[3];
       /*<<hashtbl.ml:588:9>>*/ if
       (0 !==  /*<<hashtbl.ml:588:9>>*/ caml_compare(k, key)){var slot = next; continue;}
      slot[1] = key;
      slot[2] = data;
      var _l_ = 0;
     }
     else
      var _l_ = 1;
      /*<<hashtbl.ml:595:5>>*/ if(_l_){
       /*<<hashtbl.ml:596:4>>*/ caml_check_bound(h[2], i)[1 + i] = [0, key, data, l];
      h[1] = h[1] + 1 | 0;
      var _m_ = h[2].length - 1 << 1 < h[1] ? 1 : 0;
      if(_m_)  /*<<hashtbl.ml:598:47>>*/ return resize(key_index, h);
      var _n_ = _m_;
     }
     else
      var _n_ = _l_;
     return _n_;
    }
    /*<<hashtbl.ml:599:5>>*/ }
   function mem(h, key){
     /*<<hashtbl.ml:608:2>>*/ var
      /*<<hashtbl.ml:608:28>>*/ _k_ = key_index(h, key),
     param = caml_check_bound(h[2], _k_)[1 + _k_];
    for(;;){
     if(! param)  /*<<hashtbl.ml:603:6>>*/ return 0;
     var
      k = param[1],
      next = param[3],
      _j_ = 0 ===  /*<<hashtbl.ml:605:6>>*/ caml_compare(k, key) ? 1 : 0;
     if(_j_) return _j_;
     var param = next;
    }
    /*<<hashtbl.ml:608:44>>*/ }
   function add_seq(tbl, i){
     /*<<hashtbl.ml:611:2>>*/ return  /*<<hashtbl.ml:611:2>>*/ caml_call2
            (Stdlib_Seq[4],
             function(param){
               /*<<hashtbl.ml:611:11>>*/ var v = param[2], k = param[1];
               /*<<hashtbl.ml:611:25>>*/ return add(tbl, k, v);
              /*<<hashtbl.ml:611:37>>*/ },
             i);
    /*<<hashtbl.ml:611:39>>*/ }
   function replace_seq(tbl, i){
     /*<<hashtbl.ml:614:2>>*/ return  /*<<hashtbl.ml:614:2>>*/ caml_call2
            (Stdlib_Seq[4],
             function(param){
               /*<<hashtbl.ml:614:11>>*/ var v = param[2], k = param[1];
               /*<<hashtbl.ml:614:25>>*/ return replace(tbl, k, v);
              /*<<hashtbl.ml:614:41>>*/ },
             i);
    /*<<hashtbl.ml:614:43>>*/ }
   function of_seq(i){
     /*<<hashtbl.ml:617:2>>*/  /*<<hashtbl.ml:617:12>>*/ var
     tbl = create(0, 16);
     /*<<hashtbl.ml:618:2>>*/ replace_seq(tbl, i);
     /*<<hashtbl.ml:618:2>>*/ return tbl;
    /*<<hashtbl.ml:619:5>>*/ }
   function rebuild(opt, h){
     /*<<hashtbl.ml:622:2>>*/ if(opt)
     var sth = opt[1], random = sth;
    else
     var
      random =
         /*<<hashtbl.ml:621:23>>*/ caml_call1(Stdlib_Atomic[2], randomized);
     /*<<hashtbl.ml:622:10>>*/  /*<<hashtbl.ml:622:10>>*/ var
     s = power_2_above(16, h[2].length - 1);
     /*<<hashtbl.ml:623:2>>*/ if(random)
      /*<<hashtbl.ml:624:37>>*/ var
       /*<<hashtbl.ml:624:37>>*/ _g_ =
         /*<<hashtbl.ml:624:37>>*/ caml_call1(Stdlib_Domain[10][2], prng_key),
      seed =  /*<<hashtbl.ml:624:19>>*/ caml_call1(Stdlib_Random[15][4], _g_);
    else
     var seed = 4 <= h.length - 1 ? h[3] : 0;
     /*<<hashtbl.ml:627:11>>*/ var
     _h_ = 4 <= h.length - 1 ? h[4] : s,
      /*<<hashtbl.ml:627:11>>*/ h$0 =
       [0, h[1],  /*<<hashtbl.ml:629:11>>*/ caml_make_vect(s, 0), seed, _h_];
     /*<<hashtbl.ml:633:2>>*/ insert_all_buckets
     (function(_i_){ /*<<?>>*/ return key_index(h$0, _i_);}, 0, h[2], h$0[2]);
     /*<<hashtbl.ml:633:2>>*/ return h$0;
    /*<<hashtbl.ml:634:4>>*/ }
   var
    Stdlib_Hashtbl =
      [0,
       create,
       clear,
       reset,
       copy,
       add,
       find,
       find_opt,
       find_all,
       mem,
       remove,
       replace,
       iter,
       filter_map_inplace,
       fold,
       length,
       randomize,
       is_randomized,
       rebuild,
       stats,
       to_seq,
       to_seq_keys,
       to_seq_values,
       add_seq,
       replace_seq,
       of_seq,
       Make,
       MakeSeeded,
       hash,
       seeded_hash,
       hash_param,
       caml_hash];
   runtime.caml_register_global(16, Stdlib_Hashtbl, "Stdlib__Hashtbl");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Weak
//# unitInfo: Requires: Stdlib, Stdlib__Array, Stdlib__Int, Stdlib__Obj, Stdlib__Sys
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_check_bound = runtime.caml_check_bound,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_mod = runtime.caml_mod;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
    /*<<?>>*/ function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Obj = global_data.Stdlib__Obj,
    cst_Weak_create = "Weak.create",
    cst_Weak_set = "Weak.set",
    cst_Weak_get = "Weak.get",
    cst_Weak_get_copy = "Weak.get_copy",
    cst_Weak_check = "Weak.check",
    cst_Weak_blit = "Weak.blit",
    cst_Weak_fill = "Weak.fill",
    cst_Weak_Make_hash_bucket_cann = "Weak.Make: hash bucket cannot grow more";
   function create(l){
     /*<<weak.ml:28:2>>*/ var
     _J_ = 0 <= l ? 1 : 0,
     _K_ = _J_ ? l <= Stdlib_Obj[24][15] ? 1 : 0 : _J_;
    if(1 - _K_)
      /*<<weak.ml:29:4>>*/  /*<<weak.ml:29:4>>*/ caml_call1
      (Stdlib[1], cst_Weak_create);
     /*<<weak.ml:30:2>>*/ return  /*<<weak.ml:30:2>>*/ runtime.caml_weak_create
            (l);
    /*<<weak.ml:30:10>>*/ }
   function length(x){
     /*<<weak.ml:33:15>>*/ return x.length - 1 - 2 | 0;
    /*<<weak.ml:33:55>>*/ }
   function raise_if_invalid_offset(e, o, msg){
     /*<<weak.ml:36:2>>*/ var
     _G_ = 0 <= o ? 1 : 0,
     _H_ = _G_ ? o < length(e) ? 1 : 0 : _G_,
     _I_ = 1 - _H_;
    return _I_ ?  /*<<weak.ml:37:4>>*/ caml_call1(Stdlib[1], msg) : _I_;
    /*<<weak.ml:37:20>>*/ }
   function set(e, o, x){
     /*<<weak.ml:42:2>>*/ raise_if_invalid_offset(e, o, cst_Weak_set);
    if(! x)
      /*<<weak.ml:44:12>>*/ return  /*<<weak.ml:44:12>>*/ runtime.caml_ephe_unset_key
             (e, o);
    var x$0 = x[1];
     /*<<weak.ml:45:14>>*/ return  /*<<weak.ml:45:14>>*/ runtime.caml_ephe_set_key
            (e, o, x$0);
    /*<<weak.ml:45:24>>*/ }
   function get(e, o){
     /*<<weak.ml:49:2>>*/ raise_if_invalid_offset(e, o, cst_Weak_get);
     /*<<weak.ml:50:2>>*/ return  /*<<weak.ml:50:2>>*/ runtime.caml_ephe_get_key
            (e, o);
    /*<<weak.ml:50:9>>*/ }
   function get_copy(e, o){
     /*<<weak.ml:54:2>>*/ raise_if_invalid_offset(e, o, cst_Weak_get_copy);
     /*<<weak.ml:55:2>>*/ return  /*<<weak.ml:55:2>>*/ runtime.caml_ephe_get_key_copy
            (e, o);
    /*<<weak.ml:55:14>>*/ }
   function check(e, o){
     /*<<weak.ml:59:2>>*/ raise_if_invalid_offset(e, o, cst_Weak_check);
     /*<<weak.ml:60:2>>*/ return  /*<<weak.ml:60:2>>*/ runtime.caml_ephe_check_key
            (e, o);
    /*<<weak.ml:60:11>>*/ }
   function blit(e1, o1, e2, o2, l){
     /*<<weak.ml:66:2>>*/ if
     (0 <= l
      &&
       0 <= o1
       && (length(e1) - l | 0) >= o1 && 0 <= o2 && (length(e2) - l | 0) >= o2){
     var
      _E_ = 0 !== l ? 1 : 0,
      _F_ =
        _E_
         ?  /*<<weak.ml:69:22>>*/ runtime.caml_ephe_blit_key
           (e1, o1, e2, o2, l)
         : _E_;
      /*<<weak.ml:69:22>>*/ return _F_;
    }
     /*<<weak.ml:68:7>>*/ return  /*<<weak.ml:68:7>>*/ caml_call1
            (Stdlib[1], cst_Weak_blit);
    /*<<weak.ml:69:40>>*/ }
   function fill(ar, ofs, len, x){
     /*<<weak.ml:72:2>>*/ if
     (0 <= ofs && 0 <= len && (length(ar) - len | 0) >= ofs){
     var _C_ = (ofs + len | 0) - 1 | 0;
     if(_C_ >= ofs){
      var i = ofs;
      for(;;){
        /*<<weak.ml:76:6>>*/ set(ar, i, x);
        /*<<weak.ml:76:6>>*/  /*<<weak.ml:76:6>>*/ var _D_ = i + 1 | 0;
       if(_C_ === i) break;
       var i = _D_;
      }
     }
     return 0;
    }
     /*<<weak.ml:73:7>>*/ throw  /*<<weak.ml:73:7>>*/ caml_maybe_attach_backtrace
           ([0, Stdlib[6], cst_Weak_fill], 1);
    /*<<weak.ml:78:5>>*/ }
   function Make(H){
     /*<<weak.ml:105:20>>*/  /*<<weak.ml:105:20>>*/ var
     emptybucket = create(0);
    function get_index(t, h){
      /*<<weak.ml:117:22>>*/ return caml_mod(h & Stdlib[19], t[1].length - 1);
     /*<<weak.ml:117:65>>*/ }
    var limit = 7;
    function create$0(sz){
      /*<<weak.ml:123:4>>*/ var
      sz$0 = 7 <= sz ? sz : 7,
      sz$1 = Stdlib_Sys[13] < sz$0 ? Stdlib_Sys[13] : sz$0;
      /*<<weak.ml:125:4>>*/ return [0,
              /*<<weak.ml:126:14>>*/ caml_make_vect(sz$1, emptybucket),
              /*<<weak.ml:127:15>>*/ caml_make_vect(sz$1, [0]),
             limit,
             0,
             0];
     /*<<weak.ml:131:5>>*/ }
    function clear(t){
      /*<<weak.ml:134:4>>*/ var
      _A_ = t[1].length - 1 - 1 | 0,
       /*<<weak.ml:134:4>>*/ _z_ = 0;
     if(_A_ >= 0){
      var i = _z_;
      for(;;){
        /*<<weak.ml:135:6>>*/ caml_check_bound(t[1], i)[1 + i] = emptybucket;
        /*<<weak.ml:136:6>>*/ caml_check_bound(t[2], i)[1 + i] = [0];
        /*<<weak.ml:136:6>>*/  /*<<weak.ml:136:6>>*/ var _B_ = i + 1 | 0;
       if(_A_ === i) break;
       var i = _B_;
      }
     }
     t[3] = limit;
     t[4] = 0;
     return 0;
     /*<<weak.ml:139:19>>*/ }
    function fold(f, t, init){
      /*<<weak.ml:143:4>>*/ var i = 0;
      /*<<weak.ml:149:4>>*/ return  /*<<weak.ml:149:4>>*/ caml_call3
             (Stdlib_Array[19],
              function(b, accu$1){
               var i$0 = i, accu = accu$1;
                /*<<weak.ml:144:6>>*/ for(;;){
                if(length(b) <= i$0)  /*<<weak.ml:144:28>>*/ return accu;
                 /*<<weak.ml:145:12>>*/  /*<<weak.ml:145:12>>*/ var
                 match = get(b, i$0);
                if(match)
                  /*<<weak.ml:146:38>>*/ var
                  v = match[1],
                   /*<<weak.ml:146:38>>*/ accu$0 =
                     /*<<weak.ml:146:38>>*/ caml_call2(f, v, accu),
                  i$1 = i$0 + 1 | 0,
                  i$0 = i$1,
                  accu = accu$0;
                else
                 var i$2 = i$0 + 1 | 0, i$0 = i$2;
               }
              },
              t[1],
              init);
     /*<<weak.ml:149:49>>*/ }
    function iter(f, t){
      /*<<weak.ml:153:4>>*/ var i = 0;
      /*<<weak.ml:159:15>>*/ return  /*<<weak.ml:159:15>>*/ caml_call2
             (Stdlib_Array[11],
              function(b){
               var i$0 = i;
                /*<<weak.ml:154:6>>*/ for(;;){
                if(length(b) <= i$0)  /*<<weak.ml:154:28>>*/ return 0;
                 /*<<weak.ml:155:12>>*/  /*<<weak.ml:155:12>>*/ var
                 match = get(b, i$0);
                if(match){
                 var v = match[1];
                  /*<<weak.ml:156:18>>*/  /*<<weak.ml:156:18>>*/ caml_call1
                  (f, v);
                 var i$1 = i$0 + 1 | 0, i$0 = i$1;
                }
                else
                 var i$2 = i$0 + 1 | 0, i$0 = i$2;
               }
              },
              t[1]);
     /*<<weak.ml:159:38>>*/ }
    function count_bucket(i, b, accu){
      /*<<weak.ml:173:4>>*/ var i$0 = i, accu$0 = accu;
      /*<<weak.ml:173:4>>*/ for(;;){
      if(length(b) <= i$0)  /*<<weak.ml:173:26>>*/ return accu$0;
       /*<<weak.ml:174:37>>*/ var
        /*<<weak.ml:174:37>>*/ _y_ = check(b, i$0) ? 1 : 0,
       accu$1 = accu$0 + _y_ | 0,
       i$1 = i$0 + 1 | 0,
       i$0 = i$1,
       accu$0 = accu$1;
     }
     /*<<weak.ml:174:62>>*/ }
    function count(t){
      /*<<weak.ml:178:4>>*/ var _v_ = 0;
      /*<<weak.ml:178:4>>*/ return  /*<<weak.ml:178:4>>*/ caml_call3
             (Stdlib_Array[19],
              function(_w_, _x_){
                /*<<?>>*/ return count_bucket(_v_, _w_, _x_);
              },
              t[1],
              0);
     /*<<weak.ml:178:47>>*/ }
    function add_aux(t, setter, d, h, index){
      /*<<weak.ml:238:4>>*/ var
       /*<<weak.ml:238:17>>*/ bucket$0 =
        caml_check_bound(t[1], index)[1 + index],
       /*<<weak.ml:239:17>>*/ hashes =
        caml_check_bound(t[2], index)[1 + index],
       /*<<weak.ml:240:13>>*/ sz = length(bucket$0),
      i$3 = 0;
      /*<<weak.ml:242:6>>*/ for(;;){
      if(sz <= i$3) break;
       /*<<weak.ml:260:18>>*/ if(! check(bucket$0, i$3)){
        /*<<weak.ml:263:8>>*/  /*<<weak.ml:263:8>>*/ caml_call3
        (setter, bucket$0, i$3, d);
        /*<<weak.ml:264:8>>*/ caml_check_bound(hashes, i$3)[1 + i$3] = h;
        /*<<weak.ml:264:8>>*/ return 0;
      }
       /*<<weak.ml:260:38>>*/ var
        /*<<weak.ml:260:38>>*/ i$5 = i$3 + 1 | 0,
       i$3 = i$5;
     }
      /*<<weak.ml:244:10>>*/  /*<<weak.ml:244:10>>*/ var
      newsz =
         /*<<weak.ml:244:10>>*/ caml_call2
         (Stdlib_Int[10],
          ((3 * sz | 0) / 2 | 0) + 3 | 0,
          Stdlib_Sys[13] - 2 | 0);
     if(newsz <= sz)
       /*<<weak.ml:246:28>>*/  /*<<weak.ml:246:28>>*/ caml_call1
       (Stdlib[2], cst_Weak_Make_hash_bucket_cann);
      /*<<weak.ml:247:24>>*/ var
       /*<<weak.ml:247:24>>*/ newbucket$0 = create(newsz),
       /*<<weak.ml:248:24>>*/ newhashes =
         /*<<weak.ml:248:24>>*/ caml_make_vect(newsz, 0);
      /*<<weak.ml:249:8>>*/ blit(bucket$0, 0, newbucket$0, 0, sz);
      /*<<weak.ml:250:8>>*/  /*<<weak.ml:250:8>>*/ caml_call5
      (Stdlib_Array[8], hashes, 0, newhashes, 0, sz);
      /*<<weak.ml:251:8>>*/  /*<<weak.ml:251:8>>*/ caml_call3
      (setter, newbucket$0, sz, d);
      /*<<weak.ml:252:8>>*/ caml_check_bound(newhashes, sz)[1 + sz] = h;
      /*<<weak.ml:253:8>>*/ caml_check_bound(t[1], index)[1 + index] = newbucket$0;
      /*<<weak.ml:254:8>>*/ caml_check_bound(t[2], index)[1 + index] = newhashes;
     var _r_ = sz <= t[3] ? 1 : 0, _s_ = _r_ ? t[3] < newsz ? 1 : 0 : _r_;
     if(_s_){
      t[4] = t[4] + 1 | 0;
      var i$4 = 0;
      for(;;){
        /*<<weak.ml:185:17>>*/ var
        _h_ = t[5],
         /*<<weak.ml:185:17>>*/ bucket = caml_check_bound(t[1], _h_)[1 + _h_],
         /*<<weak.ml:186:4>>*/ _i_ = t[5],
         /*<<weak.ml:186:18>>*/ hbucket = caml_check_bound(t[2], _i_)[1 + _i_],
         /*<<weak.ml:187:14>>*/ len = length(bucket),
        prev_len = (((len - 3 | 0) * 2 | 0) + 2 | 0) / 3 | 0,
         /*<<weak.ml:189:15>>*/ live = count_bucket(0, bucket, 0);
       if(live <= prev_len){
         /*<<weak.ml:201:14>>*/ var
          /*<<weak.ml:201:14>>*/ j$2 = length(bucket) - 1 | 0,
         i$0 = 0,
         j = j$2;
         /*<<weak.ml:192:8>>*/ for(;;){
         if(prev_len > j) break;
          /*<<weak.ml:193:13>>*/ if(check(bucket, i$0))
          var i$1 = i$0 + 1 | 0, i$0 = i$1;
         else if(check(bucket, j)){
           /*<<weak.ml:195:12>>*/ blit(bucket, j, bucket, i$0, 1);
           /*<<weak.ml:196:27>>*/  /*<<weak.ml:196:27>>*/ var
           _j_ = caml_check_bound(hbucket, j)[1 + j];
           /*<<weak.ml:196:12>>*/ caml_check_bound(hbucket, i$0)[1 + i$0] = _j_;
           /*<<weak.ml:196:12>>*/ var
            /*<<weak.ml:196:12>>*/ j$0 = j - 1 | 0,
           i$2 = i$0 + 1 | 0,
           i$0 = i$2,
           j = j$0;
         }
         else
           /*<<weak.ml:198:19>>*/ var
            /*<<weak.ml:198:19>>*/ j$1 = j - 1 | 0,
           j = j$1;
        }
        if(0 === prev_len){
         var _k_ = t[5];
          /*<<weak.ml:203:8>>*/ caml_check_bound(t[1], _k_)[1 + _k_] = emptybucket;
         var _l_ = t[5];
          /*<<weak.ml:204:8>>*/ caml_check_bound(t[2], _l_)[1 + _l_] = [0];
        }
        else{
          /*<<weak.ml:206:24>>*/  /*<<weak.ml:206:24>>*/ var
          newbucket = create(prev_len);
          /*<<weak.ml:207:8>>*/ blit(bucket, 0, newbucket, 0, prev_len);
         var _o_ = t[5];
          /*<<weak.ml:208:8>>*/ caml_check_bound(t[1], _o_)[1 + _o_] = newbucket;
          /*<<weak.ml:209:30>>*/ var
           /*<<weak.ml:209:30>>*/ _p_ =
             /*<<weak.ml:209:30>>*/ caml_call3
             (Stdlib_Array[5], hbucket, 0, prev_len),
          _q_ = t[5];
          /*<<weak.ml:209:8>>*/ caml_check_bound(t[2], _q_)[1 + _q_] = _p_;
        }
        var
         _m_ = t[3] < len ? 1 : 0,
         _n_ = _m_ ? prev_len <= t[3] ? 1 : 0 : _m_;
        if(_n_) t[4] = t[4] - 1 | 0;
       }
       t[5] = caml_mod(t[5] + 1 | 0, t[1].length - 1);
        /*<<weak.ml:257:38>>*/  /*<<weak.ml:257:38>>*/ var _u_ = i$4 + 1 | 0;
       if(2 === i$4) break;
       var i$4 = _u_;
      }
     }
     var _t_ = ((t[1].length - 1) / 2 | 0) < t[4] ? 1 : 0;
     if(! _t_) return _t_;
      /*<<weak.ml:181:18>>*/ var
      oldlen = t[1].length - 1,
       /*<<weak.ml:181:18>>*/ newlen =
         /*<<weak.ml:181:18>>*/ caml_call2
         (Stdlib_Int[10], ((3 * oldlen | 0) / 2 | 0) + 3 | 0, Stdlib_Sys[13]);
     if(oldlen < newlen){
       /*<<weak.ml:220:17>>*/ var
        /*<<weak.ml:220:17>>*/ newt = create$0(newlen),
       i = 0;
       /*<<weak.ml:169:16>>*/  /*<<weak.ml:169:16>>*/ caml_call2
       (Stdlib_Array[12],
        function(j, ob){
         var oi = i;
          /*<<weak.ml:164:6>>*/ for(;;){
          if(length(ob) <= oi)  /*<<weak.ml:164:28>>*/ return 0;
          if(check(ob, oi)){
            /*<<weak.ml:166:20>>*/  /*<<weak.ml:166:20>>*/ var
            oh = caml_check_bound(t[2], j)[1 + j];
           let oi$0 = oi;
            /*<<weak.ml:223:16>>*/ var
            setter =
              function(nb, ni, param){
                /*<<weak.ml:222:29>>*/ return blit(ob, oi$0, nb, ni, 1);
               /*<<weak.ml:222:47>>*/ },
             /*<<weak.ml:223:16>>*/ h = caml_check_bound(oh, oi)[1 + oi];
            /*<<weak.ml:224:35>>*/ add_aux
            (newt, setter, 0, h, get_index(newt, h));
           var i$0 = oi + 1 | 0, oi = i$0;
          }
          else
           var i$1 = oi + 1 | 0, oi = i$1;
         }
        },
        t[1]);
      t[1] = newt[1];
      t[2] = newt[2];
      t[3] = newt[3];
      t[4] = newt[4];
      t[5] = caml_mod(t[5], newt[1].length - 1);
      return 0;
     }
     t[3] = Stdlib[19];
     t[4] = 0;
     return 0;
     /*<<weak.ml:267:10>>*/ }
    function add(t, d){
      /*<<weak.ml:271:4>>*/  /*<<weak.ml:271:12>>*/ var
      h =  /*<<weak.ml:271:12>>*/ caml_call1(H[2], d);
      /*<<weak.ml:272:29>>*/ return add_aux
             (t, set, [0, d], h, get_index(t, h));
     /*<<weak.ml:272:44>>*/ }
    function find_aux(t, d, found, notfound){
      /*<<weak.ml:278:4>>*/ var
       /*<<weak.ml:278:12>>*/ h =  /*<<weak.ml:278:12>>*/ caml_call1(H[2], d),
       /*<<weak.ml:279:16>>*/ index = get_index(t, h),
       /*<<weak.ml:280:17>>*/ bucket =
        caml_check_bound(t[1], index)[1 + index],
       /*<<weak.ml:281:17>>*/ hashes =
        caml_check_bound(t[2], index)[1 + index],
       /*<<weak.ml:282:13>>*/ sz = length(bucket),
      i = 0;
      /*<<weak.ml:284:6>>*/ for(;;){
      if(sz <= i)
        /*<<weak.ml:279:16>>*/ return  /*<<weak.ml:279:16>>*/ caml_call2
               (notfound, h, index);
      if(h === caml_check_bound(hashes, i)[1 + i]){
        /*<<weak.ml:286:14>>*/  /*<<weak.ml:286:14>>*/ var
        opt = get(bucket, i);
       if(opt){
        var v = opt[1];
         /*<<weak.ml:287:29>>*/ if
         ( /*<<weak.ml:287:29>>*/ caml_call2(H[1], v, d))
          /*<<weak.ml:287:44>>*/ return  /*<<weak.ml:287:44>>*/ caml_call4
                 (found, bucket, i, opt, v);
       }
        /*<<weak.ml:288:15>>*/ var
         /*<<weak.ml:288:15>>*/ i$0 = i + 1 | 0,
        i = i$0;
      }
      else
        /*<<weak.ml:289:15>>*/ var
         /*<<weak.ml:289:15>>*/ i$1 = i + 1 | 0,
        i = i$1;
     }
     /*<<weak.ml:291:10>>*/ }
    function find_opt(t, d){
      /*<<weak.ml:293:21>>*/ return find_aux
             (t,
              d,
              function(b, i, o, v){
                /*<<weak.ml:293:54>>*/ return o;
               /*<<weak.ml:293:55>>*/ },
              function(h, i){
                /*<<weak.ml:294:48>>*/ return 0;
               /*<<weak.ml:294:52>>*/ });
     /*<<weak.ml:294:53>>*/ }
    function merge(t, d){
      /*<<weak.ml:296:21>>*/ return find_aux
             (t,
              d,
              function(b, i, o, v){
                /*<<weak.ml:296:54>>*/ return v;
               /*<<weak.ml:296:55>>*/ },
              function(h, i){
                /*<<weak.ml:298:40>>*/ add_aux(t, set, [0, d], h, i);
                /*<<weak.ml:296:21>>*/ return d;
               /*<<weak.ml:298:69>>*/ });
     /*<<weak.ml:298:70>>*/ }
    function find(t, d){
      /*<<weak.ml:300:21>>*/ return find_aux
             (t,
              d,
              function(b, i, o, v){
                /*<<weak.ml:300:54>>*/ return v;
               /*<<weak.ml:300:55>>*/ },
              function(h, i){
                /*<<weak.ml:301:48>>*/ throw  /*<<weak.ml:301:48>>*/ caml_maybe_attach_backtrace
                      (Stdlib[8], 1);
               /*<<weak.ml:301:63>>*/ });
     /*<<weak.ml:301:64>>*/ }
    function remove(t, d){
      /*<<weak.ml:303:21>>*/ return find_aux
             (t,
              d,
              function(b, i, o, v){
                /*<<weak.ml:303:54>>*/ return set(b, i, 0);
               /*<<weak.ml:303:66>>*/ },
              function(h, i){
                /*<<weak.ml:304:48>>*/ return 0;
               /*<<weak.ml:304:50>>*/ });
     /*<<weak.ml:304:51>>*/ }
    function mem(t, d){
      /*<<weak.ml:306:21>>*/ return find_aux
             (t,
              d,
              function(b, i, o, v){
                /*<<weak.ml:306:54>>*/ return 1;
               /*<<weak.ml:306:58>>*/ },
              function(h, i){
                /*<<weak.ml:307:48>>*/ return 0;
               /*<<weak.ml:307:53>>*/ });
     /*<<weak.ml:307:54>>*/ }
    function find_all(t, d){
      /*<<weak.ml:310:4>>*/ var
       /*<<weak.ml:310:12>>*/ h =  /*<<weak.ml:310:12>>*/ caml_call1(H[2], d),
       /*<<weak.ml:311:16>>*/ index = get_index(t, h),
       /*<<weak.ml:312:17>>*/ bucket =
        caml_check_bound(t[1], index)[1 + index],
       /*<<weak.ml:313:17>>*/ hashes =
        caml_check_bound(t[2], index)[1 + index],
       /*<<weak.ml:314:13>>*/ sz = length(bucket),
      i = 0,
      accu = 0;
      /*<<weak.ml:316:6>>*/ for(;;){
      if(sz <= i)  /*<<weak.ml:316:22>>*/ return accu;
      if(h === caml_check_bound(hashes, i)[1 + i]){
        /*<<weak.ml:318:14>>*/  /*<<weak.ml:318:14>>*/ var
        match = get(bucket, i);
       if(match){
        var v = match[1];
         /*<<weak.ml:319:22>>*/ if
         ( /*<<weak.ml:319:22>>*/ caml_call2(H[1], v, d)){
          /*<<weak.ml:319:50>>*/ var
           /*<<weak.ml:319:50>>*/ accu$0 = [0, v, accu],
           /*<<weak.ml:319:50>>*/ i$0 = i + 1 | 0,
          i = i$0,
          accu = accu$0;
         continue;
        }
       }
       var i$1 = i + 1 | 0, i = i$1;
      }
      else
       var i$2 = i + 1 | 0, i = i$2;
     }
     /*<<weak.ml:323:13>>*/ }
    function stats(t){
      /*<<weak.ml:326:4>>*/ var
      len = t[1].length - 1,
       /*<<weak.ml:327:15>>*/ lens =
         /*<<weak.ml:327:15>>*/ caml_call2(Stdlib_Array[13], length, t[1]);
      /*<<weak.ml:328:4>>*/  /*<<weak.ml:328:4>>*/ caml_call2
      (Stdlib_Array[34], runtime.caml_int_compare, lens);
      /*<<weak.ml:329:17>>*/ var
       /*<<weak.ml:329:17>>*/ totlen =
         /*<<weak.ml:329:17>>*/ caml_call3
         (Stdlib_Array[17],
          function(_g_, _f_){ /*<<?>>*/ return _g_ + _f_ | 0;},
          0,
          lens),
       /*<<weak.ml:329:17>>*/ _a_ = len - 1 | 0,
      _c_ = len / 2 | 0,
       /*<<weak.ml:330:51>>*/ _b_ = caml_check_bound(lens, _a_)[1 + _a_],
       /*<<weak.ml:330:37>>*/ _d_ = caml_check_bound(lens, _c_)[1 + _c_],
       /*<<weak.ml:330:27>>*/ _e_ = caml_check_bound(lens, 0)[1];
      /*<<weak.ml:330:4>>*/ return [0, len, count(t), totlen, _e_, _d_, _b_];
     /*<<weak.ml:330:64>>*/ }
     /*<<weak.ml:101:66>>*/ return [0,
            create$0,
            clear,
            merge,
            add,
            remove,
            find,
            find_opt,
            find_all,
            mem,
            iter,
            fold,
            count,
            stats];
   }
   var
    Stdlib_Weak =
      [0, create, length, set, get, get_copy, check, fill, blit, Make];
   runtime.caml_register_global(13, Stdlib_Weak, "Stdlib__Weak");
   return;
   /*<<?>>*/ }
  (globalThis));

//# unitInfo: Provides: Stdlib__Format
//# unitInfo: Requires: CamlinternalFormat, Stdlib, Stdlib__Array, Stdlib__Buffer, Stdlib__Bytes, Stdlib__Domain, Stdlib__Int, Stdlib__List, Stdlib__Queue, Stdlib__Seq, Stdlib__Stack, Stdlib__String
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$16 = "",
    cst$15 = ">",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length;
    /*<<?>>*/ function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
    /*<<?>>*/ function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
    /*<<?>>*/ function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
    /*<<?>>*/ function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$14 = ".",
    cst$11 = cst$15,
    cst$12 = "<\/",
    cst$13 = cst$16,
    cst$8 = cst$15,
    cst$9 = "<",
    cst$10 = cst$16,
    cst$7 = "\n",
    cst$3 = cst$16,
    cst$4 = cst$16,
    cst$5 = cst$16,
    cst$6 = cst$16,
    cst = cst$16,
    cst$0 = cst$16,
    cst$1 = cst$16,
    cst$2 = cst$16,
    Stdlib_Queue = global_data.Stdlib__Queue,
    CamlinternalFormat = global_data.CamlinternalFormat,
    Stdlib = global_data.Stdlib,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Domain = global_data.Stdlib__Domain,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_Stack = global_data.Stdlib__Stack,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Bytes = global_data.Stdlib__Bytes;
   function id(x){ /*<<format.ml:23:11>>*/ return x; /*<<format.ml:23:12>>*/ }
    /*<<format.ml:91:13>>*/ var
    zero = 0,
    unknown = -1,
     /*<<format.ml:91:13>>*/ String_tag =
      [248, "Stdlib.Format.String_tag", runtime.caml_fresh_oo_id(0)];
   function pp_enqueue(state, token){
     /*<<format.ml:219:2>>*/ state[13] = state[13] + token[3] | 0;
    return caml_call2(Stdlib_Queue[3], token, state[28]);
    /*<<format.ml:220:32>>*/ }
   var
    pp_infinity = 1000000010,
    _a_ = [0, cst$16, 0, cst$16],
    _b_ = [0, cst$16],
    _c_ = [1, "margin <= max_indent"],
    _d_ = [0, 0],
    _e_ = [1, "max_indent < 2"],
    cst_Format_pp_set_geometry = "Format.pp_set_geometry: ";
   function pp_output_string(state, s){
     /*<<format.ml:251:31>>*/ return caml_call3
            (state[17], s, 0, caml_ml_string_length(s));
    /*<<format.ml:251:72>>*/ }
   function pp_output_newline(state){
     /*<<format.ml:252:30>>*/ return  /*<<format.ml:252:30>>*/ caml_call1
            (state[19], 0);
    /*<<format.ml:252:53>>*/ }
   function format_pp_text(state, size, text){
     /*<<format.ml:258:2>>*/ state[9] = state[9] - size | 0;
     /*<<format.ml:259:2>>*/ pp_output_string(state, text);
    state[11] = 0;
    return;
    /*<<format.ml:260:31>>*/ }
   function format_string(state, s){
     /*<<format.ml:264:2>>*/  /*<<format.ml:264:5>>*/ var
     _a9_ =  /*<<format.ml:264:5>>*/ runtime.caml_string_notequal(s, cst$16);
     /*<<format.ml:264:5>>*/ return _a9_
            ? format_pp_text(state, caml_ml_string_length(s), s)
            : _a9_;
    /*<<format.ml:264:58>>*/ }
   function break_new_line(state, param, width){
    var after = param[3], offset = param[2], before = param[1];
     /*<<format.ml:268:2>>*/ format_string(state, before);
     /*<<format.ml:269:2>>*/ pp_output_newline(state);
    state[11] = 1;
     /*<<format.ml:273:20>>*/ var
     indent = (state[6] - width | 0) + offset | 0,
      /*<<format.ml:273:20>>*/ real_indent =
        /*<<format.ml:273:20>>*/ caml_call2(Stdlib_Int[10], state[8], indent);
    state[10] = real_indent;
    state[9] = state[6] - state[10] | 0;
    var n = state[10];
     /*<<format.ml:254:31>>*/  /*<<format.ml:254:31>>*/ caml_call1
     (state[21], n);
     /*<<format.ml:276:2>>*/ return format_string(state, after);
   }
   function break_line(state, width){
     /*<<format.ml:281:29>>*/ return break_new_line(state, _a_, width);
    /*<<format.ml:281:67>>*/ }
   function break_same_line(state, param){
    var after = param[3], width = param[2], before = param[1];
     /*<<format.ml:285:2>>*/ format_string(state, before);
    state[9] = state[9] - width | 0;
     /*<<format.ml:253:31>>*/  /*<<format.ml:253:31>>*/ caml_call1
     (state[20], width);
     /*<<format.ml:287:2>>*/ return format_string(state, after);
   }
   function format_pp_token(state, size$0, param){
     /*<<?>>*/ if(typeof param === "number")
     switch(param){
       case 0:
         /*<<format.ml:348:16>>*/  /*<<format.ml:348:16>>*/ var
         match$3 =
            /*<<format.ml:348:16>>*/ caml_call1(Stdlib_Stack[8], state[3]);
        if(! match$3)  /*<<format.ml:349:14>>*/ return;
         /*<<format.ml:351:6>>*/ var
         tabs = match$3[1][1],
          /*<<format.ml:351:6>>*/ add_tab =
           function(n, ls){
             /*<<?>>*/ if(! ls)  /*<<format.ml:352:16>>*/ return [0, n, 0];
            var l = ls[2], x = ls[1];
             /*<<format.ml:353:29>>*/ return  /*<<format.ml:353:29>>*/ runtime.caml_lessthan
                     (n, x)
                    ? [0, n, ls]
                    : [0, x, add_tab(n, l)];
           };
        tabs[1] = add_tab(state[6] - state[9] | 0, tabs[1]);
        return;
       case 1:
         /*<<format.ml:339:4>>*/  /*<<format.ml:339:4>>*/ caml_call1
         (Stdlib_Stack[5], state[2]);
         /*<<format.ml:339:4>>*/ return;
       case 2:
         /*<<format.ml:345:4>>*/  /*<<format.ml:345:4>>*/ caml_call1
         (Stdlib_Stack[5], state[3]);
         /*<<format.ml:345:4>>*/ return;
       case 3:
         /*<<format.ml:378:16>>*/  /*<<format.ml:378:16>>*/ var
         match$4 =
            /*<<format.ml:378:16>>*/ caml_call1(Stdlib_Stack[8], state[2]);
        if(! match$4)
          /*<<format.ml:379:14>>*/ return pp_output_newline(state);
        var width$0 = match$4[1][2];
         /*<<format.ml:380:26>>*/ return break_line(state, width$0);
       case 4:
        var _a7_ = state[10] !== (state[6] - state[9] | 0) ? 1 : 0;
        if(! _a7_) return _a7_;
         /*<<format.ml:306:8>>*/  /*<<format.ml:306:8>>*/ var
         match$1 =
            /*<<format.ml:306:8>>*/ caml_call1(Stdlib_Queue[6], state[28]);
        if(! match$1)  /*<<format.ml:307:12>>*/ return;
        var match$2 = match$1[1], size = match$2[1], length = match$2[3];
        state[12] = state[12] - length | 0;
        state[9] = state[9] + size | 0;
        return;
       default:
         /*<<format.ml:419:17>>*/  /*<<format.ml:419:17>>*/ var
         match$5 =
            /*<<format.ml:419:17>>*/ caml_call1(Stdlib_Stack[5], state[5]);
        if(! match$5)  /*<<format.ml:420:15>>*/ return;
         /*<<format.ml:422:20>>*/ var
         tag_name = match$5[1],
          /*<<format.ml:422:20>>*/ marker =
            /*<<format.ml:422:20>>*/ caml_call1(state[25], tag_name);
         /*<<format.ml:423:7>>*/ return pp_output_string(state, marker);
     }
    switch(param[0]){
      case 0:
       var s = param[1];
        /*<<format.ml:323:4>>*/ return format_pp_text(state, size$0, s);
      case 1:
        /*<<format.ml:388:4>>*/ var
        breaks = param[2],
        fits = param[1],
         /*<<format.ml:388:4>>*/ off = breaks[2],
        before = breaks[1],
         /*<<format.ml:389:16>>*/ match$6 =
           /*<<format.ml:389:16>>*/ caml_call1(Stdlib_Stack[8], state[2]);
       if(! match$6)  /*<<format.ml:390:14>>*/ return;
       var
        match$7 = match$6[1],
        width$1 = match$7[2],
        box_type$0 = match$7[1];
        /*<<format.ml:392:6>>*/ switch(box_type$0){
         case 0:
           /*<<format.ml:409:19>>*/ return break_same_line(state, fits);
         case 1:
           /*<<format.ml:408:19>>*/ return break_new_line
                  (state, breaks, width$1);
         case 2:
           /*<<format.ml:406:20>>*/ return break_new_line
                  (state, breaks, width$1);
         case 3:
          return state[9] < (size$0 + caml_ml_string_length(before) | 0)
                  ? break_new_line(state, breaks, width$1)
                  : break_same_line(state, fits);
         case 4:
          return state[11]
                  ? break_same_line(state, fits)
                  : state
                     [9]
                    < (size$0 + caml_ml_string_length(before) | 0)
                    ? break_new_line(state, breaks, width$1)
                    : ((state
                       [6]
                      - width$1
                      | 0)
                      + off
                      | 0)
                      < state[10]
                      ? break_new_line(state, breaks, width$1)
                      : break_same_line(state, fits);
         default:
           /*<<format.ml:407:19>>*/ return break_same_line(state, fits);
       }
      case 2:
        /*<<format.ml:359:16>>*/ var
        off$0 = param[2],
        n = param[1],
        insertion_point = state[6] - state[9] | 0,
         /*<<format.ml:359:16>>*/ match$8 =
           /*<<format.ml:359:16>>*/ caml_call1(Stdlib_Stack[8], state[3]);
       if(! match$8)  /*<<format.ml:360:14>>*/ return;
        /*<<format.ml:362:6>>*/ var
        tabs$0 = match$8[1][1],
         /*<<format.ml:362:6>>*/ match$9 = tabs$0[1];
       if(match$9){
        var first = match$9[1], param$0 = tabs$0[1];
         /*<<format.ml:366:25>>*/ for(;;){
         if(param$0){
          var tail = param$0[2], head = param$0[1];
          if(insertion_point > head){var param$0 = tail; continue;}
          var _a8_ = head;
         }
         else
          var _a8_ = first;
         var tab = _a8_;
         break;
        }
       }
       else
        var tab = insertion_point;
       var offset = tab - insertion_point | 0;
        /*<<format.ml:372:6>>*/ return 0 <= offset
               ? break_same_line(state, [0, cst$0, offset + n | 0, cst])
               : break_new_line
                 (state, [0, cst$2, tab + off$0 | 0, cst$1], state[6]);
      case 3:
       var
        ty = param[2],
        off$1 = param[1],
        insertion_point$0 = state[6] - state[9] | 0;
       if(state[8] < insertion_point$0){
         /*<<format.ml:295:8>>*/  /*<<format.ml:295:8>>*/ var
         match =
            /*<<format.ml:295:8>>*/ caml_call1(Stdlib_Stack[8], state[2]);
        if(match){
         var match$0 = match[1], width = match$0[2], box_type = match$0[1];
         if(state[9] < width && 3 >= box_type - 1 >>> 0)
           /*<<format.ml:301:51>>*/ break_line(state, width);
        }
        else
          /*<<format.ml:296:12>>*/ pp_output_newline(state);
       }
        /*<<format.ml:331:4>>*/ var
        width$2 = state[9] - off$1 | 0,
         /*<<format.ml:331:4>>*/ box_type$1 =
          1 === ty ? 1 : state[9] < size$0 ? ty : 5;
        /*<<format.ml:336:4>>*/ return  /*<<format.ml:336:4>>*/ caml_call2
               (Stdlib_Stack[3], [0, box_type$1, width$2], state[2]);
      case 4:
       var tbox = param[1];
        /*<<format.ml:342:4>>*/ return  /*<<format.ml:342:4>>*/ caml_call2
               (Stdlib_Stack[3], tbox, state[3]);
      default:
        /*<<format.ml:414:18>>*/ var
        tag_name$0 = param[1],
         /*<<format.ml:414:18>>*/ marker$0 =
           /*<<format.ml:414:18>>*/ caml_call1(state[24], tag_name$0);
        /*<<format.ml:415:5>>*/ pp_output_string(state, marker$0);
       return caml_call2(Stdlib_Stack[3], tag_name$0, state[5]);
    }
   }
   function advance_left(state){
     /*<<format.ml:431:2>>*/ for(;;){
      /*<<format.ml:431:8>>*/  /*<<format.ml:431:8>>*/ var
      match =  /*<<format.ml:431:8>>*/ caml_call1(Stdlib_Queue[9], state[28]);
     if(! match)  /*<<format.ml:432:12>>*/ return 0;
      /*<<format.ml:435:7>>*/ var
      match$0 = match[1],
      size = match$0[1],
      length = match$0[3],
      token = match$0[2],
      pending_count = state[13] - state[12] | 0,
       /*<<format.ml:435:7>>*/ _a5_ = 0 <= size ? 1 : 0,
       /*<<format.ml:435:7>>*/ _a6_ =
        _a5_ || (state[9] <= pending_count ? 1 : 0);
     if(! _a6_)  /*<<format.ml:435:7>>*/ return _a6_;
      /*<<format.ml:436:6>>*/  /*<<format.ml:436:6>>*/ caml_call1
      (Stdlib_Queue[5], state[28]);
      /*<<format.ml:437:20>>*/  /*<<format.ml:437:20>>*/ var
      size$0 = 0 <= size ? size : pp_infinity;
      /*<<format.ml:438:6>>*/ format_pp_token(state, size$0, token);
     state[12] = length + state[12] | 0;
    }
    /*<<format.ml:441:7>>*/ }
   function enqueue_advance(state, tok){
     /*<<format.ml:445:32>>*/ pp_enqueue(state, tok);
     /*<<format.ml:445:32>>*/ return advance_left(state);
    /*<<format.ml:445:72>>*/ }
   function enqueue_string_as(state, size, s){
     /*<<format.ml:450:2>>*/ return enqueue_advance
            (state, [0, size, [0, s], size]);
    /*<<format.ml:450:78>>*/ }
   function initialize_scan_stack(stack){
     /*<<format.ml:462:2>>*/  /*<<format.ml:462:2>>*/ caml_call1
     (Stdlib_Stack[9], stack);
     /*<<format.ml:463:19>>*/  /*<<format.ml:463:19>>*/ var
     queue_elem = [0, unknown, _b_, 0];
     /*<<format.ml:464:2>>*/ return  /*<<format.ml:464:2>>*/ caml_call2
            (Stdlib_Stack[3], [0, -1, queue_elem], stack);
    /*<<format.ml:464:50>>*/ }
   function set_size(state, ty){
     /*<<format.ml:476:2>>*/  /*<<format.ml:476:8>>*/ var
     match =  /*<<format.ml:476:8>>*/ caml_call1(Stdlib_Stack[8], state[1]);
    if(! match)  /*<<format.ml:477:12>>*/ return;
     /*<<format.ml:479:4>>*/ var
     match$0 = match[1],
     queue_elem = match$0[2],
     left_total = match$0[1],
      /*<<format.ml:479:4>>*/ size = queue_elem[1];
    if(left_total < state[12]) return initialize_scan_stack(state[1]);
    var _a4_ = queue_elem[2];
    if(typeof _a4_ !== "number")
     switch(_a4_[0]){
       case 3:
        if(1 - ty){
         queue_elem[1] = state[13] + size | 0;
          /*<<format.ml:493:10>>*/  /*<<format.ml:493:10>>*/ caml_call1
          (Stdlib_Stack[5], state[1]);
        }
         /*<<format.ml:493:10>>*/ return;
       case 1:
       case 2:
        if(ty){
         queue_elem[1] = state[13] + size | 0;
          /*<<format.ml:488:10>>*/  /*<<format.ml:488:10>>*/ caml_call1
          (Stdlib_Stack[5], state[1]);
        }
         /*<<format.ml:488:10>>*/ return;
     }
     /*<<format.ml:497:8>>*/ return;
    /*<<format.ml:497:10>>*/ }
   function scan_push(state, b, token){
     /*<<format.ml:503:2>>*/ pp_enqueue(state, token);
    if(b)  /*<<format.ml:504:12>>*/ set_size(state, 1);
     /*<<format.ml:505:13>>*/  /*<<format.ml:505:13>>*/ var
     elem = [0, state[13], token];
     /*<<format.ml:506:2>>*/ return  /*<<format.ml:506:2>>*/ caml_call2
            (Stdlib_Stack[3], elem, state[1]);
    /*<<format.ml:506:37>>*/ }
   function pp_open_box_gen(state, indent, br_ty){
     /*<<format.ml:513:2>>*/ state[14] = state[14] + 1 | 0;
    if(state[14] < state[15]){
      /*<<format.ml:516:15>>*/ var
      size = - state[13] | 0,
       /*<<format.ml:516:15>>*/ elem = [0, size, [3, indent, br_ty], 0];
      /*<<format.ml:517:4>>*/ return scan_push(state, 0, elem);
    }
    var _a3_ = state[14] === state[15] ? 1 : 0;
    if(! _a3_) return _a3_;
    var s = state[16];
     /*<<format.ml:454:2>>*/ return enqueue_string_as
            (state, caml_ml_string_length(s), s);
    /*<<format.ml:519:45>>*/ }
   function pp_close_box(state, param){
     /*<<format.ml:527:2>>*/ var _a1_ = 1 < state[14] ? 1 : 0;
    if(_a1_){
     if(state[14] < state[15]){
       /*<<format.ml:531:6>>*/ pp_enqueue(state, [0, zero, 1, 0]);
       /*<<format.ml:532:6>>*/ set_size(state, 1);
       /*<<format.ml:532:27>>*/ set_size(state, 0);
     }
     state[14] = state[14] - 1 | 0;
     var _a2_ = 0;
    }
    else
     var _a2_ = _a1_;
    return _a2_;
    /*<<format.ml:535:5>>*/ }
   function pp_open_stag(state, tag_name){
     /*<<format.ml:540:2>>*/ if(state[22]){
      /*<<format.ml:542:4>>*/  /*<<format.ml:542:4>>*/ caml_call2
      (Stdlib_Stack[3], tag_name, state[4]);
      /*<<format.ml:543:4>>*/  /*<<format.ml:543:4>>*/ caml_call1
      (state[26], tag_name);
    }
    var _a0_ = state[23];
    if(! _a0_) return _a0_;
     /*<<format.ml:546:16>>*/  /*<<format.ml:546:16>>*/ var
     token = [5, tag_name];
     /*<<format.ml:547:21>>*/ return pp_enqueue(state, [0, zero, token, 0]);
    /*<<format.ml:547:60>>*/ }
   function pp_close_stag(state, param){
     /*<<format.ml:552:2>>*/ if(state[23])
      /*<<format.ml:553:4>>*/ pp_enqueue(state, [0, zero, 5, 0]);
    var _aY_ = state[22];
    if(_aY_){
      /*<<format.ml:555:10>>*/  /*<<format.ml:555:10>>*/ var
      match =  /*<<format.ml:555:10>>*/ caml_call1(Stdlib_Stack[5], state[4]);
     if(match){
      var tag_name = match[1];
       /*<<format.ml:558:6>>*/ return  /*<<format.ml:558:6>>*/ caml_call1
              (state[27], tag_name);
     }
     var _aZ_ = 0;
    }
    else
     var _aZ_ = _aY_;
     /*<<format.ml:556:14>>*/ return _aZ_;
    /*<<format.ml:558:39>>*/ }
   function pp_set_print_tags(state, b){
     /*<<format.ml:560:32>>*/ state[22] = b;
    return 0;
    /*<<format.ml:560:56>>*/ }
   function pp_set_mark_tags(state, b){
     /*<<format.ml:561:31>>*/ state[23] = b;
    return 0;
    /*<<format.ml:561:54>>*/ }
   function pp_get_print_tags(state, param){
     /*<<format.ml:562:33>>*/ return state[22];
    /*<<format.ml:562:52>>*/ }
   function pp_get_mark_tags(state, param){
     /*<<format.ml:563:32>>*/ return state[23];
    /*<<format.ml:563:50>>*/ }
   function pp_set_tags(state, b){
     /*<<format.ml:565:2>>*/ pp_set_print_tags(state, b);
     /*<<format.ml:565:2>>*/ return pp_set_mark_tags(state, b);
    /*<<format.ml:565:53>>*/ }
   function pp_get_formatter_stag_function(state, param){
     /*<<format.ml:569:47>>*/ return [0,
            state[24],
            state[25],
            state[26],
            state[27]];
    /*<<format.ml:574:1>>*/ }
   function pp_set_formatter_stag_function(state, param){
    var pct = param[4], pot = param[3], mct = param[2], mot = param[1];
    state[24] = mot;
    state[25] = mct;
    state[26] = pot;
    state[27] = pct;
    return 0;
   }
   function pp_rinit(state){
     /*<<format.ml:591:2>>*/ state[12] = 1;
    state[13] = 1;
    caml_call1(Stdlib_Queue[11], state[28]);
     /*<<format.ml:592:2>>*/ initialize_scan_stack(state[1]);
     /*<<format.ml:593:2>>*/  /*<<format.ml:593:2>>*/ caml_call1
     (Stdlib_Stack[9], state[2]);
     /*<<format.ml:594:2>>*/  /*<<format.ml:594:2>>*/ caml_call1
     (Stdlib_Stack[9], state[3]);
     /*<<format.ml:595:2>>*/  /*<<format.ml:595:2>>*/ caml_call1
     (Stdlib_Stack[9], state[4]);
     /*<<format.ml:596:2>>*/  /*<<format.ml:596:2>>*/ caml_call1
     (Stdlib_Stack[9], state[5]);
    state[10] = 0;
    state[14] = 0;
    state[9] = state[6];
     /*<<format.ml:523:28>>*/ return pp_open_box_gen(state, 0, 3);
    /*<<format.ml:600:23>>*/ }
   function pp_flush_queue(state, end_with_newline){
     /*<<format.ml:608:2>>*/  /*<<format.ml:603:13>>*/ caml_call2
     (Stdlib_Stack[13],
      function(param){
        /*<<format.ml:603:23>>*/ return pp_close_stag(state, 0);
       /*<<format.ml:603:45>>*/ },
      state[4]);
     /*<<format.ml:610:4>>*/ for(;;){
     if(1 >= state[14]){
      state[13] = pp_infinity;
       /*<<format.ml:613:2>>*/ advance_left(state);
      if(end_with_newline)  /*<<format.ml:614:27>>*/ pp_output_newline(state);
       /*<<format.ml:614:27>>*/ return pp_rinit(state);
     }
      /*<<format.ml:610:4>>*/ pp_close_box(state, 0);
    }
    /*<<format.ml:615:16>>*/ }
   function pp_print_as_size(state, size, s){
     /*<<format.ml:625:2>>*/ var _aX_ = state[14] < state[15] ? 1 : 0;
    return _aX_ ? enqueue_string_as(state, size, s) : _aX_;
    /*<<format.ml:626:37>>*/ }
   function pp_print_as(state, isize, s){
     /*<<format.ml:630:2>>*/ return pp_print_as_size(state, isize, s);
    /*<<format.ml:630:46>>*/ }
   function pp_print_string(state, s){
     /*<<format.ml:634:2>>*/ return pp_print_as
            (state, caml_ml_string_length(s), s);
    /*<<format.ml:634:39>>*/ }
   function pp_print_bytes(state, s){
     /*<<format.ml:637:2>>*/ return pp_print_as
            (state,
             runtime.caml_ml_bytes_length(s),
              /*<<format.ml:637:37>>*/ caml_call1(Stdlib_Bytes[6], s));
    /*<<format.ml:637:56>>*/ }
   function pp_print_int(state, i){
     /*<<format.ml:640:27>>*/ return pp_print_string
            (state,  /*<<format.ml:640:49>>*/ caml_call1(Stdlib_Int[12], i));
    /*<<format.ml:640:66>>*/ }
   function pp_print_float(state, f){
     /*<<format.ml:643:29>>*/ return pp_print_string
            (state,  /*<<format.ml:643:51>>*/ caml_call1(Stdlib[35], f));
    /*<<format.ml:643:70>>*/ }
   function pp_print_bool(state, b){
     /*<<format.ml:646:28>>*/ return pp_print_string
            (state,  /*<<format.ml:646:50>>*/ caml_call1(Stdlib[30], b));
    /*<<format.ml:646:68>>*/ }
   function pp_print_char(state, c){
     /*<<format.ml:650:2>>*/ return pp_print_as
            (state,
             1,
              /*<<format.ml:650:22>>*/ caml_call2(Stdlib_String[1], 1, c));
    /*<<format.ml:650:39>>*/ }
   function pp_open_hbox(state, param){
     /*<<format.ml:654:28>>*/ return pp_open_box_gen(state, 0, 0);
    /*<<format.ml:654:59>>*/ }
   function pp_open_vbox(state, indent){
     /*<<format.ml:655:32>>*/ return pp_open_box_gen(state, indent, 1);
    /*<<format.ml:655:68>>*/ }
   function pp_open_hvbox(state, indent){
     /*<<format.ml:657:33>>*/ return pp_open_box_gen(state, indent, 2);
    /*<<format.ml:657:70>>*/ }
   function pp_open_hovbox(state, indent){
     /*<<format.ml:658:34>>*/ return pp_open_box_gen(state, indent, 3);
    /*<<format.ml:658:72>>*/ }
   function pp_open_box(state, indent){
     /*<<format.ml:659:31>>*/ return pp_open_box_gen(state, indent, 4);
    /*<<format.ml:659:66>>*/ }
   function pp_print_newline(state, param){
     /*<<format.ml:671:2>>*/ pp_flush_queue(state, 1);
     /*<<format.ml:671:2>>*/ return  /*<<format.ml:671:2>>*/ caml_call1
            (state[18], 0);
    /*<<format.ml:671:68>>*/ }
   function pp_print_flush(state, param){
     /*<<format.ml:673:2>>*/ pp_flush_queue(state, 0);
     /*<<format.ml:673:2>>*/ return  /*<<format.ml:673:2>>*/ caml_call1
            (state[18], 0);
    /*<<format.ml:673:69>>*/ }
   function pp_force_newline(state, param){
     /*<<format.ml:678:2>>*/ var _aW_ = state[14] < state[15] ? 1 : 0;
    return _aW_ ? enqueue_advance(state, [0, zero, 3, 0]) : _aW_;
    /*<<format.ml:679:78>>*/ }
   function pp_print_if_newline(state, param){
     /*<<format.ml:684:2>>*/ var _aV_ = state[14] < state[15] ? 1 : 0;
    return _aV_ ? enqueue_advance(state, [0, zero, 4, 0]) : _aV_;
    /*<<format.ml:686:61>>*/ }
   function pp_print_custom_break(state, fits, breaks){
     /*<<format.ml:692:2>>*/ var
     after = fits[3],
     width = fits[2],
     before = fits[1],
     _aU_ = state[14] < state[15] ? 1 : 0;
    if(! _aU_) return _aU_;
     /*<<format.ml:695:25>>*/ var
     size = - state[13] | 0,
      /*<<format.ml:695:25>>*/ token = [1, fits, breaks],
     length =
       (caml_ml_string_length(before) + width | 0)
       +  /*<<format.ml:696:4>>*/ caml_ml_string_length(after)
       | 0,
      /*<<format.ml:697:15>>*/ elem = [0, size, token, length];
     /*<<format.ml:698:4>>*/ return scan_push(state, 1, elem);
    /*<<format.ml:698:29>>*/ }
   function pp_print_break(state, width, offset){
     /*<<format.ml:705:2>>*/ return pp_print_custom_break
            (state, [0, cst$6, width, cst$5], [0, cst$4, offset, cst$3]);
    /*<<format.ml:706:50>>*/ }
   function pp_print_space(state, param){
     /*<<format.ml:714:30>>*/ return pp_print_break(state, 1, 0);
    /*<<format.ml:714:54>>*/ }
   function pp_print_cut(state, param){
     /*<<format.ml:715:28>>*/ return pp_print_break(state, 0, 0);
    /*<<format.ml:715:52>>*/ }
   function pp_open_tbox(state, param){
     /*<<format.ml:720:2>>*/ state[14] = state[14] + 1 | 0;
    var _aT_ = state[14] < state[15] ? 1 : 0;
    if(! _aT_) return _aT_;
     /*<<format.ml:723:15>>*/  /*<<format.ml:723:15>>*/ var
     elem = [0, zero, [4, [0, [0, 0]]], 0];
     /*<<format.ml:724:4>>*/ return enqueue_advance(state, elem);
    /*<<format.ml:724:30>>*/ }
   function pp_close_tbox(state, param){
     /*<<format.ml:729:2>>*/ var _aQ_ = 1 < state[14] ? 1 : 0;
    if(_aQ_){
     var _aR_ = state[14] < state[15] ? 1 : 0;
     if(_aR_){
       /*<<format.ml:732:16>>*/  /*<<format.ml:732:16>>*/ var
       elem = [0, zero, 2, 0];
       /*<<format.ml:733:5>>*/ enqueue_advance(state, elem);
      state[14] = state[14] - 1 | 0;
      var _aS_ = 0;
     }
     else
      var _aS_ = _aR_;
    }
    else
     var _aS_ = _aQ_;
    return _aS_;
    /*<<format.ml:735:5>>*/ }
   function pp_print_tbreak(state, width, offset){
     /*<<format.ml:740:2>>*/ var _aP_ = state[14] < state[15] ? 1 : 0;
    if(! _aP_) return _aP_;
     /*<<format.ml:742:15>>*/ var
     size = - state[13] | 0,
      /*<<format.ml:742:15>>*/ elem = [0, size, [2, width, offset], width];
     /*<<format.ml:743:4>>*/ return scan_push(state, 1, elem);
    /*<<format.ml:743:29>>*/ }
   function pp_print_tab(state, param){
     /*<<format.ml:746:28>>*/ return pp_print_tbreak(state, 0, 0);
    /*<<format.ml:746:53>>*/ }
   function pp_set_tab(state, param){
     /*<<format.ml:749:2>>*/ var _aO_ = state[14] < state[15] ? 1 : 0;
    if(! _aO_) return _aO_;
     /*<<format.ml:750:15>>*/  /*<<format.ml:750:15>>*/ var
     elem = [0, zero, 0, 0];
     /*<<format.ml:751:4>>*/ return enqueue_advance(state, elem);
    /*<<format.ml:751:30>>*/ }
   function pp_set_max_boxes(state, n){
     /*<<format.ml:761:31>>*/ var
     _aM_ = 1 < n ? 1 : 0,
     _aN_ = _aM_ ? (state[15] = n, 0) : _aM_;
    return _aN_;
    /*<<format.ml:761:68>>*/ }
   function pp_get_max_boxes(state, param){
     /*<<format.ml:764:32>>*/ return state[15];
    /*<<format.ml:764:50>>*/ }
   function pp_over_max_boxes(state, param){
     /*<<format.ml:766:33>>*/ return state[14] === state[15] ? 1 : 0;
    /*<<format.ml:766:73>>*/ }
   function pp_set_ellipsis_text(state, s){
     /*<<format.ml:769:35>>*/ state[16] = s;
    return 0;
    /*<<format.ml:769:57>>*/ }
   function pp_get_ellipsis_text(state, param){
     /*<<format.ml:770:36>>*/ return state[16];
    /*<<format.ml:770:53>>*/ }
   function pp_limit(n){
     /*<<format.ml:775:2>>*/ return n < 1000000010 ? n : 1000000009;
    /*<<format.ml:775:49>>*/ }
   function pp_set_max_indent(state, n$0){
     /*<<format.ml:791:2>>*/ var _aL_ = 1 < n$0 ? 1 : 0;
    if(! _aL_) return _aL_;
    var n$1 = state[6] - n$0 | 0, _aK_ = 1 <= n$1 ? 1 : 0;
    if(! _aK_) return _aK_;
     /*<<format.ml:781:12>>*/  /*<<format.ml:781:12>>*/ var n = pp_limit(n$1);
    state[7] = n;
    state[8] = state[6] - state[7] | 0;
     /*<<format.ml:784:4>>*/ return pp_rinit(state);
    /*<<format.ml:792:53>>*/ }
   function pp_get_max_indent(state, param){
     /*<<format.ml:795:33>>*/ return state[8];
    /*<<format.ml:795:52>>*/ }
   function pp_set_margin(state, n){
     /*<<format.ml:798:2>>*/ var _aI_ = 1 <= n ? 1 : 0;
    if(! _aI_) return _aI_;
     /*<<format.ml:799:12>>*/  /*<<format.ml:799:12>>*/ var n$0 = pp_limit(n);
    state[6] = n$0;
    if(state[8] <= state[6])
     var new_max_indent = state[8];
    else
      /*<<format.ml:808:15>>*/ var
       /*<<format.ml:808:15>>*/ _aJ_ =
         /*<<format.ml:808:15>>*/ caml_call2
         (Stdlib_Int[11], state[6] - state[7] | 0, state[6] / 2 | 0),
      new_max_indent =
         /*<<format.ml:808:7>>*/ caml_call2(Stdlib_Int[11], _aJ_, 1);
     /*<<format.ml:811:4>>*/ return pp_set_max_indent(state, new_max_indent);
    /*<<format.ml:811:42>>*/ }
   function validate_geometry(param){
    var margin = param[2], max_indent = param[1];
     /*<<format.ml:818:2>>*/ return 2 <= max_indent
            ? margin <= max_indent ? _c_ : _d_
            : _e_;
   }
   function check_geometry(geometry){
     /*<<format.ml:825:2>>*/ return 0 === validate_geometry(geometry)[0]
            ? 1
            : 0;
    /*<<format.ml:827:20>>*/ }
   function pp_get_margin(state, param){
     /*<<format.ml:829:29>>*/ return state[6];
    /*<<format.ml:829:44>>*/ }
   function pp_set_full_geometry(state, param){
    var margin = param[2], max_indent = param[1];
     /*<<format.ml:832:2>>*/ pp_set_margin(state, margin);
     /*<<format.ml:833:2>>*/ pp_set_max_indent(state, max_indent);
     /*<<format.ml:833:2>>*/ return 0;
   }
   function pp_set_geometry(state, max_indent, margin){
     /*<<format.ml:837:2>>*/ var
      /*<<format.ml:837:17>>*/ geometry = [0, max_indent, margin],
      /*<<format.ml:838:8>>*/ match = validate_geometry(geometry);
    if(0 === match[0])
      /*<<format.ml:842:4>>*/ return pp_set_full_geometry(state, geometry);
     /*<<format.ml:840:28>>*/ var
     msg = match[1],
      /*<<format.ml:840:28>>*/ _aH_ =
        /*<<format.ml:840:28>>*/ caml_call2
        (Stdlib[28], cst_Format_pp_set_geometry, msg);
     /*<<format.ml:840:4>>*/ throw  /*<<format.ml:840:4>>*/ caml_maybe_attach_backtrace
           ([0, Stdlib[6], _aH_], 1);
    /*<<format.ml:842:39>>*/ }
   function pp_safe_set_geometry(state, max_indent, margin){
     /*<<format.ml:845:2>>*/  /*<<format.ml:845:17>>*/ var
     geometry = [0, max_indent, margin];
    return 0 === validate_geometry(geometry)[0]
            ? pp_set_full_geometry(state, geometry)
            : 0;
    /*<<format.ml:850:39>>*/ }
   function pp_get_geometry(state, param){
     /*<<format.ml:853:2>>*/ return [0, state[8], state[6]];
    /*<<format.ml:853:78>>*/ }
   function pp_update_geometry(state, update){
     /*<<format.ml:856:2>>*/  /*<<format.ml:856:17>>*/ var
     geometry = pp_get_geometry(state, 0);
     /*<<format.ml:857:29>>*/ return pp_set_full_geometry
            (state,  /*<<format.ml:857:29>>*/ caml_call1(update, geometry));
    /*<<format.ml:857:46>>*/ }
   function pp_set_formatter_out_functions(state, param){
    var j = param[5], i = param[4], h = param[3], g = param[2], f = param[1];
    state[17] = f;
    state[18] = g;
    state[19] = h;
    state[20] = i;
    state[21] = j;
    return 0;
   }
   function pp_get_formatter_out_functions(state, param){
     /*<<format.ml:873:46>>*/ return [0,
            state[17],
            state[18],
            state[19],
            state[20],
            state[21]];
    /*<<format.ml:879:1>>*/ }
   function pp_set_formatter_output_functi(state, f, g){
     /*<<format.ml:884:2>>*/ state[17] = f;
    state[18] = g;
    return 0;
    /*<<format.ml:884:51>>*/ }
   function pp_get_formatter_output_functi(state, param){
     /*<<format.ml:887:2>>*/ return [0, state[17], state[18]];
    /*<<format.ml:887:43>>*/ }
   function display_newline(state, param){
     /*<<format.ml:891:31>>*/ return  /*<<format.ml:891:31>>*/ caml_call3
            (state[17], cst$7, 0, 1);
    /*<<format.ml:891:60>>*/ }
    /*<<format.ml:894:17>>*/ var
     /*<<format.ml:894:17>>*/ blank_line =
       /*<<format.ml:894:17>>*/ caml_call2(Stdlib_String[1], 80, 32),
    _f_ = [3, 0, 3];
   function display_blanks(state, n){
     /*<<format.ml:896:2>>*/ var n$0 = n;
     /*<<format.ml:896:2>>*/ for(;;){
     var _aG_ = 0 < n$0 ? 1 : 0;
     if(! _aG_) return _aG_;
     if(80 >= n$0)
       /*<<format.ml:897:18>>*/ return  /*<<format.ml:897:18>>*/ caml_call3
              (state[17], blank_line, 0, n$0);
      /*<<format.ml:899:4>>*/  /*<<format.ml:899:4>>*/ caml_call3
      (state[17], blank_line, 0, 80);
      /*<<format.ml:899:4>>*/ var
       /*<<format.ml:899:4>>*/ n$1 = n$0 - 80 | 0,
      n$0 = n$1;
    }
    /*<<format.ml:901:5>>*/ }
   function pp_set_formatter_out_channel(state, oc){
     /*<<format.ml:910:2>>*/ state[17] =
      /*<<format.ml:910:25>>*/ caml_call1(Stdlib[69], oc);
    state[18] =
     function(param){
       /*<<format.ml:911:35>>*/ return  /*<<format.ml:911:2>>*/ caml_call1
              (Stdlib[63], oc);
      /*<<format.ml:911:43>>*/ };
    state[19] =
     function(_aF_){ /*<<?>>*/ return display_newline(state, _aF_);};
    state[20] = function(_aE_){ /*<<?>>*/ return display_blanks(state, _aE_);};
    state[21] = function(_aD_){ /*<<?>>*/ return display_blanks(state, _aD_);};
    return 0;
    /*<<format.ml:914:45>>*/ }
   function default_pp_mark_open_tag(param){
     /*<<format.ml:922:31>>*/ if(param[1] !== String_tag)
      /*<<format.ml:924:9>>*/ return cst$10;
     /*<<format.ml:923:26>>*/ var
     s = param[2],
      /*<<format.ml:923:26>>*/ _aC_ =
        /*<<format.ml:923:26>>*/ caml_call2(Stdlib[28], s, cst$8);
     /*<<format.ml:923:26>>*/ return  /*<<format.ml:923:26>>*/ caml_call2
            (Stdlib[28], cst$9, _aC_);
    /*<<format.ml:924:11>>*/ }
   function default_pp_mark_close_tag(param){
     /*<<format.ml:925:32>>*/ if(param[1] !== String_tag)
      /*<<format.ml:927:9>>*/ return cst$13;
     /*<<format.ml:926:27>>*/ var
     s = param[2],
      /*<<format.ml:926:27>>*/ _aB_ =
        /*<<format.ml:926:27>>*/ caml_call2(Stdlib[28], s, cst$11);
     /*<<format.ml:926:27>>*/ return  /*<<format.ml:926:27>>*/ caml_call2
            (Stdlib[28], cst$12, _aB_);
    /*<<format.ml:927:11>>*/ }
   function default_pp_print_open_tag(_aA_){ /*<<?>>*/ return 0;}
   function default_pp_print_close_tag(_az_){ /*<<?>>*/ return 0;}
   function pp_make_formatter(f, g, h, i, j){
     /*<<format.ml:936:17>>*/ var
      /*<<format.ml:936:17>>*/ pp_queue =
        /*<<format.ml:936:17>>*/ caml_call1(Stdlib_Queue[2], 0),
      /*<<format.ml:938:4>>*/ sys_tok = [0, unknown, _f_, 0];
     /*<<format.ml:939:2>>*/  /*<<format.ml:939:2>>*/ caml_call2
     (Stdlib_Queue[3], sys_tok, pp_queue);
     /*<<format.ml:940:19>>*/  /*<<format.ml:940:19>>*/ var
     scan_stack =  /*<<format.ml:940:19>>*/ caml_call1(Stdlib_Stack[2], 0);
     /*<<format.ml:941:2>>*/ initialize_scan_stack(scan_stack);
     /*<<format.ml:942:2>>*/  /*<<format.ml:942:2>>*/ caml_call2
     (Stdlib_Stack[3], [0, 1, sys_tok], scan_stack);
     /*<<format.ml:942:2>>*/ var
      /*<<format.ml:942:2>>*/ pp_margin = 78,
     _av_ = Stdlib[19],
      /*<<format.ml:950:20>>*/ _aw_ =
        /*<<format.ml:950:20>>*/ caml_call1(Stdlib_Stack[2], 0),
      /*<<format.ml:949:19>>*/ _ax_ =
        /*<<format.ml:949:19>>*/ caml_call1(Stdlib_Stack[2], 0),
      /*<<format.ml:948:20>>*/ _ay_ =
        /*<<format.ml:948:20>>*/ caml_call1(Stdlib_Stack[2], 0);
     /*<<format.ml:945:2>>*/ return [0,
            scan_stack,
             /*<<format.ml:947:22>>*/ caml_call1(Stdlib_Stack[2], 0),
            _ay_,
            _ax_,
            _aw_,
            pp_margin,
            10,
            68,
            pp_margin,
            0,
            1,
            1,
            1,
            1,
            _av_,
            cst$14,
            f,
            g,
            h,
            i,
            j,
            0,
            0,
            default_pp_mark_open_tag,
            default_pp_mark_close_tag,
            default_pp_print_open_tag,
            default_pp_print_close_tag,
            pp_queue];
   }
   function formatter_of_out_functions(out_funs){
     /*<<format.ml:979:2>>*/ return pp_make_formatter
            (out_funs[1], out_funs[2], out_funs[3], out_funs[4], out_funs[5]);
    /*<<format.ml:984:23>>*/ }
   function make_formatter(output, flush){
     /*<<format.ml:990:2>>*/  /*<<format.ml:990:12>>*/ var
     ppf =
       pp_make_formatter
        (output,
         flush,
         function(_au_){ /*<<?>>*/ return 0;},
         function(_at_){ /*<<?>>*/ return 0;},
         function(_as_){ /*<<?>>*/ return 0;});
    ppf[19] = function(_ar_){ /*<<?>>*/ return display_newline(ppf, _ar_);};
    ppf[20] = function(_aq_){ /*<<?>>*/ return display_blanks(ppf, _aq_);};
    ppf[21] = function(_ap_){ /*<<?>>*/ return display_blanks(ppf, _ap_);};
     /*<<format.ml:994:2>>*/ return ppf;
    /*<<format.ml:994:5>>*/ }
   function formatter_of_out_channel(oc){
     /*<<format.ml:999:2>>*/ return make_formatter
            ( /*<<format.ml:999:17>>*/ caml_call1(Stdlib[69], oc),
             function(param){
               /*<<format.ml:999:50>>*/ return  /*<<format.ml:999:2>>*/ caml_call1
                      (Stdlib[63], oc);
              /*<<format.ml:999:58>>*/ });
    /*<<format.ml:999:59>>*/ }
   function formatter_of_buffer(b){
     /*<<format.ml:1004:2>>*/ return make_formatter
            ( /*<<format.ml:1004:17>>*/ caml_call1(Stdlib_Buffer[18], b),
             function(_ao_){ /*<<?>>*/ return 0;});
    /*<<format.ml:1004:48>>*/ }
   var pp_buffer_size = 512;
   function pp_make_buffer(param){
     /*<<format.ml:1011:24>>*/ return caml_call1
            (Stdlib_Buffer[1], pp_buffer_size);
    /*<<format.ml:1011:52>>*/ }
    /*<<format.ml:1014:13>>*/ var
     /*<<format.ml:1014:13>>*/ stdbuf = pp_make_buffer(0),
     /*<<format.ml:1018:20>>*/ std_formatter =
      formatter_of_out_channel(Stdlib[39]),
     /*<<format.ml:1019:20>>*/ err_formatter =
      formatter_of_out_channel(Stdlib[40]),
     /*<<format.ml:1020:20>>*/ str_formatter = formatter_of_buffer(stdbuf),
     /*<<format.ml:1025:17>>*/ stdbuf_key =
       /*<<format.ml:1025:17>>*/ caml_call2
       (Stdlib_Domain[10][1], 0, pp_make_buffer);
    /*<<format.ml:1026:8>>*/  /*<<format.ml:1026:8>>*/ caml_call2
    (Stdlib_Domain[10][3], stdbuf_key, stdbuf);
    /*<<format.ml:1028:24>>*/  /*<<format.ml:1028:24>>*/ var
    str_formatter_key =
       /*<<format.ml:1028:24>>*/ caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
          /*<<format.ml:1029:2>>*/ return formatter_of_buffer
                 ( /*<<format.ml:1029:22>>*/ caml_call1
                   (Stdlib_Domain[10][2], stdbuf_key));
         /*<<format.ml:1029:42>>*/ });
    /*<<format.ml:1030:8>>*/  /*<<format.ml:1030:8>>*/ caml_call2
    (Stdlib_Domain[10][3], str_formatter_key, str_formatter);
    /*<<format.ml:1030:8>>*/ function buffered_out_string(key, str, ofs, len){
     /*<<format.ml:1033:2>>*/  /*<<format.ml:1033:23>>*/ var
     _an_ =  /*<<format.ml:1033:23>>*/ caml_call1(Stdlib_Domain[10][2], key);
     /*<<format.ml:1033:2>>*/ return  /*<<format.ml:1033:2>>*/ caml_call4
            (Stdlib_Buffer[18], _an_, str, ofs, len);
    /*<<format.ml:1033:55>>*/ }
   function buffered_out_flush(oc, key, param){
     /*<<format.ml:1036:2>>*/ var
      /*<<format.ml:1036:12>>*/ buf =
        /*<<format.ml:1036:12>>*/ caml_call1(Stdlib_Domain[10][2], key),
      /*<<format.ml:1037:12>>*/ len =
        /*<<format.ml:1037:12>>*/ caml_call1(Stdlib_Buffer[7], buf),
      /*<<format.ml:1038:12>>*/ str =
        /*<<format.ml:1038:12>>*/ caml_call1(Stdlib_Buffer[2], buf);
     /*<<format.ml:1039:2>>*/  /*<<format.ml:1039:2>>*/ caml_call4
     (Stdlib[69], oc, str, 0, len);
     /*<<format.ml:1040:2>>*/  /*<<format.ml:1040:2>>*/ caml_call1
     (Stdlib[63], oc);
     /*<<format.ml:1040:2>>*/ return  /*<<format.ml:1040:2>>*/ caml_call1
            (Stdlib_Buffer[8], buf);
    /*<<format.ml:1041:18>>*/ }
    /*<<format.ml:1043:18>>*/ var
     /*<<format.ml:1043:18>>*/ std_buf_key =
       /*<<format.ml:1043:18>>*/ caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
          /*<<format.ml:1043:48>>*/ return caml_call1
                 (Stdlib_Buffer[1], pp_buffer_size);
         /*<<format.ml:1043:76>>*/ }),
     /*<<format.ml:1044:18>>*/ err_buf_key =
       /*<<format.ml:1044:18>>*/ caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
          /*<<format.ml:1044:48>>*/ return  /*<<format.ml:1043:18>>*/ caml_call1
                 (Stdlib_Buffer[1], pp_buffer_size);
         /*<<format.ml:1044:76>>*/ }),
     /*<<format.ml:1046:24>>*/ std_formatter_key =
       /*<<format.ml:1046:24>>*/ caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
          /*<<format.ml:1047:2>>*/ var
          _ab_ = Stdlib[39],
           /*<<format.ml:1048:4>>*/ ppf =
            pp_make_formatter
             (function(_ak_, _al_, _am_){
                /*<<?>>*/ return buffered_out_string
                       (std_buf_key, _ak_, _al_, _am_);
              },
              function(_aj_){
                /*<<?>>*/ return buffered_out_flush(_ab_, std_buf_key, _aj_);
              },
              function(_ai_){ /*<<?>>*/ return 0;},
              function(_ah_){ /*<<?>>*/ return 0;},
              function(_ag_){ /*<<?>>*/ return 0;});
         ppf[19] =
          function(_af_){ /*<<?>>*/ return display_newline(ppf, _af_);};
         ppf[20] =
          function(_ae_){ /*<<?>>*/ return display_blanks(ppf, _ae_);};
         ppf[21] =
          function(_ad_){ /*<<?>>*/ return display_blanks(ppf, _ad_);};
          /*<<format.ml:1054:2>>*/  /*<<format.ml:1054:2>>*/ caml_call1
          (Stdlib_Domain[6],
           function(_ac_){ /*<<?>>*/ return pp_print_flush(ppf, _ac_);});
          /*<<format.ml:1054:2>>*/ return ppf;
         /*<<format.ml:1055:5>>*/ });
    /*<<format.ml:1056:8>>*/  /*<<format.ml:1056:8>>*/ caml_call2
    (Stdlib_Domain[10][3], std_formatter_key, std_formatter);
    /*<<format.ml:1058:24>>*/  /*<<format.ml:1058:24>>*/ var
    err_formatter_key =
       /*<<format.ml:1058:24>>*/ caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
          /*<<format.ml:1059:2>>*/ var
          _R_ = Stdlib[40],
           /*<<format.ml:1060:4>>*/ ppf =
            pp_make_formatter
             (function(___, _$_, _aa_){
                /*<<?>>*/ return buffered_out_string
                       (err_buf_key, ___, _$_, _aa_);
              },
              function(_Z_){
                /*<<?>>*/ return buffered_out_flush(_R_, err_buf_key, _Z_);
              },
              function(_Y_){ /*<<?>>*/ return 0;},
              function(_X_){ /*<<?>>*/ return 0;},
              function(_W_){ /*<<?>>*/ return 0;});
         ppf[19] = function(_V_){ /*<<?>>*/ return display_newline(ppf, _V_);};
         ppf[20] = function(_U_){ /*<<?>>*/ return display_blanks(ppf, _U_);};
         ppf[21] = function(_T_){ /*<<?>>*/ return display_blanks(ppf, _T_);};
          /*<<format.ml:1066:2>>*/  /*<<format.ml:1066:2>>*/ caml_call1
          (Stdlib_Domain[6],
           function(_S_){ /*<<?>>*/ return pp_print_flush(ppf, _S_);});
          /*<<format.ml:1066:2>>*/ return ppf;
         /*<<format.ml:1067:5>>*/ });
    /*<<format.ml:1068:8>>*/  /*<<format.ml:1068:8>>*/ caml_call2
    (Stdlib_Domain[10][3], err_formatter_key, err_formatter);
   function get_std_formatter(param){
     /*<<format.ml:1070:27>>*/ return  /*<<format.ml:1068:8>>*/ caml_call1
            (Stdlib_Domain[10][2], std_formatter_key);
    /*<<format.ml:1070:52>>*/ }
   function get_err_formatter(param){
     /*<<format.ml:1071:27>>*/ return caml_call1
            (Stdlib_Domain[10][2], err_formatter_key);
    /*<<format.ml:1071:52>>*/ }
   function get_str_formatter(param){
     /*<<format.ml:1072:27>>*/ return caml_call1
            (Stdlib_Domain[10][2], str_formatter_key);
    /*<<format.ml:1072:52>>*/ }
   function get_stdbuf(param){
     /*<<format.ml:1073:20>>*/ return caml_call1
            (Stdlib_Domain[10][2], stdbuf_key);
    /*<<format.ml:1073:38>>*/ }
   function flush_buffer_formatter(buf, ppf){
     /*<<format.ml:1080:2>>*/ pp_flush_queue(ppf, 0);
     /*<<format.ml:1081:10>>*/  /*<<format.ml:1081:10>>*/ var
     s =  /*<<format.ml:1081:10>>*/ caml_call1(Stdlib_Buffer[2], buf);
     /*<<format.ml:1082:2>>*/  /*<<format.ml:1082:2>>*/ caml_call1
     (Stdlib_Buffer[9], buf);
     /*<<format.ml:1082:2>>*/ return s;
    /*<<format.ml:1083:3>>*/ }
   function flush_str_formatter(param){
     /*<<format.ml:1087:2>>*/ var
      /*<<format.ml:1087:15>>*/ stdbuf =
        /*<<format.ml:1087:15>>*/ caml_call1(Stdlib_Domain[10][2], stdbuf_key),
      /*<<format.ml:1088:22>>*/ str_formatter =
        /*<<format.ml:1088:22>>*/ caml_call1
        (Stdlib_Domain[10][2], str_formatter_key);
     /*<<format.ml:1089:2>>*/ return flush_buffer_formatter
            (stdbuf, str_formatter);
    /*<<format.ml:1089:45>>*/ }
   function make_synchronized_formatter(output, flush){
     /*<<format.ml:1092:2>>*/ return  /*<<format.ml:1092:14>>*/ caml_call2
            (Stdlib_Domain[10][1],
             0,
             function(param){
               /*<<format.ml:1093:4>>*/ var
                /*<<format.ml:1093:14>>*/ buf =
                  /*<<format.ml:1093:14>>*/ caml_call1
                  (Stdlib_Buffer[1], pp_buffer_size),
                /*<<format.ml:1094:18>>*/ output$0 =
                  /*<<format.ml:1094:18>>*/ caml_call1(Stdlib_Buffer[18], buf);
              function flush$0(param){
                /*<<format.ml:1096:6>>*/  /*<<format.ml:1096:37>>*/ var
                _Q_ =
                   /*<<format.ml:1096:37>>*/ caml_call1(Stdlib_Buffer[7], buf);
                /*<<format.ml:1096:6>>*/  /*<<format.ml:1096:6>>*/ caml_call3
                (output,
                  /*<<format.ml:1096:13>>*/ caml_call1(Stdlib_Buffer[2], buf),
                 0,
                 _Q_);
                /*<<format.ml:1097:6>>*/  /*<<format.ml:1097:6>>*/ caml_call1
                (Stdlib_Buffer[8], buf);
                /*<<format.ml:1097:6>>*/ return  /*<<format.ml:1097:6>>*/ caml_call1
                       (flush, 0);
               /*<<format.ml:1098:14>>*/ }
               /*<<format.ml:1100:4>>*/ return make_formatter
                      (output$0, flush$0);
              /*<<format.ml:1100:33>>*/ });
    /*<<format.ml:1100:34>>*/ }
   function synchronized_formatter_of_out_(oc){
     /*<<format.ml:1103:2>>*/ return make_synchronized_formatter
            ( /*<<format.ml:1103:30>>*/ caml_call1(Stdlib[69], oc),
             function(param){
               /*<<format.ml:1103:63>>*/ return  /*<<format.ml:1103:2>>*/ caml_call1
                      (Stdlib[63], oc);
              /*<<format.ml:1103:71>>*/ });
    /*<<format.ml:1103:72>>*/ }
   function make_symbolic_output_buffer(param){ /*<<format.ml:1130:2>>*/ return [0, 0];
    /*<<format.ml:1130:35>>*/ }
   function clear_symbolic_output_buffer(sob){
     /*<<format.ml:1133:2>>*/ sob[1] = 0;
    return 0;
    /*<<format.ml:1133:36>>*/ }
   function get_symbolic_output_buffer(sob){
     /*<<format.ml:1136:2>>*/ return caml_call1(Stdlib_List[10], sob[1]);
    /*<<format.ml:1136:39>>*/ }
   function flush_symbolic_output_buffer(sob){
     /*<<format.ml:1139:2>>*/  /*<<format.ml:1139:14>>*/ var
     items = get_symbolic_output_buffer(sob);
     /*<<format.ml:1140:2>>*/ clear_symbolic_output_buffer(sob);
     /*<<format.ml:1140:2>>*/ return items;
    /*<<format.ml:1141:7>>*/ }
   function add_symbolic_output_item(sob, item){
     /*<<format.ml:1144:2>>*/ sob[1] = [0, item, sob[1]];
    return 0;
    /*<<format.ml:1144:70>>*/ }
   function formatter_of_symbolic_output_b(sob){
     /*<<format.ml:1158:10>>*/ function f(s, i, n){
      /*<<format.ml:1152:33>>*/ return add_symbolic_output_item
             (sob,
              [0,
                /*<<format.ml:1152:48>>*/ caml_call3
                (Stdlib_String[16], s, i, n)]);
    }
     /*<<format.ml:1159:10>>*/ function g(_P_){
      /*<<format.ml:1148:4>>*/ return add_symbolic_output_item(sob, 0);
    }
     /*<<format.ml:1160:10>>*/ function h(_O_){
      /*<<format.ml:1150:4>>*/ return add_symbolic_output_item(sob, 1);
    }
     /*<<format.ml:1161:10>>*/ function i(n){
      /*<<format.ml:1154:33>>*/ return add_symbolic_output_item(sob, [1, n]);
    }
     /*<<format.ml:1162:10>>*/ function j(n){
      /*<<format.ml:1156:33>>*/ return add_symbolic_output_item(sob, [2, n]);
    }
     /*<<format.ml:1163:2>>*/ return pp_make_formatter(f, g, h, i, j);
    /*<<format.ml:1163:29>>*/ }
   function open_hbox(v){
     /*<<format.ml:1172:18>>*/ return pp_open_hbox
            ( /*<<format.ml:1172:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1172:60>>*/ }
   function open_vbox(v){
     /*<<format.ml:1173:18>>*/ return pp_open_vbox
            ( /*<<format.ml:1173:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1173:60>>*/ }
   function open_hvbox(v){
     /*<<format.ml:1174:19>>*/ return pp_open_hvbox
            ( /*<<format.ml:1174:33>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1174:62>>*/ }
   function open_hovbox(v){
     /*<<format.ml:1175:20>>*/ return pp_open_hovbox
            ( /*<<format.ml:1175:35>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1175:64>>*/ }
   function open_box(v){
     /*<<format.ml:1176:17>>*/ return pp_open_box
            ( /*<<format.ml:1176:29>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1176:58>>*/ }
   function close_box(v){
     /*<<format.ml:1177:18>>*/ return pp_close_box
            ( /*<<format.ml:1177:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1177:60>>*/ }
   function open_stag(v){
     /*<<format.ml:1178:18>>*/ return pp_open_stag
            ( /*<<format.ml:1178:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1178:60>>*/ }
   function close_stag(v){
     /*<<format.ml:1179:19>>*/ return pp_close_stag
            ( /*<<format.ml:1179:33>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1179:62>>*/ }
   function print_as(v, w){
     /*<<format.ml:1180:19>>*/ return pp_print_as
            ( /*<<format.ml:1180:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v,
             w);
    /*<<format.ml:1180:62>>*/ }
   function print_string(v){
     /*<<format.ml:1181:21>>*/ return pp_print_string
            ( /*<<format.ml:1181:37>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1181:66>>*/ }
   function print_bytes(v){
     /*<<format.ml:1182:20>>*/ return pp_print_bytes
            ( /*<<format.ml:1182:35>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1182:64>>*/ }
   function print_int(v){
     /*<<format.ml:1183:18>>*/ return pp_print_int
            ( /*<<format.ml:1183:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1183:60>>*/ }
   function print_float(v){
     /*<<format.ml:1184:20>>*/ return pp_print_float
            ( /*<<format.ml:1184:35>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1184:64>>*/ }
   function print_char(v){
     /*<<format.ml:1185:19>>*/ return pp_print_char
            ( /*<<format.ml:1185:33>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1185:62>>*/ }
   function print_bool(v){
     /*<<format.ml:1186:19>>*/ return pp_print_bool
            ( /*<<format.ml:1186:33>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1186:62>>*/ }
   function print_break(v, w){
     /*<<format.ml:1187:22>>*/ return pp_print_break
            ( /*<<format.ml:1187:37>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v,
             w);
    /*<<format.ml:1187:68>>*/ }
   function print_cut(v){
     /*<<format.ml:1188:18>>*/ return pp_print_cut
            ( /*<<format.ml:1188:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1188:60>>*/ }
   function print_space(v){
     /*<<format.ml:1189:20>>*/ return pp_print_space
            ( /*<<format.ml:1189:35>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1189:64>>*/ }
   function force_newline(v){
     /*<<format.ml:1190:22>>*/ return pp_force_newline
            ( /*<<format.ml:1190:39>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1190:68>>*/ }
   function print_flush(v){
     /*<<format.ml:1191:20>>*/ return pp_print_flush
            ( /*<<format.ml:1191:35>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1191:64>>*/ }
   function print_newline(v){
     /*<<format.ml:1192:22>>*/ return pp_print_newline
            ( /*<<format.ml:1192:39>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1192:68>>*/ }
   function print_if_newline(v){
     /*<<format.ml:1193:25>>*/ return pp_print_if_newline
            ( /*<<format.ml:1193:45>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1193:74>>*/ }
   function open_tbox(v){
     /*<<format.ml:1195:18>>*/ return pp_open_tbox
            ( /*<<format.ml:1195:31>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1195:60>>*/ }
   function close_tbox(v){
     /*<<format.ml:1196:19>>*/ return pp_close_tbox
            ( /*<<format.ml:1196:33>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1196:62>>*/ }
   function print_tbreak(v, w){
     /*<<format.ml:1197:23>>*/ return pp_print_tbreak
            ( /*<<format.ml:1197:39>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v,
             w);
    /*<<format.ml:1197:70>>*/ }
   function set_tab(v){
     /*<<format.ml:1199:16>>*/ return pp_set_tab
            ( /*<<format.ml:1199:27>>*/ caml_call1
              (Stdlib_Domain[10][2], std_formatter_key),
             v);
    /*<<format.ml:1199:56>>*/ }
   function print_tab(v){
     /*<<format.ml:1200:18>>*/ return pp_prin