module Test.Vectors.Chacha20Poly1305

module B = LowStar.Buffer

#set-options "--max_fuel 0 --max_ifuel 0"

let key0: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x1cuy; 0x92uy; 0x40uy; 0xa5uy; 0xebuy; 0x55uy; 0xd3uy; 0x8auy; 0xf3uy; 0x33uy; 0x88uy; 0x86uy; 0x04uy; 0xf6uy; 0xb5uy; 0xf0uy; 0x47uy; 0x39uy; 0x17uy; 0xc1uy; 0x40uy; 0x2buy; 0x80uy; 0x09uy; 0x9duy; 0xcauy; 0x5cuy; 0xbcuy; 0x20uy; 0x70uy; 0x75uy; 0xc0uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key0_len: (x:UInt32.t { UInt32.v x = B.length key0 }) =
  32ul

let nonce0: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x01uy; 0x02uy; 0x03uy; 0x04uy; 0x05uy; 0x06uy; 0x07uy; 0x08uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce0_len: (x:UInt32.t { UInt32.v x = B.length nonce0 }) =
  12ul

let aad0: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf3uy; 0x33uy; 0x88uy; 0x86uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x4euy; 0x91uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad0_len: (x:UInt32.t { UInt32.v x = B.length aad0 }) =
  12ul

let input0: (b: B.buffer UInt8.t { B.length b = 265 /\ B.recallable b /\ B.disjoint b aad0 }) =
     B.recall aad0;[@inline_let] let l = [ 0x49uy; 0x6euy; 0x74uy; 0x65uy; 0x72uy; 0x6euy; 0x65uy; 0x74uy; 0x2duy; 0x44uy; 0x72uy; 0x61uy; 0x66uy; 0x74uy; 0x73uy; 0x20uy; 0x61uy; 0x72uy; 0x65uy; 0x20uy; 0x64uy; 0x72uy; 0x61uy; 0x66uy; 0x74uy; 0x20uy; 0x64uy; 0x6fuy; 0x63uy; 0x75uy; 0x6duy; 0x65uy; 0x6euy; 0x74uy; 0x73uy; 0x20uy; 0x76uy; 0x61uy; 0x6cuy; 0x69uy; 0x64uy; 0x20uy; 0x66uy; 0x6fuy; 0x72uy; 0x20uy; 0x61uy; 0x20uy; 0x6duy; 0x61uy; 0x78uy; 0x69uy; 0x6duy; 0x75uy; 0x6duy; 0x20uy; 0x6fuy; 0x66uy; 0x20uy; 0x73uy; 0x69uy; 0x78uy; 0x20uy; 0x6duy; 0x6fuy; 0x6euy; 0x74uy; 0x68uy; 0x73uy; 0x20uy; 0x61uy; 0x6euy; 0x64uy; 0x20uy; 0x6duy; 0x61uy; 0x79uy; 0x20uy; 0x62uy; 0x65uy; 0x20uy; 0x75uy; 0x70uy; 0x64uy; 0x61uy; 0x74uy; 0x65uy; 0x64uy; 0x2cuy; 0x20uy; 0x72uy; 0x65uy; 0x70uy; 0x6cuy; 0x61uy; 0x63uy; 0x65uy; 0x64uy; 0x2cuy; 0x20uy; 0x6fuy; 0x72uy; 0x20uy; 0x6fuy; 0x62uy; 0x73uy; 0x6fuy; 0x6cuy; 0x65uy; 0x74uy; 0x65uy; 0x64uy; 0x20uy; 0x62uy; 0x79uy; 0x20uy; 0x6fuy; 0x74uy; 0x68uy; 0x65uy; 0x72uy; 0x20uy; 0x64uy; 0x6fuy; 0x63uy; 0x75uy; 0x6duy; 0x65uy; 0x6euy; 0x74uy; 0x73uy; 0x20uy; 0x61uy; 0x74uy; 0x20uy; 0x61uy; 0x6euy; 0x79uy; 0x20uy; 0x74uy; 0x69uy; 0x6duy; 0x65uy; 0x2euy; 0x20uy; 0x49uy; 0x74uy; 0x20uy; 0x69uy; 0x73uy; 0x20uy; 0x69uy; 0x6euy; 0x61uy; 0x70uy; 0x70uy; 0x72uy; 0x6fuy; 0x70uy; 0x72uy; 0x69uy; 0x61uy; 0x74uy; 0x65uy; 0x20uy; 0x74uy; 0x6fuy; 0x20uy; 0x75uy; 0x73uy; 0x65uy; 0x20uy; 0x49uy; 0x6euy; 0x74uy; 0x65uy; 0x72uy; 0x6euy; 0x65uy; 0x74uy; 0x2duy; 0x44uy; 0x72uy; 0x61uy; 0x66uy; 0x74uy; 0x73uy; 0x20uy; 0x61uy; 0x73uy; 0x20uy; 0x72uy; 0x65uy; 0x66uy; 0x65uy; 0x72uy; 0x65uy; 0x6euy; 0x63uy; 0x65uy; 0x20uy; 0x6duy; 0x61uy; 0x74uy; 0x65uy; 0x72uy; 0x69uy; 0x61uy; 0x6cuy; 0x20uy; 0x6fuy; 0x72uy; 0x20uy; 0x74uy; 0x6fuy; 0x20uy; 0x63uy; 0x69uy; 0x74uy; 0x65uy; 0x20uy; 0x74uy; 0x68uy; 0x65uy; 0x6duy; 0x20uy; 0x6fuy; 0x74uy; 0x68uy; 0x65uy; 0x72uy; 0x20uy; 0x74uy; 0x68uy; 0x61uy; 0x6euy; 0x20uy; 0x61uy; 0x73uy; 0x20uy; 0x2fuy; 0xe2uy; 0x80uy; 0x9cuy; 0x77uy; 0x6fuy; 0x72uy; 0x6buy; 0x20uy; 0x69uy; 0x6euy; 0x20uy; 0x70uy; 0x72uy; 0x6fuy; 0x67uy; 0x72uy; 0x65uy; 0x73uy; 0x73uy; 0x2euy; 0x2fuy; 0xe2uy; 0x80uy; 0x9duy; ] in
  assert_norm (List.Tot.length l = 265);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input0_len: (x:UInt32.t { UInt32.v x = B.length input0 }) =
  265ul

let output0: (b: B.buffer UInt8.t { B.length b = 281 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x64uy; 0xa0uy; 0x86uy; 0x15uy; 0x75uy; 0x86uy; 0x1auy; 0xf4uy; 0x60uy; 0xf0uy; 0x62uy; 0xc7uy; 0x9buy; 0xe6uy; 0x43uy; 0xbduy; 0x5euy; 0x80uy; 0x5cuy; 0xfduy; 0x34uy; 0x5cuy; 0xf3uy; 0x89uy; 0xf1uy; 0x08uy; 0x67uy; 0x0auy; 0xc7uy; 0x6cuy; 0x8cuy; 0xb2uy; 0x4cuy; 0x6cuy; 0xfcuy; 0x18uy; 0x75uy; 0x5duy; 0x43uy; 0xeeuy; 0xa0uy; 0x9euy; 0xe9uy; 0x4euy; 0x38uy; 0x2duy; 0x26uy; 0xb0uy; 0xbduy; 0xb7uy; 0xb7uy; 0x3cuy; 0x32uy; 0x1buy; 0x01uy; 0x00uy; 0xd4uy; 0xf0uy; 0x3buy; 0x7fuy; 0x35uy; 0x58uy; 0x94uy; 0xcfuy; 0x33uy; 0x2fuy; 0x83uy; 0x0euy; 0x71uy; 0x0buy; 0x97uy; 0xceuy; 0x98uy; 0xc8uy; 0xa8uy; 0x4auy; 0xbduy; 0x0buy; 0x94uy; 0x81uy; 0x14uy; 0xaduy; 0x17uy; 0x6euy; 0x00uy; 0x8duy; 0x33uy; 0xbduy; 0x60uy; 0xf9uy; 0x82uy; 0xb1uy; 0xffuy; 0x37uy; 0xc8uy; 0x55uy; 0x97uy; 0x97uy; 0xa0uy; 0x6euy; 0xf4uy; 0xf0uy; 0xefuy; 0x61uy; 0xc1uy; 0x86uy; 0x32uy; 0x4euy; 0x2buy; 0x35uy; 0x06uy; 0x38uy; 0x36uy; 0x06uy; 0x90uy; 0x7buy; 0x6auy; 0x7cuy; 0x02uy; 0xb0uy; 0xf9uy; 0xf6uy; 0x15uy; 0x7buy; 0x53uy; 0xc8uy; 0x67uy; 0xe4uy; 0xb9uy; 0x16uy; 0x6cuy; 0x76uy; 0x7buy; 0x80uy; 0x4duy; 0x46uy; 0xa5uy; 0x9buy; 0x52uy; 0x16uy; 0xcduy; 0xe7uy; 0xa4uy; 0xe9uy; 0x90uy; 0x40uy; 0xc5uy; 0xa4uy; 0x04uy; 0x33uy; 0x22uy; 0x5euy; 0xe2uy; 0x82uy; 0xa1uy; 0xb0uy; 0xa0uy; 0x6cuy; 0x52uy; 0x3euy; 0xafuy; 0x45uy; 0x34uy; 0xd7uy; 0xf8uy; 0x3fuy; 0xa1uy; 0x15uy; 0x5buy; 0x00uy; 0x47uy; 0x71uy; 0x8cuy; 0xbcuy; 0x54uy; 0x6auy; 0x0duy; 0x07uy; 0x2buy; 0x04uy; 0xb3uy; 0x56uy; 0x4euy; 0xeauy; 0x1buy; 0x42uy; 0x22uy; 0x73uy; 0xf5uy; 0x48uy; 0x27uy; 0x1auy; 0x0buy; 0xb2uy; 0x31uy; 0x60uy; 0x53uy; 0xfauy; 0x76uy; 0x99uy; 0x19uy; 0x55uy; 0xebuy; 0xd6uy; 0x31uy; 0x59uy; 0x43uy; 0x4euy; 0xceuy; 0xbbuy; 0x4euy; 0x46uy; 0x6duy; 0xaeuy; 0x5auy; 0x10uy; 0x73uy; 0xa6uy; 0x72uy; 0x76uy; 0x27uy; 0x09uy; 0x7auy; 0x10uy; 0x49uy; 0xe6uy; 0x17uy; 0xd9uy; 0x1duy; 0x36uy; 0x10uy; 0x94uy; 0xfauy; 0x68uy; 0xf0uy; 0xffuy; 0x77uy; 0x98uy; 0x71uy; 0x30uy; 0x30uy; 0x5buy; 0xeauy; 0xbauy; 0x2euy; 0xdauy; 0x04uy; 0xdfuy; 0x99uy; 0x7buy; 0x71uy; 0x4duy; 0x6cuy; 0x6fuy; 0x2cuy; 0x29uy; 0xa6uy; 0xaduy; 0x5cuy; 0xb4uy; 0x02uy; 0x2buy; 0x02uy; 0x70uy; 0x9buy; 0xeeuy; 0xaduy; 0x9duy; 0x67uy; 0x89uy; 0x0cuy; 0xbbuy; 0x22uy; 0x39uy; 0x23uy; 0x36uy; 0xfeuy; 0xa1uy; 0x85uy; 0x1fuy; 0x38uy; ] in
  assert_norm (List.Tot.length l = 281);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output0_len: (x:UInt32.t { UInt32.v x = B.length output0 }) =
  281ul

let key1: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x4cuy; 0xf5uy; 0x96uy; 0x83uy; 0x38uy; 0xe6uy; 0xaeuy; 0x7fuy; 0x2duy; 0x29uy; 0x25uy; 0x76uy; 0xd5uy; 0x75uy; 0x27uy; 0x86uy; 0x91uy; 0x9auy; 0x27uy; 0x7auy; 0xfbuy; 0x46uy; 0xc5uy; 0xefuy; 0x94uy; 0x81uy; 0x79uy; 0x57uy; 0x14uy; 0x59uy; 0x40uy; 0x68uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key1_len: (x:UInt32.t { UInt32.v x = B.length key1 }) =
  32ul

let nonce1: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xcauy; 0xbfuy; 0x33uy; 0x71uy; 0x32uy; 0x45uy; 0x77uy; 0x8euy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce1_len: (x:UInt32.t { UInt32.v x = B.length nonce1 }) =
  12ul

let aad1: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad1_len: (x:UInt32.t { UInt32.v x = B.length aad1 }) =
  0ul

let input1: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b /\ B.disjoint b aad1 }) =
     B.recall aad1;[@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input1_len: (x:UInt32.t { UInt32.v x = B.length input1 }) =
  0ul

let output1: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xeauy; 0xe0uy; 0x1euy; 0x9euy; 0x2cuy; 0x91uy; 0xaauy; 0xe1uy; 0xdbuy; 0x5duy; 0x99uy; 0x3fuy; 0x8auy; 0xf7uy; 0x69uy; 0x92uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output1_len: (x:UInt32.t { UInt32.v x = B.length output1 }) =
  16ul

let key2: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x2duy; 0xb0uy; 0x5duy; 0x40uy; 0xc8uy; 0xeduy; 0x44uy; 0x88uy; 0x34uy; 0xd1uy; 0x13uy; 0xafuy; 0x57uy; 0xa1uy; 0xebuy; 0x3auy; 0x2auy; 0x80uy; 0x51uy; 0x36uy; 0xecuy; 0x5buy; 0xbcuy; 0x08uy; 0x93uy; 0x84uy; 0x21uy; 0xb5uy; 0x13uy; 0x88uy; 0x3cuy; 0x0duy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key2_len: (x:UInt32.t { UInt32.v x = B.length key2 }) =
  32ul

let nonce2: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x3duy; 0x86uy; 0xb5uy; 0x6buy; 0xc8uy; 0xa3uy; 0x1fuy; 0x1duy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce2_len: (x:UInt32.t { UInt32.v x = B.length nonce2 }) =
  12ul

let aad2: (b: B.buffer UInt8.t { B.length b = 8 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x33uy; 0x10uy; 0x41uy; 0x12uy; 0x1fuy; 0xf3uy; 0xd2uy; 0x6buy; ] in
  assert_norm (List.Tot.length l = 8);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad2_len: (x:UInt32.t { UInt32.v x = B.length aad2 }) =
  8ul

let input2: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b /\ B.disjoint b aad2 }) =
     B.recall aad2;[@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input2_len: (x:UInt32.t { UInt32.v x = B.length input2 }) =
  0ul

let output2: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xdduy; 0x6buy; 0x3buy; 0x82uy; 0xceuy; 0x5auy; 0xbduy; 0xd6uy; 0xa9uy; 0x35uy; 0x83uy; 0xd8uy; 0x8cuy; 0x3duy; 0x85uy; 0x77uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output2_len: (x:UInt32.t { UInt32.v x = B.length output2 }) =
  16ul

let key3: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x4buy; 0x28uy; 0x4buy; 0xa3uy; 0x7buy; 0xbeuy; 0xe9uy; 0xf8uy; 0x31uy; 0x80uy; 0x82uy; 0xd7uy; 0xd8uy; 0xe8uy; 0xb5uy; 0xa1uy; 0xe2uy; 0x18uy; 0x18uy; 0x8auy; 0x9cuy; 0xfauy; 0xa3uy; 0x3duy; 0x25uy; 0x71uy; 0x3euy; 0x40uy; 0xbcuy; 0x54uy; 0x7auy; 0x3euy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key3_len: (x:UInt32.t { UInt32.v x = B.length key3 }) =
  32ul

let nonce3: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xd2uy; 0x32uy; 0x1fuy; 0x29uy; 0x28uy; 0xc6uy; 0xc4uy; 0xc4uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce3_len: (x:UInt32.t { UInt32.v x = B.length nonce3 }) =
  12ul

let aad3: (b: B.buffer UInt8.t { B.length b = 8 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x6auy; 0xe2uy; 0xaduy; 0x3fuy; 0x88uy; 0x39uy; 0x5auy; 0x40uy; ] in
  assert_norm (List.Tot.length l = 8);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad3_len: (x:UInt32.t { UInt32.v x = B.length aad3 }) =
  8ul

let input3: (b: B.buffer UInt8.t { B.length b = 1 /\ B.recallable b /\ B.disjoint b aad3 }) =
     B.recall aad3;[@inline_let] let l = [ 0xa4uy; ] in
  assert_norm (List.Tot.length l = 1);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input3_len: (x:UInt32.t { UInt32.v x = B.length input3 }) =
  1ul

let output3: (b: B.buffer UInt8.t { B.length b = 17 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xb7uy; 0x1buy; 0xb0uy; 0x73uy; 0x59uy; 0xb0uy; 0x84uy; 0xb2uy; 0x6duy; 0x8euy; 0xabuy; 0x94uy; 0x31uy; 0xa1uy; 0xaeuy; 0xacuy; 0x89uy; ] in
  assert_norm (List.Tot.length l = 17);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output3_len: (x:UInt32.t { UInt32.v x = B.length output3 }) =
  17ul

let key4: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x66uy; 0xcauy; 0x9cuy; 0x23uy; 0x2auy; 0x4buy; 0x4buy; 0x31uy; 0x0euy; 0x92uy; 0x89uy; 0x8buy; 0xf4uy; 0x93uy; 0xc7uy; 0x87uy; 0x98uy; 0xa3uy; 0xd8uy; 0x39uy; 0xf8uy; 0xf4uy; 0xa7uy; 0x01uy; 0xc0uy; 0x2euy; 0x0auy; 0xa6uy; 0x7euy; 0x5auy; 0x78uy; 0x87uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key4_len: (x:UInt32.t { UInt32.v x = B.length key4 }) =
  32ul

let nonce4: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x20uy; 0x1cuy; 0xaauy; 0x5fuy; 0x9cuy; 0xbfuy; 0x92uy; 0x30uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce4_len: (x:UInt32.t { UInt32.v x = B.length nonce4 }) =
  12ul

let aad4: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad4_len: (x:UInt32.t { UInt32.v x = B.length aad4 }) =
  0ul

let input4: (b: B.buffer UInt8.t { B.length b = 1 /\ B.recallable b /\ B.disjoint b aad4 }) =
     B.recall aad4;[@inline_let] let l = [ 0x2duy; ] in
  assert_norm (List.Tot.length l = 1);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input4_len: (x:UInt32.t { UInt32.v x = B.length input4 }) =
  1ul

let output4: (b: B.buffer UInt8.t { B.length b = 17 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xbfuy; 0xe1uy; 0x5buy; 0x0buy; 0xdbuy; 0x6buy; 0xf5uy; 0x5euy; 0x6cuy; 0x5duy; 0x84uy; 0x44uy; 0x39uy; 0x81uy; 0xc1uy; 0x9cuy; 0xacuy; ] in
  assert_norm (List.Tot.length l = 17);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output4_len: (x:UInt32.t { UInt32.v x = B.length output4 }) =
  17ul

let key5: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x68uy; 0x7buy; 0x8duy; 0x8euy; 0xe3uy; 0xc4uy; 0xdduy; 0xaeuy; 0xdfuy; 0x72uy; 0x7fuy; 0x53uy; 0x72uy; 0x25uy; 0x1euy; 0x78uy; 0x91uy; 0xcbuy; 0x69uy; 0x76uy; 0x1fuy; 0x49uy; 0x93uy; 0xf9uy; 0x6fuy; 0x21uy; 0xccuy; 0x39uy; 0x9cuy; 0xaduy; 0xb1uy; 0x01uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key5_len: (x:UInt32.t { UInt32.v x = B.length key5 }) =
  32ul

let nonce5: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xdfuy; 0x51uy; 0x84uy; 0x82uy; 0x42uy; 0x0cuy; 0x75uy; 0x9cuy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce5_len: (x:UInt32.t { UInt32.v x = B.length nonce5 }) =
  12ul

let aad5: (b: B.buffer UInt8.t { B.length b = 7 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x70uy; 0xd3uy; 0x33uy; 0xf3uy; 0x8buy; 0x18uy; 0x0buy; ] in
  assert_norm (List.Tot.length l = 7);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad5_len: (x:UInt32.t { UInt32.v x = B.length aad5 }) =
  7ul

let input5: (b: B.buffer UInt8.t { B.length b = 129 /\ B.recallable b /\ B.disjoint b aad5 }) =
     B.recall aad5;[@inline_let] let l = [ 0x33uy; 0x2fuy; 0x94uy; 0xc1uy; 0xa4uy; 0xefuy; 0xccuy; 0x2auy; 0x5buy; 0xa6uy; 0xe5uy; 0x8fuy; 0x1duy; 0x40uy; 0xf0uy; 0x92uy; 0x3cuy; 0xd9uy; 0x24uy; 0x11uy; 0xa9uy; 0x71uy; 0xf9uy; 0x37uy; 0x14uy; 0x99uy; 0xfauy; 0xbeuy; 0xe6uy; 0x80uy; 0xdeuy; 0x50uy; 0xc9uy; 0x96uy; 0xd4uy; 0xb0uy; 0xecuy; 0x9euy; 0x17uy; 0xecuy; 0xd2uy; 0x5euy; 0x72uy; 0x99uy; 0xfcuy; 0x0auy; 0xe1uy; 0xcbuy; 0x48uy; 0xd2uy; 0x85uy; 0xdduy; 0x2fuy; 0x90uy; 0xe0uy; 0x66uy; 0x3buy; 0xe6uy; 0x20uy; 0x74uy; 0xbeuy; 0x23uy; 0x8fuy; 0xcbuy; 0xb4uy; 0xe4uy; 0xdauy; 0x48uy; 0x40uy; 0xa6uy; 0xd1uy; 0x1buy; 0xc7uy; 0x42uy; 0xceuy; 0x2fuy; 0x0cuy; 0xa6uy; 0x85uy; 0x6euy; 0x87uy; 0x37uy; 0x03uy; 0xb1uy; 0x7cuy; 0x25uy; 0x96uy; 0xa3uy; 0x05uy; 0xd8uy; 0xb0uy; 0xf4uy; 0xeduy; 0xeauy; 0xc2uy; 0xf0uy; 0x31uy; 0x98uy; 0x6cuy; 0xd1uy; 0x14uy; 0x25uy; 0xc0uy; 0xcbuy; 0x01uy; 0x74uy; 0xd0uy; 0x82uy; 0xf4uy; 0x36uy; 0xf5uy; 0x41uy; 0xd5uy; 0xdcuy; 0xcauy; 0xc5uy; 0xbbuy; 0x98uy; 0xfeuy; 0xfcuy; 0x69uy; 0x21uy; 0x70uy; 0xd8uy; 0xa4uy; 0x4buy; 0xc8uy; 0xdeuy; 0x8fuy; ] in
  assert_norm (List.Tot.length l = 129);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input5_len: (x:UInt32.t { UInt32.v x = B.length input5 }) =
  129ul

let output5: (b: B.buffer UInt8.t { B.length b = 145 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x8buy; 0x06uy; 0xd3uy; 0x31uy; 0xb0uy; 0x93uy; 0x45uy; 0xb1uy; 0x75uy; 0x6euy; 0x26uy; 0xf9uy; 0x67uy; 0xbcuy; 0x90uy; 0x15uy; 0x81uy; 0x2cuy; 0xb5uy; 0xf0uy; 0xc6uy; 0x2buy; 0xc7uy; 0x8cuy; 0x56uy; 0xd1uy; 0xbfuy; 0x69uy; 0x6cuy; 0x07uy; 0xa0uy; 0xdauy; 0x65uy; 0x27uy; 0xc9uy; 0x90uy; 0x3duy; 0xefuy; 0x4buy; 0x11uy; 0x0fuy; 0x19uy; 0x07uy; 0xfduy; 0x29uy; 0x92uy; 0xd9uy; 0xc8uy; 0xf7uy; 0x99uy; 0x2euy; 0x4auy; 0xd0uy; 0xb8uy; 0x2cuy; 0xdcuy; 0x93uy; 0xf5uy; 0x9euy; 0x33uy; 0x78uy; 0xd1uy; 0x37uy; 0xc3uy; 0x66uy; 0xd7uy; 0x5euy; 0xbcuy; 0x44uy; 0xbfuy; 0x53uy; 0xa5uy; 0xbcuy; 0xc4uy; 0xcbuy; 0x7buy; 0x3auy; 0x8euy; 0x7fuy; 0x02uy; 0xbduy; 0xbbuy; 0xe7uy; 0xcauy; 0xa6uy; 0x6cuy; 0x6buy; 0x93uy; 0x21uy; 0x93uy; 0x10uy; 0x61uy; 0xe7uy; 0x69uy; 0xd0uy; 0x78uy; 0xf3uy; 0x07uy; 0x5auy; 0x1auy; 0x8fuy; 0x73uy; 0xaauy; 0xb1uy; 0x4euy; 0xd3uy; 0xdauy; 0x4fuy; 0xf3uy; 0x32uy; 0xe1uy; 0x66uy; 0x3euy; 0x6cuy; 0xc6uy; 0x13uy; 0xbauy; 0x06uy; 0x5buy; 0xfcuy; 0x6auy; 0xe5uy; 0x6fuy; 0x60uy; 0xfbuy; 0x07uy; 0x40uy; 0xb0uy; 0x8cuy; 0x9duy; 0x84uy; 0x43uy; 0x6buy; 0xc1uy; 0xf7uy; 0x8duy; 0x8duy; 0x31uy; 0xf7uy; 0x7auy; 0x39uy; 0x4duy; 0x8fuy; 0x9auy; 0xebuy; ] in
  assert_norm (List.Tot.length l = 145);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output5_len: (x:UInt32.t { UInt32.v x = B.length output5 }) =
  145ul

let key6: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x8duy; 0xb8uy; 0x91uy; 0x48uy; 0xf0uy; 0xe7uy; 0x0auy; 0xbduy; 0xf9uy; 0x3fuy; 0xcduy; 0xd9uy; 0xa0uy; 0x1euy; 0x42uy; 0x4cuy; 0xe7uy; 0xdeuy; 0x25uy; 0x3duy; 0xa3uy; 0xd7uy; 0x05uy; 0x80uy; 0x8duy; 0xf2uy; 0x82uy; 0xacuy; 0x44uy; 0x16uy; 0x51uy; 0x01uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key6_len: (x:UInt32.t { UInt32.v x = B.length key6 }) =
  32ul

let nonce6: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xdeuy; 0x7buy; 0xefuy; 0xc3uy; 0x65uy; 0x1buy; 0x68uy; 0xb0uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce6_len: (x:UInt32.t { UInt32.v x = B.length nonce6 }) =
  12ul

let aad6: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad6_len: (x:UInt32.t { UInt32.v x = B.length aad6 }) =
  0ul

let input6: (b: B.buffer UInt8.t { B.length b = 256 /\ B.recallable b /\ B.disjoint b aad6 }) =
     B.recall aad6;[@inline_let] let l = [ 0x9buy; 0x18uy; 0xdbuy; 0xdduy; 0x9auy; 0x0fuy; 0x3euy; 0xa5uy; 0x15uy; 0x17uy; 0xdeuy; 0xdfuy; 0x08uy; 0x9duy; 0x65uy; 0x0auy; 0x67uy; 0x30uy; 0x12uy; 0xe2uy; 0x34uy; 0x77uy; 0x4buy; 0xc1uy; 0xd9uy; 0xc6uy; 0x1fuy; 0xabuy; 0xc6uy; 0x18uy; 0x50uy; 0x17uy; 0xa7uy; 0x9duy; 0x3cuy; 0xa6uy; 0xc5uy; 0x35uy; 0x8cuy; 0x1cuy; 0xc0uy; 0xa1uy; 0x7cuy; 0x9fuy; 0x03uy; 0x89uy; 0xcauy; 0xe1uy; 0xe6uy; 0xe9uy; 0xd4uy; 0xd3uy; 0x88uy; 0xdbuy; 0xb4uy; 0x51uy; 0x9duy; 0xecuy; 0xb4uy; 0xfcuy; 0x52uy; 0xeeuy; 0x6duy; 0xf1uy; 0x75uy; 0x42uy; 0xc6uy; 0xfduy; 0xbduy; 0x7auy; 0x8euy; 0x86uy; 0xfcuy; 0x44uy; 0xb3uy; 0x4fuy; 0xf3uy; 0xeauy; 0x67uy; 0x5auy; 0x41uy; 0x13uy; 0xbauy; 0xb0uy; 0xdcuy; 0xe1uy; 0xd3uy; 0x2auy; 0x7cuy; 0x22uy; 0xb3uy; 0xcauy; 0xacuy; 0x6auy; 0x37uy; 0x98uy; 0x3euy; 0x1duy; 0x40uy; 0x97uy; 0xf7uy; 0x9buy; 0x1duy; 0x36uy; 0x6buy; 0xb3uy; 0x28uy; 0xbduy; 0x60uy; 0x82uy; 0x47uy; 0x34uy; 0xaauy; 0x2fuy; 0x7duy; 0xe9uy; 0xa8uy; 0x70uy; 0x81uy; 0x57uy; 0xd4uy; 0xb9uy; 0x77uy; 0x0auy; 0x9duy; 0x29uy; 0xa7uy; 0x84uy; 0x52uy; 0x4fuy; 0xc2uy; 0x4auy; 0x40uy; 0x3buy; 0x3cuy; 0xd4uy; 0xc9uy; 0x2auy; 0xdbuy; 0x4auy; 0x53uy; 0xc4uy; 0xbeuy; 0x80uy; 0xe9uy; 0x51uy; 0x7fuy; 0x8fuy; 0xc7uy; 0xa2uy; 0xceuy; 0x82uy; 0x5cuy; 0x91uy; 0x1euy; 0x74uy; 0xd9uy; 0xd0uy; 0xbduy; 0xd5uy; 0xf3uy; 0xfduy; 0xdauy; 0x4duy; 0x25uy; 0xb4uy; 0xbbuy; 0x2duy; 0xacuy; 0x2fuy; 0x3duy; 0x71uy; 0x85uy; 0x7buy; 0xcfuy; 0x3cuy; 0x7buy; 0x3euy; 0x0euy; 0x22uy; 0x78uy; 0x0cuy; 0x29uy; 0xbfuy; 0xe4uy; 0xf4uy; 0x57uy; 0xb3uy; 0xcbuy; 0x49uy; 0xa0uy; 0xfcuy; 0x1euy; 0x05uy; 0x4euy; 0x16uy; 0xbcuy; 0xd5uy; 0xa8uy; 0xa3uy; 0xeeuy; 0x05uy; 0x35uy; 0xc6uy; 0x7cuy; 0xabuy; 0x60uy; 0x14uy; 0x55uy; 0x1auy; 0x8euy; 0xc5uy; 0x88uy; 0x5duy; 0xd5uy; 0x81uy; 0xc2uy; 0x81uy; 0xa5uy; 0xc4uy; 0x60uy; 0xdbuy; 0xafuy; 0x77uy; 0x91uy; 0xe1uy; 0xceuy; 0xa2uy; 0x7euy; 0x7fuy; 0x42uy; 0xe3uy; 0xb0uy; 0x13uy; 0x1cuy; 0x1fuy; 0x25uy; 0x60uy; 0x21uy; 0xe2uy; 0x40uy; 0x5fuy; 0x99uy; 0xb7uy; 0x73uy; 0xecuy; 0x9buy; 0x2buy; 0xf0uy; 0x65uy; 0x11uy; 0xc8uy; 0xd0uy; 0x0auy; 0x9fuy; 0xd3uy; ] in
  assert_norm (List.Tot.length l = 256);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input6_len: (x:UInt32.t { UInt32.v x = B.length input6 }) =
  256ul

let output6: (b: B.buffer UInt8.t { B.length b = 272 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x85uy; 0x04uy; 0xc2uy; 0xeduy; 0x8duy; 0xfduy; 0x97uy; 0x5cuy; 0xd2uy; 0xb7uy; 0xe2uy; 0xc1uy; 0x6buy; 0xa3uy; 0xbauy; 0xf8uy; 0xc9uy; 0x50uy; 0xc3uy; 0xc6uy; 0xa5uy; 0xe3uy; 0xa4uy; 0x7cuy; 0xc3uy; 0x23uy; 0x49uy; 0x5euy; 0xa9uy; 0xb9uy; 0x32uy; 0xebuy; 0x8auy; 0x7cuy; 0xcauy; 0xe5uy; 0xecuy; 0xfbuy; 0x7cuy; 0xc0uy; 0xcbuy; 0x7duy; 0xdcuy; 0x2cuy; 0x9duy; 0x92uy; 0x55uy; 0x21uy; 0x0auy; 0xc8uy; 0x43uy; 0x63uy; 0x59uy; 0x0auy; 0x31uy; 0x70uy; 0x82uy; 0x67uy; 0x41uy; 0x03uy; 0xf8uy; 0xdfuy; 0xf2uy; 0xacuy; 0xa7uy; 0x02uy; 0xd4uy; 0xd5uy; 0x8auy; 0x2duy; 0xc8uy; 0x99uy; 0x19uy; 0x66uy; 0xd0uy; 0xf6uy; 0x88uy; 0x2cuy; 0x77uy; 0xd9uy; 0xd4uy; 0x0duy; 0x6cuy; 0xbduy; 0x98uy; 0xdeuy; 0xe7uy; 0x7fuy; 0xaduy; 0x7euy; 0x8auy; 0xfbuy; 0xe9uy; 0x4buy; 0xe5uy; 0xf7uy; 0xe5uy; 0x50uy; 0xa0uy; 0x90uy; 0x3fuy; 0xd6uy; 0x22uy; 0x53uy; 0xe3uy; 0xfeuy; 0x1buy; 0xccuy; 0x79uy; 0x3buy; 0xecuy; 0x12uy; 0x47uy; 0x52uy; 0xa7uy; 0xd6uy; 0x04uy; 0xe3uy; 0x52uy; 0xe6uy; 0x93uy; 0x90uy; 0x91uy; 0x32uy; 0x73uy; 0x79uy; 0xb8uy; 0xd0uy; 0x31uy; 0xdeuy; 0x1fuy; 0x9fuy; 0x2fuy; 0x05uy; 0x38uy; 0x54uy; 0x2fuy; 0x35uy; 0x04uy; 0x39uy; 0xe0uy; 0xa7uy; 0xbauy; 0xc6uy; 0x52uy; 0xf6uy; 0x37uy; 0x65uy; 0x4cuy; 0x07uy; 0xa9uy; 0x7euy; 0xb3uy; 0x21uy; 0x6fuy; 0x74uy; 0x8cuy; 0xc9uy; 0xdeuy; 0xdbuy; 0x65uy; 0x1buy; 0x9buy; 0xaauy; 0x60uy; 0xb1uy; 0x03uy; 0x30uy; 0x6buy; 0xb2uy; 0x03uy; 0xc4uy; 0x1cuy; 0x04uy; 0xf8uy; 0x0fuy; 0x64uy; 0xafuy; 0x46uy; 0xe4uy; 0x65uy; 0x99uy; 0x49uy; 0xe2uy; 0xeauy; 0xceuy; 0x78uy; 0x00uy; 0xd8uy; 0x8buy; 0xd5uy; 0x2euy; 0xcfuy; 0xfcuy; 0x40uy; 0x49uy; 0xe8uy; 0x58uy; 0xdcuy; 0x34uy; 0x9cuy; 0x8cuy; 0x61uy; 0xbfuy; 0x0auy; 0x8euy; 0xecuy; 0x39uy; 0xa9uy; 0x30uy; 0x05uy; 0x5auy; 0xd2uy; 0x56uy; 0x01uy; 0xc7uy; 0xdauy; 0x8fuy; 0x4euy; 0xbbuy; 0x43uy; 0xa3uy; 0x3auy; 0xf9uy; 0x15uy; 0x2auy; 0xd0uy; 0xa0uy; 0x7auy; 0x87uy; 0x34uy; 0x82uy; 0xfeuy; 0x8auy; 0xd1uy; 0x2duy; 0x5euy; 0xc7uy; 0xbfuy; 0x04uy; 0x53uy; 0x5fuy; 0x3buy; 0x36uy; 0xd4uy; 0x25uy; 0x5cuy; 0x34uy; 0x7auy; 0x8duy; 0xd5uy; 0x05uy; 0xceuy; 0x72uy; 0xcauy; 0xefuy; 0x7auy; 0x4buy; 0xbcuy; 0xb0uy; 0x10uy; 0x5cuy; 0x96uy; 0x42uy; 0x3auy; 0x00uy; 0x98uy; 0xcduy; 0x15uy; 0xe8uy; 0xb7uy; 0x53uy; ] in
  assert_norm (List.Tot.length l = 272);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output6_len: (x:UInt32.t { UInt32.v x = B.length output6 }) =
  272ul

let key7: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf2uy; 0xaauy; 0x4fuy; 0x99uy; 0xfduy; 0x3euy; 0xa8uy; 0x53uy; 0xc1uy; 0x44uy; 0xe9uy; 0x81uy; 0x18uy; 0xdcuy; 0xf5uy; 0xf0uy; 0x3euy; 0x44uy; 0x15uy; 0x59uy; 0xe0uy; 0xc5uy; 0x44uy; 0x86uy; 0xc3uy; 0x91uy; 0xa8uy; 0x75uy; 0xc0uy; 0x12uy; 0x46uy; 0xbauy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key7_len: (x:UInt32.t { UInt32.v x = B.length key7 }) =
  32ul

let nonce7: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x0euy; 0x0duy; 0x57uy; 0xbbuy; 0x7buy; 0x40uy; 0x54uy; 0x02uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce7_len: (x:UInt32.t { UInt32.v x = B.length nonce7 }) =
  12ul

let aad7: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad7_len: (x:UInt32.t { UInt32.v x = B.length aad7 }) =
  0ul

let input7: (b: B.buffer UInt8.t { B.length b = 512 /\ B.recallable b /\ B.disjoint b aad7 }) =
     B.recall aad7;[@inline_let] let l = [ 0xc3uy; 0x09uy; 0x94uy; 0x62uy; 0xe6uy; 0x46uy; 0x2euy; 0x10uy; 0xbeuy; 0x00uy; 0xe4uy; 0xfcuy; 0xf3uy; 0x40uy; 0xa3uy; 0xe2uy; 0x0fuy; 0xc2uy; 0x8buy; 0x28uy; 0xdcuy; 0xbauy; 0xb4uy; 0x3cuy; 0xe4uy; 0x21uy; 0x58uy; 0x61uy; 0xcduy; 0x8buy; 0xcduy; 0xfbuy; 0xacuy; 0x94uy; 0xa1uy; 0x45uy; 0xf5uy; 0x1cuy; 0xe1uy; 0x12uy; 0xe0uy; 0x3buy; 0x67uy; 0x21uy; 0x54uy; 0x5euy; 0x8cuy; 0xaauy; 0xcfuy; 0xdbuy; 0xb4uy; 0x51uy; 0xd4uy; 0x13uy; 0xdauy; 0xe6uy; 0x83uy; 0x89uy; 0xb6uy; 0x92uy; 0xe9uy; 0x21uy; 0x76uy; 0xa4uy; 0x93uy; 0x7duy; 0x0euy; 0xfduy; 0x96uy; 0x36uy; 0x03uy; 0x91uy; 0x43uy; 0x5cuy; 0x92uy; 0x49uy; 0x62uy; 0x61uy; 0x7buy; 0xebuy; 0x43uy; 0x89uy; 0xb8uy; 0x12uy; 0x20uy; 0x43uy; 0xd4uy; 0x47uy; 0x06uy; 0x84uy; 0xeeuy; 0x47uy; 0xe9uy; 0x8auy; 0x73uy; 0x15uy; 0x0fuy; 0x72uy; 0xcfuy; 0xeduy; 0xceuy; 0x96uy; 0xb2uy; 0x7fuy; 0x21uy; 0x45uy; 0x76uy; 0xebuy; 0x26uy; 0x28uy; 0x83uy; 0x6auy; 0xaduy; 0xaauy; 0xa6uy; 0x81uy; 0xd8uy; 0x55uy; 0xb1uy; 0xa3uy; 0x85uy; 0xb3uy; 0x0cuy; 0xdfuy; 0xf1uy; 0x69uy; 0x2duy; 0x97uy; 0x05uy; 0x2auy; 0xbcuy; 0x7cuy; 0x7buy; 0x25uy; 0xf8uy; 0x80uy; 0x9duy; 0x39uy; 0x25uy; 0xf3uy; 0x62uy; 0xf0uy; 0x66uy; 0x5euy; 0xf4uy; 0xa0uy; 0xcfuy; 0xd8uy; 0xfduy; 0x4fuy; 0xb1uy; 0x1fuy; 0x60uy; 0x3auy; 0x08uy; 0x47uy; 0xafuy; 0xe1uy; 0xf6uy; 0x10uy; 0x77uy; 0x09uy; 0xa7uy; 0x27uy; 0x8fuy; 0x9auy; 0x97uy; 0x5auy; 0x26uy; 0xfauy; 0xfeuy; 0x41uy; 0x32uy; 0x83uy; 0x10uy; 0xe0uy; 0x1duy; 0xbfuy; 0x64uy; 0x0duy; 0xf4uy; 0x1cuy; 0x32uy; 0x35uy; 0xe5uy; 0x1buy; 0x36uy; 0xefuy; 0xd4uy; 0x4auy; 0x93uy; 0x4duy; 0x00uy; 0x7cuy; 0xecuy; 0x02uy; 0x07uy; 0x8buy; 0x5duy; 0x7duy; 0x1buy; 0x0euy; 0xd1uy; 0xa6uy; 0xa5uy; 0x5duy; 0x7duy; 0x57uy; 0x88uy; 0xa8uy; 0xccuy; 0x81uy; 0xb4uy; 0x86uy; 0x4euy; 0xb4uy; 0x40uy; 0xe9uy; 0x1duy; 0xc3uy; 0xb1uy; 0x24uy; 0x3euy; 0x7fuy; 0xccuy; 0x8auy; 0x24uy; 0x9buy; 0xdfuy; 0x6duy; 0xf0uy; 0x39uy; 0x69uy; 0x3euy; 0x4cuy; 0xc0uy; 0x96uy; 0xe4uy; 0x13uy; 0xdauy; 0x90uy; 0xdauy; 0xf4uy; 0x95uy; 0x66uy; 0x8buy; 0x17uy; 0x17uy; 0xfeuy; 0x39uy; 0x43uy; 0x25uy; 0xaauy; 0xdauy; 0xa0uy; 0x43uy; 0x3cuy; 0xb1uy; 0x41uy; 0x02uy; 0xa3uy; 0xf0uy; 0xa7uy; 0x19uy; 0x59uy; 0xbcuy; 0x1duy; 0x7duy; 0x6cuy; 0x6duy; 0x91uy; 0x09uy; 0x5cuy; 0xb7uy; 0x5buy; 0x01uy; 0xd1uy; 0x6fuy; 0x17uy; 0x21uy; 0x97uy; 0xbfuy; 0x89uy; 0x71uy; 0xa5uy; 0xb0uy; 0x6euy; 0x07uy; 0x45uy; 0xfduy; 0x9duy; 0xeauy; 0x07uy; 0xf6uy; 0x7auy; 0x9fuy; 0x10uy; 0x18uy; 0x22uy; 0x30uy; 0x73uy; 0xacuy; 0xd4uy; 0x6buy; 0x72uy; 0x44uy; 0xeduy; 0xd9uy; 0x19uy; 0x9buy; 0x2duy; 0x4auy; 0x41uy; 0xdduy; 0xd1uy; 0x85uy; 0x5euy; 0x37uy; 0x19uy; 0xeduy; 0xd2uy; 0x15uy; 0x8fuy; 0x5euy; 0x91uy; 0xdbuy; 0x33uy; 0xf2uy; 0xe4uy; 0xdbuy; 0xffuy; 0x98uy; 0xfbuy; 0xa3uy; 0xb5uy; 0xcauy; 0x21uy; 0x69uy; 0x08uy; 0xe7uy; 0x8auy; 0xdfuy; 0x90uy; 0xffuy; 0x3euy; 0xe9uy; 0x20uy; 0x86uy; 0x3cuy; 0xe9uy; 0xfcuy; 0x0buy; 0xfeuy; 0x5cuy; 0x61uy; 0xaauy; 0x13uy; 0x92uy; 0x7fuy; 0x7buy; 0xecuy; 0xe0uy; 0x6duy; 0xa8uy; 0x23uy; 0x22uy; 0xf6uy; 0x6buy; 0x77uy; 0xc4uy; 0xfeuy; 0x40uy; 0x07uy; 0x3buy; 0xb6uy; 0xf6uy; 0x8euy; 0x5fuy; 0xd4uy; 0xb9uy; 0xb7uy; 0x0fuy; 0x21uy; 0x04uy; 0xefuy; 0x83uy; 0x63uy; 0x91uy; 0x69uy; 0x40uy; 0xa3uy; 0x48uy; 0x5cuy; 0xd2uy; 0x60uy; 0xf9uy; 0x4fuy; 0x6cuy; 0x47uy; 0x8buy; 0x3buy; 0xb1uy; 0x9fuy; 0x8euy; 0xeeuy; 0x16uy; 0x8auy; 0x13uy; 0xfcuy; 0x46uy; 0x17uy; 0xc3uy; 0xc3uy; 0x32uy; 0x56uy; 0xf8uy; 0x3cuy; 0x85uy; 0x3auy; 0xb6uy; 0x3euy; 0xaauy; 0x89uy; 0x4fuy; 0xb3uy; 0xdfuy; 0x38uy; 0xfduy; 0xf1uy; 0xe4uy; 0x3auy; 0xc0uy; 0xe6uy; 0x58uy; 0xb5uy; 0x8fuy; 0xc5uy; 0x29uy; 0xa2uy; 0x92uy; 0x4auy; 0xb6uy; 0xa0uy; 0x34uy; 0x7fuy; 0xabuy; 0xb5uy; 0x8auy; 0x90uy; 0xa1uy; 0xdbuy; 0x4duy; 0xcauy; 0xb6uy; 0x2cuy; 0x41uy; 0x3cuy; 0xf7uy; 0x2buy; 0x21uy; 0xc3uy; 0xfduy; 0xf4uy; 0x17uy; 0x5cuy; 0xb5uy; 0x33uy; 0x17uy; 0x68uy; 0x2buy; 0x08uy; 0x30uy; 0xf3uy; 0xf7uy; 0x30uy; 0x3cuy; 0x96uy; 0xe6uy; 0x6auy; 0x20uy; 0x97uy; 0xe7uy; 0x4duy; 0x10uy; 0x5fuy; 0x47uy; 0x5fuy; 0x49uy; 0x96uy; 0x09uy; 0xf0uy; 0x27uy; 0x91uy; 0xc8uy; 0xf8uy; 0x5auy; 0x2euy; 0x79uy; 0xb5uy; 0xe2uy; 0xb8uy; 0xe8uy; 0xb9uy; 0x7buy; 0xd5uy; 0x10uy; 0xcbuy; 0xffuy; 0x5duy; 0x14uy; 0x73uy; 0xf3uy; ] in
  assert_norm (List.Tot.length l = 512);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input7_len: (x:UInt32.t { UInt32.v x = B.length input7 }) =
  512ul

let output7: (b: B.buffer UInt8.t { B.length b = 528 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x14uy; 0xf6uy; 0x41uy; 0x37uy; 0xa6uy; 0xd4uy; 0x27uy; 0xcduy; 0xdbuy; 0x06uy; 0x3euy; 0x9auy; 0x4euy; 0xabuy; 0xd5uy; 0xb1uy; 0x1euy; 0x6buy; 0xd2uy; 0xbcuy; 0x11uy; 0xf4uy; 0x28uy; 0x93uy; 0x63uy; 0x54uy; 0xefuy; 0xbbuy; 0x5euy; 0x1duy; 0x3auy; 0x1duy; 0x37uy; 0x3cuy; 0x0auy; 0x6cuy; 0x1euy; 0xc2uy; 0xd1uy; 0x2cuy; 0xb5uy; 0xa3uy; 0xb5uy; 0x7buy; 0xb8uy; 0x8fuy; 0x25uy; 0xa6uy; 0x1buy; 0x61uy; 0x1cuy; 0xecuy; 0x28uy; 0x58uy; 0x26uy; 0xa4uy; 0xa8uy; 0x33uy; 0x28uy; 0x25uy; 0x5cuy; 0x45uy; 0x05uy; 0xe5uy; 0x6cuy; 0x99uy; 0xe5uy; 0x45uy; 0xc4uy; 0xa2uy; 0x03uy; 0x84uy; 0x03uy; 0x73uy; 0x1euy; 0x8cuy; 0x49uy; 0xacuy; 0x20uy; 0xdduy; 0x8duy; 0xb3uy; 0xc4uy; 0xf5uy; 0xe7uy; 0x4fuy; 0xf1uy; 0xeduy; 0xa1uy; 0x98uy; 0xdeuy; 0xa4uy; 0x96uy; 0xdduy; 0x2fuy; 0xabuy; 0xabuy; 0x97uy; 0xcfuy; 0x3euy; 0xd2uy; 0x9euy; 0xb8uy; 0x13uy; 0x07uy; 0x28uy; 0x29uy; 0x19uy; 0xafuy; 0xfduy; 0xf2uy; 0x49uy; 0x43uy; 0xeauy; 0x49uy; 0x26uy; 0x91uy; 0xc1uy; 0x07uy; 0xd6uy; 0xbbuy; 0x81uy; 0x75uy; 0x35uy; 0x0duy; 0x24uy; 0x7fuy; 0xc8uy; 0xdauy; 0xd4uy; 0xb7uy; 0xebuy; 0xe8uy; 0x5cuy; 0x09uy; 0xa2uy; 0x2fuy; 0xdcuy; 0x28uy; 0x7duy; 0x3auy; 0x03uy; 0xfauy; 0x94uy; 0xb5uy; 0x1duy; 0x17uy; 0x99uy; 0x36uy; 0xc3uy; 0x1cuy; 0x18uy; 0x34uy; 0xe3uy; 0x9fuy; 0xf5uy; 0x55uy; 0x7cuy; 0xb0uy; 0x60uy; 0x9duy; 0xffuy; 0xacuy; 0xd4uy; 0x61uy; 0xf2uy; 0xaduy; 0xf8uy; 0xceuy; 0xc7uy; 0xbeuy; 0x5cuy; 0xd2uy; 0x95uy; 0xa8uy; 0x4buy; 0x77uy; 0x13uy; 0x19uy; 0x59uy; 0x26uy; 0xc9uy; 0xb7uy; 0x8fuy; 0x6auy; 0xcbuy; 0x2duy; 0x37uy; 0x91uy; 0xeauy; 0x92uy; 0x9cuy; 0x94uy; 0x5buy; 0xdauy; 0x0buy; 0xceuy; 0xfeuy; 0x30uy; 0x20uy; 0xf8uy; 0x51uy; 0xaduy; 0xf2uy; 0xbeuy; 0xe7uy; 0xc7uy; 0xffuy; 0xb3uy; 0x33uy; 0x91uy; 0x6auy; 0xc9uy; 0x1auy; 0x41uy; 0xc9uy; 0x0fuy; 0xf3uy; 0x10uy; 0x0euy; 0xfduy; 0x53uy; 0xffuy; 0x6cuy; 0x16uy; 0x52uy; 0xd9uy; 0xf3uy; 0xf7uy; 0x98uy; 0x2euy; 0xc9uy; 0x07uy; 0x31uy; 0x2cuy; 0x0cuy; 0x72uy; 0xd7uy; 0xc5uy; 0xc6uy; 0x08uy; 0x2auy; 0x7buy; 0xdauy; 0xbduy; 0x7euy; 0x02uy; 0xeauy; 0x1auy; 0xbbuy; 0xf2uy; 0x04uy; 0x27uy; 0x61uy; 0x28uy; 0x8euy; 0xf5uy; 0x04uy; 0x03uy; 0x1fuy; 0x4cuy; 0x07uy; 0x55uy; 0x82uy; 0xecuy; 0x1euy; 0xd7uy; 0x8buy; 0x2fuy; 0x65uy; 0x56uy; 0xd1uy; 0xd9uy; 0x1euy; 0x3cuy; 0xe9uy; 0x1fuy; 0x5euy; 0x98uy; 0x70uy; 0x38uy; 0x4auy; 0x8cuy; 0x49uy; 0xc5uy; 0x43uy; 0xa0uy; 0xa1uy; 0x8buy; 0x74uy; 0x9duy; 0x4cuy; 0x62uy; 0x0duy; 0x10uy; 0x0cuy; 0xf4uy; 0x6cuy; 0x8fuy; 0xe0uy; 0xaauy; 0x9auy; 0x8duy; 0xb7uy; 0xe0uy; 0xbeuy; 0x4cuy; 0x87uy; 0xf1uy; 0x98uy; 0x2fuy; 0xccuy; 0xeduy; 0xc0uy; 0x52uy; 0x29uy; 0xdcuy; 0x83uy; 0xf8uy; 0xfcuy; 0x2cuy; 0x0euy; 0xa8uy; 0x51uy; 0x4duy; 0x80uy; 0x0duy; 0xa3uy; 0xfeuy; 0xd8uy; 0x37uy; 0xe7uy; 0x41uy; 0x24uy; 0xfcuy; 0xfbuy; 0x75uy; 0xe3uy; 0x71uy; 0x7buy; 0x57uy; 0x45uy; 0xf5uy; 0x97uy; 0x73uy; 0x65uy; 0x63uy; 0x14uy; 0x74uy; 0xb8uy; 0x82uy; 0x9fuy; 0xf8uy; 0x60uy; 0x2fuy; 0x8auy; 0xf2uy; 0x4euy; 0xf1uy; 0x39uy; 0xdauy; 0x33uy; 0x91uy; 0xf8uy; 0x36uy; 0xe0uy; 0x8duy; 0x3fuy; 0x1fuy; 0x3buy; 0x56uy; 0xdcuy; 0xa0uy; 0x8fuy; 0x3cuy; 0x9duy; 0x71uy; 0x52uy; 0xa7uy; 0xb8uy; 0xc0uy; 0xa5uy; 0xc6uy; 0xa2uy; 0x73uy; 0xdauy; 0xf4uy; 0x4buy; 0x74uy; 0x5buy; 0x00uy; 0x3duy; 0x99uy; 0xd7uy; 0x96uy; 0xbauy; 0xe6uy; 0xe1uy; 0xa6uy; 0x96uy; 0x38uy; 0xaduy; 0xb3uy; 0xc0uy; 0xd2uy; 0xbauy; 0x91uy; 0x6buy; 0xf9uy; 0x19uy; 0xdduy; 0x3buy; 0xbeuy; 0xbeuy; 0x9cuy; 0x20uy; 0x50uy; 0xbauy; 0xa1uy; 0xd0uy; 0xceuy; 0x11uy; 0xbduy; 0x95uy; 0xd8uy; 0xd1uy; 0xdduy; 0x33uy; 0x85uy; 0x74uy; 0xdcuy; 0xdbuy; 0x66uy; 0x76uy; 0x44uy; 0xdcuy; 0x03uy; 0x74uy; 0x48uy; 0x35uy; 0x98uy; 0xb1uy; 0x18uy; 0x47uy; 0x94uy; 0x7duy; 0xffuy; 0x62uy; 0xe4uy; 0x58uy; 0x78uy; 0xabuy; 0xeduy; 0x95uy; 0x36uy; 0xd9uy; 0x84uy; 0x91uy; 0x82uy; 0x64uy; 0x41uy; 0xbbuy; 0x58uy; 0xe6uy; 0x1cuy; 0x20uy; 0x6duy; 0x15uy; 0x6buy; 0x13uy; 0x96uy; 0xe8uy; 0x35uy; 0x7fuy; 0xdcuy; 0x40uy; 0x2cuy; 0xe9uy; 0xbcuy; 0x8auy; 0x4fuy; 0x92uy; 0xecuy; 0x06uy; 0x2duy; 0x50uy; 0xdfuy; 0x93uy; 0x5duy; 0x65uy; 0x5auy; 0xa8uy; 0xfcuy; 0x20uy; 0x50uy; 0x14uy; 0xa9uy; 0x8auy; 0x7euy; 0x1duy; 0x08uy; 0x1fuy; 0xe2uy; 0x99uy; 0xd0uy; 0xbeuy; 0xfbuy; 0x3auy; 0x21uy; 0x9duy; 0xaduy; 0x86uy; 0x54uy; 0xfduy; 0x0duy; 0x98uy; 0x1cuy; 0x5auy; 0x6fuy; 0x1fuy; 0x9auy; 0x40uy; 0xcduy; 0xa2uy; 0xffuy; 0x6auy; 0xf1uy; 0x54uy; ] in
  assert_norm (List.Tot.length l = 528);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output7_len: (x:UInt32.t { UInt32.v x = B.length output7 }) =
  528ul

let key8: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xeauy; 0xbcuy; 0x56uy; 0x99uy; 0xe3uy; 0x50uy; 0xffuy; 0xc5uy; 0xccuy; 0x1auy; 0xd7uy; 0xc1uy; 0x57uy; 0x72uy; 0xeauy; 0x86uy; 0x5buy; 0x89uy; 0x88uy; 0x61uy; 0x3duy; 0x2fuy; 0x9buy; 0xb2uy; 0xe7uy; 0x9cuy; 0xecuy; 0x74uy; 0x6euy; 0x3euy; 0xf4uy; 0x3buy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key8_len: (x:UInt32.t { UInt32.v x = B.length key8 }) =
  32ul

let nonce8: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xefuy; 0x2duy; 0x63uy; 0xeeuy; 0x6buy; 0x80uy; 0x8buy; 0x78uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce8_len: (x:UInt32.t { UInt32.v x = B.length nonce8 }) =
  12ul

let aad8: (b: B.buffer UInt8.t { B.length b = 9 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x5auy; 0x27uy; 0xffuy; 0xebuy; 0xdfuy; 0x84uy; 0xb2uy; 0x9euy; 0xefuy; ] in
  assert_norm (List.Tot.length l = 9);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad8_len: (x:UInt32.t { UInt32.v x = B.length aad8 }) =
  9ul

let input8: (b: B.buffer UInt8.t { B.length b = 513 /\ B.recallable b /\ B.disjoint b aad8 }) =
     B.recall aad8;[@inline_let] let l = [ 0xe6uy; 0xc3uy; 0xdbuy; 0x63uy; 0x55uy; 0x15uy; 0xe3uy; 0x5buy; 0xb7uy; 0x4buy; 0x27uy; 0x8buy; 0x5auy; 0xdduy; 0xc2uy; 0xe8uy; 0x3auy; 0x6buy; 0xd7uy; 0x81uy; 0x96uy; 0x35uy; 0x97uy; 0xcauy; 0xd7uy; 0x68uy; 0xe8uy; 0xefuy; 0xceuy; 0xabuy; 0xdauy; 0x09uy; 0x6euy; 0xd6uy; 0x8euy; 0xcbuy; 0x55uy; 0xb5uy; 0xe1uy; 0xe5uy; 0x57uy; 0xfduy; 0xc4uy; 0xe3uy; 0xe0uy; 0x18uy; 0x4fuy; 0x85uy; 0xf5uy; 0x3fuy; 0x7euy; 0x4buy; 0x88uy; 0xc9uy; 0x52uy; 0x44uy; 0x0fuy; 0xeauy; 0xafuy; 0x1fuy; 0x71uy; 0x48uy; 0x9fuy; 0x97uy; 0x6duy; 0xb9uy; 0x6fuy; 0x00uy; 0xa6uy; 0xdeuy; 0x2buy; 0x77uy; 0x8buy; 0x15uy; 0xaduy; 0x10uy; 0xa0uy; 0x2buy; 0x7buy; 0x41uy; 0x90uy; 0x03uy; 0x2duy; 0x69uy; 0xaeuy; 0xccuy; 0x77uy; 0x7cuy; 0xa5uy; 0x9duy; 0x29uy; 0x22uy; 0xc2uy; 0xeauy; 0xb4uy; 0x00uy; 0x1auy; 0xd2uy; 0x7auy; 0x98uy; 0x8auy; 0xf9uy; 0xf7uy; 0x82uy; 0xb0uy; 0xabuy; 0xd8uy; 0xa6uy; 0x94uy; 0x8duy; 0x58uy; 0x2fuy; 0x01uy; 0x9euy; 0x00uy; 0x20uy; 0xfcuy; 0x49uy; 0xdcuy; 0x0euy; 0x03uy; 0xe8uy; 0x45uy; 0x10uy; 0xd6uy; 0xa8uy; 0xdauy; 0x55uy; 0x10uy; 0x9auy; 0xdfuy; 0x67uy; 0x22uy; 0x8buy; 0x43uy; 0xabuy; 0x00uy; 0xbbuy; 0x02uy; 0xc8uy; 0xdduy; 0x7buy; 0x97uy; 0x17uy; 0xd7uy; 0x1duy; 0x9euy; 0x02uy; 0x5euy; 0x48uy; 0xdeuy; 0x8euy; 0xcfuy; 0x99uy; 0x07uy; 0x95uy; 0x92uy; 0x3cuy; 0x5fuy; 0x9fuy; 0xc5uy; 0x8auy; 0xc0uy; 0x23uy; 0xaauy; 0xd5uy; 0x8cuy; 0x82uy; 0x6euy; 0x16uy; 0x92uy; 0xb1uy; 0x12uy; 0x17uy; 0x07uy; 0xc3uy; 0xfbuy; 0x36uy; 0xf5uy; 0x6cuy; 0x35uy; 0xd6uy; 0x06uy; 0x1fuy; 0x9fuy; 0xa7uy; 0x94uy; 0xa2uy; 0x38uy; 0x63uy; 0x9cuy; 0xb0uy; 0x71uy; 0xb3uy; 0xa5uy; 0xd2uy; 0xd8uy; 0xbauy; 0x9fuy; 0x08uy; 0x01uy; 0xb3uy; 0xffuy; 0x04uy; 0x97uy; 0x73uy; 0x45uy; 0x1buy; 0xd5uy; 0xa9uy; 0x9cuy; 0x80uy; 0xafuy; 0x04uy; 0x9auy; 0x85uy; 0xdbuy; 0x32uy; 0x5buy; 0x5duy; 0x1auy; 0xc1uy; 0x36uy; 0x28uy; 0x10uy; 0x79uy; 0xf1uy; 0x3cuy; 0xbfuy; 0x1auy; 0x41uy; 0x5cuy; 0x4euy; 0xdfuy; 0xb2uy; 0x7cuy; 0x79uy; 0x3buy; 0x7auy; 0x62uy; 0x3duy; 0x4buy; 0xc9uy; 0x9buy; 0x2auy; 0x2euy; 0x7cuy; 0xa2uy; 0xb1uy; 0x11uy; 0x98uy; 0xa7uy; 0x34uy; 0x1auy; 0x00uy; 0xf3uy; 0xd1uy; 0xbcuy; 0x18uy; 0x22uy; 0xbauy; 0x02uy; 0x56uy; 0x62uy; 0x31uy; 0x10uy; 0x11uy; 0x6duy; 0xe0uy; 0x54uy; 0x9duy; 0x40uy; 0x1fuy; 0x26uy; 0x80uy; 0x41uy; 0xcauy; 0x3fuy; 0x68uy; 0x0fuy; 0x32uy; 0x1duy; 0x0auy; 0x8euy; 0x79uy; 0xd8uy; 0xa4uy; 0x1buy; 0x29uy; 0x1cuy; 0x90uy; 0x8euy; 0xc5uy; 0xe3uy; 0xb4uy; 0x91uy; 0x37uy; 0x9auy; 0x97uy; 0x86uy; 0x99uy; 0xd5uy; 0x09uy; 0xc5uy; 0xbbuy; 0xa3uy; 0x3fuy; 0x21uy; 0x29uy; 0x82uy; 0x14uy; 0x5cuy; 0xabuy; 0x25uy; 0xfbuy; 0xf2uy; 0x4fuy; 0x58uy; 0x26uy; 0xd4uy; 0x83uy; 0xaauy; 0x66uy; 0x89uy; 0x67uy; 0x7euy; 0xc0uy; 0x49uy; 0xe1uy; 0x11uy; 0x10uy; 0x7fuy; 0x7auy; 0xdauy; 0x29uy; 0x04uy; 0xffuy; 0xf0uy; 0xcbuy; 0x09uy; 0x7cuy; 0x9duy; 0xfauy; 0x03uy; 0x6fuy; 0x81uy; 0x09uy; 0x31uy; 0x60uy; 0xfbuy; 0x08uy; 0xfauy; 0x74uy; 0xd3uy; 0x64uy; 0x44uy; 0x7cuy; 0x55uy; 0x85uy; 0xecuy; 0x9cuy; 0x6euy; 0x25uy; 0xb7uy; 0x6cuy; 0xc5uy; 0x37uy; 0xb6uy; 0x83uy; 0x87uy; 0x72uy; 0x95uy; 0x8buy; 0x9duy; 0xe1uy; 0x69uy; 0x5cuy; 0x31uy; 0x95uy; 0x42uy; 0xa6uy; 0x2cuy; 0xd1uy; 0x36uy; 0x47uy; 0x1fuy; 0xecuy; 0x54uy; 0xabuy; 0xa2uy; 0x1cuy; 0xd8uy; 0x00uy; 0xccuy; 0xbcuy; 0x0duy; 0x65uy; 0xe2uy; 0x67uy; 0xbfuy; 0xbcuy; 0xeauy; 0xeeuy; 0x9euy; 0xe4uy; 0x36uy; 0x95uy; 0xbeuy; 0x73uy; 0xd9uy; 0xa6uy; 0xd9uy; 0x0fuy; 0xa0uy; 0xccuy; 0x82uy; 0x76uy; 0x26uy; 0xaduy; 0x5buy; 0x58uy; 0x6cuy; 0x4euy; 0xabuy; 0x29uy; 0x64uy; 0xd3uy; 0xd9uy; 0xa9uy; 0x08uy; 0x8cuy; 0x1duy; 0xa1uy; 0x4fuy; 0x80uy; 0xd8uy; 0x3fuy; 0x94uy; 0xfbuy; 0xd3uy; 0x7buy; 0xfcuy; 0xd1uy; 0x2buy; 0xc3uy; 0x21uy; 0xebuy; 0xe5uy; 0x1cuy; 0x84uy; 0x23uy; 0x7fuy; 0x4buy; 0xfauy; 0xdbuy; 0x34uy; 0x18uy; 0xa2uy; 0xc2uy; 0xe5uy; 0x13uy; 0xfeuy; 0x6cuy; 0x49uy; 0x81uy; 0xd2uy; 0x73uy; 0xe7uy; 0xe2uy; 0xd7uy; 0xe4uy; 0x4fuy; 0x4buy; 0x08uy; 0x6euy; 0xb1uy; 0x12uy; 0x22uy; 0x10uy; 0x9duy; 0xacuy; 0x51uy; 0x1euy; 0x17uy; 0xd9uy; 0x8auy; 0x0buy; 0x42uy; 0x88uy; 0x16uy; 0x81uy; 0x37uy; 0x7cuy; 0x6auy; 0xf7uy; 0xefuy; 0x2duy; 0xe3uy; 0xd9uy; 0xf8uy; 0x5fuy; 0xe0uy; 0x53uy; 0x27uy; 0x74uy; 0xb9uy; 0xe2uy; 0xd6uy; 0x1cuy; 0x80uy; 0x2cuy; 0x52uy; 0x65uy; ] in
  assert_norm (List.Tot.length l = 513);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input8_len: (x:UInt32.t { UInt32.v x = B.length input8 }) =
  513ul

let output8: (b: B.buffer UInt8.t { B.length b = 529 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xfduy; 0x81uy; 0x8duy; 0xd0uy; 0x3duy; 0xb4uy; 0xd5uy; 0xdfuy; 0xd3uy; 0x42uy; 0x47uy; 0x5auy; 0x6duy; 0x19uy; 0x27uy; 0x66uy; 0x4buy; 0x2euy; 0x0cuy; 0x27uy; 0x9cuy; 0x96uy; 0x4cuy; 0x72uy; 0x02uy; 0xa3uy; 0x65uy; 0xc3uy; 0xb3uy; 0x6fuy; 0x2euy; 0xbduy; 0x63uy; 0x8auy; 0x4auy; 0x5duy; 0x29uy; 0xa2uy; 0xd0uy; 0x28uy; 0x48uy; 0xc5uy; 0x3duy; 0x98uy; 0xa3uy; 0xbcuy; 0xe0uy; 0xbeuy; 0x3buy; 0x3fuy; 0xe6uy; 0x8auy; 0xa4uy; 0x7fuy; 0x53uy; 0x06uy; 0xfauy; 0x7fuy; 0x27uy; 0x76uy; 0x72uy; 0x31uy; 0xa1uy; 0xf5uy; 0xd6uy; 0x0cuy; 0x52uy; 0x47uy; 0xbauy; 0xcduy; 0x4fuy; 0xd7uy; 0xebuy; 0x05uy; 0x48uy; 0x0duy; 0x7cuy; 0x35uy; 0x4auy; 0x09uy; 0xc9uy; 0x76uy; 0x71uy; 0x02uy; 0xa3uy; 0xfbuy; 0xb7uy; 0x1auy; 0x65uy; 0xb7uy; 0xeduy; 0x98uy; 0xc6uy; 0x30uy; 0x8auy; 0x00uy; 0xaeuy; 0xa1uy; 0x31uy; 0xe5uy; 0xb5uy; 0x9euy; 0x6duy; 0x62uy; 0xdauy; 0xdauy; 0x07uy; 0x0fuy; 0x38uy; 0x38uy; 0xd3uy; 0xcbuy; 0xc1uy; 0xb0uy; 0xaduy; 0xecuy; 0x72uy; 0xecuy; 0xb1uy; 0xa2uy; 0x7buy; 0x59uy; 0xf3uy; 0x3duy; 0x2buy; 0xefuy; 0xcduy; 0x28uy; 0x5buy; 0x83uy; 0xccuy; 0x18uy; 0x91uy; 0x88uy; 0xb0uy; 0x2euy; 0xf9uy; 0x29uy; 0x31uy; 0x18uy; 0xf9uy; 0x4euy; 0xe9uy; 0x0auy; 0x91uy; 0x92uy; 0x9fuy; 0xaeuy; 0x2duy; 0xaduy; 0xf4uy; 0xe6uy; 0x1auy; 0xe2uy; 0xa4uy; 0xeeuy; 0x47uy; 0x15uy; 0xbfuy; 0x83uy; 0x6euy; 0xd7uy; 0x72uy; 0x12uy; 0x3buy; 0x2duy; 0x24uy; 0xe9uy; 0xb2uy; 0x55uy; 0xcbuy; 0x3cuy; 0x10uy; 0xf0uy; 0x24uy; 0x8auy; 0x4auy; 0x02uy; 0xeauy; 0x90uy; 0x25uy; 0xf0uy; 0xb4uy; 0x79uy; 0x3auy; 0xefuy; 0x6euy; 0xf5uy; 0x52uy; 0xdfuy; 0xb0uy; 0x0auy; 0xcduy; 0x24uy; 0x1cuy; 0xd3uy; 0x2euy; 0x22uy; 0x74uy; 0xeauy; 0x21uy; 0x6fuy; 0xe9uy; 0xbduy; 0xc8uy; 0x3euy; 0x36uy; 0x5buy; 0x19uy; 0xf1uy; 0xcauy; 0x99uy; 0x0auy; 0xb4uy; 0xa7uy; 0x52uy; 0x1auy; 0x4euy; 0xf2uy; 0xaduy; 0x8duy; 0x56uy; 0x85uy; 0xbbuy; 0x64uy; 0x89uy; 0xbauy; 0x26uy; 0xf9uy; 0xc7uy; 0xe1uy; 0x89uy; 0x19uy; 0x22uy; 0x77uy; 0xc3uy; 0xa8uy; 0xfcuy; 0xffuy; 0xaduy; 0xfeuy; 0xb9uy; 0x48uy; 0xaeuy; 0x12uy; 0x30uy; 0x9fuy; 0x19uy; 0xfbuy; 0x1buy; 0xefuy; 0x14uy; 0x87uy; 0x8auy; 0x78uy; 0x71uy; 0xf3uy; 0xf4uy; 0xb7uy; 0x00uy; 0x9cuy; 0x1duy; 0xb5uy; 0x3duy; 0x49uy; 0x00uy; 0x0cuy; 0x06uy; 0xd4uy; 0x50uy; 0xf9uy; 0x54uy; 0x45uy; 0xb2uy; 0x5buy; 0x43uy; 0xdbuy; 0x6duy; 0xcfuy; 0x1auy; 0xe9uy; 0x7auy; 0x7auy; 0xcfuy; 0xfcuy; 0x8auy; 0x4euy; 0x4duy; 0x0buy; 0x07uy; 0x63uy; 0x28uy; 0xd8uy; 0xe7uy; 0x08uy; 0x95uy; 0xdfuy; 0xa6uy; 0x72uy; 0x93uy; 0x2euy; 0xbbuy; 0xa0uy; 0x42uy; 0x89uy; 0x16uy; 0xf1uy; 0xd9uy; 0x0cuy; 0xf9uy; 0xa1uy; 0x16uy; 0xfduy; 0xd9uy; 0x03uy; 0xb4uy; 0x3buy; 0x8auy; 0xf5uy; 0xf6uy; 0xe7uy; 0x6buy; 0x2euy; 0x8euy; 0x4cuy; 0x3duy; 0xe2uy; 0xafuy; 0x08uy; 0x45uy; 0x03uy; 0xffuy; 0x09uy; 0xb6uy; 0xebuy; 0x2duy; 0xc6uy; 0x1buy; 0x88uy; 0x94uy; 0xacuy; 0x3euy; 0xf1uy; 0x9fuy; 0x0euy; 0x0euy; 0x2buy; 0xd5uy; 0x00uy; 0x4duy; 0x3fuy; 0x3buy; 0x53uy; 0xaeuy; 0xafuy; 0x1cuy; 0x33uy; 0x5fuy; 0x55uy; 0x6euy; 0x8duy; 0xafuy; 0x05uy; 0x7auy; 0x10uy; 0x34uy; 0xc9uy; 0xf4uy; 0x66uy; 0xcbuy; 0x62uy; 0x12uy; 0xa6uy; 0xeeuy; 0xe8uy; 0x1cuy; 0x5duy; 0x12uy; 0x86uy; 0xdbuy; 0x6fuy; 0x1cuy; 0x33uy; 0xc4uy; 0x1cuy; 0xdauy; 0x82uy; 0x2duy; 0x3buy; 0x59uy; 0xfeuy; 0xb1uy; 0xa4uy; 0x59uy; 0x41uy; 0x86uy; 0xd0uy; 0xefuy; 0xaeuy; 0xfbuy; 0xdauy; 0x6duy; 0x11uy; 0xb8uy; 0xcauy; 0xe9uy; 0x6euy; 0xffuy; 0xf7uy; 0xa9uy; 0xd9uy; 0x70uy; 0x30uy; 0xfcuy; 0x53uy; 0xe2uy; 0xd7uy; 0xa2uy; 0x4euy; 0xc7uy; 0x91uy; 0xd9uy; 0x07uy; 0x06uy; 0xaauy; 0xdduy; 0xb0uy; 0x59uy; 0x28uy; 0x1duy; 0x00uy; 0x66uy; 0xc5uy; 0x54uy; 0xc2uy; 0xfcuy; 0x06uy; 0xdauy; 0x05uy; 0x90uy; 0x52uy; 0x1duy; 0x37uy; 0x66uy; 0xeeuy; 0xf0uy; 0xb2uy; 0x55uy; 0x8auy; 0x5duy; 0xd2uy; 0x38uy; 0x86uy; 0x94uy; 0x9buy; 0xfcuy; 0x10uy; 0x4cuy; 0xa1uy; 0xb9uy; 0x64uy; 0x3euy; 0x44uy; 0xb8uy; 0x5fuy; 0xb0uy; 0x0cuy; 0xecuy; 0xe0uy; 0xc9uy; 0xe5uy; 0x62uy; 0x75uy; 0x3fuy; 0x09uy; 0xd5uy; 0xf5uy; 0xd9uy; 0x26uy; 0xbauy; 0x9euy; 0xd2uy; 0xf4uy; 0xb9uy; 0x48uy; 0x0auy; 0xbcuy; 0xa2uy; 0xd6uy; 0x7cuy; 0x36uy; 0x11uy; 0x7duy; 0x26uy; 0x81uy; 0x89uy; 0xcfuy; 0xa4uy; 0xaduy; 0x73uy; 0x0euy; 0xeeuy; 0xccuy; 0x06uy; 0xa9uy; 0xdbuy; 0xb1uy; 0xfduy; 0xfbuy; 0x09uy; 0x7fuy; 0x90uy; 0x42uy; 0x37uy; 0x2fuy; 0xe1uy; 0x9cuy; 0x0fuy; 0x6fuy; 0xcfuy; 0x43uy; 0xb5uy; 0xd9uy; 0x90uy; 0xe1uy; 0x85uy; 0xf5uy; 0xa8uy; 0xaeuy; ] in
  assert_norm (List.Tot.length l = 529);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output8_len: (x:UInt32.t { UInt32.v x = B.length output8 }) =
  529ul

let key9: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x47uy; 0x11uy; 0xebuy; 0x86uy; 0x2buy; 0x2cuy; 0xabuy; 0x44uy; 0x34uy; 0xdauy; 0x7fuy; 0x57uy; 0x03uy; 0x39uy; 0x0cuy; 0xafuy; 0x2cuy; 0x14uy; 0xfduy; 0x65uy; 0x23uy; 0xe9uy; 0x8euy; 0x74uy; 0xd5uy; 0x08uy; 0x68uy; 0x08uy; 0xe7uy; 0xb4uy; 0x72uy; 0xd7uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key9_len: (x:UInt32.t { UInt32.v x = B.length key9 }) =
  32ul

let nonce9: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xdbuy; 0x92uy; 0x0fuy; 0x7fuy; 0x17uy; 0x54uy; 0x0cuy; 0x30uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce9_len: (x:UInt32.t { UInt32.v x = B.length nonce9 }) =
  12ul

let aad9: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xd2uy; 0xa1uy; 0x70uy; 0xdbuy; 0x7auy; 0xf8uy; 0xfauy; 0x27uy; 0xbauy; 0x73uy; 0x0fuy; 0xbfuy; 0x3duy; 0x1euy; 0x82uy; 0xb2uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad9_len: (x:UInt32.t { UInt32.v x = B.length aad9 }) =
  16ul

let input9: (b: B.buffer UInt8.t { B.length b = 1024 /\ B.recallable b /\ B.disjoint b aad9 }) =
     B.recall aad9;[@inline_let] let l = [ 0x42uy; 0x93uy; 0xe4uy; 0xebuy; 0x97uy; 0xb0uy; 0x57uy; 0xbfuy; 0x1auy; 0x8buy; 0x1fuy; 0xe4uy; 0x5fuy; 0x36uy; 0x20uy; 0x3cuy; 0xefuy; 0x0auy; 0xa9uy; 0x48uy; 0x5fuy; 0x5fuy; 0x37uy; 0x22uy; 0x3auy; 0xdeuy; 0xe3uy; 0xaeuy; 0xbeuy; 0xaduy; 0x07uy; 0xccuy; 0xb1uy; 0xf6uy; 0xf5uy; 0xf9uy; 0x56uy; 0xdduy; 0xe7uy; 0x16uy; 0x1euy; 0x7fuy; 0xdfuy; 0x7auy; 0x9euy; 0x75uy; 0xb7uy; 0xc7uy; 0xbeuy; 0xbeuy; 0x8auy; 0x36uy; 0x04uy; 0xc0uy; 0x10uy; 0xf4uy; 0x95uy; 0x20uy; 0x03uy; 0xecuy; 0xdcuy; 0x05uy; 0xa1uy; 0x7duy; 0xc4uy; 0xa9uy; 0x2cuy; 0x82uy; 0xd0uy; 0xbcuy; 0x8buy; 0xc5uy; 0xc7uy; 0x45uy; 0x50uy; 0xf6uy; 0xa2uy; 0x1auy; 0xb5uy; 0x46uy; 0x3buy; 0x73uy; 0x02uy; 0xa6uy; 0x83uy; 0x4buy; 0x73uy; 0x82uy; 0x58uy; 0x5euy; 0x3buy; 0x65uy; 0x2fuy; 0x0euy; 0xfduy; 0x2buy; 0x59uy; 0x16uy; 0xceuy; 0xa1uy; 0x60uy; 0x9cuy; 0xe8uy; 0x3auy; 0x99uy; 0xeduy; 0x8duy; 0x5auy; 0xcfuy; 0xf6uy; 0x83uy; 0xafuy; 0xbauy; 0xd7uy; 0x73uy; 0x73uy; 0x40uy; 0x97uy; 0x3duy; 0xcauy; 0xefuy; 0x07uy; 0x57uy; 0xe6uy; 0xd9uy; 0x70uy; 0x0euy; 0x95uy; 0xaeuy; 0xa6uy; 0x8duy; 0x04uy; 0xccuy; 0xeeuy; 0xf7uy; 0x09uy; 0x31uy; 0x77uy; 0x12uy; 0xa3uy; 0x23uy; 0x97uy; 0x62uy; 0xb3uy; 0x7buy; 0x32uy; 0xfbuy; 0x80uy; 0x14uy; 0x48uy; 0x81uy; 0xc3uy; 0xe5uy; 0xeauy; 0x91uy; 0x39uy; 0x52uy; 0x81uy; 0xa2uy; 0x4fuy; 0xe4uy; 0xb3uy; 0x09uy; 0xffuy; 0xdeuy; 0x5euy; 0xe9uy; 0x58uy; 0x84uy; 0x6euy; 0xf9uy; 0x3duy; 0xdfuy; 0x25uy; 0xeauy; 0xaduy; 0xaeuy; 0xe6uy; 0x9auy; 0xd1uy; 0x89uy; 0x55uy; 0xd3uy; 0xdeuy; 0x6cuy; 0x52uy; 0xdbuy; 0x70uy; 0xfeuy; 0x37uy; 0xceuy; 0x44uy; 0x0auy; 0xa8uy; 0x25uy; 0x5fuy; 0x92uy; 0xc1uy; 0x33uy; 0x4auy; 0x4fuy; 0x9buy; 0x62uy; 0x35uy; 0xffuy; 0xceuy; 0xc0uy; 0xa9uy; 0x60uy; 0xceuy; 0x52uy; 0x00uy; 0x97uy; 0x51uy; 0x35uy; 0x26uy; 0x2euy; 0xb9uy; 0x36uy; 0xa9uy; 0x87uy; 0x6euy; 0x1euy; 0xccuy; 0x91uy; 0x78uy; 0x53uy; 0x98uy; 0x86uy; 0x5buy; 0x9cuy; 0x74uy; 0x7duy; 0x88uy; 0x33uy; 0xe1uy; 0xdfuy; 0x37uy; 0x69uy; 0x2buy; 0xbbuy; 0xf1uy; 0x4duy; 0xf4uy; 0xd1uy; 0xf1uy; 0x39uy; 0x93uy; 0x17uy; 0x51uy; 0x19uy; 0xe3uy; 0x19uy; 0x1euy; 0x76uy; 0x37uy; 0x25uy; 0xfbuy; 0x09uy; 0x27uy; 0x6auy; 0xabuy; 0x67uy; 0x6fuy; 0x14uy; 0x12uy; 0x64uy; 0xe7uy; 0xc4uy; 0x07uy; 0xdfuy; 0x4duy; 0x17uy; 0xbbuy; 0x6duy; 0xe0uy; 0xe9uy; 0xb9uy; 0xabuy; 0xcauy; 0x10uy; 0x68uy; 0xafuy; 0x7euy; 0xb7uy; 0x33uy; 0x54uy; 0x73uy; 0x07uy; 0x6euy; 0xf7uy; 0x81uy; 0x97uy; 0x9cuy; 0x05uy; 0x6fuy; 0x84uy; 0x5fuy; 0xd2uy; 0x42uy; 0xfbuy; 0x38uy; 0xcfuy; 0xd1uy; 0x2fuy; 0x14uy; 0x30uy; 0x88uy; 0x98uy; 0x4duy; 0x5auy; 0xa9uy; 0x76uy; 0xd5uy; 0x4fuy; 0x3euy; 0x70uy; 0x6cuy; 0x85uy; 0x76uy; 0xd7uy; 0x01uy; 0xa0uy; 0x1auy; 0xc8uy; 0x4euy; 0xaauy; 0xacuy; 0x78uy; 0xfeuy; 0x46uy; 0xdeuy; 0x6auy; 0x05uy; 0x46uy; 0xa7uy; 0x43uy; 0x0cuy; 0xb9uy; 0xdeuy; 0xb9uy; 0x68uy; 0xfbuy; 0xceuy; 0x42uy; 0x99uy; 0x07uy; 0x4duy; 0x0buy; 0x3buy; 0x5auy; 0x30uy; 0x35uy; 0xa8uy; 0xf9uy; 0x3auy; 0x73uy; 0xefuy; 0x0fuy; 0xdbuy; 0x1euy; 0x16uy; 0x42uy; 0xc4uy; 0xbauy; 0xaeuy; 0x58uy; 0xaauy; 0xf8uy; 0xe5uy; 0x75uy; 0x2fuy; 0x1buy; 0x15uy; 0x5cuy; 0xfduy; 0x0auy; 0x97uy; 0xd0uy; 0xe4uy; 0x37uy; 0x83uy; 0x61uy; 0x5fuy; 0x43uy; 0xa6uy; 0xc7uy; 0x3fuy; 0x38uy; 0x59uy; 0xe6uy; 0xebuy; 0xa3uy; 0x90uy; 0xc3uy; 0xaauy; 0xaauy; 0x5auy; 0xd3uy; 0x34uy; 0xd4uy; 0x17uy; 0xc8uy; 0x65uy; 0x3euy; 0x57uy; 0xbcuy; 0x5euy; 0xdduy; 0x9euy; 0xb7uy; 0xf0uy; 0x2euy; 0x5buy; 0xb2uy; 0x1fuy; 0x8auy; 0x08uy; 0x0duy; 0x45uy; 0x91uy; 0x0buy; 0x29uy; 0x53uy; 0x4fuy; 0x4cuy; 0x5auy; 0x73uy; 0x56uy; 0xfeuy; 0xafuy; 0x41uy; 0x01uy; 0x39uy; 0x0auy; 0x24uy; 0x3cuy; 0x7euy; 0xbeuy; 0x4euy; 0x53uy; 0xf3uy; 0xebuy; 0x06uy; 0x66uy; 0x51uy; 0x28uy; 0x1duy; 0xbduy; 0x41uy; 0x0auy; 0x01uy; 0xabuy; 0x16uy; 0x47uy; 0x27uy; 0x47uy; 0x47uy; 0xf7uy; 0xcbuy; 0x46uy; 0x0auy; 0x70uy; 0x9euy; 0x01uy; 0x9cuy; 0x09uy; 0xe1uy; 0x2auy; 0x00uy; 0x1auy; 0xd8uy; 0xd4uy; 0x79uy; 0x9duy; 0x80uy; 0x15uy; 0x8euy; 0x53uy; 0x2auy; 0x65uy; 0x83uy; 0x78uy; 0x3euy; 0x03uy; 0x00uy; 0x07uy; 0x12uy; 0x1fuy; 0x33uy; 0x3euy; 0x7buy; 0x13uy; 0x37uy; 0xf1uy; 0xc3uy; 0xefuy; 0xb7uy; 0xc1uy; 0x20uy; 0x3cuy; 0x3euy; 0x67uy; 0x66uy; 0x5duy; 0x88uy; 0xa7uy; 0x7duy; 0x33uy; 0x50uy; 0x77uy; 0xb0uy; 0x28uy; 0x8euy; 0xe7uy; 0x2cuy; 0x2euy; 0x7auy; 0xf4uy; 0x3cuy; 0x8duy; 0x74uy; 0x83uy; 0xafuy; 0x8euy; 0x87uy; 0x0fuy; 0xe4uy; 0x50uy; 0xffuy; 0x84uy; 0x5cuy; 0x47uy; 0x0cuy; 0x6auy; 0x49uy; 0xbfuy; 0x42uy; 0x86uy; 0x77uy; 0x15uy; 0x48uy; 0xa5uy; 0x90uy; 0x5duy; 0x93uy; 0xd6uy; 0x2auy; 0x11uy; 0xd5uy; 0xd5uy; 0x11uy; 0xaauy; 0xceuy; 0xe7uy; 0x6fuy; 0xa5uy; 0xb0uy; 0x09uy; 0x2cuy; 0x8duy; 0xd3uy; 0x92uy; 0xf0uy; 0x5auy; 0x2auy; 0xdauy; 0x5buy; 0x1euy; 0xd5uy; 0x9auy; 0xc4uy; 0xc4uy; 0xf3uy; 0x49uy; 0x74uy; 0x41uy; 0xcauy; 0xe8uy; 0xc1uy; 0xf8uy; 0x44uy; 0xd6uy; 0x3cuy; 0xaeuy; 0x6cuy; 0x1duy; 0x9auy; 0x30uy; 0x04uy; 0x4duy; 0x27uy; 0x0euy; 0xb1uy; 0x5fuy; 0x59uy; 0xa2uy; 0x24uy; 0xe8uy; 0xe1uy; 0x98uy; 0xc5uy; 0x6auy; 0x4cuy; 0xfeuy; 0x41uy; 0xd2uy; 0x27uy; 0x42uy; 0x52uy; 0xe1uy; 0xe9uy; 0x7duy; 0x62uy; 0xe4uy; 0x88uy; 0x0fuy; 0xaduy; 0xb2uy; 0x70uy; 0xcbuy; 0x9duy; 0x4cuy; 0x27uy; 0x2euy; 0x76uy; 0x1euy; 0x1auy; 0x63uy; 0x65uy; 0xf5uy; 0x3buy; 0xf8uy; 0x57uy; 0x69uy; 0xebuy; 0x5buy; 0x38uy; 0x26uy; 0x39uy; 0x33uy; 0x25uy; 0x45uy; 0x3euy; 0x91uy; 0xb8uy; 0xd8uy; 0xc7uy; 0xd5uy; 0x42uy; 0xc0uy; 0x22uy; 0x31uy; 0x74uy; 0xf4uy; 0xbcuy; 0x0cuy; 0x23uy; 0xf1uy; 0xcauy; 0xc1uy; 0x8duy; 0xd7uy; 0xbeuy; 0xc9uy; 0x62uy; 0xe4uy; 0x08uy; 0x1auy; 0xcfuy; 0x36uy; 0xd5uy; 0xfeuy; 0x55uy; 0x21uy; 0x59uy; 0x91uy; 0x87uy; 0x87uy; 0xdfuy; 0x06uy; 0xdbuy; 0xdfuy; 0x96uy; 0x45uy; 0x58uy; 0xdauy; 0x05uy; 0xcduy; 0x50uy; 0x4duy; 0xd2uy; 0x7duy; 0x05uy; 0x18uy; 0x73uy; 0x6auy; 0x8duy; 0x11uy; 0x85uy; 0xa6uy; 0x88uy; 0xe8uy; 0xdauy; 0xe6uy; 0x30uy; 0x33uy; 0xa4uy; 0x89uy; 0x31uy; 0x75uy; 0xbeuy; 0x69uy; 0x43uy; 0x84uy; 0x43uy; 0x50uy; 0x87uy; 0xdduy; 0x71uy; 0x36uy; 0x83uy; 0xc3uy; 0x78uy; 0x74uy; 0x24uy; 0x0auy; 0xeduy; 0x7buy; 0xdbuy; 0xa4uy; 0x24uy; 0x0buy; 0xb9uy; 0x7euy; 0x5duy; 0xffuy; 0xdeuy; 0xb1uy; 0xefuy; 0x61uy; 0x5auy; 0x45uy; 0x33uy; 0xf6uy; 0x17uy; 0x07uy; 0x08uy; 0x98uy; 0x83uy; 0x92uy; 0x0fuy; 0x23uy; 0x6duy; 0xe6uy; 0xaauy; 0x17uy; 0x54uy; 0xaduy; 0x6auy; 0xc8uy; 0xdbuy; 0x26uy; 0xbeuy; 0xb8uy; 0xb6uy; 0x08uy; 0xfauy; 0x68uy; 0xf1uy; 0xd7uy; 0x79uy; 0x6fuy; 0x18uy; 0xb4uy; 0x9euy; 0x2duy; 0x3fuy; 0x1buy; 0x64uy; 0xafuy; 0x8duy; 0x06uy; 0x0euy; 0x49uy; 0x28uy; 0xe0uy; 0x5duy; 0x45uy; 0x68uy; 0x13uy; 0x87uy; 0xfauy; 0xdeuy; 0x40uy; 0x7buy; 0xd2uy; 0xc3uy; 0x94uy; 0xd5uy; 0xe1uy; 0xd9uy; 0xc2uy; 0xafuy; 0x55uy; 0x89uy; 0xebuy; 0xb4uy; 0x12uy; 0x59uy; 0xa8uy; 0xd4uy; 0xc5uy; 0x29uy; 0x66uy; 0x38uy; 0xe6uy; 0xacuy; 0x22uy; 0x22uy; 0xd9uy; 0x64uy; 0x9buy; 0x34uy; 0x0auy; 0x32uy; 0x9fuy; 0xc2uy; 0xbfuy; 0x17uy; 0x6cuy; 0x3fuy; 0x71uy; 0x7auy; 0x38uy; 0x6buy; 0x98uy; 0xfbuy; 0x49uy; 0x36uy; 0x89uy; 0xc9uy; 0xe2uy; 0xd6uy; 0xc7uy; 0x5duy; 0xd0uy; 0x69uy; 0x5fuy; 0x23uy; 0x35uy; 0xc9uy; 0x30uy; 0xe2uy; 0xfduy; 0x44uy; 0x58uy; 0x39uy; 0xd7uy; 0x97uy; 0xfbuy; 0x5cuy; 0x00uy; 0xd5uy; 0x4fuy; 0x7auy; 0x1auy; 0x95uy; 0x8buy; 0x62uy; 0x4buy; 0xceuy; 0xe5uy; 0x91uy; 0x21uy; 0x7buy; 0x30uy; 0x00uy; 0xd6uy; 0xdduy; 0x6duy; 0x02uy; 0x86uy; 0x49uy; 0x0fuy; 0x3cuy; 0x1auy; 0x27uy; 0x3cuy; 0xd3uy; 0x0euy; 0x71uy; 0xf2uy; 0xffuy; 0xf5uy; 0x2fuy; 0x87uy; 0xacuy; 0x67uy; 0x59uy; 0x81uy; 0xa3uy; 0xf7uy; 0xf8uy; 0xd6uy; 0x11uy; 0x0cuy; 0x84uy; 0xa9uy; 0x03uy; 0xeeuy; 0x2auy; 0xc4uy; 0xf3uy; 0x22uy; 0xabuy; 0x7cuy; 0xe2uy; 0x25uy; 0xf5uy; 0x67uy; 0xa3uy; 0xe4uy; 0x11uy; 0xe0uy; 0x59uy; 0xb3uy; 0xcauy; 0x87uy; 0xa0uy; 0xaeuy; 0xc9uy; 0xa6uy; 0x62uy; 0x1buy; 0x6euy; 0x4duy; 0x02uy; 0x6buy; 0x07uy; 0x9duy; 0xfduy; 0xd0uy; 0x92uy; 0x06uy; 0xe1uy; 0xb2uy; 0x9auy; 0x4auy; 0x1fuy; 0x1fuy; 0x13uy; 0x49uy; 0x99uy; 0x97uy; 0x08uy; 0xdeuy; 0x7fuy; 0x98uy; 0xafuy; 0x51uy; 0x98uy; 0xeeuy; 0x2cuy; 0xcbuy; 0xf0uy; 0x0buy; 0xc6uy; 0xb6uy; 0xb7uy; 0x2duy; 0x9auy; 0xb1uy; 0xacuy; 0xa6uy; 0xe3uy; 0x15uy; 0x77uy; 0x9duy; 0x6buy; 0x1auy; 0xe4uy; 0xfcuy; 0x8buy; 0xf2uy; 0x17uy; 0x59uy; 0x08uy; 0x04uy; 0x58uy; 0x81uy; 0x9duy; 0x1buy; 0x1buy; 0x69uy; 0x55uy; 0xc2uy; 0xb4uy; 0x3cuy; 0x1fuy; 0x50uy; 0xf1uy; 0x7fuy; 0x77uy; 0x90uy; 0x4cuy; 0x66uy; 0x40uy; 0x5auy; 0xc0uy; 0x33uy; 0x1fuy; 0xcbuy; 0x05uy; 0x6duy; 0x5cuy; 0x06uy; 0x87uy; 0x52uy; 0xa2uy; 0x8fuy; 0x26uy; 0xd5uy; 0x4fuy; ] in
  assert_norm (List.Tot.length l = 1024);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input9_len: (x:UInt32.t { UInt32.v x = B.length input9 }) =
  1024ul

let output9: (b: B.buffer UInt8.t { B.length b = 1040 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xe5uy; 0x26uy; 0xa4uy; 0x3duy; 0xbduy; 0x33uy; 0xd0uy; 0x4buy; 0x6fuy; 0x05uy; 0xa7uy; 0x6euy; 0x12uy; 0x7auy; 0xd2uy; 0x74uy; 0xa6uy; 0xdduy; 0xbduy; 0x95uy; 0xebuy; 0xf9uy; 0xa4uy; 0xf1uy; 0x59uy; 0x93uy; 0x91uy; 0x70uy; 0xd9uy; 0xfeuy; 0x9auy; 0xcduy; 0x53uy; 0x1fuy; 0x3auy; 0xabuy; 0xa6uy; 0x7cuy; 0x9fuy; 0xa6uy; 0x9euy; 0xbduy; 0x99uy; 0xd9uy; 0xb5uy; 0x97uy; 0x44uy; 0xd5uy; 0x14uy; 0x48uy; 0x4duy; 0x9duy; 0xc0uy; 0xd0uy; 0x05uy; 0x96uy; 0xebuy; 0x4cuy; 0x78uy; 0x55uy; 0x09uy; 0x08uy; 0x01uy; 0x02uy; 0x30uy; 0x90uy; 0x7buy; 0x96uy; 0x7auy; 0x7buy; 0x5fuy; 0x30uy; 0x41uy; 0x24uy; 0xceuy; 0x68uy; 0x61uy; 0x49uy; 0x86uy; 0x57uy; 0x82uy; 0xdduy; 0x53uy; 0x1cuy; 0x51uy; 0x28uy; 0x2buy; 0x53uy; 0x6euy; 0x2duy; 0xc2uy; 0x20uy; 0x4cuy; 0xdduy; 0x8fuy; 0x65uy; 0x10uy; 0x20uy; 0x50uy; 0xdduy; 0x9duy; 0x50uy; 0xe5uy; 0x71uy; 0x40uy; 0x53uy; 0x69uy; 0xfcuy; 0x77uy; 0x48uy; 0x11uy; 0xb9uy; 0xdeuy; 0xa4uy; 0x8duy; 0x58uy; 0xe4uy; 0xa6uy; 0x1auy; 0x18uy; 0x47uy; 0x81uy; 0x7euy; 0xfcuy; 0xdduy; 0xf6uy; 0xefuy; 0xceuy; 0x2fuy; 0x43uy; 0x68uy; 0xd6uy; 0x06uy; 0xe2uy; 0x74uy; 0x6auy; 0xaduy; 0x90uy; 0xf5uy; 0x37uy; 0xf3uy; 0x3duy; 0x82uy; 0x69uy; 0x40uy; 0xe9uy; 0x6buy; 0xa7uy; 0x3duy; 0xa8uy; 0x1euy; 0xd2uy; 0x02uy; 0x7cuy; 0xb7uy; 0x9buy; 0xe4uy; 0xdauy; 0x8fuy; 0x95uy; 0x06uy; 0xc5uy; 0xdfuy; 0x73uy; 0xa3uy; 0x20uy; 0x9auy; 0x49uy; 0xdeuy; 0x9cuy; 0xbcuy; 0xeeuy; 0x14uy; 0x3fuy; 0x81uy; 0x5euy; 0xf8uy; 0x3buy; 0x59uy; 0x3cuy; 0xe1uy; 0x68uy; 0x12uy; 0x5auy; 0x3auy; 0x76uy; 0x3auy; 0x3fuy; 0xf7uy; 0x87uy; 0x33uy; 0x0auy; 0x01uy; 0xb8uy; 0xd4uy; 0xeduy; 0xb6uy; 0xbeuy; 0x94uy; 0x5euy; 0x70uy; 0x40uy; 0x56uy; 0x67uy; 0x1fuy; 0x50uy; 0x44uy; 0x19uy; 0xceuy; 0x82uy; 0x70uy; 0x10uy; 0x87uy; 0x13uy; 0x20uy; 0x0buy; 0x4cuy; 0x5auy; 0xb6uy; 0xf6uy; 0xa7uy; 0xaeuy; 0x81uy; 0x75uy; 0x01uy; 0x81uy; 0xe6uy; 0x4buy; 0x57uy; 0x7cuy; 0xdduy; 0x6duy; 0xf8uy; 0x1cuy; 0x29uy; 0x32uy; 0xf7uy; 0xdauy; 0x3cuy; 0x2duy; 0xf8uy; 0x9buy; 0x25uy; 0x6euy; 0x00uy; 0xb4uy; 0xf7uy; 0x2fuy; 0xf7uy; 0x04uy; 0xf7uy; 0xa1uy; 0x56uy; 0xacuy; 0x4fuy; 0x1auy; 0x64uy; 0xb8uy; 0x47uy; 0x55uy; 0x18uy; 0x7buy; 0x07uy; 0x4duy; 0xbduy; 0x47uy; 0x24uy; 0x80uy; 0x5duy; 0xa2uy; 0x70uy; 0xc5uy; 0xdduy; 0x8euy; 0x82uy; 0xd4uy; 0xebuy; 0xecuy; 0xb2uy; 0x0cuy; 0x39uy; 0xd2uy; 0x97uy; 0xc1uy; 0xcbuy; 0xebuy; 0xf4uy; 0x77uy; 0x59uy; 0xb4uy; 0x87uy; 0xefuy; 0xcbuy; 0x43uy; 0x2duy; 0x46uy; 0x54uy; 0xd1uy; 0xa7uy; 0xd7uy; 0x15uy; 0x99uy; 0x0auy; 0x43uy; 0xa1uy; 0xe0uy; 0x99uy; 0x33uy; 0x71uy; 0xc1uy; 0xeduy; 0xfeuy; 0x72uy; 0x46uy; 0x33uy; 0x8euy; 0x91uy; 0x08uy; 0x9fuy; 0xc8uy; 0x2euy; 0xcauy; 0xfauy; 0xdcuy; 0x59uy; 0xd5uy; 0xc3uy; 0x76uy; 0x84uy; 0x9fuy; 0xa3uy; 0x37uy; 0x68uy; 0xc3uy; 0xf0uy; 0x47uy; 0x2cuy; 0x68uy; 0xdbuy; 0x5euy; 0xc3uy; 0x49uy; 0x4cuy; 0xe8uy; 0x92uy; 0x85uy; 0xe2uy; 0x23uy; 0xd3uy; 0x3fuy; 0xaduy; 0x32uy; 0xe5uy; 0x2buy; 0x82uy; 0xd7uy; 0x8fuy; 0x99uy; 0x0auy; 0x59uy; 0x5cuy; 0x45uy; 0xd9uy; 0xb4uy; 0x51uy; 0x52uy; 0xc2uy; 0xaeuy; 0xbfuy; 0x80uy; 0xcfuy; 0xc9uy; 0xc9uy; 0x51uy; 0x24uy; 0x2auy; 0x3buy; 0x3auy; 0x4duy; 0xaeuy; 0xebuy; 0xbduy; 0x22uy; 0xc3uy; 0x0euy; 0x0fuy; 0x59uy; 0x25uy; 0x92uy; 0x17uy; 0xe9uy; 0x74uy; 0xc7uy; 0x8buy; 0x70uy; 0x70uy; 0x36uy; 0x55uy; 0x95uy; 0x75uy; 0x4buy; 0xaduy; 0x61uy; 0x2buy; 0x09uy; 0xbcuy; 0x82uy; 0xf2uy; 0x6euy; 0x94uy; 0x43uy; 0xaeuy; 0xc3uy; 0xd5uy; 0xcduy; 0x8euy; 0xfeuy; 0x5buy; 0x9auy; 0x88uy; 0x43uy; 0x01uy; 0x75uy; 0xb2uy; 0x23uy; 0x09uy; 0xf7uy; 0x89uy; 0x83uy; 0xe7uy; 0xfauy; 0xf9uy; 0xb4uy; 0x9buy; 0xf8uy; 0xefuy; 0xbduy; 0x1cuy; 0x92uy; 0xc1uy; 0xdauy; 0x7euy; 0xfeuy; 0x05uy; 0xbauy; 0x5auy; 0xcduy; 0x07uy; 0x6auy; 0x78uy; 0x9euy; 0x5duy; 0xfbuy; 0x11uy; 0x2fuy; 0x79uy; 0x38uy; 0xb6uy; 0xc2uy; 0x5buy; 0x6buy; 0x51uy; 0xb4uy; 0x71uy; 0xdduy; 0xf7uy; 0x2auy; 0xe4uy; 0xf4uy; 0x72uy; 0x76uy; 0xaduy; 0xc2uy; 0xdduy; 0x64uy; 0x5duy; 0x79uy; 0xb6uy; 0xf5uy; 0x7auy; 0x77uy; 0x20uy; 0x05uy; 0x3duy; 0x30uy; 0x06uy; 0xd4uy; 0x4cuy; 0x0auy; 0x2cuy; 0x98uy; 0x5auy; 0xb9uy; 0xd4uy; 0x98uy; 0xa9uy; 0x3fuy; 0xc6uy; 0x12uy; 0xeauy; 0x3buy; 0x4buy; 0xc5uy; 0x79uy; 0x64uy; 0x63uy; 0x6buy; 0x09uy; 0x54uy; 0x3buy; 0x14uy; 0x27uy; 0xbauy; 0x99uy; 0x80uy; 0xc8uy; 0x72uy; 0xa8uy; 0x12uy; 0x90uy; 0x29uy; 0xbauy; 0x40uy; 0x54uy; 0x97uy; 0x2buy; 0x7buy; 0xfeuy; 0xebuy; 0xcduy; 0x01uy; 0x05uy; 0x44uy; 0x72uy; 0xdbuy; 0x99uy; 0xe4uy; 0x61uy; 0xc9uy; 0x69uy; 0xd6uy; 0xb9uy; 0x28uy; 0xd1uy; 0x05uy; 0x3euy; 0xf9uy; 0x0buy; 0x49uy; 0x0auy; 0x49uy; 0xe9uy; 0x8duy; 0x0euy; 0xa7uy; 0x4auy; 0x0fuy; 0xafuy; 0x32uy; 0xd0uy; 0xe0uy; 0xb2uy; 0x3auy; 0x55uy; 0x58uy; 0xfeuy; 0x5cuy; 0x28uy; 0x70uy; 0x51uy; 0x23uy; 0xb0uy; 0x7buy; 0x6auy; 0x5fuy; 0x1euy; 0xb8uy; 0x17uy; 0xd7uy; 0x94uy; 0x15uy; 0x8fuy; 0xeeuy; 0x20uy; 0xc7uy; 0x42uy; 0x25uy; 0x3euy; 0x9auy; 0x14uy; 0xd7uy; 0x60uy; 0x72uy; 0x39uy; 0x47uy; 0x48uy; 0xa9uy; 0xfeuy; 0xdduy; 0x47uy; 0x0auy; 0xb1uy; 0xe6uy; 0x60uy; 0x28uy; 0x8cuy; 0x11uy; 0x68uy; 0xe1uy; 0xffuy; 0xd7uy; 0xceuy; 0xc8uy; 0xbeuy; 0xb3uy; 0xfeuy; 0x27uy; 0x30uy; 0x09uy; 0x70uy; 0xd7uy; 0xfauy; 0x02uy; 0x33uy; 0x3auy; 0x61uy; 0x2euy; 0xc7uy; 0xffuy; 0xa4uy; 0x2auy; 0xa8uy; 0x6euy; 0xb4uy; 0x79uy; 0x35uy; 0x6duy; 0x4cuy; 0x1euy; 0x38uy; 0xf8uy; 0xeeuy; 0xd4uy; 0x84uy; 0x4euy; 0x6euy; 0x28uy; 0xa7uy; 0xceuy; 0xc8uy; 0xc1uy; 0xcfuy; 0x80uy; 0x05uy; 0xf3uy; 0x04uy; 0xefuy; 0xc8uy; 0x18uy; 0x28uy; 0x2euy; 0x8duy; 0x5euy; 0x0cuy; 0xdfuy; 0xb8uy; 0x5fuy; 0x96uy; 0xe8uy; 0xc6uy; 0x9cuy; 0x2fuy; 0xe5uy; 0xa6uy; 0x44uy; 0xd7uy; 0xe7uy; 0x99uy; 0x44uy; 0x0cuy; 0xecuy; 0xd7uy; 0x05uy; 0x60uy; 0x97uy; 0xbbuy; 0x74uy; 0x77uy; 0x58uy; 0xd5uy; 0xbbuy; 0x48uy; 0xdeuy; 0x5auy; 0xb2uy; 0x54uy; 0x7fuy; 0x0euy; 0x46uy; 0x70uy; 0x6auy; 0x6fuy; 0x78uy; 0xa5uy; 0x08uy; 0x89uy; 0x05uy; 0x4euy; 0x7euy; 0xa0uy; 0x69uy; 0xb4uy; 0x40uy; 0x60uy; 0x55uy; 0x77uy; 0x75uy; 0x9buy; 0x19uy; 0xf2uy; 0xd5uy; 0x13uy; 0x80uy; 0x77uy; 0xf9uy; 0x4buy; 0x3fuy; 0x1euy; 0xeeuy; 0xe6uy; 0x76uy; 0x84uy; 0x7buy; 0x8cuy; 0xe5uy; 0x27uy; 0xa8uy; 0x0auy; 0x91uy; 0x01uy; 0x68uy; 0x71uy; 0x8auy; 0x3fuy; 0x06uy; 0xabuy; 0xf6uy; 0xa9uy; 0xa5uy; 0xe6uy; 0x72uy; 0x92uy; 0xe4uy; 0x67uy; 0xe2uy; 0xa2uy; 0x46uy; 0x35uy; 0x84uy; 0x55uy; 0x7duy; 0xcauy; 0xa8uy; 0x85uy; 0xd0uy; 0xf1uy; 0x3fuy; 0xbeuy; 0xd7uy; 0x34uy; 0x64uy; 0xfcuy; 0xaeuy; 0xe3uy; 0xe4uy; 0x04uy; 0x9fuy; 0x66uy; 0x02uy; 0xb9uy; 0x88uy; 0x10uy; 0xd9uy; 0xc4uy; 0x4cuy; 0x31uy; 0x43uy; 0x7auy; 0x93uy; 0xe2uy; 0x9buy; 0x56uy; 0x43uy; 0x84uy; 0xdcuy; 0xdcuy; 0xdeuy; 0x1duy; 0xa4uy; 0x02uy; 0x0euy; 0xc2uy; 0xefuy; 0xc3uy; 0xf8uy; 0x78uy; 0xd1uy; 0xb2uy; 0x6buy; 0x63uy; 0x18uy; 0xc9uy; 0xa9uy; 0xe5uy; 0x72uy; 0xd8uy; 0xf3uy; 0xb9uy; 0xd1uy; 0x8auy; 0xc7uy; 0x1auy; 0x02uy; 0x27uy; 0x20uy; 0x77uy; 0x10uy; 0xe5uy; 0xc8uy; 0xd4uy; 0x4auy; 0x47uy; 0xe5uy; 0xdfuy; 0x5fuy; 0x01uy; 0xaauy; 0xb0uy; 0xd4uy; 0x10uy; 0xbbuy; 0x69uy; 0xe3uy; 0x36uy; 0xc8uy; 0xe1uy; 0x3duy; 0x43uy; 0xfbuy; 0x86uy; 0xcduy; 0xccuy; 0xbfuy; 0xf4uy; 0x88uy; 0xe0uy; 0x20uy; 0xcauy; 0xb7uy; 0x1buy; 0xf1uy; 0x2fuy; 0x5cuy; 0xeeuy; 0xd4uy; 0xd3uy; 0xa3uy; 0xccuy; 0xa4uy; 0x1euy; 0x1cuy; 0x47uy; 0xfbuy; 0xbfuy; 0xfcuy; 0xa2uy; 0x41uy; 0x55uy; 0x9duy; 0xf6uy; 0x5auy; 0x5euy; 0x65uy; 0x32uy; 0x34uy; 0x7buy; 0x52uy; 0x8duy; 0xd5uy; 0xd0uy; 0x20uy; 0x60uy; 0x03uy; 0xabuy; 0x3fuy; 0x8cuy; 0xd4uy; 0x21uy; 0xeauy; 0x2auy; 0xd9uy; 0xc4uy; 0xd0uy; 0xd3uy; 0x65uy; 0xd8uy; 0x7auy; 0x13uy; 0x28uy; 0x62uy; 0x32uy; 0x4buy; 0x2cuy; 0x87uy; 0x93uy; 0xa8uy; 0xb4uy; 0x52uy; 0x45uy; 0x09uy; 0x44uy; 0xecuy; 0xecuy; 0xc3uy; 0x17uy; 0xdbuy; 0x9auy; 0x4duy; 0x5cuy; 0xa9uy; 0x11uy; 0xd4uy; 0x7duy; 0xafuy; 0x9euy; 0xf1uy; 0x2duy; 0xb2uy; 0x66uy; 0xc5uy; 0x1duy; 0xeduy; 0xb7uy; 0xcduy; 0x0buy; 0x25uy; 0x5euy; 0x30uy; 0x47uy; 0x3fuy; 0x40uy; 0xf4uy; 0xa1uy; 0xa0uy; 0x00uy; 0x94uy; 0x10uy; 0xc5uy; 0x6auy; 0x63uy; 0x1auy; 0xd5uy; 0x88uy; 0x92uy; 0x8euy; 0x82uy; 0x39uy; 0x87uy; 0x3cuy; 0x78uy; 0x65uy; 0x58uy; 0x42uy; 0x75uy; 0x5buy; 0xdduy; 0x77uy; 0x3euy; 0x09uy; 0x4euy; 0x76uy; 0x5buy; 0xe6uy; 0x0euy; 0x4duy; 0x38uy; 0xb2uy; 0xc0uy; 0xb8uy; 0x95uy; 0x01uy; 0x7auy; 0x10uy; 0xe0uy; 0xfbuy; 0x07uy; 0xf2uy; 0xabuy; 0x2duy; 0x8cuy; 0x32uy; 0xeduy; 0x2buy; 0xc0uy; 0x46uy; 0xc2uy; 0xf5uy; 0x38uy; 0x83uy; 0xf0uy; 0x17uy; 0xecuy; 0xc1uy; 0x20uy; 0x6auy; 0x9auy; 0x0buy; 0x00uy; 0xa0uy; 0x98uy; 0x22uy; 0x50uy; 0x23uy; 0xd5uy; 0x80uy; 0x6buy; 0xf6uy; 0x1fuy; 0xc3uy; 0xccuy; 0x97uy; 0xc9uy; 0x24uy; 0x9fuy; 0xf3uy; 0xafuy; 0x43uy; 0x14uy; 0xd5uy; 0xa0uy; ] in
  assert_norm (List.Tot.length l = 1040);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output9_len: (x:UInt32.t { UInt32.v x = B.length output9 }) =
  1040ul

let key10: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x35uy; 0x4euy; 0xb5uy; 0x70uy; 0x50uy; 0x42uy; 0x8auy; 0x85uy; 0xf2uy; 0xfbuy; 0xeduy; 0x7buy; 0xd0uy; 0x9euy; 0x97uy; 0xcauy; 0xfauy; 0x98uy; 0x66uy; 0x63uy; 0xeeuy; 0x37uy; 0xccuy; 0x52uy; 0xfeuy; 0xd1uy; 0xdfuy; 0x95uy; 0x15uy; 0x34uy; 0x29uy; 0x38uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key10_len: (x:UInt32.t { UInt32.v x = B.length key10 }) =
  32ul

let nonce10: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xfduy; 0x87uy; 0xd4uy; 0xd8uy; 0x62uy; 0xfduy; 0xecuy; 0xaauy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce10_len: (x:UInt32.t { UInt32.v x = B.length nonce10 }) =
  12ul

let aad10: (b: B.buffer UInt8.t { B.length b = 7 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xd6uy; 0x31uy; 0xdauy; 0x5duy; 0x42uy; 0x5euy; 0xd7uy; ] in
  assert_norm (List.Tot.length l = 7);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad10_len: (x:UInt32.t { UInt32.v x = B.length aad10 }) =
  7ul

let input10: (b: B.buffer UInt8.t { B.length b = 1933 /\ B.recallable b /\ B.disjoint b aad10 }) =
     B.recall aad10;[@inline_let] let l = [ 0x7auy; 0x57uy; 0xf2uy; 0xc7uy; 0x06uy; 0x3fuy; 0x50uy; 0x7buy; 0x36uy; 0x1auy; 0x66uy; 0x5cuy; 0xb9uy; 0x0euy; 0x5euy; 0x3buy; 0x45uy; 0x60uy; 0xbeuy; 0x9auy; 0x31uy; 0x9fuy; 0xffuy; 0x5duy; 0x66uy; 0x34uy; 0xb4uy; 0xdcuy; 0xfbuy; 0x9duy; 0x8euy; 0xeeuy; 0x6auy; 0x33uy; 0xa4uy; 0x07uy; 0x3cuy; 0xf9uy; 0x4cuy; 0x30uy; 0xa1uy; 0x24uy; 0x52uy; 0xf9uy; 0x50uy; 0x46uy; 0x88uy; 0x20uy; 0x02uy; 0x32uy; 0x3auy; 0x0euy; 0x99uy; 0x63uy; 0xafuy; 0x1fuy; 0x15uy; 0x28uy; 0x2auy; 0x05uy; 0xffuy; 0x57uy; 0x59uy; 0x5euy; 0x18uy; 0xa1uy; 0x1fuy; 0xd0uy; 0x92uy; 0x5cuy; 0x88uy; 0x66uy; 0x1buy; 0x00uy; 0x64uy; 0xa5uy; 0x93uy; 0x8duy; 0x06uy; 0x46uy; 0xb0uy; 0x64uy; 0x8buy; 0x8buy; 0xefuy; 0x99uy; 0x05uy; 0x35uy; 0x85uy; 0xb3uy; 0xf3uy; 0x33uy; 0xbbuy; 0xecuy; 0x66uy; 0xb6uy; 0x3duy; 0x57uy; 0x42uy; 0xe3uy; 0xb4uy; 0xc6uy; 0xaauy; 0xb0uy; 0x41uy; 0x2auy; 0xb9uy; 0x59uy; 0xa9uy; 0xf6uy; 0x3euy; 0x15uy; 0x26uy; 0x12uy; 0x03uy; 0x21uy; 0x4cuy; 0x74uy; 0x43uy; 0x13uy; 0x2auy; 0x03uy; 0x27uy; 0x09uy; 0xb4uy; 0xfbuy; 0xe7uy; 0xb7uy; 0x40uy; 0xffuy; 0x5euy; 0xceuy; 0x48uy; 0x9auy; 0x60uy; 0xe3uy; 0x8buy; 0x80uy; 0x8cuy; 0x38uy; 0x2duy; 0xcbuy; 0x93uy; 0x37uy; 0x74uy; 0x05uy; 0x52uy; 0x6fuy; 0x73uy; 0x3euy; 0xc3uy; 0xbcuy; 0xcauy; 0x72uy; 0x0auy; 0xebuy; 0xf1uy; 0x3buy; 0xa0uy; 0x95uy; 0xdcuy; 0x8auy; 0xc4uy; 0xa9uy; 0xdcuy; 0xcauy; 0x44uy; 0xd8uy; 0x08uy; 0x63uy; 0x6auy; 0x36uy; 0xd3uy; 0x3cuy; 0xb8uy; 0xacuy; 0x46uy; 0x7duy; 0xfduy; 0xaauy; 0xebuy; 0x3euy; 0x0fuy; 0x45uy; 0x8fuy; 0x49uy; 0xdauy; 0x2buy; 0xf2uy; 0x12uy; 0xbduy; 0xafuy; 0x67uy; 0x8auy; 0x63uy; 0x48uy; 0x4buy; 0x55uy; 0x5fuy; 0x6duy; 0x8cuy; 0xb9uy; 0x76uy; 0x34uy; 0x84uy; 0xaeuy; 0xc2uy; 0xfcuy; 0x52uy; 0x64uy; 0x82uy; 0xf7uy; 0xb0uy; 0x06uy; 0xf0uy; 0x45uy; 0x73uy; 0x12uy; 0x50uy; 0x30uy; 0x72uy; 0xeauy; 0x78uy; 0x9auy; 0xa8uy; 0xafuy; 0xb5uy; 0xe3uy; 0xbbuy; 0x77uy; 0x52uy; 0xecuy; 0x59uy; 0x84uy; 0xbfuy; 0x6buy; 0x8fuy; 0xceuy; 0x86uy; 0x5euy; 0x1fuy; 0x23uy; 0xe9uy; 0xfbuy; 0x08uy; 0x86uy; 0xf7uy; 0x10uy; 0xb9uy; 0xf2uy; 0x44uy; 0x96uy; 0x44uy; 0x63uy; 0xa9uy; 0xa8uy; 0x78uy; 0x00uy; 0x23uy; 0xd6uy; 0xc7uy; 0xe7uy; 0x6euy; 0x66uy; 0x4fuy; 0xccuy; 0xeeuy; 0x15uy; 0xb3uy; 0xbduy; 0x1duy; 0xa0uy; 0xe5uy; 0x9cuy; 0x1buy; 0x24uy; 0x2cuy; 0x4duy; 0x3cuy; 0x62uy; 0x35uy; 0x9cuy; 0x88uy; 0x59uy; 0x09uy; 0xdduy; 0x82uy; 0x1buy; 0xcfuy; 0x0auy; 0x83uy; 0x6buy; 0x3fuy; 0xaeuy; 0x03uy; 0xc4uy; 0xb4uy; 0xdduy; 0x7euy; 0x5buy; 0x28uy; 0x76uy; 0x25uy; 0x96uy; 0xd9uy; 0xc9uy; 0x9duy; 0x5fuy; 0x86uy; 0xfauy; 0xf6uy; 0xd7uy; 0xd2uy; 0xe6uy; 0x76uy; 0x1duy; 0x0fuy; 0xa1uy; 0xdcuy; 0x74uy; 0x05uy; 0x1buy; 0x1duy; 0xe0uy; 0xcduy; 0x16uy; 0xb0uy; 0xa8uy; 0x8auy; 0x34uy; 0x7buy; 0x15uy; 0x11uy; 0x77uy; 0xe5uy; 0x7buy; 0x7euy; 0x20uy; 0xf7uy; 0xdauy; 0x38uy; 0xdauy; 0xceuy; 0x70uy; 0xe9uy; 0xf5uy; 0x6cuy; 0xd9uy; 0xbeuy; 0x0cuy; 0x4cuy; 0x95uy; 0x4cuy; 0xc2uy; 0x9buy; 0x34uy; 0x55uy; 0x55uy; 0xe1uy; 0xf3uy; 0x46uy; 0x8euy; 0x48uy; 0x74uy; 0x14uy; 0x4fuy; 0x9duy; 0xc9uy; 0xf5uy; 0xe8uy; 0x1auy; 0xf0uy; 0x11uy; 0x4auy; 0xc1uy; 0x8duy; 0xe0uy; 0x93uy; 0xa0uy; 0xbeuy; 0x09uy; 0x1cuy; 0x2buy; 0x4euy; 0x0fuy; 0xb2uy; 0x87uy; 0x8buy; 0x84uy; 0xfeuy; 0x92uy; 0x32uy; 0x14uy; 0xd7uy; 0x93uy; 0xdfuy; 0xe7uy; 0x44uy; 0xbcuy; 0xc5uy; 0xaeuy; 0x53uy; 0x69uy; 0xd8uy; 0xb3uy; 0x79uy; 0x37uy; 0x80uy; 0xe3uy; 0x17uy; 0x5cuy; 0xecuy; 0x53uy; 0x00uy; 0x9auy; 0xe3uy; 0x8euy; 0xdcuy; 0x38uy; 0xb8uy; 0x66uy; 0xf0uy; 0xd3uy; 0xaduy; 0x1duy; 0x02uy; 0x96uy; 0x86uy; 0x3euy; 0x9duy; 0x3buy; 0x5duy; 0xa5uy; 0x7fuy; 0x21uy; 0x10uy; 0xf1uy; 0x1fuy; 0x13uy; 0x20uy; 0xf9uy; 0x57uy; 0x87uy; 0x20uy; 0xf5uy; 0x5fuy; 0xf1uy; 0x17uy; 0x48uy; 0x0auy; 0x51uy; 0x5auy; 0xcduy; 0x19uy; 0x03uy; 0xa6uy; 0x5auy; 0xd1uy; 0x12uy; 0x97uy; 0xe9uy; 0x48uy; 0xe2uy; 0x1duy; 0x83uy; 0x75uy; 0x50uy; 0xd9uy; 0x75uy; 0x7duy; 0x6auy; 0x82uy; 0xa1uy; 0xf9uy; 0x4euy; 0x54uy; 0x87uy; 0x89uy; 0xc9uy; 0x0cuy; 0xb7uy; 0x5buy; 0x6auy; 0x91uy; 0xc1uy; 0x9cuy; 0xb2uy; 0xa9uy; 0xdcuy; 0x9auy; 0xa4uy; 0x49uy; 0x0auy; 0x6duy; 0x0duy; 0xbbuy; 0xdeuy; 0x86uy; 0x44uy; 0xdduy; 0x5duy; 0x89uy; 0x2buy; 0x96uy; 0x0fuy; 0x23uy; 0x95uy; 0xaduy; 0xccuy; 0xa2uy; 0xb3uy; 0xb9uy; 0x7euy; 0x74uy; 0x38uy; 0xbauy; 0x9fuy; 0x73uy; 0xaeuy; 0x5fuy; 0xf8uy; 0x68uy; 0xa2uy; 0xe0uy; 0xa9uy; 0xceuy; 0xbduy; 0x40uy; 0xd4uy; 0x4cuy; 0x6buy; 0xd2uy; 0x56uy; 0x62uy; 0xb0uy; 0xccuy; 0x63uy; 0x7euy; 0x5buy; 0xd3uy; 0xaeuy; 0xd1uy; 0x75uy; 0xceuy; 0xbbuy; 0xb4uy; 0x5buy; 0xa8uy; 0xf8uy; 0xb4uy; 0xacuy; 0x71uy; 0x75uy; 0xaauy; 0xc9uy; 0x9fuy; 0xbbuy; 0x6cuy; 0xaduy; 0x0fuy; 0x55uy; 0x5duy; 0xe8uy; 0x85uy; 0x7duy; 0xf9uy; 0x21uy; 0x35uy; 0xeauy; 0x92uy; 0x85uy; 0x2buy; 0x00uy; 0xecuy; 0x84uy; 0x90uy; 0x0auy; 0x63uy; 0x96uy; 0xe4uy; 0x6buy; 0xa9uy; 0x77uy; 0xb8uy; 0x91uy; 0xf8uy; 0x46uy; 0x15uy; 0x72uy; 0x63uy; 0x70uy; 0x01uy; 0x40uy; 0xa3uy; 0xa5uy; 0x76uy; 0x62uy; 0x2buy; 0xbfuy; 0xf1uy; 0xe5uy; 0x8duy; 0x9fuy; 0xa3uy; 0xfauy; 0x9buy; 0x03uy; 0xbeuy; 0xfeuy; 0x65uy; 0x6fuy; 0xa2uy; 0x29uy; 0x0duy; 0x54uy; 0xb4uy; 0x71uy; 0xceuy; 0xa9uy; 0xd6uy; 0x3duy; 0x88uy; 0xf9uy; 0xafuy; 0x6buy; 0xa8uy; 0x9euy; 0xf4uy; 0x16uy; 0x96uy; 0x36uy; 0xb9uy; 0x00uy; 0xdcuy; 0x10uy; 0xabuy; 0xb5uy; 0x08uy; 0x31uy; 0x1fuy; 0x00uy; 0xb1uy; 0x3cuy; 0xd9uy; 0x38uy; 0x3euy; 0xc6uy; 0x04uy; 0xa7uy; 0x4euy; 0xe8uy; 0xaeuy; 0xeduy; 0x98uy; 0xc2uy; 0xf7uy; 0xb9uy; 0x00uy; 0x5fuy; 0x8cuy; 0x60uy; 0xd1uy; 0xe5uy; 0x15uy; 0xf7uy; 0xaeuy; 0x1euy; 0x84uy; 0x88uy; 0xd1uy; 0xf6uy; 0xbcuy; 0x3auy; 0x89uy; 0x35uy; 0x22uy; 0x83uy; 0x7cuy; 0xcauy; 0xf0uy; 0x33uy; 0x82uy; 0x4cuy; 0x79uy; 0x3cuy; 0xfduy; 0xb1uy; 0xaeuy; 0x52uy; 0x62uy; 0x55uy; 0xd2uy; 0x41uy; 0x60uy; 0xc6uy; 0xbbuy; 0xfauy; 0x0euy; 0x59uy; 0xd6uy; 0xa8uy; 0xfeuy; 0x5duy; 0xeduy; 0x47uy; 0x3duy; 0xe0uy; 0xeauy; 0x1fuy; 0x6euy; 0x43uy; 0x51uy; 0xecuy; 0x10uy; 0x52uy; 0x56uy; 0x77uy; 0x42uy; 0x6buy; 0x52uy; 0x87uy; 0xd8uy; 0xecuy; 0xe0uy; 0xaauy; 0x76uy; 0xa5uy; 0x84uy; 0x2auy; 0x22uy; 0x24uy; 0xfduy; 0x92uy; 0x40uy; 0x88uy; 0xd5uy; 0x85uy; 0x1cuy; 0x1fuy; 0x6buy; 0x47uy; 0xa0uy; 0xc4uy; 0xe4uy; 0xefuy; 0xf4uy; 0xeauy; 0xd7uy; 0x59uy; 0xacuy; 0x2auy; 0x9euy; 0x8cuy; 0xfauy; 0x1fuy; 0x42uy; 0x08uy; 0xfeuy; 0x4fuy; 0x74uy; 0xa0uy; 0x26uy; 0xf5uy; 0xb3uy; 0x84uy; 0xf6uy; 0x58uy; 0x5fuy; 0x26uy; 0x66uy; 0x3euy; 0xd7uy; 0xe4uy; 0x22uy; 0x91uy; 0x13uy; 0xc8uy; 0xacuy; 0x25uy; 0x96uy; 0x23uy; 0xd8uy; 0x09uy; 0xeauy; 0x45uy; 0x75uy; 0x23uy; 0xb8uy; 0x5fuy; 0xc2uy; 0x90uy; 0x8buy; 0x09uy; 0xc4uy; 0xfcuy; 0x47uy; 0x6cuy; 0x6duy; 0x0auy; 0xefuy; 0x69uy; 0xa4uy; 0x38uy; 0x19uy; 0xcfuy; 0x7duy; 0xf9uy; 0x09uy; 0x73uy; 0x9buy; 0x60uy; 0x5auy; 0xf7uy; 0x37uy; 0xb5uy; 0xfeuy; 0x9fuy; 0xe3uy; 0x2buy; 0x4cuy; 0x0duy; 0x6euy; 0x19uy; 0xf1uy; 0xd6uy; 0xc0uy; 0x70uy; 0xf3uy; 0x9duy; 0x22uy; 0x3cuy; 0xf9uy; 0x49uy; 0xceuy; 0x30uy; 0x8euy; 0x44uy; 0xb5uy; 0x76uy; 0x15uy; 0x8fuy; 0x52uy; 0xfduy; 0xa5uy; 0x04uy; 0xb8uy; 0x55uy; 0x6auy; 0x36uy; 0x59uy; 0x7cuy; 0xc4uy; 0x48uy; 0xb8uy; 0xd7uy; 0xabuy; 0x05uy; 0x66uy; 0xe9uy; 0x5euy; 0x21uy; 0x6fuy; 0x6buy; 0x36uy; 0x29uy; 0xbbuy; 0xe9uy; 0xe3uy; 0xa2uy; 0x9auy; 0xa8uy; 0xcduy; 0x55uy; 0x25uy; 0x11uy; 0xbauy; 0x5auy; 0x58uy; 0xa0uy; 0xdeuy; 0xaeuy; 0x19uy; 0x2auy; 0x48uy; 0x5auy; 0xffuy; 0x36uy; 0xcduy; 0x6duy; 0x16uy; 0x7auy; 0x73uy; 0x38uy; 0x46uy; 0xe5uy; 0x47uy; 0x59uy; 0xc8uy; 0xa2uy; 0xf6uy; 0xe2uy; 0x6cuy; 0x83uy; 0xc5uy; 0x36uy; 0x2cuy; 0x83uy; 0x7duy; 0xb4uy; 0x01uy; 0x05uy; 0x69uy; 0xe7uy; 0xafuy; 0x5cuy; 0xc4uy; 0x64uy; 0x82uy; 0x12uy; 0x21uy; 0xefuy; 0xf7uy; 0xd1uy; 0x7duy; 0xb8uy; 0x8duy; 0x8cuy; 0x98uy; 0x7cuy; 0x5fuy; 0x7duy; 0x92uy; 0x88uy; 0xb9uy; 0x94uy; 0x07uy; 0x9cuy; 0xd8uy; 0xe9uy; 0x9cuy; 0x17uy; 0x38uy; 0xe3uy; 0x57uy; 0x6cuy; 0xe0uy; 0xdcuy; 0xa5uy; 0x92uy; 0x42uy; 0xb3uy; 0xbduy; 0x50uy; 0xa2uy; 0x7euy; 0xb5uy; 0xb1uy; 0x52uy; 0x72uy; 0x03uy; 0x97uy; 0xd8uy; 0xaauy; 0x9auy; 0x1euy; 0x75uy; 0x41uy; 0x11uy; 0xa3uy; 0x4fuy; 0xccuy; 0xd4uy; 0xe3uy; 0x73uy; 0xaduy; 0x96uy; 0xdcuy; 0x47uy; 0x41uy; 0x9fuy; 0xb0uy; 0xbeuy; 0x79uy; 0x91uy; 0xf5uy; 0xb6uy; 0x18uy; 0xfeuy; 0xc2uy; 0x83uy; 0x18uy; 0x7duy; 0x73uy; 0xd9uy; 0x4fuy; 0x83uy; 0x84uy; 0x03uy; 0xb3uy; 0xf0uy; 0x77uy; 0x66uy; 0x3duy; 0x83uy; 0x63uy; 0x2euy; 0x2cuy; 0xf9uy; 0xdduy; 0xa6uy; 0x1fuy; 0x89uy; 0x82uy; 0xb8uy; 0x23uy; 0x42uy; 0xebuy; 0xe2uy; 0xcauy; 0x70uy; 0x82uy; 0x61uy; 0x41uy; 0x0auy; 0x6duy; 0x5fuy; 0x75uy; 0xc5uy; 0xe2uy; 0xc4uy; 0x91uy; 0x18uy; 0x44uy; 0x22uy; 0xfauy; 0x34uy; 0x10uy; 0xf5uy; 0x20uy; 0xdcuy; 0xb7uy; 0xdduy; 0x2auy; 0x20uy; 0x77uy; 0xf5uy; 0xf9uy; 0xceuy; 0xdbuy; 0xa0uy; 0x0auy; 0x52uy; 0x2auy; 0x4euy; 0xdduy; 0xccuy; 0x97uy; 0xdfuy; 0x05uy; 0xe4uy; 0x5euy; 0xb7uy; 0xaauy; 0xf0uy; 0xe2uy; 0x80uy; 0xffuy; 0xbauy; 0x1auy; 0x0fuy; 0xacuy; 0xdfuy; 0x02uy; 0x32uy; 0xe6uy; 0xf7uy; 0xc7uy; 0x17uy; 0x13uy; 0xb7uy; 0xfcuy; 0x98uy; 0x48uy; 0x8cuy; 0x0duy; 0x82uy; 0xc9uy; 0x80uy; 0x7auy; 0xe2uy; 0x0auy; 0xc5uy; 0xb4uy; 0xdeuy; 0x7cuy; 0x3cuy; 0x79uy; 0x81uy; 0x0euy; 0x28uy; 0x65uy; 0x79uy; 0x67uy; 0x82uy; 0x69uy; 0x44uy; 0x66uy; 0x09uy; 0xf7uy; 0x16uy; 0x1auy; 0xf9uy; 0x7duy; 0x80uy; 0xa1uy; 0x79uy; 0x14uy; 0xa9uy; 0xc8uy; 0x20uy; 0xfbuy; 0xa2uy; 0x46uy; 0xbeuy; 0x08uy; 0x35uy; 0x17uy; 0x58uy; 0xc1uy; 0x1auy; 0xdauy; 0x2auy; 0x6buy; 0x2euy; 0x1euy; 0xe6uy; 0x27uy; 0x55uy; 0x7buy; 0x19uy; 0xe2uy; 0xfbuy; 0x64uy; 0xfcuy; 0x5euy; 0x15uy; 0x54uy; 0x3cuy; 0xe7uy; 0xc2uy; 0x11uy; 0x50uy; 0x30uy; 0xb8uy; 0x72uy; 0x03uy; 0x0buy; 0x1auy; 0x9fuy; 0x86uy; 0x27uy; 0x11uy; 0x5cuy; 0x06uy; 0x2buy; 0xbduy; 0x75uy; 0x1auy; 0x0auy; 0xdauy; 0x01uy; 0xfauy; 0x5cuy; 0x4auy; 0xc1uy; 0x80uy; 0x3auy; 0x6euy; 0x30uy; 0xc8uy; 0x2cuy; 0xebuy; 0x56uy; 0xecuy; 0x89uy; 0xfauy; 0x35uy; 0x7buy; 0xb2uy; 0xf0uy; 0x97uy; 0x08uy; 0x86uy; 0x53uy; 0xbeuy; 0xbduy; 0x40uy; 0x41uy; 0x38uy; 0x1cuy; 0xb4uy; 0x8buy; 0x79uy; 0x2euy; 0x18uy; 0x96uy; 0x94uy; 0xdeuy; 0xe8uy; 0xcauy; 0xe5uy; 0x9fuy; 0x92uy; 0x9fuy; 0x15uy; 0x5duy; 0x56uy; 0x60uy; 0x5cuy; 0x09uy; 0xf9uy; 0x16uy; 0xf4uy; 0x17uy; 0x0fuy; 0xf6uy; 0x4cuy; 0xdauy; 0xe6uy; 0x67uy; 0x89uy; 0x9fuy; 0xcauy; 0x6cuy; 0xe7uy; 0x9buy; 0x04uy; 0x62uy; 0x0euy; 0x26uy; 0xa6uy; 0x52uy; 0xbduy; 0x29uy; 0xffuy; 0xc7uy; 0xa4uy; 0x96uy; 0xe6uy; 0x6auy; 0x02uy; 0xa5uy; 0x2euy; 0x7buy; 0xfeuy; 0x97uy; 0x68uy; 0x3euy; 0x2euy; 0x5fuy; 0x3buy; 0x0fuy; 0x36uy; 0xd6uy; 0x98uy; 0x19uy; 0x59uy; 0x48uy; 0xd2uy; 0xc6uy; 0xe1uy; 0x55uy; 0x1auy; 0x6euy; 0xd6uy; 0xeduy; 0x2cuy; 0xbauy; 0xc3uy; 0x9euy; 0x64uy; 0xc9uy; 0x95uy; 0x86uy; 0x35uy; 0x5euy; 0x3euy; 0x88uy; 0x69uy; 0x99uy; 0x4buy; 0xeeuy; 0xbeuy; 0x9auy; 0x99uy; 0xb5uy; 0x6euy; 0x58uy; 0xaeuy; 0xdduy; 0x22uy; 0xdbuy; 0xdduy; 0x6buy; 0xfcuy; 0xafuy; 0x90uy; 0xa3uy; 0x3duy; 0xa4uy; 0xc1uy; 0x15uy; 0x92uy; 0x18uy; 0x8duy; 0xd2uy; 0x4buy; 0x7buy; 0x06uy; 0xd1uy; 0x37uy; 0xb5uy; 0xe2uy; 0x7cuy; 0x2cuy; 0xf0uy; 0x25uy; 0xe4uy; 0x94uy; 0x2auy; 0xbduy; 0xe3uy; 0x82uy; 0x70uy; 0x78uy; 0xa3uy; 0x82uy; 0x10uy; 0x5auy; 0x90uy; 0xd7uy; 0xa4uy; 0xfauy; 0xafuy; 0x1auy; 0x88uy; 0x59uy; 0xdcuy; 0x74uy; 0x12uy; 0xb4uy; 0x8euy; 0xd7uy; 0x19uy; 0x46uy; 0xf4uy; 0x84uy; 0x69uy; 0x9fuy; 0xbbuy; 0x70uy; 0xa8uy; 0x4cuy; 0x52uy; 0x81uy; 0xa9uy; 0xffuy; 0x76uy; 0x1cuy; 0xaeuy; 0xd8uy; 0x11uy; 0x3duy; 0x7fuy; 0x7duy; 0xc5uy; 0x12uy; 0x59uy; 0x28uy; 0x18uy; 0xc2uy; 0xa2uy; 0xb7uy; 0x1cuy; 0x88uy; 0xf8uy; 0xd6uy; 0x1buy; 0xa6uy; 0x7duy; 0x9euy; 0xdeuy; 0x29uy; 0xf8uy; 0xeduy; 0xffuy; 0xebuy; 0x92uy; 0x24uy; 0x4fuy; 0x05uy; 0xaauy; 0xd9uy; 0x49uy; 0xbauy; 0x87uy; 0x59uy; 0x51uy; 0xc9uy; 0x20uy; 0x5cuy; 0x9buy; 0x74uy; 0xcfuy; 0x03uy; 0xd9uy; 0x2duy; 0x34uy; 0xc7uy; 0x5buy; 0xa5uy; 0x40uy; 0xb2uy; 0x99uy; 0xf5uy; 0xcbuy; 0xb4uy; 0xf6uy; 0xb7uy; 0x72uy; 0x4auy; 0xd6uy; 0xbduy; 0xb0uy; 0xf3uy; 0x93uy; 0xe0uy; 0x1buy; 0xa8uy; 0x04uy; 0x1euy; 0x35uy; 0xd4uy; 0x80uy; 0x20uy; 0xf4uy; 0x9cuy; 0x31uy; 0x6buy; 0x45uy; 0xb9uy; 0x15uy; 0xb0uy; 0x5euy; 0xdduy; 0x0auy; 0x33uy; 0x9cuy; 0x83uy; 0xcduy; 0x58uy; 0x89uy; 0x50uy; 0x56uy; 0xbbuy; 0x81uy; 0x00uy; 0x91uy; 0x32uy; 0xf3uy; 0x1buy; 0x3euy; 0xcfuy; 0x45uy; 0xe1uy; 0xf9uy; 0xe1uy; 0x2cuy; 0x26uy; 0x78uy; 0x93uy; 0x9auy; 0x60uy; 0x46uy; 0xc9uy; 0xb5uy; 0x5euy; 0x6auy; 0x28uy; 0x92uy; 0x87uy; 0x3fuy; 0x63uy; 0x7buy; 0xdbuy; 0xf7uy; 0xd0uy; 0x13uy; 0x9duy; 0x32uy; 0x40uy; 0x5euy; 0xcfuy; 0xfbuy; 0x79uy; 0x68uy; 0x47uy; 0x4cuy; 0xfduy; 0x01uy; 0x17uy; 0xe6uy; 0x97uy; 0x93uy; 0x78uy; 0xbbuy; 0xa6uy; 0x27uy; 0xa3uy; 0xe8uy; 0x1auy; 0xe8uy; 0x94uy; 0x55uy; 0x7duy; 0x08uy; 0xe5uy; 0xdcuy; 0x66uy; 0xa3uy; 0x69uy; 0xc8uy; 0xcauy; 0xc5uy; 0xa1uy; 0x84uy; 0x55uy; 0xdeuy; 0x08uy; 0x91uy; 0x16uy; 0x3auy; 0x0cuy; 0x86uy; 0xabuy; 0x27uy; 0x2buy; 0x64uy; 0x34uy; 0x02uy; 0x6cuy; 0x76uy; 0x8buy; 0xc6uy; 0xafuy; 0xccuy; 0xe1uy; 0xd6uy; 0x8cuy; 0x2auy; 0x18uy; 0x3duy; 0xa6uy; 0x1buy; 0x37uy; 0x75uy; 0x45uy; 0x73uy; 0xc2uy; 0x75uy; 0xd7uy; 0x53uy; 0x78uy; 0x3auy; 0xd6uy; 0xe8uy; 0x29uy; 0xd2uy; 0x4auy; 0xa8uy; 0x1euy; 0x82uy; 0xf6uy; 0xb6uy; 0x81uy; 0xdeuy; 0x21uy; 0xeduy; 0x2buy; 0x56uy; 0xbbuy; 0xf2uy; 0xd0uy; 0x57uy; 0xc1uy; 0x7cuy; 0xd2uy; 0x6auy; 0xd2uy; 0x56uy; 0xf5uy; 0x13uy; 0x5fuy; 0x1cuy; 0x6auy; 0x0buy; 0x74uy; 0xfbuy; 0xe9uy; 0xfeuy; 0x9euy; 0xeauy; 0x95uy; 0xb2uy; 0x46uy; 0xabuy; 0x0auy; 0xfcuy; 0xfduy; 0xf3uy; 0xbbuy; 0x04uy; 0x2buy; 0x76uy; 0x1buy; 0xa4uy; 0x74uy; 0xb0uy; 0xc1uy; 0x78uy; 0xc3uy; 0x69uy; 0xe2uy; 0xb0uy; 0x01uy; 0xe1uy; 0xdeuy; 0x32uy; 0x4cuy; 0x8duy; 0x1auy; 0xb3uy; 0x38uy; 0x08uy; 0xd5uy; 0xfcuy; 0x1fuy; 0xdcuy; 0x0euy; 0x2cuy; 0x9cuy; 0xb1uy; 0xa1uy; 0x63uy; 0x17uy; 0x22uy; 0xf5uy; 0x6cuy; 0x93uy; 0x70uy; 0x74uy; 0x00uy; 0xf8uy; 0x39uy; 0x01uy; 0x94uy; 0xd1uy; 0x32uy; 0x23uy; 0x56uy; 0x5duy; 0xa6uy; 0x02uy; 0x76uy; 0x76uy; 0x93uy; 0xceuy; 0x2fuy; 0x19uy; 0xe9uy; 0x17uy; 0x52uy; 0xaeuy; 0x6euy; 0x2cuy; 0x6duy; 0x61uy; 0x7fuy; 0x3buy; 0xaauy; 0xe0uy; 0x52uy; 0x85uy; 0xc5uy; 0x65uy; 0xc1uy; 0xbbuy; 0x8euy; 0x5buy; 0x21uy; 0xd5uy; 0xc9uy; 0x78uy; 0x83uy; 0x07uy; 0x97uy; 0x4cuy; 0x62uy; 0x61uy; 0x41uy; 0xd4uy; 0xfcuy; 0xc9uy; 0x39uy; 0xe3uy; 0x9buy; 0xd0uy; 0xccuy; 0x75uy; 0xc4uy; 0x97uy; 0xe6uy; 0xdduy; 0x2auy; 0x5fuy; 0xa6uy; 0xe8uy; 0x59uy; 0x6cuy; 0x98uy; 0xb9uy; 0x02uy; 0xe2uy; 0xa2uy; 0xd6uy; 0x68uy; 0xeeuy; 0x3buy; 0x1duy; 0xe3uy; 0x4duy; 0x5buy; 0x30uy; 0xefuy; 0x03uy; 0xf2uy; 0xebuy; 0x18uy; 0x57uy; 0x36uy; 0xe8uy; 0xa1uy; 0xf4uy; 0x47uy; 0xfbuy; 0xcbuy; 0x8fuy; 0xcbuy; 0xc8uy; 0xf3uy; 0x4fuy; 0x74uy; 0x9duy; 0x9duy; 0xb1uy; 0x8duy; 0x14uy; 0x44uy; 0xd9uy; 0x19uy; 0xb4uy; 0x54uy; 0x4fuy; 0x75uy; 0x19uy; 0x09uy; 0xa0uy; 0x75uy; 0xbcuy; 0x3buy; 0x82uy; 0xc6uy; 0x3fuy; 0xb8uy; 0x83uy; 0x19uy; 0x6euy; 0xd6uy; 0x37uy; 0xfeuy; 0x6euy; 0x8auy; 0x4euy; 0xe0uy; 0x4auy; 0xabuy; 0x7buy; 0xc8uy; 0xb4uy; 0x1duy; 0xf4uy; 0xeduy; 0x27uy; 0x03uy; 0x65uy; 0xa2uy; 0xa1uy; 0xaeuy; 0x11uy; 0xe7uy; 0x98uy; 0x78uy; 0x48uy; 0x91uy; 0xd2uy; 0xd2uy; 0xd4uy; 0x23uy; 0x78uy; 0x50uy; 0xb1uy; 0x5buy; 0x85uy; 0x10uy; 0x8duy; 0xcauy; 0x5fuy; 0x0fuy; 0x71uy; 0xaeuy; 0x72uy; 0x9auy; 0xf6uy; 0x25uy; 0x19uy; 0x60uy; 0x06uy; 0xf7uy; 0x10uy; 0x34uy; 0x18uy; 0x0duy; 0xc9uy; 0x9fuy; 0x7buy; 0x0cuy; 0x9buy; 0x8fuy; 0x91uy; 0x1buy; 0x9fuy; 0xcduy; 0x10uy; 0xeeuy; 0x75uy; 0xf9uy; 0x97uy; 0x66uy; 0xfcuy; 0x4duy; 0x33uy; 0x6euy; 0x28uy; 0x2buy; 0x92uy; 0x85uy; 0x4fuy; 0xabuy; 0x43uy; 0x8duy; 0x8fuy; 0x7duy; 0x86uy; 0xa7uy; 0xc7uy; 0xd8uy; 0xd3uy; 0x0buy; 0x8buy; 0x57uy; 0xb6uy; 0x1duy; 0x95uy; 0x0duy; 0xe9uy; 0xbcuy; 0xd9uy; 0x03uy; 0xd9uy; 0x10uy; 0x19uy; 0xc3uy; 0x46uy; 0x63uy; 0x55uy; 0x87uy; 0x61uy; 0x79uy; 0x6cuy; 0x95uy; 0x0euy; 0x9cuy; 0xdduy; 0xcauy; 0xc3uy; 0xf3uy; 0x64uy; 0xf0uy; 0x7duy; 0x76uy; 0xb7uy; 0x53uy; 0x67uy; 0x2buy; 0x1euy; 0x44uy; 0x56uy; 0x81uy; 0xeauy; 0x8fuy; 0x5cuy; 0x42uy; 0x16uy; 0xb8uy; 0x28uy; 0xebuy; 0x1buy; 0x61uy; 0x10uy; 0x1euy; 0xbfuy; 0xecuy; 0xa8uy; ] in
  assert_norm (List.Tot.length l = 1933);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input10_len: (x:UInt32.t { UInt32.v x = B.length input10 }) =
  1933ul

let output10: (b: B.buffer UInt8.t { B.length b = 1949 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x6auy; 0xfcuy; 0x4buy; 0x25uy; 0xdfuy; 0xc0uy; 0xe4uy; 0xe8uy; 0x17uy; 0x4duy; 0x4cuy; 0xc9uy; 0x7euy; 0xdeuy; 0x3auy; 0xccuy; 0x3cuy; 0xbauy; 0x6auy; 0x77uy; 0x47uy; 0xdbuy; 0xe3uy; 0x74uy; 0x7auy; 0x4duy; 0x5fuy; 0x8duy; 0x37uy; 0x55uy; 0x80uy; 0x73uy; 0x90uy; 0x66uy; 0x5duy; 0x3auy; 0x7duy; 0x5duy; 0x86uy; 0x5euy; 0x8duy; 0xfduy; 0x83uy; 0xffuy; 0x4euy; 0x74uy; 0x6fuy; 0xf9uy; 0xe6uy; 0x70uy; 0x17uy; 0x70uy; 0x3euy; 0x96uy; 0xa7uy; 0x7euy; 0xcbuy; 0xabuy; 0x8fuy; 0x58uy; 0x24uy; 0x9buy; 0x01uy; 0xfduy; 0xcbuy; 0xe6uy; 0x4duy; 0x9buy; 0xf0uy; 0x88uy; 0x94uy; 0x57uy; 0x66uy; 0xefuy; 0x72uy; 0x4cuy; 0x42uy; 0x6euy; 0x16uy; 0x19uy; 0x15uy; 0xeauy; 0x70uy; 0x5buy; 0xacuy; 0x13uy; 0xdbuy; 0x9fuy; 0x18uy; 0xe2uy; 0x3cuy; 0x26uy; 0x97uy; 0xbcuy; 0xdcuy; 0x45uy; 0x8cuy; 0x6cuy; 0x24uy; 0x69uy; 0x9cuy; 0xf7uy; 0x65uy; 0x1euy; 0x18uy; 0x59uy; 0x31uy; 0x7cuy; 0xe4uy; 0x73uy; 0xbcuy; 0x39uy; 0x62uy; 0xc6uy; 0x5cuy; 0x9fuy; 0xbfuy; 0xfauy; 0x90uy; 0x03uy; 0xc9uy; 0x72uy; 0x26uy; 0xb6uy; 0x1buy; 0xc2uy; 0xb7uy; 0x3fuy; 0xf2uy; 0x13uy; 0x77uy; 0xf2uy; 0x8duy; 0xb9uy; 0x47uy; 0xd0uy; 0x53uy; 0xdduy; 0xc8uy; 0x91uy; 0x83uy; 0x8buy; 0xb1uy; 0xceuy; 0xa3uy; 0xfeuy; 0xcduy; 0xd9uy; 0xdduy; 0x92uy; 0x7buy; 0xdbuy; 0xb8uy; 0xfbuy; 0xc9uy; 0x2duy; 0x01uy; 0x59uy; 0x39uy; 0x52uy; 0xaduy; 0x1buy; 0xecuy; 0xcfuy; 0xd7uy; 0x70uy; 0x13uy; 0x21uy; 0xf5uy; 0x47uy; 0xaauy; 0x18uy; 0x21uy; 0x5cuy; 0xc9uy; 0x9auy; 0xd2uy; 0x6buy; 0x05uy; 0x9cuy; 0x01uy; 0xa1uy; 0xdauy; 0x35uy; 0x5duy; 0xb3uy; 0x70uy; 0xe6uy; 0xa9uy; 0x80uy; 0x8buy; 0x91uy; 0xb7uy; 0xb3uy; 0x5fuy; 0x24uy; 0x9auy; 0xb7uy; 0xd1uy; 0x6buy; 0xa1uy; 0x1cuy; 0x50uy; 0xbauy; 0x49uy; 0xe0uy; 0xeeuy; 0x2euy; 0x75uy; 0xacuy; 0x69uy; 0xc0uy; 0xebuy; 0x03uy; 0xdduy; 0x19uy; 0xe5uy; 0xf6uy; 0x06uy; 0xdduy; 0xc3uy; 0xd7uy; 0x2buy; 0x07uy; 0x07uy; 0x30uy; 0xa7uy; 0x19uy; 0x0cuy; 0xbfuy; 0xe6uy; 0x18uy; 0xccuy; 0xb1uy; 0x01uy; 0x11uy; 0x85uy; 0x77uy; 0x1duy; 0x96uy; 0xa7uy; 0xa3uy; 0x00uy; 0x84uy; 0x02uy; 0xa2uy; 0x83uy; 0x68uy; 0xdauy; 0x17uy; 0x27uy; 0xc8uy; 0x7fuy; 0x23uy; 0xb7uy; 0xf4uy; 0x13uy; 0x85uy; 0xcfuy; 0xdduy; 0x7auy; 0x7duy; 0x24uy; 0x57uy; 0xfeuy; 0x05uy; 0x93uy; 0xf5uy; 0x74uy; 0xceuy; 0xeduy; 0x0cuy; 0x20uy; 0x98uy; 0x8duy; 0x92uy; 0x30uy; 0xa1uy; 0x29uy; 0x23uy; 0x1auy; 0xa0uy; 0x4fuy; 0x69uy; 0x56uy; 0x4cuy; 0xe1uy; 0xc8uy; 0xceuy; 0xf6uy; 0x9auy; 0x0cuy; 0xa4uy; 0xfauy; 0x04uy; 0xf6uy; 0x62uy; 0x95uy; 0xf2uy; 0xfauy; 0xc7uy; 0x40uy; 0x68uy; 0x40uy; 0x8fuy; 0x41uy; 0xdauy; 0xb4uy; 0x26uy; 0x6fuy; 0x70uy; 0xabuy; 0x40uy; 0x61uy; 0xa4uy; 0x0euy; 0x75uy; 0xfbuy; 0x86uy; 0xebuy; 0x9duy; 0x9auy; 0x1fuy; 0xecuy; 0x76uy; 0x99uy; 0xe7uy; 0xeauy; 0xaauy; 0x1euy; 0x2duy; 0xb5uy; 0xd4uy; 0xa6uy; 0x1auy; 0xb8uy; 0x61uy; 0x0auy; 0x1duy; 0x16uy; 0x5buy; 0x98uy; 0xc2uy; 0x31uy; 0x40uy; 0xe7uy; 0x23uy; 0x1duy; 0x66uy; 0x99uy; 0xc8uy; 0xc0uy; 0xd7uy; 0xceuy; 0xf3uy; 0x57uy; 0x40uy; 0x04uy; 0x3fuy; 0xfcuy; 0xeauy; 0xb3uy; 0xfcuy; 0xd2uy; 0xd3uy; 0x99uy; 0xa4uy; 0x94uy; 0x69uy; 0xa0uy; 0xefuy; 0xd1uy; 0x85uy; 0xb3uy; 0xa6uy; 0xb1uy; 0x28uy; 0xbfuy; 0x94uy; 0x67uy; 0x22uy; 0xc3uy; 0x36uy; 0x46uy; 0xf8uy; 0xd2uy; 0x0fuy; 0x5fuy; 0xf4uy; 0x59uy; 0x80uy; 0xe6uy; 0x2duy; 0x43uy; 0x08uy; 0x7duy; 0x19uy; 0x09uy; 0x97uy; 0xa7uy; 0x4cuy; 0x3duy; 0x8duy; 0xbauy; 0x65uy; 0x62uy; 0xa3uy; 0x71uy; 0x33uy; 0x29uy; 0x62uy; 0xdbuy; 0xc1uy; 0x33uy; 0x34uy; 0x1auy; 0x63uy; 0x33uy; 0x16uy; 0xb6uy; 0x64uy; 0x7euy; 0xabuy; 0x33uy; 0xf0uy; 0xe6uy; 0x26uy; 0x68uy; 0xbauy; 0x1duy; 0x2euy; 0x38uy; 0x08uy; 0xe6uy; 0x02uy; 0xd3uy; 0x25uy; 0x2cuy; 0x47uy; 0x23uy; 0x58uy; 0x34uy; 0x0fuy; 0x9duy; 0x63uy; 0x4fuy; 0x63uy; 0xbbuy; 0x7fuy; 0x3buy; 0x34uy; 0x38uy; 0xa7uy; 0xb5uy; 0x8duy; 0x65uy; 0xd9uy; 0x9fuy; 0x79uy; 0x55uy; 0x3euy; 0x4duy; 0xe7uy; 0x73uy; 0xd8uy; 0xf6uy; 0x98uy; 0x97uy; 0x84uy; 0x60uy; 0x9cuy; 0xc8uy; 0xa9uy; 0x3cuy; 0xf6uy; 0xdcuy; 0x12uy; 0x5cuy; 0xe1uy; 0xbbuy; 0x0buy; 0x8buy; 0x98uy; 0x9cuy; 0x9duy; 0x26uy; 0x7cuy; 0x4auy; 0xe6uy; 0x46uy; 0x36uy; 0x58uy; 0x21uy; 0x4auy; 0xeeuy; 0xcauy; 0xd7uy; 0x3buy; 0xc2uy; 0x6cuy; 0x49uy; 0x2fuy; 0xe5uy; 0xd5uy; 0x03uy; 0x59uy; 0x84uy; 0x53uy; 0xcbuy; 0xfeuy; 0x92uy; 0x71uy; 0x2euy; 0x7cuy; 0x21uy; 0xccuy; 0x99uy; 0x85uy; 0x7fuy; 0xb8uy; 0x74uy; 0x90uy; 0x13uy; 0x42uy; 0x3fuy; 0xe0uy; 0x6buy; 0x1duy; 0xf2uy; 0x4duy; 0x54uy; 0xd4uy; 0xfcuy; 0x3auy; 0x05uy; 0xe6uy; 0x74uy; 0xafuy; 0xa6uy; 0xa0uy; 0x2auy; 0x20uy; 0x23uy; 0x5duy; 0x34uy; 0x5cuy; 0xd9uy; 0x3euy; 0x4euy; 0xfauy; 0x93uy; 0xe7uy; 0xaauy; 0xe9uy; 0x6fuy; 0x08uy; 0x43uy; 0x67uy; 0x41uy; 0xc5uy; 0xaduy; 0xfbuy; 0x31uy; 0x95uy; 0x82uy; 0x73uy; 0x32uy; 0xd8uy; 0xa6uy; 0xa3uy; 0xeduy; 0x0euy; 0x2duy; 0xf6uy; 0x5fuy; 0xfduy; 0x80uy; 0xa6uy; 0x7auy; 0xe0uy; 0xdfuy; 0x78uy; 0x15uy; 0x29uy; 0x74uy; 0x33uy; 0xd0uy; 0x9euy; 0x83uy; 0x86uy; 0x72uy; 0x22uy; 0x57uy; 0x29uy; 0xb9uy; 0x9euy; 0x5duy; 0xd3uy; 0x1auy; 0xb5uy; 0x96uy; 0x72uy; 0x41uy; 0x3duy; 0xf1uy; 0x64uy; 0x43uy; 0x67uy; 0xeeuy; 0xaauy; 0x5cuy; 0xd3uy; 0x9auy; 0x96uy; 0x13uy; 0x11uy; 0x5duy; 0xf3uy; 0x0cuy; 0x87uy; 0x82uy; 0x1euy; 0x41uy; 0x9euy; 0xd0uy; 0x27uy; 0xd7uy; 0x54uy; 0x3buy; 0x67uy; 0x73uy; 0x09uy; 0x91uy; 0xe9uy; 0xd5uy; 0x36uy; 0xa7uy; 0xb5uy; 0x55uy; 0xe4uy; 0xf3uy; 0x21uy; 0x51uy; 0x49uy; 0x22uy; 0x07uy; 0x55uy; 0x4fuy; 0x44uy; 0x4buy; 0xd2uy; 0x15uy; 0x93uy; 0x17uy; 0x2auy; 0xfauy; 0x4duy; 0x4auy; 0x57uy; 0xdbuy; 0x4cuy; 0xa6uy; 0xebuy; 0xecuy; 0x53uy; 0x25uy; 0x6cuy; 0x21uy; 0xeduy; 0x00uy; 0x4cuy; 0x3buy; 0xcauy; 0x14uy; 0x57uy; 0xa9uy; 0xd6uy; 0x6auy; 0xcduy; 0x8duy; 0x5euy; 0x74uy; 0xacuy; 0x72uy; 0xc1uy; 0x97uy; 0xe5uy; 0x1buy; 0x45uy; 0x4euy; 0xdauy; 0xfcuy; 0xccuy; 0x40uy; 0xe8uy; 0x48uy; 0x88uy; 0x0buy; 0xa3uy; 0xe3uy; 0x8duy; 0x83uy; 0x42uy; 0xc3uy; 0x23uy; 0xfduy; 0x68uy; 0xb5uy; 0x8euy; 0xf1uy; 0x9duy; 0x63uy; 0x77uy; 0xe9uy; 0xa3uy; 0x8euy; 0x8cuy; 0x26uy; 0x6buy; 0xbduy; 0x72uy; 0x73uy; 0x35uy; 0x0cuy; 0x03uy; 0xf8uy; 0x43uy; 0x78uy; 0x52uy; 0x71uy; 0x15uy; 0x1fuy; 0x71uy; 0x5duy; 0x6euy; 0xeduy; 0xb9uy; 0xccuy; 0x86uy; 0x30uy; 0xdbuy; 0x2buy; 0xd3uy; 0x82uy; 0x88uy; 0x23uy; 0x71uy; 0x90uy; 0x53uy; 0x5cuy; 0xa9uy; 0x2fuy; 0x76uy; 0x01uy; 0xb7uy; 0x9auy; 0xfeuy; 0x43uy; 0x55uy; 0xa3uy; 0x04uy; 0x9buy; 0x0euy; 0xe4uy; 0x59uy; 0xdfuy; 0xc9uy; 0xe9uy; 0xb1uy; 0xeauy; 0x29uy; 0x28uy; 0x3cuy; 0x5cuy; 0xaeuy; 0x72uy; 0x84uy; 0xb6uy; 0xc6uy; 0xebuy; 0x0cuy; 0x27uy; 0x07uy; 0x74uy; 0x90uy; 0x0duy; 0x31uy; 0xb0uy; 0x00uy; 0x77uy; 0xe9uy; 0x40uy; 0x70uy; 0x6fuy; 0x68uy; 0xa7uy; 0xfduy; 0x06uy; 0xecuy; 0x4buy; 0xc0uy; 0xb7uy; 0xacuy; 0xbcuy; 0x33uy; 0xb7uy; 0x6duy; 0x0auy; 0xbduy; 0x12uy; 0x1buy; 0x59uy; 0xcbuy; 0xdduy; 0x32uy; 0xf5uy; 0x1duy; 0x94uy; 0x57uy; 0x76uy; 0x9euy; 0x0cuy; 0x18uy; 0x98uy; 0x71uy; 0xd7uy; 0x2auy; 0xdbuy; 0x0buy; 0x7buy; 0xa7uy; 0x71uy; 0xb7uy; 0x67uy; 0x81uy; 0x23uy; 0x96uy; 0xaeuy; 0xb9uy; 0x7euy; 0x32uy; 0x43uy; 0x92uy; 0x8auy; 0x19uy; 0xa0uy; 0xc4uy; 0xd4uy; 0x3buy; 0x57uy; 0xf9uy; 0x4auy; 0x2cuy; 0xfbuy; 0x51uy; 0x46uy; 0xbbuy; 0xcbuy; 0x5duy; 0xb3uy; 0xefuy; 0x13uy; 0x93uy; 0x6euy; 0x68uy; 0x42uy; 0x54uy; 0x57uy; 0xd3uy; 0x6auy; 0x3auy; 0x8fuy; 0x9duy; 0x66uy; 0xbfuy; 0xbduy; 0x36uy; 0x23uy; 0xf5uy; 0x93uy; 0x83uy; 0x7buy; 0x9cuy; 0xc0uy; 0xdduy; 0xc5uy; 0x49uy; 0xc0uy; 0x64uy; 0xeduy; 0x07uy; 0x12uy; 0xb3uy; 0xe6uy; 0xe4uy; 0xe5uy; 0x38uy; 0x95uy; 0x23uy; 0xb1uy; 0xa0uy; 0x3buy; 0x1auy; 0x61uy; 0xdauy; 0x17uy; 0xacuy; 0xc3uy; 0x58uy; 0xdduy; 0x74uy; 0x64uy; 0x22uy; 0x11uy; 0xe8uy; 0x32uy; 0x1duy; 0x16uy; 0x93uy; 0x85uy; 0x99uy; 0xa5uy; 0x9cuy; 0x34uy; 0x55uy; 0xb1uy; 0xe9uy; 0x20uy; 0x72uy; 0xc9uy; 0x28uy; 0x7buy; 0x79uy; 0x00uy; 0xa1uy; 0xa6uy; 0xa3uy; 0x27uy; 0x40uy; 0x18uy; 0x8auy; 0x54uy; 0xe0uy; 0xccuy; 0xe8uy; 0x4euy; 0x8euy; 0x43uy; 0x96uy; 0xe7uy; 0x3fuy; 0xc8uy; 0xe9uy; 0xb2uy; 0xf9uy; 0xc9uy; 0xdauy; 0x04uy; 0x71uy; 0x50uy; 0x47uy; 0xe4uy; 0xaauy; 0xceuy; 0xa2uy; 0x30uy; 0xc8uy; 0xe4uy; 0xacuy; 0xc7uy; 0x0duy; 0x06uy; 0x2euy; 0xe6uy; 0xe8uy; 0x80uy; 0x36uy; 0x29uy; 0x9euy; 0x01uy; 0xb8uy; 0xc3uy; 0xf0uy; 0xa0uy; 0x5duy; 0x7auy; 0xcauy; 0x4duy; 0xa0uy; 0x57uy; 0xbduy; 0x2auy; 0x45uy; 0xa7uy; 0x7fuy; 0x9cuy; 0x93uy; 0x07uy; 0x8fuy; 0x35uy; 0x67uy; 0x92uy; 0xe3uy; 0xe9uy; 0x7fuy; 0xa8uy; 0x61uy; 0x43uy; 0x9euy; 0x25uy; 0x4fuy; 0x33uy; 0x76uy; 0x13uy; 0x6euy; 0x12uy; 0xb9uy; 0xdduy; 0xa4uy; 0x7cuy; 0x08uy; 0x9fuy; 0x7cuy; 0xe7uy; 0x0auy; 0x8duy; 0x84uy; 0x06uy; 0xa4uy; 0x33uy; 0x17uy; 0x34uy; 0x5euy; 0x10uy; 0x7cuy; 0xc0uy; 0xa8uy; 0x3duy; 0x1fuy; 0x42uy; 0x20uy; 0x51uy; 0x65uy; 0x5duy; 0x09uy; 0xc3uy; 0xaauy; 0xc0uy; 0xc8uy; 0x0duy; 0xf0uy; 0x79uy; 0xbcuy; 0x20uy; 0x1buy; 0x95uy; 0xe7uy; 0x06uy; 0x7duy; 0x47uy; 0x20uy; 0x03uy; 0x1auy; 0x74uy; 0xdduy; 0xe2uy; 0xd4uy; 0xaeuy; 0x38uy; 0x71uy; 0x9buy; 0xf5uy; 0x80uy; 0xecuy; 0x08uy; 0x4euy; 0x56uy; 0xbauy; 0x76uy; 0x12uy; 0x1auy; 0xdfuy; 0x48uy; 0xf3uy; 0xaeuy; 0xb3uy; 0xe6uy; 0xe6uy; 0xbeuy; 0xc0uy; 0x91uy; 0x2euy; 0x01uy; 0xb3uy; 0x01uy; 0x86uy; 0xa2uy; 0xb9uy; 0x52uy; 0xd1uy; 0x21uy; 0xaeuy; 0xd4uy; 0x97uy; 0x1duy; 0xefuy; 0x41uy; 0x12uy; 0x95uy; 0x3duy; 0x48uy; 0x45uy; 0x1cuy; 0x56uy; 0x32uy; 0x8fuy; 0xb8uy; 0x43uy; 0xbbuy; 0x19uy; 0xf3uy; 0xcauy; 0xe9uy; 0xebuy; 0x6duy; 0x84uy; 0xbeuy; 0x86uy; 0x06uy; 0xe2uy; 0x36uy; 0xb2uy; 0x62uy; 0x9duy; 0xd3uy; 0x4cuy; 0x48uy; 0x18uy; 0x54uy; 0x13uy; 0x4euy; 0xcfuy; 0xfduy; 0xbauy; 0x84uy; 0xb9uy; 0x30uy; 0x53uy; 0xcfuy; 0xfbuy; 0xb9uy; 0x29uy; 0x8fuy; 0xdcuy; 0x9fuy; 0xefuy; 0x60uy; 0x0buy; 0x64uy; 0xf6uy; 0x8buy; 0xeeuy; 0xa6uy; 0x91uy; 0xc2uy; 0x41uy; 0x6cuy; 0xf6uy; 0xfauy; 0x79uy; 0x67uy; 0x4buy; 0xc1uy; 0x3fuy; 0xafuy; 0x09uy; 0x81uy; 0xd4uy; 0x5duy; 0xcbuy; 0x09uy; 0xdfuy; 0x36uy; 0x31uy; 0xc0uy; 0x14uy; 0x3cuy; 0x7cuy; 0x0euy; 0x65uy; 0x95uy; 0x99uy; 0x6duy; 0xa3uy; 0xf4uy; 0xd7uy; 0x38uy; 0xeeuy; 0x1auy; 0x2buy; 0x37uy; 0xe2uy; 0xa4uy; 0x3buy; 0x4buy; 0xd0uy; 0x65uy; 0xcauy; 0xf8uy; 0xc3uy; 0xe8uy; 0x15uy; 0x20uy; 0xefuy; 0xf2uy; 0x00uy; 0xfduy; 0x01uy; 0x09uy; 0xc5uy; 0xc8uy; 0x17uy; 0x04uy; 0x93uy; 0xd0uy; 0x93uy; 0x03uy; 0x55uy; 0xc5uy; 0xfeuy; 0x32uy; 0xa3uy; 0x3euy; 0x28uy; 0x2duy; 0x3buy; 0x93uy; 0x8auy; 0xccuy; 0x07uy; 0x72uy; 0x80uy; 0x8buy; 0x74uy; 0x16uy; 0x24uy; 0xbbuy; 0xdauy; 0x94uy; 0x39uy; 0x30uy; 0x8fuy; 0xb1uy; 0xcduy; 0x4auy; 0x90uy; 0x92uy; 0x7cuy; 0x14uy; 0x8fuy; 0x95uy; 0x4euy; 0xacuy; 0x9buy; 0xd8uy; 0x8fuy; 0x1auy; 0x87uy; 0xa4uy; 0x32uy; 0x27uy; 0x8auy; 0xbauy; 0xf7uy; 0x41uy; 0xcfuy; 0x84uy; 0x37uy; 0x19uy; 0xe6uy; 0x06uy; 0xf5uy; 0x0euy; 0xcfuy; 0x36uy; 0xf5uy; 0x9euy; 0x6cuy; 0xdeuy; 0xbcuy; 0xffuy; 0x64uy; 0x7euy; 0x4euy; 0x59uy; 0x57uy; 0x48uy; 0xfeuy; 0x14uy; 0xf7uy; 0x9cuy; 0x93uy; 0x5duy; 0x15uy; 0xaduy; 0xccuy; 0x11uy; 0xb1uy; 0x17uy; 0x18uy; 0xb2uy; 0x7euy; 0xccuy; 0xabuy; 0xe9uy; 0xceuy; 0x7duy; 0x77uy; 0x5buy; 0x51uy; 0x1buy; 0x1euy; 0x20uy; 0xa8uy; 0x32uy; 0x06uy; 0x0euy; 0x75uy; 0x93uy; 0xacuy; 0xdbuy; 0x35uy; 0x37uy; 0x1fuy; 0xe9uy; 0x19uy; 0x1duy; 0xb4uy; 0x71uy; 0x97uy; 0xd6uy; 0x4euy; 0x2cuy; 0x08uy; 0xa5uy; 0x13uy; 0xf9uy; 0x0euy; 0x7euy; 0x78uy; 0x6euy; 0x14uy; 0xe0uy; 0xa9uy; 0xb9uy; 0x96uy; 0x4cuy; 0x80uy; 0x82uy; 0xbauy; 0x17uy; 0xb3uy; 0x9duy; 0x69uy; 0xb0uy; 0x84uy; 0x46uy; 0xffuy; 0xf9uy; 0x52uy; 0x79uy; 0x94uy; 0x58uy; 0x3auy; 0x62uy; 0x90uy; 0x15uy; 0x35uy; 0x71uy; 0x10uy; 0x37uy; 0xeduy; 0xa1uy; 0x8euy; 0x53uy; 0x6euy; 0xf4uy; 0x26uy; 0x57uy; 0x93uy; 0x15uy; 0x93uy; 0xf6uy; 0x81uy; 0x2cuy; 0x5auy; 0x10uy; 0xdauy; 0x92uy; 0xaduy; 0x2fuy; 0xdbuy; 0x28uy; 0x31uy; 0x2duy; 0x55uy; 0x04uy; 0xd2uy; 0x06uy; 0x28uy; 0x8cuy; 0x1euy; 0xdcuy; 0xeauy; 0x54uy; 0xacuy; 0xffuy; 0xb7uy; 0x6cuy; 0x30uy; 0x15uy; 0xd4uy; 0xb4uy; 0x0duy; 0x00uy; 0x93uy; 0x57uy; 0xdduy; 0xd2uy; 0x07uy; 0x07uy; 0x06uy; 0xd9uy; 0x43uy; 0x9buy; 0xcduy; 0x3auy; 0xf4uy; 0x7duy; 0x4cuy; 0x36uy; 0x5duy; 0x23uy; 0xa2uy; 0xccuy; 0x57uy; 0x40uy; 0x91uy; 0xe9uy; 0x2cuy; 0x2fuy; 0x2cuy; 0xd5uy; 0x30uy; 0x9buy; 0x17uy; 0xb0uy; 0xc9uy; 0xf7uy; 0xa7uy; 0x2fuy; 0xd1uy; 0x93uy; 0x20uy; 0x6buy; 0xc6uy; 0xc1uy; 0xe4uy; 0x6fuy; 0xcbuy; 0xd1uy; 0xe7uy; 0x09uy; 0x0fuy; 0x9euy; 0xdcuy; 0xaauy; 0x9fuy; 0x2fuy; 0xdfuy; 0x56uy; 0x9fuy; 0xd4uy; 0x33uy; 0x04uy; 0xafuy; 0xd3uy; 0x6cuy; 0x58uy; 0x61uy; 0xf0uy; 0x30uy; 0xecuy; 0xf2uy; 0x7fuy; 0xf2uy; 0x9cuy; 0xdfuy; 0x39uy; 0xbbuy; 0x6fuy; 0xa2uy; 0x8cuy; 0x7euy; 0xc4uy; 0x22uy; 0x51uy; 0x71uy; 0xc0uy; 0x4duy; 0x14uy; 0x1auy; 0xc4uy; 0xcduy; 0x04uy; 0xd9uy; 0x87uy; 0x08uy; 0x50uy; 0x05uy; 0xccuy; 0xafuy; 0xf6uy; 0xf0uy; 0x8fuy; 0x92uy; 0x54uy; 0x58uy; 0xc2uy; 0xc7uy; 0x09uy; 0x7auy; 0x59uy; 0x02uy; 0x05uy; 0xe8uy; 0xb0uy; 0x86uy; 0xd9uy; 0xbfuy; 0x7buy; 0x35uy; 0x51uy; 0x4duy; 0xafuy; 0x08uy; 0x97uy; 0x2cuy; 0x65uy; 0xdauy; 0x2auy; 0x71uy; 0x3auy; 0xa8uy; 0x51uy; 0xccuy; 0xf2uy; 0x73uy; 0x27uy; 0xc3uy; 0xfduy; 0x62uy; 0xcfuy; 0xe3uy; 0xb2uy; 0xcauy; 0xcbuy; 0xbeuy; 0x1auy; 0x0auy; 0xa1uy; 0x34uy; 0x7buy; 0x77uy; 0xc4uy; 0x62uy; 0x68uy; 0x78uy; 0x5fuy; 0x94uy; 0x07uy; 0x04uy; 0x65uy; 0x16uy; 0x4buy; 0x61uy; 0xcbuy; 0xffuy; 0x75uy; 0x26uy; 0x50uy; 0x66uy; 0x1fuy; 0x6euy; 0x93uy; 0xf8uy; 0xc5uy; 0x51uy; 0xebuy; 0xa4uy; 0x4auy; 0x48uy; 0x68uy; 0x6buy; 0xe2uy; 0x5euy; 0x44uy; 0xb2uy; 0x50uy; 0x2cuy; 0x6cuy; 0xaeuy; 0x79uy; 0x4euy; 0x66uy; 0x35uy; 0x81uy; 0x50uy; 0xacuy; 0xbcuy; 0x3fuy; 0xb1uy; 0x0cuy; 0xf3uy; 0x05uy; 0x3cuy; 0x4auy; 0xa3uy; 0x6cuy; 0x2auy; 0x79uy; 0xb4uy; 0xb7uy; 0xabuy; 0xcauy; 0xc7uy; 0x9buy; 0x8euy; 0xcduy; 0x5fuy; 0x11uy; 0x03uy; 0xcbuy; 0x30uy; 0xa3uy; 0xabuy; 0xdauy; 0xfeuy; 0x64uy; 0xb9uy; 0xbbuy; 0xd8uy; 0x5euy; 0x3auy; 0x1auy; 0x56uy; 0xe5uy; 0x05uy; 0x48uy; 0x90uy; 0x1euy; 0x61uy; 0x69uy; 0x1buy; 0x22uy; 0xe6uy; 0x1auy; 0x3cuy; 0x75uy; 0xaduy; 0x1fuy; 0x37uy; 0x28uy; 0xdcuy; 0xe4uy; 0x6duy; 0xbduy; 0x42uy; 0xdcuy; 0xd3uy; 0xc8uy; 0xb6uy; 0x1cuy; 0x48uy; 0xfeuy; 0x94uy; 0x77uy; 0x7fuy; 0xbduy; 0x62uy; 0xacuy; 0xa3uy; 0x47uy; 0x27uy; 0xcfuy; 0x5fuy; 0xd9uy; 0xdbuy; 0xafuy; 0xecuy; 0xf7uy; 0x5euy; 0xc1uy; 0xb0uy; 0x9duy; 0x01uy; 0x26uy; 0x99uy; 0x7euy; 0x8fuy; 0x03uy; 0x70uy; 0xb5uy; 0x42uy; 0xbeuy; 0x67uy; 0x28uy; 0x1buy; 0x7cuy; 0xbduy; 0x61uy; 0x21uy; 0x97uy; 0xccuy; 0x5cuy; 0xe1uy; 0x97uy; 0x8fuy; 0x8duy; 0xdeuy; 0x2buy; 0xaauy; 0xa7uy; 0x71uy; 0x1duy; 0x1euy; 0x02uy; 0x73uy; 0x70uy; 0x58uy; 0x32uy; 0x5buy; 0x1duy; 0x67uy; 0x3duy; 0xe0uy; 0x74uy; 0x4fuy; 0x03uy; 0xf2uy; 0x70uy; 0x51uy; 0x79uy; 0xf1uy; 0x61uy; 0x70uy; 0x15uy; 0x74uy; 0x9duy; 0x23uy; 0x89uy; 0xdeuy; 0xacuy; 0xfduy; 0xdeuy; 0xd0uy; 0x1fuy; 0xc3uy; 0x87uy; 0x44uy; 0x35uy; 0x4buy; 0xe5uy; 0xb0uy; 0x60uy; 0xc5uy; 0x22uy; 0xe4uy; 0x9euy; 0xcauy; 0xebuy; 0xd5uy; 0x3auy; 0x09uy; 0x45uy; 0xa4uy; 0xdbuy; 0xfauy; 0x3fuy; 0xebuy; 0x1buy; 0xc7uy; 0xc8uy; 0x14uy; 0x99uy; 0x51uy; 0x92uy; 0x10uy; 0xeduy; 0xeduy; 0x28uy; 0xe0uy; 0xa1uy; 0xf8uy; 0x26uy; 0xcfuy; 0xcduy; 0xcbuy; 0x63uy; 0xa1uy; 0x3buy; 0xe3uy; 0xdfuy; 0x7euy; 0xfeuy; 0xa6uy; 0xf0uy; 0x81uy; 0x9auy; 0xbfuy; 0x55uy; 0xdeuy; 0x54uy; 0xd5uy; 0x56uy; 0x60uy; 0x98uy; 0x10uy; 0x68uy; 0xf4uy; 0x38uy; 0x96uy; 0x8euy; 0x6fuy; 0x1duy; 0x44uy; 0x7fuy; 0xd6uy; 0x2fuy; 0xfeuy; 0x55uy; 0xfbuy; 0x0cuy; 0x7euy; 0x67uy; 0xe2uy; 0x61uy; 0x44uy; 0xeduy; 0xf2uy; 0x35uy; 0x30uy; 0x5duy; 0xe9uy; 0xc7uy; 0xd6uy; 0x6duy; 0xe0uy; 0xa0uy; 0xeduy; 0xf3uy; 0xfcuy; 0xd8uy; 0x3euy; 0x0auy; 0x7buy; 0xcduy; 0xafuy; 0x65uy; 0x68uy; 0x18uy; 0xc0uy; 0xecuy; 0x04uy; 0x1cuy; 0x74uy; 0x6duy; 0xe2uy; 0x6euy; 0x79uy; 0xd4uy; 0x11uy; 0x2buy; 0x62uy; 0xd5uy; 0x27uy; 0xaduy; 0x4fuy; 0x01uy; 0x59uy; 0x73uy; 0xccuy; 0x6auy; 0x53uy; 0xfbuy; 0x2duy; 0xd5uy; 0x4euy; 0x99uy; 0x21uy; 0x65uy; 0x4duy; 0xf5uy; 0x82uy; 0xf7uy; 0xd8uy; 0x42uy; 0xceuy; 0x6fuy; 0x3duy; 0x36uy; 0x47uy; 0xf1uy; 0x05uy; 0x16uy; 0xe8uy; 0x1buy; 0x6auy; 0x8fuy; 0x93uy; 0xf2uy; 0x8fuy; 0x37uy; 0x40uy; 0x12uy; 0x28uy; 0xa3uy; 0xe6uy; 0xb9uy; 0x17uy; 0x4auy; 0x1fuy; 0xb1uy; 0xd1uy; 0x66uy; 0x69uy; 0x86uy; 0xc4uy; 0xfcuy; 0x97uy; 0xaeuy; 0x3fuy; 0x8fuy; 0x1euy; 0x2buy; 0xdfuy; 0xcduy; 0xf9uy; 0x3cuy; ] in
  assert_norm (List.Tot.length l = 1949);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output10_len: (x:UInt32.t { UInt32.v x = B.length output10 }) =
  1949ul

let key11: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xb3uy; 0x35uy; 0x50uy; 0x03uy; 0x54uy; 0x2euy; 0x40uy; 0x5euy; 0x8fuy; 0x59uy; 0x8euy; 0xc5uy; 0x90uy; 0xd5uy; 0x27uy; 0x2duy; 0xbauy; 0x29uy; 0x2euy; 0xcbuy; 0x1buy; 0x70uy; 0x44uy; 0x1euy; 0x65uy; 0x91uy; 0x6euy; 0x2auy; 0x79uy; 0x22uy; 0xdauy; 0x64uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key11_len: (x:UInt32.t { UInt32.v x = B.length key11 }) =
  32ul

let nonce11: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x05uy; 0xa3uy; 0x93uy; 0xeduy; 0x30uy; 0xc5uy; 0xa2uy; 0x06uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let nonce11_len: (x:UInt32.t { UInt32.v x = B.length nonce11 }) =
  12ul

let aad11: (b: B.buffer UInt8.t { B.length b = 63 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xb1uy; 0x69uy; 0x83uy; 0x87uy; 0x30uy; 0xaauy; 0x5duy; 0xb8uy; 0x77uy; 0xe8uy; 0x21uy; 0xffuy; 0x06uy; 0x59uy; 0x35uy; 0xceuy; 0x75uy; 0xfeuy; 0x38uy; 0xefuy; 0xb8uy; 0x91uy; 0x43uy; 0x8cuy; 0xcfuy; 0x70uy; 0xdduy; 0x0auy; 0x68uy; 0xbfuy; 0xd4uy; 0xbcuy; 0x16uy; 0x76uy; 0x99uy; 0x36uy; 0x1euy; 0x58uy; 0x79uy; 0x5euy; 0xd4uy; 0x29uy; 0xf7uy; 0x33uy; 0x93uy; 0x48uy; 0xdbuy; 0x5fuy; 0x01uy; 0xaeuy; 0x9cuy; 0xb6uy; 0xe4uy; 0x88uy; 0x6duy; 0x2buy; 0x76uy; 0x75uy; 0xe0uy; 0xf3uy; 0x74uy; 0xe2uy; 0xc9uy; ] in
  assert_norm (List.Tot.length l = 63);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let aad11_len: (x:UInt32.t { UInt32.v x = B.length aad11 }) =
  63ul

let input11: (b: B.buffer UInt8.t { B.length b = 2011 /\ B.recallable b /\ B.disjoint b aad11 }) =
     B.recall aad11;[@inline_let] let l = [ 0x74uy; 0xa6uy; 0x3euy; 0xe4uy; 0xb1uy; 0xcbuy; 0xafuy; 0xb0uy; 0x40uy; 0xe5uy; 0x0fuy; 0x9euy; 0xf1uy; 0xf2uy; 0x89uy; 0xb5uy; 0x42uy; 0x34uy; 0x8auy; 0xa1uy; 0x03uy; 0xb7uy; 0xe9uy; 0x57uy; 0x46uy; 0xbeuy; 0x20uy; 0xe4uy; 0x6euy; 0xb0uy; 0xebuy; 0xffuy; 0xeauy; 0x07uy; 0x7euy; 0xefuy; 0xe2uy; 0x55uy; 0x9fuy; 0xe5uy; 0x78uy; 0x3auy; 0xb7uy; 0x83uy; 0xc2uy; 0x18uy; 0x40uy; 0x7buy; 0xebuy; 0xcduy; 0x81uy; 0xfbuy; 0x90uy; 0x12uy; 0x9euy; 0x46uy; 0xa9uy; 0xd6uy; 0x4auy; 0xbauy; 0xb0uy; 0x62uy; 0xdbuy; 0x6buy; 0x99uy; 0xc4uy; 0xdbuy; 0x54uy; 0x4buy; 0xb8uy; 0xa5uy; 0x71uy; 0xcbuy; 0xcduy; 0x63uy; 0x32uy; 0x55uy; 0xfbuy; 0x31uy; 0xf0uy; 0x38uy; 0xf5uy; 0xbeuy; 0x78uy; 0xe4uy; 0x45uy; 0xceuy; 0x1buy; 0x6auy; 0x5buy; 0x0euy; 0xf4uy; 0x16uy; 0xe4uy; 0xb1uy; 0x3duy; 0xf6uy; 0x63uy; 0x7buy; 0xa7uy; 0x0cuy; 0xdeuy; 0x6fuy; 0x8fuy; 0x74uy; 0xdfuy; 0xe0uy; 0x1euy; 0x9duy; 0xceuy; 0x8fuy; 0x24uy; 0xefuy; 0x23uy; 0x35uy; 0x33uy; 0x7buy; 0x83uy; 0x34uy; 0x23uy; 0x58uy; 0x74uy; 0x14uy; 0x77uy; 0x1fuy; 0xc2uy; 0x4fuy; 0x4euy; 0xc6uy; 0x89uy; 0xf9uy; 0x52uy; 0x09uy; 0x37uy; 0x64uy; 0x14uy; 0xc4uy; 0x01uy; 0x6buy; 0x9duy; 0x77uy; 0xe8uy; 0x90uy; 0x5duy; 0xa8uy; 0x4auy; 0x2auy; 0xefuy; 0x5cuy; 0x7fuy; 0xebuy; 0xbbuy; 0xb2uy; 0xc6uy; 0x93uy; 0x99uy; 0x66uy; 0xdcuy; 0x7fuy; 0xd4uy; 0x9euy; 0x2auy; 0xcauy; 0x8duy; 0xdbuy; 0xe7uy; 0x20uy; 0xcfuy; 0xe4uy; 0x73uy; 0xaeuy; 0x49uy; 0x7duy; 0x64uy; 0x0fuy; 0x0euy; 0x28uy; 0x46uy; 0xa9uy; 0xa8uy; 0x32uy; 0xe4uy; 0x0euy; 0xf6uy; 0x51uy; 0x53uy; 0xb8uy; 0x3cuy; 0xb1uy; 0xffuy; 0xa3uy; 0x33uy; 0x41uy; 0x75uy; 0xffuy; 0xf1uy; 0x6fuy; 0xf1uy; 0xfbuy; 0xbbuy; 0x83uy; 0x7fuy; 0x06uy; 0x9buy; 0xe7uy; 0x1buy; 0x0auy; 0xe0uy; 0x5cuy; 0x33uy; 0x60uy; 0x5buy; 0xdbuy; 0x5buy; 0xeduy; 0xfeuy; 0xa5uy; 0x16uy; 0x19uy; 0x72uy; 0xa3uy; 0x64uy; 0x23uy; 0x00uy; 0x02uy; 0xc7uy; 0xf3uy; 0x6auy; 0x81uy; 0x3euy; 0x44uy; 0x1duy; 0x79uy; 0x15uy; 0x5fuy; 0x9auy; 0xdeuy; 0xe2uy; 0xfduy; 0x1buy; 0x73uy; 0xc1uy; 0xbcuy; 0x23uy; 0xbauy; 0x31uy; 0xd2uy; 0x50uy; 0xd5uy; 0xaduy; 0x7fuy; 0x74uy; 0xa7uy; 0xc9uy; 0xf8uy; 0x3euy; 0x2buy; 0x26uy; 0x10uy; 0xf6uy; 0x03uy; 0x36uy; 0x74uy; 0xe4uy; 0x0euy; 0x6auy; 0x72uy; 0xb7uy; 0x73uy; 0x0auy; 0x42uy; 0x28uy; 0xc2uy; 0xaduy; 0x5euy; 0x03uy; 0xbeuy; 0xb8uy; 0x0buy; 0xa8uy; 0x5buy; 0xd4uy; 0xb8uy; 0xbauy; 0x52uy; 0x89uy; 0xb1uy; 0x9buy; 0xc1uy; 0xc3uy; 0x65uy; 0x87uy; 0xeduy; 0xa5uy; 0xf4uy; 0x86uy; 0xfduy; 0x41uy; 0x80uy; 0x91uy; 0x27uy; 0x59uy; 0x53uy; 0x67uy; 0x15uy; 0x78uy; 0x54uy; 0x8buy; 0x2duy; 0x3duy; 0xc7uy; 0xffuy; 0x02uy; 0x92uy; 0x07uy; 0x5fuy; 0x7auy; 0x4buy; 0x60uy; 0x59uy; 0x3cuy; 0x6fuy; 0x5cuy; 0xd8uy; 0xecuy; 0x95uy; 0xd2uy; 0xfeuy; 0xa0uy; 0x3buy; 0xd8uy; 0x3fuy; 0xd1uy; 0x69uy; 0xa6uy; 0xd6uy; 0x41uy; 0xb2uy; 0xf4uy; 0x4duy; 0x12uy; 0xf4uy; 0x58uy; 0x3euy; 0x66uy; 0x64uy; 0x80uy; 0x31uy; 0x9buy; 0xa8uy; 0x4cuy; 0x8buy; 0x07uy; 0xb2uy; 0xecuy; 0x66uy; 0x94uy; 0x66uy; 0x47uy; 0x50uy; 0x50uy; 0x5fuy; 0x18uy; 0x0buy; 0x0euy; 0xd6uy; 0xc0uy; 0x39uy; 0x21uy; 0x13uy; 0x9euy; 0x33uy; 0xbcuy; 0x79uy; 0x36uy; 0x02uy; 0x96uy; 0x70uy; 0xf0uy; 0x48uy; 0x67uy; 0x2fuy; 0x26uy; 0xe9uy; 0x6duy; 0x10uy; 0xbbuy; 0xd6uy; 0x3fuy; 0xd1uy; 0x64uy; 0x7auy; 0x2euy; 0xbeuy; 0x0cuy; 0x61uy; 0xf0uy; 0x75uy; 0x42uy; 0x38uy; 0x23uy; 0xb1uy; 0x9euy; 0x9fuy; 0x7cuy; 0x67uy; 0x66uy; 0xd9uy; 0x58uy; 0x9auy; 0xf1uy; 0xbbuy; 0x41uy; 0x2auy; 0x8duy; 0x65uy; 0x84uy; 0x94uy; 0xfcuy; 0xdcuy; 0x6auy; 0x50uy; 0x64uy; 0xdbuy; 0x56uy; 0x33uy; 0x76uy; 0x00uy; 0x10uy; 0xeduy; 0xbeuy; 0xd2uy; 0x12uy; 0xf6uy; 0xf6uy; 0x1buy; 0xa2uy; 0x16uy; 0xdeuy; 0xaeuy; 0x31uy; 0x95uy; 0xdduy; 0xb1uy; 0x08uy; 0x7euy; 0x4euy; 0xeeuy; 0xe7uy; 0xf9uy; 0xa5uy; 0xfbuy; 0x5buy; 0x61uy; 0x43uy; 0x00uy; 0x40uy; 0xf6uy; 0x7euy; 0x02uy; 0x04uy; 0x32uy; 0x4euy; 0x0cuy; 0xe2uy; 0x66uy; 0x0duy; 0xd7uy; 0x07uy; 0x98uy; 0x0euy; 0xf8uy; 0x72uy; 0x34uy; 0x6duy; 0x95uy; 0x86uy; 0xd7uy; 0xcbuy; 0x31uy; 0x54uy; 0x47uy; 0xd0uy; 0x38uy; 0x29uy; 0x9cuy; 0x5auy; 0x68uy; 0xd4uy; 0x87uy; 0x76uy; 0xc9uy; 0xe7uy; 0x7euy; 0xe3uy; 0xf4uy; 0x81uy; 0x6duy; 0x18uy; 0xcbuy; 0xc9uy; 0x05uy; 0xafuy; 0xa0uy; 0xfbuy; 0x66uy; 0xf7uy; 0xf1uy; 0x1cuy; 0xc6uy; 0x14uy; 0x11uy; 0x4fuy; 0x2buy; 0x79uy; 0x42uy; 0x8buy; 0xbcuy; 0xacuy; 0xe7uy; 0x6cuy; 0xfeuy; 0x0fuy; 0x58uy; 0xe7uy; 0x7cuy; 0x78uy; 0x39uy; 0x30uy; 0xb0uy; 0x66uy; 0x2cuy; 0x9buy; 0x6duy; 0x3auy; 0xe1uy; 0xcfuy; 0xc9uy; 0xa4uy; 0x0euy; 0x6duy; 0x6duy; 0x8auy; 0xa1uy; 0x3auy; 0xe7uy; 0x28uy; 0xd4uy; 0x78uy; 0x4cuy; 0xa6uy; 0xa2uy; 0x2auy; 0xa6uy; 0x03uy; 0x30uy; 0xd7uy; 0xa8uy; 0x25uy; 0x66uy; 0x87uy; 0x2fuy; 0x69uy; 0x5cuy; 0x4euy; 0xdduy; 0xa5uy; 0x49uy; 0x5duy; 0x37uy; 0x4auy; 0x59uy; 0xc4uy; 0xafuy; 0x1fuy; 0xa2uy; 0xe4uy; 0xf8uy; 0xa6uy; 0x12uy; 0x97uy; 0xd5uy; 0x79uy; 0xf5uy; 0xe2uy; 0x4auy; 0x2buy; 0x5fuy; 0x61uy; 0xe4uy; 0x9euy; 0xe3uy; 0xeeuy; 0xb8uy; 0xa7uy; 0x5buy; 0x2fuy; 0xf4uy; 0x9euy; 0x6cuy; 0xfbuy; 0xd1uy; 0xc6uy; 0x56uy; 0x77uy; 0xbauy; 0x75uy; 0xaauy; 0x3duy; 0x1auy; 0xa8uy; 0x0buy; 0xb3uy; 0x68uy; 0x24uy; 0x00uy; 0x10uy; 0x7fuy; 0xfduy; 0xd7uy; 0xa1uy; 0x8duy; 0x83uy; 0x54uy; 0x4fuy; 0x1fuy; 0xd8uy; 0x2auy; 0xbeuy; 0x8auy; 0x0cuy; 0x87uy; 0xabuy; 0xa2uy; 0xdeuy; 0xc3uy; 0x39uy; 0xbfuy; 0x09uy; 0x03uy; 0xa5uy; 0xf3uy; 0x05uy; 0x28uy; 0xe1uy; 0xe1uy; 0xeeuy; 0x39uy; 0x70uy; 0x9cuy; 0xd8uy; 0x81uy; 0x12uy; 0x1euy; 0x02uy; 0x40uy; 0xd2uy; 0x6euy; 0xf0uy; 0xebuy; 0x1buy; 0x3duy; 0x22uy; 0xc6uy; 0xe5uy; 0xe3uy; 0xb4uy; 0x5auy; 0x98uy; 0xbbuy; 0xf0uy; 0x22uy; 0x28uy; 0x8duy; 0xe5uy; 0xd3uy; 0x16uy; 0x48uy; 0x24uy; 0xa5uy; 0xe6uy; 0x66uy; 0x0cuy; 0xf9uy; 0x08uy; 0xf9uy; 0x7euy; 0x1euy; 0xe1uy; 0x28uy; 0x26uy; 0x22uy; 0xc7uy; 0xc7uy; 0x0auy; 0x32uy; 0x47uy; 0xfauy; 0xa3uy; 0xbeuy; 0x3cuy; 0xc4uy; 0xc5uy; 0x53uy; 0x0auy; 0xd5uy; 0x94uy; 0x4auy; 0xd7uy; 0x93uy; 0xd8uy; 0x42uy; 0x99uy; 0xb9uy; 0x0auy; 0xdbuy; 0x56uy; 0xf7uy; 0xb9uy; 0x1cuy; 0x53uy; 0x4fuy; 0xfauy; 0xd3uy; 0x74uy; 0xaduy; 0xd9uy; 0x68uy; 0xf1uy; 0x1buy; 0xdfuy; 0x61uy; 0xc6uy; 0x5euy; 0xa8uy; 0x48uy; 0xfcuy; 0xd4uy; 0x4auy; 0x4cuy; 0x3cuy; 0x32uy; 0xf7uy; 0x1cuy; 0x96uy; 0x21uy; 0x9buy; 0xf9uy; 0xa3uy; 0xccuy; 0x5auy; 0xceuy; 0xd5uy; 0xd7uy; 0x08uy; 0x24uy; 0xf6uy; 0x1cuy; 0xfduy; 0xdduy; 0x38uy; 0xc2uy; 0x32uy; 0xe9uy; 0xb8uy; 0xe7uy; 0xb6uy; 0xfauy; 0x9duy; 0x45uy; 0x13uy; 0x2cuy; 0x83uy; 0xfduy; 0x4auy; 0x69uy; 0x82uy; 0xcduy; 0xdcuy; 0xb3uy; 0x76uy; 0x0cuy; 0x9euy; 0xd8uy; 0xf4uy; 0x1buy; 0x45uy; 0x15uy; 0xb4uy; 0x97uy; 0xe7uy; 0x58uy; 0x34uy; 0xe2uy; 0x03uy; 0x29uy; 0x5auy; 0xbfuy; 0xb6uy; 0xe0uy; 0x5duy; 0x13uy; 0xd9uy; 0x2buy; 0xb4uy; 0x80uy; 0xb2uy; 0x45uy; 0x81uy; 0x6auy; 0x2euy; 0x6cuy; 0x89uy; 0x7duy; 0xeeuy; 0xbbuy; 0x52uy; 0xdduy; 0x1fuy; 0x18uy; 0xe7uy; 0x13uy; 0x6buy; 0x33uy; 0x0euy; 0xeauy; 0x36uy; 0x92uy; 0x77uy; 0x7buy; 0x6duy; 0x9cuy; 0x5auy; 0x5fuy; 0x45uy; 0x7buy; 0x7buy; 0x35uy; 0x62uy; 0x23uy; 0xd1uy; 0xbfuy; 0x0fuy; 0xd0uy; 0x08uy; 0x1buy; 0x2buy; 0x80uy; 0x6buy; 0x7euy; 0xf1uy; 0x21uy; 0x47uy; 0xb0uy; 0x57uy; 0xd1uy; 0x98uy; 0x72uy; 0x90uy; 0x34uy; 0x1cuy; 0x20uy; 0x04uy; 0xffuy; 0x3duy; 0x5cuy; 0xeeuy; 0x0euy; 0x57uy; 0x5fuy; 0x6fuy; 0x24uy; 0x4euy; 0x3cuy; 0xeauy; 0xfcuy; 0xa5uy; 0xa9uy; 0x83uy; 0xc9uy; 0x61uy; 0xb4uy; 0x51uy; 0x24uy; 0xf8uy; 0x27uy; 0x5euy; 0x46uy; 0x8cuy; 0xb1uy; 0x53uy; 0x02uy; 0x96uy; 0x35uy; 0xbauy; 0xb8uy; 0x4cuy; 0x71uy; 0xd3uy; 0x15uy; 0x59uy; 0x35uy; 0x22uy; 0x20uy; 0xaduy; 0x03uy; 0x9fuy; 0x66uy; 0x44uy; 0x3buy; 0x9cuy; 0x35uy; 0x37uy; 0x1fuy; 0x9buy; 0xbbuy; 0xf3uy; 0xdbuy; 0x35uy; 0x63uy; 0x30uy; 0x64uy; 0xaauy; 0xa2uy; 0x06uy; 0xa8uy; 0x5duy; 0xbbuy; 0xe1uy; 0x9fuy; 0x70uy; 0xecuy; 0x82uy; 0x11uy; 0x06uy; 0x36uy; 0xecuy; 0x8buy; 0x69uy; 0x66uy; 0x24uy; 0x44uy; 0xc9uy; 0x4auy; 0x57uy; 0xbbuy; 0x9buy; 0x78uy; 0x13uy; 0xceuy; 0x9cuy; 0x0cuy; 0xbauy; 0x92uy; 0x93uy; 0x63uy; 0xb8uy; 0xe2uy; 0x95uy; 0x0fuy; 0x0fuy; 0x16uy; 0x39uy; 0x52uy; 0xfduy; 0x3auy; 0x6duy; 0x02uy; 0x4buy; 0xdfuy; 0x13uy; 0xd3uy; 0x2auy; 0x22uy; 0xb4uy; 0x03uy; 0x7cuy; 0x54uy; 0x49uy; 0x96uy; 0x68uy; 0x54uy; 0x10uy; 0xfauy; 0xefuy; 0xaauy; 0x6cuy; 0xe8uy; 0x22uy; 0xdcuy; 0x71uy; 0x16uy; 0x13uy; 0x1auy; 0xf6uy; 0x28uy; 0xe5uy; 0x6duy; 0x77uy; 0x3duy; 0xcduy; 0x30uy; 0x63uy; 0xb1uy; 0x70uy; 0x52uy; 0xa1uy; 0xc5uy; 0x94uy; 0x5fuy; 0xcfuy; 0xe8uy; 0xb8uy; 0x26uy; 0x98uy; 0xf7uy; 0x06uy; 0xa0uy; 0x0auy; 0x70uy; 0xfauy; 0x03uy; 0x80uy; 0xacuy; 0xc1uy; 0xecuy; 0xd6uy; 0x4cuy; 0x54uy; 0xd7uy; 0xfeuy; 0x47uy; 0xb6uy; 0x88uy; 0x4auy; 0xf7uy; 0x71uy; 0x24uy; 0xeeuy; 0xf3uy; 0xd2uy; 0xc2uy; 0x4auy; 0x7fuy; 0xfeuy; 0x61uy; 0xc7uy; 0x35uy; 0xc9uy; 0x37uy; 0x67uy; 0xcbuy; 0x24uy; 0x35uy; 0xdauy; 0x7euy; 0xcauy; 0x5fuy; 0xf3uy; 0x8duy; 0xd4uy; 0x13uy; 0x8euy; 0xd6uy; 0xcbuy; 0x4duy; 0x53uy; 0x8fuy; 0x53uy; 0x1fuy; 0xc0uy; 0x74uy; 0xf7uy; 0x53uy; 0xb9uy; 0x5euy; 0x23uy; 0x37uy; 0xbauy; 0x6euy; 0xe3uy; 0x9duy; 0x07uy; 0x55uy; 0x25uy; 0x7buy; 0xe6uy; 0x2auy; 0x64uy; 0xd1uy; 0x32uy; 0xdduy; 0x54uy; 0x1buy; 0x4buy; 0xc0uy; 0xe1uy; 0xd7uy; 0x69uy; 0x58uy; 0xf8uy; 0x93uy; 0x29uy; 0xc4uy; 0xdduy; 0x23uy; 0x2fuy; 0xa5uy; 0xfcuy; 0x9duy; 0x7euy; 0xf8uy; 0xd4uy; 0x90uy; 0xcduy; 0x82uy; 0x55uy; 0xdcuy; 0x16uy; 0x16uy; 0x9fuy; 0x07uy; 0x52uy; 0x9buy; 0x9duy; 0x25uy; 0xeduy; 0x32uy; 0xc5uy; 0x7buy; 0xdfuy; 0xf6uy; 0x83uy; 0x46uy; 0x3duy; 0x65uy; 0xb7uy; 0xefuy; 0x87uy; 0x7auy; 0x12uy; 0x69uy; 0x8fuy; 0x06uy; 0x7cuy; 0x51uy; 0x15uy; 0x4auy; 0x08uy; 0xe8uy; 0xacuy; 0x9auy; 0x0cuy; 0x24uy; 0xa7uy; 0x27uy; 0xd8uy; 0x46uy; 0x2fuy; 0xe7uy; 0x01uy; 0x0euy; 0x1cuy; 0xc6uy; 0x91uy; 0xb0uy; 0x6euy; 0x85uy; 0x65uy; 0xf0uy; 0x29uy; 0x0duy; 0x2euy; 0x6buy; 0x3buy; 0xfbuy; 0x4buy; 0xdfuy; 0xe4uy; 0x80uy; 0x93uy; 0x03uy; 0x66uy; 0x46uy; 0x3euy; 0x8auy; 0x6euy; 0xf3uy; 0x5euy; 0x4duy; 0x62uy; 0x0euy; 0x49uy; 0x05uy; 0xafuy; 0xd4uy; 0xf8uy; 0x21uy; 0x20uy; 0x61uy; 0x1duy; 0x39uy; 0x17uy; 0xf4uy; 0x61uy; 0x47uy; 0x95uy; 0xfbuy; 0x15uy; 0x2euy; 0xb3uy; 0x4fuy; 0xd0uy; 0x5duy; 0xf5uy; 0x7duy; 0x40uy; 0xdauy; 0x90uy; 0x3cuy; 0x6buy; 0xcbuy; 0x17uy; 0x00uy; 0x13uy; 0x3buy; 0x64uy; 0x34uy; 0x1buy; 0xf0uy; 0xf2uy; 0xe5uy; 0x3buy; 0xb2uy; 0xc7uy; 0xd3uy; 0x5fuy; 0x3auy; 0x44uy; 0xa6uy; 0x9buy; 0xb7uy; 0x78uy; 0x0euy; 0x42uy; 0x5duy; 0x4cuy; 0xc1uy; 0xe9uy; 0xd2uy; 0xcbuy; 0xb7uy; 0x78uy; 0xd1uy; 0xfeuy; 0x9auy; 0xb5uy; 0x07uy; 0xe9uy; 0xe0uy; 0xbeuy; 0xe2uy; 0x8auy; 0xa7uy; 0x01uy; 0x83uy; 0x00uy; 0x8cuy; 0x5cuy; 0x08uy; 0xe6uy; 0x63uy; 0x12uy; 0x92uy; 0xb7uy; 0xb7uy; 0xa6uy; 0x19uy; 0x7duy; 0x38uy; 0x13uy; 0x38uy; 0x92uy; 0x87uy; 0x24uy; 0xf9uy; 0x48uy; 0xb3uy; 0x5euy; 0x87uy; 0x6auy; 0x40uy; 0x39uy; 0x5cuy; 0x3fuy; 0xeduy; 0x8fuy; 0xeeuy; 0xdbuy; 0x15uy; 0x82uy; 0x06uy; 0xdauy; 0x49uy; 0x21uy; 0x2buy; 0xb5uy; 0xbfuy; 0x32uy; 0x7cuy; 0x9fuy; 0x42uy; 0x28uy; 0x63uy; 0xcfuy; 0xafuy; 0x1euy; 0xf8uy; 0xc6uy; 0xa0uy; 0xd1uy; 0x02uy; 0x43uy; 0x57uy; 0x62uy; 0xecuy; 0x9buy; 0x0fuy; 0x01uy; 0x9euy; 0x71uy; 0xd8uy; 0x87uy; 0x9duy; 0x01uy; 0xc1uy; 0x58uy; 0x77uy; 0xd9uy; 0xafuy; 0xb1uy; 0x10uy; 0x7euy; 0xdduy; 0xa6uy; 0x50uy; 0x96uy; 0xe5uy; 0xf0uy; 0x72uy; 0x00uy; 0x6duy; 0x4buy; 0xf8uy; 0x2auy; 0x8fuy; 0x19uy; 0xf3uy; 0x22uy; 0x88uy; 0x11uy; 0x4auy; 0x8buy; 0x7cuy; 0xfduy; 0xb7uy; 0xeduy; 0xe1uy; 0xf6uy; 0x40uy; 0x39uy; 0xe0uy; 0xe9uy; 0xf6uy; 0x3duy; 0x25uy; 0xe6uy; 0x74uy; 0x3cuy; 0x58uy; 0x57uy; 0x7fuy; 0xe1uy; 0x22uy; 0x96uy; 0x47uy; 0x31uy; 0x91uy; 0xbauy; 0x70uy; 0x85uy; 0x28uy; 0x6buy; 0x9fuy; 0x6euy; 0x25uy; 0xacuy; 0x23uy; 0x66uy; 0x2fuy; 0x29uy; 0x88uy; 0x28uy; 0xceuy; 0x8cuy; 0x5cuy; 0x88uy; 0x53uy; 0xd1uy; 0x3buy; 0xccuy; 0x6auy; 0x51uy; 0xb2uy; 0xe1uy; 0x28uy; 0x3fuy; 0x91uy; 0xb4uy; 0x0duy; 0x00uy; 0x3auy; 0xe3uy; 0xf8uy; 0xc3uy; 0x8fuy; 0xd7uy; 0x96uy; 0x62uy; 0x0euy; 0x2euy; 0xfcuy; 0xc8uy; 0x6cuy; 0x77uy; 0xa6uy; 0x1duy; 0x22uy; 0xc1uy; 0xb8uy; 0xe6uy; 0x61uy; 0xd7uy; 0x67uy; 0x36uy; 0x13uy; 0x7buy; 0xbbuy; 0x9buy; 0x59uy; 0x09uy; 0xa6uy; 0xdfuy; 0xf7uy; 0x6buy; 0xa3uy; 0x40uy; 0x1auy; 0xf5uy; 0x4fuy; 0xb4uy; 0xdauy; 0xd3uy; 0xf3uy; 0x81uy; 0x93uy; 0xc6uy; 0x18uy; 0xd9uy; 0x26uy; 0xeeuy; 0xacuy; 0xf0uy; 0xaauy; 0xdfuy; 0xc5uy; 0x9cuy; 0xcauy; 0xc2uy; 0xa2uy; 0xccuy; 0x7buy; 0x5cuy; 0x24uy; 0xb0uy; 0xbcuy; 0xd0uy; 0x6auy; 0x4duy; 0x89uy; 0x09uy; 0xb8uy; 0x07uy; 0xfeuy; 0x87uy; 0xaduy; 0x0auy; 0xeauy; 0xb8uy; 0x42uy; 0xf9uy; 0x5euy; 0xb3uy; 0x3euy; 0x36uy; 0x4cuy; 0xafuy; 0x75uy; 0x9euy; 0x1cuy; 0xebuy; 0xbduy; 0xbcuy; 0xbbuy; 0x80uy; 0x40uy; 0xa7uy; 0x3auy; 0x30uy; 0xbfuy; 0xa8uy; 0x44uy; 0xf4uy; 0xebuy; 0x38uy; 0xaduy; 0x29uy; 0xbauy; 0x23uy; 0xeduy; 0x41uy; 0x0cuy; 0xeauy; 0xd2uy; 0xbbuy; 0x41uy; 0x18uy; 0xd6uy; 0xb9uy; 0xbauy; 0x65uy; 0x2buy; 0xa3uy; 0x91uy; 0x6duy; 0x1fuy; 0xa9uy; 0xf4uy; 0xd1uy; 0x25uy; 0x8duy; 0x4duy; 0x38uy; 0xffuy; 0x64uy; 0xa0uy; 0xecuy; 0xdeuy; 0xa6uy; 0xb6uy; 0x79uy; 0xabuy; 0x8euy; 0x33uy; 0x6cuy; 0x47uy; 0xdeuy; 0xafuy; 0x94uy; 0xa4uy; 0xa5uy; 0x86uy; 0x77uy; 0x55uy; 0x09uy; 0x92uy; 0x81uy; 0x31uy; 0x76uy; 0xc7uy; 0x34uy; 0x22uy; 0x89uy; 0x8euy; 0x3duy; 0x26uy; 0x26uy; 0xd7uy; 0xfcuy; 0x1euy; 0x16uy; 0x72uy; 0x13uy; 0x33uy; 0x63uy; 0xd5uy; 0x22uy; 0xbeuy; 0xb8uy; 0x04uy; 0x34uy; 0x84uy; 0x41uy; 0xbbuy; 0x80uy; 0xd0uy; 0x9fuy; 0x46uy; 0x48uy; 0x07uy; 0xa7uy; 0xfcuy; 0x2buy; 0x3auy; 0x75uy; 0x55uy; 0x8cuy; 0xc7uy; 0x6auy; 0xbduy; 0x7euy; 0x46uy; 0x08uy; 0x84uy; 0x0fuy; 0xd5uy; 0x74uy; 0xc0uy; 0x82uy; 0x8euy; 0xaauy; 0x61uy; 0x05uy; 0x01uy; 0xb2uy; 0x47uy; 0x6euy; 0x20uy; 0x6auy; 0x2duy; 0x58uy; 0x70uy; 0x48uy; 0x32uy; 0xa7uy; 0x37uy; 0xd2uy; 0xb8uy; 0x82uy; 0x1auy; 0x51uy; 0xb9uy; 0x61uy; 0xdduy; 0xfduy; 0x9duy; 0x6buy; 0x0euy; 0x18uy; 0x97uy; 0xf8uy; 0x45uy; 0x5fuy; 0x87uy; 0x10uy; 0xcfuy; 0x34uy; 0x72uy; 0x45uy; 0x26uy; 0x49uy; 0x70uy; 0xe7uy; 0xa3uy; 0x78uy; 0xe0uy; 0x52uy; 0x89uy; 0x84uy; 0x94uy; 0x83uy; 0x82uy; 0xc2uy; 0x69uy; 0x8fuy; 0xe3uy; 0xe1uy; 0x3fuy; 0x60uy; 0x74uy; 0x88uy; 0xc4uy; 0xf7uy; 0x75uy; 0x2cuy; 0xfbuy; 0xbduy; 0xb6uy; 0xc4uy; 0x7euy; 0x10uy; 0x0auy; 0x6cuy; 0x90uy; 0x04uy; 0x9euy; 0xc3uy; 0x3fuy; 0x59uy; 0x7cuy; 0xceuy; 0x31uy; 0x18uy; 0x60uy; 0x57uy; 0x73uy; 0x46uy; 0x94uy; 0x7duy; 0x06uy; 0xa0uy; 0x6duy; 0x44uy; 0xecuy; 0xa2uy; 0x0auy; 0x9euy; 0x05uy; 0x15uy; 0xefuy; 0xcauy; 0x5cuy; 0xbfuy; 0x00uy; 0xebuy; 0xf7uy; 0x3duy; 0x32uy; 0xd4uy; 0xa5uy; 0xefuy; 0x49uy; 0x89uy; 0x5euy; 0x46uy; 0xb0uy; 0xa6uy; 0x63uy; 0x5buy; 0x8auy; 0x73uy; 0xaeuy; 0x6fuy; 0xd5uy; 0x9duy; 0xf8uy; 0x4fuy; 0x40uy; 0xb5uy; 0xb2uy; 0x6euy; 0xd3uy; 0xb6uy; 0x01uy; 0xa9uy; 0x26uy; 0xa2uy; 0x21uy; 0xcfuy; 0x33uy; 0x7auy; 0x3auy; 0xa4uy; 0x23uy; 0x13uy; 0xb0uy; 0x69uy; 0x6auy; 0xeeuy; 0xceuy; 0xd8uy; 0x9duy; 0x01uy; 0x1duy; 0x50uy; 0xc1uy; 0x30uy; 0x6cuy; 0xb1uy; 0xcduy; 0xa0uy; 0xf0uy; 0xf0uy; 0xa2uy; 0x64uy; 0x6fuy; 0xbbuy; 0xbfuy; 0x5euy; 0xe6uy; 0xabuy; 0x87uy; 0xb4uy; 0x0fuy; 0x4fuy; 0x15uy; 0xafuy; 0xb5uy; 0x25uy; 0xa1uy; 0xb2uy; 0xd0uy; 0x80uy; 0x2cuy; 0xfbuy; 0xf9uy; 0xfeuy; 0xd2uy; 0x33uy; 0xbbuy; 0x76uy; 0xfeuy; 0x7cuy; 0xa8uy; 0x66uy; 0xf7uy; 0xe7uy; 0x85uy; 0x9fuy; 0x1fuy; 0x85uy; 0x57uy; 0x88uy; 0xe1uy; 0xe9uy; 0x63uy; 0xe4uy; 0xd8uy; 0x1cuy; 0xa1uy; 0xfbuy; 0xdauy; 0x44uy; 0x05uy; 0x2euy; 0x1duy; 0x3auy; 0x1cuy; 0xffuy; 0xc8uy; 0x3buy; 0xc0uy; 0xfeuy; 0xdauy; 0x22uy; 0x0buy; 0x43uy; 0xd6uy; 0x88uy; 0x39uy; 0x4cuy; 0x4auy; 0xa6uy; 0x69uy; 0x18uy; 0x93uy; 0x42uy; 0x4euy; 0xb5uy; 0xccuy; 0x66uy; 0x0duy; 0x09uy; 0xf8uy; 0x1euy; 0x7cuy; 0xd3uy; 0x3cuy; 0x99uy; 0x0duy; 0x50uy; 0x1duy; 0x62uy; 0xe9uy; 0x57uy; 0x06uy; 0xbfuy; 0x19uy; 0x88uy; 0xdduy; 0xaduy; 0x7buy; 0x4fuy; 0xf9uy; 0xc7uy; 0x82uy; 0x6duy; 0x8duy; 0xc8uy; 0xc4uy; 0xc5uy; 0x78uy; 0x17uy; 0x20uy; 0x15uy; 0xc5uy; 0x52uy; 0x41uy; 0xcfuy; 0x5buy; 0xd6uy; 0x7fuy; 0x94uy; 0x02uy; 0x41uy; 0xe0uy; 0x40uy; 0x22uy; 0x03uy; 0x5euy; 0xd1uy; 0x53uy; 0xd4uy; 0x86uy; 0xd3uy; 0x2cuy; 0x9fuy; 0x0fuy; 0x96uy; 0xe3uy; 0x6buy; 0x9auy; 0x76uy; 0x32uy; 0x06uy; 0x47uy; 0x4buy; 0x11uy; 0xb3uy; 0xdduy; 0x03uy; 0x65uy; 0xbduy; 0x9buy; 0x01uy; 0xdauy; 0x9cuy; 0xb9uy; 0x7euy; 0x3fuy; 0x6auy; 0xc4uy; 0x7buy; 0xeauy; 0xd4uy; 0x3cuy; 0xb9uy; 0xfbuy; 0x5cuy; 0x6buy; 0x64uy; 0x33uy; 0x52uy; 0xbauy; 0x64uy; 0x78uy; 0x8fuy; 0xa4uy; 0xafuy; 0x7auy; 0x61uy; 0x8duy; 0xbcuy; 0xc5uy; 0x73uy; 0xe9uy; 0x6buy; 0x58uy; 0x97uy; 0x4buy; 0xbfuy; 0x63uy; 0x22uy; 0xd3uy; 0x37uy; 0x02uy; 0x54uy; 0xc5uy; 0xb9uy; 0x16uy; 0x4auy; 0xf0uy; 0x19uy; 0xd8uy; 0x94uy; 0x57uy; 0xb8uy; 0x8auy; 0xb3uy; 0x16uy; 0x3buy; 0xd0uy; 0x84uy; 0x8euy; 0x67uy; 0xa6uy; 0xa3uy; 0x7duy; 0x78uy; 0xecuy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 2011);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input11_len: (x:UInt32.t { UInt32.v x = B.length input11 }) =
  2011ul

let output11: (b: B.buffer UInt8.t { B.length b = 2027 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x52uy; 0x34uy; 0xb3uy; 0x65uy; 0x3buy; 0xb7uy; 0xe5uy; 0xd3uy; 0xabuy; 0x49uy; 0x17uy; 0x60uy; 0xd2uy; 0x52uy; 0x56uy; 0xdfuy; 0xdfuy; 0x34uy; 0x56uy; 0x82uy; 0xe2uy; 0xbeuy; 0xe5uy; 0xe1uy; 0x28uy; 0xd1uy; 0x4euy; 0x5fuy; 0x4fuy; 0x01uy; 0x7duy; 0x3fuy; 0x99uy; 0x6buy; 0x30uy; 0x6euy; 0x1auy; 0x7cuy; 0x4cuy; 0x8euy; 0x62uy; 0x81uy; 0xaeuy; 0x86uy; 0x3fuy; 0x6buy; 0xd0uy; 0xb5uy; 0xa9uy; 0xcfuy; 0x50uy; 0xf1uy; 0x02uy; 0x12uy; 0xa0uy; 0x0buy; 0x24uy; 0xe9uy; 0xe6uy; 0x72uy; 0x89uy; 0x2cuy; 0x52uy; 0x1buy; 0x34uy; 0x38uy; 0xf8uy; 0x75uy; 0x5fuy; 0xa0uy; 0x74uy; 0xe2uy; 0x99uy; 0xdduy; 0xa6uy; 0x4buy; 0x14uy; 0x50uy; 0x4euy; 0xf1uy; 0xbeuy; 0xd6uy; 0x9euy; 0xdbuy; 0xb2uy; 0x24uy; 0x27uy; 0x74uy; 0x12uy; 0x4auy; 0x78uy; 0x78uy; 0x17uy; 0xa5uy; 0x58uy; 0x8euy; 0x2fuy; 0xf9uy; 0xf4uy; 0x8duy; 0xeeuy; 0x03uy; 0x88uy; 0xaeuy; 0xb8uy; 0x29uy; 0xa1uy; 0x2fuy; 0x4buy; 0xeeuy; 0x92uy; 0xbduy; 0x87uy; 0xb3uy; 0xceuy; 0x34uy; 0x21uy; 0x57uy; 0x46uy; 0x04uy; 0x49uy; 0x0cuy; 0x80uy; 0xf2uy; 0x01uy; 0x13uy; 0xa1uy; 0x55uy; 0xb3uy; 0xffuy; 0x44uy; 0x30uy; 0x3cuy; 0x1cuy; 0xd0uy; 0xefuy; 0xbcuy; 0x18uy; 0x74uy; 0x26uy; 0xaduy; 0x41uy; 0x5buy; 0x5buy; 0x3euy; 0x9auy; 0x7auy; 0x46uy; 0x4fuy; 0x16uy; 0xd6uy; 0x74uy; 0x5auy; 0xb7uy; 0x3auy; 0x28uy; 0x31uy; 0xd8uy; 0xaeuy; 0x26uy; 0xacuy; 0x50uy; 0x53uy; 0x86uy; 0xf2uy; 0x56uy; 0xd7uy; 0x3fuy; 0x29uy; 0xbcuy; 0x45uy; 0x68uy; 0x8euy; 0xcbuy; 0x98uy; 0x64uy; 0xdduy; 0xc9uy; 0xbauy; 0xb8uy; 0x4buy; 0x7buy; 0x82uy; 0xdduy; 0x14uy; 0xa7uy; 0xcbuy; 0x71uy; 0x72uy; 0x00uy; 0x5cuy; 0xaduy; 0x7buy; 0x6auy; 0x89uy; 0xa4uy; 0x3duy; 0xbfuy; 0xb5uy; 0x4buy; 0x3euy; 0x7cuy; 0x5auy; 0xcfuy; 0xb8uy; 0xa1uy; 0xc5uy; 0x6euy; 0xc8uy; 0xb6uy; 0x31uy; 0x57uy; 0x7buy; 0xdfuy; 0xa5uy; 0x7euy; 0xb1uy; 0xd6uy; 0x42uy; 0x2auy; 0x31uy; 0x36uy; 0xd1uy; 0xd0uy; 0x3fuy; 0x7auy; 0xe5uy; 0x94uy; 0xd6uy; 0x36uy; 0xa0uy; 0x6fuy; 0xb7uy; 0x40uy; 0x7duy; 0x37uy; 0xc6uy; 0x55uy; 0x7cuy; 0x50uy; 0x40uy; 0x6duy; 0x29uy; 0x89uy; 0xe3uy; 0x5auy; 0xaeuy; 0x97uy; 0xe7uy; 0x44uy; 0x49uy; 0x6euy; 0xbduy; 0x81uy; 0x3duy; 0x03uy; 0x93uy; 0x06uy; 0x12uy; 0x06uy; 0xe2uy; 0x41uy; 0x12uy; 0x4auy; 0xf1uy; 0x6auy; 0xa4uy; 0x58uy; 0xa2uy; 0xfbuy; 0xd2uy; 0x15uy; 0xbauy; 0xc9uy; 0x79uy; 0xc9uy; 0xceuy; 0x5euy; 0x13uy; 0xbbuy; 0xf1uy; 0x09uy; 0x04uy; 0xccuy; 0xfduy; 0xe8uy; 0x51uy; 0x34uy; 0x6auy; 0xe8uy; 0x61uy; 0x88uy; 0xdauy; 0xeduy; 0x01uy; 0x47uy; 0x84uy; 0xf5uy; 0x73uy; 0x25uy; 0xf9uy; 0x1cuy; 0x42uy; 0x86uy; 0x07uy; 0xf3uy; 0x5buy; 0x1auy; 0x01uy; 0xb3uy; 0xebuy; 0x24uy; 0x32uy; 0x8duy; 0xf6uy; 0xeduy; 0x7cuy; 0x4buy; 0xebuy; 0x3cuy; 0x36uy; 0x42uy; 0x28uy; 0xdfuy; 0xdfuy; 0xb6uy; 0xbeuy; 0xd9uy; 0x8cuy; 0x52uy; 0xd3uy; 0x2buy; 0x08uy; 0x90uy; 0x8cuy; 0xe7uy; 0x98uy; 0x31uy; 0xe2uy; 0x32uy; 0x8euy; 0xfcuy; 0x11uy; 0x48uy; 0x00uy; 0xa8uy; 0x6auy; 0x42uy; 0x4auy; 0x02uy; 0xc6uy; 0x4buy; 0x09uy; 0xf1uy; 0xe3uy; 0x49uy; 0xf3uy; 0x45uy; 0x1fuy; 0x0euy; 0xbcuy; 0x56uy; 0xe2uy; 0xe4uy; 0xdfuy; 0xfbuy; 0xebuy; 0x61uy; 0xfauy; 0x24uy; 0xc1uy; 0x63uy; 0x75uy; 0xbbuy; 0x47uy; 0x75uy; 0xafuy; 0xe1uy; 0x53uy; 0x16uy; 0x96uy; 0x21uy; 0x85uy; 0x26uy; 0x11uy; 0xb3uy; 0x76uy; 0xe3uy; 0x23uy; 0xa1uy; 0x6buy; 0x74uy; 0x37uy; 0xd0uy; 0xdeuy; 0x06uy; 0x90uy; 0x71uy; 0x5duy; 0x43uy; 0x88uy; 0x9buy; 0x00uy; 0x54uy; 0xa6uy; 0x75uy; 0x2fuy; 0xa1uy; 0xc2uy; 0x0buy; 0x73uy; 0x20uy; 0x1duy; 0xb6uy; 0x21uy; 0x79uy; 0x57uy; 0x3fuy; 0xfauy; 0x09uy; 0xbeuy; 0x8auy; 0x33uy; 0xc3uy; 0x52uy; 0xf0uy; 0x1duy; 0x82uy; 0x31uy; 0xd1uy; 0x55uy; 0xb5uy; 0x6cuy; 0x99uy; 0x25uy; 0xcfuy; 0x5cuy; 0x32uy; 0xceuy; 0xe9uy; 0x0duy; 0xfauy; 0x69uy; 0x2cuy; 0xd5uy; 0x0duy; 0xc5uy; 0x6duy; 0x86uy; 0xd0uy; 0x0cuy; 0x3buy; 0x06uy; 0x50uy; 0x79uy; 0xe8uy; 0xc3uy; 0xaeuy; 0x04uy; 0xe6uy; 0xcduy; 0x51uy; 0xe4uy; 0x26uy; 0x9buy; 0x4fuy; 0x7euy; 0xa6uy; 0x0fuy; 0xabuy; 0xd8uy; 0xe5uy; 0xdeuy; 0xa9uy; 0x00uy; 0x95uy; 0xbeuy; 0xa3uy; 0x9duy; 0x5duy; 0xb2uy; 0x09uy; 0x70uy; 0x18uy; 0x1cuy; 0xf0uy; 0xacuy; 0x29uy; 0x23uy; 0x02uy; 0x29uy; 0x28uy; 0xd2uy; 0x74uy; 0x35uy; 0x57uy; 0x62uy; 0x0fuy; 0x24uy; 0xeauy; 0x5euy; 0x33uy; 0xc2uy; 0x92uy; 0xf3uy; 0x78uy; 0x4duy; 0x30uy; 0x1euy; 0xa1uy; 0x99uy; 0xa9uy; 0x82uy; 0xb0uy; 0x42uy; 0x31uy; 0x8duy; 0xaduy; 0x8auy; 0xbcuy; 0xfcuy; 0xd4uy; 0x57uy; 0x47uy; 0x3euy; 0xb4uy; 0x50uy; 0xdduy; 0x6euy; 0x2cuy; 0x80uy; 0x4duy; 0x22uy; 0xf1uy; 0xfbuy; 0x57uy; 0xc4uy; 0xdduy; 0x17uy; 0xe1uy; 0x8auy; 0x36uy; 0x4auy; 0xb3uy; 0x37uy; 0xcauy; 0xc9uy; 0x4euy; 0xabuy; 0xd5uy; 0x69uy; 0xc4uy; 0xf4uy; 0xbcuy; 0x0buy; 0x3buy; 0x44uy; 0x4buy; 0x29uy; 0x9cuy; 0xeeuy; 0xd4uy; 0x35uy; 0x22uy; 0x21uy; 0xb0uy; 0x1fuy; 0x27uy; 0x64uy; 0xa8uy; 0x51uy; 0x1buy; 0xf0uy; 0x9fuy; 0x19uy; 0x5cuy; 0xfbuy; 0x5auy; 0x64uy; 0x74uy; 0x70uy; 0x45uy; 0x09uy; 0xf5uy; 0x64uy; 0xfeuy; 0x1auy; 0x2duy; 0xc9uy; 0x14uy; 0x04uy; 0x14uy; 0xcfuy; 0xd5uy; 0x7duy; 0x60uy; 0xafuy; 0x94uy; 0x39uy; 0x94uy; 0xe2uy; 0x7duy; 0x79uy; 0x82uy; 0xd0uy; 0x65uy; 0x3buy; 0x6buy; 0x9cuy; 0x19uy; 0x84uy; 0xb4uy; 0x6duy; 0xb3uy; 0x0cuy; 0x99uy; 0xc0uy; 0x56uy; 0xa8uy; 0xbduy; 0x73uy; 0xceuy; 0x05uy; 0x84uy; 0x3euy; 0x30uy; 0xaauy; 0xc4uy; 0x9buy; 0x1buy; 0x04uy; 0x2auy; 0x9fuy; 0xd7uy; 0x43uy; 0x2buy; 0x23uy; 0xdfuy; 0xbfuy; 0xaauy; 0xd5uy; 0xc2uy; 0x43uy; 0x2duy; 0x70uy; 0xabuy; 0xdcuy; 0x75uy; 0xaduy; 0xacuy; 0xf7uy; 0xc0uy; 0xbeuy; 0x67uy; 0xb2uy; 0x74uy; 0xeduy; 0x67uy; 0x10uy; 0x4auy; 0x92uy; 0x60uy; 0xc1uy; 0x40uy; 0x50uy; 0x19uy; 0x8auy; 0x8auy; 0x8cuy; 0x09uy; 0x0euy; 0x72uy; 0xe1uy; 0x73uy; 0x5euy; 0xe8uy; 0x41uy; 0x85uy; 0x63uy; 0x9fuy; 0x3fuy; 0xd7uy; 0x7duy; 0xc4uy; 0xfbuy; 0x22uy; 0x5duy; 0x92uy; 0x6cuy; 0xb3uy; 0x1euy; 0xe2uy; 0x50uy; 0x2fuy; 0x82uy; 0xa8uy; 0x28uy; 0xc0uy; 0xb5uy; 0xd7uy; 0x5fuy; 0x68uy; 0x0duy; 0x2cuy; 0x2duy; 0xafuy; 0x7euy; 0xfauy; 0x2euy; 0x08uy; 0x0fuy; 0x1fuy; 0x70uy; 0x9fuy; 0xe9uy; 0x19uy; 0x72uy; 0x55uy; 0xf8uy; 0xfbuy; 0x51uy; 0xd2uy; 0x33uy; 0x5duy; 0xa0uy; 0xd3uy; 0x2buy; 0x0auy; 0x6cuy; 0xbcuy; 0x4euy; 0xcfuy; 0x36uy; 0x4duy; 0xdcuy; 0x3buy; 0xe9uy; 0x3euy; 0x81uy; 0x7cuy; 0x61uy; 0xdbuy; 0x20uy; 0x2duy; 0x3auy; 0xc3uy; 0xb3uy; 0x0cuy; 0x1euy; 0x00uy; 0xb9uy; 0x7cuy; 0xf5uy; 0xcauy; 0x10uy; 0x5fuy; 0x3auy; 0x71uy; 0xb3uy; 0xe4uy; 0x20uy; 0xdbuy; 0x0cuy; 0x2auy; 0x98uy; 0x63uy; 0x45uy; 0x00uy; 0x58uy; 0xf6uy; 0x68uy; 0xe4uy; 0x0buy; 0xdauy; 0x13uy; 0x3buy; 0x60uy; 0x5cuy; 0x76uy; 0xdbuy; 0xb9uy; 0x97uy; 0x71uy; 0xe4uy; 0xd9uy; 0xb7uy; 0xdbuy; 0xbduy; 0x68uy; 0xc7uy; 0x84uy; 0x84uy; 0xaauy; 0x7cuy; 0x68uy; 0x62uy; 0x5euy; 0x16uy; 0xfcuy; 0xbauy; 0x72uy; 0xaauy; 0x9auy; 0xa9uy; 0xebuy; 0x7cuy; 0x75uy; 0x47uy; 0x97uy; 0x7euy; 0xaduy; 0xe2uy; 0xd9uy; 0x91uy; 0xe8uy; 0xe4uy; 0xa5uy; 0x31uy; 0xd7uy; 0x01uy; 0x8euy; 0xa2uy; 0x11uy; 0x88uy; 0x95uy; 0xb9uy; 0xf2uy; 0x9buy; 0xd3uy; 0x7fuy; 0x1buy; 0x81uy; 0x22uy; 0xf7uy; 0x98uy; 0x60uy; 0x0auy; 0x64uy; 0xa6uy; 0xc1uy; 0xf6uy; 0x49uy; 0xc7uy; 0xe3uy; 0x07uy; 0x4duy; 0x94uy; 0x7auy; 0xcfuy; 0x6euy; 0x68uy; 0x0cuy; 0x1buy; 0x3fuy; 0x6euy; 0x2euy; 0xeeuy; 0x92uy; 0xfauy; 0x52uy; 0xb3uy; 0x59uy; 0xf8uy; 0xf1uy; 0x8fuy; 0x6auy; 0x66uy; 0xa3uy; 0x82uy; 0x76uy; 0x4auy; 0x07uy; 0x1auy; 0xc7uy; 0xdduy; 0xf5uy; 0xdauy; 0x9cuy; 0x3cuy; 0x24uy; 0xbfuy; 0xfduy; 0x42uy; 0xa1uy; 0x10uy; 0x64uy; 0x6auy; 0x0fuy; 0x89uy; 0xeeuy; 0x36uy; 0xa5uy; 0xceuy; 0x99uy; 0x48uy; 0x6auy; 0xf0uy; 0x9fuy; 0x9euy; 0x69uy; 0xa4uy; 0x40uy; 0x20uy; 0xe9uy; 0x16uy; 0x15uy; 0xf7uy; 0xdbuy; 0x75uy; 0x02uy; 0xcbuy; 0xe9uy; 0x73uy; 0x8buy; 0x3buy; 0x49uy; 0x2fuy; 0xf0uy; 0xafuy; 0x51uy; 0x06uy; 0x5cuy; 0xdfuy; 0x27uy; 0x27uy; 0x49uy; 0x6auy; 0xd1uy; 0xccuy; 0xc7uy; 0xb5uy; 0x63uy; 0xb5uy; 0xfcuy; 0xb8uy; 0x5cuy; 0x87uy; 0x7fuy; 0x84uy; 0xb4uy; 0xccuy; 0x14uy; 0xa9uy; 0x53uy; 0xdauy; 0xa4uy; 0x56uy; 0xf8uy; 0xb6uy; 0x1buy; 0xccuy; 0x40uy; 0x27uy; 0x52uy; 0x06uy; 0x5auy; 0x13uy; 0x81uy; 0xd7uy; 0x3auy; 0xd4uy; 0x3buy; 0xfbuy; 0x49uy; 0x65uy; 0x31uy; 0x33uy; 0xb2uy; 0xfauy; 0xcduy; 0xaduy; 0x58uy; 0x4euy; 0x2buy; 0xaeuy; 0xd2uy; 0x20uy; 0xfbuy; 0x1auy; 0x48uy; 0xb4uy; 0x3fuy; 0x9auy; 0xd8uy; 0x7auy; 0x35uy; 0x4auy; 0xc8uy; 0xeeuy; 0x88uy; 0x5euy; 0x07uy; 0x66uy; 0x54uy; 0xb9uy; 0xecuy; 0x9fuy; 0xa3uy; 0xe3uy; 0xb9uy; 0x37uy; 0xaauy; 0x49uy; 0x76uy; 0x31uy; 0xdauy; 0x74uy; 0x2duy; 0x3cuy; 0xa4uy; 0x65uy; 0x10uy; 0x32uy; 0x38uy; 0xf0uy; 0xdeuy; 0xd3uy; 0x99uy; 0x17uy; 0xaauy; 0x71uy; 0xaauy; 0x8fuy; 0x0fuy; 0x8cuy; 0xafuy; 0xa2uy; 0xf8uy; 0x5duy; 0x64uy; 0xbauy; 0x1duy; 0xa3uy; 0xefuy; 0x96uy; 0x73uy; 0xe8uy; 0xa1uy; 0x02uy; 0x8duy; 0x0cuy; 0x6duy; 0xb8uy; 0x06uy; 0x90uy; 0xb8uy; 0x08uy; 0x56uy; 0x2cuy; 0xa7uy; 0x06uy; 0xc9uy; 0xc2uy; 0x38uy; 0xdbuy; 0x7cuy; 0x63uy; 0xb1uy; 0x57uy; 0x8euy; 0xeauy; 0x7cuy; 0x79uy; 0xf3uy; 0x49uy; 0x1duy; 0xfeuy; 0x9fuy; 0xf3uy; 0x6euy; 0xb1uy; 0x1duy; 0xbauy; 0x19uy; 0x80uy; 0x1auy; 0x0auy; 0xd3uy; 0xb0uy; 0x26uy; 0x21uy; 0x40uy; 0xb1uy; 0x7cuy; 0xf9uy; 0x4duy; 0x8duy; 0x10uy; 0xc1uy; 0x7euy; 0xf4uy; 0xf6uy; 0x3cuy; 0xa8uy; 0xfduy; 0x7cuy; 0xa3uy; 0x92uy; 0xb2uy; 0x0fuy; 0xaauy; 0xccuy; 0xa6uy; 0x11uy; 0xfeuy; 0x04uy; 0xe3uy; 0xd1uy; 0x7auy; 0x32uy; 0x89uy; 0xdfuy; 0x0duy; 0xc4uy; 0x8fuy; 0x79uy; 0x6buy; 0xcauy; 0x16uy; 0x7cuy; 0x6euy; 0xf9uy; 0xaduy; 0x0fuy; 0xf6uy; 0xfeuy; 0x27uy; 0xdbuy; 0xc4uy; 0x13uy; 0x70uy; 0xf1uy; 0x62uy; 0x1auy; 0x4fuy; 0x79uy; 0x40uy; 0xc9uy; 0x9buy; 0x8buy; 0x21uy; 0xeauy; 0x84uy; 0xfauy; 0xf5uy; 0xf1uy; 0x89uy; 0xceuy; 0xb7uy; 0x55uy; 0x0auy; 0x80uy; 0x39uy; 0x2fuy; 0x55uy; 0x36uy; 0x16uy; 0x9cuy; 0x7buy; 0x08uy; 0xbduy; 0x87uy; 0x0duy; 0xa5uy; 0x32uy; 0xf1uy; 0x52uy; 0x7cuy; 0xe8uy; 0x55uy; 0x60uy; 0x5buy; 0xd7uy; 0x69uy; 0xe4uy; 0xfcuy; 0xfauy; 0x12uy; 0x85uy; 0x96uy; 0xeauy; 0x50uy; 0x28uy; 0xabuy; 0x8auy; 0xf7uy; 0xbbuy; 0x0euy; 0x53uy; 0x74uy; 0xcauy; 0xa6uy; 0x27uy; 0x09uy; 0xc2uy; 0xb5uy; 0xdeuy; 0x18uy; 0x14uy; 0xd9uy; 0xeauy; 0xe5uy; 0x29uy; 0x1cuy; 0x40uy; 0x56uy; 0xcfuy; 0xd7uy; 0xaeuy; 0x05uy; 0x3fuy; 0x65uy; 0xafuy; 0x05uy; 0x73uy; 0xe2uy; 0x35uy; 0x96uy; 0x27uy; 0x07uy; 0x14uy; 0xc0uy; 0xaduy; 0x33uy; 0xf1uy; 0xdcuy; 0x44uy; 0x7auy; 0x89uy; 0x17uy; 0x77uy; 0xd2uy; 0x9cuy; 0x58uy; 0x60uy; 0xf0uy; 0x3fuy; 0x7buy; 0x2duy; 0x2euy; 0x57uy; 0x95uy; 0x54uy; 0x87uy; 0xeduy; 0xf2uy; 0xc7uy; 0x4cuy; 0xf0uy; 0xaeuy; 0x56uy; 0x29uy; 0x19uy; 0x7duy; 0x66uy; 0x4buy; 0x9buy; 0x83uy; 0x84uy; 0x42uy; 0x3buy; 0x01uy; 0x25uy; 0x66uy; 0x8euy; 0x02uy; 0xdeuy; 0xb9uy; 0x83uy; 0x54uy; 0x19uy; 0xf6uy; 0x9fuy; 0x79uy; 0x0duy; 0x67uy; 0xc5uy; 0x1duy; 0x7auy; 0x44uy; 0x02uy; 0x98uy; 0xa7uy; 0x16uy; 0x1cuy; 0x29uy; 0x0duy; 0x74uy; 0xffuy; 0x85uy; 0x40uy; 0x06uy; 0xefuy; 0x2cuy; 0xa9uy; 0xc6uy; 0xf5uy; 0x53uy; 0x07uy; 0x06uy; 0xaeuy; 0xe4uy; 0xfauy; 0x5fuy; 0xd8uy; 0x39uy; 0x4duy; 0xf1uy; 0x9buy; 0x6buy; 0xd9uy; 0x24uy; 0x84uy; 0xfeuy; 0x03uy; 0x4cuy; 0xb2uy; 0x3fuy; 0xdfuy; 0xa1uy; 0x05uy; 0x9euy; 0x50uy; 0x14uy; 0x5auy; 0xd9uy; 0x1auy; 0xa2uy; 0xa7uy; 0xfauy; 0xfauy; 0x17uy; 0xf7uy; 0x78uy; 0xd6uy; 0xb5uy; 0x92uy; 0x61uy; 0x91uy; 0xacuy; 0x36uy; 0xfauy; 0x56uy; 0x0duy; 0x38uy; 0x32uy; 0x18uy; 0x85uy; 0x08uy; 0x58uy; 0x37uy; 0xf0uy; 0x4buy; 0xdbuy; 0x59uy; 0xe7uy; 0xa4uy; 0x34uy; 0xc0uy; 0x1buy; 0x01uy; 0xafuy; 0x2duy; 0xdeuy; 0xa1uy; 0xaauy; 0x5duy; 0xd3uy; 0xecuy; 0xe1uy; 0xd4uy; 0xf7uy; 0xe6uy; 0x54uy; 0x68uy; 0xf0uy; 0x51uy; 0x97uy; 0xa7uy; 0x89uy; 0xeauy; 0x24uy; 0xaduy; 0xd3uy; 0x6euy; 0x47uy; 0x93uy; 0x8buy; 0x4buy; 0xb4uy; 0xf7uy; 0x1cuy; 0x42uy; 0x06uy; 0x67uy; 0xe8uy; 0x99uy; 0xf6uy; 0xf5uy; 0x7buy; 0x85uy; 0xb5uy; 0x65uy; 0xb5uy; 0xb5uy; 0xd2uy; 0x37uy; 0xf5uy; 0xf3uy; 0x02uy; 0xa6uy; 0x4duy; 0x11uy; 0xa7uy; 0xdcuy; 0x51uy; 0x09uy; 0x7fuy; 0xa0uy; 0xd8uy; 0x88uy; 0x1cuy; 0x13uy; 0x71uy; 0xaeuy; 0x9cuy; 0xb7uy; 0x7buy; 0x34uy; 0xd6uy; 0x4euy; 0x68uy; 0x26uy; 0x83uy; 0x51uy; 0xafuy; 0x1duy; 0xeeuy; 0x8buy; 0xbbuy; 0x69uy; 0x43uy; 0x2buy; 0x9euy; 0x8auy; 0xbcuy; 0x02uy; 0x0euy; 0xa0uy; 0x1buy; 0xe0uy; 0xa8uy; 0x5fuy; 0x6fuy; 0xafuy; 0x1buy; 0x8fuy; 0xe7uy; 0x64uy; 0x71uy; 0x74uy; 0x11uy; 0x7euy; 0xa8uy; 0xd8uy; 0xf9uy; 0x97uy; 0x06uy; 0xc3uy; 0xb6uy; 0xfbuy; 0xfbuy; 0xb7uy; 0x3duy; 0x35uy; 0x9duy; 0x3buy; 0x52uy; 0xeduy; 0x54uy; 0xcauy; 0xf4uy; 0x81uy; 0x01uy; 0x2duy; 0x1buy; 0xc3uy; 0xa7uy; 0x00uy; 0x3duy; 0x1auy; 0x39uy; 0x54uy; 0xe1uy; 0xf6uy; 0xffuy; 0xeduy; 0x6fuy; 0x0buy; 0x5auy; 0x68uy; 0xdauy; 0x58uy; 0xdduy; 0xa9uy; 0xcfuy; 0x5cuy; 0x4auy; 0xe5uy; 0x09uy; 0x4euy; 0xdeuy; 0x9duy; 0xbcuy; 0x3euy; 0xeeuy; 0x5auy; 0x00uy; 0x3buy; 0x2cuy; 0x87uy; 0x10uy; 0x65uy; 0x60uy; 0xdduy; 0xd7uy; 0x56uy; 0xd1uy; 0x4cuy; 0x64uy; 0x45uy; 0xe4uy; 0x21uy; 0xecuy; 0x78uy; 0xf8uy; 0x25uy; 0x7auy; 0x3euy; 0x16uy; 0x5duy; 0x09uy; 0x53uy; 0x14uy; 0xbeuy; 0x4fuy; 0xaeuy; 0x87uy; 0xd8uy; 0xd1uy; 0xaauy; 0x3cuy; 0xf6uy; 0x3euy; 0xa4uy; 0x70uy; 0x8cuy; 0x5euy; 0x70uy; 0xa4uy; 0xb3uy; 0x6buy; 0x66uy; 0x73uy; 0xd3uy; 0xbfuy; 0x31uy; 0x06uy; 0x19uy; 0x62uy; 0x93uy; 0x15uy; 0xf2uy; 0x86uy; 0xe4uy; 0x52uy; 0x7euy; 0x53uy; 0x4cuy; 0x12uy; 0x38uy; 0xccuy; 0x34uy; 0x7duy; 0x57uy; 0xf6uy; 0x42uy; 0x93uy; 0x8auy; 0xc4uy; 0xeeuy; 0x5cuy; 0x8auy; 0xe1uy; 0x52uy; 0x8fuy; 0x56uy; 0x64uy; 0xf6uy; 0xa6uy; 0xd1uy; 0x91uy; 0x57uy; 0x70uy; 0xcduy; 0x11uy; 0x76uy; 0xf5uy; 0x59uy; 0x60uy; 0x60uy; 0x3cuy; 0xc1uy; 0xc3uy; 0x0buy; 0x7fuy; 0x58uy; 0x1auy; 0x50uy; 0x91uy; 0xf1uy; 0x68uy; 0x8fuy; 0x6euy; 0x74uy; 0x74uy; 0xa8uy; 0x51uy; 0x0buy; 0xf7uy; 0x7auy; 0x98uy; 0x37uy; 0xf2uy; 0x0auy; 0x0euy; 0xa4uy; 0x97uy; 0x04uy; 0xb8uy; 0x9buy; 0xfduy; 0xa0uy; 0xeauy; 0xf7uy; 0x0duy; 0xe1uy; 0xdbuy; 0x03uy; 0xf0uy; 0x31uy; 0x29uy; 0xf8uy; 0xdduy; 0x6buy; 0x8buy; 0x5duy; 0xd8uy; 0x59uy; 0xa9uy; 0x29uy; 0xcfuy; 0x9auy; 0x79uy; 0x89uy; 0x19uy; 0x63uy; 0x46uy; 0x09uy; 0x79uy; 0x6auy; 0x11uy; 0xdauy; 0x63uy; 0x68uy; 0x48uy; 0x77uy; 0x23uy; 0xfbuy; 0x7duy; 0x3auy; 0x43uy; 0xcbuy; 0x02uy; 0x3buy; 0x7auy; 0x6duy; 0x10uy; 0x2auy; 0x9euy; 0xacuy; 0xf1uy; 0xd4uy; 0x19uy; 0xf8uy; 0x23uy; 0x64uy; 0x1duy; 0x2cuy; 0x5fuy; 0xf2uy; 0xb0uy; 0x5cuy; 0x23uy; 0x27uy; 0xf7uy; 0x27uy; 0x30uy; 0x16uy; 0x37uy; 0xb1uy; 0x90uy; 0xabuy; 0x38uy; 0xfbuy; 0x55uy; 0xcduy; 0x78uy; 0x58uy; 0xd4uy; 0x7duy; 0x43uy; 0xf6uy; 0x45uy; 0x5euy; 0x55uy; 0x8duy; 0xb1uy; 0x02uy; 0x65uy; 0x58uy; 0xb4uy; 0x13uy; 0x4buy; 0x36uy; 0xf7uy; 0xccuy; 0xfeuy; 0x3duy; 0x0buy; 0x82uy; 0xe2uy; 0x12uy; 0x11uy; 0xbbuy; 0xe6uy; 0xb8uy; 0x3auy; 0x48uy; 0x71uy; 0xc7uy; 0x50uy; 0x06uy; 0x16uy; 0x3auy; 0xe6uy; 0x7cuy; 0x05uy; 0xc7uy; 0xc8uy; 0x4duy; 0x2fuy; 0x08uy; 0x6auy; 0x17uy; 0x9auy; 0x95uy; 0x97uy; 0x50uy; 0x68uy; 0xdcuy; 0x28uy; 0x18uy; 0xc4uy; 0x61uy; 0x38uy; 0xb9uy; 0xe0uy; 0x3euy; 0x78uy; 0xdbuy; 0x29uy; 0xe0uy; 0x9fuy; 0x52uy; 0xdduy; 0xf8uy; 0x4fuy; 0x91uy; 0xc1uy; 0xd0uy; 0x33uy; 0xa1uy; 0x7auy; 0x8euy; 0x30uy; 0x13uy; 0x82uy; 0x07uy; 0x9fuy; 0xd3uy; 0x31uy; 0x0fuy; 0x23uy; 0xbeuy; 0x32uy; 0x5auy; 0x75uy; 0xcfuy; 0x96uy; 0xb2uy; 0xecuy; 0xb5uy; 0x32uy; 0xacuy; 0x21uy; 0xd1uy; 0x82uy; 0x33uy; 0xd3uy; 0x15uy; 0x74uy; 0xbduy; 0x90uy; 0xf1uy; 0x2cuy; 0xe6uy; 0x5fuy; 0x8duy; 0xe3uy; 0x02uy; 0xe8uy; 0xe9uy; 0xc4uy; 0xcauy; 0x96uy; 0xebuy; 0x0euy; 0xbcuy; 0x91uy; 0xf4uy; 0xb9uy; 0xeauy; 0xd9uy; 0x1buy; 0x75uy; 0xbduy; 0xe1uy; 0xacuy; 0x2auy; 0x05uy; 0x37uy; 0x52uy; 0x9buy; 0x1buy; 0x3fuy; 0x5auy; 0xdcuy; 0x21uy; 0xc3uy; 0x98uy; 0xbbuy; 0xafuy; 0xa3uy; 0xf2uy; 0x00uy; 0xbfuy; 0x0duy; 0x30uy; 0x89uy; 0x05uy; 0xccuy; 0xa5uy; 0x76uy; 0xf5uy; 0x06uy; 0xf0uy; 0xc6uy; 0x54uy; 0x8auy; 0x5duy; 0xd4uy; 0x1euy; 0xc1uy; 0xf2uy; 0xceuy; 0xb0uy; 0x62uy; 0xc8uy; 0xfcuy; 0x59uy; 0x42uy; 0x9auy; 0x90uy; 0x60uy; 0x55uy; 0xfeuy; 0x88uy; 0xa5uy; 0x8buy; 0xb8uy; 0x33uy; 0x0cuy; 0x23uy; 0x24uy; 0x0duy; 0x15uy; 0x70uy; 0x37uy; 0x1euy; 0x3duy; 0xf6uy; 0xd2uy; 0xeauy; 0x92uy; 0x10uy; 0xb2uy; 0xc4uy; 0x51uy; 0xacuy; 0xf2uy; 0xacuy; 0xf3uy; 0x6buy; 0x6cuy; 0xaauy; 0xcfuy; 0x12uy; 0xc5uy; 0x6cuy; 0x90uy; 0x50uy; 0xb5uy; 0x0cuy; 0xfcuy; 0x1auy; 0x15uy; 0x52uy; 0xe9uy; 0x26uy; 0xc6uy; 0x52uy; 0xa4uy; 0xe7uy; 0x81uy; 0x69uy; 0xe1uy; 0xe7uy; 0x9euy; 0x30uy; 0x01uy; 0xecuy; 0x84uy; 0x89uy; 0xb2uy; 0x0duy; 0x66uy; 0xdduy; 0xceuy; 0x28uy; 0x5cuy; 0xecuy; 0x98uy; 0x46uy; 0x68uy; 0x21uy; 0x9fuy; 0x88uy; 0x3fuy; 0x1fuy; 0x42uy; 0x77uy; 0xceuy; 0xd0uy; 0x61uy; 0xd4uy; 0x20uy; 0xa7uy; 0xffuy; 0x53uy; 0xaduy; 0x37uy; 0xd0uy; 0x17uy; 0x35uy; 0xc9uy; 0xfcuy; 0xbauy; 0x0auy; 0x78uy; 0x3fuy; 0xf2uy; 0xccuy; 0x86uy; 0x89uy; 0xe8uy; 0x4buy; 0x3cuy; 0x48uy; 0x33uy; 0x09uy; 0x7fuy; 0xc6uy; 0xc0uy; 0xdduy; 0xb8uy; 0xfduy; 0x7auy; 0x66uy; 0x66uy; 0x65uy; 0xebuy; 0x47uy; 0xa7uy; 0x04uy; 0x28uy; 0xa3uy; 0x19uy; 0x8euy; 0xa9uy; 0xb1uy; 0x13uy; 0x67uy; 0x62uy; 0x70uy; 0xcfuy; 0xd6uy; ] in
  assert_norm (List.Tot.length l = 2027);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let output11_len: (x:UInt32.t { UInt32.v x = B.length output11 }) =
  2027ul

noeq
type vector = | Vector:
  output: B.buffer UInt8.t { B.recallable output } ->
  output_len: UInt32.t { B.length output = UInt32.v output_len } ->
  input: B.buffer UInt8.t { B.recallable input } ->
  input_len: UInt32.t { B.length input = UInt32.v input_len } ->
  aad: B.buffer UInt8.t { B.recallable aad /\ B.disjoint input aad } ->
  aad_len: UInt32.t { B.length aad = UInt32.v aad_len } ->
  nonce: B.buffer UInt8.t { B.recallable nonce } ->
  nonce_len: UInt32.t { B.length nonce = UInt32.v nonce_len } ->
  key: B.buffer UInt8.t { B.recallable key } ->
  key_len: UInt32.t { B.length key = UInt32.v key_len } ->
  vector

let vectors: (b: B.buffer vector { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 
    Vector output0 output0_len input0 input0_len aad0 aad0_len nonce0 nonce0_len key0 key0_len ;
    Vector output1 output1_len input1 input1_len aad1 aad1_len nonce1 nonce1_len key1 key1_len ;
    Vector output2 output2_len input2 input2_len aad2 aad2_len nonce2 nonce2_len key2 key2_len ;
    Vector output3 output3_len input3 input3_len aad3 aad3_len nonce3 nonce3_len key3 key3_len ;
    Vector output4 output4_len input4 input4_len aad4 aad4_len nonce4 nonce4_len key4 key4_len ;
    Vector output5 output5_len input5 input5_len aad5 aad5_len nonce5 nonce5_len key5 key5_len ;
    Vector output6 output6_len input6 input6_len aad6 aad6_len nonce6 nonce6_len key6 key6_len ;
    Vector output7 output7_len input7 input7_len aad7 aad7_len nonce7 nonce7_len key7 key7_len ;
    Vector output8 output8_len input8 input8_len aad8 aad8_len nonce8 nonce8_len key8 key8_len ;
    Vector output9 output9_len input9 input9_len aad9 aad9_len nonce9 nonce9_len key9 key9_len ;
    Vector output10 output10_len input10 input10_len aad10 aad10_len nonce10 nonce10_len key10 key10_len ;
    Vector output11 output11_len input11 input11_len aad11 aad11_len nonce11 nonce11_len key11 key11_len ;
  ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

let vectors_len: (x:UInt32.t { UInt32.v x = B.length vectors }) =
  12ul
