//::///////////////////////////////////////////////////////////////////////////
//::
//:: This file was generated by the NWTREASURE program.
//::
//:: Elements Copyright (c) 2001-2002 Bioware Corp.
//::
//::///////////////////////////////////////////////////////////////////////////

//
// Globals used to pass arguments around (reduces compiled script size)
//

int g_nM;
int g_nS;
object g_oA;
object g_oT;
int g_n;

//
// The following are only used by the respawn system
//

location g_loc;
string g_sProfile;
float g_fDelay;
int g_nSingleShot;
int g_nSomethingSpawned;

//
// Level range definitions
//

int RANGE_1_MIN = 0;
int RANGE_1_MAX = 5;
int RANGE_2_MIN = 6;
int RANGE_2_MAX = 8;
int RANGE_3_MIN = 9;
int RANGE_3_MAX = 10;
int RANGE_4_MIN = 11;
int RANGE_4_MAX = 13;
int RANGE_5_MIN = 14;
int RANGE_5_MAX = 16;
int RANGE_6_MIN = 17;
int RANGE_6_MAX = 100;

//
// Forward reference routines
//

void dbSpeak (string s);
int GetDefaultRespawnTime (); //Only used for SW style

//
// Get the level range from the hit dice
//

int GetLevelRange (int nHD)
{
    if (nHD <= RANGE_3_MAX)
    {
        if (nHD <= RANGE_1_MAX)
            return 1;
        if (nHD <= RANGE_2_MAX)
            return 2;
        return 3;
    }
    else
    {
        if (nHD >= RANGE_6_MIN)
            return 6;
        if (nHD <= RANGE_5_MIN)
            return 5;
        return 4;
    }
}

//
// Validate the objects
//

int InitializeGenerateTreasure (object oA, object oT)
{
    dbSpeak ("*********************NEW TREASURE*************************");
    if (GetIsObjectValid (oA) == FALSE)
    {
        dbSpeak ("Aborted.  Attacker or last opener isn't valid.");
        return 0;
    }
    
    dbSpeak ("For: " + GetName (oA));
    
    if (oT == OBJECT_INVALID)
    {
        oT = oA;
    }
    g_oA = oA;
    g_oT = oT;
    return 1;
}

//
// Create an item on the object
//

void MyCreateItemOnObjectInt (string sItemTemplate, int nStackSize, int nStackRange)
{

    //
    // Sanity check
    //
    
    if (sItemTemplate == "")
    {
        PrintString ("blank item passed into MyCreateItemOnObject.");
    }
    
    //
    // Debug string
    //
    
    dbSpeak (sItemTemplate);

    //
    // If a stack range was supplied, then add a random amount
    //
    
    if (nStackRange >= 2)
        nStackSize += Random (nStackRange);
    
    //
    // Create the item
    //
        
    object oItem = CreateItemOnObject(sItemTemplate, g_oT, nStackSize);
    if (GetIsObjectValid(oItem) == FALSE && sItemTemplate != "NW_IT_GOLD001") // gold :)
    {

        // * check to see if item is there in a stack, if not give warning
        if (GetIsObjectValid(GetItemPossessedBy(g_oT, GetStringUpperCase(sItemTemplate))) == FALSE &&
            GetIsObjectValid(GetItemPossessedBy(g_oT, GetStringLowerCase(sItemTemplate))) == FALSE)
        {
            PrintString("**DESIGN***");
            PrintString("******" + sItemTemplate + " is an invalid item template.");
            PrintString("*******");
        }
    }
}

//
// No suffixing
//

void MyCreateItemOnObjectA0_P0 (string sItemTemplate)
{
    MyCreateItemOnObjectInt (sItemTemplate, 1, 1);
}

void MyCreateItemOnObjectA1_P0 (string sItemTemplate, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate, nStackSize, 1);
}

void MyCreateItemOnObjectA2_P0 (string sItemTemplate, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate, nStackSize, nStackRange);
}

//
// 1 digit suffixing
//

void MyCreateItemOnObjectA0_P1 (string sItemTemplate, int nIndex)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight (IntToString (nIndex), 1), 1, 1);
}

void MyCreateItemOnObjectA1_P1 (string sItemTemplate, int nIndex, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight (IntToString (nIndex), 1), nStackSize, 1);
}

void MyCreateItemOnObjectA2_P1 (string sItemTemplate, int nIndex, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight (IntToString (nIndex), 1), nStackSize, nStackRange);
}

//
// 2 digit suffixing
//

void MyCreateItemOnObjectA0_P2 (string sItemTemplate, int nIndex)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0" + IntToString (nIndex), 2), 1, 1);
}

void MyCreateItemOnObjectA1_P2 (string sItemTemplate, int nIndex, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0" + IntToString (nIndex), 2), nStackSize, 1);
}

void MyCreateItemOnObjectA2_P2 (string sItemTemplate, int nIndex, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0" + IntToString (nIndex), 2), nStackSize, nStackRange);
}

//
// 3 digit suffixing
//

void MyCreateItemOnObjectA0_P3 (string sItemTemplate, int nIndex)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("00" + IntToString (nIndex), 3), 1, 1);
}

void MyCreateItemOnObjectA1_P3 (string sItemTemplate, int nIndex, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("00" + IntToString (nIndex), 3), nStackSize, 1);
}

void MyCreateItemOnObjectA2_P3 (string sItemTemplate, int nIndex, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("00" + IntToString (nIndex), 3), nStackSize, nStackRange);
}

//
// 4 digit suffixing
//

void MyCreateItemOnObjectA0_P4 (string sItemTemplate, int nIndex)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("000" + IntToString (nIndex), 4), 1, 1);
}

void MyCreateItemOnObjectA1_P4 (string sItemTemplate, int nIndex, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("000" + IntToString (nIndex), 4), nStackSize, 1);
}

void MyCreateItemOnObjectA2_P4 (string sItemTemplate, int nIndex, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("000" + IntToString (nIndex), 4), nStackSize, nStackRange);
}

//
// 5 digit suffixing
//

void MyCreateItemOnObjectA0_P5 (string sItemTemplate, int nIndex)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0000" + IntToString (nIndex), 5), 1, 1);
}

void MyCreateItemOnObjectA1_P5 (string sItemTemplate, int nIndex, int nStackSize)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0000" + IntToString (nIndex), 5), nStackSize, 1);
}

void MyCreateItemOnObjectA2_P5 (string sItemTemplate, int nIndex, int nStackSize, int nStackRange)
{
    MyCreateItemOnObjectInt (sItemTemplate + GetStringRight ("0000" + IntToString (nIndex), 5), nStackSize, nStackRange);
}

//
// Create gold
//

void MyCreateGold (int nCount, int nDie, float fMultiplier)
{
    int nGold;
    switch (nDie)
    {
        case   2: nGold = d2 (nCount); break;
        case   3: nGold = d3 (nCount); break;
        case   4: nGold = d4 (nCount); break;
        case   6: nGold = d6 (nCount); break;
        case   8: nGold = d8 (nCount); break;
        case  10: nGold = d10 (nCount); break;
        case  12: nGold = d12 (nCount); break;
        case  20: nGold = d20 (nCount); break;
        case 100: nGold = d100 (nCount); break;
        default:
            nGold = 0;
            while (nCount > 0)
            {
                nCount--;
                nGold += Random (nDie) + 1;
            }
            break;
    }
    float fGold = IntToFloat (nGold) * fMultiplier;
    nGold = FloatToInt (fGold);
    if (nGold < 1)
        nGold = 1;
    MyCreateItemOnObjectInt ("NW_IT_GOLD001", nGold, 1);
}

//
// Random Class to Use
//

int MyRandomClassToUse (object oCharacter)
{
    int nTotal = GetHitDice (oCharacter);
    if (nTotal < 1)
        return CLASS_TYPE_INVALID;
        
    int nState1 = GetLevelByPosition (1, oCharacter);
    int nState2 = GetLevelByPosition (2, oCharacter);

    int nUseClass = Random (nTotal);
    if (nUseClass < nState1)
        return GetClassByPosition (1, oCharacter);
    else 
    if (nUseClass < nState1 + nState2)
        return GetClassByPosition (2, oCharacter);
    else
        return GetClassByPosition (3, oCharacter);
}

//::///////////////////////////////////////////////////////////////////////////
//:: 
//:: **** BEGIN GENERATED CODE ****
//::
//::///////////////////////////////////////////////////////////////////////////

