#ifndef ETS_NONEOBJECT_H
#define ETS_NONEOBJECT_H

//-----------------------------------------------------------------------------
// 
// @doc
//
// @module	NoneObject.h - None object |
//
// This module contains the definition of the none object.
//
// Copyright (c) 2002-2003 - Edward T. Smith
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met:
// 
// 1. Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
// 2. Neither the name of Edward T. Smith nor the names of its contributors 
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// @end
//
// $History: CnfMainWnd.h $
//      
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Required include files
//
//-----------------------------------------------------------------------------

#include "TableItemObject.h"

//-----------------------------------------------------------------------------
//
// Forward definitions
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Class definition
//
//-----------------------------------------------------------------------------

class CNoneObject : public CTableItemObject
{
public:
	enum Element
	{
		Unknown			= 0,
		None			= 1,
		Chance			= 2,
	};

// @access Constructors and destructors
public:

	// @cmember General constructor
	
	CNoneObject ();

	// @cmember General destructor

	virtual ~CNoneObject ();

// @access Public virtual methods
public:

	// @cmember Get the image

	virtual Object_Image GetImage ();

	// @cmember Write the routine body

	virtual void WriteRoutineBody (CMainWnd *pMainWnd, FILE *fp, bool fDebug)
	{
		return;
	}

	// @cmember Get the object type

	virtual Object_Type GetObjectType () const
	{
		return Object_Type_None;
	}

	// @cmember Compare two objects

	virtual bool Compare (const CObject *pRhs) const
	{
		return pRhs ->GetObjectType () == Object_Type_None;
	}

	// @cmember Can this object be edited

	virtual bool CanEdit () const
	{
		return true;
	}

	// @cmember Write an XML file

	virtual void WriteXML (FILE *fp)
	{
		fprintf (fp, _T ("  <None>\r\n"));
		fprintf (fp, _T ("   <Chance>%d</Chance>\r\n"), m_nChance);  
		fprintf (fp, _T ("  </None>\r\n"));
		return;
	}

	// @cmember Start an XML element

	virtual void OnStartElement (CDataParser *pParser, 
		const XML_Char *pszName, const XML_Char **papszAttrs);

	// @cmember End an XML element

	virtual void OnEndElement (CDataParser *pParser, 
		const XML_Char *pszName);

// @access Protected methods
protected:

	// @cmember Get the XML element number

    Element GetElement (const XML_Char *pszName);

};

#endif // ETS_NONEOBJECT_H
