/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_pss_2048_sha256_0_vectors_h__
#define rsa_pss_2048_sha256_0_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> pub_key_1{
    0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00,
    0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xa2, 0xb4, 0x51,
    0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71, 0x51, 0x35, 0x50,
    0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17, 0x09, 0x4f, 0xa1,
    0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d, 0x3f, 0x7c, 0xaf,
    0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a, 0x17, 0x00, 0xf6,
    0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea, 0xc8, 0x84, 0x50,
    0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51, 0x2e, 0xd8, 0xa7,
    0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c, 0x15, 0xe8, 0x24,
    0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e, 0x25, 0x4a, 0x2f,
    0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17, 0xe1, 0xa0, 0x29,
    0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4, 0x90, 0xed, 0x81,
    0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61, 0x04, 0x28, 0xe0,
    0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0, 0x21, 0xd0, 0xfc,
    0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde, 0x4d, 0x1e, 0xce,
    0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4, 0xed, 0x54, 0x11,
    0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e, 0x09, 0xad, 0xa0,
    0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19, 0x69, 0x81, 0x6f,
    0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae, 0x79, 0xd4, 0x60,
    0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b, 0xc2, 0x2c, 0x4e,
    0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a, 0x62, 0x80, 0x7d,
    0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06, 0x6f, 0x45, 0x3d,
    0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83, 0xf7, 0x42, 0xb9,
    0xd5, 0x02, 0x03, 0x01, 0x00, 0x01};

const RsaPssTestVector kRsaPss2048Sha2560WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     1,
     0,
     {0x20, 0x08, 0x1f, 0x88, 0x94, 0xa1, 0x33, 0x0c, 0x4d, 0x50, 0x3f, 0x64,
      0x28, 0x80, 0xe3, 0xc3, 0x0e, 0x39, 0x8f, 0xc6, 0x23, 0x5c, 0x24, 0xf1,
      0xbe, 0x75, 0x2e, 0x2d, 0x49, 0xcd, 0x94, 0x93, 0xac, 0x0c, 0xf9, 0x99,
      0xe2, 0x75, 0xc4, 0xf8, 0x9f, 0xf0, 0x8f, 0x0d, 0x9b, 0xa4, 0xe2, 0x64,
      0xa3, 0x32, 0x52, 0x5a, 0x61, 0x6d, 0x33, 0x6b, 0xd9, 0xe8, 0x22, 0xf4,
      0x1a, 0xb3, 0xf4, 0xfa, 0xe2, 0xf4, 0x8e, 0xc6, 0x6c, 0x2e, 0x52, 0x64,
      0x2e, 0xd9, 0x3b, 0x7c, 0xb9, 0x44, 0x39, 0x6f, 0xba, 0xa7, 0x27, 0xcb,
      0xfd, 0xfc, 0x1f, 0x20, 0xaa, 0xce, 0x99, 0xa6, 0xf2, 0xa7, 0x44, 0x75,
      0xc3, 0x38, 0xf8, 0xd9, 0xf2, 0x2a, 0x38, 0xcb, 0x5b, 0xc5, 0x17, 0x52,
      0x07, 0x65, 0x03, 0xb3, 0xae, 0xf1, 0xe6, 0x5e, 0x5a, 0x8f, 0x85, 0x83,
      0xd9, 0xae, 0x73, 0x78, 0xde, 0xd0, 0x38, 0xcf, 0x51, 0x68, 0x98, 0xad,
      0x06, 0xbe, 0xb9, 0x0a, 0x42, 0xb8, 0x57, 0x64, 0x52, 0x6f, 0xce, 0xa4,
      0x4f, 0x74, 0x25, 0x8f, 0xa4, 0xef, 0xb1, 0xda, 0x25, 0x3d, 0x33, 0x7f,
      0x65, 0x61, 0x91, 0x81, 0xce, 0xb8, 0x32, 0xdf, 0xe2, 0x85, 0xce, 0x78,
      0xae, 0x6b, 0x15, 0xf2, 0x04, 0xe2, 0x3b, 0xab, 0x27, 0x4e, 0x87, 0x44,
      0x5d, 0x9f, 0x5d, 0xf9, 0x7f, 0x41, 0xdc, 0x8e, 0x3a, 0x97, 0x73, 0x6b,
      0x62, 0x59, 0x1d, 0x07, 0x57, 0x44, 0xb2, 0x55, 0x2f, 0x90, 0xbc, 0xf1,
      0xb1, 0x39, 0x3e, 0x1e, 0x76, 0x27, 0xef, 0x1f, 0x98, 0x5f, 0x2b, 0xba,
      0xbd, 0x52, 0xe4, 0x3a, 0x35, 0xd0, 0xdd, 0xf4, 0xc6, 0x71, 0x26, 0xe3,
      0x91, 0xf9, 0x22, 0xef, 0x7b, 0x1b, 0xb1, 0x91, 0x1c, 0xd6, 0xe1, 0xb3,
      0x03, 0xcb, 0x29, 0x10, 0xdd, 0x70, 0x67, 0x2b, 0xbf, 0xb6, 0x2e, 0xa4,
      0xea, 0xad, 0x72, 0x5c},
     pub_key_1,
     {},
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     2,
     0,
     {0x4b, 0xf1, 0x6f, 0x09, 0x87, 0x01, 0xd3, 0x40, 0xc4, 0x38, 0x36, 0x8e,
      0x65, 0x8e, 0xd8, 0x90, 0x4d, 0x3a, 0x21, 0xf7, 0x71, 0x4c, 0x02, 0x44,
      0x0d, 0x74, 0x76, 0xea, 0xd1, 0x32, 0x76, 0x6b, 0x3d, 0x57, 0x8b, 0x32,
      0x5a, 0xe7, 0x52, 0xf9, 0x06, 0x87, 0x3a, 0xf1, 0xb7, 0x95, 0x58, 0x5a,
      0x2a, 0x0d, 0x0e, 0x67, 0x88, 0xfe, 0x90, 0x33, 0x21, 0xb2, 0x08, 0x0b,
      0xd0, 0xdf, 0xb9, 0xde, 0x42, 0xc3, 0xbe, 0x41, 0xae, 0xff, 0x37, 0xe3,
      0x2d, 0xef, 0xdc, 0x0a, 0x75, 0xf1, 0x2a, 0xdb, 0x5b, 0x9d, 0xe4, 0xd0,
      0x67, 0xa9, 0x20, 0xa7, 0x20, 0xcb, 0x16, 0xcf, 0xaf, 0x56, 0xd7, 0xc0,
      0x9d, 0x8e, 0xf3, 0x84, 0xa8, 0xaa, 0x10, 0x65, 0x45, 0x22, 0x9b, 0x54,
      0x0c, 0x52, 0xb4, 0x9e, 0xcc, 0x9d, 0x6d, 0x14, 0xea, 0x70, 0x48, 0x06,
      0x42, 0xb9, 0xcd, 0x03, 0x30, 0xef, 0xc0, 0x05, 0x50, 0x2e, 0x4c, 0x38,
      0xb9, 0x6a, 0x36, 0x45, 0x64, 0x47, 0xce, 0x21, 0x33, 0xdf, 0x78, 0x85,
      0x43, 0x07, 0x01, 0x0e, 0xc2, 0x21, 0x30, 0x5d, 0xc9, 0x05, 0x70, 0x25,
      0x23, 0x21, 0xe0, 0x6c, 0x1b, 0xb0, 0x1d, 0x75, 0x10, 0x0e, 0x85, 0xe6,
      0x83, 0x26, 0xfe, 0x92, 0x48, 0x8c, 0x0c, 0x5e, 0x58, 0x52, 0x4b, 0x10,
      0xf8, 0xec, 0x74, 0x58, 0xd8, 0x87, 0xce, 0xc2, 0x54, 0xd3, 0x9b, 0x0b,
      0xef, 0x92, 0x1b, 0xa3, 0x1f, 0xd5, 0xa1, 0x17, 0x97, 0x7f, 0x19, 0x45,
      0xfc, 0x04, 0x83, 0x77, 0x27, 0x45, 0x69, 0x49, 0xff, 0xdc, 0x98, 0x86,
      0xf2, 0x10, 0x71, 0x18, 0x6b, 0xf3, 0x2d, 0xfb, 0xd9, 0xc3, 0xcd, 0x6a,
      0x2a, 0x00, 0xa1, 0xcd, 0xd5, 0xfc, 0x3c, 0x22, 0xf4, 0xbb, 0xaa, 0xb9,
      0x2a, 0xa8, 0x51, 0x16, 0x71, 0x1f, 0x1c, 0x53, 0x75, 0x4b, 0xdd, 0x2b,
      0xc3, 0x84, 0xf2, 0xa8},
     pub_key_1,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     3,
     0,
     {0x2b, 0x31, 0x55, 0xb1, 0x49, 0x71, 0xf7, 0x9c, 0x9e, 0x32, 0x94, 0x72,
      0x3c, 0x7e, 0x41, 0xde, 0xd4, 0x1a, 0xf7, 0x09, 0xf6, 0xed, 0xb2, 0xc1,
      0x9f, 0x35, 0x26, 0x58, 0x4a, 0xaa, 0x1e, 0xf2, 0xde, 0x2e, 0x7a, 0x8d,
      0xca, 0xf5, 0xd7, 0xc3, 0x23, 0x9f, 0x60, 0x4c, 0x42, 0x16, 0x56, 0xdc,
      0x58, 0xe8, 0xb0, 0x85, 0x2f, 0x7a, 0x65, 0xcd, 0x55, 0x77, 0x24, 0xa9,
      0xb2, 0xa1, 0x7c, 0xac, 0x38, 0xd8, 0x02, 0x0e, 0x93, 0x9b, 0xfe, 0xfe,
      0xc5, 0xdc, 0xe0, 0xd8, 0x99, 0x3e, 0x75, 0x61, 0x5b, 0x97, 0x49, 0x44,
      0xe4, 0xc4, 0xa8, 0x11, 0xe4, 0x0d, 0xb6, 0x3f, 0x13, 0xd2, 0xb6, 0x26,
      0xbf, 0x26, 0x25, 0x7a, 0x70, 0x6a, 0x7b, 0xed, 0xc8, 0x63, 0xd0, 0x10,
      0x0b, 0x67, 0x6a, 0xb7, 0x0d, 0x4a, 0x4f, 0x6e, 0xaf, 0x46, 0x92, 0xe0,
      0xb6, 0x9e, 0xe4, 0x42, 0x6c, 0xfe, 0x7c, 0xfc, 0x3e, 0x92, 0xd9, 0x3b,
      0xb8, 0x04, 0x56, 0x98, 0x83, 0xcf, 0x31, 0xfb, 0x28, 0x2e, 0xfa, 0x5a,
      0x81, 0xce, 0x9f, 0x6d, 0x9f, 0x0e, 0xd7, 0x92, 0x51, 0xef, 0x2a, 0x0b,
      0x59, 0x6f, 0x80, 0xe0, 0xeb, 0x96, 0xed, 0xe6, 0x7e, 0x30, 0x45, 0x7a,
      0x07, 0x65, 0x5d, 0x77, 0x79, 0x28, 0xb8, 0x98, 0xed, 0x16, 0x79, 0x04,
      0x66, 0x73, 0xe4, 0x89, 0xd9, 0xc6, 0x30, 0x5d, 0xee, 0x05, 0xab, 0xfd,
      0xeb, 0xa7, 0x35, 0x70, 0x99, 0xf9, 0xcf, 0xfd, 0x00, 0x73, 0x51, 0x65,
      0xdd, 0xc3, 0x9a, 0xa7, 0x35, 0x5b, 0x10, 0xa8, 0xb8, 0x61, 0x2d, 0xfa,
      0x2f, 0x83, 0x6f, 0xb9, 0xf5, 0xf8, 0x9f, 0x14, 0x07, 0x36, 0x5d, 0x6b,
      0x39, 0xa3, 0x9e, 0x89, 0xc6, 0x64, 0x7f, 0xf9, 0xda, 0x5f, 0xc6, 0xf9,
      0x60, 0x30, 0x66, 0x86, 0xa8, 0xed, 0x8e, 0x2c, 0xe1, 0x2c, 0xc7, 0xfd,
      0x98, 0x70, 0xd5, 0x76},
     pub_key_1,
     {0x54, 0x65, 0x73, 0x74},
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     4,
     0,
     {0x5e, 0x91, 0xb5, 0xdc, 0xbf, 0x02, 0xd6, 0xf1, 0x96, 0x21, 0xd4, 0x1a,
      0x83, 0xdc, 0x8f, 0x15, 0xea, 0x83, 0xc0, 0xed, 0xb8, 0x37, 0x65, 0xef,
      0x02, 0x9b, 0x0a, 0xca, 0xc2, 0xe1, 0xec, 0x89, 0x18, 0xb1, 0xd2, 0xaf,
      0xe1, 0xfa, 0xdf, 0x11, 0xc4, 0x8d, 0x27, 0x59, 0x4c, 0xb9, 0xc0, 0x1f,
      0xed, 0x79, 0xd9, 0x0e, 0x5d, 0x5a, 0x80, 0x85, 0xc4, 0x38, 0x45, 0x01,
      0x11, 0xaa, 0x7d, 0x9f, 0xa3, 0x9c, 0x23, 0x45, 0xb1, 0x4f, 0xc3, 0xc2,
      0xcb, 0x34, 0x12, 0x8f, 0x86, 0xdb, 0x5e, 0xb0, 0x0b, 0xdf, 0x8d, 0xfe,
      0x38, 0xd6, 0x1f, 0x29, 0xa4, 0x1f, 0xe3, 0x13, 0x42, 0xe7, 0xaa, 0xef,
      0xcb, 0x4b, 0x12, 0x2e, 0xb5, 0xd6, 0x3c, 0x2f, 0x5c, 0x26, 0x3c, 0x8d,
      0xf8, 0x45, 0x0e, 0x94, 0x28, 0xff, 0xef, 0x97, 0x4d, 0x53, 0x58, 0x18,
      0xd5, 0x1d, 0xc0, 0x3a, 0x7d, 0x60, 0xc8, 0xb2, 0xd1, 0x6c, 0x99, 0x9a,
      0xe4, 0x6d, 0x73, 0xab, 0x40, 0x51, 0x5f, 0xe6, 0x01, 0xd9, 0xb8, 0x9b,
      0x1d, 0x09, 0xc6, 0xd6, 0x0c, 0xd5, 0x16, 0x39, 0xa9, 0x7c, 0x1d, 0x21,
      0x1e, 0x09, 0x76, 0x09, 0xba, 0x5e, 0x8c, 0x31, 0x9c, 0x6f, 0xbd, 0x21,
      0xb3, 0x4a, 0x63, 0x4e, 0xc8, 0xfb, 0x89, 0x71, 0xc5, 0xaa, 0xe2, 0x1c,
      0x70, 0xb8, 0x47, 0xa4, 0x53, 0x9c, 0xc1, 0x0d, 0xc3, 0x14, 0xdd, 0xd8,
      0xa9, 0x62, 0x9e, 0x8a, 0x0e, 0x51, 0xc6, 0x6c, 0x0c, 0xb6, 0x1f, 0xd1,
      0xf7, 0x22, 0x8c, 0x01, 0xc6, 0x76, 0x91, 0x90, 0xab, 0xe9, 0xba, 0xc9,
      0xa3, 0x89, 0x78, 0x00, 0x05, 0x00, 0x14, 0x35, 0x85, 0x94, 0xe0, 0xfb,
      0x20, 0xdb, 0xb4, 0x58, 0xb1, 0x2a, 0xa1, 0x34, 0x68, 0x26, 0xcc, 0x9f,
      0x7e, 0x9c, 0x53, 0x52, 0xb0, 0x73, 0xd6, 0x28, 0x53, 0xda, 0xfe, 0x77,
      0xc8, 0x48, 0xcb, 0x1f},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     5,
     0,
     {0x50, 0x1c, 0x81, 0x19, 0xa0, 0xf8, 0xaa, 0x21, 0x39, 0xef, 0x5e, 0x05,
      0xad, 0xc6, 0x53, 0x84, 0xfa, 0x38, 0x9b, 0x90, 0x23, 0x53, 0x21, 0x71,
      0xd5, 0x14, 0x65, 0x1f, 0xf4, 0x86, 0x77, 0xaa, 0xd5, 0x46, 0x32, 0x6a,
      0x2e, 0x3c, 0x02, 0xb3, 0x9e, 0xd8, 0x4e, 0x5b, 0x7e, 0x46, 0x30, 0x60,
      0x4f, 0x29, 0x79, 0xc1, 0xfd, 0x7b, 0xf3, 0x7d, 0xa8, 0xe0, 0xce, 0xdc,
      0xae, 0xcf, 0xbe, 0xa6, 0xf9, 0xc7, 0x15, 0x14, 0x1a, 0x1d, 0x05, 0x25,
      0x29, 0xd0, 0xd0, 0xfc, 0xd7, 0x1e, 0xb7, 0x08, 0x67, 0xe2, 0x70, 0x43,
      0x77, 0x80, 0x1a, 0x0e, 0xc7, 0x21, 0xfc, 0x59, 0xfc, 0xa9, 0xd8, 0xb1,
      0xb0, 0x8c, 0xd9, 0xae, 0x3a, 0xb0, 0x94, 0xf5, 0xbb, 0xe2, 0xfa, 0xaf,
      0x31, 0x71, 0xdc, 0xf1, 0x71, 0x2c, 0x53, 0x4b, 0xbc, 0x7e, 0xa8, 0x02,
      0xa2, 0xa7, 0x2d, 0x8c, 0xeb, 0xef, 0xee, 0xff, 0x15, 0x30, 0xe4, 0x08,
      0x1b, 0x85, 0xa4, 0x2a, 0xe3, 0x8f, 0x63, 0x0f, 0x38, 0xc1, 0x12, 0x11,
      0x99, 0xf2, 0x15, 0x6e, 0x26, 0x7c, 0xe2, 0x46, 0x7f, 0x9b, 0x48, 0x53,
      0xdb, 0xd2, 0x9d, 0xd9, 0x99, 0xae, 0xbf, 0xc4, 0x02, 0xf2, 0xa0, 0xc3,
      0x3b, 0x8c, 0x1b, 0x80, 0x22, 0x94, 0x1e, 0x75, 0x4b, 0x7a, 0x18, 0x7d,
      0xf4, 0xc5, 0x96, 0x33, 0xdc, 0x6e, 0x76, 0xcb, 0x32, 0x00, 0xe3, 0x4a,
      0xcf, 0xde, 0x53, 0xa3, 0x86, 0x64, 0x78, 0x33, 0xdc, 0x2a, 0xcc, 0xf2,
      0x44, 0x72, 0x6f, 0xdb, 0xf4, 0x40, 0xcd, 0x32, 0x50, 0x31, 0x88, 0xa2,
      0x91, 0xe5, 0xb0, 0x67, 0x8a, 0xa7, 0x29, 0xb5, 0x39, 0xc1, 0xf5, 0xf9,
      0x7e, 0x7b, 0x78, 0x8c, 0x0c, 0x20, 0xb8, 0x8d, 0x90, 0xc9, 0x0a, 0x3b,
      0xf3, 0x33, 0x00, 0xd1, 0x81, 0xb9, 0xae, 0x79, 0x7c, 0xbc, 0x76, 0x04,
      0x9b, 0x43, 0xbe, 0x3d},
     pub_key_1,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     6,
     0,
     {0xa1, 0x7d, 0x67, 0x93, 0x73, 0x54, 0xc7, 0xfc, 0xba, 0x18, 0xdd, 0x53,
      0x83, 0xed, 0xbf, 0x2f, 0x08, 0x68, 0xcc, 0xbe, 0x0a, 0x31, 0x68, 0x76,
      0xfb, 0x1c, 0x4f, 0xb1, 0x4e, 0x7f, 0x4c, 0x04, 0x8e, 0xf5, 0xde, 0xd5,
      0xd0, 0x1d, 0x02, 0x55, 0x6c, 0xff, 0x0c, 0x8b, 0xf0, 0x81, 0xbd, 0x09,
      0xc4, 0x6c, 0xe4, 0xda, 0x15, 0x6e, 0x98, 0x10, 0xdf, 0x19, 0x5c, 0x5b,
      0x65, 0xdd, 0xbc, 0x30, 0x25, 0xb8, 0x4f, 0x91, 0x04, 0x70, 0x49, 0xf2,
      0x05, 0x34, 0x1c, 0xa8, 0xdc, 0x55, 0xe4, 0x40, 0xbf, 0x8d, 0x9a, 0x3e,
      0x98, 0xc2, 0x31, 0xbb, 0x74, 0xe7, 0x1b, 0xe0, 0x19, 0xcd, 0xf4, 0x51,
      0xe9, 0x62, 0xd8, 0xb7, 0xe8, 0xe6, 0xd7, 0x66, 0xd3, 0xbe, 0x43, 0x0c,
      0x75, 0x96, 0xff, 0xca, 0xfb, 0xb7, 0x85, 0xe5, 0xfe, 0x89, 0x87, 0xce,
      0x72, 0x1a, 0xe2, 0x28, 0x83, 0x2c, 0x8b, 0x4f, 0xe0, 0xb0, 0x07, 0x1b,
      0x0e, 0x5c, 0x65, 0x28, 0x56, 0xf7, 0x85, 0x69, 0x5f, 0x70, 0xcb, 0xb3,
      0xc6, 0x23, 0x94, 0xa8, 0x29, 0x1b, 0xa5, 0xf5, 0x87, 0xd4, 0xfd, 0x7b,
      0xb4, 0x48, 0x64, 0x9a, 0x72, 0x26, 0x14, 0x47, 0xaa, 0xe6, 0xa2, 0xb7,
      0x50, 0x82, 0x4d, 0x40, 0x0c, 0xa4, 0x02, 0x54, 0x3c, 0x8b, 0xdb, 0xbb,
      0x8e, 0x7c, 0x3b, 0x44, 0xcb, 0x70, 0x85, 0xa8, 0x33, 0x92, 0x34, 0x6a,
      0xbe, 0x99, 0x9e, 0xa2, 0xa5, 0xea, 0x15, 0xe9, 0xee, 0xf6, 0xbf, 0x08,
      0xa8, 0x80, 0x96, 0xee, 0x4e, 0x53, 0x23, 0x69, 0xf0, 0x05, 0x92, 0x85,
      0x29, 0x8b, 0x38, 0x7a, 0x42, 0x8e, 0x5e, 0x34, 0xed, 0x72, 0x96, 0xe0,
      0xb5, 0x3d, 0x34, 0xc5, 0xe2, 0x3f, 0x0d, 0x3c, 0x12, 0xe8, 0xa2, 0xd3,
      0x13, 0x26, 0x72, 0xa6, 0x55, 0xc7, 0x04, 0x8b, 0xdc, 0x0c, 0x69, 0xb3,
      0x6c, 0xae, 0x60, 0x2f},
     pub_key_1,
     {0x61},
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     7,
     0,
     {0x64, 0xc2, 0x6d, 0x43, 0xb0, 0x28, 0xf2, 0x84, 0xe9, 0x66, 0x7d, 0x59,
      0x51, 0xe7, 0x0c, 0x75, 0xe6, 0x11, 0xae, 0x2a, 0xb8, 0x76, 0xf6, 0x6c,
      0xcf, 0xaf, 0x09, 0xbd, 0x54, 0xa2, 0x6d, 0xd1, 0x79, 0x83, 0xd9, 0x93,
      0xbd, 0x4f, 0x52, 0x70, 0x53, 0x7f, 0x4c, 0x4b, 0x2e, 0x48, 0x69, 0x5e,
      0xda, 0x28, 0xc8, 0xc3, 0x65, 0x48, 0x6b, 0x5f, 0xc3, 0xbd, 0xe4, 0x04,
      0x9d, 0xcf, 0x6f, 0xd7, 0x22, 0xe6, 0x34, 0xfd, 0xf5, 0x57, 0x1d, 0x29,
      0xb1, 0xe1, 0x56, 0xa4, 0x8b, 0x0c, 0x70, 0x6d, 0x96, 0x15, 0x5d, 0x86,
      0xc2, 0x0d, 0xbb, 0xb1, 0xa4, 0x7c, 0x7e, 0x54, 0xef, 0xa1, 0x5b, 0x25,
      0xd7, 0x6f, 0x50, 0x2b, 0x30, 0x69, 0xe2, 0x51, 0x4f, 0x89, 0xd9, 0xbd,
      0xfd, 0xa9, 0xbc, 0xda, 0x02, 0x30, 0x1c, 0x58, 0xe2, 0x17, 0x3c, 0xf4,
      0xf3, 0xdd, 0x49, 0xd8, 0x41, 0x58, 0x02, 0xc1, 0x1a, 0xed, 0x78, 0xf0,
      0x31, 0xe8, 0xe2, 0xe5, 0x01, 0x97, 0x44, 0x3e, 0x5f, 0xe9, 0xab, 0x55,
      0xaf, 0xd8, 0xde, 0xeb, 0x7b, 0x5d, 0xb8, 0xba, 0x7a, 0x7b, 0x9f, 0xce,
      0x6b, 0x7d, 0x9e, 0xea, 0xb9, 0xef, 0x25, 0x03, 0x57, 0x42, 0xd0, 0x76,
      0x93, 0x5c, 0x05, 0x9d, 0x07, 0x6b, 0x47, 0x14, 0x12, 0x7d, 0x40, 0x8c,
      0x94, 0x28, 0xa9, 0x0c, 0xb9, 0x89, 0x1a, 0x15, 0x1e, 0xee, 0x8d, 0xe7,
      0xd0, 0xce, 0xa3, 0x2b, 0x0a, 0xd2, 0xd8, 0xca, 0x4a, 0xbe, 0xb0, 0x52,
      0x1b, 0x29, 0x6b, 0x5a, 0xc0, 0x8f, 0x7c, 0x53, 0xd5, 0xc8, 0x5e, 0x47,
      0xed, 0x82, 0x8e, 0x0c, 0x11, 0x46, 0x8d, 0x6c, 0xb5, 0x0b, 0xea, 0x89,
      0xe4, 0xb4, 0x55, 0x93, 0x63, 0x76, 0xbd, 0xe9, 0xf2, 0x2e, 0xb9, 0x8b,
      0x3e, 0x23, 0x95, 0xee, 0xdd, 0x05, 0xd1, 0xde, 0xf3, 0x8f, 0xd5, 0xe0,
      0x82, 0xad, 0xe3, 0xb0},
     pub_key_1,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     8,
     0,
     {0x08, 0xa9, 0x00, 0xc5, 0xc0, 0xcf, 0x38, 0x96, 0x3b, 0x8d, 0x47, 0x68,
      0x2c, 0xc7, 0xda, 0xe9, 0xd3, 0xf0, 0xa7, 0x8e, 0x57, 0x1e, 0xe5, 0xbc,
      0xe6, 0x58, 0x15, 0x42, 0x48, 0xb0, 0x08, 0x4a, 0xb9, 0x6a, 0x7a, 0xb0,
      0xca, 0x8c, 0x6a, 0xd8, 0xd6, 0xfc, 0x10, 0x50, 0x40, 0xc9, 0xde, 0x8f,
      0x8d, 0xf6, 0x1c, 0x1b, 0x6b, 0xe5, 0x9a, 0x5b, 0x89, 0x9d, 0xf5, 0x86,
      0x02, 0x6e, 0x4b, 0x3a, 0xc1, 0x53, 0x1a, 0xb0, 0x9b, 0x5f, 0xb5, 0x02,
      0x6c, 0xbd, 0x25, 0x2c, 0x6a, 0x54, 0x8f, 0xae, 0x9e, 0xe8, 0x81, 0xfa,
      0x38, 0x2d, 0x98, 0x49, 0x9f, 0xb8, 0x8c, 0x2b, 0x06, 0x1f, 0x56, 0x0e,
      0x1d, 0xaf, 0x98, 0x14, 0x57, 0x05, 0x05, 0x4f, 0xd0, 0xce, 0x66, 0xd8,
      0xfb, 0x2f, 0x64, 0xab, 0x16, 0x0f, 0x4b, 0xf1, 0xed, 0x1a, 0x54, 0xcf,
      0x69, 0x38, 0x2a, 0xfb, 0x75, 0xc7, 0x1c, 0xf4, 0xc3, 0x8b, 0xfc, 0x16,
      0x03, 0x65, 0x3a, 0xf3, 0x5a, 0x7a, 0xb1, 0xab, 0x72, 0x68, 0xcf, 0xbe,
      0xd8, 0x8b, 0xd4, 0xe7, 0x79, 0xa8, 0x81, 0x1a, 0xcc, 0x94, 0x7a, 0x21,
      0xb0, 0x59, 0xea, 0x43, 0xc1, 0x97, 0x86, 0xf3, 0x70, 0x07, 0x63, 0x60,
      0xf4, 0x62, 0x0a, 0x48, 0x6d, 0x6e, 0x05, 0x72, 0xe5, 0xc6, 0xc7, 0x96,
      0x60, 0x47, 0x36, 0xac, 0xc5, 0xb4, 0x1c, 0x6d, 0xa7, 0xab, 0x2a, 0x40,
      0x63, 0x0b, 0xb8, 0xbf, 0x57, 0x2a, 0xe9, 0x6c, 0x9b, 0xf2, 0x93, 0x58,
      0x00, 0x21, 0xd5, 0xa0, 0xb4, 0x2a, 0x19, 0x6c, 0x74, 0xb8, 0x0b, 0x55,
      0x22, 0x58, 0x39, 0x75, 0x63, 0x80, 0x30, 0x52, 0x03, 0xb2, 0xbf, 0xd7,
      0x52, 0x56, 0x18, 0xb4, 0x02, 0xd5, 0x28, 0x8d, 0xa2, 0x88, 0xbb, 0x3d,
      0x78, 0xde, 0xae, 0xb2, 0x6f, 0xdd, 0x43, 0x2b, 0x2a, 0xac, 0x74, 0x6c,
      0x4f, 0xea, 0x8b, 0x0f},
     pub_key_1,
     {0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     9,
     0,
     {0x29, 0xb1, 0xc6, 0x7e, 0x4b, 0xe6, 0x42, 0xcd, 0x69, 0xe7, 0xf3, 0x81,
      0x15, 0xdb, 0x51, 0xd9, 0x63, 0xa5, 0x42, 0x60, 0xa8, 0x77, 0x78, 0x1d,
      0xde, 0xba, 0x5f, 0xa6, 0xff, 0x2f, 0xc0, 0xda, 0x18, 0x2f, 0x89, 0x23,
      0xbb, 0x92, 0x57, 0xe9, 0x29, 0x89, 0x43, 0x83, 0x92, 0xf0, 0x47, 0x94,
      0x3f, 0x57, 0x69, 0xee, 0x05, 0x7c, 0x71, 0x62, 0xc7, 0x1c, 0xf2, 0xc0,
      0x14, 0x7e, 0xad, 0x67, 0x0a, 0xb9, 0xae, 0x2c, 0x1f, 0xda, 0xb6, 0x04,
      0x60, 0x1a, 0x2d, 0xba, 0x88, 0x48, 0x3b, 0x2d, 0x3b, 0x1d, 0xd5, 0x30,
      0xaa, 0xa1, 0x7f, 0x7a, 0x05, 0x6f, 0x1d, 0xee, 0x49, 0xe0, 0xb9, 0x67,
      0x98, 0x45, 0x06, 0xbd, 0x39, 0xf2, 0xdf, 0x29, 0xa0, 0x6d, 0x58, 0xf1,
      0x59, 0x46, 0x59, 0x73, 0xa0, 0xfc, 0xf1, 0xeb, 0x58, 0x90, 0x46, 0x48,
      0x63, 0xae, 0xe9, 0x2a, 0x4f, 0x39, 0x38, 0x74, 0x2c, 0x87, 0x61, 0x64,
      0xef, 0x95, 0xcf, 0x34, 0x75, 0x3e, 0x99, 0x26, 0xef, 0x87, 0x00, 0x4d,
      0x20, 0x7b, 0x9e, 0x49, 0x69, 0x22, 0xbd, 0x00, 0xdf, 0xba, 0xff, 0xd9,
      0xdd, 0xfa, 0x21, 0x6a, 0x4b, 0x7b, 0xff, 0xad, 0x0d, 0x96, 0x08, 0xe0,
      0xa2, 0xe8, 0xd2, 0x2e, 0x41, 0xa5, 0x14, 0x49, 0x46, 0x83, 0x83, 0x1e,
      0x25, 0xc2, 0x4f, 0x03, 0x2d, 0x1b, 0xfa, 0xc1, 0x9d, 0x19, 0x3c, 0x4b,
      0x34, 0x38, 0x15, 0x74, 0x7a, 0x25, 0x4f, 0x02, 0x63, 0x13, 0xa6, 0xb5,
      0x54, 0x08, 0x59, 0x21, 0xc6, 0xa8, 0xd0, 0xb3, 0x62, 0xa7, 0xe7, 0x5f,
      0x64, 0x19, 0x21, 0x5a, 0x5b, 0x9d, 0x4b, 0x7b, 0x87, 0x2c, 0xd9, 0x52,
      0xf8, 0x30, 0x42, 0x64, 0x62, 0xa5, 0x47, 0xa4, 0x75, 0xed, 0x36, 0x96,
      0xbb, 0x97, 0x72, 0x23, 0xc1, 0xfb, 0x5a, 0xef, 0xcc, 0xac, 0xee, 0xf9,
      0x96, 0x89, 0x78, 0x8f},
     pub_key_1,
     {0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31},
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     10,
     0,
     {0x12, 0xa1, 0xcb, 0x80, 0xd9, 0xca, 0x2b, 0x22, 0x9f, 0x85, 0xc7, 0xaa,
      0x17, 0x05, 0xab, 0xaa, 0x61, 0x52, 0xb3, 0xfe, 0x1c, 0x6d, 0xde, 0xad,
      0xde, 0x2d, 0xe5, 0x6f, 0x49, 0xcb, 0x5d, 0x51, 0x76, 0xc9, 0x1b, 0xf9,
      0xa1, 0x2a, 0x12, 0x37, 0x27, 0x53, 0xd0, 0xb6, 0x57, 0xfc, 0xed, 0x52,
      0xa8, 0xc6, 0xae, 0x88, 0xcf, 0x6e, 0x84, 0xa3, 0x58, 0xb9, 0x96, 0xfd,
      0x06, 0xed, 0x08, 0x46, 0xdd, 0x68, 0x5b, 0x80, 0x02, 0x32, 0x17, 0x7f,
      0x17, 0xd7, 0x2d, 0xa5, 0xe8, 0x17, 0xca, 0xba, 0x8e, 0xc9, 0xa1, 0xf0,
      0x8e, 0xc7, 0xe0, 0x15, 0xaa, 0x28, 0x21, 0xa1, 0xf9, 0x77, 0x7b, 0xa6,
      0xa7, 0xd0, 0x95, 0x04, 0x49, 0x25, 0x4e, 0x5b, 0xc5, 0xa0, 0xbc, 0x63,
      0xf7, 0xa6, 0xc7, 0x97, 0xfa, 0x5b, 0x2d, 0x30, 0xe8, 0x17, 0x04, 0x73,
      0x5f, 0x8d, 0xbb, 0xe1, 0xa6, 0xc7, 0xc8, 0xdb, 0x18, 0xc1, 0x42, 0xb0,
      0x86, 0x1f, 0x85, 0x25, 0xb6, 0x6e, 0x4c, 0x55, 0x09, 0x03, 0x77, 0xb0,
      0x83, 0x50, 0x00, 0x1b, 0x18, 0xcd, 0x27, 0xf6, 0xe1, 0xbe, 0x8d, 0x43,
      0xb9, 0x36, 0x88, 0x3f, 0x7e, 0x05, 0x70, 0x16, 0xb7, 0x8f, 0x6f, 0x81,
      0x0c, 0xfb, 0xc1, 0x9d, 0x39, 0x49, 0x09, 0x04, 0x08, 0x44, 0xc9, 0xcd,
      0xc9, 0xff, 0x5c, 0x8b, 0x37, 0x32, 0x7f, 0xec, 0xed, 0x82, 0x0f, 0x3d,
      0xab, 0xbc, 0x1f, 0x59, 0x7b, 0x2e, 0xd3, 0x53, 0xe7, 0xbb, 0xd3, 0xd3,
      0x15, 0xe9, 0xe0, 0x21, 0x24, 0xf9, 0x8b, 0x01, 0x4b, 0xe8, 0x27, 0xc6,
      0x35, 0xe1, 0x3f, 0x28, 0x4c, 0x1d, 0xd5, 0xf5, 0x45, 0x71, 0x29, 0xd2,
      0xef, 0x24, 0x9a, 0xd1, 0x26, 0x59, 0xcf, 0xca, 0x95, 0x64, 0x63, 0x14,
      0xab, 0xbb, 0xe0, 0x90, 0xe1, 0x2f, 0xf4, 0x48, 0x0a, 0x50, 0xe3, 0x93,
      0xa4, 0x7a, 0x19, 0xbe},
     pub_key_1,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 11
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     11,
     0,
     {0x7b, 0xed, 0x5b, 0xb4, 0x38, 0x26, 0x84, 0x10, 0x53, 0xd2, 0x3c, 0xb2,
      0xf5, 0x74, 0xc6, 0x87, 0xbe, 0x82, 0x7e, 0x99, 0x68, 0xb3, 0x7a, 0xf2,
      0x48, 0xdb, 0x45, 0x1e, 0xfc, 0xb8, 0x18, 0xd0, 0xbb, 0x89, 0x75, 0xdd,
      0xf7, 0x40, 0x74, 0x96, 0x60, 0x32, 0x81, 0xc5, 0x71, 0x9a, 0xab, 0x83,
      0xaf, 0xb4, 0x18, 0xf4, 0x96, 0xd8, 0xcf, 0x26, 0xe9, 0x1c, 0x56, 0x97,
      0x4e, 0x65, 0xb3, 0x82, 0xf9, 0x6a, 0x20, 0x69, 0x95, 0xdf, 0xf1, 0xb5,
      0x78, 0x39, 0xf7, 0x20, 0x8e, 0x33, 0x8e, 0x86, 0x35, 0x8c, 0xcc, 0xaa,
      0x30, 0xcf, 0xf9, 0x67, 0x7a, 0xc0, 0xa7, 0xaf, 0xa4, 0x8e, 0x8a, 0xe3,
      0xe3, 0x94, 0x2e, 0x36, 0xfa, 0x3f, 0xdf, 0xb4, 0x7d, 0xb4, 0x29, 0x50,
      0x27, 0xe0, 0xcc, 0x4e, 0x2b, 0x98, 0xef, 0x1d, 0xb4, 0x95, 0x19, 0xb3,
      0x16, 0xff, 0x4b, 0xfa, 0xac, 0x24, 0x63, 0x91, 0x69, 0x1c, 0x77, 0x05,
      0xac, 0xb8, 0x99, 0x23, 0xd3, 0x99, 0x81, 0x38, 0x82, 0x86, 0xc5, 0x96,
      0x9b, 0xc4, 0x28, 0x51, 0x78, 0x88, 0x72, 0x65, 0x90, 0x19, 0xa3, 0xbb,
      0x05, 0xa7, 0x2f, 0xe8, 0x15, 0xee, 0x17, 0xdd, 0x0b, 0xac, 0xe9, 0x2a,
      0x93, 0x46, 0x83, 0xe0, 0x19, 0x04, 0x96, 0x69, 0xef, 0x28, 0x56, 0x25,
      0xb0, 0xbd, 0xf9, 0x93, 0x5b, 0xef, 0xca, 0x3a, 0x0b, 0xf6, 0xb4, 0x15,
      0x4d, 0x65, 0xb6, 0x2a, 0x83, 0x59, 0x7a, 0xbf, 0xdb, 0x0e, 0xc3, 0x35,
      0xc2, 0xce, 0xbf, 0xa6, 0x27, 0x91, 0x8e, 0xe2, 0x8d, 0x64, 0xef, 0x0d,
      0xeb, 0xea, 0xb2, 0x7e, 0x9e, 0xfe, 0xdf, 0xcc, 0x55, 0x77, 0x89, 0xf4,
      0x4d, 0x1e, 0x57, 0x12, 0x7b, 0x06, 0x6a, 0x22, 0x1e, 0x11, 0xf4, 0xc0,
      0xb1, 0x46, 0x29, 0x3d, 0x78, 0xd7, 0x2a, 0x5f, 0x89, 0x9f, 0x95, 0x4b,
      0x5d, 0xd3, 0x7c, 0x1e},
     pub_key_1,
     {0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35},
     true},

    // Comment:
    // tcID: 12
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     12,
     0,
     {0x38, 0xb0, 0x9e, 0xb6, 0xac, 0xd2, 0xd2, 0xf0, 0xe0, 0x83, 0xf0, 0xbf,
      0x84, 0x52, 0x3a, 0x47, 0x5f, 0xb5, 0x51, 0x9e, 0xbc, 0xb8, 0xa5, 0xfc,
      0x20, 0x07, 0xce, 0xc2, 0xca, 0x6f, 0x01, 0xb1, 0x4e, 0x43, 0x32, 0xac,
      0xd9, 0x35, 0xb0, 0x70, 0x14, 0x0c, 0xb2, 0x41, 0xb4, 0x25, 0x5f, 0xa0,
      0x97, 0xdb, 0x27, 0x81, 0xb5, 0x72, 0x86, 0x6b, 0x55, 0xaa, 0xb5, 0x68,
      0x4d, 0x73, 0x18, 0x1b, 0x4c, 0x91, 0x1e, 0xc6, 0xe7, 0x2b, 0x3c, 0x26,
      0x7c, 0x09, 0x46, 0x97, 0x37, 0xea, 0x36, 0xeb, 0x2a, 0xeb, 0xa7, 0x43,
      0xc2, 0x9f, 0xc4, 0xff, 0x0c, 0x82, 0xb3, 0x00, 0x2e, 0xd8, 0xda, 0xea,
      0xc3, 0x13, 0xd2, 0xec, 0x4f, 0x7d, 0x9e, 0x70, 0x7e, 0xc3, 0x34, 0xf0,
      0x22, 0x88, 0x52, 0xea, 0xe8, 0xd5, 0x8c, 0x27, 0xe1, 0xfd, 0xd1, 0xdb,
      0xf8, 0xd1, 0x5b, 0x8a, 0x7b, 0x0f, 0x82, 0x4e, 0xb4, 0xf2, 0xc0, 0x19,
      0x19, 0x24, 0x74, 0x9e, 0x2a, 0xf4, 0xad, 0xc0, 0xa0, 0xed, 0x41, 0x97,
      0x8b, 0xbf, 0x39, 0x0e, 0x31, 0x86, 0x00, 0x68, 0xaa, 0x8d, 0xb5, 0xd5,
      0xc7, 0xc7, 0xe8, 0x6b, 0x0c, 0xbc, 0x92, 0x39, 0xfe, 0xa6, 0x5b, 0xf0,
      0xd9, 0xb0, 0xa4, 0xd7, 0xa7, 0x05, 0x8c, 0xe6, 0xe4, 0x23, 0x85, 0x8d,
      0x3a, 0x09, 0x56, 0xc3, 0xac, 0x3a, 0xf7, 0xf4, 0x08, 0xc7, 0x92, 0x6e,
      0xbf, 0x86, 0xd4, 0x7c, 0xd4, 0x9d, 0xe3, 0x64, 0xf9, 0x06, 0x71, 0xaf,
      0xb5, 0x2b, 0xd7, 0xd1, 0x7a, 0xad, 0x00, 0x83, 0x3e, 0xc7, 0x9e, 0x43,
      0x40, 0x1e, 0xa2, 0x43, 0x7d, 0x0e, 0xf7, 0xa8, 0x9a, 0xd3, 0x5d, 0xcf,
      0x88, 0x41, 0x21, 0xbf, 0x91, 0xac, 0x17, 0xdf, 0x17, 0x16, 0x3a, 0xe1,
      0x9f, 0x08, 0x43, 0x98, 0xca, 0x3a, 0xbe, 0xe4, 0x7d, 0xb7, 0xc1, 0x11,
      0xc8, 0x1b, 0xda, 0xd9},
     pub_key_1,
     {0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39},
     true},

    // Comment:
    // tcID: 13
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     13,
     0,
     {0x49, 0x52, 0x54, 0xa0, 0xe2, 0xeb, 0x9c, 0xa9, 0xf0, 0xfa, 0x28, 0x1c,
      0xc7, 0xee, 0x50, 0x31, 0xcc, 0xad, 0xd0, 0xff, 0x52, 0xa1, 0xc7, 0x7d,
      0xc7, 0xfd, 0x02, 0x7f, 0x54, 0x31, 0x92, 0x58, 0xdc, 0x0a, 0x4e, 0x4b,
      0xf9, 0x8d, 0x13, 0x71, 0x1a, 0x4d, 0x9a, 0xb0, 0xc1, 0xac, 0x8d, 0x67,
      0xf9, 0x8c, 0x04, 0x74, 0x7a, 0xe6, 0xb9, 0xef, 0x95, 0xe6, 0x7c, 0x86,
      0x71, 0xd7, 0xd9, 0xa2, 0xa2, 0xbc, 0x5e, 0x58, 0xb1, 0xb8, 0x63, 0x52,
      0x5b, 0xc1, 0x0c, 0x6f, 0xe6, 0x53, 0x88, 0x59, 0x0b, 0x96, 0xf2, 0x46,
      0xc5, 0x8d, 0x11, 0x8f, 0x03, 0xbc, 0x67, 0x3b, 0x87, 0x71, 0x5d, 0xb6,
      0x93, 0x85, 0x90, 0x7b, 0x5e, 0xd7, 0xad, 0x57, 0x6b, 0x45, 0x23, 0x61,
      0xac, 0x81, 0x64, 0xf9, 0xea, 0xdd, 0x25, 0x0e, 0xb4, 0x45, 0xd6, 0x97,
      0xce, 0x7c, 0x0b, 0xb4, 0x36, 0x0c, 0x65, 0x86, 0x8a, 0x8f, 0xe0, 0x61,
      0x01, 0xb5, 0x6f, 0x4f, 0x7c, 0xf8, 0x2a, 0x9b, 0xc7, 0x82, 0x54, 0xef,
      0xf9, 0x74, 0x36, 0x6f, 0x2c, 0xa2, 0xf7, 0xa1, 0x70, 0x96, 0xb0, 0x5b,
      0x9b, 0xae, 0x47, 0xee, 0x57, 0x2e, 0xb6, 0x0c, 0xce, 0xea, 0xf1, 0xe7,
      0xb4, 0x84, 0xe9, 0x0b, 0x5b, 0x0a, 0x8e, 0xe6, 0xf1, 0x51, 0x7d, 0x1e,
      0x69, 0x4d, 0x23, 0xa2, 0xf9, 0xd3, 0x3f, 0xf4, 0x7a, 0x3a, 0xcb, 0x7c,
      0x9e, 0x93, 0xa6, 0xfb, 0x9e, 0xd2, 0xe9, 0x94, 0x77, 0x3c, 0xaf, 0x5a,
      0x8e, 0xd3, 0x45, 0x35, 0x54, 0x80, 0x71, 0x24, 0xfc, 0x4a, 0x4a, 0x19,
      0xfa, 0xd8, 0x8c, 0x70, 0xd5, 0xd5, 0xd9, 0x09, 0x69, 0xe1, 0x9a, 0xcd,
      0x4c, 0x1f, 0x10, 0xb8, 0x76, 0x29, 0xdc, 0xf5, 0xde, 0x6a, 0x74, 0x41,
      0xf4, 0x7e, 0xa4, 0xcc, 0x4b, 0x84, 0xca, 0x6f, 0xf4, 0x3e, 0x09, 0x05,
      0xa7, 0x30, 0x83, 0xfa},
     pub_key_1,
     {0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 14
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     14,
     0,
     {0x7d, 0x0a, 0xee, 0x24, 0xec, 0x62, 0xcd, 0x2c, 0x62, 0x38, 0xe4, 0x9d,
      0xd5, 0x89, 0xdd, 0xcc, 0x80, 0x4b, 0x51, 0x22, 0xf5, 0x7c, 0xa8, 0xc2,
      0xd3, 0xf7, 0xdd, 0xcd, 0xf1, 0x50, 0x3c, 0x3e, 0xae, 0x8a, 0xe1, 0x92,
      0xa0, 0x05, 0x7f, 0xca, 0x6e, 0xbf, 0xb3, 0x23, 0x1c, 0xb9, 0xaa, 0xa3,
      0x80, 0xbf, 0x45, 0x09, 0xdf, 0x5c, 0x83, 0x20, 0x4c, 0xc6, 0x1b, 0x48,
      0x70, 0xe4, 0x23, 0x36, 0x16, 0xee, 0x70, 0x97, 0x50, 0x72, 0x22, 0xc2,
      0x20, 0x10, 0xc3, 0xf3, 0x4b, 0x6c, 0x75, 0xe4, 0xa3, 0x41, 0x92, 0x0d,
      0xce, 0x40, 0xe4, 0xcf, 0xb7, 0x22, 0x06, 0xf0, 0x0d, 0xad, 0x39, 0xcd,
      0x07, 0x86, 0x42, 0x75, 0x75, 0xca, 0xb1, 0x98, 0x32, 0xb6, 0x4c, 0xe9,
      0xdd, 0x45, 0xbf, 0x8c, 0x00, 0x23, 0xb5, 0xb0, 0x07, 0x54, 0x4c, 0x40,
      0x48, 0xeb, 0x06, 0xb0, 0xa7, 0x3e, 0x15, 0x83, 0xdb, 0x64, 0xb9, 0xae,
      0x70, 0xca, 0x88, 0xa7, 0xa1, 0x69, 0x95, 0x3c, 0xb2, 0x07, 0xac, 0xca,
      0x09, 0x98, 0x76, 0x84, 0x1c, 0x6f, 0x0a, 0xe9, 0xa4, 0xce, 0xcd, 0xee,
      0x90, 0x0d, 0x2e, 0xf1, 0xe5, 0x55, 0x9f, 0x8b, 0x49, 0x64, 0x67, 0x73,
      0x3e, 0x44, 0xbd, 0xc6, 0xce, 0x8f, 0x22, 0x2f, 0xce, 0x5e, 0x99, 0xae,
      0x3b, 0xf2, 0xee, 0x9f, 0x68, 0x21, 0xde, 0xe0, 0xf1, 0xa1, 0xfd, 0xb0,
      0x72, 0xe9, 0x24, 0x04, 0xe3, 0x25, 0xe0, 0x6f, 0x81, 0x3d, 0x70, 0xdf,
      0x65, 0x25, 0xe7, 0x6f, 0x0e, 0xa5, 0x93, 0x4e, 0x53, 0xca, 0x6a, 0xa1,
      0x21, 0x60, 0xf6, 0xa9, 0x2d, 0xd9, 0xd1, 0xf5, 0xa4, 0xa6, 0x1e, 0x47,
      0xf3, 0xf0, 0x1f, 0x29, 0x7f, 0x04, 0x70, 0xc3, 0x43, 0xdf, 0x41, 0x67,
      0x58, 0x8b, 0x81, 0xc5, 0x22, 0x39, 0x08, 0xb6, 0x8c, 0x4e, 0x23, 0x80,
      0xd9, 0x5f, 0xad, 0xb6},
     pub_key_1,
     {0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 15
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     15,
     0,
     {0x5d, 0x82, 0x21, 0x77, 0x79, 0x1f, 0xaa, 0x3b, 0xeb, 0x14, 0x93, 0xaf,
      0x76, 0x0b, 0x50, 0xf6, 0x2e, 0x78, 0xf1, 0x4b, 0x3e, 0xb2, 0x78, 0x67,
      0x9d, 0x59, 0xdb, 0xb8, 0xff, 0x0e, 0xca, 0x8b, 0x4f, 0x4f, 0x90, 0x12,
      0x4b, 0x83, 0x0c, 0x8d, 0x63, 0x5e, 0x90, 0xb8, 0x6d, 0xe9, 0x7d, 0x92,
      0x21, 0x2b, 0x1e, 0x42, 0xaa, 0xe5, 0x7c, 0xea, 0xd0, 0x65, 0x0e, 0x7e,
      0x92, 0x04, 0xd3, 0xd2, 0x04, 0xb4, 0x3d, 0x2e, 0x63, 0x76, 0x09, 0x2d,
      0x2b, 0x28, 0x0a, 0xcd, 0x18, 0x39, 0x82, 0x95, 0x65, 0x0d, 0xc9, 0x4f,
      0x74, 0xb7, 0xfa, 0x71, 0x98, 0xc0, 0x86, 0x88, 0x90, 0x07, 0x84, 0x22,
      0xe2, 0xce, 0x12, 0xd3, 0x75, 0x98, 0x6e, 0xf3, 0x87, 0xa8, 0x2b, 0x18,
      0x8a, 0x23, 0x17, 0x84, 0xc8, 0x6e, 0x85, 0xab, 0x0c, 0x63, 0x0f, 0x78,
      0x76, 0xc6, 0x52, 0xe4, 0xf4, 0xba, 0x9a, 0x4d, 0x4d, 0xc3, 0xca, 0x70,
      0x31, 0x6b, 0xba, 0xe3, 0x39, 0x9f, 0x82, 0xc3, 0xe4, 0xe2, 0x49, 0x83,
      0x14, 0x3b, 0xaa, 0xf4, 0xe1, 0x76, 0xc7, 0xc0, 0xec, 0x1c, 0xf9, 0x08,
      0xef, 0xf9, 0xc1, 0x5b, 0x34, 0x68, 0xfc, 0x7a, 0x44, 0xf6, 0xbc, 0x07,
      0x7c, 0xc3, 0x46, 0x7e, 0x4e, 0xc3, 0xa5, 0x0b, 0xa5, 0x18, 0x58, 0xac,
      0x9c, 0xf3, 0xcf, 0xf0, 0xc9, 0x9c, 0xe5, 0xc9, 0x63, 0xeb, 0xe5, 0x34,
      0x17, 0x52, 0xdb, 0x2c, 0xb6, 0xed, 0x59, 0x80, 0x54, 0x40, 0x56, 0xd3,
      0x08, 0xc7, 0xc7, 0x4f, 0xd1, 0x49, 0x85, 0xa4, 0x14, 0xee, 0x61, 0x66,
      0x9b, 0xf4, 0xab, 0xf4, 0x87, 0x67, 0x07, 0x1c, 0xfd, 0x0c, 0x1a, 0x1d,
      0xf8, 0x4b, 0x8d, 0xd4, 0xdf, 0xca, 0x74, 0xb3, 0x42, 0xec, 0x82, 0x0a,
      0xeb, 0x73, 0xa5, 0xeb, 0xa0, 0xdf, 0x78, 0xb8, 0x5a, 0x56, 0x8d, 0xc3,
      0x6c, 0xee, 0xa5, 0xb8},
     pub_key_1,
     {0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30},
     true},

    // Comment:
    // tcID: 16
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     16,
     0,
     {0x97, 0x8c, 0x88, 0x52, 0xab, 0x3a, 0x09, 0xc6, 0xe2, 0x8f, 0x62, 0x7c,
      0xd9, 0x17, 0x92, 0x73, 0x53, 0x87, 0x4c, 0xb7, 0xb2, 0xd6, 0x64, 0x7f,
      0x3f, 0x58, 0x89, 0xff, 0x81, 0xb0, 0x48, 0xf4, 0xa4, 0xc6, 0x07, 0x3a,
      0xe6, 0xd9, 0x9b, 0xc7, 0x35, 0x4d, 0x9e, 0x45, 0xc8, 0x05, 0xfe, 0xbe,
      0x5b, 0xe5, 0xdd, 0x3f, 0x95, 0xad, 0x14, 0x51, 0x31, 0x19, 0x16, 0x9a,
      0x6a, 0xc7, 0xa6, 0xa5, 0xb8, 0x8e, 0xad, 0x21, 0x71, 0xd9, 0x99, 0xf1,
      0x99, 0xb3, 0x24, 0x25, 0x15, 0x66, 0x06, 0x6f, 0x8d, 0x9a, 0x3b, 0xb5,
      0x1a, 0x5b, 0x59, 0xc7, 0x99, 0x85, 0x8d, 0x45, 0x91, 0x36, 0x34, 0x1a,
      0xb7, 0x74, 0x48, 0x0f, 0x05, 0x9f, 0xee, 0x15, 0x3b, 0xc0, 0x3e, 0x37,
      0xcf, 0x67, 0x6b, 0x1d, 0xb4, 0xab, 0xb2, 0xf7, 0x97, 0x95, 0x54, 0xfb,
      0x63, 0x52, 0x00, 0xce, 0x1c, 0x53, 0x44, 0x8e, 0x5d, 0xc3, 0x97, 0xbe,
      0x13, 0xc4, 0xd8, 0xf8, 0xbc, 0x2c, 0xf2, 0x11, 0x7a, 0x0c, 0x4d, 0xdc,
      0xb0, 0x89, 0x26, 0xfd, 0x5a, 0x1a, 0xdd, 0xd1, 0x93, 0xd0, 0xc1, 0xf2,
      0x16, 0x77, 0x31, 0xc7, 0x3a, 0xff, 0xba, 0x2c, 0x74, 0x37, 0x44, 0x3d,
      0x8b, 0xce, 0x82, 0x85, 0x40, 0xa3, 0xd4, 0x2f, 0x03, 0xb5, 0x90, 0xdd,
      0xed, 0x09, 0x58, 0xaa, 0x4f, 0xe4, 0x8d, 0x66, 0xd3, 0xde, 0xdb, 0x06,
      0x97, 0xf3, 0x66, 0xb3, 0xc7, 0xef, 0x9b, 0xea, 0x8c, 0x2b, 0x56, 0x70,
      0xa3, 0x1c, 0x41, 0xdf, 0x21, 0x82, 0x8a, 0x3a, 0x48, 0x1d, 0x9e, 0x42,
      0xc9, 0x3e, 0xf0, 0xb5, 0xcf, 0x43, 0x33, 0x0e, 0x63, 0x56, 0x02, 0x18,
      0x93, 0x07, 0x81, 0x79, 0xfd, 0x85, 0x7a, 0x14, 0xc4, 0x37, 0xd8, 0xb8,
      0xc6, 0x6d, 0x4e, 0x4e, 0xfc, 0xe1, 0x36, 0x9f, 0x69, 0x45, 0xc6, 0xbf,
      0x87, 0x85, 0x08, 0xa0},
     pub_key_1,
     {0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36},
     true},

    // Comment:
    // tcID: 17
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     17,
     0,
     {0x13, 0x22, 0x28, 0xbc, 0x78, 0x12, 0x49, 0xb5, 0x47, 0xb2, 0x54, 0x3f,
      0x00, 0x4b, 0x58, 0x07, 0xc0, 0x5f, 0x65, 0x30, 0xeb, 0x68, 0x5a, 0x0a,
      0x3c, 0x6b, 0x7e, 0xbe, 0x5c, 0x38, 0xef, 0x39, 0xed, 0xde, 0xdc, 0x5c,
      0xf3, 0xf9, 0x8f, 0x45, 0x2f, 0xfb, 0x20, 0x2e, 0x30, 0xdc, 0xcb, 0x8f,
      0x14, 0xc2, 0x52, 0xe6, 0x73, 0x47, 0x3e, 0xc7, 0xbf, 0xeb, 0x0d, 0x9c,
      0xb1, 0x6c, 0x2d, 0x88, 0xea, 0x16, 0x6f, 0xbb, 0x69, 0xec, 0xa1, 0x6f,
      0x7e, 0x03, 0x05, 0xe0, 0x54, 0xf1, 0x58, 0xed, 0x24, 0xc7, 0x4d, 0x02,
      0x32, 0x87, 0x30, 0x48, 0x81, 0x79, 0x25, 0x4e, 0xbd, 0x63, 0x97, 0x2f,
      0x2a, 0x51, 0xc4, 0x5f, 0x27, 0x49, 0x39, 0xd8, 0x9b, 0xcb, 0xad, 0x5d,
      0xf3, 0xd3, 0x96, 0x11, 0x15, 0x39, 0x2a, 0xa4, 0x83, 0xbe, 0xba, 0x4f,
      0x00, 0xe5, 0x55, 0x31, 0x55, 0x0f, 0x6e, 0x16, 0x7d, 0xa3, 0x85, 0x19,
      0x27, 0x3b, 0x3d, 0x16, 0x55, 0x5d, 0xbc, 0x28, 0x69, 0x79, 0xb4, 0x0c,
      0xee, 0x6e, 0x5e, 0x55, 0x59, 0xcd, 0xfb, 0xe6, 0xbc, 0x20, 0x8b, 0x53,
      0xe6, 0x33, 0x74, 0x00, 0x82, 0x1c, 0x43, 0x64, 0x6f, 0x94, 0x0f, 0xe6,
      0x24, 0x46, 0x68, 0x34, 0xb3, 0x35, 0xb3, 0xba, 0xd2, 0x7b, 0x8f, 0x29,
      0x8d, 0xfb, 0x4a, 0x1d, 0x3e, 0x63, 0x08, 0xa5, 0xfe, 0xa7, 0x7f, 0xd5,
      0x34, 0x7a, 0xbb, 0xd2, 0xee, 0x8e, 0x70, 0x8c, 0xa2, 0xf8, 0x71, 0x9c,
      0xee, 0x6f, 0xfe, 0x9a, 0xa9, 0x14, 0x43, 0xfc, 0x8e, 0xa5, 0x04, 0x17,
      0xd5, 0xf5, 0x46, 0xc2, 0x23, 0xfd, 0x07, 0xa5, 0x87, 0xac, 0x54, 0x7a,
      0x2e, 0x4b, 0x3f, 0x68, 0x6b, 0x70, 0x34, 0xc0, 0x64, 0x53, 0xdb, 0x15,
      0xfd, 0xe3, 0x1b, 0xd1, 0xb1, 0xc7, 0x64, 0x48, 0xa3, 0xba, 0xb5, 0xd1,
      0x4c, 0x7f, 0xf9, 0x4d},
     pub_key_1,
     {0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33},
     true},

    // Comment:
    // tcID: 18
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     18,
     0,
     {0xa0, 0x4a, 0x78, 0xf9, 0x2d, 0x66, 0x93, 0xc9, 0x47, 0x0e, 0x7e, 0x88,
      0x69, 0x0e, 0x40, 0xa4, 0xae, 0x8a, 0xef, 0xd0, 0xaf, 0x18, 0x45, 0x45,
      0x06, 0x90, 0x33, 0x73, 0x21, 0xce, 0x5b, 0x5e, 0x12, 0x5f, 0x98, 0x1b,
      0x76, 0x8e, 0x9e, 0x0a, 0x8a, 0x4a, 0x37, 0xe6, 0x87, 0xa0, 0x38, 0xda,
      0x1d, 0x2c, 0x21, 0x46, 0x2b, 0x96, 0x2b, 0x3c, 0xbb, 0xde, 0xb1, 0x70,
      0x22, 0x7f, 0xd9, 0x2f, 0x8e, 0x22, 0xe9, 0x9e, 0x6a, 0x18, 0x3a, 0xc6,
      0x8c, 0x0c, 0x42, 0x70, 0x8e, 0x36, 0x95, 0x59, 0xcf, 0xe7, 0xa1, 0xbc,
      0x5f, 0xd6, 0x4a, 0xc7, 0x1e, 0x8e, 0xd3, 0x4c, 0xe7, 0x0e, 0x86, 0x33,
      0x65, 0x03, 0x02, 0x8e, 0x61, 0x74, 0xb3, 0xff, 0x2b, 0x90, 0x76, 0xf4,
      0xb6, 0xb8, 0x4f, 0x05, 0x0f, 0xe3, 0x6a, 0xc4, 0x5a, 0x0f, 0x1d, 0xe6,
      0x77, 0xb7, 0x8f, 0x42, 0x90, 0x8d, 0xe1, 0x40, 0xd1, 0xf2, 0xa6, 0xec,
      0x88, 0x7a, 0x4f, 0xbc, 0x79, 0x5f, 0x76, 0x1f, 0x2f, 0x9b, 0x71, 0xd4,
      0x5d, 0xe9, 0xe6, 0xce, 0x78, 0x20, 0xbd, 0x6f, 0xd1, 0xa5, 0x3f, 0x0c,
      0x15, 0x16, 0xe3, 0xdf, 0x5b, 0x31, 0x48, 0x65, 0x18, 0xb7, 0x67, 0xab,
      0x55, 0x48, 0x14, 0xed, 0xe6, 0x27, 0x0b, 0x41, 0x7d, 0x53, 0x48, 0x0d,
      0x82, 0xc4, 0x15, 0xd8, 0x6d, 0x40, 0x35, 0x5b, 0x40, 0x53, 0x41, 0x03,
      0x4d, 0xa2, 0x94, 0x9c, 0xdd, 0x75, 0x98, 0x19, 0x59, 0x75, 0x23, 0x6e,
      0x26, 0x4b, 0x09, 0x88, 0x22, 0xaa, 0x88, 0x44, 0x48, 0x8f, 0x16, 0xfc,
      0xbc, 0xe0, 0x76, 0xba, 0xff, 0x03, 0xa9, 0xae, 0xf6, 0xa2, 0xab, 0xa1,
      0x55, 0xca, 0x14, 0xfa, 0x30, 0xe0, 0xef, 0xff, 0x4c, 0x96, 0x8e, 0xac,
      0x26, 0x57, 0x60, 0xdf, 0xff, 0x20, 0x56, 0xf6, 0xb1, 0x07, 0x9d, 0xc2,
      0x93, 0x16, 0xb6, 0x29},
     pub_key_1,
     {0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37},
     true},

    // Comment:
    // tcID: 19
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     19,
     0,
     {0x22, 0x1e, 0xfc, 0x61, 0xab, 0x6d, 0xd3, 0x04, 0x4c, 0xf7, 0x77, 0x80,
      0xd3, 0x79, 0xc0, 0x1a, 0xf6, 0x53, 0x12, 0x95, 0x1e, 0x5e, 0xa5, 0xbd,
      0x5e, 0xcf, 0xaf, 0xa5, 0xef, 0x55, 0xc5, 0xa5, 0x4e, 0x8b, 0xcd, 0xba,
      0x38, 0xa7, 0xb1, 0x27, 0x53, 0xbf, 0x04, 0x9e, 0x5a, 0xef, 0x8f, 0x2b,
      0x71, 0x79, 0x64, 0x29, 0xca, 0x93, 0x50, 0xce, 0x82, 0x0a, 0x10, 0xc7,
      0x04, 0x2d, 0xea, 0x4b, 0xee, 0xf1, 0x96, 0xed, 0x5e, 0xc3, 0xa3, 0x4c,
      0xfa, 0x53, 0x4e, 0x71, 0x1a, 0xe8, 0x00, 0x96, 0x31, 0xa6, 0xa3, 0xc6,
      0xd8, 0x7b, 0x25, 0xaf, 0x09, 0x0c, 0xab, 0xb2, 0xc8, 0x0e, 0x14, 0x32,
      0x17, 0x63, 0xfe, 0x15, 0x45, 0xbf, 0xca, 0x78, 0x26, 0x74, 0x15, 0xfc,
      0x89, 0x87, 0x8e, 0x96, 0x82, 0x83, 0xb2, 0x16, 0xaf, 0x23, 0xa9, 0xa5,
      0xe6, 0x75, 0x02, 0x8e, 0x62, 0xe1, 0xe2, 0xdf, 0x11, 0x77, 0x37, 0xc7,
      0x73, 0xd8, 0x32, 0xc7, 0x05, 0xd3, 0xed, 0x36, 0xe6, 0x80, 0xf1, 0xe3,
      0xb2, 0xec, 0xf0, 0x6a, 0xef, 0xf6, 0x9e, 0x00, 0x72, 0xf9, 0x51, 0xa3,
      0x44, 0x49, 0xb4, 0x13, 0x4e, 0x9e, 0x13, 0x9f, 0xfd, 0xdc, 0xe8, 0xc3,
      0x8b, 0x2f, 0xf0, 0xd2, 0x0a, 0x31, 0x4b, 0x45, 0xa9, 0x34, 0x5e, 0x3a,
      0xe6, 0xe3, 0x12, 0xa9, 0x46, 0x73, 0x60, 0x5e, 0x5e, 0xd8, 0x69, 0x30,
      0x02, 0xd6, 0x06, 0x29, 0xc6, 0x0f, 0xa5, 0x44, 0x69, 0x14, 0x8d, 0x5c,
      0x50, 0xd8, 0x0e, 0xd8, 0xa1, 0xa0, 0xd2, 0x2e, 0x46, 0x72, 0xf9, 0xf3,
      0xa2, 0xeb, 0x85, 0xd2, 0x98, 0x92, 0x8e, 0x4f, 0xc3, 0x33, 0xfd, 0x1e,
      0x0a, 0xd5, 0x90, 0x9e, 0x65, 0xb8, 0xfb, 0x82, 0x91, 0x74, 0x15, 0x47,
      0x3f, 0x28, 0xa1, 0x7a, 0x61, 0x8c, 0x07, 0x90, 0x3e, 0x8a, 0xcb, 0xf8,
      0x01, 0x5e, 0x1c, 0x81},
     pub_key_1,
     {0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 20
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     20,
     0,
     {0x55, 0xb6, 0x73, 0x74, 0xc9, 0xef, 0x2a, 0xe6, 0x09, 0xf7, 0x0b, 0xd1,
      0xc8, 0x05, 0xf5, 0xc0, 0x92, 0x27, 0x8e, 0x8a, 0x2e, 0x45, 0xf0, 0x49,
      0xb9, 0x49, 0xbd, 0x57, 0xd4, 0xbe, 0xd4, 0x4d, 0xd9, 0x88, 0x0c, 0xd5,
      0x98, 0x96, 0xde, 0x26, 0x6e, 0x3a, 0x52, 0x94, 0xf2, 0x90, 0x23, 0xa7,
      0xfe, 0x37, 0x6b, 0xfd, 0xc3, 0x5b, 0xb9, 0x2d, 0x54, 0x2f, 0x28, 0xf7,
      0xef, 0xaa, 0x37, 0xd4, 0xf3, 0x2c, 0x29, 0x7c, 0xef, 0x38, 0xc7, 0x23,
      0xb2, 0x7c, 0xd1, 0xfc, 0x0e, 0x45, 0xf6, 0xba, 0xbb, 0x61, 0xa2, 0x75,
      0x47, 0xb3, 0x7a, 0x18, 0x68, 0x66, 0xa9, 0xc7, 0x25, 0xa0, 0xd4, 0x25,
      0x3e, 0x35, 0xbe, 0xfe, 0xbf, 0x4f, 0x47, 0xae, 0xf7, 0xcb, 0x1c, 0x4b,
      0x35, 0x41, 0x9b, 0x6e, 0x02, 0x4e, 0x01, 0x51, 0xd4, 0x7c, 0x0c, 0x49,
      0xfc, 0x3b, 0xbe, 0xab, 0xeb, 0x75, 0xf2, 0xdd, 0x59, 0x6f, 0xef, 0x0f,
      0x8c, 0x9c, 0x27, 0x5f, 0x60, 0x58, 0xb9, 0x13, 0x0c, 0x58, 0xe0, 0x26,
      0x6e, 0xf1, 0x2e, 0x02, 0x33, 0xc6, 0xd1, 0x6f, 0x78, 0xec, 0x5c, 0xcc,
      0x1e, 0x8c, 0x7e, 0x03, 0xe3, 0xbc, 0xf1, 0x2b, 0xe3, 0x33, 0x17, 0xdf,
      0xb6, 0x60, 0xcf, 0x6d, 0x38, 0x51, 0xbb, 0x2a, 0xef, 0xf5, 0x69, 0x3f,
      0xe1, 0xa6, 0xe4, 0xb6, 0x44, 0xe0, 0xfc, 0x86, 0x0a, 0x3d, 0x6c, 0x21,
      0x00, 0x00, 0x9f, 0x29, 0xc6, 0x32, 0xfd, 0x9a, 0x57, 0x9a, 0x6b, 0xec,
      0xe0, 0x4e, 0xd2, 0x7b, 0xaa, 0xd3, 0xc5, 0xd6, 0x2b, 0x12, 0xba, 0x30,
      0x37, 0x2e, 0x5d, 0x7b, 0xed, 0x23, 0x70, 0x2c, 0x14, 0x6f, 0x4a, 0x64,
      0x4a, 0x6c, 0xa1, 0xbc, 0x9b, 0x23, 0xf2, 0x9c, 0xfe, 0xc3, 0xb4, 0x7f,
      0x7c, 0x92, 0xe9, 0xfe, 0xf4, 0x71, 0xb9, 0xe2, 0x55, 0x57, 0x00, 0xac,
      0x3c, 0x29, 0x60, 0xb1},
     pub_key_1,
     {0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31},
     true},

    // Comment:
    // tcID: 21
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     21,
     0,
     {0x74, 0xaf, 0x7b, 0x30, 0x1b, 0x5b, 0x48, 0x0a, 0xb7, 0x0b, 0x7a, 0xf2,
      0xde, 0xcd, 0x15, 0x5d, 0x7c, 0x6a, 0x28, 0x0c, 0xa7, 0x76, 0x63, 0xc2,
      0x76, 0xcd, 0xbb, 0x70, 0x2f, 0x78, 0x43, 0xfc, 0x3b, 0x0e, 0x3d, 0x54,
      0x66, 0x9f, 0xa9, 0xb9, 0x90, 0x93, 0xf3, 0x23, 0x53, 0x3f, 0x3e, 0xe5,
      0x84, 0x48, 0x3c, 0x83, 0xfd, 0x2f, 0x20, 0xd2, 0xd2, 0x91, 0xab, 0x84,
      0x82, 0x43, 0x5f, 0xb5, 0x3d, 0xfa, 0x19, 0xa8, 0x98, 0xfc, 0xe3, 0x6f,
      0x47, 0x09, 0x51, 0xb4, 0x80, 0x8e, 0xe4, 0xcd, 0xee, 0xd2, 0x73, 0x54,
      0x6d, 0xb4, 0xe6, 0xdb, 0x79, 0xcb, 0x2a, 0x42, 0x9c, 0x04, 0xc6, 0xe0,
      0xe7, 0x66, 0x1f, 0x6e, 0xe8, 0x4e, 0xea, 0x57, 0x98, 0x17, 0x97, 0xa2,
      0x98, 0xee, 0x37, 0xad, 0x26, 0x61, 0xb0, 0x02, 0x34, 0x5a, 0xfc, 0x0f,
      0xe9, 0x7c, 0x6b, 0x2b, 0x95, 0x5e, 0xfe, 0x1d, 0x75, 0x3f, 0x3e, 0x26,
      0x53, 0x3b, 0x43, 0xc0, 0xee, 0x48, 0x81, 0xe6, 0xe7, 0xbb, 0x36, 0xbd,
      0x56, 0xf0, 0x61, 0xbc, 0xe3, 0x40, 0xa9, 0xaf, 0x0a, 0x67, 0x9b, 0xb2,
      0x9f, 0x10, 0xc3, 0xc1, 0x40, 0xab, 0x6a, 0x5d, 0x3f, 0xee, 0x7f, 0x5e,
      0xe9, 0x02, 0x01, 0xd3, 0x35, 0xa0, 0x9c, 0xd9, 0x9d, 0x71, 0xc3, 0xfc,
      0x4a, 0x89, 0x07, 0x23, 0xf1, 0x99, 0x2f, 0x18, 0xea, 0x3f, 0xe6, 0x72,
      0xab, 0x65, 0x56, 0x14, 0x0f, 0xe4, 0xca, 0x5b, 0x16, 0xb1, 0x68, 0x73,
      0x6d, 0x58, 0xca, 0x8b, 0x0e, 0x2b, 0xe3, 0x64, 0x93, 0x1a, 0x1c, 0x2d,
      0x63, 0xeb, 0xad, 0x5f, 0xa3, 0xa0, 0x75, 0xa8, 0x89, 0xee, 0x1c, 0x56,
      0xd5, 0xc1, 0x28, 0xb1, 0x51, 0xba, 0x55, 0xa0, 0xdb, 0x41, 0x39, 0x97,
      0x31, 0x43, 0x18, 0x2b, 0x65, 0x21, 0x96, 0x2e, 0xc3, 0x6a, 0x81, 0x97,
      0x5b, 0x0e, 0x4a, 0x7b},
     pub_key_1,
     {0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38},
     true},

    // Comment:
    // tcID: 22
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     22,
     0,
     {0x3e, 0xd6, 0xa5, 0x56, 0xe0, 0xd2, 0x63, 0x50, 0xf6, 0x1e, 0xcc, 0x89,
      0x65, 0x50, 0x88, 0x84, 0x81, 0xa0, 0xe4, 0xfd, 0xdc, 0x0a, 0x8d, 0xb8,
      0x5c, 0xe3, 0x54, 0x7b, 0xef, 0x67, 0xd5, 0xa4, 0xdc, 0x8e, 0xc6, 0x53,
      0x12, 0x3b, 0x8f, 0xef, 0x83, 0x6e, 0x6d, 0x16, 0x18, 0x7c, 0x74, 0x60,
      0x42, 0xd8, 0xeb, 0x68, 0x31, 0x05, 0x45, 0x57, 0x8e, 0x7a, 0xa6, 0x9d,
      0x67, 0x6e, 0x2f, 0xec, 0xbe, 0xc0, 0x05, 0x67, 0xe6, 0x7d, 0x9f, 0x90,
      0xba, 0xd6, 0xff, 0xad, 0x56, 0xf2, 0xce, 0xb9, 0x0d, 0x06, 0xca, 0xcf,
      0x8e, 0x73, 0x60, 0x43, 0x95, 0x42, 0xa6, 0x77, 0x3e, 0x0b, 0x25, 0xb1,
      0x5f, 0x38, 0x5f, 0x35, 0x6f, 0x63, 0x03, 0x34, 0x81, 0x77, 0xe6, 0x62,
      0xb6, 0xed, 0x30, 0x85, 0x4d, 0xfd, 0x40, 0xb6, 0x49, 0xe9, 0x8e, 0xb9,
      0x28, 0x9e, 0x96, 0x4e, 0x15, 0xbd, 0xfa, 0xd7, 0xa5, 0x59, 0x64, 0x35,
      0xa2, 0xc2, 0xe5, 0xf8, 0x49, 0x43, 0x1c, 0xf1, 0x4d, 0x2b, 0x35, 0x49,
      0x69, 0x1e, 0x64, 0x2d, 0x5d, 0xba, 0xdb, 0x12, 0x8f, 0x66, 0x3f, 0xb0,
      0x6f, 0x84, 0xae, 0x23, 0x3d, 0x8b, 0xd8, 0x1f, 0xc7, 0x57, 0x19, 0x70,
      0xde, 0x9c, 0x5a, 0x14, 0x85, 0x4e, 0xc0, 0x3b, 0x3b, 0x42, 0x4a, 0xa5,
      0x09, 0x1c, 0x0d, 0xa9, 0xa2, 0x50, 0x20, 0xd8, 0x3e, 0xe4, 0x39, 0xe8,
      0x48, 0x98, 0x41, 0x1e, 0x97, 0x7d, 0xb5, 0x3a, 0x9b, 0xca, 0xe5, 0x59,
      0x85, 0xc2, 0x18, 0xc1, 0xb3, 0xd0, 0x8a, 0x96, 0x45, 0x93, 0x77, 0x4f,
      0x91, 0x20, 0xae, 0xa7, 0x23, 0x68, 0x3f, 0x8e, 0xbc, 0x9f, 0x09, 0x55,
      0x98, 0xa1, 0x31, 0x22, 0x59, 0xbf, 0x1e, 0x20, 0xab, 0x6a, 0x79, 0x92,
      0x8f, 0xb2, 0x28, 0x58, 0x57, 0x2b, 0xb1, 0x1a, 0x77, 0x35, 0x43, 0x83,
      0x71, 0x32, 0x32, 0xdb},
     pub_key_1,
     {0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37},
     true},

    // Comment:
    // tcID: 23
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     23,
     0,
     {0x05, 0xd9, 0x75, 0xcc, 0xb9, 0x28, 0x59, 0xe4, 0x32, 0x2c, 0x77, 0x12,
      0x11, 0x98, 0x77, 0x40, 0x16, 0x18, 0x26, 0x8b, 0xa4, 0x86, 0xa0, 0x5a,
      0x52, 0x5c, 0xe5, 0xfa, 0x87, 0x9c, 0x5b, 0x8c, 0xb2, 0xe3, 0x81, 0x71,
      0xf1, 0xb8, 0xc5, 0xba, 0xdf, 0xd2, 0xd3, 0x2b, 0x27, 0x67, 0x67, 0x38,
      0x9b, 0x01, 0x11, 0x48, 0xe9, 0x94, 0xc4, 0x00, 0xb8, 0xdc, 0xd2, 0xe4,
      0x49, 0x19, 0xb2, 0x0f, 0xda, 0xc7, 0x5e, 0xa3, 0xc5, 0xbd, 0x2e, 0x1b,
      0x48, 0x8d, 0x28, 0x5e, 0x97, 0x45, 0x69, 0x93, 0x2c, 0x41, 0x87, 0x41,
      0xda, 0x41, 0xab, 0x22, 0x9d, 0xd6, 0x5c, 0xa0, 0x9c, 0xf2, 0x81, 0xf4,
      0x2e, 0x23, 0x1c, 0x86, 0x57, 0x62, 0x3d, 0xba, 0xaf, 0x7b, 0x5d, 0x87,
      0x5a, 0xeb, 0x7d, 0xd4, 0xae, 0xa1, 0xfd, 0x15, 0xfe, 0x6a, 0x0b, 0x7e,
      0xff, 0xff, 0x66, 0xe9, 0xbf, 0x97, 0x9e, 0x70, 0xb0, 0xec, 0x28, 0xda,
      0xb2, 0x60, 0xec, 0x68, 0xd6, 0x79, 0xb1, 0x3e, 0x76, 0xdc, 0x1f, 0x0a,
      0x82, 0xa0, 0xc5, 0x98, 0xb3, 0x41, 0x2c, 0xf6, 0xa2, 0xf3, 0x06, 0xe8,
      0xe5, 0x10, 0x76, 0x98, 0xd3, 0xc5, 0x4a, 0x7e, 0xde, 0x18, 0x8f, 0xf3,
      0x96, 0xec, 0xf7, 0xe1, 0x53, 0xcb, 0xbe, 0x32, 0x2e, 0x48, 0xde, 0x7f,
      0xb4, 0xc8, 0xee, 0xe3, 0xcd, 0xe0, 0xcd, 0x35, 0x61, 0x57, 0x79, 0xce,
      0x24, 0xf8, 0x5f, 0x55, 0x0a, 0x35, 0xd3, 0xd3, 0x1a, 0x6a, 0xda, 0x61,
      0x75, 0xdc, 0xe6, 0x34, 0x6f, 0x2b, 0x4c, 0x7a, 0xb0, 0xd6, 0x0d, 0x4a,
      0x95, 0x50, 0x0b, 0xc5, 0x4e, 0xb5, 0xa1, 0xda, 0x60, 0x28, 0x19, 0x2d,
      0x5a, 0x53, 0x72, 0xf4, 0x8d, 0xbf, 0x70, 0x47, 0x84, 0xdb, 0x56, 0x16,
      0xfc, 0x1e, 0x69, 0x0f, 0x7a, 0xb3, 0xbe, 0x16, 0x7b, 0x53, 0x28, 0xd4,
      0x87, 0x89, 0x3c, 0x3a},
     pub_key_1,
     {0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 24
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     24,
     0,
     {0x40, 0xf9, 0xb7, 0x40, 0x51, 0xd6, 0xa9, 0x5f, 0xda, 0xa2, 0x5b, 0x05,
      0x59, 0x8b, 0x42, 0x2e, 0xef, 0x97, 0x85, 0x2d, 0xda, 0x21, 0x7d, 0x51,
      0xb5, 0x91, 0xa3, 0x69, 0x37, 0xaf, 0x45, 0xdd, 0xf5, 0xe0, 0x6f, 0x3e,
      0xab, 0xfa, 0xf1, 0x76, 0x10, 0xe5, 0x54, 0x90, 0xed, 0x3e, 0x00, 0xd1,
      0x1c, 0x85, 0x61, 0xf7, 0xcf, 0xfa, 0x25, 0x60, 0x0f, 0xb9, 0xef, 0x7a,
      0x51, 0x14, 0x39, 0x94, 0x15, 0xa9, 0x33, 0xeb, 0x68, 0x11, 0xae, 0x21,
      0x42, 0x35, 0x1c, 0xc0, 0x62, 0x1a, 0x5d, 0x39, 0xff, 0x45, 0x28, 0x75,
      0xb1, 0xa6, 0x69, 0xc6, 0x66, 0xc6, 0x06, 0xe4, 0xb8, 0x17, 0x97, 0x5b,
      0x96, 0x66, 0x35, 0x81, 0x16, 0x94, 0xc8, 0xa9, 0x20, 0xa5, 0xcb, 0xe8,
      0x30, 0x0d, 0xf0, 0x0c, 0x0a, 0xe0, 0xfa, 0xa1, 0xa7, 0x81, 0x29, 0x12,
      0xda, 0xa0, 0x81, 0xc7, 0x20, 0x4a, 0xf6, 0xeb, 0x7f, 0x71, 0x52, 0xec,
      0x82, 0xb4, 0x5b, 0x50, 0x4d, 0xc3, 0x21, 0x4e, 0xb9, 0xec, 0x5b, 0x32,
      0x2c, 0x58, 0x77, 0x14, 0x10, 0xda, 0xd1, 0x21, 0xf5, 0xcd, 0x88, 0x7b,
      0xff, 0x99, 0x76, 0xc3, 0x8c, 0x3c, 0xc9, 0xb1, 0xa4, 0x4d, 0x36, 0x83,
      0xe9, 0x5c, 0x76, 0xe6, 0xa8, 0x3a, 0xf6, 0xc6, 0x50, 0xcf, 0x60, 0x91,
      0xb6, 0x8e, 0x6e, 0xa2, 0xe6, 0xf2, 0x8b, 0x11, 0xe0, 0xc6, 0x64, 0xad,
      0x13, 0x2f, 0xf0, 0x98, 0xd0, 0xce, 0xe6, 0x5c, 0x8f, 0x0b, 0x43, 0x63,
      0x28, 0x33, 0x2c, 0xa0, 0xbd, 0x10, 0x48, 0xaf, 0x8d, 0xe6, 0x18, 0xfd,
      0xb4, 0x94, 0x14, 0x8a, 0xf8, 0xd2, 0xd9, 0x8e, 0xf4, 0x81, 0x9f, 0xed,
      0xe5, 0x64, 0x47, 0x6a, 0x52, 0xfa, 0x2b, 0x7d, 0x17, 0x6e, 0x57, 0xf0,
      0xfd, 0x9e, 0x49, 0x9a, 0x21, 0x5d, 0xe6, 0xb7, 0x73, 0x72, 0x78, 0xd7,
      0xe6, 0xd9, 0x5a, 0x2b},
     pub_key_1,
     {0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34},
     true},

    // Comment:
    // tcID: 25
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     25,
     0,
     {0x94, 0xcd, 0x1d, 0x5b, 0x54, 0xa8, 0x86, 0x49, 0xf9, 0x20, 0xe1, 0xde,
      0xcf, 0x75, 0x0e, 0x04, 0xc8, 0x63, 0x0e, 0x32, 0xd7, 0x18, 0x10, 0x01,
      0x6b, 0x98, 0x81, 0x8b, 0xfd, 0x0d, 0x97, 0x8b, 0xab, 0x27, 0x25, 0x46,
      0x6c, 0x1a, 0x82, 0x6b, 0xdf, 0x4e, 0xf4, 0x2b, 0x11, 0x5b, 0x90, 0x4e,
      0x32, 0x8f, 0xf1, 0xc0, 0x12, 0xc7, 0x04, 0x86, 0x56, 0x40, 0xaf, 0x61,
      0xaf, 0xf3, 0xf7, 0xbb, 0x6a, 0x3f, 0xd6, 0x67, 0xed, 0x2c, 0x91, 0xeb,
      0xb9, 0x3a, 0x02, 0x32, 0x65, 0x53, 0x60, 0x80, 0x70, 0x02, 0xc2, 0xf0,
      0x5f, 0xb6, 0x4c, 0x90, 0xf8, 0x42, 0xb7, 0xbe, 0xc1, 0x1d, 0xd1, 0x96,
      0x0b, 0xf8, 0x5f, 0x21, 0x67, 0xb3, 0x97, 0xe0, 0x85, 0x2b, 0x79, 0x0c,
      0x7f, 0x19, 0x3d, 0x6e, 0x7f, 0x26, 0x4b, 0x2a, 0x50, 0x24, 0x80, 0x7d,
      0xd5, 0xd7, 0x6d, 0x94, 0x87, 0xab, 0x0e, 0x42, 0x2c, 0x92, 0x16, 0xc6,
      0x93, 0xaa, 0x17, 0x09, 0xe5, 0x6b, 0x3b, 0x61, 0x71, 0x9c, 0x9d, 0x6b,
      0x35, 0xf5, 0x10, 0xa7, 0x21, 0xd9, 0x47, 0x1f, 0x83, 0xca, 0x1a, 0x6e,
      0x46, 0xf7, 0xc1, 0x4a, 0xd0, 0xe4, 0xab, 0x4f, 0x25, 0x13, 0xa3, 0x89,
      0xe7, 0x09, 0x77, 0xb3, 0xd7, 0xd9, 0x91, 0x7a, 0x13, 0xc2, 0x5c, 0x1a,
      0x43, 0x9a, 0x75, 0x18, 0x5e, 0x9a, 0xab, 0x64, 0xee, 0x75, 0x76, 0xdb,
      0x62, 0x3e, 0x51, 0x42, 0x83, 0xb2, 0xd9, 0x4e, 0x10, 0x5f, 0x8c, 0x39,
      0xac, 0xdf, 0xd8, 0x53, 0x81, 0x72, 0x75, 0xe9, 0x05, 0x41, 0xc6, 0x78,
      0x12, 0xe4, 0x0a, 0x79, 0xfc, 0xda, 0x5a, 0x2d, 0x32, 0xd2, 0xc4, 0x00,
      0xd1, 0x19, 0x3f, 0x1b, 0x75, 0x6c, 0x98, 0xe8, 0xd3, 0x21, 0x25, 0x75,
      0xde, 0xce, 0x26, 0xc4, 0x47, 0x92, 0xfe, 0x3f, 0xbc, 0xe5, 0xdc, 0x56,
      0xd0, 0x24, 0x8c, 0x5e},
     pub_key_1,
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 26
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     26,
     0,
     {0x17, 0xda, 0x64, 0x46, 0x87, 0x4a, 0x87, 0xe7, 0xa7, 0xae, 0x4f, 0xb6,
      0x37, 0xc1, 0x91, 0xdb, 0x1d, 0x13, 0xc2, 0x0b, 0xef, 0xdc, 0x72, 0x6c,
      0x8a, 0xf2, 0x6a, 0x63, 0xb7, 0x8b, 0xf0, 0xc9, 0x98, 0xb8, 0x2c, 0x25,
      0xa1, 0x25, 0x67, 0x4a, 0x50, 0x71, 0x7a, 0x84, 0x9d, 0xdf, 0x00, 0x4b,
      0xa0, 0xf1, 0x40, 0x09, 0x21, 0xc0, 0x8a, 0x37, 0xa0, 0xc5, 0x6a, 0x72,
      0x83, 0x22, 0xa2, 0x06, 0x9d, 0xca, 0x41, 0x21, 0xc0, 0xc4, 0x7c, 0x43,
      0x7e, 0x7a, 0x16, 0xcc, 0x35, 0x92, 0xad, 0x54, 0x41, 0xa1, 0x57, 0x02,
      0x8d, 0x8c, 0xb6, 0xcf, 0x7c, 0xe5, 0xb8, 0x58, 0x2f, 0xd5, 0x25, 0xa1,
      0xc5, 0xfa, 0xce, 0x82, 0x20, 0x4e, 0x01, 0xfa, 0xbc, 0xa6, 0x02, 0x43,
      0x02, 0x2e, 0xa4, 0xd5, 0x81, 0x26, 0xfa, 0x33, 0x17, 0x0a, 0x60, 0x53,
      0xce, 0x2f, 0xd5, 0x3b, 0x46, 0xb1, 0x65, 0xd1, 0x05, 0x15, 0x1d, 0x5a,
      0x3e, 0xa7, 0xb0, 0xf2, 0xf0, 0x19, 0x78, 0x4a, 0xe8, 0x7f, 0xed, 0x52,
      0x9d, 0x77, 0x1b, 0xa5, 0xa6, 0xa6, 0xab, 0x60, 0x93, 0x4a, 0x8a, 0xef,
      0x5d, 0x4a, 0x4f, 0x25, 0xe5, 0xac, 0x91, 0xb6, 0x4e, 0x47, 0xae, 0xe0,
      0x95, 0x35, 0x2a, 0xc6, 0xa9, 0xf6, 0x8f, 0x5e, 0xea, 0xd8, 0x36, 0x73,
      0x0c, 0x08, 0xa3, 0x53, 0x95, 0xe0, 0xa2, 0xcc, 0x1a, 0xab, 0x29, 0xb7,
      0xe1, 0xd5, 0xef, 0x23, 0x8e, 0x93, 0x9e, 0x98, 0x47, 0xb9, 0x0d, 0x72,
      0x28, 0xb1, 0x23, 0x97, 0x49, 0xe7, 0x9c, 0x07, 0x39, 0x4a, 0xcf, 0x13,
      0xaa, 0x32, 0xe3, 0x49, 0xc2, 0x37, 0x31, 0x83, 0x8b, 0x24, 0x1c, 0x20,
      0xf7, 0xeb, 0xfa, 0x62, 0x7f, 0x96, 0xdc, 0xdf, 0x39, 0x5b, 0x4f, 0x77,
      0x3c, 0x74, 0x34, 0x7c, 0xcb, 0x96, 0x6f, 0xf8, 0xa3, 0x12, 0x2f, 0x6d,
      0x6f, 0x11, 0x92, 0xeb},
     pub_key_1,
     {0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35},
     true},

    // Comment:
    // tcID: 27
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     27,
     0,
     {0x01, 0x69, 0xa2, 0x2f, 0x82, 0xd7, 0xc1, 0xfc, 0x21, 0xca, 0xf6, 0x13,
      0x1d, 0x6a, 0x40, 0x02, 0x57, 0x82, 0x12, 0xf3, 0xbe, 0xeb, 0x18, 0x5a,
      0x83, 0x24, 0x08, 0x83, 0x3b, 0xbc, 0x24, 0x6f, 0x05, 0x22, 0x29, 0x59,
      0xe9, 0x08, 0x49, 0xbd, 0x41, 0x20, 0x7d, 0x6d, 0x74, 0xa4, 0x8e, 0x08,
      0x4b, 0x6e, 0xaa, 0xfa, 0xec, 0x78, 0xc9, 0xc0, 0xaa, 0xd7, 0xa9, 0xb2,
      0x46, 0x24, 0xe8, 0xc4, 0xc6, 0x6b, 0xec, 0x56, 0xfc, 0x86, 0xd2, 0xec,
      0x31, 0x76, 0x2a, 0x74, 0x98, 0xdd, 0x48, 0x20, 0x7a, 0x16, 0xb3, 0x15,
      0xc6, 0x8a, 0xac, 0x94, 0x66, 0x20, 0x13, 0x94, 0x03, 0x07, 0xe6, 0xf6,
      0xdc, 0x1d, 0x2d, 0x51, 0x28, 0x85, 0x19, 0x8f, 0x28, 0x8a, 0xdb, 0xd7,
      0x3b, 0x31, 0x09, 0x30, 0x0b, 0x1f, 0x03, 0xe1, 0x37, 0xb9, 0x04, 0xf7,
      0x43, 0xcc, 0xc7, 0xb9, 0x0d, 0xb2, 0x46, 0xc7, 0xee, 0x7b, 0x18, 0xc1,
      0xb6, 0xb2, 0xad, 0x5f, 0x06, 0x14, 0x96, 0xf8, 0xca, 0xc5, 0x34, 0xb5,
      0x8f, 0x16, 0x1e, 0x27, 0x78, 0xe8, 0xf7, 0x3d, 0xb6, 0xf4, 0x55, 0xaa,
      0xd6, 0x2f, 0x59, 0x9c, 0xff, 0xc8, 0xef, 0x16, 0xa4, 0x62, 0xbf, 0x38,
      0x0e, 0x0d, 0x09, 0xad, 0x82, 0x95, 0xe7, 0xe9, 0xa7, 0xba, 0xfa, 0x1b,
      0x7f, 0xd8, 0x41, 0x66, 0xda, 0xd9, 0x36, 0x37, 0x3b, 0x32, 0x3b, 0x52,
      0x5a, 0x11, 0x1d, 0x3b, 0x34, 0xe5, 0xf9, 0x18, 0x35, 0x8c, 0xec, 0x48,
      0x14, 0x4a, 0x99, 0xf2, 0xc6, 0x14, 0xff, 0xb2, 0x3f, 0x9a, 0x3c, 0x8f,
      0x9a, 0x49, 0x1f, 0x8a, 0x7f, 0xb0, 0x82, 0x5d, 0xcd, 0xe6, 0x2b, 0x40,
      0xb9, 0xb5, 0x6f, 0xbc, 0x81, 0x6e, 0x21, 0x42, 0x5f, 0xa4, 0xb0, 0x62,
      0x1d, 0x21, 0x5f, 0xa0, 0x19, 0xd2, 0x93, 0x10, 0x7a, 0x54, 0x7d, 0x55,
      0xa1, 0xf5, 0x52, 0xb9},
     pub_key_1,
     {0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39},
     true},

    // Comment:
    // tcID: 28
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     28,
     0,
     {0x78, 0xb2, 0x09, 0x81, 0x26, 0xeb, 0x13, 0xca, 0x30, 0x6f, 0x31, 0xcb,
      0x64, 0xba, 0x1a, 0xfc, 0x17, 0xe0, 0x53, 0x58, 0x0b, 0x68, 0x18, 0x4a,
      0x02, 0x9d, 0x5a, 0xd4, 0x7e, 0xc8, 0x02, 0x94, 0x74, 0xa6, 0x4d, 0xcc,
      0xea, 0x67, 0xef, 0x1d, 0x01, 0xb4, 0xf9, 0x5f, 0x1c, 0x2b, 0x41, 0x6d,
      0x31, 0x24, 0x37, 0x13, 0x9e, 0xd1, 0x97, 0x7e, 0xc8, 0x0a, 0x93, 0x39,
      0xbf, 0x92, 0x5c, 0xd2, 0xf2, 0xc1, 0x57, 0xdd, 0x3a, 0xcc, 0xb4, 0x7d,
      0x1b, 0x85, 0xea, 0xa4, 0x3a, 0x7f, 0x2f, 0x60, 0x83, 0xe8, 0x50, 0x84,
      0xb0, 0x5d, 0x80, 0x33, 0x6b, 0x2d, 0x04, 0x35, 0x31, 0x5d, 0x01, 0x24,
      0xed, 0x15, 0x5b, 0xe0, 0x10, 0x0a, 0x98, 0xf7, 0x5b, 0x9d, 0x75, 0x96,
      0xf3, 0x79, 0x9c, 0xfb, 0x3a, 0x1b, 0x7e, 0x2a, 0x8a, 0xc3, 0xc8, 0x05,
      0xda, 0x8d, 0xa5, 0x84, 0x4a, 0x27, 0xb0, 0x44, 0x86, 0xf8, 0x0f, 0x1d,
      0xdf, 0xd4, 0x63, 0xba, 0x9d, 0x01, 0xa8, 0x50, 0x09, 0x6a, 0x60, 0x03,
      0x46, 0x77, 0x2d, 0x8b, 0xbf, 0xc7, 0x3c, 0x99, 0x32, 0x52, 0x26, 0x87,
      0xb2, 0x96, 0xdd, 0xcf, 0x28, 0x92, 0xf3, 0x7b, 0x2a, 0x9b, 0x90, 0xbe,
      0x7d, 0xcd, 0x90, 0x81, 0xdf, 0x2a, 0x48, 0x01, 0x4f, 0x5b, 0xdd, 0x08,
      0xc1, 0x14, 0x98, 0x9a, 0x49, 0x20, 0xea, 0xd5, 0x75, 0x63, 0xc4, 0x61,
      0x58, 0x74, 0xf3, 0xb7, 0x70, 0x76, 0x07, 0xd6, 0x25, 0x76, 0x14, 0x84,
      0x7b, 0xd9, 0x94, 0x29, 0x64, 0x2a, 0x58, 0xa3, 0x05, 0x38, 0x3c, 0x83,
      0x5a, 0x1b, 0xbc, 0x2e, 0xa8, 0xb4, 0x43, 0xa2, 0xaa, 0xef, 0xa5, 0xc8,
      0xcd, 0xe4, 0x59, 0x90, 0x40, 0x16, 0xdd, 0xf3, 0x81, 0xc5, 0x91, 0xdc,
      0x23, 0x8e, 0x10, 0xa8, 0x24, 0x9c, 0x7e, 0x1c, 0xaa, 0xd9, 0x6b, 0x42,
      0xea, 0x41, 0x5f, 0x7d},
     pub_key_1,
     {0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34},
     true},

    // Comment:
    // tcID: 29
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     29,
     0,
     {0x37, 0xac, 0x7d, 0x00, 0x88, 0xf2, 0x11, 0x18, 0xf5, 0xf9, 0xf8, 0x34,
      0x06, 0x3d, 0x56, 0x96, 0x64, 0x56, 0xa9, 0xba, 0x84, 0x00, 0x89, 0xa1,
      0xb1, 0x80, 0x5f, 0xcf, 0xc8, 0x08, 0xff, 0x22, 0xcc, 0x9d, 0x7b, 0x3b,
      0x3a, 0x36, 0x1c, 0xbf, 0x1c, 0x2f, 0x96, 0xc6, 0x2f, 0x69, 0x4b, 0x47,
      0xa6, 0xe9, 0xa1, 0x9f, 0x2a, 0xda, 0xce, 0x72, 0x12, 0x00, 0xa5, 0x21,
      0x10, 0xf3, 0x4b, 0x9c, 0x95, 0xf4, 0x5f, 0xb4, 0xaf, 0x9c, 0x25, 0x0d,
      0x04, 0x72, 0x01, 0x80, 0x69, 0xd4, 0x93, 0x84, 0x7f, 0xaf, 0xd4, 0x68,
      0xe8, 0xf5, 0x0b, 0x4d, 0x2f, 0x1a, 0xd9, 0x7e, 0x10, 0x01, 0x58, 0x62,
      0xec, 0x02, 0x82, 0x2b, 0x1e, 0x17, 0xdc, 0xe3, 0xda, 0x17, 0x15, 0xf6,
      0xf0, 0x9f, 0xb8, 0x9b, 0x4f, 0x7d, 0x0c, 0x35, 0xb8, 0x50, 0x94, 0x45,
      0xf7, 0x70, 0xea, 0x6e, 0xc3, 0x25, 0xe9, 0x33, 0xc6, 0x51, 0xdd, 0x4d,
      0x75, 0xf5, 0x70, 0x20, 0x80, 0xec, 0x3b, 0x03, 0xc4, 0x8b, 0x38, 0x0b,
      0x1f, 0x20, 0x21, 0x12, 0xea, 0xc8, 0x68, 0x6d, 0x3e, 0x6e, 0x37, 0xf2,
      0x68, 0x5a, 0x6b, 0xe8, 0xb0, 0x78, 0x58, 0x45, 0x33, 0xae, 0x66, 0x85,
      0x5c, 0xfd, 0x6f, 0x6b, 0x75, 0x8e, 0x44, 0x87, 0xba, 0xb1, 0x9a, 0x65,
      0xa1, 0x22, 0x45, 0xa6, 0xf1, 0x77, 0xfb, 0xfd, 0x86, 0x1c, 0x94, 0xc5,
      0xd3, 0x0b, 0x6f, 0xbf, 0x75, 0x0d, 0x66, 0xb6, 0x82, 0xf9, 0x8e, 0x34,
      0xfa, 0xcf, 0x4a, 0xad, 0xd6, 0x7b, 0x4d, 0xb4, 0x46, 0x3c, 0xb0, 0x83,
      0x28, 0xd8, 0xd5, 0x93, 0x57, 0x89, 0x5d, 0xa5, 0x5f, 0x17, 0x36, 0xc9,
      0x1c, 0x62, 0xb2, 0x63, 0x4a, 0x66, 0xac, 0xe8, 0xb2, 0xea, 0x44, 0xa8,
      0x6e, 0x5d, 0xbc, 0x09, 0xaa, 0xd6, 0x99, 0x85, 0x24, 0x07, 0x7a, 0x68,
      0xb9, 0xc1, 0xf3, 0x3c},
     pub_key_1,
     {0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34},
     true},

    // Comment:
    // tcID: 30
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     30,
     0,
     {0x6d, 0x25, 0x0a, 0x92, 0x0d, 0xe5, 0x96, 0x5e, 0xc3, 0x6a, 0xb9, 0x16,
      0xad, 0x58, 0x5e, 0xf2, 0x12, 0x52, 0x35, 0x5f, 0x06, 0x29, 0xb0, 0x84,
      0xa1, 0x19, 0xf7, 0xe9, 0xb7, 0x3d, 0x3d, 0xe1, 0x42, 0x56, 0xf6, 0x12,
      0xfa, 0x92, 0xe3, 0xd6, 0x58, 0xef, 0xb3, 0xe5, 0x33, 0x43, 0xc0, 0xed,
      0xb8, 0xb7, 0xe5, 0x5a, 0x70, 0x4d, 0xce, 0x2a, 0xf2, 0xf7, 0xd8, 0x61,
      0xa4, 0x04, 0xd1, 0x55, 0x4f, 0xe1, 0x9a, 0xa9, 0xa6, 0xb9, 0xaa, 0x8a,
      0x13, 0x89, 0x72, 0x47, 0xa3, 0x7a, 0x2d, 0x97, 0x3c, 0xee, 0x58, 0xc3,
      0x60, 0x8c, 0x94, 0x78, 0x9f, 0xb8, 0xac, 0x1c, 0xe0, 0x5d, 0x6f, 0x0c,
      0x2c, 0x1c, 0x7b, 0x8b, 0xaa, 0x7b, 0xaa, 0x1c, 0xc8, 0xd7, 0x7d, 0x4b,
      0x7e, 0x91, 0x1d, 0xb3, 0x71, 0x03, 0x81, 0x17, 0xaf, 0x95, 0xb1, 0xe2,
      0x40, 0xab, 0x31, 0x70, 0x31, 0xbb, 0xa8, 0x36, 0x86, 0xb8, 0xab, 0x99,
      0xd7, 0x5b, 0xaa, 0xbe, 0xd4, 0x87, 0x3f, 0xc7, 0x28, 0x84, 0x79, 0x4b,
      0x3a, 0x3d, 0xa9, 0x05, 0xda, 0x01, 0x6a, 0xc2, 0x92, 0x62, 0x2b, 0x8f,
      0x73, 0xe4, 0x46, 0xf4, 0x6a, 0x99, 0x2c, 0xad, 0x8d, 0x2b, 0x9c, 0x9b,
      0x4d, 0x50, 0x38, 0x1f, 0x58, 0xde, 0x58, 0xda, 0x58, 0xa2, 0x5a, 0xe3,
      0x41, 0xb1, 0x1d, 0x30, 0x2e, 0x11, 0xdb, 0x18, 0xd2, 0xba, 0xfe, 0x67,
      0x3d, 0xea, 0x10, 0x93, 0xd6, 0x7f, 0x7d, 0x1e, 0x49, 0x19, 0xab, 0xbd,
      0x43, 0xc0, 0xc0, 0x00, 0x8b, 0x8e, 0xab, 0x08, 0x9e, 0xc6, 0xbb, 0xcf,
      0x12, 0x6f, 0xb9, 0x99, 0x8f, 0xa8, 0x69, 0x7a, 0xb4, 0x8c, 0xfa, 0x5d,
      0x90, 0xae, 0x76, 0xea, 0xfd, 0xec, 0xf1, 0x80, 0x37, 0xfc, 0x3c, 0x8c,
      0x5f, 0xba, 0x02, 0xe3, 0x7a, 0xe7, 0x9b, 0x29, 0x66, 0x5c, 0x05, 0x1e,
      0x27, 0x1f, 0x26, 0x9a},
     pub_key_1,
     {0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36},
     true},

    // Comment:
    // tcID: 31
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     31,
     0,
     {0x97, 0xa3, 0xe3, 0x42, 0xaa, 0x73, 0x97, 0x3a, 0x4b, 0x99, 0x38, 0x73,
      0xd1, 0x74, 0x1d, 0xc9, 0xad, 0x91, 0x6f, 0x5d, 0xe6, 0x3d, 0x78, 0xf8,
      0xc6, 0xa7, 0xf7, 0xb2, 0x24, 0x7e, 0x2e, 0xd6, 0x2a, 0x76, 0x51, 0x0d,
      0x0e, 0x25, 0xe6, 0xa2, 0x7e, 0xa0, 0xe2, 0xea, 0x8a, 0x5d, 0x8e, 0x38,
      0x38, 0x15, 0x28, 0xf9, 0x13, 0x45, 0x8b, 0xf6, 0xca, 0xec, 0xcb, 0x73,
      0xfe, 0x2e, 0x2a, 0xe3, 0x83, 0x0d, 0x0c, 0x3f, 0x46, 0x38, 0x59, 0xbf,
      0xd5, 0x5f, 0xc2, 0x6e, 0x5b, 0xb1, 0x6f, 0x95, 0xa1, 0x51, 0x7f, 0x44,
      0x59, 0x79, 0x26, 0x5f, 0xd0, 0x9b, 0x17, 0x03, 0x32, 0x97, 0xaa, 0x6d,
      0x53, 0x36, 0x20, 0x61, 0x82, 0xd5, 0x03, 0x03, 0x96, 0x17, 0x6e, 0xd0,
      0x4b, 0x0f, 0x6b, 0x86, 0xa9, 0xad, 0x9d, 0x18, 0x0c, 0x17, 0xf7, 0xaf,
      0xc6, 0xaa, 0xcb, 0xa9, 0x41, 0x6f, 0x0a, 0x67, 0xd5, 0xf7, 0xb8, 0xd9,
      0x3c, 0x99, 0x4b, 0x71, 0x9f, 0xac, 0x07, 0x53, 0x89, 0xf8, 0x3e, 0xef,
      0xd9, 0xc9, 0xf3, 0xad, 0xe1, 0x46, 0x63, 0x29, 0x17, 0xc2, 0x6f, 0x62,
      0x2a, 0x13, 0x13, 0xef, 0x47, 0x0f, 0x25, 0x7f, 0x67, 0xf9, 0xfb, 0xfe,
      0x67, 0x24, 0x5e, 0xc2, 0x53, 0x95, 0x97, 0x51, 0xa8, 0x4a, 0xe8, 0x4c,
      0x7a, 0x0c, 0x06, 0x12, 0x93, 0x37, 0x64, 0x5d, 0xfa, 0x36, 0xc6, 0x5c,
      0xee, 0xe8, 0xfd, 0x1c, 0xcb, 0xd0, 0x21, 0xa5, 0x17, 0x81, 0xf4, 0xab,
      0x83, 0x98, 0xaf, 0x33, 0x44, 0xb0, 0xa3, 0xb9, 0x03, 0x6e, 0xd4, 0xb9,
      0xd1, 0x7f, 0x7c, 0x57, 0x29, 0x03, 0x39, 0x1a, 0x64, 0xa8, 0xc4, 0x5c,
      0x1f, 0xe5, 0xef, 0x9d, 0xa6, 0x07, 0xa0, 0xa7, 0xce, 0xd1, 0xf9, 0x7a,
      0x86, 0x51, 0xb4, 0x4b, 0xa4, 0xf0, 0x37, 0x48, 0x46, 0x26, 0xbf, 0x77,
      0x0d, 0x17, 0x65, 0xe1},
     pub_key_1,
     {0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 32
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     32,
     0,
     {0x6f, 0xe1, 0xf5, 0xe3, 0xf1, 0x1d, 0xba, 0xc4, 0x00, 0x04, 0x35, 0x05,
      0xb0, 0xb3, 0x31, 0xc3, 0x2c, 0x28, 0xc3, 0x7b, 0x4d, 0x3c, 0xfd, 0x9b,
      0xbf, 0x95, 0x9b, 0x30, 0x1b, 0x3b, 0xbc, 0x75, 0x22, 0x48, 0xe0, 0x52,
      0xb5, 0xfc, 0x3f, 0xd6, 0xc8, 0x0b, 0x2a, 0x81, 0x75, 0x44, 0x01, 0x05,
      0xbf, 0x84, 0x90, 0x4d, 0x2f, 0xa9, 0xea, 0x76, 0x3a, 0x31, 0xba, 0x53,
      0x2f, 0x7c, 0x52, 0x8e, 0x15, 0x96, 0x7f, 0x48, 0x58, 0xc0, 0xa6, 0x7f,
      0xb9, 0xb9, 0x1b, 0x0e, 0xd4, 0x39, 0x26, 0xf3, 0xbb, 0xb9, 0x0d, 0x97,
      0x0e, 0x8d, 0x81, 0xa3, 0xd2, 0x38, 0x05, 0x56, 0xe6, 0x3e, 0xfe, 0x0b,
      0x49, 0xff, 0x70, 0x2d, 0xb5, 0xc1, 0x83, 0x5a, 0xdb, 0xad, 0x43, 0x83,
      0x0a, 0x98, 0x3f, 0xa8, 0x91, 0x52, 0x97, 0x32, 0x10, 0x4e, 0x60, 0x94,
      0x1c, 0x03, 0xfc, 0x8e, 0x26, 0x7c, 0x0a, 0x88, 0x9c, 0xa7, 0xd2, 0x9d,
      0x61, 0x58, 0x11, 0xd0, 0x5e, 0x96, 0x4f, 0xaa, 0x99, 0xf8, 0x1c, 0x2b,
      0xac, 0x92, 0x9b, 0x26, 0xb0, 0x82, 0x5c, 0x35, 0xab, 0xd7, 0xd3, 0xa3,
      0x6c, 0x09, 0x56, 0x81, 0x41, 0xa5, 0x38, 0x53, 0x76, 0x0d, 0x63, 0x24,
      0x46, 0xd4, 0x08, 0x8d, 0x03, 0x2b, 0x34, 0x8e, 0xf0, 0x94, 0x2b, 0x91,
      0xeb, 0xf1, 0xc6, 0x8b, 0xaf, 0xc9, 0x1b, 0xc5, 0x48, 0x63, 0x45, 0x22,
      0x45, 0xaf, 0x96, 0xc0, 0x02, 0x50, 0x30, 0x2a, 0x05, 0xb2, 0x47, 0x23,
      0xf7, 0x32, 0x7e, 0xf4, 0x20, 0xfc, 0xb4, 0x42, 0x7f, 0x40, 0xd5, 0xe3,
      0x3e, 0xf4, 0xc4, 0x82, 0x0e, 0x0a, 0x7d, 0xf5, 0x7c, 0x24, 0x81, 0x4b,
      0x6e, 0xd8, 0xbd, 0x61, 0xde, 0x28, 0xc6, 0x59, 0x76, 0x35, 0x6a, 0x32,
      0x79, 0xd5, 0x21, 0x34, 0x75, 0x3e, 0x00, 0x8f, 0x02, 0xcd, 0x9d, 0x27,
      0xbc, 0xb6, 0x33, 0x0f},
     pub_key_1,
     {0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38},
     true},

    // Comment:
    // tcID: 33
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     33,
     0,
     {0x9a, 0xe7, 0x8d, 0xe1, 0x84, 0xd5, 0xb7, 0x20, 0x7e, 0x99, 0x08, 0x7c,
      0x84, 0xda, 0xcd, 0x1d, 0x5d, 0x51, 0x01, 0x19, 0xa2, 0x5b, 0x43, 0x15,
      0x50, 0x50, 0x15, 0x4c, 0x15, 0x39, 0xa7, 0xb4, 0x41, 0x46, 0xde, 0x65,
      0xc8, 0x35, 0x42, 0x63, 0x65, 0xc6, 0xd8, 0x77, 0x8c, 0x29, 0xe6, 0xe7,
      0x63, 0x97, 0x65, 0xda, 0x41, 0x84, 0xdb, 0xe0, 0x9e, 0x8f, 0x59, 0x46,
      0xeb, 0x2d, 0x63, 0x2c, 0xab, 0xa6, 0xe3, 0x1e, 0xb2, 0xed, 0xfc, 0x30,
      0x01, 0x6f, 0xfc, 0x4e, 0x3b, 0x7e, 0xed, 0x4d, 0x2d, 0x95, 0xcc, 0x56,
      0x3c, 0x27, 0x94, 0xd7, 0x0f, 0x8e, 0xf6, 0x0f, 0xf3, 0xf7, 0x7f, 0x87,
      0x6d, 0x82, 0xcd, 0x07, 0x5b, 0xb2, 0xfb, 0x6a, 0xb0, 0xd0, 0x27, 0xce,
      0x9d, 0xc5, 0xf3, 0xb2, 0x6a, 0x3e, 0x93, 0xc8, 0xa2, 0xc2, 0xe8, 0xbc,
      0xeb, 0x14, 0xf9, 0xeb, 0x45, 0xba, 0x4e, 0x10, 0x95, 0xa1, 0x9f, 0x44,
      0x1f, 0xee, 0x14, 0x5c, 0x60, 0xdf, 0x21, 0xad, 0xf2, 0x06, 0x8f, 0xe5,
      0x66, 0xdd, 0x79, 0x26, 0xda, 0xde, 0x24, 0xb3, 0x1b, 0x71, 0xf5, 0xdb,
      0x3d, 0x4d, 0xda, 0xf6, 0xc4, 0xe4, 0x4b, 0xee, 0x59, 0xe0, 0xd3, 0x30,
      0x2d, 0xca, 0x6d, 0x75, 0xfc, 0xc8, 0x79, 0x52, 0xcb, 0x58, 0x55, 0x5c,
      0x7d, 0xfb, 0xec, 0x53, 0x97, 0x5c, 0x7e, 0x1c, 0xda, 0x80, 0x3c, 0x20,
      0x07, 0xec, 0x1e, 0x53, 0xff, 0xfa, 0x36, 0x3e, 0x69, 0x61, 0x3d, 0x17,
      0xf8, 0x70, 0xc2, 0x67, 0x44, 0x42, 0x84, 0x0d, 0x10, 0x05, 0x03, 0x9e,
      0xcd, 0x21, 0x06, 0x92, 0x1a, 0xb6, 0xeb, 0xd9, 0xd9, 0x6e, 0x21, 0x30,
      0x7a, 0x80, 0xe9, 0x94, 0xff, 0x85, 0xea, 0xe5, 0x34, 0x9f, 0x4b, 0x42,
      0x6d, 0x45, 0x8a, 0xeb, 0x22, 0xca, 0xe5, 0x33, 0xe4, 0x67, 0x24, 0xcf,
      0xa5, 0xf2, 0xb4, 0x42},
     pub_key_1,
     {0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38},
     true},

    // Comment:
    // tcID: 34
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     34,
     0,
     {0xa2, 0x88, 0xda, 0xb1, 0xbd, 0xd7, 0xf4, 0x67, 0x6d, 0x1b, 0xcc, 0x84,
      0x29, 0x1a, 0x77, 0x84, 0xbe, 0x62, 0xf0, 0x01, 0xc5, 0xc1, 0xa8, 0x3a,
      0xd5, 0x75, 0xb1, 0x5c, 0xf5, 0x6a, 0x86, 0x86, 0x00, 0xba, 0xdc, 0x95,
      0xf2, 0x29, 0x54, 0xf9, 0xf4, 0x74, 0x34, 0x0d, 0x87, 0x4d, 0x3d, 0x56,
      0xfd, 0x23, 0xa8, 0xa8, 0x5e, 0xe3, 0xf0, 0x52, 0xc7, 0xbe, 0x5c, 0xa6,
      0x53, 0xcc, 0x2f, 0xd2, 0xc1, 0xea, 0x62, 0xf0, 0x2c, 0x0c, 0x5b, 0x65,
      0x3f, 0xc2, 0x01, 0x27, 0x2d, 0x43, 0x26, 0x71, 0x05, 0x9e, 0xe2, 0x79,
      0x39, 0x8e, 0x5a, 0xd0, 0xc4, 0x5e, 0x73, 0x5e, 0xb5, 0xc0, 0x3a, 0x2f,
      0xf9, 0xc8, 0x2a, 0xb5, 0x3d, 0x1a, 0xc9, 0x22, 0x55, 0x89, 0xec, 0xee,
      0x80, 0xfd, 0xe9, 0x0a, 0x03, 0x6e, 0x07, 0x9e, 0x45, 0xb3, 0x3b, 0x0b,
      0x4f, 0x0e, 0x6a, 0xfc, 0x31, 0x7a, 0xd3, 0x74, 0x4d, 0xd6, 0x5d, 0x22,
      0x60, 0x7c, 0xf3, 0x1d, 0xba, 0xbe, 0xb3, 0x8b, 0x0e, 0xb9, 0x35, 0xed,
      0xe4, 0x42, 0x0a, 0x1d, 0x82, 0x46, 0xb8, 0x0d, 0xa2, 0x17, 0xdb, 0xed,
      0x5d, 0x1c, 0xf6, 0xa4, 0xcf, 0x88, 0xac, 0x03, 0xa3, 0xec, 0xa3, 0x07,
      0xbc, 0x7a, 0xf4, 0xcd, 0xea, 0x63, 0x89, 0x4f, 0x67, 0x6e, 0xf2, 0x53,
      0xf7, 0xc8, 0xe1, 0xe7, 0xac, 0x1f, 0x67, 0xfb, 0x45, 0xab, 0xd2, 0xae,
      0xac, 0x3a, 0xc8, 0x89, 0x9a, 0x73, 0x86, 0x7a, 0xf8, 0x66, 0x88, 0xb6,
      0x7b, 0x3e, 0xcd, 0xf9, 0xe6, 0x38, 0x0a, 0x84, 0xb9, 0x9b, 0x98, 0xd2,
      0xdc, 0x4e, 0x65, 0x68, 0x25, 0x58, 0xd2, 0x87, 0x11, 0xdb, 0xb1, 0x28,
      0x8a, 0x03, 0x51, 0xce, 0xf1, 0x87, 0xf1, 0xed, 0xda, 0x14, 0xab, 0x57,
      0xa8, 0xfb, 0xc7, 0x1f, 0xb6, 0x03, 0x75, 0xe6, 0x82, 0xa5, 0x35, 0x66,
      0xeb, 0xa5, 0xff, 0x0b},
     pub_key_1,
     {0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38},
     true},

    // Comment:
    // tcID: 35
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     35,
     0,
     {0x0a, 0x53, 0x39, 0x30, 0x14, 0x00, 0xf5, 0x05, 0x42, 0x4b, 0xbd, 0x72,
      0xa8, 0x83, 0x55, 0x75, 0x9c, 0xe2, 0xb8, 0xe4, 0x3c, 0x97, 0xc7, 0xdc,
      0x6f, 0xc9, 0x0d, 0xc4, 0xbd, 0x33, 0x9d, 0xd3, 0x97, 0xbc, 0xdc, 0xd7,
      0x06, 0xae, 0x49, 0xdf, 0x8d, 0x5f, 0x53, 0x5f, 0x37, 0xc4, 0x27, 0x5e,
      0x89, 0x44, 0x19, 0x34, 0x5b, 0xc0, 0x1a, 0x15, 0xa1, 0x12, 0x51, 0xac,
      0x2b, 0x01, 0xbe, 0xa9, 0xed, 0xcf, 0x09, 0x32, 0x39, 0xb6, 0xbd, 0x15,
      0x19, 0x69, 0x74, 0xed, 0x38, 0xeb, 0xdd, 0xae, 0xdd, 0x60, 0xe6, 0xba,
      0x3e, 0xe6, 0x7a, 0xe0, 0x05, 0xc7, 0x38, 0x50, 0xca, 0x8a, 0x13, 0xa1,
      0xec, 0x69, 0x34, 0x33, 0xbb, 0xa8, 0xeb, 0x40, 0xdc, 0xb2, 0x3f, 0x33,
      0xa1, 0xa6, 0xfa, 0xc6, 0x4d, 0x63, 0x4c, 0x93, 0x63, 0xf2, 0x76, 0xc1,
      0x19, 0xd8, 0xe7, 0xe7, 0x64, 0x9e, 0x15, 0xfe, 0xe7, 0xc0, 0xa0, 0x39,
      0xdd, 0x41, 0xff, 0xd5, 0x87, 0x15, 0x92, 0xb7, 0xbc, 0xd7, 0xc3, 0x05,
      0x2b, 0x3d, 0xaf, 0xf5, 0xc9, 0x98, 0x44, 0x2f, 0x78, 0x8f, 0x4a, 0xf4,
      0x3a, 0xd0, 0x32, 0xf2, 0x57, 0xdd, 0x4f, 0xa0, 0xc7, 0xc6, 0x7f, 0x07,
      0x8d, 0x6b, 0x06, 0x08, 0xdf, 0x1a, 0x1d, 0x3b, 0x49, 0x48, 0x32, 0x7e,
      0xde, 0xd4, 0x7f, 0x9f, 0x4e, 0xd1, 0x66, 0x01, 0xa6, 0xe7, 0xfe, 0x86,
      0xec, 0xaf, 0x97, 0x21, 0xa4, 0x39, 0x1b, 0x01, 0x05, 0x1c, 0x00, 0x57,
      0x66, 0x27, 0xd4, 0x4f, 0x66, 0xca, 0x56, 0x57, 0x23, 0x6e, 0x1f, 0x52,
      0x60, 0xa3, 0x1f, 0x01, 0x7c, 0x6d, 0xae, 0x68, 0xd1, 0x7e, 0x98, 0x49,
      0x97, 0xe1, 0x89, 0x26, 0x26, 0xdd, 0x97, 0xf4, 0x14, 0x29, 0xa9, 0x14,
      0xa7, 0x66, 0x9e, 0x65, 0x01, 0x82, 0x84, 0x5b, 0x26, 0x14, 0xc7, 0x7f,
      0x39, 0x26, 0x71, 0x87},
     pub_key_1,
     {0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 36
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     36,
     0,
     {0x83, 0x83, 0xa9, 0x89, 0xde, 0x89, 0x65, 0x6e, 0xc9, 0x03, 0x37, 0x18,
      0x1c, 0xc6, 0x15, 0x38, 0x5f, 0x69, 0x16, 0x22, 0xaf, 0x12, 0x88, 0x60,
      0x32, 0x85, 0x20, 0x62, 0x5b, 0xfa, 0xa1, 0xff, 0xd2, 0x79, 0x2f, 0xcd,
      0x83, 0x95, 0xcb, 0x8f, 0x4a, 0xb3, 0x98, 0x6c, 0x00, 0xe9, 0xd4, 0x3a,
      0x0d, 0xb6, 0x78, 0xcf, 0x1c, 0xd3, 0xf1, 0x30, 0xe9, 0x56, 0x69, 0xee,
      0x31, 0x60, 0xda, 0x36, 0xb9, 0x9e, 0xae, 0x93, 0x88, 0xa2, 0x40, 0x79,
      0x32, 0x6e, 0x0c, 0x3e, 0x87, 0xee, 0xb7, 0xfe, 0xd2, 0xad, 0x44, 0x4e,
      0x1b, 0x66, 0xd3, 0x07, 0x2f, 0x05, 0x71, 0x67, 0xee, 0x96, 0x7e, 0x9d,
      0xd0, 0x8d, 0xec, 0x18, 0x3c, 0x4b, 0xd5, 0x5b, 0x07, 0x28, 0x0f, 0x74,
      0xbe, 0x43, 0x44, 0x5a, 0x19, 0xaa, 0x06, 0x59, 0xf7, 0x8f, 0xab, 0xcf,
      0x56, 0xe4, 0xbb, 0xcf, 0x39, 0x27, 0xe3, 0x08, 0xef, 0x77, 0x3e, 0xa6,
      0x32, 0x4e, 0x5b, 0x23, 0xfd, 0xb4, 0x6b, 0x08, 0x05, 0x7a, 0x1a, 0x63,
      0x27, 0x2b, 0x9c, 0x29, 0xa0, 0xd0, 0xed, 0x59, 0xd4, 0x77, 0x8a, 0xd7,
      0xcf, 0x2b, 0xa5, 0x76, 0xec, 0x19, 0xd3, 0xd8, 0x1c, 0x86, 0x9c, 0xf7,
      0x62, 0xd0, 0x42, 0x60, 0xef, 0x80, 0x5a, 0x35, 0x05, 0x5d, 0x90, 0x13,
      0xb3, 0x27, 0x01, 0x3d, 0xa7, 0xa8, 0x98, 0xb6, 0x68, 0x42, 0x75, 0xdb,
      0xe5, 0x05, 0x7b, 0x83, 0x3d, 0x73, 0x8c, 0xda, 0x3f, 0x01, 0x8c, 0x10,
      0x0d, 0x63, 0x84, 0x89, 0x59, 0xe1, 0x54, 0x92, 0xfa, 0xde, 0x26, 0x37,
      0x8f, 0x4b, 0x39, 0xbe, 0xd4, 0xbd, 0x56, 0x25, 0x9e, 0xa8, 0xdf, 0x02,
      0x3f, 0x2c, 0x63, 0x01, 0x4f, 0xad, 0x63, 0x48, 0x06, 0xf6, 0xa6, 0x50,
      0xb5, 0xe6, 0x8f, 0xb3, 0x5f, 0x6c, 0xaf, 0x19, 0x8e, 0xd0, 0x9d, 0xed,
      0xcf, 0xba, 0x9d, 0xa4},
     pub_key_1,
     {0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39},
     true},

    // Comment:
    // tcID: 37
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     37,
     0,
     {0x23, 0xb5, 0xe6, 0xdc, 0x26, 0xe1, 0x0e, 0x99, 0xbf, 0x04, 0x05, 0xb8,
      0x43, 0x47, 0xe1, 0xcb, 0xbb, 0x6a, 0xf4, 0xa8, 0xd0, 0x02, 0x5d, 0x03,
      0x13, 0x56, 0x1c, 0x72, 0x6d, 0xe0, 0x26, 0x8f, 0xfe, 0x4f, 0xf7, 0xb2,
      0xe2, 0x0a, 0x96, 0xe4, 0xbd, 0x69, 0x95, 0x83, 0x28, 0x1a, 0xae, 0xb1,
      0x0b, 0x59, 0x2e, 0x20, 0x7e, 0x1c, 0xc5, 0xd8, 0xfb, 0x7d, 0x5c, 0x2c,
      0x1d, 0x8f, 0x03, 0x44, 0x67, 0xca, 0x09, 0x0e, 0xc4, 0x88, 0x5e, 0x0a,
      0x1b, 0x09, 0xde, 0xa6, 0x1a, 0x12, 0x9c, 0x96, 0x74, 0x50, 0xcd, 0xb5,
      0x98, 0x4a, 0xc5, 0xdb, 0xc8, 0x52, 0x89, 0x3a, 0xfd, 0xf3, 0x33, 0xb5,
      0x22, 0x7d, 0xf2, 0xf0, 0x23, 0xf3, 0x7f, 0x31, 0x0f, 0x13, 0xdd, 0x73,
      0xec, 0xb9, 0xc8, 0x64, 0xcc, 0xba, 0x1c, 0x93, 0xf6, 0xb7, 0xc4, 0x93,
      0x4f, 0xd8, 0x17, 0xe2, 0x6f, 0xc2, 0xcd, 0x60, 0x7d, 0xfc, 0xc6, 0x61,
      0x8b, 0x41, 0xcc, 0x57, 0x16, 0x03, 0xaa, 0x26, 0xdd, 0x4f, 0xc1, 0x80,
      0xd5, 0xb3, 0xae, 0x91, 0x54, 0x18, 0xd3, 0x5d, 0x64, 0x76, 0xdd, 0x34,
      0xd4, 0x61, 0x2f, 0x50, 0xcc, 0xa2, 0x49, 0xff, 0x66, 0x1f, 0xc5, 0xa2,
      0xbc, 0xd0, 0x9a, 0x80, 0x6d, 0xa0, 0xff, 0x04, 0x63, 0x48, 0x9f, 0xc0,
      0xfa, 0xc1, 0x0c, 0xdd, 0x41, 0xd4, 0x24, 0x37, 0x66, 0x58, 0x4a, 0xe3,
      0x8e, 0x99, 0xc6, 0x8e, 0x9a, 0xbf, 0xfe, 0x36, 0x28, 0x94, 0xcf, 0x5a,
      0xb1, 0x01, 0x00, 0xdd, 0x31, 0x71, 0xc6, 0xcf, 0x63, 0xd9, 0x3d, 0xa5,
      0xf8, 0xf6, 0xf7, 0xd3, 0x87, 0x7c, 0xeb, 0xe6, 0x4f, 0x3a, 0xfa, 0x8b,
      0xfe, 0x78, 0xf4, 0x43, 0x6b, 0x83, 0xf8, 0xb8, 0x45, 0xff, 0xd9, 0x4f,
      0x99, 0x80, 0xd5, 0x8a, 0x74, 0x38, 0x56, 0xb6, 0xef, 0xdd, 0xbb, 0xeb,
      0xab, 0xd3, 0x1d, 0x9e},
     pub_key_1,
     {0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32},
     true},

    // Comment:
    // tcID: 38
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     38,
     0,
     {0x9f, 0x8a, 0x9a, 0xbd, 0x11, 0x9e, 0x44, 0x26, 0x10, 0x97, 0xa7, 0xfb,
      0x12, 0x0f, 0xa7, 0xed, 0xfb, 0x77, 0x41, 0x8a, 0xa3, 0xa5, 0x49, 0x8a,
      0xbe, 0xaf, 0x17, 0xe2, 0x45, 0x3e, 0x8b, 0xe2, 0x6a, 0x81, 0x4e, 0x7c,
      0xc1, 0xa2, 0x76, 0xa3, 0x51, 0xae, 0x00, 0x2a, 0xc8, 0x74, 0x6f, 0x63,
      0x0f, 0x7d, 0xa9, 0x45, 0x9d, 0x3f, 0xa4, 0x17, 0x8f, 0x8e, 0xc9, 0x75,
      0x6f, 0xa6, 0xde, 0xbd, 0xf4, 0xd5, 0x58, 0x14, 0xbc, 0xe8, 0xf8, 0x4e,
      0xab, 0x38, 0xdf, 0xa0, 0xc9, 0x8f, 0x81, 0x44, 0x88, 0x00, 0x75, 0x5d,
      0x08, 0xc3, 0xb9, 0x69, 0x1e, 0x83, 0x7a, 0x2a, 0xa0, 0x52, 0xb5, 0xca,
      0x41, 0x2e, 0x2b, 0xb8, 0x15, 0x6e, 0x4a, 0x3a, 0xca, 0x3d, 0x35, 0xc9,
      0xbd, 0x44, 0x7d, 0x6b, 0x5b, 0x53, 0x29, 0x05, 0xc6, 0x0e, 0x70, 0xdd,
      0x65, 0xf6, 0xc7, 0x9a, 0x28, 0xf2, 0x36, 0xe3, 0xa0, 0xcb, 0xe4, 0xf7,
      0x34, 0xb2, 0xa3, 0xb2, 0x2f, 0xb7, 0x33, 0xe4, 0x50, 0x38, 0x82, 0x0e,
      0x08, 0x7b, 0xdd, 0x42, 0x9b, 0x5b, 0x54, 0xb8, 0x4a, 0x6d, 0x12, 0x10,
      0x78, 0x8b, 0xb5, 0x58, 0xf0, 0x32, 0x5e, 0xcf, 0x8a, 0xb7, 0xf4, 0x64,
      0x1b, 0xff, 0x09, 0x56, 0x4f, 0x06, 0xaf, 0x6d, 0x79, 0x2d, 0xf9, 0x88,
      0x69, 0x95, 0x50, 0xd3, 0x5f, 0x21, 0x97, 0xb4, 0xbd, 0x7c, 0xb7, 0xea,
      0xea, 0x64, 0x34, 0x1c, 0xe8, 0x23, 0x91, 0xab, 0x87, 0x98, 0xc1, 0xef,
      0x6b, 0xe8, 0xa7, 0xed, 0x8f, 0x2e, 0x1d, 0xca, 0xa3, 0x31, 0xda, 0x28,
      0x44, 0xc0, 0x6e, 0x3e, 0x05, 0x6a, 0xd0, 0xba, 0x22, 0xc4, 0x72, 0x4e,
      0xa7, 0x92, 0x9f, 0x57, 0x27, 0x4f, 0xe5, 0xa2, 0xc4, 0x62, 0x78, 0x0b,
      0x19, 0x0d, 0x54, 0x04, 0xc6, 0x8c, 0x82, 0x3b, 0xa2, 0x33, 0xae, 0x35,
      0x02, 0x6a, 0x6e, 0x72},
     pub_key_1,
     {0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35},
     true},

    // Comment:
    // tcID: 39
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     39,
     0,
     {0x22, 0x7f, 0xb4, 0x2c, 0xb5, 0xc3, 0xd8, 0x8b, 0x8b, 0x71, 0xd1, 0xa6,
      0x52, 0x2b, 0xc5, 0xf8, 0x24, 0xb2, 0x50, 0x7d, 0x29, 0x98, 0xa9, 0x4b,
      0x9b, 0x97, 0x2c, 0xab, 0xe4, 0xab, 0x46, 0xeb, 0x47, 0xcd, 0x10, 0x6f,
      0x79, 0xc1, 0x7d, 0x4a, 0x0c, 0x59, 0xc7, 0xb7, 0x4b, 0x5b, 0x3d, 0x03,
      0x18, 0x0c, 0xe1, 0x55, 0xa8, 0xbb, 0x09, 0x20, 0xe9, 0x87, 0xfd, 0x2b,
      0xbd, 0xd6, 0x4d, 0x91, 0xff, 0x3f, 0x57, 0xb5, 0xdf, 0xbe, 0x57, 0xf3,
      0x98, 0x9c, 0xe4, 0xaa, 0x9d, 0x9e, 0x3e, 0xfa, 0xfc, 0x50, 0x1c, 0x44,
      0x37, 0xa0, 0xb1, 0x4e, 0x29, 0x83, 0x26, 0x2a, 0x61, 0xb1, 0x5a, 0x10,
      0x00, 0x88, 0x8e, 0xe1, 0x48, 0x2b, 0xee, 0x4a, 0x1e, 0x6a, 0xfc, 0x92,
      0xbe, 0xd1, 0x7f, 0x35, 0xa3, 0x2d, 0xf6, 0x7f, 0xad, 0x28, 0x97, 0x97,
      0x75, 0xcf, 0x0c, 0x1e, 0xdd, 0xe0, 0x06, 0x91, 0x95, 0x66, 0xcf, 0xdc,
      0x36, 0x57, 0xc9, 0xad, 0x2a, 0x82, 0xd2, 0xe6, 0x8a, 0x11, 0xe2, 0x3f,
      0x01, 0xf4, 0xd8, 0xfa, 0xff, 0x87, 0x3f, 0x5b, 0xd1, 0x60, 0x9e, 0x3b,
      0x90, 0x1a, 0xe1, 0x3f, 0x8a, 0x59, 0x9d, 0x42, 0xd2, 0xfb, 0x5a, 0xc9,
      0xf9, 0x70, 0x7d, 0x73, 0x09, 0x21, 0xc5, 0x98, 0x1c, 0xaf, 0xaa, 0xed,
      0x86, 0xd3, 0x70, 0xbd, 0xc7, 0x58, 0x5b, 0xae, 0x3e, 0xa4, 0x00, 0x2c,
      0x50, 0xc9, 0x6b, 0x19, 0x52, 0x83, 0x59, 0x2c, 0x5d, 0x57, 0x7c, 0x53,
      0x62, 0x7d, 0x94, 0x6a, 0xfa, 0x48, 0xd1, 0x0e, 0x8c, 0x89, 0x43, 0x2f,
      0x50, 0x21, 0x0f, 0x8e, 0x0c, 0x99, 0xa2, 0x3e, 0xb0, 0x89, 0x55, 0x93,
      0x90, 0xdf, 0xeb, 0x47, 0x2d, 0xb7, 0x40, 0xe2, 0x7c, 0xa2, 0x55, 0xf0,
      0x76, 0x4c, 0x7a, 0x57, 0x5d, 0x39, 0x09, 0xc2, 0x43, 0x08, 0xf1, 0x87,
      0xbd, 0xe9, 0x0f, 0xea},
     pub_key_1,
     {0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37},
     true},

    // Comment:
    // tcID: 40
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     40,
     0,
     {0x49, 0xb8, 0xd3, 0x5a, 0xc6, 0x09, 0x3b, 0xd9, 0xd5, 0x3d, 0x5a, 0xcf,
      0x6a, 0xf1, 0xa2, 0xf2, 0x94, 0xc1, 0x3b, 0x00, 0x72, 0x56, 0x49, 0x31,
      0xb8, 0xe6, 0x9e, 0x11, 0xd7, 0xfb, 0xcc, 0x7c, 0xce, 0xa4, 0x4f, 0x5e,
      0x52, 0xf2, 0x8b, 0x63, 0xb0, 0x9d, 0xed, 0xdd, 0xd5, 0x76, 0x65, 0x15,
      0xee, 0xd3, 0xed, 0x3d, 0x59, 0x54, 0x24, 0xe7, 0x08, 0x46, 0xba, 0x96,
      0xb9, 0xbd, 0x12, 0x78, 0x17, 0x15, 0xac, 0x7c, 0x40, 0x5a, 0xcf, 0x97,
      0xa8, 0xa7, 0x35, 0xc8, 0xa9, 0xd2, 0x74, 0xb6, 0x6a, 0x54, 0xf2, 0xa2,
      0x41, 0x38, 0xfd, 0x90, 0x06, 0xb2, 0xb5, 0x23, 0xd1, 0x5f, 0x7d, 0x4b,
      0xb4, 0x58, 0x52, 0xee, 0x06, 0x28, 0x58, 0x48, 0x17, 0xc3, 0x21, 0x1d,
      0xe2, 0xe6, 0x28, 0x11, 0xe0, 0x3f, 0x15, 0x06, 0x0c, 0x1c, 0xdc, 0x5f,
      0x6f, 0x7e, 0x0e, 0xda, 0xe7, 0x85, 0x70, 0xa5, 0x3d, 0x04, 0xe3, 0x79,
      0x96, 0x33, 0xf8, 0xe7, 0xbc, 0x99, 0xa2, 0x4d, 0x32, 0xf3, 0x07, 0x96,
      0x3c, 0xce, 0x9e, 0x9f, 0x5e, 0x6d, 0x22, 0x34, 0xa9, 0xdd, 0x9a, 0x8b,
      0xaa, 0x39, 0xd9, 0x05, 0x8d, 0x4f, 0x9b, 0x75, 0x09, 0xae, 0x7e, 0xaa,
      0x77, 0x6d, 0x73, 0x4d, 0xa7, 0xcb, 0x7a, 0xd5, 0x14, 0x8b, 0x2a, 0x06,
      0x99, 0x50, 0x40, 0x5f, 0x0f, 0x22, 0x54, 0xd4, 0x7e, 0x9e, 0x70, 0x3a,
      0x40, 0xcd, 0x51, 0x79, 0x14, 0xbf, 0xfb, 0x38, 0xfd, 0x00, 0xf4, 0x87,
      0x30, 0x56, 0xdf, 0x33, 0xed, 0x50, 0x22, 0xea, 0x01, 0x15, 0xbf, 0xab,
      0xc7, 0x66, 0xc5, 0xec, 0x8d, 0x5b, 0xbc, 0xac, 0x2a, 0x4c, 0x70, 0x81,
      0xe5, 0x96, 0x0b, 0xf1, 0xeb, 0x36, 0x4d, 0x8c, 0xbc, 0xeb, 0xac, 0x11,
      0x86, 0x6e, 0x5e, 0x7d, 0x1d, 0xab, 0x2d, 0x0f, 0xb1, 0x8e, 0x46, 0x52,
      0x6a, 0x44, 0x52, 0xf8},
     pub_key_1,
     {0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31},
     true},

    // Comment:
    // tcID: 41
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     41,
     0,
     {0x2f, 0xe9, 0x09, 0x88, 0xf9, 0xe8, 0x8d, 0x1c, 0xac, 0xc4, 0xc6, 0xcd,
      0x25, 0x94, 0xc0, 0xd9, 0xb0, 0x25, 0x13, 0xae, 0xfa, 0x1c, 0x82, 0x15,
      0x5b, 0xd7, 0xec, 0x58, 0xe0, 0x86, 0xb3, 0xd8, 0x08, 0xb8, 0x85, 0x41,
      0x19, 0x62, 0x3f, 0x17, 0x90, 0x54, 0x45, 0xdc, 0xe9, 0xa0, 0x00, 0xf0,
      0x1b, 0x1e, 0xf7, 0x97, 0x3d, 0xb1, 0xf9, 0x18, 0x14, 0xa2, 0x91, 0x19,
      0xeb, 0x74, 0x4d, 0x51, 0xff, 0x94, 0x3f, 0x55, 0x41, 0xb0, 0xfd, 0x0a,
      0x28, 0xe2, 0xf7, 0x1d, 0x4d, 0xbd, 0x75, 0x9c, 0xd2, 0x8f, 0x33, 0x21,
      0x32, 0x5e, 0xa0, 0x32, 0x7c, 0x19, 0x35, 0x6b, 0xb5, 0x76, 0xf3, 0xb2,
      0x11, 0xf7, 0x99, 0x69, 0xfa, 0x1b, 0xb1, 0xfa, 0xf3, 0x33, 0xda, 0x12,
      0xf2, 0xf8, 0x29, 0x70, 0x30, 0xd6, 0xf2, 0x68, 0xee, 0xb0, 0x32, 0x02,
      0x99, 0x41, 0x9d, 0x02, 0xaf, 0xe8, 0xb4, 0x55, 0xed, 0xf7, 0xb1, 0x16,
      0x91, 0xed, 0x99, 0xb9, 0x80, 0x00, 0x14, 0xaa, 0xd9, 0x4a, 0xe8, 0x74,
      0x78, 0x07, 0x7c, 0x35, 0xe8, 0x23, 0xf4, 0x1a, 0x22, 0xf2, 0x85, 0xd6,
      0xcf, 0x57, 0x5d, 0x1b, 0xd4, 0x09, 0xa8, 0xaf, 0x55, 0x6c, 0x1a, 0xdd,
      0xdc, 0x58, 0x1c, 0xf3, 0xb9, 0x3c, 0x7c, 0x16, 0x17, 0x62, 0xe8, 0x6b,
      0x00, 0x6a, 0x3d, 0x08, 0x31, 0x5c, 0xcc, 0x52, 0xb2, 0x05, 0xb6, 0xdf,
      0xdd, 0xc4, 0xb2, 0xc0, 0x63, 0x15, 0x29, 0xbd, 0xae, 0x65, 0xc6, 0x3f,
      0xad, 0x31, 0xa0, 0x0a, 0xe9, 0x92, 0x3e, 0x48, 0xe9, 0xe9, 0x62, 0x13,
      0xc7, 0x3a, 0xfb, 0xeb, 0x53, 0xb9, 0x00, 0x5d, 0x42, 0xf9, 0xfe, 0xb7,
      0x3f, 0x28, 0x8e, 0x2a, 0xb9, 0x18, 0x84, 0x02, 0x0b, 0xa8, 0xd1, 0x98,
      0xa9, 0x31, 0x0b, 0x88, 0x80, 0xc9, 0x12, 0xdc, 0xe2, 0x90, 0x83, 0xef,
      0xe6, 0xd6, 0xe3, 0x61},
     pub_key_1,
     {0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33},
     true},

    // Comment:
    // tcID: 42
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     42,
     0,
     {0x43, 0x48, 0xae, 0x89, 0xc8, 0xe5, 0xd0, 0x3f, 0xb9, 0x4d, 0x2a, 0x8a,
      0x63, 0xa6, 0x57, 0x7f, 0x7c, 0xa1, 0x0e, 0x7d, 0x53, 0xe4, 0x89, 0x8e,
      0x1c, 0xab, 0xc0, 0xee, 0x96, 0xa1, 0xc7, 0xeb, 0x84, 0x1b, 0x98, 0x46,
      0x17, 0x32, 0x1f, 0xb0, 0x5b, 0x81, 0x2a, 0x17, 0x12, 0x4f, 0x31, 0x1c,
      0x91, 0xcc, 0xb9, 0x48, 0x76, 0x57, 0x13, 0xfc, 0x5f, 0xef, 0x61, 0xf6,
      0x0f, 0x6d, 0xfe, 0x3b, 0xc1, 0x5d, 0x1d, 0x93, 0x77, 0x63, 0xc1, 0xf8,
      0x7b, 0x38, 0x99, 0x75, 0x2f, 0x47, 0x33, 0xb6, 0xb7, 0x40, 0xaf, 0x33,
      0x40, 0xea, 0x04, 0x15, 0xd4, 0x1d, 0xba, 0x82, 0x19, 0x1f, 0x9a, 0xf1,
      0xcb, 0xa3, 0x18, 0x9e, 0x72, 0xc0, 0xba, 0x44, 0xdd, 0xa4, 0x7e, 0xdb,
      0x6d, 0xff, 0x3a, 0xc6, 0xde, 0x21, 0x58, 0x6b, 0x15, 0x35, 0x3b, 0x54,
      0xf1, 0xb2, 0xb2, 0x28, 0x1c, 0x98, 0xb2, 0x33, 0x4e, 0x39, 0xef, 0x48,
      0x69, 0x1d, 0xdd, 0x4f, 0x1b, 0x67, 0xc0, 0x6f, 0x24, 0xf2, 0x2d, 0xfd,
      0x08, 0x86, 0x5e, 0xf3, 0xfc, 0xa3, 0x3e, 0xc4, 0xe1, 0x13, 0xa2, 0x04,
      0xe3, 0x49, 0x82, 0x2f, 0x2b, 0x4f, 0xf5, 0x12, 0xe4, 0xf1, 0x1c, 0xf0,
      0x11, 0xff, 0x8b, 0x6d, 0xbf, 0x3a, 0xb5, 0xcc, 0xe1, 0xd9, 0x0d, 0xcb,
      0xdb, 0x91, 0xd1, 0x3f, 0x77, 0xed, 0xb9, 0xbf, 0xfc, 0x65, 0x0f, 0x5f,
      0x42, 0xca, 0x1e, 0xae, 0x85, 0x5a, 0x2f, 0x2f, 0xa9, 0xa4, 0x16, 0x89,
      0x97, 0x52, 0x2b, 0xea, 0x76, 0x71, 0xa5, 0x5d, 0x56, 0x75, 0x0b, 0x78,
      0xf9, 0xf6, 0x6a, 0x2d, 0x72, 0x60, 0x77, 0x22, 0x75, 0x3f, 0xb9, 0x98,
      0x7a, 0xcf, 0x43, 0xb0, 0xe6, 0x60, 0x21, 0x58, 0x0c, 0x79, 0xc5, 0xa6,
      0x21, 0xd9, 0x6d, 0x9e, 0xbe, 0x8d, 0x24, 0xed, 0x90, 0x58, 0xa6, 0x7e,
      0x27, 0x51, 0x9a, 0xb8},
     pub_key_1,
     {0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 43
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     43,
     0,
     {0x07, 0x4d, 0x9b, 0xb6, 0x85, 0x8d, 0xde, 0xc8, 0x81, 0x6b, 0xea, 0xcb,
      0xf7, 0x58, 0xb0, 0x02, 0x26, 0x86, 0x3d, 0x1c, 0x52, 0x00, 0x18, 0x8d,
      0xeb, 0xef, 0xd6, 0xda, 0x12, 0xb6, 0xe7, 0xbe, 0x8e, 0x30, 0x08, 0x5d,
      0x91, 0x3d, 0x87, 0x42, 0xf1, 0x21, 0x50, 0x75, 0x63, 0x9d, 0x93, 0x0c,
      0xf1, 0x67, 0x1c, 0xce, 0x3c, 0x34, 0x4c, 0xf9, 0x15, 0xda, 0x8d, 0xc8,
      0xb8, 0xaa, 0x46, 0xbb, 0x75, 0x38, 0x27, 0xbe, 0x2d, 0x4e, 0x2e, 0x76,
      0x62, 0xd2, 0x66, 0xc9, 0x1b, 0xdc, 0xd4, 0x66, 0x7d, 0x28, 0xcc, 0xbc,
      0xd7, 0xbd, 0xe9, 0x0a, 0x4b, 0xad, 0xa2, 0xa2, 0x29, 0x6f, 0x0d, 0x58,
      0x82, 0xef, 0x9c, 0x8e, 0x49, 0x2e, 0xb9, 0x47, 0x07, 0xd0, 0xfb, 0x39,
      0x4f, 0x08, 0xdb, 0xd0, 0xb7, 0x17, 0x7b, 0x75, 0x6b, 0xd6, 0x7d, 0x19,
      0x1c, 0xa2, 0x4d, 0xd0, 0x2c, 0x10, 0x15, 0x6b, 0x5a, 0x45, 0x6f, 0x37,
      0x0e, 0x74, 0x5d, 0x84, 0x0b, 0xa4, 0x12, 0x13, 0x65, 0x03, 0xaa, 0x9b,
      0x4f, 0xfd, 0x38, 0x7a, 0xa7, 0x91, 0xf0, 0xb5, 0x66, 0xd6, 0xca, 0xd8,
      0x8e, 0x7e, 0x80, 0x3d, 0x9b, 0x0b, 0xeb, 0x83, 0x70, 0x8c, 0xbe, 0x56,
      0x07, 0xc1, 0x65, 0x00, 0x72, 0xb4, 0xbb, 0x4d, 0x5a, 0xce, 0xd0, 0x07,
      0xef, 0xb0, 0xfa, 0x89, 0x2c, 0x79, 0x53, 0x4f, 0x7a, 0x38, 0x00, 0x0d,
      0xfa, 0xae, 0xde, 0xb0, 0x55, 0xe3, 0x9b, 0xe7, 0xe1, 0x7e, 0x59, 0x3b,
      0x77, 0x3d, 0xcc, 0x4b, 0x44, 0xb3, 0x76, 0x12, 0xf9, 0xa6, 0x39, 0xa6,
      0xb9, 0x4c, 0xed, 0x87, 0xf8, 0xc7, 0xa5, 0x23, 0x14, 0xfa, 0xe9, 0x7c,
      0x7e, 0x82, 0x13, 0xfc, 0x56, 0x17, 0x7f, 0x9b, 0x8b, 0x31, 0x11, 0xfd,
      0x4e, 0x74, 0x57, 0x48, 0x2f, 0xb5, 0xb8, 0xa9, 0xec, 0xda, 0x0e, 0x00,
      0xf7, 0xb9, 0x46, 0x14},
     pub_key_1,
     {0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38},
     true},

    // Comment:
    // tcID: 44
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     44,
     0,
     {0x9e, 0x04, 0x80, 0x4c, 0xb3, 0x16, 0xa4, 0x1d, 0x33, 0x0e, 0x38, 0x1a,
      0xae, 0x55, 0x5d, 0x86, 0x6c, 0xb1, 0xbe, 0x35, 0x56, 0x00, 0x4d, 0xb7,
      0x2e, 0xb4, 0xa1, 0x1d, 0x11, 0xda, 0x11, 0x06, 0x0f, 0x7e, 0xe7, 0xdd,
      0xb0, 0xc4, 0x5b, 0x12, 0x06, 0xd5, 0x0a, 0xd2, 0x23, 0x31, 0x41, 0xd2,
      0xfa, 0x6f, 0xc1, 0x90, 0xc0, 0x9c, 0x92, 0xa5, 0xbe, 0x6e, 0x97, 0x79,
      0x42, 0xe2, 0xa4, 0xf9, 0x74, 0x0e, 0xd6, 0x7d, 0xc9, 0xea, 0x9e, 0x76,
      0x7f, 0x73, 0x69, 0x0c, 0x90, 0x80, 0x17, 0x73, 0x6d, 0x4f, 0xea, 0x0a,
      0xd1, 0x23, 0xfa, 0x4f, 0x9f, 0xe8, 0x4d, 0x56, 0x72, 0xdb, 0xaa, 0x5f,
      0xdf, 0x75, 0x81, 0x05, 0x30, 0x87, 0x09, 0xf4, 0xc3, 0xa3, 0x95, 0x43,
      0x3e, 0x99, 0x4a, 0xf2, 0x89, 0x04, 0x15, 0xe6, 0x07, 0x73, 0xe1, 0x66,
      0xb4, 0xc1, 0x52, 0x97, 0x81, 0x54, 0x8f, 0x1b, 0xaa, 0x7b, 0x82, 0x34,
      0x08, 0x79, 0x48, 0x0a, 0x06, 0x6c, 0x3f, 0xce, 0xaa, 0xbe, 0xc9, 0xcc,
      0xf6, 0x68, 0x79, 0xce, 0x33, 0x65, 0xf9, 0xb9, 0xc0, 0x4e, 0xe2, 0xf8,
      0x5b, 0xa0, 0x8d, 0x6e, 0x39, 0xff, 0xae, 0xee, 0xe2, 0xc4, 0x58, 0x34,
      0xb6, 0xd7, 0xe1, 0x6d, 0x94, 0x2d, 0xba, 0xe4, 0x5b, 0xc2, 0x2f, 0xf7,
      0xea, 0xdb, 0x3d, 0x91, 0x7c, 0x4d, 0xb5, 0xf8, 0x46, 0x2e, 0x8e, 0x6e,
      0x61, 0x8f, 0x1e, 0x84, 0xd1, 0x6e, 0xb4, 0x36, 0xd4, 0xac, 0x4d, 0x07,
      0xf1, 0x02, 0x6e, 0xd7, 0x5d, 0x70, 0xd2, 0xba, 0x03, 0x32, 0xb9, 0xc2,
      0x13, 0x82, 0xf8, 0x6a, 0x7a, 0x9c, 0xa7, 0x02, 0xe8, 0x55, 0xe4, 0x8a,
      0x44, 0xfa, 0x65, 0xbb, 0xdc, 0x7e, 0xf5, 0xc8, 0x76, 0x02, 0x30, 0xa2,
      0x10, 0x2c, 0x6f, 0x95, 0x1c, 0x63, 0x9e, 0xc8, 0x24, 0x92, 0x12, 0x9d,
      0x81, 0x0f, 0x62, 0x61},
     pub_key_1,
     {0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34},
     true},

    // Comment:
    // tcID: 45
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     45,
     0,
     {0x98, 0xf3, 0x53, 0xe2, 0xfb, 0x80, 0xca, 0x88, 0x41, 0x38, 0xd7, 0xcb,
      0xfd, 0x82, 0x43, 0x23, 0x82, 0x72, 0xd4, 0x1c, 0xd3, 0xd2, 0x09, 0x10,
      0x4f, 0x5c, 0x5c, 0x40, 0xb4, 0x98, 0x20, 0x4f, 0xd7, 0x31, 0xee, 0xbc,
      0x0f, 0x47, 0x06, 0xe3, 0xe2, 0x2f, 0x16, 0x5a, 0x5c, 0x98, 0x9b, 0xf0,
      0xd0, 0xd2, 0xda, 0xee, 0x6f, 0xdf, 0xca, 0x4e, 0x59, 0x9f, 0x35, 0x55,
      0x09, 0x98, 0x2d, 0x98, 0x8d, 0xd3, 0x06, 0x1b, 0x1c, 0x13, 0xd6, 0x12,
      0xc0, 0x03, 0xdb, 0x6f, 0x56, 0x2a, 0x68, 0xdd, 0x7c, 0xb7, 0xfe, 0x7d,
      0xea, 0x74, 0xa1, 0x94, 0x34, 0xdb, 0x03, 0xda, 0x48, 0xca, 0x84, 0xa8,
      0xaf, 0x51, 0xef, 0x34, 0x04, 0x4c, 0x86, 0xac, 0x04, 0x45, 0x87, 0x1c,
      0xaa, 0xf6, 0x45, 0x47, 0x04, 0x60, 0xa1, 0x56, 0x20, 0x06, 0x7a, 0x0a,
      0x8e, 0x82, 0x1e, 0xa7, 0xb5, 0x0e, 0x66, 0x31, 0x78, 0x4e, 0xdb, 0x2f,
      0xe8, 0x84, 0xf1, 0x6b, 0x3e, 0xe5, 0x0e, 0xba, 0x2d, 0x81, 0x56, 0x44,
      0x74, 0x4c, 0x9b, 0x29, 0x2c, 0x51, 0x07, 0xca, 0x27, 0x69, 0x00, 0x4d,
      0xbf, 0x4b, 0x42, 0xeb, 0x7d, 0x73, 0x8b, 0x9b, 0xf2, 0x24, 0x1c, 0x07,
      0x39, 0xf1, 0x59, 0x79, 0xa7, 0x1a, 0xd6, 0x93, 0x5e, 0xe7, 0xdd, 0xd3,
      0xd7, 0x75, 0xb7, 0x66, 0x15, 0x13, 0xc7, 0x76, 0x1a, 0xe4, 0x48, 0xff,
      0xc3, 0xfc, 0x28, 0x70, 0x77, 0xd0, 0x11, 0x78, 0x15, 0xb3, 0xd5, 0x78,
      0x90, 0xac, 0x37, 0xb8, 0x7c, 0x97, 0x2e, 0x32, 0xbc, 0x0f, 0x75, 0x92,
      0x14, 0xd2, 0x73, 0x9c, 0x4b, 0xe9, 0x30, 0x7f, 0x25, 0x1a, 0x4f, 0x30,
      0x27, 0xa8, 0xdb, 0xb7, 0xe3, 0xf9, 0x35, 0x4b, 0x26, 0xeb, 0x98, 0x14,
      0x5d, 0xe8, 0x1e, 0xa8, 0xe2, 0x3a, 0xed, 0x40, 0x1f, 0x31, 0x5c, 0xc5,
      0x02, 0x27, 0xb5, 0xfb},
     pub_key_1,
     {0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33},
     true},

    // Comment:
    // tcID: 46
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     46,
     0,
     {0x47, 0x82, 0x85, 0x8a, 0x9e, 0x77, 0xc7, 0x10, 0x92, 0x9f, 0x71, 0xaf,
      0x2b, 0x01, 0x99, 0x00, 0x2f, 0xee, 0x97, 0x95, 0x16, 0x1e, 0xc8, 0xce,
      0xc4, 0x49, 0xd3, 0xb1, 0x59, 0x9a, 0x5b, 0x02, 0x35, 0xe0, 0x79, 0xfc,
      0x4c, 0x73, 0xab, 0x09, 0xfe, 0x65, 0x87, 0x52, 0x50, 0x63, 0x8f, 0x0d,
      0x07, 0x5a, 0xca, 0xbd, 0x10, 0x42, 0xee, 0x9f, 0x51, 0xe6, 0x6b, 0xdb,
      0x15, 0x66, 0x2a, 0x83, 0x28, 0x58, 0x3f, 0xfb, 0x73, 0xf3, 0xb7, 0xf1,
      0x5e, 0xfd, 0xe5, 0x39, 0xbe, 0xf8, 0x11, 0xec, 0xea, 0x95, 0xd1, 0x6c,
      0xac, 0x91, 0xf3, 0x0f, 0x80, 0x50, 0x6d, 0x68, 0xc9, 0x4c, 0xba, 0xb5,
      0xb1, 0x07, 0x00, 0x50, 0x16, 0x8a, 0x96, 0x72, 0x1c, 0x97, 0x09, 0xdc,
      0x8c, 0xab, 0xf8, 0x5c, 0xa3, 0xd7, 0x2a, 0x9d, 0x3c, 0x5e, 0xd8, 0x7b,
      0x46, 0x17, 0xeb, 0x24, 0x5b, 0xc3, 0x48, 0x99, 0xe8, 0x6b, 0x60, 0xd2,
      0x94, 0xfc, 0x42, 0x8e, 0xea, 0xf1, 0xf8, 0x6c, 0x54, 0x74, 0xa9, 0xe2,
      0x7d, 0x7a, 0x9a, 0xd4, 0x58, 0x88, 0x65, 0x57, 0x4f, 0x1b, 0x71, 0xb1,
      0xd8, 0xae, 0x66, 0x55, 0xba, 0xba, 0x63, 0xa4, 0xe5, 0x79, 0xde, 0xec,
      0x9e, 0xa1, 0xee, 0xf1, 0x78, 0x7b, 0x42, 0x7d, 0x5f, 0x5b, 0x77, 0xb6,
      0x69, 0x73, 0x3b, 0xd6, 0xf7, 0xf0, 0x7e, 0xa4, 0x1d, 0x6f, 0x2c, 0x2c,
      0x04, 0x05, 0x89, 0xfb, 0xbd, 0x59, 0xbb, 0x0f, 0x39, 0xef, 0x6d, 0xaa,
      0xa2, 0x84, 0x30, 0xc1, 0x8e, 0x64, 0xd0, 0xac, 0xfd, 0xc0, 0x72, 0xbb,
      0xda, 0x93, 0x2d, 0xff, 0xaf, 0x38, 0xac, 0x4b, 0x49, 0x5d, 0xa1, 0xce,
      0xcc, 0x36, 0xca, 0x25, 0xdb, 0xaf, 0x06, 0xcb, 0xab, 0xde, 0xd8, 0x15,
      0xba, 0x6a, 0xa5, 0x5f, 0x04, 0xdb, 0x12, 0x68, 0x3b, 0xcc, 0x4c, 0x5f,
      0xcc, 0x5c, 0xe8, 0x75},
     pub_key_1,
     {0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37},
     true},

    // Comment:
    // tcID: 47
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     47,
     0,
     {0x25, 0x6f, 0x84, 0x2e, 0x0e, 0xa1, 0xdd, 0x3d, 0xd5, 0xcb, 0x05, 0xcb,
      0x18, 0x4c, 0xde, 0x79, 0xba, 0x34, 0xc8, 0x7f, 0x08, 0x3e, 0x21, 0x55,
      0x70, 0xb4, 0x02, 0xee, 0x92, 0x9a, 0x47, 0x04, 0x94, 0x27, 0xad, 0x56,
      0x8b, 0x30, 0xc0, 0x05, 0xef, 0x4f, 0x88, 0xfd, 0x51, 0x10, 0x96, 0xe2,
      0x34, 0x11, 0xe9, 0x27, 0xfd, 0x2a, 0xa8, 0x5a, 0x3e, 0xb6, 0xe0, 0x1d,
      0xee, 0x3e, 0x9f, 0xb5, 0x86, 0x5a, 0xbb, 0x46, 0x0e, 0xf7, 0x6f, 0xe8,
      0xd9, 0x32, 0xdc, 0x08, 0x94, 0x58, 0x24, 0x01, 0x1f, 0xd2, 0x26, 0x91,
      0x5e, 0xe3, 0x97, 0x74, 0x75, 0x66, 0x0d, 0x7f, 0x40, 0xb3, 0xcf, 0xab,
      0x3c, 0x9e, 0x7e, 0x90, 0xe3, 0x7f, 0xf8, 0x7d, 0x2d, 0xaa, 0x83, 0x4b,
      0xb3, 0x64, 0x5c, 0xd1, 0x83, 0x2f, 0x28, 0x33, 0xfe, 0xbb, 0x80, 0xa6,
      0x50, 0xcd, 0xe0, 0x07, 0xfa, 0x6c, 0x52, 0x32, 0xab, 0x5c, 0x9f, 0x0b,
      0xc8, 0x5d, 0x8c, 0x2f, 0xe3, 0x26, 0xef, 0x25, 0xca, 0x04, 0x0b, 0xf9,
      0x5a, 0x3e, 0x37, 0x34, 0xf1, 0x76, 0x49, 0x81, 0xfa, 0xa5, 0xba, 0xc8,
      0x7e, 0xc6, 0x4d, 0x9b, 0x3e, 0x4a, 0x98, 0x67, 0xe4, 0xd5, 0x5b, 0x31,
      0x31, 0x71, 0x74, 0x0e, 0x84, 0x13, 0xa5, 0xe4, 0x29, 0x7b, 0x20, 0x66,
      0x24, 0x28, 0x9f, 0x15, 0x32, 0xc9, 0xad, 0xdf, 0xe9, 0xf8, 0x85, 0xa6,
      0xa6, 0xca, 0xab, 0xd2, 0x53, 0xfd, 0xd3, 0x31, 0xe7, 0x62, 0xa8, 0x2c,
      0x97, 0x7b, 0xb2, 0x1c, 0x8e, 0x1e, 0x57, 0x02, 0xf7, 0x7e, 0xf0, 0xc2,
      0xf6, 0x92, 0x59, 0xe0, 0x02, 0x7c, 0x3a, 0x7d, 0x8c, 0x7c, 0x80, 0x34,
      0xfc, 0x24, 0xfb, 0xff, 0x14, 0xb5, 0x50, 0x28, 0x16, 0xf4, 0xd7, 0xfc,
      0xf1, 0xed, 0x75, 0x0d, 0x8b, 0xe2, 0x40, 0x51, 0x86, 0xaf, 0xe5, 0x4a,
      0xd9, 0xcd, 0x50, 0x30},
     pub_key_1,
     {0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36},
     true},

    // Comment:
    // tcID: 48
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     48,
     0,
     {0x62, 0xba, 0xb4, 0x02, 0xf2, 0x29, 0xe2, 0x6a, 0x53, 0x57, 0x05, 0x67,
      0x6f, 0xaa, 0x60, 0xd4, 0xcb, 0xd3, 0x84, 0x1d, 0x4f, 0x5f, 0xd3, 0x05,
      0x8e, 0x1d, 0x5c, 0x44, 0xa5, 0x00, 0xe8, 0x72, 0xf0, 0x03, 0x57, 0x47,
      0xcb, 0x5b, 0xc1, 0x2b, 0x97, 0x2f, 0x64, 0x01, 0xcd, 0xd1, 0xe2, 0x12,
      0xfd, 0x54, 0x0d, 0x45, 0xaa, 0x5f, 0xa5, 0x35, 0x14, 0x0c, 0x6b, 0xa7,
      0xf1, 0x65, 0x15, 0x4b, 0xa4, 0xb7, 0x71, 0xc1, 0xed, 0xd2, 0x7e, 0xba,
      0x09, 0x7a, 0xbe, 0xdd, 0x29, 0x47, 0x28, 0x44, 0x7c, 0x22, 0xed, 0x52,
      0x51, 0x8b, 0x1d, 0xd8, 0x72, 0x12, 0xea, 0xae, 0x44, 0x72, 0x4e, 0x25,
      0x05, 0x2a, 0xd4, 0xbf, 0xd0, 0x18, 0x5d, 0xe9, 0xed, 0xde, 0x00, 0x84,
      0xb0, 0xfd, 0x35, 0xcb, 0xb2, 0x26, 0xf5, 0x36, 0x61, 0xfc, 0x12, 0xa1,
      0x4f, 0x1b, 0x8e, 0x31, 0xfb, 0xf3, 0xdd, 0xcc, 0xc7, 0x24, 0x2f, 0xb5,
      0x69, 0x5d, 0x9a, 0xe8, 0x4a, 0xc1, 0x04, 0xc2, 0x9e, 0x39, 0x39, 0x11,
      0x03, 0xd1, 0x5c, 0x4c, 0xd8, 0xba, 0x24, 0x98, 0xe9, 0xca, 0x24, 0xa6,
      0x18, 0xdf, 0x21, 0xe7, 0xcd, 0xb9, 0x04, 0xd6, 0xde, 0x49, 0x54, 0x63,
      0x7b, 0x28, 0xea, 0xd7, 0x4a, 0x31, 0x57, 0x02, 0xe8, 0xa1, 0x4c, 0x47,
      0x8d, 0x00, 0x49, 0x05, 0xd8, 0x7b, 0x63, 0x41, 0xf8, 0x4d, 0x51, 0x9a,
      0xae, 0x66, 0x08, 0xa7, 0x66, 0x18, 0xf8, 0xff, 0xca, 0xd7, 0x1a, 0x70,
      0xd1, 0x80, 0xd4, 0xfe, 0x05, 0x97, 0xce, 0x60, 0x44, 0x63, 0x4c, 0x5e,
      0x1b, 0xde, 0x39, 0xc1, 0x56, 0xb6, 0xad, 0x37, 0x75, 0xb0, 0x03, 0x31,
      0xf7, 0x6d, 0xb1, 0xd8, 0x98, 0x44, 0xc1, 0x30, 0xe9, 0xef, 0x5f, 0x82,
      0x6b, 0x9f, 0x57, 0x32, 0xc9, 0xd1, 0xea, 0xc8, 0x17, 0xd3, 0xef, 0xb4,
      0x69, 0x56, 0xbb, 0x47},
     pub_key_1,
     {0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38},
     true},

    // Comment:
    // tcID: 49
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     49,
     0,
     {0x42, 0x28, 0x0e, 0x80, 0xad, 0x24, 0x46, 0x18, 0x47, 0x89, 0x75, 0xf9,
      0x38, 0x7c, 0xbd, 0x44, 0x7d, 0x85, 0xdb, 0xab, 0x3e, 0x70, 0xbb, 0x1d,
      0xb6, 0x65, 0x79, 0xa2, 0x49, 0x6b, 0x03, 0x51, 0xfc, 0xb0, 0x56, 0xa9,
      0x0c, 0x5b, 0x78, 0xed, 0xc2, 0xce, 0x67, 0x75, 0xb3, 0x42, 0xc5, 0x51,
      0x54, 0x68, 0x7d, 0x3c, 0xff, 0xf1, 0xbe, 0xa1, 0xca, 0x31, 0xf3, 0x08,
      0xb7, 0x3c, 0x2a, 0x29, 0x19, 0x1a, 0x8a, 0x3e, 0x1c, 0x21, 0xc3, 0x3d,
      0xaa, 0x4d, 0x37, 0x50, 0xda, 0x25, 0x32, 0x49, 0xd8, 0x7b, 0xbe, 0xe6,
      0x11, 0x0c, 0x9e, 0xa2, 0x54, 0x59, 0xb9, 0x75, 0xd4, 0xa7, 0x2f, 0x0b,
      0x06, 0x4f, 0xe1, 0x53, 0x32, 0x01, 0x21, 0x33, 0xa6, 0x7c, 0x0c, 0x8c,
      0x8e, 0x4b, 0x90, 0xfe, 0xc9, 0x39, 0x19, 0xd4, 0xd1, 0xee, 0x71, 0x79,
      0x94, 0x88, 0x9d, 0x62, 0xd3, 0x94, 0xfb, 0x80, 0x90, 0xf5, 0x8c, 0x4a,
      0x07, 0x92, 0x6c, 0x67, 0xd3, 0x55, 0xd9, 0x65, 0x4b, 0xfa, 0x52, 0x1d,
      0x29, 0xfd, 0x16, 0x6f, 0xe5, 0xf3, 0x63, 0x72, 0x26, 0x16, 0x6f, 0x0e,
      0x45, 0x8b, 0xf3, 0x19, 0x62, 0x27, 0xe2, 0x62, 0xee, 0xbc, 0x55, 0xfc,
      0x39, 0xf0, 0x41, 0x79, 0x5f, 0xc6, 0xd1, 0xc2, 0x37, 0xf9, 0x86, 0x94,
      0xe4, 0x1f, 0x12, 0x8d, 0xe0, 0xc9, 0xcf, 0x6c, 0xef, 0x7c, 0x1f, 0xcd,
      0xcc, 0x61, 0xc0, 0xc7, 0x32, 0xab, 0x96, 0x03, 0x59, 0x8b, 0x0b, 0x56,
      0x55, 0xa7, 0xe3, 0x9e, 0x44, 0x27, 0x4a, 0x70, 0x49, 0xab, 0x42, 0xe5,
      0x09, 0xc5, 0x01, 0x32, 0x54, 0x2c, 0x88, 0x8f, 0x3e, 0x6b, 0x95, 0x6c,
      0x45, 0x27, 0xc5, 0x15, 0xfa, 0x8b, 0x01, 0xad, 0xd9, 0x94, 0xbd, 0x50,
      0xa6, 0xad, 0xf0, 0x85, 0x85, 0x05, 0x49, 0x6e, 0xe2, 0xa7, 0xb9, 0xa0,
      0x43, 0xa8, 0xb8, 0xf5},
     pub_key_1,
     {0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 50
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     50,
     0,
     {0x2d, 0x8a, 0x12, 0x7e, 0xdb, 0xca, 0xf5, 0x0a, 0x1b, 0x35, 0xae, 0x0c,
      0x7b, 0xf2, 0x07, 0x76, 0x98, 0x64, 0x48, 0xec, 0x57, 0x65, 0xb1, 0x5e,
      0xd7, 0xd8, 0x86, 0x11, 0x7a, 0xf2, 0x64, 0x04, 0x3a, 0x1c, 0x3f, 0xde,
      0x6a, 0xf1, 0x84, 0x84, 0x28, 0xa5, 0x25, 0xdd, 0xc9, 0xf3, 0x34, 0xd1,
      0x0c, 0xe6, 0xaa, 0xb0, 0x44, 0x57, 0xef, 0x28, 0x63, 0x80, 0x7c, 0xa6,
      0x74, 0xdc, 0x0e, 0xe8, 0x4b, 0x0a, 0x1a, 0xb4, 0x9a, 0x1b, 0x99, 0x9c,
      0x4b, 0x21, 0x26, 0xde, 0xd5, 0x16, 0xed, 0x11, 0x57, 0xdb, 0x04, 0x7b,
      0xa0, 0x52, 0xdc, 0x7d, 0x98, 0x53, 0xde, 0x48, 0x1a, 0x6b, 0xfc, 0xdf,
      0xe2, 0xd3, 0x14, 0x39, 0x98, 0x0e, 0x62, 0xce, 0x20, 0xc7, 0x7d, 0xde,
      0x58, 0x77, 0x6b, 0x21, 0x27, 0xa5, 0x57, 0xff, 0xd8, 0xc5, 0x15, 0x99,
      0x69, 0x9f, 0x0c, 0xf2, 0x67, 0xa1, 0x08, 0x37, 0x8a, 0x80, 0x26, 0xe0,
      0xa5, 0x30, 0x03, 0x30, 0x9c, 0xc6, 0x45, 0xb5, 0x17, 0x6d, 0xd6, 0x11,
      0x56, 0x3c, 0x67, 0x36, 0xb8, 0x3e, 0x8e, 0x0e, 0x6f, 0xe0, 0xb0, 0x62,
      0xf2, 0xcc, 0x13, 0x7a, 0x41, 0x5b, 0x09, 0x7b, 0xdc, 0xe6, 0x6d, 0x95,
      0x2f, 0xe2, 0xbd, 0x9e, 0x40, 0x7a, 0x46, 0x24, 0xd1, 0x15, 0x71, 0x06,
      0xa5, 0xd7, 0xdd, 0xfa, 0x76, 0xb0, 0x97, 0x38, 0xc0, 0x9a, 0x58, 0x17,
      0xb5, 0x45, 0xdc, 0xb2, 0x7f, 0x8a, 0xd9, 0xff, 0x09, 0x86, 0xf8, 0x0c,
      0x99, 0xed, 0x49, 0xbd, 0x87, 0x4c, 0x89, 0xe8, 0xc8, 0xd0, 0xc5, 0x9e,
      0xe3, 0xec, 0x04, 0x21, 0x4c, 0xba, 0xc6, 0x12, 0xe4, 0xac, 0x3b, 0x25,
      0xd6, 0x2f, 0xd2, 0x86, 0xa4, 0x31, 0xa5, 0x7a, 0x75, 0x8b, 0xf3, 0x1e,
      0xb5, 0x2d, 0x38, 0xd1, 0x3b, 0xca, 0x1d, 0x17, 0x07, 0x4f, 0x4c, 0x9c,
      0x28, 0xbd, 0x93, 0x16},
     pub_key_1,
     {0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 51
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     51,
     0,
     {0x15, 0xe8, 0xfe, 0x3e, 0x7d, 0xcb, 0x5c, 0xa5, 0xc1, 0x6e, 0x1f, 0x12,
      0xfe, 0xc4, 0x69, 0x8a, 0xe2, 0x8c, 0x51, 0x1b, 0x02, 0xc4, 0x0f, 0x83,
      0x55, 0x5b, 0x2b, 0xb1, 0x5b, 0x20, 0xb7, 0x46, 0x2a, 0xbe, 0x1d, 0x0d,
      0x42, 0xb5, 0x3a, 0x58, 0xb7, 0xf1, 0x28, 0x7a, 0xf1, 0x52, 0x24, 0xa0,
      0xe5, 0x05, 0xe7, 0x19, 0x1d, 0x01, 0xf7, 0xf3, 0xb9, 0xa4, 0x56, 0xa5,
      0x52, 0x3c, 0x56, 0xbe, 0x92, 0xc4, 0x14, 0xa8, 0xe2, 0x23, 0x92, 0x20,
      0xe6, 0xc1, 0x70, 0x56, 0x31, 0x02, 0x21, 0xe4, 0xec, 0x25, 0xf8, 0x6a,
      0x7a, 0x0c, 0xaf, 0x42, 0x39, 0xfc, 0xbc, 0x5f, 0x70, 0x4e, 0xe9, 0x2b,
      0x8b, 0xe9, 0x9c, 0x86, 0xda, 0x42, 0xab, 0x09, 0xc0, 0x42, 0x30, 0x8e,
      0x92, 0xde, 0x00, 0xc7, 0x47, 0xf2, 0x3e, 0xb2, 0x77, 0xa9, 0xf6, 0x41,
      0xe0, 0x90, 0xe4, 0x66, 0x28, 0xf7, 0x44, 0xa0, 0x98, 0xf9, 0x2d, 0x03,
      0x1e, 0xe3, 0x15, 0x9d, 0x06, 0x87, 0xdf, 0x6b, 0x58, 0x51, 0x98, 0xa7,
      0x98, 0x5e, 0x29, 0x17, 0xd8, 0x72, 0x3f, 0x7e, 0xb1, 0x17, 0x5f, 0x38,
      0xf2, 0x8b, 0xfe, 0x74, 0x54, 0xd4, 0x1e, 0x08, 0x63, 0x26, 0xa4, 0xc2,
      0xfc, 0x16, 0x02, 0x74, 0x92, 0xd4, 0xcd, 0xa2, 0x37, 0x1d, 0x65, 0xbb,
      0x24, 0x1a, 0x87, 0xfb, 0x26, 0x4f, 0xa2, 0xd2, 0x51, 0x6c, 0x5f, 0xf8,
      0x17, 0xc4, 0x05, 0xc0, 0xfa, 0x48, 0x62, 0x5f, 0x54, 0x0e, 0x65, 0x02,
      0x26, 0x7e, 0xcb, 0x3e, 0x0f, 0xb7, 0x75, 0x73, 0x36, 0x1f, 0xef, 0x5d,
      0x74, 0x60, 0xae, 0x4d, 0x4a, 0x0f, 0xd2, 0x2d, 0xc5, 0x10, 0x3d, 0x2b,
      0x74, 0x9f, 0xd7, 0xbf, 0x28, 0x30, 0xe2, 0x2d, 0x9f, 0xcd, 0x8b, 0x08,
      0x27, 0x28, 0x47, 0x58, 0xbe, 0x30, 0xdb, 0x77, 0x30, 0x85, 0x53, 0x85,
      0x5d, 0x36, 0x69, 0x91},
     pub_key_1,
     {0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36},
     true},

    // Comment:
    // tcID: 52
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     52,
     0,
     {0x0a, 0x8e, 0x7c, 0x3d, 0x26, 0x83, 0x4d, 0x46, 0xdb, 0xb4, 0xf9, 0xd6,
      0xb9, 0xb6, 0xae, 0xbb, 0x2e, 0xa3, 0xb1, 0xb1, 0x80, 0xae, 0x01, 0xdc,
      0xed, 0x1d, 0xf0, 0x33, 0x53, 0xa2, 0xae, 0x59, 0x83, 0x20, 0xe1, 0x71,
      0x8c, 0x9e, 0x43, 0xf4, 0x72, 0x6c, 0xab, 0x81, 0xb5, 0xaa, 0xda, 0xf7,
      0x76, 0x90, 0x95, 0x7e, 0xa0, 0x47, 0x7f, 0xdb, 0x8a, 0x30, 0x4d, 0xbd,
      0xf3, 0xfc, 0xc5, 0x3a, 0xe4, 0xe9, 0x5b, 0x41, 0xc2, 0x7a, 0x39, 0x2f,
      0x0d, 0xfc, 0x83, 0x9f, 0xe8, 0x69, 0x8d, 0xe5, 0x88, 0x90, 0xba, 0x06,
      0x46, 0x09, 0xcd, 0x72, 0xc8, 0xe2, 0x67, 0xb9, 0x0b, 0xdd, 0xa0, 0xeb,
      0xfa, 0xb8, 0x47, 0x4d, 0x0c, 0xef, 0x48, 0x59, 0xaa, 0x85, 0x68, 0x16,
      0x4e, 0x72, 0x13, 0x6a, 0x21, 0x4f, 0xf9, 0x27, 0x9f, 0xfd, 0xa0, 0xe8,
      0xbf, 0x9d, 0xec, 0xe0, 0x30, 0x9f, 0x06, 0xe2, 0x24, 0x45, 0x95, 0xd1,
      0x7a, 0xf3, 0xbe, 0x94, 0xc7, 0xef, 0x9a, 0x15, 0x42, 0x29, 0x7e, 0x7e,
      0x6d, 0x40, 0xf9, 0xc4, 0xb2, 0xee, 0x6b, 0x65, 0x22, 0x99, 0xcc, 0xb2,
      0x0d, 0xa2, 0x74, 0x71, 0x18, 0x61, 0xe3, 0x93, 0x17, 0x34, 0x7f, 0xd5,
      0x6f, 0x5f, 0x13, 0x00, 0x7f, 0x31, 0xe2, 0x90, 0x43, 0x00, 0x19, 0xd8,
      0x26, 0xb2, 0xbe, 0xa3, 0x35, 0x4e, 0x92, 0x6a, 0x23, 0x5a, 0x9a, 0x3e,
      0x9b, 0x68, 0xe1, 0x79, 0xde, 0x25, 0xf3, 0xfe, 0xae, 0x8d, 0x3a, 0xce,
      0x9b, 0x99, 0x9a, 0xfb, 0x1b, 0x50, 0x19, 0x08, 0x48, 0x20, 0x75, 0x23,
      0x62, 0x68, 0x59, 0x6a, 0x4f, 0x89, 0x25, 0x42, 0xc1, 0xf0, 0x5d, 0xbf,
      0x66, 0x30, 0x0c, 0x9f, 0x24, 0x9c, 0x31, 0xc3, 0x4f, 0xca, 0xd5, 0x8f,
      0xad, 0x5d, 0x7e, 0xfd, 0xf3, 0xe1, 0x6a, 0xd3, 0x11, 0xea, 0xc4, 0x98,
      0x1f, 0x16, 0x4d, 0x8a},
     pub_key_1,
     {0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34},
     true},

    // Comment:
    // tcID: 53
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     53,
     0,
     {0x91, 0x5e, 0xe8, 0x62, 0x25, 0xd1, 0x5a, 0x30, 0x8b, 0x4f, 0x4e, 0x7c,
      0xe1, 0x3f, 0x39, 0x6f, 0xbe, 0x81, 0x3b, 0x81, 0x1d, 0x4f, 0xe2, 0x18,
      0x34, 0x15, 0xbc, 0xdc, 0x19, 0x6f, 0xcf, 0x22, 0x04, 0xa3, 0x4d, 0xcf,
      0x07, 0x81, 0x52, 0x68, 0x53, 0xc4, 0x1f, 0x91, 0xde, 0x1a, 0x32, 0x52,
      0x8e, 0xe7, 0xa6, 0xd3, 0x07, 0xa7, 0xec, 0x4e, 0x23, 0x09, 0x9d, 0x52,
      0x69, 0xdb, 0x7d, 0xaa, 0x3b, 0x51, 0x1d, 0x00, 0xf7, 0x4b, 0x0d, 0xd2,
      0x11, 0xd2, 0xc7, 0x6c, 0x30, 0x91, 0x9e, 0xc3, 0xc6, 0x06, 0x25, 0x05,
      0x53, 0x0f, 0xf2, 0x4f, 0xed, 0x58, 0x1f, 0x28, 0x6f, 0xd1, 0x49, 0x9d,
      0x78, 0x9d, 0x2e, 0x7a, 0x4e, 0x25, 0xba, 0x39, 0x84, 0xf2, 0xe6, 0xe0,
      0x7e, 0x26, 0xbb, 0xc4, 0x5f, 0xb0, 0x26, 0x24, 0xff, 0xc1, 0xb9, 0xee,
      0xdb, 0x8e, 0x77, 0xe0, 0x76, 0xb0, 0xc9, 0xa8, 0x36, 0x04, 0x62, 0x37,
      0xdb, 0x99, 0x2c, 0x0f, 0x4c, 0x53, 0x13, 0x36, 0xee, 0x1b, 0xb9, 0xef,
      0x75, 0xbd, 0x6c, 0xd6, 0x47, 0x46, 0x0f, 0x8a, 0x8c, 0xaf, 0xb3, 0x13,
      0x90, 0x8d, 0xfd, 0xeb, 0x52, 0x98, 0x24, 0xee, 0xe0, 0x1d, 0x76, 0xce,
      0xd6, 0x16, 0x13, 0x3c, 0x93, 0x29, 0x7a, 0xd5, 0x06, 0x6f, 0x08, 0xf4,
      0x67, 0xf2, 0x38, 0x7e, 0xdf, 0x24, 0x7c, 0x68, 0x07, 0x08, 0x04, 0xa8,
      0x00, 0xac, 0xe3, 0x63, 0x48, 0x01, 0x61, 0x19, 0x1b, 0x0f, 0x50, 0xae,
      0x26, 0x0e, 0x31, 0x2e, 0xf8, 0x5c, 0x2d, 0x42, 0x9b, 0xee, 0x51, 0x7f,
      0xb2, 0x21, 0x83, 0xbf, 0x2f, 0xc9, 0x1b, 0x0f, 0x30, 0x54, 0x12, 0xda,
      0x4f, 0x3e, 0xe2, 0x00, 0x87, 0xe0, 0xa1, 0x58, 0xd0, 0x36, 0xf3, 0x11,
      0xf1, 0xcc, 0xeb, 0x9d, 0x0b, 0xc9, 0x1a, 0x75, 0xc0, 0x23, 0x3f, 0xdb,
      0x6b, 0x18, 0xc9, 0x1f},
     pub_key_1,
     {0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34},
     true},

    // Comment:
    // tcID: 54
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     54,
     0,
     {0x2b, 0x85, 0x0d, 0xd6, 0xa6, 0x5d, 0x22, 0x5a, 0x55, 0xd5, 0x26, 0xe8,
      0x34, 0xc5, 0x5a, 0x6a, 0x2a, 0x71, 0xae, 0x2a, 0x7d, 0x1d, 0xb1, 0x43,
      0x9e, 0xc1, 0x2a, 0xe1, 0x14, 0x7b, 0x26, 0xa8, 0xd5, 0x32, 0x5c, 0x76,
      0x4d, 0x4c, 0x5d, 0x1e, 0x3c, 0xc1, 0xd4, 0x9c, 0x61, 0xa0, 0xe3, 0x64,
      0x88, 0x79, 0x7f, 0x59, 0x2a, 0x1a, 0x19, 0xc3, 0xe2, 0x00, 0xcd, 0xf8,
      0x3c, 0x18, 0x80, 0xbb, 0x27, 0x2a, 0x4a, 0xdb, 0xcd, 0x1d, 0xae, 0x96,
      0x1a, 0x19, 0x85, 0x79, 0x15, 0x23, 0x3f, 0x20, 0x95, 0x94, 0x4b, 0x9b,
      0x96, 0xa0, 0x9a, 0xa0, 0xcf, 0x99, 0x71, 0x18, 0x3e, 0xf3, 0x60, 0x10,
      0x36, 0x98, 0xac, 0x04, 0x9f, 0x42, 0x96, 0x00, 0xc3, 0x39, 0xee, 0xcc,
      0xde, 0x2b, 0xf4, 0x93, 0x53, 0xc7, 0x2e, 0xa4, 0xa2, 0x43, 0xdb, 0x91,
      0xbc, 0xff, 0x7e, 0xc0, 0x1e, 0x51, 0x42, 0x31, 0x03, 0xa1, 0xb3, 0x88,
      0xe1, 0xf7, 0x50, 0xb1, 0x1b, 0xa8, 0xbe, 0x65, 0x58, 0xa2, 0xb0, 0xb2,
      0x21, 0x6d, 0xb2, 0x22, 0x9f, 0xc6, 0x55, 0xec, 0xfa, 0x90, 0x00, 0xfa,
      0x66, 0x4d, 0xbc, 0xd8, 0x29, 0x9e, 0x1e, 0x25, 0x8d, 0x13, 0xae, 0x59,
      0x69, 0x6e, 0xda, 0xe7, 0x97, 0x4e, 0xb1, 0xc6, 0x3a, 0x73, 0xaa, 0x6e,
      0xa1, 0x2d, 0x20, 0x03, 0x52, 0xe1, 0xc7, 0xc2, 0x73, 0x1d, 0x36, 0x05,
      0xff, 0x9f, 0x1e, 0x18, 0xb2, 0x5a, 0xf1, 0x3d, 0x24, 0x59, 0x81, 0x77,
      0x16, 0x6d, 0xae, 0x95, 0x03, 0x3b, 0x42, 0x4f, 0x78, 0x88, 0x3e, 0xd1,
      0x4c, 0x68, 0x49, 0xd5, 0xb8, 0xfe, 0xb5, 0x26, 0xe3, 0xac, 0x14, 0xf5,
      0x09, 0x88, 0xe4, 0x95, 0x6f, 0x99, 0xb3, 0x4d, 0x49, 0x90, 0x03, 0x50,
      0x85, 0x21, 0x8e, 0x6c, 0x16, 0xce, 0xd8, 0x14, 0x94, 0x17, 0xb7, 0xb4,
      0xd9, 0xd2, 0x5a, 0x57},
     pub_key_1,
     {0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31},
     true},

    // Comment:
    // tcID: 55
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     55,
     0,
     {0x86, 0xb2, 0x2f, 0x94, 0x8d, 0xd5, 0xaf, 0x9d, 0xf6, 0x5c, 0x1d, 0x06,
      0x26, 0x08, 0x39, 0x3d, 0x90, 0xd3, 0x98, 0x2d, 0x9b, 0x3f, 0x27, 0x98,
      0x65, 0xb8, 0xd6, 0x75, 0xcf, 0x2f, 0x46, 0xba, 0xf3, 0x90, 0x14, 0x10,
      0xa3, 0x88, 0xbb, 0x87, 0xa7, 0xf5, 0xda, 0xd2, 0x68, 0xd0, 0x89, 0x9f,
      0xee, 0xde, 0x82, 0x22, 0xc0, 0xe5, 0x52, 0xc9, 0x1a, 0x76, 0xaa, 0x5f,
      0x5b, 0x4b, 0x30, 0xb5, 0x73, 0xba, 0xcc, 0x17, 0x87, 0xa2, 0xe4, 0x87,
      0xb9, 0x90, 0xc5, 0x58, 0xb1, 0x97, 0x20, 0x69, 0xa8, 0xf2, 0x9c, 0xad,
      0x25, 0xab, 0xb5, 0x09, 0x4e, 0x94, 0x26, 0x62, 0x18, 0xf7, 0x81, 0x6e,
      0xd9, 0xb3, 0x14, 0xee, 0xc8, 0x28, 0x9d, 0xae, 0x61, 0xde, 0x5a, 0xe5,
      0x16, 0xd6, 0x3c, 0x58, 0xf9, 0x9b, 0x01, 0xdd, 0x5c, 0xd9, 0x49, 0x5e,
      0xe4, 0x7a, 0x98, 0x12, 0x65, 0xd8, 0x36, 0xd6, 0x9f, 0xc5, 0x51, 0x21,
      0xa2, 0xc7, 0x85, 0x68, 0x5f, 0x44, 0x7c, 0xa6, 0x3c, 0x3b, 0xd1, 0x9d,
      0xc3, 0x3a, 0xb6, 0x3a, 0x1c, 0xcd, 0xfd, 0xd9, 0x4d, 0x5c, 0xda, 0x20,
      0xbe, 0x63, 0x9d, 0x48, 0x4d, 0xa0, 0x22, 0x73, 0x64, 0x0a, 0x19, 0xaf,
      0xe0, 0x3d, 0x36, 0x2f, 0x58, 0xda, 0x9d, 0x75, 0xbd, 0x71, 0xde, 0x52,
      0xe0, 0xfe, 0x84, 0x9f, 0x11, 0x4b, 0xa3, 0x67, 0xf1, 0x22, 0x82, 0x98,
      0x9d, 0xeb, 0xb3, 0x3a, 0x1d, 0x27, 0x8e, 0x93, 0x42, 0x45, 0xf9, 0x81,
      0xac, 0x0e, 0x22, 0x28, 0x67, 0xfc, 0x1c, 0x16, 0xe4, 0xbb, 0x08, 0xdd,
      0x8f, 0xf2, 0x0c, 0x41, 0xf3, 0x5f, 0xee, 0xae, 0xe1, 0x4e, 0x19, 0xbc,
      0x72, 0xc5, 0x4f, 0x69, 0x2c, 0xdf, 0x2c, 0x09, 0xc5, 0x1f, 0x53, 0x78,
      0xc3, 0xf8, 0x4e, 0x6d, 0xf6, 0xf9, 0x90, 0x94, 0x14, 0x05, 0xf8, 0x60,
      0x82, 0x42, 0xed, 0xbf},
     pub_key_1,
     {0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36},
     true},

    // Comment:
    // tcID: 56
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     56,
     0,
     {0x8b, 0x7c, 0x4b, 0xb2, 0xf5, 0xc2, 0xe9, 0x21, 0x81, 0xf8, 0x1b, 0xf1,
      0x8f, 0x55, 0x36, 0x1c, 0x8e, 0x37, 0x28, 0xe8, 0xa4, 0xc8, 0x0e, 0xe9,
      0x60, 0xf5, 0xe3, 0xd2, 0x8c, 0xe7, 0x84, 0xd5, 0x98, 0xbb, 0x3e, 0xba,
      0x64, 0x1f, 0x8b, 0x6e, 0xe1, 0x8e, 0x45, 0x55, 0x24, 0x4c, 0xe6, 0x5d,
      0x7e, 0x56, 0x3b, 0x5c, 0xfc, 0xe7, 0x60, 0xe6, 0x4c, 0x03, 0x47, 0xe2,
      0x09, 0xb6, 0xed, 0x2b, 0x4a, 0xa4, 0x5e, 0xd4, 0xce, 0x14, 0x80, 0x7f,
      0xc2, 0x14, 0x77, 0x59, 0x00, 0xc5, 0xca, 0xb7, 0xef, 0x93, 0x42, 0xe5,
      0x26, 0xb2, 0xe3, 0x46, 0xce, 0xdf, 0x9c, 0x33, 0xde, 0xc7, 0xdf, 0x3c,
      0x58, 0x90, 0xbe, 0x5f, 0xee, 0x98, 0x5c, 0x1f, 0xb4, 0xf1, 0x46, 0xde,
      0x70, 0xd1, 0xb5, 0xcc, 0xda, 0x6f, 0xa4, 0x69, 0xa2, 0x07, 0xd4, 0xa0,
      0x74, 0x31, 0x0b, 0x2d, 0x4b, 0x05, 0xb6, 0xb3, 0x9b, 0xf7, 0xa9, 0x39,
      0x06, 0x84, 0xb6, 0x24, 0x07, 0x88, 0xa1, 0x76, 0xdd, 0x89, 0x1b, 0xbe,
      0x4a, 0x00, 0xf2, 0xb9, 0x06, 0xcb, 0x85, 0x29, 0x7c, 0x36, 0xe2, 0xdf,
      0x8b, 0x51, 0x92, 0xc9, 0xb3, 0x3c, 0xbf, 0x2f, 0x94, 0xa7, 0x23, 0x99,
      0x6f, 0x51, 0xdf, 0xac, 0x1f, 0x97, 0x49, 0x71, 0x94, 0x30, 0x4f, 0x33,
      0x83, 0xc0, 0xdf, 0x16, 0x08, 0x7f, 0xf3, 0xa4, 0xf0, 0xb3, 0x37, 0x8b,
      0x91, 0xc8, 0x23, 0x33, 0x66, 0xed, 0xe6, 0xac, 0x90, 0xab, 0x0c, 0xcc,
      0x72, 0xdd, 0x20, 0x6c, 0xe3, 0xbb, 0xb1, 0xb7, 0x83, 0x1c, 0x7c, 0x2a,
      0x3d, 0xb6, 0x40, 0x55, 0x83, 0xc6, 0xdb, 0x9d, 0x35, 0xf2, 0xfb, 0x72,
      0xeb, 0xe1, 0x2c, 0xd0, 0x35, 0xa1, 0xc9, 0x7c, 0x45, 0x70, 0x31, 0xe4,
      0x81, 0xe4, 0x88, 0x14, 0x27, 0xbd, 0xb5, 0x6b, 0xad, 0xcb, 0x27, 0x38,
      0xf3, 0x41, 0xc5, 0x09},
     pub_key_1,
     {0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32},
     true},

    // Comment:
    // tcID: 57
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     57,
     0,
     {0x5a, 0x97, 0x8a, 0xe0, 0xc6, 0x3f, 0xa0, 0x6a, 0xe1, 0x4b, 0x79, 0x9f,
      0x22, 0x57, 0x8b, 0x4a, 0xde, 0xde, 0x79, 0xcf, 0x13, 0x4a, 0x42, 0x42,
      0x29, 0x0a, 0x58, 0x16, 0x07, 0xd4, 0x91, 0xf5, 0xde, 0x67, 0x1f, 0x62,
      0x95, 0xbf, 0xa2, 0xc5, 0xa5, 0x7a, 0x3a, 0xe0, 0xcd, 0x87, 0x90, 0xe9,
      0xf7, 0xc9, 0xc5, 0x93, 0x3c, 0xfb, 0x52, 0x24, 0xd4, 0xc8, 0x83, 0x81,
      0x2d, 0x8d, 0x30, 0x8e, 0xdb, 0x8e, 0x59, 0x7a, 0x2e, 0x7b, 0x20, 0x7e,
      0x0f, 0x5a, 0x23, 0x15, 0xeb, 0x8b, 0x76, 0xb7, 0x25, 0xe4, 0x31, 0x97,
      0x9d, 0xee, 0xfa, 0x6c, 0xd4, 0xff, 0x8e, 0xe6, 0x38, 0x4c, 0xf1, 0x7d,
      0x2f, 0x50, 0x60, 0xab, 0x57, 0xa7, 0x83, 0xd4, 0xae, 0x9f, 0x31, 0xff,
      0xde, 0xc0, 0x5f, 0x1a, 0x15, 0x81, 0x42, 0x21, 0x8e, 0xfb, 0x75, 0x4d,
      0x01, 0xef, 0x33, 0xf3, 0x06, 0x2e, 0x4a, 0xb3, 0xc7, 0xc7, 0x7b, 0xaf,
      0x34, 0xef, 0x2f, 0xf9, 0xae, 0xc9, 0x5e, 0x87, 0x77, 0x6e, 0x50, 0x54,
      0xf4, 0x32, 0x6a, 0xfd, 0xd7, 0xf3, 0x34, 0x45, 0x18, 0x8b, 0x6f, 0x00,
      0xea, 0x80, 0x71, 0x42, 0x37, 0x40, 0xb5, 0xa2, 0x45, 0xdd, 0xe5, 0x61,
      0xf8, 0x14, 0xf3, 0x3b, 0x7b, 0x4c, 0x8f, 0xc7, 0x58, 0xe8, 0xf9, 0xd0,
      0xb3, 0x5c, 0x5f, 0xfa, 0x19, 0x92, 0x41, 0xf1, 0xe8, 0x0c, 0x92, 0xf0,
      0x59, 0x44, 0x59, 0xb9, 0xb7, 0xad, 0xb3, 0xea, 0x65, 0x7f, 0xd8, 0xd3,
      0xe8, 0xec, 0x31, 0x50, 0x5a, 0x45, 0x0e, 0x4b, 0xa6, 0x16, 0x6c, 0x02,
      0x8f, 0xf7, 0xa7, 0xad, 0xc6, 0x72, 0x39, 0xae, 0x35, 0xce, 0xdc, 0x75,
      0x57, 0xfc, 0xe8, 0x1b, 0xa4, 0xca, 0x48, 0x46, 0xf2, 0x3b, 0xc3, 0xa9,
      0xe2, 0xe0, 0xe4, 0x60, 0xb6, 0x4d, 0xb4, 0x60, 0xce, 0x41, 0xe6, 0x09,
      0x11, 0x2a, 0x70, 0xb6},
     pub_key_1,
     {0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30},
     true},

    // Comment:
    // tcID: 58
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     58,
     0,
     {0x3d, 0x2a, 0x22, 0xdb, 0xb1, 0xb7, 0x5e, 0xee, 0xf6, 0x58, 0xa7, 0x16,
      0xdf, 0xfd, 0xed, 0x2d, 0xeb, 0xa0, 0x58, 0x9a, 0xb0, 0x02, 0xf6, 0x39,
      0x49, 0xac, 0x22, 0x8a, 0x32, 0x02, 0x9a, 0xc3, 0xd3, 0x72, 0x29, 0x73,
      0x64, 0xef, 0xef, 0x9b, 0x37, 0xfa, 0xee, 0xca, 0xdb, 0xd8, 0x41, 0xae,
      0x4c, 0x65, 0x12, 0x82, 0x09, 0x67, 0x08, 0x76, 0x9d, 0xcb, 0x21, 0xca,
      0x1d, 0xa8, 0xcf, 0x19, 0x6d, 0x15, 0x86, 0x29, 0xe8, 0x60, 0x0e, 0xb7,
      0x57, 0xc5, 0xf6, 0x72, 0x2e, 0xe2, 0xdf, 0x00, 0xed, 0x0e, 0x0c, 0x50,
      0x3f, 0x1e, 0xdf, 0x89, 0xf3, 0xb0, 0x93, 0x09, 0xd7, 0xf4, 0x46, 0xd6,
      0x84, 0xba, 0x70, 0x39, 0x2d, 0x65, 0xf2, 0xd7, 0xd0, 0x89, 0x41, 0x39,
      0x8e, 0xfe, 0xc0, 0xa8, 0xcd, 0x1f, 0xf1, 0xaa, 0x50, 0x8e, 0x8a, 0x7e,
      0x30, 0x4d, 0xb3, 0xfa, 0x9c, 0x14, 0x72, 0x9c, 0x61, 0x02, 0x4e, 0x48,
      0x64, 0xce, 0x63, 0x60, 0x5b, 0xae, 0x91, 0x38, 0xdc, 0x2f, 0xcc, 0xd1,
      0x07, 0xcb, 0x44, 0x3a, 0x24, 0x7e, 0xec, 0x78, 0x05, 0x14, 0x22, 0x87,
      0xbd, 0xc8, 0x8b, 0x6f, 0xbd, 0x24, 0xe1, 0xf4, 0xd0, 0xf9, 0xb1, 0xee,
      0x48, 0x0a, 0xae, 0x1f, 0x06, 0x2d, 0x53, 0x3c, 0xe7, 0xee, 0x7d, 0x9f,
      0x2a, 0x0b, 0x34, 0x0f, 0x11, 0x58, 0x4b, 0x64, 0x32, 0x4f, 0xb8, 0xfa,
      0x1a, 0x5a, 0xf4, 0xd2, 0x00, 0x34, 0x78, 0xe1, 0x0e, 0x31, 0x29, 0x96,
      0xa6, 0xe4, 0x91, 0x74, 0xa2, 0x6b, 0x35, 0x65, 0xc1, 0x47, 0xa5, 0x52,
      0x85, 0xad, 0xb7, 0xb9, 0x2b, 0xc5, 0x84, 0xaf, 0x11, 0x9b, 0xee, 0xc1,
      0xcf, 0x23, 0x5a, 0xf2, 0xb3, 0x2a, 0x81, 0x0a, 0xc8, 0x03, 0xac, 0xac,
      0x2a, 0x8b, 0x8c, 0x26, 0x13, 0x33, 0x1a, 0x62, 0x60, 0x46, 0x88, 0xc2,
      0xc6, 0x11, 0xbd, 0x48},
     pub_key_1,
     {0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38},
     true},

    // Comment:
    // tcID: 59
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     59,
     0,
     {0x78, 0xe5, 0xd7, 0x81, 0xd7, 0x74, 0xb8, 0xd7, 0x7a, 0x9c, 0x29, 0x0b,
      0x8a, 0x1b, 0xab, 0xbb, 0x18, 0x93, 0xab, 0xd8, 0x0d, 0x04, 0x94, 0x06,
      0x3e, 0x55, 0xf7, 0x01, 0x82, 0x3f, 0x16, 0xbf, 0x71, 0x5d, 0xef, 0x50,
      0x85, 0x78, 0x7b, 0x73, 0xf4, 0xf3, 0x42, 0x0c, 0x15, 0xd1, 0x8b, 0x8f,
      0x5f, 0xee, 0xe1, 0x94, 0xb2, 0x67, 0x62, 0xef, 0xe7, 0xb5, 0xe0, 0xed,
      0x3a, 0x3c, 0x9b, 0x98, 0x18, 0x32, 0x28, 0x87, 0xd2, 0xad, 0xc5, 0xf7,
      0xdc, 0x42, 0xdb, 0x0b, 0x31, 0xfa, 0x3b, 0xfb, 0x36, 0xea, 0x1b, 0x10,
      0xba, 0x28, 0xac, 0xba, 0x19, 0xbd, 0x24, 0x94, 0x61, 0x6f, 0x40, 0xce,
      0x71, 0x7d, 0x24, 0x34, 0xbf, 0x65, 0x43, 0xc5, 0x51, 0x43, 0x22, 0xe6,
      0x70, 0xb8, 0x69, 0xc4, 0x16, 0x66, 0x26, 0xc1, 0x52, 0x29, 0x89, 0x9b,
      0x63, 0xac, 0xb9, 0x03, 0x64, 0xad, 0xf8, 0x42, 0xce, 0xa5, 0xcc, 0x95,
      0xa0, 0x23, 0xfe, 0xac, 0x64, 0x35, 0x4e, 0xe1, 0x87, 0xfb, 0x2b, 0xf8,
      0x03, 0xf5, 0x0c, 0xf2, 0xbb, 0xc1, 0xfe, 0x3a, 0xa5, 0xb8, 0xdd, 0xc7,
      0xb7, 0xc3, 0xd4, 0x70, 0xb3, 0x3b, 0xee, 0x5a, 0xcf, 0xf2, 0x91, 0xaf,
      0x4b, 0x48, 0xaa, 0xb5, 0x02, 0x68, 0xf5, 0x96, 0x26, 0x06, 0x95, 0xdb,
      0x71, 0x1f, 0x53, 0xfb, 0x8f, 0x08, 0xf2, 0x21, 0x13, 0xf2, 0x9c, 0xca,
      0x6d, 0xa4, 0x76, 0xf7, 0x16, 0xbe, 0xb4, 0x3f, 0xc2, 0xdf, 0x98, 0x8d,
      0xf8, 0x20, 0xa0, 0xe5, 0x8d, 0xb8, 0x17, 0xd8, 0xec, 0x90, 0x51, 0x1e,
      0x8e, 0xf5, 0xb9, 0x0e, 0x1f, 0xc0, 0x3f, 0xd8, 0x36, 0x9f, 0xeb, 0xfa,
      0x15, 0x24, 0xcf, 0xbd, 0x66, 0xaf, 0x9f, 0x39, 0x51, 0x94, 0xda, 0x94,
      0xc6, 0x43, 0xb8, 0x67, 0x22, 0xb6, 0x2e, 0xf0, 0x83, 0x64, 0xff, 0xba,
      0x80, 0xd3, 0xcf, 0x5b},
     pub_key_1,
     {0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32},
     true},

    // Comment:
    // tcID: 60
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     60,
     0,
     {0x05, 0xa0, 0x89, 0x48, 0x9b, 0xe8, 0x6b, 0x22, 0x25, 0xbc, 0x65, 0x91,
      0x6a, 0x5a, 0xfe, 0xa3, 0x4d, 0x6a, 0x37, 0x2f, 0x7f, 0x2b, 0x2b, 0xf4,
      0x93, 0xe1, 0x1f, 0x94, 0x92, 0x36, 0xdc, 0xfc, 0x3f, 0x2f, 0x1b, 0xdf,
      0xf3, 0x34, 0xa7, 0x37, 0xc2, 0x3e, 0x4f, 0x18, 0xaa, 0x89, 0xd6, 0x12,
      0x65, 0xc5, 0x93, 0x5a, 0xae, 0x98, 0x19, 0xa0, 0x5a, 0xda, 0x91, 0xd9,
      0x43, 0xa6, 0xf4, 0x2a, 0xc2, 0xd4, 0x8f, 0x76, 0x01, 0x19, 0xfb, 0xde,
      0xbf, 0xf6, 0xb1, 0x54, 0xfa, 0x6b, 0xf8, 0x31, 0xa9, 0xf4, 0xd3, 0xb7,
      0x1e, 0x41, 0xc2, 0x88, 0x1f, 0x5e, 0xb7, 0x63, 0x66, 0x29, 0x70, 0x4f,
      0x93, 0x61, 0x31, 0xd9, 0x06, 0xda, 0x62, 0xaf, 0x4b, 0xf6, 0x37, 0x1b,
      0xa7, 0x13, 0x59, 0x21, 0xba, 0xf8, 0x10, 0x08, 0xdf, 0x10, 0x16, 0xe3,
      0xfc, 0xc8, 0xae, 0x0f, 0x1f, 0xa8, 0xcf, 0x89, 0x5b, 0xec, 0x5c, 0xa6,
      0x89, 0xcd, 0x43, 0xfc, 0x17, 0x5e, 0x8b, 0xb2, 0xf9, 0xd4, 0x69, 0x85,
      0xa8, 0x3e, 0x2d, 0xa1, 0x85, 0x35, 0x6b, 0x81, 0x4c, 0x80, 0x6d, 0x53,
      0x81, 0xfd, 0x4b, 0x2d, 0x70, 0x74, 0xb9, 0xfc, 0x6c, 0x74, 0x08, 0x23,
      0x9c, 0xc7, 0x6f, 0x54, 0x63, 0x8d, 0x7e, 0x27, 0xab, 0x4d, 0x6f, 0x1b,
      0x58, 0x62, 0xee, 0x15, 0xf2, 0xc4, 0xd0, 0xef, 0xf6, 0xfb, 0xa9, 0x0c,
      0xae, 0xf5, 0x26, 0xaa, 0x7a, 0x60, 0x42, 0xb1, 0xc0, 0x8c, 0x02, 0x1c,
      0x6d, 0x29, 0x8a, 0xfd, 0x91, 0xfd, 0x46, 0x6f, 0x66, 0x85, 0xc4, 0xf0,
      0xad, 0xd1, 0x01, 0xd7, 0xf8, 0x23, 0x1c, 0xe7, 0x04, 0x01, 0x36, 0x71,
      0xa1, 0x46, 0x81, 0x10, 0xcd, 0xf9, 0xb8, 0x82, 0x96, 0x99, 0xb0, 0x3e,
      0xae, 0x22, 0x38, 0xbb, 0xa6, 0x70, 0xe9, 0x59, 0xfb, 0x15, 0x0e, 0x94,
      0xfe, 0xa8, 0x89, 0xba},
     pub_key_1,
     {0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36},
     true},

    // Comment:
    // tcID: 61
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     61,
     0,
     {0x30, 0x67, 0x42, 0xec, 0xb8, 0x09, 0x93, 0xc0, 0xd6, 0xf3, 0xd9, 0x87,
      0xd4, 0x62, 0xba, 0x4e, 0xcb, 0x87, 0x76, 0x49, 0xd0, 0xf6, 0x03, 0x6c,
      0x62, 0x94, 0xa2, 0xb8, 0x65, 0x22, 0x1d, 0xd9, 0x5e, 0x4f, 0xa3, 0xfe,
      0x76, 0x94, 0xa6, 0xbb, 0x6c, 0x6f, 0x93, 0xa5, 0x91, 0xcc, 0x92, 0xfe,
      0x63, 0x1d, 0x31, 0xbd, 0x90, 0x59, 0xb8, 0xa5, 0x7b, 0x7f, 0x83, 0x02,
      0xb2, 0xd4, 0x14, 0xad, 0xb8, 0x13, 0xe2, 0x1f, 0x02, 0xa8, 0xb1, 0xe0,
      0x62, 0x8b, 0x1a, 0x52, 0x35, 0x9a, 0x4a, 0xb9, 0x47, 0xe2, 0x35, 0xf9,
      0x77, 0x58, 0xd4, 0xb5, 0x0e, 0x67, 0x9e, 0x62, 0x25, 0x15, 0x2a, 0x99,
      0x50, 0xba, 0x54, 0xe1, 0xe1, 0x90, 0x6f, 0x15, 0xbb, 0x91, 0xf8, 0xcf,
      0xc8, 0xd1, 0x4a, 0x2c, 0xb4, 0x1e, 0xe8, 0x65, 0x43, 0x20, 0xdc, 0xed,
      0xbf, 0x3b, 0x21, 0xd0, 0x07, 0x05, 0xce, 0x6c, 0xc9, 0x3d, 0xa7, 0x42,
      0x6f, 0x4d, 0x41, 0xbf, 0xb2, 0x1f, 0xb4, 0xcf, 0xe1, 0x87, 0xf8, 0xa2,
      0x4c, 0xec, 0xbd, 0x1e, 0xc6, 0xa5, 0x68, 0xef, 0xc6, 0x4b, 0x13, 0xa0,
      0xea, 0xa5, 0xd4, 0x5a, 0xee, 0xcd, 0x81, 0xaf, 0x18, 0x49, 0x54, 0xa5,
      0x6c, 0x42, 0xb1, 0x0a, 0x40, 0xb0, 0xc1, 0xff, 0x6e, 0xe4, 0x9c, 0x14,
      0x93, 0xcd, 0x93, 0xfb, 0x83, 0xe9, 0xea, 0xc5, 0xaa, 0xc5, 0x26, 0xa0,
      0xe6, 0xd9, 0x65, 0x52, 0xc1, 0x78, 0x05, 0x24, 0x70, 0x70, 0xa3, 0x0e,
      0xa5, 0xb9, 0xfa, 0x4f, 0x67, 0x85, 0x2e, 0x11, 0xed, 0x25, 0x8c, 0xfb,
      0x1e, 0xe4, 0xe6, 0x48, 0x08, 0xdc, 0xfd, 0xd1, 0x10, 0x96, 0xdf, 0xed,
      0x7c, 0x37, 0x6c, 0xd1, 0x37, 0x3f, 0x0c, 0x6a, 0xc1, 0xfa, 0xd8, 0x87,
      0x8b, 0x95, 0xc7, 0x83, 0xdf, 0x87, 0xa3, 0xf0, 0x54, 0xfe, 0xce, 0xc0,
      0xd1, 0xf5, 0x11, 0x6d},
     pub_key_1,
     {0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35},
     true},

    // Comment: first byte of m_hash modified
    // tcID: 62
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     62,
     0,
     {0x6b, 0x77, 0xfb, 0x8c, 0xd2, 0x87, 0xc6, 0x66, 0xcb, 0xc3, 0x0f, 0x00,
      0xbc, 0xfc, 0xcd, 0x31, 0xf6, 0xdc, 0x01, 0x65, 0x5c, 0x3c, 0x97, 0x6d,
      0x1b, 0x2a, 0x98, 0x0d, 0x53, 0xbe, 0x40, 0xd6, 0xa4, 0xa7, 0x67, 0x60,
      0x24, 0xab, 0xeb, 0x18, 0x25, 0xec, 0x47, 0x58, 0x93, 0x65, 0xc0, 0x7e,
      0x5d, 0x4c, 0x3d, 0x34, 0xe2, 0x49, 0x81, 0x41, 0x26, 0xe3, 0x2b, 0xa4,
      0x0a, 0xa8, 0x1d, 0xde, 0xa0, 0xf6, 0x1f, 0xe4, 0xe3, 0x72, 0x5a, 0xeb,
      0x97, 0x51, 0x10, 0x3f, 0xd0, 0x34, 0xcf, 0x3f, 0xa5, 0x16, 0xfd, 0xc1,
      0x56, 0x9a, 0xeb, 0x7b, 0x02, 0x8d, 0x19, 0x2c, 0x8e, 0xf4, 0xef, 0x60,
      0xa5, 0xbe, 0xfb, 0x8a, 0x4d, 0xe5, 0x95, 0xbd, 0x47, 0x17, 0x46, 0x28,
      0x79, 0xf4, 0x24, 0xe8, 0x72, 0x86, 0xae, 0xc0, 0xbc, 0xe6, 0xf9, 0xe7,
      0x63, 0xee, 0x34, 0x17, 0x65, 0xc2, 0x4c, 0xef, 0x24, 0xf9, 0x16, 0xa5,
      0x2a, 0x77, 0x75, 0x95, 0x87, 0x94, 0x71, 0xe2, 0xf3, 0x18, 0x8c, 0x1b,
      0xe7, 0x7f, 0xdc, 0xed, 0x94, 0x1f, 0xe0, 0xcf, 0x73, 0x9b, 0xd8, 0xd5,
      0xa4, 0xce, 0xed, 0x9f, 0xa1, 0xe4, 0x7f, 0x6f, 0x12, 0xdb, 0xa6, 0x8c,
      0xbe, 0x7b, 0xb2, 0xeb, 0x81, 0xe4, 0x6c, 0x27, 0x88, 0xb8, 0x47, 0xd0,
      0xab, 0x6f, 0x55, 0x95, 0x1f, 0x78, 0x7d, 0xb4, 0xec, 0x73, 0x67, 0x72,
      0x85, 0x1c, 0x43, 0x53, 0x4b, 0x7e, 0xbc, 0xf2, 0x26, 0xc2, 0x54, 0x08,
      0x06, 0xd9, 0x25, 0xbe, 0xbe, 0xc9, 0xd1, 0x09, 0x91, 0x5e, 0x46, 0x6d,
      0x08, 0xe2, 0x47, 0x0b, 0x7e, 0x85, 0xb4, 0xfa, 0xc6, 0x6e, 0x08, 0x9b,
      0x1a, 0x53, 0x5b, 0xa7, 0x03, 0xdb, 0xc1, 0x0f, 0x80, 0x0f, 0x6b, 0xdd,
      0x55, 0x73, 0x70, 0xe9, 0xce, 0x76, 0x1e, 0x86, 0x46, 0x68, 0x33, 0x90,
      0x3e, 0xfe, 0x31, 0x5c},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of m_hash modified
    // tcID: 63
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     63,
     0,
     {0x4a, 0xf6, 0xc0, 0x2b, 0x1f, 0x3c, 0x27, 0x19, 0xfd, 0x1c, 0x84, 0x96,
      0x56, 0x58, 0xe3, 0x66, 0x51, 0xff, 0x89, 0x14, 0x84, 0xf4, 0xc4, 0x17,
      0x7f, 0xce, 0x21, 0x85, 0xb7, 0x09, 0x8c, 0x86, 0x19, 0x39, 0xfc, 0xba,
      0x67, 0x7e, 0x8a, 0xd4, 0x61, 0x57, 0x7a, 0x66, 0x6a, 0xc7, 0x76, 0x53,
      0xac, 0x37, 0xfe, 0x61, 0xb5, 0xfc, 0x23, 0x5b, 0xa7, 0x69, 0x17, 0xe0,
      0x3c, 0x34, 0x19, 0xfa, 0x3b, 0x05, 0x51, 0x71, 0xf9, 0x59, 0xed, 0xc7,
      0xf9, 0xfd, 0x34, 0x92, 0x09, 0xa2, 0x3a, 0x4a, 0xba, 0x57, 0xca, 0x80,
      0x74, 0x4f, 0x69, 0xbe, 0x6f, 0xfd, 0x1a, 0x22, 0x52, 0xa1, 0x82, 0xa3,
      0xa2, 0xc1, 0xa2, 0xc0, 0x69, 0xdd, 0x49, 0x53, 0xda, 0xb9, 0xa6, 0xac,
      0xb4, 0xc7, 0x04, 0x7d, 0x74, 0x02, 0x58, 0x42, 0x75, 0xcb, 0x72, 0x68,
      0x75, 0xc0, 0x85, 0x80, 0x66, 0xf5, 0x0c, 0xae, 0xbd, 0xf7, 0xe9, 0xaf,
      0xb6, 0xd4, 0xf3, 0x27, 0x06, 0x62, 0xaf, 0xbc, 0x66, 0xed, 0x14, 0xce,
      0x69, 0xa8, 0x46, 0xfc, 0x0c, 0x54, 0xf9, 0xe5, 0x7b, 0xd4, 0xf8, 0x27,
      0xc0, 0xb7, 0x80, 0xc3, 0x0d, 0xcf, 0x86, 0x61, 0xcf, 0x4b, 0xb6, 0x78,
      0xee, 0x03, 0x96, 0xbf, 0x8e, 0x0a, 0x08, 0xd2, 0x59, 0x59, 0x31, 0x70,
      0xdf, 0xf3, 0xf9, 0x3d, 0xfd, 0xe9, 0xf4, 0xd9, 0xce, 0xd5, 0x10, 0xe0,
      0x7a, 0x27, 0x36, 0xc8, 0x72, 0x7d, 0x2f, 0x9e, 0x97, 0x3e, 0x32, 0x52,
      0x4e, 0x07, 0x2a, 0x92, 0xdb, 0xa8, 0xed, 0xb2, 0xd1, 0x62, 0x8d, 0xa0,
      0x37, 0x41, 0xd2, 0x27, 0x25, 0x59, 0x14, 0x71, 0x74, 0x45, 0x40, 0x71,
      0x11, 0xee, 0xfa, 0xaa, 0x88, 0x9f, 0xeb, 0xfc, 0x6f, 0x4b, 0x0d, 0x42,
      0xdd, 0x95, 0x89, 0x37, 0x71, 0x0b, 0xa5, 0xe9, 0x44, 0x14, 0xa2, 0x6e,
      0x09, 0xcb, 0x3f, 0x5c},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 64
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     64,
     0,
     {0x60, 0x1f, 0x64, 0x31, 0xb0, 0x60, 0x7c, 0x80, 0xd5, 0xc9, 0x2c, 0x86,
      0xa6, 0x3d, 0x06, 0xfc, 0xd8, 0x62, 0xbb, 0x35, 0xed, 0xa3, 0x1a, 0x7f,
      0x33, 0x1a, 0x59, 0xab, 0xbb, 0x8e, 0xc1, 0x8f, 0xbc, 0x86, 0xec, 0x95,
      0xad, 0x63, 0x72, 0x32, 0x16, 0xe1, 0x51, 0xb7, 0xbf, 0x73, 0x13, 0x5c,
      0x02, 0x8a, 0x5a, 0xc3, 0xb4, 0x5f, 0x30, 0xa7, 0xff, 0x8e, 0xa4, 0x3d,
      0x5d, 0xfa, 0x6a, 0x52, 0xf5, 0xfe, 0x14, 0x05, 0xe6, 0xf5, 0xd6, 0x4a,
      0xbc, 0x49, 0x99, 0xf8, 0xc5, 0x80, 0x70, 0x1b, 0xd9, 0xe4, 0x51, 0xbc,
      0xf6, 0xd5, 0x4b, 0xf0, 0xbd, 0x1c, 0x83, 0xc7, 0xe0, 0x39, 0x9e, 0x78,
      0x05, 0x75, 0x7c, 0xf4, 0x36, 0x16, 0x4f, 0x36, 0x5e, 0xe7, 0x6f, 0x29,
      0x43, 0x38, 0x61, 0x85, 0x6b, 0x67, 0xb6, 0xcb, 0xd8, 0xb2, 0x35, 0x36,
      0x57, 0x86, 0xc2, 0xde, 0x9b, 0x30, 0x5e, 0x32, 0x93, 0x79, 0x22, 0x02,
      0xe1, 0x84, 0x8f, 0x95, 0x95, 0x26, 0x5e, 0xd6, 0xfd, 0x4b, 0x17, 0x40,
      0xbc, 0xbc, 0xc6, 0x97, 0xd7, 0x19, 0xff, 0x70, 0xb9, 0x20, 0x0e, 0x65,
      0xd7, 0x71, 0x14, 0x94, 0xe1, 0x88, 0x55, 0xfa, 0xc3, 0x6b, 0xf9, 0x48,
      0x7b, 0x54, 0x79, 0x8f, 0x39, 0xd5, 0xa3, 0x2b, 0x5d, 0x62, 0xdd, 0xe3,
      0xde, 0x2c, 0x3b, 0x5f, 0x8f, 0x7f, 0x4b, 0xba, 0xf3, 0xea, 0x04, 0xe1,
      0x1c, 0xc8, 0xa4, 0xf6, 0x24, 0x7e, 0x25, 0xc8, 0xa3, 0xa4, 0xe0, 0x5d,
      0x83, 0x11, 0x99, 0xd1, 0x4c, 0xf4, 0x4e, 0xcc, 0x8e, 0x66, 0xc8, 0xca,
      0x38, 0x83, 0xb5, 0xaa, 0xac, 0x3e, 0xb5, 0x88, 0x9b, 0x23, 0xde, 0xa6,
      0xba, 0x66, 0x49, 0xc8, 0xa6, 0x9c, 0xfe, 0xd5, 0x47, 0xca, 0x93, 0x6a,
      0x57, 0xb2, 0x20, 0xc4, 0x4b, 0x8e, 0xb8, 0x60, 0x4c, 0x8d, 0xbd, 0x81,
      0xa3, 0x50, 0x01, 0x16},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of m_hash modified
    // tcID: 65
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     65,
     0,
     {0x2a, 0x31, 0x52, 0x41, 0x93, 0x05, 0x43, 0x09, 0xce, 0x7b, 0x6a, 0xe9,
      0xc4, 0xbb, 0x05, 0x3f, 0x5a, 0x5a, 0xed, 0x27, 0x3d, 0x7a, 0x4a, 0x60,
      0x94, 0x96, 0xc7, 0x20, 0x5f, 0x50, 0x77, 0xdd, 0xc7, 0x46, 0xe8, 0xa4,
      0xea, 0x37, 0x6b, 0xb8, 0x79, 0x55, 0x6d, 0x49, 0x99, 0xe7, 0x88, 0xfc,
      0x8f, 0x82, 0x37, 0x8f, 0x62, 0x81, 0x14, 0x06, 0x63, 0xaf, 0x2f, 0xe0,
      0x99, 0x5a, 0x1b, 0x73, 0xee, 0xef, 0x60, 0x34, 0x1d, 0x07, 0x20, 0xce,
      0x47, 0x28, 0x2e, 0xb8, 0x7b, 0xb7, 0x99, 0x08, 0xbe, 0x8c, 0x3f, 0xfe,
      0x86, 0x18, 0x2d, 0x17, 0x4a, 0xfd, 0x05, 0x22, 0xa8, 0x7f, 0xa5, 0x6e,
      0x0d, 0x14, 0x9a, 0xb4, 0xc3, 0x22, 0x92, 0xca, 0x1d, 0x1a, 0x84, 0x78,
      0xad, 0x40, 0x90, 0x00, 0x6b, 0x32, 0xa1, 0x47, 0xff, 0xe4, 0x30, 0x34,
      0x87, 0x19, 0x6d, 0x30, 0x8d, 0xd5, 0x9f, 0x81, 0xef, 0xf9, 0x56, 0xbd,
      0x6c, 0xa8, 0x7e, 0xe0, 0x24, 0x69, 0x27, 0xe2, 0x79, 0xbf, 0x80, 0x80,
      0x7e, 0xf4, 0x58, 0x29, 0x82, 0x4c, 0x80, 0xb8, 0x2f, 0x74, 0x42, 0x02,
      0x1b, 0xcc, 0xd8, 0xce, 0x45, 0x13, 0xcb, 0xd4, 0xd4, 0x15, 0x0f, 0xff,
      0x20, 0xdd, 0xc2, 0xea, 0x94, 0x2e, 0xf3, 0x18, 0x45, 0x52, 0x65, 0xb5,
      0x66, 0x7a, 0x74, 0xeb, 0xbe, 0xb8, 0x3a, 0x05, 0xd1, 0x5f, 0x32, 0x15,
      0xc0, 0x4b, 0x11, 0x3c, 0x8b, 0x55, 0xec, 0x8b, 0xe5, 0x12, 0xe7, 0x97,
      0xa3, 0xac, 0xe1, 0x5d, 0x25, 0x14, 0xc2, 0xbb, 0x74, 0xf5, 0x0e, 0x09,
      0x69, 0xeb, 0x1a, 0x22, 0x91, 0xfd, 0xb6, 0xfd, 0xea, 0x1a, 0xf0, 0xcb,
      0xea, 0x6f, 0x05, 0x93, 0x7b, 0xe6, 0x14, 0x00, 0x3c, 0x15, 0x69, 0xb6,
      0x48, 0xc2, 0x01, 0x2e, 0xc5, 0xdc, 0xde, 0x80, 0x6f, 0x68, 0xe2, 0x47,
      0x59, 0x7b, 0xcc, 0xe6},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in m_hash flipped
    // tcID: 66
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     66,
     0,
     {0x82, 0x91, 0xcb, 0xd8, 0x15, 0x29, 0xc8, 0xf1, 0xe2, 0x7a, 0x90, 0x7d,
      0xfe, 0xf2, 0xde, 0x16, 0xdc, 0x6d, 0x38, 0x2b, 0x11, 0x2c, 0xc3, 0xd2,
      0xd6, 0x9f, 0x4c, 0x69, 0x15, 0xe7, 0xc6, 0x99, 0x2e, 0xea, 0xc6, 0xe4,
      0xb8, 0x2f, 0x53, 0x96, 0xa4, 0x6e, 0xab, 0x56, 0x28, 0x58, 0x83, 0x5a,
      0xb0, 0xc0, 0xae, 0xe6, 0x3d, 0x25, 0x85, 0xdc, 0x75, 0x37, 0xdc, 0x00,
      0x08, 0xa4, 0xb4, 0x08, 0x03, 0x46, 0x7a, 0xbd, 0x5f, 0xdc, 0xa4, 0x11,
      0x42, 0x82, 0x26, 0x5c, 0x2b, 0xd9, 0x29, 0xa0, 0x3c, 0x78, 0x92, 0x77,
      0x4a, 0x21, 0xed, 0x64, 0x54, 0xe7, 0x36, 0x84, 0x67, 0x3d, 0x64, 0x48,
      0xb1, 0x95, 0x55, 0xd0, 0xcb, 0xa9, 0xe4, 0xc0, 0x0c, 0x99, 0xaf, 0x77,
      0xb3, 0x0f, 0x1d, 0xaa, 0x4b, 0x15, 0xee, 0xf8, 0x48, 0x9e, 0x15, 0xa2,
      0x76, 0xfe, 0xd1, 0x55, 0x3e, 0x61, 0x7a, 0x64, 0xdc, 0x58, 0xd5, 0xdf,
      0xf3, 0xc0, 0x58, 0x53, 0xa7, 0x03, 0x90, 0x47, 0xd2, 0x43, 0xc5, 0x2e,
      0x53, 0xf7, 0xdc, 0xfc, 0x40, 0x64, 0x1b, 0xb9, 0xac, 0xc3, 0x3e, 0xd9,
      0x6c, 0x74, 0xc7, 0x9c, 0x93, 0xb7, 0x9f, 0x32, 0x56, 0x6c, 0xf5, 0x53,
      0x42, 0x8c, 0xf8, 0x5d, 0x2d, 0x36, 0xa0, 0x70, 0xc8, 0x9f, 0x1e, 0xce,
      0xb4, 0x60, 0x6f, 0xd2, 0x85, 0xf7, 0xba, 0x3d, 0xde, 0xf7, 0x0f, 0xf1,
      0x51, 0xed, 0x0f, 0xd3, 0xa5, 0xb6, 0xc5, 0x33, 0x8e, 0xb2, 0xf8, 0x12,
      0xcb, 0x4c, 0xf4, 0x82, 0x7c, 0xae, 0xf0, 0xb8, 0x96, 0xa1, 0xd4, 0x9f,
      0x49, 0xe2, 0xc3, 0x04, 0x94, 0x62, 0xd0, 0x7d, 0x0e, 0x64, 0xd3, 0x3f,
      0x1e, 0x2c, 0x61, 0x5c, 0x62, 0xa9, 0x58, 0xab, 0xb6, 0x94, 0x2d, 0x9a,
      0xc8, 0xfd, 0xc3, 0x9a, 0xcc, 0x59, 0x5c, 0xd3, 0x81, 0xae, 0xad, 0x07,
      0x5a, 0xb7, 0xb5, 0x1c},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 20
    // tcID: 67
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     67,
     0,
     {0x57, 0xe8, 0xcc, 0x1d, 0xc0, 0x0c, 0x07, 0x38, 0x3d, 0x89, 0xa7, 0x9b,
      0x5c, 0x8e, 0x4f, 0x5b, 0xde, 0x2a, 0x2b, 0xa5, 0x5a, 0x3c, 0x72, 0x01,
      0xb3, 0x29, 0x1c, 0x4d, 0x80, 0x5b, 0x1b, 0x2e, 0xb3, 0x6f, 0x8f, 0x32,
      0x6b, 0x54, 0x23, 0x42, 0xda, 0x18, 0x0a, 0xbe, 0x50, 0x86, 0x69, 0xbb,
      0x6c, 0xc2, 0xdd, 0x54, 0xe3, 0x27, 0xbc, 0x70, 0xc1, 0xe3, 0x17, 0xba,
      0x93, 0xa0, 0xfd, 0x21, 0xe7, 0xfc, 0xe2, 0x2a, 0x0c, 0x59, 0x7c, 0x74,
      0x20, 0xd1, 0xd5, 0x60, 0x2a, 0xc4, 0x3d, 0x93, 0x48, 0xba, 0x3e, 0xba,
      0x56, 0x1f, 0x25, 0x0e, 0x30, 0x1a, 0xb9, 0x55, 0xb0, 0xdc, 0x33, 0xe4,
      0xab, 0xde, 0x32, 0x94, 0x6b, 0x9b, 0x3e, 0x86, 0xc8, 0xbf, 0x07, 0xa4,
      0x46, 0x46, 0xca, 0x59, 0x59, 0x60, 0xbb, 0x98, 0x8f, 0xef, 0x04, 0xb2,
      0x82, 0x49, 0x67, 0xe9, 0xda, 0x8b, 0x02, 0x64, 0xf1, 0xda, 0x06, 0x59,
      0x37, 0x39, 0x35, 0x31, 0x3a, 0x57, 0x4b, 0x53, 0x80, 0xf0, 0xb5, 0x4c,
      0xe1, 0xbc, 0x0d, 0xde, 0x42, 0x3b, 0xd3, 0xa5, 0x4f, 0x6a, 0xe5, 0xfa,
      0xfa, 0x77, 0x2a, 0x55, 0xc1, 0xc4, 0x4e, 0xb6, 0xed, 0xff, 0xec, 0xf1,
      0x3e, 0x6e, 0x5e, 0x1e, 0xda, 0xf8, 0x7a, 0x79, 0xe3, 0x38, 0x57, 0x73,
      0x04, 0x14, 0x1f, 0xbc, 0x44, 0xf0, 0xe9, 0xee, 0xb2, 0x86, 0xf5, 0x53,
      0xf8, 0x79, 0xad, 0xdd, 0x6e, 0x12, 0xe4, 0x36, 0xfa, 0x3a, 0xf5, 0x1a,
      0xd5, 0x3a, 0x72, 0xf2, 0x67, 0x9f, 0x0e, 0xd1, 0x02, 0xd5, 0x04, 0xee,
      0x08, 0x70, 0x6f, 0xe1, 0x11, 0xea, 0xee, 0x49, 0xd8, 0x80, 0xd1, 0xa0,
      0xb9, 0x19, 0x24, 0xb3, 0xb7, 0x99, 0x68, 0xed, 0x0f, 0x9b, 0xff, 0x44,
      0x6d, 0xac, 0x19, 0x9e, 0xe8, 0x9b, 0x15, 0x8c, 0x07, 0x49, 0x27, 0xd2,
      0x7b, 0x86, 0x44, 0x98},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s_len changed to 32
    // tcID: 68
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     68,
     0,
     {0x68, 0xca, 0xf0, 0x7e, 0x71, 0xee, 0x65, 0x4f, 0xfa, 0xbf, 0x07, 0xd3,
      0x42, 0xfc, 0x40, 0x59, 0xde, 0xb4, 0xf7, 0xe5, 0x97, 0x07, 0x46, 0xc4,
      0x23, 0xb1, 0xe8, 0xf6, 0x68, 0xd5, 0x33, 0x22, 0x75, 0xcc, 0x35, 0xeb,
      0x61, 0x27, 0x0a, 0xeb, 0xd2, 0x78, 0x55, 0xb1, 0xe8, 0x0d, 0x59, 0xde,
      0xf4, 0x7f, 0xe8, 0x88, 0x28, 0x67, 0xfd, 0x33, 0xc2, 0x30, 0x8c, 0x91,
      0x97, 0x6b, 0xaa, 0x0b, 0x1d, 0xf9, 0x52, 0xca, 0xa7, 0x8d, 0xb4, 0x82,
      0x8a, 0xb8, 0x1e, 0x79, 0x94, 0x9b, 0xf1, 0x45, 0xcb, 0xdf, 0xd1, 0xc4,
      0x98, 0x7e, 0xd0, 0x36, 0xf8, 0x1e, 0x84, 0x42, 0x08, 0x10, 0x16, 0xf2,
      0x0f, 0xa4, 0xb5, 0x87, 0x57, 0x48, 0x84, 0xca, 0x6f, 0x60, 0x45, 0x95,
      0x9c, 0xe3, 0x50, 0x1a, 0xe7, 0xc0, 0x2b, 0x19, 0x02, 0xec, 0x1d, 0x24,
      0x1e, 0xf2, 0x8d, 0xee, 0x35, 0x6c, 0x0d, 0x30, 0xd2, 0x8a, 0x95, 0x0f,
      0x1f, 0xbc, 0x68, 0x3e, 0xe7, 0xd9, 0xaa, 0xd2, 0x6b, 0x04, 0x8c, 0x13,
      0x42, 0x6f, 0xe3, 0x97, 0x5d, 0x56, 0x38, 0xaf, 0xeb, 0x5b, 0x9c, 0x1a,
      0x99, 0xd1, 0x62, 0xd3, 0xa5, 0x81, 0x0e, 0x8b, 0x07, 0x4d, 0x7a, 0x2e,
      0xae, 0x2b, 0xe5, 0x2b, 0x57, 0x71, 0x51, 0xf7, 0x6e, 0x1f, 0x73, 0x4b,
      0x0a, 0x95, 0x6e, 0xf4, 0xf2, 0x2b, 0xe6, 0x4d, 0xc2, 0x0a, 0x81, 0xad,
      0x13, 0x16, 0xe4, 0xf7, 0x9d, 0xff, 0x5f, 0xc4, 0x1f, 0xc0, 0x8a, 0x20,
      0xbc, 0x61, 0x22, 0x83, 0xa8, 0x84, 0x15, 0xd4, 0x15, 0x95, 0xbf, 0xea,
      0x66, 0xd5, 0x9d, 0xe7, 0xac, 0x12, 0xe2, 0x30, 0xf7, 0x22, 0x44, 0xad,
      0x99, 0x05, 0xae, 0xf0, 0xea, 0xd3, 0xfa, 0x41, 0xed, 0x70, 0xbf, 0x42,
      0x18, 0x86, 0x3d, 0x5f, 0x04, 0x12, 0x92, 0xf2, 0xd1, 0x4c, 0xe0, 0xa7,
      0x27, 0x1c, 0x6d, 0x36},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: byte 0 in zero padding modified
    // tcID: 69
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     69,
     0,
     {0x1a, 0xbb, 0x40, 0xf0, 0x3d, 0xbe, 0x5b, 0x4f, 0x13, 0x65, 0x86, 0x2d,
      0x9f, 0x09, 0x5a, 0x8d, 0x57, 0xe8, 0x92, 0x25, 0x65, 0x37, 0x2f, 0x0b,
      0x34, 0xef, 0x5e, 0x23, 0x24, 0x41, 0xd5, 0x77, 0xb3, 0xc1, 0xf1, 0x9a,
      0x24, 0x0e, 0xbd, 0xa8, 0x80, 0xa0, 0x9c, 0xb4, 0x1a, 0x72, 0x67, 0x73,
      0x26, 0x23, 0xb0, 0xfa, 0xa4, 0x14, 0x84, 0x3f, 0x9e, 0xf0, 0x63, 0xf9,
      0x3a, 0x92, 0xbf, 0xe5, 0xf9, 0x8f, 0x7c, 0x28, 0xda, 0x18, 0x4f, 0x01,
      0x1a, 0xa7, 0x87, 0xeb, 0xd0, 0xb5, 0xfd, 0xa4, 0xae, 0xc1, 0xbe, 0xab,
      0x67, 0x57, 0xad, 0xd3, 0x2f, 0x7a, 0x35, 0xcb, 0x40, 0x77, 0x79, 0xaa,
      0xce, 0xf4, 0x3c, 0x04, 0x29, 0x28, 0x0e, 0x5a, 0x04, 0x0c, 0xf5, 0x94,
      0x3d, 0xfb, 0x57, 0x9f, 0x86, 0xe0, 0xc6, 0x3c, 0xc8, 0x28, 0xfb, 0xca,
      0xfc, 0x9c, 0x8a, 0x15, 0xec, 0x98, 0xfb, 0x64, 0xec, 0xb5, 0xe2, 0x95,
      0xdc, 0x36, 0x0f, 0x50, 0x23, 0x0f, 0x41, 0x53, 0x37, 0xaa, 0xac, 0x6f,
      0xca, 0xc0, 0x2f, 0xe6, 0x25, 0xef, 0x61, 0x74, 0x44, 0x88, 0xeb, 0x7c,
      0xd8, 0x1a, 0x4e, 0x78, 0x8a, 0x44, 0x3f, 0x56, 0xb3, 0x2b, 0xb3, 0xa7,
      0xa3, 0x44, 0x90, 0x08, 0x06, 0x95, 0x2f, 0x6f, 0x3f, 0x55, 0xf8, 0xd9,
      0xe9, 0x21, 0x7d, 0xda, 0xf0, 0x6a, 0x0f, 0xfe, 0x8b, 0x0b, 0xf5, 0x55,
      0x1d, 0x87, 0xcc, 0x92, 0x51, 0xd8, 0x39, 0x44, 0x1c, 0xdb, 0x3c, 0x72,
      0xae, 0x9c, 0x6a, 0x5a, 0x3d, 0xe7, 0xab, 0x85, 0xf9, 0x08, 0xae, 0x7d,
      0x04, 0x23, 0x2c, 0x52, 0x14, 0x3d, 0x27, 0x2e, 0x87, 0xa5, 0x4c, 0x5b,
      0x39, 0xd3, 0x99, 0xb4, 0x9c, 0xa7, 0xe9, 0x6e, 0xdd, 0x3b, 0x6e, 0x22,
      0xc2, 0x96, 0xde, 0x69, 0xe9, 0xe1, 0x84, 0x80, 0x38, 0x02, 0x57, 0x80,
      0xe4, 0xf1, 0xac, 0x29},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: byte 7 in zero padding modified
    // tcID: 70
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     70,
     0,
     {0xa1, 0x1b, 0xd4, 0xfd, 0xd3, 0x0f, 0xb3, 0x53, 0x31, 0x45, 0x30, 0xd6,
      0x0b, 0x1c, 0xd9, 0x21, 0xd6, 0x09, 0x16, 0x58, 0xe0, 0xc7, 0x75, 0x43,
      0x2b, 0x6b, 0x70, 0x2b, 0x15, 0x63, 0xa9, 0xe5, 0xb5, 0x47, 0xf9, 0x68,
      0xac, 0x13, 0xac, 0x5b, 0x70, 0x27, 0xae, 0xb5, 0x3e, 0xa8, 0x98, 0x7c,
      0x94, 0x41, 0xfb, 0xca, 0xf4, 0x14, 0xbd, 0x04, 0x43, 0x44, 0x45, 0xb2,
      0xce, 0x6a, 0x1d, 0x9d, 0xea, 0x2f, 0x2f, 0x17, 0x9a, 0x6d, 0x40, 0x34,
      0x2a, 0x25, 0xb1, 0x03, 0x00, 0xd4, 0x53, 0x58, 0xf7, 0x03, 0xf8, 0x14,
      0x91, 0x78, 0x70, 0xf0, 0xa4, 0x7f, 0x4b, 0x4a, 0xc4, 0x72, 0x28, 0x57,
      0x40, 0x96, 0xff, 0x24, 0x0a, 0xb0, 0x96, 0x6b, 0xb7, 0x7e, 0xa9, 0xb5,
      0x15, 0x5c, 0x6a, 0x4f, 0xa0, 0xa1, 0x85, 0xce, 0x5d, 0x38, 0x9c, 0x6c,
      0xe2, 0x88, 0x21, 0x26, 0x26, 0x98, 0xbe, 0xad, 0xd0, 0xfb, 0xec, 0x4b,
      0xa2, 0xb6, 0x63, 0x89, 0xd6, 0x10, 0xf2, 0x90, 0x65, 0x6b, 0x7a, 0x4f,
      0x7e, 0xa1, 0xf4, 0xa3, 0xc4, 0x4b, 0x35, 0x28, 0xbf, 0x62, 0xf7, 0x2a,
      0xbf, 0x79, 0x35, 0xe0, 0xd8, 0xb6, 0xcf, 0xc2, 0xdb, 0x94, 0x7e, 0x44,
      0x07, 0x52, 0x41, 0x0a, 0x43, 0xa0, 0xef, 0x77, 0xc0, 0xdc, 0x31, 0xb5,
      0x8b, 0xe0, 0x21, 0xb9, 0x41, 0x18, 0xe5, 0xe0, 0xca, 0xb1, 0xd8, 0x99,
      0x4e, 0x76, 0xdd, 0xff, 0xcc, 0x2e, 0x5d, 0x55, 0xfa, 0x59, 0xd1, 0xba,
      0x79, 0x2f, 0xda, 0x9d, 0xb2, 0xb5, 0xba, 0x9e, 0xc6, 0xf6, 0xba, 0xc3,
      0x95, 0xc2, 0x50, 0xe2, 0xb8, 0xff, 0x24, 0x5a, 0x44, 0x8b, 0x61, 0x17,
      0x97, 0x32, 0x2b, 0xce, 0x63, 0x7c, 0x0b, 0x15, 0x37, 0xc9, 0x76, 0x5a,
      0x84, 0x98, 0xe0, 0xe0, 0x37, 0x1a, 0xf2, 0xf8, 0xec, 0x15, 0xf3, 0x2e,
      0x76, 0x5e, 0xe2, 0x34},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes in zero padding modified
    // tcID: 71
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     71,
     0,
     {0x83, 0x67, 0x3b, 0xf6, 0xd1, 0x78, 0xe8, 0x73, 0xe9, 0x86, 0xc9, 0xa9,
      0x75, 0x0b, 0xef, 0xdf, 0x2d, 0x6a, 0x3f, 0x01, 0x28, 0xec, 0x90, 0xb5,
      0xa8, 0x05, 0x9d, 0x32, 0xf9, 0xf9, 0x59, 0x23, 0x49, 0x09, 0x5e, 0x24,
      0xf8, 0x8e, 0x9f, 0xc4, 0x8a, 0xe5, 0x49, 0x00, 0x9f, 0x52, 0xb4, 0xd8,
      0x21, 0xfd, 0x40, 0x84, 0x8a, 0x9a, 0xce, 0xae, 0xc2, 0x52, 0x37, 0x4b,
      0x17, 0xd4, 0x95, 0x02, 0x96, 0xe3, 0x0b, 0x3f, 0xf4, 0x89, 0xd4, 0x20,
      0xb8, 0xda, 0xae, 0xf4, 0x74, 0x88, 0x69, 0x67, 0x62, 0xae, 0x4c, 0xc5,
      0x5a, 0xde, 0x17, 0x0c, 0x5e, 0x0d, 0x72, 0xe6, 0x96, 0xaf, 0x79, 0x3d,
      0x5c, 0xfa, 0x04, 0x47, 0x7c, 0x14, 0x77, 0x32, 0x32, 0x8e, 0x27, 0x59,
      0x99, 0x74, 0x6c, 0x36, 0x80, 0xc3, 0xdc, 0xa7, 0x01, 0x59, 0x2b, 0x17,
      0xbb, 0x37, 0xdd, 0x8c, 0x5e, 0xeb, 0x3a, 0x92, 0x9f, 0x93, 0x2a, 0x35,
      0x21, 0xa8, 0x00, 0x4c, 0x10, 0xc9, 0xe3, 0xee, 0xd8, 0xd9, 0x56, 0x83,
      0x5a, 0x70, 0x0c, 0xab, 0xca, 0x21, 0x03, 0x8a, 0x9d, 0x6d, 0xde, 0x44,
      0xf8, 0x88, 0x33, 0x6c, 0x16, 0x7c, 0x04, 0xac, 0x26, 0xe8, 0x00, 0xa9,
      0x91, 0x30, 0xa6, 0xe1, 0xd3, 0xb3, 0xbd, 0x80, 0x61, 0xda, 0xfd, 0x2b,
      0x46, 0x21, 0x02, 0x24, 0x9f, 0xd0, 0x7d, 0xc5, 0x0a, 0x2e, 0x57, 0xa8,
      0xc6, 0xcd, 0x52, 0x38, 0x1f, 0xd4, 0xe1, 0xbf, 0xdb, 0xab, 0x18, 0xfd,
      0x60, 0x2c, 0x88, 0x90, 0xd5, 0x1e, 0x80, 0x53, 0xc3, 0xc2, 0xab, 0x5c,
      0x96, 0xba, 0xe2, 0x84, 0x7b, 0x55, 0x39, 0xae, 0xd3, 0xad, 0x83, 0x95,
      0x3f, 0x47, 0x84, 0x1f, 0x8f, 0x50, 0xfa, 0x28, 0x44, 0x6d, 0x30, 0xc2,
      0x0b, 0x2b, 0x7d, 0xd8, 0xab, 0xf4, 0xe4, 0x9c, 0x06, 0x36, 0x43, 0x7c,
      0x22, 0x83, 0x3b, 0xa9},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 72
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     72,
     0,
     {0x90, 0xc3, 0xcb, 0x33, 0x31, 0xe8, 0xb3, 0x52, 0xc3, 0x7d, 0xb4, 0x62,
      0x83, 0xa1, 0xa6, 0x6b, 0x64, 0x7e, 0xcc, 0xa4, 0x3e, 0x34, 0x61, 0xce,
      0x1a, 0xfc, 0x49, 0xd6, 0x23, 0x04, 0x57, 0x34, 0x1a, 0x52, 0xb5, 0x58,
      0x49, 0x6f, 0xf8, 0x30, 0x53, 0x17, 0x5a, 0x7b, 0xfb, 0x47, 0x55, 0xa1,
      0xbe, 0xf0, 0xe6, 0x5f, 0x47, 0x0d, 0x61, 0x39, 0xea, 0xaa, 0x28, 0xcc,
      0x1c, 0x08, 0x39, 0x05, 0x85, 0x9c, 0x14, 0x75, 0x86, 0x8c, 0xeb, 0x1e,
      0x38, 0x29, 0x43, 0x7f, 0x64, 0xa7, 0xad, 0x75, 0x7c, 0x9d, 0xa3, 0xb6,
      0xe8, 0x44, 0x3e, 0x8f, 0x98, 0x1f, 0x5c, 0x07, 0x24, 0xc5, 0x90, 0x9b,
      0xd4, 0xeb, 0xcf, 0xa6, 0x5e, 0xea, 0x4e, 0x4f, 0x7a, 0xf5, 0x22, 0x2d,
      0xba, 0x64, 0xa5, 0x12, 0x28, 0x75, 0x9c, 0x69, 0xe2, 0x6c, 0x44, 0xd9,
      0xa5, 0x28, 0xd7, 0x5a, 0x5b, 0x96, 0x85, 0x52, 0x53, 0xda, 0x88, 0xf9,
      0xb5, 0x47, 0x44, 0xb1, 0xa8, 0xb0, 0x23, 0x28, 0x39, 0x4c, 0x45, 0x2e,
      0x62, 0xef, 0x75, 0xcd, 0x69, 0xf7, 0xde, 0xf6, 0x7b, 0x80, 0xe4, 0x85,
      0x9b, 0xa3, 0xe7, 0x3b, 0x08, 0xa2, 0xa3, 0xff, 0x93, 0x1f, 0x44, 0xd1,
      0xd5, 0x24, 0x32, 0x0a, 0x33, 0x41, 0x6b, 0xf4, 0xfc, 0x74, 0x48, 0x47,
      0xd1, 0x2e, 0x3e, 0x97, 0x3c, 0xb8, 0x70, 0xfd, 0xc3, 0xac, 0x1b, 0xdb,
      0xac, 0xb6, 0x77, 0xbc, 0xc6, 0x3f, 0x92, 0x73, 0x66, 0xf4, 0xd0, 0xd6,
      0x1e, 0xe3, 0xbc, 0x0d, 0x1a, 0x1b, 0x3d, 0x14, 0x96, 0x72, 0xc6, 0x39,
      0x8f, 0x34, 0x09, 0xfe, 0x9e, 0x7c, 0x7c, 0x0a, 0x15, 0x05, 0x71, 0x57,
      0x3b, 0x87, 0x88, 0x9b, 0x4f, 0x23, 0xef, 0x49, 0xb6, 0xf5, 0x98, 0x44,
      0x12, 0x64, 0x2e, 0x5b, 0x0a, 0xbe, 0x7f, 0x5e, 0xc4, 0xb4, 0xcf, 0x12,
      0xc4, 0x6a, 0x38, 0xf4},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of hash h modified
    // tcID: 73
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     73,
     0,
     {0x7a, 0x73, 0x18, 0x79, 0x94, 0x77, 0xeb, 0x6d, 0xa5, 0x5c, 0x7b, 0x5f,
      0x6a, 0x03, 0x38, 0x07, 0x1d, 0x98, 0x10, 0x11, 0xe1, 0xa9, 0xbc, 0x6f,
      0xa3, 0xa2, 0x25, 0x8c, 0xa5, 0xca, 0xa0, 0x39, 0xfc, 0x7f, 0x76, 0x82,
      0x34, 0xcc, 0x08, 0xe4, 0x25, 0x32, 0x3f, 0x57, 0x69, 0x1c, 0xbc, 0xf5,
      0xf8, 0x3d, 0x6a, 0x34, 0x39, 0xa6, 0x39, 0x81, 0x8c, 0x6b, 0x2b, 0xd3,
      0xa8, 0x60, 0xc9, 0xa6, 0xb9, 0xa8, 0xe0, 0x72, 0x8a, 0xa7, 0xdd, 0xff,
      0xe1, 0x8f, 0x82, 0xc0, 0x28, 0x54, 0xca, 0x07, 0xb1, 0x7d, 0xb0, 0xf1,
      0x66, 0xd2, 0xe5, 0x21, 0xad, 0xa5, 0xc1, 0xf8, 0x5d, 0x0c, 0x2f, 0x25,
      0x93, 0x01, 0xd3, 0xf4, 0xb4, 0xf1, 0x38, 0x0f, 0x94, 0xbb, 0x81, 0x9d,
      0xcf, 0xac, 0x9a, 0xdb, 0x76, 0x4a, 0x19, 0x80, 0x91, 0xe1, 0x10, 0xf0,
      0xd3, 0xc5, 0xfb, 0xe2, 0x0a, 0x29, 0x36, 0x6f, 0xa5, 0x2d, 0x24, 0x6c,
      0xc9, 0x22, 0xbf, 0xd2, 0xb4, 0x4a, 0x61, 0x9b, 0x59, 0xb4, 0x97, 0xa5,
      0x37, 0x92, 0x82, 0xee, 0x30, 0x60, 0x8f, 0x42, 0x43, 0xf7, 0x32, 0x8c,
      0xa8, 0xae, 0xc2, 0x0f, 0x61, 0xaa, 0x8b, 0x40, 0x83, 0xab, 0xd1, 0xc2,
      0x06, 0xfb, 0xc9, 0xea, 0x59, 0x8d, 0x16, 0x3e, 0x52, 0xda, 0x10, 0x26,
      0xae, 0x34, 0x9d, 0x26, 0x46, 0x9e, 0x22, 0x44, 0xb8, 0x61, 0x39, 0x89,
      0x5f, 0x80, 0xec, 0x4e, 0x8b, 0x6f, 0x59, 0x65, 0xa2, 0x8a, 0xc4, 0xe9,
      0x63, 0x6e, 0xc3, 0xb1, 0xe5, 0xd6, 0x85, 0x48, 0x3a, 0x04, 0x75, 0xfa,
      0x64, 0x54, 0x21, 0xed, 0x6e, 0xe9, 0x63, 0x3f, 0x27, 0x6a, 0xa4, 0x00,
      0x0e, 0xef, 0xb1, 0x73, 0xb5, 0xff, 0xe8, 0x24, 0xd3, 0x8a, 0x4d, 0x7e,
      0x24, 0x14, 0x6e, 0x4a, 0x6a, 0xde, 0xdc, 0x3f, 0xfd, 0xe4, 0x52, 0x1d,
      0xab, 0x87, 0x91, 0x20},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 74
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     74,
     0,
     {0x33, 0x17, 0x56, 0xb9, 0x2b, 0x34, 0x63, 0x79, 0xe1, 0xc5, 0x0d, 0xea,
      0x5e, 0x05, 0xd9, 0x29, 0x12, 0xea, 0xbc, 0x56, 0x89, 0x05, 0xd7, 0xf2,
      0x90, 0xed, 0x35, 0x3e, 0x70, 0x56, 0x71, 0xf0, 0xf5, 0xa4, 0x39, 0x21,
      0xd7, 0x1c, 0xef, 0x11, 0xfa, 0x2c, 0xc2, 0x3c, 0x95, 0x4e, 0xf2, 0x7e,
      0xeb, 0xfb, 0xae, 0xc7, 0x7a, 0x33, 0x14, 0x7b, 0x5c, 0x64, 0x08, 0xb7,
      0xfb, 0x8b, 0xa9, 0xd8, 0xe3, 0xcc, 0xd5, 0xaf, 0x54, 0x19, 0x42, 0xa9,
      0x46, 0xbf, 0x05, 0x7d, 0x39, 0xac, 0x34, 0xe9, 0x54, 0xca, 0x3e, 0xb3,
      0x08, 0x44, 0x9a, 0x9a, 0x8f, 0xed, 0x15, 0xf7, 0x60, 0xd9, 0x39, 0x2c,
      0x32, 0x61, 0x8c, 0x28, 0x99, 0x93, 0xb3, 0x88, 0x75, 0xdf, 0x41, 0x2d,
      0x46, 0x05, 0x00, 0xed, 0x0a, 0xc7, 0xd9, 0xb7, 0x9b, 0x0c, 0x34, 0xe8,
      0xa6, 0x43, 0x10, 0xad, 0x4c, 0xb0, 0xe7, 0xd6, 0xdd, 0x1d, 0xd8, 0xad,
      0x6a, 0xa8, 0x16, 0x83, 0xa3, 0x42, 0x06, 0x18, 0x78, 0x3a, 0x31, 0x5b,
      0x26, 0x43, 0xf7, 0xe8, 0xc8, 0xa9, 0x57, 0x34, 0xaa, 0x1e, 0xa5, 0x26,
      0x75, 0x2b, 0xca, 0x4d, 0x44, 0x3a, 0x18, 0x22, 0x4c, 0xed, 0x3d, 0x2a,
      0x07, 0xbb, 0xb7, 0x34, 0xd0, 0x16, 0x29, 0x48, 0x3f, 0x5c, 0x8b, 0x91,
      0xd9, 0x49, 0x26, 0x91, 0x6e, 0x86, 0xee, 0x43, 0x0f, 0x4f, 0x6f, 0x07,
      0xc4, 0x0d, 0x58, 0x08, 0xf0, 0xf5, 0x9b, 0x9f, 0x43, 0x87, 0x23, 0xbc,
      0xfb, 0x0a, 0x8f, 0x59, 0x5e, 0x3d, 0xa0, 0x0d, 0x5f, 0x2c, 0x3b, 0xc9,
      0xeb, 0xa4, 0xe6, 0x4c, 0xfc, 0x5e, 0xdd, 0x9c, 0x24, 0x4e, 0xaa, 0x4a,
      0xa8, 0xf7, 0x18, 0x1f, 0xc0, 0x89, 0x5c, 0x91, 0x13, 0x05, 0xfb, 0x8d,
      0xd3, 0xd4, 0x04, 0x86, 0x5f, 0x6e, 0xe2, 0xa4, 0xde, 0x8f, 0x5d, 0xe7,
      0x96, 0x2c, 0xfa, 0x9e},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of hash h modified
    // tcID: 75
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     75,
     0,
     {0x28, 0x48, 0x1a, 0x5b, 0xc8, 0x76, 0x2a, 0xb8, 0xcf, 0xad, 0x8d, 0x78,
      0x88, 0xe5, 0xdb, 0x6b, 0x67, 0x8b, 0x12, 0x55, 0x4a, 0x24, 0x4a, 0xeb,
      0xed, 0xbb, 0x4d, 0x83, 0xfe, 0x0f, 0xb6, 0x76, 0xd7, 0x74, 0x11, 0x28,
      0x54, 0x84, 0xec, 0x8b, 0x76, 0x84, 0x3d, 0x4e, 0xbe, 0xd1, 0xdc, 0x9d,
      0xbc, 0x20, 0x39, 0xc3, 0xd0, 0xe7, 0xe5, 0x28, 0x8d, 0xe9, 0x60, 0x2f,
      0x7e, 0xe8, 0x27, 0x93, 0xe7, 0x5d, 0x23, 0x20, 0xd8, 0xa7, 0xc2, 0x54,
      0x11, 0x6c, 0xcb, 0x08, 0x65, 0x73, 0x14, 0x2c, 0xfd, 0x33, 0xe3, 0x6c,
      0xce, 0x3f, 0x83, 0x09, 0x01, 0xdc, 0x73, 0x4e, 0xf1, 0x83, 0x64, 0xe1,
      0xc0, 0x12, 0x5c, 0xd8, 0xfc, 0xc3, 0xc7, 0xf4, 0xf3, 0x33, 0xd4, 0xb0,
      0x53, 0x86, 0xc3, 0xcb, 0xdf, 0x61, 0x6d, 0x38, 0x6a, 0x08, 0x68, 0x62,
      0xb5, 0x91, 0xd8, 0x0c, 0x34, 0x83, 0x27, 0x67, 0xfe, 0xb8, 0x3a, 0xeb,
      0xda, 0xce, 0x7d, 0x19, 0x26, 0x9b, 0x0b, 0x5b, 0xf3, 0x40, 0x49, 0x9a,
      0x9d, 0x53, 0x0c, 0x15, 0xb1, 0x9c, 0x68, 0xce, 0x22, 0x73, 0x64, 0x08,
      0x0b, 0x27, 0xe6, 0xf4, 0xe0, 0x17, 0xd6, 0xdf, 0xdf, 0x6e, 0xf0, 0x5f,
      0x4b, 0x73, 0xb9, 0x26, 0x02, 0xa6, 0x24, 0x93, 0x91, 0x81, 0x2a, 0x28,
      0x6d, 0x8f, 0xc8, 0x72, 0x04, 0xa4, 0x77, 0xd1, 0x43, 0x07, 0xaa, 0x2e,
      0x23, 0xf1, 0x2f, 0x74, 0x52, 0xe1, 0x5d, 0x4b, 0xfa, 0xa3, 0xde, 0xee,
      0x56, 0x90, 0x3e, 0xd6, 0x60, 0x31, 0x30, 0x4d, 0xac, 0x16, 0xf6, 0x39,
      0x30, 0x08, 0xa5, 0x34, 0x96, 0x84, 0x50, 0x79, 0xaf, 0x72, 0xe6, 0xc5,
      0xd4, 0x78, 0x16, 0x64, 0xec, 0x75, 0x7c, 0x74, 0x1e, 0xa0, 0xdc, 0x9b,
      0xa6, 0x28, 0xdf, 0x2d, 0xbf, 0xa5, 0x91, 0xf1, 0x6c, 0x35, 0x2d, 0x51,
      0x71, 0xb3, 0xa0, 0xc5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of h replaced by 0
    // tcID: 76
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     76,
     0,
     {0x26, 0x7c, 0xdb, 0x3f, 0x7e, 0xc3, 0x90, 0xac, 0x09, 0x10, 0xa3, 0xac,
      0xd4, 0x28, 0x93, 0xb3, 0xc4, 0x45, 0x22, 0x64, 0x13, 0xce, 0x38, 0xd7,
      0xfe, 0xcd, 0x82, 0x5e, 0x29, 0xd3, 0xa7, 0xc8, 0xa2, 0xc3, 0x61, 0x60,
      0x7b, 0x70, 0xb8, 0x8f, 0x1c, 0xce, 0xde, 0xe4, 0xc9, 0xd3, 0xc8, 0xd1,
      0x09, 0xbc, 0x3e, 0x77, 0xad, 0x74, 0x92, 0x36, 0xf5, 0x46, 0x35, 0x27,
      0x13, 0xb7, 0x15, 0x81, 0xef, 0x0e, 0xd3, 0xb9, 0xa9, 0xd1, 0xa1, 0x10,
      0x35, 0x62, 0x9c, 0x8f, 0x6c, 0xf9, 0x12, 0xcc, 0xa1, 0x0e, 0xeb, 0x2b,
      0x02, 0xd3, 0xbc, 0xbc, 0xb1, 0x67, 0xf0, 0x2c, 0xe4, 0x3d, 0x00, 0x51,
      0x39, 0x99, 0xe4, 0x71, 0x0c, 0xf5, 0xd4, 0xf4, 0xd7, 0x30, 0xdf, 0xfe,
      0x9e, 0x52, 0xac, 0x5a, 0x11, 0xd6, 0x45, 0x38, 0x21, 0x29, 0x8e, 0x66,
      0xdd, 0x88, 0x2f, 0xa7, 0xee, 0xaa, 0x99, 0xd0, 0x6d, 0x32, 0x4a, 0x14,
      0x36, 0xe2, 0xe2, 0xf3, 0xa8, 0xe7, 0x87, 0x44, 0xcd, 0xb2, 0x1d, 0x00,
      0x70, 0x98, 0x7a, 0x48, 0x95, 0x69, 0x7f, 0x26, 0xd3, 0x7f, 0x79, 0xe9,
      0x3f, 0x67, 0x02, 0x61, 0x9d, 0xdc, 0x4b, 0x69, 0x86, 0x45, 0x0f, 0x84,
      0x63, 0x07, 0x17, 0x64, 0x32, 0x24, 0xd1, 0x34, 0xa9, 0x22, 0xb5, 0xae,
      0xba, 0xa4, 0x30, 0x44, 0x4b, 0xb5, 0x87, 0x07, 0x9f, 0x92, 0x5b, 0xa9,
      0x3a, 0x42, 0xbf, 0x84, 0x75, 0x79, 0xb8, 0xbd, 0x7e, 0x72, 0xba, 0xa5,
      0xee, 0xf8, 0x2a, 0xf8, 0x3a, 0xfd, 0xe8, 0x09, 0xea, 0xd8, 0xf8, 0x10,
      0xbf, 0x44, 0x41, 0x10, 0x7a, 0x30, 0x95, 0xa4, 0xf4, 0xf1, 0x37, 0xa3,
      0xa2, 0x4b, 0xd5, 0xf2, 0x1a, 0x18, 0xcf, 0xec, 0x80, 0x9a, 0x16, 0x4f,
      0x44, 0x71, 0xc4, 0x90, 0x91, 0x39, 0x0d, 0x2f, 0xc1, 0xc6, 0x57, 0x8d,
      0xfb, 0xc2, 0x06, 0x0a},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits of h replaced by 1s
    // tcID: 77
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     77,
     0,
     {0x7b, 0x9f, 0xb5, 0x86, 0xf1, 0x45, 0x5c, 0x9f, 0xd9, 0x5d, 0xb2, 0x5e,
      0xc6, 0x6c, 0xc1, 0xb8, 0xe0, 0x23, 0x73, 0x55, 0x17, 0x7c, 0xf1, 0xc4,
      0x0d, 0xf5, 0x9e, 0xc1, 0xeb, 0x84, 0xa9, 0x51, 0x49, 0xfc, 0x4c, 0x06,
      0x11, 0x7e, 0x83, 0x01, 0x83, 0x6a, 0x32, 0xaa, 0xe7, 0xe9, 0xed, 0x18,
      0xb9, 0xea, 0xe6, 0x7e, 0x5f, 0x76, 0xce, 0xd6, 0x0e, 0x89, 0xb8, 0xe1,
      0x1d, 0x34, 0x67, 0xaf, 0xd7, 0x11, 0x94, 0xb4, 0x94, 0xf7, 0x06, 0x2c,
      0x15, 0x73, 0x1a, 0x47, 0x55, 0x86, 0xfc, 0x90, 0xeb, 0xbd, 0x1b, 0x38,
      0x2d, 0x5c, 0x55, 0xc0, 0xb3, 0x19, 0x86, 0x9b, 0x3d, 0x40, 0x9b, 0x82,
      0xce, 0xc0, 0xaf, 0xb1, 0x9f, 0x63, 0x52, 0xef, 0xcd, 0x6f, 0x1e, 0xd9,
      0x49, 0xf2, 0x7a, 0x03, 0x06, 0xa3, 0xfd, 0x1e, 0xc4, 0x72, 0x2c, 0xd3,
      0x35, 0xc1, 0x16, 0x98, 0x71, 0xc6, 0x37, 0x96, 0xbf, 0x3a, 0x93, 0x3d,
      0xee, 0x3f, 0x81, 0xf0, 0x1f, 0xa8, 0xb6, 0xe7, 0x10, 0x07, 0x2f, 0xea,
      0x56, 0x2c, 0xd9, 0x38, 0xfb, 0x2b, 0xb1, 0x05, 0x38, 0x45, 0x55, 0x5b,
      0x07, 0xcd, 0xa7, 0x4f, 0x14, 0x4a, 0xc8, 0x4d, 0x95, 0x57, 0x32, 0x6c,
      0xca, 0x79, 0x9a, 0xf5, 0x01, 0xf9, 0x47, 0x4c, 0xd8, 0xb1, 0x8a, 0x2a,
      0xf4, 0xd1, 0xa1, 0x2f, 0x93, 0xa5, 0xb6, 0xdf, 0xd1, 0x88, 0x0e, 0x58,
      0xea, 0x82, 0xe9, 0x8f, 0xab, 0xe9, 0x6f, 0xa7, 0x69, 0x81, 0xa6, 0x24,
      0x3e, 0x8e, 0x4c, 0xa3, 0x86, 0xf5, 0xea, 0x44, 0x63, 0xf6, 0x15, 0xba,
      0x18, 0x12, 0xe3, 0x88, 0x42, 0xfd, 0x51, 0xc7, 0x1e, 0x0b, 0x6a, 0x9d,
      0xa6, 0x8a, 0x2b, 0x14, 0x32, 0xa7, 0xce, 0x26, 0x86, 0x63, 0x8e, 0x55,
      0x12, 0x9d, 0x42, 0x24, 0xc9, 0x45, 0x13, 0x20, 0x7e, 0xbf, 0x90, 0xe8,
      0xc5, 0xf4, 0x35, 0xab},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bits in hash h flipped
    // tcID: 78
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     78,
     0,
     {0x6b, 0xd4, 0x14, 0xe8, 0x77, 0xab, 0xc9, 0x2b, 0x60, 0x8b, 0x08, 0xa2,
      0x73, 0x94, 0x6f, 0x90, 0xba, 0x6c, 0x6c, 0x27, 0xde, 0x24, 0x48, 0x17,
      0x56, 0x38, 0xf6, 0x7a, 0x6b, 0x14, 0x49, 0x2f, 0xc1, 0x41, 0x5e, 0xce,
      0x54, 0x0b, 0xe3, 0xe3, 0xdf, 0x8c, 0x8e, 0xa7, 0x15, 0x42, 0x11, 0x63,
      0x7d, 0x9b, 0x51, 0x44, 0x31, 0x2e, 0x11, 0x3b, 0xda, 0x25, 0x26, 0xb6,
      0xfb, 0x2c, 0xaf, 0x7b, 0x07, 0x67, 0x33, 0x32, 0xdf, 0xa6, 0x05, 0x46,
      0x8e, 0x37, 0xf4, 0x02, 0x6e, 0xad, 0xb4, 0xc0, 0xf8, 0x4b, 0x7b, 0x48,
      0x2b, 0xa6, 0x75, 0x28, 0x39, 0xfb, 0xa4, 0x6b, 0x76, 0x57, 0x09, 0xc3,
      0xc6, 0xe5, 0x4d, 0xe1, 0x39, 0x53, 0x24, 0x5a, 0x33, 0x64, 0xbb, 0xf2,
      0x12, 0x22, 0x37, 0x4e, 0xb6, 0x3e, 0x61, 0xe6, 0x8d, 0x73, 0xa1, 0x26,
      0xf4, 0x0f, 0x11, 0x54, 0x05, 0xfe, 0x90, 0x92, 0xb0, 0x0b, 0x60, 0xa7,
      0xf0, 0xb9, 0x95, 0x09, 0x20, 0x61, 0x42, 0x74, 0x54, 0xf6, 0x87, 0x6a,
      0xe2, 0xab, 0x3b, 0x27, 0x57, 0x33, 0x73, 0x49, 0xff, 0x3c, 0xa3, 0xe2,
      0x33, 0x28, 0x88, 0xb9, 0x61, 0x6f, 0xcf, 0xfb, 0x3b, 0x92, 0x49, 0x77,
      0xef, 0x85, 0x65, 0x53, 0xf5, 0x5b, 0x2f, 0x1b, 0x11, 0x5e, 0xf0, 0xad,
      0x78, 0x56, 0xf6, 0x66, 0xa9, 0x86, 0x31, 0x09, 0xc6, 0x49, 0x8c, 0x52,
      0x27, 0x1e, 0xa2, 0xe6, 0x85, 0x4f, 0xe7, 0x3e, 0x9e, 0x4d, 0x4e, 0xc6,
      0x66, 0xfe, 0x66, 0x8f, 0x0e, 0xa1, 0xd1, 0xaf, 0x19, 0x85, 0x3e, 0x9a,
      0x07, 0x06, 0x64, 0x18, 0x69, 0x74, 0x29, 0xcc, 0x31, 0xff, 0xf1, 0x07,
      0xb6, 0xba, 0x21, 0x2b, 0x4a, 0x3c, 0xc1, 0x9b, 0x59, 0xad, 0xa4, 0x59,
      0xef, 0xbc, 0x4c, 0xcb, 0x90, 0xda, 0x8a, 0x0b, 0xbb, 0x48, 0x28, 0x04,
      0x56, 0xde, 0x69, 0xd2},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: hash of salt missing
    // tcID: 79
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     79,
     0,
     {0x39, 0x22, 0x0d, 0xab, 0xef, 0x40, 0xda, 0x1a, 0x50, 0x2b, 0xf2, 0x31,
      0xbd, 0xd2, 0x3d, 0x8d, 0x2c, 0xef, 0x5b, 0x85, 0x95, 0x0b, 0x7a, 0xba,
      0xba, 0x4c, 0xe6, 0x3e, 0xb5, 0x72, 0x83, 0xfa, 0xcf, 0x1c, 0x50, 0xb5,
      0x67, 0xa0, 0xd2, 0x72, 0xb6, 0xe5, 0x92, 0x10, 0xbb, 0xa6, 0x16, 0x37,
      0x35, 0xe0, 0xbe, 0x82, 0xdb, 0xe4, 0xa4, 0xed, 0x2d, 0xce, 0x3f, 0x3f,
      0xd1, 0x8e, 0xec, 0xee, 0x04, 0x75, 0x17, 0xa8, 0x5a, 0x1e, 0x63, 0x43,
      0x37, 0x88, 0x4f, 0x9e, 0xd6, 0xae, 0xd6, 0xc2, 0x50, 0xd8, 0xf0, 0x45,
      0x3f, 0x3a, 0x10, 0x3c, 0x8b, 0x68, 0x4b, 0x8f, 0x45, 0x2d, 0x05, 0x91,
      0x7b, 0x56, 0x8c, 0xb2, 0xf8, 0x2f, 0x6e, 0xc2, 0x9c, 0x07, 0xe0, 0xd4,
      0x51, 0x30, 0x7a, 0x3b, 0x54, 0xdc, 0xb0, 0x31, 0x65, 0xda, 0x59, 0x61,
      0x18, 0x38, 0xf8, 0xb5, 0x5d, 0x2e, 0x8c, 0xbc, 0x02, 0x0f, 0xc5, 0xb4,
      0x82, 0xe1, 0xf8, 0xf1, 0xad, 0x4d, 0x77, 0x8b, 0x93, 0xe6, 0x48, 0xc1,
      0x16, 0x0b, 0x3c, 0xb4, 0x3d, 0xd0, 0x71, 0xb6, 0x73, 0x39, 0xed, 0xbd,
      0xac, 0xd7, 0xb6, 0x68, 0xec, 0x92, 0xa3, 0xe2, 0x80, 0x81, 0x85, 0x24,
      0x3f, 0x29, 0x21, 0xd5, 0x02, 0xe0, 0x57, 0x94, 0x32, 0x01, 0x7b, 0x7a,
      0xfd, 0x9e, 0x98, 0x35, 0x15, 0xb3, 0xd9, 0xb2, 0xdd, 0xef, 0x7a, 0xfe,
      0x4e, 0xe5, 0xb3, 0x40, 0x5e, 0x2c, 0x66, 0x17, 0xce, 0x2a, 0xcd, 0xb6,
      0x24, 0x32, 0x13, 0xd2, 0xdb, 0xf8, 0xc7, 0x2c, 0xac, 0x4d, 0x4a, 0xc0,
      0xe6, 0x92, 0x65, 0xf2, 0x04, 0x99, 0xa2, 0x9c, 0xf5, 0x0a, 0x67, 0xec,
      0xf2, 0xcf, 0xa2, 0xdf, 0x61, 0xc5, 0x85, 0xf3, 0x2b, 0x9f, 0x06, 0x7f,
      0x84, 0xba, 0xab, 0x8b, 0x88, 0x15, 0x2b, 0x65, 0xb2, 0x20, 0x89, 0x8f,
      0x91, 0xb9, 0xf5, 0x06},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of ps modified
    // tcID: 80
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     80,
     0,
     {0x48, 0x7b, 0xc9, 0x02, 0x1d, 0x8e, 0x95, 0xd0, 0x5c, 0x1d, 0x32, 0x37,
      0xc3, 0xe9, 0xf1, 0x0d, 0xf7, 0x64, 0xe8, 0xf7, 0x0a, 0x06, 0x8f, 0xe6,
      0xd9, 0x3b, 0x86, 0x52, 0x33, 0xf6, 0xce, 0x80, 0x88, 0xbf, 0xc1, 0x17,
      0xc9, 0x08, 0x6a, 0x3b, 0xea, 0x29, 0xd8, 0x6e, 0x6d, 0x75, 0xfd, 0x9c,
      0x87, 0x00, 0xe8, 0x71, 0xf6, 0x02, 0x7b, 0xdd, 0x0b, 0x37, 0xc1, 0xb5,
      0x81, 0xdd, 0xa8, 0x07, 0xa1, 0x40, 0x17, 0x21, 0xf8, 0xa5, 0x82, 0xa0,
      0x63, 0x09, 0xbf, 0xdf, 0xea, 0x5e, 0xf1, 0x77, 0xcb, 0x7b, 0xff, 0x47,
      0x17, 0x9d, 0x9f, 0xee, 0x32, 0xbf, 0x54, 0x5e, 0x3e, 0x45, 0x13, 0x21,
      0x2b, 0x68, 0xfc, 0x3e, 0xaa, 0x43, 0xf9, 0xbf, 0x86, 0xab, 0x06, 0x6f,
      0xea, 0x31, 0x01, 0x82, 0x99, 0xf4, 0x40, 0x1e, 0x3e, 0x09, 0x85, 0xc0,
      0xd4, 0x50, 0xf1, 0x02, 0x16, 0x28, 0x96, 0xe6, 0x19, 0xa2, 0x08, 0x3d,
      0x5f, 0xd2, 0xf2, 0xa0, 0x3f, 0xac, 0x6a, 0xd9, 0x9d, 0x38, 0xea, 0xad,
      0xe1, 0xc5, 0x6a, 0x79, 0x96, 0xa3, 0x5e, 0x5e, 0x65, 0x70, 0x78, 0x54,
      0x7c, 0x43, 0xd1, 0x3f, 0xbf, 0x62, 0xa6, 0x4a, 0x00, 0x7c, 0x8f, 0x03,
      0xb7, 0x9b, 0x9c, 0x59, 0xd1, 0x96, 0x97, 0x06, 0x93, 0x44, 0xb7, 0xab,
      0x30, 0x9b, 0x53, 0x2a, 0x74, 0x49, 0x87, 0x8d, 0x3c, 0x33, 0x47, 0x20,
      0x98, 0x02, 0x69, 0x17, 0xf9, 0x9d, 0x07, 0xd4, 0xb2, 0x4c, 0x39, 0xc6,
      0x7d, 0xac, 0x09, 0x9d, 0x77, 0xc2, 0xc0, 0x31, 0x3a, 0x55, 0x7d, 0x8a,
      0x5a, 0xeb, 0x89, 0x62, 0x14, 0x21, 0x1f, 0xdc, 0xcb, 0x53, 0x1f, 0x39,
      0x0d, 0x91, 0x84, 0x8b, 0xe4, 0x59, 0xdf, 0x01, 0xc0, 0x14, 0x45, 0x4c,
      0x8c, 0x9f, 0xb3, 0x90, 0xd6, 0xf7, 0x59, 0x71, 0x3e, 0x30, 0x12, 0x8a,
      0x91, 0x84, 0xe8, 0x81},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte of ps modified
    // tcID: 81
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     81,
     0,
     {0x5b, 0xc1, 0xe9, 0x6a, 0xd5, 0x36, 0xde, 0xe1, 0xb3, 0xd2, 0x3e, 0x31,
      0xf0, 0x53, 0xb9, 0xb0, 0xe1, 0x43, 0x9c, 0xe7, 0xc4, 0x8e, 0xbb, 0x54,
      0xf0, 0x1a, 0x81, 0xde, 0x10, 0x13, 0x36, 0x12, 0xdd, 0x0c, 0x1b, 0x4d,
      0xc0, 0xb6, 0x0d, 0x6a, 0xfc, 0xbd, 0x18, 0xe4, 0x01, 0x23, 0xb4, 0x02,
      0x36, 0xbc, 0xd7, 0x73, 0xb5, 0xff, 0x47, 0x3b, 0x5f, 0x35, 0xc6, 0xed,
      0x42, 0x94, 0x54, 0x1e, 0x7f, 0x02, 0x8a, 0xcb, 0xc2, 0x9f, 0x55, 0x83,
      0xe9, 0x33, 0x31, 0xd4, 0xc0, 0x36, 0x31, 0xaf, 0xaf, 0x79, 0xbc, 0x68,
      0x3c, 0x18, 0x7c, 0x79, 0x29, 0xd2, 0xf7, 0xdb, 0x52, 0xd1, 0xa3, 0x4d,
      0x88, 0x21, 0x0a, 0xb5, 0x02, 0x31, 0x21, 0x98, 0x37, 0xe1, 0xb6, 0x0d,
      0x49, 0xce, 0x80, 0x48, 0xe9, 0xee, 0x4e, 0xf5, 0x5c, 0x22, 0x18, 0x67,
      0x4f, 0x29, 0x71, 0x58, 0xc7, 0x11, 0xe4, 0xfb, 0xa6, 0x23, 0x51, 0x87,
      0x9e, 0x7d, 0x05, 0x8e, 0x0c, 0xef, 0x25, 0x57, 0x5c, 0xb0, 0xab, 0x9f,
      0x6d, 0x69, 0x61, 0xa4, 0xcb, 0x6d, 0x9a, 0xb0, 0xa6, 0x8a, 0x30, 0x1f,
      0xa3, 0xbb, 0xb8, 0xd0, 0x89, 0x9f, 0x43, 0xba, 0xe4, 0x0e, 0xc1, 0x97,
      0x58, 0x59, 0x1e, 0x5e, 0x0c, 0xfa, 0x84, 0xdd, 0x08, 0xf7, 0x85, 0x9e,
      0xbf, 0x54, 0xc7, 0x6e, 0x04, 0xe7, 0x47, 0x48, 0x83, 0x33, 0x13, 0xbf,
      0x15, 0x79, 0x3b, 0x5b, 0xbc, 0x47, 0x49, 0x4f, 0x3b, 0xf4, 0x39, 0xd7,
      0xfb, 0x52, 0x25, 0x64, 0x0f, 0x3f, 0x37, 0x56, 0xd9, 0xd4, 0x45, 0x2f,
      0x7f, 0xbd, 0xd8, 0x28, 0xfe, 0x84, 0x4f, 0x75, 0x7a, 0x0c, 0xc5, 0x85,
      0xae, 0x0a, 0x6a, 0x54, 0x10, 0x06, 0x5c, 0x8c, 0xe4, 0xe0, 0x31, 0x9c,
      0x35, 0x65, 0x65, 0xeb, 0xdb, 0x1b, 0xa0, 0xfe, 0xfe, 0x78, 0x0c, 0x70,
      0xa5, 0x13, 0x53, 0x65},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0xff
    // tcID: 82
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     82,
     0,
     {0x2b, 0x3b, 0xe6, 0x99, 0x70, 0x57, 0xae, 0x17, 0xc7, 0x49, 0xc4, 0x35,
      0xdb, 0xc6, 0x81, 0x10, 0x20, 0x4e, 0x95, 0xb3, 0xe1, 0x27, 0xa2, 0x30,
      0x12, 0x1e, 0x27, 0xc9, 0x5a, 0xac, 0xe9, 0x0e, 0x9f, 0x22, 0x1e, 0x27,
      0x63, 0x83, 0x30, 0x24, 0xb3, 0xbb, 0x87, 0x33, 0x68, 0xe3, 0xe9, 0x92,
      0x89, 0x7d, 0x87, 0x67, 0xeb, 0xa2, 0x47, 0x96, 0x37, 0xee, 0x93, 0x83,
      0x79, 0x6c, 0xbc, 0x10, 0x45, 0x5d, 0xa3, 0xb5, 0x2c, 0x7f, 0xac, 0x1d,
      0x91, 0x13, 0x1e, 0x3f, 0x78, 0xf5, 0xf6, 0x16, 0xb3, 0xfd, 0x41, 0x3b,
      0x31, 0x0f, 0xe8, 0xf5, 0x0e, 0xf4, 0xf7, 0x21, 0xfc, 0x02, 0x6a, 0x62,
      0x22, 0xf0, 0xd9, 0x11, 0x36, 0x24, 0xcf, 0x7d, 0x48, 0x1e, 0x79, 0xe7,
      0x88, 0x58, 0x7e, 0xe6, 0x59, 0xe8, 0x12, 0x96, 0xea, 0xa4, 0x38, 0xff,
      0x13, 0x45, 0x4e, 0x36, 0xea, 0x50, 0xe9, 0xf0, 0x38, 0xed, 0x2a, 0x75,
      0x48, 0xa8, 0xd1, 0x69, 0x63, 0x5c, 0x3e, 0x15, 0xbc, 0x20, 0xcd, 0x83,
      0xc8, 0x27, 0x9d, 0x16, 0xe6, 0xb0, 0xed, 0xca, 0xc2, 0xe9, 0xc7, 0x2b,
      0x90, 0x48, 0xdd, 0x7f, 0xd1, 0xd2, 0x98, 0xe4, 0x14, 0xc3, 0x83, 0x22,
      0x36, 0xd6, 0x12, 0xaf, 0x38, 0x41, 0xe4, 0x26, 0xc7, 0x4f, 0x20, 0x48,
      0x4e, 0xf4, 0x08, 0xb1, 0x9f, 0x22, 0x44, 0x9e, 0x70, 0x14, 0x60, 0x63,
      0x3f, 0xbc, 0x51, 0x55, 0x85, 0x1e, 0x81, 0x2e, 0x88, 0x6c, 0xbf, 0xd6,
      0x21, 0x8b, 0xb2, 0x73, 0x88, 0xe2, 0x05, 0x47, 0xfb, 0x4a, 0x48, 0xd2,
      0xe0, 0xf9, 0xa2, 0x84, 0xf9, 0xbc, 0x1e, 0x93, 0x91, 0xb2, 0x8a, 0xb7,
      0xf3, 0xf4, 0x5f, 0xf5, 0xae, 0xb6, 0xaf, 0x12, 0xfa, 0xae, 0x43, 0x73,
      0x61, 0x87, 0x7d, 0x04, 0xe2, 0xdf, 0x1a, 0x10, 0x57, 0xac, 0x3a, 0x68,
      0x0e, 0x51, 0x23, 0xef},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: all bytes of ps changed to 0x80
    // tcID: 83
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     83,
     0,
     {0x4b, 0xb8, 0xfd, 0x79, 0xda, 0x58, 0xfd, 0x32, 0x17, 0x66, 0x19, 0x38,
      0xc9, 0x07, 0x72, 0xee, 0xbd, 0xe7, 0xbf, 0xe5, 0xd4, 0x9f, 0xa5, 0x97,
      0xcf, 0x44, 0x80, 0x19, 0xa5, 0x6d, 0x71, 0x0e, 0xa1, 0x26, 0xe8, 0xb9,
      0x4a, 0xac, 0xb4, 0x5b, 0xed, 0x81, 0xdf, 0x07, 0xed, 0x4c, 0x89, 0xa9,
      0x88, 0x9b, 0xac, 0x0a, 0xd2, 0xab, 0xd5, 0x06, 0x37, 0x4d, 0x5e, 0xbe,
      0xd1, 0x47, 0x77, 0x67, 0x3f, 0xb1, 0xc5, 0x1a, 0x3f, 0x84, 0x4e, 0x96,
      0x19, 0xbf, 0x70, 0x7c, 0x98, 0x66, 0xb2, 0x17, 0x21, 0xa7, 0x54, 0x58,
      0xc1, 0x00, 0xd5, 0x7b, 0x9e, 0xbf, 0x6c, 0xa5, 0x8a, 0xaf, 0xf1, 0xd4,
      0x7c, 0xb2, 0xd0, 0xf2, 0x60, 0x74, 0xdc, 0x15, 0xd0, 0x90, 0x0a, 0x11,
      0xd6, 0x81, 0xbc, 0xd7, 0x6b, 0x11, 0x11, 0x40, 0x50, 0x0a, 0x51, 0xcf,
      0x8c, 0x1b, 0x5f, 0xf4, 0x77, 0x11, 0x76, 0xf1, 0xdc, 0x08, 0x84, 0xd4,
      0x2b, 0x36, 0xa1, 0x56, 0x90, 0xb9, 0x91, 0xc7, 0x7f, 0x96, 0x05, 0xee,
      0x9c, 0x43, 0x29, 0xfe, 0xad, 0x40, 0x36, 0x4f, 0x2b, 0x63, 0x72, 0x81,
      0x23, 0x19, 0xc0, 0xed, 0x4a, 0x6a, 0x15, 0xc0, 0x71, 0x6d, 0xa9, 0x42,
      0x6d, 0xdb, 0xbe, 0xe7, 0x99, 0x38, 0xbb, 0xf8, 0xdc, 0x3b, 0x45, 0x9b,
      0xad, 0x11, 0xce, 0x79, 0xc0, 0xba, 0xe6, 0x08, 0x0a, 0x06, 0xb6, 0xc8,
      0xc1, 0xc0, 0x51, 0xfc, 0x37, 0xe0, 0xbf, 0x05, 0x46, 0xc7, 0xb5, 0x5b,
      0x2c, 0xb6, 0xd9, 0x0b, 0xbf, 0x49, 0x61, 0xcc, 0xd1, 0xad, 0xc6, 0x23,
      0xc9, 0xb9, 0xb5, 0x19, 0x12, 0xd6, 0xb7, 0x88, 0x43, 0x93, 0x2c, 0xe0,
      0x43, 0x23, 0xf8, 0xa9, 0x15, 0x9d, 0x10, 0xac, 0x94, 0xc2, 0xd9, 0x80,
      0xe9, 0xb4, 0x8f, 0xc1, 0x43, 0x29, 0x9d, 0x4c, 0x83, 0x00, 0x50, 0xac,
      0xe6, 0x1f, 0x72, 0x38},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0
    // tcID: 84
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     84,
     0,
     {0x9a, 0xca, 0x5b, 0x5f, 0xe1, 0x36, 0x9d, 0xc4, 0x6e, 0xff, 0x90, 0x8e,
      0x69, 0x0b, 0xa8, 0x87, 0x44, 0xdb, 0x0c, 0x86, 0xf7, 0xda, 0x7e, 0x64,
      0x4e, 0xac, 0x31, 0x44, 0x93, 0xba, 0x6a, 0x7d, 0x00, 0x3d, 0xc5, 0x40,
      0x0e, 0x1c, 0x52, 0x1c, 0x37, 0x3e, 0xde, 0x41, 0x0a, 0xfc, 0xaa, 0xe8,
      0xa4, 0xea, 0x8e, 0x14, 0xd1, 0xe6, 0xc2, 0xac, 0x3f, 0x39, 0xc0, 0xbf,
      0x8b, 0xfe, 0xb6, 0x88, 0x96, 0x22, 0x60, 0xf9, 0x10, 0x58, 0xef, 0x9c,
      0x1a, 0x0b, 0xa3, 0x96, 0x89, 0x73, 0x6d, 0x03, 0x9f, 0xf8, 0x65, 0x24,
      0xa9, 0x7d, 0x8e, 0xaa, 0xf2, 0x48, 0x60, 0x17, 0x93, 0x02, 0x3c, 0xe6,
      0x56, 0x9c, 0x3c, 0xf1, 0x5d, 0xff, 0x30, 0xf4, 0x1e, 0x38, 0x46, 0x90,
      0xab, 0x40, 0x81, 0x2c, 0xb1, 0xe4, 0x41, 0x4a, 0x03, 0x70, 0xfc, 0x39,
      0xf5, 0x26, 0xab, 0xab, 0x87, 0xbb, 0x9a, 0x40, 0x5f, 0xd4, 0x48, 0x69,
      0x06, 0x9f, 0x34, 0x3f, 0x28, 0xba, 0xb5, 0x0a, 0x1e, 0x58, 0x2d, 0x4b,
      0xce, 0xd2, 0x5d, 0x41, 0xf9, 0xfd, 0xd2, 0xe9, 0x58, 0x17, 0x7a, 0x36,
      0x25, 0xbb, 0x59, 0xc4, 0x67, 0x7f, 0x7f, 0x74, 0x93, 0x21, 0x02, 0x3f,
      0xc9, 0xb9, 0xb7, 0x24, 0xe8, 0x17, 0x2a, 0x4a, 0x51, 0x27, 0x43, 0xa1,
      0xc7, 0x8c, 0x3c, 0x8b, 0x1f, 0x05, 0x56, 0xfe, 0xde, 0x02, 0xe9, 0xf6,
      0xf2, 0xf8, 0x51, 0xfd, 0x31, 0xe2, 0x1f, 0x08, 0x86, 0xa3, 0x5d, 0x12,
      0xa0, 0xe0, 0x4f, 0x04, 0x12, 0x51, 0x52, 0x4b, 0xd7, 0x83, 0x8d, 0x91,
      0x65, 0x70, 0x26, 0x54, 0x0e, 0x13, 0x3a, 0x2a, 0xc1, 0xad, 0xe5, 0x2f,
      0x03, 0xef, 0xb5, 0x09, 0xc3, 0x05, 0x78, 0xbf, 0xde, 0x27, 0x2f, 0x0d,
      0x9f, 0xc2, 0xe5, 0x15, 0xe5, 0x41, 0x25, 0x9d, 0xfc, 0x24, 0x9b, 0xf1,
      0x76, 0x2b, 0x17, 0xb5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: ps followed by 0xff
    // tcID: 85
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     85,
     0,
     {0x92, 0x11, 0xea, 0x63, 0x74, 0x36, 0x2d, 0x77, 0xf4, 0x91, 0xd9, 0xdc,
      0xa7, 0xe8, 0xe8, 0xd2, 0xb6, 0x72, 0xbd, 0x56, 0x5d, 0xda, 0x15, 0x66,
      0x81, 0x46, 0x70, 0xd2, 0x2e, 0x3f, 0x21, 0x1b, 0x38, 0x24, 0x65, 0x29,
      0xa5, 0xf0, 0x13, 0x33, 0xce, 0xd7, 0x03, 0x23, 0xe6, 0xcc, 0x4d, 0xe5,
      0x8e, 0x9d, 0xee, 0x11, 0xa9, 0x0f, 0x34, 0x5f, 0xc5, 0x3c, 0x1c, 0xb0,
      0xf0, 0xc2, 0x28, 0x72, 0x30, 0xd1, 0xcf, 0xc8, 0x3d, 0x33, 0xc6, 0x15,
      0x8a, 0x87, 0x30, 0x85, 0x3b, 0x51, 0x63, 0xc8, 0x25, 0xec, 0x05, 0x08,
      0x4c, 0xf0, 0x81, 0x63, 0x25, 0xe2, 0x1b, 0xa8, 0x7f, 0x16, 0x85, 0x19,
      0x7c, 0x98, 0x91, 0xca, 0x3b, 0x89, 0xd8, 0xd8, 0xbb, 0xad, 0x39, 0x5f,
      0x7f, 0x71, 0xb9, 0x1e, 0xf9, 0x37, 0xa1, 0xd8, 0x1b, 0xf7, 0x49, 0x73,
      0x56, 0x92, 0x8b, 0x77, 0xb1, 0x0f, 0xe2, 0x70, 0x50, 0x0a, 0x73, 0x1d,
      0x49, 0x8b, 0xeb, 0x85, 0x49, 0x0c, 0x1d, 0x3c, 0x41, 0x45, 0x33, 0x6d,
      0x2a, 0x8c, 0xe8, 0x43, 0x03, 0x54, 0xb3, 0xaf, 0xcb, 0xf0, 0xc9, 0x23,
      0xb0, 0xb0, 0xe8, 0x24, 0xad, 0xb3, 0x6d, 0x7b, 0xe6, 0x9a, 0x8e, 0x95,
      0x1f, 0x64, 0xa5, 0xb1, 0xd6, 0x48, 0xdf, 0xd9, 0xfe, 0xa4, 0x9b, 0x59,
      0xc9, 0x9e, 0xfc, 0xf0, 0x15, 0xc6, 0xb3, 0x93, 0x7d, 0x89, 0x86, 0x10,
      0x0f, 0x48, 0x02, 0x23, 0x46, 0x13, 0x6e, 0xb5, 0x6f, 0x95, 0x38, 0xb1,
      0x15, 0x28, 0x4e, 0xad, 0x85, 0x19, 0x63, 0x85, 0xd9, 0x1d, 0xd4, 0x14,
      0xee, 0x22, 0xa3, 0xc7, 0xf4, 0x0f, 0x63, 0x2c, 0xbe, 0x56, 0x5c, 0x8d,
      0x0a, 0x32, 0x54, 0x04, 0xd0, 0xd4, 0x90, 0x52, 0x82, 0xcf, 0x7a, 0xcc,
      0x62, 0x10, 0xa6, 0xea, 0xa2, 0x6f, 0x3c, 0x39, 0x61, 0x66, 0x0a, 0x94,
      0x47, 0x71, 0xb3, 0x42},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: shifted salt
    // tcID: 86
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     86,
     0,
     {0x39, 0x11, 0x2e, 0x1c, 0x82, 0x51, 0xd5, 0xff, 0xe1, 0x37, 0x3e, 0x70,
      0xfa, 0xc9, 0x46, 0x35, 0x8b, 0x00, 0xba, 0xe6, 0xa4, 0x61, 0xa1, 0xaf,
      0x56, 0x1a, 0x82, 0xd8, 0x1e, 0xc4, 0xac, 0xdc, 0x63, 0xee, 0xcb, 0x3b,
      0x98, 0xf5, 0xf0, 0x70, 0x92, 0x9d, 0xec, 0x66, 0xa7, 0x58, 0xd4, 0xa1,
      0x2c, 0xec, 0x26, 0x00, 0x20, 0x8d, 0x75, 0x97, 0x32, 0x0b, 0xa5, 0xdb,
      0x41, 0x20, 0x06, 0xeb, 0xe7, 0x6e, 0xd5, 0x93, 0xd8, 0xb1, 0x09, 0x0e,
      0x93, 0xbe, 0x21, 0xb1, 0xc0, 0x07, 0x00, 0xe3, 0x93, 0xdd, 0xb4, 0xb7,
      0xd7, 0xa8, 0xbb, 0xda, 0xab, 0x60, 0x30, 0x87, 0xab, 0xd2, 0xb9, 0x0a,
      0x04, 0x08, 0xa7, 0x75, 0xa4, 0x46, 0x9d, 0x4f, 0x2f, 0x6b, 0x34, 0xd2,
      0x28, 0xda, 0x55, 0xbb, 0x48, 0x72, 0xef, 0x6d, 0xde, 0x52, 0x82, 0xf5,
      0xbb, 0xcd, 0xd6, 0xa8, 0xce, 0xfc, 0x71, 0xc4, 0xca, 0xf0, 0x04, 0x53,
      0xe6, 0xd6, 0xc5, 0x93, 0x21, 0xb7, 0x38, 0xd3, 0xb2, 0x1a, 0x3d, 0x8f,
      0x0d, 0xa4, 0xaf, 0xde, 0x30, 0xc1, 0x6b, 0xc5, 0x72, 0x2a, 0xc3, 0x0a,
      0xd6, 0xbb, 0x1f, 0x9f, 0xe0, 0x45, 0x1a, 0xd1, 0x50, 0xfb, 0x3d, 0x67,
      0xa8, 0x05, 0x99, 0x3e, 0x50, 0x6a, 0x80, 0xb2, 0xde, 0xa3, 0x80, 0x1b,
      0xbe, 0xdb, 0x8f, 0xf7, 0xb6, 0x76, 0xf5, 0x0c, 0xa3, 0xfa, 0x5b, 0x9b,
      0xd7, 0x44, 0xc0, 0x08, 0x22, 0xc9, 0x75, 0xe2, 0xab, 0x8c, 0xc6, 0xa9,
      0x17, 0x43, 0x62, 0x79, 0xa9, 0xe8, 0x5a, 0xea, 0x62, 0x47, 0x7e, 0xf8,
      0x42, 0x70, 0xf6, 0xef, 0xe4, 0x95, 0xed, 0x50, 0x36, 0x23, 0x10, 0x8c,
      0xa3, 0x9d, 0x5c, 0x47, 0xba, 0xfa, 0x35, 0x05, 0xf0, 0x49, 0x95, 0xec,
      0x9c, 0x2a, 0x0e, 0x41, 0x1f, 0xed, 0x91, 0x79, 0xc9, 0xa9, 0xe9, 0x4f,
      0xce, 0xcd, 0xa5, 0xad},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 87
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     87,
     0,
     {0x1b, 0xaa, 0xb3, 0x4d, 0x75, 0x3d, 0x4c, 0x16, 0x91, 0x07, 0xff, 0x7d,
      0xba, 0x46, 0xec, 0x1a, 0x42, 0x03, 0xcb, 0x16, 0x54, 0x48, 0x9d, 0x6f,
      0xc2, 0x0d, 0x20, 0x6b, 0xb2, 0x1f, 0xab, 0x48, 0x38, 0x72, 0xc4, 0x4a,
      0xe8, 0x01, 0x7b, 0x7c, 0x07, 0xaa, 0xdb, 0x8e, 0x84, 0x89, 0xa2, 0xb4,
      0x1b, 0x89, 0xf9, 0x33, 0x1f, 0xef, 0x63, 0x31, 0x74, 0x08, 0x10, 0x5e,
      0xae, 0x19, 0x90, 0x03, 0x77, 0xce, 0x15, 0x0e, 0xc8, 0x9a, 0x37, 0xb2,
      0x6b, 0xfb, 0x16, 0x9a, 0x89, 0xaa, 0x1c, 0x71, 0xa8, 0x3c, 0xba, 0x68,
      0x58, 0xd5, 0xb4, 0x73, 0x53, 0xe8, 0x20, 0x17, 0xf1, 0x9a, 0x66, 0x88,
      0x92, 0x77, 0x68, 0xbf, 0xd0, 0xe7, 0x5b, 0xfc, 0xd7, 0x1a, 0x5e, 0x19,
      0x48, 0x54, 0x39, 0x07, 0xd6, 0x5b, 0xc8, 0xfc, 0x81, 0x34, 0x36, 0xa1,
      0x59, 0x49, 0xfb, 0xaf, 0x0a, 0x7f, 0x95, 0xdd, 0xf0, 0x10, 0xf2, 0x98,
      0xdf, 0x93, 0x14, 0x20, 0x38, 0x38, 0xa6, 0x0b, 0x39, 0xc5, 0xbc, 0xbc,
      0x7a, 0x43, 0x85, 0x00, 0x64, 0x99, 0x50, 0xbf, 0x28, 0xe7, 0x8f, 0x94,
      0x15, 0x5c, 0xc6, 0x64, 0xad, 0x5f, 0xf9, 0x96, 0xe5, 0x17, 0x89, 0xfb,
      0x13, 0x03, 0x8e, 0x17, 0x57, 0xdc, 0x19, 0xb6, 0x57, 0x2f, 0x02, 0x8f,
      0xdd, 0x8b, 0xe3, 0x18, 0xab, 0x93, 0x3a, 0xdc, 0xed, 0x2e, 0x87, 0xb5,
      0x69, 0x54, 0x45, 0x03, 0x91, 0x60, 0x30, 0xb4, 0x06, 0x0e, 0x23, 0x1b,
      0x02, 0x65, 0x37, 0x28, 0x05, 0xcb, 0x53, 0x21, 0x4c, 0x6f, 0x21, 0xe1,
      0x3c, 0x63, 0x2c, 0xe0, 0x80, 0x31, 0xee, 0x36, 0x8b, 0xcd, 0xf3, 0xea,
      0xcb, 0x3b, 0x87, 0x26, 0x9e, 0x8a, 0x86, 0x84, 0x70, 0x3a, 0x34, 0x85,
      0x24, 0x02, 0x0e, 0x82, 0x0d, 0xe9, 0x3f, 0x1f, 0x33, 0x4b, 0x59, 0xcd,
      0xdf, 0xf5, 0x1a, 0x12},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: first byte of masked_db changed to 0
    // tcID: 88
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     88,
     0,
     {0x7f, 0x04, 0x56, 0x0a, 0xce, 0xa9, 0x5c, 0x8b, 0x3d, 0xf6, 0x7a, 0x74,
      0xfb, 0x2b, 0x32, 0xd9, 0x04, 0xe5, 0xc5, 0x9b, 0x43, 0xb1, 0x0b, 0x11,
      0x51, 0x9e, 0x79, 0x6e, 0xfa, 0x77, 0xc0, 0xc9, 0xb1, 0x4b, 0xea, 0xf1,
      0xba, 0x13, 0x08, 0xa6, 0x5f, 0xee, 0x50, 0xe7, 0x86, 0x22, 0x89, 0xd4,
      0x6a, 0x3c, 0xfe, 0x79, 0xf4, 0x23, 0xe7, 0xd9, 0x20, 0x1d, 0xfc, 0x74,
      0x28, 0xbe, 0xc7, 0xf3, 0x04, 0x22, 0x85, 0x08, 0xb7, 0xe8, 0xe5, 0xaf,
      0x4d, 0xba, 0xbb, 0xb3, 0x95, 0x8d, 0x1f, 0x48, 0xda, 0xe4, 0x01, 0x6c,
      0xf6, 0x99, 0x42, 0x1b, 0x7a, 0x9a, 0x0b, 0x1d, 0xc1, 0xc8, 0x06, 0xa7,
      0xb1, 0x9c, 0xf6, 0x5f, 0xb7, 0xd4, 0x46, 0x5a, 0x03, 0x1b, 0xd8, 0xc2,
      0x40, 0x71, 0xb3, 0x97, 0xdc, 0x1f, 0x69, 0x87, 0xcd, 0xdc, 0x8b, 0x69,
      0xf5, 0xf3, 0xdd, 0xe2, 0x5f, 0xa3, 0x6c, 0x2a, 0xd6, 0xe0, 0x30, 0xc6,
      0x44, 0x13, 0xbf, 0x3e, 0xb3, 0x91, 0x76, 0xbc, 0x00, 0x3c, 0x90, 0x9e,
      0x37, 0xd2, 0x8d, 0x5a, 0x04, 0x0c, 0x15, 0xbb, 0x4a, 0x73, 0xc7, 0x4c,
      0x39, 0xc4, 0xd1, 0x32, 0xd0, 0x9f, 0xd5, 0x65, 0xab, 0xd7, 0xb6, 0x3d,
      0x81, 0x11, 0x5e, 0xcc, 0x8a, 0x15, 0x17, 0x86, 0xf6, 0xea, 0x50, 0x88,
      0x2e, 0x50, 0xdb, 0x36, 0x2c, 0xce, 0xd3, 0x97, 0x02, 0xae, 0x1e, 0xcc,
      0x17, 0x6c, 0xec, 0xe9, 0x50, 0x9f, 0xf0, 0x71, 0xb8, 0x7f, 0x14, 0x25,
      0x47, 0xca, 0x3a, 0xab, 0x04, 0xbe, 0xc1, 0xa7, 0xd0, 0xc6, 0xff, 0x35,
      0x06, 0x04, 0x20, 0xb9, 0x9e, 0x28, 0x55, 0x15, 0xee, 0xc0, 0x16, 0xec,
      0x41, 0x9c, 0xaf, 0x75, 0xcf, 0x11, 0xaf, 0x56, 0xa3, 0x95, 0x18, 0x7f,
      0xe6, 0x57, 0x57, 0x86, 0x99, 0x8b, 0x6b, 0x43, 0x48, 0x56, 0x1a, 0x0d,
      0xd6, 0x88, 0x78, 0xcf},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 89
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     89,
     0,
     {0x1c, 0x02, 0x91, 0x85, 0x06, 0x13, 0x85, 0x64, 0x39, 0x43, 0xdc, 0xa8,
      0xad, 0xef, 0xc5, 0x66, 0x6c, 0xa0, 0x39, 0x76, 0x5d, 0x29, 0xf8, 0xba,
      0xa2, 0x0d, 0xc3, 0xcc, 0x43, 0x98, 0x1e, 0xbe, 0x1e, 0x6d, 0x1f, 0x09,
      0xa6, 0x17, 0x55, 0x99, 0x55, 0x43, 0x73, 0x23, 0xe5, 0x0f, 0x64, 0x64,
      0xa6, 0x99, 0x50, 0xba, 0xf2, 0x3c, 0x74, 0x63, 0xb1, 0xb1, 0xc6, 0x76,
      0x1b, 0x50, 0xbb, 0xa8, 0x9c, 0x81, 0x29, 0x9d, 0x45, 0x43, 0xf7, 0x6e,
      0x3e, 0x4c, 0xa4, 0xe3, 0x0c, 0xe7, 0x10, 0xa2, 0x07, 0x07, 0xb1, 0x8d,
      0xee, 0x5d, 0x2a, 0xc9, 0xe0, 0xd9, 0x33, 0x01, 0x48, 0x52, 0x6f, 0x19,
      0x34, 0x39, 0xcb, 0x33, 0x23, 0x8e, 0xf9, 0xd8, 0x24, 0x24, 0xfc, 0x12,
      0x87, 0x09, 0x7e, 0x76, 0x26, 0xba, 0xe0, 0x13, 0x0b, 0x73, 0x5a, 0x22,
      0xcb, 0x6e, 0xf0, 0x8b, 0xa4, 0xd8, 0x40, 0xb3, 0x70, 0xc9, 0xe8, 0x65,
      0x8f, 0x83, 0x26, 0x7e, 0x52, 0xb8, 0xd5, 0x6a, 0xe0, 0xad, 0xa9, 0xdc,
      0x51, 0x14, 0x92, 0x0f, 0x97, 0x88, 0x4d, 0x6b, 0xf5, 0x29, 0xbb, 0xd7,
      0xc8, 0x1b, 0x2f, 0x9a, 0x70, 0x0e, 0x4d, 0xf4, 0xc7, 0x1a, 0x8c, 0xe3,
      0x14, 0x1f, 0x9f, 0x4b, 0xe3, 0x1c, 0x9d, 0x63, 0x96, 0x19, 0xb2, 0x0f,
      0x72, 0x5f, 0x55, 0x47, 0x5b, 0x38, 0xce, 0x36, 0xfa, 0xee, 0x92, 0x98,
      0x64, 0xa5, 0xc7, 0x79, 0x3e, 0xc2, 0x6d, 0xd6, 0xd1, 0xc4, 0xb7, 0x5f,
      0x11, 0x1f, 0xeb, 0xa3, 0x76, 0x5d, 0x0d, 0x35, 0xa2, 0x72, 0xfc, 0x52,
      0xfd, 0xb8, 0x5f, 0x2c, 0x0b, 0xd1, 0xbd, 0x22, 0xcf, 0xb4, 0x7b, 0xd0,
      0xba, 0x58, 0xd0, 0x0a, 0xf1, 0x19, 0x75, 0x9e, 0x1f, 0x4d, 0x57, 0x63,
      0xf1, 0x5c, 0xba, 0x4e, 0x78, 0x8f, 0xc6, 0xf8, 0xa2, 0x21, 0xdb, 0xde,
      0xb3, 0x2c, 0x48, 0x4a},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 90
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     90,
     0,
     {0x05, 0x94, 0xa2, 0xa0, 0xf3, 0xd1, 0x08, 0x57, 0xe8, 0xe2, 0xa8, 0x9d,
      0x72, 0xdf, 0x80, 0xc8, 0xb3, 0x79, 0x77, 0xbf, 0x2c, 0x39, 0x00, 0x87,
      0xd1, 0xdf, 0x76, 0x72, 0xfc, 0xa5, 0x0d, 0x21, 0xb7, 0xa3, 0xb2, 0x44,
      0x53, 0xb5, 0x5a, 0xfe, 0xe4, 0xc6, 0xfb, 0x2a, 0xdf, 0x83, 0xe6, 0xb3,
      0xe6, 0xa6, 0x3d, 0xb3, 0x1b, 0x68, 0x5c, 0xa9, 0x56, 0xbd, 0xa1, 0xf3,
      0x07, 0x4e, 0xb5, 0x33, 0x64, 0xd9, 0xbb, 0xb9, 0xad, 0x16, 0x88, 0x3b,
      0x56, 0xce, 0xb6, 0x6c, 0xae, 0x51, 0x71, 0x2d, 0x59, 0x2e, 0x10, 0xf8,
      0x51, 0xc4, 0x43, 0x1a, 0x4f, 0x7b, 0x36, 0x25, 0xc7, 0x74, 0x80, 0x8b,
      0xf7, 0xc6, 0x94, 0xc5, 0x82, 0xf1, 0xf2, 0x0c, 0x2f, 0x51, 0xca, 0x9f,
      0x78, 0x1c, 0x61, 0x72, 0xd0, 0x52, 0x01, 0xe1, 0xe0, 0xad, 0x96, 0xf7,
      0x23, 0x1c, 0x27, 0x86, 0xe0, 0x39, 0xcd, 0xaf, 0xcc, 0x40, 0x45, 0xbb,
      0x07, 0x8c, 0x2f, 0x43, 0x2d, 0x34, 0x09, 0xdc, 0xaf, 0x25, 0xd8, 0xc0,
      0x54, 0x9d, 0xe0, 0x3d, 0x79, 0x64, 0x60, 0x6a, 0xa0, 0xfb, 0xda, 0x33,
      0x3a, 0x0e, 0xac, 0x26, 0xe5, 0xf3, 0xba, 0x13, 0xb1, 0xd6, 0xdc, 0x71,
      0x0c, 0x01, 0xa1, 0x7e, 0x1a, 0x24, 0x24, 0x1b, 0xd7, 0x41, 0xd5, 0x1d,
      0xb4, 0xca, 0xfb, 0xac, 0xa5, 0x18, 0xfe, 0x32, 0xfe, 0xb0, 0xed, 0x5c,
      0xb9, 0x16, 0xc8, 0xc0, 0x94, 0xc4, 0x1f, 0x09, 0x2c, 0xec, 0xb7, 0xa9,
      0xcc, 0x08, 0x18, 0x35, 0x1b, 0x5c, 0x8b, 0x65, 0x63, 0xbb, 0xa3, 0x2f,
      0xb8, 0xe8, 0x6b, 0x4c, 0x81, 0xf4, 0xf5, 0x7c, 0x24, 0xa8, 0x80, 0xe9,
      0x1d, 0xaf, 0x31, 0xcd, 0x19, 0x11, 0xaa, 0x66, 0x90, 0xc8, 0xe4, 0x5f,
      0x00, 0xdd, 0x62, 0x98, 0x63, 0x69, 0xbf, 0xa5, 0x82, 0x4b, 0x78, 0x5c,
      0x1c, 0x56, 0xfd, 0xbb},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: last byte in em modified
    // tcID: 91
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     91,
     0,
     {0x10, 0xbc, 0x1d, 0x1d, 0x1f, 0xdd, 0x4a, 0x8f, 0x74, 0xb1, 0x7f, 0x2c,
      0x82, 0x58, 0x07, 0x8e, 0xf5, 0xc4, 0xf5, 0xfb, 0x97, 0x3a, 0x25, 0x05,
      0x06, 0x0b, 0x12, 0x65, 0x04, 0xc9, 0x36, 0x6a, 0x45, 0x78, 0xe2, 0xa3,
      0x33, 0xb1, 0xa9, 0xc5, 0x80, 0x23, 0x9e, 0xe9, 0x59, 0xd1, 0x70, 0x17,
      0x66, 0x46, 0x31, 0x98, 0x2c, 0xb8, 0x55, 0x4f, 0xae, 0x8c, 0xed, 0xae,
      0x07, 0xeb, 0x7e, 0x2f, 0xb6, 0x9c, 0xb7, 0x02, 0xdb, 0x93, 0xd9, 0x48,
      0xd0, 0xd0, 0xe4, 0x65, 0x4d, 0x9e, 0xb4, 0x91, 0x92, 0xef, 0x87, 0xe9,
      0x2f, 0x4d, 0x22, 0x9b, 0xa5, 0x6f, 0x16, 0x5a, 0x8a, 0xd4, 0x76, 0x9d,
      0x0c, 0x70, 0x71, 0x11, 0xb9, 0xbe, 0x90, 0xc6, 0xcc, 0x29, 0xcb, 0x33,
      0x89, 0xa9, 0xae, 0x4d, 0x50, 0x45, 0xd8, 0xa6, 0x92, 0x34, 0xcd, 0x5e,
      0x57, 0xfa, 0xbb, 0x76, 0xe5, 0xd1, 0x86, 0x9d, 0x83, 0xcd, 0x2f, 0x3e,
      0xa8, 0xf0, 0x41, 0x91, 0x94, 0xcc, 0x54, 0xc3, 0x98, 0xa2, 0x88, 0xaa,
      0xa3, 0x5f, 0x76, 0x5c, 0xa8, 0xe0, 0xe2, 0x64, 0x86, 0x5b, 0x70, 0x9d,
      0x5a, 0x21, 0xc9, 0xd8, 0x07, 0xc4, 0xc0, 0x75, 0x1f, 0x9e, 0x4e, 0x68,
      0xc9, 0xcd, 0xc6, 0x1d, 0x93, 0x11, 0x3e, 0x5b, 0xb8, 0x11, 0xc2, 0xe2,
      0x17, 0xf3, 0x1e, 0xb1, 0x4f, 0x01, 0x0a, 0xad, 0x77, 0xab, 0xed, 0x3e,
      0x43, 0x05, 0xe7, 0xbd, 0xb1, 0x06, 0x68, 0x79, 0x23, 0x78, 0x49, 0x88,
      0x3c, 0x3e, 0xf0, 0x99, 0xb8, 0x5c, 0x78, 0x35, 0x2b, 0x32, 0x37, 0x4d,
      0xd2, 0x44, 0xe1, 0x73, 0xed, 0xc3, 0x82, 0x49, 0x24, 0x09, 0x8c, 0xfc,
      0xe9, 0xd7, 0x29, 0x16, 0x6c, 0xcf, 0xcc, 0xad, 0xae, 0x88, 0x71, 0x26,
      0x69, 0x27, 0x76, 0x3a, 0xe6, 0xa5, 0xe7, 0x50, 0xf4, 0x9b, 0x83, 0x7b,
      0x60, 0x68, 0x2a, 0xa9},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 0
    // tcID: 92
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     92,
     0,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is 1
    // tcID: 93
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     93,
     0,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n-1
    // tcID: 94
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     94,
     0,
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd4},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: signature is n
    // tcID: 95
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     95,
     0,
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd5},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to signature
    // tcID: 96
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     96,
     0,
     {0x00, 0x00, 0x5e, 0x91, 0xb5, 0xdc, 0xbf, 0x02, 0xd6, 0xf1, 0x96, 0x21,
      0xd4, 0x1a, 0x83, 0xdc, 0x8f, 0x15, 0xea, 0x83, 0xc0, 0xed, 0xb8, 0x37,
      0x65, 0xef, 0x02, 0x9b, 0x0a, 0xca, 0xc2, 0xe1, 0xec, 0x89, 0x18, 0xb1,
      0xd2, 0xaf, 0xe1, 0xfa, 0xdf, 0x11, 0xc4, 0x8d, 0x27, 0x59, 0x4c, 0xb9,
      0xc0, 0x1f, 0xed, 0x79, 0xd9, 0x0e, 0x5d, 0x5a, 0x80, 0x85, 0xc4, 0x38,
      0x45, 0x01, 0x11, 0xaa, 0x7d, 0x9f, 0xa3, 0x9c, 0x23, 0x45, 0xb1, 0x4f,
      0xc3, 0xc2, 0xcb, 0x34, 0x12, 0x8f, 0x86, 0xdb, 0x5e, 0xb0, 0x0b, 0xdf,
      0x8d, 0xfe, 0x38, 0xd6, 0x1f, 0x29, 0xa4, 0x1f, 0xe3, 0x13, 0x42, 0xe7,
      0xaa, 0xef, 0xcb, 0x4b, 0x12, 0x2e, 0xb5, 0xd6, 0x3c, 0x2f, 0x5c, 0x26,
      0x3c, 0x8d, 0xf8, 0x45, 0x0e, 0x94, 0x28, 0xff, 0xef, 0x97, 0x4d, 0x53,
      0x58, 0x18, 0xd5, 0x1d, 0xc0, 0x3a, 0x7d, 0x60, 0xc8, 0xb2, 0xd1, 0x6c,
      0x99, 0x9a, 0xe4, 0x6d, 0x73, 0xab, 0x40, 0x51, 0x5f, 0xe6, 0x01, 0xd9,
      0xb8, 0x9b, 0x1d, 0x09, 0xc6, 0xd6, 0x0c, 0xd5, 0x16, 0x39, 0xa9, 0x7c,
      0x1d, 0x21, 0x1e, 0x09, 0x76, 0x09, 0xba, 0x5e, 0x8c, 0x31, 0x9c, 0x6f,
      0xbd, 0x21, 0xb3, 0x4a, 0x63, 0x4e, 0xc8, 0xfb, 0x89, 0x71, 0xc5, 0xaa,
      0xe2, 0x1c, 0x70, 0xb8, 0x47, 0xa4, 0x53, 0x9c, 0xc1, 0x0d, 0xc3, 0x14,
      0xdd, 0xd8, 0xa9, 0x62, 0x9e, 0x8a, 0x0e, 0x51, 0xc6, 0x6c, 0x0c, 0xb6,
      0x1f, 0xd1, 0xf7, 0x22, 0x8c, 0x01, 0xc6, 0x76, 0x91, 0x90, 0xab, 0xe9,
      0xba, 0xc9, 0xa3, 0x89, 0x78, 0x00, 0x05, 0x00, 0x14, 0x35, 0x85, 0x94,
      0xe0, 0xfb, 0x20, 0xdb, 0xb4, 0x58, 0xb1, 0x2a, 0xa1, 0x34, 0x68, 0x26,
      0xcc, 0x9f, 0x7e, 0x9c, 0x53, 0x52, 0xb0, 0x73, 0xd6, 0x28, 0x53, 0xda,
      0xfe, 0x77, 0xc8, 0x48, 0xcb, 0x1f},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to signature
    // tcID: 97
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     97,
     0,
     {0x5e, 0x91, 0xb5, 0xdc, 0xbf, 0x02, 0xd6, 0xf1, 0x96, 0x21, 0xd4, 0x1a,
      0x83, 0xdc, 0x8f, 0x15, 0xea, 0x83, 0xc0, 0xed, 0xb8, 0x37, 0x65, 0xef,
      0x02, 0x9b, 0x0a, 0xca, 0xc2, 0xe1, 0xec, 0x89, 0x18, 0xb1, 0xd2, 0xaf,
      0xe1, 0xfa, 0xdf, 0x11, 0xc4, 0x8d, 0x27, 0x59, 0x4c, 0xb9, 0xc0, 0x1f,
      0xed, 0x79, 0xd9, 0x0e, 0x5d, 0x5a, 0x80, 0x85, 0xc4, 0x38, 0x45, 0x01,
      0x11, 0xaa, 0x7d, 0x9f, 0xa3, 0x9c, 0x23, 0x45, 0xb1, 0x4f, 0xc3, 0xc2,
      0xcb, 0x34, 0x12, 0x8f, 0x86, 0xdb, 0x5e, 0xb0, 0x0b, 0xdf, 0x8d, 0xfe,
      0x38, 0xd6, 0x1f, 0x29, 0xa4, 0x1f, 0xe3, 0x13, 0x42, 0xe7, 0xaa, 0xef,
      0xcb, 0x4b, 0x12, 0x2e, 0xb5, 0xd6, 0x3c, 0x2f, 0x5c, 0x26, 0x3c, 0x8d,
      0xf8, 0x45, 0x0e, 0x94, 0x28, 0xff, 0xef, 0x97, 0x4d, 0x53, 0x58, 0x18,
      0xd5, 0x1d, 0xc0, 0x3a, 0x7d, 0x60, 0xc8, 0xb2, 0xd1, 0x6c, 0x99, 0x9a,
      0xe4, 0x6d, 0x73, 0xab, 0x40, 0x51, 0x5f, 0xe6, 0x01, 0xd9, 0xb8, 0x9b,
      0x1d, 0x09, 0xc6, 0xd6, 0x0c, 0xd5, 0x16, 0x39, 0xa9, 0x7c, 0x1d, 0x21,
      0x1e, 0x09, 0x76, 0x09, 0xba, 0x5e, 0x8c, 0x31, 0x9c, 0x6f, 0xbd, 0x21,
      0xb3, 0x4a, 0x63, 0x4e, 0xc8, 0xfb, 0x89, 0x71, 0xc5, 0xaa, 0xe2, 0x1c,
      0x70, 0xb8, 0x47, 0xa4, 0x53, 0x9c, 0xc1, 0x0d, 0xc3, 0x14, 0xdd, 0xd8,
      0xa9, 0x62, 0x9e, 0x8a, 0x0e, 0x51, 0xc6, 0x6c, 0x0c, 0xb6, 0x1f, 0xd1,
      0xf7, 0x22, 0x8c, 0x01, 0xc6, 0x76, 0x91, 0x90, 0xab, 0xe9, 0xba, 0xc9,
      0xa3, 0x89, 0x78, 0x00, 0x05, 0x00, 0x14, 0x35, 0x85, 0x94, 0xe0, 0xfb,
      0x20, 0xdb, 0xb4, 0x58, 0xb1, 0x2a, 0xa1, 0x34, 0x68, 0x26, 0xcc, 0x9f,
      0x7e, 0x9c, 0x53, 0x52, 0xb0, 0x73, 0xd6, 0x28, 0x53, 0xda, 0xfe, 0x77,
      0xc8, 0x48, 0xcb, 0x1f, 0x00, 0x00},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated signature
    // tcID: 98
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     98,
     0,
     {0x5e, 0x91, 0xb5, 0xdc, 0xbf, 0x02, 0xd6, 0xf1, 0x96, 0x21, 0xd4, 0x1a,
      0x83, 0xdc, 0x8f, 0x15, 0xea, 0x83, 0xc0, 0xed, 0xb8, 0x37, 0x65, 0xef,
      0x02, 0x9b, 0x0a, 0xca, 0xc2, 0xe1, 0xec, 0x89, 0x18, 0xb1, 0xd2, 0xaf,
      0xe1, 0xfa, 0xdf, 0x11, 0xc4, 0x8d, 0x27, 0x59, 0x4c, 0xb9, 0xc0, 0x1f,
      0xed, 0x79, 0xd9, 0x0e, 0x5d, 0x5a, 0x80, 0x85, 0xc4, 0x38, 0x45, 0x01,
      0x11, 0xaa, 0x7d, 0x9f, 0xa3, 0x9c, 0x23, 0x45, 0xb1, 0x4f, 0xc3, 0xc2,
      0xcb, 0x34, 0x12, 0x8f, 0x86, 0xdb, 0x5e, 0xb0, 0x0b, 0xdf, 0x8d, 0xfe,
      0x38, 0xd6, 0x1f, 0x29, 0xa4, 0x1f, 0xe3, 0x13, 0x42, 0xe7, 0xaa, 0xef,
      0xcb, 0x4b, 0x12, 0x2e, 0xb5, 0xd6, 0x3c, 0x2f, 0x5c, 0x26, 0x3c, 0x8d,
      0xf8, 0x45, 0x0e, 0x94, 0x28, 0xff, 0xef, 0x97, 0x4d, 0x53, 0x58, 0x18,
      0xd5, 0x1d, 0xc0, 0x3a, 0x7d, 0x60, 0xc8, 0xb2, 0xd1, 0x6c, 0x99, 0x9a,
      0xe4, 0x6d, 0x73, 0xab, 0x40, 0x51, 0x5f, 0xe6, 0x01, 0xd9, 0xb8, 0x9b,
      0x1d, 0x09, 0xc6, 0xd6, 0x0c, 0xd5, 0x16, 0x39, 0xa9, 0x7c, 0x1d, 0x21,
      0x1e, 0x09, 0x76, 0x09, 0xba, 0x5e, 0x8c, 0x31, 0x9c, 0x6f, 0xbd, 0x21,
      0xb3, 0x4a, 0x63, 0x4e, 0xc8, 0xfb, 0x89, 0x71, 0xc5, 0xaa, 0xe2, 0x1c,
      0x70, 0xb8, 0x47, 0xa4, 0x53, 0x9c, 0xc1, 0x0d, 0xc3, 0x14, 0xdd, 0xd8,
      0xa9, 0x62, 0x9e, 0x8a, 0x0e, 0x51, 0xc6, 0x6c, 0x0c, 0xb6, 0x1f, 0xd1,
      0xf7, 0x22, 0x8c, 0x01, 0xc6, 0x76, 0x91, 0x90, 0xab, 0xe9, 0xba, 0xc9,
      0xa3, 0x89, 0x78, 0x00, 0x05, 0x00, 0x14, 0x35, 0x85, 0x94, 0xe0, 0xfb,
      0x20, 0xdb, 0xb4, 0x58, 0xb1, 0x2a, 0xa1, 0x34, 0x68, 0x26, 0xcc, 0x9f,
      0x7e, 0x9c, 0x53, 0x52, 0xb0, 0x73, 0xd6, 0x28, 0x53, 0xda, 0xfe, 0x77,
      0xc8, 0x48},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: empty signature
    // tcID: 99
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     99,
     0,
     {},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: PKCS #1 v1.5 signature
    // tcID: 100
    {SEC_OID_SHA256,
     CKG_MGF1_SHA256,
     100,
     0,
     {0x17, 0x58, 0xeb, 0x94, 0x58, 0x8e, 0x6f, 0xc4, 0xf5, 0x0c, 0x1b, 0xe1,
      0xaf, 0xca, 0xa4, 0x10, 0x27, 0x86, 0x9f, 0x30, 0x4c, 0xad, 0x51, 0x3b,
      0x1f, 0xb1, 0x2c, 0x2f, 0x44, 0x6d, 0x63, 0xcd, 0xc0, 0x5c, 0x48, 0x30,
      0xa7, 0xe3, 0xe6, 0x30, 0xda, 0x7b, 0x2d, 0xa4, 0xf7, 0x86, 0x7c, 0xc1,
      0x73, 0xbf, 0x64, 0x20, 0xf9, 0x73, 0x22, 0x77, 0x28, 0x25, 0x96, 0xde,
      0x41, 0xde, 0xd3, 0x2e, 0x21, 0xd0, 0xcc, 0x31, 0x44, 0x11, 0x74, 0xda,
      0x87, 0x65, 0xf5, 0x74, 0x19, 0xc7, 0x76, 0x4e, 0xa7, 0x58, 0xf5, 0x5b,
      0xc1, 0x76, 0x46, 0xeb, 0x10, 0x0c, 0x43, 0x5d, 0x1a, 0xc0, 0xee, 0xd6,
      0xfc, 0x7b, 0xa6, 0xde, 0x5f, 0x83, 0x20, 0x94, 0xee, 0x2f, 0x47, 0x99,
      0x79, 0x76, 0x5e, 0x05, 0xac, 0x99, 0x76, 0x78, 0x8d, 0xb3, 0xc2, 0x41,
      0xa9, 0xe3, 0x2a, 0x0d, 0xa8, 0x64, 0xf0, 0x01, 0x9a, 0x87, 0x64, 0x6b,
      0xa6, 0x23, 0xd6, 0x3f, 0x44, 0x11, 0xaf, 0x5d, 0xee, 0x1b, 0xe9, 0xec,
      0x48, 0x8c, 0x7e, 0x3e, 0x1b, 0x23, 0x14, 0x79, 0xde, 0x70, 0xb9, 0xac,
      0x5f, 0x78, 0xa1, 0x7b, 0x1f, 0x41, 0x20, 0xae, 0xce, 0x45, 0xf2, 0x6c,
      0x07, 0xe7, 0xbb, 0x34, 0x5f, 0xdf, 0xeb, 0x05, 0xe1, 0x4b, 0xca, 0xac,
      0xc6, 0x14, 0x67, 0x2a, 0x46, 0x5f, 0xc5, 0x23, 0x62, 0x4c, 0xb1, 0x9f,
      0x66, 0xf9, 0xc6, 0xc3, 0xf6, 0x42, 0xb8, 0x32, 0xca, 0x44, 0xcb, 0x25,
      0x17, 0x6d, 0x67, 0x9f, 0x0e, 0x05, 0x60, 0x6c, 0x3f, 0xed, 0x02, 0x2c,
      0xac, 0x24, 0xc2, 0xbf, 0x96, 0x0a, 0x40, 0x6d, 0x48, 0x81, 0x8e, 0x3e,
      0xb7, 0xed, 0x53, 0xb0, 0x44, 0x60, 0x32, 0x46, 0x90, 0x47, 0xdf, 0xed,
      0x95, 0xfc, 0x18, 0x08, 0x8c, 0x92, 0xd9, 0x1d, 0x93, 0x72, 0x2c, 0x47,
      0xf8, 0x81, 0x63, 0xa8},
     pub_key_1,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false}};

#endif  // rsa_pss_2048_sha256_0_vectors_h__
