/* $Id: nsrllookup.cc 123 2012-02-08 16:43:07Z rjh $
 * Copyright (c) 2012, Robert J. Hansen <rjh@secret-alchemy.com>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#include "common.hpp"

using std::vector;
using std::string;
using std::find;
using std::remove;
using std::ofstream;
using std::cin;

string SERVER("localhost");
bool SCORE_HITS(false); // score misses
int PORT(9120);
ofstream* HIT_FILE(0);
ofstream* MISSES_FILE(0);
NetworkSocket* GLOBAL_SOCK(0);

namespace {
bool is_valid(const string& line)
{
    vector<string>* tokens = tokenize(line);
    string::iterator siter;
    bool rv = false;
    if ((tokens->size() < 1) ||
            (tokens->at(0).size() != 32 && tokens->at(0).size() != 40))
        goto IS_VALID_BAIL;

    for (siter = tokens->at(0).begin() ;
            siter != tokens->at(0).end() ; ++
            ++siter)
        if (! ((*siter >= '0' && *siter <= '9') ||
                (*siter >= 'A' && *siter <= 'F') ||
                (*siter >= 'a' && *siter <= 'f')))
            goto IS_VALID_BAIL;

    rv = true;

IS_VALID_BAIL:
    if (0 != tokens) {
        delete tokens;
    }
    return rv;
}
}


int main(int argc, char* argv[])
{
#ifdef WINDOWS
    WSAData wsad;
    if (0 != WSAStartup(MAKEWORD(2, 0), &wsad)) {
        std::cerr <<
                  "Error: could not initialize Winsock.\n\n"
                  "You're running a very old version of Windows.  nsrllookup won't work\n"
                  "on this system.\n";
        bomb(0);
    }
#endif

    vector<string> buffer;

    parse_options(argc, argv);

    try {
        try {
            vector<char> buf(65536, '\0');
            while (cin) {
#ifdef WINDOWS
                ZeroMemory(&buf[0], 65536);
#else
                memset(&buf[0], 0, 65536);
#endif

                cin.getline(&buf[0], 65536);
                buf.erase(remove(buf.begin(), buf.end(), '\r'), buf.end());
                buf.erase(remove(buf.begin(), buf.end(), '\n'), buf.end());

                string line(&buf[0]);

                if (is_valid(line)) {
                    buffer.push_back(line);
                    if (buffer.size() >= 4096) {
                        query_server(buffer);
                        buffer.clear();
                    }
                }
            }
        } catch (EOFException&) {
            // pass: this is entirely expected.  Uh, well, maybe.  It should
            // actually be removed, I think...
        }
        if (buffer.size() > 0) {
            query_server(buffer);
            buffer.clear();
        }
        end_connection();
    } catch (NetworkError&) {
        std::cerr << "nsrllookup failed: network error\n";
    } catch (ConnectionRefused&) {
        std::cerr << "nsrllookup failed: server refused the connection\n";
    } catch (std::exception& e) {
        std::cerr << "nsrllookup failed due to an unexpected exception:\n\n\t"
                  << e.what() << "\n";
    }
    if (HIT_FILE)
        delete HIT_FILE;
    if (MISSES_FILE)
        delete MISSES_FILE;
    if (GLOBAL_SOCK)
        delete GLOBAL_SOCK;

#ifdef WINDOWS
    WSACleanup();
#endif
    return 0;
}
