# NSM-Console logging to a text file
class Logger
  @@logfile = nil
  
  def initialize(name)
    @@logfile = name.to_s
  end
  
  def Logger.write(line)
    if @@logfile.nil?
      puts "Error. No logfile specified."
      return
    end
    
    if !File.exist?(@@logfile)
      begin
        system("touch #{@@logfile}")
      rescue
        STDERR.puts "Error creating logfile #{@@logfile}: #{$!}"
        exit
      end
    end
    
    begin
      File.open(@@logfile, "a") do |f|
        f.write(line)
      end
    rescue
      STDERR.puts "Error writing to logfile: #{$!}"
    end
    
  end
  
end
