#
# $Id: discover-pingd.tm,v 1.8 2005/08/05 19:58:20 rader Exp $
#

#==============================================================================

sub print_latency_conf {
  $t = "$target-$host-ping-latency";
  print <<__EOT__; 
#------------------------------------------------------------------

System[$t]:        ping\@$host
RRD[$t]:           ${root}${prefix}latency/${t}.rrd
GraphWebPage[$t]:  ${root}${prefix}latency/${t}.cgi
Variable[$t][ping_min]: \\
  `nrg-pingdstat -m min $host` GAUGE
Variable[$t][ping_ave]: \\
  `nrg-pingdstat -m ave $host` GAUGE
Variable[$t][ping_max]: \\
  `nrg-pingdstat -m max $host` GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:     $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:  \\
  ${source} to ${host} ($dest_addr) Network Latency Graphs
PageTop[$t]:    \\
  ${source} to ${host} Network Latency Graphs <P>
PageBody[$t]:
  <TABLE>
    <TR><TD>&nbsp;&nbsp;Ping destination IP address is $dest_addr</TD></TR>
    <TR><TD>&nbsp;&nbsp;Ping packet size is 1400 bytes</TD></TR>
    <TR><TD>&nbsp;&nbsp;One ping is sent every 15 seconds</TD></TR>
    <TR><TD>&nbsp;&nbsp;Data points represent 20 pings sent over a five minute interval</TD></TR>
  </TABLE>

PageBottom[$t]: ${source} to ${host} Network Latency Graphs

__EOT__

}

#==============================================================================

sub print_loss_conf {
  $t = "$target-$host-ping-loss";
  print <<__EOT__; 
#------------------------------------------------------------------

System[$t]:        ping\@$host
RRD[$t]:           ${root}${prefix}loss/${t}.rrd
GraphWebPage[$t]:  ${root}${prefix}loss/${t}.cgi
Variable[$t][ping_loss]: \\
  `nrg-pingdstat -m loss $host` GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:     $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:  \\
  ${source} to ${host} ($dest_addr) Packet Loss Graphs
PageTop[$t]:    \\
  ${source} to ${host} Packet Loss Graphs <P>
PageBody[$t]:
  <TABLE>
    <TR><TD>&nbsp;&nbsp;Ping destination IP address is $dest_addr</TD></TR>
    <TR><TD>&nbsp;&nbsp;Ping packet size is 1400 bytes</TD></TR>
    <TR><TD>&nbsp;&nbsp;One ping is sent every 15 seconds</TD></TR>
    <TR><TD>&nbsp;&nbsp;Data points represent 20 pings sent over a five minute interval</TD></TR>
  </TABLE>

PageBottom[$t]: ${source} to ${host} Packet Loss Graphs

__EOT__

}

#==============================================================================

return 1;

