#
# discover-netdev.tm
#
# $Id: discover-netdev.tm,v 1.7 2002/03/05 15:16:37 rader Exp $
#

#==============================================================================

sub print_cpu_conf {
  $t = "$target-netdev-cpu";
  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:             ${comm_str}\@${host}
RRD[$t]:                ${root}${prefix}${t}.rrd
GraphWebPage[$t]:       ${root}${prefix}${t}.cgi
Variable[$t][cpu]:      $cpu_oid GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:          $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:  ${target}'s CPU Utilization Graphs
PageTop[$t]:    ${target}'s CPU Utilization Graphs <P>
PageBottom[$t]: ${target}'s CPU Utilization Graphs

__EOT__
}
#==============================================================================

sub print_mem_conf_with_total {
  $t = "$target-netdev-mem";
  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:               ${comm_str}\@${host}
RRD[$t]:                  ${root}${prefix}${t}.rrd
GraphWebPage[$t]:         ${root}${prefix}${t}.cgi
Variable[$t][free_mem]:   $free_mem_oid GAUGE
Variable[$t][total_mem]:  $total_mem_oid GAUGE
CalcDef[$t][used_mem]:    total_mem,free_mem,-
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:            $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:   ${target}'s Real Memory Utilization Graphs
PageTop[$t]:     ${target}'s Real Memory Utilization Graphs <P>
PageBottom[$t]:  ${target}'s Real Memory Utilization Graphs

__EOT__
}

#==============================================================================

sub print_mem_conf_with_used {
  $t = "$target-netdev-mem";
  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:               ${comm_str}\@${host}
RRD[$t]:                  ${root}${prefix}${t}.rrd
GraphWebPage[$t]:         ${root}${prefix}${t}.cgi
Variable[$t][free_mem]:   $free_mem_oid GAUGE
Variable[$t][used_mem]:   $used_mem_oid GAUGE
CalcDef[$t][total_mem]:   free_mem,used_mem,+
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:            $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:   ${target}'s Real Memory Utilization Graphs
PageTop[$t]:     ${target}'s Real Memory Utilization Graphs <P>
PageBottom[$t]:  ${target}'s Real Memory Utilization Graphs

__EOT__
}

#==============================================================================

return 1;

