#
# $Id: discover-errors.tm,v 1.3 2003/07/20 03:47:26 rader Exp $
#

#=============================================================================

sub print_conf {
local($instance) = @_;

$dns_name = &dns_rev_lookup($address);

print <<__EOT__;
#------------------------------------------------------------------

System[$target-ierr]:            ${comm_str}\@${host}${port}
RRD[$target-ierr]:               ${root}${prefix}${target}-ierr.rrd
GraphWebPage[$target-ierr]:      ${root}${prefix}${target}-ierr.cgi
Variable[$target-ierr][in_err]:  ifInErrors.$instance
Variable[$target-ierr][out_err]: ifOutErrors.$instance
Variable[$target-ierr][in_dis]:  ifInDiscards.$instance
Variable[$target-ierr][out_dis]: ifOutDiscards.$instance
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$target-ierr]:      $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$target-ierr]: $descriptions{$instance}
PageTop[$target-ierr]:   $descriptions{$instance}
PageBody[$target-ierr]:
  <TABLE>
    <TR><TD>&nbsp;&nbsp;System:</TD><TD>$target_basename</TD></TR>
    <TR><TD>&nbsp;&nbsp;Description:</TD><TD>$sys_details{'sysDescr'}</TD></TR>
    <TR><TD>&nbsp;&nbsp;Interface:</TD><TD>$i_to_name{$instance} (SNMP Instance $instance)</TD></TR>
    <TR><TD>&nbsp;&nbsp;IP Address:</TD><TD>$address ($dns_name)</TD></TR>
    <TR><TD>&nbsp;&nbsp;Network Type:</TD><TD>$i_to_type{$instance} ($i_to_speed{$instance})</TD></TR>
  </TABLE>
PageBottom[$target-ierr]: $descriptions{$instance}

__EOT__

}

#=============================================================================

return 1;

