/* 
 *  $Id: receive.c,v 1.25 2005/08/05 20:06:28 rader Exp $
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#ifndef __SOLARIS__
#include <sys/socketvar.h>
#endif
#include <sys/file.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <memory.h>
#include <errno.h>
#include "pingd.h"

extern struct ping_list_entry *ping_list[];
extern int ping_list_size;
extern int pingd_socket;
extern char *ping_packet;
extern int packet_size;
extern int icmp_ident;
extern int errno;
extern int debuggin;

/*------------------------------------------------------------------*/

int
parse_icmp_seq(packet,packetlen,from)
char *packet;
int packetlen;
struct sockaddr_in *from;
{
  struct in_addr temp;
  struct ip *ip;
  struct icmp *icp;
  int hlen;

#ifndef __OSF1__
  from->sin_addr.s_addr = ntohl(from->sin_addr.s_addr);
#endif /* !OSF1 */

  temp = from->sin_addr;

  ip = (struct ip *) packet;  /* Get a pointer to the ip packet */

#if defined(__LINUX__) || defined(__SOLARIS__) || defined(__SUNOS__) || defined(__FreeBSD__)
  hlen = ip->ip_hl << 2;  /* get header length */
#else
  hlen = (ip->ip_vhl & 0xf) << 2;  /* get header length */
#endif

  debug("  %d byte packet from %s\n", packetlen, inet_ntoa(temp));

  if (packetlen < hlen + ICMP_MINLEN) {
    debug("  packet too short (%d bytes) from %s\n", packetlen, inet_ntoa(temp));
    return(-1);
  }
  packetlen -= hlen;
  icp = (struct icmp *) (packet + hlen);
  debug("  icmp_type=%d icmp_ident=%d icmp_seq=%d icmp_code=%d\n", 
    icp->icmp_type, icp->icmp_id, icp->icmp_seq, icp->icmp_code);
  if (icp->icmp_type == ICMP_ECHO )  {
    /* no need to parse ping requests... */
    debug("  was a echo request\n");
    return(-1);
  }
  if (icp->icmp_type != ICMP_ECHOREPLY)  {
#ifdef __DUMP_PACKETS__
    int  i, *lp;
    fprintf(stderr,"%d bytes from %s: ", packetlen,
         inet_ntoa(ntohl(from->sin_addr.s_addr)));
    fprintf(stderr,"icmp_type=%d (%s)\n",
        icp->icmp_type, pr_type(icp->icmp_type));
    for(i = 0; i < 12; i++)
        fprintf(stderr,"x%2.2x: x%8.8x\n",
      i*sizeof(long), *lp++);
    fprintf(stderr,"icmp_type=%d icmp_code=%d icmp_id=%d icmp_seq=%d\n",
        icp->icmp_type,icp->icmp_code,icp->icmp_id,icp->icmp_seq);
#endif
    debug("  was a weird ICMP packet! icmp_type=%d\n", icp->icmp_type);
    return(0);
  }
  if(icp->icmp_id != icmp_ident) {
    debug("  was not our echo response: icmp_ident=%d\n", icp->icmp_id);
    return(-1);
  }
  debug("  was our echo response: icmp_ident=%d\n", icp->icmp_id);
  return(icp->icmp_seq);
}

/*------------------------------------------------------------------*/

int
calc_latency(idx)
int idx;
{
  struct timeval now;
  int e_secs, e_usecs, rtt, ave_rtt;

  gettimeofday(&now,0);
  e_secs = now.tv_sec - ping_list[idx]->n_ping_start_time.tv_sec;
  e_usecs = now.tv_usec - ping_list[idx]->n_ping_start_time.tv_usec;
  rtt = e_secs*1000*1000;
  rtt += e_usecs;
  rtt /= 1000;
  return rtt;

}

/*------------------------------------------------------------------*/

receive_pings() 
{
  struct sockaddr_in from_sock;
  int from_len, byte_count, idx, l;
  char *packet_buffer;

  if ( (packet_buffer = (u_char *)malloc((unsigned)packet_size)) == NULL ) {
    fprintf(stderr,
      "fatal error: malloc failed while creating buffer for receiving pings\n");
    exit(1);
  }
  memset(packet_buffer, 0, packet_size);

  while(1) {
    from_len = sizeof(from_sock);
#if 0
usleep(3000);  // for testing w/ localhost which responds in < 0 ms
#endif
    if ((byte_count = recvfrom(pingd_socket, packet_buffer, packet_size, 
                        0, (struct sockaddr *)&from_sock, &from_len)) < 0) {
      if (errno == EINTR) { continue; }
      debug("  recvfrom() failed: ");
      if ( debuggin ) { perror(""); }
    }
    debug("receive_pings() got %d bytes\n", byte_count);

    /* packets are sent out with their seq num equal to     */
    /* to an index into the ping_list array so we can map   */
    /* echo response seqs onto ping_list nodes here...      */
    idx = parse_icmp_seq(packet_buffer,byte_count,&from_sock);

    if (( idx > -1) && ( idx < ping_list_size )) {
      ping_list[idx]->n_state = DONE_PINGING;
      l = calc_latency(idx);
      ping_list[idx]->n_latency = l;
      if ( ping_list[idx]->n_latency_ave == NO_VALUE_SET ) {
        ping_list[idx]->n_latency_ave = l;
      } else {
        ping_list[idx]->n_latency_ave = 
          EXP_DECAY * ping_list[idx]->n_latency_ave + l * (1.0 - EXP_DECAY);
      }
      ping_list[idx]->n_latency_data[ping_list[idx]->n_next_data_point] = l;
      ping_list[idx]->n_next_data_point++;
      if ( ping_list[idx]->n_next_data_point > (NUM_DATA_POINTS - 1) ) {
        ping_list[idx]->n_next_data_point = 0;
      }
      debug("  node %d is up: addr=%s name=%s latency=%d ms ave=%d ms\n",
        idx, ping_list[idx]->n_addr, ping_list[idx]->n_name,
        ping_list[idx]->n_latency, ping_list[idx]->n_latency_ave);
#ifdef __DEBUG_DATA_POINTS__
      /* assumes NUM_DATA_POINTS == 20... can't use loop here because */
      /* because it will get interrupted causing disjointed output... */
      if ( debuggin) { fprintf(stderr,"node %d data...\n  %d %d %d %d %d %d %d %d %d %d\n  %d %d %d %d %d %d %d %d %d %d (next=%d)\n", 
        idx,
        ping_list[idx]->n_latency_data[0], ping_list[idx]->n_latency_data[1],
        ping_list[idx]->n_latency_data[2], ping_list[idx]->n_latency_data[3],
        ping_list[idx]->n_latency_data[4], ping_list[idx]->n_latency_data[5],
        ping_list[idx]->n_latency_data[6], ping_list[idx]->n_latency_data[7],
        ping_list[idx]->n_latency_data[8], ping_list[idx]->n_latency_data[9],
        ping_list[idx]->n_latency_data[10], ping_list[idx]->n_latency_data[11],
        ping_list[idx]->n_latency_data[12], ping_list[idx]->n_latency_data[13],
        ping_list[idx]->n_latency_data[14], ping_list[idx]->n_latency_data[15],
        ping_list[idx]->n_latency_data[16], ping_list[idx]->n_latency_data[17],
        ping_list[idx]->n_latency_data[18], ping_list[idx]->n_latency_data[19],
        ping_list[idx]->n_next_data_point);
        fflush(stderr);
      }
#endif
    }
  }
}

