/* 
 *  $Id: read_list.c,v 1.23 2005/08/05 20:10:43 rader Exp $
 */

#include <stdio.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <errno.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#ifdef __FreeBSD__
#include <stdlib.h> 
#else
#include <malloc.h>
#endif
#include "pingd.h"

char pinglist_file[MAX_PATH_LENGTH];
struct ping_list_entry *ping_list[MAX_NODES];
int ping_list_size = 0;

/*------------------------------------------------------------------*/

read_ping_list() 
{
  struct stat buf;
  FILE *fp;
  int i, j, line_num;
  char buffer[MAX_CHARS_PER_LINE];
  char *str_match;
  time_t now;

  sprintf(pinglist_file, "%s/%s", PREFIX, PING_LIST_FILE);
  debug("read_ping_list() from %s\n", pinglist_file);
  if ((fp = fopen(pinglist_file, "r+")) == NULL) {
    fprintf(stderr,"fopen %s ",pinglist_file);
    perror("failed");
    exit(1);
  }
  for ( i = 0, line_num = 1; 
        fgets(buffer, sizeof(buffer), fp) != NULL && i < MAX_NODES; 
        line_num++ ) {

    /* comments */
    if ( buffer[0] == '#' || buffer[0] == '\n' ) { continue; }  

    debug("  processing line %d\n", line_num);
  
    /* new node */
    ping_list[i] = malloc(sizeof(struct ping_list_entry)); 

    /* addr */
    if ( (str_match = (char *)strtok(buffer," \t\n")) == NULL ) {
      debug("  couldn't read addr from line %d\n",line_num);
      fprintf(stderr,"warning: ignoring %s line %d: can't parse address\n",
        pinglist_file,line_num);
      continue;
    }
    ping_list[i]->n_addr = malloc(strlen(str_match)+1);
    strcpy(ping_list[i]->n_addr,str_match);

    /* name */
    if ( (str_match = (char *)strtok(NULL," \t\n")) == NULL ) {
      debug("  couldn't read name from line %d\n",line_num);
    }
    ping_list[i]->n_name = malloc(strlen(str_match)+1);
    strcpy(ping_list[i]->n_name,str_match);

    /* use ping_list index as packet sequence so that we  */
    /* can map echo response back to the ping_list...     */
    create_icmp_header(
      ping_list[i]->n_addr,&ping_list[i]->n_header,&ping_list[i]->n_sock,i);

    /* next ping */
    ping_list[i]->n_next_ping = time(&now);

    /* state */
    ping_list[i]->n_state = NOT_PINGING;
    
    /* data */
    ping_list[i]->n_latency = NO_VALUE_SET;
    ping_list[i]->n_latency_ave = NO_VALUE_SET;
    for(j=0; j < NUM_DATA_POINTS; j++) {
       ping_list[i]->n_latency_data[j] = NO_VALUE_SET;
    }
    ping_list[i]->n_next_data_point = 0;

    /* details */
    debug("  added node %d: addr=%s name=%s next=%ld\n", i,
      ping_list[i]->n_addr, ping_list[i]->n_name, ping_list[i]->n_next_ping);
    i++;
  }
  (void)fclose(fp);
  ping_list_size = i;
}

