/* 
 *  $Id: pingd.c,v 1.29 2005/08/05 20:10:43 rader Exp $
 */

#include <stdio.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <errno.h>
#ifdef __FreeBSD__
#include <stdlib.h> 
#else
#include <malloc.h>
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include "pingd.h"

int debuggin = DEBUG;
int verbosin = VERBOSE;
int force_pid_file = 0;
int polling_interval = POLLING_INTERVAL;
int packet_size = PACKET_SIZE;
int interpacket_delay = INTERPACKET_DELAY;
char pid_file[MAX_PATH_LENGTH];

extern struct ping_list_entry *ping_list[];

/*------------------------------------------------------------------*/

main(argc,argv)
int argc;
char *argv[];
{
  process_args(argc,argv);
  write_pid_file();
  create_ping_socket();
  malloc_ping_packet();
  set_icmp_identifer();
  read_ping_list();
  send_pings();
  receive_pings(); 
}

/*------------------------------------------------------------------*/

process_args(argc,argv)
int argc;
char *argv[];
{
  int flag;
  extern char *optarg;
  extern int optind;
  while ( (flag = getopt(argc, argv, "hdvp:s:w:f")) != EOF ) {
    switch(flag) {
      case 'h':
        usage();
        exit(1);
      case 'd':
        debuggin = 1;
        break;
      case 'v':
        verbosin = 1;
        break;
      case 'p':
        polling_interval = atoi(optarg) / NUM_DATA_POINTS;
	if ( polling_interval < 1 ) {
          fprintf(stderr,"error: polling_interval must be at least %d\n",NUM_DATA_POINTS);
          usage();
          exit(1);
        }
        break;
      case 's':
        packet_size = atoi(optarg);
        break;
      case 'w':
        interpacket_delay = atoi(optarg);
        break;
      case 'f':
        force_pid_file = 1;
        break;
      default:
        usage();
        exit(1);
     }
  }
  if ( optind < argc ) {
    usage();
    exit(1);
  }
  debug("packet_size is %d bytes\n", packet_size);
  debug("polling_interval is %d seconds\n", polling_interval);
  debug("interpacket_delay is %d ms\n", interpacket_delay);
}

/*------------------------------------------------------------------*/

usage()
{
  printf("usage: nrg-pingd [args]\n");
  printf("  -p num   set polling interval to num (default %d secs)\n", polling_interval * NUM_DATA_POINTS);
  printf("  -s num   send ping packets that are num bytes in size (default %d bytes)\n", packet_size);
  printf("  -w num   wait num milliseconds between sending packets (default %d ms)\n", interpacket_delay);
  printf("  -f       force writing of pid file (use for at-boot execution)\n");
  printf("  -v       verbose mode (start times, failures and end times) \n");
  printf("  -d       debug mode (gory details)\n");
}

/*------------------------------------------------------------------*/

debug(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)
char *a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n,*o;
{
  if ( debuggin ) {
    fprintf(stderr,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
    fflush(stderr);
  }
}

/*------------------------------------------------------------------*/

verbose(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)
char *a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n,*o;
{
  char time_str[27];
  time_t now_t = time(&now_t);
  int len;
  if ( verbosin && ! debuggin ) {
    strcpy(time_str,(char *)ctime(&now_t));
    len = strlen(time_str);
    time_str[len - 6] = '\0';
    fprintf(stderr,"%s ",time_str);
    fprintf(stderr,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
    fflush(stderr);
  }
}

/*------------------------------------------------------------------*/

debug_ctime(t)
time_t t;
{
  char time_str[27];
  int len;
  if ( debuggin ) {
    strcpy(time_str,(char *)ctime(&t));
    len = strlen(time_str);
    time_str[len - 6] = '\0';
    fprintf(stderr,"%s",time_str);
    fflush(stderr);
  }
}

/*------------------------------------------------------------------*/

dump_list_entry(i)
int i;
{
  fprintf(stderr,"list entry %d...\n",i);
  fprintf(stderr,"  n_addr is      \"%s\"\n",ping_list[i]->n_addr);
  fprintf(stderr,"  n_name is      \"%s\"\n",ping_list[i]->n_name);
  fprintf(stderr,"  n_next_ping is \"%lu\"\n",ping_list[i]->n_next_ping);
  fflush(stderr);
}

/*------------------------------------------------------------------*/

write_pid_file()
{
  struct stat buf;
  FILE *fp;
  char old_pid[10];
  sprintf(pid_file, "%s/%s", PREFIX, PINGD_PID_FILE);
  if (stat(pid_file, &buf) < 0) {
    if (errno == ENOENT) {
      if ((fp = fopen(pid_file, "a+")) == NULL) {
        fprintf(stderr,"fopen %s ",pid_file);
        perror("failed");
        exit(1);
      }
      debug("writing pid %d to %s\n", getpid(), pid_file);
      fprintf(fp, "%d\n", getpid());
      fclose(fp);
    } else {
      fprintf(stderr,"stat %s ",pid_file);
      perror("failed");
      exit(1);
    }
  } else {
    debug("checking %s\n", pid_file);
    if ((fp = fopen(pid_file, "r+")) == NULL) {
      fprintf(stderr,"fopen %s ",pid_file);
      perror("failed");
      exit(1);
    }
    (void)fgets(old_pid, 10, fp);
    debug("looking for running nrg-pingd (pid is %d)\n", atol(old_pid));
    if (kill((pid_t) atol(old_pid), 0) < 0) {
      if (errno == ESRCH) {
        (void)rewind(fp);
        debug("writing pid %d to %s\n", getpid(), pid_file);
        fprintf(fp, "%d\n", getpid());
        (void)fclose(fp);
      } 
    } else {
      debug("found a running pingd\n");
      if ( force_pid_file ) {
        (void)rewind(fp);
        debug("writing pid %d to %s\n", getpid(), pid_file);
        fprintf(fp, "%d\n", getpid());
        (void)fclose(fp);
      } else {
        fprintf(stderr, "pingd is running (pid is %d)\n", atoi(old_pid));
        exit(1);
      }
    }
  }
}

