const React = require('react');

const {
  render
} = require('ink');

const importJSX = require('import-jsx');
/* istanbul ignore next */


const reporter = {
  report(tap, Type = 'base') {
    // NB: React will only render as a tag if it's capitalized
    if (typeof Type === 'function' && Type.prototype.isReactComponent) return render( /*#__PURE__*/React.createElement(Type, {
      tap: tap
    }));
    if (typeof Type !== 'string' || !types.includes(Type)) throw new Error('unsupported report type: ' + Type);
    const Report = importJSX('./reports/' + Type);
    render( /*#__PURE__*/React.createElement(Report, {
      tap: tap
    }));
  }

};
/* istanbul ignore next */

module.exports = (...args) => reporter.report(...args);

const types = module.exports.types = require('../types.js');

const cap = s => s.replace(/^./, $0 => $0.toUpperCase());

types.forEach(type => Object.defineProperty(module.exports, cap(type), {
  get: () => importJSX(`./reports/${type}`),
  enumerable: true
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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