const React = require('react');

const {
  Box,
  Color
} = require('ink');

const prettyDiff = require('../../pretty-diff.js');

const prettySource = require('../../pretty-source.js');

const yaml = require('tap-yaml');

const importJSX = require('import-jsx');

const PassFail = importJSX('./pass-fail.js');
const AssertName = importJSX('./assert-name.js');

module.exports = ({
  res
}) => {
  const {
    ok,
    id,
    name,
    testName,
    skip,
    todo
  } = res;
  const diag = res.diag || {};
  const diff = prettyDiff(diag && diag.diff);

  if (diff) {
    delete diag.diff;
    delete diag.found;
    delete diag.wanted;
    delete diag.pattern;
    delete diag.compare;
  }

  const source = prettySource(diag);
  if (source) delete diag.source; // pretty-print errors found in t.error() assertions

  const origin = diag && diag.found && diag.origin;
  const originSrc = prettySource(origin);

  if (originSrc) {
    origin.message = diag.found.message;
    delete diag.origin;
    delete diag.found;
    delete origin.source;
  }

  delete diag.didNotWant;
  const filtered = /^filter: (only|\/.*\/)$/.test(res.skip);
  return filtered ? '' : /*#__PURE__*/React.createElement(Box, {
    flexDirection: "column"
  }, /*#__PURE__*/React.createElement(PassFail, {
    ok: ok,
    name: testName,
    skip: skip,
    todo: todo
  }), /*#__PURE__*/React.createElement(AssertName, {
    ok,
    name,
    skip,
    todo
  }), ' ', source ? /*#__PURE__*/React.createElement(Box, null, source) : '', diff ? /*#__PURE__*/React.createElement(Box, null, diff + '\n') : '', diag && Object.keys(diag).length ? /*#__PURE__*/React.createElement(Box, null, `  ${yaml.stringify({
    test: res.fullname,
    ...diag
  }).split('\n').join('\n  ')}`) : '', originSrc ? /*#__PURE__*/React.createElement(Box, {
    flexDirection: "column"
  }, /*#__PURE__*/React.createElement(Box, {
    marginLeft: 2
  }, "Error Origin:", '\n'), /*#__PURE__*/React.createElement(Box, null, originSrc), /*#__PURE__*/React.createElement(Box, {
    marginLeft: 2
  }, yaml.stringify(origin))) : '');
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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