#include <locale.h>
#include <notcurses/notcurses.h>

int main(void){
  struct notcurses_options nops = {
    .flags = NCOPTION_NO_ALTERNATE_SCREEN
              | NCOPTION_SUPPRESS_BANNERS
              | NCOPTION_DRAIN_INPUT,
  };
  struct notcurses* nc = notcurses_core_init(&nops, NULL);
  if(nc == NULL){
    return EXIT_FAILURE;
  }
  struct ncplane* n = notcurses_stdplane(nc);
  const int y = 10;
  ncplane_set_scrolling(n, true);
  ncplane_putstr_aligned(n, y + 0, NCALIGN_CENTER, "Pack my box with five dozen liquor jugs\n");
  ncplane_putstr_aligned(n, y + 1, NCALIGN_CENTER, "sɓnɾ ɹonbıl uǝzop ǝʌıɟ ɥʇıʍ xoq ʎɯ ʞɔɐԀ\n");
  ncplane_putstr_aligned(n, y + 2, NCALIGN_CENTER, "ꙅǫuꞁ ɿoupi| ᴎɘƹob ɘviᎸ ʜƚiw xod ʏm ʞɔɒꟼ\n");
  ncplane_putstr_aligned(n, y + 3, NCALIGN_CENTER, "P̸̯̼͙̻̲͚̜͚͈̩̎͠a̶̯̳̱̟͚͇̩̯̬͂̒̒̌̅͊̽̿͗̈́͘͝ͅć̸̮̦̩̭͓̫̟̹̆͂͒̓͆̈̅̀͐̿̚ͅk̶̡̻̜̼̙͍̥̗̯̠̜͓̪̽ ̷̮͚̺͎̗̂̈́̿̑͝m̴̩͍̺̟͓̼͓͇̟̙͂̏̈́͆̎́̐̐̽̕̚͘͜ͅy̵̧̻̗̦̯̱̬̤͈̦̺͗̓͛ ̵̣̤͕͙̟͛͌͑̉͘͝b̵̨̡̨̯̞̘͕̰̙̬̳͇̮͖̹͗o̶̻̫͑̎͑̽̈́̚̚̕ͅx̵̢̦̗̳̝̻̗̟̘̻̼͚̰̓̇̓͛̀ ̸͈̜͙́̍͂̅̃̿͘w̵̧̪̻̤̮̑͊͌̈́͋́̔͂̑̌͑͋̇͂ḯ̴̺͛̒̔̏́̅̓̾̔̊̆͗͠͝t̷̢̛̟͉͕̗̙̭̖͈̼̂̎́͌͜͝h̸̢̨̜̤̗͎̳̖͙̺̹̭̘̞̀̀̓̊̐̀͐̈́̀̿͆̔̄͝ͅ ̴̹̙̜̥͕͖͑́͛̈́̄̈́̿̕f̶̡̢̳̗͉̩͖̹͚̗̩̰͖̀̂͗͌̑i̴̧̝̰͎͕̣͓͓̋͒̇̀̾͐̃̚̕v̵̛̠̩̪̻̟͕̭͕̗̲̼̽͗͐̄̈́̾͂̍̔̎͌̌͘͝e̵̢̤͇̪̻͚̜͉̻͉̝͙͗̀̃̐͋̌̋̌̈́̅̈̌̉͘͜ ̶̡̢̭͙̤͑̑͂̐͛̑̍͑͌̀͛d̴̨̧͍̫͔͔̫̻̗̙͖̞̱͆̒͂̈̐͑̕̚͠͝ó̸̰̠̦̦̞̼̘͔̥͎͕̦̯̑̀̇̈́̎̄͘z̴̡̧̡̦̦̙̞̪̣̤͕̫̳̈̉͌̃͌͛̀͌̎̃̌͒͜͝ȩ̷̻͖̥̬̹̖̫͛͐̍̂̾̀͑͊̎̀̊̏̕ͅn̵̢̢̧͚̜͉̯̲͕̒͊̒͌͋͗̓́͂͝ ̵̡̧̨̛̛͓͚̘̺̲̺̻̻̫̾̄̒̑̄̄̏̇̍̽͜l̴̗̩͍̰̇i̴̡̭̳͉̘̩͚̽̏̿̈̔́̂̈́̊͝q̷̫͚̌̅̈́̓̐̎ů̶̢͈̪͔̅̓̀̓̓̈͆̍͋͋̉͝͠ǫ̵̻͠r̵̰̯̠̟̬͖̳͔̚ͅ ̶̡̣̭̥̻̭͙͎̰̜̥̜̊j̷̧̡̟̝̼̞̭͙͈̘̇̾̽͊̄̈̍͗͒͑͜u̷̡̪̤̖̣̰͈̽̀̚͜g̸̨̢̧̳̙̝̠̩̜̻͙̘̪̞̈́͐̈́̇̆̎̈ͅs̶̫͑͂̂͛̋̇̅̒͝.̴͈̖̮̪̮͓̹̈̐̇̓̇͝\n");
  ncplane_putstr_aligned(n, y + 4, NCALIGN_CENTER, "Ⓟⓐⓒⓚ ⓜⓨ ⓑⓞⓧ ⓦⓘⓣⓗ ⓕⓘⓥⓔ ⓓⓞⓩⓔⓝ ⓛⓘⓠⓤⓞⓡ ⓙⓤⓖⓢ\n");
  ncplane_putstr_aligned(n, y + 5, NCALIGN_CENTER, "φąçҟ ʍվ ҍօ× աìէհ ƒìѵҽ ժօՀҽղ Ӏìզմօɾ ʝմցʂ\n");
  ncplane_putstr_aligned(n, y + 6, NCALIGN_CENTER, "P⃞a⃞c⃞k⃞m⃞y⃞b⃞o⃞x⃞w⃞i⃞t⃞h⃞f⃞i⃞v⃞e⃞d⃞o⃞z⃞e⃞n⃞l⃞i⃞q⃞u⃞o⃞r⃞j⃞u⃞g⃞s⃞.⃞\n");
  ncplane_putstr_aligned(n, y + 7, NCALIGN_CENTER, "P⃣a⃣c⃣k⃣m⃣y⃣b⃣o⃣x⃣w⃣i⃣t⃣h⃣f⃣i⃣v⃣e⃣d⃣o⃣z⃣e⃣n⃣l⃣i⃣q⃣u⃣o⃣r⃣j⃣u⃣g⃣s⃣.⃣\n");
  ncplane_putstr_aligned(n, y + 8, NCALIGN_CENTER, "ᴘᴀᴄᴋ ᴍʏ ʙᴏx ᴡɪᴛʜ ꜰɪᴠᴇ ᴅᴏᴢᴇɴ ʟɪQᴜᴏʀ ᴊᴜɢꜱ\n");
  ncplane_putstr_aligned(n, y + 9, NCALIGN_CENTER, "🅝🅔🅖🅐🅣🅘🅥🅔 🅒🅘🅡🅒🅛🅔🅢 🅐🅡🅔 🅐🅛🅢🅞 🅐🅥🅐🅘🅛🅐🅑🅛🅔 \n");
  ncplane_putstr_aligned(n, y + 10, NCALIGN_CENTER, "🄴 🅂 🄲 🄷 🄴 🅆  🄲 🄸 🅁 🄲 🄻 🄴 🅂  🄶 🄴 🅃  🅂 🅀 🅄 🄰 🅁 🄴 🅂 \n");
  ncplane_putstr_aligned(n, y + 11, NCALIGN_CENTER, "🅰 🅱🅴🅰🆄🆃🅸🅵🆄🅻 🆄🆂🅴 🅾🅵 🅽🅴🅶🅰🆃🅸🆅🅴 🆂🆀🆄🅰🆁🅴🆂\n");
  ncplane_putstr_aligned(n, y + 14, NCALIGN_CENTER, "į̵̢̡̢̨̨̛͈̤͇̭͈̣̗̮̫̫̰̤̳̘̞̥̟͙̞̥͉̳̜̫̣̯̗̠͖̲̪̘̟͉͖̜͔̪͈̜̼̩̥̗͔̭͔̠̺̫̺̦͇̐͛̉̃͒̿̒͆̅̐̆͆͌͋̎̈́̓̔̓͌̌̀̽̾̈́̄̈́̇̒̀͆͆͌̄́̎̋̑̀͊̐̆̚̚̚̚͜͜͜͝͠͠͝ͅͅn̵̡̢̧̧̧̢̢̛̛̙̩͈̦̠̳̜͖̤͍̻̹̼̯̦̦̰͕͈͈̖̬̣̦͓̳̣̮͙͓̣͖̲͉̭̞̤̞͙̝̝͔͓̗͓̣͙͕̲̩̠̬̑̊̈̐͛͒̎̐͒̓̆̌͊̅̿̂͛̈́̈́́̉̽̔̓̔̎̈̿͒̃̊̾̏̇̈́̋́͆̐̈́͛̔̓̄̀͋̊̃͛͑̋͂̔̈̐͐͐̆̇͌̓́́̿́̍̈́̈́̈́͋̄͆̈͛͂̇͗̅̓̀̈́̂͂̆̃̈́̈́̓̓̐̔̌̍̋͐̚̕̚͘͘͘͘̚̚͘͘͜͝͝͝͝͠͝e̶̡̨̨̧̨̨̨̧̦͇̖͔̫̹̺̺̯͈̺̫̗͈̲͕̮͈͓̭̱͔͈͚̬̰̜͇̼̙̰̣͎͕̠̥̯̖̣̬̗͎̓͑͌̊̇͆͐͑̂̎͋̑͐̀̅̂͌̽̉̊̀͌̓̈́̀͛̐́̋̈͑͆̐̑̉̐̍́̈́̅̿͒̕̕̚͜͜͝͝͠ļ̷̢̨̢̢̡̡̣͕͈̩͔̻̬̻͙͙̩̲͇͈̥͎̖̻͖̮̪̞̠̹͍̙͖̳̱͓̘͖̱̱͕̯̰͙̝̣͕̭̮̿̑͘͜͜͜ự̴̡̡̨̨̢̨̨̤͈̝̟̣̠͖̗͙̗̖̦̯͍̘̟͎̝͔͙̗͎̟̺̣͖̝̩̜̜̖̳̹͍̦̩͔̜̘̲͈̮̠͚̭̭̜͉̘̫̰̺̫͖̗̦̮͓̗̻̖͍̥̤͎͖̣̻̝͚͙̤̥͎̖̯͙̯̫̘̜̘̤̠̯͖͉͍̎̈͐̄̊̈̊̌͑̎͂͒͌́̃͐̐̉͗̽̀͂̃̒͋̂̀̊̉́̃̄̄̍̆́̑͑̇̇̾́̊̂͊̐͑̾̀͊̒̓́̂̐̄͋̀̈́̅̏̒̎̊̒͂͐̑͐̉́̄̂̀̕̕͘̕̕͘̕̕̕͜͜͝͝͝͝͝͝͠͝ć̵̡̨̨̢̢̛̛͔̩̦͓̥̠̜̳̯̮̩̜̖͖̘̜̖͖̖̳̹̲̻̯̬̪̰̭͇̮͉̳͉̬̬͇͉̟̲̞̱̯̖̗̞͚͎͓͔͍͈̲͇̳͈̦̠͚̲͎̦͙̰̲̬̝̞̟̪͈̘̖̦̩̝̩͕͈̦̯͙̞̖̥̺̝̗̔͊̂̈́́̿̾̾͛̈͐̔̉̈͐̈́̈̉͑̃̂͋́̆̓̒̈̈̉͛̏̅͌͌̆̓́͊̂̾̈̚͘͘͜͜͜͝͠͝͠͠͠͝͠ͅͅͅt̶̡̡̧̛̛̮̘̹̼̺̹͓̠͖̳̺̹̘̥͙͇̪̩͇̖̦̾͐̍̇͊̅̅̇̀̂̏̀̆̑͗̑͆͊̾̎͗̋̊̇̒͛̀̇͂̒͆̀̊̽̑̀̐̅̔̅̀̋͆͐̋́͆̒̓̐͐́͂̐̋̇̿̑͆̅͑͐́̄́̈́̌̈́͋̄̎͌̈́̅̍̎̓̑̕̚͘̚̚͜͠͠͝͝͠͝ͅą̵̧̛̛͎͕̯̪͚̫̟̺͚̱͎͚̹̟̖̦̼͍̦͙̹̹̰̫̤̯͚̠̼͉̭̳̓͗̈́̎̀̇͌͌͌̐̌̀̾̀̈̍̾̓̀͌͑̔̆̋̇̇̈́̔̌̈́̐͒͌̒̐̋̅̀̉͆̒̓̀͌̒̒͋̐̀̒̇̉̅̏̾̕͘̕͝͝͠͝ͅͅb̷̧̧̡̢̨̧̡̡̛̛̛͈̩̰͖̰̹̯̪͍̯͉͙̺̬̝̟̥̜͙̙͕͇̗̪̬̣̙͕̙̙͉͔̦̦̼̜̳̤̺͕͇̠̲̘̼̲̦̺̝̪̲̣̠̪̮͉̮͙̥̤̫̫͉͍̤͍͙̺̩̫̜͚̞̫̺͍̺̣͍̥̠͓̯̳̳̖̟͉̄̏͛̆͊͆͆̆̐̀̏̎̊͆̾͋̇͑̓̒͑̂͛́͊͗̇̔̾͆͂̒̃͋͊̊̆̀̈̊̌͗̈̿̄̀́̌̌̑͐͂̈́̇͛̒̏̒̋̅̆̈̽̽̅̐͊͆̿̐̌̈̂̓͌̀̋͛͛̎͒͒͋̏̐̀̒̇̀̐́̕͘̕͜͜͜͜͜͝͝͝͠͠͝͠͝ͅl̴̨̨̢̨̨̢̧̨̧̨͍͕̟̲͙̺̯̹̺̟̼̜͍̙̣̼̬̺͕͚̤̙͍͓̳̘͍̠̙͍͎̝̮͍̤̰̩̯̦̠̦̻̣̜͎͉͓͎̦̝̖̲͚̦͓̭̩͉͖̘̟̪͔͎̪̰͓͔̟̬͂̌̈̉͋͘ͅͅͅê̸̡̨̧̧̧̡̧̧̨̧̛̛̝͕̪̲̟̣͍̹̻̠̥̟̯͔̻̗̙̳̺͍̗̬̥̼͕͖͈͔̝̩͙͔̜̩̫͕̠͇͔͍̥͚͕͉̬̩̫̟͉̝̭̖̳̳̰̘͙͓̙͍̙̞̣̖̝̦̰̰̺̰̺̖̦̝͈̲͈̗̬̦̺̹͎̯̭̟̺̯̠̬̮̝̰͙̗͎͈͔̮̲̯̩̪͈͙̲̪̱̦̩̘̲̈̋̒̉̑̈́̍̀̄̇̓́̓̾̌̒̏͌͒̂͆̆̈́́͐̾̈́͌̍͌̉̐̐̑̇̽̑̋̆͗̑̆̌͂͛̑́̒̅̌̌̀͗͂̅̎̋̈́̅͑̌̄̃̾̎͌͒͑͊̍̂̾͋̉̒̋̃̒̑̈͋̊̒͆̏̎̊̃̕̚̚̕͘̕͘͘̚͜͜͠͠͝͝͝͝͝͝͠͠͝ͅͅͅͅͅ ̷̧̡̢̡̧̢̧̧̡̨̖̤̺̤̮̗̭̬̰̰̟̳͚̱̩͍̱̰̩̠̮͕͓̣̺̳͈͔̟̳̣͈̱̰̬̞̖̦͔̼̹̥͖͈͚̩̼͖̬̞̩͎͇̞̬̯̟͕̞̗͖̘̙͖̞͓̜̭͖̹̱̙̖͔̭̲̻̘͚͇͍̱̹͇̱̬̘̲͕̝̗̳̰͖̮̞͉̗̝͖̥̹̣̣̬̠̘̦͚̫̜̻̱̌̀͂̃̑̓̄̈́͐̌͒̐́͑̂̇͋͗́́͗̍͊̐͑̾͂̍̈́̏̈́́̑̌̓̎̈́̐̑͗̊̇̈́͂̚͘̚͜͜͝͝͝͝͝͝ͅͅͅm̷̢̡̛̛͚̹̻̮̘̤̩̬͙͎̈́̿̂̍͂̽̀͒͌́̃͑̓̿̉̀͑̈̓͒͘̕͝͝͝͠ͅǫ̶̢̢̢̨̼͇̗͕͖͚̤̤̰̰̯̜͕͍̠̳̰͕̣͍̱̞̮̠̳̤̭̰̫͖̘͉̠̝̹̩̳̳̱͔͍̲̪̱͔̫̠͑́͋́́̓̀͋̈́̍̉̅̾́͘͘͜͜͠ḑ̸̢̨̡̛̛͍̞͉̝̖͓̝̳̝̲͈̗̼͖̤̯͈̮̮͇̹̲̰̟͎̼̏͂́̃̈̀̾̅̊̍̒͛̓̒̆̀͐͗̍̆͛͊̂͗̃́̓͑̃̇͒͌͛̆̋̈́̑̕͝ͅą̸̛̛̗̠̙̳̣̯͇̙̯̰̊͒̆̔͛͌̄̓̒͐̑̏̃̊̏͌͊͑̒̂̂͂̈́̐̎̂̀͒̓̅̈́͊́́̒̾̑̒̒̉͛́̃̔̈̀̍͋͑̓͆̂̿̽̏́͑͂̀̍̀̓̒͛̊̋̈̑̎̅̀̉̑̈́͑̓̐͑̾̃̒͊̉̒̓̌̀͑̍͑̾͊̿͌̔̏͗͗̈́͘͘͘̚̕͘̕͘̕͘͠͠͝ͅĺ̴̨̨̡̧̡̧̨̧̡̡̢̡͖͔̗̮͓̼̗͈͔̳̬̞̺͙̩̣̩̥͎̙̭̯̖̪̫͎͇̪̯̬̠͓͖̣͇͍̮̮͈̟̫͚͉̻͈̖̗̠̙̝͙̠̰͚̱̲̤̺̪̭̫̱̫̠̞͓̹̮̖̘̣̓̿́̌͂̀̇͐̈́̾̀̂̍͆͛͗͊̈́̀̈́͑̎͋̒͒̕̚̕̚̕͜͠͠͠ͅͅi̴̧̨̢̝͎͇̠̭̟͇̭͙͚̳̭̘͈̟͓͈̥̭͚͈͍̲̲͔̤͉͈̎̈͂͆̀͛͋͊̏͊͗͋̓̐̉̆̒̈́͊̏̈͋́̓̿̾͛̒̓̅͛̚̕͜͜͝͠͝ͅͅṯ̶̡̛̪͚̮̩̤̗͇̗͍̩̬̲͔͙̼̯͉͓̃̐̽̐̌͂̑͊͊͝y̷̨̡̧̢̧̧̧̧̡̡̨̧͈̫͉̟̠̘̜̟̜̻̭̜̦̻̺̮͖̫̺͙̰̟̥̱̝̤̘͙̳̜͔̼̹̹͉̳̰̻̳̩̻̺̫͈̼̘͉͓͎̙͔̣̥̪̺͎̙̹͕͇̖̤̗͙͈͉̭̦̺͈̞̼̗̜̯̞̠̬̱̼͈͇̖̬͕͕̬̮͖̤̜͔͙̻̤͈͓̣̖͓̘̘̬̳̻̜̲̳̏̄̂̈́̒̃̎̇̏͆͊̓̎́̓͛̄͆̃͆̈́́͊̋̈́̾̈͒̍͊̔̆̉̏͐̿͆̂̊̀̌̀̽̆̋̓́͆̓̈́̚͘͜͜͜͝ͅͅͅͅͅ ̴̢̧̧̨̢̨̡̡̨̢̨̛̛̛̥͓̬͍̭̫̬̬̱̩͇̱̗͚̲̘͉̘͇͓̮͇̹̱̠͖̦͈̟̮̬̦̝͚͙̝̠͖̞̖̱̥̜̯̼͓̫̹͖̘͓̣͎̱̘̰̦̺̪͙̜͓̼͚̺̖̞̻͈͚̲͙̗͈̱̯̘͈̟̞̞͈̬̤̦̹̹̿̐̅́͛̒͐͋́̓̊̊̋̊͐̈́̇̍͒̑̎̿̀͑̉͒̾̀̈̈́̂̐͋͑͗̓͒̑̔̌̏͒̑̓͒̏͌̀͌̋̂̇̓̈͗̓͛̉͑͗͒̾̐͊̏̈́̅́̈̾͋̐͂̽̈̏̐̀̆̃͗̓̚̕̕̕̚̚͝͝͝͝ͅǫ̵̢̡̨̡̨̡̨̤̤̖͕̠̥̰̠̩̙̰̮̜̘̪̭̭̯̺̭͚͙̞̜̪̰͚̘̭̻͓͈̺͉̯͔͖̯̠̭̰̫̲͈̦̖͖̪̣̰͖͎̙͚̙̹̰̬̜̲̱̘̘̪̭̣̻̫͓̼̦̦̘̩̥̱̣̺̌̇͒̊̃̐̾̍̈́̅̉̊͐͒̀͆̉̀̇͊̕̕͜͜͝ͅͅͅͅͅͅͅf̷̨̨̧̨̢̢̨̧̛̮̖̝͎̻̟̦̗͕͍̻̫̤̰̣̜̮͙̱̝̮͈̫̯̣̻̪͚̘͍͈̝̱̞͚͔̣̗̱̳̰̣̦̘̦̮̞̬̗͈̘̤̦̞̞̱̠̹̖̣̰̦̦͍̙̫̲̮̲͇̼̗͓̹̹͓̬̩͍̦͍̆͊̀̆͂͑̾̔̎̎̿͂̀̐̈́̈̇͒̔̋̇̒͆̏̋͋͒͊̏̉̏̎͛̋̔͐̈̈́̿͋̽̀̈́͗͒̑̽͋̏̅̌̇̓͑̅̿͐̂͆͆̃̈̈́̌̈́̆̌̋̎̀̾͆͂̿̃̃̐͒͌̃́̑̐̽́̐̔̔̅̄͘̚̚͘̚͘̚͘͜͜͝͝͝͠͠͝͝͠͠ ̷̡̡̨̨̧̛̛̱̼̜͙̜͔̠̹̺̞̰̞̟̘͚̣̮̼̞̙̘̱͔̖̬͈͖͇̳̪͚̩̰̠̦͖̫͖͈̗͍̩̤̂̆̂͂̓̾̑̉́̏͊́̉͗͌͆̒̑̅̓̅̑͛͐̌̅͑̍̋͛͒̆͆̐̇̒̌́͐̔̐͂̽̋̋̐̾̆̆̀̋̈́̆̔̀̎͐̄̌̀̈͑̂͛̈́͐̈́͋̽͊͑̔̀͛͑͑̐̎͋̾̓͗̍͋̏̈́͛̂͒̉̅̊̂̆͂́̅͑̾͆̈́̇̆̑͋̐̋̚̚̚̚͘͘̚̚̕͘͠͝͝͝͝͝͝͝͝͝ͅt̸̨̛̛̛̛̙͕̪̬̣͚̩͕̺̯̹͂̿̃̊̔̇̄̌̉̒̆͐̈́̌͐̓̿͊͊͆̈́̄̌͂̓̅̐̓̐͒̍̽̓͊̄̏͌́̃̓̉́̀̈̿̓͌̆̅̎̇͒͐̀͗̉̀͂̏̓̀̈́͑͐̾̿̌̉̔̓͌͛̈͌́̊̕̕̚̕̕̕͘̚͠͝͝͠͝͝͝͝͝͠h̴̡̨̡̨̧̛̛̛̳͙̳̦͚̫̟̰͔̘̼̣̳̲̯͍̮͚̝͔̠͔͓̥̫̜̩̟̝͖̼͉͎̹̲̤̝̤̠̤̮͖͙͉̫̦̖͇̤̝̼̝̖̲̠̥̦͍͈͇̼͇̙̟̱͕̦̘͍͕̗̩͇͚̩͙̻̣͙̥͕͎̬̙̙̰͇͕͎͎̹̼̭̘̠̟̲͇̟͖͂̋̏̅̔̏͋̇̀͐̅͂̿̍̒͛́̾͗̑͂͊͂̀̋̓̀̓̽̔̋̐̈̓̀͑̑̒̒̍͑͌͌̎́͛̄͛͛̅́͗̿̚̚̕͘̚͜͝͝͝͝ͅͅę̶̢̡̨̡̧̨̢̢̛̛̛̛̛͉̬̜̘̪͕̪̖͚͚̝̜̜̩̹̗̰̫̼͕̼̰͔̞̤̬̞͓̖͙͙̣̰̭̹̫̬̘̯̭̟͖͉̖̰̗̮̯̭̿͒͒̌͐͛͒̿̋̐͂͌̾̾̀̉͆̾̆̇͋̒̿͂͐̍̄̽͌͆̏̉̐̈́̿̎̒̃̉̀͌̉̈́͌͊̇̒̔͌̈́̆̆̌̅̈͛͆͆̋̓̀͋̓̓̔͛́̃̾͛̂͊͂͑̐̑͑̉̐̂̊̒̕͘̕͘̕͘̚͘͜͜͝͝͝͝͠͠ͅ ̶̡̧̨̧̧̧̨̧̡̨̧̺̯͍͖̺̟̖͇̜͚̟̪̟̤̠̭͓͇̩͉̯̮͉͚͓̯̼̝̘͕͕͔͈͉̱̠̱͇̞̗̠̱̪̟̯͔͖͓̺̫̪̠͉̺͕̟̮̲̰͔̻̮͓͈̮̭̥̱͇̰͈̟̮̥̣̭̯̹̑̈́̿̅̾̃̄͆̆̉̔̂͗͐̒̄̈̈̋̈͊̾̀̓̾̒͘͜͠͝͝v̴̨̡̡̧̨̨̧̛̛̛̛̻͕͔̠͚͎̱̪̮͓̘̟͓͚̜̯͚̼͉͉̯̖͓͖̖̪̹͖̱̝̫̜̖̠̙̺̳͇̭͈̯̹̺̮̝̲͎̮̮̦͓͈͍̳̫̞͓͉̰̺͇̻̩̗̩̞̺̻̬̬̮͈̗͇͉̝͔̺̖̲͉̭͎̞̣̈́̎͊͗̾̌̅͋́̀̍̓͆̈̀͑̎̏̉̽͗̀̄͋̋̍͊̅̽̈́͑̉̓̐̀̾̀̀̎͑͆̿̈́͆͆̉̎͆̈́̃̓͐͑̃̐̊̏̒͛̀͌͑̐̆̅̋̿͐͒͂̅̃̍̄͆̈̎̔̆̓̇̈̾̾̇̿̈͌͆̔̄̀͘̕̚̕͘͘͜͜͜͜͝͠͝͠͝͠͝͝ͅͅͅͅi̵̢̧̧̢̡̡̨̡̛͙͙̲̫͙̪̠̹͕̲̺̻̜̜̭̠̱̟̙͖͖̘͍̣̙̬͈̜̣͍͙̘̟͚͙͕͉̲̺͍̜͎͚̘̫͇̲̗̲̞̞̩̫̗̫͍̲̥̺̮̻̹̝̹͉̪̪̭͓̰̭̠̤̝̰͕̮͍͖͕̙̖̫͉̭͓̰̱̳̫̠͍̬͉̣̱̮̳̲̭̮̪̭̗̳̳̲̞̻̯͙̎̅̈́̍͒̄̀̀̾̒͐̾̃̂̑́̅́̈́̑̈́̏͐͑̑̄̇̍̌̚̕̕̕̕͜͠͠͝͝͝͝ͅͅş̴̛̛͎̜̖͓̏̒̽̽́̿́̀̎́̐͒͋́͊̓̎͌̋̉̒̾͒͐̌̕͘ͅĩ̴̡̡̢̨̛̛̛͙̹̗̭͔̱͈̠̟̹̬̯̯̱͔̞͓̯͓̩̯̻̹̯̤̭̭͔̬͓͍͈͔̝̯͉̻̦̝̪̰̜̣̝̲̱͈̥̦̼͔̹̩͔̫̳̖̭̜̖̯̙̘̗̳͈͇̤̥͔̯̜͕̜̟̬̻̲̎͌͒̈́͗̂̇̓́̎̈́̄̾̿͑̂͒̀͌̆́͛͑̀̐̎͗͐̈́̈͊̐́́̈́͛̊͌̓͂̔̊́̉̋́̂̿̎̋̄͂͂͊͛̍̽͋̑̾͋̎̇̐̊̔͐̓̈́̀̇̾̆̃͑̌̂̀̊̀̒͐̒̍̍̒̒̓͗̎̽̌̄̒̄͌̓͊̿̂̊͋̀̈́̃͋̈̍́͆̑̑͘͘͘͘̕͘͘͜͜͝͝͠͠͠ͅͅͅb̵̧̧͓̻͚̰̰̻͕̮͕̹̱̲̞͙̝̹̆̊̔͑̓̐́͛̿̔̓̿̅̂̉̎͂͗̀̿͒͐̈̑͂̏͒̑̾̽̇̄̾̑̄̊̌̀͒̾͂̉̍͋̋̇̏̆̕̚̕͘͝͝͠͝l̷̢̧̨̢̡̨̢̡̡̛̗̤̹̞̱̬͎̗̣͍͈̦̝͇̱̖̮̩͙͉̪̞̮͙͍͍͔̘̭̻̼̘̺͙̪̳̣̱̲̲͈͔͍͎͙̙̲̟̥̪̺̩̺͓̜̗̬͙̬̳̜͍̻̩̙̭͈̘̗̝̦͓͇̟̭̦͚͖̥̤̦̻͈̘̩̭͇̫̩̺̟̪̝̩̟̰̥̞̥̝̮̖̺̟̺̗̗͇̦͙͙̞̽̑͑̊̐̓̀́̓͗̇̓͗͋̑̆͋̅͋͛̈̋̈́͛̚͘͜͜͜ͅͅͅͅȩ̴̨̨̢̡̨̼̻̻̝͔̱̘͕̥͚̟̦̻͖̺̼͇̼̬̙̦̫̝̗̥̞̥̻̦̙̬̩̠̟̺͖̪͚̲̙̪̲̻̺̺̥͈̝̲͉̟̥͇̰̻̫̟̣̰̫̹̲̦̬̼̦͓͍͎̙̼͎̤̥̻̪̩͖̼̱͇̗̋͋̐͂͑̊͊̉̿̉͗̎͋͌͌̀͒͋̐̃͊͗̆̑̀͒̈́̂̀͒͌̕̚̕͘͜ͅ\n");
  notcurses_render(nc);
  notcurses_stop(nc);
  return EXIT_SUCCESS;
}
