'use strict';
const common = require('../common');
if (!common.hasCrypto)
  common.skip('missing crypto');

// Check getPeerCertificate can properly handle '\0' for fix CVE-2009-2408.

const assert = require('assert');
const tls = require('tls');
const fixtures = require('../common/fixtures');

const server = tls.createServer({
  key: fixtures.readSync(['0-dns', '0-dns-key.pem']),
  cert: fixtures.readSync(['0-dns', '0-dns-cert.pem'])
}, function(c) {
  c.once('data', function() {
    c.destroy();
    server.close();
  });
}).listen(0, common.mustCall(function() {
  const c = tls.connect(this.address().port, {
    rejectUnauthorized: false
  }, common.mustCall(function() {
    const cert = c.getPeerCertificate();
    assert.strictEqual(cert.subjectaltname,
                       'DNS:good.example.org\0.evil.example.com, ' +
                           'DNS:just-another.example.com, ' +
                           'IP Address:8.8.8.8, ' +
                           'IP Address:8.8.4.4, ' +
                           'DNS:last.example.com');
    c.write('ok');
  }));
}));
