# Node Foundation CTC Meeting 2016-02-10

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2016-02-10
* **GitHub Issue**: https://github.com/nodejs/node/issues/5176
* **Minutes Google Doc**: <https://docs.google.com/document/d/1sAHu9jVh8Dn9gHFASOH56j2klzW-L6YP-DfKo1gO_6Y>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/145ND-9pGdAwZ1eoOMypX1_wtx5FCVoanWtLl8zzyxH8>_

## Present

* James Snell (CTC)
* Trevor Norris (CTC)
* Colin Ihrig (CTC)
* Brian White (CTC)
* Alexis Campailla (CTC)
* Bert Belder (CTC)
* Chris Dickinson (CTC)
* Shigeki Ohtsu (CTC)
* Steven Loomis (observer)
* Mikeal Rogers (observer)
* Fedor Indutny (CTC)
* Jeremiah Senkpiel (CTC)
* Rod Vagg (CTC)
* Ben Noordhuis (CTC)
* Nikita Skovoroda (observer)
* Ali Sheikh (observer)
* Evan Lucas (observer)
* Rich Trott (observer)
* Michael Dawson (observer)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

* Revert "fs: deprecate fs.read's string interface" [#5163](https://github.com/nodejs/node/pull/5163) & fs: add a temporary fix for re-evaluation support [#5102](https://github.com/nodejs/node/pull/5102)
* buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682) & Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)
* CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

## Standup

* Brian White: Working more on improving performance in various areas of core, reviewing PRs and issues.
* Chris Dickinson: Promises PR + discussions with the error symposium group.
* Rich Trott: addressing flaky tests, enhancing linting, working to find a path to more automation in landing of PRs (although others, including Alexis, seem to have picked that ball up, thankfully)
* James Snell: Working on express stuff in, security stuff out, buffer API finished, moving forward on string externalization.
* Jeremiah Senkpiel: Hook for unhandled rejections that detects when the GC fires on a promise. That is currently blocked on V8 bug with weak callbacks + promises.
* Chris Dickinson: Promises PR + discussions with the error symposium group.
* Trevor Norris — MakeCallback reentrant fix for HTTP parser / AsyncWrap interaction.
* Michael Dawson - Working on getting AIX up in the CI.  Also on running v8 tests in the Node tree. Added AIX to libuv tests.
* Steven R. Loomis - not much to add
* Nikita Skovoroda — like ususal, mostly comments and the initial version of the codesearch API on a VPS. Nothing major.
* Rod Vagg - Security stuff, catching up on issues and discussions. Legal committee meeting yesterday.

## Review of last meeting

* Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)
* CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)
* buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682) & Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* @srl295: [path for full-icu data?](https://github.com/nodejs/node/issues/3460) -  ./node_modules vs ./node/ ? (npm linkage) - todo, update ticket with meeting resolution


## Minutes

### Revert "fs: deprecate fs.read's string interface" [#5163](https://github.com/nodejs/node/pull/5163) & fs: add a temporary fix for re-evaluation support [#5102](https://github.com/nodejs/node/pull/5102)

Rod: Simple deprecation warning for the particular argument usage. Pulling in the internal util module for deprecation messes up older versions of graceful-fs (and thus older versions of npm.) The question is whether to revert the PR, or to add a helper (that Nikita proposed.) I would suggest that this is urgent enough that we need to do something about it.

Jeremiah: This is a poor reason to revert it.
James: From everything that I’ve seen, adding the warning is the least bad option. Folks seems to be against reverting. Maybe making the warning less specific to graceful-fs.

Ben: I don’t agree. I think it’s right to point them to the newer version.

Jeremiah: I agree (with Ben).

Rod: Anytime you break the build, it’s an immediate candidate for reversion. It’s not permanently reverted, but it’s “let’s fix the build.”

Jeremiah: This doesn’t actually break CI though. It breaks newer versions of npm on master. .. It might be npm in general just on the master branch.

James: Forrest noted that pretty much any change other than reverting will have a significant effect on the npm user base.

Jeremiah: Yeah but we’re not shipping this in a stable.

Michael: If it breaks in master, doesn’t that prevent folks from doing other tests?

Ben: I think the problem lies with npm here.

Mikeal: You make that sound so easy.

Ben: The version of npm we’re talking about is still in a PR, yes?

Jeremiah: We don’t regularly run tests on master, so it might already be broken. I can test it right now..

Rod: I think Myles has been trying to run the npm tests more regularly, as part of smoke testing — and it’s broken for the smoke testing now.

Michael: It seems like we’d want to keep things as green as possible. It seems like we’d want npm to do something.

Rod: It’s a fact of life that we exist in an ecosystem that has these kinds of issues. My vote is to revert, and then revisit after we’ve gotten the build fixed.

Ben: Well, yeah, I do. I think Nikita’s PR is an acceptable intermediate solution.

Jeremiah: Likewise. The resolution is that we try to require it, if that fails, we use a deprecation helper we build in that emits a warning that something is breaking an internal module — that would fix it and seems quite reasonable. It will also help people note where stuff is going to break.

Rod: Does someone want to help Nikita get this in?

Ben: Didn’t you already get a couple of LGTMs?

James: I think there’s one -1 and three LGTMs.

Rod: We can force it if we have to.

James: I propose: if we accept this now, let’s try to get it resolved better before v6 goes out — which gives us a deadline so it’s not pushed off indefinitely. npm gets a fix, and that’s where it happens.

Ben: I think it’s a good idea to push npm to update their dependencies. Whether or not npm updates, I think it’s a good idea to include Nikita’s PR.

Jeremiah: I think so too.

Rod: Let’s take it back to GitHub.

### buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682) & Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)

James: There were some changes I was waiting for from Trevor w/r/t fill encoding. There was a desire to bikeshed a bit more on the name, not sure if you want to do that here. I think absent that the PR is probably in a place where we can land it.

Rod: Sounds like we need a last call for objections, otherwise it’s going in.

James: Yep.

Rod: How about you do that on GitHub?

James: OK.

Jeremiah: Are you adding a zero-fill flag?

James: Yes — it will switch all allocations to use calloc under the hood. The one thing this does not do is change the default behavior of `new Buffer(size)`. If we did that, it would be a breaking change going back to 0.10.

Bert: Is the plan to deprecate it off the table?

James: It’s a soft deprecate — docs only.

Jeremiah: We should try to just deprecate it. The problem is that folks are running different versions against modules, and it would be bad to rely on zero-fill behavior where it doesn’t exist [CD — didn’t capture this entirely]

James: We need to refine our deprecation strategy — and define whether something is deprecated vs. end-of-life. Will probably be returning to that next week or the week after.

Rod: It sounds like we’ve got a way forward, here.

Bert: It’s ugly but I won’t object.

Rod: Noted.

### CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)

Rod: We should start to line up a vote.

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

Rod: There was a PR that Mikeal put in that updates the DCO from v1.0 to v1.1. If you’d like to review that, please comment on that.

### Other business

James noted that the express application landed today. I will be working to move that into the new organization. More of an update on tomorrow’s TSC call.

Jeremiah notes that he will be a bit preoccupied by that for a while.

## Next Meeting

2016-02-17
