# basic_json::rend

```cpp
reverse_iterator rend() noexcept;
const_reverse_iterator rend() const noexcept;
```

Returns an iterator to the reverse-end; that is, one before the first element. This element acts as a placeholder,
attempting to access it results in undefined behavior.

![Illustration from cppreference.com](../../images/range-rbegin-rend.svg)

## Return value

reverse iterator to the element following the last element

## Exception safety

No-throw guarantee: this member function never throws exceptions.

## Complexity

Constant.

## Example

??? example

    The following code shows an example for `eend()`.
    
    ```cpp
    --8<-- "examples/rend.cpp"
    ```
    
    Output:
    
    ```json
    --8<-- "examples/rend.output"
    ```

## Version history

- Added in version 1.0.0.
