#!/bin/sh
# Generated by niminst

set -e

if [ $# -eq 1 ] ; then
  if test -f bin/nim
  then
    echo "Nim build detected"
  else
    echo "Please build Nim before installing it"
    exit 1
  fi
  case $1 in
    "--help"|"-h"|"help"|"h")
      echo "Nim installation script"
      echo "Usage: [sudo] sh install.sh DIR"
      echo "Where DIR may be:"
      echo "  /usr/bin"
      echo "  /usr/local/bin"
      echo "  /opt"
      echo "  <some other dir> (treated similar to '/opt')"
      echo "To deinstall, use the command:"
      echo "sh deinstall.sh DIR"
      exit 1
      ;;
    "/usr/bin")
      bindir=/usr/bin
      configdir=/etc/nim
      libdir=/usr/lib/nim
      docdir=/usr/share/nim/doc
      datadir=/usr/share/nim/data
      nimbleDir="/opt/nimble/pkgs/compiler-1.6.8"
      ;;
    "/usr/local/bin")
      bindir=/usr/local/bin
      configdir=/etc/nim
      libdir=/usr/local/lib/nim
      docdir=/usr/local/share/nim/doc
      datadir=/usr/local/share/nim/data
      nimbleDir="/opt/nimble/pkgs/compiler-1.6.8"
      ;;
    "/opt")
      bindir="/opt/nim/bin"
      configdir="/opt/nim/config"
      libdir="/opt/nim/lib"
      docdir="/opt/nim/doc"
      datadir="/opt/nim/data"
      nimbleDir="/opt/nimble/pkgs/compiler-1.6.8"
      mkdir -p /opt/nim
      mkdir -p $bindir
      mkdir -p $configdir
      ;;
    *)
      bindir="$1/nim/bin"
      configdir="$1/nim/config"
      libdir="$1/nim/lib"
      docdir="$1/nim/doc"
      datadir="$1/nim/data"
      nimbleDir="$1/nim"
      mkdir -p $1/nim
      mkdir -p $bindir
      mkdir -p $configdir
      ;;
  esac

  mkdir -p $libdir
  mkdir -p $docdir
  mkdir -p $configdir
  mkdir -p $nimbleDir/
  echo "copying files..."
  mkdir -p $configdir/
  mkdir -p $libdir/
  mkdir -p $libdir/impure
  mkdir -p $libdir/impure/nre/private
  mkdir -p $libdir/system
  mkdir -p $libdir/system/mm
  mkdir -p $libdir/posix
  mkdir -p $libdir/genode_cpp
  mkdir -p $libdir/packages/docutils
  mkdir -p $libdir/genode
  mkdir -p $libdir/js
  mkdir -p $libdir/windows
  mkdir -p $libdir/deprecated/pure
  mkdir -p $libdir/experimental
  mkdir -p $libdir/core
  mkdir -p $libdir/wrappers
  mkdir -p $libdir/wrappers/linenoise
  mkdir -p $libdir/std
  mkdir -p $libdir/std/private
  mkdir -p $libdir/arch/x86
  mkdir -p $libdir/pure
  mkdir -p $libdir/pure/collections
  mkdir -p $libdir/pure/unidecode
  mkdir -p $libdir/pure/concurrency
  mkdir -p $libdir/pure/includes
  mkdir -p $libdir/pure/ioselects
  mkdir -p $nimbleDir/compiler
  mkdir -p $nimbleDir/compiler/ic
  mkdir -p $nimbleDir/compiler/nimfix
  mkdir -p $nimbleDir/compiler/plugins
  mkdir -p $nimbleDir/doc

  cp bin/nim $bindir/nim
  chmod 755 $bindir/nim
  cp config/nim.cfg $configdir/nim.cfg
  chmod 644 $configdir/nim.cfg
  cp config/nimdoc.cfg $configdir/nimdoc.cfg
  chmod 644 $configdir/nimdoc.cfg
  cp config/nimdoc.tex.cfg $configdir/nimdoc.tex.cfg
  chmod 644 $configdir/nimdoc.tex.cfg
  cp config/rename.rules.cfg $configdir/rename.rules.cfg
  chmod 644 $configdir/rename.rules.cfg
  cp config/config.nims $configdir/config.nims
  chmod 644 $configdir/config.nims
  cp lib/system.nim $libdir/system.nim
  chmod 644 $libdir/system.nim
  cp lib/impure/rdstdin.nim $libdir/impure/rdstdin.nim
  chmod 644 $libdir/impure/rdstdin.nim
  cp lib/impure/db_postgres.nim $libdir/impure/db_postgres.nim
  chmod 644 $libdir/impure/db_postgres.nim
  cp lib/impure/nre/private/util.nim $libdir/impure/nre/private/util.nim
  chmod 644 $libdir/impure/nre/private/util.nim
  cp lib/impure/db_odbc.nim $libdir/impure/db_odbc.nim
  chmod 644 $libdir/impure/db_odbc.nim
  cp lib/impure/db_mysql.nim $libdir/impure/db_mysql.nim
  chmod 644 $libdir/impure/db_mysql.nim
  cp lib/impure/db_sqlite.nim $libdir/impure/db_sqlite.nim
  chmod 644 $libdir/impure/db_sqlite.nim
  cp lib/impure/re.nim $libdir/impure/re.nim
  chmod 644 $libdir/impure/re.nim
  cp lib/impure/nre.nim $libdir/impure/nre.nim
  chmod 644 $libdir/impure/nre.nim
  cp lib/system_overview.rst $libdir/system_overview.rst
  chmod 644 $libdir/system_overview.rst
  cp lib/nimhcr.nim $libdir/nimhcr.nim
  chmod 644 $libdir/nimhcr.nim
  cp lib/deps.txt $libdir/deps.txt
  chmod 644 $libdir/deps.txt
  cp lib/system/inclrtl.nim $libdir/system/inclrtl.nim
  chmod 644 $libdir/system/inclrtl.nim
  cp lib/system/memory.nim $libdir/system/memory.nim
  chmod 644 $libdir/system/memory.nim
  cp lib/system/stacktraces.nim $libdir/system/stacktraces.nim
  chmod 644 $libdir/system/stacktraces.nim
  cp lib/system/gc_common.nim $libdir/system/gc_common.nim
  chmod 644 $libdir/system/gc_common.nim
  cp lib/system/hti.nim $libdir/system/hti.nim
  chmod 644 $libdir/system/hti.nim
  cp lib/system/cellseqs_v2.nim $libdir/system/cellseqs_v2.nim
  chmod 644 $libdir/system/cellseqs_v2.nim
  cp lib/system/channels_builtin.nim $libdir/system/channels_builtin.nim
  chmod 644 $libdir/system/channels_builtin.nim
  cp lib/system/assertions.nim $libdir/system/assertions.nim
  chmod 644 $libdir/system/assertions.nim
  cp lib/system/integerops.nim $libdir/system/integerops.nim
  chmod 644 $libdir/system/integerops.nim
  cp lib/system/exceptions.nim $libdir/system/exceptions.nim
  chmod 644 $libdir/system/exceptions.nim
  cp lib/system/comparisons.nim $libdir/system/comparisons.nim
  chmod 644 $libdir/system/comparisons.nim
  cp lib/system/setops.nim $libdir/system/setops.nim
  chmod 644 $libdir/system/setops.nim
  cp lib/system/sysspawn.nim $libdir/system/sysspawn.nim
  chmod 644 $libdir/system/sysspawn.nim
  cp lib/system/orc.nim $libdir/system/orc.nim
  chmod 644 $libdir/system/orc.nim
  cp lib/system/iterators_1.nim $libdir/system/iterators_1.nim
  chmod 644 $libdir/system/iterators_1.nim
  cp lib/system/strs_v2.nim $libdir/system/strs_v2.nim
  chmod 644 $libdir/system/strs_v2.nim
  cp lib/system/indexerrors.nim $libdir/system/indexerrors.nim
  chmod 644 $libdir/system/indexerrors.nim
  cp lib/system/threadlocalstorage.nim $libdir/system/threadlocalstorage.nim
  chmod 644 $libdir/system/threadlocalstorage.nim
  cp lib/system/seqs_v2_reimpl.nim $libdir/system/seqs_v2_reimpl.nim
  chmod 644 $libdir/system/seqs_v2_reimpl.nim
  cp lib/system/gc_hooks.nim $libdir/system/gc_hooks.nim
  chmod 644 $libdir/system/gc_hooks.nim
  cp lib/system/bitmasks.nim $libdir/system/bitmasks.nim
  chmod 644 $libdir/system/bitmasks.nim
  cp lib/system/widestrs.nim $libdir/system/widestrs.nim
  chmod 644 $libdir/system/widestrs.nim
  cp lib/system/cellseqs_v1.nim $libdir/system/cellseqs_v1.nim
  chmod 644 $libdir/system/cellseqs_v1.nim
  cp lib/system/memalloc.nim $libdir/system/memalloc.nim
  chmod 644 $libdir/system/memalloc.nim
  cp lib/system/timers.nim $libdir/system/timers.nim
  chmod 644 $libdir/system/timers.nim
  cp lib/system/schubfach.nim $libdir/system/schubfach.nim
  chmod 644 $libdir/system/schubfach.nim
  cp lib/system/alloc.nim $libdir/system/alloc.nim
  chmod 644 $libdir/system/alloc.nim
  cp lib/system/gc_interface.nim $libdir/system/gc_interface.nim
  chmod 644 $libdir/system/gc_interface.nim
  cp lib/system/mm/boehm.nim $libdir/system/mm/boehm.nim
  chmod 644 $libdir/system/mm/boehm.nim
  cp lib/system/mm/go.nim $libdir/system/mm/go.nim
  chmod 644 $libdir/system/mm/go.nim
  cp lib/system/mm/none.nim $libdir/system/mm/none.nim
  chmod 644 $libdir/system/mm/none.nim
  cp lib/system/mm/malloc.nim $libdir/system/mm/malloc.nim
  chmod 644 $libdir/system/mm/malloc.nim
  cp lib/system/fatal.nim $libdir/system/fatal.nim
  chmod 644 $libdir/system/fatal.nim
  cp lib/system/cellsets.nim $libdir/system/cellsets.nim
  chmod 644 $libdir/system/cellsets.nim
  cp lib/system/formatfloat.nim $libdir/system/formatfloat.nim
  chmod 644 $libdir/system/formatfloat.nim
  cp lib/system/avltree.nim $libdir/system/avltree.nim
  chmod 644 $libdir/system/avltree.nim
  cp lib/system/chcks.nim $libdir/system/chcks.nim
  chmod 644 $libdir/system/chcks.nim
  cp lib/system/seqs_v2.nim $libdir/system/seqs_v2.nim
  chmod 644 $libdir/system/seqs_v2.nim
  cp lib/system/ansi_c.nim $libdir/system/ansi_c.nim
  chmod 644 $libdir/system/ansi_c.nim
  cp lib/system/osalloc.nim $libdir/system/osalloc.nim
  chmod 644 $libdir/system/osalloc.nim
  cp lib/system/sets.nim $libdir/system/sets.nim
  chmod 644 $libdir/system/sets.nim
  cp lib/system/gc_regions.nim $libdir/system/gc_regions.nim
  chmod 644 $libdir/system/gc_regions.nim
  cp lib/system/io.nim $libdir/system/io.nim
  chmod 644 $libdir/system/io.nim
  cp lib/system/sysstr.nim $libdir/system/sysstr.nim
  chmod 644 $libdir/system/sysstr.nim
  cp lib/system/strmantle.nim $libdir/system/strmantle.nim
  chmod 644 $libdir/system/strmantle.nim
  cp lib/system/countbits_impl.nim $libdir/system/countbits_impl.nim
  chmod 644 $libdir/system/countbits_impl.nim
  cp lib/system/gc.nim $libdir/system/gc.nim
  chmod 644 $libdir/system/gc.nim
  cp lib/system/assign.nim $libdir/system/assign.nim
  chmod 644 $libdir/system/assign.nim
  cp lib/system/gc2.nim $libdir/system/gc2.nim
  chmod 644 $libdir/system/gc2.nim
  cp lib/system/threads.nim $libdir/system/threads.nim
  chmod 644 $libdir/system/threads.nim
  cp lib/system/gc_ms.nim $libdir/system/gc_ms.nim
  chmod 644 $libdir/system/gc_ms.nim
  cp lib/system/arithm.nim $libdir/system/arithm.nim
  chmod 644 $libdir/system/arithm.nim
  cp lib/system/embedded.nim $libdir/system/embedded.nim
  chmod 644 $libdir/system/embedded.nim
  cp lib/system/repr.nim $libdir/system/repr.nim
  chmod 644 $libdir/system/repr.nim
  cp lib/system/repr_impl.nim $libdir/system/repr_impl.nim
  chmod 644 $libdir/system/repr_impl.nim
  cp lib/system/repr_v2.nim $libdir/system/repr_v2.nim
  chmod 644 $libdir/system/repr_v2.nim
  cp lib/system/cgprocs.nim $libdir/system/cgprocs.nim
  chmod 644 $libdir/system/cgprocs.nim
  cp lib/system/arc.nim $libdir/system/arc.nim
  chmod 644 $libdir/system/arc.nim
  cp lib/system/dragonbox.nim $libdir/system/dragonbox.nim
  chmod 644 $libdir/system/dragonbox.nim
  cp lib/system/coro_detection.nim $libdir/system/coro_detection.nim
  chmod 644 $libdir/system/coro_detection.nim
  cp lib/system/dyncalls.nim $libdir/system/dyncalls.nim
  chmod 644 $libdir/system/dyncalls.nim
  cp lib/system/deepcopy.nim $libdir/system/deepcopy.nim
  chmod 644 $libdir/system/deepcopy.nim
  cp lib/system/profiler.nim $libdir/system/profiler.nim
  chmod 644 $libdir/system/profiler.nim
  cp lib/system/cyclebreaker.nim $libdir/system/cyclebreaker.nim
  chmod 644 $libdir/system/cyclebreaker.nim
  cp lib/system/mmdisp.nim $libdir/system/mmdisp.nim
  chmod 644 $libdir/system/mmdisp.nim
  cp lib/system/arithmetics.nim $libdir/system/arithmetics.nim
  chmod 644 $libdir/system/arithmetics.nim
  cp lib/system/reprjs.nim $libdir/system/reprjs.nim
  chmod 644 $libdir/system/reprjs.nim
  cp lib/system/nimscript.nim $libdir/system/nimscript.nim
  chmod 644 $libdir/system/nimscript.nim
  cp lib/system/basic_types.nim $libdir/system/basic_types.nim
  chmod 644 $libdir/system/basic_types.nim
  cp lib/system/dollars.nim $libdir/system/dollars.nim
  chmod 644 $libdir/system/dollars.nim
  cp lib/system/platforms.nim $libdir/system/platforms.nim
  chmod 644 $libdir/system/platforms.nim
  cp lib/system/iterators.nim $libdir/system/iterators.nim
  chmod 644 $libdir/system/iterators.nim
  cp lib/system/jssys.nim $libdir/system/jssys.nim
  chmod 644 $libdir/system/jssys.nim
  cp lib/system/syslocks.nim $libdir/system/syslocks.nim
  chmod 644 $libdir/system/syslocks.nim
  cp lib/system/memtracker.nim $libdir/system/memtracker.nim
  chmod 644 $libdir/system/memtracker.nim
  cp lib/system/excpt.nim $libdir/system/excpt.nim
  chmod 644 $libdir/system/excpt.nim
  cp lib/system/atomics.nim $libdir/system/atomics.nim
  chmod 644 $libdir/system/atomics.nim
  cp lib/posix/kqueue.nim $libdir/posix/kqueue.nim
  chmod 644 $libdir/posix/kqueue.nim
  cp lib/posix/epoll.nim $libdir/posix/epoll.nim
  chmod 644 $libdir/posix/epoll.nim
  cp lib/posix/posix_nintendoswitch_consts.nim $libdir/posix/posix_nintendoswitch_consts.nim
  chmod 644 $libdir/posix/posix_nintendoswitch_consts.nim
  cp lib/posix/posix_other_consts.nim $libdir/posix/posix_other_consts.nim
  chmod 644 $libdir/posix/posix_other_consts.nim
  cp lib/posix/posix_utils.nim $libdir/posix/posix_utils.nim
  chmod 644 $libdir/posix/posix_utils.nim
  cp lib/posix/posix_openbsd_amd64.nim $libdir/posix/posix_openbsd_amd64.nim
  chmod 644 $libdir/posix/posix_openbsd_amd64.nim
  cp lib/posix/termios.nim $libdir/posix/termios.nim
  chmod 644 $libdir/posix/termios.nim
  cp lib/posix/posix_linux_amd64_consts.nim $libdir/posix/posix_linux_amd64_consts.nim
  chmod 644 $libdir/posix/posix_linux_amd64_consts.nim
  cp lib/posix/posix_other.nim $libdir/posix/posix_other.nim
  chmod 644 $libdir/posix/posix_other.nim
  cp lib/posix/posix.nim $libdir/posix/posix.nim
  chmod 644 $libdir/posix/posix.nim
  cp lib/posix/posix_haiku.nim $libdir/posix/posix_haiku.nim
  chmod 644 $libdir/posix/posix_haiku.nim
  cp lib/posix/posix_linux_amd64.nim $libdir/posix/posix_linux_amd64.nim
  chmod 644 $libdir/posix/posix_linux_amd64.nim
  cp lib/posix/linux.nim $libdir/posix/linux.nim
  chmod 644 $libdir/posix/linux.nim
  cp lib/posix/posix_macos_amd64.nim $libdir/posix/posix_macos_amd64.nim
  chmod 644 $libdir/posix/posix_macos_amd64.nim
  cp lib/posix/posix_freertos_consts.nim $libdir/posix/posix_freertos_consts.nim
  chmod 644 $libdir/posix/posix_freertos_consts.nim
  cp lib/posix/inotify.nim $libdir/posix/inotify.nim
  chmod 644 $libdir/posix/inotify.nim
  cp lib/posix/posix_nintendoswitch.nim $libdir/posix/posix_nintendoswitch.nim
  chmod 644 $libdir/posix/posix_nintendoswitch.nim
  cp lib/genode_cpp/threads.h $libdir/genode_cpp/threads.h
  chmod 644 $libdir/genode_cpp/threads.h
  cp lib/genode_cpp/syslocks.h $libdir/genode_cpp/syslocks.h
  chmod 644 $libdir/genode_cpp/syslocks.h
  cp lib/packages/docutils/rstgen.nim $libdir/packages/docutils/rstgen.nim
  chmod 644 $libdir/packages/docutils/rstgen.nim
  cp lib/packages/docutils/docutils.nimble.old $libdir/packages/docutils/docutils.nimble.old
  chmod 644 $libdir/packages/docutils/docutils.nimble.old
  cp lib/packages/docutils/rst.nim $libdir/packages/docutils/rst.nim
  chmod 644 $libdir/packages/docutils/rst.nim
  cp lib/packages/docutils/highlite.nim $libdir/packages/docutils/highlite.nim
  chmod 644 $libdir/packages/docutils/highlite.nim
  cp lib/packages/docutils/rstast.nim $libdir/packages/docutils/rstast.nim
  chmod 644 $libdir/packages/docutils/rstast.nim
  cp lib/cycle.h $libdir/cycle.h
  chmod 644 $libdir/cycle.h
  cp lib/nimrtl.nim.cfg $libdir/nimrtl.nim.cfg
  chmod 644 $libdir/nimrtl.nim.cfg
  cp lib/genode/env.nim $libdir/genode/env.nim
  chmod 644 $libdir/genode/env.nim
  cp lib/genode/alloc.nim $libdir/genode/alloc.nim
  chmod 644 $libdir/genode/alloc.nim
  cp lib/js/jscore.nim $libdir/js/jscore.nim
  chmod 644 $libdir/js/jscore.nim
  cp lib/js/dom.nim $libdir/js/dom.nim
  chmod 644 $libdir/js/dom.nim
  cp lib/js/jsconsole.nim $libdir/js/jsconsole.nim
  chmod 644 $libdir/js/jsconsole.nim
  cp lib/js/asyncjs.nim $libdir/js/asyncjs.nim
  chmod 644 $libdir/js/asyncjs.nim
  cp lib/js/jsffi.nim $libdir/js/jsffi.nim
  chmod 644 $libdir/js/jsffi.nim
  cp lib/js/dom_extensions.nim $libdir/js/dom_extensions.nim
  chmod 644 $libdir/js/dom_extensions.nim
  cp lib/js/jsre.nim $libdir/js/jsre.nim
  chmod 644 $libdir/js/jsre.nim
  cp lib/windows/registry.nim $libdir/windows/registry.nim
  chmod 644 $libdir/windows/registry.nim
  cp lib/windows/winlean.nim $libdir/windows/winlean.nim
  chmod 644 $libdir/windows/winlean.nim
  cp lib/deprecated/pure/securehash.nim $libdir/deprecated/pure/securehash.nim
  chmod 644 $libdir/deprecated/pure/securehash.nim
  cp lib/deprecated/pure/parseopt2.nim $libdir/deprecated/pure/parseopt2.nim
  chmod 644 $libdir/deprecated/pure/parseopt2.nim
  cp lib/deprecated/pure/sharedstrings.nim $libdir/deprecated/pure/sharedstrings.nim
  chmod 644 $libdir/deprecated/pure/sharedstrings.nim
  cp lib/deprecated/pure/ospaths.nim $libdir/deprecated/pure/ospaths.nim
  chmod 644 $libdir/deprecated/pure/ospaths.nim
  cp lib/deprecated/pure/LockFreeHash.nim $libdir/deprecated/pure/LockFreeHash.nim
  chmod 644 $libdir/deprecated/pure/LockFreeHash.nim
  cp lib/deprecated/pure/events.nim $libdir/deprecated/pure/events.nim
  chmod 644 $libdir/deprecated/pure/events.nim
  cp lib/experimental/diff.nim $libdir/experimental/diff.nim
  chmod 644 $libdir/experimental/diff.nim
  cp lib/core/macros.nim $libdir/core/macros.nim
  chmod 644 $libdir/core/macros.nim
  cp lib/core/locks.nim $libdir/core/locks.nim
  chmod 644 $libdir/core/locks.nim
  cp lib/core/hotcodereloading.nim $libdir/core/hotcodereloading.nim
  chmod 644 $libdir/core/hotcodereloading.nim
  cp lib/core/rlocks.nim $libdir/core/rlocks.nim
  chmod 644 $libdir/core/rlocks.nim
  cp lib/core/macrocache.nim $libdir/core/macrocache.nim
  chmod 644 $libdir/core/macrocache.nim
  cp lib/core/typeinfo.nim $libdir/core/typeinfo.nim
  chmod 644 $libdir/core/typeinfo.nim
  cp lib/nimrtl.nim $libdir/nimrtl.nim
  chmod 644 $libdir/nimrtl.nim
  cp lib/wrappers/pcre.nim $libdir/wrappers/pcre.nim
  chmod 644 $libdir/wrappers/pcre.nim
  cp lib/wrappers/sqlite3.nim $libdir/wrappers/sqlite3.nim
  chmod 644 $libdir/wrappers/sqlite3.nim
  cp lib/wrappers/mysql.nim $libdir/wrappers/mysql.nim
  chmod 644 $libdir/wrappers/mysql.nim
  cp lib/wrappers/postgres.nim $libdir/wrappers/postgres.nim
  chmod 644 $libdir/wrappers/postgres.nim
  cp lib/wrappers/odbcsql.nim $libdir/wrappers/odbcsql.nim
  chmod 644 $libdir/wrappers/odbcsql.nim
  cp lib/wrappers/openssl.nim $libdir/wrappers/openssl.nim
  chmod 644 $libdir/wrappers/openssl.nim
  cp lib/wrappers/linenoise/linenoise.nim $libdir/wrappers/linenoise/linenoise.nim
  chmod 644 $libdir/wrappers/linenoise/linenoise.nim
  cp lib/wrappers/linenoise/linenoise.h $libdir/wrappers/linenoise/linenoise.h
  chmod 644 $libdir/wrappers/linenoise/linenoise.h
  cp lib/wrappers/linenoise/LICENSE.txt $libdir/wrappers/linenoise/LICENSE.txt
  chmod 644 $libdir/wrappers/linenoise/LICENSE.txt
  cp lib/wrappers/linenoise/README.markdown $libdir/wrappers/linenoise/README.markdown
  chmod 644 $libdir/wrappers/linenoise/README.markdown
  cp lib/wrappers/linenoise/linenoise.c $libdir/wrappers/linenoise/linenoise.c
  chmod 644 $libdir/wrappers/linenoise/linenoise.c
  cp lib/wrappers/tinyc.nim $libdir/wrappers/tinyc.nim
  chmod 644 $libdir/wrappers/tinyc.nim
  cp lib/stdlib.nimble $libdir/stdlib.nimble
  chmod 644 $libdir/stdlib.nimble
  cp lib/nimhcr.nim.cfg $libdir/nimhcr.nim.cfg
  chmod 644 $libdir/nimhcr.nim.cfg
  cp lib/nimbase.h $libdir/nimbase.h
  chmod 644 $libdir/nimbase.h
  cp lib/std/tempfiles.nim $libdir/std/tempfiles.nim
  chmod 644 $libdir/std/tempfiles.nim
  cp lib/std/enumerate.nim $libdir/std/enumerate.nim
  chmod 644 $libdir/std/enumerate.nim
  cp lib/std/jsfetch.nim $libdir/std/jsfetch.nim
  chmod 644 $libdir/std/jsfetch.nim
  cp lib/std/setutils.nim $libdir/std/setutils.nim
  chmod 644 $libdir/std/setutils.nim
  cp lib/std/packedsets.nim $libdir/std/packedsets.nim
  chmod 644 $libdir/std/packedsets.nim
  cp lib/std/tasks.nim $libdir/std/tasks.nim
  chmod 644 $libdir/std/tasks.nim
  cp lib/std/logic.nim $libdir/std/logic.nim
  chmod 644 $libdir/std/logic.nim
  cp lib/std/socketstreams.nim $libdir/std/socketstreams.nim
  chmod 644 $libdir/std/socketstreams.nim
  cp lib/std/sysrand.nim $libdir/std/sysrand.nim
  chmod 644 $libdir/std/sysrand.nim
  cp lib/std/jsonutils.nim $libdir/std/jsonutils.nim
  chmod 644 $libdir/std/jsonutils.nim
  cp lib/std/jsformdata.nim $libdir/std/jsformdata.nim
  chmod 644 $libdir/std/jsformdata.nim
  cp lib/std/varints.nim $libdir/std/varints.nim
  chmod 644 $libdir/std/varints.nim
  cp lib/std/stackframes.nim $libdir/std/stackframes.nim
  chmod 644 $libdir/std/stackframes.nim
  cp lib/std/wordwrap.nim $libdir/std/wordwrap.nim
  chmod 644 $libdir/std/wordwrap.nim
  cp lib/std/jsbigints.nim $libdir/std/jsbigints.nim
  chmod 644 $libdir/std/jsbigints.nim
  cp lib/std/genasts.nim $libdir/std/genasts.nim
  chmod 644 $libdir/std/genasts.nim
  cp lib/std/monotimes.nim $libdir/std/monotimes.nim
  chmod 644 $libdir/std/monotimes.nim
  cp lib/std/with.nim $libdir/std/with.nim
  chmod 644 $libdir/std/with.nim
  cp lib/std/decls.nim $libdir/std/decls.nim
  chmod 644 $libdir/std/decls.nim
  cp lib/std/time_t.nim $libdir/std/time_t.nim
  chmod 644 $libdir/std/time_t.nim
  cp lib/std/vmutils.nim $libdir/std/vmutils.nim
  chmod 644 $libdir/std/vmutils.nim
  cp lib/std/sha1.nim $libdir/std/sha1.nim
  chmod 644 $libdir/std/sha1.nim
  cp lib/std/enumutils.nim $libdir/std/enumutils.nim
  chmod 644 $libdir/std/enumutils.nim
  cp lib/std/compilesettings.nim $libdir/std/compilesettings.nim
  chmod 644 $libdir/std/compilesettings.nim
  cp lib/std/importutils.nim $libdir/std/importutils.nim
  chmod 644 $libdir/std/importutils.nim
  cp lib/std/sums.nim $libdir/std/sums.nim
  chmod 644 $libdir/std/sums.nim
  cp lib/std/private/bitops_utils.nim $libdir/std/private/bitops_utils.nim
  chmod 644 $libdir/std/private/bitops_utils.nim
  cp lib/std/private/gitutils.nim $libdir/std/private/gitutils.nim
  chmod 644 $libdir/std/private/gitutils.nim
  cp lib/std/private/strimpl.nim $libdir/std/private/strimpl.nim
  chmod 644 $libdir/std/private/strimpl.nim
  cp lib/std/private/since.nim $libdir/std/private/since.nim
  chmod 644 $libdir/std/private/since.nim
  cp lib/std/private/decode_helpers.nim $libdir/std/private/decode_helpers.nim
  chmod 644 $libdir/std/private/decode_helpers.nim
  cp lib/std/private/miscdollars.nim $libdir/std/private/miscdollars.nim
  chmod 644 $libdir/std/private/miscdollars.nim
  cp lib/std/private/dbutils.nim $libdir/std/private/dbutils.nim
  chmod 644 $libdir/std/private/dbutils.nim
  cp lib/std/private/asciitables.nim $libdir/std/private/asciitables.nim
  chmod 644 $libdir/std/private/asciitables.nim
  cp lib/std/private/globs.nim $libdir/std/private/globs.nim
  chmod 644 $libdir/std/private/globs.nim
  cp lib/std/private/digitsutils.nim $libdir/std/private/digitsutils.nim
  chmod 644 $libdir/std/private/digitsutils.nim
  cp lib/std/private/jsutils.nim $libdir/std/private/jsutils.nim
  chmod 644 $libdir/std/private/jsutils.nim
  cp lib/std/private/win_setenv.nim $libdir/std/private/win_setenv.nim
  chmod 644 $libdir/std/private/win_setenv.nim
  cp lib/std/private/underscored_calls.nim $libdir/std/private/underscored_calls.nim
  chmod 644 $libdir/std/private/underscored_calls.nim
  cp lib/std/wrapnils.nim $libdir/std/wrapnils.nim
  chmod 644 $libdir/std/wrapnils.nim
  cp lib/std/isolation.nim $libdir/std/isolation.nim
  chmod 644 $libdir/std/isolation.nim
  cp lib/std/effecttraits.nim $libdir/std/effecttraits.nim
  chmod 644 $libdir/std/effecttraits.nim
  cp lib/std/jsheaders.nim $libdir/std/jsheaders.nim
  chmod 644 $libdir/std/jsheaders.nim
  cp lib/std/strbasics.nim $libdir/std/strbasics.nim
  chmod 644 $libdir/std/strbasics.nim
  cp lib/std/exitprocs.nim $libdir/std/exitprocs.nim
  chmod 644 $libdir/std/exitprocs.nim
  cp lib/std/editdistance.nim $libdir/std/editdistance.nim
  chmod 644 $libdir/std/editdistance.nim
  cp lib/arch/x86/i386.S $libdir/arch/x86/i386.S
  chmod 644 $libdir/arch/x86/i386.S
  cp lib/arch/x86/amd64.S $libdir/arch/x86/amd64.S
  chmod 644 $libdir/arch/x86/amd64.S
  cp lib/pure/options.nim $libdir/pure/options.nim
  chmod 644 $libdir/pure/options.nim
  cp lib/pure/math.nim $libdir/pure/math.nim
  chmod 644 $libdir/pure/math.nim
  cp lib/pure/streamwrapper.nim $libdir/pure/streamwrapper.nim
  chmod 644 $libdir/pure/streamwrapper.nim
  cp lib/pure/hashes.nim $libdir/pure/hashes.nim
  chmod 644 $libdir/pure/hashes.nim
  cp lib/pure/asyncftpclient.nim $libdir/pure/asyncftpclient.nim
  chmod 644 $libdir/pure/asyncftpclient.nim
  cp lib/pure/parsecsv.nim $libdir/pure/parsecsv.nim
  chmod 644 $libdir/pure/parsecsv.nim
  cp lib/pure/smtp.nim.cfg $libdir/pure/smtp.nim.cfg
  chmod 644 $libdir/pure/smtp.nim.cfg
  cp lib/pure/segfaults.nim $libdir/pure/segfaults.nim
  chmod 644 $libdir/pure/segfaults.nim
  cp lib/pure/unittest.nim $libdir/pure/unittest.nim
  chmod 644 $libdir/pure/unittest.nim
  cp lib/pure/cstrutils.nim $libdir/pure/cstrutils.nim
  chmod 644 $libdir/pure/cstrutils.nim
  cp lib/pure/distros.nim $libdir/pure/distros.nim
  chmod 644 $libdir/pure/distros.nim
  cp lib/pure/md5.nim $libdir/pure/md5.nim
  chmod 644 $libdir/pure/md5.nim
  cp lib/pure/parseutils.nim $libdir/pure/parseutils.nim
  chmod 644 $libdir/pure/parseutils.nim
  cp lib/pure/sugar.nim $libdir/pure/sugar.nim
  chmod 644 $libdir/pure/sugar.nim
  cp lib/pure/future.nim $libdir/pure/future.nim
  chmod 644 $libdir/pure/future.nim
  cp lib/pure/cookies.nim $libdir/pure/cookies.nim
  chmod 644 $libdir/pure/cookies.nim
  cp lib/pure/algorithm.nim $libdir/pure/algorithm.nim
  chmod 644 $libdir/pure/algorithm.nim
  cp lib/pure/pegs.nim $libdir/pure/pegs.nim
  chmod 644 $libdir/pure/pegs.nim
  cp lib/pure/terminal.nim $libdir/pure/terminal.nim
  chmod 644 $libdir/pure/terminal.nim
  cp lib/pure/encodings.nim $libdir/pure/encodings.nim
  chmod 644 $libdir/pure/encodings.nim
  cp lib/pure/parseopt.nim $libdir/pure/parseopt.nim
  chmod 644 $libdir/pure/parseopt.nim
  cp lib/pure/httpclient.nim $libdir/pure/httpclient.nim
  chmod 644 $libdir/pure/httpclient.nim
  cp lib/pure/complex.nim $libdir/pure/complex.nim
  chmod 644 $libdir/pure/complex.nim
  cp lib/pure/asyncfile.nim $libdir/pure/asyncfile.nim
  chmod 644 $libdir/pure/asyncfile.nim
  cp lib/pure/collections/critbits.nim $libdir/pure/collections/critbits.nim
  chmod 644 $libdir/pure/collections/critbits.nim
  cp lib/pure/collections/heapqueue.nim $libdir/pure/collections/heapqueue.nim
  chmod 644 $libdir/pure/collections/heapqueue.nim
  cp lib/pure/collections/tableimpl.nim $libdir/pure/collections/tableimpl.nim
  chmod 644 $libdir/pure/collections/tableimpl.nim
  cp lib/pure/collections/setimpl.nim $libdir/pure/collections/setimpl.nim
  chmod 644 $libdir/pure/collections/setimpl.nim
  cp lib/pure/collections/sets.nim $libdir/pure/collections/sets.nim
  chmod 644 $libdir/pure/collections/sets.nim
  cp lib/pure/collections/sharedlist.nim $libdir/pure/collections/sharedlist.nim
  chmod 644 $libdir/pure/collections/sharedlist.nim
  cp lib/pure/collections/chains.nim $libdir/pure/collections/chains.nim
  chmod 644 $libdir/pure/collections/chains.nim
  cp lib/pure/collections/intsets.nim $libdir/pure/collections/intsets.nim
  chmod 644 $libdir/pure/collections/intsets.nim
  cp lib/pure/collections/lists.nim $libdir/pure/collections/lists.nim
  chmod 644 $libdir/pure/collections/lists.nim
  cp lib/pure/collections/sequtils.nim $libdir/pure/collections/sequtils.nim
  chmod 644 $libdir/pure/collections/sequtils.nim
  cp lib/pure/collections/tables.nim $libdir/pure/collections/tables.nim
  chmod 644 $libdir/pure/collections/tables.nim
  cp lib/pure/collections/rtarrays.nim $libdir/pure/collections/rtarrays.nim
  chmod 644 $libdir/pure/collections/rtarrays.nim
  cp lib/pure/collections/sharedtables.nim $libdir/pure/collections/sharedtables.nim
  chmod 644 $libdir/pure/collections/sharedtables.nim
  cp lib/pure/collections/deques.nim $libdir/pure/collections/deques.nim
  chmod 644 $libdir/pure/collections/deques.nim
  cp lib/pure/collections/hashcommon.nim $libdir/pure/collections/hashcommon.nim
  chmod 644 $libdir/pure/collections/hashcommon.nim
  cp lib/pure/oswalkdir.nim $libdir/pure/oswalkdir.nim
  chmod 644 $libdir/pure/oswalkdir.nim
  cp lib/pure/pathnorm.nim $libdir/pure/pathnorm.nim
  chmod 644 $libdir/pure/pathnorm.nim
  cp lib/pure/httpcore.nim $libdir/pure/httpcore.nim
  chmod 644 $libdir/pure/httpcore.nim
  cp lib/pure/random.nim $libdir/pure/random.nim
  chmod 644 $libdir/pure/random.nim
  cp lib/pure/coro.nim $libdir/pure/coro.nim
  chmod 644 $libdir/pure/coro.nim
  cp lib/pure/memfiles.nim $libdir/pure/memfiles.nim
  chmod 644 $libdir/pure/memfiles.nim
  cp lib/pure/db_common.nim $libdir/pure/db_common.nim
  chmod 644 $libdir/pure/db_common.nim
  cp lib/pure/unidecode/gen.py $libdir/pure/unidecode/gen.py
  chmod 644 $libdir/pure/unidecode/gen.py
  cp lib/pure/unidecode/unidecode.nim $libdir/pure/unidecode/unidecode.nim
  chmod 644 $libdir/pure/unidecode/unidecode.nim
  cp lib/pure/unidecode/unidecode.dat $libdir/pure/unidecode/unidecode.dat
  chmod 644 $libdir/pure/unidecode/unidecode.dat
  cp lib/pure/asyncfutures.nim $libdir/pure/asyncfutures.nim
  chmod 644 $libdir/pure/asyncfutures.nim
  cp lib/pure/unicode.nim $libdir/pure/unicode.nim
  chmod 644 $libdir/pure/unicode.nim
  cp lib/pure/volatile.nim $libdir/pure/volatile.nim
  chmod 644 $libdir/pure/volatile.nim
  cp lib/pure/lenientops.nim $libdir/pure/lenientops.nim
  chmod 644 $libdir/pure/lenientops.nim
  cp lib/pure/strutils.nim $libdir/pure/strutils.nim
  chmod 644 $libdir/pure/strutils.nim
  cp lib/pure/strmisc.nim $libdir/pure/strmisc.nim
  chmod 644 $libdir/pure/strmisc.nim
  cp lib/pure/reservedmem.nim $libdir/pure/reservedmem.nim
  chmod 644 $libdir/pure/reservedmem.nim
  cp lib/pure/asyncmacro.nim $libdir/pure/asyncmacro.nim
  chmod 644 $libdir/pure/asyncmacro.nim
  cp lib/pure/oids.nim $libdir/pure/oids.nim
  chmod 644 $libdir/pure/oids.nim
  cp lib/pure/json.nim $libdir/pure/json.nim
  chmod 644 $libdir/pure/json.nim
  cp lib/pure/browsers.nim $libdir/pure/browsers.nim
  chmod 644 $libdir/pure/browsers.nim
  cp lib/pure/ssl_config.nim $libdir/pure/ssl_config.nim
  chmod 644 $libdir/pure/ssl_config.nim
  cp lib/pure/base64.nim $libdir/pure/base64.nim
  chmod 644 $libdir/pure/base64.nim
  cp lib/pure/htmlgen.nim $libdir/pure/htmlgen.nim
  chmod 644 $libdir/pure/htmlgen.nim
  cp lib/pure/xmlparser.nim $libdir/pure/xmlparser.nim
  chmod 644 $libdir/pure/xmlparser.nim
  cp lib/pure/strformat.nim $libdir/pure/strformat.nim
  chmod 644 $libdir/pure/strformat.nim
  cp lib/pure/asynchttpserver.nim $libdir/pure/asynchttpserver.nim
  chmod 644 $libdir/pure/asynchttpserver.nim
  cp lib/pure/endians.nim $libdir/pure/endians.nim
  chmod 644 $libdir/pure/endians.nim
  cp lib/pure/times.nim $libdir/pure/times.nim
  chmod 644 $libdir/pure/times.nim
  cp lib/pure/cgi.nim $libdir/pure/cgi.nim
  chmod 644 $libdir/pure/cgi.nim
  cp lib/pure/punycode.nim $libdir/pure/punycode.nim
  chmod 644 $libdir/pure/punycode.nim
  cp lib/pure/concurrency/cpuinfo.nim $libdir/pure/concurrency/cpuinfo.nim
  chmod 644 $libdir/pure/concurrency/cpuinfo.nim
  cp lib/pure/concurrency/threadpool.nim.cfg $libdir/pure/concurrency/threadpool.nim.cfg
  chmod 644 $libdir/pure/concurrency/threadpool.nim.cfg
  cp lib/pure/concurrency/threadpool.nim $libdir/pure/concurrency/threadpool.nim
  chmod 644 $libdir/pure/concurrency/threadpool.nim
  cp lib/pure/concurrency/cpuload.nim $libdir/pure/concurrency/cpuload.nim
  chmod 644 $libdir/pure/concurrency/cpuload.nim
  cp lib/pure/concurrency/atomics.nim $libdir/pure/concurrency/atomics.nim
  chmod 644 $libdir/pure/concurrency/atomics.nim
  cp lib/pure/parsejson.nim $libdir/pure/parsejson.nim
  chmod 644 $libdir/pure/parsejson.nim
  cp lib/pure/logging.nim $libdir/pure/logging.nim
  chmod 644 $libdir/pure/logging.nim
  cp lib/pure/nimprof.nim $libdir/pure/nimprof.nim
  chmod 644 $libdir/pure/nimprof.nim
  cp lib/pure/prelude.nim $libdir/pure/prelude.nim
  chmod 644 $libdir/pure/prelude.nim
  cp lib/pure/parsesql.nim $libdir/pure/parsesql.nim
  chmod 644 $libdir/pure/parsesql.nim
  cp lib/pure/colors.nim $libdir/pure/colors.nim
  chmod 644 $libdir/pure/colors.nim
  cp lib/pure/bitops.nim $libdir/pure/bitops.nim
  chmod 644 $libdir/pure/bitops.nim
  cp lib/pure/includes/oserr.nim $libdir/pure/includes/oserr.nim
  chmod 644 $libdir/pure/includes/oserr.nim
  cp lib/pure/includes/unicode_ranges.nim $libdir/pure/includes/unicode_ranges.nim
  chmod 644 $libdir/pure/includes/unicode_ranges.nim
  cp lib/pure/includes/osenv.nim $libdir/pure/includes/osenv.nim
  chmod 644 $libdir/pure/includes/osenv.nim
  cp lib/pure/includes/osseps.nim $libdir/pure/includes/osseps.nim
  chmod 644 $libdir/pure/includes/osseps.nim
  cp lib/pure/nimprof.nim.cfg $libdir/pure/nimprof.nim.cfg
  chmod 644 $libdir/pure/nimprof.nim.cfg
  cp lib/pure/nimtracker.nim $libdir/pure/nimtracker.nim
  chmod 644 $libdir/pure/nimtracker.nim
  cp lib/pure/htmlparser.nim $libdir/pure/htmlparser.nim
  chmod 644 $libdir/pure/htmlparser.nim
  cp lib/pure/typetraits.nim $libdir/pure/typetraits.nim
  chmod 644 $libdir/pure/typetraits.nim
  cp lib/pure/uri.nim $libdir/pure/uri.nim
  chmod 644 $libdir/pure/uri.nim
  cp lib/pure/marshal.nim $libdir/pure/marshal.nim
  chmod 644 $libdir/pure/marshal.nim
  cp lib/pure/streams.nim $libdir/pure/streams.nim
  chmod 644 $libdir/pure/streams.nim
  cp lib/pure/asyncnet.nim $libdir/pure/asyncnet.nim
  chmod 644 $libdir/pure/asyncnet.nim
  cp lib/pure/ioselects/ioselectors_kqueue.nim $libdir/pure/ioselects/ioselectors_kqueue.nim
  chmod 644 $libdir/pure/ioselects/ioselectors_kqueue.nim
  cp lib/pure/ioselects/ioselectors_epoll.nim $libdir/pure/ioselects/ioselectors_epoll.nim
  chmod 644 $libdir/pure/ioselects/ioselectors_epoll.nim
  cp lib/pure/ioselects/ioselectors_poll.nim $libdir/pure/ioselects/ioselectors_poll.nim
  chmod 644 $libdir/pure/ioselects/ioselectors_poll.nim
  cp lib/pure/ioselects/ioselectors_select.nim $libdir/pure/ioselects/ioselectors_select.nim
  chmod 644 $libdir/pure/ioselects/ioselectors_select.nim
  cp lib/pure/fenv.nim $libdir/pure/fenv.nim
  chmod 644 $libdir/pure/fenv.nim
  cp lib/pure/osproc.nim $libdir/pure/osproc.nim
  chmod 644 $libdir/pure/osproc.nim
  cp lib/pure/strtabs.nim $libdir/pure/strtabs.nim
  chmod 644 $libdir/pure/strtabs.nim
  cp lib/pure/asyncstreams.nim $libdir/pure/asyncstreams.nim
  chmod 644 $libdir/pure/asyncstreams.nim
  cp lib/pure/stats.nim $libdir/pure/stats.nim
  chmod 644 $libdir/pure/stats.nim
  cp lib/pure/mimetypes.nim $libdir/pure/mimetypes.nim
  chmod 644 $libdir/pure/mimetypes.nim
  cp lib/pure/asyncdispatch.nim $libdir/pure/asyncdispatch.nim
  chmod 644 $libdir/pure/asyncdispatch.nim
  cp lib/pure/asyncdispatch.nim.cfg $libdir/pure/asyncdispatch.nim.cfg
  chmod 644 $libdir/pure/asyncdispatch.nim.cfg
  cp lib/pure/strscans.nim $libdir/pure/strscans.nim
  chmod 644 $libdir/pure/strscans.nim
  cp lib/pure/rationals.nim $libdir/pure/rationals.nim
  chmod 644 $libdir/pure/rationals.nim
  cp lib/pure/parsexml.nim $libdir/pure/parsexml.nim
  chmod 644 $libdir/pure/parsexml.nim
  cp lib/pure/coro.nimcfg $libdir/pure/coro.nimcfg
  chmod 644 $libdir/pure/coro.nimcfg
  cp lib/pure/net.nim $libdir/pure/net.nim
  chmod 644 $libdir/pure/net.nim
  cp lib/pure/xmltree.nim $libdir/pure/xmltree.nim
  chmod 644 $libdir/pure/xmltree.nim
  cp lib/pure/os.nim $libdir/pure/os.nim
  chmod 644 $libdir/pure/os.nim
  cp lib/pure/ssl_certs.nim $libdir/pure/ssl_certs.nim
  chmod 644 $libdir/pure/ssl_certs.nim
  cp lib/pure/selectors.nim $libdir/pure/selectors.nim
  chmod 644 $libdir/pure/selectors.nim
  cp lib/pure/parsecfg.nim $libdir/pure/parsecfg.nim
  chmod 644 $libdir/pure/parsecfg.nim
  cp lib/pure/ropes.nim $libdir/pure/ropes.nim
  chmod 644 $libdir/pure/ropes.nim
  cp lib/pure/async.nim $libdir/pure/async.nim
  chmod 644 $libdir/pure/async.nim
  cp lib/pure/nativesockets.nim $libdir/pure/nativesockets.nim
  chmod 644 $libdir/pure/nativesockets.nim
  cp lib/pure/lexbase.nim $libdir/pure/lexbase.nim
  chmod 644 $libdir/pure/lexbase.nim
  cp lib/pure/smtp.nim $libdir/pure/smtp.nim
  chmod 644 $libdir/pure/smtp.nim
  cp lib/pure/dynlib.nim $libdir/pure/dynlib.nim
  chmod 644 $libdir/pure/dynlib.nim
  cp lib/pure/mersenne.nim $libdir/pure/mersenne.nim
  chmod 644 $libdir/pure/mersenne.nim
  cp compiler/aliases.nim $nimbleDir/compiler/aliases.nim
  chmod 644 $nimbleDir/compiler/aliases.nim
  cp compiler/ast.nim $nimbleDir/compiler/ast.nim
  chmod 644 $nimbleDir/compiler/ast.nim
  cp compiler/astalgo.nim $nimbleDir/compiler/astalgo.nim
  chmod 644 $nimbleDir/compiler/astalgo.nim
  cp compiler/astmsgs.nim $nimbleDir/compiler/astmsgs.nim
  chmod 644 $nimbleDir/compiler/astmsgs.nim
  cp compiler/bitsets.nim $nimbleDir/compiler/bitsets.nim
  chmod 644 $nimbleDir/compiler/bitsets.nim
  cp compiler/btrees.nim $nimbleDir/compiler/btrees.nim
  chmod 644 $nimbleDir/compiler/btrees.nim
  cp compiler/ccgcalls.nim $nimbleDir/compiler/ccgcalls.nim
  chmod 644 $nimbleDir/compiler/ccgcalls.nim
  cp compiler/ccgexprs.nim $nimbleDir/compiler/ccgexprs.nim
  chmod 644 $nimbleDir/compiler/ccgexprs.nim
  cp compiler/ccgliterals.nim $nimbleDir/compiler/ccgliterals.nim
  chmod 644 $nimbleDir/compiler/ccgliterals.nim
  cp compiler/ccgmerge_unused.nim $nimbleDir/compiler/ccgmerge_unused.nim
  chmod 644 $nimbleDir/compiler/ccgmerge_unused.nim
  cp compiler/ccgreset.nim $nimbleDir/compiler/ccgreset.nim
  chmod 644 $nimbleDir/compiler/ccgreset.nim
  cp compiler/ccgstmts.nim $nimbleDir/compiler/ccgstmts.nim
  chmod 644 $nimbleDir/compiler/ccgstmts.nim
  cp compiler/ccgthreadvars.nim $nimbleDir/compiler/ccgthreadvars.nim
  chmod 644 $nimbleDir/compiler/ccgthreadvars.nim
  cp compiler/ccgtrav.nim $nimbleDir/compiler/ccgtrav.nim
  chmod 644 $nimbleDir/compiler/ccgtrav.nim
  cp compiler/ccgtypes.nim $nimbleDir/compiler/ccgtypes.nim
  chmod 644 $nimbleDir/compiler/ccgtypes.nim
  cp compiler/ccgutils.nim $nimbleDir/compiler/ccgutils.nim
  chmod 644 $nimbleDir/compiler/ccgutils.nim
  cp compiler/cgen.nim $nimbleDir/compiler/cgen.nim
  chmod 644 $nimbleDir/compiler/cgen.nim
  cp compiler/cgendata.nim $nimbleDir/compiler/cgendata.nim
  chmod 644 $nimbleDir/compiler/cgendata.nim
  cp compiler/cgmeth.nim $nimbleDir/compiler/cgmeth.nim
  chmod 644 $nimbleDir/compiler/cgmeth.nim
  cp compiler/closureiters.nim $nimbleDir/compiler/closureiters.nim
  chmod 644 $nimbleDir/compiler/closureiters.nim
  cp compiler/cmdlinehelper.nim $nimbleDir/compiler/cmdlinehelper.nim
  chmod 644 $nimbleDir/compiler/cmdlinehelper.nim
  cp compiler/commands.nim $nimbleDir/compiler/commands.nim
  chmod 644 $nimbleDir/compiler/commands.nim
  cp compiler/concepts.nim $nimbleDir/compiler/concepts.nim
  chmod 644 $nimbleDir/compiler/concepts.nim
  cp compiler/condsyms.nim $nimbleDir/compiler/condsyms.nim
  chmod 644 $nimbleDir/compiler/condsyms.nim
  cp compiler/debuginfo.nim $nimbleDir/compiler/debuginfo.nim
  chmod 644 $nimbleDir/compiler/debuginfo.nim
  cp compiler/debugutils.nim $nimbleDir/compiler/debugutils.nim
  chmod 644 $nimbleDir/compiler/debugutils.nim
  cp compiler/depends.nim $nimbleDir/compiler/depends.nim
  chmod 644 $nimbleDir/compiler/depends.nim
  cp compiler/dfa.nim $nimbleDir/compiler/dfa.nim
  chmod 644 $nimbleDir/compiler/dfa.nim
  cp compiler/docgen.nim $nimbleDir/compiler/docgen.nim
  chmod 644 $nimbleDir/compiler/docgen.nim
  cp compiler/docgen2.nim $nimbleDir/compiler/docgen2.nim
  chmod 644 $nimbleDir/compiler/docgen2.nim
  cp compiler/enumtostr.nim $nimbleDir/compiler/enumtostr.nim
  chmod 644 $nimbleDir/compiler/enumtostr.nim
  cp compiler/errorhandling.nim $nimbleDir/compiler/errorhandling.nim
  chmod 644 $nimbleDir/compiler/errorhandling.nim
  cp compiler/evalffi.nim $nimbleDir/compiler/evalffi.nim
  chmod 644 $nimbleDir/compiler/evalffi.nim
  cp compiler/evaltempl.nim $nimbleDir/compiler/evaltempl.nim
  chmod 644 $nimbleDir/compiler/evaltempl.nim
  cp compiler/extccomp.nim $nimbleDir/compiler/extccomp.nim
  chmod 644 $nimbleDir/compiler/extccomp.nim
  cp compiler/filter_tmpl.nim $nimbleDir/compiler/filter_tmpl.nim
  chmod 644 $nimbleDir/compiler/filter_tmpl.nim
  cp compiler/filters.nim $nimbleDir/compiler/filters.nim
  chmod 644 $nimbleDir/compiler/filters.nim
  cp compiler/gorgeimpl.nim $nimbleDir/compiler/gorgeimpl.nim
  chmod 644 $nimbleDir/compiler/gorgeimpl.nim
  cp compiler/guards.nim $nimbleDir/compiler/guards.nim
  chmod 644 $nimbleDir/compiler/guards.nim
  cp compiler/hlo.nim $nimbleDir/compiler/hlo.nim
  chmod 644 $nimbleDir/compiler/hlo.nim
  cp compiler/ic/cbackend.nim $nimbleDir/compiler/ic/cbackend.nim
  chmod 644 $nimbleDir/compiler/ic/cbackend.nim
  cp compiler/ic/rodfiles.nim $nimbleDir/compiler/ic/rodfiles.nim
  chmod 644 $nimbleDir/compiler/ic/rodfiles.nim
  cp compiler/ic/replayer.nim $nimbleDir/compiler/ic/replayer.nim
  chmod 644 $nimbleDir/compiler/ic/replayer.nim
  cp compiler/ic/integrity.nim $nimbleDir/compiler/ic/integrity.nim
  chmod 644 $nimbleDir/compiler/ic/integrity.nim
  cp compiler/ic/packed_ast.nim $nimbleDir/compiler/ic/packed_ast.nim
  chmod 644 $nimbleDir/compiler/ic/packed_ast.nim
  cp compiler/ic/dce.nim $nimbleDir/compiler/ic/dce.nim
  chmod 644 $nimbleDir/compiler/ic/dce.nim
  cp compiler/ic/navigator.nim $nimbleDir/compiler/ic/navigator.nim
  chmod 644 $nimbleDir/compiler/ic/navigator.nim
  cp compiler/ic/design.rst $nimbleDir/compiler/ic/design.rst
  chmod 644 $nimbleDir/compiler/ic/design.rst
  cp compiler/ic/ic.nim $nimbleDir/compiler/ic/ic.nim
  chmod 644 $nimbleDir/compiler/ic/ic.nim
  cp compiler/ic/bitabs.nim $nimbleDir/compiler/ic/bitabs.nim
  chmod 644 $nimbleDir/compiler/ic/bitabs.nim
  cp compiler/idents.nim $nimbleDir/compiler/idents.nim
  chmod 644 $nimbleDir/compiler/idents.nim
  cp compiler/importer.nim $nimbleDir/compiler/importer.nim
  chmod 644 $nimbleDir/compiler/importer.nim
  cp compiler/index.nim $nimbleDir/compiler/index.nim
  chmod 644 $nimbleDir/compiler/index.nim
  cp compiler/injectdestructors.nim $nimbleDir/compiler/injectdestructors.nim
  chmod 644 $nimbleDir/compiler/injectdestructors.nim
  cp compiler/installer.ini $nimbleDir/compiler/installer.ini
  chmod 644 $nimbleDir/compiler/installer.ini
  cp compiler/int128.nim $nimbleDir/compiler/int128.nim
  chmod 644 $nimbleDir/compiler/int128.nim
  cp compiler/isolation_check.nim $nimbleDir/compiler/isolation_check.nim
  chmod 644 $nimbleDir/compiler/isolation_check.nim
  cp compiler/jsgen.nim $nimbleDir/compiler/jsgen.nim
  chmod 644 $nimbleDir/compiler/jsgen.nim
  cp compiler/jstypes.nim $nimbleDir/compiler/jstypes.nim
  chmod 644 $nimbleDir/compiler/jstypes.nim
  cp compiler/lambdalifting.nim $nimbleDir/compiler/lambdalifting.nim
  chmod 644 $nimbleDir/compiler/lambdalifting.nim
  cp compiler/layouter.nim $nimbleDir/compiler/layouter.nim
  chmod 644 $nimbleDir/compiler/layouter.nim
  cp compiler/lexer.nim $nimbleDir/compiler/lexer.nim
  chmod 644 $nimbleDir/compiler/lexer.nim
  cp compiler/liftdestructors.nim $nimbleDir/compiler/liftdestructors.nim
  chmod 644 $nimbleDir/compiler/liftdestructors.nim
  cp compiler/liftlocals.nim $nimbleDir/compiler/liftlocals.nim
  chmod 644 $nimbleDir/compiler/liftlocals.nim
  cp compiler/lineinfos.nim $nimbleDir/compiler/lineinfos.nim
  chmod 644 $nimbleDir/compiler/lineinfos.nim
  cp compiler/linter.nim $nimbleDir/compiler/linter.nim
  chmod 644 $nimbleDir/compiler/linter.nim
  cp compiler/llstream.nim $nimbleDir/compiler/llstream.nim
  chmod 644 $nimbleDir/compiler/llstream.nim
  cp compiler/lookups.nim $nimbleDir/compiler/lookups.nim
  chmod 644 $nimbleDir/compiler/lookups.nim
  cp compiler/lowerings.nim $nimbleDir/compiler/lowerings.nim
  chmod 644 $nimbleDir/compiler/lowerings.nim
  cp compiler/macrocacheimpl.nim $nimbleDir/compiler/macrocacheimpl.nim
  chmod 644 $nimbleDir/compiler/macrocacheimpl.nim
  cp compiler/magicsys.nim $nimbleDir/compiler/magicsys.nim
  chmod 644 $nimbleDir/compiler/magicsys.nim
  cp compiler/main.nim $nimbleDir/compiler/main.nim
  chmod 644 $nimbleDir/compiler/main.nim
  cp compiler/mapping.txt $nimbleDir/compiler/mapping.txt
  chmod 644 $nimbleDir/compiler/mapping.txt
  cp compiler/modulegraphs.nim $nimbleDir/compiler/modulegraphs.nim
  chmod 644 $nimbleDir/compiler/modulegraphs.nim
  cp compiler/modulepaths.nim $nimbleDir/compiler/modulepaths.nim
  chmod 644 $nimbleDir/compiler/modulepaths.nim
  cp compiler/modules.nim $nimbleDir/compiler/modules.nim
  chmod 644 $nimbleDir/compiler/modules.nim
  cp compiler/msgs.nim $nimbleDir/compiler/msgs.nim
  chmod 644 $nimbleDir/compiler/msgs.nim
  cp compiler/ndi.nim $nimbleDir/compiler/ndi.nim
  chmod 644 $nimbleDir/compiler/ndi.nim
  cp compiler/nilcheck.nim $nimbleDir/compiler/nilcheck.nim
  chmod 644 $nimbleDir/compiler/nilcheck.nim
  cp compiler/nim.cfg $nimbleDir/compiler/nim.cfg
  chmod 644 $nimbleDir/compiler/nim.cfg
  cp compiler/nim.nim $nimbleDir/compiler/nim.nim
  chmod 644 $nimbleDir/compiler/nim.nim
  cp compiler/nimblecmd.nim $nimbleDir/compiler/nimblecmd.nim
  chmod 644 $nimbleDir/compiler/nimblecmd.nim
  cp compiler/nimconf.nim $nimbleDir/compiler/nimconf.nim
  chmod 644 $nimbleDir/compiler/nimconf.nim
  cp compiler/nimeval.nim $nimbleDir/compiler/nimeval.nim
  chmod 644 $nimbleDir/compiler/nimeval.nim
  cp compiler/nimfix/prettybase.nim $nimbleDir/compiler/nimfix/prettybase.nim
  chmod 644 $nimbleDir/compiler/nimfix/prettybase.nim
  cp compiler/nimfix/nimfix.nim.cfg $nimbleDir/compiler/nimfix/nimfix.nim.cfg
  chmod 644 $nimbleDir/compiler/nimfix/nimfix.nim.cfg
  cp compiler/nimfix/nimfix.nim $nimbleDir/compiler/nimfix/nimfix.nim
  chmod 644 $nimbleDir/compiler/nimfix/nimfix.nim
  cp compiler/nimlexbase.nim $nimbleDir/compiler/nimlexbase.nim
  chmod 644 $nimbleDir/compiler/nimlexbase.nim
  cp compiler/nimpaths.nim $nimbleDir/compiler/nimpaths.nim
  chmod 644 $nimbleDir/compiler/nimpaths.nim
  cp compiler/nimsets.nim $nimbleDir/compiler/nimsets.nim
  chmod 644 $nimbleDir/compiler/nimsets.nim
  cp compiler/nodejs.nim $nimbleDir/compiler/nodejs.nim
  chmod 644 $nimbleDir/compiler/nodejs.nim
  cp compiler/nversion.nim $nimbleDir/compiler/nversion.nim
  chmod 644 $nimbleDir/compiler/nversion.nim
  cp compiler/optimizer.nim $nimbleDir/compiler/optimizer.nim
  chmod 644 $nimbleDir/compiler/optimizer.nim
  cp compiler/options.nim $nimbleDir/compiler/options.nim
  chmod 644 $nimbleDir/compiler/options.nim
  cp compiler/packagehandling.nim $nimbleDir/compiler/packagehandling.nim
  chmod 644 $nimbleDir/compiler/packagehandling.nim
  cp compiler/packages.nim $nimbleDir/compiler/packages.nim
  chmod 644 $nimbleDir/compiler/packages.nim
  cp compiler/parampatterns.nim $nimbleDir/compiler/parampatterns.nim
  chmod 644 $nimbleDir/compiler/parampatterns.nim
  cp compiler/parser.nim $nimbleDir/compiler/parser.nim
  chmod 644 $nimbleDir/compiler/parser.nim
  cp compiler/passaux.nim $nimbleDir/compiler/passaux.nim
  chmod 644 $nimbleDir/compiler/passaux.nim
  cp compiler/passes.nim $nimbleDir/compiler/passes.nim
  chmod 644 $nimbleDir/compiler/passes.nim
  cp compiler/pathutils.nim $nimbleDir/compiler/pathutils.nim
  chmod 644 $nimbleDir/compiler/pathutils.nim
  cp compiler/patterns.nim $nimbleDir/compiler/patterns.nim
  chmod 644 $nimbleDir/compiler/patterns.nim
  cp compiler/platform.nim $nimbleDir/compiler/platform.nim
  chmod 644 $nimbleDir/compiler/platform.nim
  cp compiler/plugins/locals.nim $nimbleDir/compiler/plugins/locals.nim
  chmod 644 $nimbleDir/compiler/plugins/locals.nim
  cp compiler/plugins/active.nim $nimbleDir/compiler/plugins/active.nim
  chmod 644 $nimbleDir/compiler/plugins/active.nim
  cp compiler/plugins/itersgen.nim $nimbleDir/compiler/plugins/itersgen.nim
  chmod 644 $nimbleDir/compiler/plugins/itersgen.nim
  cp compiler/pluginsupport.nim $nimbleDir/compiler/pluginsupport.nim
  chmod 644 $nimbleDir/compiler/pluginsupport.nim
  cp compiler/pragmas.nim $nimbleDir/compiler/pragmas.nim
  chmod 644 $nimbleDir/compiler/pragmas.nim
  cp compiler/prefixmatches.nim $nimbleDir/compiler/prefixmatches.nim
  chmod 644 $nimbleDir/compiler/prefixmatches.nim
  cp compiler/procfind.nim $nimbleDir/compiler/procfind.nim
  chmod 644 $nimbleDir/compiler/procfind.nim
  cp compiler/readme.md $nimbleDir/compiler/readme.md
  chmod 644 $nimbleDir/compiler/readme.md
  cp compiler/renderer.nim $nimbleDir/compiler/renderer.nim
  chmod 644 $nimbleDir/compiler/renderer.nim
  cp compiler/renderverbatim.nim $nimbleDir/compiler/renderverbatim.nim
  chmod 644 $nimbleDir/compiler/renderverbatim.nim
  cp compiler/reorder.nim $nimbleDir/compiler/reorder.nim
  chmod 644 $nimbleDir/compiler/reorder.nim
  cp compiler/rodutils.nim $nimbleDir/compiler/rodutils.nim
  chmod 644 $nimbleDir/compiler/rodutils.nim
  cp compiler/ropes.nim $nimbleDir/compiler/ropes.nim
  chmod 644 $nimbleDir/compiler/ropes.nim
  cp compiler/saturate.nim $nimbleDir/compiler/saturate.nim
  chmod 644 $nimbleDir/compiler/saturate.nim
  cp compiler/scriptconfig.nim $nimbleDir/compiler/scriptconfig.nim
  chmod 644 $nimbleDir/compiler/scriptconfig.nim
  cp compiler/sem.nim $nimbleDir/compiler/sem.nim
  chmod 644 $nimbleDir/compiler/sem.nim
  cp compiler/semcall.nim $nimbleDir/compiler/semcall.nim
  chmod 644 $nimbleDir/compiler/semcall.nim
  cp compiler/semdata.nim $nimbleDir/compiler/semdata.nim
  chmod 644 $nimbleDir/compiler/semdata.nim
  cp compiler/semexprs.nim $nimbleDir/compiler/semexprs.nim
  chmod 644 $nimbleDir/compiler/semexprs.nim
  cp compiler/semfields.nim $nimbleDir/compiler/semfields.nim
  chmod 644 $nimbleDir/compiler/semfields.nim
  cp compiler/semfold.nim $nimbleDir/compiler/semfold.nim
  chmod 644 $nimbleDir/compiler/semfold.nim
  cp compiler/semgnrc.nim $nimbleDir/compiler/semgnrc.nim
  chmod 644 $nimbleDir/compiler/semgnrc.nim
  cp compiler/seminst.nim $nimbleDir/compiler/seminst.nim
  chmod 644 $nimbleDir/compiler/seminst.nim
  cp compiler/semmacrosanity.nim $nimbleDir/compiler/semmacrosanity.nim
  chmod 644 $nimbleDir/compiler/semmacrosanity.nim
  cp compiler/semmagic.nim $nimbleDir/compiler/semmagic.nim
  chmod 644 $nimbleDir/compiler/semmagic.nim
  cp compiler/semobjconstr.nim $nimbleDir/compiler/semobjconstr.nim
  chmod 644 $nimbleDir/compiler/semobjconstr.nim
  cp compiler/semparallel.nim $nimbleDir/compiler/semparallel.nim
  chmod 644 $nimbleDir/compiler/semparallel.nim
  cp compiler/sempass2.nim $nimbleDir/compiler/sempass2.nim
  chmod 644 $nimbleDir/compiler/sempass2.nim
  cp compiler/semstmts.nim $nimbleDir/compiler/semstmts.nim
  chmod 644 $nimbleDir/compiler/semstmts.nim
  cp compiler/semtempl.nim $nimbleDir/compiler/semtempl.nim
  chmod 644 $nimbleDir/compiler/semtempl.nim
  cp compiler/semtypes.nim $nimbleDir/compiler/semtypes.nim
  chmod 644 $nimbleDir/compiler/semtypes.nim
  cp compiler/semtypinst.nim $nimbleDir/compiler/semtypinst.nim
  chmod 644 $nimbleDir/compiler/semtypinst.nim
  cp compiler/sighashes.nim $nimbleDir/compiler/sighashes.nim
  chmod 644 $nimbleDir/compiler/sighashes.nim
  cp compiler/sigmatch.nim $nimbleDir/compiler/sigmatch.nim
  chmod 644 $nimbleDir/compiler/sigmatch.nim
  cp compiler/sinkparameter_inference.nim $nimbleDir/compiler/sinkparameter_inference.nim
  chmod 644 $nimbleDir/compiler/sinkparameter_inference.nim
  cp compiler/sizealignoffsetimpl.nim $nimbleDir/compiler/sizealignoffsetimpl.nim
  chmod 644 $nimbleDir/compiler/sizealignoffsetimpl.nim
  cp compiler/sourcemap.nim $nimbleDir/compiler/sourcemap.nim
  chmod 644 $nimbleDir/compiler/sourcemap.nim
  cp compiler/spawn.nim $nimbleDir/compiler/spawn.nim
  chmod 644 $nimbleDir/compiler/spawn.nim
  cp compiler/strutils2.nim $nimbleDir/compiler/strutils2.nim
  chmod 644 $nimbleDir/compiler/strutils2.nim
  cp compiler/suggest.nim $nimbleDir/compiler/suggest.nim
  chmod 644 $nimbleDir/compiler/suggest.nim
  cp compiler/syntaxes.nim $nimbleDir/compiler/syntaxes.nim
  chmod 644 $nimbleDir/compiler/syntaxes.nim
  cp compiler/tccgen.nim $nimbleDir/compiler/tccgen.nim
  chmod 644 $nimbleDir/compiler/tccgen.nim
  cp compiler/transf.nim $nimbleDir/compiler/transf.nim
  chmod 644 $nimbleDir/compiler/transf.nim
  cp compiler/trees.nim $nimbleDir/compiler/trees.nim
  chmod 644 $nimbleDir/compiler/trees.nim
  cp compiler/treetab.nim $nimbleDir/compiler/treetab.nim
  chmod 644 $nimbleDir/compiler/treetab.nim
  cp compiler/typeallowed.nim $nimbleDir/compiler/typeallowed.nim
  chmod 644 $nimbleDir/compiler/typeallowed.nim
  cp compiler/types.nim $nimbleDir/compiler/types.nim
  chmod 644 $nimbleDir/compiler/types.nim
  cp compiler/typesrenderer.nim $nimbleDir/compiler/typesrenderer.nim
  chmod 644 $nimbleDir/compiler/typesrenderer.nim
  cp compiler/varpartitions.nim $nimbleDir/compiler/varpartitions.nim
  chmod 644 $nimbleDir/compiler/varpartitions.nim
  cp compiler/vm.nim $nimbleDir/compiler/vm.nim
  chmod 644 $nimbleDir/compiler/vm.nim
  cp compiler/vmconv.nim $nimbleDir/compiler/vmconv.nim
  chmod 644 $nimbleDir/compiler/vmconv.nim
  cp compiler/vmdef.nim $nimbleDir/compiler/vmdef.nim
  chmod 644 $nimbleDir/compiler/vmdef.nim
  cp compiler/vmdeps.nim $nimbleDir/compiler/vmdeps.nim
  chmod 644 $nimbleDir/compiler/vmdeps.nim
  cp compiler/vmgen.nim $nimbleDir/compiler/vmgen.nim
  chmod 644 $nimbleDir/compiler/vmgen.nim
  cp compiler/vmhooks.nim $nimbleDir/compiler/vmhooks.nim
  chmod 644 $nimbleDir/compiler/vmhooks.nim
  cp compiler/vmmarshal.nim $nimbleDir/compiler/vmmarshal.nim
  chmod 644 $nimbleDir/compiler/vmmarshal.nim
  cp compiler/vmops.nim $nimbleDir/compiler/vmops.nim
  chmod 644 $nimbleDir/compiler/vmops.nim
  cp compiler/vmprofiler.nim $nimbleDir/compiler/vmprofiler.nim
  chmod 644 $nimbleDir/compiler/vmprofiler.nim
  cp compiler/wordrecg.nim $nimbleDir/compiler/wordrecg.nim
  chmod 644 $nimbleDir/compiler/wordrecg.nim
  cp doc/basicopt.txt $nimbleDir/doc/basicopt.txt
  chmod 644 $nimbleDir/doc/basicopt.txt
  cp doc/advopt.txt $nimbleDir/doc/advopt.txt
  chmod 644 $nimbleDir/doc/advopt.txt
  cp doc/nimdoc.css $nimbleDir/doc/nimdoc.css
  chmod 644 $nimbleDir/doc/nimdoc.css
cp compiler.nimble $nimbleDir/compiler.nimble
chmod 644 $nimbleDir/compiler.nimble

  echo "installation successful"
else
  echo "Nim installation script"
  echo "Usage: [sudo] sh install.sh DIR"
  echo "Where DIR may be:"
  echo "  /usr/bin"
  echo "  /usr/local/bin"
  echo "  /opt"
  echo "  <some other dir> (treated similar to '/opt')"
  echo "To deinstall, use the command:"
  echo "sh deinstall.sh DIR"
  exit 1
fi

