
#line 3 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 160
#define YY_END_OF_BUFFER 161
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[411] =
    {   0,
        0,    0,  161,  159,  136,   63,  137,  135,  103,  159,
      104,   53,  102,  105,  159,   64,   65,   94,   92,   52,
       93,   56,   96,  140,  154,  132,   51,  116,   91,  117,
      130,  158,   67,   68,  107,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,   69,  106,   70,  108,  158,  158,  158,  136,
      135,    2,  114,    0,  139,    0,   79,  122,   89,    0,
      138,    0,  100,   73,   66,  110,   71,  112,   72,   57,
        0,  157,    0,    1,   98,   75,  157,  141,  154,    0,
        0,    0,    0,  131,  126,  118,   61,  113,   59,  120,

      128,  158,   86,  158,  158,  158,  158,  158,  158,   10,
      158,  158,  158,  158,  158,  158,  158,  158,  158,   11,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,   90,
      124,  109,  133,  134,   95,   97,  158,  158,  158,  158,
      158,  158,  158,  158,  158,    0,    2,  139,   87,  138,
       80,   54,  157,    0,   77,  156,  157,    0,    0,  157,
        0,  146,    0,  142,    0,  150,   82,   84,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,    9,  158,  158,  158,  158,   24,  158,  158,  158,

      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,   19,  158,  158,  158,  158,  158,   88,   74,
       76,   55,  101,   58,   60,  123,  125,  115,  119,  121,
       62,  111,  127,  129,   99,  157,    0,    0,  149,    0,
      149,    0,  145,    0,  145,    0,  153,    0,  153,    0,
        3,   23,  158,   16,  158,  158,  158,  158,   12,   34,
      158,  158,  158,   28,  158,   41,   40,  158,  158,  158,
      158,  158,   22,  158,  158,  158,  158,   26,  158,  158,
      158,  158,  158,  158,  158,   37,  158,  158,  158,   35,
      158,   81,   83,   85,   78,  155,    0,  148,  149,    0,

        0,  149,    0,  144,  145,    0,    0,  145,    0,  152,
      153,    0,    0,  153,   14,   20,    4,  158,  158,  158,
      158,   38,  158,  158,  158,  158,  158,  158,  158,  158,
      158,   45,  158,  158,  158,  158,  158,  158,  158,  158,
       21,  158,   33,    8,  149,    0,    0,  145,    0,    0,
      153,    0,    0,  158,  158,  158,   48,  158,  158,    5,
      158,   43,  158,  158,  158,   47,  158,   18,  158,    6,
       27,   32,   13,   31,  158,  147,  143,  151,  158,   17,
      158,   36,  158,  158,   49,  158,  158,  158,  158,   39,
      158,   15,  158,    7,  158,  158,  158,   25,  158,  158,

       44,  158,   42,   46,   29,  158,   50,  158,   30,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       23,   23,   23,   23,   23,   24,   24,   25,   26,   27,
       28,   29,   30,    1,   31,   31,   31,   31,   32,   31,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   34,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       35,   36,   37,   38,   39,    1,   40,   41,   42,   43,

       44,   45,   46,   47,   48,   33,   49,   50,   51,   52,
       53,   54,   33,   55,   56,   57,   58,   59,   60,   61,
       62,   33,   63,   64,   65,   66,    1,   67,   33,   33,
       33,   33,   33,   68,   69,   70,   71,   72,   33,   33,
       33,   33,   33,   33,   73,   74,   33,   33,   33,   33,
       75,   33,   33,   33,   33,   33,   33,   33,   33,   76,
       77,   78,   33,   79,   80,   81,   82,   83,   33,   84,
       85,   86,   33,   33,   33,   33,   33,   87,   88,   33,
       33,   33,   89,   33,   33,   90,   33,   33,   91,   33,
       33,   33,   33,   92,   93,   33,   33,   33,   33,   33,

       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   94,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33
    } ;

static const YY_CHAR yy_meta[95] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    3,    1,
        4,    4,    4,    4,    1,    1,    1,    1,    1,    1,
        4,    4,    5,    4,    1,    1,    1,    1,    4,    4,
        4,    4,    4,    4,    4,    5,    5,    5,    5,    5,
        5,    5,    5,    4,    5,    5,    5,    5,    5,    5,
        5,    5,    6,    1,    1,    1,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5

    } ;

static const flex_int16_t yy_base[417] =
    {   0,
        0,   93,  789,  790,  790,  790,  790,  790,  760,   89,
      790,  790,  759,   86,   87,  790,  790,   85,   87,  790,
       88,   86,  104,  107,  131,  761,  790,  106,   83,   93,
      790,    0,  790,  790,  757,  726,   49,   87,   92,  106,
      121,  733,  742,  120,  741,   89,   97,  120,  126,  728,
      726,  731,  790,  129,  790,  790,   96,  103,  127,  198,
      199,  790,  790,  155,  790,  178,  790,  749,  790,  154,
      790,  177,  748,  790,  790,  790,  790,  790,  790,  790,
      756,  194,  198,  790,  746,  790,  208,  222,  241,  254,
      229,  260,  265,  790,  745,  790,  790,  790,  790,  790,

      744,    0,  790,  714,  717,  725,  167,  716,  722,    0,
      710,  707,  168,  714,  713,  707,  709,  707,  703,    0,
      704,  700,  717,  704,  704,  700,  711,  151,  196,  700,
      194,  702,  694,  177,  700,  693,  698,  697,  696,  790,
      715,    0,    0,    0,  714,  713,  659,  182,  665,  176,
      215,  666,  647,  223,  645,  309,  790,  262,  790,  280,
      790,  790,  297,  301,  790,  716,  310,  322,  329,  335,
      316,  343,  349,  362,  376,  293,  790,  790,  681,  683,
      692,  687,  688,  246,  689,  684,  676,  682,  681,  668,
      679,   94,  680,  680,  681,  666,    0,  661,  673,  654,

      658,  664,  657,  664,  661,  652,  669,  651,  319,  650,
      662,  661,    0,  643,  658,  645,  645,  632,  790,  790,
      790,    0,  651,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  650,  648,  647,  346,  655,  401,  370,  374,
      409,  428,  415,  434,  442,  461,  408,  467,  441,  497,
        0,    0,  624,    0,  625,  614,  622,  611,    0,    0,
      614,  615,  622,    0,  617,    0,  607,  623,  611,  606,
      591,  596,    0,  606,  601,  604,  592,    0,  588,  588,
      593,  588,  588,  576,  570,    0,  551,  564,  553,    0,
      555,  790,  790,  790,  790,  790,  475,  579,  495,  448,

      502,  507,  521,  568,  527,  530,  533,  540,  552,  566,
      546,  580,  592,  605,    0,    0,    0,  530,  531,  521,
      534,    0,  524,  520,  517,  503,  488,  484,  483,  493,
      491,    0,  480,  470,  456,  460,  455,  437,  446,  449,
        0,  432,    0,    0,  361,  439,  567,  436,  426,  612,
      281,  424,  615,  377,  377,  384,    0,  377,  374,    0,
      375,    0,  367,  370,  347,    0,  363,    0,  336,    0,
        0,    0,    0,    0,  341,  790,  790,  790,  286,    0,
      327,    0,  324,  328,    0,  321,  304,  289,  273,    0,
      256,    0,  238,    0,  230,  223,  199,    0,  184,  157,

        0,  132,    0,    0,    0,  106,    0,   66,    0,  790,
      680,  686,  689,  692,  693,  697
    } ;

static const flex_int16_t yy_def[417] =
    {   0,
      410,    1,  410,  410,  410,  410,  410,  410,  410,  411,
      410,  410,  410,  410,  412,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  413,  410,  410,  410,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  410,  410,  410,  410,  413,  413,  413,  410,
      410,  410,  410,  411,  410,  411,  410,  410,  410,  412,
      410,  412,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  413,  410,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  410,
      410,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  410,  410,  411,  410,  412,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  414,  410,  410,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,

      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  410,  410,
      410,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  415,  410,  416,  410,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      416,  410,  410,  410,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  410,  410,  410,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,
      413,  413,  413,  413,  413,  413,  413,  413,  413,  413,

      413,  413,  413,  413,  413,  413,  413,  413,  413,    0,
      410,  410,  410,  410,  410,  410
    } ;

static const flex_int16_t yy_nxt[885] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   25,   25,   26,   27,   28,   29,   30,   31,
       32,   32,   32,   32,   33,    4,   34,   35,   32,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   32,   32,
       32,   45,   32,   46,   47,   48,   49,   50,   51,   52,
       32,   32,   53,   54,   55,   56,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   57,   58,   59,   60,   65,   68,   61,   71,   73,

       62,  105,   76,  106,   81,   78,   82,   82,   82,   82,
       98,   99,   74,   69,   77,   79,   80,  409,   84,   75,
      100,  101,   72,   85,   66,   87,  107,   88,   88,   88,
       89,   86,   95,   96,   97,  109,  128,  265,   90,  108,
      129,  125,  266,  126,  110,   88,  127,   91,   83,   87,
       90,   89,   89,   89,   89,  111,  140,  112,  408,   92,
      114,   65,   90,  130,  120,   71,  113,   93,  115,   89,
      121,  122,  133,  116,   90,  123,  131,  145,  117,  132,
      134,  142,  143,  144,  158,  135,  407,  136,  160,   72,
       66,  146,  141,  147,  148,  149,  150,  151,  203,  156,

      156,  152,  156,  156,  406,  157,  157,  204,  153,  188,
      154,  155,   72,   66,  163,  163,  163,  163,  164,  164,
      164,  164,  182,  183,  189,   90,  166,  405,  167,  167,
      167,  167,  163,  208,  212,  205,  164,   90,  213,   90,
       87,  404,   88,   88,   88,   89,  167,  171,  209,  172,
      172,   90,  206,   90,  223,  224,   83,  226,  227,   87,
       88,   89,   89,   89,   89,   90,  403,  172,   65,  169,
      168,  169,   90,  402,  170,  170,  170,  170,  173,   89,
      174,  174,  174,  175,   90,  176,  176,  176,  176,  401,
      228,   71,  170,  229,  230,  176,  176,   66,  174,  233,

      234,  256,  257,  176,  176,  176,  176,  176,  176,  176,
      156,  249,  400,  156,  250,   72,  157,  163,  163,  163,
      163,  164,  164,  164,  164,  391,  250,  399,   90,  392,
      167,  167,  167,  167,  250,  163,  239,  239,  398,  164,
       90,   90,  238,  238,  238,  238,  250,  397,  167,  170,
      170,  170,  170,   90,  239,  170,  170,  170,  170,   83,
      238,  241,  396,  172,  172,  236,  282,  170,  395,  243,
      243,  243,  168,  170,  242,  394,  283,   90,  240,  393,
      245,  172,  174,  174,  174,  390,  242,  243,  389,   90,
      239,  239,  242,  246,  297,  297,  247,  247,  247,  247,

      174,  242,  388,  387,  242,  246,  247,  247,  239,  386,
      385,  244,  297,  242,  247,  247,  247,  247,  247,  247,
      247,  238,  238,  238,  238,  384,  383,  298,  382,  299,
      299,  381,  240,  380,  379,  243,  243,  243,  248,  238,
      242,  250,  378,  301,  377,  301,  246,  299,  302,  302,
      302,  302,  242,  243,  303,  303,  303,  376,  246,  310,
      304,  250,  305,  305,  305,  236,  302,  246,  347,  347,
      248,  300,  303,  246,  250,  375,  307,  244,  307,  246,
      305,  308,  308,  308,  308,  246,  347,  309,  309,  309,
      309,  374,  373,  372,  250,  297,  297,  309,  309,  308,

      371,  370,  369,  312,  306,  309,  309,  309,  309,  309,
      309,  309,  313,  297,  313,  299,  299,  314,  314,  314,
      314,  368,  302,  302,  302,  302,  242,  302,  302,  302,
      302,  367,  366,  299,  365,  314,  364,  363,  242,  345,
      302,  303,  303,  303,  362,  302,  361,  305,  305,  305,
      350,  350,  350,  308,  308,  308,  308,  300,  246,  303,
      308,  308,  308,  308,  410,  305,  360,  359,  350,  358,
      246,  308,  309,  309,  309,  309,  357,  356,  308,  250,
      355,  354,  309,  309,  352,  348,  349,  347,  347,  306,
      309,  309,  309,  309,  309,  309,  309,  346,  344,  250,

      353,  353,  353,  353,  343,  347,  342,  341,  312,  340,
      353,  353,  314,  314,  314,  314,  351,  339,  353,  353,
      353,  353,  353,  353,  353,  314,  314,  314,  314,  338,
      314,  345,  350,  350,  350,  353,  353,  353,  353,  337,
      336,  335,  334,  314,  333,  353,  353,  332,  331,  330,
      350,  329,  328,  353,  353,  353,  353,  353,  353,  353,
      327,  326,  325,  324,  323,  322,  321,  320,  319,  318,
      317,  316,  315,  296,  295,  294,  348,  293,  292,  351,
       64,  291,   64,   64,   64,   64,   70,  290,   70,   70,
       70,   70,  102,  102,  176,  176,  247,  289,  247,  311,

      311,  288,  311,  287,  286,  285,  284,  281,  280,  279,
      278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
      268,  267,  264,  263,  262,  261,  260,  259,  258,  255,
      254,  253,  252,  251,  237,  235,  232,  231,  225,  222,
      221,  220,  219,  218,  217,  216,  215,  214,  211,  210,
      207,  202,  201,  200,  199,  198,  197,  196,  195,  194,
      193,  192,  191,  190,  187,  186,  185,  184,  181,  180,
      179,  178,  177,  165,  162,  161,  159,  139,  138,  137,
      124,  119,  118,  104,  103,   94,   67,   63,  410,    3,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410
    } ;

static const flex_int16_t yy_chk[885] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    2,   10,   14,    2,   15,   18,

        2,   37,   19,   37,   22,   21,   22,   22,   22,   22,
       29,   29,   18,   14,   19,   21,   21,  408,   23,   18,
       30,   30,   15,   23,   10,   24,   38,   24,   24,   24,
       24,   23,   28,   28,   28,   39,   47,  192,   24,   38,
       47,   46,  192,   46,   39,   24,   46,   24,   22,   25,
       24,   25,   25,   25,   25,   40,   54,   40,  406,   24,
       41,   64,   25,   48,   44,   70,   40,   24,   41,   25,
       44,   44,   49,   41,   25,   44,   48,   58,   41,   48,
       49,   57,   57,   57,   66,   49,  402,   49,   72,   70,
       64,   58,   54,   59,   59,   59,   59,   59,  128,   60,

       61,   59,   60,   61,  400,   60,   61,  128,   59,  113,
       59,   59,   72,   66,   82,   82,   82,   82,   83,   83,
       83,   83,  107,  107,  113,   82,   87,  399,   87,   87,
       87,   87,   82,  131,  134,  129,   83,   82,  134,   87,
       88,  397,   88,   88,   88,   88,   87,   91,  131,   91,
       91,   87,  129,   88,  148,  148,   82,  150,  150,   89,
       88,   89,   89,   89,   89,   88,  396,   91,  158,   90,
       87,   90,   89,  395,   90,   90,   90,   90,   92,   89,
       92,   92,   92,   93,   89,   93,   93,   93,   93,  393,
      151,  160,   90,  151,  151,   93,   93,  158,   92,  154,

      154,  184,  184,   93,   93,   93,   93,   93,   93,   93,
      156,  176,  391,  156,  351,  160,  156,  163,  163,  163,
      163,  164,  164,  164,  164,  379,  176,  389,  163,  379,
      167,  167,  167,  167,  351,  163,  171,  171,  388,  164,
      163,  167,  168,  168,  168,  168,  176,  387,  167,  169,
      169,  169,  169,  167,  171,  170,  170,  170,  170,  163,
      168,  172,  386,  172,  172,  164,  209,  169,  384,  173,
      173,  173,  167,  170,  172,  383,  209,  236,  171,  381,
      174,  172,  174,  174,  174,  375,  172,  173,  369,  236,
      239,  239,  345,  174,  240,  240,  175,  175,  175,  175,

      174,  239,  367,  365,  345,  174,  175,  175,  239,  364,
      363,  173,  240,  239,  175,  175,  175,  175,  175,  175,
      175,  238,  238,  238,  238,  361,  359,  241,  358,  241,
      241,  356,  239,  355,  354,  243,  243,  243,  175,  238,
      241,  247,  352,  242,  349,  242,  243,  241,  242,  242,
      242,  242,  241,  243,  244,  244,  244,  346,  243,  249,
      245,  247,  245,  245,  245,  238,  242,  348,  300,  300,
      247,  241,  244,  245,  249,  342,  246,  243,  246,  348,
      245,  246,  246,  246,  246,  245,  300,  248,  248,  248,
      248,  340,  339,  338,  249,  297,  297,  248,  248,  246,

      337,  336,  335,  249,  245,  248,  248,  248,  248,  248,
      248,  248,  250,  297,  250,  299,  299,  250,  250,  250,
      250,  334,  301,  301,  301,  301,  299,  302,  302,  302,
      302,  333,  331,  299,  330,  250,  329,  328,  299,  297,
      301,  303,  303,  303,  327,  302,  326,  305,  305,  305,
      306,  306,  306,  307,  307,  307,  307,  299,  305,  303,
      308,  308,  308,  308,  311,  305,  325,  324,  306,  323,
      305,  307,  309,  309,  309,  309,  321,  320,  308,  311,
      319,  318,  309,  309,  310,  303,  304,  347,  347,  305,
      309,  309,  309,  309,  309,  309,  309,  298,  291,  311,

      312,  312,  312,  312,  289,  347,  288,  287,  311,  285,
      312,  312,  313,  313,  313,  313,  309,  284,  312,  312,
      312,  312,  312,  312,  312,  314,  314,  314,  314,  283,
      313,  347,  350,  350,  350,  353,  353,  353,  353,  282,
      281,  280,  279,  314,  277,  353,  353,  276,  275,  274,
      350,  272,  271,  353,  353,  353,  353,  353,  353,  353,
      270,  269,  268,  267,  265,  263,  262,  261,  258,  257,
      256,  255,  253,  237,  235,  234,  350,  233,  223,  353,
      411,  218,  411,  411,  411,  411,  412,  217,  412,  412,
      412,  412,  413,  413,  414,  414,  415,  216,  415,  416,

      416,  215,  416,  214,  212,  211,  210,  208,  207,  206,
      205,  204,  203,  202,  201,  200,  199,  198,  196,  195,
      194,  193,  191,  190,  189,  188,  187,  186,  185,  183,
      182,  181,  180,  179,  166,  155,  153,  152,  149,  147,
      146,  145,  141,  139,  138,  137,  136,  135,  133,  132,
      130,  127,  126,  125,  124,  123,  122,  121,  119,  118,
      117,  116,  115,  114,  112,  111,  109,  108,  106,  105,
      104,  101,   95,   85,   81,   73,   68,   52,   51,   50,
       45,   43,   42,   36,   35,   26,   13,    9,    3,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,

      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410,  410,  410,  410,  410,  410,  410,
      410,  410,  410,  410
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"
#line 2 "lex.l"

/*
 * Copyright © 1988-2004 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#include	"nickle.h"
#include	"gram.h"
#include	"ref.h"
#include	<ctype.h>
#include	<strings.h>
#include	<errno.h>
#ifdef HAVE_LIBREADLINE
#include	READLINE_H
#include	HISTORY_H
#endif
    
typedef struct _lexInput {
    DataType		data;
    struct _lexInput	*next;
    Value		file;
    Atom		name;
    int			lineno;
    Bool		at_bol;
    Bool		at_eof;
    Bool		interactive;
} LexInput;

LexInput    *lexInput;
extern int  ignorenl;
extern int  notCommand;
extern int  seeComment;
#define	    FILE_END_CHAR	-2
    
static void lexInputMark (void *object)
{
    LexInput *lex = object;
    
    MemReference (lex->next);
    MemReference (lex->file);
}

static DataType lexInputType = {
    lexInputMark, 0, "lexInputType"
};

void
NewLexInput (Value file, Atom name, Bool after, Bool interactive)
{
    ENTER ();
    LexInput	*lex;

    lex = MemAllocate (&lexInputType, sizeof (*lex));
    lex->file = file;
    lex->name = name;
    lex->lineno = 0;
    lex->at_bol = True;
    lex->at_eof = False;
    lex->interactive = interactive;
    if (after)
    {
	LexInput **prev;
	
	for (prev = &lexInput; *prev; prev = &(*prev)->next)
	    ;
	lex->next = 0;
	*prev = lex;
    } else {
	lex->next = lexInput;
	lexInput = lex;
    }
    EXIT ();
}

#ifdef HAVE_LIBREADLINE

volatile int stdin_in_readline;

static void
my_prep_terminal(int meta_flag)
{
    stdin_in_readline = 1;
    rl_prep_terminal(meta_flag);
}

static void
my_deprep_terminal(void)
{
    rl_deprep_terminal();
    stdin_in_readline = 0;
}

static int
LexGetChar (void);

static int
ReadlineGetChar (FILE *f)
{
    return LexGetChar ();
}
#endif

ReferencePtr	LexInputReference;

void
LexInit (void)
{
    ENTER ();

#if HAVE_LIBREADLINE
    rl_getc_function = ReadlineGetChar;
    rl_prep_term_function = (void *) my_prep_terminal;
    rl_deprep_term_function = my_deprep_terminal;
    rl_catch_signals = 0;
#endif
    LexInputReference = NewReference ((void **) &lexInput);
    MemAddRoot (LexInputReference);
    EXIT ();
}

Atom
LexFileName (void)
{
    if (lexInput)
	return lexInput->name;
    return AtomId ("<initialization>");
}

int
LexFileLine (void)
{
    if (lexInput)
	return lexInput->lineno;
    return 0;
}

Bool
LexInteractive (void)
{
    if (lexInput)
	return lexInput->interactive;
    return False;
}

Bool
LexResetInteractive (void)
{
    while (lexInput->next && !lexInput->interactive)
    {
	FileClose (lexInput->file);
	lexInput = lexInput->next;
    }
    if (lexInput->interactive)
	return True;
    return False;
}

Bool
LexFile (char *s, Bool complain, Bool after)
{
    Value	f;
    int		err;

    f = FileFopen (s, "r", &err);
    if (f == 0) {
	if (complain)
	    (void) FilePrintf (FileStderr, "%s: %s\n",
			       s, StringChars (&FileGetErrorMessage (err)->string));
	return False;
    }
    (void) NewLexInput(f, AtomId (s), after, False);
    return True;
}

static int
LexGetChar (void)
{
    int	    c;

    for (;;)
    {
	c = FileInput (lexInput->file);
	if (c >= 0)
	    return c;
	if (c == FileBlocked)
	    ThreadsRun (0, lexInput->file);
	else
	{
	    if (!lexInput->next)
		return FileEOF;
	    lexInput->at_eof = True;
	    return '\n';
	}
    }
}

static Value
prompt (void)
{
    Value	v;
    
    if (ignorenl)
	v = lookupVar (0, "prompt2");
    else if (CurrentFrame)
	v = lookupVar (0, "prompt3");
    else
	v = lookupVar (0, "prompt");
    return v;
}

static int
LexGetInteractiveChar (void)
{
#ifdef HAVE_LIBREADLINE
    static char	*line, *line_base;
    int	    c;

    if (!line)
    {
	char    *p;

	p = StrzPart (prompt (), "invalid prompt");
	if (!p)
	    p = "??? ";
	for (;;)
	{
	    FileFlush (FileStdout, False);
	    FileFlush (FileStderr, False);
	    if (FileStdout->file.flags & FileOutputBlocked)
		ThreadsRun (0, FileStdout);
	    else if (FileStderr->file.flags & FileOutputBlocked)
		ThreadsRun (0, FileStderr);
	    else
		break;
	}
	rl_inhibit_completion = 1;
	line_base = readline (p);
	line = line_base;
	if (!line)
	    return FileEOF;
	add_history (line_base);
    }
    c = (*line++) & 0xff;
    if (!c)
    {
	c = '\n';
	free (line_base);
	line = 0;
    }
    return c;
#else
    if (lexInput->at_bol)
    {
	Value	v = prompt ();
	Print (FileStdout, v, 's', 0, 0, 0, ' ');
	FileFlush (FileStdout, True);
    }
    return LexGetChar ();
#endif
}

#undef YY_INPUT
#define YY_NO_UNPUT

static int yy_input (char *buf, int max_size)
{
    int	    c;
    int	    result = 0;
    
    while (result < max_size) {
	if (lexInput->at_eof)
	{
	    FileClose (lexInput->file);
	    lexInput = lexInput->next;
	}
	if (lexInput->interactive)
	    c = LexGetInteractiveChar ();
	else
	    c = LexGetChar ();
	if (lexInput->at_bol) { lexInput->lineno++; }
	lexInput->at_bol = False;
	if (c < 0) 
	    break;
	buf[result++] = c;
	if (c == '\n')
	{
	    lexInput->at_bol = True;
	    break;
	}
    }
    return result;
}

#define YY_INPUT(buf,result,max_size) ((result) = yy_input (buf, max_size))
    
#ifndef FLEX_SCANNER
#undef		input
#undef		unput
int input (void)
{
    char    buf[1];
    int	    r;

    YY_INPUT(buf, r, 1);
    if (r == 0)
	return 0;
    return buf[0];
}

void unput (char c)
{
    if (c == '\n')
	lexInput->lineno--;
    FileUnput (lexInput->file, c);
}
#endif

#line 1096 "lex.c"
#line 1097 "lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 321 "lex.l"

#line 1319 "lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 411 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 790 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 322 "lex.l"
{   
		    if (seeComment) 
		    {
			yylval.value = lexdoc ();
			return COMMENT_CONST;
		    }
		    else
			skipcomment (); 
		}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 331 "lex.l"
skipline();
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 332 "lex.l"
{ yylval.class = class_auto; return AUTO; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 333 "lex.l"
{ yylval.class = class_const; return CONST; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 334 "lex.l"
{ yylval.class = class_global; return GLOBAL; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 335 "lex.l"
{ yylval.class = class_static; return STATIC; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 336 "lex.l"
{ yylval.type = typePrim[rep_void]; return FUNCTION; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 337 "lex.l"
{ yylval.ints = WHILE; return WHILE; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 338 "lex.l"
{ yylval.ints = FOR; return FOR; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 339 "lex.l"
{ yylval.ints = DO; return DO; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 340 "lex.l"
{ yylval.ints = IF; return IF; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 341 "lex.l"
{ yylval.ints = ELSE; return ELSE; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 342 "lex.l"
{ yylval.ints = SWITCH; return SWITCH; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 343 "lex.l"
{ yylval.ints = BREAK; return BREAK; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 344 "lex.l"
{ yylval.ints = CONTINUE; return CONTINUE; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 345 "lex.l"
{ yylval.ints = CASE; return CASE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 346 "lex.l"
{ yylval.ints = DEFAULT; return DEFAULT; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 347 "lex.l"
{ yylval.ints = RETURNTOK; return RETURNTOK; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 348 "lex.l"
{ yylval.ints = TRY; return TRY; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 349 "lex.l"
{ yylval.ints = CATCH; return CATCH; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 350 "lex.l"
{ yylval.ints = TWIXT; return TWIXT; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 352 "lex.l"
{ yylval.type = typePoly; return POLY; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 353 "lex.l"
{ yylval.type = typePrim[rep_bool]; return BOOL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 354 "lex.l"
{ yylval.type = typePrim[rep_integer]; return INTEGER; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 355 "lex.l"
{ yylval.type = typePrim[rep_rational]; return RATIONAL; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 356 "lex.l"
{ yylval.type = typePrim[rep_float]; return REAL; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 357 "lex.l"
{ yylval.type = typePrim[rep_string]; return STRING; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 358 "lex.l"
{ yylval.type = typePrim[rep_file]; return FILET; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 359 "lex.l"
{ yylval.type = typePrim[rep_semaphore]; return SEMAPHORE; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 360 "lex.l"
{ yylval.type = typePrim[rep_continuation]; return CONTINUATION; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 361 "lex.l"
{ yylval.type = typePrim[rep_thread]; return THREAD; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 362 "lex.l"
{ yylval.ints = STRUCT; return STRUCT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 363 "lex.l"
{ yylval.ints = UNION; return UNION; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 364 "lex.l"
{ yylval.ints = ENUM; return ENUM; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 365 "lex.l"
{ yylval.type = typePrim[rep_void]; return VOID; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 366 "lex.l"
{ yylval.type = typePrim[rep_foreign]; return FOREIGN; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 367 "lex.l"
{ yylval.value = TrueVal; return BOOLVAL; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 368 "lex.l"
{ yylval.value = FalseVal; return BOOLVAL; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 370 "lex.l"
{ yylval.ints = TYPEDEF; return TYPEDEF; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 371 "lex.l"
{ yylval.ints = FUNC; return FUNC; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 372 "lex.l"
{ yylval.ints = FORK; return FORK; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 373 "lex.l"
{ yylval.ints = NAMESPACE; return NAMESPACE; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 374 "lex.l"
{ yylval.ints = IMPORT; return IMPORT; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 375 "lex.l"
{ yylval.ints = EXCEPTION; return EXCEPTION; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 376 "lex.l"
{ yylval.ints = RAISE; return RAISE; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 377 "lex.l"
{ yylval.publish = publish_protected; return PROTECTED; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 378 "lex.l"
{ yylval.publish = publish_public; return PUBLIC; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 379 "lex.l"
{ yylval.publish = publish_extend; return EXTEND; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 380 "lex.l"
{ yylval.ints = ISTYPE; return ISTYPE; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 381 "lex.l"
{ yylval.ints = HASMEMBER; return HASMEMBER; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 382 "lex.l"
{ yylval.ints = SEMI; return SEMI; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 383 "lex.l"
{ yylval.ints = COMMA; return COMMA; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 384 "lex.l"
{ yylval.ints = DOLLAR; return DOLLAR; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 385 "lex.l"
{ yylval.ints = DOTDOTDOT; return DOTDOTDOT; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 386 "lex.l"
{ yylval.ints = DOTDOTDOT; return DOTDOTDOT; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 387 "lex.l"
{ yylval.ints = DOT; return DOT; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 388 "lex.l"
{ yylval.ints = ARROW; return ARROW; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 389 "lex.l"
{ yylval.ints = ARROW; return ARROW; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 390 "lex.l"
{ yylval.ints = DARROW; return DARROW; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 391 "lex.l"
{ yylval.ints = DARROW; return DARROW; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 392 "lex.l"
{ yylval.value = Void; return VOIDVAL; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 393 "lex.l"
{ yylval.value = Void; return VOIDVAL; }
	YY_BREAK
case 63:
/* rule 63 can match eol */
YY_RULE_SETUP
#line 394 "lex.l"
{ 
		    if (lexInput->at_eof) { strcpy (yytext, "EOF"); yylval.ints = ENDFILE; return ENDFILE; }
		    if (!ignorenl) { yylval.ints = NL; return NL; } 
		}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 398 "lex.l"
{ yylval.ints = OP; ++ignorenl; return OP; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 399 "lex.l"
{ yylval.ints = CP; if (ignorenl > 0) --ignorenl; return CP; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 400 "lex.l"
{ yylval.ints = STAROS; ++ignorenl; return STAROS; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 401 "lex.l"
{ yylval.ints = OS; ++ignorenl; return OS; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 402 "lex.l"
{ yylval.ints = CS; if (ignorenl > 0) --ignorenl; return CS; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 403 "lex.l"
{ yylval.ints = OC; ++ignorenl; return OC; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 404 "lex.l"
{ yylval.ints = CC; if (ignorenl > 0) --ignorenl; return CC; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 405 "lex.l"
{ yylval.ints = ASSIGNPLUS; return ASSIGNPLUS; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 406 "lex.l"
{ yylval.ints = ASSIGNMINUS; return ASSIGNMINUS; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 407 "lex.l"
{ yylval.ints = ASSIGNTIMES; return ASSIGNTIMES; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 408 "lex.l"
{ yylval.ints = ASSIGNTIMES; return ASSIGNTIMES; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 409 "lex.l"
{ yylval.ints = ASSIGNDIVIDE; return ASSIGNDIVIDE; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 410 "lex.l"
{ yylval.ints = ASSIGNDIVIDE; return ASSIGNDIVIDE; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 411 "lex.l"
{ yylval.ints = ASSIGNDIV; return ASSIGNDIV; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 412 "lex.l"
{ yylval.ints = ASSIGNDIV; return ASSIGNDIV; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 413 "lex.l"
{ yylval.ints = ASSIGNMOD; return ASSIGNMOD; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 414 "lex.l"
{ yylval.ints = ASSIGNPOW; return ASSIGNPOW; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 415 "lex.l"
{ yylval.ints = ASSIGNPOW; return ASSIGNPOW; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 416 "lex.l"
{ yylval.ints = ASSIGNSHIFTL; return ASSIGNSHIFTL; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 417 "lex.l"
{ yylval.ints = ASSIGNSHIFTL; return ASSIGNSHIFTL; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 418 "lex.l"
{ yylval.ints = ASSIGNSHIFTR; return ASSIGNSHIFTR; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 419 "lex.l"
{ yylval.ints = ASSIGNSHIFTR; return ASSIGNSHIFTR; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 420 "lex.l"
{ yylval.ints = ASSIGNLXOR; return ASSIGNLXOR; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 421 "lex.l"
{ yylval.ints = ASSIGNAND; return ASSIGNAND; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 422 "lex.l"
{ yylval.ints = ASSIGNOR; return ASSIGNOR; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 423 "lex.l"
{ yylval.ints = ASSIGNLAND; return ASSIGNLAND; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 424 "lex.l"
{ yylval.ints = ASSIGNLOR; return ASSIGNLOR; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 425 "lex.l"
{ yylval.ints = ASSIGN; return ASSIGN; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 427 "lex.l"
{ yylval.ints = PLUS; return PLUS; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 428 "lex.l"
{ yylval.ints = MINUS; return MINUS; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 429 "lex.l"
{ yylval.ints = TIMES; return TIMES; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 430 "lex.l"
{ yylval.ints = TIMES; return TIMES; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 431 "lex.l"
{ yylval.ints = DIVIDE; return DIVIDE; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 432 "lex.l"
{ yylval.ints = DIVIDE; return DIVIDE; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 433 "lex.l"
{ yylval.ints = DIV; return DIV; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 434 "lex.l"
{ yylval.ints = DIV; return DIV; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 435 "lex.l"
{ yylval.ints = STARSTAR; return STARSTAR; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 436 "lex.l"
{ yylval.ints = STARSTAR; return STARSTAR; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 437 "lex.l"
{ yylval.ints = MOD; return MOD; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 438 "lex.l"
{ yylval.ints = BANG; return BANG; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 439 "lex.l"
{ yylval.ints = POUND; return POUND; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 440 "lex.l"
{ yylval.ints = LAND; return LAND; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 441 "lex.l"
{ yylval.ints = LOR; return LOR; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 442 "lex.l"
{ yylval.ints = LXOR; return LXOR; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 443 "lex.l"
{ yylval.ints = LNOT; return LNOT; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 444 "lex.l"
{ yylval.ints = LNOT; return LNOT; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 445 "lex.l"
{ yylval.ints = INC; return INC; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 446 "lex.l"
{ yylval.ints = INC; return INC; }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 447 "lex.l"
{ yylval.ints = DEC; return DEC; }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 448 "lex.l"
{ yylval.ints = EQ; return EQ; }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 449 "lex.l"
{ yylval.ints = NE; return NE; }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 450 "lex.l"
{ yylval.ints = NE; return NE; }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 451 "lex.l"
{ yylval.ints = LT; return LT; }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 452 "lex.l"
{ yylval.ints = GT; return GT; }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 453 "lex.l"
{ yylval.ints = LE; return LE; }
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 454 "lex.l"
{ yylval.ints = LE; return LE; }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 455 "lex.l"
{ yylval.ints = GE; return GE; }
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 456 "lex.l"
{ yylval.ints = GE; return GE; }
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 457 "lex.l"
{ yylval.ints = AND; return AND; }
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 458 "lex.l"
{ yylval.ints = AND; return AND; }
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 459 "lex.l"
{ yylval.ints = OR; return OR; }
	YY_BREAK
case 125:
YY_RULE_SETUP
#line 460 "lex.l"
{ yylval.ints = OR; return OR; }
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 461 "lex.l"
{ yylval.ints = SHIFTL; return SHIFTL; }
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 462 "lex.l"
{ yylval.ints = SHIFTL; return SHIFTL; }
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 463 "lex.l"
{ yylval.ints = SHIFTR; return SHIFTR; }
	YY_BREAK
case 129:
YY_RULE_SETUP
#line 464 "lex.l"
{ yylval.ints = SHIFTR; return SHIFTR; }
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 465 "lex.l"
{ yylval.ints = QUEST; return QUEST; }
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 466 "lex.l"
{ yylval.ints = COLONCOLON; return COLONCOLON; }
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 467 "lex.l"
{ yylval.ints = COLON; return COLON; }
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 468 "lex.l"
{ yylval.ints = POW2; return POW2; }
	YY_BREAK
case 134:
YY_RULE_SETUP
#line 469 "lex.l"
{ yylval.ints = POW3; return POW3; }
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 470 "lex.l"
;
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 471 "lex.l"
;
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 472 "lex.l"
;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 473 "lex.l"
{
			ENTER ();
			char	    *s;
			long	    len = yyleng - 1;
			unsigned    c;

			s = yytext + 1;
			s = StringNextChar (s, &c, &len);
			if (c == '\\')
			{
			    if (!(s = StringNextChar (s, &c, &len)))
				c = 0;
			    else if ('0' <= c && c <= '7')
			    {
				unsigned    ch;
				char	    *ps = s;

				c = c - '0';
				while ((s = StringNextChar (s, &ch, &len)) &&
				       '0' <= ch && ch <= '7')
				{
				    c = (c << 3) | (ch - '0');
				    ps = s;
				}
				s = ps;
			    }
			    else
				c = lexEscape (c);
			}
			yylval.value = NewInt (c);
			EXIT ();
			REFERENCE (yylval.value);
			return CHAR_CONST;
		}
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 507 "lex.l"
{
			ENTER ();
			char	    *d, *s;
			unsigned    c;
			long	    len = yyleng - 2;

			yylval.value = NewString (len);
			d = StringChars (&yylval.value->string);
			s = yytext + 1;
			while ((s = StringNextChar (s, &c, &len)))
			{
			    if (c == '\\')
			    {
				if (!(s = StringNextChar (s, &c, &len)))
				    break;
				if ('0' <= c && c <= '7')
				{
				    unsigned	ch;
    				    char	*ps = s;
				    long	plen = len;

				    c = c - '0';
				    while ((s = StringNextChar (s, &ch, &len)) &&
					   '0' <= ch && ch <= '7')
				    {
					c = (c << 3) | (ch - '0');
					ps = s;
					plen = len;
				    }
				    s = ps;
				    len = plen;
				}
				else
				    c = lexEscape (c);
			    }
			    d += StringPutChar (c, d);
			}
			*d = '\0';
			yylval.value->string.length = d - StringChars(&yylval.value->string);
			EXIT ();
			REFERENCE (yylval.value);
			return STRING_CONST;
		}
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 550 "lex.l"
{
		yylval.value = Zero;
		return TEN_NUM;
		}
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 554 "lex.l"
{
		yylval.value = atov(yytext+1, 8);
		return OCTAL0_NUM;
		}
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 558 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 143:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 562 "lex.l"
{
		yylval.value = aetov(yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 144:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 566 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 570 "lex.l"
{
		yylval.value = aetov (yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 574 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 147:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 578 "lex.l"
{
		yylval.value = aetov(yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 148:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 582 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 586 "lex.l"
{
		yylval.value = aetov (yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 590 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 151:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 594 "lex.l"
{
		yylval.value = aetov(yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 152:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 598 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 602 "lex.l"
{
		yylval.value = aetov (yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 154:
YY_RULE_SETUP
#line 606 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 155:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 610 "lex.l"
{
		yylval.value = aetov(yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 156:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 614 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 157:
YY_RULE_SETUP
#line 618 "lex.l"
{
		yylval.value = aetov (yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 158:
YY_RULE_SETUP
#line 622 "lex.l"
{
	        CommandPtr	c;
		SymbolPtr	symbol;
		yylval.atom = AtomId (yytext);
		if (!notCommand && (c = CommandFind (CurrentCommands, yylval.atom)))
		{
		    if (c->names)
			return NAMECOMMAND;
		    return COMMAND;
		}
		if (LexNamespace)
		    symbol = NamespaceFindName (LexNamespace, yylval.atom, False);
	        else
		    symbol = NamespaceFindName (CurrentNamespace, yylval.atom, True);
		if (symbol)
		{
		    switch (symbol->symbol.class) {
		    case class_namespace:
			return NAMESPACENAME;
		    case class_typedef:
			return TYPENAME;
		    default:
			break;
		    }
		}
		return NAME;
		}
	YY_BREAK
case 159:
YY_RULE_SETUP
#line 649 "lex.l"
FilePrintf (FileStderr, "character \\%o ignored\n", *yytext & 0xff);
	YY_BREAK
case 160:
YY_RULE_SETUP
#line 650 "lex.l"
ECHO;
	YY_BREAK
#line 2368 "lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 411 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 411 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 410);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 650 "lex.l"


int
lexEscape (int c)
{
    switch (c) {
    case '0':
	return '\0';
	break;
    case 'b':
	return '\b';
	break;
    case 'n':
	return '\n';
	break;
    case 'r':
	return '\r';
	break;
    case 't':
	return '\t';
	break;
    case 'f':
	return '\f';
	break;
    case 'v':
	return '\v';
	break;
    default:
	return c;
    }
}


Value
lexdoc (void)
{
    int	    c;
    Value   s = NewStrString ("");

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return Void;
    }
    for (;;) {
	Bool skip = False;
	while (c != EOF && c != '*')
	{
	    if (skip && c != ' ' && c != '\t')
		skip = False;
	    if (!skip)
		s = Plus (s, NewCharString (c));
	    if (c == '\n')
		skip = True;
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    break;
	if (!skip)
	    s = Plus (s, NewCharString ('*'));
    }
    return s;
}

void
skipcomment (void)
{
    int	c;

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return;
    }
    for (;;) {
	while (c != EOF && c != '*')
	{
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    return;
    }
}

void
skipline (void)
{
    int	    c;

    do {
	c = input();
    } while (c != EOF && c != '\n');
}

Value
atov (char *s, int base)
{
    ENTER ();
    Value	result;
    Value	b;
    char	c;
    int		i;

    b = NewInt (base);
    result = NewInt (0);
    for (;;) {
	c = *s++;
	if ('0' <= c  && c <= '9')
	    i = c - '0';
	else if ('a' <= c && c <= 'z')
	    i = c - 'a' + 10;
	else if ('A' <= c && c <= 'Z')
	    i = c - 'A' + 10;
	else if (c == '_')
	    continue;
	else
	    break;
	if (i >= base)
	    break;
	result = Plus (NewInt (i), Times (result, b));
    }
    RETURN (result);
}

static char *
scan_number(char *s, char needle, int *lenp)
{
    int len = 0;
    for (;;) {
	char c = *s;
	if (tolower(c) == needle)
	    break;
	switch (c) {
	case '\0':
	    return NULL;
	case '_':
	    break;
	default:
	    len++;
	    break;
	}
	s++;
    }
    if (lenp)
	*lenp = len;
    return s;
}

static int
number_len(char *s)
{
    int len = 0;
    char c;
    while ((c = *s++))
	if (c != '_')
	    len++;
    return len;
}

Value
aetov (char *s, int base)
{
    ENTER ();
    char    *int_part, *frac_part, *rep_part, *exp_part, *next;
    int	    sign, int_len = -1, frac_len = -1, rep_len = -1, exp_frac_len = -1, esign;
    Value   v, sv;
    char    exp_char;
    int	    exp_base;

    switch (base) {
    case 2:
	exp_char = 'e';
	exp_base = 2;
	break;
    case 8:
	exp_char = 'e';
	exp_base = 2;
	break;
    case 10:
    default:
	exp_char = 'e';
	exp_base = 10;
	break;
    case 16:
	exp_char = 'p';
	exp_base = 2;
	break;
    }
    int_part = s;
    sign = 1;
    if (*int_part == '+')
	int_part++;
    else if (*int_part == '-') {
	int_part++;
	sign = -1;
    }
    next = int_part;
    frac_part = scan_number(next, '.', &int_len);
    frac_len = -1;
    rep_part = 0;
    rep_len = 0;
    esign = 1;
    if (frac_part) {
	frac_part++;
	next = frac_part;
	rep_part = scan_number(next, '{', &frac_len);
	if (rep_part)
	{
	    rep_part++;
	    next = rep_part;
	    next = scan_number(next, '}', &rep_len);
	    if (!next)
		RETURN(Void);	/* can't happen */
	}
    }
    exp_part = scan_number(next, exp_char, &exp_frac_len);
    if (exp_part) {
	if (frac_len < 0)
	    frac_len = exp_frac_len;
	exp_part++;
	if (*exp_part == '+')
	    exp_part++;
	else if (*exp_part == '-') {
	    esign = -1;
	    exp_part++;
	}
    } else if (frac_len < 0 && frac_part)
	frac_len = number_len(frac_part);
    v = atov (int_part, base);
    if (frac_part)
    {
	v = Plus (v, Divide (atov (frac_part, base),
				 Pow (NewInt (base),
				       NewInt (frac_len))));
    }
    if (rep_part)
    {
	Value	rep;

	rep = Divide (atov (rep_part, base), Minus (Pow (NewInt (base),
						       NewInt (rep_len)),
						  One));
	if (frac_len)
	    rep = Divide (rep, Pow (NewInt (base),
				    NewInt (frac_len)));
	v = Plus (v, rep);
    }
    if (exp_part)
    {
	sv = Pow (NewInt (exp_base), atov (exp_part, 10));
	if (esign > 0)
	    v = Times (v, sv);
	else
	    v = Divide (v, sv);
    }
    if (sign == -1)
	v = Negate (v);
    RETURN (v);
}

