/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import java.lang.reflect.Field;

public class SetStaticFieldProc
extends Procedure1
implements Inlineable {
    private Declaration fieldDecl;

    public SetStaticFieldProc(Declaration fieldDecl) {
        this.fieldDecl = fieldDecl;
    }

    @Override
    public Object apply1(Object arg) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        try {
            Field reflectField = field.getReflectField();
            reflectField.set(null, arg);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("no such field " + field.getSourceName() + " in " + field.getDeclaringClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access for field " + field.getSourceName());
        }
        return arg;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        Type fieldType = field.getType();
        Expression arg = exp.getArgs()[0];
        CodeAttr code = comp.getCode();
        boolean ignore = target instanceof IgnoreTarget;
        arg.compile(comp, fieldType);
        if (!ignore) {
            code.emitDup(fieldType.getSize() > 4 ? 2 : 1, 1);
        }
        code.emitPutStatic(field);
        if (!ignore) {
            target.compileFromStack(comp, fieldType);
        }
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return this.fieldDecl.getType();
    }
}

