/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.BindingEnumeration;
import gnu.mapping.ConstantConstraint;
import gnu.mapping.Future;
import gnu.mapping.NameMap;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundConstraint;
import gnu.mapping.UnboundSymbol;

public class Environment
extends NameMap {
    Binding[] table;
    int log2Size = 4;
    private int mask;
    int num_bindings;
    private static Environment global;
    Environment previous;
    boolean locked;
    protected TrivialConstraint trivialConstraint = new TrivialConstraint(this);
    protected UnboundConstraint unboundConstraint = new UnboundConstraint(this);
    protected ConstantConstraint constantConstraint;

    public final boolean isLocked() {
        return this.locked;
    }

    public final void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static Environment user() {
        return Environment.current();
    }

    public static Object lookup_global(String name) throws UnboundSymbol {
        Binding binding = Environment.user().lookup(name);
        if (binding == null) {
            throw new UnboundSymbol(name);
        }
        return binding.get();
    }

    public static void define_global(String name, Object new_value) {
        Environment.user().defineValue(name, new_value);
    }

    public static void defineFunction(String name, Object new_value) {
        Environment.defineFunction(Environment.user(), name, new_value);
    }

    public static void defineFunction(Environment env, String name, Object new_value) {
        Binding binding = env.getBinding(name);
        binding.constraint.setFunctionValue(binding, new_value);
    }

    public static void put_global(String name, Object new_value) {
        Environment.user().put(name, new_value);
    }

    public static Environment current() {
        return Environment.getCurrent();
    }

    public static Environment getCurrent() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return ((Future)thread).environment;
        }
        return global;
    }

    public static void setCurrent(Environment env) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            ((Future)thread).environment = env;
        } else {
            global = env;
        }
    }

    public Environment() {
        this(64);
    }

    public Environment(int capacity) {
        while (capacity > 1 << this.log2Size) {
            ++this.log2Size;
        }
        capacity = 1 << this.log2Size;
        this.table = new Binding[capacity];
        this.mask = capacity - 1;
    }

    public Environment(Environment previous) {
        this();
        this.previous = previous;
    }

    public Binding getBinding(String name) {
        Binding binding = this.lookup(name);
        if (binding != null) {
            return binding;
        }
        binding = this.addBinding(name, null);
        binding.constraint = this.unboundConstraint;
        return binding;
    }

    public static Binding getCurrentBinding(String name) {
        return Environment.getCurrent().getBinding(name);
    }

    public Binding lookup(String name) {
        return this.lookup(name, System.identityHashCode(name));
    }

    private Binding lookup(String name, int hash) {
        Environment env = this;
        while (env != null) {
            int index = Binding.hashSearch(env.table, env.log2Size, env.mask, name, hash);
            Binding element = env.table[index];
            if (element != null && element != Binding.hashDELETED) {
                return element;
            }
            env = env.previous;
        }
        return null;
    }

    public Binding defineValue(String name, Object value) {
        Binding binding = this.getBinding(name);
        binding.constraint = this.trivialConstraint;
        binding.value = value;
        return binding;
    }

    public Binding define(String name, Object value) {
        return this.defineValue(name, value);
    }

    public void addBinding(Binding binding) {
        if (3 * this.num_bindings >= 2 * this.table.length) {
            this.rehash();
        }
        if (Binding.hashSet(this.table, this.log2Size, binding) == null) {
            ++this.num_bindings;
        }
    }

    public Binding addBinding(String name, Object value) {
        Binding binding = new Binding(name);
        binding.constraint = this.trivialConstraint;
        binding.value = value;
        this.addBinding(binding);
        return binding;
    }

    void rehash() {
        int new_capacity = 2 * this.table.length;
        Binding[] new_table = new Binding[new_capacity];
        Binding.hashInsertAll(new_table, this.log2Size + 1, this.table, this.log2Size);
        this.table = new_table;
        ++this.log2Size;
        this.mask = this.mask << 1 | 1;
    }

    public Object remove(String name) {
        Environment env = this;
        while (env != null) {
            if (this.locked) {
                throw new IllegalStateException("attempt to remove variable: " + name + " locked environment");
            }
            Binding[] env_tab = env.table;
            Binding old = Binding.hashDelete(env.table, env.log2Size, name);
            if (old != null) {
                return old;
            }
            env = env.previous;
        }
        return null;
    }

    public Object remove(Object name) {
        return this.remove((String)name);
    }

    public void remove(Binding binding) {
        String name = binding.getName();
        if (this.locked) {
            throw new IllegalStateException("attempt to remove variable: " + name + " locked environment");
        }
        Binding.hashDelete(this.table, this.log2Size, name);
    }

    public final boolean isBound(String name) {
        return this.get(name, Binding.UNBOUND) != Binding.UNBOUND;
    }

    @Override
    public Object get(String name, Object defaultValue) {
        Binding binding = this.lookup(name);
        if (binding == null) {
            return defaultValue;
        }
        return binding.get(defaultValue);
    }

    public Object getFunction(String name) {
        return this.getChecked(name);
    }

    @Override
    public Object put(String name, Object value) {
        Binding binding = this.lookup(name);
        if (binding == null) {
            this.define(name, value);
            return null;
        }
        if (!binding.isBound()) {
            binding.set(value);
            return null;
        }
        Object old_value = binding.get();
        binding.set(value);
        return old_value;
    }

    public Object put(Object name, Object value) {
        return this.put((String)name, value);
    }

    public void putFunction(String name, Object value) {
        this.put(name, value);
    }

    public BindingEnumeration enumerateBindings() {
        return new BindingEnumeration(this.table, 1 << this.log2Size);
    }

    public BindingEnumeration enumerateAllBindings() {
        return new BindingEnumeration(this);
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null) {
            name = super.toString();
        }
        return "#<environment " + name + '>';
    }
}

