#!/bin/sh

# Contributed by Steven Penny, https://github.com/nu8
# Cosmetical changes and minor fixes by Ilya Sher

set -e

SED=sed

# gsed - MacOS, sed - all the rest
if which gsed >/dev/null;then
	SED=gsed
fi

if ! $SED --version >/dev/null 2>/dev/null;then
	echo "Failed to assert GNU sed: failed running sed --version" >&2
	exit 1
fi

if ! $SED --version | grep -iq 'GNU sed';then
	echo "Failed to assert GNU sed: 'sed --version' output had no 'GNU sed'" >&2
	exit 2
fi

file_name=$1
var_name=$(tr /. __ <<eof
$file_name
eof
)
len=$(wc -c < "$file_name")
data=$(od -A n -t u1 -v "$file_name" | $SED 's/ \+/,/g;1s/,//')
printf '// Generated by %s from input file %s
unsigned char %s[] = {
%s
};
unsigned int %s_len = %s;
' "$0" "$file_name" "$var_name" "$data" "$var_name" "$len"
