/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#ifndef _USER_H_
#define _USER_H_ 1

#include "config.h"
#include "classes.h"
#include "functions.h"

struct from_config_file {
        char nickname[NICKNAME_LEN];
        char realname[REALNAME_LEN];
        char servername[SERVER_NAME_LEN];
        int port;
        char command_on_startup[COMMAND_MAX][COMMAND_LEN];  /* Commands which have to be send on startup */
        int command_on_startup_num;
	char modes[MODE_TO_SET_LEN];
	char part_quit_msg[PART_QUIT_MSG_LEN];
	bool autoconnect;              /* 1 = autoconnect; 0 = no autoconnect */
	bool autoreconnect;            /* 1 = autoreconnect after a connection got lost; 0 = no autoreconnect */
};

class User {
private:
        struct from_config_file * settings;
public:
        User(void);
        ~User(void);
        void SetNickname(char * new_nickname);
        void SetRealname(char * new_realname);
        void SetPort(int new_port);
        void SetServername(char * new_servername);
        char * GetNickname(void);
	char * GetRealname(void);
	char * GetServername(void);
	char * GetStartupcommand(int command_num);
	char * GetLeaveMessage(void);
	char * GetModes(void);
	bool GetAutoConnect(void);
	bool GetAutoReconnect(void);
	int GetTotalCommandNum(void);
        int GetPort(void);
        int ReadSettings(void);     /* Read an Write the Settings to the ... */
//        int WriteSettings(void);    /* ... config-file. ret: 0 = failed; 1 = OK */
};

#endif
