/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#define _USER_CC_
#include <cstring>
#include "user.h"

User::User(void)
{
	settings = NULL;
	ReadSettings();
	return;
}

User::~User(void)
{
        return;
}

void User::SetNickname(char * new_nickname)
{
        strncpy(settings->nickname, new_nickname, NICKNAME_LEN-1);
        return;
}

void User::SetRealname(char * new_realname)
{
        strncpy(settings->realname, new_realname, REALNAME_LEN-1);
        return;
}

int User::ReadSettings(void)
{
        if(settings) {
		delete settings;
		settings = NULL;
	}
        settings = get_config_file_settings();
        if(settings == NULL) return 0;       /* failed */
        return 1;            /* OK */
}

//int User::WriteSettings(void)
//{
//        write_config_file(settings);
//        return 1; /* OK */
//}

void User::SetPort(int new_port)
{
        if((new_port > 0) && (new_port <= 65535)) settings->port = new_port;
		else settings->port = DEFAULT_PORT_NUM;
        return;
}

void User::SetServername(char * new_servername)
{
        strncpy(settings->servername, new_servername, SERVER_NAME_LEN-1);
        return;
}

char * User::GetServername(void)
{
        return settings->servername;
}

char * User::GetStartupcommand(int command_num)
{
	if(command_num < 0 || command_num > settings->command_on_startup_num - 1) return NULL;
	return settings->command_on_startup[command_num];
}

char * User::GetLeaveMessage(void)
{
	return settings->part_quit_msg;
}

char * User::GetModes(void)
{
	return settings->modes;
}

bool User::GetAutoConnect(void)
{
	return settings->autoconnect;
}

bool User::GetAutoReconnect(void)
{
	return settings->autoreconnect;
}

int User::GetTotalCommandNum(void)
{
	return settings->command_on_startup_num;
}

int User::GetPort(void)
{
        return settings->port;
}

char * User::GetNickname(void)
{
	return settings->nickname;
}

char * User::GetRealname(void)
{
	return settings->realname;
}

#undef _USER_CC_
