/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#ifndef _SCREEN_H_
#define _SCREEN_H_ 1

#include <curses.h>
#include "config.h"
#include "classes.h"
#include "functions.h"

struct screeninfo {
	int used;
	int type; /* 0 = channel; 1 = directchat */
	char channel_name[CHANNELS_NAME_LEN];
        char channel_topic[TOPIC_LEN_MAX];
	char directchat_nickname[NICKNAME_LEN];
};

class Screen {
private:
	int COLSnow;
	int LINESnow;
	int active_channel;
	int first_print_msg; /* 0 = print normal screen, 1-xxx = when the user wants to scroll up*/
	int redraw_screen_from_scratch; /* used for SIGWINCH */
	char * InputBuffer;
	char help_buffer[HELP_BUF_LEN];
	WINDOW * MainScreen;	/* The hole Screen */
	WINDOW * TextScreen;
	WINDOW * InfoBottom;    /* User-Info -> Mode, Name, Away ... */
	WINDOW * InfoTop;       /* Channel and Topic Info */
	WINDOW * InputScreen;
	struct screeninfo screen_info[CHANNELS_MAX];
	unsigned long num_textscreen_redraws;
	int Test_Input_for_special_Chars(char * buf);
	/* ret: what we have to do: 0 = dont Parse the input, wait for more Chars; 1 = Parse the Input */
	void AddToInputBuffer(char * buf);
	int MessagesToPrint(void);
	void user_input_SCREEN(char * user_input);
	char * MakeScreenString(int type); /* for printing the bottom screen */
	void SetCursorToInputScreen(void);
	/* TextFormat variables and functions */
	bool bold_started;                           /* if the is marked as bold or not */
	bool underline_started;                      /* if the string is markes as underlined or not*/
	void ResetFormat(WINDOW * screen);           /* resets ALL format options ! */
	void SetBold(WINDOW * screen);               /* makes the next chars bold, or not bold if it is allready turned on */
	void SetUnderline(WINDOW * screen);          /* makes the next chars underlined, or not underlined if it is allready turned on */
	int SetColor(char * string);                 /* in this version this function is only make the ouput more 'nice' -> "^C15text^C" => "text" */
	int print_format_text(WINDOW * screen, char * string, int max_chars); /* max_chars = maximum real chars to write to the screen (without format chars ) ; return value = num chars wrote */
public:
	Screen(void);
	~Screen(void);
	void SetActiveChannel(int new_active_channel);
	int GetActiveChannel(void);
	int GetScreenUse(int screen_nr);
	void SetScreenUse(int screen_nr, int new_use);
	int GetScreenType(int screen_nr);
	void SetScreenType(int screen_nr, int new_type);
	char * GetChannelName(int screen_nr);
	char * GetDirectChatNick(int screen_nr);
	int GetScreenCols(void);
	int GetScreenNumForChannel(char * tmp_channel);
	int GetScreenNumForDirectChat(char * tmp_nickname);
	void SetChannelName(int screen_nr, char * new_channelname);
	char * GetTopic(int screen_nr);                   /* get the topic for a screen */
	void SetTopic(int screen_nr, char * new_topic);   /* sets the topic for a screen */
	void SetDirectChatNick(int screen_nr, char * new_directchatnick);
	void DrawTopScreen(void);
	void DrawBottomScreen(void);
	void DrawTextScreen(void);
	void DrawInputScreen(void);
	void GetInput(void);
	int GetScreenNr(char * name, int type); /* ret: 0 = no such name for a channel or user; >0 = screennum */
	int GetNotUsedScreen(int type); /* ret: 0 = no screen left; or the new screen number */
	void EmptyScreen(int screen_nr); /* marks a screen as not used */
	void EmptyAllScreens(void); /* same as above but for all screens */
	void MakeAllWindow(int sigwinch);
	void MarktoRedrawScreen(void);
	void CheckScreenForRedraw(void);
	void EndNcurses(void); /* clean up the screen and end ncurses */
	void ParseCommandToServer(char * message); /* parse a user command and send it to the server if 'message' is NULL the intern buffer 'InputBuffer' will be taken */
};

#endif
