/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#define _PARAMETER_CC_
#include <cstdio>
#include <cstring>
#include "parameter.h"

Parameter::Parameter(void)
{ 
	param_list_ptr = NULL;
	Init_Reset_Parameters();
	return;
}

Parameter::~Parameter(void)
{
	if(param_list_ptr) {
		for(int i = 0; i < PARAMETER_MAX_PARAMS; i++)
			if(param_list_ptr[i])
				delete[] param_list_ptr[i];
		delete[] param_list_ptr;
	}
	return;
}

void Parameter::Init_Reset_Parameters(void)
{
	if(param_list_ptr) {
		for(int i = 0; i < PARAMETER_MAX_PARAMS; i++)
		{
			if(param_list_ptr[i]) {
				delete[] param_list_ptr[i];
				param_list_ptr[i] = NULL;
			}
		}
	} else {
		param_list_ptr = new char * [PARAMETER_MAX_PARAMS];
		for(int i = 0; i < PARAMETER_MAX_PARAMS; i++)
			param_list_ptr[i] = NULL;
	}
	num_parameters = 0;
	last_parameter = 0;
	return;
}

int Parameter::Add_Parameter(char * parameter_str)
{
	/* search the next empty field */
	int field = -1;
	for(int i = 0; i < PARAMETER_MAX_PARAMS; i++) {
		if(param_list_ptr[i] == NULL) {
			field = i;
			break;
		}
	}
	if(field == -1) return field; /* no space left */
	int len = strlen(parameter_str);
	if(len >= PARAMETER_MAX_STRLEN) len = PARAMETER_MAX_STRLEN - 1;
	param_list_ptr[field] = new char[len+1];
	memcpy(&param_list_ptr[field][0], parameter_str, len);
	param_list_ptr[field][len] = '\0';
	num_parameters++;
	return field;
}

void Parameter::Remove_Parameter(int parameter_index)
{
	if((parameter_index < 0) || (parameter_index >= PARAMETER_MAX_PARAMS)) return;
	if(param_list_ptr[parameter_index]) {
		delete[] param_list_ptr[parameter_index];
		param_list_ptr[parameter_index] = NULL;
		num_parameters--;
	}
	return;
}

char * Parameter::Read_Parameter(int parameter_index)
{
	if((parameter_index < 0) || (parameter_index >= PARAMETER_MAX_PARAMS)) return NULL;
	last_parameter = parameter_index;
	return &param_list_ptr[parameter_index][0];
}

char * Parameter::GetFirstElement(void)
{
	if(num_parameters < 1) return NULL;
	for(int i = 0; i < PARAMETER_MAX_PARAMS; i++)
	{
		if(param_list_ptr[i] != NULL)
		{
			last_parameter = i;
			return param_list_ptr[i];
		}
	}
	return NULL;
}

char * Parameter::GetNextElement(void)
{
	if(num_parameters < 2) return NULL; /* there cant be a next parameter if there is anyway less then one */
	int tmp_param;
	for(int i = 0; i < PARAMETER_MAX_PARAMS; i++)
	{
		tmp_param = last_parameter + i + 1;
		if(tmp_param >= PARAMETER_MAX_PARAMS) tmp_param -= PARAMETER_MAX_PARAMS;
		if(param_list_ptr[tmp_param] != NULL) {
			last_parameter = tmp_param;
			return param_list_ptr[tmp_param];
		}
	}
	return NULL;
}

int Parameter::Get_Num_Parameter(void)
{
	return num_parameters;
}

int Parameter::Get_Last_Parameter(void)
{
	return last_parameter;
}

#undef _PARAMETER_CC_
