/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#ifndef _MESSAGES_H_
#define _MESSAGES_H_ 1

#include "config.h"
#include "classes.h"
#include "functions.h"

class Messages {
private:
        /* every element of the channel_messages array will be
         * allocated when a message comes in */
        char * channel_messages[CHANNELS_MAX][NUM_LINES];
	unsigned short has_format_chars[CHANNELS_MAX][NUM_LINES]; /* 1 = there are format chars; 0 = there are no format chars */
	bool has_changed[CHANNELS_MAX]; /* no new messages on this channel since messages has been added to the buffer */
        /* which_start_message tells us, which element of the array
         * channel_messages the last one is (bottom) */
        int which_start_message[CHANNELS_MAX];
	int how_many_entrys[CHANNELS_MAX];
        void SetMessage(int channel_num, char * new_message);
	int check_for_format_chars(char * string); /* ret: 1 = there are format chars; 0 = there are no format chars */
public:
        Messages(void);
        ~Messages(void);
	void SetIrcChatMessage(int channel_num, char * nickname, char * message);
	/* Position 0 is the newest entry
	 * ret NULL = no entry for this position and channel */
        char * GetMessage(int channel_num, int position);
	int GetFormatOptions(int channel_num, int position); /* 1 = there are format chars; 0 = there are no format chars */
	int GetLinesNum(int channel_num);
	void EmptyMessages(int channel_num); /* deletes every message */
	void SetChange(int tmp_channel, bool value); /* manualy set this to force a screen redraw */
	bool GetChange(int tmp_channel);
};

#endif
