/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *  
 *                                                                 */

#ifndef _INPUT_PARAMETERS_H_
#define _INPUT_PARAMETERS_H_ 1

#include <cstring> /* NULL */
#include "config.h"

struct Input_Parameters {
	unsigned short defined;
	unsigned short parameters_min;
	unsigned short parameters_max;
};

#ifdef _MAIN_CC_

struct Input_Parameters input_params[PROTOCOL_HIGHEST_NUMBER+1] = {
	{ 0, 0, 0                       }, /* command:	0	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	1	RPL_WELCOME          "Welcome to the Internet Relay Network <nick>!<user>@<host> */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	2	RPL_YOURHOST         "Your host is <servername>, running version <ver> */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	3	RPL_CREATED          "This server was created <date> */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	4	RPL_MYINFO           "<servername> <version> <available user modes>  <available channel modes> */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	5	RPL_BOUNCE           "Try server <server name>, port <port number>" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	6	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	7	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	8	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	9	*/
	{ 0, 0, 0                       }, /* command:	10	*/
	{ 0, 0, 0                       }, /* command:	11	*/
	{ 0, 0, 0                       }, /* command:	12	*/
	{ 0, 0, 0                       }, /* command:	13	*/
	{ 0, 0, 0                       }, /* command:	14	*/
	{ 0, 0, 0                       }, /* command:	15	*/
	{ 0, 0, 0                       }, /* command:	16	*/
	{ 0, 0, 0                       }, /* command:	17	*/
	{ 0, 0, 0                       }, /* command:	18	*/
	{ 0, 0, 0                       }, /* command:	19	*/
	{ 0, 0, 0                       }, /* command:	20	*/
	{ 0, 0, 0                       }, /* command:	21	*/
	{ 0, 0, 0                       }, /* command:	22	*/
	{ 0, 0, 0                       }, /* command:	23	*/
	{ 0, 0, 0                       }, /* command:	24	*/
	{ 0, 0, 0                       }, /* command:	25	*/
	{ 0, 0, 0                       }, /* command:	26	*/
	{ 0, 0, 0                       }, /* command:	27	*/
	{ 0, 0, 0                       }, /* command:	28	*/
	{ 0, 0, 0                       }, /* command:	29	*/
	{ 0, 0, 0                       }, /* command:	30	*/
	{ 0, 0, 0                       }, /* command:	31	*/
	{ 0, 0, 0                       }, /* command:	32	*/
	{ 0, 0, 0                       }, /* command:	33	*/
	{ 0, 0, 0                       }, /* command:	34	*/
	{ 0, 0, 0                       }, /* command:	35	*/
	{ 0, 0, 0                       }, /* command:	36	*/
	{ 0, 0, 0                       }, /* command:	37	*/
	{ 0, 0, 0                       }, /* command:	38	*/
	{ 0, 0, 0                       }, /* command:	39	*/
	{ 0, 0, 0                       }, /* command:	40	*/
	{ 0, 0, 0                       }, /* command:	41	*/
	{ 0, 0, 0                       }, /* command:	42	*/
	{ 0, 0, 0                       }, /* command:	43	*/
	{ 0, 0, 0                       }, /* command:	44	*/
	{ 0, 0, 0                       }, /* command:	45	*/
	{ 0, 0, 0                       }, /* command:	46	*/
	{ 0, 0, 0                       }, /* command:	47	*/
	{ 0, 0, 0                       }, /* command:	48	*/
	{ 0, 0, 0                       }, /* command:	49	*/
	{ 0, 0, 0                       }, /* command:	50	*/
	{ 0, 0, 0                       }, /* command:	51	*/
	{ 0, 0, 0                       }, /* command:	52	*/
	{ 0, 0, 0                       }, /* command:	53	*/
	{ 0, 0, 0                       }, /* command:	54	*/
	{ 0, 0, 0                       }, /* command:	55	*/
	{ 0, 0, 0                       }, /* command:	56	*/
	{ 0, 0, 0                       }, /* command:	57	*/
	{ 0, 0, 0                       }, /* command:	58	*/
	{ 0, 0, 0                       }, /* command:	59	*/
	{ 0, 0, 0                       }, /* command:	60	*/
	{ 0, 0, 0                       }, /* command:	61	*/
	{ 0, 0, 0                       }, /* command:	62	*/
	{ 0, 0, 0                       }, /* command:	63	*/
	{ 0, 0, 0                       }, /* command:	64	*/
	{ 0, 0, 0                       }, /* command:	65	*/
	{ 0, 0, 0                       }, /* command:	66	*/
	{ 0, 0, 0                       }, /* command:	67	*/
	{ 0, 0, 0                       }, /* command:	68	*/
	{ 0, 0, 0                       }, /* command:	69	*/
	{ 0, 0, 0                       }, /* command:	70	*/
	{ 0, 0, 0                       }, /* command:	71	*/
	{ 0, 0, 0                       }, /* command:	72	*/
	{ 0, 0, 0                       }, /* command:	73	*/
	{ 0, 0, 0                       }, /* command:	74	*/
	{ 0, 0, 0                       }, /* command:	75	*/
	{ 0, 0, 0                       }, /* command:	76	*/
	{ 0, 0, 0                       }, /* command:	77	*/
	{ 0, 0, 0                       }, /* command:	78	*/
	{ 0, 0, 0                       }, /* command:	79	*/
	{ 0, 0, 0                       }, /* command:	80	*/
	{ 0, 0, 0                       }, /* command:	81	*/
	{ 0, 0, 0                       }, /* command:	82	*/
	{ 0, 0, 0                       }, /* command:	83	*/
	{ 0, 0, 0                       }, /* command:	84	*/
	{ 0, 0, 0                       }, /* command:	85	*/
	{ 0, 0, 0                       }, /* command:	86	*/
	{ 0, 0, 0                       }, /* command:	87	*/
	{ 0, 0, 0                       }, /* command:	88	*/
	{ 0, 0, 0                       }, /* command:	89	*/
	{ 0, 0, 0                       }, /* command:	90	*/
	{ 0, 0, 0                       }, /* command:	91	*/
	{ 0, 0, 0                       }, /* command:	92	*/
	{ 0, 0, 0                       }, /* command:	93	*/
	{ 0, 0, 0                       }, /* command:	94	*/
	{ 0, 0, 0                       }, /* command:	95	*/
	{ 0, 0, 0                       }, /* command:	96	*/
	{ 0, 0, 0                       }, /* command:	97	*/
	{ 0, 0, 0                       }, /* command:	98	*/
	{ 0, 0, 0                       }, /* command:	99	*/
	{ 0, 0, 0                       }, /* command:	100	*/
	{ 0, 0, 0                       }, /* command:	101	*/
	{ 0, 0, 0                       }, /* command:	102	*/
	{ 0, 0, 0                       }, /* command:	103	*/
	{ 0, 0, 0                       }, /* command:	104	*/
	{ 0, 0, 0                       }, /* command:	105	*/
	{ 0, 0, 0                       }, /* command:	106	*/
	{ 0, 0, 0                       }, /* command:	107	*/
	{ 0, 0, 0                       }, /* command:	108	*/
	{ 0, 0, 0                       }, /* command:	109	*/
	{ 0, 0, 0                       }, /* command:	110	*/
	{ 0, 0, 0                       }, /* command:	111	*/
	{ 0, 0, 0                       }, /* command:	112	*/
	{ 0, 0, 0                       }, /* command:	113	*/
	{ 0, 0, 0                       }, /* command:	114	*/
	{ 0, 0, 0                       }, /* command:	115	*/
	{ 0, 0, 0                       }, /* command:	116	*/
	{ 0, 0, 0                       }, /* command:	117	*/
	{ 0, 0, 0                       }, /* command:	118	*/
	{ 0, 0, 0                       }, /* command:	119	*/
	{ 0, 0, 0                       }, /* command:	120	*/
	{ 0, 0, 0                       }, /* command:	121	*/
	{ 0, 0, 0                       }, /* command:	122	*/
	{ 0, 0, 0                       }, /* command:	123	*/
	{ 0, 0, 0                       }, /* command:	124	*/
	{ 0, 0, 0                       }, /* command:	125	*/
	{ 0, 0, 0                       }, /* command:	126	*/
	{ 0, 0, 0                       }, /* command:	127	*/
	{ 0, 0, 0                       }, /* command:	128	*/
	{ 0, 0, 0                       }, /* command:	129	*/
	{ 0, 0, 0                       }, /* command:	130	*/
	{ 0, 0, 0                       }, /* command:	131	*/
	{ 0, 0, 0                       }, /* command:	132	*/
	{ 0, 0, 0                       }, /* command:	133	*/
	{ 0, 0, 0                       }, /* command:	134	*/
	{ 0, 0, 0                       }, /* command:	135	*/
	{ 0, 0, 0                       }, /* command:	136	*/
	{ 0, 0, 0                       }, /* command:	137	*/
	{ 0, 0, 0                       }, /* command:	138	*/
	{ 0, 0, 0                       }, /* command:	139	*/
	{ 0, 0, 0                       }, /* command:	140	*/
	{ 0, 0, 0                       }, /* command:	141	*/
	{ 0, 0, 0                       }, /* command:	142	*/
	{ 0, 0, 0                       }, /* command:	143	*/
	{ 0, 0, 0                       }, /* command:	144	*/
	{ 0, 0, 0                       }, /* command:	145	*/
	{ 0, 0, 0                       }, /* command:	146	*/
	{ 0, 0, 0                       }, /* command:	147	*/
	{ 0, 0, 0                       }, /* command:	148	*/
	{ 0, 0, 0                       }, /* command:	149	*/
	{ 0, 0, 0                       }, /* command:	150	*/
	{ 0, 0, 0                       }, /* command:	151	*/
	{ 0, 0, 0                       }, /* command:	152	*/
	{ 0, 0, 0                       }, /* command:	153	*/
	{ 0, 0, 0                       }, /* command:	154	*/
	{ 0, 0, 0                       }, /* command:	155	*/
	{ 0, 0, 0                       }, /* command:	156	*/
	{ 0, 0, 0                       }, /* command:	157	*/
	{ 0, 0, 0                       }, /* command:	158	*/
	{ 0, 0, 0                       }, /* command:	159	*/
	{ 0, 0, 0                       }, /* command:	160	*/
	{ 0, 0, 0                       }, /* command:	161	*/
	{ 0, 0, 0                       }, /* command:	162	*/
	{ 0, 0, 0                       }, /* command:	163	*/
	{ 0, 0, 0                       }, /* command:	164	*/
	{ 0, 0, 0                       }, /* command:	165	*/
	{ 0, 0, 0                       }, /* command:	166	*/
	{ 0, 0, 0                       }, /* command:	167	*/
	{ 0, 0, 0                       }, /* command:	168	*/
	{ 0, 0, 0                       }, /* command:	169	*/
	{ 0, 0, 0                       }, /* command:	170	*/
	{ 0, 0, 0                       }, /* command:	171	*/
	{ 0, 0, 0                       }, /* command:	172	*/
	{ 0, 0, 0                       }, /* command:	173	*/
	{ 0, 0, 0                       }, /* command:	174	*/
	{ 0, 0, 0                       }, /* command:	175	*/
	{ 0, 0, 0                       }, /* command:	176	*/
	{ 0, 0, 0                       }, /* command:	177	*/
	{ 0, 0, 0                       }, /* command:	178	*/
	{ 0, 0, 0                       }, /* command:	179	*/
	{ 0, 0, 0                       }, /* command:	180	*/
	{ 0, 0, 0                       }, /* command:	181	*/
	{ 0, 0, 0                       }, /* command:	182	*/
	{ 0, 0, 0                       }, /* command:	183	*/
	{ 0, 0, 0                       }, /* command:	184	*/
	{ 0, 0, 0                       }, /* command:	185	*/
	{ 0, 0, 0                       }, /* command:	186	*/
	{ 0, 0, 0                       }, /* command:	187	*/
	{ 0, 0, 0                       }, /* command:	188	*/
	{ 0, 0, 0                       }, /* command:	189	*/
	{ 0, 0, 0                       }, /* command:	190	*/
	{ 0, 0, 0                       }, /* command:	191	*/
	{ 0, 0, 0                       }, /* command:	192	*/
	{ 0, 0, 0                       }, /* command:	193	*/
	{ 0, 0, 0                       }, /* command:	194	*/
	{ 0, 0, 0                       }, /* command:	195	*/
	{ 0, 0, 0                       }, /* command:	196	*/
	{ 0, 0, 0                       }, /* command:	197	*/
	{ 0, 0, 0                       }, /* command:	198	*/
	{ 0, 0, 0                       }, /* command:	199	*/
	{ 0, 0, 0                       }, /* command:	200	*/
	{ 0, 0, 0                       }, /* command:	201	*/
	{ 0, 0, 0                       }, /* command:	202	*/
	{ 0, 0, 0                       }, /* command:	203	*/
	{ 0, 0, 0                       }, /* command:	204	*/
	{ 0, 0, 0                       }, /* command:	205	*/
	{ 0, 0, 0                       }, /* command:	206	*/
	{ 0, 0, 0                       }, /* command:	207	*/
	{ 0, 0, 0                       }, /* command:	208	*/
	{ 0, 0, 0                       }, /* command:	209	*/
	{ 0, 0, 0                       }, /* command:	210	*/
	{ 0, 0, 0                       }, /* command:	211	*/
	{ 0, 0, 0                       }, /* command:	212	*/
	{ 0, 0, 0                       }, /* command:	213	*/
	{ 0, 0, 0                       }, /* command:	214	*/
	{ 0, 0, 0                       }, /* command:	215	*/
	{ 0, 0, 0                       }, /* command:	216	*/
	{ 0, 0, 0                       }, /* command:	217	*/
	{ 0, 0, 0                       }, /* command:	218	*/
	{ 0, 0, 0                       }, /* command:	219	*/
	{ 0, 0, 0                       }, /* command:	220	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	221	RPL_UMODEIS          "<user mode string>" */
	{ 0, 0, 0                       }, /* command:	222	*/
	{ 0, 0, 0                       }, /* command:	223	*/
	{ 0, 0, 0                       }, /* command:	224	*/
	{ 0, 0, 0                       }, /* command:	225	*/
	{ 0, 0, 0                       }, /* command:	226	*/
	{ 0, 0, 0                       }, /* command:	227	*/
	{ 0, 0, 0                       }, /* command:	228	*/
	{ 0, 0, 0                       }, /* command:	229	*/
	{ 0, 0, 0                       }, /* command:	230	*/
	{ 0, 0, 0                       }, /* command:	231	*/
	{ 0, 0, 0                       }, /* command:	232	*/
	{ 0, 0, 0                       }, /* command:	233	*/
	{ 0, 0, 0                       }, /* command:	234	*/
	{ 0, 0, 0                       }, /* command:	235	*/
	{ 0, 0, 0                       }, /* command:	236	*/
	{ 0, 0, 0                       }, /* command:	237	*/
	{ 0, 0, 0                       }, /* command:	238	*/
	{ 0, 0, 0                       }, /* command:	239	*/
	{ 0, 0, 0                       }, /* command:	240	*/
	{ 0, 0, 0                       }, /* command:	241	*/
	{ 0, 0, 0                       }, /* command:	242	*/
	{ 0, 0, 0                       }, /* command:	243	*/
	{ 0, 0, 0                       }, /* command:	244	*/
	{ 0, 0, 0                       }, /* command:	245	*/
	{ 0, 0, 0                       }, /* command:	246	*/
	{ 0, 0, 0                       }, /* command:	247	*/
	{ 0, 0, 0                       }, /* command:	248	*/
	{ 0, 0, 0                       }, /* command:	249	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	250	Was not discribed in the RFC documentation, in the freenode network it is a user count msg */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	251	RPL_LUSERCLIENT      ":There are <integer> users and <integer> services on <integer> servers" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	252	RPL_LUSEROP          "<integer> :operator(s) online" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	253	RPL_LUSERUNKNOWN     "<integer> :unknown connection(s)" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	254	RPL_LUSERCHANNELS    "<integer> :channels formed" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	255	RPL_LUSERME          ":I have <integer> clients and <integer> servers" */
	{ 0, 0, 0                       }, /* command:	256	*/
	{ 0, 0, 0                       }, /* command:	257	*/
	{ 0, 0, 0                       }, /* command:	258	*/
	{ 0, 0, 0                       }, /* command:	259	*/
	{ 0, 0, 0                       }, /* command:	260	*/
	{ 0, 0, 0                       }, /* command:	261	*/
	{ 0, 0, 0                       }, /* command:	262	*/
	{ 0, 0, 0                       }, /* command:	263	*/
	{ 0, 0, 0                       }, /* command:	264	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	265	Was not discribed in RFC documentation, in the freenode network it is a "Current local users" msg */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	266	Was not discribed in RFC documentation, in the freenode network it is a "Current global users" msg */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	267	Was not discribed in RFC documentation, in the gamesnet network it is a "Service agents online" msg */
	{ 0, 0, 0                       }, /* command:	268	*/
	{ 0, 0, 0                       }, /* command:	269	*/
	{ 0, 0, 0                       }, /* command:	270	*/
	{ 0, 0, 0                       }, /* command:	271	*/
	{ 0, 0, 0                       }, /* command:	272	*/
	{ 0, 0, 0                       }, /* command:	273	*/
	{ 0, 0, 0                       }, /* command:	274	*/
	{ 0, 0, 0                       }, /* command:	275	*/
	{ 0, 0, 0                       }, /* command:	276	*/
	{ 0, 0, 0                       }, /* command:	277	*/
	{ 0, 0, 0                       }, /* command:	278	*/
	{ 0, 0, 0                       }, /* command:	279	*/
	{ 0, 0, 0                       }, /* command:	280	*/
	{ 0, 0, 0                       }, /* command:	281	*/
	{ 0, 0, 0                       }, /* command:	282	*/
	{ 0, 0, 0                       }, /* command:	283	*/
	{ 0, 0, 0                       }, /* command:	284	*/
	{ 0, 0, 0                       }, /* command:	285	*/
	{ 0, 0, 0                       }, /* command:	286	*/
	{ 0, 0, 0                       }, /* command:	287	*/
	{ 0, 0, 0                       }, /* command:	288	*/
	{ 0, 0, 0                       }, /* command:	289	*/
	{ 0, 0, 0                       }, /* command:	290	*/
	{ 0, 0, 0                       }, /* command:	291	*/
	{ 0, 0, 0                       }, /* command:	292	*/
	{ 0, 0, 0                       }, /* command:	293	*/
	{ 0, 0, 0                       }, /* command:	294	*/
	{ 0, 0, 0                       }, /* command:	295	*/
	{ 0, 0, 0                       }, /* command:	296	*/
	{ 0, 0, 0                       }, /* command:	297	*/
	{ 0, 0, 0                       }, /* command:	298	*/
	{ 0, 0, 0                       }, /* command:	299	*/
	{ 0, 0, 0                       }, /* command:	300	*/
	{ 0, 0, 0                       }, /* command:	301	*/
	{ 0, 0, 0                       }, /* command:	302	*/
	{ 0, 0, 0                       }, /* command:	303	*/
	{ 0, 0, 0                       }, /* command:	304	*/
	{ 0, 0, 0                       }, /* command:	305	*/
	{ 0, 0, 0                       }, /* command:	306	*/
	{ 0, 0, 0                       }, /* command:	307	*/
	{ 0, 0, 0                       }, /* command:	308	*/
	{ 0, 0, 0                       }, /* command:	309	*/
	{ 0, 0, 0                       }, /* command:	310	*/
	{ 0, 0, 0                       }, /* command:	311	*/
	{ 0, 0, 0                       }, /* command:	312	*/
	{ 0, 0, 0                       }, /* command:	313	*/
	{ 0, 0, 0                       }, /* command:	314	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	315	RPL_ENDOFWHO         "<name> :End of WHO list" */
	{ 0, 0, 0                       }, /* command:	316	*/
	{ 0, 0, 0                       }, /* command:	317	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	318	RPL_ENDOFWHOIS       "<nick> :End of WHOIS list" */
	{ 0, 0, 0                       }, /* command:	319	*/
	{ 0, 0, 0                       }, /* command:	320	*/
	{ 0, 0, 0                       }, /* command:	321	*/
	{ 0, 0, 0                       }, /* command:	322	*/
	{ 0, 0, 0                       }, /* command:	323	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	324	RPL_CHANNELMODEIS    "<channel> <mode> <mode params>" */
	{ 0, 0, 0                       }, /* command:	325	*/
	{ 0, 0, 0                       }, /* command:	326	*/
	{ 0, 0, 0                       }, /* command:	327	*/
	{ 0, 0, 0                       }, /* command:	328	*/
	{ 1, 5, 5                       }, /* command:	329	not in rfc, but seems to be when a channel has been created -> "<channel> <unix-timestamp>" */
	{ 0, 0, 0                       }, /* command:	330	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	331	RPL_NOTOPIC          "<channel> :No topic is set" */
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	332	RPL_TOPIC            "<channel> :<topic> */
	{ 1, 6, 6                       }, /* command:	333	Was also not discribed in RFC documentation, in the freenode network it is a information about who has when set the topic of a channel => "<channel> <nickname> <unix-timestamp>*/
	{ 0, 0, 0                       }, /* command:	334	*/
	{ 0, 0, 0                       }, /* command:	335	*/
	{ 0, 0, 0                       }, /* command:	336	*/
	{ 0, 0, 0                       }, /* command:	337	*/
	{ 0, 0, 0                       }, /* command:	338	*/
	{ 0, 0, 0                       }, /* command:	339	*/
	{ 0, 0, 0                       }, /* command:	340	*/
	{ 0, 0, 0                       }, /* command:	341	*/
	{ 0, 0, 0                       }, /* command:	342	*/
	{ 0, 0, 0                       }, /* command:	343	*/
	{ 0, 0, 0                       }, /* command:	344	*/
	{ 0, 0, 0                       }, /* command:	345	*/
	{ 0, 0, 0                       }, /* command:	346	*/
	{ 0, 0, 0                       }, /* command:	347	*/
	{ 0, 0, 0                       }, /* command:	348	*/
	{ 0, 0, 0                       }, /* command:	349	*/
	{ 0, 0, 0                       }, /* command:	350	*/
	{ 0, 0, 0                       }, /* command:	351	*/
	{ 0, 0, 0                       }, /* command:	352	*/
	{ 1, 6, NUM_INPUTPARAMETERS_MAX }, /* command:	353	RPL_NAMREPLY         "( "=" / "*" / "@" ) <channel>  :[ "@" / "+" ] <nick> *( " " [ "@" / "+" ] <nick> )" */
	{ 0, 0, 0                       }, /* command:	354	*/
	{ 0, 0, 0                       }, /* command:	355	*/
	{ 0, 0, 0                       }, /* command:	356	*/
	{ 0, 0, 0                       }, /* command:	357	*/
	{ 0, 0, 0                       }, /* command:	358	*/
	{ 0, 0, 0                       }, /* command:	359	*/
	{ 0, 0, 0                       }, /* command:	360	*/
	{ 0, 0, 0                       }, /* command:	361	*/
	{ 0, 0, 0                       }, /* command:	362	*/
	{ 0, 0, 0                       }, /* command:	363	*/
	{ 0, 0, 0                       }, /* command:	364	*/
	{ 0, 0, 0                       }, /* command:	365	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	366	RPL_ENDOFNAMES       "<channel> :End of NAMES list" */
	{ 0, 0, 0                       }, /* command:	367	*/
	{ 0, 0, 0                       }, /* command:	368	*/
	{ 0, 0, 0                       }, /* command:	369	*/
	{ 0, 0, 0                       }, /* command:	370	*/
	{ 0, 0, 0                       }, /* command:	371	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	372	RPL_MOTD             ":- <text>" */
	{ 0, 0, 0                       }, /* command:	373	*/
	{ 0, 0, 0                       }, /* command:	374	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	375	RPL_MOTDSTART        ":- <server> Message of the day - " */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	376	RPL_ENDOFMOTD        ":End of MOTD command" */
	{ 0, 0, 0                       }, /* command:	377	*/
	{ 0, 0, 0                       }, /* command:	378	*/
	{ 0, 0, 0                       }, /* command:	379	*/
	{ 0, 0, 0                       }, /* command:	380	*/
	{ 0, 0, 0                       }, /* command:	381	*/
	{ 0, 0, 0                       }, /* command:	382	*/
	{ 0, 0, 0                       }, /* command:	383	*/
	{ 0, 0, 0                       }, /* command:	384	*/
	{ 0, 0, 0                       }, /* command:	385	*/
	{ 0, 0, 0                       }, /* command:	386	*/
	{ 0, 0, 0                       }, /* command:	387	*/
	{ 0, 0, 0                       }, /* command:	388	*/
	{ 0, 0, 0                       }, /* command:	389	*/
	{ 0, 0, 0                       }, /* command:	390	*/
	{ 0, 0, 0                       }, /* command:	391	*/
	{ 0, 0, 0                       }, /* command:	392	*/
	{ 0, 0, 0                       }, /* command:	393	*/
	{ 0, 0, 0                       }, /* command:	394	*/
	{ 0, 0, 0                       }, /* command:	395	*/
	{ 0, 0, 0                       }, /* command:	396	*/
	{ 0, 0, 0                       }, /* command:	397	*/
	{ 0, 0, 0                       }, /* command:	398	*/
	{ 0, 0, 0                       }, /* command:	399	*/
	{ 0, 0, 0                       }, /* command:	400	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	401	ERR_NOSUCHNICK       "<nickname> :No such nick/channel" */
	{ 0, 0, 0                       }, /* command:	402	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	403	ERR_NOSUCHCHANNEL    "<channel name> :No such channel"*/
	{ 0, 0, 0                       }, /* command:	404	*/
	{ 0, 0, 0                       }, /* command:	405	*/
	{ 0, 0, 0                       }, /* command:	406	*/
	{ 0, 0, 0                       }, /* command:	407	*/
	{ 0, 0, 0                       }, /* command:	408	*/
	{ 0, 0, 0                       }, /* command:	409	*/
	{ 0, 0, 0                       }, /* command:	410	*/
	{ 0, 0, 0                       }, /* command:	411	*/
	{ 0, 0, 0                       }, /* command:	412	*/
	{ 0, 0, 0                       }, /* command:	413	*/
	{ 0, 0, 0                       }, /* command:	414	*/
	{ 0, 0, 0                       }, /* command:	415	*/
	{ 0, 0, 0                       }, /* command:	416	*/
	{ 0, 0, 0                       }, /* command:	417	*/
	{ 0, 0, 0                       }, /* command:	418	*/
	{ 0, 0, 0                       }, /* command:	419	*/
	{ 0, 0, 0                       }, /* command:	420	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	421	ERR_UNKNOWNCOMMAND   "<command> :Unknown command"*/
	{ 0, 0, 0                       }, /* command:	422	*/
	{ 0, 0, 0                       }, /* command:	423	*/
	{ 0, 0, 0                       }, /* command:	424	*/
	{ 0, 0, 0                       }, /* command:	425	*/
	{ 0, 0, 0                       }, /* command:	426	*/
	{ 0, 0, 0                       }, /* command:	427	*/
	{ 0, 0, 0                       }, /* command:	428	*/
	{ 0, 0, 0                       }, /* command:	429	*/
	{ 0, 0, 0                       }, /* command:	430	*/
	{ 0, 0, 0                       }, /* command:	431	*/
	{ 0, 0, 0                       }, /* command:	432	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	433	ERR_NICKNAMEINUSE */
	{ 0, 0, 0                       }, /* command:	434	*/
	{ 0, 0, 0                       }, /* command:	435	*/
	{ 0, 0, 0                       }, /* command:	436	*/
	{ 0, 0, 0                       }, /* command:	437	*/
	{ 0, 0, 0                       }, /* command:	438	*/
	{ 0, 0, 0                       }, /* command:	439	*/
	{ 0, 0, 0                       }, /* command:	440	*/
	{ 0, 0, 0                       }, /* command:	441	*/
	{ 0, 0, 0                       }, /* command:	442	*/
	{ 0, 0, 0                       }, /* command:	443	*/
	{ 0, 0, 0                       }, /* command:	444	*/
	{ 0, 0, 0                       }, /* command:	445	*/
	{ 0, 0, 0                       }, /* command:	446	*/
	{ 0, 0, 0                       }, /* command:	447	*/
	{ 0, 0, 0                       }, /* command:	448	*/
	{ 0, 0, 0                       }, /* command:	449	*/
	{ 0, 0, 0                       }, /* command:	450	*/
	{ 1, 5, NUM_INPUTPARAMETERS_MAX }, /* command:	451	ERR_NOTREGISTERED */
	{ 0, 0, 0                       }, /* command:	452	*/
	{ 0, 0, 0                       }, /* command:	453	*/
	{ 0, 0, 0                       }, /* command:	454	*/
	{ 0, 0, 0                       }, /* command:	455	*/
	{ 0, 0, 0                       }, /* command:	456	*/
	{ 0, 0, 0                       }, /* command:	457	*/
	{ 0, 0, 0                       }, /* command:	458	*/
	{ 0, 0, 0                       }, /* command:	459	*/
	{ 0, 0, 0                       }, /* command:	460	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	461	ERR_NEEDMOREPARAMS   "<command> :Not enough parameters"*/
	{ 0, 0, 0                       }, /* command:	462	*/
	{ 0, 0, 0                       }, /* command:	463	*/
	{ 0, 0, 0                       }, /* command:	464	*/
	{ 0, 0, 0                       }, /* command:	465	*/
	{ 0, 0, 0                       }, /* command:	466	*/
	{ 0, 0, 0                       }, /* command:	467	*/
	{ 0, 0, 0                       }, /* command:	468	*/
	{ 0, 0, 0                       }, /* command:	469	*/
	{ 0, 0, 0                       }, /* command:	470	*/
	{ 0, 0, 0                       }, /* command:	471	*/
	{ 0, 0, 0                       }, /* command:	472	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	473	ERR_INVITEONLYCHAN   "<channel> :Cannot join channel (+i)" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	474	ERR_BANNEDFROMCHAN   "<channel> :Cannot join channel (+b)" */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	475	ERR_BADCHANNELKEY    "<channel> :Cannot join channel (+k)" */
	{ 0, 0, 0                       }, /* command:	476	*/
	{ 0, 0, 0                       }, /* command:	477	*/
	{ 0, 0, 0                       }, /* command:	478	*/
	{ 0, 0, 0                       }, /* command:	479	*/
	{ 0, 0, 0                       }, /* command:	480	*/
	{ 0, 0, 0                       }, /* command:	481	*/
	{ 0, 0, 0                       }, /* command:	482	*/
	{ 0, 0, 0                       }, /* command:	483	*/
	{ 0, 0, 0                       }, /* command:	484	*/
	{ 0, 0, 0                       }, /* command:	485	*/
	{ 0, 0, 0                       }, /* command:	486	*/
	{ 0, 0, 0                       }, /* command:	487	*/
	{ 0, 0, 0                       }, /* command:	488	*/
	{ 0, 0, 0                       }, /* command:	489	*/
	{ 0, 0, 0                       }, /* command:	490	*/
	{ 0, 0, 0                       }, /* command:	491	*/
	{ 0, 0, 0                       }, /* command:	492	*/
	{ 0, 0, 0                       }, /* command:	493	*/
	{ 0, 0, 0                       }, /* command:	494	*/
	{ 0, 0, 0                       }, /* command:	495	*/
	{ 0, 0, 0                       }, /* command:	496	*/
	{ 0, 0, 0                       }, /* command:	497	*/
	{ 0, 0, 0                       }, /* command:	498	*/
	{ 0, 0, 0                       }, /* command:	499	*/
	{ 0, 0, 0                       }, /* command:	500	*/
	{ 0, 0, 0                       }, /* command:	501	*/
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	502	ERR_USERSDONTMATCH   ":Cannot change mode for other users" */
	{ 0, 0, 0                       }, /* command:	503	*/
	{ 0, 0, 0                       }, /* command:	504	*/
	{ 0, 0, 0                       }, /* command:	505	*/
	{ 0, 0, 0                       }, /* command:	506	*/
	{ 0, 0, 0                       }, /* command:	507	*/
	{ 0, 0, 0                       }, /* command:	508	*/
	{ 0, 0, 0                       }, /* command:	509	*/
	{ 0, 0, 0                       }, /* command:	510	*/
	{ 0, 0, 0                       }, /* command:	511	*/
	{ 0, 0, 0                       }, /* command:	512	*/
	{ 0, 0, 0                       }, /* command:	513	*/
	{ 0, 0, 0                       }, /* command:	514	*/
	{ 0, 0, 0                       }, /* command:	515	*/
	{ 0, 0, 0                       }, /* command:	516	*/
	{ 0, 0, 0                       }, /* command:	517	*/
	{ 0, 0, 0                       }, /* command:	518	*/
	{ 0, 0, 0                       }, /* command:	519	*/
	{ 0, 0, 0                       }, /* command:	520	*/
	{ 0, 0, 0                       }, /* command:	521	*/
	{ 0, 0, 0                       }, /* command:	522	*/
	{ 0, 0, 0                       }, /* command:	523	*/
	{ 0, 0, 0                       }, /* command:	524	*/
	{ 0, 0, 0                       }, /* command:	525	*/
	{ 0, 0, 0                       }, /* command:	526	*/
	{ 0, 0, 0                       }, /* command:	527	*/
	{ 0, 0, 0                       }, /* command:	528	*/
	{ 0, 0, 0                       }, /* command:	529	*/
	{ 0, 0, 0                       }, /* command:	530	*/
	{ 0, 0, 0                       }, /* command:	531	*/
	{ 0, 0, 0                       }, /* command:	532	*/
	{ 0, 0, 0                       }, /* command:	533	*/
	{ 0, 0, 0                       }, /* command:	534	*/
	{ 0, 0, 0                       }, /* command:	535	*/
	{ 0, 0, 0                       }, /* command:	536	*/
	{ 0, 0, 0                       }, /* command:	537	*/
	{ 0, 0, 0                       }, /* command:	538	*/
	{ 0, 0, 0                       }, /* command:	539	*/
	{ 0, 0, 0                       }, /* command:	540	*/
	{ 0, 0, 0                       }, /* command:	541	*/
	{ 0, 0, 0                       }, /* command:	542	*/
	{ 0, 0, 0                       }, /* command:	543	*/
	{ 0, 0, 0                       }, /* command:	544	*/
	{ 0, 0, 0                       }, /* command:	545	*/
	{ 0, 0, 0                       }, /* command:	546	*/
	{ 0, 0, 0                       }, /* command:	547	*/
	{ 0, 0, 0                       }, /* command:	548	*/
	{ 0, 0, 0                       }, /* command:	549	*/
	{ 0, 0, 0                       }, /* command:	550	*/
	{ 0, 0, 0                       }, /* command:	551	*/
	{ 0, 0, 0                       }, /* command:	552	*/
	{ 0, 0, 0                       }, /* command:	553	*/
	{ 0, 0, 0                       }, /* command:	554	*/
	{ 0, 0, 0                       }, /* command:	555	*/
	{ 0, 0, 0                       }, /* command:	556	*/
	{ 0, 0, 0                       }, /* command:	557	*/
	{ 0, 0, 0                       }, /* command:	558	*/
	{ 0, 0, 0                       }, /* command:	559	*/
	{ 0, 0, 0                       }, /* command:	560	*/
	{ 0, 0, 0                       }, /* command:	561	*/
	{ 0, 0, 0                       }, /* command:	562	*/
	{ 0, 0, 0                       }, /* command:	563	*/
	{ 0, 0, 0                       }, /* command:	564	*/
	{ 0, 0, 0                       }, /* command:	565	*/
	{ 0, 0, 0                       }, /* command:	566	*/
	{ 0, 0, 0                       }, /* command:	567	*/
	{ 0, 0, 0                       }, /* command:	568	*/
	{ 0, 0, 0                       }, /* command:	569	*/
	{ 0, 0, 0                       }, /* command:	570	*/
	{ 0, 0, 0                       }, /* command:	571	*/
	{ 0, 0, 0                       }, /* command:	572	*/
	{ 0, 0, 0                       }, /* command:	573	*/
	{ 0, 0, 0                       }, /* command:	574	*/
	{ 0, 0, 0                       }, /* command:	575	*/
	{ 0, 0, 0                       }, /* command:	576	*/
	{ 0, 0, 0                       }, /* command:	577	*/
	{ 0, 0, 0                       }, /* command:	578	*/
	{ 0, 0, 0                       }, /* command:	579	*/
	{ 0, 0, 0                       }, /* command:	580	*/
	{ 0, 0, 0                       }, /* command:	581	*/
	{ 0, 0, 0                       }, /* command:	582	*/
	{ 0, 0, 0                       }, /* command:	583	*/
	{ 0, 0, 0                       }, /* command:	584	*/
	{ 0, 0, 0                       }, /* command:	585	*/
	{ 0, 0, 0                       }, /* command:	586	*/
	{ 0, 0, 0                       }, /* command:	587	*/
	{ 0, 0, 0                       }, /* command:	588	*/
	{ 0, 0, 0                       }, /* command:	589	*/
	{ 0, 0, 0                       }, /* command:	590	*/
	{ 0, 0, 0                       }, /* command:	591	*/
	{ 0, 0, 0                       }, /* command:	592	*/
	{ 0, 0, 0                       }, /* command:	593	*/
	{ 0, 0, 0                       }, /* command:	594	*/
	{ 0, 0, 0                       }, /* command:	595	*/
	{ 0, 0, 0                       }, /* command:	596	*/
	{ 0, 0, 0                       }, /* command:	597	*/
	{ 0, 0, 0                       }, /* command:	598	*/
	{ 0, 0, 0                       }, /* command:	599	*/
	{ 1, 4, 4                       }, /* command:	600	PROTOCOL_PONG_NUMBER      */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	601	PROTOCOL_PRIVMSG          */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	602	PROTOCOL_NOTICE           */
	{ 1, 3, 3                       }, /* command:	603	PROTOCOL_JOIN             */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	604	PROTOCOL_PART             */
	{ 1, 3, NUM_INPUTPARAMETERS_MAX }, /* command:	605	PROTOCOL_QUIT             */
	{ 1, 3, 3                       }, /* command:	606	PROTOCOL_NICK             */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	607	PROTOCOL_MODE             */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	608	PROTOCOL_KICK             */
	{ 1, 4, NUM_INPUTPARAMETERS_MAX }, /* command:	609	PROTOCOL_TOPIC            */
	{ 1, 2, 2                       }, /* command:	610	PROTOCOL_PING             */
	{ 1, 3, NUM_INPUTPARAMETERS_MAX }, /* command:	611	PROTOCOL_WALLOPS          */
	{ 1, 3, NUM_INPUTPARAMETERS_MAX }  /* command:	612	PROTOCOL_NUM_SERVERNOTICE */
};

#else

extern struct Input_Parameters input_params[PROTOCOL_HIGHEST_NUMBER+1];

#endif /* ifdef _MAIN_CC_ */

#endif /* ifndef _INPUT_PARAMETERS_H_ */
