/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#define CLIENT_VERSION "0.5.0"
/* Wait time for Input in Microseconds (1'000'000 microsec = 1 sec) :) */
#define IO_INPUT_WAITLEN 500000
#define INPUT_LEN_MAX 512
#define NUM_INPUTPARAMETERS_MAX 256
#define SERVER_NAME_LEN 256
#define NICKNAME_LEN 32
#define REALNAME_LEN 64
#define CHANNELS_MAX 24 /* f1 - f12 */
#define CHANNELS_MAX_STRLEN 2  /* if you set a CHANNELS_MAX of more than 99 or less than 10 update this ! */
#define CHANNELS_NAME_LEN 64
#define TOPIC_LEN_MAX 512
#define COMMAND_MAX 25
#define COMMAND_LEN 256
/* how long one message can be  replace this name with
 * #define MESSAGE_LEN_MAX 1024 */
#define LINEBUF_LEN 512
/* how many lines we store */
#define NUM_LINES 1000
/* READ_BUFLEN is also used for writing the config-file */
#define READ_BUFLEN 512
#define INPUT_BUFFER_LEN 2048
#define ONELINE_READ_MAXLEN 1024
#define HELP_BUF_LEN 512
/* The maximum len that a command from the irc-server can have */
#define MAX_COMMAND_LEN 10
/* Delay between 2 ping commands in seconds */
#define DELAY_BETWEEN_PING 30
/* the time between 2 connect retryings in seconds */
#define TIME_BETWEEN_CONNECT_RETRY 10
#define SCREEN_NOT_USED "This Screen is not used yet!"
#define LEAVE_MSG_LEN 256
#define TIME_AND_NICKLEN 19 /* timelen is atm 7, so we have 12 chars left*/
#define TIMESTAMP_LEN 11
#define PARAMETER_MAX_PARAMS 2048
#define PARAMETER_MAX_STRLEN 512
#define MODE_TO_SET_LEN 64
#define PART_QUIT_MSG_LEN 256
#define CTCP_VERSION_REPLY "Netwalker IRC-Client"

#define FILES_HELP_DIRECTORY       "/usr/share/netwalker-ircc/"
#define FILES_HELP_INDEX_FILE      "/helpindex.asc"
#define FILES_CONFIG_FILE          "/.netwalkerircc.conf"

/* some default values */
#define DEFAULT_NICKNAME           "ABC"
#define DEFAULT_REALNAME           "This lame user did not read the config file."
#define DEFAULT_SERVERNAME         "irc.freenode.net"
#define DEFAULT_PORT_STR           "6667"
#define DEFAULT_PORT_NUM           6667
#define DEFAULT_MODES              "iw"
#define DEFAULT_PART_QUIT_MSG      "Netwalker IRC-Client (http://lancelot2k.dyndns.org) Version: " CLIENT_VERSION
#define DEFAULT_AUTOCONNECT        1
#define DEFAULT_AUTOCONNECT_STR    "yes"
#define DEFAULT_AUTORECONNECT      1
#define DEFAULT_AUTORECONNECT_STR  "yes"

/* some display options */
#define DISPLAY_DEFAULT        "---"
#define DISPLAY_NOTICE         "\2-=NOTICE=-\2"
#define DISPLAY_PART           "<--- "
#define DISPLAY_QUIT           "<--- "
#define DISPLAY_JOIN           "---> "
#define DISPLAY_SERVERMSG      "==="
#define DISPLAY_NOTIMPLEMENTED "\2-=!!!=-\2"
#define DISPLAY_NOTPARSED      "\2!PARSE-ERROR!\2"
#define DISPLAY_ERROR          "\2!ERROR!\2"
#define DISPLAY_AUTHINFO       "***"
#define DISPLAY_HELP           "\2-=HELP=-\2"
#define DISPLAY_CTCP           "\2-=CTCP=-\2"
#define DISPLAY_NICKNAME       "\2-=NICK=-\2"
#define DISPLAY_MODE           "\2-=MODE=-\2"
#define DISPLAY_KICK           "\2-=KICK=-\2"
#define DISPLAY_TOPIC          "\2-=TOPIC=-\2"
#define DISPLAY_USERLIST       "\2-=USERS=-\2"
#define DISPLAY_MEACTION       ""
#define DISPLAY_WALLOPS        "\2-=WALLOP=-\2"
#define DISPLAY_RAWTEXT        "\2!UNPARSED!\2"

/* messages */
#define MESSAGE_CONNECTED        "Connection established"
#define MESSAGE_DISCONNECT       "Disconnected from server"
#define MESSAGE_ABORTED          "Connection aborted by server"
#define MESSAGE_REFUSED          "Connection refused by server"
#define MESSAGE_RESET            "Connection reset by server"
#define MESSAGE_ERR_PTHREAD      "pthread error !!!"
#define MESSAGE_HOST_LOOKUP      "looking up "
#define MESSAGE_HOST_LOOKUP_OK   "host lookup successfully"
#define MESSAGE_HOST_NOTFOUND    "host not found !!!"

/* format options */
#define FORMAT_BOLD_NUM       2
#define FORMAT_COLOR_NUM      3
#define FORMAT_UNDERLINE_NUM  31
#define FORMAT_RESET_NUM      15

/* numbers for irc protocol commands
 * if you change this numbers you also have to change the values in input_parameters.h */
#define PROTOCOL_NUM_PONG         600
#define PROTOCOL_NUM_PRIVMSG      601
#define PROTOCOL_NUM_NOTICE       602
#define PROTOCOL_NUM_JOIN         603
#define PROTOCOL_NUM_PART         604
#define PROTOCOL_NUM_QUIT         605
#define PROTOCOL_NUM_NICK         606
#define PROTOCOL_NUM_MODE         607
#define PROTOCOL_NUM_KICK         608
#define PROTOCOL_NUM_TOPIC        609
#define PROTOCOL_NUM_PING         610
#define PROTOCOL_NUM_WALLOPS      611
#define PROTOCOL_NUM_SERVERNOTICE 612
#define PROTOCOL_HIGHEST_NUMBER   612 /* allways update this */

/* status */

#define STATUS_NOTHING                 0 /* no connection established and no try to establish one                    */
#define STATUS_RESOLV_IN_PROGRESS      1 /* name resolv in progress but not yet finished                             */
#define STATUS_RESOLVING_FINISHED      2 /* name resolved and not yet used to connect to somewhere                   */
#define STATUS_SYN_SENT                3 /* SYN packet sent but no connection established                            */
#define STATUS_CONNECTED               4 /* connected to the server                                                  */
#define STATUS_LOGIN_TRIED             5 /* we tried to login to the irc-server, but we didnt receive a response yet */
#define STATUS_ALL_OK                  6 /* we are successfully connected and loged in !                             */
#define STATUS_MAX_NUM                 6 /* allways update this                                                      */
