/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>
#include <nd_gui.h>
#include <nd_protocol_inst.h>
#include <nd_protocol.h>

#define  ND_PINF_KEY  "nd_pinf_gui"

LND_ProtoInfo     *
nd_proto_info_new(LND_Protocol *proto, guint nesting)
{
  LND_ProtoInfo *pinf = libnd_proto_info_new(proto, nesting);
  ND_ProtoInfo *pinf_gui;

  if (!pinf)
    return NULL;

  if (! (pinf_gui = g_new0(ND_ProtoInfo, 1)))
    return NULL;

  libnd_reg_set_data(pinf->registry, ND_PINF_KEY, pinf_gui);

  return pinf;
}


void              
nd_proto_info_free(LND_ProtoInfo *pinf)
{
  ND_ProtoInfo *pinf_gui;

  if ( (pinf_gui = libnd_reg_del_data(pinf->registry, ND_PINF_KEY)))
    g_free(pinf_gui);

  libnd_proto_info_free(pinf);
}


ND_ProtoInfo     *
nd_proto_info_get(const LND_ProtoInfo *pinf)
{
  ND_ProtoInfo *pinf_gui;

  if (!pinf)
    return NULL;
  
  pinf_gui = libnd_reg_get_data(pinf->registry, ND_PINF_KEY);
  D_ASSERT_PTR(pinf_gui);

  return pinf_gui;
}


void           
nd_proto_info_field_set_state(LND_ProtoInfo *pinf,
			      ND_ProtoField *field,
			      ND_ProtoFieldState state)
{
  GtkWidget *button;


  /* Note -- we cannot store any information for a single field
     in the field structure directly, since the field structures
     are only templates, but the actual buttons exist once per
     trace file. */

  if (!pinf || !field)
    return;

  button = libnd_reg_get_data(pinf->registry, nd_proto_field_to_string(field));
  
  D_ASSERT_PTR(button);
  if (!button)
    return;
  
  switch (state)
    {
    case ND_FIELD_STATE_ERROR:
      /* Paint the field in a gorgeous bright red: */
      nd_gui_widget_set_color(button, ND_COLOR_RED);

      break;
    case ND_FIELD_STATE_UNKN:
      nd_gui_widget_set_color(button, ND_COLOR_YELLOW);
      break;

    default:
      nd_gui_widget_set_color(button, ND_COLOR_BG);
    }
}
