/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_filter_gui_h
#define __nd_filter_gui_h

#include <nd.h>


void             nd_filter_dialog_init(void);

/**
 * nd_filter_dialog_show - shows the filter management dialog.
 */
void             nd_filter_dialog_show(void);


/**
 * nd_filter_dialog_hide - hides the filter management dialog.
 */
void             nd_filter_dialog_hide(void);


/**
 * nd_filter_dialog_create - creates a new filter.
 *
 * The function calls the callback defined for creating
 * a new filter via the GUI, as defined by the currently
 * selected filter factory.
 */
void             nd_filter_dialog_create(void);


/* The following are GUI callbacks and used internally. */
void             nd_filter_dialog_update(void);
void             nd_filter_dialog_delete(void);
void             nd_filter_dialog_modify(void);

void             nd_trace_filter_dialog_show(void);

/* The following are GUI callbacks and used internally. */
void             nd_trace_filter_dialog_apply_filters(void);
void             nd_trace_filter_dialog_cancel(void);

#endif

