/*

Copyright (C) 2008 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_pcap_h
#define __nd_pcap_h

#include <nd.h>
#include <nd_protocol.h>
#include <nd_gui.h>

/* These are the implementations for pcap packet headers of LND_Protocol's callbacks: */
GtkWidget *nd_pcap_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_pcap_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);
void       nd_pcap_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_pcap_header_complete(const LND_Packet *packet, guint nesting);

/* Generic accessor function for the Ethernet Protocol implementation: */
ND_Protocol *nd_pcap_get_gui(void);
LND_Protocol *nd_pcap_get(void);

/* Helper functions to set a trace's pcap GUI table to a packet's content: */
void       nd_pcap_set_tv_sec(LND_ProtoInfo *pinf, const struct pcap_pkthdr *hdr);
void       nd_pcap_set_tv_usec(LND_ProtoInfo *pinf, const struct pcap_pkthdr *hdr);
void       nd_pcap_set_caplen(LND_ProtoInfo *pinf, const struct pcap_pkthdr *hdr);
void       nd_pcap_set_len(LND_ProtoInfo *pinf, const struct pcap_pkthdr *hdr);

#endif
