/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <nd.h>
#include <nd_gui.h>
#include <nd_packet.h>
#include <nd_dialog.h>

#include <nd_ether.h>


static void
ether_shost_okay_cb (guchar     *address,
		     int         address_len,
		     LND_Packet *packet,
		     void       *user_data)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct ether_header  *eh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_ether_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      eh = (struct ether_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_ether_get(), nesting);
      if (!eh)
	continue;

      memcpy(eh->ether_shost, address, ETHER_ADDR_LEN);
      libnd_packet_modified(libnd_pit_get(&pit));
    }

  return;
  TOUCH(address_len);
  TOUCH(user_data);
}


void
nd_ether_src_addr_cb(LND_Packet  *packet,
		     guchar      *header,
		     guchar      *data)
{
  struct ether_header  *eh;

  eh = (struct ether_header *) header;
  nd_dialog_hardware_address(_("Enter MAC dest. address:"),
			     eh->ether_shost, 6,
			     ether_shost_okay_cb,
			     NULL,
			     packet, data);
}


static void
ether_dhost_okay_cb (guchar     *address,
		     int         address_len,
		     LND_Packet *packet,
		     void       *user_data)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct ether_header  *eh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_ether_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      eh = (struct ether_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_ether_get(), nesting);
      if (!eh)
	continue;

      memcpy(eh->ether_dhost, address, ETHER_ADDR_LEN);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(address_len);
  TOUCH(user_data);
}


void
nd_ether_dest_addr_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data)
{
  struct ether_header  *eh;

  eh = (struct ether_header *) header;
  nd_dialog_hardware_address(_("Enter MAC dest. address:"),
			     eh->ether_dhost, 6,
			     ether_dhost_okay_cb,
			     NULL,
			     packet, data);
}



/* The callback that gets called when the user has clicked
   one of the predefined Ethernet protocol values: */
void    
nd_ether_type_value_cb(LND_Packet  *packet,
		       guchar      *header,
		       int          value)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct ether_header  *eh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_ether_get(), header);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      eh = (struct ether_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_ether_get(), nesting);
      if (!eh)
	continue;

      eh->ether_type = htons((guint16) value);
      libnd_packet_update(packet, nd_ether_get(), nesting);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
  
  return;
  TOUCH(header);
}


/* The callback that gets called when the user selected "Custom"
   from the Ethernet protocol type menu, and then clicked "Okay": */
static void
ether_prot_custom_okay_cb(LND_Packet *packet, void *user_data, guint value)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct ether_header  *eh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_ether_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      eh = (struct ether_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_ether_get(), nesting);
      if (!eh)
	continue;

      eh->ether_type = htons((guint16) value);
      libnd_packet_update(packet, nd_ether_get(), nesting);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
}


/* The callback that gets called when the user selected "Custom"
   from the Ethernet protocol type menu: */
void    
nd_ether_type_custom_cb(LND_Packet  *packet,
			guchar      *header,
			int          value)
{
  struct ether_header   *eh;
  
  eh = (struct ether_header *) header;
  nd_dialog_number(_("Enter protocol number:"),
		   ND_BASE_DEC,
		   ntohs(eh->ether_type),
		   65535,
		   ether_prot_custom_okay_cb,
		   NULL,
		   packet, header);

  return;
  TOUCH(value);
}


/* The callback that gets called when the user clicks the button
   for the Ethernet protocol type in the table. Pops up the menu. */
void
nd_ether_lengthtype_cb(LND_Packet  *packet,
		       guchar      *header,
		       guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(ether_menu_type_data);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
      
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}
