// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- Channel ---

// ChannelStatusValues defines the type-safe values for Channel.Status context
type ChannelStatusValues struct {
	Inactive     int64
	Binding      int64
	Starting     int64
	Running      int64
	Stopping     int64
	Retrying     int64
	Stopped      int64
	Requesting   int64
	Paused       int64
	Disconnected int64
	Initializing int64
	Switching    int64
}

// ChannelStatusContext provides type-safe operations for Channel.Status context
type ChannelStatusContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.Status context
func (c ChannelStatusContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"inactive":     values.Inactive,
		"binding":      values.Binding,
		"starting":     values.Starting,
		"running":      values.Running,
		"stopping":     values.Stopping,
		"retrying":     values.Retrying,
		"stopped":      values.Stopped,
		"requesting":   values.Requesting,
		"paused":       values.Paused,
		"disconnected": values.Disconnected,
		"initializing": values.Initializing,
		"switching":    values.Switching,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatusContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelMessagesValues defines the type-safe values for Channel.Messages context
type ChannelMessagesValues struct {
	Messages int64
}

// ChannelMessagesContext provides type-safe operations for Channel.Messages context
type ChannelMessagesContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.Messages context
func (c ChannelMessagesContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"messages": values.Messages,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelBytesValues defines the type-safe values for Channel.Bytes context
type ChannelBytesValues struct {
	Bytes int64
}

// ChannelBytesContext provides type-safe operations for Channel.Bytes context
type ChannelBytesContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.Bytes context
func (c ChannelBytesContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelBytesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"bytes": values.Bytes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelBytesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelBatchesValues defines the type-safe values for Channel.Batches context
type ChannelBatchesValues struct {
	Batches int64
}

// ChannelBatchesContext provides type-safe operations for Channel.Batches context
type ChannelBatchesContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.Batches context
func (c ChannelBatchesContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelBatchesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"batches": values.Batches,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelBatchesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelBatchSizeValues defines the type-safe values for Channel.BatchSize context
type ChannelBatchSizeValues struct {
	Batch_size int64
}

// ChannelBatchSizeContext provides type-safe operations for Channel.BatchSize context
type ChannelBatchSizeContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.BatchSize context
func (c ChannelBatchSizeContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelBatchSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"batch_size": values.Batch_size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelBatchSizeContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelBatchIntervalValues defines the type-safe values for Channel.BatchInterval context
type ChannelBatchIntervalValues struct {
	Batch_interval int64
}

// ChannelBatchIntervalContext provides type-safe operations for Channel.BatchInterval context
type ChannelBatchIntervalContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.BatchInterval context
func (c ChannelBatchIntervalContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelBatchIntervalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"batch_interval": values.Batch_interval,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelBatchIntervalContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelIntervalsValues defines the type-safe values for Channel.Intervals context
type ChannelIntervalsValues struct {
	Disc_interval       int64
	Hb_interval         int64
	Keep_alive_interval int64
}

// ChannelIntervalsContext provides type-safe operations for Channel.Intervals context
type ChannelIntervalsContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.Intervals context
func (c ChannelIntervalsContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelIntervalsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"disc_interval":       values.Disc_interval,
		"hb_interval":         values.Hb_interval,
		"keep_alive_interval": values.Keep_alive_interval,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelIntervalsContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelShortRetryCountValues defines the type-safe values for Channel.ShortRetryCount context
type ChannelShortRetryCountValues struct {
	Short_retry int64
}

// ChannelShortRetryCountContext provides type-safe operations for Channel.ShortRetryCount context
type ChannelShortRetryCountContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.ShortRetryCount context
func (c ChannelShortRetryCountContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelShortRetryCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"short_retry": values.Short_retry,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelShortRetryCountContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelLongRetryIntervalValues defines the type-safe values for Channel.LongRetryInterval context
type ChannelLongRetryIntervalValues struct {
	Long_retry int64
}

// ChannelLongRetryIntervalContext provides type-safe operations for Channel.LongRetryInterval context
type ChannelLongRetryIntervalContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.LongRetryInterval context
func (c ChannelLongRetryIntervalContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelLongRetryIntervalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"long_retry": values.Long_retry,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelLongRetryIntervalContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelMaxMessageLengthValues defines the type-safe values for Channel.MaxMessageLength context
type ChannelMaxMessageLengthValues struct {
	Max_msg_length int64
}

// ChannelMaxMessageLengthContext provides type-safe operations for Channel.MaxMessageLength context
type ChannelMaxMessageLengthContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.MaxMessageLength context
func (c ChannelMaxMessageLengthContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelMaxMessageLengthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"max_msg_length": values.Max_msg_length,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelMaxMessageLengthContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelSharingConversationsValues defines the type-safe values for Channel.SharingConversations context
type ChannelSharingConversationsValues struct {
	Sharing_conversations int64
}

// ChannelSharingConversationsContext provides type-safe operations for Channel.SharingConversations context
type ChannelSharingConversationsContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.SharingConversations context
func (c ChannelSharingConversationsContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelSharingConversationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"sharing_conversations": values.Sharing_conversations,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelSharingConversationsContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelNetworkPriorityValues defines the type-safe values for Channel.NetworkPriority context
type ChannelNetworkPriorityValues struct {
	Network_priority int64
}

// ChannelNetworkPriorityContext provides type-safe operations for Channel.NetworkPriority context
type ChannelNetworkPriorityContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.NetworkPriority context
func (c ChannelNetworkPriorityContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelNetworkPriorityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"network_priority": values.Network_priority,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelNetworkPriorityContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelBufferCountsValues defines the type-safe values for Channel.BufferCounts context
type ChannelBufferCountsValues struct {
	Sent     int64
	Received int64
}

// ChannelBufferCountsContext provides type-safe operations for Channel.BufferCounts context
type ChannelBufferCountsContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.BufferCounts context
func (c ChannelBufferCountsContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelBufferCountsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"sent":     values.Sent,
		"received": values.Received,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelBufferCountsContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelCurrentMessagesValues defines the type-safe values for Channel.CurrentMessages context
type ChannelCurrentMessagesValues struct {
	Current int64
}

// ChannelCurrentMessagesContext provides type-safe operations for Channel.CurrentMessages context
type ChannelCurrentMessagesContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.CurrentMessages context
func (c ChannelCurrentMessagesContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelCurrentMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelCurrentMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelXmitQueueTimeValues defines the type-safe values for Channel.XmitQueueTime context
type ChannelXmitQueueTimeValues struct {
	Xmitq_time int64
}

// ChannelXmitQueueTimeContext provides type-safe operations for Channel.XmitQueueTime context
type ChannelXmitQueueTimeContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.XmitQueueTime context
func (c ChannelXmitQueueTimeContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelXmitQueueTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"xmitq_time": values.Xmitq_time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelXmitQueueTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelMCAStatusValues defines the type-safe values for Channel.MCAStatus context
type ChannelMCAStatusValues struct {
	Mca_status int64
}

// ChannelMCAStatusContext provides type-safe operations for Channel.MCAStatus context
type ChannelMCAStatusContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.MCAStatus context
func (c ChannelMCAStatusContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelMCAStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"mca_status": values.Mca_status,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelMCAStatusContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelInDoubtStatusValues defines the type-safe values for Channel.InDoubtStatus context
type ChannelInDoubtStatusValues struct {
	Indoubt_status int64
}

// ChannelInDoubtStatusContext provides type-safe operations for Channel.InDoubtStatus context
type ChannelInDoubtStatusContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.InDoubtStatus context
func (c ChannelInDoubtStatusContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelInDoubtStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"indoubt_status": values.Indoubt_status,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelInDoubtStatusContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelSSLKeyResetsValues defines the type-safe values for Channel.SSLKeyResets context
type ChannelSSLKeyResetsValues struct {
	Ssl_key_resets int64
}

// ChannelSSLKeyResetsContext provides type-safe operations for Channel.SSLKeyResets context
type ChannelSSLKeyResetsContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.SSLKeyResets context
func (c ChannelSSLKeyResetsContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelSSLKeyResetsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"ssl_key_resets": values.Ssl_key_resets,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelSSLKeyResetsContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelNPMSpeedValues defines the type-safe values for Channel.NPMSpeed context
type ChannelNPMSpeedValues struct {
	Npm_speed int64
}

// ChannelNPMSpeedContext provides type-safe operations for Channel.NPMSpeed context
type ChannelNPMSpeedContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.NPMSpeed context
func (c ChannelNPMSpeedContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelNPMSpeedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"npm_speed": values.Npm_speed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelNPMSpeedContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelCurrentSharingConversationsValues defines the type-safe values for Channel.CurrentSharingConversations context
type ChannelCurrentSharingConversationsValues struct {
	Current_sharing int64
}

// ChannelCurrentSharingConversationsContext provides type-safe operations for Channel.CurrentSharingConversations context
type ChannelCurrentSharingConversationsContext struct {
	framework.Context[ChannelLabels]
}

// Set provides type-safe dimension setting for Channel.CurrentSharingConversations context
func (c ChannelCurrentSharingConversationsContext) Set(state *framework.CollectorState, labels ChannelLabels, values ChannelCurrentSharingConversationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current_sharing": values.Current_sharing,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelCurrentSharingConversationsContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelLabels defines the required labels for Channel contexts
type ChannelLabels struct {
	Channel string
	Type    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ChannelLabels) InstanceID(contextName string) string {
	// Label order from YAML: channel, type
	return contextName + "." + cleanLabelValue(l.Channel) + "_" + cleanLabelValue(l.Type)
}

// Channel contains all metric contexts for Channel
var Channel = struct {
	Status                      ChannelStatusContext
	Messages                    ChannelMessagesContext
	Bytes                       ChannelBytesContext
	Batches                     ChannelBatchesContext
	BatchSize                   ChannelBatchSizeContext
	BatchInterval               ChannelBatchIntervalContext
	Intervals                   ChannelIntervalsContext
	ShortRetryCount             ChannelShortRetryCountContext
	LongRetryInterval           ChannelLongRetryIntervalContext
	MaxMessageLength            ChannelMaxMessageLengthContext
	SharingConversations        ChannelSharingConversationsContext
	NetworkPriority             ChannelNetworkPriorityContext
	BufferCounts                ChannelBufferCountsContext
	CurrentMessages             ChannelCurrentMessagesContext
	XmitQueueTime               ChannelXmitQueueTimeContext
	MCAStatus                   ChannelMCAStatusContext
	InDoubtStatus               ChannelInDoubtStatusContext
	SSLKeyResets                ChannelSSLKeyResetsContext
	NPMSpeed                    ChannelNPMSpeedContext
	CurrentSharingConversations ChannelCurrentSharingConversationsContext
}{
	Status: ChannelStatusContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.status",
			Family:      "channels/overview",
			Title:       "Channel Status",
			Units:       "status",
			Type:        module.Stacked,
			Priority:    3000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "inactive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "binding",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "starting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "running",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "stopping",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "retrying",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "stopped",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "requesting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "paused",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "disconnected",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "initializing",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "switching",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Messages: ChannelMessagesContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.messages",
			Family:      "channels/overview",
			Title:       "Channel Message Rate",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    3001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "messages",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Bytes: ChannelBytesContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.bytes",
			Family:      "channels/overview",
			Title:       "Channel Data Transfer Rate",
			Units:       "bytes/s",
			Type:        module.Line,
			Priority:    3002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "bytes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Batches: ChannelBatchesContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.batches",
			Family:      "channels/overview",
			Title:       "Channel Batch Rate",
			Units:       "batches/s",
			Type:        module.Line,
			Priority:    3003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	BatchSize: ChannelBatchSizeContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.batch_size",
			Family:      "channels/overview",
			Title:       "Channel Batch Size",
			Units:       "messages",
			Type:        module.Line,
			Priority:    3004,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "batch_size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	BatchInterval: ChannelBatchIntervalContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.batch_interval",
			Family:      "channels/overview",
			Title:       "Channel Batch Interval",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    3005,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "batch_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Intervals: ChannelIntervalsContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.intervals",
			Family:      "channels/overview",
			Title:       "Channel Intervals",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    3006,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "disc_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "hb_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "keep_alive_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	ShortRetryCount: ChannelShortRetryCountContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.short_retry_count",
			Family:      "channels/overview",
			Title:       "Channel Short Retry Count",
			Units:       "retries",
			Type:        module.Line,
			Priority:    3007,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "short_retry",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	LongRetryInterval: ChannelLongRetryIntervalContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.long_retry_interval",
			Family:      "channels/overview",
			Title:       "Channel Long Retry Interval",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    3008,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "long_retry",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	MaxMessageLength: ChannelMaxMessageLengthContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.max_msg_length",
			Family:      "channels/overview",
			Title:       "Channel Max Message Length",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    3009,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "max_msg_length",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	SharingConversations: ChannelSharingConversationsContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.sharing_conversations",
			Family:      "channels/overview",
			Title:       "Channel Sharing Conversations",
			Units:       "conversations",
			Type:        module.Line,
			Priority:    3010,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "sharing_conversations",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	NetworkPriority: ChannelNetworkPriorityContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.network_priority",
			Family:      "channels/overview",
			Title:       "Channel Network Priority",
			Units:       "priority",
			Type:        module.Line,
			Priority:    3011,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "network_priority",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	BufferCounts: ChannelBufferCountsContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.buffer_counts",
			Family:      "channels/overview",
			Title:       "Channel Buffer Counts",
			Units:       "buffers",
			Type:        module.Line,
			Priority:    3012,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "sent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "received",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	CurrentMessages: ChannelCurrentMessagesContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.current_messages",
			Family:      "channels/overview",
			Title:       "Channel Current Messages",
			Units:       "messages",
			Type:        module.Line,
			Priority:    3013,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	XmitQueueTime: ChannelXmitQueueTimeContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.xmitq_time",
			Family:      "channels/overview",
			Title:       "Channel Transmission Queue Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    3014,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "xmitq_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	MCAStatus: ChannelMCAStatusContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.mca_status",
			Family:      "channels/overview",
			Title:       "Channel MCA Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    3015,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "mca_status",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	InDoubtStatus: ChannelInDoubtStatusContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.indoubt_status",
			Family:      "channels/overview",
			Title:       "Channel In-Doubt Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    3016,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "indoubt_status",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	SSLKeyResets: ChannelSSLKeyResetsContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.ssl_key_resets",
			Family:      "channels/overview",
			Title:       "Channel SSL Key Resets",
			Units:       "resets",
			Type:        module.Line,
			Priority:    3017,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "ssl_key_resets",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	NPMSpeed: ChannelNPMSpeedContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.npm_speed",
			Family:      "channels/overview",
			Title:       "Channel Non-Persistent Message Speed",
			Units:       "speed",
			Type:        module.Line,
			Priority:    3018,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "npm_speed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	CurrentSharingConversations: ChannelCurrentSharingConversationsContext{
		Context: framework.Context[ChannelLabels]{
			Name:        "mq.channel.current_sharing_convs",
			Family:      "channels/overview",
			Title:       "Channel Current Sharing Conversations",
			Units:       "conversations",
			Type:        module.Line,
			Priority:    3019,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current_sharing",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
}

// --- ChannelStatistics ---

// ChannelStatisticsMessagesValues defines the type-safe values for ChannelStatistics.Messages context
type ChannelStatisticsMessagesValues struct {
	Messages int64
}

// ChannelStatisticsMessagesContext provides type-safe operations for ChannelStatistics.Messages context
type ChannelStatisticsMessagesContext struct {
	framework.Context[ChannelStatisticsLabels]
}

// Set provides type-safe dimension setting for ChannelStatistics.Messages context
func (c ChannelStatisticsMessagesContext) Set(state *framework.CollectorState, labels ChannelStatisticsLabels, values ChannelStatisticsMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"messages": values.Messages,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatisticsMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelStatisticsBytesValues defines the type-safe values for ChannelStatistics.Bytes context
type ChannelStatisticsBytesValues struct {
	Bytes int64
}

// ChannelStatisticsBytesContext provides type-safe operations for ChannelStatistics.Bytes context
type ChannelStatisticsBytesContext struct {
	framework.Context[ChannelStatisticsLabels]
}

// Set provides type-safe dimension setting for ChannelStatistics.Bytes context
func (c ChannelStatisticsBytesContext) Set(state *framework.CollectorState, labels ChannelStatisticsLabels, values ChannelStatisticsBytesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"bytes": values.Bytes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatisticsBytesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelStatisticsBatchesValues defines the type-safe values for ChannelStatistics.Batches context
type ChannelStatisticsBatchesValues struct {
	Full_batches       int64
	Incomplete_batches int64
}

// ChannelStatisticsBatchesContext provides type-safe operations for ChannelStatistics.Batches context
type ChannelStatisticsBatchesContext struct {
	framework.Context[ChannelStatisticsLabels]
}

// Set provides type-safe dimension setting for ChannelStatistics.Batches context
func (c ChannelStatisticsBatchesContext) Set(state *framework.CollectorState, labels ChannelStatisticsLabels, values ChannelStatisticsBatchesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"full_batches":       values.Full_batches,
		"incomplete_batches": values.Incomplete_batches,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatisticsBatchesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelStatisticsBatchSizeValues defines the type-safe values for ChannelStatistics.BatchSize context
type ChannelStatisticsBatchSizeValues struct {
	Avg_batch_size int64
}

// ChannelStatisticsBatchSizeContext provides type-safe operations for ChannelStatistics.BatchSize context
type ChannelStatisticsBatchSizeContext struct {
	framework.Context[ChannelStatisticsLabels]
}

// Set provides type-safe dimension setting for ChannelStatistics.BatchSize context
func (c ChannelStatisticsBatchSizeContext) Set(state *framework.CollectorState, labels ChannelStatisticsLabels, values ChannelStatisticsBatchSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"avg_batch_size": values.Avg_batch_size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatisticsBatchSizeContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelStatisticsPutRetriesValues defines the type-safe values for ChannelStatistics.PutRetries context
type ChannelStatisticsPutRetriesValues struct {
	Put_retries int64
}

// ChannelStatisticsPutRetriesContext provides type-safe operations for ChannelStatistics.PutRetries context
type ChannelStatisticsPutRetriesContext struct {
	framework.Context[ChannelStatisticsLabels]
}

// Set provides type-safe dimension setting for ChannelStatistics.PutRetries context
func (c ChannelStatisticsPutRetriesContext) Set(state *framework.CollectorState, labels ChannelStatisticsLabels, values ChannelStatisticsPutRetriesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"put_retries": values.Put_retries,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ChannelStatisticsPutRetriesContext) SetUpdateEvery(state *framework.CollectorState, labels ChannelStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ChannelStatisticsLabels defines the required labels for ChannelStatistics contexts
type ChannelStatisticsLabels struct {
	Channel string
	Type    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ChannelStatisticsLabels) InstanceID(contextName string) string {
	// Label order from YAML: channel, type
	return contextName + "." + cleanLabelValue(l.Channel) + "_" + cleanLabelValue(l.Type)
}

// ChannelStatistics contains all metric contexts for ChannelStatistics
var ChannelStatistics = struct {
	Messages   ChannelStatisticsMessagesContext
	Bytes      ChannelStatisticsBytesContext
	Batches    ChannelStatisticsBatchesContext
	BatchSize  ChannelStatisticsBatchSizeContext
	PutRetries ChannelStatisticsPutRetriesContext
}{
	Messages: ChannelStatisticsMessagesContext{
		Context: framework.Context[ChannelStatisticsLabels]{
			Name:        "mq.channel_stats.messages",
			Family:      "channels/statistics",
			Title:       "Channel Messages (Statistics)",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    7000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "messages",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Bytes: ChannelStatisticsBytesContext{
		Context: framework.Context[ChannelStatisticsLabels]{
			Name:        "mq.channel_stats.bytes",
			Family:      "channels/statistics",
			Title:       "Channel Bytes (Statistics)",
			Units:       "bytes/s",
			Type:        module.Line,
			Priority:    7001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "bytes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	Batches: ChannelStatisticsBatchesContext{
		Context: framework.Context[ChannelStatisticsLabels]{
			Name:        "mq.channel_stats.batches",
			Family:      "channels/statistics",
			Title:       "Channel Batches (Statistics)",
			Units:       "batches/s",
			Type:        module.Line,
			Priority:    7002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "full_batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "incomplete_batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	BatchSize: ChannelStatisticsBatchSizeContext{
		Context: framework.Context[ChannelStatisticsLabels]{
			Name:        "mq.channel_stats.batch_size",
			Family:      "channels/statistics",
			Title:       "Channel Average Batch Size (Statistics)",
			Units:       "messages",
			Type:        module.Line,
			Priority:    7003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "avg_batch_size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
	PutRetries: ChannelStatisticsPutRetriesContext{
		Context: framework.Context[ChannelStatisticsLabels]{
			Name:        "mq.channel_stats.put_retries",
			Family:      "channels/statistics",
			Title:       "Channel Put Retries (Statistics)",
			Units:       "retries/s",
			Type:        module.Line,
			Priority:    7004,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "put_retries",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"channel",
				"type",
			},
		},
	},
}

// --- Listener ---

// ListenerStatusValues defines the type-safe values for Listener.Status context
type ListenerStatusValues struct {
	Stopped  int64
	Starting int64
	Running  int64
	Stopping int64
	Retrying int64
}

// ListenerStatusContext provides type-safe operations for Listener.Status context
type ListenerStatusContext struct {
	framework.Context[ListenerLabels]
}

// Set provides type-safe dimension setting for Listener.Status context
func (c ListenerStatusContext) Set(state *framework.CollectorState, labels ListenerLabels, values ListenerStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"stopped":  values.Stopped,
		"starting": values.Starting,
		"running":  values.Running,
		"stopping": values.Stopping,
		"retrying": values.Retrying,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ListenerStatusContext) SetUpdateEvery(state *framework.CollectorState, labels ListenerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ListenerBacklogValues defines the type-safe values for Listener.Backlog context
type ListenerBacklogValues struct {
	Backlog int64
}

// ListenerBacklogContext provides type-safe operations for Listener.Backlog context
type ListenerBacklogContext struct {
	framework.Context[ListenerLabels]
}

// Set provides type-safe dimension setting for Listener.Backlog context
func (c ListenerBacklogContext) Set(state *framework.CollectorState, labels ListenerLabels, values ListenerBacklogValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"backlog": values.Backlog,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ListenerBacklogContext) SetUpdateEvery(state *framework.CollectorState, labels ListenerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ListenerUptimeValues defines the type-safe values for Listener.Uptime context
type ListenerUptimeValues struct {
	Uptime int64
}

// ListenerUptimeContext provides type-safe operations for Listener.Uptime context
type ListenerUptimeContext struct {
	framework.Context[ListenerLabels]
}

// Set provides type-safe dimension setting for Listener.Uptime context
func (c ListenerUptimeContext) Set(state *framework.CollectorState, labels ListenerLabels, values ListenerUptimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"uptime": values.Uptime,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ListenerUptimeContext) SetUpdateEvery(state *framework.CollectorState, labels ListenerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ListenerLabels defines the required labels for Listener contexts
type ListenerLabels struct {
	Listener   string
	Port       string
	Ip_address string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ListenerLabels) InstanceID(contextName string) string {
	// Label order from YAML: listener, port, ip_address
	return contextName + "." + cleanLabelValue(l.Listener) + "_" + cleanLabelValue(l.Port) + "_" + cleanLabelValue(l.Ip_address)
}

// Listener contains all metric contexts for Listener
var Listener = struct {
	Status  ListenerStatusContext
	Backlog ListenerBacklogContext
	Uptime  ListenerUptimeContext
}{
	Status: ListenerStatusContext{
		Context: framework.Context[ListenerLabels]{
			Name:        "mq.listener.status",
			Family:      "listeners",
			Title:       "Listener Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    5000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "stopped",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "starting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "running",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "stopping",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "retrying",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"listener",
				"port",
				"ip_address",
			},
		},
	},
	Backlog: ListenerBacklogContext{
		Context: framework.Context[ListenerLabels]{
			Name:        "mq.listener.backlog",
			Family:      "listeners",
			Title:       "Listener Connection Backlog",
			Units:       "connections",
			Type:        module.Line,
			Priority:    5001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "backlog",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"listener",
				"port",
				"ip_address",
			},
		},
	},
	Uptime: ListenerUptimeContext{
		Context: framework.Context[ListenerLabels]{
			Name:        "mq.listener.uptime",
			Family:      "listeners",
			Title:       "Listener Uptime",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    5002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uptime",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"listener",
				"port",
				"ip_address",
			},
		},
	},
}

// --- MQIStatistics ---

// MQIStatisticsOpensValues defines the type-safe values for MQIStatistics.Opens context
type MQIStatisticsOpensValues struct {
	Opens_total  int64
	Opens_failed int64
}

// MQIStatisticsOpensContext provides type-safe operations for MQIStatistics.Opens context
type MQIStatisticsOpensContext struct {
	framework.Context[MQIStatisticsLabels]
}

// Set provides type-safe dimension setting for MQIStatistics.Opens context
func (c MQIStatisticsOpensContext) Set(state *framework.CollectorState, labels MQIStatisticsLabels, values MQIStatisticsOpensValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"opens_total":  values.Opens_total,
		"opens_failed": values.Opens_failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MQIStatisticsOpensContext) SetUpdateEvery(state *framework.CollectorState, labels MQIStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MQIStatisticsClosesValues defines the type-safe values for MQIStatistics.Closes context
type MQIStatisticsClosesValues struct {
	Closes_total  int64
	Closes_failed int64
}

// MQIStatisticsClosesContext provides type-safe operations for MQIStatistics.Closes context
type MQIStatisticsClosesContext struct {
	framework.Context[MQIStatisticsLabels]
}

// Set provides type-safe dimension setting for MQIStatistics.Closes context
func (c MQIStatisticsClosesContext) Set(state *framework.CollectorState, labels MQIStatisticsLabels, values MQIStatisticsClosesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"closes_total":  values.Closes_total,
		"closes_failed": values.Closes_failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MQIStatisticsClosesContext) SetUpdateEvery(state *framework.CollectorState, labels MQIStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MQIStatisticsInqsValues defines the type-safe values for MQIStatistics.Inqs context
type MQIStatisticsInqsValues struct {
	Inqs_total  int64
	Inqs_failed int64
}

// MQIStatisticsInqsContext provides type-safe operations for MQIStatistics.Inqs context
type MQIStatisticsInqsContext struct {
	framework.Context[MQIStatisticsLabels]
}

// Set provides type-safe dimension setting for MQIStatistics.Inqs context
func (c MQIStatisticsInqsContext) Set(state *framework.CollectorState, labels MQIStatisticsLabels, values MQIStatisticsInqsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"inqs_total":  values.Inqs_total,
		"inqs_failed": values.Inqs_failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MQIStatisticsInqsContext) SetUpdateEvery(state *framework.CollectorState, labels MQIStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MQIStatisticsSetsValues defines the type-safe values for MQIStatistics.Sets context
type MQIStatisticsSetsValues struct {
	Sets_total  int64
	Sets_failed int64
}

// MQIStatisticsSetsContext provides type-safe operations for MQIStatistics.Sets context
type MQIStatisticsSetsContext struct {
	framework.Context[MQIStatisticsLabels]
}

// Set provides type-safe dimension setting for MQIStatistics.Sets context
func (c MQIStatisticsSetsContext) Set(state *framework.CollectorState, labels MQIStatisticsLabels, values MQIStatisticsSetsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"sets_total":  values.Sets_total,
		"sets_failed": values.Sets_failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MQIStatisticsSetsContext) SetUpdateEvery(state *framework.CollectorState, labels MQIStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MQIStatisticsLabels defines the required labels for MQIStatistics contexts
type MQIStatisticsLabels struct {
	Queue_manager string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l MQIStatisticsLabels) InstanceID(contextName string) string {
	// Label order from YAML: queue_manager
	return contextName + "." + cleanLabelValue(l.Queue_manager)
}

// MQIStatistics contains all metric contexts for MQIStatistics
var MQIStatistics = struct {
	Opens  MQIStatisticsOpensContext
	Closes MQIStatisticsClosesContext
	Inqs   MQIStatisticsInqsContext
	Sets   MQIStatisticsSetsContext
}{
	Opens: MQIStatisticsOpensContext{
		Context: framework.Context[MQIStatisticsLabels]{
			Name:        "mq.mqi_stats.opens",
			Family:      "queues/mqi_operations",
			Title:       "MQOPEN Operations (Statistics)",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    8000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "opens_total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "opens_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_manager",
			},
		},
	},
	Closes: MQIStatisticsClosesContext{
		Context: framework.Context[MQIStatisticsLabels]{
			Name:        "mq.mqi_stats.closes",
			Family:      "queues/mqi_operations",
			Title:       "MQCLOSE Operations (Statistics)",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    8001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "closes_total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "closes_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_manager",
			},
		},
	},
	Inqs: MQIStatisticsInqsContext{
		Context: framework.Context[MQIStatisticsLabels]{
			Name:        "mq.mqi_stats.inqs",
			Family:      "queues/mqi_operations",
			Title:       "MQINQ Operations (Statistics)",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    8002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "inqs_total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "inqs_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_manager",
			},
		},
	},
	Sets: MQIStatisticsSetsContext{
		Context: framework.Context[MQIStatisticsLabels]{
			Name:        "mq.mqi_stats.sets",
			Family:      "queues/mqi_operations",
			Title:       "MQSET Operations (Statistics)",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    8003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "sets_total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "sets_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_manager",
			},
		},
	},
}

// --- Queue ---

// QueueDepthValues defines the type-safe values for Queue.Depth context
type QueueDepthValues struct {
	Current int64
	Max     int64
}

// QueueDepthContext provides type-safe operations for Queue.Depth context
type QueueDepthContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.Depth context
func (c QueueDepthContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueDepthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
		"max":     values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueDepthContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueDepthPercentageValues defines the type-safe values for Queue.DepthPercentage context
type QueueDepthPercentageValues struct {
	Percentage int64
}

// QueueDepthPercentageContext provides type-safe operations for Queue.DepthPercentage context
type QueueDepthPercentageContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.DepthPercentage context
func (c QueueDepthPercentageContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueDepthPercentageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"percentage": values.Percentage,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueDepthPercentageContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueMessagesValues defines the type-safe values for Queue.Messages context
type QueueMessagesValues struct {
	Enqueued int64
	Dequeued int64
}

// QueueMessagesContext provides type-safe operations for Queue.Messages context
type QueueMessagesContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.Messages context
func (c QueueMessagesContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"enqueued": values.Enqueued,
		"dequeued": values.Dequeued,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueConnectionsValues defines the type-safe values for Queue.Connections context
type QueueConnectionsValues struct {
	Input  int64
	Output int64
}

// QueueConnectionsContext provides type-safe operations for Queue.Connections context
type QueueConnectionsContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.Connections context
func (c QueueConnectionsContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"input":  values.Input,
		"output": values.Output,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueHighDepthValues defines the type-safe values for Queue.HighDepth context
type QueueHighDepthValues struct {
	High_depth int64
}

// QueueHighDepthContext provides type-safe operations for Queue.HighDepth context
type QueueHighDepthContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.HighDepth context
func (c QueueHighDepthContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueHighDepthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"high_depth": values.High_depth,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueHighDepthContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueUncommittedMessagesValues defines the type-safe values for Queue.UncommittedMessages context
type QueueUncommittedMessagesValues struct {
	Uncommitted int64
}

// QueueUncommittedMessagesContext provides type-safe operations for Queue.UncommittedMessages context
type QueueUncommittedMessagesContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.UncommittedMessages context
func (c QueueUncommittedMessagesContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueUncommittedMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"uncommitted": values.Uncommitted,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueUncommittedMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueFileSizeValues defines the type-safe values for Queue.FileSize context
type QueueFileSizeValues struct {
	Current int64
	Max     int64
}

// QueueFileSizeContext provides type-safe operations for Queue.FileSize context
type QueueFileSizeContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.FileSize context
func (c QueueFileSizeContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueFileSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
		"max":     values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueFileSizeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueLastActivityValues defines the type-safe values for Queue.LastActivity context
type QueueLastActivityValues struct {
	Since_last_get int64
	Since_last_put int64
}

// QueueLastActivityContext provides type-safe operations for Queue.LastActivity context
type QueueLastActivityContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.LastActivity context
func (c QueueLastActivityContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueLastActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"since_last_get": values.Since_last_get,
		"since_last_put": values.Since_last_put,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueLastActivityContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueOldestMessageAgeValues defines the type-safe values for Queue.OldestMessageAge context
type QueueOldestMessageAgeValues struct {
	Oldest_msg_age int64
}

// QueueOldestMessageAgeContext provides type-safe operations for Queue.OldestMessageAge context
type QueueOldestMessageAgeContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.OldestMessageAge context
func (c QueueOldestMessageAgeContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueOldestMessageAgeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"oldest_msg_age": values.Oldest_msg_age,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueOldestMessageAgeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueQueueTimeIndicatorsValues defines the type-safe values for Queue.QueueTimeIndicators context
type QueueQueueTimeIndicatorsValues struct {
	Short_period int64
	Long_period  int64
}

// QueueQueueTimeIndicatorsContext provides type-safe operations for Queue.QueueTimeIndicators context
type QueueQueueTimeIndicatorsContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.QueueTimeIndicators context
func (c QueueQueueTimeIndicatorsContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueQueueTimeIndicatorsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"short_period": values.Short_period,
		"long_period":  values.Long_period,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueQueueTimeIndicatorsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueServiceIntervalValues defines the type-safe values for Queue.ServiceInterval context
type QueueServiceIntervalValues struct {
	Service_interval int64
}

// QueueServiceIntervalContext provides type-safe operations for Queue.ServiceInterval context
type QueueServiceIntervalContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.ServiceInterval context
func (c QueueServiceIntervalContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueServiceIntervalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"service_interval": values.Service_interval,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueServiceIntervalContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueInhibitStatusValues defines the type-safe values for Queue.InhibitStatus context
type QueueInhibitStatusValues struct {
	Inhibit_get int64
	Inhibit_put int64
}

// QueueInhibitStatusContext provides type-safe operations for Queue.InhibitStatus context
type QueueInhibitStatusContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.InhibitStatus context
func (c QueueInhibitStatusContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueInhibitStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"inhibit_get": values.Inhibit_get,
		"inhibit_put": values.Inhibit_put,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueInhibitStatusContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueuePriorityValues defines the type-safe values for Queue.Priority context
type QueuePriorityValues struct {
	Def_priority int64
}

// QueuePriorityContext provides type-safe operations for Queue.Priority context
type QueuePriorityContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.Priority context
func (c QueuePriorityContext) Set(state *framework.CollectorState, labels QueueLabels, values QueuePriorityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"def_priority": values.Def_priority,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueuePriorityContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueMessagePersistenceValues defines the type-safe values for Queue.MessagePersistence context
type QueueMessagePersistenceValues struct {
	Persistent     int64
	Non_persistent int64
}

// QueueMessagePersistenceContext provides type-safe operations for Queue.MessagePersistence context
type QueueMessagePersistenceContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.MessagePersistence context
func (c QueueMessagePersistenceContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueMessagePersistenceValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"persistent":     values.Persistent,
		"non_persistent": values.Non_persistent,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueMessagePersistenceContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueRetentionIntervalValues defines the type-safe values for Queue.RetentionInterval context
type QueueRetentionIntervalValues struct {
	Retention_interval int64
}

// QueueRetentionIntervalContext provides type-safe operations for Queue.RetentionInterval context
type QueueRetentionIntervalContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.RetentionInterval context
func (c QueueRetentionIntervalContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueRetentionIntervalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"retention_interval": values.Retention_interval,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueRetentionIntervalContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueTriggersValues defines the type-safe values for Queue.Triggers context
type QueueTriggersValues struct {
	Trigger_depth int64
	Trigger_type  int64
}

// QueueTriggersContext provides type-safe operations for Queue.Triggers context
type QueueTriggersContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.Triggers context
func (c QueueTriggersContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueTriggersValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"trigger_depth": values.Trigger_depth,
		"trigger_type":  values.Trigger_type,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueTriggersContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueBackoutThresholdValues defines the type-safe values for Queue.BackoutThreshold context
type QueueBackoutThresholdValues struct {
	Backout_threshold int64
}

// QueueBackoutThresholdContext provides type-safe operations for Queue.BackoutThreshold context
type QueueBackoutThresholdContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.BackoutThreshold context
func (c QueueBackoutThresholdContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueBackoutThresholdValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"backout_threshold": values.Backout_threshold,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueBackoutThresholdContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueMaxMessageLengthValues defines the type-safe values for Queue.MaxMessageLength context
type QueueMaxMessageLengthValues struct {
	Max_msg_length int64
}

// QueueMaxMessageLengthContext provides type-safe operations for Queue.MaxMessageLength context
type QueueMaxMessageLengthContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.MaxMessageLength context
func (c QueueMaxMessageLengthContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueMaxMessageLengthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"max_msg_length": values.Max_msg_length,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueMaxMessageLengthContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueQueueScopeValues defines the type-safe values for Queue.QueueScope context
type QueueQueueScopeValues struct {
	Queue_manager int64
	Cell          int64
}

// QueueQueueScopeContext provides type-safe operations for Queue.QueueScope context
type QueueQueueScopeContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.QueueScope context
func (c QueueQueueScopeContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueQueueScopeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"queue_manager": values.Queue_manager,
		"cell":          values.Cell,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueQueueScopeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueQueueUsageValues defines the type-safe values for Queue.QueueUsage context
type QueueQueueUsageValues struct {
	Normal       int64
	Transmission int64
}

// QueueQueueUsageContext provides type-safe operations for Queue.QueueUsage context
type QueueQueueUsageContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.QueueUsage context
func (c QueueQueueUsageContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueQueueUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"normal":       values.Normal,
		"transmission": values.Transmission,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueQueueUsageContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueMessageDeliverySequenceValues defines the type-safe values for Queue.MessageDeliverySequence context
type QueueMessageDeliverySequenceValues struct {
	Priority int64
	Fifo     int64
}

// QueueMessageDeliverySequenceContext provides type-safe operations for Queue.MessageDeliverySequence context
type QueueMessageDeliverySequenceContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.MessageDeliverySequence context
func (c QueueMessageDeliverySequenceContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueMessageDeliverySequenceValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"priority": values.Priority,
		"fifo":     values.Fifo,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueMessageDeliverySequenceContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueHardenGetBackoutValues defines the type-safe values for Queue.HardenGetBackout context
type QueueHardenGetBackoutValues struct {
	Enabled  int64
	Disabled int64
}

// QueueHardenGetBackoutContext provides type-safe operations for Queue.HardenGetBackout context
type QueueHardenGetBackoutContext struct {
	framework.Context[QueueLabels]
}

// Set provides type-safe dimension setting for Queue.HardenGetBackout context
func (c QueueHardenGetBackoutContext) Set(state *framework.CollectorState, labels QueueLabels, values QueueHardenGetBackoutValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"enabled":  values.Enabled,
		"disabled": values.Disabled,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueHardenGetBackoutContext) SetUpdateEvery(state *framework.CollectorState, labels QueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueLabels defines the required labels for Queue contexts
type QueueLabels struct {
	Queue string
	Type  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l QueueLabels) InstanceID(contextName string) string {
	// Label order from YAML: queue, type
	return contextName + "." + cleanLabelValue(l.Queue) + "_" + cleanLabelValue(l.Type)
}

// Queue contains all metric contexts for Queue
var Queue = struct {
	Depth                   QueueDepthContext
	DepthPercentage         QueueDepthPercentageContext
	Messages                QueueMessagesContext
	Connections             QueueConnectionsContext
	HighDepth               QueueHighDepthContext
	UncommittedMessages     QueueUncommittedMessagesContext
	FileSize                QueueFileSizeContext
	LastActivity            QueueLastActivityContext
	OldestMessageAge        QueueOldestMessageAgeContext
	QueueTimeIndicators     QueueQueueTimeIndicatorsContext
	ServiceInterval         QueueServiceIntervalContext
	InhibitStatus           QueueInhibitStatusContext
	Priority                QueuePriorityContext
	MessagePersistence      QueueMessagePersistenceContext
	RetentionInterval       QueueRetentionIntervalContext
	Triggers                QueueTriggersContext
	BackoutThreshold        QueueBackoutThresholdContext
	MaxMessageLength        QueueMaxMessageLengthContext
	QueueScope              QueueQueueScopeContext
	QueueUsage              QueueQueueUsageContext
	MessageDeliverySequence QueueMessageDeliverySequenceContext
	HardenGetBackout        QueueHardenGetBackoutContext
}{
	Depth: QueueDepthContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.depth",
			Family:      "queues/activity",
			Title:       "Queue Depth",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	DepthPercentage: QueueDepthPercentageContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.depth_percentage",
			Family:      "queues/activity",
			Title:       "Queue Depth Percentage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    2001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "percentage",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Messages: QueueMessagesContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.messages",
			Family:      "queues/activity",
			Title:       "Queue Messages",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    2002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "enqueued",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "dequeued",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Connections: QueueConnectionsContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.connections",
			Family:      "queues/activity",
			Title:       "Queue Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    2003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "input",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "output",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	HighDepth: QueueHighDepthContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.high_depth",
			Family:      "queues/activity",
			Title:       "Queue Peak Depth",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2004,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "high_depth",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	UncommittedMessages: QueueUncommittedMessagesContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.uncommitted_msgs",
			Family:      "queues/activity",
			Title:       "Queue Uncommitted Messages",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2005,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uncommitted",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	FileSize: QueueFileSizeContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.file_size",
			Family:      "queues/activity",
			Title:       "Queue File Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    2006,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	LastActivity: QueueLastActivityContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.last_activity",
			Family:      "queues/activity",
			Title:       "Time Since Last Queue Activity",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    2007,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "since_last_get",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "since_last_put",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	OldestMessageAge: QueueOldestMessageAgeContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.oldest_msg_age",
			Family:      "queues/performance",
			Title:       "Queue Oldest Message Age",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    2100,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "oldest_msg_age",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	QueueTimeIndicators: QueueQueueTimeIndicatorsContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.time_indicators",
			Family:      "queues/performance",
			Title:       "Queue Time Indicators",
			Units:       "microseconds",
			Type:        module.Line,
			Priority:    2101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "short_period",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "long_period",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	ServiceInterval: QueueServiceIntervalContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.service_interval",
			Family:      "queues/performance",
			Title:       "Queue Service Interval",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    2102,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "service_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	InhibitStatus: QueueInhibitStatusContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.inhibit_status",
			Family:      "queues/configuration",
			Title:       "Queue Inhibit Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    2200,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "inhibit_get",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "inhibit_put",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Priority: QueuePriorityContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.priority",
			Family:      "queues/configuration",
			Title:       "Queue Priority Configuration",
			Units:       "priority",
			Type:        module.Line,
			Priority:    2201,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "def_priority",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	MessagePersistence: QueueMessagePersistenceContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.message_persistence",
			Family:      "queues/configuration",
			Title:       "Queue Default Message Persistence",
			Units:       "boolean",
			Type:        module.Line,
			Priority:    2202,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "persistent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "non_persistent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	RetentionInterval: QueueRetentionIntervalContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.retention_interval",
			Family:      "queues/configuration",
			Title:       "Queue Retention Interval",
			Units:       "hours",
			Type:        module.Line,
			Priority:    2203,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "retention_interval",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Triggers: QueueTriggersContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.triggers",
			Family:      "queues/limits",
			Title:       "Queue Trigger Configuration",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2300,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "trigger_depth",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "trigger_type",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	BackoutThreshold: QueueBackoutThresholdContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.backout_threshold",
			Family:      "queues/limits",
			Title:       "Queue Error Handling",
			Units:       "retries",
			Type:        module.Line,
			Priority:    2301,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "backout_threshold",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	MaxMessageLength: QueueMaxMessageLengthContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.max_msg_length",
			Family:      "queues/limits",
			Title:       "Queue Max Message Length",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    2302,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "max_msg_length",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	QueueScope: QueueQueueScopeContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.scope",
			Family:      "queues/behavior",
			Title:       "Queue Scope",
			Units:       "boolean",
			Type:        module.Line,
			Priority:    2400,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "queue_manager",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "cell",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	QueueUsage: QueueQueueUsageContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.usage",
			Family:      "queues/behavior",
			Title:       "Queue Usage Type",
			Units:       "boolean",
			Type:        module.Line,
			Priority:    2401,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "normal",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "transmission",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	MessageDeliverySequence: QueueMessageDeliverySequenceContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.msg_delivery_sequence",
			Family:      "queues/behavior",
			Title:       "Message Delivery Sequence",
			Units:       "boolean",
			Type:        module.Line,
			Priority:    2402,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "priority",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fifo",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	HardenGetBackout: QueueHardenGetBackoutContext{
		Context: framework.Context[QueueLabels]{
			Name:        "mq.queue.harden_get_backout",
			Family:      "queues/behavior",
			Title:       "Harden Get Backout",
			Units:       "boolean",
			Type:        module.Line,
			Priority:    2403,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "enabled",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "disabled",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
}

// --- QueueGroup ---

// QueueGroupDepthValues defines the type-safe values for QueueGroup.Depth context
type QueueGroupDepthValues struct {
	Current int64
	Max     int64
}

// QueueGroupDepthContext provides type-safe operations for QueueGroup.Depth context
type QueueGroupDepthContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.Depth context
func (c QueueGroupDepthContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupDepthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
		"max":     values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupDepthContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupDepthPercentageValues defines the type-safe values for QueueGroup.DepthPercentage context
type QueueGroupDepthPercentageValues struct {
	Percentage int64
}

// QueueGroupDepthPercentageContext provides type-safe operations for QueueGroup.DepthPercentage context
type QueueGroupDepthPercentageContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.DepthPercentage context
func (c QueueGroupDepthPercentageContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupDepthPercentageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"percentage": values.Percentage,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupDepthPercentageContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupMessagesValues defines the type-safe values for QueueGroup.Messages context
type QueueGroupMessagesValues struct {
	Enqueued int64
	Dequeued int64
}

// QueueGroupMessagesContext provides type-safe operations for QueueGroup.Messages context
type QueueGroupMessagesContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.Messages context
func (c QueueGroupMessagesContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"enqueued": values.Enqueued,
		"dequeued": values.Dequeued,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupConnectionsValues defines the type-safe values for QueueGroup.Connections context
type QueueGroupConnectionsValues struct {
	Input  int64
	Output int64
}

// QueueGroupConnectionsContext provides type-safe operations for QueueGroup.Connections context
type QueueGroupConnectionsContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.Connections context
func (c QueueGroupConnectionsContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"input":  values.Input,
		"output": values.Output,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupUncommittedMessagesValues defines the type-safe values for QueueGroup.UncommittedMessages context
type QueueGroupUncommittedMessagesValues struct {
	Uncommitted int64
}

// QueueGroupUncommittedMessagesContext provides type-safe operations for QueueGroup.UncommittedMessages context
type QueueGroupUncommittedMessagesContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.UncommittedMessages context
func (c QueueGroupUncommittedMessagesContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupUncommittedMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"uncommitted": values.Uncommitted,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupUncommittedMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupFileSizeValues defines the type-safe values for QueueGroup.FileSize context
type QueueGroupFileSizeValues struct {
	Current int64
	Max     int64
}

// QueueGroupFileSizeContext provides type-safe operations for QueueGroup.FileSize context
type QueueGroupFileSizeContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.FileSize context
func (c QueueGroupFileSizeContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupFileSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
		"max":     values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupFileSizeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupOldestMessageAgeValues defines the type-safe values for QueueGroup.OldestMessageAge context
type QueueGroupOldestMessageAgeValues struct {
	Oldest_msg_age int64
}

// QueueGroupOldestMessageAgeContext provides type-safe operations for QueueGroup.OldestMessageAge context
type QueueGroupOldestMessageAgeContext struct {
	framework.Context[QueueGroupLabels]
}

// Set provides type-safe dimension setting for QueueGroup.OldestMessageAge context
func (c QueueGroupOldestMessageAgeContext) Set(state *framework.CollectorState, labels QueueGroupLabels, values QueueGroupOldestMessageAgeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"oldest_msg_age": values.Oldest_msg_age,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueGroupOldestMessageAgeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueGroupLabels defines the required labels for QueueGroup contexts
type QueueGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l QueueGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// QueueGroup contains all metric contexts for QueueGroup
var QueueGroup = struct {
	Depth               QueueGroupDepthContext
	DepthPercentage     QueueGroupDepthPercentageContext
	Messages            QueueGroupMessagesContext
	Connections         QueueGroupConnectionsContext
	UncommittedMessages QueueGroupUncommittedMessagesContext
	FileSize            QueueGroupFileSizeContext
	OldestMessageAge    QueueGroupOldestMessageAgeContext
}{
	Depth: QueueGroupDepthContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.depth",
			Family:      "queues/group",
			Title:       "Queue Group Depth",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2450,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	DepthPercentage: QueueGroupDepthPercentageContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.depth_percentage",
			Family:      "queues/group",
			Title:       "Queue Group Depth Percentage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    2451,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "percentage",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Messages: QueueGroupMessagesContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.messages",
			Family:      "queues/group",
			Title:       "Queue Group Messages",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    2452,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "enqueued",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "dequeued",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Connections: QueueGroupConnectionsContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.connections",
			Family:      "queues/group",
			Title:       "Queue Group Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    2453,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "input",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "output",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	UncommittedMessages: QueueGroupUncommittedMessagesContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.uncommitted_msgs",
			Family:      "queues/group",
			Title:       "Queue Group Uncommitted Messages",
			Units:       "messages",
			Type:        module.Line,
			Priority:    2454,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uncommitted",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	FileSize: QueueGroupFileSizeContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.file_size",
			Family:      "queues/group",
			Title:       "Queue Group File Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    2455,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	OldestMessageAge: QueueGroupOldestMessageAgeContext{
		Context: framework.Context[QueueGroupLabels]{
			Name:        "mq.queue_group.oldest_msg_age",
			Family:      "queues/group",
			Title:       "Queue Group Oldest Message Age",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    2456,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "oldest_msg_age",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// --- QueueManager ---

// QueueManagerStatusValues defines the type-safe values for QueueManager.Status context
type QueueManagerStatusValues struct {
	Status int64
}

// QueueManagerStatusContext provides type-safe operations for QueueManager.Status context
type QueueManagerStatusContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.Status context
func (c QueueManagerStatusContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"status": values.Status,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerStatusContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerConnectionCountValues defines the type-safe values for QueueManager.ConnectionCount context
type QueueManagerConnectionCountValues struct {
	Connections int64
}

// QueueManagerConnectionCountContext provides type-safe operations for QueueManager.ConnectionCount context
type QueueManagerConnectionCountContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.ConnectionCount context
func (c QueueManagerConnectionCountContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerConnectionCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"connections": values.Connections,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerConnectionCountContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerUptimeValues defines the type-safe values for QueueManager.Uptime context
type QueueManagerUptimeValues struct {
	Uptime int64
}

// QueueManagerUptimeContext provides type-safe operations for QueueManager.Uptime context
type QueueManagerUptimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.Uptime context
func (c QueueManagerUptimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerUptimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"uptime": values.Uptime,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerUptimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerQueuesOverviewValues defines the type-safe values for QueueManager.QueuesOverview context
type QueueManagerQueuesOverviewValues struct {
	Monitored int64
	Excluded  int64
	Invisible int64
	Failed    int64
}

// QueueManagerQueuesOverviewContext provides type-safe operations for QueueManager.QueuesOverview context
type QueueManagerQueuesOverviewContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.QueuesOverview context
func (c QueueManagerQueuesOverviewContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerQueuesOverviewValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"monitored": values.Monitored,
		"excluded":  values.Excluded,
		"invisible": values.Invisible,
		"failed":    values.Failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerQueuesOverviewContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerChannelsOverviewValues defines the type-safe values for QueueManager.ChannelsOverview context
type QueueManagerChannelsOverviewValues struct {
	Monitored int64
	Excluded  int64
	Invisible int64
	Failed    int64
}

// QueueManagerChannelsOverviewContext provides type-safe operations for QueueManager.ChannelsOverview context
type QueueManagerChannelsOverviewContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.ChannelsOverview context
func (c QueueManagerChannelsOverviewContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerChannelsOverviewValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"monitored": values.Monitored,
		"excluded":  values.Excluded,
		"invisible": values.Invisible,
		"failed":    values.Failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerChannelsOverviewContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerTopicsOverviewValues defines the type-safe values for QueueManager.TopicsOverview context
type QueueManagerTopicsOverviewValues struct {
	Monitored int64
	Excluded  int64
	Invisible int64
	Failed    int64
}

// QueueManagerTopicsOverviewContext provides type-safe operations for QueueManager.TopicsOverview context
type QueueManagerTopicsOverviewContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.TopicsOverview context
func (c QueueManagerTopicsOverviewContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerTopicsOverviewValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"monitored": values.Monitored,
		"excluded":  values.Excluded,
		"invisible": values.Invisible,
		"failed":    values.Failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerTopicsOverviewContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerListenersOverviewValues defines the type-safe values for QueueManager.ListenersOverview context
type QueueManagerListenersOverviewValues struct {
	Monitored int64
	Excluded  int64
	Invisible int64
	Failed    int64
}

// QueueManagerListenersOverviewContext provides type-safe operations for QueueManager.ListenersOverview context
type QueueManagerListenersOverviewContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManager.ListenersOverview context
func (c QueueManagerListenersOverviewContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerListenersOverviewValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"monitored": values.Monitored,
		"excluded":  values.Excluded,
		"invisible": values.Invisible,
		"failed":    values.Failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerListenersOverviewContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManager contains all metric contexts for QueueManager
var QueueManager = struct {
	Status            QueueManagerStatusContext
	ConnectionCount   QueueManagerConnectionCountContext
	Uptime            QueueManagerUptimeContext
	QueuesOverview    QueueManagerQueuesOverviewContext
	ChannelsOverview  QueueManagerChannelsOverviewContext
	TopicsOverview    QueueManagerTopicsOverviewContext
	ListenersOverview QueueManagerListenersOverviewContext
}{
	Status: QueueManagerStatusContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.status",
			Family:      "queue_manager",
			Title:       "Queue Manager Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    1000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "status",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ConnectionCount: QueueManagerConnectionCountContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.connection_count",
			Family:      "queue_manager",
			Title:       "Queue Manager Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    1001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "connections",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Uptime: QueueManagerUptimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.uptime",
			Family:      "queue_manager",
			Title:       "Queue Manager Uptime",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    1002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uptime",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	QueuesOverview: QueueManagerQueuesOverviewContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.queues.overview",
			Family:      "overview",
			Title:       "Queues Monitoring Status",
			Units:       "queues",
			Type:        module.Stacked,
			Priority:    1100,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "monitored",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "excluded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invisible",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "failed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ChannelsOverview: QueueManagerChannelsOverviewContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.channels.overview",
			Family:      "overview",
			Title:       "Channels Monitoring Status",
			Units:       "channels",
			Type:        module.Stacked,
			Priority:    1101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "monitored",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "excluded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invisible",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "failed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TopicsOverview: QueueManagerTopicsOverviewContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.topics.overview",
			Family:      "overview",
			Title:       "Topics Monitoring Status",
			Units:       "topics",
			Type:        module.Stacked,
			Priority:    1102,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "monitored",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "excluded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invisible",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "failed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ListenersOverview: QueueManagerListenersOverviewContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.listeners.overview",
			Family:      "overview",
			Title:       "Listeners Monitoring Status",
			Units:       "listeners",
			Type:        module.Stacked,
			Priority:    1103,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "monitored",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "excluded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invisible",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "failed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- QueueManagerResources ---

// QueueManagerResourcesCPUUsageValues defines the type-safe values for QueueManagerResources.CPUUsage context
type QueueManagerResourcesCPUUsageValues struct {
	User   int64
	System int64
}

// QueueManagerResourcesCPUUsageContext provides type-safe operations for QueueManagerResources.CPUUsage context
type QueueManagerResourcesCPUUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.CPUUsage context
func (c QueueManagerResourcesCPUUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesCPUUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"user":   values.User,
		"system": values.System,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesCPUUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResourcesMemoryUsageValues defines the type-safe values for QueueManagerResources.MemoryUsage context
type QueueManagerResourcesMemoryUsageValues struct {
	Total int64
}

// QueueManagerResourcesMemoryUsageContext provides type-safe operations for QueueManagerResources.MemoryUsage context
type QueueManagerResourcesMemoryUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.MemoryUsage context
func (c QueueManagerResourcesMemoryUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesMemoryUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesMemoryUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResourcesRAMUsageValues defines the type-safe values for QueueManagerResources.RAMUsage context
type QueueManagerResourcesRAMUsageValues struct {
	Total int64
}

// QueueManagerResourcesRAMUsageContext provides type-safe operations for QueueManagerResources.RAMUsage context
type QueueManagerResourcesRAMUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.RAMUsage context
func (c QueueManagerResourcesRAMUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesRAMUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesRAMUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResourcesLogUtilizationValues defines the type-safe values for QueueManagerResources.LogUtilization context
type QueueManagerResourcesLogUtilizationValues struct {
	Used int64
}

// QueueManagerResourcesLogUtilizationContext provides type-safe operations for QueueManagerResources.LogUtilization context
type QueueManagerResourcesLogUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.LogUtilization context
func (c QueueManagerResourcesLogUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesLogUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesLogUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResourcesLogFileSizeValues defines the type-safe values for QueueManagerResources.LogFileSize context
type QueueManagerResourcesLogFileSizeValues struct {
	Size int64
}

// QueueManagerResourcesLogFileSizeContext provides type-safe operations for QueueManagerResources.LogFileSize context
type QueueManagerResourcesLogFileSizeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.LogFileSize context
func (c QueueManagerResourcesLogFileSizeContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesLogFileSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"size": values.Size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesLogFileSizeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResourcesLogWriteRateValues defines the type-safe values for QueueManagerResources.LogWriteRate context
type QueueManagerResourcesLogWriteRateValues struct {
	Rate int64
}

// QueueManagerResourcesLogWriteRateContext provides type-safe operations for QueueManagerResources.LogWriteRate context
type QueueManagerResourcesLogWriteRateContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for QueueManagerResources.LogWriteRate context
func (c QueueManagerResourcesLogWriteRateContext) Set(state *framework.CollectorState, labels EmptyLabels, values QueueManagerResourcesLogWriteRateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"rate": values.Rate,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueManagerResourcesLogWriteRateContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// QueueManagerResources contains all metric contexts for QueueManagerResources
var QueueManagerResources = struct {
	CPUUsage       QueueManagerResourcesCPUUsageContext
	MemoryUsage    QueueManagerResourcesMemoryUsageContext
	RAMUsage       QueueManagerResourcesRAMUsageContext
	LogUtilization QueueManagerResourcesLogUtilizationContext
	LogFileSize    QueueManagerResourcesLogFileSizeContext
	LogWriteRate   QueueManagerResourcesLogWriteRateContext
}{
	CPUUsage: QueueManagerResourcesCPUUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.cpu_usage",
			Family:      "resources",
			Title:       "Queue Manager CPU Usage",
			Units:       "percentage",
			Type:        module.Stacked,
			Priority:    1050,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "user",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       100,
					Precision: 1,
				},
				{
					Name:      "system",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       100,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryUsage: QueueManagerResourcesMemoryUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.memory_usage",
			Family:      "resources",
			Title:       "Queue Manager Memory Usage",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1051,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	RAMUsage: QueueManagerResourcesRAMUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.ram_usage",
			Family:      "resources",
			Title:       "Queue Manager RAM Usage",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1052,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogUtilization: QueueManagerResourcesLogUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.log_utilization",
			Family:      "resources",
			Title:       "Queue Manager Log Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1053,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       100,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogFileSize: QueueManagerResourcesLogFileSizeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.log_file_size",
			Family:      "resources",
			Title:       "Queue Manager Log File Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1054,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogWriteRate: QueueManagerResourcesLogWriteRateContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "mq.qmgr.log_write_rate",
			Family:      "resources",
			Title:       "Queue Manager Log Write Rate",
			Units:       "bytes/s",
			Type:        module.Line,
			Priority:    1055,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "rate",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- QueueStatistics ---

// QueueStatisticsDepthMinMaxValues defines the type-safe values for QueueStatistics.DepthMinMax context
type QueueStatisticsDepthMinMaxValues struct {
	Min_depth int64
	Max_depth int64
}

// QueueStatisticsDepthMinMaxContext provides type-safe operations for QueueStatistics.DepthMinMax context
type QueueStatisticsDepthMinMaxContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.DepthMinMax context
func (c QueueStatisticsDepthMinMaxContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsDepthMinMaxValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"min_depth": values.Min_depth,
		"max_depth": values.Max_depth,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsDepthMinMaxContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsAvgQueueTimeValues defines the type-safe values for QueueStatistics.AvgQueueTime context
type QueueStatisticsAvgQueueTimeValues struct {
	Non_persistent int64
	Persistent     int64
}

// QueueStatisticsAvgQueueTimeContext provides type-safe operations for QueueStatistics.AvgQueueTime context
type QueueStatisticsAvgQueueTimeContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.AvgQueueTime context
func (c QueueStatisticsAvgQueueTimeContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsAvgQueueTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"non_persistent": values.Non_persistent,
		"persistent":     values.Persistent,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsAvgQueueTimeContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsQueueTimeIndicatorsValues defines the type-safe values for QueueStatistics.QueueTimeIndicators context
type QueueStatisticsQueueTimeIndicatorsValues struct {
	Short_period int64
	Long_period  int64
}

// QueueStatisticsQueueTimeIndicatorsContext provides type-safe operations for QueueStatistics.QueueTimeIndicators context
type QueueStatisticsQueueTimeIndicatorsContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.QueueTimeIndicators context
func (c QueueStatisticsQueueTimeIndicatorsContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsQueueTimeIndicatorsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"short_period": values.Short_period,
		"long_period":  values.Long_period,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsQueueTimeIndicatorsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsOperationsValues defines the type-safe values for QueueStatistics.Operations context
type QueueStatisticsOperationsValues struct {
	Puts_non_persistent int64
	Puts_persistent     int64
	Gets_non_persistent int64
	Gets_persistent     int64
	Put1s               int64
	Browses             int64
}

// QueueStatisticsOperationsContext provides type-safe operations for QueueStatistics.Operations context
type QueueStatisticsOperationsContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.Operations context
func (c QueueStatisticsOperationsContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"puts_non_persistent": values.Puts_non_persistent,
		"puts_persistent":     values.Puts_persistent,
		"gets_non_persistent": values.Gets_non_persistent,
		"gets_persistent":     values.Gets_persistent,
		"put1s":               values.Put1s,
		"browses":             values.Browses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsBytesValues defines the type-safe values for QueueStatistics.Bytes context
type QueueStatisticsBytesValues struct {
	Put_bytes_non_persistent int64
	Put_bytes_persistent     int64
	Get_bytes_non_persistent int64
	Get_bytes_persistent     int64
	Browse_bytes             int64
}

// QueueStatisticsBytesContext provides type-safe operations for QueueStatistics.Bytes context
type QueueStatisticsBytesContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.Bytes context
func (c QueueStatisticsBytesContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsBytesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"put_bytes_non_persistent": values.Put_bytes_non_persistent,
		"put_bytes_persistent":     values.Put_bytes_persistent,
		"get_bytes_non_persistent": values.Get_bytes_non_persistent,
		"get_bytes_persistent":     values.Get_bytes_persistent,
		"browse_bytes":             values.Browse_bytes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsBytesContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsFailuresValues defines the type-safe values for QueueStatistics.Failures context
type QueueStatisticsFailuresValues struct {
	Puts_failed    int64
	Put1s_failed   int64
	Gets_failed    int64
	Browses_failed int64
}

// QueueStatisticsFailuresContext provides type-safe operations for QueueStatistics.Failures context
type QueueStatisticsFailuresContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.Failures context
func (c QueueStatisticsFailuresContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsFailuresValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"puts_failed":    values.Puts_failed,
		"put1s_failed":   values.Put1s_failed,
		"gets_failed":    values.Gets_failed,
		"browses_failed": values.Browses_failed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsFailuresContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsMessageLifecycleValues defines the type-safe values for QueueStatistics.MessageLifecycle context
type QueueStatisticsMessageLifecycleValues struct {
	Expired    int64
	Purged     int64
	Not_queued int64
}

// QueueStatisticsMessageLifecycleContext provides type-safe operations for QueueStatistics.MessageLifecycle context
type QueueStatisticsMessageLifecycleContext struct {
	framework.Context[QueueStatisticsLabels]
}

// Set provides type-safe dimension setting for QueueStatistics.MessageLifecycle context
func (c QueueStatisticsMessageLifecycleContext) Set(state *framework.CollectorState, labels QueueStatisticsLabels, values QueueStatisticsMessageLifecycleValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"expired":    values.Expired,
		"purged":     values.Purged,
		"not_queued": values.Not_queued,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueStatisticsMessageLifecycleContext) SetUpdateEvery(state *framework.CollectorState, labels QueueStatisticsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueStatisticsLabels defines the required labels for QueueStatistics contexts
type QueueStatisticsLabels struct {
	Queue string
	Type  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l QueueStatisticsLabels) InstanceID(contextName string) string {
	// Label order from YAML: queue, type
	return contextName + "." + cleanLabelValue(l.Queue) + "_" + cleanLabelValue(l.Type)
}

// QueueStatistics contains all metric contexts for QueueStatistics
var QueueStatistics = struct {
	DepthMinMax         QueueStatisticsDepthMinMaxContext
	AvgQueueTime        QueueStatisticsAvgQueueTimeContext
	QueueTimeIndicators QueueStatisticsQueueTimeIndicatorsContext
	Operations          QueueStatisticsOperationsContext
	Bytes               QueueStatisticsBytesContext
	Failures            QueueStatisticsFailuresContext
	MessageLifecycle    QueueStatisticsMessageLifecycleContext
}{
	DepthMinMax: QueueStatisticsDepthMinMaxContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.depth_min_max",
			Family:      "queues/statistics",
			Title:       "Queue Depth Min/Max (Statistics)",
			Units:       "messages",
			Type:        module.Line,
			Priority:    6000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "min_depth",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max_depth",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	AvgQueueTime: QueueStatisticsAvgQueueTimeContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.avg_queue_time",
			Family:      "queues/statistics",
			Title:       "Queue Average Time (Statistics)",
			Units:       "microseconds",
			Type:        module.Line,
			Priority:    6001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "non_persistent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "persistent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	QueueTimeIndicators: QueueStatisticsQueueTimeIndicatorsContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.time_indicators",
			Family:      "queues/statistics",
			Title:       "Queue Time Indicators (Statistics)",
			Units:       "microseconds",
			Type:        module.Line,
			Priority:    6002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "short_period",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "long_period",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Operations: QueueStatisticsOperationsContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.operations",
			Family:      "queues/statistics",
			Title:       "Queue Operations (Statistics)",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    6003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "puts_non_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "puts_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "gets_non_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "gets_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "put1s",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "browses",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Bytes: QueueStatisticsBytesContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.bytes",
			Family:      "queues/statistics",
			Title:       "Queue Bytes (Statistics)",
			Units:       "bytes/s",
			Type:        module.Line,
			Priority:    6004,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "put_bytes_non_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "put_bytes_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "get_bytes_non_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "get_bytes_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "browse_bytes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	Failures: QueueStatisticsFailuresContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.failures",
			Family:      "queues/statistics",
			Title:       "Queue Operation Failures (Statistics)",
			Units:       "failures/s",
			Type:        module.Line,
			Priority:    6005,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "puts_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "put1s_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "gets_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "browses_failed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
	MessageLifecycle: QueueStatisticsMessageLifecycleContext{
		Context: framework.Context[QueueStatisticsLabels]{
			Name:        "mq.queue_stats.message_lifecycle",
			Family:      "queues/statistics",
			Title:       "Queue Message Lifecycle (Statistics)",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    6006,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "expired",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "purged",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "not_queued",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue",
				"type",
			},
		},
	},
}

// --- Subscription ---

// SubscriptionMessageCountValues defines the type-safe values for Subscription.MessageCount context
type SubscriptionMessageCountValues struct {
	Pending int64
}

// SubscriptionMessageCountContext provides type-safe operations for Subscription.MessageCount context
type SubscriptionMessageCountContext struct {
	framework.Context[SubscriptionLabels]
}

// Set provides type-safe dimension setting for Subscription.MessageCount context
func (c SubscriptionMessageCountContext) Set(state *framework.CollectorState, labels SubscriptionLabels, values SubscriptionMessageCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"pending": values.Pending,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SubscriptionMessageCountContext) SetUpdateEvery(state *framework.CollectorState, labels SubscriptionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SubscriptionLastMessageAgeValues defines the type-safe values for Subscription.LastMessageAge context
type SubscriptionLastMessageAgeValues struct {
	Age int64
}

// SubscriptionLastMessageAgeContext provides type-safe operations for Subscription.LastMessageAge context
type SubscriptionLastMessageAgeContext struct {
	framework.Context[SubscriptionLabels]
}

// Set provides type-safe dimension setting for Subscription.LastMessageAge context
func (c SubscriptionLastMessageAgeContext) Set(state *framework.CollectorState, labels SubscriptionLabels, values SubscriptionLastMessageAgeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"age": values.Age,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SubscriptionLastMessageAgeContext) SetUpdateEvery(state *framework.CollectorState, labels SubscriptionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SubscriptionLabels defines the required labels for Subscription contexts
type SubscriptionLabels struct {
	Subscription string
	Topic        string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SubscriptionLabels) InstanceID(contextName string) string {
	// Label order from YAML: subscription, topic
	return contextName + "." + cleanLabelValue(l.Subscription) + "_" + cleanLabelValue(l.Topic)
}

// Subscription contains all metric contexts for Subscription
var Subscription = struct {
	MessageCount   SubscriptionMessageCountContext
	LastMessageAge SubscriptionLastMessageAgeContext
}{
	MessageCount: SubscriptionMessageCountContext{
		Context: framework.Context[SubscriptionLabels]{
			Name:        "mq.subscription.messages",
			Family:      "subscriptions",
			Title:       "IBM MQ Subscription Messages",
			Units:       "messages",
			Type:        module.Line,
			Priority:    9000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "pending",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"subscription",
				"topic",
			},
		},
	},
	LastMessageAge: SubscriptionLastMessageAgeContext{
		Context: framework.Context[SubscriptionLabels]{
			Name:        "mq.subscription.last_message_age",
			Family:      "subscriptions",
			Title:       "IBM MQ Subscription Last Message Age",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    9001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "age",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"subscription",
				"topic",
			},
		},
	},
}

// --- Topic ---

// TopicPublishersValues defines the type-safe values for Topic.Publishers context
type TopicPublishersValues struct {
	Publishers int64
}

// TopicPublishersContext provides type-safe operations for Topic.Publishers context
type TopicPublishersContext struct {
	framework.Context[TopicLabels]
}

// Set provides type-safe dimension setting for Topic.Publishers context
func (c TopicPublishersContext) Set(state *framework.CollectorState, labels TopicLabels, values TopicPublishersValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"publishers": values.Publishers,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TopicPublishersContext) SetUpdateEvery(state *framework.CollectorState, labels TopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TopicSubscribersValues defines the type-safe values for Topic.Subscribers context
type TopicSubscribersValues struct {
	Subscribers int64
}

// TopicSubscribersContext provides type-safe operations for Topic.Subscribers context
type TopicSubscribersContext struct {
	framework.Context[TopicLabels]
}

// Set provides type-safe dimension setting for Topic.Subscribers context
func (c TopicSubscribersContext) Set(state *framework.CollectorState, labels TopicLabels, values TopicSubscribersValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"subscribers": values.Subscribers,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TopicSubscribersContext) SetUpdateEvery(state *framework.CollectorState, labels TopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TopicMessagesValues defines the type-safe values for Topic.Messages context
type TopicMessagesValues struct {
	Messages int64
}

// TopicMessagesContext provides type-safe operations for Topic.Messages context
type TopicMessagesContext struct {
	framework.Context[TopicLabels]
}

// Set provides type-safe dimension setting for Topic.Messages context
func (c TopicMessagesContext) Set(state *framework.CollectorState, labels TopicLabels, values TopicMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"messages": values.Messages,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TopicMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels TopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TopicTimeSinceLastMessageValues defines the type-safe values for Topic.TimeSinceLastMessage context
type TopicTimeSinceLastMessageValues struct {
	Time_since_last_msg int64
}

// TopicTimeSinceLastMessageContext provides type-safe operations for Topic.TimeSinceLastMessage context
type TopicTimeSinceLastMessageContext struct {
	framework.Context[TopicLabels]
}

// Set provides type-safe dimension setting for Topic.TimeSinceLastMessage context
func (c TopicTimeSinceLastMessageContext) Set(state *framework.CollectorState, labels TopicLabels, values TopicTimeSinceLastMessageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"time_since_last_msg": values.Time_since_last_msg,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TopicTimeSinceLastMessageContext) SetUpdateEvery(state *framework.CollectorState, labels TopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TopicLabels defines the required labels for Topic contexts
type TopicLabels struct {
	Topic string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TopicLabels) InstanceID(contextName string) string {
	// Label order from YAML: topic
	return contextName + "." + cleanLabelValue(l.Topic)
}

// Topic contains all metric contexts for Topic
var Topic = struct {
	Publishers           TopicPublishersContext
	Subscribers          TopicSubscribersContext
	Messages             TopicMessagesContext
	TimeSinceLastMessage TopicTimeSinceLastMessageContext
}{
	Publishers: TopicPublishersContext{
		Context: framework.Context[TopicLabels]{
			Name:        "mq.topic.publishers",
			Family:      "topics",
			Title:       "Topic Publishers",
			Units:       "publishers",
			Type:        module.Line,
			Priority:    4000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "publishers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"topic",
			},
		},
	},
	Subscribers: TopicSubscribersContext{
		Context: framework.Context[TopicLabels]{
			Name:        "mq.topic.subscribers",
			Family:      "topics",
			Title:       "Topic Subscribers",
			Units:       "subscribers",
			Type:        module.Line,
			Priority:    4001,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "subscribers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"topic",
			},
		},
	},
	Messages: TopicMessagesContext{
		Context: framework.Context[TopicLabels]{
			Name:        "mq.topic.messages",
			Family:      "topics",
			Title:       "Topic Message Rate",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    4002,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "messages",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"topic",
			},
		},
	},
	TimeSinceLastMessage: TopicTimeSinceLastMessageContext{
		Context: framework.Context[TopicLabels]{
			Name:        "mq.topic.time_since_last_message",
			Family:      "topics",
			Title:       "Time Since Last Message",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    4003,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "time_since_last_msg",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"topic",
			},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&Channel.Status.Context,
		&Channel.Messages.Context,
		&Channel.Bytes.Context,
		&Channel.Batches.Context,
		&Channel.BatchSize.Context,
		&Channel.BatchInterval.Context,
		&Channel.Intervals.Context,
		&Channel.ShortRetryCount.Context,
		&Channel.LongRetryInterval.Context,
		&Channel.MaxMessageLength.Context,
		&Channel.SharingConversations.Context,
		&Channel.NetworkPriority.Context,
		&Channel.BufferCounts.Context,
		&Channel.CurrentMessages.Context,
		&Channel.XmitQueueTime.Context,
		&Channel.MCAStatus.Context,
		&Channel.InDoubtStatus.Context,
		&Channel.SSLKeyResets.Context,
		&Channel.NPMSpeed.Context,
		&Channel.CurrentSharingConversations.Context,
		&ChannelStatistics.Messages.Context,
		&ChannelStatistics.Bytes.Context,
		&ChannelStatistics.Batches.Context,
		&ChannelStatistics.BatchSize.Context,
		&ChannelStatistics.PutRetries.Context,
		&Listener.Status.Context,
		&Listener.Backlog.Context,
		&Listener.Uptime.Context,
		&MQIStatistics.Opens.Context,
		&MQIStatistics.Closes.Context,
		&MQIStatistics.Inqs.Context,
		&MQIStatistics.Sets.Context,
		&Queue.Depth.Context,
		&Queue.DepthPercentage.Context,
		&Queue.Messages.Context,
		&Queue.Connections.Context,
		&Queue.HighDepth.Context,
		&Queue.UncommittedMessages.Context,
		&Queue.FileSize.Context,
		&Queue.LastActivity.Context,
		&Queue.OldestMessageAge.Context,
		&Queue.QueueTimeIndicators.Context,
		&Queue.ServiceInterval.Context,
		&Queue.InhibitStatus.Context,
		&Queue.Priority.Context,
		&Queue.MessagePersistence.Context,
		&Queue.RetentionInterval.Context,
		&Queue.Triggers.Context,
		&Queue.BackoutThreshold.Context,
		&Queue.MaxMessageLength.Context,
		&Queue.QueueScope.Context,
		&Queue.QueueUsage.Context,
		&Queue.MessageDeliverySequence.Context,
		&Queue.HardenGetBackout.Context,
		&QueueGroup.Depth.Context,
		&QueueGroup.DepthPercentage.Context,
		&QueueGroup.Messages.Context,
		&QueueGroup.Connections.Context,
		&QueueGroup.UncommittedMessages.Context,
		&QueueGroup.FileSize.Context,
		&QueueGroup.OldestMessageAge.Context,
		&QueueManager.Status.Context,
		&QueueManager.ConnectionCount.Context,
		&QueueManager.Uptime.Context,
		&QueueManager.QueuesOverview.Context,
		&QueueManager.ChannelsOverview.Context,
		&QueueManager.TopicsOverview.Context,
		&QueueManager.ListenersOverview.Context,
		&QueueManagerResources.CPUUsage.Context,
		&QueueManagerResources.MemoryUsage.Context,
		&QueueManagerResources.RAMUsage.Context,
		&QueueManagerResources.LogUtilization.Context,
		&QueueManagerResources.LogFileSize.Context,
		&QueueManagerResources.LogWriteRate.Context,
		&QueueStatistics.DepthMinMax.Context,
		&QueueStatistics.AvgQueueTime.Context,
		&QueueStatistics.QueueTimeIndicators.Context,
		&QueueStatistics.Operations.Context,
		&QueueStatistics.Bytes.Context,
		&QueueStatistics.Failures.Context,
		&QueueStatistics.MessageLifecycle.Context,
		&Subscription.MessageCount.Context,
		&Subscription.LastMessageAge.Context,
		&Topic.Publishers.Context,
		&Topic.Subscribers.Context,
		&Topic.Messages.Context,
		&Topic.TimeSinceLastMessage.Context,
	}
}
