<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/nginxplus/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/nginxplus/metadata.yaml"
sidebar_label: "NGINX Plus"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Web Servers and Web Proxies"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# NGINX Plus


<img src="https://netdata.cloud/img/nginxplus.svg" width="150"/>


Plugin: go.d.plugin
Module: nginxplus

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors NGINX Plus servers.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per NGINX Plus instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.client_connections_rate | accepted, dropped | connections/s |
| nginxplus.client_connections_count | active, idle | connections |
| nginxplus.ssl_handshakes_rate | successful, failed | handshakes/s |
| nginxplus.ssl_handshakes_failures_rate | no_common_protocol, no_common_cipher, timeout, peer_rejected_cert | failures/s |
| nginxplus.ssl_verification_errors_rate | no_cert, expired_cert, revoked_cert, hostname_mismatch, other | errors/s |
| nginxplus.ssl_session_reuses_rate | ssl_session | reuses/s |
| nginxplus.http_requests_rate | requests | requests/s |
| nginxplus.http_requests_count | requests | requests |
| nginxplus.uptime | uptime | seconds |

### Per http server zone

These metrics refer to the HTTP server zone.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| http_server_zone | HTTP server zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.http_server_zone_requests_rate | requests | requests/s |
| nginxplus.http_server_zone_responses_per_code_class_rate | 1xx, 2xx, 3xx, 4xx, 5xx | responses/s |
| nginxplus.http_server_zone_traffic_rate | received, sent | bytes/s |
| nginxplus.http_server_zone_requests_processing_count | processing | requests |
| nginxplus.http_server_zone_requests_discarded_rate | discarded | requests/s |

### Per http location zone

These metrics refer to the HTTP location zone.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| http_location_zone | HTTP location zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.http_location_zone_requests_rate | requests | requests/s |
| nginxplus.http_location_zone_responses_per_code_class_rate | 1xx, 2xx, 3xx, 4xx, 5xx | responses/s |
| nginxplus.http_location_zone_traffic_rate | received, sent | bytes/s |
| nginxplus.http_location_zone_requests_discarded_rate | discarded | requests/s |

### Per http upstream

These metrics refer to the HTTP upstream.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| http_upstream_name | HTTP upstream name |
| http_upstream_zone | HTTP upstream zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.http_upstream_peers_count | peers | peers |
| nginxplus.http_upstream_zombies_count | zombie | servers |
| nginxplus.http_upstream_keepalive_count | keepalive | connections |

### Per http upstream server

These metrics refer to the HTTP upstream server.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| http_upstream_name | HTTP upstream name |
| http_upstream_zone | HTTP upstream zone name |
| http_upstream_server_address | HTTP upstream server address (e.g. 127.0.0.1:81) |
| http_upstream_server_name | HTTP upstream server name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.http_upstream_server_requests_rate | requests | requests/s |
| nginxplus.http_upstream_server_responses_per_code_class_rate | 1xx, 2xx, 3xx, 4xx, 5xx | responses/s |
| nginxplus.http_upstream_server_response_time | response | milliseconds |
| nginxplus.http_upstream_server_response_header_time | header | milliseconds |
| nginxplus.http_upstream_server_traffic_rate | received, sent | bytes/s |
| nginxplus.http_upstream_server_state | up, down, draining, unavail, checking, unhealthy | state |
| nginxplus.http_upstream_server_connections_count | active | connections |
| nginxplus.http_upstream_server_downtime | downtime | seconds |

### Per http cache

These metrics refer to the HTTP cache.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| http_cache | HTTP cache name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.http_cache_state | warm, cold | state |
| nginxplus.http_cache_iops | served, written, bypass | responses/s |
| nginxplus.http_cache_io | served, written, bypass | bytes/s |
| nginxplus.http_cache_size | size | bytes |

### Per stream server zone

These metrics refer to the Stream server zone.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| stream_server_zone | Stream server zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.stream_server_zone_connections_rate | accepted | connections/s |
| nginxplus.stream_server_zone_sessions_per_code_class_rate | 2xx, 4xx, 5xx | sessions/s |
| nginxplus.stream_server_zone_traffic_rate | received, sent | bytes/s |
| nginxplus.stream_server_zone_connections_processing_count | processing | connections |
| nginxplus.stream_server_zone_connections_discarded_rate | discarded | connections/s |

### Per stream upstream

These metrics refer to the Stream upstream.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| stream_upstream_name | Stream upstream name |
| stream_upstream_zone | Stream upstream zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.stream_upstream_peers_count | peers | peers |
| nginxplus.stream_upstream_zombies_count | zombie | servers |

### Per stream upstream server

These metrics refer to the Stream upstream server.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| stream_upstream_name | Stream upstream name |
| stream_upstream_zone | Stream upstream zone name |
| stream_upstream_server_address | Stream upstream server address (e.g. 127.0.0.1:12346) |
| stream_upstream_server_name | Stream upstream server name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.stream_upstream_server_connections_rate | forwarded | connections/s |
| nginxplus.stream_upstream_server_traffic_rate | received, sent | bytes/s |
| nginxplus.stream_upstream_server_state | up, down, unavail, checking, unhealthy | state |
| nginxplus.stream_upstream_server_downtime | downtime | seconds |
| nginxplus.stream_upstream_server_connections_count | active | connections |

### Per resolver zone

These metrics refer to the resolver zone.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| resolver_zone | resolver zone name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nginxplus.resolver_zone_requests_rate | name, srv, addr | requests/s |
| nginxplus.resolver_zone_responses_rate | noerror, formerr, servfail, nxdomain, notimp, refused, timedout, unknown | responses/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **nginxplus** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **nginxplus**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/nginxplus.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Config API

To configure API, see the [official documentation](https://docs.nginx.com/nginx/admin-guide/monitoring/live-activity-monitoring/#configuring-the-api).



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. | http://127.0.0.1 | yes |
|  | timeout | HTTP request timeout (seconds). | 1 | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **nginxplus** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the nginxplus data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _nginxplus_ (or scroll the list) to locate the **nginxplus** collector.
5. Click the **+** next to the **nginxplus** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/nginxplus.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/nginxplus.conf
```

##### Examples

###### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1

```
</details>

###### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1
    username: username
    password: password

```
</details>

###### HTTPS with self-signed certificate

NGINX Plus with enabled HTTPS and self-signed certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1
    tls_skip_verify: yes

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1

  - name: remote
    url: http://192.0.2.1

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `nginxplus` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m nginxplus
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m nginxplus -j jobName
  ```

### Getting Logs

If you're encountering problems with the `nginxplus` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep nginxplus
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep nginxplus /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep nginxplus
```


