<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/debugfs.plugin/integrations/linux_zswap.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/debugfs.plugin/metadata.yaml"
sidebar_label: "Linux ZSwap"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Memory"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Linux ZSwap


<img src="https://netdata.cloud/img/microchip.svg" width="150"/>


Plugin: debugfs.plugin
Module: /sys/kernel/debug/zswap

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collects zswap performance metrics on Linux systems.


Parse data from `debugfs file.

This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.

This integration requires read access to files under `/sys/kernel/debug/zswap`, which are accessible only to the root user by default. Netdata uses Linux Capabilities to give the plugin access to debugfs. `CAP_DAC_READ_SEARCH` is added automatically during installation. This capability allows bypassing file read permission checks and directory read and execute permission checks. If file capabilities are not usable, then the plugin is instead installed with the SUID bit set in permissions so that it runs as root.


### Default Behavior

#### Auto-Detection

Assuming that debugfs is mounted and the required permissions are available, this integration will automatically detect whether or not the system is using zswap.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

Monitor the performance statistics of zswap.

### Per Linux ZSwap instance

Global zswap performance metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.zswap_pool_compression_ratio | compression_ratio | ratio |
| system.zswap_pool_compressed_size | compressed_size | bytes |
| system.zswap_pool_raw_size | uncompressed_size | bytes |
| system.zswap_rejections | compress_poor, kmemcache_fail, alloc_fail, reclaim_fail | rejections/s |
| system.zswap_pool_limit_hit | limit | events/s |
| system.zswap_written_back_raw_bytes | written_back | bytes/s |
| system.zswap_same_filled_raw_size | same_filled | bytes |
| system.zswap_duplicate_entry | duplicate | entries/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

#### filesystem

The debugfs filesystem must be mounted on your host for plugin to collect data. You can run the command-line (`sudo mount -t debugfs none /sys/kernel/debug/`) to mount it locally. It is also recommended to modify your fstab (5) avoiding necessity to mount the filesystem before starting netdata.



### Configuration

#### Options



<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 1 | no |
| command options | Additinal parameters for collector |  | no |


</details>



#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:debugfs]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


