<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/logs/integrations/systemd_journal_logs.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/logs/metadata.yaml"
sidebar_label: "Systemd Journal Logs"
learn_status: "Published"
learn_rel_path: "Logs"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE LOGS' metadata.yaml FILE"
endmeta-->

# Systemd Journal Logs


<img src="https://netdata.cloud/img/netdata.png" width="150"/>


The `systemd` journal plugin by Netdata makes viewing, exploring and analyzing `systemd` journal logs simple and efficient.

It automatically discovers available journal sources, allows advanced filtering, offers interactive visual representations and supports exploring the logs of both individual servers and the logs on infrastructure wide journal centralization servers.

The plugin automatically detects the available journal sources, based on the journal files available in `/var/log/journal` (persistent logs) and `/run/log/journal` (volatile logs).


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Visualization

You can start exploring `systemd` journal logs on the "Logs" tab of the Netdata UI.


## Key features

- Works on both **individual servers** and **journal centralization servers**.
- Supports `persistent` and `volatile` journals.
- Supports `system`, `user`, `namespaces` and `remote` journals.
- Allows filtering on **any journal field** or **field value**, for any time-frame.
- Allows **full text search** (`grep`) on all journal fields, for any time-frame.
- Provides a **histogram** for log entries over time, with a break down per field-value, for any field and any time-frame.
- Works directly on journal files, without any other third-party components.
- Supports coloring log entries, the same way `journalctl` does.
- In PLAY mode provides the same experience as `journalctl -f`, showing new log entries immediately after they are received.


## Setup

## Prerequisites

- A Netdata Cloud account


## Configuration

There is no configuration needed for this integration.

