<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/x509check/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/x509check/metadata.yaml"
sidebar_label: "X.509 certificate"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# X.509 certificate


<img src="https://netdata.cloud/img/lock.svg" width="150"/>


Plugin: go.d.plugin
Module: x509check

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview



This collectors monitors x509 certificates expiration time and revocation status.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per source

These metrics refer to the SSL certificate.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| source | Same as the "source" configuration option. |
| common_name | The common name (CN) extracted from the certificate. |
| depth | The depth of the certificate within the certificate chain. The leaf certificate has a depth of 0, and subsequent certificates (intermediate certificates) have increasing depth values. The root certificate is at the highest depth. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| x509check.time_until_expiration | expiry | seconds |
| x509check.revocation_status | not_revoked, revoked | boolean |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ x509check_days_until_expiration ](https://github.com/netdata/netdata/blob/master/src/health/health.d/x509check.conf) | x509check.time_until_expiration | SSL cert expiring soon (${label:source} cn:${label:common_name}) |
| [ x509check_revocation_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/x509check.conf) | x509check.revocation_status | SSL cert revoked (${label:source}) |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/x509check.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/x509check.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| source | Certificate source. Allowed schemes: https, tcp, tcp4, tcp6, udp, udp4, udp6, file, smtp. |  | no |
| check_full_chain | Monitor expiration time for all certificates in the SSL/TLS chain, including intermediate and root certificates. | no | no |
| check_revocation_status | Whether to check the revocation status of the certificate. | no | no |
| timeout | SSL connection timeout. | 2 | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Website certificate

Website certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_site_cert
    source: https://my_site.org:443

```
</details>

##### Local file certificate

Local file certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_file_cert
    source: file:///home/me/cert.pem

```
</details>

##### SMTP certificate

SMTP certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_smtp_cert
    source: smtp://smtp.my_mail.org:587

```
</details>

##### Multi-instance

> **Note**: When you define more than one job, their names must be unique.

Check the expiration status of the multiple websites' certificates.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_site_cert1
    source: https://my_site1.org:443

  - name: my_site_cert2
    source: https://my_site1.org:443

  - name: my_site_cert3
    source: https://my_site3.org:443

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `x509check` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m x509check
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m x509check -j jobName
  ```

### Getting Logs

If you're encountering problems with the `x509check` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep x509check
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep x509check /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep x509check
```


