<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/hddtemp/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/hddtemp/metadata.yaml"
sidebar_label: "HDD temperature"
learn_status: "Published"
learn_rel_path: "Data Collection/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HDD temperature


<img src="https://netdata.cloud/img/hard-drive.svg" width="150"/>


Plugin: python.d.plugin
Module: hddtemp

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors disk temperatures.


It uses the `hddtemp` daemon to gather the metrics.


This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, this collector will attempt to connect to the `hddtemp` daemon on `127.0.0.1:7634`

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per HDD temperature instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hddtemp.temperatures | a dimension per disk | Celsius |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Run `hddtemp` in daemon mode

You can execute `hddtemp` in TCP/IP daemon mode by using the `-d` argument.

So running `hddtemp -d` would run the daemon, by default on port 7634.



### Configuration

#### File

The configuration file name for this integration is `python.d/hddtemp.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/hddtemp.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.

By default this collector will try to autodetect disks (autodetection works only for disk which names start with "sd"). However this can be overridden by setting the option `disks` to an array of desired disks.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 1 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. | local | no |
| devices | Array of desired disks to detect, in case their name doesn't start with `sd`. |  | no |
| host | The IP or HOSTNAME to connect to. | localhost | yes |
| port | The port to connect to. | 7634 | no |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
localhost:
  name: 'local'
  host: '127.0.0.1'
  port: 7634

```
##### Custom disk names

An example defining the disk names to detect.

<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  host: '127.0.0.1'
  port: 7634
  devices:
    - customdisk1
    - customdisk2

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  host: '127.0.0.1'
  port: 7634

remote_job:
  name : 'remote'
  host  : 'http://192.0.2.1:2812'

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `hddtemp` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin hddtemp debug trace
  ```


